/* completion.c generated by valac 0.48.10, the Vala compiler
 * generated from completion.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Sébastien Wilmet
 *          Pieter Pareit
 */

#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>
#include <tepl/tepl.h>
#include "config.h"

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND (completion_provider_completion_command_get_type ())
typedef struct _CompletionProviderCompletionCommand CompletionProviderCompletionCommand;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_ARGUMENT (completion_provider_completion_argument_get_type ())
typedef struct _CompletionProviderCompletionArgument CompletionProviderCompletionArgument;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE (completion_provider_completion_choice_get_type ())
typedef struct _CompletionProviderCompletionChoice CompletionProviderCompletionChoice;
enum  {
	COMPLETION_PROVIDER_0_PROPERTY,
	COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* completion_provider_properties[COMPLETION_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define COMPLETION_PROVIDER_TYPE_ARGUMENT_CONTEXT (completion_provider_argument_context_get_type ())
typedef struct _CompletionProviderArgumentContext CompletionProviderArgumentContext;
#define _completion_provider_completion_command_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_command_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _completion_provider_completion_choice_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_choice_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _CompletionProviderCompletionChoice {
	gchar* name;
	gchar* package;
	gchar* insert;
	gchar* insert_after;
};

struct _CompletionProviderCompletionArgument {
	gchar* label;
	gboolean optional;
	CompletionProviderCompletionChoice* choices;
	gint choices_length1;
	gint _choices_size_;
};

struct _CompletionProviderCompletionCommand {
	gchar* name;
	gchar* package;
	CompletionProviderCompletionArgument* args;
	gint args_length1;
	gint _args_size_;
};

struct _CompletionProviderPrivate {
	GSettings* _settings;
	GList* _proposals;
	GeeHashMap* _commands;
	GeeHashMap* _environments;
	CompletionProviderCompletionCommand _current_command;
	CompletionProviderCompletionArgument _current_arg;
	CompletionProviderCompletionChoice _current_choice;
	GdkPixbuf* _icon_cmd;
	GdkPixbuf* _icon_choice;
	GdkPixbuf* _icon_package_required;
	GtkSourceCompletionInfo* _calltip_window;
	GtkLabel* _calltip_window_label;
};

struct _CompletionProviderArgumentContext {
	gchar* cmd_name;
	gchar* arg_contents;
	GeeArrayList* args_types;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

static gint CompletionProvider_private_offset;
static gpointer completion_provider_parent_class = NULL;
static CompletionProvider* completion_provider__instance;
static CompletionProvider* completion_provider__instance = NULL;
static GtkSourceCompletionProviderIface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;

GType completion_provider_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
static GType completion_provider_completion_command_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_choice_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self,
                                                 CompletionProviderCompletionChoice* dest);
static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self);
static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self,
                                                   CompletionProviderCompletionArgument* dest);
static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self);
static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self,
                                                  CompletionProviderCompletionCommand* dest);
static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static CompletionProvider* completion_provider_new (void);
static CompletionProvider* completion_provider_construct (GType object_type);
static void completion_provider_load_data (CompletionProvider* self);
CompletionProvider* completion_provider_get_default (void);
static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base,
                                         GtkSourceCompletionContext* context);
static gboolean completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GtkSourceCompletionProposal* proposal,
                                                  GtkTextIter* iter);
static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self,
                                                      GtkTextIter* iter);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static void completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                        GtkSourceCompletionContext* context);
static void completion_provider_show_no_proposals (CompletionProvider* self,
                                            GtkSourceCompletionContext* context);
static void completion_provider_populate_command (CompletionProvider* self,
                                           GtkSourceCompletionContext* context,
                                           const gchar* cmd);
static GType completion_provider_argument_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self,
                                                CompletionProviderArgumentContext* dest);
static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self);
static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self,
                                                        GtkTextIter* iter,
                                                        CompletionProviderArgumentContext* info);
static void completion_provider_populate_argument (CompletionProvider* self,
                                            GtkSourceCompletionContext* context,
                                            CompletionProviderArgumentContext* info);
static gboolean completion_provider_is_user_request (CompletionProvider* self,
                                              GtkSourceCompletionContext* context);
static void completion_provider_show_all_proposals (CompletionProvider* self,
                                             GtkSourceCompletionContext* context);
static void completion_provider_show_filtered_proposals (CompletionProvider* self,
                                                  GtkSourceCompletionContext* context,
                                                  GList* proposals_to_filter,
                                                  const gchar* prefix);
static GList* completion_provider_get_argument_proposals (CompletionProvider* self,
                                                   CompletionProviderArgumentContext* arg_context);
static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self,
                                                     const gchar* arg_cmd,
                                                     GeeArrayList* arguments);
static gchar* completion_provider_get_command_info (CompletionProvider* self,
                                             CompletionProviderCompletionCommand* cmd,
                                             gint cur_arg);
static gint completion_provider_get_argument_num (CompletionProvider* self,
                                           CompletionProviderCompletionArgument* all_args,
                                           gint all_args_length1,
                                           GeeArrayList* args);
static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a,
                                            GtkSourceCompletionItem* b);
static void completion_provider_init_calltip_window (CompletionProvider* self);
static void completion_provider_show_calltip_info (CompletionProvider* self,
                                            const gchar* markup);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* main_window_get_active_view (MainWindow* self);
static void completion_provider_get_begin_arg_pos (CompletionProvider* self,
                                            GtkTextIter* in_arg_pos,
                                            GtkTextIter* result);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                                     GtkSourceCompletionProposal* proposal,
                                                     GtkTextIter* iter);
static void completion_provider_activate_proposal_command_name (CompletionProvider* self,
                                                         GtkSourceCompletionProposal* proposal,
                                                         GtkTextIter* iter,
                                                         const gchar* cmd);
static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self,
                                                            GtkSourceCompletionProposal* proposal,
                                                            GtkTextIter* iter,
                                                            const gchar* arg_cmd,
                                                            const gchar* arg_contents);
static void completion_provider_close_environment (CompletionProvider* self,
                                            const gchar* env_name,
                                            GtkTextIter* iter);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentView* document_tab_get_document_view (DocumentTab* self);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self,
                                                  GtkTextIter* iter);
gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self,
                                                       const gchar* text,
                                                       gint index);
static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self,
                                                       CompletionProviderCompletionCommand* cmd);
gchar* utils_load_file (GFile* file);
static void completion_provider_parser_start (CompletionProvider* self,
                                       GMarkupParseContext* context,
                                       const gchar* name,
                                       gchar** attr_names,
                                       gint attr_names_length1,
                                       gchar** attr_values,
                                       gint attr_values_length1,
                                       GError** error);
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                          const gchar* element_name,
                                                                          gchar** attribute_names,
                                                                          gchar** attribute_values,
                                                                          gpointer self,
                                                                          GError** error);
static void completion_provider_parser_end (CompletionProvider* self,
                                     GMarkupParseContext* context,
                                     const gchar* name,
                                     GError** error);
static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                      const gchar* element_name,
                                                                      gpointer self,
                                                                      GError** error);
static void completion_provider_parser_text (CompletionProvider* self,
                                      GMarkupParseContext* context,
                                      const gchar* text,
                                      gsize text_len,
                                      GError** error);
static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                                const gchar* text,
                                                                gsize text_len,
                                                                gpointer self,
                                                                GError** error);
static void completion_provider_parser_add_command (CompletionProvider* self,
                                             gchar** attr_names,
                                             gint attr_names_length1,
                                             gchar** attr_values,
                                             gint attr_values_length1,
                                             GError** error);
static void completion_provider_parser_add_argument (CompletionProvider* self,
                                              gchar** attr_names,
                                              gint attr_names_length1,
                                              gchar** attr_values,
                                              gint attr_values_length1,
                                              GError** error);
static void completion_provider_parser_add_choice (CompletionProvider* self,
                                            gchar** attr_names,
                                            gint attr_names_length1,
                                            gchar** attr_values,
                                            gint attr_values_length1,
                                            GError** error);
static void _vala_array_add2 (CompletionProviderCompletionArgument* * array,
                       gint* length,
                       gint* size,
                       const CompletionProviderCompletionArgument* value);
static void _vala_array_add3 (CompletionProviderCompletionChoice* * array,
                       gint* length,
                       gint* size,
                       const CompletionProviderCompletionChoice* value);
static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument * array,
                                                            gint array_length);
static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self,
                                                        gint length);
static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice * array,
                                                          gint array_length);
static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self,
                                                      gint length);
static void completion_provider_finalize (GObject * obj);
static GType completion_provider_get_type_once (void);
static gint _vala_array_length (gpointer array);

static inline gpointer
completion_provider_get_instance_private (CompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, CompletionProvider_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static CompletionProvider*
completion_provider_construct (GType object_type)
{
	CompletionProvider * self = NULL;
	GSettings* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = latexila_utils_get_pixbuf_from_icon_name ("completion_cmd", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_cmd);
	self->priv->_icon_cmd = _tmp1_;
	_tmp2_ = latexila_utils_get_pixbuf_from_icon_name ("gray-square", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_choice);
	self->priv->_icon_choice = _tmp2_;
	_tmp3_ = latexila_utils_get_pixbuf_from_icon_name ("dialog-warning", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_package_required);
	self->priv->_icon_package_required = _tmp3_;
	completion_provider_load_data (self);
	return self;
}

static CompletionProvider*
completion_provider_new (void)
{
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CompletionProvider*
completion_provider_get_default (void)
{
	CompletionProvider* _tmp0_;
	CompletionProvider* _tmp2_;
	CompletionProvider* _tmp3_;
	CompletionProvider* result = NULL;
	_tmp0_ = completion_provider__instance;
	if (_tmp0_ == NULL) {
		CompletionProvider* _tmp1_;
		_tmp1_ = completion_provider_new ();
		_g_object_unref0 (completion_provider__instance);
		completion_provider__instance = _tmp1_;
	}
	_tmp2_ = completion_provider__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
completion_provider_real_get_name (GtkSourceCompletionProvider* base)
{
	CompletionProvider * self;
	gchar* _tmp0_;
	gchar* result = NULL;
	self = (CompletionProvider*) base;
	_tmp0_ = g_strdup ("LaTeX");
	result = _tmp0_;
	return result;
}

static GtkSourceCompletionActivation
completion_provider_real_get_activation (GtkSourceCompletionProvider* base)
{
	CompletionProvider * self;
	GtkSourceCompletionActivation activation = 0U;
	GSettings* _tmp0_;
	GtkSourceCompletionActivation result = 0U;
	self = (CompletionProvider*) base;
	activation = GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	_tmp0_ = self->priv->_settings;
	if (g_settings_get_boolean (_tmp0_, "interactive-completion")) {
		GtkSourceCompletionActivation _tmp1_;
		_tmp1_ = activation;
		activation = _tmp1_ | GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE;
	}
	result = activation;
	return result;
}

static gboolean
completion_provider_real_match (GtkSourceCompletionProvider* base,
                                GtkSourceCompletionContext* context)
{
	CompletionProvider * self;
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTextBuffer* buf = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean result = FALSE;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp1_ = gtk_source_completion_context_get_iter (context, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = gtk_text_iter_get_buffer (&iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buf = _tmp3_;
	_tmp4_ = buf;
	_tmp5_ = gtk_text_buffer_get_has_selection (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (buf);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (buf);
	return result;
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static gboolean
completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                         GtkSourceCompletionContext* context,
                                         GtkSourceCompletionProposal* proposal,
                                         GtkTextIter* iter)
{
	CompletionProvider * self;
	GtkTextIter _vala_iter = {0};
	GtkTextIter _tmp0_ = {0};
	gchar* cmd = NULL;
	GtkTextIter* _tmp1_;
	GtkTextIter* _tmp2_;
	GtkTextIter* _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GtkTextIter* _tmp8_;
	GtkTextIter* _tmp9_;
	GtkTextIter* _tmp10_;
	GtkTextIter prev = {0};
	GtkTextIter _tmp11_;
	gboolean _tmp12_ = FALSE;
	GtkTextIter _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean result = FALSE;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_vala_iter = _tmp0_;
	g_object_get (context, "iter", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = *_tmp3_;
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
	_tmp6_ = _tmp5_;
	__vala_GtkTextIter_free0 (_tmp3_);
	cmd = _tmp6_;
	_tmp7_ = cmd;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_free0 (cmd);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	g_object_get (context, "iter", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_vala_iter = *_tmp10_;
	__vala_GtkTextIter_free0 (_tmp10_);
	_tmp11_ = _vala_iter;
	prev = _tmp11_;
	if (gtk_text_iter_backward_char (&prev)) {
		_tmp12_ = gtk_text_iter_get_char (&prev) == ((gunichar) '\\');
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkTextIter _tmp13_;
		_tmp13_ = prev;
		_vala_iter = _tmp13_;
		result = TRUE;
		_g_free0 (cmd);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	if (!gtk_text_iter_starts_word (&_vala_iter)) {
		gtk_text_iter_backward_visible_word_start (&_vala_iter);
	}
	_tmp14_ = _vala_iter;
	prev = _tmp14_;
	if (gtk_text_iter_backward_char (&prev)) {
		_tmp15_ = gtk_text_iter_get_char (&prev) == ((gunichar) '\\');
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GtkTextIter _tmp16_;
		_tmp16_ = prev;
		_vala_iter = _tmp16_;
	}
	result = TRUE;
	_g_free0 (cmd);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

/*************************************************************************/
static void
completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                   GtkSourceCompletionContext* context)
{
	CompletionProvider * self;
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* cmd = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	CompletionProviderArgumentContext info = {0};
	gboolean in_arg = FALSE;
	GtkTextIter _tmp6_;
	CompletionProviderArgumentContext _tmp7_ = {0};
	gboolean _tmp8_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp1_ = gtk_source_completion_context_get_iter (context, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		completion_provider_show_no_proposals (self, context);
		return;
	}
	_tmp2_ = iter;
	_tmp3_ = completion_provider_get_latex_command_at_iter (self, &_tmp2_);
	cmd = _tmp3_;
	_tmp4_ = cmd;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = cmd;
		completion_provider_populate_command (self, context, _tmp5_);
		_g_free0 (cmd);
		return;
	}
	_tmp6_ = iter;
	_tmp8_ = completion_provider_in_latex_command_argument (self, &_tmp6_, &_tmp7_);
	completion_provider_argument_context_destroy (&info);
	info = _tmp7_;
	in_arg = _tmp8_;
	if (in_arg) {
		CompletionProviderArgumentContext _tmp9_;
		_tmp9_ = info;
		completion_provider_populate_argument (self, context, &_tmp9_);
		completion_provider_argument_context_destroy (&info);
		_g_free0 (cmd);
		return;
	}
	if (completion_provider_is_user_request (self, context)) {
		completion_provider_show_all_proposals (self, context);
	} else {
		completion_provider_show_no_proposals (self, context);
	}
	completion_provider_argument_context_destroy (&info);
	_g_free0 (cmd);
}

static void
completion_provider_populate_command (CompletionProvider* self,
                                      GtkSourceCompletionContext* context,
                                      const gchar* cmd)
{
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (cmd != NULL);
	if (!completion_provider_is_user_request (self, context)) {
		guint min_nb_chars = 0U;
		GSettings* _tmp0_;
		guint _tmp1_ = 0U;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = self->priv->_settings;
		g_settings_get (_tmp0_, "interactive-completion-num", "u", &_tmp1_);
		min_nb_chars = _tmp1_;
		_tmp2_ = strlen (cmd);
		_tmp3_ = _tmp2_;
		if (((guint) _tmp3_) <= min_nb_chars) {
			completion_provider_show_no_proposals (self, context);
			return;
		}
	}
	if (g_strcmp0 (cmd, "\\") == 0) {
		completion_provider_show_all_proposals (self, context);
		return;
	}
	_tmp4_ = self->priv->_proposals;
	completion_provider_show_filtered_proposals (self, context, _tmp4_, cmd);
}

static void
completion_provider_populate_argument (CompletionProvider* self,
                                       GtkSourceCompletionContext* context,
                                       CompletionProviderArgumentContext* info)
{
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	GList* proposals_to_filter = NULL;
	CompletionProviderArgumentContext _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* _tmp10_;
	CompletionProviderArgumentContext _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *info;
	_tmp2_ = _tmp1_.cmd_name;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_)) {
		completion_provider_show_no_proposals (self, context);
		return;
	}
	_tmp3_ = *info;
	_tmp4_ = completion_provider_get_argument_proposals (self, &_tmp3_);
	proposals_to_filter = _tmp4_;
	_tmp5_ = proposals_to_filter;
	if (_tmp5_ == NULL) {
		if (completion_provider_is_user_request (self, context)) {
			CompletionProviderArgumentContext _tmp6_;
			const gchar* _tmp7_;
			CompletionProviderArgumentContext _tmp8_;
			GeeArrayList* _tmp9_;
			_tmp6_ = *info;
			_tmp7_ = _tmp6_.cmd_name;
			_tmp8_ = *info;
			_tmp9_ = _tmp8_.args_types;
			completion_provider_show_calltip_cmd_prototype (self, _tmp7_, _tmp9_);
		} else {
			completion_provider_show_no_proposals (self, context);
		}
		return;
	}
	_tmp10_ = proposals_to_filter;
	_tmp11_ = *info;
	_tmp12_ = _tmp11_.arg_contents;
	completion_provider_show_filtered_proposals (self, context, _tmp10_, _tmp12_);
}

static GList*
completion_provider_get_argument_proposals (CompletionProvider* self,
                                            CompletionProviderArgumentContext* arg_context)
{
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	CompletionProviderCompletionCommand cmd = {0};
	GeeHashMap* _tmp3_;
	CompletionProviderArgumentContext _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_;
	CompletionProviderCompletionCommand* _tmp7_;
	CompletionProviderCompletionCommand _tmp8_;
	CompletionProviderCompletionCommand _tmp9_ = {0};
	CompletionProviderCompletionCommand _tmp10_;
	gchar* cmd_info = NULL;
	CompletionProviderCompletionCommand _tmp11_;
	gchar* _tmp12_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp13_;
	CompletionProviderCompletionArgument* _tmp14_;
	gint _tmp14__length1;
	CompletionProviderArgumentContext _tmp15_;
	GeeArrayList* _tmp16_;
	CompletionProviderCompletionArgument arg = {0};
	CompletionProviderCompletionCommand _tmp17_;
	CompletionProviderCompletionArgument* _tmp18_;
	gint _tmp18__length1;
	CompletionProviderCompletionArgument _tmp19_;
	CompletionProviderCompletionArgument _tmp20_;
	CompletionProviderCompletionArgument _tmp21_ = {0};
	GList* items = NULL;
	CompletionProviderCompletionArgument _tmp22_;
	CompletionProviderCompletionChoice* _tmp23_;
	gint _tmp23__length1;
	GList* _tmp53_;
	GList* _tmp54_;
	GList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (arg_context != NULL, NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *arg_context;
	_tmp2_ = _tmp1_.cmd_name;
	g_return_val_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_), NULL);
	_tmp3_ = self->priv->_commands;
	_tmp4_ = *arg_context;
	_tmp5_ = _tmp4_.cmd_name;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
	_tmp7_ = (CompletionProviderCompletionCommand*) _tmp6_;
	_tmp8_ = *_tmp7_;
	completion_provider_completion_command_copy (&_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_completion_provider_completion_command_free0 (_tmp7_);
	cmd = _tmp10_;
	_tmp11_ = cmd;
	_tmp12_ = completion_provider_get_command_info (self, &_tmp11_, -1);
	cmd_info = _tmp12_;
	_tmp13_ = cmd;
	_tmp14_ = _tmp13_.args;
	_tmp14__length1 = _tmp13_.args_length1;
	_tmp15_ = *arg_context;
	_tmp16_ = _tmp15_.args_types;
	arg_num = completion_provider_get_argument_num (self, _tmp14_, (gint) _tmp14__length1, _tmp16_);
	if (arg_num == -1) {
		result = NULL;
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	_tmp17_ = cmd;
	_tmp18_ = _tmp17_.args;
	_tmp18__length1 = _tmp17_.args_length1;
	_tmp19_ = _tmp18_[arg_num - 1];
	_tmp20_ = _tmp19_;
	completion_provider_completion_argument_copy (&_tmp20_, &_tmp21_);
	arg = _tmp21_;
	items = NULL;
	_tmp22_ = arg;
	_tmp23_ = _tmp22_.choices;
	_tmp23__length1 = _tmp22_.choices_length1;
	{
		CompletionProviderCompletionChoice* choice_collection = NULL;
		gint choice_collection_length1 = 0;
		gint _choice_collection_size_ = 0;
		gint choice_it = 0;
		choice_collection = _tmp23_;
		choice_collection_length1 = _tmp23__length1;
		for (choice_it = 0; choice_it < choice_collection_length1; choice_it = choice_it + 1) {
			CompletionProviderCompletionChoice _tmp24_;
			CompletionProviderCompletionChoice _tmp25_ = {0};
			CompletionProviderCompletionChoice choice = {0};
			_tmp24_ = choice_collection[choice_it];
			completion_provider_completion_choice_copy (&_tmp24_, &_tmp25_);
			choice = _tmp25_;
			{
				GdkPixbuf* pixbuf = NULL;
				gchar* arg_info = NULL;
				CompletionProviderCompletionChoice _tmp26_;
				const gchar* _tmp27_;
				GtkSourceCompletionItem* item = NULL;
				GtkSourceCompletionItem* _tmp38_;
				GtkSourceCompletionItem* _tmp39_;
				CompletionProviderCompletionChoice _tmp40_;
				const gchar* _tmp41_;
				GtkSourceCompletionItem* _tmp42_;
				CompletionProviderCompletionChoice _tmp43_;
				const gchar* _tmp44_;
				GtkSourceCompletionItem* _tmp45_;
				GdkPixbuf* _tmp46_;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_;
				GtkSourceCompletionItem* _tmp50_;
				GtkSourceCompletionItem* _tmp51_;
				GtkSourceCompletionItem* _tmp52_;
				arg_info = NULL;
				_tmp26_ = choice;
				_tmp27_ = _tmp26_.package;
				if (_tmp27_ != NULL) {
					GdkPixbuf* _tmp28_;
					GdkPixbuf* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					CompletionProviderCompletionChoice _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp28_ = self->priv->_icon_package_required;
					_tmp29_ = _g_object_ref0 (_tmp28_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp29_;
					_tmp30_ = cmd_info;
					_tmp31_ = g_strconcat (_tmp30_, "\nPackage: ", NULL);
					_tmp32_ = _tmp31_;
					_tmp33_ = choice;
					_tmp34_ = _tmp33_.package;
					_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
					_g_free0 (arg_info);
					arg_info = _tmp35_;
					_g_free0 (_tmp32_);
				} else {
					GdkPixbuf* _tmp36_;
					GdkPixbuf* _tmp37_;
					_tmp36_ = self->priv->_icon_choice;
					_tmp37_ = _g_object_ref0 (_tmp36_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp37_;
				}
				_tmp38_ = gtk_source_completion_item_new ();
				item = _tmp38_;
				_tmp39_ = item;
				_tmp40_ = choice;
				_tmp41_ = _tmp40_.name;
				gtk_source_completion_item_set_label (_tmp39_, _tmp41_);
				_tmp42_ = item;
				_tmp43_ = choice;
				_tmp44_ = _tmp43_.name;
				gtk_source_completion_item_set_text (_tmp42_, _tmp44_);
				_tmp45_ = item;
				_tmp46_ = pixbuf;
				gtk_source_completion_item_set_icon (_tmp45_, _tmp46_);
				_tmp48_ = arg_info;
				_tmp47_ = _tmp48_;
				if (_tmp47_ == NULL) {
					const gchar* _tmp49_;
					_tmp49_ = cmd_info;
					_tmp47_ = _tmp49_;
				}
				_tmp50_ = item;
				gtk_source_completion_item_set_info (_tmp50_, _tmp47_);
				_tmp51_ = item;
				_tmp52_ = _g_object_ref0 (_tmp51_);
				items = g_list_prepend (items, _tmp52_);
				_g_object_unref0 (item);
				_g_free0 (arg_info);
				_g_object_unref0 (pixbuf);
				completion_provider_completion_choice_destroy (&choice);
			}
		}
	}
	_tmp53_ = items;
	if (_tmp53_ == NULL) {
		result = NULL;
		completion_provider_completion_argument_destroy (&arg);
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	items = g_list_sort (items, (GCompareFunc) completion_provider_compare_proposals);
	_tmp54_ = items;
	result = _tmp54_;
	completion_provider_completion_argument_destroy (&arg);
	_g_free0 (cmd_info);
	completion_provider_completion_command_destroy (&cmd);
	return result;
}

static void
completion_provider_show_no_proposals (CompletionProvider* self,
                                       GtkSourceCompletionContext* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), NULL, TRUE);
}

static void
completion_provider_show_all_proposals (CompletionProvider* self,
                                        GtkSourceCompletionContext* context)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->_proposals;
	gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp0_, TRUE);
}

static void
completion_provider_show_filtered_proposals (CompletionProvider* self,
                                             GtkSourceCompletionContext* context,
                                             GList* proposals_to_filter,
                                             const gchar* prefix)
{
	gboolean _tmp0_ = FALSE;
	GList* filtered_proposals = NULL;
	GList* _tmp9_;
	GList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (prefix == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (prefix, "") == 0;
	}
	if (_tmp0_) {
		gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), proposals_to_filter, TRUE);
		return;
	}
	filtered_proposals = NULL;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = proposals_to_filter;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkSourceCompletionItem* _tmp1_;
			GtkSourceCompletionItem* item = NULL;
			_tmp1_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
			item = _tmp1_;
			{
				GtkSourceCompletionItem* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp2_ = item;
				g_object_get (_tmp2_, "text", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = g_str_has_prefix (_tmp5_, prefix);
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					GtkSourceCompletionItem* _tmp7_;
					GtkSourceCompletionItem* _tmp8_;
					_tmp7_ = item;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					filtered_proposals = g_list_prepend (filtered_proposals, _tmp8_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp9_ = filtered_proposals;
	if (_tmp9_ != NULL) {
		filtered_proposals = g_list_reverse (filtered_proposals);
	} else {
		GtkSourceCompletionItem* dummy_proposal = NULL;
		GtkSourceCompletionItem* _tmp10_;
		GtkSourceCompletionItem* _tmp11_;
		GtkSourceCompletionItem* _tmp12_;
		GtkSourceCompletionItem* _tmp13_;
		GtkSourceCompletionItem* _tmp14_;
		_tmp10_ = gtk_source_completion_item_new ();
		dummy_proposal = _tmp10_;
		_tmp11_ = dummy_proposal;
		gtk_source_completion_item_set_label (_tmp11_, _ ("No matching proposal"));
		_tmp12_ = dummy_proposal;
		gtk_source_completion_item_set_text (_tmp12_, "");
		_tmp13_ = dummy_proposal;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		filtered_proposals = g_list_prepend (filtered_proposals, _tmp14_);
		_g_object_unref0 (dummy_proposal);
	}
	_tmp15_ = filtered_proposals;
	gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp15_, TRUE);
	(filtered_proposals == NULL) ? NULL : (filtered_proposals = (_g_list_free__g_object_unref0_ (filtered_proposals), NULL));
}

/*************************************************************************/
static void
completion_provider_init_calltip_window (CompletionProvider* self)
{
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	GtkSourceCompletionInfo* _tmp2_;
	GtkLabel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_completion_info_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_calltip_window);
	self->priv->_calltip_window = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_calltip_window_label);
	self->priv->_calltip_window_label = _tmp1_;
	_tmp2_ = self->priv->_calltip_window;
	_tmp3_ = self->priv->_calltip_window_label;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
}

static void
completion_provider_show_calltip_cmd_prototype (CompletionProvider* self,
                                                const gchar* arg_cmd,
                                                GeeArrayList* arguments)
{
	GeeHashMap* _tmp0_;
	CompletionProviderCompletionCommand command = {0};
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	CompletionProviderCompletionCommand* _tmp3_;
	CompletionProviderCompletionCommand _tmp4_;
	CompletionProviderCompletionCommand _tmp5_ = {0};
	CompletionProviderCompletionCommand _tmp6_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp7_;
	CompletionProviderCompletionArgument* _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg_cmd != NULL);
	g_return_if_fail (arguments != NULL);
	_tmp0_ = self->priv->_commands;
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, arg_cmd));
	_tmp1_ = self->priv->_commands;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, arg_cmd);
	_tmp3_ = (CompletionProviderCompletionCommand*) _tmp2_;
	_tmp4_ = *_tmp3_;
	completion_provider_completion_command_copy (&_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_completion_provider_completion_command_free0 (_tmp3_);
	command = _tmp6_;
	_tmp7_ = command;
	_tmp8_ = _tmp7_.args;
	_tmp8__length1 = _tmp7_.args_length1;
	arg_num = completion_provider_get_argument_num (self, _tmp8_, (gint) _tmp8__length1, arguments);
	if (arg_num != -1) {
		gchar* info = NULL;
		CompletionProviderCompletionCommand _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = command;
		_tmp10_ = completion_provider_get_command_info (self, &_tmp9_, arg_num);
		info = _tmp10_;
		_tmp11_ = info;
		completion_provider_show_calltip_info (self, _tmp11_);
		_g_free0 (info);
	}
	completion_provider_completion_command_destroy (&command);
}

static void
completion_provider_show_calltip_info (CompletionProvider* self,
                                       const gchar* markup)
{
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	MainWindow* window = NULL;
	GlatexApp* _tmp2_;
	GlatexApp* _tmp3_;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	GtkSourceCompletionInfo* _tmp6_;
	GtkSourceCompletionInfo* _tmp7_;
	DocumentView* _tmp8_;
	DocumentView* _tmp9_;
	GtkTextIter cursor_pos = {0};
	GtkTextBuffer* buffer = NULL;
	DocumentView* _tmp10_;
	DocumentView* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextMark* _tmp15_;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_ = {0};
	GtkSourceCompletionInfo* _tmp19_;
	DocumentView* _tmp20_;
	DocumentView* _tmp21_;
	GtkTextIter _tmp22_;
	GtkSourceCompletionInfo* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (markup != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ == NULL) {
		completion_provider_init_calltip_window (self);
	}
	_tmp1_ = self->priv->_calltip_window_label;
	gtk_label_set_markup (_tmp1_, markup);
	_tmp2_ = glatex_app_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = glatex_app_get_active_main_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	window = _tmp5_;
	g_return_if_fail (window != NULL);
	_tmp6_ = self->priv->_calltip_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, (GtkWindow*) window);
	_tmp7_ = self->priv->_calltip_window;
	_tmp8_ = main_window_get_active_view (window);
	_tmp9_ = _tmp8_;
	gtk_window_set_attached_to ((GtkWindow*) _tmp7_, (GtkWidget*) _tmp9_);
	_tmp10_ = main_window_get_active_view (window);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	buffer = _tmp14_;
	_tmp15_ = gtk_text_buffer_get_insert (buffer);
	gtk_text_buffer_get_iter_at_mark (buffer, &_tmp16_, _tmp15_);
	cursor_pos = _tmp16_;
	_tmp17_ = cursor_pos;
	completion_provider_get_begin_arg_pos (self, &_tmp17_, &_tmp18_);
	begin_arg_pos = _tmp18_;
	_tmp19_ = self->priv->_calltip_window;
	_tmp20_ = main_window_get_active_view (window);
	_tmp21_ = _tmp20_;
	_tmp22_ = begin_arg_pos;
	gtk_source_completion_info_move_to_iter (_tmp19_, (GtkTextView*) _tmp21_, &_tmp22_);
	_tmp23_ = self->priv->_calltip_window;
	gtk_widget_show_all ((GtkWidget*) _tmp23_);
	_g_object_unref0 (buffer);
	_g_object_unref0 (window);
}

void
completion_provider_hide_calltip_window (CompletionProvider* self)
{
	GtkSourceCompletionInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ != NULL) {
		GtkSourceCompletionInfo* _tmp1_;
		_tmp1_ = self->priv->_calltip_window;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}

/*************************************************************************/
static gboolean
completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                            GtkSourceCompletionProposal* proposal,
                                            GtkTextIter* iter)
{
	CompletionProvider * self;
	gchar* text = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* cmd = NULL;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean result = FALSE;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = gtk_source_completion_proposal_get_text (proposal);
	text = _tmp0_;
	_tmp2_ = text;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = text;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp4_ = *iter;
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
	cmd = _tmp5_;
	_tmp7_ = cmd;
	if (_tmp7_ != NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = text;
		_tmp6_ = g_str_has_prefix (_tmp8_, "\\");
	}
	if (_tmp6_) {
		GtkTextIter _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = *iter;
		_tmp10_ = cmd;
		completion_provider_activate_proposal_command_name (self, proposal, &_tmp9_, _tmp10_);
	} else {
		CompletionProviderArgumentContext info = {0};
		GtkTextIter _tmp11_;
		CompletionProviderArgumentContext _tmp12_ = {0};
		gboolean _tmp13_;
		_tmp11_ = *iter;
		_tmp13_ = completion_provider_in_latex_command_argument (self, &_tmp11_, &_tmp12_);
		completion_provider_argument_context_destroy (&info);
		info = _tmp12_;
		if (_tmp13_) {
			GtkTextIter _tmp14_;
			CompletionProviderArgumentContext _tmp15_;
			const gchar* _tmp16_;
			CompletionProviderArgumentContext _tmp17_;
			const gchar* _tmp18_;
			_tmp14_ = *iter;
			_tmp15_ = info;
			_tmp16_ = _tmp15_.cmd_name;
			_tmp17_ = info;
			_tmp18_ = _tmp17_.arg_contents;
			completion_provider_activate_proposal_argument_choice (self, proposal, &_tmp14_, _tmp16_, _tmp18_);
		} else {
			g_warning ("completion.vala:421: Not in a LaTeX command argument.");
		}
		completion_provider_argument_context_destroy (&info);
	}
	result = TRUE;
	_g_free0 (cmd);
	_g_free0 (text);
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
completion_provider_activate_proposal_command_name (CompletionProvider* self,
                                                    GtkSourceCompletionProposal* proposal,
                                                    GtkTextIter* iter,
                                                    const gchar* cmd)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextMark* old_pos_mark = NULL;
	GtkTextBuffer* _tmp11_;
	GtkTextIter _tmp12_;
	GtkTextMark* _tmp13_;
	GtkTextMark* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	const gchar* _tmp17_;
	GtkTextBuffer* _tmp18_;
	GtkTextIter old_pos_iter = {0};
	GtkTextBuffer* _tmp19_;
	GtkTextMark* _tmp20_;
	GtkTextIter _tmp21_ = {0};
	GtkTextBuffer* _tmp22_;
	GtkTextMark* _tmp23_;
	GtkTextIter match_end = {0};
	GtkTextIter _tmp24_;
	GtkTextIter _tmp25_ = {0};
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_source_completion_proposal_get_text (proposal);
	text = _tmp0_;
	if (cmd != NULL) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = strlen (cmd);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = 0;
	}
	index_start = (glong) _tmp1_;
	_tmp4_ = text;
	_tmp5_ = text;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_slice (_tmp4_, index_start, (glong) _tmp7_);
	text_to_insert = _tmp8_;
	_tmp9_ = gtk_text_iter_get_buffer (iter);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	doc = _tmp10_;
	_tmp11_ = doc;
	_tmp12_ = *iter;
	_tmp13_ = gtk_text_buffer_create_mark (_tmp11_, NULL, &_tmp12_, TRUE);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	old_pos_mark = _tmp14_;
	_tmp15_ = doc;
	gtk_text_buffer_begin_user_action (_tmp15_);
	_tmp16_ = doc;
	_tmp17_ = text_to_insert;
	gtk_text_buffer_insert (_tmp16_, iter, _tmp17_, -1);
	_tmp18_ = doc;
	gtk_text_buffer_end_user_action (_tmp18_);
	_tmp19_ = doc;
	_tmp20_ = old_pos_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp19_, &_tmp21_, _tmp20_);
	old_pos_iter = _tmp21_;
	_tmp22_ = doc;
	_tmp23_ = old_pos_mark;
	gtk_text_buffer_delete_mark (_tmp22_, _tmp23_);
	_tmp24_ = *iter;
	_tmp26_ = gtk_text_iter_forward_search (&old_pos_iter, "{", GTK_TEXT_SEARCH_TEXT_ONLY | GTK_TEXT_SEARCH_VISIBLE_ONLY, NULL, &_tmp25_, &_tmp24_);
	match_end = _tmp25_;
	if (_tmp26_) {
		GtkTextBuffer* _tmp27_;
		GtkTextIter _tmp28_;
		_tmp27_ = doc;
		_tmp28_ = match_end;
		gtk_text_buffer_place_cursor (_tmp27_, &_tmp28_);
	}
	_g_object_unref0 (old_pos_mark);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}

static void
completion_provider_activate_proposal_argument_choice (CompletionProvider* self,
                                                       GtkSourceCompletionProposal* proposal,
                                                       GtkTextIter* iter,
                                                       const gchar* arg_cmd,
                                                       const gchar* arg_contents)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	const gchar* _tmp13_;
	GtkTextBuffer* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (arg_cmd != NULL);
	_tmp0_ = gtk_source_completion_proposal_get_text (proposal);
	text = _tmp0_;
	if (arg_contents != NULL) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = strlen (arg_contents);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = 0;
	}
	index_start = (glong) _tmp1_;
	_tmp4_ = text;
	_tmp5_ = text;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_slice (_tmp4_, index_start, (glong) _tmp7_);
	text_to_insert = _tmp8_;
	_tmp9_ = gtk_text_iter_get_buffer (iter);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	doc = _tmp10_;
	_tmp11_ = doc;
	gtk_text_buffer_begin_user_action (_tmp11_);
	_tmp12_ = doc;
	_tmp13_ = text_to_insert;
	gtk_text_buffer_insert (_tmp12_, iter, _tmp13_, -1);
	if (g_strcmp0 (arg_cmd, "\\begin") == 0) {
		GtkTextBuffer* _tmp15_;
		GtkTextBuffer* _tmp16_;
		const gchar* _tmp17_;
		GtkTextIter _tmp18_;
		if (gtk_text_iter_get_char (iter) == ((gunichar) '}')) {
			gtk_text_iter_forward_char (iter);
		} else {
			GtkTextBuffer* _tmp14_;
			_tmp14_ = doc;
			gtk_text_buffer_insert (_tmp14_, iter, "}", -1);
		}
		_tmp15_ = doc;
		gtk_text_buffer_end_user_action (_tmp15_);
		_tmp16_ = doc;
		gtk_text_buffer_begin_user_action (_tmp16_);
		_tmp17_ = text;
		_tmp18_ = *iter;
		completion_provider_close_environment (self, _tmp17_, &_tmp18_);
	} else {
	}
	_tmp19_ = doc;
	gtk_text_buffer_end_user_action (_tmp19_);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
completion_provider_close_environment (CompletionProvider* self,
                                       const gchar* env_name,
                                       GtkTextIter* iter)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gchar* cur_indent = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar* indent = NULL;
	Document* _tmp4_;
	DocumentTab* _tmp5_;
	DocumentView* _tmp6_;
	DocumentView* _tmp7_;
	gchar* _tmp8_;
	CompletionProviderCompletionChoice* env = NULL;
	GeeHashMap* _tmp9_;
	gpointer _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	CompletionProviderCompletionChoice* _tmp20_;
	GtkTextMark* cursor_pos = NULL;
	Document* _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextMark* _tmp28_;
	GtkTextMark* _tmp29_;
	gboolean _tmp30_ = FALSE;
	CompletionProviderCompletionChoice* _tmp31_;
	Document* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	Document* _tmp43_;
	GtkTextMark* _tmp44_;
	GtkTextIter _tmp45_ = {0};
	Document* _tmp46_;
	GtkTextMark* _tmp47_;
	Document* _tmp48_;
	GtkTextIter _tmp49_;
	Document* _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (env_name != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = *iter;
	_tmp3_ = tepl_iter_get_line_indentation (&_tmp2_);
	cur_indent = _tmp3_;
	_tmp4_ = doc;
	_tmp5_ = _tmp4_->tab;
	_tmp6_ = document_tab_get_document_view (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = latexila_view_get_indentation_style ((GtkSourceView*) _tmp7_);
	indent = _tmp8_;
	_tmp9_ = self->priv->_environments;
	_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, env_name);
	env = (CompletionProviderCompletionChoice*) _tmp10_;
	_tmp11_ = doc;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp11_);
	_tmp12_ = doc;
	_tmp13_ = cur_indent;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = indent;
	_tmp16_ = string_to_string (_tmp15_);
	_tmp17_ = g_strconcat ("\n", _tmp14_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	document_insert (_tmp12_, iter, _tmp18_, -1);
	_g_free0 (_tmp18_);
	_tmp20_ = env;
	if (_tmp20_ != NULL) {
		CompletionProviderCompletionChoice* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = env;
		_tmp22_ = (*_tmp21_).insert;
		_tmp19_ = _tmp22_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		Document* _tmp23_;
		CompletionProviderCompletionChoice* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = doc;
		_tmp24_ = env;
		_tmp25_ = (*_tmp24_).insert;
		document_insert (_tmp23_, iter, _tmp25_, -1);
	}
	_tmp26_ = doc;
	_tmp27_ = *iter;
	_tmp28_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) _tmp26_, NULL, &_tmp27_, TRUE);
	_tmp29_ = _g_object_ref0 (_tmp28_);
	cursor_pos = _tmp29_;
	_tmp31_ = env;
	if (_tmp31_ != NULL) {
		CompletionProviderCompletionChoice* _tmp32_;
		const gchar* _tmp33_;
		_tmp32_ = env;
		_tmp33_ = (*_tmp32_).insert_after;
		_tmp30_ = _tmp33_ != NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		Document* _tmp34_;
		CompletionProviderCompletionChoice* _tmp35_;
		const gchar* _tmp36_;
		_tmp34_ = doc;
		_tmp35_ = env;
		_tmp36_ = (*_tmp35_).insert_after;
		document_insert (_tmp34_, iter, _tmp36_, -1);
	}
	_tmp37_ = doc;
	_tmp38_ = cur_indent;
	_tmp39_ = string_to_string (_tmp38_);
	_tmp40_ = string_to_string (env_name);
	_tmp41_ = g_strconcat ("\n", _tmp39_, "\\end{", _tmp40_, "}", NULL);
	_tmp42_ = _tmp41_;
	document_insert (_tmp37_, iter, _tmp42_, -1);
	_g_free0 (_tmp42_);
	_tmp43_ = doc;
	_tmp44_ = cursor_pos;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp43_, &_tmp45_, _tmp44_);
	*iter = _tmp45_;
	_tmp46_ = doc;
	_tmp47_ = cursor_pos;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp46_, _tmp47_);
	_tmp48_ = doc;
	_tmp49_ = *iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp48_, &_tmp49_);
	_tmp50_ = doc;
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp50_);
	_g_object_unref0 (cursor_pos);
	_completion_provider_completion_choice_free0 (env);
	_g_free0 (indent);
	_g_free0 (cur_indent);
	_g_object_unref0 (doc);
}

/*************************************************************************/
static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}

static void
completion_provider_get_begin_arg_pos (CompletionProvider* self,
                                       GtkTextIter* in_arg_pos,
                                       GtkTextIter* result)
{
	gchar* text = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_;
	gint index = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gunichar cur_char = 0U;
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (in_arg_pos != NULL);
	_tmp0_ = *in_arg_pos;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	index = _tmp4_;
	while (TRUE) {
		const gchar* _tmp5_;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp5_ = text;
		_tmp7_ = string_get_prev_char (_tmp5_, &index, &_tmp6_);
		cur_char = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		if (cur_char == ((gunichar) '[')) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = cur_char == ((gunichar) '{');
		}
		if (_tmp9_) {
			const gchar* _tmp10_;
			_tmp10_ = text;
			_tmp8_ = !utils_char_is_escaped (_tmp10_, (glong) index);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			break;
		}
	}
	_tmp11_ = *in_arg_pos;
	begin_arg_pos = _tmp11_;
	gtk_text_iter_set_visible_line_index (&begin_arg_pos, index);
	gtk_text_iter_forward_char (&begin_arg_pos);
	*result = begin_arg_pos;
	_g_free0 (text);
	return;
}

static gchar*
completion_provider_get_latex_command_at_iter (CompletionProvider* self,
                                               GtkTextIter* iter)
{
	gchar* text = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = strlen (text);
	_tmp3_ = _tmp2_;
	_tmp4_ = completion_provider_get_latex_command_at_index (self, text, _tmp3_);
	result = _tmp4_;
	_g_free0 (text);
	return result;
}

static gchar*
completion_provider_get_latex_command_at_index (CompletionProvider* self,
                                                const gchar* text,
                                                gint index)
{
	gint _tmp0_;
	gint _tmp1_;
	gint cur_index = 0;
	gunichar cur_char = 0U;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = strlen (text);
	_tmp1_ = _tmp0_;
	g_return_val_if_fail (index <= _tmp1_, NULL);
	cur_index = index;
	while (TRUE) {
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = string_get_prev_char (text, &cur_index, &_tmp2_);
		cur_char = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		if (cur_char == ((gunichar) '\\')) {
			gchar* _tmp4_;
			if (utils_char_is_escaped (text, (glong) cur_index)) {
				break;
			}
			_tmp4_ = string_slice (text, (glong) cur_index, (glong) index);
			result = _tmp4_;
			return result;
		}
		if (!g_unichar_isalpha (cur_char)) {
			_tmp5_ = cur_char != ((gunichar) '*');
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			break;
		}
	}
	result = NULL;
	return result;
}

static gboolean
completion_provider_in_latex_command_argument (CompletionProvider* self,
                                               GtkTextIter* iter,
                                               CompletionProviderArgumentContext* info)
{
	CompletionProviderArgumentContext _vala_info = {0};
	GeeArrayList* _tmp0_;
	gchar* text = NULL;
	GtkTextIter _tmp1_;
	gchar* _tmp2_;
	gint last_index = 0;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cur_index = 0;
	gboolean in_prev_arg = FALSE;
	gunichar prev_arg_opening_bracket = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	completion_provider_argument_context_destroy (&_vala_info);
	memset (&_vala_info, 0, sizeof (CompletionProviderArgumentContext));
	_g_free0 (_vala_info.cmd_name);
	_vala_info.cmd_name = NULL;
	_g_free0 (_vala_info.arg_contents);
	_vala_info.arg_contents = NULL;
	_tmp0_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_vala_info.args_types);
	_vala_info.args_types = _tmp0_;
	_tmp1_ = *iter;
	_tmp2_ = completion_provider_get_text_line_to_iter (self, &_tmp1_);
	text = _tmp2_;
	_tmp3_ = text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	last_index = _tmp5_;
	cur_index = last_index;
	while (TRUE) {
		gunichar cur_char = 0U;
		const gchar* _tmp6_;
		gunichar _tmp7_ = 0U;
		gboolean _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean opening_bracket = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp6_ = text;
		_tmp8_ = string_get_prev_char (_tmp6_, &cur_index, &_tmp7_);
		cur_char = _tmp7_;
		if (!_tmp8_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		if (cur_char == ((gunichar) '{')) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = cur_char == ((gunichar) '[');
		}
		opening_bracket = _tmp9_;
		if (opening_bracket) {
			const gchar* _tmp11_;
			_tmp11_ = text;
			_tmp10_ = !utils_char_is_escaped (_tmp11_, (glong) cur_index);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			CompletionProviderArgumentContext _tmp12_;
			GeeArrayList* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = _vala_info;
			_tmp13_ = _tmp12_.args_types;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp13_, 0, (gpointer) ((gintptr) (cur_char == ((gunichar) '['))));
			_tmp14_ = text;
			_tmp15_ = string_slice (_tmp14_, (glong) (cur_index + 1), (glong) last_index);
			_g_free0 (_vala_info.arg_contents);
			_vala_info.arg_contents = _tmp15_;
			break;
		}
	}
	in_prev_arg = FALSE;
	prev_arg_opening_bracket = (gunichar) '{';
	while (TRUE) {
		gunichar cur_char = 0U;
		const gchar* _tmp16_;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_;
		_tmp16_ = text;
		_tmp18_ = string_get_prev_char (_tmp16_, &cur_index, &_tmp17_);
		cur_char = _tmp17_;
		if (!_tmp18_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		if (in_prev_arg) {
			if (cur_char == prev_arg_opening_bracket) {
				const gchar* _tmp19_;
				_tmp19_ = text;
				in_prev_arg = utils_char_is_escaped (_tmp19_, (glong) cur_index);
			}
		} else {
			gboolean _tmp20_ = FALSE;
			if (cur_char == ((gunichar) '}')) {
				_tmp20_ = TRUE;
			} else {
				_tmp20_ = cur_char == ((gunichar) ']');
			}
			if (_tmp20_) {
				const gchar* _tmp21_;
				gchar _tmp22_ = '\0';
				CompletionProviderArgumentContext _tmp23_;
				GeeArrayList* _tmp24_;
				_tmp21_ = text;
				if (utils_char_is_escaped (_tmp21_, (glong) cur_index)) {
					result = FALSE;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				}
				in_prev_arg = TRUE;
				if (cur_char == ((gunichar) '}')) {
					_tmp22_ = '{';
				} else {
					_tmp22_ = '[';
				}
				prev_arg_opening_bracket = (gunichar) _tmp22_;
				_tmp23_ = _vala_info;
				_tmp24_ = _tmp23_.args_types;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp24_, 0, (gpointer) ((gintptr) (cur_char == ((gunichar) ']'))));
			} else {
				gboolean _tmp25_ = FALSE;
				if (g_unichar_isalpha (cur_char)) {
					_tmp25_ = TRUE;
				} else {
					_tmp25_ = cur_char == ((gunichar) '*');
				}
				if (_tmp25_) {
					const gchar* _tmp26_;
					gchar* _tmp27_;
					CompletionProviderArgumentContext _tmp28_;
					const gchar* _tmp29_;
					_tmp26_ = text;
					_tmp27_ = completion_provider_get_latex_command_at_index (self, _tmp26_, cur_index + 1);
					_g_free0 (_vala_info.cmd_name);
					_vala_info.cmd_name = _tmp27_;
					_tmp28_ = _vala_info;
					_tmp29_ = _tmp28_.cmd_name;
					result = _tmp29_ != NULL;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				} else {
					if (!g_unichar_isspace (cur_char)) {
						result = FALSE;
						_g_free0 (text);
						if (info) {
							*info = _vala_info;
						} else {
							completion_provider_argument_context_destroy (&_vala_info);
						}
						return result;
					}
				}
			}
		}
	}
	_g_free0 (text);
	if (info) {
		*info = _vala_info;
	} else {
		completion_provider_argument_context_destroy (&_vala_info);
	}
}

/*************************************************************************/
static gboolean
completion_provider_is_user_request (CompletionProvider* self,
                                     GtkSourceCompletionContext* context)
{
	GtkSourceCompletionActivation _tmp0_;
	GtkSourceCompletionActivation _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_object_get (context, "activation", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}

static gint
completion_provider_compare_proposals (GtkSourceCompletionItem* a,
                                       GtkSourceCompletionItem* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint result = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	g_object_get (a, "text", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_object_get (b, "text", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gchar*
completion_provider_get_text_line_to_iter (CompletionProvider* self,
                                           GtkTextIter* iter)
{
	gint line = 0;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter iter_start = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	line = gtk_text_iter_get_line (iter);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	gtk_text_buffer_get_iter_at_line (doc, &_tmp2_, line);
	iter_start = _tmp2_;
	_tmp3_ = iter_start;
	_tmp4_ = *iter;
	_tmp5_ = gtk_text_buffer_get_text (doc, &_tmp3_, &_tmp4_, FALSE);
	result = _tmp5_;
	_g_object_unref0 (doc);
	return result;
}

static gchar*
completion_provider_get_command_info (CompletionProvider* self,
                                      CompletionProviderCompletionCommand* cmd,
                                      gint cur_arg)
{
	gchar* info = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionCommand _tmp29_;
	const gchar* _tmp30_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	info = _tmp2_;
	arg_num = 1;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_;
			CompletionProviderCompletionArgument _tmp6_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			_tmp5_ = arg_collection[arg_it];
			completion_provider_completion_argument_copy (&_tmp5_, &_tmp6_);
			arg = _tmp6_;
			{
				CompletionProviderCompletionArgument _tmp9_;
				gint _tmp28_;
				if (arg_num == cur_arg) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = info;
					_tmp8_ = g_strconcat (_tmp7_, "<b>", NULL);
					_g_free0 (info);
					info = _tmp8_;
				}
				_tmp9_ = arg;
				if (_tmp9_.optional) {
					const gchar* _tmp10_;
					CompletionProviderCompletionArgument _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp10_ = info;
					_tmp11_ = arg;
					_tmp12_ = _tmp11_.label;
					_tmp13_ = g_strconcat ("[", _tmp12_, NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp14_, "]", NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp10_, _tmp16_, NULL);
					_g_free0 (info);
					info = _tmp17_;
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
				} else {
					const gchar* _tmp18_;
					CompletionProviderCompletionArgument _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp18_ = info;
					_tmp19_ = arg;
					_tmp20_ = _tmp19_.label;
					_tmp21_ = g_strconcat ("{", _tmp20_, NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp22_, "}", NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp18_, _tmp24_, NULL);
					_g_free0 (info);
					info = _tmp25_;
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
				}
				if (arg_num == cur_arg) {
					const gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp26_ = info;
					_tmp27_ = g_strconcat (_tmp26_, "</b>", NULL);
					_g_free0 (info);
					info = _tmp27_;
				}
				_tmp28_ = arg_num;
				arg_num = _tmp28_ + 1;
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	_tmp29_ = *cmd;
	_tmp30_ = _tmp29_.package;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		CompletionProviderCompletionCommand _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp31_ = info;
		_tmp32_ = *cmd;
		_tmp33_ = _tmp32_.package;
		_tmp34_ = g_strconcat ("\nPackage: ", _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat (_tmp31_, _tmp35_, NULL);
		_g_free0 (info);
		info = _tmp36_;
		_g_free0 (_tmp35_);
	}
	result = info;
	return result;
}

static gint
completion_provider_get_argument_num (CompletionProvider* self,
                                      CompletionProviderCompletionArgument* all_args,
                                      gint all_args_length1,
                                      GeeArrayList* args)
{
	gint _tmp0_;
	gint _tmp1_;
	gint num = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (args != NULL, 0);
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) args);
	_tmp1_ = _tmp0_;
	if (all_args_length1 < _tmp1_) {
		result = -1;
		return result;
	}
	num = 0;
	{
		GeeArrayList* _arg_list = NULL;
		GeeArrayList* _tmp2_;
		gint _arg_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = _g_object_ref0 (args);
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gboolean arg = FALSE;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gint _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _arg_index);
			arg = (gboolean) ((gintptr) _tmp9_);
			while (TRUE) {
				CompletionProviderCompletionArgument _tmp10_;
				gint _tmp12_;
				if (all_args_length1 <= num) {
					result = -1;
					_g_object_unref0 (_arg_list);
					return result;
				}
				_tmp10_ = all_args[num];
				if (_tmp10_.optional == arg) {
					break;
				} else {
					CompletionProviderCompletionArgument _tmp11_;
					_tmp11_ = all_args[num];
					if (!_tmp11_.optional) {
						result = -1;
						_g_object_unref0 (_arg_list);
						return result;
					}
				}
				_tmp12_ = num;
				num = _tmp12_ + 1;
			}
			_tmp13_ = num;
			num = _tmp13_ + 1;
		}
		_g_object_unref0 (_arg_list);
	}
	result = num;
	return result;
}

static gchar*
completion_provider_get_command_text_to_insert (CompletionProvider* self,
                                                CompletionProviderCompletionCommand* cmd)
{
	gchar* text_to_insert = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	text_to_insert = _tmp2_;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_;
			CompletionProviderCompletionArgument _tmp6_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			_tmp5_ = arg_collection[arg_it];
			completion_provider_completion_argument_copy (&_tmp5_, &_tmp6_);
			arg = _tmp6_;
			{
				CompletionProviderCompletionArgument _tmp7_;
				_tmp7_ = arg;
				if (!_tmp7_.optional) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = text_to_insert;
					_tmp9_ = g_strconcat (_tmp8_, "{}", NULL);
					_g_free0 (text_to_insert);
					text_to_insert = _tmp9_;
				}
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	result = text_to_insert;
	return result;
}

/*************************************************************************/
static void
_completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                     const gchar* element_name,
                                                                     gchar** attribute_names,
                                                                     gchar** attribute_values,
                                                                     gpointer self,
                                                                     GError** error)
{
	completion_provider_parser_start ((CompletionProvider*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}

static void
_completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                 const gchar* element_name,
                                                                 gpointer self,
                                                                 GError** error)
{
	completion_provider_parser_end ((CompletionProvider*) self, context, element_name, error);
}

static void
_completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                           const gchar* text,
                                                           gsize text_len,
                                                           gpointer self,
                                                           GError** error)
{
	completion_provider_parser_text ((CompletionProvider*) self, context, text, text_len, error);
}

static void
completion_provider_load_data (CompletionProvider* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GFile* file = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* contents = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND, (GBoxedCopyFunc) completion_provider_completion_command_dup, (GDestroyNotify) completion_provider_completion_command_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_commands);
	self->priv->_commands = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE, (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GDestroyNotify) completion_provider_completion_choice_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_environments);
	self->priv->_environments = _tmp1_;
	_tmp2_ = g_build_filename (DATA_DIR, "completion.xml", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file = _tmp5_;
	_tmp6_ = file;
	_tmp7_ = utils_load_file (_tmp6_);
	contents = _tmp7_;
	_tmp8_ = contents;
	if (_tmp8_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp9_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp10_;
		GMarkupParseContext* _tmp11_;
		GMarkupParseContext* _tmp12_;
		const gchar* _tmp13_;
		_tmp9_.start_element = _completion_provider_parser_start_gmarkup_parser_start_element_func;
		_tmp9_.end_element = _completion_provider_parser_end_gmarkup_parser_end_element_func;
		_tmp9_.text = _completion_provider_parser_text_gmarkup_parser_text_func;
		_tmp9_.passthrough = NULL;
		_tmp9_.error = NULL;
		parser = _tmp9_;
		_tmp10_ = parser;
		_tmp11_ = g_markup_parse_context_new (&_tmp10_, 0, self, NULL);
		context = _tmp11_;
		_tmp12_ = context;
		_tmp13_ = contents;
		g_markup_parse_context_parse (_tmp12_, _tmp13_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch0_g_error;
		}
		self->priv->_proposals = g_list_sort (self->priv->_proposals, (GCompareFunc) completion_provider_compare_proposals);
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("completion.vala:804: Impossible to load completion data: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
}

static void
completion_provider_parser_start (CompletionProvider* self,
                                  GMarkupParseContext* context,
                                  const gchar* name,
                                  gchar** attr_names,
                                  gint attr_names_length1,
                                  gchar** attr_values,
                                  gint attr_values_length1,
                                  GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("commands")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				completion_provider_parser_add_command (self, attr_names, (gint) attr_names_length1, attr_values, (gint) attr_values_length1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				completion_provider_parser_add_argument (self, attr_names, (gint) attr_names_length1, attr_values, (gint) attr_values_length1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				completion_provider_parser_add_choice (self, attr_names, (gint) attr_names_length1, attr_values, (gint) attr_values_length1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("insert")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("insert_after"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("placeholder")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("component"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				GError* _tmp7_;
				GError* _tmp8_;
				_tmp3_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strconcat (_tmp4_, "\"", NULL);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp6_);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				_g_free0 (_tmp4_);
				_inner_error0_ = _tmp8_;
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static void
completion_provider_parser_add_command (CompletionProvider* self,
                                        gchar** attr_names,
                                        gint attr_names_length1,
                                        gchar** attr_values,
                                        gint attr_values_length1,
                                        GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	memset (&self->priv->_current_command, 0, sizeof (CompletionProviderCompletionCommand));
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
				static GQuark _tmp4_label0 = 0;
				static GQuark _tmp4_label1 = 0;
				static GQuark _tmp4_label2 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(attr_num < attr_names_length1)) {
					break;
				}
				_tmp2_ = attr_names[attr_num];
				_tmp3_ = _tmp2_;
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp6_;
							gchar* _tmp7_;
							_tmp6_ = attr_values[attr_num];
							_tmp7_ = g_strconcat ("\\", _tmp6_, NULL);
							_g_free0 (self->priv->_current_command.name);
							self->priv->_current_command.name = _tmp7_;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp8_;
							gchar* _tmp9_;
							_tmp8_ = attr_values[attr_num];
							_tmp9_ = g_strdup (_tmp8_);
							_g_free0 (self->priv->_current_command.package);
							self->priv->_current_command.package = _tmp9_;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("environment")))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							GError* _tmp15_;
							GError* _tmp16_;
							_tmp10_ = attr_names[attr_num];
							_tmp11_ = g_strconcat ("unknown command attribute \"", _tmp10_, NULL);
							_tmp12_ = _tmp11_;
							_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp14_);
							_tmp16_ = _tmp15_;
							_g_free0 (_tmp14_);
							_g_free0 (_tmp12_);
							_inner_error0_ = _tmp16_;
							if (_inner_error0_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error0_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
			}
		}
	}
}

static void
completion_provider_parser_add_argument (CompletionProvider* self,
                                         gchar** attr_names,
                                         gint attr_names_length1,
                                         gchar** attr_values,
                                         gint attr_values_length1,
                                         GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	memset (&self->priv->_current_arg, 0, sizeof (CompletionProviderCompletionArgument));
	self->priv->_current_arg.optional = FALSE;
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
				static GQuark _tmp4_label0 = 0;
				static GQuark _tmp4_label1 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(attr_num < attr_names_length1)) {
					break;
				}
				_tmp2_ = attr_names[attr_num];
				_tmp3_ = _tmp2_;
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("label")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp6_;
							gchar* _tmp7_;
							_tmp6_ = attr_values[attr_num];
							_tmp7_ = g_strdup (_tmp6_);
							_g_free0 (self->priv->_current_arg.label);
							self->priv->_current_arg.label = _tmp7_;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("type")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp8_;
							_tmp8_ = attr_values[attr_num];
							self->priv->_current_arg.optional = g_strcmp0 (_tmp8_, "optional") == 0;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							GError* _tmp14_;
							GError* _tmp15_;
							_tmp9_ = attr_names[attr_num];
							_tmp10_ = g_strconcat ("unknown argument attribute \"", _tmp9_, NULL);
							_tmp11_ = _tmp10_;
							_tmp12_ = g_strconcat (_tmp11_, "\"", NULL);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp13_);
							_tmp15_ = _tmp14_;
							_g_free0 (_tmp13_);
							_g_free0 (_tmp11_);
							_inner_error0_ = _tmp15_;
							if (_inner_error0_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error0_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
			}
		}
	}
}

static void
completion_provider_parser_add_choice (CompletionProvider* self,
                                       gchar** attr_names,
                                       gint attr_names_length1,
                                       gchar** attr_values,
                                       gint attr_values_length1,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	memset (&self->priv->_current_choice, 0, sizeof (CompletionProviderCompletionChoice));
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
				static GQuark _tmp4_label0 = 0;
				static GQuark _tmp4_label1 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(attr_num < attr_names_length1)) {
					break;
				}
				_tmp2_ = attr_names[attr_num];
				_tmp3_ = _tmp2_;
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp6_;
							gchar* _tmp7_;
							_tmp6_ = attr_values[attr_num];
							_tmp7_ = g_strdup (_tmp6_);
							_g_free0 (self->priv->_current_choice.name);
							self->priv->_current_choice.name = _tmp7_;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp8_;
							gchar* _tmp9_;
							_tmp8_ = attr_values[attr_num];
							_tmp9_ = g_strdup (_tmp8_);
							_g_free0 (self->priv->_current_choice.package);
							self->priv->_current_choice.package = _tmp9_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							GError* _tmp15_;
							GError* _tmp16_;
							_tmp10_ = attr_names[attr_num];
							_tmp11_ = g_strconcat ("unknown choice attribute \"", _tmp10_, NULL);
							_tmp12_ = _tmp11_;
							_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp14_);
							_tmp16_ = _tmp15_;
							_g_free0 (_tmp14_);
							_g_free0 (_tmp12_);
							_inner_error0_ = _tmp16_;
							if (_inner_error0_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error0_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
			}
		}
	}
}

static void
_vala_array_add2 (CompletionProviderCompletionArgument* * array,
                  gint* length,
                  gint* size,
                  const CompletionProviderCompletionArgument* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionArgument, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add3 (CompletionProviderCompletionChoice* * array,
                  gint* length,
                  gint* size,
                  const CompletionProviderCompletionChoice* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionChoice, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
completion_provider_parser_end (CompletionProvider* self,
                                GMarkupParseContext* context,
                                const gchar* name,
                                GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				GdkPixbuf* _tmp3_ = NULL;
				CompletionProviderCompletionCommand _tmp4_;
				const gchar* _tmp5_;
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp8_;
				GtkSourceCompletionItem* item = NULL;
				GtkSourceCompletionItem* _tmp9_;
				GtkSourceCompletionItem* _tmp10_;
				CompletionProviderCompletionCommand _tmp11_;
				const gchar* _tmp12_;
				GtkSourceCompletionItem* _tmp13_;
				CompletionProviderCompletionCommand _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GtkSourceCompletionItem* _tmp17_;
				GdkPixbuf* _tmp18_;
				GtkSourceCompletionItem* _tmp19_;
				CompletionProviderCompletionCommand _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GtkSourceCompletionItem* _tmp23_;
				GtkSourceCompletionItem* _tmp24_;
				CompletionProviderCompletionCommand _tmp25_;
				CompletionProviderCompletionArgument* _tmp26_;
				gint _tmp26__length1;
				_tmp4_ = self->priv->_current_command;
				_tmp5_ = _tmp4_.package;
				if (_tmp5_ != NULL) {
					GdkPixbuf* _tmp6_;
					_tmp6_ = self->priv->_icon_package_required;
					_tmp3_ = _tmp6_;
				} else {
					GdkPixbuf* _tmp7_;
					_tmp7_ = self->priv->_icon_cmd;
					_tmp3_ = _tmp7_;
				}
				_tmp8_ = _g_object_ref0 (_tmp3_);
				pixbuf = _tmp8_;
				_tmp9_ = gtk_source_completion_item_new ();
				item = _tmp9_;
				_tmp10_ = item;
				_tmp11_ = self->priv->_current_command;
				_tmp12_ = _tmp11_.name;
				gtk_source_completion_item_set_label (_tmp10_, _tmp12_);
				_tmp13_ = item;
				_tmp14_ = self->priv->_current_command;
				_tmp15_ = completion_provider_get_command_text_to_insert (self, &_tmp14_);
				_tmp16_ = _tmp15_;
				gtk_source_completion_item_set_text (_tmp13_, _tmp16_);
				_g_free0 (_tmp16_);
				_tmp17_ = item;
				_tmp18_ = pixbuf;
				gtk_source_completion_item_set_icon (_tmp17_, _tmp18_);
				_tmp19_ = item;
				_tmp20_ = self->priv->_current_command;
				_tmp21_ = completion_provider_get_command_info (self, &_tmp20_, -1);
				_tmp22_ = _tmp21_;
				gtk_source_completion_item_set_info (_tmp19_, _tmp22_);
				_g_free0 (_tmp22_);
				_tmp23_ = item;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				self->priv->_proposals = g_list_prepend (self->priv->_proposals, _tmp24_);
				_tmp25_ = self->priv->_current_command;
				_tmp26_ = _tmp25_.args;
				_tmp26__length1 = _tmp25_.args_length1;
				if (0 < _tmp26__length1) {
					GeeHashMap* _tmp27_;
					CompletionProviderCompletionCommand _tmp28_;
					const gchar* _tmp29_;
					CompletionProviderCompletionCommand _tmp30_;
					_tmp27_ = self->priv->_commands;
					_tmp28_ = self->priv->_current_command;
					_tmp29_ = _tmp28_.name;
					_tmp30_ = self->priv->_current_command;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp29_, &_tmp30_);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (pixbuf);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionArgument _tmp31_;
				CompletionProviderCompletionArgument _tmp32_;
				CompletionProviderCompletionArgument _tmp33_ = {0};
				_tmp31_ = self->priv->_current_arg;
				_tmp32_ = _tmp31_;
				completion_provider_completion_argument_copy (&_tmp32_, &_tmp33_);
				_vala_array_add2 (&self->priv->_current_command.args, &self->priv->_current_command.args_length1, &self->priv->_current_command._args_size_, &_tmp33_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionChoice _tmp34_;
				CompletionProviderCompletionChoice _tmp35_;
				CompletionProviderCompletionChoice _tmp36_ = {0};
				gboolean _tmp37_ = FALSE;
				CompletionProviderCompletionChoice _tmp38_;
				const gchar* _tmp39_;
				_tmp34_ = self->priv->_current_choice;
				_tmp35_ = _tmp34_;
				completion_provider_completion_choice_copy (&_tmp35_, &_tmp36_);
				_vala_array_add3 (&self->priv->_current_arg.choices, &self->priv->_current_arg.choices_length1, &self->priv->_current_arg._choices_size_, &_tmp36_);
				_tmp38_ = self->priv->_current_choice;
				_tmp39_ = _tmp38_.insert;
				if (_tmp39_ != NULL) {
					_tmp37_ = TRUE;
				} else {
					CompletionProviderCompletionChoice _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = self->priv->_current_choice;
					_tmp41_ = _tmp40_.insert_after;
					_tmp37_ = _tmp41_ != NULL;
				}
				if (_tmp37_) {
					GeeHashMap* _tmp42_;
					CompletionProviderCompletionChoice _tmp43_;
					const gchar* _tmp44_;
					CompletionProviderCompletionChoice _tmp45_;
					_tmp42_ = self->priv->_environments;
					_tmp43_ = self->priv->_current_choice;
					_tmp44_ = _tmp43_.name;
					_tmp45_ = self->priv->_current_choice;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, _tmp44_, &_tmp45_);
				}
				break;
			}
		}
	}
}

static void
completion_provider_parser_text (CompletionProvider* self,
                                 GMarkupParseContext* context,
                                 const gchar* text,
                                 gsize text_len,
                                 GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_markup_parse_context_get_element (context);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("insert")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (text);
				_g_free0 (self->priv->_current_choice.insert);
				self->priv->_current_choice.insert = _tmp4_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("insert_after")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (text);
				_g_free0 (self->priv->_current_choice.insert_after);
				self->priv->_current_choice.insert_after = _tmp5_;
				break;
			}
		}
	}
}

static void
_vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument * array,
                                                       gint array_length)
{
	if (array != NULL) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_argument_destroy (&array[i]);
		}
	}
	g_free (array);
}

static CompletionProviderCompletionArgument*
_vala_array_dup1 (CompletionProviderCompletionArgument* self,
                  gint length)
{
	if (length > 0) {
		CompletionProviderCompletionArgument* result;
		gint i;
		result = g_new0 (CompletionProviderCompletionArgument, length);
		for (i = 0; i < length; i++) {
			CompletionProviderCompletionArgument _tmp0_;
			CompletionProviderCompletionArgument _tmp1_ = {0};
			_tmp0_ = self[i];
			completion_provider_completion_argument_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static void
completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self,
                                             CompletionProviderCompletionCommand* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionArgument* _tmp5_;
	gint _tmp5__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).args;
	_tmp4__length1 = (*self).args_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	(*dest).args = (_vala_CompletionProviderCompletionArgument_array_free ((*dest).args, (*dest).args_length1), NULL);
	(*dest).args = _tmp5_;
	(*dest).args_length1 = _tmp5__length1;
	(*dest)._args_size_ = (*dest).args_length1;
}

static void
completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	(*self).args = (_vala_CompletionProviderCompletionArgument_array_free ((*self).args, (*self).args_length1), NULL);
}

static CompletionProviderCompletionCommand*
completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self)
{
	CompletionProviderCompletionCommand* dup;
	dup = g_new0 (CompletionProviderCompletionCommand, 1);
	completion_provider_completion_command_copy (self, dup);
	return dup;
}

static void
completion_provider_completion_command_free (CompletionProviderCompletionCommand* self)
{
	completion_provider_completion_command_destroy (self);
	g_free (self);
}

static GType
completion_provider_completion_command_get_type_once (void)
{
	GType completion_provider_completion_command_type_id;
	completion_provider_completion_command_type_id = g_boxed_type_register_static ("CompletionProviderCompletionCommand", (GBoxedCopyFunc) completion_provider_completion_command_dup, (GBoxedFreeFunc) completion_provider_completion_command_free);
	return completion_provider_completion_command_type_id;
}

static GType
completion_provider_completion_command_get_type (void)
{
	static volatile gsize completion_provider_completion_command_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_command_type_id__volatile)) {
		GType completion_provider_completion_command_type_id;
		completion_provider_completion_command_type_id = completion_provider_completion_command_get_type_once ();
		g_once_init_leave (&completion_provider_completion_command_type_id__volatile, completion_provider_completion_command_type_id);
	}
	return completion_provider_completion_command_type_id__volatile;
}

static void
_vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice * array,
                                                     gint array_length)
{
	if (array != NULL) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_choice_destroy (&array[i]);
		}
	}
	g_free (array);
}

static CompletionProviderCompletionChoice*
_vala_array_dup2 (CompletionProviderCompletionChoice* self,
                  gint length)
{
	if (length > 0) {
		CompletionProviderCompletionChoice* result;
		gint i;
		result = g_new0 (CompletionProviderCompletionChoice, length);
		for (i = 0; i < length; i++) {
			CompletionProviderCompletionChoice _tmp0_;
			CompletionProviderCompletionChoice _tmp1_ = {0};
			_tmp0_ = self[i];
			completion_provider_completion_choice_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static void
completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self,
                                              CompletionProviderCompletionArgument* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	CompletionProviderCompletionChoice* _tmp2_;
	gint _tmp2__length1;
	CompletionProviderCompletionChoice* _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	(*dest).optional = (*self).optional;
	_tmp2_ = (*self).choices;
	_tmp2__length1 = (*self).choices_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	(*dest).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*dest).choices, (*dest).choices_length1), NULL);
	(*dest).choices = _tmp3_;
	(*dest).choices_length1 = _tmp3__length1;
	(*dest)._choices_size_ = (*dest).choices_length1;
}

static void
completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self)
{
	_g_free0 ((*self).label);
	(*self).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*self).choices, (*self).choices_length1), NULL);
}

static CompletionProviderCompletionArgument*
completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self)
{
	CompletionProviderCompletionArgument* dup;
	dup = g_new0 (CompletionProviderCompletionArgument, 1);
	completion_provider_completion_argument_copy (self, dup);
	return dup;
}

static void
completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self)
{
	completion_provider_completion_argument_destroy (self);
	g_free (self);
}

static GType
completion_provider_completion_argument_get_type_once (void)
{
	GType completion_provider_completion_argument_type_id;
	completion_provider_completion_argument_type_id = g_boxed_type_register_static ("CompletionProviderCompletionArgument", (GBoxedCopyFunc) completion_provider_completion_argument_dup, (GBoxedFreeFunc) completion_provider_completion_argument_free);
	return completion_provider_completion_argument_type_id;
}

static GType
completion_provider_completion_argument_get_type (void)
{
	static volatile gsize completion_provider_completion_argument_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_argument_type_id__volatile)) {
		GType completion_provider_completion_argument_type_id;
		completion_provider_completion_argument_type_id = completion_provider_completion_argument_get_type_once ();
		g_once_init_leave (&completion_provider_completion_argument_type_id__volatile, completion_provider_completion_argument_type_id);
	}
	return completion_provider_completion_argument_type_id__volatile;
}

static void
completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self,
                                            CompletionProviderCompletionChoice* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).insert;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).insert);
	(*dest).insert = _tmp5_;
	_tmp6_ = (*self).insert_after;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).insert_after);
	(*dest).insert_after = _tmp7_;
}

static void
completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	_g_free0 ((*self).insert);
	_g_free0 ((*self).insert_after);
}

static CompletionProviderCompletionChoice*
completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self)
{
	CompletionProviderCompletionChoice* dup;
	dup = g_new0 (CompletionProviderCompletionChoice, 1);
	completion_provider_completion_choice_copy (self, dup);
	return dup;
}

static void
completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self)
{
	completion_provider_completion_choice_destroy (self);
	g_free (self);
}

static GType
completion_provider_completion_choice_get_type_once (void)
{
	GType completion_provider_completion_choice_type_id;
	completion_provider_completion_choice_type_id = g_boxed_type_register_static ("CompletionProviderCompletionChoice", (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GBoxedFreeFunc) completion_provider_completion_choice_free);
	return completion_provider_completion_choice_type_id;
}

static GType
completion_provider_completion_choice_get_type (void)
{
	static volatile gsize completion_provider_completion_choice_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_choice_type_id__volatile)) {
		GType completion_provider_completion_choice_type_id;
		completion_provider_completion_choice_type_id = completion_provider_completion_choice_get_type_once ();
		g_once_init_leave (&completion_provider_completion_choice_type_id__volatile, completion_provider_completion_choice_type_id);
	}
	return completion_provider_completion_choice_type_id__volatile;
}

static void
completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self,
                                           CompletionProviderArgumentContext* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	_tmp0_ = (*self).cmd_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).cmd_name);
	(*dest).cmd_name = _tmp1_;
	_tmp2_ = (*self).arg_contents;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).arg_contents);
	(*dest).arg_contents = _tmp3_;
	_tmp4_ = (*self).args_types;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).args_types);
	(*dest).args_types = _tmp5_;
}

static void
completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self)
{
	_g_free0 ((*self).cmd_name);
	_g_free0 ((*self).arg_contents);
	_g_object_unref0 ((*self).args_types);
}

static CompletionProviderArgumentContext*
completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self)
{
	CompletionProviderArgumentContext* dup;
	dup = g_new0 (CompletionProviderArgumentContext, 1);
	completion_provider_argument_context_copy (self, dup);
	return dup;
}

static void
completion_provider_argument_context_free (CompletionProviderArgumentContext* self)
{
	completion_provider_argument_context_destroy (self);
	g_free (self);
}

static GType
completion_provider_argument_context_get_type_once (void)
{
	GType completion_provider_argument_context_type_id;
	completion_provider_argument_context_type_id = g_boxed_type_register_static ("CompletionProviderArgumentContext", (GBoxedCopyFunc) completion_provider_argument_context_dup, (GBoxedFreeFunc) completion_provider_argument_context_free);
	return completion_provider_argument_context_type_id;
}

static GType
completion_provider_argument_context_get_type (void)
{
	static volatile gsize completion_provider_argument_context_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_argument_context_type_id__volatile)) {
		GType completion_provider_argument_context_type_id;
		completion_provider_argument_context_type_id = completion_provider_argument_context_get_type_once ();
		g_once_init_leave (&completion_provider_argument_context_type_id__volatile, completion_provider_argument_context_type_id);
	}
	return completion_provider_argument_context_type_id__volatile;
}

static void
completion_provider_class_init (CompletionProviderClass * klass,
                                gpointer klass_data)
{
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CompletionProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = completion_provider_finalize;
}

static void
completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface,
                                                                   gpointer iface_data)
{
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (GtkSourceCompletionProvider*)) completion_provider_real_get_name;
	iface->get_activation = (GtkSourceCompletionActivation (*) (GtkSourceCompletionProvider*)) completion_provider_real_get_activation;
	iface->match = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_match;
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
	iface->populate = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_populate;
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
}

static void
completion_provider_instance_init (CompletionProvider * self,
                                   gpointer klass)
{
	self->priv = completion_provider_get_instance_private (self);
	self->priv->_calltip_window = NULL;
	self->priv->_calltip_window_label = NULL;
}

static void
completion_provider_finalize (GObject * obj)
{
	CompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_PROVIDER, CompletionProvider);
	_g_object_unref0 (self->priv->_settings);
	(self->priv->_proposals == NULL) ? NULL : (self->priv->_proposals = (_g_list_free__g_object_unref0_ (self->priv->_proposals), NULL));
	_g_object_unref0 (self->priv->_commands);
	_g_object_unref0 (self->priv->_environments);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	_g_object_unref0 (self->priv->_icon_cmd);
	_g_object_unref0 (self->priv->_icon_choice);
	_g_object_unref0 (self->priv->_icon_package_required);
	_g_object_unref0 (self->priv->_calltip_window);
	_g_object_unref0 (self->priv->_calltip_window_label);
	G_OBJECT_CLASS (completion_provider_parent_class)->finalize (obj);
}

static GType
completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType completion_provider_type_id;
	completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	CompletionProvider_private_offset = g_type_add_instance_private (completion_provider_type_id, sizeof (CompletionProviderPrivate));
	return completion_provider_type_id;
}

GType
completion_provider_get_type (void)
{
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		GType completion_provider_type_id;
		completion_provider_type_id = completion_provider_get_type_once ();
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

