/* build_tool_dialog.c generated by valac 0.48.10, the Vala compiler
 * generated from build_tool_dialog.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2015 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The configuration of a single build tool.*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _BuildToolDialogPrivate BuildToolDialogPrivate;
enum  {
	BUILD_TOOL_DIALOG_0_PROPERTY,
	BUILD_TOOL_DIALOG_NUM_PROPERTIES
};
static GParamSpec* build_tool_dialog_properties[BUILD_TOOL_DIALOG_NUM_PROPERTIES];
typedef enum  {
	BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME,
	BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL,
	BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS
} BuildToolDialogIconColumn;

#define BUILD_TOOL_DIALOG_TYPE_ICON_COLUMN (build_tool_dialog_icon_column_get_type ())
typedef enum  {
	BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND,
	BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR,
	BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS
} BuildToolDialogJobColumn;

#define BUILD_TOOL_DIALOG_TYPE_JOB_COLUMN (build_tool_dialog_job_column_get_type ())
typedef enum  {
	BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME,
	BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS
} BuildToolDialogPostProcessorColumn;

#define BUILD_TOOL_DIALOG_TYPE_POST_PROCESSOR_COLUMN (build_tool_dialog_post_processor_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BuildToolDialog {
	GObject parent_instance;
	BuildToolDialogPrivate * priv;
};

struct _BuildToolDialogClass {
	GObjectClass parent_class;
};

struct _BuildToolDialogPrivate {
	GtkDialog* _dialog;
	GtkEntry* _entry_label;
	GtkEntry* _entry_desc;
	GtkEntry* _entry_extensions;
	GtkEntry* _entry_files_to_open;
	GtkListStore* _icons_store;
	GtkComboBox* _icons_combobox;
	GtkListStore* _jobs_store;
	GtkTreeView* _jobs_view;
};

struct _Block1Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* remove_button;
	GtkTreeSelection* select;
};

struct _Block2Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block3Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};

static gint BuildToolDialog_private_offset;
static gpointer build_tool_dialog_parent_class = NULL;

GType build_tool_dialog_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolDialog, g_object_unref)
static GType build_tool_dialog_icon_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType build_tool_dialog_job_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType build_tool_dialog_post_processor_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BuildToolDialog* build_tool_dialog_new (GtkWindow* parent,
                                        gboolean editable);
BuildToolDialog* build_tool_dialog_construct (GType object_type,
                                              GtkWindow* parent,
                                              gboolean editable);
static void build_tool_dialog_init_text_entries (BuildToolDialog* self,
                                          gboolean editable);
static void build_tool_dialog_init_icons_store (BuildToolDialog* self);
static void build_tool_dialog_init_icons_combobox (BuildToolDialog* self);
static void build_tool_dialog_init_jobs (BuildToolDialog* self,
                                  gboolean editable);
static GtkGrid* build_tool_dialog_get_main_grid (BuildToolDialog* self,
                                          gboolean editable);
gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self,
                                            LatexilaBuildTools* build_tools,
                                            gint build_tool_num);
static void build_tool_dialog_set_build_tool (BuildToolDialog* self,
                                       LatexilaBuildTool* build_tool);
static LatexilaBuildTool* build_tool_dialog_retrieve_build_tool (BuildToolDialog* self);
gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void build_tool_dialog_set_new_build_tool (BuildToolDialog* self);
static void build_tool_dialog_add_icon (BuildToolDialog* self,
                                 const gchar* icon_name,
                                 const gchar* label);
static void ___lambda93_ (BuildToolDialog* self,
                   const gchar* path_string,
                   const gchar* new_text);
static void ____lambda93__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                  const gchar* path,
                                                  const gchar* new_text,
                                                  gpointer self);
static void __lambda94_ (BuildToolDialog* self,
                  const gchar* path_string,
                  const gchar* new_text);
static void ___lambda94__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                 const gchar* path,
                                                 const gchar* new_text,
                                                 gpointer self);
static GtkToolButton* build_tool_dialog_get_add_button (BuildToolDialog* self);
static void __lambda95_ (BuildToolDialog* self);
static void build_tool_dialog_add_build_job (BuildToolDialog* self,
                                      LatexilaBuildJob* job);
static void ___lambda95__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static GtkToolButton* build_tool_dialog_get_remove_button (BuildToolDialog* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda96_ (Block1Data* _data1_);
static void ___lambda96__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static void __lambda97_ (BuildToolDialog* self);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void ___lambda97__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static GtkToolButton* build_tool_dialog_get_up_button (BuildToolDialog* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda98_ (Block2Data* _data2_);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void ___lambda98__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static void __lambda99_ (Block2Data* _data2_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model,
                                     GtkTreeIter* iter);
static void ___lambda99__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static GtkToolButton* build_tool_dialog_get_down_button (BuildToolDialog* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda100_ (Block3Data* _data3_);
static void ___lambda100__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void __lambda101_ (Block3Data* _data3_);
static void ___lambda101__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static GtkGrid* build_tool_dialog_get_label_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_desc_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_extensions_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_icons_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_jobs_grid (BuildToolDialog* self,
                                            gboolean editable);
static GtkWidget* build_tool_dialog_get_files_to_open_grid (BuildToolDialog* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void build_tool_dialog_finalize (GObject * obj);
static GType build_tool_dialog_get_type_once (void);

static inline gpointer
build_tool_dialog_get_instance_private (BuildToolDialog* self)
{
	return G_STRUCT_MEMBER_P (self, BuildToolDialog_private_offset);
}

static GType
build_tool_dialog_icon_column_get_type_once (void)
{
	static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, "BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME", "icon-name"}, {BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, "BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL", "label"}, {BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType build_tool_dialog_icon_column_type_id;
	build_tool_dialog_icon_column_type_id = g_enum_register_static ("BuildToolDialogIconColumn", values);
	return build_tool_dialog_icon_column_type_id;
}

static GType
build_tool_dialog_icon_column_get_type (void)
{
	static volatile gsize build_tool_dialog_icon_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_icon_column_type_id__volatile)) {
		GType build_tool_dialog_icon_column_type_id;
		build_tool_dialog_icon_column_type_id = build_tool_dialog_icon_column_get_type_once ();
		g_once_init_leave (&build_tool_dialog_icon_column_type_id__volatile, build_tool_dialog_icon_column_type_id);
	}
	return build_tool_dialog_icon_column_type_id__volatile;
}

static GType
build_tool_dialog_job_column_get_type_once (void)
{
	static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, "BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND", "command"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR", "post-processor"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType build_tool_dialog_job_column_type_id;
	build_tool_dialog_job_column_type_id = g_enum_register_static ("BuildToolDialogJobColumn", values);
	return build_tool_dialog_job_column_type_id;
}

static GType
build_tool_dialog_job_column_get_type (void)
{
	static volatile gsize build_tool_dialog_job_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_job_column_type_id__volatile)) {
		GType build_tool_dialog_job_column_type_id;
		build_tool_dialog_job_column_type_id = build_tool_dialog_job_column_get_type_once ();
		g_once_init_leave (&build_tool_dialog_job_column_type_id__volatile, build_tool_dialog_job_column_type_id);
	}
	return build_tool_dialog_job_column_type_id__volatile;
}

static GType
build_tool_dialog_post_processor_column_get_type_once (void)
{
	static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, "BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME", "name"}, {BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType build_tool_dialog_post_processor_column_type_id;
	build_tool_dialog_post_processor_column_type_id = g_enum_register_static ("BuildToolDialogPostProcessorColumn", values);
	return build_tool_dialog_post_processor_column_type_id;
}

static GType
build_tool_dialog_post_processor_column_get_type (void)
{
	static volatile gsize build_tool_dialog_post_processor_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_post_processor_column_type_id__volatile)) {
		GType build_tool_dialog_post_processor_column_type_id;
		build_tool_dialog_post_processor_column_type_id = build_tool_dialog_post_processor_column_get_type_once ();
		g_once_init_leave (&build_tool_dialog_post_processor_column_type_id__volatile, build_tool_dialog_post_processor_column_type_id);
	}
	return build_tool_dialog_post_processor_column_type_id__volatile;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BuildToolDialog*
build_tool_dialog_construct (GType object_type,
                             GtkWindow* parent,
                             gboolean editable)
{
	BuildToolDialog * self = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (BuildToolDialog*) g_object_new (object_type, NULL);
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp2_;
	_tmp3_ = self->priv->_dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp3_, TRUE);
	_tmp4_ = self->priv->_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
	_tmp5_ = self->priv->_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, parent);
	if (editable) {
		GtkDialog* _tmp6_;
		GtkDialog* _tmp7_;
		GtkDialog* _tmp8_;
		GtkDialog* _tmp9_;
		_tmp6_ = self->priv->_dialog;
		gtk_window_set_title ((GtkWindow*) _tmp6_, _ ("Personal Build Tool"));
		_tmp7_ = self->priv->_dialog;
		gtk_dialog_add_button (_tmp7_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
		_tmp8_ = self->priv->_dialog;
		gtk_dialog_add_button (_tmp8_, _ ("_Apply"), (gint) GTK_RESPONSE_APPLY);
		_tmp9_ = self->priv->_dialog;
		gtk_dialog_set_default_response (_tmp9_, (gint) GTK_RESPONSE_APPLY);
	} else {
		GtkDialog* _tmp10_;
		_tmp10_ = self->priv->_dialog;
		gtk_window_set_title ((GtkWindow*) _tmp10_, _ ("Default Build Tool (read-only)"));
	}
	build_tool_dialog_init_text_entries (self, editable);
	build_tool_dialog_init_icons_store (self);
	build_tool_dialog_init_icons_combobox (self);
	build_tool_dialog_init_jobs (self, editable);
	_tmp11_ = self->priv->_dialog;
	_tmp12_ = gtk_dialog_get_content_area (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	content_area = _tmp13_;
	_tmp14_ = build_tool_dialog_get_main_grid (self, editable);
	_tmp15_ = _tmp14_;
	gtk_box_pack_start (content_area, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (_tmp15_);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_g_object_unref0 (content_area);
	return self;
}

BuildToolDialog*
build_tool_dialog_new (GtkWindow* parent,
                       gboolean editable)
{
	return build_tool_dialog_construct (TYPE_BUILD_TOOL_DIALOG, parent, editable);
}

gboolean
build_tool_dialog_open_build_tool (BuildToolDialog* self,
                                   LatexilaBuildTools* build_tools,
                                   gint build_tool_num)
{
	LatexilaBuildTool* build_tool = NULL;
	LatexilaBuildTool* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	LatexilaBuildTool* _tmp2_;
	LatexilaBuildTool* _tmp3_;
	gboolean apply = FALSE;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (build_tools != NULL, FALSE);
	_tmp0_ = latexila_build_tools_nth (build_tools, (guint) build_tool_num);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	build_tool = _tmp1_;
	_tmp2_ = build_tool;
	g_return_val_if_fail (_tmp2_ != NULL, FALSE);
	_tmp3_ = build_tool;
	build_tool_dialog_set_build_tool (self, _tmp3_);
	_tmp4_ = self->priv->_dialog;
	apply = gtk_dialog_run (_tmp4_) == ((gint) GTK_RESPONSE_APPLY);
	if (apply) {
		LatexilaBuildTool* new_build_tool = NULL;
		LatexilaBuildTool* _tmp5_;
		LatexilaBuildTool* _tmp6_;
		LatexilaBuildTool* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		LatexilaBuildToolsPersonal* personal_build_tools = NULL;
		LatexilaBuildToolsPersonal* _tmp10_;
		LatexilaBuildToolsPersonal* _tmp11_;
		LatexilaBuildTool* _tmp12_;
		_tmp5_ = build_tool_dialog_retrieve_build_tool (self);
		new_build_tool = _tmp5_;
		_tmp6_ = new_build_tool;
		_tmp7_ = build_tool;
		g_object_get (_tmp7_, "enabled", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		g_object_set (_tmp6_, "enabled", _tmp9_, NULL);
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (build_tools, latexila_build_tools_personal_get_type ()) ? ((LatexilaBuildToolsPersonal*) build_tools) : NULL);
		personal_build_tools = _tmp10_;
		_tmp11_ = personal_build_tools;
		_tmp12_ = new_build_tool;
		latexila_build_tools_personal_replace (_tmp11_, _tmp12_, (guint) build_tool_num);
		_g_object_unref0 (personal_build_tools);
		_g_object_unref0 (new_build_tool);
	}
	_tmp13_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	result = apply;
	_g_object_unref0 (build_tool);
	return result;
}

gboolean
build_tool_dialog_create_personal_build_tool (BuildToolDialog* self)
{
	gboolean apply = FALSE;
	GtkDialog* _tmp0_;
	GtkDialog* _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	build_tool_dialog_set_new_build_tool (self);
	_tmp0_ = self->priv->_dialog;
	apply = gtk_dialog_run (_tmp0_) == ((gint) GTK_RESPONSE_APPLY);
	if (apply) {
		LatexilaBuildTool* new_build_tool = NULL;
		LatexilaBuildTool* _tmp1_;
		LatexilaBuildTool* _tmp2_;
		LatexilaBuildToolsPersonal* build_tools = NULL;
		LatexilaBuildToolsPersonal* _tmp3_;
		LatexilaBuildToolsPersonal* _tmp4_;
		LatexilaBuildToolsPersonal* _tmp5_;
		LatexilaBuildTool* _tmp6_;
		_tmp1_ = build_tool_dialog_retrieve_build_tool (self);
		new_build_tool = _tmp1_;
		_tmp2_ = new_build_tool;
		g_object_set (_tmp2_, "enabled", TRUE, NULL);
		_tmp3_ = latexila_build_tools_personal_get_instance ();
		_tmp4_ = _g_object_ref0 (_tmp3_);
		build_tools = _tmp4_;
		_tmp5_ = build_tools;
		_tmp6_ = new_build_tool;
		latexila_build_tools_personal_add (_tmp5_, _tmp6_);
		_g_object_unref0 (build_tools);
		_g_object_unref0 (new_build_tool);
	}
	_tmp7_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	result = apply;
	return result;
}

/*************************************************************************/
static void
build_tool_dialog_init_text_entries (BuildToolDialog* self,
                                     gboolean editable)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_entry_label);
	self->priv->_entry_label = _tmp0_;
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_entry_desc);
	self->priv->_entry_desc = _tmp1_;
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_entry_extensions);
	self->priv->_entry_extensions = _tmp2_;
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_entry_files_to_open);
	self->priv->_entry_files_to_open = _tmp3_;
	_tmp4_ = self->priv->_entry_label;
	gtk_editable_set_editable ((GtkEditable*) _tmp4_, editable);
	_tmp5_ = self->priv->_entry_desc;
	gtk_editable_set_editable ((GtkEditable*) _tmp5_, editable);
	_tmp6_ = self->priv->_entry_extensions;
	gtk_editable_set_editable ((GtkEditable*) _tmp6_, editable);
	_tmp7_ = self->priv->_entry_files_to_open;
	gtk_editable_set_editable ((GtkEditable*) _tmp7_, editable);
}

static void
build_tool_dialog_init_icons_store (BuildToolDialog* self)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->_icons_store);
	self->priv->_icons_store = _tmp0_;
	build_tool_dialog_add_icon (self, "system-run", _ ("Execute"));
	build_tool_dialog_add_icon (self, "compile_dvi", "LaTeX → DVI");
	build_tool_dialog_add_icon (self, "compile_pdf", "LaTeX → PDF");
	build_tool_dialog_add_icon (self, "compile_ps", "LaTeX → PS");
	build_tool_dialog_add_icon (self, GTK_STOCK_CONVERT, _ ("Convert"));
	build_tool_dialog_add_icon (self, "text-x-generic", _ ("View File"));
	build_tool_dialog_add_icon (self, "latexila-dvi", _ ("View DVI"));
	build_tool_dialog_add_icon (self, "latexila-pdf", _ ("View PDF"));
	build_tool_dialog_add_icon (self, "latexila-ps", _ ("View PS"));
}

static void
build_tool_dialog_add_icon (BuildToolDialog* self,
                            const gchar* icon_name,
                            const gchar* label)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->_icons_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->_icons_store;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, icon_name, BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, label, -1);
}

static void
build_tool_dialog_init_icons_combobox (BuildToolDialog* self)
{
	GtkListStore* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkComboBox* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_icons_store;
	_tmp1_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_icons_combobox);
	self->priv->_icons_combobox = _tmp1_;
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp2_);
	pixbuf_renderer = _tmp2_;
	_tmp3_ = self->priv->_icons_combobox;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp4_ = self->priv->_icons_combobox;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) pixbuf_renderer, "icon-name", BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, NULL);
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp5_);
	text_renderer = _tmp5_;
	_tmp6_ = self->priv->_icons_combobox;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp7_ = self->priv->_icons_combobox;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, NULL);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
}

static void
___lambda93_ (BuildToolDialog* self,
              const gchar* path_string,
              const gchar* new_text)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->_jobs_store;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp1_, path_string);
	iter = _tmp1_;
	_tmp2_ = self->priv->_jobs_store;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, new_text, -1);
}

static void
____lambda93__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                             const gchar* path,
                                             const gchar* new_text,
                                             gpointer self)
{
	___lambda93_ ((BuildToolDialog*) self, path, new_text);
}

static void
__lambda94_ (BuildToolDialog* self,
             const gchar* path_string,
             const gchar* new_text)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->_jobs_store;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp1_, path_string);
	iter = _tmp1_;
	_tmp2_ = self->priv->_jobs_store;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, new_text, -1);
}

static void
___lambda94__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                            const gchar* path,
                                            const gchar* new_text,
                                            gpointer self)
{
	__lambda94_ ((BuildToolDialog*) self, path, new_text);
}

static void
build_tool_dialog_init_jobs (BuildToolDialog* self,
                             gboolean editable)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* post_processor_store = NULL;
	GtkListStore* _tmp3_;
	GtkListStore* _tmp12_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp15_;
	GtkTreeViewColumn* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkTreeView* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkCellRendererCombo* combo_renderer = NULL;
	GtkCellRendererCombo* _tmp20_;
	GtkCellRendererCombo* _tmp21_;
	GtkCellRendererCombo* _tmp22_;
	GtkListStore* _tmp23_;
	GtkCellRendererCombo* _tmp24_;
	GtkCellRendererCombo* _tmp25_;
	GtkTreeView* _tmp26_;
	GtkCellRendererCombo* _tmp27_;
	GtkCellRendererCombo* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->_jobs_store);
	self->priv->_jobs_store = _tmp0_;
	_tmp1_ = self->priv->_jobs_store;
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_jobs_view);
	self->priv->_jobs_view = _tmp2_;
	_tmp3_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS, G_TYPE_STRING, -1);
	post_processor_store = _tmp3_;
	{
		gint type = 0;
		type = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				const gchar* name = NULL;
				const gchar* _tmp6_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_ = {0};
				GtkListStore* _tmp9_;
				GtkTreeIter _tmp10_;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = type;
					type = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(type < ((gint) LATEXILA_POST_PROCESSOR_TYPE_NB_TYPES))) {
					break;
				}
				_tmp6_ = latexila_post_processor_get_name_from_type ((LatexilaPostProcessorType) type);
				name = _tmp6_;
				_tmp7_ = post_processor_store;
				gtk_list_store_append (_tmp7_, &_tmp8_);
				iter = _tmp8_;
				_tmp9_ = post_processor_store;
				_tmp10_ = iter;
				_tmp11_ = name;
				gtk_list_store_set (_tmp9_, &_tmp10_, BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, _tmp11_, -1);
			}
		}
	}
	_tmp12_ = post_processor_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp12_, (gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, GTK_SORT_ASCENDING);
	_tmp13_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp13_);
	text_renderer = _tmp13_;
	_tmp14_ = text_renderer;
	g_object_set (_tmp14_, "editable", TRUE, NULL);
	_tmp15_ = text_renderer;
	_tmp16_ = gtk_tree_view_column_new_with_attributes (_ ("Commands"), (GtkCellRenderer*) _tmp15_, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, NULL);
	g_object_ref_sink (_tmp16_);
	column = _tmp16_;
	_tmp17_ = column;
	gtk_tree_view_column_set_resizable (_tmp17_, TRUE);
	_tmp18_ = self->priv->_jobs_view;
	_tmp19_ = column;
	gtk_tree_view_append_column (_tmp18_, _tmp19_);
	_tmp20_ = (GtkCellRendererCombo*) gtk_cell_renderer_combo_new ();
	g_object_ref_sink (_tmp20_);
	combo_renderer = _tmp20_;
	_tmp21_ = combo_renderer;
	g_object_set ((GtkCellRendererText*) _tmp21_, "editable", editable, NULL);
	_tmp22_ = combo_renderer;
	_tmp23_ = post_processor_store;
	g_object_set (_tmp22_, "model", (GtkTreeModel*) _tmp23_, NULL);
	_tmp24_ = combo_renderer;
	g_object_set (_tmp24_, "text-column", (gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, NULL);
	_tmp25_ = combo_renderer;
	g_object_set (_tmp25_, "has-entry", FALSE, NULL);
	_tmp26_ = self->priv->_jobs_view;
	_tmp27_ = combo_renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp26_, -1, _ ("Post Processor"), (GtkCellRenderer*) _tmp27_, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, NULL);
	if (editable) {
		GtkCellRendererText* _tmp28_;
		_tmp28_ = text_renderer;
		g_signal_connect_object (_tmp28_, "edited", (GCallback) ____lambda93__gtk_cell_renderer_text_edited, self, 0);
	}
	_tmp29_ = combo_renderer;
	g_signal_connect_object ((GtkCellRendererText*) _tmp29_, "edited", (GCallback) ___lambda94__gtk_cell_renderer_text_edited, self, 0);
	_g_object_unref0 (combo_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (post_processor_store);
}

/*************************************************************************/
static void
__lambda95_ (BuildToolDialog* self)
{
	LatexilaBuildJob* new_job = NULL;
	LatexilaBuildJob* _tmp0_;
	_tmp0_ = latexila_build_job_new ();
	new_job = _tmp0_;
	g_object_set (new_job, "command", "", NULL);
	g_object_set (new_job, "post-processor-type", LATEXILA_POST_PROCESSOR_TYPE_ALL_OUTPUT, NULL);
	build_tool_dialog_add_build_job (self, new_job);
	_g_object_unref0 (new_job);
}

static void
___lambda95__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda95_ ((BuildToolDialog*) self);
}

static GtkToolButton*
build_tool_dialog_get_add_button (BuildToolDialog* self)
{
	GtkToolButton* add_button = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	add_button = _tmp0_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _ ("Add…"));
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda95__gtk_tool_button_clicked, self, 0);
	result = add_button;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BuildToolDialog* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->remove_button);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda96_ (Block1Data* _data1_)
{
	BuildToolDialog* self;
	gboolean row_selected = FALSE;
	self = _data1_->self;
	row_selected = gtk_tree_selection_count_selected_rows (_data1_->select) > 0;
	gtk_widget_set_sensitive ((GtkWidget*) _data1_->remove_button, row_selected);
}

static void
___lambda96__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda96_ (self);
}

static void
__lambda97_ (BuildToolDialog* self)
{
	GtkTreeIter iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	_tmp0_ = self->priv->_jobs_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	selected_row = _tmp2_;
	if (selected_row >= 0) {
		GtkListStore* _tmp3_;
		_tmp3_ = self->priv->_jobs_store;
		gtk_list_store_remove (_tmp3_, &iter);
	}
}

static void
___lambda97__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda97_ ((BuildToolDialog*) self);
}

static GtkToolButton*
build_tool_dialog_get_remove_button (BuildToolDialog* self)
{
	Block1Data* _data1_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data1_->remove_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data1_->remove_button, "list-remove-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data1_->remove_button, _ ("Remove"));
	gtk_widget_set_sensitive ((GtkWidget*) _data1_->remove_button, FALSE);
	_tmp1_ = self->priv->_jobs_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_data1_->select = _tmp2_;
	g_signal_connect_data (_data1_->select, "changed", (GCallback) ___lambda96__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_object (_data1_->remove_button, "clicked", (GCallback) ___lambda97__gtk_tool_button_clicked, self, 0);
	_tmp3_ = _g_object_ref0 (_data1_->remove_button);
	result = _tmp3_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BuildToolDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->up_button);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
__lambda98_ (Block2Data* _data2_)
{
	BuildToolDialog* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_ = 0;
	gint* _tmp7_;
	gint _tmp8_;
	self = _data2_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data2_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	if (g_list_length (_tmp1_) == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, FALSE);
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
		return;
	}
	_tmp2_ = selected_rows;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
	path_selected = _tmp4_;
	_tmp5_ = path_selected;
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_[0];
	row_num = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, row_num > 0);
	__vala_GtkTreePath_free0 (path_selected);
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
}

static void
___lambda98__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda98_ (self);
}

static void
__lambda99_ (Block2Data* _data2_)
{
	BuildToolDialog* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	self = _data2_->self;
	_tmp0_ = self->priv->_jobs_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	if (selected_row > 0) {
		GtkTreeIter iter_up = {0};
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter_selected;
		iter_up = _tmp3_;
		_tmp4_ = self->priv->_jobs_store;
		_tmp5_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp4_, &iter_up);
		if (_tmp5_) {
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter _tmp8_;
			_tmp6_ = self->priv->_jobs_store;
			_tmp7_ = iter_selected;
			_tmp8_ = iter_up;
			gtk_list_store_swap (_tmp6_, &_tmp7_, &_tmp8_);
			g_signal_emit_by_name (_data2_->select, "changed");
		}
	}
}

static void
___lambda99__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda99_ (self);
}

static GtkToolButton*
build_tool_dialog_get_up_button (BuildToolDialog* self)
{
	Block2Data* _data2_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data2_->up_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data2_->up_button, "go-up-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data2_->up_button, _ ("Move up"));
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, FALSE);
	_tmp1_ = self->priv->_jobs_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_data2_->select = _tmp2_;
	g_signal_connect_data (_data2_->select, "changed", (GCallback) ___lambda98__gtk_tree_selection_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_data (_data2_->up_button, "clicked", (GCallback) ___lambda99__gtk_tool_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data2_->up_button);
	result = _tmp3_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BuildToolDialog* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->down_button);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda100_ (Block3Data* _data3_)
{
	BuildToolDialog* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_ = 0;
	gint* _tmp7_;
	gint _tmp8_;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp9_;
	GtkTreeModel* _tmp10_;
	gint nb_rows = 0;
	GtkTreeModel* _tmp11_;
	self = _data3_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data3_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	if (g_list_length (_tmp1_) == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, FALSE);
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
		return;
	}
	_tmp2_ = selected_rows;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
	path_selected = _tmp4_;
	_tmp5_ = path_selected;
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_[0];
	row_num = _tmp8_;
	_tmp9_ = self->priv->_jobs_store;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp9_) : NULL);
	model = _tmp10_;
	_tmp11_ = model;
	nb_rows = gtk_tree_model_iter_n_children (_tmp11_, NULL);
	gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, row_num < (nb_rows - 1));
	_g_object_unref0 (model);
	__vala_GtkTreePath_free0 (path_selected);
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
}

static void
___lambda100__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
	__lambda100_ (self);
}

static void
__lambda101_ (Block3Data* _data3_)
{
	BuildToolDialog* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	self = _data3_->self;
	_tmp0_ = self->priv->_jobs_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	if (selected_row >= 0) {
		GtkTreeIter iter_down = {0};
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter_selected;
		iter_down = _tmp3_;
		_tmp4_ = self->priv->_jobs_store;
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter_down);
		if (_tmp5_) {
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter _tmp8_;
			_tmp6_ = self->priv->_jobs_store;
			_tmp7_ = iter_selected;
			_tmp8_ = iter_down;
			gtk_list_store_swap (_tmp6_, &_tmp7_, &_tmp8_);
			g_signal_emit_by_name (_data3_->select, "changed");
		}
	}
}

static void
___lambda101__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
	__lambda101_ (self);
}

static GtkToolButton*
build_tool_dialog_get_down_button (BuildToolDialog* self)
{
	Block3Data* _data3_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data3_->down_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data3_->down_button, "go-down-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data3_->down_button, _ ("Move down"));
	gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, FALSE);
	_tmp1_ = self->priv->_jobs_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_data3_->select = _tmp2_;
	g_signal_connect_data (_data3_->select, "changed", (GCallback) ___lambda100__gtk_tree_selection_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	g_signal_connect_data (_data3_->down_button, "clicked", (GCallback) ___lambda101__gtk_tool_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data3_->down_button);
	result = _tmp3_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

/*************************************************************************/
static void
build_tool_dialog_set_new_build_tool (BuildToolDialog* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkListStore* _tmp5_;
	GtkTreeView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry_label;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->_entry_desc;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->_entry_extensions;
	gtk_entry_set_text (_tmp2_, "");
	_tmp3_ = self->priv->_entry_files_to_open;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->_icons_combobox;
	gtk_combo_box_set_active (_tmp4_, 0);
	_tmp5_ = self->priv->_jobs_store;
	gtk_list_store_clear (_tmp5_);
	_tmp6_ = self->priv->_jobs_view;
	gtk_tree_view_columns_autosize (_tmp6_);
}

static void
build_tool_dialog_set_build_tool (BuildToolDialog* self,
                                  LatexilaBuildTool* build_tool)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	GtkEntry* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkEntry* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkEntry* _tmp17_;
	GtkComboBox* _tmp18_;
	GtkTreeIter iter = {0};
	gboolean ok = FALSE;
	GtkListStore* _tmp19_;
	GtkTreeIter _tmp20_ = {0};
	gboolean _tmp21_;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp22_;
	GtkTreeModel* _tmp23_;
	GtkListStore* _tmp37_;
	GList* _tmp38_;
	GtkTreeView* _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tool != NULL);
	g_object_get (build_tool, "label", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = self->priv->_entry_label;
	gtk_entry_set_text (_tmp4_, _tmp0_);
	_tmp6_ = latexila_build_tool_get_description (build_tool);
	_tmp5_ = _tmp6_;
	if (_tmp5_ == NULL) {
		_tmp5_ = "";
	}
	_tmp7_ = self->priv->_entry_desc;
	gtk_entry_set_text (_tmp7_, _tmp5_);
	g_object_get (build_tool, "extensions", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp8_ = _tmp10_;
	if (_tmp8_ == NULL) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("");
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = self->priv->_entry_extensions;
	gtk_entry_set_text (_tmp12_, _tmp8_);
	g_object_get (build_tool, "files-to-open", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	_tmp13_ = _tmp15_;
	if (_tmp13_ == NULL) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("");
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp16_;
	}
	_tmp17_ = self->priv->_entry_files_to_open;
	gtk_entry_set_text (_tmp17_, _tmp13_);
	_tmp18_ = self->priv->_icons_combobox;
	gtk_combo_box_set_active (_tmp18_, 0);
	_tmp19_ = self->priv->_icons_store;
	_tmp21_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp19_, &_tmp20_);
	iter = _tmp20_;
	ok = _tmp21_;
	g_return_if_fail (ok);
	_tmp22_ = self->priv->_icons_store;
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp22_) : NULL);
	model = _tmp23_;
	{
		gboolean _tmp24_ = FALSE;
		_tmp24_ = TRUE;
		while (TRUE) {
			gchar* icon_name = NULL;
			GtkTreeModel* _tmp27_;
			GtkTreeIter _tmp28_;
			gchar* _tmp29_ = NULL;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			if (!_tmp24_) {
				GtkListStore* _tmp25_;
				gboolean _tmp26_;
				_tmp25_ = self->priv->_icons_store;
				_tmp26_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp25_, &iter);
				if (!_tmp26_) {
					break;
				}
			}
			_tmp24_ = FALSE;
			_tmp27_ = model;
			_tmp28_ = iter;
			gtk_tree_model_get (_tmp27_, &_tmp28_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, &_tmp29_, -1);
			_g_free0 (icon_name);
			icon_name = _tmp29_;
			_tmp30_ = icon_name;
			g_object_get (build_tool, "icon", &_tmp31_, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strcmp0 (_tmp30_, _tmp33_) == 0;
			_g_free0 (_tmp33_);
			if (_tmp34_) {
				GtkComboBox* _tmp35_;
				GtkTreeIter _tmp36_;
				_tmp35_ = self->priv->_icons_combobox;
				_tmp36_ = iter;
				gtk_combo_box_set_active_iter (_tmp35_, &_tmp36_);
				_g_free0 (icon_name);
				break;
			}
			_g_free0 (icon_name);
		}
	}
	_tmp37_ = self->priv->_jobs_store;
	gtk_list_store_clear (_tmp37_);
	_tmp38_ = latexila_build_tool_get_jobs (build_tool);
	{
		GList* build_job_collection = NULL;
		GList* build_job_it = NULL;
		build_job_collection = _tmp38_;
		for (build_job_it = build_job_collection; build_job_it != NULL; build_job_it = build_job_it->next) {
			LatexilaBuildJob* _tmp39_;
			LatexilaBuildJob* build_job = NULL;
			_tmp39_ = _g_object_ref0 ((LatexilaBuildJob*) build_job_it->data);
			build_job = _tmp39_;
			{
				LatexilaBuildJob* _tmp40_;
				_tmp40_ = build_job;
				build_tool_dialog_add_build_job (self, _tmp40_);
				_g_object_unref0 (build_job);
			}
		}
	}
	_tmp41_ = self->priv->_jobs_view;
	gtk_tree_view_columns_autosize (_tmp41_);
	_g_object_unref0 (model);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp0_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static LatexilaBuildTool*
build_tool_dialog_retrieve_build_tool (BuildToolDialog* self)
{
	LatexilaBuildTool* tool = NULL;
	LatexilaBuildTool* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	GtkEntry* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	LatexilaBuildTool* _tmp13_;
	GtkEntry* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	LatexilaBuildTool* _tmp19_;
	GtkEntry* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp25_;
	GtkTreeIter _tmp26_ = {0};
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp27_;
	GtkTreeModel* _tmp28_;
	gchar* icon_name = NULL;
	GtkTreeModel* _tmp29_;
	GtkTreeIter _tmp30_;
	gchar* _tmp31_ = NULL;
	LatexilaBuildTool* _tmp32_;
	const gchar* _tmp33_;
	GtkListStore* _tmp34_;
	GtkTreeModel* _tmp35_;
	gboolean valid = FALSE;
	GtkListStore* _tmp36_;
	GtkTreeIter _tmp37_ = {0};
	gboolean _tmp38_;
	LatexilaBuildTool* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tool_new ();
	tool = _tmp0_;
	_tmp1_ = tool;
	_tmp2_ = self->priv->_entry_label;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	g_object_set (_tmp1_, "label", _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_tmp7_ = tool;
	_tmp8_ = self->priv->_entry_desc;
	_tmp9_ = gtk_entry_get_text (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_strip (_tmp10_);
	_tmp12_ = _tmp11_;
	g_object_set (_tmp7_, "description", _tmp12_, NULL);
	_g_free0 (_tmp12_);
	_tmp13_ = tool;
	_tmp14_ = self->priv->_entry_extensions;
	_tmp15_ = gtk_entry_get_text (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = string_strip (_tmp16_);
	_tmp18_ = _tmp17_;
	g_object_set (_tmp13_, "extensions", _tmp18_, NULL);
	_g_free0 (_tmp18_);
	_tmp19_ = tool;
	_tmp20_ = self->priv->_entry_files_to_open;
	_tmp21_ = gtk_entry_get_text (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = string_strip (_tmp22_);
	_tmp24_ = _tmp23_;
	g_object_set (_tmp19_, "files-to-open", _tmp24_, NULL);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->_icons_combobox;
	gtk_combo_box_get_active_iter (_tmp25_, &_tmp26_);
	iter = _tmp26_;
	_tmp27_ = self->priv->_icons_store;
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp27_) : NULL);
	model = _tmp28_;
	_tmp29_ = model;
	_tmp30_ = iter;
	gtk_tree_model_get (_tmp29_, &_tmp30_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, &_tmp31_, -1);
	_g_free0 (icon_name);
	icon_name = _tmp31_;
	_tmp32_ = tool;
	_tmp33_ = icon_name;
	g_object_set (_tmp32_, "icon", _tmp33_, NULL);
	_tmp34_ = self->priv->_jobs_store;
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp34_) : NULL);
	_g_object_unref0 (model);
	model = _tmp35_;
	_tmp36_ = self->priv->_jobs_store;
	_tmp38_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp36_, &_tmp37_);
	iter = _tmp37_;
	valid = _tmp38_;
	while (TRUE) {
		LatexilaBuildJob* job = NULL;
		LatexilaBuildJob* _tmp39_;
		gchar* command = NULL;
		gchar* post_processor_name = NULL;
		GtkTreeModel* _tmp40_;
		GtkTreeIter _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		LatexilaBuildJob* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		LatexilaPostProcessorType type = 0;
		const gchar* _tmp48_;
		LatexilaPostProcessorType _tmp49_ = 0;
		gboolean _tmp50_;
		LatexilaBuildTool* _tmp53_;
		LatexilaBuildJob* _tmp54_;
		GtkListStore* _tmp55_;
		gboolean _tmp56_;
		if (!valid) {
			break;
		}
		_tmp39_ = latexila_build_job_new ();
		job = _tmp39_;
		_tmp40_ = model;
		_tmp41_ = iter;
		gtk_tree_model_get (_tmp40_, &_tmp41_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, &_tmp42_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, &_tmp43_, -1);
		_g_free0 (command);
		command = _tmp42_;
		_g_free0 (post_processor_name);
		post_processor_name = _tmp43_;
		_tmp44_ = job;
		_tmp45_ = command;
		_tmp46_ = string_strip (_tmp45_);
		_tmp47_ = _tmp46_;
		g_object_set (_tmp44_, "command", _tmp47_, NULL);
		_g_free0 (_tmp47_);
		_tmp48_ = post_processor_name;
		_tmp50_ = latexila_post_processor_get_type_from_name (_tmp48_, &_tmp49_);
		type = _tmp49_;
		if (_tmp50_) {
			LatexilaBuildJob* _tmp51_;
			LatexilaPostProcessorType _tmp52_;
			_tmp51_ = job;
			_tmp52_ = type;
			g_object_set (_tmp51_, "post-processor-type", _tmp52_, NULL);
		}
		_tmp53_ = tool;
		_tmp54_ = job;
		latexila_build_tool_add_job (_tmp53_, _tmp54_);
		_tmp55_ = self->priv->_jobs_store;
		_tmp56_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp55_, &iter);
		valid = _tmp56_;
		_g_free0 (post_processor_name);
		_g_free0 (command);
		_g_object_unref0 (job);
	}
	result = tool;
	_g_free0 (icon_name);
	_g_object_unref0 (model);
	return result;
}

/*************************************************************************/
static void
build_tool_dialog_add_build_job (BuildToolDialog* self,
                                 LatexilaBuildJob* job)
{
	gchar* post_processor_name = NULL;
	LatexilaPostProcessorType _tmp0_;
	LatexilaPostProcessorType _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkTreeSelection* select = NULL;
	GtkTreeView* _tmp11_;
	GtkTreeSelection* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	g_object_get (job, "post-processor-type", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = latexila_post_processor_get_name_from_type (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	post_processor_name = _tmp3_;
	_tmp4_ = self->priv->_jobs_store;
	gtk_list_store_append (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	_tmp6_ = self->priv->_jobs_store;
	_tmp7_ = iter;
	g_object_get (job, "command", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	gtk_list_store_set (_tmp6_, &_tmp7_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp10_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, post_processor_name, -1);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->_jobs_view;
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
	select = _tmp12_;
	g_signal_emit_by_name (select, "changed");
	_g_free0 (post_processor_name);
}

/*************************************************************************/
static GtkGrid*
build_tool_dialog_get_main_grid (BuildToolDialog* self,
                                 gboolean editable)
{
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkGrid* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	main_grid = _tmp0_;
	gtk_grid_set_row_spacing (main_grid, (guint) 5);
	gtk_grid_set_column_spacing (main_grid, (guint) 5);
	_tmp1_ = build_tool_dialog_get_label_grid (self);
	_tmp2_ = _tmp1_;
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp2_, 0, 0, 1, 1);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = build_tool_dialog_get_desc_grid (self);
	_tmp4_ = _tmp3_;
	gtk_grid_attach (main_grid, _tmp4_, 1, 0, 1, 1);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = build_tool_dialog_get_extensions_grid (self);
	_tmp6_ = _tmp5_;
	gtk_grid_attach (main_grid, _tmp6_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = build_tool_dialog_get_icons_grid (self);
	_tmp8_ = _tmp7_;
	gtk_grid_attach (main_grid, _tmp8_, 1, 1, 1, 1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = build_tool_dialog_get_jobs_grid (self, editable);
	_tmp10_ = _tmp9_;
	gtk_grid_attach (main_grid, _tmp10_, 0, 2, 2, 1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = build_tool_dialog_get_files_to_open_grid (self);
	_tmp12_ = _tmp11_;
	gtk_grid_attach (main_grid, _tmp12_, 0, 3, 2, 1);
	_g_object_unref0 (_tmp12_);
	result = main_grid;
	return result;
}

static GtkGrid*
build_tool_dialog_get_label_grid (BuildToolDialog* self)
{
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* title = NULL;
	GtkLabel* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* arrow = NULL;
	GtkLabel* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkGrid* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_grid_set_row_spacing (grid, (guint) 6);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 6);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	title = _tmp1_;
	_tmp2_ = g_strconcat ("<b>", _ ("Label"), NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "</b>", NULL);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (title, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	gtk_widget_set_halign ((GtkWidget*) title, GTK_ALIGN_START);
	gtk_grid_attach (grid, (GtkWidget*) title, 0, 0, 1, 1);
	_tmp6_ = (GtkLabel*) gtk_label_new ("→");
	g_object_ref_sink (_tmp6_);
	arrow = _tmp6_;
	gtk_widget_set_tooltip_text ((GtkWidget*) arrow, _ ("You can select this arrow and copy/paste it!"));
	gtk_widget_set_halign ((GtkWidget*) arrow, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) arrow, TRUE);
	gtk_label_set_selectable (arrow, TRUE);
	gtk_grid_attach (grid, (GtkWidget*) arrow, 1, 0, 1, 1);
	gtk_widget_set_hexpand ((GtkWidget*) grid, FALSE);
	_tmp7_ = self->priv->_entry_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 12);
	_tmp8_ = self->priv->_entry_label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp8_, 0, 1, 2, 1);
	result = grid;
	_g_object_unref0 (arrow);
	_g_object_unref0 (title);
	return result;
}

static GtkWidget*
build_tool_dialog_get_desc_grid (BuildToolDialog* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_desc;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->_entry_desc;
	_tmp2_ = latexila_utils_get_dialog_component (_ ("Description"), (GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static GtkWidget*
build_tool_dialog_get_extensions_grid (BuildToolDialog* self)
{
	GtkEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkEntry* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_extensions;
	_tmp1_ = g_strconcat (_ ("File extensions for which the build tool can be executed."), "\n", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, _ ("The extensions are separated by spaces."), NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, _ ("If it is empty, all extensions are allowed."), NULL);
	_tmp8_ = _tmp7_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp9_ = self->priv->_entry_extensions;
	_tmp10_ = latexila_utils_get_dialog_component (_ ("Extensions"), (GtkWidget*) _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	result = _tmp11_;
	return result;
}

static GtkWidget*
build_tool_dialog_get_icons_grid (BuildToolDialog* self)
{
	GtkComboBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icons_combobox;
	_tmp1_ = latexila_utils_get_dialog_component (_ ("Icon"), (GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static GtkWidget*
build_tool_dialog_get_jobs_grid (BuildToolDialog* self,
                                 gboolean editable)
{
	GtkLabel* placeholders = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* placeholder_filename = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* placeholder_shortname = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkGrid* placeholders_grid = NULL;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	GtkGrid* _tmp16_;
	GtkLabel* _tmp17_;
	GtkGrid* _tmp18_;
	GtkLabel* _tmp19_;
	GtkGrid* _tmp20_;
	GtkLabel* _tmp21_;
	GtkTreeView* _tmp22_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkTreeView* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkBox* jobs_box = NULL;
	GtkBox* _tmp27_;
	GtkGrid* _tmp28_;
	GtkBox* _tmp29_;
	GtkGrid* _tmp30_;
	GtkBox* _tmp31_;
	GtkScrolledWindow* _tmp32_;
	GtkBox* _tmp59_;
	GtkWidget* _tmp60_;
	GtkWidget* _tmp61_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Placeholders:"));
	g_object_ref_sink (_tmp0_);
	placeholders = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("$filename");
	g_object_ref_sink (_tmp1_);
	placeholder_filename = _tmp1_;
	_tmp2_ = placeholder_filename;
	_tmp3_ = g_strconcat (_ ("The active document’s filename."), "\n", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, _ ("If the active document belongs to a project, the main file is chosen."), NULL);
	_tmp6_ = _tmp5_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = (GtkLabel*) gtk_label_new ("$shortname");
	g_object_ref_sink (_tmp7_);
	placeholder_shortname = _tmp7_;
	_tmp8_ = placeholder_shortname;
	_tmp9_ = g_strconcat (_ ("The active document’s filename without its extension."), "\n", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, _ ("If the active document belongs to a project, the main file is chosen."), NULL);
	_tmp12_ = _tmp11_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp13_);
	placeholders_grid = _tmp13_;
	_tmp14_ = placeholders_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp14_, GTK_ORIENTATION_HORIZONTAL);
	_tmp15_ = placeholders_grid;
	gtk_grid_set_column_spacing (_tmp15_, (guint) 10);
	_tmp16_ = placeholders_grid;
	_tmp17_ = placeholders;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = placeholders_grid;
	_tmp19_ = placeholder_filename;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = placeholders_grid;
	_tmp21_ = placeholder_shortname;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->_jobs_view;
	g_object_set ((GtkWidget*) _tmp22_, "expand", TRUE, NULL);
	_tmp23_ = self->priv->_jobs_view;
	_tmp24_ = utils_add_scrollbar ((GtkWidget*) _tmp23_);
	scrolled_window = _tmp24_;
	_tmp25_ = scrolled_window;
	gtk_widget_set_size_request ((GtkWidget*) _tmp25_, 600, 120);
	_tmp26_ = scrolled_window;
	gtk_scrolled_window_set_shadow_type (_tmp26_, GTK_SHADOW_IN);
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp27_);
	jobs_box = _tmp27_;
	_tmp28_ = placeholders_grid;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp28_, 8);
	_tmp29_ = jobs_box;
	_tmp30_ = placeholders_grid;
	gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, FALSE, TRUE, (guint) 0);
	_tmp31_ = jobs_box;
	_tmp32_ = scrolled_window;
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, TRUE, TRUE, (guint) 0);
	if (editable) {
		GtkToolbar* toolbar = NULL;
		GtkToolbar* _tmp33_;
		GtkToolbar* _tmp34_;
		GtkToolButton* _tmp35_;
		GtkToolButton* _tmp36_;
		GtkToolbar* _tmp37_;
		GtkToolButton* _tmp38_;
		GtkToolButton* _tmp39_;
		GtkToolbar* _tmp40_;
		GtkToolButton* _tmp41_;
		GtkToolButton* _tmp42_;
		GtkToolbar* _tmp43_;
		GtkToolButton* _tmp44_;
		GtkToolButton* _tmp45_;
		GtkToolbar* _tmp46_;
		GtkToolbar* _tmp47_;
		GtkBox* _tmp48_;
		GtkToolbar* _tmp49_;
		GtkStyleContext* context = NULL;
		GtkScrolledWindow* _tmp50_;
		GtkStyleContext* _tmp51_;
		GtkStyleContext* _tmp52_;
		GtkStyleContext* _tmp53_;
		GtkToolbar* _tmp54_;
		GtkStyleContext* _tmp55_;
		GtkStyleContext* _tmp56_;
		GtkStyleContext* _tmp57_;
		GtkStyleContext* _tmp58_;
		_tmp33_ = (GtkToolbar*) gtk_toolbar_new ();
		g_object_ref_sink (_tmp33_);
		toolbar = _tmp33_;
		_tmp34_ = toolbar;
		_tmp35_ = build_tool_dialog_get_add_button (self);
		_tmp36_ = _tmp35_;
		gtk_toolbar_insert (_tmp34_, (GtkToolItem*) _tmp36_, -1);
		_g_object_unref0 (_tmp36_);
		_tmp37_ = toolbar;
		_tmp38_ = build_tool_dialog_get_remove_button (self);
		_tmp39_ = _tmp38_;
		gtk_toolbar_insert (_tmp37_, (GtkToolItem*) _tmp39_, -1);
		_g_object_unref0 (_tmp39_);
		_tmp40_ = toolbar;
		_tmp41_ = build_tool_dialog_get_up_button (self);
		_tmp42_ = _tmp41_;
		gtk_toolbar_insert (_tmp40_, (GtkToolItem*) _tmp42_, -1);
		_g_object_unref0 (_tmp42_);
		_tmp43_ = toolbar;
		_tmp44_ = build_tool_dialog_get_down_button (self);
		_tmp45_ = _tmp44_;
		gtk_toolbar_insert (_tmp43_, (GtkToolItem*) _tmp45_, -1);
		_g_object_unref0 (_tmp45_);
		_tmp46_ = toolbar;
		gtk_toolbar_set_icon_size (_tmp46_, GTK_ICON_SIZE_MENU);
		_tmp47_ = toolbar;
		gtk_toolbar_set_style (_tmp47_, GTK_TOOLBAR_ICONS);
		_tmp48_ = jobs_box;
		_tmp49_ = toolbar;
		gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, FALSE, TRUE, (guint) 0);
		_tmp50_ = scrolled_window;
		_tmp51_ = gtk_widget_get_style_context ((GtkWidget*) _tmp50_);
		_tmp52_ = _g_object_ref0 (_tmp51_);
		context = _tmp52_;
		_tmp53_ = context;
		gtk_style_context_set_junction_sides (_tmp53_, GTK_JUNCTION_BOTTOM);
		_tmp54_ = toolbar;
		_tmp55_ = gtk_widget_get_style_context ((GtkWidget*) _tmp54_);
		_tmp56_ = _g_object_ref0 (_tmp55_);
		_g_object_unref0 (context);
		context = _tmp56_;
		_tmp57_ = context;
		gtk_style_context_add_class (_tmp57_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
		_tmp58_ = context;
		gtk_style_context_set_junction_sides (_tmp58_, GTK_JUNCTION_TOP);
		_g_object_unref0 (context);
		_g_object_unref0 (toolbar);
	}
	_tmp59_ = jobs_box;
	_tmp60_ = latexila_utils_get_dialog_component (_ ("Jobs"), (GtkWidget*) _tmp59_);
	_tmp61_ = _g_object_ref0 (_tmp60_);
	result = _tmp61_;
	_g_object_unref0 (jobs_box);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (placeholders_grid);
	_g_object_unref0 (placeholder_shortname);
	_g_object_unref0 (placeholder_filename);
	_g_object_unref0 (placeholders);
	return result;
}

static GtkWidget*
build_tool_dialog_get_files_to_open_grid (BuildToolDialog* self)
{
	GtkEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_files_to_open;
	_tmp1_ = g_strconcat (_ ("List of files to open after executing the build jobs."), "\n", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, _ ("The files are separated by spaces."), NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, _ ("You should use the placeholders to specify the files."), NULL);
	_tmp8_ = _tmp7_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp9_ = self->priv->_entry_files_to_open;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = self->priv->_entry_files_to_open;
	_tmp11_ = latexila_utils_get_dialog_component (_ ("Files to open"), (GtkWidget*) _tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	result = _tmp12_;
	return result;
}

static void
build_tool_dialog_class_init (BuildToolDialogClass * klass,
                              gpointer klass_data)
{
	build_tool_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BuildToolDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = build_tool_dialog_finalize;
}

static void
build_tool_dialog_instance_init (BuildToolDialog * self,
                                 gpointer klass)
{
	self->priv = build_tool_dialog_get_instance_private (self);
}

static void
build_tool_dialog_finalize (GObject * obj)
{
	BuildToolDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOL_DIALOG, BuildToolDialog);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_entry_label);
	_g_object_unref0 (self->priv->_entry_desc);
	_g_object_unref0 (self->priv->_entry_extensions);
	_g_object_unref0 (self->priv->_entry_files_to_open);
	_g_object_unref0 (self->priv->_icons_store);
	_g_object_unref0 (self->priv->_icons_combobox);
	_g_object_unref0 (self->priv->_jobs_store);
	_g_object_unref0 (self->priv->_jobs_view);
	G_OBJECT_CLASS (build_tool_dialog_parent_class)->finalize (obj);
}

static GType
build_tool_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BuildToolDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolDialog), 0, (GInstanceInitFunc) build_tool_dialog_instance_init, NULL };
	GType build_tool_dialog_type_id;
	build_tool_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolDialog", &g_define_type_info, 0);
	BuildToolDialog_private_offset = g_type_add_instance_private (build_tool_dialog_type_id, sizeof (BuildToolDialogPrivate));
	return build_tool_dialog_type_id;
}

GType
build_tool_dialog_get_type (void)
{
	static volatile gsize build_tool_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_type_id__volatile)) {
		GType build_tool_dialog_type_id;
		build_tool_dialog_type_id = build_tool_dialog_get_type_once ();
		g_once_init_leave (&build_tool_dialog_type_id__volatile, build_tool_dialog_type_id);
	}
	return build_tool_dialog_type_id__volatile;
}

