/* app_settings.c generated by valac 0.48.10, the Vala compiler
 * generated from app_settings.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <tepl/tepl.h>
#include <latexila.h>

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _AppSettingsPrivate AppSettingsPrivate;
enum  {
	APP_SETTINGS_0_PROPERTY,
	APP_SETTINGS_SYSTEM_FONT_PROPERTY,
	APP_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* app_settings_properties[APP_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

struct _AppSettings {
	GSettings parent_instance;
	AppSettingsPrivate * priv;
};

struct _AppSettingsClass {
	GSettingsClass parent_class;
};

struct _AppSettingsPrivate {
	GSettings* editor;
	gchar* _system_font;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

static gint AppSettings_private_offset;
static gpointer app_settings_parent_class = NULL;
static AppSettings* app_settings_instance;
static AppSettings* app_settings_instance = NULL;

GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
static AppSettings* app_settings_new (void);
static AppSettings* app_settings_construct (GType object_type);
static void app_settings_initialize (AppSettings* self);
AppSettings* app_settings_get_default (void);
static void app_settings_set_system_font (AppSettings* self,
                                   const gchar* value);
static void __lambda4_ (AppSettings* self,
                 GSettings* setting,
                 const gchar* key);
static void app_settings_set_font (AppSettings* self,
                            const gchar* font);
const gchar* app_settings_get_system_font (AppSettings* self);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda114_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda114__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda115_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda115__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda116_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
GeeList* glatex_app_get_documents (GlatexApp* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
void document_tab_set_auto_save (DocumentTab* self,
                                 gboolean value);
static void ___lambda116__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda117_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
void document_tab_set_auto_save_interval (DocumentTab* self,
                                          guint value);
static void ___lambda117__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
GeeList* glatex_app_get_views (GlatexApp* self);
void document_view_set_font_from_string (DocumentView* self,
                                         const gchar* font);
static void app_settings_finalize (GObject * obj);
static GType app_settings_get_type_once (void);
static void _vala_app_settings_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_app_settings_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
app_settings_get_instance_private (AppSettings* self)
{
	return G_STRUCT_MEMBER_P (self, AppSettings_private_offset);
}

static AppSettings*
app_settings_construct (GType object_type)
{
	AppSettings * self = NULL;
	self = (AppSettings*) g_object_new (object_type, "schema-id", "org.gnome.gnome-latex", NULL);
	app_settings_initialize (self);
	return self;
}

static AppSettings*
app_settings_new (void)
{
	return app_settings_construct (TYPE_APP_SETTINGS);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AppSettings*
app_settings_get_default (void)
{
	AppSettings* _tmp0_;
	AppSettings* _tmp2_;
	AppSettings* _tmp3_;
	AppSettings* result = NULL;
	_tmp0_ = app_settings_instance;
	if (_tmp0_ == NULL) {
		AppSettings* _tmp1_;
		_tmp1_ = app_settings_new ();
		_g_object_unref0 (app_settings_instance);
		app_settings_instance = _tmp1_;
	}
	_tmp2_ = app_settings_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
__lambda4_ (AppSettings* self,
            GSettings* setting,
            const gchar* key)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_string (setting, key);
	_tmp1_ = _tmp0_;
	app_settings_set_system_font (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->editor;
	if (g_settings_get_boolean (_tmp2_, "use-default-font")) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_system_font;
		app_settings_set_font (self, _tmp3_);
	}
}

static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda4_ ((AppSettings*) self, _sender, key);
}

static void
__lambda114_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* font = NULL;
	gchar* _tmp5_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	if (val) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_system_font;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GSettings* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->editor;
		_tmp4_ = g_settings_get_string (_tmp3_, "editor-font");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp0_);
	font = _tmp5_;
	app_settings_set_font (self, font);
	_g_free0 (font);
	_g_free0 (_tmp0_);
}

static void
___lambda114__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	__lambda114_ ((AppSettings*) self, _sender, key);
}

static void
__lambda115_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->editor;
	if (g_settings_get_boolean (_tmp0_, "use-default-font")) {
		return;
	}
	_tmp1_ = g_settings_get_string (setting, key);
	_tmp2_ = _tmp1_;
	app_settings_set_font (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
___lambda115__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	__lambda115_ ((AppSettings*) self, _sender, key);
}

static void
__lambda116_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _doc_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _doc_index = 0;
		_tmp0_ = glatex_app_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = glatex_app_get_documents (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_doc_list = _tmp3_;
		_tmp4_ = _doc_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_doc_size = _tmp6_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Document* doc = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			Document* _tmp11_;
			DocumentTab* _tmp12_;
			_doc_index = _doc_index + 1;
			_tmp7_ = _doc_index;
			_tmp8_ = _doc_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _doc_list;
			_tmp10_ = gee_list_get (_tmp9_, _doc_index);
			doc = (Document*) _tmp10_;
			_tmp11_ = doc;
			_tmp12_ = _tmp11_->tab;
			document_tab_set_auto_save (_tmp12_, val);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
}

static void
___lambda116__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	__lambda116_ ((AppSettings*) self, _sender, key);
}

static void
__lambda117_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	guint val = 0U;
	guint _tmp0_ = 0U;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_settings_get (setting, key, "u", &_tmp0_);
	val = _tmp0_;
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp1_;
		GlatexApp* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _doc_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _doc_index = 0;
		_tmp1_ = glatex_app_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = glatex_app_get_documents (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_doc_list = _tmp4_;
		_tmp5_ = _doc_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_doc_size = _tmp7_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			Document* doc = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			Document* _tmp12_;
			DocumentTab* _tmp13_;
			_doc_index = _doc_index + 1;
			_tmp8_ = _doc_index;
			_tmp9_ = _doc_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _doc_list;
			_tmp11_ = gee_list_get (_tmp10_, _doc_index);
			doc = (Document*) _tmp11_;
			_tmp12_ = doc;
			_tmp13_ = _tmp12_->tab;
			document_tab_set_auto_save_interval (_tmp13_, val);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
}

static void
___lambda117__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	__lambda117_ ((AppSettings*) self, _sender, key);
}

static void
app_settings_initialize (AppSettings* self)
{
	GSettings* prefs = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* desktop_interface = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_get_child ((GSettings*) self, "preferences");
	prefs = _tmp0_;
	_tmp1_ = g_settings_get_child (prefs, "editor");
	_g_object_unref0 (self->priv->editor);
	self->priv->editor = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.desktop.interface");
	desktop_interface = _tmp2_;
	_tmp3_ = g_settings_get_string (desktop_interface, "monospace-font-name");
	_tmp4_ = _tmp3_;
	app_settings_set_system_font (self, _tmp4_);
	_g_free0 (_tmp4_);
	g_signal_connect_object (desktop_interface, "changed::monospace-font-name", (GCallback) ___lambda4__g_settings_changed, self, 0);
	_tmp5_ = self->priv->editor;
	g_signal_connect_object (_tmp5_, "changed::use-default-font", (GCallback) ___lambda114__g_settings_changed, self, 0);
	_tmp6_ = self->priv->editor;
	g_signal_connect_object (_tmp6_, "changed::editor-font", (GCallback) ___lambda115__g_settings_changed, self, 0);
	_tmp7_ = self->priv->editor;
	g_signal_connect_object (_tmp7_, "changed::auto-save", (GCallback) ___lambda116__g_settings_changed, self, 0);
	_tmp8_ = self->priv->editor;
	g_signal_connect_object (_tmp8_, "changed::auto-save-interval", (GCallback) ___lambda117__g_settings_changed, self, 0);
	_g_object_unref0 (desktop_interface);
	_g_object_unref0 (prefs);
}

static void
app_settings_set_font (AppSettings* self,
                       const gchar* font)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
		_tmp0_ = glatex_app_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = glatex_app_get_views (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_view_list = _tmp3_;
		_tmp4_ = _view_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_view_size = _tmp6_;
		_view_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			DocumentView* view = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			DocumentView* _tmp11_;
			_view_index = _view_index + 1;
			_tmp7_ = _view_index;
			_tmp8_ = _view_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _view_list;
			_tmp10_ = gee_list_get (_tmp9_, _view_index);
			view = (DocumentView*) _tmp10_;
			_tmp11_ = view;
			document_view_set_font_from_string (_tmp11_, font);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_list);
	}
}

const gchar*
app_settings_get_system_font (AppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_system_font;
	result = _tmp0_;
	return result;
}

static void
app_settings_set_system_font (AppSettings* self,
                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, app_settings_get_system_font (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_system_font);
		self->priv->_system_font = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, app_settings_properties[APP_SETTINGS_SYSTEM_FONT_PROPERTY]);
	}
}

static void
app_settings_class_init (AppSettingsClass * klass,
                         gpointer klass_data)
{
	app_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AppSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_app_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_app_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = app_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_SYSTEM_FONT_PROPERTY, app_settings_properties[APP_SETTINGS_SYSTEM_FONT_PROPERTY] = g_param_spec_string ("system-font", "system-font", "system-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
app_settings_instance_init (AppSettings * self,
                            gpointer klass)
{
	self->priv = app_settings_get_instance_private (self);
}

static void
app_settings_finalize (GObject * obj)
{
	AppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_SETTINGS, AppSettings);
	_g_object_unref0 (self->priv->editor);
	_g_free0 (self->priv->_system_font);
	G_OBJECT_CLASS (app_settings_parent_class)->finalize (obj);
}

static GType
app_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppSettings), 0, (GInstanceInitFunc) app_settings_instance_init, NULL };
	GType app_settings_type_id;
	app_settings_type_id = g_type_register_static (g_settings_get_type (), "AppSettings", &g_define_type_info, 0);
	AppSettings_private_offset = g_type_add_instance_private (app_settings_type_id, sizeof (AppSettingsPrivate));
	return app_settings_type_id;
}

GType
app_settings_get_type (void)
{
	static volatile gsize app_settings_type_id__volatile = 0;
	if (g_once_init_enter (&app_settings_type_id__volatile)) {
		GType app_settings_type_id;
		app_settings_type_id = app_settings_get_type_once ();
		g_once_init_leave (&app_settings_type_id__volatile, app_settings_type_id);
	}
	return app_settings_type_id__volatile;
}

static void
_vala_app_settings_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	AppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_SETTINGS, AppSettings);
	switch (property_id) {
		case APP_SETTINGS_SYSTEM_FONT_PROPERTY:
		g_value_set_string (value, app_settings_get_system_font (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_app_settings_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	AppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_SETTINGS, AppSettings);
	switch (property_id) {
		case APP_SETTINGS_SYSTEM_FONT_PROPERTY:
		app_settings_set_system_font (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

