gnome-latex.next
================

What would a gnome-latex.next project look like? (Apart from porting to the
latest major version of GTK). Note, there are currently no plans in gnome-latex
to work on these items.

Misc
----

- Ideally the project should be renamed again (I think), to something like
  GTeXedit or something else, but still retaining the internal "code project" to
  gnome-latex (like Videos/Totem).

General notes
-------------

I wrote the Vala code when I was a beginner, so some parts may be ugly and not
well implemented. The liblatexila, written in C, is much better implemented (in
my humble opinion).

Build tools
-----------

For the build tools, parsing the commands output is quite fragile, especially
the output of latexmk. And the latex post-processor is full of heuristics, some
warning/error messages are not extracted correctly. With retrospection, it was
a bad idea to implement it like that. To have a more robust implementation, it
would have been better to parse the log file and have a
[log viewer](https://gitlab.gnome.org/Archive/gnome-latex/-/issues/30).

In general for my other projects I now try to avoid implementing features that
have a fragile implementation (i.e. something not based on stable APIs, or with
heuristics, etc).

For gnome-latex, if the build tools break in the future, a solution is to
create a container with an older version of TeX Live bundled (or at least an
older version of latexmk bundled).

And, probably a lot of gnome-latex users anyway prefer to build the files
outside of the application, in a terminal.

AST
---

For the file structure in the side panel, a better implementation would be to
maintain an AST (Abstract Syntax Tree) attached to the GtkSourceBuffer, and by
using GtkSourceRegion. Then this AST can serve for other features, especially
for the auto-completion, or for text folding. For a project with multiple
`*.tex` files, the AST can be created for files not yet opened in the
application; this would be useful to provide completion for the `\ref`,
`\pageref` and `\cite` commands.

See also the Proposal 2
[here](https://wiki.gnome.org/Projects/GtkSourceView/CodeFolding).
