/* document_tab.c generated by valac 0.48.6, the Vala compiler
 * generated from document_tab.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
typedef struct _DocumentTabPrivate DocumentTabPrivate;
enum  {
	DOCUMENT_TAB_0_PROPERTY,
	DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY,
	DOCUMENT_TAB_DOCUMENT_PROPERTY,
	DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY,
	DOCUMENT_TAB_AUTO_SAVE_PROPERTY,
	DOCUMENT_TAB_NUM_PROPERTIES
};
static GParamSpec* document_tab_properties[DOCUMENT_TAB_NUM_PROPERTIES];

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DocumentPrivate DocumentPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block14Data Block14Data;

struct _DocumentTab {
	TeplTab parent_instance;
	DocumentTabPrivate * priv;
};

struct _DocumentTabClass {
	TeplTabClass parent_class;
};

struct _DocumentTabPrivate {
	gboolean ask_if_externally_modified;
	guint auto_save_timeout;
	guint _auto_save_interval;
	gboolean _auto_save;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _Block14Data {
	int _ref_count_;
	DocumentTab* self;
	TeplInfoBar* infobar;
};

static gint DocumentTab_private_offset;
static gpointer document_tab_parent_class = NULL;

GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
Document* document_new (void);
Document* document_construct (GType object_type);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type,
                                       Document* doc);
static void document_tab_initialize (DocumentTab* self);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type,
                                                   GFile* location);
Document* document_tab_get_document (DocumentTab* self);
void document_load (Document* self,
                    GFile* location);
DocumentTab* document_tab_new_with_view (DocumentView* document_view);
DocumentTab* document_tab_construct_with_view (GType object_type,
                                               DocumentView* document_view);
DocumentView* document_tab_get_document_view (DocumentTab* self);
static gboolean document_tab_view_focused_in (DocumentTab* self);
static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                  GdkEventFocus* event,
                                                                  gpointer self);
TeplView* tepl_tab_get_view (TeplTab* self);
void document_tab_set_auto_save (DocumentTab* self,
                                 gboolean value);
void document_tab_set_auto_save_interval (DocumentTab* self,
                                          guint value);
static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self);
static void __lambda21_ (DocumentTab* self);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
gchar* document_tab_get_menu_tip (DocumentTab* self);
gchar* document_get_uri_for_display (Document* self);
gboolean document_is_externally_modified (Document* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
GFile* document_get_location (Document* self);
static void ___lambda20_ (Block14Data* _data14_,
                   gint response_id);
static void ____lambda20__gtk_info_bar_response (GtkInfoBar* _sender,
                                          gint response_id,
                                          gpointer self);
static void document_tab_install_auto_save_timeout (DocumentTab* self);
gboolean document_tab_get_auto_save (DocumentTab* self);
guint document_tab_get_auto_save_interval (DocumentTab* self);
static gboolean document_tab_on_auto_save (DocumentTab* self);
static gboolean _document_tab_on_auto_save_gsource_func (gpointer self);
gboolean document_get_readonly (Document* self);
static void document_tab_remove_auto_save_timeout (DocumentTab* self);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
static void document_tab_finalize (GObject * obj);
static GType document_tab_get_type_once (void);
static void _vala_document_tab_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_document_tab_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
document_tab_get_instance_private (DocumentTab* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentTab_private_offset);
}

DocumentTab*
document_tab_construct (GType object_type)
{
	DocumentTab * self = NULL;
	DocumentView* document_view = NULL;
	Document* _tmp0_;
	Document* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 103 "document_tab.vala"
	_tmp0_ = document_new ();
#line 103 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 103 "document_tab.vala"
	_tmp2_ = document_view_new (_tmp1_);
#line 103 "document_tab.vala"
	g_object_ref_sink (_tmp2_);
#line 103 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 103 "document_tab.vala"
	_g_object_unref0 (_tmp1_);
#line 103 "document_tab.vala"
	document_view = _tmp3_;
#line 104 "document_tab.vala"
	self = (DocumentTab*) g_object_new (object_type, "view", document_view, NULL);
#line 105 "document_tab.vala"
	document_tab_initialize (self);
#line 101 "document_tab.vala"
	_g_object_unref0 (document_view);
#line 101 "document_tab.vala"
	return self;
#line 220 "document_tab.c"
}

DocumentTab*
document_tab_new (void)
{
#line 101 "document_tab.vala"
	return document_tab_construct (TYPE_DOCUMENT_TAB);
#line 228 "document_tab.c"
}

DocumentTab*
document_tab_construct_from_location (GType object_type,
                                      GFile* location)
{
	DocumentTab * self = NULL;
	Document* _tmp0_;
	Document* _tmp1_;
#line 108 "document_tab.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 110 "document_tab.vala"
	self = (DocumentTab*) document_tab_construct (object_type);
#line 111 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 111 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 111 "document_tab.vala"
	document_load (_tmp1_, location);
#line 108 "document_tab.vala"
	return self;
#line 250 "document_tab.c"
}

DocumentTab*
document_tab_new_from_location (GFile* location)
{
#line 108 "document_tab.vala"
	return document_tab_construct_from_location (TYPE_DOCUMENT_TAB, location);
#line 258 "document_tab.c"
}

DocumentTab*
document_tab_construct_with_view (GType object_type,
                                  DocumentView* document_view)
{
	DocumentTab * self = NULL;
#line 114 "document_tab.vala"
	g_return_val_if_fail (document_view != NULL, NULL);
#line 116 "document_tab.vala"
	self = (DocumentTab*) g_object_new (object_type, "view", document_view, NULL);
#line 117 "document_tab.vala"
	document_tab_initialize (self);
#line 114 "document_tab.vala"
	return self;
#line 274 "document_tab.c"
}

DocumentTab*
document_tab_new_with_view (DocumentView* document_view)
{
#line 114 "document_tab.vala"
	return document_tab_construct_with_view (TYPE_DOCUMENT_TAB, document_view);
#line 282 "document_tab.c"
}

static gboolean
_document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                         GdkEventFocus* event,
                                                         gpointer self)
{
	gboolean result;
	result = document_tab_view_focused_in ((DocumentTab*) self);
#line 124 "document_tab.vala"
	return result;
#line 294 "document_tab.c"
}

static void
__lambda21_ (DocumentTab* self)
{
#line 140 "document_tab.vala"
	if (self->priv->auto_save_timeout <= ((guint) 0)) {
#line 141 "document_tab.vala"
		document_tab_install_auto_save_timeout_if_needed (self);
#line 304 "document_tab.c"
	}
}

static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 138 "document_tab.vala"
	__lambda21_ ((DocumentTab*) self);
#line 315 "document_tab.c"
}

static void
document_tab_initialize (DocumentTab* self)
{
	Document* _tmp0_;
	Document* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	TeplView* _tmp4_;
	TeplView* _tmp5_;
	GSettings* settings = NULL;
	GSettings* _tmp6_;
	guint tmp = 0U;
	guint _tmp7_ = 0U;
	Document* _tmp8_;
	Document* _tmp9_;
#line 120 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 122 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 122 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 122 "document_tab.vala"
	_tmp1_->tab = self;
#line 124 "document_tab.vala"
	_tmp2_ = document_tab_get_document_view (self);
#line 124 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 124 "document_tab.vala"
	g_signal_connect_object ((GtkWidget*) _tmp3_, "focus-in-event", (GCallback) _document_tab_view_focused_in_gtk_widget_focus_in_event, self, 0);
#line 126 "document_tab.vala"
	_tmp4_ = tepl_tab_get_view ((TeplTab*) self);
#line 126 "document_tab.vala"
	_tmp5_ = _tmp4_;
#line 126 "document_tab.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
#line 129 "document_tab.vala"
	_tmp6_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 129 "document_tab.vala"
	settings = _tmp6_;
#line 131 "document_tab.vala"
	document_tab_set_auto_save (self, g_settings_get_boolean (settings, "auto-save"));
#line 133 "document_tab.vala"
	g_settings_get (settings, "auto-save-interval", "u", &_tmp7_);
#line 133 "document_tab.vala"
	tmp = _tmp7_;
#line 134 "document_tab.vala"
	document_tab_set_auto_save_interval (self, tmp);
#line 136 "document_tab.vala"
	document_tab_install_auto_save_timeout_if_needed (self);
#line 138 "document_tab.vala"
	_tmp8_ = document_tab_get_document (self);
#line 138 "document_tab.vala"
	_tmp9_ = _tmp8_;
#line 138 "document_tab.vala"
	g_signal_connect_object ((GObject*) _tmp9_, "notify::location", (GCallback) ___lambda21__g_object_notify, self, 0);
#line 120 "document_tab.vala"
	_g_object_unref0 (settings);
#line 375 "document_tab.c"
}

gchar*
document_tab_get_menu_tip (DocumentTab* self)
{
	Document* _tmp0_;
	Document* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result = NULL;
#line 145 "document_tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 147 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 147 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 147 "document_tab.vala"
	_tmp2_ = document_get_uri_for_display (_tmp1_);
#line 147 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 147 "document_tab.vala"
	_tmp4_ = g_strdup_printf (_ ("Activate “%s”"), _tmp3_);
#line 147 "document_tab.vala"
	_tmp5_ = _tmp4_;
#line 147 "document_tab.vala"
	_g_free0 (_tmp3_);
#line 147 "document_tab.vala"
	result = _tmp5_;
#line 147 "document_tab.vala"
	return result;
#line 408 "document_tab.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 159 "document_tab.vala"
	return self ? g_object_ref (self) : NULL;
#line 416 "document_tab.c"
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
#line 165 "document_tab.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 165 "document_tab.vala"
	return _data14_;
#line 426 "document_tab.c"
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 165 "document_tab.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 436 "document_tab.c"
		DocumentTab* self;
#line 165 "document_tab.vala"
		self = _data14_->self;
#line 165 "document_tab.vala"
		_g_object_unref0 (_data14_->infobar);
#line 165 "document_tab.vala"
		_g_object_unref0 (self);
#line 165 "document_tab.vala"
		g_slice_free (Block14Data, _data14_);
#line 446 "document_tab.c"
	}
}

static void
___lambda20_ (Block14Data* _data14_,
              gint response_id)
{
	DocumentTab* self;
	TeplInfoBar* _tmp6_;
	DocumentView* _tmp7_;
	DocumentView* _tmp8_;
#line 174 "document_tab.vala"
	self = _data14_->self;
#line 176 "document_tab.vala"
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
#line 462 "document_tab.c"
		Document* _tmp0_;
		Document* _tmp1_;
		Document* _tmp2_;
		Document* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
#line 178 "document_tab.vala"
		_tmp0_ = document_tab_get_document (self);
#line 178 "document_tab.vala"
		_tmp1_ = _tmp0_;
#line 178 "document_tab.vala"
		_tmp2_ = document_tab_get_document (self);
#line 178 "document_tab.vala"
		_tmp3_ = _tmp2_;
#line 178 "document_tab.vala"
		_tmp4_ = document_get_location (_tmp3_);
#line 178 "document_tab.vala"
		_tmp5_ = _tmp4_;
#line 178 "document_tab.vala"
		document_load (_tmp1_, _tmp5_);
#line 179 "document_tab.vala"
		self->priv->ask_if_externally_modified = FALSE;
#line 485 "document_tab.c"
	}
#line 182 "document_tab.vala"
	_tmp6_ = _data14_->infobar;
#line 182 "document_tab.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
#line 183 "document_tab.vala"
	_tmp7_ = document_tab_get_document_view (self);
#line 183 "document_tab.vala"
	_tmp8_ = _tmp7_;
#line 183 "document_tab.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
#line 497 "document_tab.c"
}

static void
____lambda20__gtk_info_bar_response (GtkInfoBar* _sender,
                                     gint response_id,
                                     gpointer self)
{
#line 174 "document_tab.vala"
	___lambda20_ (self, response_id);
#line 507 "document_tab.c"
}

static gboolean
document_tab_view_focused_in (DocumentTab* self)
{
	GFile* location = NULL;
	TeplBuffer* _tmp0_;
	TeplFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	gboolean result = FALSE;
#line 150 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "document_tab.vala"
	if (self->priv->ask_if_externally_modified) {
#line 156 "document_tab.vala"
		result = FALSE;
#line 156 "document_tab.vala"
		return result;
#line 531 "document_tab.c"
	}
#line 159 "document_tab.vala"
	_tmp0_ = tepl_tab_get_buffer ((TeplTab*) self);
#line 159 "document_tab.vala"
	_tmp1_ = tepl_buffer_get_file (_tmp0_);
#line 159 "document_tab.vala"
	_tmp2_ = tepl_file_get_location (_tmp1_);
#line 159 "document_tab.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 159 "document_tab.vala"
	location = _tmp3_;
#line 160 "document_tab.vala"
	_tmp4_ = location;
#line 160 "document_tab.vala"
	if (_tmp4_ == NULL) {
#line 161 "document_tab.vala"
		result = FALSE;
#line 161 "document_tab.vala"
		_g_object_unref0 (location);
#line 161 "document_tab.vala"
		return result;
#line 553 "document_tab.c"
	}
#line 162 "document_tab.vala"
	_tmp5_ = location;
#line 162 "document_tab.vala"
	if (!g_file_has_uri_scheme (_tmp5_, "file")) {
#line 163 "document_tab.vala"
		result = FALSE;
#line 163 "document_tab.vala"
		_g_object_unref0 (location);
#line 163 "document_tab.vala"
		return result;
#line 565 "document_tab.c"
	}
#line 165 "document_tab.vala"
	_tmp6_ = document_tab_get_document (self);
#line 165 "document_tab.vala"
	_tmp7_ = _tmp6_;
#line 165 "document_tab.vala"
	if (document_is_externally_modified (_tmp7_)) {
#line 573 "document_tab.c"
		Block14Data* _data14_;
		Document* _tmp8_;
		Document* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		Document* _tmp12_;
		Document* _tmp13_;
		TeplInfoBar* _tmp14_;
		TeplInfoBar* _tmp15_;
		TeplInfoBar* _tmp16_;
		TeplInfoBar* _tmp17_;
		TeplInfoBar* _tmp18_;
#line 165 "document_tab.vala"
		_data14_ = g_slice_new0 (Block14Data);
#line 165 "document_tab.vala"
		_data14_->_ref_count_ = 1;
#line 165 "document_tab.vala"
		_data14_->self = g_object_ref (self);
#line 167 "document_tab.vala"
		self->priv->ask_if_externally_modified = TRUE;
#line 169 "document_tab.vala"
		_tmp8_ = document_tab_get_document (self);
#line 169 "document_tab.vala"
		_tmp9_ = _tmp8_;
#line 169 "document_tab.vala"
		_tmp10_ = document_get_location (_tmp9_);
#line 169 "document_tab.vala"
		_tmp11_ = _tmp10_;
#line 169 "document_tab.vala"
		_tmp12_ = document_tab_get_document (self);
#line 169 "document_tab.vala"
		_tmp13_ = _tmp12_;
#line 169 "document_tab.vala"
		_tmp14_ = tepl_io_error_info_bar_externally_modified (_tmp11_, gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp13_));
#line 169 "document_tab.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 169 "document_tab.vala"
		_data14_->infobar = _tmp15_;
#line 171 "document_tab.vala"
		_tmp16_ = _data14_->infobar;
#line 171 "document_tab.vala"
		tepl_tab_add_info_bar ((TeplTab*) self, (GtkInfoBar*) _tmp16_);
#line 172 "document_tab.vala"
		_tmp17_ = _data14_->infobar;
#line 172 "document_tab.vala"
		gtk_widget_show ((GtkWidget*) _tmp17_);
#line 174 "document_tab.vala"
		_tmp18_ = _data14_->infobar;
#line 174 "document_tab.vala"
		g_signal_connect_data ((GtkInfoBar*) _tmp18_, "response", (GCallback) ____lambda20__gtk_info_bar_response, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
#line 165 "document_tab.vala"
		block14_data_unref (_data14_);
#line 165 "document_tab.vala"
		_data14_ = NULL;
#line 628 "document_tab.c"
	}
#line 187 "document_tab.vala"
	result = FALSE;
#line 187 "document_tab.vala"
	_g_object_unref0 (location);
#line 187 "document_tab.vala"
	return result;
#line 636 "document_tab.c"
}

static gboolean
_document_tab_on_auto_save_gsource_func (gpointer self)
{
	gboolean result;
	result = document_tab_on_auto_save ((DocumentTab*) self);
#line 196 "document_tab.vala"
	return result;
#line 646 "document_tab.c"
}

static void
document_tab_install_auto_save_timeout (DocumentTab* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
#line 190 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 192 "document_tab.vala"
	g_return_if_fail (self->priv->auto_save_timeout <= ((guint) 0));
#line 193 "document_tab.vala"
	_tmp0_ = document_tab_get_auto_save (self);
#line 193 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 193 "document_tab.vala"
	g_return_if_fail (_tmp1_);
#line 194 "document_tab.vala"
	_tmp2_ = document_tab_get_auto_save_interval (self);
#line 194 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 194 "document_tab.vala"
	g_return_if_fail (_tmp3_ > ((guint) 0));
#line 196 "document_tab.vala"
	_tmp4_ = document_tab_get_auto_save_interval (self);
#line 196 "document_tab.vala"
	_tmp5_ = _tmp4_;
#line 196 "document_tab.vala"
	self->priv->auto_save_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp5_ * 60, _document_tab_on_auto_save_gsource_func, g_object_ref (self), g_object_unref);
#line 680 "document_tab.c"
}

static gboolean
document_tab_install_auto_save_timeout_if_needed (DocumentTab* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result = FALSE;
#line 199 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 201 "document_tab.vala"
	g_return_val_if_fail (self->priv->auto_save_timeout <= ((guint) 0), FALSE);
#line 203 "document_tab.vala"
	_tmp2_ = document_tab_get_auto_save (self);
#line 203 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 203 "document_tab.vala"
	if (_tmp3_) {
#line 701 "document_tab.c"
		Document* _tmp4_;
		Document* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
#line 203 "document_tab.vala"
		_tmp4_ = document_tab_get_document (self);
#line 203 "document_tab.vala"
		_tmp5_ = _tmp4_;
#line 203 "document_tab.vala"
		_tmp6_ = document_get_location (_tmp5_);
#line 203 "document_tab.vala"
		_tmp7_ = _tmp6_;
#line 203 "document_tab.vala"
		_tmp1_ = _tmp7_ != NULL;
#line 716 "document_tab.c"
	} else {
#line 203 "document_tab.vala"
		_tmp1_ = FALSE;
#line 720 "document_tab.c"
	}
#line 203 "document_tab.vala"
	if (_tmp1_) {
#line 724 "document_tab.c"
		Document* _tmp8_;
		Document* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
#line 203 "document_tab.vala"
		_tmp8_ = document_tab_get_document (self);
#line 203 "document_tab.vala"
		_tmp9_ = _tmp8_;
#line 203 "document_tab.vala"
		_tmp10_ = document_get_readonly (_tmp9_);
#line 203 "document_tab.vala"
		_tmp11_ = _tmp10_;
#line 203 "document_tab.vala"
		_tmp0_ = !_tmp11_;
#line 739 "document_tab.c"
	} else {
#line 203 "document_tab.vala"
		_tmp0_ = FALSE;
#line 743 "document_tab.c"
	}
#line 203 "document_tab.vala"
	if (_tmp0_) {
#line 205 "document_tab.vala"
		document_tab_install_auto_save_timeout (self);
#line 206 "document_tab.vala"
		result = TRUE;
#line 206 "document_tab.vala"
		return result;
#line 753 "document_tab.c"
	}
#line 209 "document_tab.vala"
	result = FALSE;
#line 209 "document_tab.vala"
	return result;
#line 759 "document_tab.c"
}

static void
document_tab_remove_auto_save_timeout (DocumentTab* self)
{
#line 212 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 214 "document_tab.vala"
	g_return_if_fail (self->priv->auto_save_timeout > ((guint) 0));
#line 216 "document_tab.vala"
	g_source_remove (self->priv->auto_save_timeout);
#line 217 "document_tab.vala"
	self->priv->auto_save_timeout = (guint) 0;
#line 773 "document_tab.c"
}

static gboolean
document_tab_on_auto_save (DocumentTab* self)
{
	Document* _tmp0_;
	Document* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	Document* _tmp12_;
	Document* _tmp13_;
	gboolean result = FALSE;
#line 220 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 222 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 222 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 222 "document_tab.vala"
	_tmp2_ = document_get_location (_tmp1_);
#line 222 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 222 "document_tab.vala"
	g_return_val_if_fail (_tmp3_ != NULL, FALSE);
#line 223 "document_tab.vala"
	_tmp4_ = document_tab_get_document (self);
#line 223 "document_tab.vala"
	_tmp5_ = _tmp4_;
#line 223 "document_tab.vala"
	_tmp6_ = document_get_readonly (_tmp5_);
#line 223 "document_tab.vala"
	_tmp7_ = _tmp6_;
#line 223 "document_tab.vala"
	g_return_val_if_fail (!_tmp7_, FALSE);
#line 224 "document_tab.vala"
	g_return_val_if_fail (self->priv->auto_save_timeout > ((guint) 0), FALSE);
#line 225 "document_tab.vala"
	_tmp8_ = document_tab_get_auto_save (self);
#line 225 "document_tab.vala"
	_tmp9_ = _tmp8_;
#line 225 "document_tab.vala"
	g_return_val_if_fail (_tmp9_, FALSE);
#line 226 "document_tab.vala"
	_tmp10_ = document_tab_get_auto_save_interval (self);
#line 226 "document_tab.vala"
	_tmp11_ = _tmp10_;
#line 226 "document_tab.vala"
	g_return_val_if_fail (_tmp11_ > ((guint) 0), FALSE);
#line 228 "document_tab.vala"
	_tmp12_ = document_tab_get_document (self);
#line 228 "document_tab.vala"
	_tmp13_ = _tmp12_;
#line 228 "document_tab.vala"
	if (gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp13_)) {
#line 836 "document_tab.c"
		Document* _tmp14_;
		Document* _tmp15_;
#line 229 "document_tab.vala"
		_tmp14_ = document_tab_get_document (self);
#line 229 "document_tab.vala"
		_tmp15_ = _tmp14_;
#line 229 "document_tab.vala"
		document_save (_tmp15_, TRUE, FALSE);
#line 845 "document_tab.c"
	}
#line 231 "document_tab.vala"
	result = TRUE;
#line 231 "document_tab.vala"
	return result;
#line 851 "document_tab.c"
}

DocumentView*
document_tab_get_document_view (DocumentTab* self)
{
	DocumentView* result;
	TeplView* _tmp0_;
#line 26 "document_tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "document_tab.vala"
	_tmp0_ = tepl_tab_get_view ((TeplTab*) self);
#line 26 "document_tab.vala"
	result = IS_DOCUMENT_VIEW (_tmp0_) ? ((DocumentView*) _tmp0_) : NULL;
#line 26 "document_tab.vala"
	return result;
#line 867 "document_tab.c"
}

Document*
document_tab_get_document (DocumentTab* self)
{
	Document* result;
	TeplBuffer* _tmp0_;
#line 31 "document_tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "document_tab.vala"
	_tmp0_ = tepl_tab_get_buffer ((TeplTab*) self);
#line 31 "document_tab.vala"
	result = IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL;
#line 31 "document_tab.vala"
	return result;
#line 883 "document_tab.c"
}

guint
document_tab_get_auto_save_interval (DocumentTab* self)
{
	guint result;
#line 41 "document_tab.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 43 "document_tab.vala"
	result = self->priv->_auto_save_interval;
#line 43 "document_tab.vala"
	return result;
#line 896 "document_tab.c"
}

void
document_tab_set_auto_save_interval (DocumentTab* self,
                                     guint value)
{
#line 46 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 48 "document_tab.vala"
	g_return_if_fail (value > ((guint) 0));
#line 50 "document_tab.vala"
	if (self->priv->_auto_save_interval == value) {
#line 51 "document_tab.vala"
		return;
#line 911 "document_tab.c"
	}
#line 53 "document_tab.vala"
	self->priv->_auto_save_interval = value;
#line 55 "document_tab.vala"
	if (!self->priv->_auto_save) {
#line 56 "document_tab.vala"
		return;
#line 919 "document_tab.c"
	}
#line 58 "document_tab.vala"
	if (self->priv->auto_save_timeout > ((guint) 0)) {
#line 923 "document_tab.c"
		Document* _tmp0_;
		Document* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		Document* _tmp4_;
		Document* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
#line 60 "document_tab.vala"
		_tmp0_ = document_tab_get_document (self);
#line 60 "document_tab.vala"
		_tmp1_ = _tmp0_;
#line 60 "document_tab.vala"
		_tmp2_ = document_get_location (_tmp1_);
#line 60 "document_tab.vala"
		_tmp3_ = _tmp2_;
#line 60 "document_tab.vala"
		g_return_if_fail (_tmp3_ != NULL);
#line 61 "document_tab.vala"
		_tmp4_ = document_tab_get_document (self);
#line 61 "document_tab.vala"
		_tmp5_ = _tmp4_;
#line 61 "document_tab.vala"
		_tmp6_ = document_get_readonly (_tmp5_);
#line 61 "document_tab.vala"
		_tmp7_ = _tmp6_;
#line 61 "document_tab.vala"
		g_return_if_fail (!_tmp7_);
#line 62 "document_tab.vala"
		document_tab_remove_auto_save_timeout (self);
#line 63 "document_tab.vala"
		document_tab_install_auto_save_timeout (self);
#line 956 "document_tab.c"
	}
#line 46 "document_tab.vala"
	g_object_notify_by_pspec ((GObject *) self, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY]);
#line 960 "document_tab.c"
}

gboolean
document_tab_get_auto_save (DocumentTab* self)
{
	gboolean result;
#line 71 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "document_tab.vala"
	result = self->priv->_auto_save;
#line 73 "document_tab.vala"
	return result;
#line 973 "document_tab.c"
}

void
document_tab_set_auto_save (DocumentTab* self,
                            gboolean value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
#line 76 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 78 "document_tab.vala"
	if (value == self->priv->_auto_save) {
#line 79 "document_tab.vala"
		return;
#line 993 "document_tab.c"
	}
#line 81 "document_tab.vala"
	self->priv->_auto_save = value;
#line 83 "document_tab.vala"
	if (self->priv->_auto_save) {
#line 83 "document_tab.vala"
		_tmp2_ = self->priv->auto_save_timeout <= ((guint) 0);
#line 1001 "document_tab.c"
	} else {
#line 83 "document_tab.vala"
		_tmp2_ = FALSE;
#line 1005 "document_tab.c"
	}
#line 83 "document_tab.vala"
	if (_tmp2_) {
#line 1009 "document_tab.c"
		Document* _tmp3_;
		Document* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 83 "document_tab.vala"
		_tmp3_ = document_tab_get_document (self);
#line 83 "document_tab.vala"
		_tmp4_ = _tmp3_;
#line 83 "document_tab.vala"
		_tmp5_ = document_get_location (_tmp4_);
#line 83 "document_tab.vala"
		_tmp6_ = _tmp5_;
#line 83 "document_tab.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 1024 "document_tab.c"
	} else {
#line 83 "document_tab.vala"
		_tmp1_ = FALSE;
#line 1028 "document_tab.c"
	}
#line 83 "document_tab.vala"
	if (_tmp1_) {
#line 1032 "document_tab.c"
		Document* _tmp7_;
		Document* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
#line 84 "document_tab.vala"
		_tmp7_ = document_tab_get_document (self);
#line 84 "document_tab.vala"
		_tmp8_ = _tmp7_;
#line 84 "document_tab.vala"
		_tmp9_ = document_get_readonly (_tmp8_);
#line 84 "document_tab.vala"
		_tmp10_ = _tmp9_;
#line 84 "document_tab.vala"
		_tmp0_ = !_tmp10_;
#line 1047 "document_tab.c"
	} else {
#line 83 "document_tab.vala"
		_tmp0_ = FALSE;
#line 1051 "document_tab.c"
	}
#line 83 "document_tab.vala"
	if (_tmp0_) {
#line 86 "document_tab.vala"
		document_tab_install_auto_save_timeout (self);
#line 87 "document_tab.vala"
		return;
#line 1059 "document_tab.c"
	}
#line 90 "document_tab.vala"
	if (!self->priv->_auto_save) {
#line 90 "document_tab.vala"
		_tmp11_ = self->priv->auto_save_timeout > ((guint) 0);
#line 1065 "document_tab.c"
	} else {
#line 90 "document_tab.vala"
		_tmp11_ = FALSE;
#line 1069 "document_tab.c"
	}
#line 90 "document_tab.vala"
	if (_tmp11_) {
#line 92 "document_tab.vala"
		document_tab_remove_auto_save_timeout (self);
#line 93 "document_tab.vala"
		return;
#line 1077 "document_tab.c"
	}
#line 96 "document_tab.vala"
	if (!self->priv->_auto_save) {
#line 96 "document_tab.vala"
		_tmp14_ = self->priv->auto_save_timeout <= ((guint) 0);
#line 1083 "document_tab.c"
	} else {
#line 96 "document_tab.vala"
		_tmp14_ = FALSE;
#line 1087 "document_tab.c"
	}
#line 96 "document_tab.vala"
	if (_tmp14_) {
#line 96 "document_tab.vala"
		_tmp13_ = TRUE;
#line 1093 "document_tab.c"
	} else {
		Document* _tmp15_;
		Document* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
#line 97 "document_tab.vala"
		_tmp15_ = document_tab_get_document (self);
#line 97 "document_tab.vala"
		_tmp16_ = _tmp15_;
#line 97 "document_tab.vala"
		_tmp17_ = document_get_location (_tmp16_);
#line 97 "document_tab.vala"
		_tmp18_ = _tmp17_;
#line 97 "document_tab.vala"
		_tmp13_ = _tmp18_ == NULL;
#line 1109 "document_tab.c"
	}
#line 96 "document_tab.vala"
	if (_tmp13_) {
#line 96 "document_tab.vala"
		_tmp12_ = TRUE;
#line 1115 "document_tab.c"
	} else {
		Document* _tmp19_;
		Document* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
#line 97 "document_tab.vala"
		_tmp19_ = document_tab_get_document (self);
#line 97 "document_tab.vala"
		_tmp20_ = _tmp19_;
#line 97 "document_tab.vala"
		_tmp21_ = document_get_readonly (_tmp20_);
#line 97 "document_tab.vala"
		_tmp22_ = _tmp21_;
#line 97 "document_tab.vala"
		_tmp12_ = _tmp22_;
#line 1131 "document_tab.c"
	}
#line 96 "document_tab.vala"
	g_return_if_fail (_tmp12_);
#line 76 "document_tab.vala"
	g_object_notify_by_pspec ((GObject *) self, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_PROPERTY]);
#line 1137 "document_tab.c"
}

static void
document_tab_class_init (DocumentTabClass * klass,
                         gpointer klass_data)
{
#line 22 "document_tab.vala"
	document_tab_parent_class = g_type_class_peek_parent (klass);
#line 22 "document_tab.vala"
	g_type_class_adjust_private_offset (klass, &DocumentTab_private_offset);
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_tab_get_property;
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_tab_set_property;
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (klass)->finalize = document_tab_finalize;
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY, document_tab_properties[DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY] = g_param_spec_object ("document-view", "document-view", "document-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_DOCUMENT_PROPERTY, document_tab_properties[DOCUMENT_TAB_DOCUMENT_PROPERTY] = g_param_spec_object ("document", "document", "document", TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY] = g_param_spec_uint ("auto-save-interval", "auto-save-interval", "auto-save-interval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE_PROPERTY, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_PROPERTY] = g_param_spec_boolean ("auto-save", "auto-save", "auto-save", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1162 "document_tab.c"
}

static void
document_tab_instance_init (DocumentTab * self,
                            gpointer klass)
{
#line 22 "document_tab.vala"
	self->priv = document_tab_get_instance_private (self);
#line 34 "document_tab.vala"
	self->priv->ask_if_externally_modified = FALSE;
#line 1173 "document_tab.c"
}

static void
document_tab_finalize (GObject * obj)
{
	DocumentTab * self;
#line 22 "document_tab.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_TAB, DocumentTab);
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (document_tab_parent_class)->finalize (obj);
#line 1184 "document_tab.c"
}

static GType
document_tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentTab), 0, (GInstanceInitFunc) document_tab_instance_init, NULL };
	GType document_tab_type_id;
	document_tab_type_id = g_type_register_static (tepl_tab_get_type (), "DocumentTab", &g_define_type_info, 0);
	DocumentTab_private_offset = g_type_add_instance_private (document_tab_type_id, sizeof (DocumentTabPrivate));
	return document_tab_type_id;
}

GType
document_tab_get_type (void)
{
	static volatile gsize document_tab_type_id__volatile = 0;
	if (g_once_init_enter (&document_tab_type_id__volatile)) {
		GType document_tab_type_id;
		document_tab_type_id = document_tab_get_type_once ();
		g_once_init_leave (&document_tab_type_id__volatile, document_tab_type_id);
	}
	return document_tab_type_id__volatile;
}

static void
_vala_document_tab_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	DocumentTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_TAB, DocumentTab);
#line 22 "document_tab.vala"
	switch (property_id) {
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_object (value, document_tab_get_document_view (self));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_DOCUMENT_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_object (value, document_tab_get_document (self));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_uint (value, document_tab_get_auto_save_interval (self));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_boolean (value, document_tab_get_auto_save (self));
#line 22 "document_tab.vala"
		break;
#line 1243 "document_tab.c"
		default:
#line 22 "document_tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document_tab.vala"
		break;
#line 1249 "document_tab.c"
	}
}

static void
_vala_document_tab_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	DocumentTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_TAB, DocumentTab);
#line 22 "document_tab.vala"
	switch (property_id) {
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY:
#line 22 "document_tab.vala"
		document_tab_set_auto_save_interval (self, g_value_get_uint (value));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_PROPERTY:
#line 22 "document_tab.vala"
		document_tab_set_auto_save (self, g_value_get_boolean (value));
#line 22 "document_tab.vala"
		break;
#line 1275 "document_tab.c"
		default:
#line 22 "document_tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document_tab.vala"
		break;
#line 1281 "document_tab.c"
	}
}

