/* search.c generated by valac 0.46.7, the Vala compiler
 * generated from search.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <gtksourceview/gtksource.h>

#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;
typedef struct _GotoLinePrivate GotoLinePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	GOTO_LINE_0_PROPERTY,
	GOTO_LINE_NUM_PROPERTIES
};
static GParamSpec* goto_line_properties[GOTO_LINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;
enum  {
	SEARCH_AND_REPLACE_0_PROPERTY,
	SEARCH_AND_REPLACE_NUM_PROPERTIES
};
static GParamSpec* search_and_replace_properties[SEARCH_AND_REPLACE_NUM_PROPERTIES];
typedef enum  {
	SEARCH_AND_REPLACE_MODE_SEARCH,
	SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE
} SearchAndReplaceMode;

#define SEARCH_AND_REPLACE_TYPE_MODE (search_and_replace_mode_get_type ())
typedef struct _Block29Data Block29Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block30Data Block30Data;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

struct _GotoLine {
	GtkGrid parent_instance;
	GotoLinePrivate * priv;
};

struct _GotoLineClass {
	GtkGridClass parent_class;
};

struct _GotoLinePrivate {
	MainWindow* main_window;
	GtkEntry* entry;
};

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* _main_window;
	GtkGrid* _main_grid;
	GtkGrid* _replace_grid;
	GtkArrow* _arrow;
	GtkSearchEntry* _entry_find;
	GtkSearchEntry* _entry_replace;
	GtkLabel* _info_label;
	GtkSourceSearchSettings* _search_settings;
	GtkSourceSearchContext* _search_context;
};

struct _Block29Data {
	int _ref_count_;
	SearchAndReplace* self;
	GtkButton* button_previous;
	GtkButton* button_next;
	GtkButton* button_replace;
	GtkButton* button_replace_all;
};

struct _Block30Data {
	int _ref_count_;
	SearchAndReplace* self;
	GtkMenu* menu;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

static gint GotoLine_private_offset;
static gpointer goto_line_parent_class = NULL;
static gint SearchAndReplace_private_offset;
static gpointer search_and_replace_parent_class = NULL;

GType goto_line_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GotoLine, g_object_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type,
                               MainWindow* main_window);
static void __lambda52_ (GotoLine* self);
static void ___lambda52__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda53_ (GotoLine* self);
static void ___lambda53__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda54_ (GotoLine* self);
static void ___lambda54__gtk_entry_icon_press (GtkEntry* _sender,
                                        GtkEntryIconPosition icon_pos,
                                        GdkEventButton* event,
                                        gpointer self);
static void goto_line_on_changed (GotoLine* self);
static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender,
                                                 gpointer self);
void goto_line_show (GotoLine* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* main_window_get_active_view (MainWindow* self);
static void goto_line_finalize (GObject * obj);
GType search_and_replace_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchAndReplace, g_object_unref)
static GType search_and_replace_mode_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SearchAndReplaceMode search_and_replace_get_mode (SearchAndReplace* self);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type,
                                                MainWindow* main_window);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void search_and_replace_init_find_entry (SearchAndReplace* self);
static GtkButton* search_and_replace_get_button (SearchAndReplace* self,
                                          const gchar* icon_name);
static void __lambda56_ (SearchAndReplace* self);
static void ___lambda56__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender,
                                                            gpointer self);
static void _search_and_replace_search_forward_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                     gpointer self);
static void search_and_replace_search_backward (SearchAndReplace* self);
static void _search_and_replace_search_backward_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _search_and_replace_search_backward_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                          gpointer self);
static void __lambda58_ (Block29Data* _data29_);
static void ___lambda58__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender,
                                                     gpointer self);
static void __lambda59_ (SearchAndReplace* self);
static void ___lambda59__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void _search_and_replace_hide_gtk_search_entry_stop_search (GtkSearchEntry* _sender,
                                                            gpointer self);
static gboolean __lambda60_ (SearchAndReplace* self,
                      GdkEventKey* event);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static gboolean ___lambda60__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void __lambda55_ (Block30Data* _data30_,
                  GtkEntryIconPosition icon_pos,
                  GdkEventButton* event);
static void ___lambda55__gtk_entry_icon_press (GtkEntry* _sender,
                                        GtkEntryIconPosition icon_pos,
                                        GdkEventButton* event,
                                        gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
Document* main_window_get_active_document (MainWindow* self);
static void search_and_replace_connect_active_document (SearchAndReplace* self);
static void _search_and_replace_connect_active_document_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void search_and_replace_destroy_search_context (SearchAndReplace* self);
static void search_and_replace_mark_set_cb (SearchAndReplace* self,
                                     GtkTextBuffer* buffer,
                                     GtkTextIter* location,
                                     GtkTextMark* mark);
static void _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender,
                                                               GtkTextIter* location,
                                                               GtkTextMark* mark,
                                                               gpointer self);
static void __lambda57_ (SearchAndReplace* self);
static void search_and_replace_update_info_label (SearchAndReplace* self);
static void ___lambda57__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
gboolean document_get_readonly (Document* self);
TeplView* tepl_tab_get_view (TeplTab* self);
static void search_and_replace_finalize (GObject * obj);

static inline gpointer
goto_line_get_instance_private (GotoLine* self)
{
	return G_STRUCT_MEMBER_P (self, GotoLine_private_offset);
}

static void
__lambda52_ (GotoLine* self)
{
#line 38 "search.vala"
	gtk_widget_hide ((GtkWidget*) self);
#line 310 "search.c"
}

static void
___lambda52__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 38 "search.vala"
	__lambda52_ ((GotoLine*) self);
#line 319 "search.c"
}

static void
__lambda53_ (GotoLine* self)
{
#line 52 "search.vala"
	gtk_widget_hide ((GtkWidget*) self);
#line 327 "search.c"
}

static void
___lambda53__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
#line 52 "search.vala"
	__lambda53_ ((GotoLine*) self);
#line 336 "search.c"
}

static void
__lambda54_ (GotoLine* self)
{
#line 53 "search.vala"
	gtk_widget_hide ((GtkWidget*) self);
#line 344 "search.c"
}

static void
___lambda54__gtk_entry_icon_press (GtkEntry* _sender,
                                   GtkEntryIconPosition icon_pos,
                                   GdkEventButton* event,
                                   gpointer self)
{
#line 53 "search.vala"
	__lambda54_ ((GotoLine*) self);
#line 355 "search.c"
}

static void
_goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender,
                                            gpointer self)
{
#line 54 "search.vala"
	goto_line_on_changed ((GotoLine*) self);
#line 364 "search.c"
}

GotoLine*
goto_line_construct (GType object_type,
                     MainWindow* main_window)
{
	GotoLine * self = NULL;
	GtkButton* close_button = NULL;
	GtkButton* _tmp0_;
	GtkImage* img = NULL;
	GtkImage* _tmp1_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GIcon* icon = NULL;
	GThemedIcon* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
#line 27 "search.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 27 "search.vala"
	self = (GotoLine*) g_object_new (object_type, NULL);
#line 29 "search.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
#line 30 "search.vala"
	gtk_grid_set_column_spacing ((GtkGrid*) self, (guint) 3);
#line 31 "search.vala"
	self->priv->main_window = main_window;
#line 33 "search.vala"
	_tmp0_ = (GtkButton*) gtk_button_new ();
#line 33 "search.vala"
	g_object_ref_sink (_tmp0_);
#line 33 "search.vala"
	close_button = _tmp0_;
#line 34 "search.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) close_button);
#line 35 "search.vala"
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
#line 36 "search.vala"
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("window-close", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 36 "search.vala"
	g_object_ref_sink (_tmp1_);
#line 36 "search.vala"
	img = _tmp1_;
#line 37 "search.vala"
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) img);
#line 38 "search.vala"
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda52__gtk_button_clicked, self, 0);
#line 40 "search.vala"
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Go to Line:"));
#line 40 "search.vala"
	g_object_ref_sink (_tmp2_);
#line 40 "search.vala"
	label = _tmp2_;
#line 41 "search.vala"
	gtk_widget_set_margin_start ((GtkWidget*) label, 2);
#line 42 "search.vala"
	gtk_widget_set_margin_end ((GtkWidget*) label, 2);
#line 43 "search.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) label);
#line 45 "search.vala"
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
#line 45 "search.vala"
	g_object_ref_sink (_tmp3_);
#line 45 "search.vala"
	_g_object_unref0 (self->priv->entry);
#line 45 "search.vala"
	self->priv->entry = _tmp3_;
#line 46 "search.vala"
	_tmp4_ = self->priv->entry;
#line 46 "search.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
#line 47 "search.vala"
	_tmp5_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("go-jump-symbolic");
#line 47 "search.vala"
	icon = (GIcon*) _tmp5_;
#line 48 "search.vala"
	_tmp6_ = self->priv->entry;
#line 48 "search.vala"
	gtk_entry_set_icon_from_gicon (_tmp6_, GTK_ENTRY_ICON_SECONDARY, icon);
#line 49 "search.vala"
	_tmp7_ = self->priv->entry;
#line 49 "search.vala"
	gtk_entry_set_icon_activatable (_tmp7_, GTK_ENTRY_ICON_SECONDARY, TRUE);
#line 50 "search.vala"
	_tmp8_ = self->priv->entry;
#line 50 "search.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _ ("Line you want to move the cursor to"));
#line 51 "search.vala"
	_tmp9_ = self->priv->entry;
#line 51 "search.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 100, -1);
#line 52 "search.vala"
	_tmp10_ = self->priv->entry;
#line 52 "search.vala"
	g_signal_connect_object (_tmp10_, "activate", (GCallback) ___lambda53__gtk_entry_activate, self, 0);
#line 53 "search.vala"
	_tmp11_ = self->priv->entry;
#line 53 "search.vala"
	g_signal_connect_object (_tmp11_, "icon-press", (GCallback) ___lambda54__gtk_entry_icon_press, self, 0);
#line 54 "search.vala"
	_tmp12_ = self->priv->entry;
#line 54 "search.vala"
	g_signal_connect_object ((GtkEditable*) _tmp12_, "changed", (GCallback) _goto_line_on_changed_gtk_editable_changed, self, 0);
#line 27 "search.vala"
	_g_object_unref0 (icon);
#line 27 "search.vala"
	_g_object_unref0 (label);
#line 27 "search.vala"
	_g_object_unref0 (img);
#line 27 "search.vala"
	_g_object_unref0 (close_button);
#line 27 "search.vala"
	return self;
#line 485 "search.c"
}

GotoLine*
goto_line_new (MainWindow* main_window)
{
#line 27 "search.vala"
	return goto_line_construct (TYPE_GOTO_LINE, main_window);
#line 493 "search.c"
}

void
goto_line_show (GotoLine* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
#line 57 "search.vala"
	g_return_if_fail (self != NULL);
#line 59 "search.vala"
	_tmp0_ = self->priv->entry;
#line 59 "search.vala"
	gtk_entry_set_text (_tmp0_, "");
#line 60 "search.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 61 "search.vala"
	_tmp1_ = self->priv->entry;
#line 61 "search.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 513 "search.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 66 "search.vala"
	return self ? g_object_ref (self) : NULL;
#line 521 "search.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 538 "search.c"
}

static void
goto_line_on_changed (GotoLine* self)
{
	GtkStyleContext* style_context = NULL;
	GtkEntry* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkEntry* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gchar* text = NULL;
	GtkEntry* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint line = 0;
	const gchar* _tmp17_;
	MainWindow* _tmp18_;
	DocumentView* _tmp19_;
	DocumentView* _tmp20_;
#line 64 "search.vala"
	g_return_if_fail (self != NULL);
#line 66 "search.vala"
	_tmp0_ = self->priv->entry;
#line 66 "search.vala"
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
#line 66 "search.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 66 "search.vala"
	style_context = _tmp2_;
#line 68 "search.vala"
	_tmp3_ = self->priv->entry;
#line 68 "search.vala"
	_tmp4_ = gtk_entry_get_text_length (_tmp3_);
#line 68 "search.vala"
	_tmp5_ = _tmp4_;
#line 68 "search.vala"
	if (_tmp5_ == ((guint) 0)) {
#line 578 "search.c"
		GtkStyleContext* _tmp6_;
#line 70 "search.vala"
		_tmp6_ = style_context;
#line 70 "search.vala"
		gtk_style_context_remove_class (_tmp6_, GTK_STYLE_CLASS_ERROR);
#line 71 "search.vala"
		_g_object_unref0 (style_context);
#line 71 "search.vala"
		return;
#line 588 "search.c"
	}
#line 74 "search.vala"
	_tmp7_ = self->priv->entry;
#line 74 "search.vala"
	_tmp8_ = gtk_entry_get_text (_tmp7_);
#line 74 "search.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 74 "search.vala"
	text = _tmp9_;
#line 598 "search.c"
	{
		gint i = 0;
#line 77 "search.vala"
		i = 0;
#line 603 "search.c"
		{
			gboolean _tmp10_ = FALSE;
#line 77 "search.vala"
			_tmp10_ = TRUE;
#line 77 "search.vala"
			while (TRUE) {
#line 610 "search.c"
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gunichar c = 0U;
				const gchar* _tmp15_;
#line 77 "search.vala"
				if (!_tmp10_) {
#line 618 "search.c"
					gint _tmp11_;
#line 77 "search.vala"
					_tmp11_ = i;
#line 77 "search.vala"
					i = _tmp11_ + 1;
#line 624 "search.c"
				}
#line 77 "search.vala"
				_tmp10_ = FALSE;
#line 77 "search.vala"
				_tmp12_ = text;
#line 77 "search.vala"
				_tmp13_ = strlen (_tmp12_);
#line 77 "search.vala"
				_tmp14_ = _tmp13_;
#line 77 "search.vala"
				if (!(i < _tmp14_)) {
#line 77 "search.vala"
					break;
#line 638 "search.c"
				}
#line 79 "search.vala"
				_tmp15_ = text;
#line 79 "search.vala"
				c = (gunichar) string_get (_tmp15_, (glong) i);
#line 80 "search.vala"
				if (!g_unichar_isdigit (c)) {
#line 646 "search.c"
					GtkStyleContext* _tmp16_;
#line 82 "search.vala"
					_tmp16_ = style_context;
#line 82 "search.vala"
					gtk_style_context_add_class (_tmp16_, GTK_STYLE_CLASS_ERROR);
#line 83 "search.vala"
					_g_free0 (text);
#line 83 "search.vala"
					_g_object_unref0 (style_context);
#line 83 "search.vala"
					return;
#line 658 "search.c"
				}
			}
		}
	}
#line 87 "search.vala"
	_tmp17_ = text;
#line 87 "search.vala"
	line = atoi (_tmp17_) - 1;
#line 89 "search.vala"
	_tmp18_ = self->priv->main_window;
#line 89 "search.vala"
	_tmp19_ = main_window_get_active_view (_tmp18_);
#line 89 "search.vala"
	_tmp20_ = _tmp19_;
#line 89 "search.vala"
	if (tepl_view_goto_line ((TeplView*) _tmp20_, line)) {
#line 675 "search.c"
		GtkStyleContext* _tmp21_;
#line 90 "search.vala"
		_tmp21_ = style_context;
#line 90 "search.vala"
		gtk_style_context_remove_class (_tmp21_, GTK_STYLE_CLASS_ERROR);
#line 681 "search.c"
	} else {
		GtkStyleContext* _tmp22_;
#line 92 "search.vala"
		_tmp22_ = style_context;
#line 92 "search.vala"
		gtk_style_context_add_class (_tmp22_, GTK_STYLE_CLASS_ERROR);
#line 688 "search.c"
	}
#line 64 "search.vala"
	_g_free0 (text);
#line 64 "search.vala"
	_g_object_unref0 (style_context);
#line 694 "search.c"
}

static void
goto_line_class_init (GotoLineClass * klass,
                      gpointer klass_data)
{
#line 22 "search.vala"
	goto_line_parent_class = g_type_class_peek_parent (klass);
#line 22 "search.vala"
	g_type_class_adjust_private_offset (klass, &GotoLine_private_offset);
#line 22 "search.vala"
	G_OBJECT_CLASS (klass)->finalize = goto_line_finalize;
#line 707 "search.c"
}

static void
goto_line_instance_init (GotoLine * self,
                         gpointer klass)
{
#line 22 "search.vala"
	self->priv = goto_line_get_instance_private (self);
#line 716 "search.c"
}

static void
goto_line_finalize (GObject * obj)
{
	GotoLine * self;
#line 22 "search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GOTO_LINE, GotoLine);
#line 25 "search.vala"
	_g_object_unref0 (self->priv->entry);
#line 22 "search.vala"
	G_OBJECT_CLASS (goto_line_parent_class)->finalize (obj);
#line 729 "search.c"
}

GType
goto_line_get_type (void)
{
	static volatile gsize goto_line_type_id__volatile = 0;
	if (g_once_init_enter (&goto_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GotoLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) goto_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GotoLine), 0, (GInstanceInitFunc) goto_line_instance_init, NULL };
		GType goto_line_type_id;
		goto_line_type_id = g_type_register_static (gtk_grid_get_type (), "GotoLine", &g_define_type_info, 0);
		GotoLine_private_offset = g_type_add_instance_private (goto_line_type_id, sizeof (GotoLinePrivate));
		g_once_init_leave (&goto_line_type_id__volatile, goto_line_type_id);
	}
	return goto_line_type_id__volatile;
}

static inline gpointer
search_and_replace_get_instance_private (SearchAndReplace* self)
{
	return G_STRUCT_MEMBER_P (self, SearchAndReplace_private_offset);
}

static GType
search_and_replace_mode_get_type (void)
{
	static volatile gsize search_and_replace_mode_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_AND_REPLACE_MODE_SEARCH, "SEARCH_AND_REPLACE_MODE_SEARCH", "search"}, {SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE, "SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE", "search-and-replace"}, {0, NULL, NULL}};
		GType search_and_replace_mode_type_id;
		search_and_replace_mode_type_id = g_enum_register_static ("SearchAndReplaceMode", values);
		g_once_init_leave (&search_and_replace_mode_type_id__volatile, search_and_replace_mode_type_id);
	}
	return search_and_replace_mode_type_id__volatile;
}

static SearchAndReplaceMode
search_and_replace_get_mode (SearchAndReplace* self)
{
	SearchAndReplaceMode _tmp0_ = 0;
	GtkArrow* _tmp1_;
	GtkArrowType _tmp2_;
	GtkArrowType _tmp3_;
	SearchAndReplaceMode result = 0;
#line 119 "search.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 121 "search.vala"
	_tmp1_ = self->priv->_arrow;
#line 121 "search.vala"
	g_object_get (_tmp1_, "arrow-type", &_tmp2_, NULL);
#line 121 "search.vala"
	_tmp3_ = _tmp2_;
#line 121 "search.vala"
	if (_tmp3_ == GTK_ARROW_UP) {
#line 121 "search.vala"
		_tmp0_ = SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE;
#line 785 "search.c"
	} else {
#line 121 "search.vala"
		_tmp0_ = SEARCH_AND_REPLACE_MODE_SEARCH;
#line 789 "search.c"
	}
#line 121 "search.vala"
	result = _tmp0_;
#line 121 "search.vala"
	return result;
#line 795 "search.c"
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
#line 124 "search.vala"
	g_atomic_int_inc (&_data29_->_ref_count_);
#line 124 "search.vala"
	return _data29_;
#line 805 "search.c"
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
#line 124 "search.vala"
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
#line 815 "search.c"
		SearchAndReplace* self;
#line 124 "search.vala"
		self = _data29_->self;
#line 124 "search.vala"
		_g_object_unref0 (_data29_->button_replace_all);
#line 124 "search.vala"
		_g_object_unref0 (_data29_->button_replace);
#line 124 "search.vala"
		_g_object_unref0 (_data29_->button_next);
#line 124 "search.vala"
		_g_object_unref0 (_data29_->button_previous);
#line 124 "search.vala"
		_g_object_unref0 (self);
#line 124 "search.vala"
		g_slice_free (Block29Data, _data29_);
#line 831 "search.c"
	}
}

static void
__lambda56_ (SearchAndReplace* self)
{
#line 211 "search.vala"
	if (search_and_replace_get_mode (self) == SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE) {
#line 840 "search.c"
		GtkArrow* _tmp0_;
		GtkGrid* _tmp1_;
#line 213 "search.vala"
		_tmp0_ = self->priv->_arrow;
#line 213 "search.vala"
		g_object_set (_tmp0_, "arrow-type", GTK_ARROW_DOWN, NULL);
#line 214 "search.vala"
		_tmp1_ = self->priv->_replace_grid;
#line 214 "search.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 851 "search.c"
	} else {
		GtkArrow* _tmp2_;
		GtkGrid* _tmp3_;
#line 220 "search.vala"
		_tmp2_ = self->priv->_arrow;
#line 220 "search.vala"
		g_object_set (_tmp2_, "arrow-type", GTK_ARROW_UP, NULL);
#line 221 "search.vala"
		_tmp3_ = self->priv->_replace_grid;
#line 221 "search.vala"
		gtk_widget_show ((GtkWidget*) _tmp3_);
#line 863 "search.c"
	}
}

static void
___lambda56__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 208 "search.vala"
	__lambda56_ ((SearchAndReplace*) self);
#line 873 "search.c"
}

static void
_search_and_replace_hide_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
#line 225 "search.vala"
	search_and_replace_hide ((SearchAndReplace*) self);
#line 882 "search.c"
}

static void
_search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
#line 227 "search.vala"
	search_and_replace_search_forward ((SearchAndReplace*) self);
#line 891 "search.c"
}

static void
_search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender,
                                                       gpointer self)
{
#line 228 "search.vala"
	search_and_replace_search_forward ((SearchAndReplace*) self);
#line 900 "search.c"
}

static void
_search_and_replace_search_forward_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                gpointer self)
{
#line 229 "search.vala"
	search_and_replace_search_forward ((SearchAndReplace*) self);
#line 909 "search.c"
}

static void
_search_and_replace_search_backward_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
#line 231 "search.vala"
	search_and_replace_search_backward ((SearchAndReplace*) self);
#line 918 "search.c"
}

static void
_search_and_replace_search_backward_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                     gpointer self)
{
#line 232 "search.vala"
	search_and_replace_search_backward ((SearchAndReplace*) self);
#line 927 "search.c"
}

static void
__lambda58_ (Block29Data* _data29_)
{
	SearchAndReplace* self;
	gboolean sensitive = FALSE;
	GtkSearchEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
#line 234 "search.vala"
	self = _data29_->self;
#line 236 "search.vala"
	_tmp0_ = self->priv->_entry_find;
#line 236 "search.vala"
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
#line 236 "search.vala"
	_tmp2_ = _tmp1_;
#line 236 "search.vala"
	sensitive = _tmp2_ > ((guint) 0);
#line 237 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_previous, sensitive);
#line 238 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_next, sensitive);
#line 239 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_replace, sensitive);
#line 240 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_replace_all, sensitive);
#line 956 "search.c"
}

static void
___lambda58__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
#line 234 "search.vala"
	__lambda58_ (self);
#line 965 "search.c"
}

static void
_search_and_replace_replace_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
#line 243 "search.vala"
	search_and_replace_replace ((SearchAndReplace*) self);
#line 974 "search.c"
}

static void
_search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender,
                                                gpointer self)
{
#line 244 "search.vala"
	search_and_replace_replace ((SearchAndReplace*) self);
#line 983 "search.c"
}

static void
__lambda59_ (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 248 "search.vala"
	_tmp0_ = self->priv->_search_context;
#line 248 "search.vala"
	if (_tmp0_ != NULL) {
#line 995 "search.c"
		MainWindow* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		MainWindow* _tmp10_;
		DocumentView* _tmp11_;
		DocumentView* _tmp12_;
		GtkSourceCompletion* _tmp13_;
		GtkSourceCompletion* _tmp14_;
#line 250 "search.vala"
		_tmp1_ = self->priv->_main_window;
#line 250 "search.vala"
		_tmp2_ = main_window_get_active_view (_tmp1_);
#line 250 "search.vala"
		_tmp3_ = _tmp2_;
#line 250 "search.vala"
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
#line 250 "search.vala"
		_tmp5_ = _tmp4_;
#line 250 "search.vala"
		gtk_source_completion_block_interactive (_tmp5_);
#line 1018 "search.c"
		{
			GtkSourceSearchContext* _tmp6_;
			GtkSearchEntry* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
#line 254 "search.vala"
			_tmp6_ = self->priv->_search_context;
#line 254 "search.vala"
			_tmp7_ = self->priv->_entry_replace;
#line 254 "search.vala"
			_tmp8_ = gtk_entry_get_text ((GtkEntry*) _tmp7_);
#line 254 "search.vala"
			_tmp9_ = _tmp8_;
#line 254 "search.vala"
			gtk_source_search_context_replace_all (_tmp6_, _tmp9_, -1, &_inner_error0_);
#line 254 "search.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1036 "search.c"
				goto __catch36_g_error;
			}
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError* e = NULL;
#line 252 "search.vala"
			e = _inner_error0_;
#line 252 "search.vala"
			_inner_error0_ = NULL;
#line 252 "search.vala"
			_g_error_free0 (e);
#line 1050 "search.c"
		}
		__finally36:
#line 252 "search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 252 "search.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 252 "search.vala"
			g_clear_error (&_inner_error0_);
#line 252 "search.vala"
			return;
#line 1061 "search.c"
		}
#line 261 "search.vala"
		_tmp10_ = self->priv->_main_window;
#line 261 "search.vala"
		_tmp11_ = main_window_get_active_view (_tmp10_);
#line 261 "search.vala"
		_tmp12_ = _tmp11_;
#line 261 "search.vala"
		_tmp13_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp12_);
#line 261 "search.vala"
		_tmp14_ = _tmp13_;
#line 261 "search.vala"
		gtk_source_completion_unblock_interactive (_tmp14_);
#line 1075 "search.c"
	}
}

static void
___lambda59__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 246 "search.vala"
	__lambda59_ ((SearchAndReplace*) self);
#line 1085 "search.c"
}

static void
_search_and_replace_hide_gtk_search_entry_stop_search (GtkSearchEntry* _sender,
                                                       gpointer self)
{
#line 265 "search.vala"
	search_and_replace_hide ((SearchAndReplace*) self);
#line 1094 "search.c"
}

static gboolean
__lambda60_ (SearchAndReplace* self,
             GdkEventKey* event)
{
	gboolean result = FALSE;
#line 266 "search.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 268 "search.vala"
	switch (event->keyval) {
#line 268 "search.vala"
		case GDK_KEY_Tab:
#line 1108 "search.c"
		{
			GtkSearchEntry* _tmp0_;
#line 272 "search.vala"
			search_and_replace_show_search_and_replace (self);
#line 273 "search.vala"
			_tmp0_ = self->priv->_entry_replace;
#line 273 "search.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 274 "search.vala"
			result = TRUE;
#line 274 "search.vala"
			return result;
#line 1121 "search.c"
		}
		default:
		{
#line 278 "search.vala"
			result = FALSE;
#line 278 "search.vala"
			return result;
#line 1129 "search.c"
		}
	}
}

static gboolean
___lambda60__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda60_ ((SearchAndReplace*) self, event);
#line 266 "search.vala"
	return result;
#line 1143 "search.c"
}

SearchAndReplace*
search_and_replace_construct (GType object_type,
                              MainWindow* main_window)
{
	SearchAndReplace * self = NULL;
	Block29Data* _data29_;
	GtkSourceSearchSettings* _tmp0_;
	GtkSourceSearchSettings* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkButton* button_arrow = NULL;
	GtkButton* _tmp5_;
	GtkArrow* _tmp6_;
	GtkArrow* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* find_grid = NULL;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkSearchEntry* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* button_close = NULL;
	GtkButton* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkGrid* _tmp18_;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkSearchEntry* _tmp23_;
	GtkSearchEntry* _tmp24_;
	GtkSearchEntry* _tmp25_;
	GtkSearchEntry* _tmp26_;
	GtkSearchEntry* _tmp27_;
	GtkGrid* _tmp28_;
	GtkSearchEntry* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkGrid* replace_all_grid = NULL;
	GtkGrid* _tmp32_;
	GtkImage* image = NULL;
	GtkImage* _tmp33_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp34_;
	GtkGrid* _tmp35_;
	GtkGrid* _tmp36_;
	GtkSearchEntry* _tmp37_;
	GtkSearchEntry* _tmp38_;
	GtkSearchEntry* _tmp39_;
	GtkSearchEntry* _tmp40_;
	GtkSearchEntry* _tmp41_;
	GtkSearchEntry* _tmp42_;
	GtkSearchEntry* _tmp43_;
	GtkGrid* _tmp44_;
#line 124 "search.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 124 "search.vala"
	_data29_ = g_slice_new0 (Block29Data);
#line 124 "search.vala"
	_data29_->_ref_count_ = 1;
#line 124 "search.vala"
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
#line 124 "search.vala"
	_data29_->self = g_object_ref (self);
#line 126 "search.vala"
	self->priv->_main_window = main_window;
#line 128 "search.vala"
	_tmp0_ = gtk_source_search_settings_new ();
#line 128 "search.vala"
	_g_object_unref0 (self->priv->_search_settings);
#line 128 "search.vala"
	self->priv->_search_settings = _tmp0_;
#line 129 "search.vala"
	_tmp1_ = self->priv->_search_settings;
#line 129 "search.vala"
	gtk_source_search_settings_set_wrap_around (_tmp1_, TRUE);
#line 131 "search.vala"
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
#line 131 "search.vala"
	g_object_ref_sink (_tmp2_);
#line 131 "search.vala"
	_g_object_unref0 (self->priv->_main_grid);
#line 131 "search.vala"
	self->priv->_main_grid = _tmp2_;
#line 132 "search.vala"
	_tmp3_ = self->priv->_main_grid;
#line 132 "search.vala"
	gtk_grid_set_column_spacing (_tmp3_, (guint) 3);
#line 133 "search.vala"
	_tmp4_ = self->priv->_main_grid;
#line 133 "search.vala"
	gtk_grid_set_row_spacing (_tmp4_, (guint) 3);
#line 136 "search.vala"
	_tmp5_ = (GtkButton*) gtk_button_new ();
#line 136 "search.vala"
	g_object_ref_sink (_tmp5_);
#line 136 "search.vala"
	button_arrow = _tmp5_;
#line 137 "search.vala"
	_tmp6_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_OUT);
#line 137 "search.vala"
	g_object_ref_sink (_tmp6_);
#line 137 "search.vala"
	_g_object_unref0 (self->priv->_arrow);
#line 137 "search.vala"
	self->priv->_arrow = _tmp6_;
#line 138 "search.vala"
	_tmp7_ = self->priv->_arrow;
#line 138 "search.vala"
	gtk_container_add ((GtkContainer*) button_arrow, (GtkWidget*) _tmp7_);
#line 139 "search.vala"
	_tmp8_ = self->priv->_main_grid;
#line 139 "search.vala"
	gtk_grid_attach (_tmp8_, (GtkWidget*) button_arrow, 0, 0, 1, 1);
#line 142 "search.vala"
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
#line 142 "search.vala"
	g_object_ref_sink (_tmp9_);
#line 142 "search.vala"
	find_grid = _tmp9_;
#line 143 "search.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) find_grid, GTK_ORIENTATION_HORIZONTAL);
#line 144 "search.vala"
	gtk_grid_set_column_spacing (find_grid, (guint) 2);
#line 145 "search.vala"
	_tmp10_ = self->priv->_main_grid;
#line 145 "search.vala"
	gtk_grid_attach (_tmp10_, (GtkWidget*) find_grid, 1, 0, 1, 1);
#line 147 "search.vala"
	search_and_replace_init_find_entry (self);
#line 148 "search.vala"
	_tmp11_ = self->priv->_entry_find;
#line 148 "search.vala"
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _tmp11_);
#line 151 "search.vala"
	_tmp12_ = search_and_replace_get_button (self, "go-up");
#line 151 "search.vala"
	_data29_->button_previous = _tmp12_;
#line 152 "search.vala"
	_tmp13_ = search_and_replace_get_button (self, "go-down");
#line 152 "search.vala"
	_data29_->button_next = _tmp13_;
#line 153 "search.vala"
	_tmp14_ = search_and_replace_get_button (self, "window-close");
#line 153 "search.vala"
	button_close = _tmp14_;
#line 155 "search.vala"
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data29_->button_previous);
#line 156 "search.vala"
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data29_->button_next);
#line 157 "search.vala"
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) button_close);
#line 159 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_previous, FALSE);
#line 160 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_next, FALSE);
#line 163 "search.vala"
	_tmp15_ = (GtkLabel*) gtk_label_new (NULL);
#line 163 "search.vala"
	g_object_ref_sink (_tmp15_);
#line 163 "search.vala"
	_g_object_unref0 (self->priv->_info_label);
#line 163 "search.vala"
	self->priv->_info_label = _tmp15_;
#line 164 "search.vala"
	_tmp16_ = self->priv->_info_label;
#line 164 "search.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, 12);
#line 165 "search.vala"
	_tmp17_ = self->priv->_info_label;
#line 165 "search.vala"
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _tmp17_);
#line 168 "search.vala"
	_tmp18_ = (GtkGrid*) gtk_grid_new ();
#line 168 "search.vala"
	g_object_ref_sink (_tmp18_);
#line 168 "search.vala"
	_g_object_unref0 (self->priv->_replace_grid);
#line 168 "search.vala"
	self->priv->_replace_grid = _tmp18_;
#line 169 "search.vala"
	_tmp19_ = self->priv->_replace_grid;
#line 169 "search.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp19_, GTK_ORIENTATION_HORIZONTAL);
#line 170 "search.vala"
	_tmp20_ = self->priv->_replace_grid;
#line 170 "search.vala"
	gtk_grid_set_column_spacing (_tmp20_, (guint) 2);
#line 171 "search.vala"
	_tmp21_ = self->priv->_main_grid;
#line 171 "search.vala"
	_tmp22_ = self->priv->_replace_grid;
#line 171 "search.vala"
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 1, 1, 1, 1);
#line 173 "search.vala"
	_tmp23_ = (GtkSearchEntry*) gtk_search_entry_new ();
#line 173 "search.vala"
	g_object_ref_sink (_tmp23_);
#line 173 "search.vala"
	_g_object_unref0 (self->priv->_entry_replace);
#line 173 "search.vala"
	self->priv->_entry_replace = _tmp23_;
#line 174 "search.vala"
	_tmp24_ = self->priv->_entry_replace;
#line 174 "search.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _ ("Replace with"));
#line 175 "search.vala"
	_tmp25_ = self->priv->_entry_replace;
#line 175 "search.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp25_, TRUE);
#line 176 "search.vala"
	_tmp26_ = self->priv->_entry_replace;
#line 176 "search.vala"
	gtk_entry_set_width_chars ((GtkEntry*) _tmp26_, 25);
#line 177 "search.vala"
	_tmp27_ = self->priv->_entry_replace;
#line 177 "search.vala"
	g_object_set ((GtkEntry*) _tmp27_, "primary-icon-gicon", NULL, NULL);
#line 178 "search.vala"
	_tmp28_ = self->priv->_replace_grid;
#line 178 "search.vala"
	_tmp29_ = self->priv->_entry_replace;
#line 178 "search.vala"
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
#line 181 "search.vala"
	_tmp30_ = search_and_replace_get_button (self, "edit-find-replace");
#line 181 "search.vala"
	_data29_->button_replace = _tmp30_;
#line 182 "search.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _data29_->button_replace, _ ("Replace"));
#line 185 "search.vala"
	_tmp31_ = (GtkButton*) gtk_button_new ();
#line 185 "search.vala"
	g_object_ref_sink (_tmp31_);
#line 185 "search.vala"
	_data29_->button_replace_all = _tmp31_;
#line 186 "search.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _data29_->button_replace_all, _ ("Replace All"));
#line 187 "search.vala"
	gtk_button_set_relief (_data29_->button_replace_all, GTK_RELIEF_NONE);
#line 188 "search.vala"
	_tmp32_ = (GtkGrid*) gtk_grid_new ();
#line 188 "search.vala"
	g_object_ref_sink (_tmp32_);
#line 188 "search.vala"
	replace_all_grid = _tmp32_;
#line 189 "search.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) replace_all_grid, GTK_ORIENTATION_HORIZONTAL);
#line 190 "search.vala"
	gtk_grid_set_column_spacing (replace_all_grid, (guint) 8);
#line 191 "search.vala"
	gtk_widget_set_valign ((GtkWidget*) replace_all_grid, GTK_ALIGN_CENTER);
#line 193 "search.vala"
	_tmp33_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-find-replace", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 193 "search.vala"
	g_object_ref_sink (_tmp33_);
#line 193 "search.vala"
	image = _tmp33_;
#line 194 "search.vala"
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) image);
#line 196 "search.vala"
	_tmp34_ = (GtkLabel*) gtk_label_new (_ ("All"));
#line 196 "search.vala"
	g_object_ref_sink (_tmp34_);
#line 196 "search.vala"
	label = _tmp34_;
#line 197 "search.vala"
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) label);
#line 198 "search.vala"
	gtk_container_add ((GtkContainer*) _data29_->button_replace_all, (GtkWidget*) replace_all_grid);
#line 200 "search.vala"
	_tmp35_ = self->priv->_replace_grid;
#line 200 "search.vala"
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _data29_->button_replace);
#line 201 "search.vala"
	_tmp36_ = self->priv->_replace_grid;
#line 201 "search.vala"
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _data29_->button_replace_all);
#line 203 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_replace, FALSE);
#line 204 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data29_->button_replace_all, FALSE);
#line 208 "search.vala"
	g_signal_connect_object (button_arrow, "clicked", (GCallback) ___lambda56__gtk_button_clicked, self, 0);
#line 225 "search.vala"
	g_signal_connect_object (button_close, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
#line 227 "search.vala"
	g_signal_connect_object (_data29_->button_next, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
#line 228 "search.vala"
	_tmp37_ = self->priv->_entry_find;
#line 228 "search.vala"
	g_signal_connect_object ((GtkEntry*) _tmp37_, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
#line 229 "search.vala"
	_tmp38_ = self->priv->_entry_find;
#line 229 "search.vala"
	g_signal_connect_object (_tmp38_, "next-match", (GCallback) _search_and_replace_search_forward_gtk_search_entry_next_match, self, 0);
#line 231 "search.vala"
	g_signal_connect_object (_data29_->button_previous, "clicked", (GCallback) _search_and_replace_search_backward_gtk_button_clicked, self, 0);
#line 232 "search.vala"
	_tmp39_ = self->priv->_entry_find;
#line 232 "search.vala"
	g_signal_connect_object (_tmp39_, "previous-match", (GCallback) _search_and_replace_search_backward_gtk_search_entry_previous_match, self, 0);
#line 234 "search.vala"
	_tmp40_ = self->priv->_entry_find;
#line 234 "search.vala"
	g_signal_connect_data ((GtkEditable*) _tmp40_, "changed", (GCallback) ___lambda58__gtk_editable_changed, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
#line 243 "search.vala"
	g_signal_connect_object (_data29_->button_replace, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
#line 244 "search.vala"
	_tmp41_ = self->priv->_entry_replace;
#line 244 "search.vala"
	g_signal_connect_object ((GtkEntry*) _tmp41_, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
#line 246 "search.vala"
	g_signal_connect_object (_data29_->button_replace_all, "clicked", (GCallback) ___lambda59__gtk_button_clicked, self, 0);
#line 265 "search.vala"
	_tmp42_ = self->priv->_entry_find;
#line 265 "search.vala"
	g_signal_connect_object (_tmp42_, "stop-search", (GCallback) _search_and_replace_hide_gtk_search_entry_stop_search, self, 0);
#line 266 "search.vala"
	_tmp43_ = self->priv->_entry_find;
#line 266 "search.vala"
	g_signal_connect_object ((GtkWidget*) _tmp43_, "key-press-event", (GCallback) ___lambda60__gtk_widget_key_press_event, self, 0);
#line 282 "search.vala"
	_tmp44_ = self->priv->_main_grid;
#line 282 "search.vala"
	gtk_widget_hide ((GtkWidget*) _tmp44_);
#line 124 "search.vala"
	_g_object_unref0 (label);
#line 124 "search.vala"
	_g_object_unref0 (image);
#line 124 "search.vala"
	_g_object_unref0 (replace_all_grid);
#line 124 "search.vala"
	_g_object_unref0 (button_close);
#line 124 "search.vala"
	_g_object_unref0 (find_grid);
#line 124 "search.vala"
	_g_object_unref0 (button_arrow);
#line 124 "search.vala"
	block29_data_unref (_data29_);
#line 124 "search.vala"
	_data29_ = NULL;
#line 124 "search.vala"
	return self;
#line 1493 "search.c"
}

SearchAndReplace*
search_and_replace_new (MainWindow* main_window)
{
#line 124 "search.vala"
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
#line 1501 "search.c"
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
#line 285 "search.vala"
	g_atomic_int_inc (&_data30_->_ref_count_);
#line 285 "search.vala"
	return _data30_;
#line 1511 "search.c"
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
#line 285 "search.vala"
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
#line 1521 "search.c"
		SearchAndReplace* self;
#line 285 "search.vala"
		self = _data30_->self;
#line 285 "search.vala"
		_g_object_unref0 (_data30_->menu);
#line 285 "search.vala"
		_g_object_unref0 (self);
#line 285 "search.vala"
		g_slice_free (Block30Data, _data30_);
#line 1531 "search.c"
	}
}

static void
__lambda55_ (Block30Data* _data30_,
             GtkEntryIconPosition icon_pos,
             GdkEventButton* event)
{
	SearchAndReplace* self;
#line 320 "search.vala"
	self = _data30_->self;
#line 320 "search.vala"
	g_return_if_fail (event != NULL);
#line 322 "search.vala"
	if (icon_pos == GTK_ENTRY_ICON_PRIMARY) {
#line 1547 "search.c"
		GtkSearchEntry* _tmp0_;
#line 323 "search.vala"
		_tmp0_ = self->priv->_entry_find;
#line 323 "search.vala"
		gtk_menu_popup_at_widget (_data30_->menu, (GtkWidget*) _tmp0_, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, (GdkEvent*) event);
#line 1553 "search.c"
	}
}

static void
___lambda55__gtk_entry_icon_press (GtkEntry* _sender,
                                   GtkEntryIconPosition icon_pos,
                                   GdkEventButton* event,
                                   gpointer self)
{
#line 320 "search.vala"
	__lambda55_ (self, icon_pos, event);
#line 1565 "search.c"
}

static void
search_and_replace_init_find_entry (SearchAndReplace* self)
{
	Block30Data* _data30_;
	GtkSearchEntry* _tmp0_;
	GtkSearchEntry* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	GtkSearchEntry* _tmp4_;
	GtkSearchEntry* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkSearchEntry* _tmp7_;
	GtkSearchEntry* _tmp8_;
	GtkSearchEntry* _tmp9_;
	GtkSourceSearchSettings* _tmp10_;
	GtkMenu* _tmp11_;
	GtkCheckMenuItem* check_case_sensitive = NULL;
	GtkCheckMenuItem* _tmp12_;
	GtkCheckMenuItem* check_entire_word = NULL;
	GtkCheckMenuItem* _tmp13_;
	GtkSourceSearchSettings* _tmp14_;
	GtkSourceSearchSettings* _tmp15_;
	GtkSearchEntry* _tmp16_;
#line 285 "search.vala"
	g_return_if_fail (self != NULL);
#line 285 "search.vala"
	_data30_ = g_slice_new0 (Block30Data);
#line 285 "search.vala"
	_data30_->_ref_count_ = 1;
#line 285 "search.vala"
	_data30_->self = g_object_ref (self);
#line 287 "search.vala"
	_tmp0_ = (GtkSearchEntry*) gtk_search_entry_new ();
#line 287 "search.vala"
	g_object_ref_sink (_tmp0_);
#line 287 "search.vala"
	_g_object_unref0 (self->priv->_entry_find);
#line 287 "search.vala"
	self->priv->_entry_find = _tmp0_;
#line 288 "search.vala"
	_tmp1_ = self->priv->_entry_find;
#line 288 "search.vala"
	_tmp2_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("document-properties-symbolic");
#line 288 "search.vala"
	_tmp3_ = _tmp2_;
#line 288 "search.vala"
	g_object_set ((GtkEntry*) _tmp1_, "primary-icon-gicon", (GIcon*) _tmp3_, NULL);
#line 288 "search.vala"
	_g_object_unref0 (_tmp3_);
#line 290 "search.vala"
	_tmp4_ = self->priv->_entry_find;
#line 290 "search.vala"
	g_object_set ((GtkEntry*) _tmp4_, "primary-icon-activatable", TRUE, NULL);
#line 291 "search.vala"
	_tmp5_ = self->priv->_entry_find;
#line 291 "search.vala"
	g_object_set ((GtkEntry*) _tmp5_, "primary-icon-sensitive", TRUE, NULL);
#line 292 "search.vala"
	_tmp6_ = self->priv->_entry_find;
#line 292 "search.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Search for"));
#line 293 "search.vala"
	_tmp7_ = self->priv->_entry_find;
#line 293 "search.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp7_, TRUE);
#line 294 "search.vala"
	_tmp8_ = self->priv->_entry_find;
#line 294 "search.vala"
	gtk_entry_set_width_chars ((GtkEntry*) _tmp8_, 25);
#line 296 "search.vala"
	_tmp9_ = self->priv->_entry_find;
#line 296 "search.vala"
	_tmp10_ = self->priv->_search_settings;
#line 296 "search.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "text", (GObject*) _tmp10_, "search-text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 300 "search.vala"
	_tmp11_ = (GtkMenu*) gtk_menu_new ();
#line 300 "search.vala"
	g_object_ref_sink (_tmp11_);
#line 300 "search.vala"
	_data30_->menu = _tmp11_;
#line 302 "search.vala"
	_tmp12_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Case sensitive"));
#line 302 "search.vala"
	g_object_ref_sink (_tmp12_);
#line 302 "search.vala"
	check_case_sensitive = _tmp12_;
#line 305 "search.vala"
	_tmp13_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Entire words only"));
#line 305 "search.vala"
	g_object_ref_sink (_tmp13_);
#line 305 "search.vala"
	check_entire_word = _tmp13_;
#line 308 "search.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data30_->menu, (GtkMenuItem*) check_case_sensitive);
#line 309 "search.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data30_->menu, (GtkMenuItem*) check_entire_word);
#line 310 "search.vala"
	gtk_widget_show_all ((GtkWidget*) _data30_->menu);
#line 312 "search.vala"
	_tmp14_ = self->priv->_search_settings;
#line 312 "search.vala"
	g_object_bind_property_with_closures ((GObject*) check_case_sensitive, "active", (GObject*) _tmp14_, "case-sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 316 "search.vala"
	_tmp15_ = self->priv->_search_settings;
#line 316 "search.vala"
	g_object_bind_property_with_closures ((GObject*) check_entire_word, "active", (GObject*) _tmp15_, "at-word-boundaries", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 320 "search.vala"
	_tmp16_ = self->priv->_entry_find;
#line 320 "search.vala"
	g_signal_connect_data ((GtkEntry*) _tmp16_, "icon-press", (GCallback) ___lambda55__gtk_entry_icon_press, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
#line 285 "search.vala"
	_g_object_unref0 (check_entire_word);
#line 285 "search.vala"
	_g_object_unref0 (check_case_sensitive);
#line 285 "search.vala"
	block30_data_unref (_data30_);
#line 285 "search.vala"
	_data30_ = NULL;
#line 1687 "search.c"
}

static GtkButton*
search_and_replace_get_button (SearchAndReplace* self,
                               const gchar* icon_name)
{
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkImage* image = NULL;
	GtkImage* _tmp1_;
	GtkButton* result = NULL;
#line 328 "search.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 328 "search.vala"
	g_return_val_if_fail (icon_name != NULL, NULL);
#line 330 "search.vala"
	_tmp0_ = (GtkButton*) gtk_button_new ();
#line 330 "search.vala"
	g_object_ref_sink (_tmp0_);
#line 330 "search.vala"
	button = _tmp0_;
#line 331 "search.vala"
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name, (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 331 "search.vala"
	g_object_ref_sink (_tmp1_);
#line 331 "search.vala"
	image = _tmp1_;
#line 332 "search.vala"
	gtk_container_add ((GtkContainer*) button, (GtkWidget*) image);
#line 333 "search.vala"
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
#line 334 "search.vala"
	result = button;
#line 334 "search.vala"
	_g_object_unref0 (image);
#line 334 "search.vala"
	return result;
#line 1725 "search.c"
}

GtkWidget*
search_and_replace_get_widget (SearchAndReplace* self)
{
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result = NULL;
#line 337 "search.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 339 "search.vala"
	_tmp0_ = self->priv->_main_grid;
#line 339 "search.vala"
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
#line 339 "search.vala"
	result = _tmp1_;
#line 339 "search.vala"
	return result;
#line 1744 "search.c"
}

void
search_and_replace_show_search (SearchAndReplace* self)
{
	GtkArrow* _tmp0_;
	GtkGrid* _tmp1_;
#line 342 "search.vala"
	g_return_if_fail (self != NULL);
#line 344 "search.vala"
	_tmp0_ = self->priv->_arrow;
#line 344 "search.vala"
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_DOWN, NULL);
#line 345 "search.vala"
	search_and_replace_show (self);
#line 346 "search.vala"
	_tmp1_ = self->priv->_replace_grid;
#line 346 "search.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1764 "search.c"
}

void
search_and_replace_show_search_and_replace (SearchAndReplace* self)
{
	GtkArrow* _tmp0_;
#line 349 "search.vala"
	g_return_if_fail (self != NULL);
#line 351 "search.vala"
	_tmp0_ = self->priv->_arrow;
#line 351 "search.vala"
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_UP, NULL);
#line 352 "search.vala"
	search_and_replace_show (self);
#line 1779 "search.c"
}

static void
_search_and_replace_connect_active_document_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
#line 372 "search.vala"
	search_and_replace_connect_active_document ((SearchAndReplace*) self);
#line 1789 "search.c"
}

static void
search_and_replace_show (SearchAndReplace* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtkGrid* _tmp3_;
	GtkSearchEntry* _tmp4_;
	Document* doc = NULL;
	MainWindow* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	MainWindow* _tmp19_;
#line 355 "search.vala"
	g_return_if_fail (self != NULL);
#line 357 "search.vala"
	_tmp0_ = self->priv->_main_window;
#line 357 "search.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 357 "search.vala"
	_tmp2_ = _tmp1_;
#line 357 "search.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 359 "search.vala"
	_tmp3_ = self->priv->_main_grid;
#line 359 "search.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
#line 360 "search.vala"
	_tmp4_ = self->priv->_entry_find;
#line 360 "search.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
#line 364 "search.vala"
	_tmp5_ = self->priv->_main_window;
#line 364 "search.vala"
	_tmp6_ = main_window_get_active_document (_tmp5_);
#line 364 "search.vala"
	_tmp7_ = _tmp6_;
#line 364 "search.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 364 "search.vala"
	doc = _tmp8_;
#line 365 "search.vala"
	_tmp9_ = doc;
#line 365 "search.vala"
	if (tepl_buffer_get_selection_type ((TeplBuffer*) _tmp9_) == TEPL_SELECTION_TYPE_ON_SAME_LINE) {
#line 1839 "search.c"
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		Document* _tmp10_;
		GtkTextIter _tmp11_ = {0};
		GtkTextIter _tmp12_ = {0};
		GtkSearchEntry* _tmp13_;
		Document* _tmp14_;
		GtkTextIter _tmp15_;
		GtkTextIter _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 368 "search.vala"
		_tmp10_ = doc;
#line 368 "search.vala"
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp10_, &_tmp11_, &_tmp12_);
#line 368 "search.vala"
		start = _tmp11_;
#line 368 "search.vala"
		end = _tmp12_;
#line 369 "search.vala"
		_tmp13_ = self->priv->_entry_find;
#line 369 "search.vala"
		_tmp14_ = doc;
#line 369 "search.vala"
		_tmp15_ = start;
#line 369 "search.vala"
		_tmp16_ = end;
#line 369 "search.vala"
		_tmp17_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp14_, &_tmp15_, &_tmp16_, FALSE);
#line 369 "search.vala"
		_tmp18_ = _tmp17_;
#line 369 "search.vala"
		gtk_entry_set_text ((GtkEntry*) _tmp13_, _tmp18_);
#line 369 "search.vala"
		_g_free0 (_tmp18_);
#line 1875 "search.c"
	}
#line 372 "search.vala"
	_tmp19_ = self->priv->_main_window;
#line 372 "search.vala"
	g_signal_connect_object ((GObject*) _tmp19_, "notify::active-document", (GCallback) _search_and_replace_connect_active_document_g_object_notify, self, 0);
#line 373 "search.vala"
	search_and_replace_connect_active_document (self);
#line 355 "search.vala"
	_g_object_unref0 (doc);
#line 1885 "search.c"
}

void
search_and_replace_hide (SearchAndReplace* self)
{
	MainWindow* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	GtkGrid* _tmp3_;
	MainWindow* _tmp4_;
	DocumentView* _tmp5_;
	DocumentView* _tmp6_;
#line 376 "search.vala"
	g_return_if_fail (self != NULL);
#line 378 "search.vala"
	_tmp0_ = self->priv->_main_window;
#line 378 "search.vala"
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
#line 378 "search.vala"
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _search_and_replace_connect_active_document_g_object_notify, self);
#line 379 "search.vala"
	search_and_replace_destroy_search_context (self);
#line 381 "search.vala"
	_tmp3_ = self->priv->_main_grid;
#line 381 "search.vala"
	gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 383 "search.vala"
	_tmp4_ = self->priv->_main_window;
#line 383 "search.vala"
	_tmp5_ = main_window_get_active_view (_tmp4_);
#line 383 "search.vala"
	_tmp6_ = _tmp5_;
#line 383 "search.vala"
	if (_tmp6_ != NULL) {
#line 1920 "search.c"
		MainWindow* _tmp7_;
		DocumentView* _tmp8_;
		DocumentView* _tmp9_;
#line 384 "search.vala"
		_tmp7_ = self->priv->_main_window;
#line 384 "search.vala"
		_tmp8_ = main_window_get_active_view (_tmp7_);
#line 384 "search.vala"
		_tmp9_ = _tmp8_;
#line 384 "search.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
#line 1932 "search.c"
	}
}

static void
_search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender,
                                                          GtkTextIter* location,
                                                          GtkTextMark* mark,
                                                          gpointer self)
{
#line 393 "search.vala"
	search_and_replace_mark_set_cb ((SearchAndReplace*) self, _sender, location, mark);
#line 1944 "search.c"
}

static void
search_and_replace_destroy_search_context (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	guint _tmp5_;
#line 387 "search.vala"
	g_return_if_fail (self != NULL);
#line 389 "search.vala"
	_tmp0_ = self->priv->_search_context;
#line 389 "search.vala"
	if (_tmp0_ == NULL) {
#line 390 "search.vala"
		return;
#line 1965 "search.c"
	}
#line 392 "search.vala"
	_tmp1_ = self->priv->_search_context;
#line 392 "search.vala"
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
#line 392 "search.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 392 "search.vala"
	buffer = _tmp3_;
#line 393 "search.vala"
	_tmp4_ = buffer;
#line 393 "search.vala"
	g_signal_parse_name ("mark-set", gtk_text_buffer_get_type (), &_tmp5_, NULL, FALSE);
#line 393 "search.vala"
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self);
#line 395 "search.vala"
	_g_object_unref0 (self->priv->_search_context);
#line 395 "search.vala"
	self->priv->_search_context = NULL;
#line 387 "search.vala"
	_g_object_unref0 (buffer);
#line 1987 "search.c"
}

static void
__lambda57_ (SearchAndReplace* self)
{
	GtkStyleContext* style_context = NULL;
	GtkSearchEntry* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkSourceSearchContext* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 411 "search.vala"
	_tmp0_ = self->priv->_entry_find;
#line 411 "search.vala"
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
#line 411 "search.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 411 "search.vala"
	style_context = _tmp2_;
#line 413 "search.vala"
	_tmp4_ = self->priv->_search_context;
#line 413 "search.vala"
	_tmp5_ = gtk_source_search_context_get_occurrences_count (_tmp4_);
#line 413 "search.vala"
	_tmp6_ = _tmp5_;
#line 413 "search.vala"
	if (_tmp6_ == 0) {
#line 2017 "search.c"
		GtkSourceSearchSettings* _tmp7_;
		const gchar* _tmp8_;
#line 414 "search.vala"
		_tmp7_ = self->priv->_search_settings;
#line 414 "search.vala"
		_tmp8_ = gtk_source_search_settings_get_search_text (_tmp7_);
#line 414 "search.vala"
		_tmp3_ = _tmp8_ != NULL;
#line 2026 "search.c"
	} else {
#line 413 "search.vala"
		_tmp3_ = FALSE;
#line 2030 "search.c"
	}
#line 413 "search.vala"
	if (_tmp3_) {
#line 2034 "search.c"
		GtkStyleContext* _tmp9_;
#line 415 "search.vala"
		_tmp9_ = style_context;
#line 415 "search.vala"
		gtk_style_context_add_class (_tmp9_, GTK_STYLE_CLASS_ERROR);
#line 2040 "search.c"
	} else {
		GtkSourceSearchContext* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 417 "search.vala"
		_tmp10_ = self->priv->_search_context;
#line 417 "search.vala"
		_tmp11_ = gtk_source_search_context_get_occurrences_count (_tmp10_);
#line 417 "search.vala"
		_tmp12_ = _tmp11_;
#line 417 "search.vala"
		if (_tmp12_ >= 0) {
#line 2053 "search.c"
			GtkStyleContext* _tmp13_;
#line 418 "search.vala"
			_tmp13_ = style_context;
#line 418 "search.vala"
			gtk_style_context_remove_class (_tmp13_, GTK_STYLE_CLASS_ERROR);
#line 2059 "search.c"
		}
	}
#line 420 "search.vala"
	search_and_replace_update_info_label (self);
#line 409 "search.vala"
	_g_object_unref0 (style_context);
#line 2066 "search.c"
}

static void
___lambda57__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 409 "search.vala"
	__lambda57_ ((SearchAndReplace*) self);
#line 2076 "search.c"
}

static void
search_and_replace_connect_active_document (SearchAndReplace* self)
{
	Document* doc = NULL;
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GtkSourceSearchSettings* _tmp6_;
	GtkSourceSearchContext* _tmp7_;
	GtkSourceSearchContext* _tmp8_;
	gboolean readonly = FALSE;
	MainWindow* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkGrid* _tmp14_;
	Document* _tmp15_;
#line 398 "search.vala"
	g_return_if_fail (self != NULL);
#line 400 "search.vala"
	search_and_replace_destroy_search_context (self);
#line 402 "search.vala"
	_tmp0_ = self->priv->_main_window;
#line 402 "search.vala"
	_tmp1_ = main_window_get_active_document (_tmp0_);
#line 402 "search.vala"
	_tmp2_ = _tmp1_;
#line 402 "search.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 402 "search.vala"
	doc = _tmp3_;
#line 404 "search.vala"
	_tmp4_ = doc;
#line 404 "search.vala"
	if (_tmp4_ == NULL) {
#line 405 "search.vala"
		_g_object_unref0 (doc);
#line 405 "search.vala"
		return;
#line 2122 "search.c"
	}
#line 407 "search.vala"
	_tmp5_ = doc;
#line 407 "search.vala"
	_tmp6_ = self->priv->_search_settings;
#line 407 "search.vala"
	_tmp7_ = gtk_source_search_context_new ((GtkSourceBuffer*) _tmp5_, _tmp6_);
#line 407 "search.vala"
	_g_object_unref0 (self->priv->_search_context);
#line 407 "search.vala"
	self->priv->_search_context = _tmp7_;
#line 409 "search.vala"
	_tmp8_ = self->priv->_search_context;
#line 409 "search.vala"
	g_signal_connect_object ((GObject*) _tmp8_, "notify::occurrences-count", (GCallback) ___lambda57__g_object_notify, self, 0);
#line 423 "search.vala"
	_tmp9_ = self->priv->_main_window;
#line 423 "search.vala"
	_tmp10_ = main_window_get_active_document (_tmp9_);
#line 423 "search.vala"
	_tmp11_ = _tmp10_;
#line 423 "search.vala"
	_tmp12_ = document_get_readonly (_tmp11_);
#line 423 "search.vala"
	_tmp13_ = _tmp12_;
#line 423 "search.vala"
	readonly = _tmp13_;
#line 424 "search.vala"
	_tmp14_ = self->priv->_replace_grid;
#line 424 "search.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, !readonly);
#line 426 "search.vala"
	_tmp15_ = doc;
#line 426 "search.vala"
	g_signal_connect_object ((GtkTextBuffer*) _tmp15_, "mark-set", (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self, 0);
#line 398 "search.vala"
	_g_object_unref0 (doc);
#line 2160 "search.c"
}

static void
search_and_replace_mark_set_cb (SearchAndReplace* self,
                                GtkTextBuffer* buffer,
                                GtkTextIter* location,
                                GtkTextMark* mark)
{
	gboolean _tmp0_ = FALSE;
	GtkTextMark* _tmp1_;
#line 429 "search.vala"
	g_return_if_fail (self != NULL);
#line 429 "search.vala"
	g_return_if_fail (buffer != NULL);
#line 429 "search.vala"
	g_return_if_fail (location != NULL);
#line 429 "search.vala"
	g_return_if_fail (mark != NULL);
#line 431 "search.vala"
	_tmp1_ = gtk_text_buffer_get_insert (buffer);
#line 431 "search.vala"
	if (mark == _tmp1_) {
#line 431 "search.vala"
		_tmp0_ = TRUE;
#line 2185 "search.c"
	} else {
		GtkTextMark* _tmp2_;
#line 431 "search.vala"
		_tmp2_ = gtk_text_buffer_get_selection_bound (buffer);
#line 431 "search.vala"
		_tmp0_ = mark == _tmp2_;
#line 2192 "search.c"
	}
#line 431 "search.vala"
	if (_tmp0_) {
#line 433 "search.vala"
		search_and_replace_update_info_label (self);
#line 2198 "search.c"
	}
}

static void
search_and_replace_update_info_label (SearchAndReplace* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSourceSearchContext* _tmp1_;
	gint count = 0;
	GtkSourceSearchContext* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkTextBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp9_;
	GtkSourceBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp12_;
	GtkTextIter _tmp13_ = {0};
	GtkTextIter _tmp14_ = {0};
	gint pos = 0;
	GtkSourceSearchContext* _tmp15_;
	GtkTextIter _tmp16_;
	GtkTextIter _tmp17_;
#line 437 "search.vala"
	g_return_if_fail (self != NULL);
#line 439 "search.vala"
	_tmp1_ = self->priv->_search_context;
#line 439 "search.vala"
	if (_tmp1_ == NULL) {
#line 439 "search.vala"
		_tmp0_ = TRUE;
#line 2232 "search.c"
	} else {
		GtkSourceSearchSettings* _tmp2_;
		const gchar* _tmp3_;
#line 440 "search.vala"
		_tmp2_ = self->priv->_search_settings;
#line 440 "search.vala"
		_tmp3_ = gtk_source_search_settings_get_search_text (_tmp2_);
#line 440 "search.vala"
		_tmp0_ = _tmp3_ == NULL;
#line 2242 "search.c"
	}
#line 439 "search.vala"
	if (_tmp0_) {
#line 2246 "search.c"
		GtkLabel* _tmp4_;
#line 442 "search.vala"
		_tmp4_ = self->priv->_info_label;
#line 442 "search.vala"
		gtk_label_set_text (_tmp4_, "");
#line 443 "search.vala"
		return;
#line 2254 "search.c"
	}
#line 446 "search.vala"
	_tmp5_ = self->priv->_search_context;
#line 446 "search.vala"
	_tmp6_ = gtk_source_search_context_get_occurrences_count (_tmp5_);
#line 446 "search.vala"
	_tmp7_ = _tmp6_;
#line 446 "search.vala"
	count = _tmp7_;
#line 448 "search.vala"
	if (count == -1) {
#line 450 "search.vala"
		return;
#line 2268 "search.c"
	}
#line 453 "search.vala"
	if (count == 0) {
#line 2272 "search.c"
		GtkLabel* _tmp8_;
#line 455 "search.vala"
		_tmp8_ = self->priv->_info_label;
#line 455 "search.vala"
		gtk_label_set_text (_tmp8_, _ ("Not found"));
#line 456 "search.vala"
		return;
#line 2280 "search.c"
	}
#line 459 "search.vala"
	_tmp9_ = self->priv->_search_context;
#line 459 "search.vala"
	_tmp10_ = gtk_source_search_context_get_buffer (_tmp9_);
#line 459 "search.vala"
	_tmp11_ = _g_object_ref0 ((GtkTextBuffer*) _tmp10_);
#line 459 "search.vala"
	buffer = _tmp11_;
#line 463 "search.vala"
	_tmp12_ = buffer;
#line 463 "search.vala"
	gtk_text_buffer_get_selection_bounds (_tmp12_, &_tmp13_, &_tmp14_);
#line 463 "search.vala"
	start = _tmp13_;
#line 463 "search.vala"
	end = _tmp14_;
#line 465 "search.vala"
	_tmp15_ = self->priv->_search_context;
#line 465 "search.vala"
	_tmp16_ = start;
#line 465 "search.vala"
	_tmp17_ = end;
#line 465 "search.vala"
	pos = gtk_source_search_context_get_occurrence_position (_tmp15_, &_tmp16_, &_tmp17_);
#line 467 "search.vala"
	if (pos > 0) {
#line 2308 "search.c"
		GtkLabel* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
#line 472 "search.vala"
		_tmp18_ = self->priv->_info_label;
#line 472 "search.vala"
		_tmp19_ = g_strdup_printf (_ ("Match %d of %d"), pos, count);
#line 472 "search.vala"
		_tmp20_ = _tmp19_;
#line 472 "search.vala"
		gtk_label_set_text (_tmp18_, _tmp20_);
#line 472 "search.vala"
		_g_free0 (_tmp20_);
#line 2322 "search.c"
	} else {
		gchar* text = NULL;
		gchar* _tmp21_;
		GtkLabel* _tmp22_;
		const gchar* _tmp23_;
#line 477 "search.vala"
		_tmp21_ = g_strdup_printf (ngettext ("%d match", "%d matches", (gulong) count), count);
#line 477 "search.vala"
		text = _tmp21_;
#line 478 "search.vala"
		_tmp22_ = self->priv->_info_label;
#line 478 "search.vala"
		_tmp23_ = text;
#line 478 "search.vala"
		gtk_label_set_text (_tmp22_, _tmp23_);
#line 467 "search.vala"
		_g_free0 (text);
#line 2340 "search.c"
	}
#line 437 "search.vala"
	_g_object_unref0 (buffer);
#line 2344 "search.c"
}

static void
search_and_replace_search_forward (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_;
#line 482 "search.vala"
	g_return_if_fail (self != NULL);
#line 484 "search.vala"
	_tmp0_ = self->priv->_search_context;
#line 484 "search.vala"
	if (_tmp0_ == NULL) {
#line 485 "search.vala"
		return;
#line 2373 "search.c"
	}
#line 491 "search.vala"
	_tmp1_ = self->priv->_search_context;
#line 491 "search.vala"
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
#line 491 "search.vala"
	_tmp3_ = _g_object_ref0 (IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL);
#line 491 "search.vala"
	doc = _tmp3_;
#line 492 "search.vala"
	_tmp4_ = doc;
#line 492 "search.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, NULL, &_tmp5_);
#line 492 "search.vala"
	iter = _tmp5_;
#line 494 "search.vala"
	_tmp6_ = self->priv->_search_context;
#line 494 "search.vala"
	_tmp7_ = iter;
#line 494 "search.vala"
	_tmp10_ = gtk_source_search_context_forward (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, NULL);
#line 494 "search.vala"
	match_start = _tmp8_;
#line 494 "search.vala"
	match_end = _tmp9_;
#line 494 "search.vala"
	if (_tmp10_) {
#line 2401 "search.c"
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		Document* _tmp14_;
		DocumentTab* _tmp15_;
		TeplView* _tmp16_;
		TeplView* _tmp17_;
#line 496 "search.vala"
		_tmp11_ = doc;
#line 496 "search.vala"
		_tmp12_ = match_start;
#line 496 "search.vala"
		_tmp13_ = match_end;
#line 496 "search.vala"
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
#line 497 "search.vala"
		_tmp14_ = doc;
#line 497 "search.vala"
		_tmp15_ = _tmp14_->tab;
#line 497 "search.vala"
		_tmp16_ = tepl_tab_get_view ((TeplTab*) _tmp15_);
#line 497 "search.vala"
		_tmp17_ = _tmp16_;
#line 497 "search.vala"
		tepl_view_scroll_to_cursor (_tmp17_);
#line 2427 "search.c"
	}
#line 482 "search.vala"
	_g_object_unref0 (doc);
#line 2431 "search.c"
}

static void
search_and_replace_search_backward (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_;
#line 501 "search.vala"
	g_return_if_fail (self != NULL);
#line 503 "search.vala"
	_tmp0_ = self->priv->_search_context;
#line 503 "search.vala"
	if (_tmp0_ == NULL) {
#line 504 "search.vala"
		return;
#line 2460 "search.c"
	}
#line 510 "search.vala"
	_tmp1_ = self->priv->_search_context;
#line 510 "search.vala"
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
#line 510 "search.vala"
	_tmp3_ = _g_object_ref0 (IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL);
#line 510 "search.vala"
	doc = _tmp3_;
#line 511 "search.vala"
	_tmp4_ = doc;
#line 511 "search.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, NULL);
#line 511 "search.vala"
	iter = _tmp5_;
#line 513 "search.vala"
	_tmp6_ = self->priv->_search_context;
#line 513 "search.vala"
	_tmp7_ = iter;
#line 513 "search.vala"
	_tmp10_ = gtk_source_search_context_backward (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, NULL);
#line 513 "search.vala"
	match_start = _tmp8_;
#line 513 "search.vala"
	match_end = _tmp9_;
#line 513 "search.vala"
	if (_tmp10_) {
#line 2488 "search.c"
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		Document* _tmp14_;
		DocumentTab* _tmp15_;
		TeplView* _tmp16_;
		TeplView* _tmp17_;
#line 515 "search.vala"
		_tmp11_ = doc;
#line 515 "search.vala"
		_tmp12_ = match_start;
#line 515 "search.vala"
		_tmp13_ = match_end;
#line 515 "search.vala"
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
#line 516 "search.vala"
		_tmp14_ = doc;
#line 516 "search.vala"
		_tmp15_ = _tmp14_->tab;
#line 516 "search.vala"
		_tmp16_ = tepl_tab_get_view ((TeplTab*) _tmp15_);
#line 516 "search.vala"
		_tmp17_ = _tmp16_;
#line 516 "search.vala"
		tepl_view_scroll_to_cursor (_tmp17_);
#line 2514 "search.c"
	}
#line 501 "search.vala"
	_g_object_unref0 (doc);
#line 2518 "search.c"
}

static void
search_and_replace_replace (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	MainWindow* _tmp7_;
	DocumentView* _tmp8_;
	DocumentView* _tmp9_;
	GtkSourceCompletion* _tmp10_;
	GtkSourceCompletion* _tmp11_;
	MainWindow* _tmp19_;
	DocumentView* _tmp20_;
	DocumentView* _tmp21_;
	GtkSourceCompletion* _tmp22_;
	GtkSourceCompletion* _tmp23_;
	GError* _inner_error0_ = NULL;
#line 520 "search.vala"
	g_return_if_fail (self != NULL);
#line 522 "search.vala"
	_tmp0_ = self->priv->_search_context;
#line 522 "search.vala"
	if (_tmp0_ == NULL) {
#line 523 "search.vala"
		return;
#line 2553 "search.c"
	}
#line 527 "search.vala"
	_tmp1_ = self->priv->_search_context;
#line 527 "search.vala"
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
#line 527 "search.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 527 "search.vala"
	buffer = _tmp3_;
#line 528 "search.vala"
	_tmp4_ = buffer;
#line 528 "search.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, &_tmp6_);
#line 528 "search.vala"
	match_start = _tmp5_;
#line 528 "search.vala"
	match_end = _tmp6_;
#line 530 "search.vala"
	_tmp7_ = self->priv->_main_window;
#line 530 "search.vala"
	_tmp8_ = main_window_get_active_view (_tmp7_);
#line 530 "search.vala"
	_tmp9_ = _tmp8_;
#line 530 "search.vala"
	_tmp10_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp9_);
#line 530 "search.vala"
	_tmp11_ = _tmp10_;
#line 530 "search.vala"
	gtk_source_completion_block_interactive (_tmp11_);
#line 2583 "search.c"
	{
		gboolean _tmp12_ = FALSE;
		GtkSourceSearchContext* _tmp13_;
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_;
		GtkSearchEntry* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 534 "search.vala"
		_tmp13_ = self->priv->_search_context;
#line 534 "search.vala"
		_tmp14_ = match_start;
#line 534 "search.vala"
		_tmp15_ = match_end;
#line 534 "search.vala"
		_tmp16_ = self->priv->_entry_replace;
#line 534 "search.vala"
		_tmp17_ = gtk_entry_get_text ((GtkEntry*) _tmp16_);
#line 534 "search.vala"
		_tmp18_ = _tmp17_;
#line 534 "search.vala"
		_tmp12_ = gtk_source_search_context_replace (_tmp13_, &_tmp14_, &_tmp15_, _tmp18_, -1, &_inner_error0_);
#line 534 "search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2608 "search.c"
			goto __catch37_g_error;
		}
#line 534 "search.vala"
		if (!_tmp12_) {
#line 536 "search.vala"
			search_and_replace_search_forward (self);
#line 2615 "search.c"
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
#line 532 "search.vala"
		e = _inner_error0_;
#line 532 "search.vala"
		_inner_error0_ = NULL;
#line 532 "search.vala"
		_g_error_free0 (e);
#line 2628 "search.c"
	}
	__finally37:
#line 532 "search.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 532 "search.vala"
		_g_object_unref0 (buffer);
#line 532 "search.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 532 "search.vala"
		g_clear_error (&_inner_error0_);
#line 532 "search.vala"
		return;
#line 2641 "search.c"
	}
#line 543 "search.vala"
	_tmp19_ = self->priv->_main_window;
#line 543 "search.vala"
	_tmp20_ = main_window_get_active_view (_tmp19_);
#line 543 "search.vala"
	_tmp21_ = _tmp20_;
#line 543 "search.vala"
	_tmp22_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp21_);
#line 543 "search.vala"
	_tmp23_ = _tmp22_;
#line 543 "search.vala"
	gtk_source_completion_unblock_interactive (_tmp23_);
#line 520 "search.vala"
	_g_object_unref0 (buffer);
#line 2657 "search.c"
}

static void
search_and_replace_class_init (SearchAndReplaceClass * klass,
                               gpointer klass_data)
{
#line 96 "search.vala"
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
#line 96 "search.vala"
	g_type_class_adjust_private_offset (klass, &SearchAndReplace_private_offset);
#line 96 "search.vala"
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
#line 2670 "search.c"
}

static void
search_and_replace_instance_init (SearchAndReplace * self,
                                  gpointer klass)
{
#line 96 "search.vala"
	self->priv = search_and_replace_get_instance_private (self);
#line 111 "search.vala"
	self->priv->_search_context = NULL;
#line 2681 "search.c"
}

static void
search_and_replace_finalize (GObject * obj)
{
	SearchAndReplace * self;
#line 96 "search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_AND_REPLACE, SearchAndReplace);
#line 100 "search.vala"
	_g_object_unref0 (self->priv->_main_grid);
#line 101 "search.vala"
	_g_object_unref0 (self->priv->_replace_grid);
#line 103 "search.vala"
	_g_object_unref0 (self->priv->_arrow);
#line 105 "search.vala"
	_g_object_unref0 (self->priv->_entry_find);
#line 106 "search.vala"
	_g_object_unref0 (self->priv->_entry_replace);
#line 108 "search.vala"
	_g_object_unref0 (self->priv->_info_label);
#line 110 "search.vala"
	_g_object_unref0 (self->priv->_search_settings);
#line 111 "search.vala"
	_g_object_unref0 (self->priv->_search_context);
#line 96 "search.vala"
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
#line 2708 "search.c"
}

GType
search_and_replace_get_type (void)
{
	static volatile gsize search_and_replace_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
		GType search_and_replace_type_id;
		search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
		SearchAndReplace_private_offset = g_type_add_instance_private (search_and_replace_type_id, sizeof (SearchAndReplacePrivate));
		g_once_init_leave (&search_and_replace_type_id__volatile, search_and_replace_type_id);
	}
	return search_and_replace_type_id__volatile;
}

