/* most_used_symbols.c generated by valac 0.46.7, the Vala compiler
 * generated from most_used_symbols.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
typedef struct _MostUsedSymbolsPrivate MostUsedSymbolsPrivate;
enum  {
	MOST_USED_SYMBOLS_0_PROPERTY,
	MOST_USED_SYMBOLS_NUM_PROPERTIES
};
static GParamSpec* most_used_symbols_properties[MOST_USED_SYMBOLS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	SYMBOL_COLUMN_PIXBUF,
	SYMBOL_COLUMN_COMMAND,
	SYMBOL_COLUMN_TOOLTIP,
	SYMBOL_COLUMN_ID,
	SYMBOL_COLUMN_N_COLUMNS
} SymbolColumn;

#define TYPE_SYMBOL_COLUMN (symbol_column_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MostUsedSymbols {
	GObject parent_instance;
	MostUsedSymbolsPrivate * priv;
};

struct _MostUsedSymbolsClass {
	GObjectClass parent_class;
};

struct _MostUsedSymbolsPrivate {
	gboolean _modified;
	GtkListStore* _store;
};

static gint MostUsedSymbols_private_offset;
static gpointer most_used_symbols_parent_class = NULL;
static MostUsedSymbols* most_used_symbols__instance;
static MostUsedSymbols* most_used_symbols__instance = NULL;

GType most_used_symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
GType symbol_column_get_type (void) G_GNUC_CONST;
#define MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM ((gint) SYMBOL_COLUMN_N_COLUMNS)
static MostUsedSymbols* most_used_symbols_new (void);
static MostUsedSymbols* most_used_symbols_construct (GType object_type);
static void most_used_symbols_init_models (MostUsedSymbols* self);
static void most_used_symbols_load_data (MostUsedSymbols* self);
MostUsedSymbols* most_used_symbols_get_default (void);
GtkTreeModel* most_used_symbols_get_model (MostUsedSymbols* self);
void most_used_symbols_clear (MostUsedSymbols* self);
void most_used_symbols_increment_symbol (MostUsedSymbols* self,
                                         const gchar* id);
static gboolean most_used_symbols_get_iter_at_symbol_id (MostUsedSymbols* self,
                                                  const gchar* id,
                                                  GtkTreeIter* iter);
static void most_used_symbols_add_symbol (MostUsedSymbols* self,
                                   const gchar* id,
                                   gint nb_times_used);
GdkPixbuf* symbols_get_pixbuf (const gchar* symbol_id);
GType symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Symbols, g_object_unref)
Symbols* symbols_get_default (void);
gboolean symbols_get_symbol_info (Symbols* self,
                                  const gchar* id,
                                  gchar* * command,
                                  gchar* * tooltip);
static GFile* most_used_symbols_get_xml_file (MostUsedSymbols* self);
gchar* utils_load_file (GFile* file);
static void most_used_symbols_parser_start (MostUsedSymbols* self,
                                     GMarkupParseContext* context,
                                     const gchar* name,
                                     gchar** attr_names,
                                     gint attr_names_length1,
                                     gchar** attr_values,
                                     gint attr_values_length1,
                                     GError** error);
static void _most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                        const gchar* element_name,
                                                                        gchar** attribute_names,
                                                                        gchar** attribute_values,
                                                                        gpointer self,
                                                                        GError** error);
void most_used_symbols_save (MostUsedSymbols* self);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
static void most_used_symbols_finalize (GObject * obj);
static gint _vala_array_length (gpointer array);

static inline gpointer
most_used_symbols_get_instance_private (MostUsedSymbols* self)
{
	return G_STRUCT_MEMBER_P (self, MostUsedSymbols_private_offset);
}

static MostUsedSymbols*
most_used_symbols_construct (GType object_type)
{
	MostUsedSymbols * self = NULL;
#line 33 "most_used_symbols.vala"
	self = (MostUsedSymbols*) g_object_new (object_type, NULL);
#line 35 "most_used_symbols.vala"
	most_used_symbols_init_models (self);
#line 36 "most_used_symbols.vala"
	most_used_symbols_load_data (self);
#line 33 "most_used_symbols.vala"
	return self;
#line 161 "most_used_symbols.c"
}

static MostUsedSymbols*
most_used_symbols_new (void)
{
#line 33 "most_used_symbols.vala"
	return most_used_symbols_construct (TYPE_MOST_USED_SYMBOLS);
#line 169 "most_used_symbols.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 45 "most_used_symbols.vala"
	return self ? g_object_ref (self) : NULL;
#line 177 "most_used_symbols.c"
}

MostUsedSymbols*
most_used_symbols_get_default (void)
{
	MostUsedSymbols* _tmp0_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
	MostUsedSymbols* result = NULL;
#line 42 "most_used_symbols.vala"
	_tmp0_ = most_used_symbols__instance;
#line 42 "most_used_symbols.vala"
	if (_tmp0_ == NULL) {
#line 191 "most_used_symbols.c"
		MostUsedSymbols* _tmp1_;
#line 43 "most_used_symbols.vala"
		_tmp1_ = most_used_symbols_new ();
#line 43 "most_used_symbols.vala"
		_g_object_unref0 (most_used_symbols__instance);
#line 43 "most_used_symbols.vala"
		most_used_symbols__instance = _tmp1_;
#line 199 "most_used_symbols.c"
	}
#line 45 "most_used_symbols.vala"
	_tmp2_ = most_used_symbols__instance;
#line 45 "most_used_symbols.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 45 "most_used_symbols.vala"
	result = _tmp3_;
#line 45 "most_used_symbols.vala"
	return result;
#line 209 "most_used_symbols.c"
}

static void
most_used_symbols_init_models (MostUsedSymbols* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
#line 48 "most_used_symbols.vala"
	g_return_if_fail (self != NULL);
#line 50 "most_used_symbols.vala"
	_tmp0_ = gtk_list_store_new ((gint) (SYMBOL_COLUMN_N_COLUMNS + 1), gdk_pixbuf_get_type (), G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, -1);
#line 50 "most_used_symbols.vala"
	_g_object_unref0 (self->priv->_store);
#line 50 "most_used_symbols.vala"
	self->priv->_store = _tmp0_;
#line 58 "most_used_symbols.vala"
	_tmp1_ = self->priv->_store;
#line 58 "most_used_symbols.vala"
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, GTK_SORT_DESCENDING);
#line 229 "most_used_symbols.c"
}

GtkTreeModel*
most_used_symbols_get_model (MostUsedSymbols* self)
{
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* result = NULL;
#line 61 "most_used_symbols.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "most_used_symbols.vala"
	_tmp0_ = self->priv->_store;
#line 63 "most_used_symbols.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp0_) : NULL);
#line 63 "most_used_symbols.vala"
	result = _tmp1_;
#line 63 "most_used_symbols.vala"
	return result;
#line 248 "most_used_symbols.c"
}

void
most_used_symbols_clear (MostUsedSymbols* self)
{
	GtkListStore* _tmp0_;
#line 66 "most_used_symbols.vala"
	g_return_if_fail (self != NULL);
#line 68 "most_used_symbols.vala"
	_tmp0_ = self->priv->_store;
#line 68 "most_used_symbols.vala"
	gtk_list_store_clear (_tmp0_);
#line 261 "most_used_symbols.c"
}

void
most_used_symbols_increment_symbol (MostUsedSymbols* self,
                                    const gchar* id)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
#line 71 "most_used_symbols.vala"
	g_return_if_fail (self != NULL);
#line 71 "most_used_symbols.vala"
	g_return_if_fail (id != NULL);
#line 75 "most_used_symbols.vala"
	_tmp1_ = most_used_symbols_get_iter_at_symbol_id (self, id, &_tmp0_);
#line 75 "most_used_symbols.vala"
	iter = _tmp0_;
#line 75 "most_used_symbols.vala"
	if (!_tmp1_) {
#line 76 "most_used_symbols.vala"
		most_used_symbols_add_symbol (self, id, 1);
#line 283 "most_used_symbols.c"
	} else {
		gint num = 0;
		GtkTreeModel* model = NULL;
		GtkListStore* _tmp2_;
		GtkTreeModel* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeIter _tmp5_;
		gint _tmp6_ = 0;
		GtkListStore* _tmp7_;
		GtkTreeIter _tmp8_;
#line 80 "most_used_symbols.vala"
		_tmp2_ = self->priv->_store;
#line 80 "most_used_symbols.vala"
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp2_) : NULL);
#line 80 "most_used_symbols.vala"
		model = _tmp3_;
#line 81 "most_used_symbols.vala"
		_tmp4_ = model;
#line 81 "most_used_symbols.vala"
		_tmp5_ = iter;
#line 81 "most_used_symbols.vala"
		gtk_tree_model_get (_tmp4_, &_tmp5_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, &_tmp6_, -1);
#line 81 "most_used_symbols.vala"
		num = _tmp6_;
#line 83 "most_used_symbols.vala"
		_tmp7_ = self->priv->_store;
#line 83 "most_used_symbols.vala"
		_tmp8_ = iter;
#line 83 "most_used_symbols.vala"
		gtk_list_store_set (_tmp7_, &_tmp8_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, num + 1, -1);
#line 75 "most_used_symbols.vala"
		_g_object_unref0 (model);
#line 316 "most_used_symbols.c"
	}
#line 86 "most_used_symbols.vala"
	self->priv->_modified = TRUE;
#line 320 "most_used_symbols.c"
}

static gboolean
most_used_symbols_get_iter_at_symbol_id (MostUsedSymbols* self,
                                         const gchar* id,
                                         GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result = FALSE;
#line 89 "most_used_symbols.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 89 "most_used_symbols.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 91 "most_used_symbols.vala"
	_tmp0_ = self->priv->_store;
#line 91 "most_used_symbols.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 91 "most_used_symbols.vala"
	_vala_iter = _tmp1_;
#line 91 "most_used_symbols.vala"
	if (!_tmp2_) {
#line 92 "most_used_symbols.vala"
		result = FALSE;
#line 92 "most_used_symbols.vala"
		if (iter) {
#line 92 "most_used_symbols.vala"
			*iter = _vala_iter;
#line 351 "most_used_symbols.c"
		}
#line 92 "most_used_symbols.vala"
		return result;
#line 355 "most_used_symbols.c"
	}
	{
		gboolean _tmp3_ = FALSE;
#line 94 "most_used_symbols.vala"
		_tmp3_ = TRUE;
#line 94 "most_used_symbols.vala"
		while (TRUE) {
#line 363 "most_used_symbols.c"
			gchar* cur_id = NULL;
			GtkTreeModel* model = NULL;
			GtkListStore* _tmp6_;
			GtkTreeModel* _tmp7_;
			GtkTreeModel* _tmp8_;
			GtkTreeIter _tmp9_;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_;
#line 94 "most_used_symbols.vala"
			if (!_tmp3_) {
#line 374 "most_used_symbols.c"
				GtkListStore* _tmp4_;
				gboolean _tmp5_;
#line 103 "most_used_symbols.vala"
				_tmp4_ = self->priv->_store;
#line 103 "most_used_symbols.vala"
				_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &_vala_iter);
#line 103 "most_used_symbols.vala"
				if (!_tmp5_) {
#line 103 "most_used_symbols.vala"
					break;
#line 385 "most_used_symbols.c"
				}
			}
#line 94 "most_used_symbols.vala"
			_tmp3_ = FALSE;
#line 97 "most_used_symbols.vala"
			_tmp6_ = self->priv->_store;
#line 97 "most_used_symbols.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp6_) : NULL);
#line 97 "most_used_symbols.vala"
			model = _tmp7_;
#line 98 "most_used_symbols.vala"
			_tmp8_ = model;
#line 98 "most_used_symbols.vala"
			_tmp9_ = _vala_iter;
#line 98 "most_used_symbols.vala"
			gtk_tree_model_get (_tmp8_, &_tmp9_, SYMBOL_COLUMN_ID, &_tmp10_, -1);
#line 98 "most_used_symbols.vala"
			_g_free0 (cur_id);
#line 98 "most_used_symbols.vala"
			cur_id = _tmp10_;
#line 100 "most_used_symbols.vala"
			_tmp11_ = cur_id;
#line 100 "most_used_symbols.vala"
			if (g_strcmp0 (_tmp11_, id) == 0) {
#line 101 "most_used_symbols.vala"
				result = TRUE;
#line 101 "most_used_symbols.vala"
				_g_object_unref0 (model);
#line 101 "most_used_symbols.vala"
				_g_free0 (cur_id);
#line 101 "most_used_symbols.vala"
				if (iter) {
#line 101 "most_used_symbols.vala"
					*iter = _vala_iter;
#line 420 "most_used_symbols.c"
				}
#line 101 "most_used_symbols.vala"
				return result;
#line 424 "most_used_symbols.c"
			}
#line 94 "most_used_symbols.vala"
			_g_object_unref0 (model);
#line 94 "most_used_symbols.vala"
			_g_free0 (cur_id);
#line 430 "most_used_symbols.c"
		}
	}
#line 105 "most_used_symbols.vala"
	result = FALSE;
#line 105 "most_used_symbols.vala"
	if (iter) {
#line 105 "most_used_symbols.vala"
		*iter = _vala_iter;
#line 439 "most_used_symbols.c"
	}
#line 105 "most_used_symbols.vala"
	return result;
#line 443 "most_used_symbols.c"
}

static void
most_used_symbols_add_symbol (MostUsedSymbols* self,
                              const gchar* id,
                              gint nb_times_used)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	gchar* command = NULL;
	gchar* tooltip = NULL;
	Symbols* _tmp2_;
	Symbols* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_;
	GdkPixbuf* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
#line 108 "most_used_symbols.vala"
	g_return_if_fail (self != NULL);
#line 108 "most_used_symbols.vala"
	g_return_if_fail (id != NULL);
#line 110 "most_used_symbols.vala"
	_tmp0_ = symbols_get_pixbuf (id);
#line 110 "most_used_symbols.vala"
	pixbuf = _tmp0_;
#line 111 "most_used_symbols.vala"
	_tmp1_ = pixbuf;
#line 111 "most_used_symbols.vala"
	if (_tmp1_ == NULL) {
#line 112 "most_used_symbols.vala"
		_g_object_unref0 (pixbuf);
#line 112 "most_used_symbols.vala"
		return;
#line 486 "most_used_symbols.c"
	}
#line 116 "most_used_symbols.vala"
	_tmp2_ = symbols_get_default ();
#line 116 "most_used_symbols.vala"
	_tmp3_ = _tmp2_;
#line 116 "most_used_symbols.vala"
	_tmp6_ = symbols_get_symbol_info (_tmp3_, id, &_tmp4_, &_tmp5_);
#line 116 "most_used_symbols.vala"
	_g_free0 (command);
#line 116 "most_used_symbols.vala"
	command = _tmp4_;
#line 116 "most_used_symbols.vala"
	_g_free0 (tooltip);
#line 116 "most_used_symbols.vala"
	tooltip = _tmp5_;
#line 116 "most_used_symbols.vala"
	_tmp7_ = !_tmp6_;
#line 116 "most_used_symbols.vala"
	_g_object_unref0 (_tmp3_);
#line 116 "most_used_symbols.vala"
	if (_tmp7_) {
#line 117 "most_used_symbols.vala"
		_g_free0 (tooltip);
#line 117 "most_used_symbols.vala"
		_g_free0 (command);
#line 117 "most_used_symbols.vala"
		_g_object_unref0 (pixbuf);
#line 117 "most_used_symbols.vala"
		return;
#line 516 "most_used_symbols.c"
	}
#line 120 "most_used_symbols.vala"
	_tmp8_ = self->priv->_store;
#line 120 "most_used_symbols.vala"
	gtk_list_store_append (_tmp8_, &_tmp9_);
#line 120 "most_used_symbols.vala"
	iter = _tmp9_;
#line 121 "most_used_symbols.vala"
	_tmp10_ = self->priv->_store;
#line 121 "most_used_symbols.vala"
	_tmp11_ = iter;
#line 121 "most_used_symbols.vala"
	_tmp12_ = pixbuf;
#line 121 "most_used_symbols.vala"
	_tmp13_ = command;
#line 121 "most_used_symbols.vala"
	_tmp14_ = tooltip;
#line 121 "most_used_symbols.vala"
	gtk_list_store_set (_tmp10_, &_tmp11_, SYMBOL_COLUMN_PIXBUF, _tmp12_, SYMBOL_COLUMN_COMMAND, _tmp13_, SYMBOL_COLUMN_TOOLTIP, _tmp14_, SYMBOL_COLUMN_ID, id, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, nb_times_used, -1);
#line 108 "most_used_symbols.vala"
	_g_free0 (tooltip);
#line 108 "most_used_symbols.vala"
	_g_free0 (command);
#line 108 "most_used_symbols.vala"
	_g_object_unref0 (pixbuf);
#line 542 "most_used_symbols.c"
}

static GFile*
most_used_symbols_get_xml_file (MostUsedSymbols* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* result = NULL;
#line 130 "most_used_symbols.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "most_used_symbols.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 132 "most_used_symbols.vala"
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "most_used_symbols.xml", NULL);
#line 132 "most_used_symbols.vala"
	path = _tmp1_;
#line 135 "most_used_symbols.vala"
	_tmp2_ = g_file_new_for_path (path);
#line 135 "most_used_symbols.vala"
	result = _tmp2_;
#line 135 "most_used_symbols.vala"
	_g_free0 (path);
#line 135 "most_used_symbols.vala"
	return result;
#line 569 "most_used_symbols.c"
}

static void
_most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                   const gchar* element_name,
                                                                   gchar** attribute_names,
                                                                   gchar** attribute_values,
                                                                   gpointer self,
                                                                   GError** error)
{
#line 150 "most_used_symbols.vala"
	most_used_symbols_parser_start ((MostUsedSymbols*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
#line 582 "most_used_symbols.c"
}

static void
most_used_symbols_load_data (MostUsedSymbols* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* contents = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 138 "most_used_symbols.vala"
	g_return_if_fail (self != NULL);
#line 140 "most_used_symbols.vala"
	_tmp0_ = most_used_symbols_get_xml_file (self);
#line 140 "most_used_symbols.vala"
	file = _tmp0_;
#line 141 "most_used_symbols.vala"
	_tmp1_ = file;
#line 141 "most_used_symbols.vala"
	if (!g_file_query_exists (_tmp1_, NULL)) {
#line 142 "most_used_symbols.vala"
		_g_object_unref0 (file);
#line 142 "most_used_symbols.vala"
		return;
#line 610 "most_used_symbols.c"
	}
#line 144 "most_used_symbols.vala"
	_tmp2_ = file;
#line 144 "most_used_symbols.vala"
	_tmp3_ = utils_load_file (_tmp2_);
#line 144 "most_used_symbols.vala"
	contents = _tmp3_;
#line 145 "most_used_symbols.vala"
	_tmp4_ = contents;
#line 145 "most_used_symbols.vala"
	if (_tmp4_ == NULL) {
#line 146 "most_used_symbols.vala"
		_g_free0 (contents);
#line 146 "most_used_symbols.vala"
		_g_object_unref0 (file);
#line 146 "most_used_symbols.vala"
		return;
#line 628 "most_used_symbols.c"
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp5_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp6_;
		GMarkupParseContext* _tmp7_;
		GMarkupParseContext* _tmp8_;
		const gchar* _tmp9_;
#line 150 "most_used_symbols.vala"
		_tmp5_.start_element = _most_used_symbols_parser_start_gmarkup_parser_start_element_func;
#line 150 "most_used_symbols.vala"
		_tmp5_.end_element = NULL;
#line 150 "most_used_symbols.vala"
		_tmp5_.text = NULL;
#line 150 "most_used_symbols.vala"
		_tmp5_.passthrough = NULL;
#line 150 "most_used_symbols.vala"
		_tmp5_.error = NULL;
#line 150 "most_used_symbols.vala"
		parser = _tmp5_;
#line 151 "most_used_symbols.vala"
		_tmp6_ = parser;
#line 151 "most_used_symbols.vala"
		_tmp7_ = g_markup_parse_context_new (&_tmp6_, 0, self, NULL);
#line 151 "most_used_symbols.vala"
		context = _tmp7_;
#line 152 "most_used_symbols.vala"
		_tmp8_ = context;
#line 152 "most_used_symbols.vala"
		_tmp9_ = contents;
#line 152 "most_used_symbols.vala"
		g_markup_parse_context_parse (_tmp8_, _tmp9_, (gssize) -1, &_inner_error0_);
#line 152 "most_used_symbols.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 152 "most_used_symbols.vala"
			_g_markup_parse_context_unref0 (context);
#line 666 "most_used_symbols.c"
			goto __catch30_g_error;
		}
#line 148 "most_used_symbols.vala"
		_g_markup_parse_context_unref0 (context);
#line 671 "most_used_symbols.c"
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 148 "most_used_symbols.vala"
		e = _inner_error0_;
#line 148 "most_used_symbols.vala"
		_inner_error0_ = NULL;
#line 156 "most_used_symbols.vala"
		_tmp10_ = e;
#line 156 "most_used_symbols.vala"
		_tmp11_ = _tmp10_->message;
#line 156 "most_used_symbols.vala"
		g_warning ("most_used_symbols.vala:156: Impossible to load the most used symbols: " \
"%s", _tmp11_);
#line 148 "most_used_symbols.vala"
		_g_error_free0 (e);
#line 691 "most_used_symbols.c"
	}
	__finally30:
#line 148 "most_used_symbols.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 148 "most_used_symbols.vala"
		_g_free0 (contents);
#line 148 "most_used_symbols.vala"
		_g_object_unref0 (file);
#line 148 "most_used_symbols.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 148 "most_used_symbols.vala"
		g_clear_error (&_inner_error0_);
#line 148 "most_used_symbols.vala"
		return;
#line 706 "most_used_symbols.c"
	}
#line 138 "most_used_symbols.vala"
	_g_free0 (contents);
#line 138 "most_used_symbols.vala"
	_g_object_unref0 (file);
#line 712 "most_used_symbols.c"
}

static void
most_used_symbols_parser_start (MostUsedSymbols* self,
                                GMarkupParseContext* context,
                                const gchar* name,
                                gchar** attr_names,
                                gint attr_names_length1,
                                gchar** attr_values,
                                gint attr_values_length1,
                                GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 163 "most_used_symbols.vala"
	static GQuark _tmp1_label0 = 0;
#line 163 "most_used_symbols.vala"
	static GQuark _tmp1_label1 = 0;
#line 731 "most_used_symbols.c"
	GError* _inner_error0_ = NULL;
#line 160 "most_used_symbols.vala"
	g_return_if_fail (self != NULL);
#line 160 "most_used_symbols.vala"
	g_return_if_fail (context != NULL);
#line 160 "most_used_symbols.vala"
	g_return_if_fail (name != NULL);
#line 163 "most_used_symbols.vala"
	_tmp0_ = name;
#line 163 "most_used_symbols.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 163 "most_used_symbols.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("symbols")))) {
#line 163 "most_used_symbols.vala"
		switch (0) {
#line 747 "most_used_symbols.c"
			default:
			{
#line 166 "most_used_symbols.vala"
				return;
#line 752 "most_used_symbols.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("symbol")))) {
#line 163 "most_used_symbols.vala"
		switch (0) {
#line 758 "most_used_symbols.c"
			default:
			{
				gchar* id = NULL;
				gint num = 0;
				const gchar* _tmp19_;
#line 169 "most_used_symbols.vala"
				id = NULL;
#line 170 "most_used_symbols.vala"
				num = 0;
#line 768 "most_used_symbols.c"
				{
					gint i = 0;
#line 172 "most_used_symbols.vala"
					i = 0;
#line 773 "most_used_symbols.c"
					{
						gboolean _tmp3_ = FALSE;
#line 172 "most_used_symbols.vala"
						_tmp3_ = TRUE;
#line 172 "most_used_symbols.vala"
						while (TRUE) {
#line 780 "most_used_symbols.c"
							const gchar* _tmp5_;
							const gchar* _tmp6_;
							GQuark _tmp8_ = 0U;
#line 174 "most_used_symbols.vala"
							static GQuark _tmp7_label0 = 0;
#line 174 "most_used_symbols.vala"
							static GQuark _tmp7_label1 = 0;
#line 174 "most_used_symbols.vala"
							static GQuark _tmp7_label2 = 0;
#line 174 "most_used_symbols.vala"
							static GQuark _tmp7_label3 = 0;
#line 172 "most_used_symbols.vala"
							if (!_tmp3_) {
#line 794 "most_used_symbols.c"
								gint _tmp4_;
#line 172 "most_used_symbols.vala"
								_tmp4_ = i;
#line 172 "most_used_symbols.vala"
								i = _tmp4_ + 1;
#line 800 "most_used_symbols.c"
							}
#line 172 "most_used_symbols.vala"
							_tmp3_ = FALSE;
#line 172 "most_used_symbols.vala"
							if (!(i < attr_names_length1)) {
#line 172 "most_used_symbols.vala"
								break;
#line 808 "most_used_symbols.c"
							}
#line 174 "most_used_symbols.vala"
							_tmp5_ = attr_names[i];
#line 174 "most_used_symbols.vala"
							_tmp6_ = _tmp5_;
#line 174 "most_used_symbols.vala"
							_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
#line 174 "most_used_symbols.vala"
							if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("id")))) {
#line 174 "most_used_symbols.vala"
								switch (0) {
#line 820 "most_used_symbols.c"
									default:
									{
										const gchar* _tmp9_;
										gchar* _tmp10_;
#line 177 "most_used_symbols.vala"
										_tmp9_ = attr_values[i];
#line 177 "most_used_symbols.vala"
										_tmp10_ = g_strdup (_tmp9_);
#line 177 "most_used_symbols.vala"
										_g_free0 (id);
#line 177 "most_used_symbols.vala"
										id = _tmp10_;
#line 178 "most_used_symbols.vala"
										break;
#line 835 "most_used_symbols.c"
									}
								}
							} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("num")))) {
#line 174 "most_used_symbols.vala"
								switch (0) {
#line 841 "most_used_symbols.c"
									default:
									{
										const gchar* _tmp11_;
#line 181 "most_used_symbols.vala"
										_tmp11_ = attr_values[i];
#line 181 "most_used_symbols.vala"
										num = atoi (_tmp11_);
#line 182 "most_used_symbols.vala"
										break;
#line 851 "most_used_symbols.c"
									}
								}
							} else if ((_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("command")))) || (_tmp8_ == ((0 != _tmp7_label3) ? _tmp7_label3 : (_tmp7_label3 = g_quark_from_static_string ("package"))))) {
#line 174 "most_used_symbols.vala"
								switch (0) {
#line 857 "most_used_symbols.c"
									default:
									{
#line 187 "most_used_symbols.vala"
										break;
#line 862 "most_used_symbols.c"
									}
								}
							} else {
#line 174 "most_used_symbols.vala"
								switch (0) {
#line 868 "most_used_symbols.c"
									default:
									{
										const gchar* _tmp12_;
										gchar* _tmp13_;
										gchar* _tmp14_;
										gchar* _tmp15_;
										gchar* _tmp16_;
										GError* _tmp17_;
										GError* _tmp18_;
#line 190 "most_used_symbols.vala"
										_tmp12_ = attr_names[i];
#line 190 "most_used_symbols.vala"
										_tmp13_ = g_strconcat ("unknown attribute \"", _tmp12_, NULL);
#line 190 "most_used_symbols.vala"
										_tmp14_ = _tmp13_;
#line 190 "most_used_symbols.vala"
										_tmp15_ = g_strconcat (_tmp14_, "\"", NULL);
#line 190 "most_used_symbols.vala"
										_tmp16_ = _tmp15_;
#line 190 "most_used_symbols.vala"
										_tmp17_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp16_);
#line 190 "most_used_symbols.vala"
										_tmp18_ = _tmp17_;
#line 190 "most_used_symbols.vala"
										_g_free0 (_tmp16_);
#line 190 "most_used_symbols.vala"
										_g_free0 (_tmp14_);
#line 190 "most_used_symbols.vala"
										_inner_error0_ = _tmp18_;
#line 190 "most_used_symbols.vala"
										if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 190 "most_used_symbols.vala"
											g_propagate_error (error, _inner_error0_);
#line 190 "most_used_symbols.vala"
											_g_free0 (id);
#line 190 "most_used_symbols.vala"
											return;
#line 906 "most_used_symbols.c"
										} else {
#line 190 "most_used_symbols.vala"
											_g_free0 (id);
#line 190 "most_used_symbols.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 190 "most_used_symbols.vala"
											g_clear_error (&_inner_error0_);
#line 190 "most_used_symbols.vala"
											return;
#line 916 "most_used_symbols.c"
										}
									}
								}
							}
						}
					}
				}
#line 195 "most_used_symbols.vala"
				_tmp19_ = id;
#line 195 "most_used_symbols.vala"
				most_used_symbols_add_symbol (self, _tmp19_, num);
#line 196 "most_used_symbols.vala"
				_g_free0 (id);
#line 196 "most_used_symbols.vala"
				break;
#line 932 "most_used_symbols.c"
			}
		}
	} else {
#line 163 "most_used_symbols.vala"
		switch (0) {
#line 938 "most_used_symbols.c"
			default:
			{
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				GError* _tmp24_;
				GError* _tmp25_;
#line 199 "most_used_symbols.vala"
				_tmp20_ = g_strconcat ("unknown element \"", name, NULL);
#line 199 "most_used_symbols.vala"
				_tmp21_ = _tmp20_;
#line 199 "most_used_symbols.vala"
				_tmp22_ = g_strconcat (_tmp21_, "\"", NULL);
#line 199 "most_used_symbols.vala"
				_tmp23_ = _tmp22_;
#line 199 "most_used_symbols.vala"
				_tmp24_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp23_);
#line 199 "most_used_symbols.vala"
				_tmp25_ = _tmp24_;
#line 199 "most_used_symbols.vala"
				_g_free0 (_tmp23_);
#line 199 "most_used_symbols.vala"
				_g_free0 (_tmp21_);
#line 199 "most_used_symbols.vala"
				_inner_error0_ = _tmp25_;
#line 199 "most_used_symbols.vala"
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 199 "most_used_symbols.vala"
					g_propagate_error (error, _inner_error0_);
#line 199 "most_used_symbols.vala"
					return;
#line 971 "most_used_symbols.c"
				} else {
#line 199 "most_used_symbols.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 199 "most_used_symbols.vala"
					g_clear_error (&_inner_error0_);
#line 199 "most_used_symbols.vala"
					return;
#line 979 "most_used_symbols.c"
				}
			}
		}
	}
}

void
most_used_symbols_save (MostUsedSymbols* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GtkTreeIter iter = {0};
	gboolean is_empty = FALSE;
	GtkListStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	gchar* content = NULL;
	gchar* _tmp5_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GFile* _tmp22_;
	const gchar* _tmp23_;
#line 204 "most_used_symbols.vala"
	g_return_if_fail (self != NULL);
#line 206 "most_used_symbols.vala"
	if (!self->priv->_modified) {
#line 207 "most_used_symbols.vala"
		return;
#line 1008 "most_used_symbols.c"
	}
#line 209 "most_used_symbols.vala"
	self->priv->_modified = FALSE;
#line 211 "most_used_symbols.vala"
	_tmp0_ = most_used_symbols_get_xml_file (self);
#line 211 "most_used_symbols.vala"
	file = _tmp0_;
#line 214 "most_used_symbols.vala"
	_tmp1_ = self->priv->_store;
#line 214 "most_used_symbols.vala"
	_tmp3_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp1_, &_tmp2_);
#line 214 "most_used_symbols.vala"
	iter = _tmp2_;
#line 214 "most_used_symbols.vala"
	is_empty = !_tmp3_;
#line 216 "most_used_symbols.vala"
	if (is_empty) {
#line 1026 "most_used_symbols.c"
		GFile* _tmp4_;
#line 218 "most_used_symbols.vala"
		_tmp4_ = file;
#line 218 "most_used_symbols.vala"
		utils_delete_file (_tmp4_);
#line 219 "most_used_symbols.vala"
		_g_object_unref0 (file);
#line 219 "most_used_symbols.vala"
		return;
#line 1036 "most_used_symbols.c"
	}
#line 222 "most_used_symbols.vala"
	_tmp5_ = g_strdup ("<symbols>\n");
#line 222 "most_used_symbols.vala"
	content = _tmp5_;
#line 1042 "most_used_symbols.c"
	{
		gboolean _tmp6_ = FALSE;
#line 224 "most_used_symbols.vala"
		_tmp6_ = TRUE;
#line 224 "most_used_symbols.vala"
		while (TRUE) {
#line 1049 "most_used_symbols.c"
			gchar* id = NULL;
			gint num = 0;
			GtkTreeModel* model = NULL;
			GtkListStore* _tmp9_;
			GtkTreeModel* _tmp10_;
			GtkTreeModel* _tmp11_;
			GtkTreeIter _tmp12_;
			gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
#line 224 "most_used_symbols.vala"
			if (!_tmp6_) {
#line 1066 "most_used_symbols.c"
				GtkListStore* _tmp7_;
				gboolean _tmp8_;
#line 237 "most_used_symbols.vala"
				_tmp7_ = self->priv->_store;
#line 237 "most_used_symbols.vala"
				_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &iter);
#line 237 "most_used_symbols.vala"
				if (!_tmp8_) {
#line 237 "most_used_symbols.vala"
					break;
#line 1077 "most_used_symbols.c"
				}
			}
#line 224 "most_used_symbols.vala"
			_tmp6_ = FALSE;
#line 229 "most_used_symbols.vala"
			_tmp9_ = self->priv->_store;
#line 229 "most_used_symbols.vala"
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp9_) : NULL);
#line 229 "most_used_symbols.vala"
			model = _tmp10_;
#line 230 "most_used_symbols.vala"
			_tmp11_ = model;
#line 230 "most_used_symbols.vala"
			_tmp12_ = iter;
#line 230 "most_used_symbols.vala"
			gtk_tree_model_get (_tmp11_, &_tmp12_, SYMBOL_COLUMN_ID, &_tmp13_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, &_tmp14_, -1);
#line 230 "most_used_symbols.vala"
			_g_free0 (id);
#line 230 "most_used_symbols.vala"
			id = _tmp13_;
#line 230 "most_used_symbols.vala"
			num = _tmp14_;
#line 235 "most_used_symbols.vala"
			_tmp15_ = content;
#line 235 "most_used_symbols.vala"
			_tmp16_ = id;
#line 235 "most_used_symbols.vala"
			_tmp17_ = g_strdup_printf ("  <symbol id=\"%s\" num=\"%d\" />\n", _tmp16_, num);
#line 235 "most_used_symbols.vala"
			_tmp18_ = _tmp17_;
#line 235 "most_used_symbols.vala"
			_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
#line 235 "most_used_symbols.vala"
			_g_free0 (content);
#line 235 "most_used_symbols.vala"
			content = _tmp19_;
#line 235 "most_used_symbols.vala"
			_g_free0 (_tmp18_);
#line 224 "most_used_symbols.vala"
			_g_object_unref0 (model);
#line 224 "most_used_symbols.vala"
			_g_free0 (id);
#line 1120 "most_used_symbols.c"
		}
	}
#line 239 "most_used_symbols.vala"
	_tmp20_ = content;
#line 239 "most_used_symbols.vala"
	_tmp21_ = g_strconcat (_tmp20_, "</symbols>\n", NULL);
#line 239 "most_used_symbols.vala"
	_g_free0 (content);
#line 239 "most_used_symbols.vala"
	content = _tmp21_;
#line 241 "most_used_symbols.vala"
	_tmp22_ = file;
#line 241 "most_used_symbols.vala"
	_tmp23_ = content;
#line 241 "most_used_symbols.vala"
	utils_save_file (_tmp22_, _tmp23_, FALSE);
#line 204 "most_used_symbols.vala"
	_g_free0 (content);
#line 204 "most_used_symbols.vala"
	_g_object_unref0 (file);
#line 1141 "most_used_symbols.c"
}

static void
most_used_symbols_class_init (MostUsedSymbolsClass * klass,
                              gpointer klass_data)
{
#line 24 "most_used_symbols.vala"
	most_used_symbols_parent_class = g_type_class_peek_parent (klass);
#line 24 "most_used_symbols.vala"
	g_type_class_adjust_private_offset (klass, &MostUsedSymbols_private_offset);
#line 24 "most_used_symbols.vala"
	G_OBJECT_CLASS (klass)->finalize = most_used_symbols_finalize;
#line 1154 "most_used_symbols.c"
}

static void
most_used_symbols_instance_init (MostUsedSymbols * self,
                                 gpointer klass)
{
#line 24 "most_used_symbols.vala"
	self->priv = most_used_symbols_get_instance_private (self);
#line 27 "most_used_symbols.vala"
	self->priv->_modified = FALSE;
#line 1165 "most_used_symbols.c"
}

static void
most_used_symbols_finalize (GObject * obj)
{
	MostUsedSymbols * self;
#line 24 "most_used_symbols.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOST_USED_SYMBOLS, MostUsedSymbols);
#line 28 "most_used_symbols.vala"
	_g_object_unref0 (self->priv->_store);
#line 24 "most_used_symbols.vala"
	G_OBJECT_CLASS (most_used_symbols_parent_class)->finalize (obj);
#line 1178 "most_used_symbols.c"
}

GType
most_used_symbols_get_type (void)
{
	static volatile gsize most_used_symbols_type_id__volatile = 0;
	if (g_once_init_enter (&most_used_symbols_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MostUsedSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) most_used_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MostUsedSymbols), 0, (GInstanceInitFunc) most_used_symbols_instance_init, NULL };
		GType most_used_symbols_type_id;
		most_used_symbols_type_id = g_type_register_static (G_TYPE_OBJECT, "MostUsedSymbols", &g_define_type_info, 0);
		MostUsedSymbols_private_offset = g_type_add_instance_private (most_used_symbols_type_id, sizeof (MostUsedSymbolsPrivate));
		g_once_init_leave (&most_used_symbols_type_id__volatile, most_used_symbols_type_id);
	}
	return most_used_symbols_type_id__volatile;
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 1206 "most_used_symbols.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 1211 "most_used_symbols.c"
}

