/* latex_menu.c generated by valac 0.46.7, the Vala compiler
 * generated from latex_menu.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <latexila.h>
#include <amtk/amtk.h>
#include <gio/gio.h>

#define TYPE_LATEX_MENU (latex_menu_get_type ())
#define LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_MENU, LatexMenu))
#define LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_MENU, LatexMenuClass))
#define IS_LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_MENU))
#define IS_LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_MENU))
#define LATEX_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_MENU, LatexMenuClass))

typedef struct _LatexMenu LatexMenu;
typedef struct _LatexMenuClass LatexMenuClass;
typedef struct _LatexMenuPrivate LatexMenuPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	LATEX_MENU_0_PROPERTY,
	LATEX_MENU_NUM_PROPERTIES
};
static GParamSpec* latex_menu_properties[LATEX_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MENU_TOOL_ACTION (menu_tool_action_get_type ())
#define MENU_TOOL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_TOOL_ACTION, MenuToolAction))
#define MENU_TOOL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_TOOL_ACTION, MenuToolActionClass))
#define IS_MENU_TOOL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_TOOL_ACTION))
#define IS_MENU_TOOL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_TOOL_ACTION))
#define MENU_TOOL_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_TOOL_ACTION, MenuToolActionClass))

typedef struct _MenuToolAction MenuToolAction;
typedef struct _MenuToolActionClass MenuToolActionClass;

struct _LatexMenu {
	GtkActionGroup parent_instance;
	LatexMenuPrivate * priv;
};

struct _LatexMenuClass {
	GtkActionGroupClass parent_class;
};

struct _LatexMenuPrivate {
	MainWindow* main_window;
};

static gint LatexMenu_private_offset;
static gpointer latex_menu_parent_class = NULL;

GType latex_menu_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LatexMenu, g_object_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
LatexMenu* latex_menu_new (MainWindow* main_window);
LatexMenu* latex_menu_construct (GType object_type,
                                 MainWindow* main_window);
static GtkAction* latex_menu_get_menu_tool_action (LatexMenu* self,
                                            const gchar* name,
                                            const gchar* label,
                                            const gchar* icon_name);
MenuToolAction* menu_tool_action_new (const gchar* name,
                                      const gchar* label,
                                      const gchar* tooltip,
                                      const gchar* icon_name);
MenuToolAction* menu_tool_action_construct (GType object_type,
                                            const gchar* name,
                                            const gchar* label,
                                            const gchar* tooltip,
                                            const gchar* icon_name);
GType menu_tool_action_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuToolAction, g_object_unref)
static void latex_menu_finalize (GObject * obj);

static const GtkActionEntry LATEX_MENU_latex_action_entries[23] = {{"Latex", NULL, "_LaTeX"}, {"Sectioning", "sectioning", N_ ("_Sectioning")}, {"References", "references", N_ ("_References")}, {"Environments", "format-justify-center", "_Environments"}, {"ListEnvironments", "list-itemize", N_ ("_List Environments")}, {"CharacterSize", "character-size", N_ ("_Characters Sizes")}, {"FontStyles", "bold", N_ ("_Font Styles")}, {"FontFamily", NULL, N_ ("_Font Family")}, {"FontSeries", NULL, N_ ("F_ont Series")}, {"FontShape", NULL, N_ ("Fo_nt Shape")}, {"Tabular", "table", N_ ("_Tabular")}, {"Presentation", "x-office-presentation", "_Presentation"}, {"Spacing", NULL, N_ ("_Spacing")}, {"Accents", NULL, N_ ("International _Accents")}, {"LatexMisc", NULL, N_ ("_Misc")}, {"Math", NULL, N_ ("_Math")}, {"MathEnvironments", NULL, N_ ("_Math Environments")}, {"MathFunctions", NULL, N_ ("Math _Functions")}, {"MathFontStyles", NULL, N_ ("Math Font _Styles")}, {"MathAccents", NULL, N_ ("Math _Accents")}, {"MathSpaces", NULL, N_ ("Math _Spaces")}, {"MathLeftDelimiters", "delimiters-left", N_ ("_Left Delimiters")}, {"MathRightDelimiters", "delimiters-right", N_ ("Right _Delimiters")}};

static inline gpointer
latex_menu_get_instance_private (LatexMenu* self)
{
	return G_STRUCT_MEMBER_P (self, LatexMenu_private_offset);
}

LatexMenu*
latex_menu_construct (GType object_type,
                      MainWindow* main_window)
{
	LatexMenu * self = NULL;
	GtkAction* sectioning = NULL;
	GtkAction* _tmp0_;
	GtkAction* sizes = NULL;
	GtkAction* _tmp1_;
	GtkAction* references = NULL;
	GtkAction* _tmp2_;
	GtkAction* presentation_env = NULL;
	GtkAction* _tmp3_;
	GtkAction* math_env = NULL;
	GtkAction* _tmp4_;
#line 58 "latex_menu.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 60 "latex_menu.vala"
	self = (LatexMenu*) g_object_new (object_type, "name", "LatexActionGroup", NULL);
#line 61 "latex_menu.vala"
	gtk_action_group_set_translation_domain ((GtkActionGroup*) self, GETTEXT_PACKAGE);
#line 63 "latex_menu.vala"
	self->priv->main_window = main_window;
#line 66 "latex_menu.vala"
	_tmp0_ = latex_menu_get_menu_tool_action (self, "SectioningToolItem", _ ("Sectioning"), "sectioning");
#line 66 "latex_menu.vala"
	sectioning = _tmp0_;
#line 69 "latex_menu.vala"
	_tmp1_ = latex_menu_get_menu_tool_action (self, "CharacterSizeToolItem", _ ("Characters Sizes"), "character-size");
#line 69 "latex_menu.vala"
	sizes = _tmp1_;
#line 72 "latex_menu.vala"
	_tmp2_ = latex_menu_get_menu_tool_action (self, "ReferencesToolItem", _ ("References"), "references");
#line 72 "latex_menu.vala"
	references = _tmp2_;
#line 75 "latex_menu.vala"
	_tmp3_ = latex_menu_get_menu_tool_action (self, "PresentationToolItem", _ ("Presentation Environments"), "x-office-presentation");
#line 75 "latex_menu.vala"
	presentation_env = _tmp3_;
#line 78 "latex_menu.vala"
	_tmp4_ = latex_menu_get_menu_tool_action (self, "MathEnvironmentsToolItem", _ ("Math Environments"), "math");
#line 78 "latex_menu.vala"
	math_env = _tmp4_;
#line 81 "latex_menu.vala"
	gtk_action_group_add_actions ((GtkActionGroup*) self, LATEX_MENU_latex_action_entries, (guint) G_N_ELEMENTS (LATEX_MENU_latex_action_entries), self);
#line 82 "latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, sectioning);
#line 83 "latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, sizes);
#line 84 "latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, references);
#line 85 "latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, presentation_env);
#line 86 "latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, math_env);
#line 90 "latex_menu.vala"
	latexila_latex_commands_add_actions ((GtkApplicationWindow*) main_window);
#line 93 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::part", (GtkActionGroup*) self, "SectioningPart");
#line 95 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::chapter", (GtkActionGroup*) self, "SectioningChapter");
#line 97 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::section", (GtkActionGroup*) self, "SectioningSection");
#line 99 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::subsection", (GtkActionGroup*) self, "SectioningSubsection");
#line 101 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::subsubsection", (GtkActionGroup*) self, "SectioningSubsubsection");
#line 103 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::paragraph", (GtkActionGroup*) self, "SectioningParagraph");
#line 105 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::subparagraph", (GtkActionGroup*) self, "SectioningSubparagraph");
#line 109 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::label", (GtkActionGroup*) self, "ReferencesLabel");
#line 111 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::ref", (GtkActionGroup*) self, "ReferencesRef");
#line 113 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::pageref", (GtkActionGroup*) self, "ReferencesPageref");
#line 115 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::index", (GtkActionGroup*) self, "ReferencesIndex");
#line 117 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::footnote", (GtkActionGroup*) self, "ReferencesFootnote");
#line 119 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::cite", (GtkActionGroup*) self, "ReferencesCite");
#line 123 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::center", (GtkActionGroup*) self, "EnvCenter");
#line 125 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::flushleft", (GtkActionGroup*) self, "EnvLeft");
#line 127 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::flushright", (GtkActionGroup*) self, "EnvRight");
#line 129 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-figure", (GtkActionGroup*) self, "EnvFigure");
#line 131 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-table", (GtkActionGroup*) self, "EnvTable");
#line 133 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::quote", (GtkActionGroup*) self, "EnvQuote");
#line 135 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::quotation", (GtkActionGroup*) self, "EnvQuotation");
#line 137 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::verse", (GtkActionGroup*) self, "EnvVerse");
#line 139 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::verbatim", (GtkActionGroup*) self, "EnvVerbatim");
#line 141 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::minipage", (GtkActionGroup*) self, "EnvMinipage");
#line 143 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::titlepage", (GtkActionGroup*) self, "EnvTitlepage");
#line 147 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-simple::itemize", (GtkActionGroup*) self, "ListEnvItemize");
#line 149 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-simple::enumerate", (GtkActionGroup*) self, "ListEnvEnumerate");
#line 151 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-description", (GtkActionGroup*) self, "ListEnvDescription");
#line 153 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-list", (GtkActionGroup*) self, "ListEnvList");
#line 155 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::item", (GtkActionGroup*) self, "ListEnvItem");
#line 159 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::tiny", (GtkActionGroup*) self, "CharacterSizeTiny");
#line 161 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::scriptsize", (GtkActionGroup*) self, "CharacterSizeScriptsize");
#line 163 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::footnotesize", (GtkActionGroup*) self, "CharacterSizeFootnotesize");
#line 165 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::small", (GtkActionGroup*) self, "CharacterSizeSmall");
#line 167 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::normalsize", (GtkActionGroup*) self, "CharacterSizeNormalsize");
#line 169 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::large", (GtkActionGroup*) self, "CharacterSizelarge");
#line 171 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::Large", (GtkActionGroup*) self, "CharacterSizeLarge");
#line 173 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::LARGE", (GtkActionGroup*) self, "CharacterSizeLARGE");
#line 175 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::huge", (GtkActionGroup*) self, "CharacterSizehuge");
#line 177 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::Huge", (GtkActionGroup*) self, "CharacterSizeHuge");
#line 181 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textbf", (GtkActionGroup*) self, "Bold");
#line 183 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textit", (GtkActionGroup*) self, "Italic");
#line 185 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::texttt", (GtkActionGroup*) self, "Typewriter");
#line 187 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textsl", (GtkActionGroup*) self, "Slanted");
#line 189 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textsc", (GtkActionGroup*) self, "SmallCaps");
#line 191 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textsf", (GtkActionGroup*) self, "SansSerif");
#line 193 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::emph", (GtkActionGroup*) self, "Emph");
#line 195 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::underline", (GtkActionGroup*) self, "Underline");
#line 198 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::rmfamily", (GtkActionGroup*) self, "FontFamilyRoman");
#line 200 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::sffamily", (GtkActionGroup*) self, "FontFamilySansSerif");
#line 202 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::ttfamily", (GtkActionGroup*) self, "FontFamilyMonospace");
#line 205 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::mdseries", (GtkActionGroup*) self, "FontSeriesMedium");
#line 207 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::bfseries", (GtkActionGroup*) self, "FontSeriesBold");
#line 210 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::upshape", (GtkActionGroup*) self, "FontShapeUpright");
#line 212 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::itshape", (GtkActionGroup*) self, "FontShapeItalic");
#line 214 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::slshape", (GtkActionGroup*) self, "FontShapeSlanted");
#line 216 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::scshape", (GtkActionGroup*) self, "FontShapeSmallCaps");
#line 220 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::tabbing", (GtkActionGroup*) self, "TabularTabbing");
#line 222 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-tabular-tabular", (GtkActionGroup*) self, "TabularTabular");
#line 224 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-tabular-multicolumn", (GtkActionGroup*) self, "TabularMulticolumn");
#line 226 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::hline", (GtkActionGroup*) self, "TabularHline");
#line 228 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::vline", (GtkActionGroup*) self, "TabularVline");
#line 230 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-tabular-cline", (GtkActionGroup*) self, "TabularCline");
#line 234 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-presentation-frame", (GtkActionGroup*) self, "PresentationFrame");
#line 236 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-presentation-block", (GtkActionGroup*) self, "PresentationBlock");
#line 238 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-presentation-columns", (GtkActionGroup*) self, "PresentationColumns");
#line 242 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-spacing-new-line", (GtkActionGroup*) self, "SpacingNewLine");
#line 244 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-newline::newpage", (GtkActionGroup*) self, "SpacingNewPage");
#line 246 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-newline::linebreak", (GtkActionGroup*) self, "SpacingLineBreak");
#line 248 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-newline::pagebreak", (GtkActionGroup*) self, "SpacingPageBreak");
#line 250 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::bigskip", (GtkActionGroup*) self, "SpacingBigSkip");
#line 252 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::medskip", (GtkActionGroup*) self, "SpacingMedSkip");
#line 254 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::hspace", (GtkActionGroup*) self, "SpacingHSpace");
#line 256 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::vspace", (GtkActionGroup*) self, "SpacingVSpace");
#line 258 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::noindent", (GtkActionGroup*) self, "SpacingNoIndent");
#line 262 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('\\'')", (GtkActionGroup*) self, "Accent0");
#line 264 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('`')", (GtkActionGroup*) self, "Accent1");
#line 266 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('^')", (GtkActionGroup*) self, "Accent2");
#line 268 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('\"')", (GtkActionGroup*) self, "Accent3");
#line 270 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('~')", (GtkActionGroup*) self, "Accent4");
#line 272 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('=')", (GtkActionGroup*) self, "Accent5");
#line 274 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('.')", (GtkActionGroup*) self, "Accent6");
#line 276 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('v')", (GtkActionGroup*) self, "Accent7");
#line 278 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('u')", (GtkActionGroup*) self, "Accent8");
#line 280 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('H')", (GtkActionGroup*) self, "Accent9");
#line 282 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('c')", (GtkActionGroup*) self, "Accent10");
#line 284 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('k')", (GtkActionGroup*) self, "Accent11");
#line 286 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('d')", (GtkActionGroup*) self, "Accent12");
#line 288 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('b')", (GtkActionGroup*) self, "Accent13");
#line 290 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('r')", (GtkActionGroup*) self, "Accent14");
#line 292 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('t')", (GtkActionGroup*) self, "Accent15");
#line 296 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::documentclass", (GtkActionGroup*) self, "LatexDocumentClass");
#line 298 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::usepackage", (GtkActionGroup*) self, "LatexUsepackage");
#line 300 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-ams-packages", (GtkActionGroup*) self, "LatexAMS");
#line 302 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::author", (GtkActionGroup*) self, "LatexAuthor");
#line 304 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::title", (GtkActionGroup*) self, "LatexTitle");
#line 306 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::document", (GtkActionGroup*) self, "LatexBeginDocument");
#line 308 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-simple::maketitle", (GtkActionGroup*) self, "LatexMakeTitle");
#line 310 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-simple::tableofcontents", (GtkActionGroup*) self, "LatexTableOfContents");
#line 312 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::abstract", (GtkActionGroup*) self, "LatexAbstract");
#line 314 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::includegraphics", (GtkActionGroup*) self, "LatexIncludeGraphics");
#line 316 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::input", (GtkActionGroup*) self, "LatexInput");
#line 320 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-env-normal", (GtkActionGroup*) self, "MathEnvNormal");
#line 322 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-env-centered", (GtkActionGroup*) self, "MathEnvCentered");
#line 324 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::equation", (GtkActionGroup*) self, "MathEnvNumbered");
#line 326 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-env-array", (GtkActionGroup*) self, "MathEnvArray");
#line 328 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::align", (GtkActionGroup*) self, "MathEnvNumberedArray");
#line 332 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-superscript", (GtkActionGroup*) self, "MathSuperscript");
#line 334 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-subscript", (GtkActionGroup*) self, "MathSubscript");
#line 336 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-frac", (GtkActionGroup*) self, "MathFrac");
#line 338 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::sqrt", (GtkActionGroup*) self, "MathSquareRoot");
#line 340 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-nth-root", (GtkActionGroup*) self, "MathNthRoot");
#line 344 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::arccos", (GtkActionGroup*) self, "MathFuncArccos");
#line 346 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::arcsin", (GtkActionGroup*) self, "MathFuncArcsin");
#line 348 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::arctan", (GtkActionGroup*) self, "MathFuncArctan");
#line 350 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::cos", (GtkActionGroup*) self, "MathFuncCos");
#line 352 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::cosh", (GtkActionGroup*) self, "MathFuncCosh");
#line 354 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::cot", (GtkActionGroup*) self, "MathFuncCot");
#line 356 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::coth", (GtkActionGroup*) self, "MathFuncCoth");
#line 358 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::csc", (GtkActionGroup*) self, "MathFuncCsc");
#line 360 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::deg", (GtkActionGroup*) self, "MathFuncDeg");
#line 362 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::det", (GtkActionGroup*) self, "MathFuncDet");
#line 364 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::dim", (GtkActionGroup*) self, "MathFuncDim");
#line 366 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::exp", (GtkActionGroup*) self, "MathFuncExp");
#line 368 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::gcd", (GtkActionGroup*) self, "MathFuncGcd");
#line 370 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::hom", (GtkActionGroup*) self, "MathFuncHom");
#line 372 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::inf", (GtkActionGroup*) self, "MathFuncInf");
#line 374 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::ker", (GtkActionGroup*) self, "MathFuncKer");
#line 376 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::lg", (GtkActionGroup*) self, "MathFuncLg");
#line 378 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::lim", (GtkActionGroup*) self, "MathFuncLim");
#line 380 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::liminf", (GtkActionGroup*) self, "MathFuncLiminf");
#line 382 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::limsup", (GtkActionGroup*) self, "MathFuncLimsup");
#line 384 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::ln", (GtkActionGroup*) self, "MathFuncLn");
#line 386 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::log", (GtkActionGroup*) self, "MathFuncLog");
#line 388 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::max", (GtkActionGroup*) self, "MathFuncMax");
#line 390 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::min", (GtkActionGroup*) self, "MathFuncMin");
#line 392 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sec", (GtkActionGroup*) self, "MathFuncSec");
#line 394 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sin", (GtkActionGroup*) self, "MathFuncSin");
#line 396 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sinh", (GtkActionGroup*) self, "MathFuncSinh");
#line 398 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sup", (GtkActionGroup*) self, "MathFuncSup");
#line 400 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::tan", (GtkActionGroup*) self, "MathFuncTan");
#line 402 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::tanh", (GtkActionGroup*) self, "MathFuncTanh");
#line 406 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathrm", (GtkActionGroup*) self, "MathFSrm");
#line 408 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathit", (GtkActionGroup*) self, "MathFSit");
#line 410 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathbf", (GtkActionGroup*) self, "MathFSbf");
#line 412 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathsf", (GtkActionGroup*) self, "MathFSsf");
#line 414 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathtt", (GtkActionGroup*) self, "MathFStt");
#line 416 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathcal", (GtkActionGroup*) self, "MathFScal");
#line 418 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathbb", (GtkActionGroup*) self, "MathFSbb");
#line 420 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathfrak", (GtkActionGroup*) self, "MathFSfrak");
#line 424 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::acute", (GtkActionGroup*) self, "MathAccentAcute");
#line 426 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::grave", (GtkActionGroup*) self, "MathAccentGrave");
#line 428 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::tilde", (GtkActionGroup*) self, "MathAccentTilde");
#line 430 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::bar", (GtkActionGroup*) self, "MathAccentBar");
#line 432 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::vec", (GtkActionGroup*) self, "MathAccentVec");
#line 434 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::hat", (GtkActionGroup*) self, "MathAccentHat");
#line 436 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::check", (GtkActionGroup*) self, "MathAccentCheck");
#line 438 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::breve", (GtkActionGroup*) self, "MathAccentBreve");
#line 440 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::dot", (GtkActionGroup*) self, "MathAccentDot");
#line 442 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::ddot", (GtkActionGroup*) self, "MathAccentDdot");
#line 444 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathring", (GtkActionGroup*) self, "MathAccentRing");
#line 448 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-spaces-small", (GtkActionGroup*) self, "MathSpaceSmall");
#line 450 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-spaces-medium", (GtkActionGroup*) self, "MathSpaceMedium");
#line 452 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-spaces-large", (GtkActionGroup*) self, "MathSpaceLarge");
#line 454 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::quad", (GtkActionGroup*) self, "MathSpaceQuad");
#line 456 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::qquad", (GtkActionGroup*) self, "MathSpaceQquad");
#line 460 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left1", (GtkActionGroup*) self, "MathLeftDelimiter1");
#line 462 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left2", (GtkActionGroup*) self, "MathLeftDelimiter2");
#line 464 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left3", (GtkActionGroup*) self, "MathLeftDelimiter3");
#line 466 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left4", (GtkActionGroup*) self, "MathLeftDelimiter4");
#line 468 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left5", (GtkActionGroup*) self, "MathLeftDelimiter5");
#line 470 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left6", (GtkActionGroup*) self, "MathLeftDelimiter6");
#line 472 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left7", (GtkActionGroup*) self, "MathLeftDelimiter7");
#line 474 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left8", (GtkActionGroup*) self, "MathLeftDelimiter8");
#line 476 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left9", (GtkActionGroup*) self, "MathLeftDelimiter9");
#line 480 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right1", (GtkActionGroup*) self, "MathRightDelimiter1");
#line 482 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right2", (GtkActionGroup*) self, "MathRightDelimiter2");
#line 484 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right3", (GtkActionGroup*) self, "MathRightDelimiter3");
#line 486 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right4", (GtkActionGroup*) self, "MathRightDelimiter4");
#line 488 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right5", (GtkActionGroup*) self, "MathRightDelimiter5");
#line 490 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right6", (GtkActionGroup*) self, "MathRightDelimiter6");
#line 492 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right7", (GtkActionGroup*) self, "MathRightDelimiter7");
#line 494 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right8", (GtkActionGroup*) self, "MathRightDelimiter8");
#line 496 "latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right9", (GtkActionGroup*) self, "MathRightDelimiter9");
#line 58 "latex_menu.vala"
	_g_object_unref0 (math_env);
#line 58 "latex_menu.vala"
	_g_object_unref0 (presentation_env);
#line 58 "latex_menu.vala"
	_g_object_unref0 (references);
#line 58 "latex_menu.vala"
	_g_object_unref0 (sizes);
#line 58 "latex_menu.vala"
	_g_object_unref0 (sectioning);
#line 58 "latex_menu.vala"
	return self;
#line 555 "latex_menu.c"
}

LatexMenu*
latex_menu_new (MainWindow* main_window)
{
#line 58 "latex_menu.vala"
	return latex_menu_construct (TYPE_LATEX_MENU, main_window);
#line 563 "latex_menu.c"
}

static GtkAction*
latex_menu_get_menu_tool_action (LatexMenu* self,
                                 const gchar* name,
                                 const gchar* label,
                                 const gchar* icon_name)
{
	GtkAction* action = NULL;
	MenuToolAction* _tmp0_;
	GtkMenuToolButton* menu_tool_button = NULL;
	GtkMenuToolButton* _tmp1_;
	GtkAction* result = NULL;
#line 500 "latex_menu.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 500 "latex_menu.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 502 "latex_menu.vala"
	_tmp0_ = menu_tool_action_new (name, label, label, icon_name);
#line 502 "latex_menu.vala"
	action = (GtkAction*) _tmp0_;
#line 503 "latex_menu.vala"
	_tmp1_ = (GtkMenuToolButton*) gtk_menu_tool_button_new (NULL, NULL);
#line 503 "latex_menu.vala"
	g_object_ref_sink (_tmp1_);
#line 503 "latex_menu.vala"
	menu_tool_button = _tmp1_;
#line 504 "latex_menu.vala"
	gtk_activatable_set_related_action ((GtkActivatable*) menu_tool_button, action);
#line 505 "latex_menu.vala"
	result = action;
#line 505 "latex_menu.vala"
	_g_object_unref0 (menu_tool_button);
#line 505 "latex_menu.vala"
	return result;
#line 599 "latex_menu.c"
}

static void
latex_menu_class_init (LatexMenuClass * klass,
                       gpointer klass_data)
{
#line 22 "latex_menu.vala"
	latex_menu_parent_class = g_type_class_peek_parent (klass);
#line 22 "latex_menu.vala"
	g_type_class_adjust_private_offset (klass, &LatexMenu_private_offset);
#line 22 "latex_menu.vala"
	G_OBJECT_CLASS (klass)->finalize = latex_menu_finalize;
#line 612 "latex_menu.c"
}

static void
latex_menu_instance_init (LatexMenu * self,
                          gpointer klass)
{
#line 22 "latex_menu.vala"
	self->priv = latex_menu_get_instance_private (self);
#line 621 "latex_menu.c"
}

static void
latex_menu_finalize (GObject * obj)
{
	LatexMenu * self;
#line 22 "latex_menu.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LATEX_MENU, LatexMenu);
#line 22 "latex_menu.vala"
	G_OBJECT_CLASS (latex_menu_parent_class)->finalize (obj);
#line 632 "latex_menu.c"
}

GType
latex_menu_get_type (void)
{
	static volatile gsize latex_menu_type_id__volatile = 0;
	if (g_once_init_enter (&latex_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latex_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexMenu), 0, (GInstanceInitFunc) latex_menu_instance_init, NULL };
		GType latex_menu_type_id;
		latex_menu_type_id = g_type_register_static (gtk_action_group_get_type (), "LatexMenu", &g_define_type_info, 0);
		LatexMenu_private_offset = g_type_add_instance_private (latex_menu_type_id, sizeof (LatexMenuPrivate));
		g_once_init_leave (&latex_menu_type_id__volatile, latex_menu_type_id);
	}
	return latex_menu_type_id__volatile;
}

