/* glatex_app.c generated by valac 0.46.7, the Vala compiler
 * generated from glatex_app.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <latexila.h>
#include <gdk/gdk.h>
#include <gee.h>

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;
typedef struct _GlatexAppPrivate GlatexAppPrivate;
enum  {
	GLATEX_APP_0_PROPERTY,
	GLATEX_APP_NUM_PROPERTIES
};
static GParamSpec* glatex_app_properties[GLATEX_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block21Data Block21Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

struct _GlatexApp {
	GtkApplication parent_instance;
	GlatexAppPrivate * priv;
};

struct _GlatexAppClass {
	GtkApplicationClass parent_class;
};

struct _Block21Data {
	int _ref_count_;
	GlatexApp* self;
	gboolean show_version;
	gboolean new_document;
	gboolean new_window;
};

static gpointer glatex_app_parent_class = NULL;
static GtkCssProvider* glatex_app__provider;
static GtkCssProvider* glatex_app__provider = NULL;

GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
static void glatex_app_new_document_cb (GlatexApp* self);
static void _glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void glatex_app_preferences_cb (GlatexApp* self);
static void _glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void glatex_app_manage_build_tools_cb (GlatexApp* self);
static void _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void glatex_app_help_cb (GlatexApp* self);
static void _glatex_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void glatex_app_about_cb (GlatexApp* self);
static void _glatex_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void glatex_app_quit_cb (GlatexApp* self);
static void _glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
GlatexApp* glatex_app_new (void);
GlatexApp* glatex_app_construct (GType object_type);
static void glatex_app_setup_main_option_entries (GlatexApp* self);
static void glatex_app_startup_cb (GlatexApp* self);
static void _glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                                   gpointer self);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                gint files_length1);
static void _glatex_app_open_documents_g_application_open (GApplication* _sender,
                                                    GFile** files,
                                                    gint n_files,
                                                    const gchar* hint,
                                                    gpointer self);
static void glatex_app_shutdown_cb (GlatexApp* self);
static void _glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                     gpointer self);
GlatexApp* glatex_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gint __lambda116_ (Block21Data* _data21_);
static gint ___lambda116__g_application_handle_local_options (GApplication* _sender,
                                                       GVariantDict* options,
                                                       gpointer self);
static void glatex_app_setup_theme_extensions (GlatexApp* self);
GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
AppSettings* app_settings_get_default (void);
static void glatex_app_support_backward_search (GlatexApp* self);
static gchar* glatex_app_get_accel_filename (GlatexApp* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
Projects* projects_get_default (void);
void projects_save (Projects* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
MainWindow* glatex_app_create_window (GlatexApp* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
void preferences_dialog_show_me (GtkWindow* parent);
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type,
                                                          GtkWindow* parent_window);
GType build_tools_preferences_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolsPreferences, g_object_unref)
gboolean main_window_quit (MainWindow* self);
static void glatex_app_update_theme (GlatexApp* self);
static void _glatex_app_update_theme_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GeeList* glatex_app_get_documents (GlatexApp* self);
GeeList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
GeeList* glatex_app_get_views (GlatexApp* self);
GeeList* main_window_get_views (MainWindow* self);
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void __lambda117_ (GlatexApp* self,
                   const gchar* tex_uri,
                   gint line,
                   guint timestamp);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
static void ___lambda117__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                     const gchar* tex_uri,
                                                     gint line,
                                                     guint timestamp,
                                                     gpointer self);
static void glatex_app_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry GLATEX_APP__app_actions[6] = {{"new-document", _glatex_app_new_document_cb_gsimple_action_activate_callback}, {"preferences", _glatex_app_preferences_cb_gsimple_action_activate_callback}, {"manage-build-tools", _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback}, {"help", _glatex_app_help_cb_gsimple_action_activate_callback}, {"about", _glatex_app_about_cb_gsimple_action_activate_callback}, {"quit", _glatex_app_quit_cb_gsimple_action_activate_callback}};

static void
_glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
#line 26 "glatex_app.vala"
	glatex_app_new_document_cb ((GlatexApp*) self);
#line 298 "glatex_app.c"
}

static void
_glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
#line 26 "glatex_app.vala"
	glatex_app_preferences_cb ((GlatexApp*) self);
#line 308 "glatex_app.c"
}

static void
_glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
#line 26 "glatex_app.vala"
	glatex_app_manage_build_tools_cb ((GlatexApp*) self);
#line 318 "glatex_app.c"
}

static void
_glatex_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 26 "glatex_app.vala"
	glatex_app_help_cb ((GlatexApp*) self);
#line 328 "glatex_app.c"
}

static void
_glatex_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
#line 26 "glatex_app.vala"
	glatex_app_about_cb ((GlatexApp*) self);
#line 338 "glatex_app.c"
}

static void
_glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 26 "glatex_app.vala"
	glatex_app_quit_cb ((GlatexApp*) self);
#line 348 "glatex_app.c"
}

static void
_glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                              gpointer self)
{
#line 45 "glatex_app.vala"
	glatex_app_startup_cb ((GlatexApp*) self);
#line 357 "glatex_app.c"
}

static void
_glatex_app_open_documents_g_application_open (GApplication* _sender,
                                               GFile** files,
                                               gint n_files,
                                               const gchar* hint,
                                               gpointer self)
{
#line 46 "glatex_app.vala"
	glatex_app_open_documents ((GlatexApp*) self, files, n_files);
#line 369 "glatex_app.c"
}

static void
_glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                gpointer self)
{
#line 47 "glatex_app.vala"
	glatex_app_shutdown_cb ((GlatexApp*) self);
#line 378 "glatex_app.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 49 "glatex_app.vala"
	return self ? g_object_ref (self) : NULL;
#line 386 "glatex_app.c"
}

GlatexApp*
glatex_app_construct (GType object_type)
{
	GlatexApp * self = NULL;
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
#line 38 "glatex_app.vala"
	self = (GlatexApp*) g_object_new (object_type, "application-id", "org.gnome.gnome-latex", NULL);
#line 39 "glatex_app.vala"
	g_application_set_flags ((GApplication*) self, G_APPLICATION_HANDLES_OPEN);
#line 40 "glatex_app.vala"
	g_set_application_name (PACKAGE_NAME);
#line 41 "glatex_app.vala"
	gtk_window_set_default_icon_name ("gnome-latex");
#line 43 "glatex_app.vala"
	glatex_app_setup_main_option_entries (self);
#line 45 "glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _glatex_app_startup_cb_g_application_startup, self, 0);
#line 46 "glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "open", (GCallback) _glatex_app_open_documents_g_application_open, self, 0);
#line 47 "glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) _glatex_app_shutdown_cb_g_application_shutdown, self, 0);
#line 49 "glatex_app.vala"
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
#line 49 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 49 "glatex_app.vala"
	tepl_app = _tmp1_;
#line 50 "glatex_app.vala"
	tepl_application_handle_activate (tepl_app);
#line 51 "glatex_app.vala"
	tepl_application_handle_metadata (tepl_app);
#line 36 "glatex_app.vala"
	_g_object_unref0 (tepl_app);
#line 36 "glatex_app.vala"
	return self;
#line 426 "glatex_app.c"
}

GlatexApp*
glatex_app_new (void)
{
#line 36 "glatex_app.vala"
	return glatex_app_construct (TYPE_GLATEX_APP);
#line 434 "glatex_app.c"
}

GlatexApp*
glatex_app_get_instance (void)
{
	GApplication* _tmp0_;
	GlatexApp* _tmp1_;
	GlatexApp* result = NULL;
#line 56 "glatex_app.vala"
	_tmp0_ = g_application_get_default ();
#line 56 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (IS_GLATEX_APP (_tmp0_) ? ((GlatexApp*) _tmp0_) : NULL);
#line 56 "glatex_app.vala"
	result = _tmp1_;
#line 56 "glatex_app.vala"
	return result;
#line 451 "glatex_app.c"
}

MainWindow*
glatex_app_get_active_main_window (GlatexApp* self)
{
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
	GtkApplicationWindow* main_window = NULL;
	TeplApplication* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	GtkApplicationWindow* _tmp6_;
	MainWindow* _tmp7_;
	MainWindow* result = NULL;
#line 59 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "glatex_app.vala"
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
#line 61 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 61 "glatex_app.vala"
	tepl_app = _tmp1_;
#line 62 "glatex_app.vala"
	_tmp2_ = tepl_app;
#line 62 "glatex_app.vala"
	_tmp3_ = tepl_application_get_active_main_window (_tmp2_);
#line 62 "glatex_app.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 62 "glatex_app.vala"
	main_window = _tmp4_;
#line 64 "glatex_app.vala"
	_tmp5_ = main_window;
#line 64 "glatex_app.vala"
	if (_tmp5_ == NULL) {
#line 65 "glatex_app.vala"
		result = NULL;
#line 65 "glatex_app.vala"
		_g_object_unref0 (main_window);
#line 65 "glatex_app.vala"
		_g_object_unref0 (tepl_app);
#line 65 "glatex_app.vala"
		return result;
#line 496 "glatex_app.c"
	}
#line 67 "glatex_app.vala"
	_tmp6_ = main_window;
#line 67 "glatex_app.vala"
	_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
#line 67 "glatex_app.vala"
	result = _tmp7_;
#line 67 "glatex_app.vala"
	_g_object_unref0 (main_window);
#line 67 "glatex_app.vala"
	_g_object_unref0 (tepl_app);
#line 67 "glatex_app.vala"
	return result;
#line 510 "glatex_app.c"
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
#line 70 "glatex_app.vala"
	g_atomic_int_inc (&_data21_->_ref_count_);
#line 70 "glatex_app.vala"
	return _data21_;
#line 520 "glatex_app.c"
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
#line 70 "glatex_app.vala"
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
#line 530 "glatex_app.c"
		GlatexApp* self;
#line 70 "glatex_app.vala"
		self = _data21_->self;
#line 70 "glatex_app.vala"
		_g_object_unref0 (self);
#line 70 "glatex_app.vala"
		g_slice_free (Block21Data, _data21_);
#line 538 "glatex_app.c"
	}
}

static gint
__lambda116_ (Block21Data* _data21_)
{
	GlatexApp* self;
	GError* _inner_error0_ = NULL;
	gint result = 0;
#line 91 "glatex_app.vala"
	self = _data21_->self;
#line 93 "glatex_app.vala"
	if (_data21_->show_version) {
#line 552 "glatex_app.c"
		FILE* _tmp0_;
#line 95 "glatex_app.vala"
		_tmp0_ = stdout;
#line 95 "glatex_app.vala"
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
#line 96 "glatex_app.vala"
		result = 0;
#line 96 "glatex_app.vala"
		return result;
#line 562 "glatex_app.c"
	}
	{
#line 101 "glatex_app.vala"
		g_application_register ((GApplication*) self, NULL, &_inner_error0_);
#line 101 "glatex_app.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 569 "glatex_app.c"
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
#line 99 "glatex_app.vala"
		e = _inner_error0_;
#line 99 "glatex_app.vala"
		_inner_error0_ = NULL;
#line 105 "glatex_app.vala"
		_tmp1_ = e->message;
#line 105 "glatex_app.vala"
		g_error ("glatex_app.vala:105: Failed to register the application: %s", _tmp1_);
#line 99 "glatex_app.vala"
		_g_error_free0 (e);
#line 588 "glatex_app.c"
	}
	__finally22:
#line 99 "glatex_app.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 593 "glatex_app.c"
		gint _tmp2_ = -1;
#line 99 "glatex_app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 99 "glatex_app.vala"
		g_clear_error (&_inner_error0_);
#line 99 "glatex_app.vala"
		return _tmp2_;
#line 601 "glatex_app.c"
	}
#line 108 "glatex_app.vala"
	if (_data21_->new_window) {
#line 109 "glatex_app.vala"
		g_action_group_activate_action ((GActionGroup*) self, "tepl-new-window", NULL);
#line 607 "glatex_app.c"
	}
#line 111 "glatex_app.vala"
	if (_data21_->new_document) {
#line 112 "glatex_app.vala"
		g_action_group_activate_action ((GActionGroup*) self, "new-document", NULL);
#line 613 "glatex_app.c"
	}
#line 114 "glatex_app.vala"
	result = -1;
#line 114 "glatex_app.vala"
	return result;
#line 619 "glatex_app.c"
}

static gint
___lambda116__g_application_handle_local_options (GApplication* _sender,
                                                  GVariantDict* options,
                                                  gpointer self)
{
	gint result;
	result = __lambda116_ (self);
#line 91 "glatex_app.vala"
	return result;
#line 631 "glatex_app.c"
}

static void
glatex_app_setup_main_option_entries (GlatexApp* self)
{
	Block21Data* _data21_;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp0_;
	gint options_length1;
	gint _options_size_;
	GOptionEntry _tmp1_ = {0};
	GOptionEntry _tmp2_ = {0};
	GOptionEntry _tmp3_ = {0};
	GOptionEntry _tmp4_ = {0};
#line 70 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 70 "glatex_app.vala"
	_data21_ = g_slice_new0 (Block21Data);
#line 70 "glatex_app.vala"
	_data21_->_ref_count_ = 1;
#line 70 "glatex_app.vala"
	_data21_->self = g_object_ref (self);
#line 72 "glatex_app.vala"
	_data21_->show_version = FALSE;
#line 73 "glatex_app.vala"
	_data21_->new_document = FALSE;
#line 74 "glatex_app.vala"
	_data21_->new_window = FALSE;
#line 76 "glatex_app.vala"
	_tmp0_ = g_new0 (GOptionEntry, 4);
#line 76 "glatex_app.vala"
	options = _tmp0_;
#line 76 "glatex_app.vala"
	options_length1 = 4;
#line 76 "glatex_app.vala"
	_options_size_ = options_length1;
#line 78 "glatex_app.vala"
	_tmp1_.long_name = "version";
#line 78 "glatex_app.vala"
	_tmp1_.short_name = 'V';
#line 78 "glatex_app.vala"
	_tmp1_.flags = 0;
#line 78 "glatex_app.vala"
	_tmp1_.arg = G_OPTION_ARG_NONE;
#line 78 "glatex_app.vala"
	_tmp1_.arg_data = &_data21_->show_version;
#line 78 "glatex_app.vala"
	_tmp1_.description = N_ ("Show the application’s version");
#line 78 "glatex_app.vala"
	_tmp1_.arg_description = NULL;
#line 78 "glatex_app.vala"
	options[0] = _tmp1_;
#line 81 "glatex_app.vala"
	_tmp2_.long_name = "new-document";
#line 81 "glatex_app.vala"
	_tmp2_.short_name = 'n';
#line 81 "glatex_app.vala"
	_tmp2_.flags = 0;
#line 81 "glatex_app.vala"
	_tmp2_.arg = G_OPTION_ARG_NONE;
#line 81 "glatex_app.vala"
	_tmp2_.arg_data = &_data21_->new_document;
#line 81 "glatex_app.vala"
	_tmp2_.description = N_ ("Create new document");
#line 81 "glatex_app.vala"
	_tmp2_.arg_description = NULL;
#line 81 "glatex_app.vala"
	options[1] = _tmp2_;
#line 84 "glatex_app.vala"
	_tmp3_.long_name = "new-window";
#line 84 "glatex_app.vala"
	_tmp3_.short_name = (gchar) 0;
#line 84 "glatex_app.vala"
	_tmp3_.flags = 0;
#line 84 "glatex_app.vala"
	_tmp3_.arg = G_OPTION_ARG_NONE;
#line 84 "glatex_app.vala"
	_tmp3_.arg_data = &_data21_->new_window;
#line 84 "glatex_app.vala"
	_tmp3_.description = N_ ("Create a new top-level window in an existing instance of GNOME LaTeX");
#line 84 "glatex_app.vala"
	_tmp3_.arg_description = NULL;
#line 84 "glatex_app.vala"
	options[2] = _tmp3_;
#line 87 "glatex_app.vala"
	_tmp4_.long_name = NULL;
#line 87 "glatex_app.vala"
	options[3] = _tmp4_;
#line 89 "glatex_app.vala"
	g_application_add_main_option_entries ((GApplication*) self, options);
#line 91 "glatex_app.vala"
	g_signal_connect_data ((GApplication*) self, "handle-local-options", (GCallback) ___lambda116__g_application_handle_local_options, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
#line 70 "glatex_app.vala"
	options = (g_free (options), NULL);
#line 70 "glatex_app.vala"
	block21_data_unref (_data21_);
#line 70 "glatex_app.vala"
	_data21_ = NULL;
#line 730 "glatex_app.c"
}

static void
glatex_app_startup_cb (GlatexApp* self)
{
	AppSettings* _tmp0_;
	AppSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 118 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 120 "glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 122 "glatex_app.vala"
	latexila_utils_migrate_latexila_to_gnome_latex ();
#line 124 "glatex_app.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GLATEX_APP__app_actions, (gint) G_N_ELEMENTS (GLATEX_APP__app_actions), self);
#line 125 "glatex_app.vala"
	latexila_latex_commands_add_action_infos ((GtkApplication*) self);
#line 127 "glatex_app.vala"
	latexila_utils_register_icons ();
#line 128 "glatex_app.vala"
	glatex_app_setup_theme_extensions (self);
#line 129 "glatex_app.vala"
	_tmp0_ = app_settings_get_default ();
#line 129 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 129 "glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 130 "glatex_app.vala"
	glatex_app_support_backward_search (self);
#line 131 "glatex_app.vala"
	_tmp2_ = glatex_app_get_accel_filename (self);
#line 131 "glatex_app.vala"
	_tmp3_ = _tmp2_;
#line 131 "glatex_app.vala"
	gtk_accel_map_load (_tmp3_);
#line 131 "glatex_app.vala"
	_g_free0 (_tmp3_);
#line 133 "glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 772 "glatex_app.c"
}

static void
glatex_app_shutdown_cb (GlatexApp* self)
{
	Projects* _tmp0_;
	Projects* _tmp1_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
	gchar* accel_filename = NULL;
	gchar* _tmp4_;
	GFile* accel_file = NULL;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
#line 136 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 138 "glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 140 "glatex_app.vala"
	_tmp0_ = projects_get_default ();
#line 140 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 140 "glatex_app.vala"
	projects_save (_tmp1_);
#line 140 "glatex_app.vala"
	_projects_unref0 (_tmp1_);
#line 141 "glatex_app.vala"
	_tmp2_ = most_used_symbols_get_default ();
#line 141 "glatex_app.vala"
	_tmp3_ = _tmp2_;
#line 141 "glatex_app.vala"
	most_used_symbols_save (_tmp3_);
#line 141 "glatex_app.vala"
	_g_object_unref0 (_tmp3_);
#line 144 "glatex_app.vala"
	_tmp4_ = glatex_app_get_accel_filename (self);
#line 144 "glatex_app.vala"
	accel_filename = _tmp4_;
#line 145 "glatex_app.vala"
	_tmp5_ = g_file_new_for_path (accel_filename);
#line 145 "glatex_app.vala"
	accel_file = _tmp5_;
#line 815 "glatex_app.c"
	{
#line 148 "glatex_app.vala"
		tepl_utils_create_parent_directories (accel_file, NULL, &_inner_error0_);
#line 148 "glatex_app.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 821 "glatex_app.c"
			goto __catch23_g_error;
		}
#line 149 "glatex_app.vala"
		gtk_accel_map_save (accel_filename);
#line 826 "glatex_app.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 146 "glatex_app.vala"
		_error_ = _inner_error0_;
#line 146 "glatex_app.vala"
		_inner_error0_ = NULL;
#line 153 "glatex_app.vala"
		_tmp6_ = _error_;
#line 153 "glatex_app.vala"
		_tmp7_ = _tmp6_->message;
#line 153 "glatex_app.vala"
		g_warning ("glatex_app.vala:153: Error when saving accel file: %s", _tmp7_);
#line 146 "glatex_app.vala"
		_g_error_free0 (_error_);
#line 846 "glatex_app.c"
	}
	__finally23:
#line 146 "glatex_app.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 146 "glatex_app.vala"
		_g_object_unref0 (accel_file);
#line 146 "glatex_app.vala"
		_g_free0 (accel_filename);
#line 146 "glatex_app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 146 "glatex_app.vala"
		g_clear_error (&_inner_error0_);
#line 146 "glatex_app.vala"
		return;
#line 861 "glatex_app.c"
	}
#line 156 "glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 136 "glatex_app.vala"
	_g_object_unref0 (accel_file);
#line 136 "glatex_app.vala"
	_g_free0 (accel_filename);
#line 869 "glatex_app.c"
}

static void
glatex_app_new_document_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
#line 159 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 161 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 161 "glatex_app.vala"
	window = _tmp0_;
#line 162 "glatex_app.vala"
	_tmp1_ = window;
#line 162 "glatex_app.vala"
	if (_tmp1_ == NULL) {
#line 891 "glatex_app.c"
		MainWindow* _tmp2_;
#line 163 "glatex_app.vala"
		_tmp2_ = glatex_app_create_window (self);
#line 163 "glatex_app.vala"
		_g_object_unref0 (window);
#line 163 "glatex_app.vala"
		window = _tmp2_;
#line 899 "glatex_app.c"
	}
#line 165 "glatex_app.vala"
	_tmp3_ = window;
#line 165 "glatex_app.vala"
	_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
#line 165 "glatex_app.vala"
	_tmp5_ = _tmp4_;
#line 165 "glatex_app.vala"
	_g_object_unref0 (_tmp5_);
#line 159 "glatex_app.vala"
	_g_object_unref0 (window);
#line 911 "glatex_app.c"
}

static void
glatex_app_preferences_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
#line 168 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 170 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 170 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 170 "glatex_app.vala"
	preferences_dialog_show_me ((GtkWindow*) _tmp1_);
#line 170 "glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 929 "glatex_app.c"
}

static void
glatex_app_manage_build_tools_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	BuildToolsPreferences* _tmp2_;
	BuildToolsPreferences* _tmp3_;
#line 173 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 175 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 175 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 175 "glatex_app.vala"
	_tmp2_ = build_tools_preferences_new ((GtkWindow*) _tmp1_);
#line 175 "glatex_app.vala"
	_tmp3_ = _tmp2_;
#line 175 "glatex_app.vala"
	_g_object_unref0 (_tmp3_);
#line 175 "glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 953 "glatex_app.c"
}

static void
glatex_app_help_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 178 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 180 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 180 "glatex_app.vala"
	window = _tmp0_;
#line 968 "glatex_app.c"
	{
#line 184 "glatex_app.vala"
		latexila_utils_show_uri ((GtkWidget*) window, "help:gnome-latex", (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 184 "glatex_app.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 974 "glatex_app.c"
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 182 "glatex_app.vala"
		e = _inner_error0_;
#line 182 "glatex_app.vala"
		_inner_error0_ = NULL;
#line 188 "glatex_app.vala"
		_tmp1_ = e;
#line 188 "glatex_app.vala"
		_tmp2_ = _tmp1_->message;
#line 188 "glatex_app.vala"
		g_warning ("glatex_app.vala:188: Impossible to open the documentation: %s", _tmp2_);
#line 182 "glatex_app.vala"
		_g_error_free0 (e);
#line 996 "glatex_app.c"
	}
	__finally24:
#line 182 "glatex_app.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 182 "glatex_app.vala"
		_g_object_unref0 (window);
#line 182 "glatex_app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 182 "glatex_app.vala"
		g_clear_error (&_inner_error0_);
#line 182 "glatex_app.vala"
		return;
#line 1009 "glatex_app.c"
	}
#line 178 "glatex_app.vala"
	_g_object_unref0 (window);
#line 1013 "glatex_app.c"
}

static void
glatex_app_about_cb (GlatexApp* self)
{
	gchar* comments = NULL;
	gchar* _tmp0_;
	gchar* copyright = NULL;
	gchar* _tmp1_;
	gchar* website = NULL;
	gchar* _tmp2_;
	gchar** authors = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint artists_length1;
	gint _artists_size_;
	MainWindow* _tmp11_;
	MainWindow* _tmp12_;
#line 192 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 194 "glatex_app.vala"
	_tmp0_ = g_strdup (_ ("GNOME LaTeX is a LaTeX editor for the GNOME desktop"));
#line 194 "glatex_app.vala"
	comments = _tmp0_;
#line 196 "glatex_app.vala"
	_tmp1_ = g_strdup ("Copyright 2009-2020 – Sébastien Wilmet");
#line 196 "glatex_app.vala"
	copyright = _tmp1_;
#line 198 "glatex_app.vala"
	_tmp2_ = g_strdup ("https://wiki.gnome.org/Apps/GNOME-LaTeX");
#line 198 "glatex_app.vala"
	website = _tmp2_;
#line 200 "glatex_app.vala"
	_tmp3_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
#line 200 "glatex_app.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 200 "glatex_app.vala"
	_tmp4_[0] = _tmp3_;
#line 200 "glatex_app.vala"
	_tmp4_[1] = NULL;
#line 200 "glatex_app.vala"
	authors = _tmp4_;
#line 200 "glatex_app.vala"
	authors_length1 = 2;
#line 200 "glatex_app.vala"
	_authors_size_ = authors_length1;
#line 206 "glatex_app.vala"
	_tmp5_ = g_strdup ("Eric Forgeot <e.forgeot@laposte.net>");
#line 206 "glatex_app.vala"
	_tmp6_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
#line 206 "glatex_app.vala"
	_tmp7_ = g_strdup ("Alexander Wilms <f.alexander.wilms@gmail.com>");
#line 206 "glatex_app.vala"
	_tmp8_ = g_strdup ("The Kile Team http://kile.sourceforge.net/");
#line 206 "glatex_app.vala"
	_tmp9_ = g_strdup ("Gedit LaTeX Plugin https://wiki.gnome.org/Apps/Gedit/LaTeXPlugin");
#line 206 "glatex_app.vala"
	_tmp10_ = g_new0 (gchar*, 6 + 1);
#line 206 "glatex_app.vala"
	_tmp10_[0] = _tmp5_;
#line 206 "glatex_app.vala"
	_tmp10_[1] = _tmp6_;
#line 206 "glatex_app.vala"
	_tmp10_[2] = _tmp7_;
#line 206 "glatex_app.vala"
	_tmp10_[3] = _tmp8_;
#line 206 "glatex_app.vala"
	_tmp10_[4] = _tmp9_;
#line 206 "glatex_app.vala"
	_tmp10_[5] = NULL;
#line 206 "glatex_app.vala"
	artists = _tmp10_;
#line 206 "glatex_app.vala"
	artists_length1 = 6;
#line 206 "glatex_app.vala"
	_artists_size_ = artists_length1;
#line 216 "glatex_app.vala"
	_tmp11_ = glatex_app_get_active_main_window (self);
#line 216 "glatex_app.vala"
	_tmp12_ = _tmp11_;
#line 216 "glatex_app.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp12_, "program-name", PACKAGE_NAME, "version", PACKAGE_VERSION, "authors", authors, "artists", artists, "comments", comments, "copyright", copyright, "license-type", GTK_LICENSE_GPL_3_0, "title", _ ("About GNOME LaTeX"), "translator-credits", _ ("translator-credits"), "website", website, "logo-icon-name", "gnome-latex", NULL);
#line 216 "glatex_app.vala"
	_g_object_unref0 (_tmp12_);
#line 192 "glatex_app.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 192 "glatex_app.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 192 "glatex_app.vala"
	_g_free0 (website);
#line 192 "glatex_app.vala"
	_g_free0 (copyright);
#line 192 "glatex_app.vala"
	_g_free0 (comments);
#line 1117 "glatex_app.c"
}

static void
glatex_app_quit_cb (GlatexApp* self)
{
	gboolean cont = FALSE;
#line 231 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 233 "glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 235 "glatex_app.vala"
	cont = TRUE;
#line 236 "glatex_app.vala"
	while (TRUE) {
#line 1132 "glatex_app.c"
		MainWindow* main_window = NULL;
		MainWindow* _tmp0_;
		MainWindow* _tmp1_;
		MainWindow* _tmp2_;
		MainWindow* _tmp3_;
#line 236 "glatex_app.vala"
		if (!cont) {
#line 236 "glatex_app.vala"
			break;
#line 1142 "glatex_app.c"
		}
#line 238 "glatex_app.vala"
		_tmp0_ = glatex_app_get_active_main_window (self);
#line 238 "glatex_app.vala"
		main_window = _tmp0_;
#line 239 "glatex_app.vala"
		_tmp1_ = main_window;
#line 239 "glatex_app.vala"
		if (_tmp1_ == NULL) {
#line 240 "glatex_app.vala"
			_g_object_unref0 (main_window);
#line 240 "glatex_app.vala"
			break;
#line 1156 "glatex_app.c"
		}
#line 242 "glatex_app.vala"
		_tmp2_ = main_window;
#line 242 "glatex_app.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 243 "glatex_app.vala"
		_tmp3_ = main_window;
#line 243 "glatex_app.vala"
		cont = main_window_quit (_tmp3_);
#line 236 "glatex_app.vala"
		_g_object_unref0 (main_window);
#line 1168 "glatex_app.c"
	}
#line 246 "glatex_app.vala"
	if (cont) {
#line 248 "glatex_app.vala"
		while (TRUE) {
#line 1174 "glatex_app.c"
			GtkWindow* _tmp4_;
			GtkWindow* _tmp5_;
			GtkWindow* _tmp6_;
			GtkWindow* _tmp7_;
#line 248 "glatex_app.vala"
			_tmp4_ = gtk_application_get_active_window ((GtkApplication*) self);
#line 248 "glatex_app.vala"
			_tmp5_ = _tmp4_;
#line 248 "glatex_app.vala"
			if (!(_tmp5_ != NULL)) {
#line 248 "glatex_app.vala"
				break;
#line 1187 "glatex_app.c"
			}
#line 249 "glatex_app.vala"
			_tmp6_ = gtk_application_get_active_window ((GtkApplication*) self);
#line 249 "glatex_app.vala"
			_tmp7_ = _tmp6_;
#line 249 "glatex_app.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp7_);
#line 1195 "glatex_app.c"
		}
	}
#line 252 "glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 1200 "glatex_app.c"
}

static void
_glatex_app_update_theme_g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
#line 258 "glatex_app.vala"
	glatex_app_update_theme ((GlatexApp*) self);
#line 1210 "glatex_app.c"
}

static void
glatex_app_setup_theme_extensions (GlatexApp* self)
{
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
#line 255 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 257 "glatex_app.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 257 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 257 "glatex_app.vala"
	settings = _tmp1_;
#line 258 "glatex_app.vala"
	g_signal_connect_object ((GObject*) settings, "notify::gtk-theme-name", (GCallback) _glatex_app_update_theme_g_object_notify, self, 0);
#line 259 "glatex_app.vala"
	glatex_app_update_theme (self);
#line 255 "glatex_app.vala"
	_g_object_unref0 (settings);
#line 1233 "glatex_app.c"
}

static void
glatex_app_update_theme (GlatexApp* self)
{
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GtkSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError* _inner_error0_ = NULL;
#line 262 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 264 "glatex_app.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 264 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 264 "glatex_app.vala"
	settings = _tmp1_;
#line 265 "glatex_app.vala"
	_tmp2_ = gdk_screen_get_default ();
#line 265 "glatex_app.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 265 "glatex_app.vala"
	screen = _tmp3_;
#line 267 "glatex_app.vala"
	_tmp4_ = settings;
#line 267 "glatex_app.vala"
	g_object_get (_tmp4_, "gtk-theme-name", &_tmp5_, NULL);
#line 267 "glatex_app.vala"
	_tmp6_ = _tmp5_;
#line 267 "glatex_app.vala"
	_tmp7_ = _tmp6_;
#line 267 "glatex_app.vala"
	_tmp8_ = g_strcmp0 (_tmp7_, "Adwaita") == 0;
#line 267 "glatex_app.vala"
	_g_free0 (_tmp7_);
#line 267 "glatex_app.vala"
	if (_tmp8_) {
#line 1279 "glatex_app.c"
		GtkCssProvider* _tmp9_;
		GdkScreen* _tmp16_;
		GtkCssProvider* _tmp17_;
#line 269 "glatex_app.vala"
		_tmp9_ = glatex_app__provider;
#line 269 "glatex_app.vala"
		if (_tmp9_ == NULL) {
#line 1287 "glatex_app.c"
			GtkCssProvider* _tmp10_;
			GFile* file = NULL;
			GFile* _tmp11_;
#line 271 "glatex_app.vala"
			_tmp10_ = gtk_css_provider_new ();
#line 271 "glatex_app.vala"
			_g_object_unref0 (glatex_app__provider);
#line 271 "glatex_app.vala"
			glatex_app__provider = _tmp10_;
#line 272 "glatex_app.vala"
			_tmp11_ = g_file_new_for_uri ("resource:///org/gnome/gnome-latex/ui/gnome-latex.adwaita.css");
#line 272 "glatex_app.vala"
			file = _tmp11_;
#line 1301 "glatex_app.c"
			{
				GtkCssProvider* _tmp12_;
				GFile* _tmp13_;
#line 275 "glatex_app.vala"
				_tmp12_ = glatex_app__provider;
#line 275 "glatex_app.vala"
				_tmp13_ = file;
#line 275 "glatex_app.vala"
				gtk_css_provider_load_from_file (_tmp12_, _tmp13_, &_inner_error0_);
#line 275 "glatex_app.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1313 "glatex_app.c"
					goto __catch25_g_error;
				}
			}
			goto __finally25;
			__catch25_g_error:
			{
				GError* e = NULL;
				GError* _tmp14_;
				const gchar* _tmp15_;
#line 273 "glatex_app.vala"
				e = _inner_error0_;
#line 273 "glatex_app.vala"
				_inner_error0_ = NULL;
#line 279 "glatex_app.vala"
				_tmp14_ = e;
#line 279 "glatex_app.vala"
				_tmp15_ = _tmp14_->message;
#line 279 "glatex_app.vala"
				g_warning ("glatex_app.vala:279: Cannot load CSS: %s", _tmp15_);
#line 273 "glatex_app.vala"
				_g_error_free0 (e);
#line 1335 "glatex_app.c"
			}
			__finally25:
#line 273 "glatex_app.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 273 "glatex_app.vala"
				_g_object_unref0 (file);
#line 273 "glatex_app.vala"
				_g_object_unref0 (screen);
#line 273 "glatex_app.vala"
				_g_object_unref0 (settings);
#line 273 "glatex_app.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 273 "glatex_app.vala"
				g_clear_error (&_inner_error0_);
#line 273 "glatex_app.vala"
				return;
#line 1352 "glatex_app.c"
			}
#line 269 "glatex_app.vala"
			_g_object_unref0 (file);
#line 1356 "glatex_app.c"
		}
#line 283 "glatex_app.vala"
		_tmp16_ = screen;
#line 283 "glatex_app.vala"
		_tmp17_ = glatex_app__provider;
#line 283 "glatex_app.vala"
		gtk_style_context_add_provider_for_screen (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 1364 "glatex_app.c"
	} else {
		GtkCssProvider* _tmp18_;
#line 286 "glatex_app.vala"
		_tmp18_ = glatex_app__provider;
#line 286 "glatex_app.vala"
		if (_tmp18_ != NULL) {
#line 1371 "glatex_app.c"
			GdkScreen* _tmp19_;
			GtkCssProvider* _tmp20_;
#line 288 "glatex_app.vala"
			_tmp19_ = screen;
#line 288 "glatex_app.vala"
			_tmp20_ = glatex_app__provider;
#line 288 "glatex_app.vala"
			gtk_style_context_remove_provider_for_screen (_tmp19_, (GtkStyleProvider*) _tmp20_);
#line 289 "glatex_app.vala"
			_g_object_unref0 (glatex_app__provider);
#line 289 "glatex_app.vala"
			glatex_app__provider = NULL;
#line 1384 "glatex_app.c"
		}
	}
#line 262 "glatex_app.vala"
	_g_object_unref0 (screen);
#line 262 "glatex_app.vala"
	_g_object_unref0 (settings);
#line 1391 "glatex_app.c"
}

GeeList*
glatex_app_get_documents (GlatexApp* self)
{
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	GeeList* result = NULL;
#line 294 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 296 "glatex_app.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 296 "glatex_app.vala"
	all_documents = (GeeList*) _tmp0_;
#line 297 "glatex_app.vala"
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
#line 1409 "glatex_app.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 297 "glatex_app.vala"
		window_collection = _tmp1_;
#line 297 "glatex_app.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1417 "glatex_app.c"
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
#line 297 "glatex_app.vala"
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 297 "glatex_app.vala"
			window = _tmp2_;
#line 1424 "glatex_app.c"
			{
				GtkWindow* _tmp3_;
#line 299 "glatex_app.vala"
				_tmp3_ = window;
#line 299 "glatex_app.vala"
				if (IS_MAIN_WINDOW (_tmp3_)) {
#line 1431 "glatex_app.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
#line 301 "glatex_app.vala"
					_tmp4_ = window;
#line 301 "glatex_app.vala"
					_tmp5_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp4_) ? ((MainWindow*) _tmp4_) : NULL);
#line 301 "glatex_app.vala"
					main_window = _tmp5_;
#line 302 "glatex_app.vala"
					_tmp6_ = all_documents;
#line 302 "glatex_app.vala"
					_tmp7_ = main_window;
#line 302 "glatex_app.vala"
					_tmp8_ = main_window_get_documents (_tmp7_);
#line 302 "glatex_app.vala"
					_tmp9_ = _tmp8_;
#line 302 "glatex_app.vala"
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
#line 302 "glatex_app.vala"
					_g_object_unref0 (_tmp9_);
#line 299 "glatex_app.vala"
					_g_object_unref0 (main_window);
#line 1459 "glatex_app.c"
				}
#line 297 "glatex_app.vala"
				_g_object_unref0 (window);
#line 1463 "glatex_app.c"
			}
		}
	}
#line 306 "glatex_app.vala"
	result = all_documents;
#line 306 "glatex_app.vala"
	return result;
#line 1471 "glatex_app.c"
}

GeeList*
glatex_app_get_views (GlatexApp* self)
{
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	GeeList* result = NULL;
#line 310 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 312 "glatex_app.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 312 "glatex_app.vala"
	all_views = (GeeList*) _tmp0_;
#line 313 "glatex_app.vala"
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
#line 1489 "glatex_app.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 313 "glatex_app.vala"
		window_collection = _tmp1_;
#line 313 "glatex_app.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1497 "glatex_app.c"
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
#line 313 "glatex_app.vala"
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 313 "glatex_app.vala"
			window = _tmp2_;
#line 1504 "glatex_app.c"
			{
				GtkWindow* _tmp3_;
#line 315 "glatex_app.vala"
				_tmp3_ = window;
#line 315 "glatex_app.vala"
				if (IS_MAIN_WINDOW (_tmp3_)) {
#line 1511 "glatex_app.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
#line 317 "glatex_app.vala"
					_tmp4_ = window;
#line 317 "glatex_app.vala"
					_tmp5_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp4_) ? ((MainWindow*) _tmp4_) : NULL);
#line 317 "glatex_app.vala"
					main_window = _tmp5_;
#line 318 "glatex_app.vala"
					_tmp6_ = all_views;
#line 318 "glatex_app.vala"
					_tmp7_ = main_window;
#line 318 "glatex_app.vala"
					_tmp8_ = main_window_get_views (_tmp7_);
#line 318 "glatex_app.vala"
					_tmp9_ = _tmp8_;
#line 318 "glatex_app.vala"
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
#line 318 "glatex_app.vala"
					_g_object_unref0 (_tmp9_);
#line 315 "glatex_app.vala"
					_g_object_unref0 (main_window);
#line 1539 "glatex_app.c"
				}
#line 313 "glatex_app.vala"
				_g_object_unref0 (window);
#line 1543 "glatex_app.c"
			}
		}
	}
#line 322 "glatex_app.vala"
	result = all_views;
#line 322 "glatex_app.vala"
	return result;
#line 1551 "glatex_app.c"
}

MainWindow*
glatex_app_create_window (GlatexApp* self)
{
	TeplAbstractFactory* factory = NULL;
	TeplAbstractFactory* _tmp0_;
	TeplAbstractFactory* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* result = NULL;
#line 325 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 327 "glatex_app.vala"
	_tmp0_ = tepl_abstract_factory_get_singleton ();
#line 327 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 327 "glatex_app.vala"
	factory = _tmp1_;
#line 329 "glatex_app.vala"
	_tmp2_ = tepl_abstract_factory_create_main_window (factory, (GtkApplication*) self);
#line 329 "glatex_app.vala"
	_tmp3_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp2_) ? ((MainWindow*) _tmp2_) : NULL);
#line 329 "glatex_app.vala"
	result = _tmp3_;
#line 329 "glatex_app.vala"
	_g_object_unref0 (factory);
#line 329 "glatex_app.vala"
	return result;
#line 1581 "glatex_app.c"
}

void
glatex_app_open_documents (GlatexApp* self,
                           GFile** files,
                           gint files_length1)
{
	MainWindow* main_window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	gboolean jump_to = FALSE;
	MainWindow* _tmp8_;
#line 332 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 334 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 334 "glatex_app.vala"
	main_window = _tmp0_;
#line 335 "glatex_app.vala"
	_tmp1_ = main_window;
#line 335 "glatex_app.vala"
	if (_tmp1_ == NULL) {
#line 1604 "glatex_app.c"
		MainWindow* _tmp2_;
#line 336 "glatex_app.vala"
		_tmp2_ = glatex_app_create_window (self);
#line 336 "glatex_app.vala"
		_g_object_unref0 (main_window);
#line 336 "glatex_app.vala"
		main_window = _tmp2_;
#line 1612 "glatex_app.c"
	}
#line 338 "glatex_app.vala"
	jump_to = TRUE;
#line 1616 "glatex_app.c"
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
#line 339 "glatex_app.vala"
		file_collection = files;
#line 339 "glatex_app.vala"
		file_collection_length1 = files_length1;
#line 339 "glatex_app.vala"
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
#line 1628 "glatex_app.c"
			GFile* _tmp3_;
			GFile* file = NULL;
#line 339 "glatex_app.vala"
			_tmp3_ = _g_object_ref0 (file_collection[file_it]);
#line 339 "glatex_app.vala"
			file = _tmp3_;
#line 1635 "glatex_app.c"
			{
				MainWindow* _tmp4_;
				GFile* _tmp5_;
				DocumentTab* _tmp6_;
				DocumentTab* _tmp7_;
#line 341 "glatex_app.vala"
				_tmp4_ = main_window;
#line 341 "glatex_app.vala"
				_tmp5_ = file;
#line 341 "glatex_app.vala"
				_tmp6_ = main_window_open_document (_tmp4_, _tmp5_, jump_to);
#line 341 "glatex_app.vala"
				_tmp7_ = _tmp6_;
#line 341 "glatex_app.vala"
				_g_object_unref0 (_tmp7_);
#line 342 "glatex_app.vala"
				jump_to = FALSE;
#line 339 "glatex_app.vala"
				_g_object_unref0 (file);
#line 1655 "glatex_app.c"
			}
		}
	}
#line 345 "glatex_app.vala"
	_tmp8_ = main_window;
#line 345 "glatex_app.vala"
	gtk_window_present ((GtkWindow*) _tmp8_);
#line 332 "glatex_app.vala"
	_g_object_unref0 (main_window);
#line 1665 "glatex_app.c"
}

static gchar*
glatex_app_get_accel_filename (GlatexApp* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
#line 348 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 350 "glatex_app.vala"
	_tmp0_ = g_get_user_config_dir ();
#line 350 "glatex_app.vala"
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "accels", NULL);
#line 350 "glatex_app.vala"
	result = _tmp1_;
#line 350 "glatex_app.vala"
	return result;
#line 1684 "glatex_app.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1518 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1519 "glib-2.0.vapi"
	result = self;
#line 1519 "glib-2.0.vapi"
	return result;
#line 1697 "glatex_app.c"
}

static void
__lambda117_ (GlatexApp* self,
              const gchar* tex_uri,
              gint line,
              guint timestamp)
{
	GFile* tex_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	MainWindow* main_window = NULL;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
#line 358 "glatex_app.vala"
	g_return_if_fail (tex_uri != NULL);
#line 360 "glatex_app.vala"
	_tmp0_ = g_file_new_for_uri (tex_uri);
#line 360 "glatex_app.vala"
	tex_file = _tmp0_;
#line 361 "glatex_app.vala"
	_tmp1_ = tex_file;
#line 361 "glatex_app.vala"
	if (!g_file_query_exists (_tmp1_, NULL)) {
#line 1722 "glatex_app.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 363 "glatex_app.vala"
		_tmp2_ = string_to_string (tex_uri);
#line 363 "glatex_app.vala"
		_tmp3_ = g_strconcat ("Backward search: the file \"", _tmp2_, "\" doesn't exist.", NULL);
#line 363 "glatex_app.vala"
		_tmp4_ = _tmp3_;
#line 363 "glatex_app.vala"
		g_warning ("glatex_app.vala:363: %s", _tmp4_);
#line 363 "glatex_app.vala"
		_g_free0 (_tmp4_);
#line 364 "glatex_app.vala"
		_g_object_unref0 (tex_file);
#line 364 "glatex_app.vala"
		return;
#line 1740 "glatex_app.c"
	}
#line 369 "glatex_app.vala"
	_tmp5_ = glatex_app_get_active_main_window (self);
#line 369 "glatex_app.vala"
	main_window = _tmp5_;
#line 370 "glatex_app.vala"
	_tmp6_ = main_window;
#line 370 "glatex_app.vala"
	if (_tmp6_ != NULL) {
#line 1750 "glatex_app.c"
		MainWindow* _tmp7_;
		GFile* _tmp8_;
		MainWindow* _tmp9_;
#line 372 "glatex_app.vala"
		_tmp7_ = main_window;
#line 372 "glatex_app.vala"
		_tmp8_ = tex_file;
#line 372 "glatex_app.vala"
		main_window_jump_to_file_position (_tmp7_, _tmp8_, line, line);
#line 373 "glatex_app.vala"
		_tmp9_ = main_window;
#line 373 "glatex_app.vala"
		gtk_window_present_with_time ((GtkWindow*) _tmp9_, (guint32) timestamp);
#line 1764 "glatex_app.c"
	}
#line 358 "glatex_app.vala"
	_g_object_unref0 (main_window);
#line 358 "glatex_app.vala"
	_g_object_unref0 (tex_file);
#line 1770 "glatex_app.c"
}

static void
___lambda117__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                const gchar* tex_uri,
                                                gint line,
                                                guint timestamp,
                                                gpointer self)
{
#line 358 "glatex_app.vala"
	__lambda117_ ((GlatexApp*) self, tex_uri, line, timestamp);
#line 1782 "glatex_app.c"
}

static void
glatex_app_support_backward_search (GlatexApp* self)
{
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp0_;
	LatexilaSynctex* _tmp1_;
#line 354 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 356 "glatex_app.vala"
	_tmp0_ = latexila_synctex_get_instance ();
#line 356 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 356 "glatex_app.vala"
	synctex = _tmp1_;
#line 358 "glatex_app.vala"
	g_signal_connect_object (synctex, "backward-search", (GCallback) ___lambda117__latexila_synctex_backward_search, self, 0);
#line 354 "glatex_app.vala"
	_g_object_unref0 (synctex);
#line 1803 "glatex_app.c"
}

static void
glatex_app_class_init (GlatexAppClass * klass,
                       gpointer klass_data)
{
#line 22 "glatex_app.vala"
	glatex_app_parent_class = g_type_class_peek_parent (klass);
#line 22 "glatex_app.vala"
	G_OBJECT_CLASS (klass)->finalize = glatex_app_finalize;
#line 1814 "glatex_app.c"
}

static void
glatex_app_instance_init (GlatexApp * self,
                          gpointer klass)
{
}

static void
glatex_app_finalize (GObject * obj)
{
	GlatexApp * self;
#line 22 "glatex_app.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GLATEX_APP, GlatexApp);
#line 22 "glatex_app.vala"
	G_OBJECT_CLASS (glatex_app_parent_class)->finalize (obj);
#line 1831 "glatex_app.c"
}

GType
glatex_app_get_type (void)
{
	static volatile gsize glatex_app_type_id__volatile = 0;
	if (g_once_init_enter (&glatex_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GlatexAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) glatex_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlatexApp), 0, (GInstanceInitFunc) glatex_app_instance_init, NULL };
		GType glatex_app_type_id;
		glatex_app_type_id = g_type_register_static (gtk_application_get_type (), "GlatexApp", &g_define_type_info, 0);
		g_once_init_leave (&glatex_app_type_id__volatile, glatex_app_type_id);
	}
	return glatex_app_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1854 "glatex_app.c"
		int i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1862 "glatex_app.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 1877 "glatex_app.c"
}

