/* document.c generated by valac 0.46.7, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib/gstdio.h>

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
enum  {
	DOCUMENT_0_PROPERTY,
	DOCUMENT_LOCATION_PROPERTY,
	DOCUMENT_READONLY_PROPERTY,
	DOCUMENT_PROJECT_ID_PROPERTY,
	DOCUMENT_NUM_PROPERTIES
};
static GParamSpec* document_properties[DOCUMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
};

struct _Block15Data {
	int _ref_count_;
	Document* self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

static gint Document_private_offset;
static gpointer document_parent_class = NULL;

GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
GType document_structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentStructure, g_object_unref)
Document* document_new (void);
Document* document_construct (GType object_type);
static void __lambda43_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda43__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda44_ (Document* self);
static void ___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
static void __lambda45_ (Document* self);
static void ___lambda45__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* document_tab_get_document_view (DocumentTab* self);
static gboolean __lambda38_ (Block15Data* _data15_);
static gboolean ___lambda38__gsource_func (gpointer self);
void document_load (Document* self,
                    GFile* location);
void document_set_location (Document* self,
                            GFile* value);
void document_set_contents (Document* self,
                            const gchar* contents);
static gchar* document_to_utf8 (Document* self,
                         const gchar* text,
                         GError** error);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
GFile* document_get_location (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda16_ (Block16Data* _data16_,
                    gint response_id);
static void _____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                           gint response_id,
                                           gpointer self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
Projects* projects_get_default (void);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self,
                              gint value);
gchar* document_get_uri_for_display (Document* self);
gchar* document_get_short_name_for_display (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
void document_uncomment_selected_lines (Document* self);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self,
                       gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
void document_structure_parse (DocumentStructure* self);
gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda27_ (Block17Data* _data17_,
                  gint response_id);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
static void ___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                         gint response_id,
                                         gpointer self);
void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
gboolean document_get_readonly (Document* self);
void document_set_readonly (Document* self,
                            gboolean value);
static void document_finalize (GObject * obj);
static void _vala_document_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_document_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

static inline gpointer
document_get_instance_private (Document* self)
{
	return G_STRUCT_MEMBER_P (self, Document_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 37 "document.vala"
	return self ? g_object_ref (self) : NULL;
#line 303 "document.c"
}

static void
__lambda43_ (Document* self)
{
#line 42 "document.vala"
	document_update_syntax_highlighting (self);
#line 43 "document.vala"
	document_update_project_id (self);
#line 313 "document.c"
}

static void
___lambda43__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 40 "document.vala"
	__lambda43_ ((Document*) self);
#line 323 "document.c"
}

static void
__lambda44_ (Document* self)
{
#line 48 "document.vala"
	self->priv->new_file = FALSE;
#line 331 "document.c"
}

static void
___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
#line 46 "document.vala"
	__lambda44_ ((Document*) self);
#line 340 "document.c"
}

static void
__lambda45_ (Document* self)
{
#line 63 "document.vala"
	tepl_buffer_load_metadata_from_metadata_manager ((TeplBuffer*) self);
#line 348 "document.c"
}

static void
___lambda45__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 61 "document.vala"
	__lambda45_ ((Document*) self);
#line 358 "document.c"
}

Document*
document_construct (GType object_type)
{
	Document * self = NULL;
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	LatexilaSettings* settings = NULL;
	LatexilaSettings* _tmp3_;
	LatexilaSettings* _tmp4_;
	GSettings* editor_settings = NULL;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	TeplFile* _tmp7_;
	TeplFile* _tmp8_;
#line 34 "document.vala"
	self = (Document*) g_object_new (object_type, NULL);
#line 37 "document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 37 "document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 37 "document.vala"
	lm = _tmp1_;
#line 38 "document.vala"
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
#line 38 "document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
#line 40 "document.vala"
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda43__g_object_notify, self, 0);
#line 46 "document.vala"
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda44__gtk_text_buffer_changed, self, 0);
#line 51 "document.vala"
	_tmp3_ = latexila_settings_get_singleton ();
#line 51 "document.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 51 "document.vala"
	settings = _tmp4_;
#line 52 "document.vala"
	_tmp5_ = latexila_settings_peek_editor_settings (settings);
#line 52 "document.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 52 "document.vala"
	editor_settings = _tmp6_;
#line 53 "document.vala"
	g_settings_bind (editor_settings, "scheme", (GObject*) self, "tepl-style-scheme-id", G_SETTINGS_BIND_GET);
#line 58 "document.vala"
	_tmp7_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 58 "document.vala"
	g_object_bind_property_with_closures ((GObject*) self, "location", (GObject*) _tmp7_, "location", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 61 "document.vala"
	_tmp8_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 61 "document.vala"
	g_signal_connect_object ((GObject*) _tmp8_, "notify::location", (GCallback) ___lambda45__g_object_notify, self, 0);
#line 34 "document.vala"
	_g_object_unref0 (editor_settings);
#line 34 "document.vala"
	_g_object_unref0 (settings);
#line 34 "document.vala"
	_g_object_unref0 (lm);
#line 34 "document.vala"
	return self;
#line 423 "document.c"
}

Document*
document_new (void)
{
#line 34 "document.vala"
	return document_construct (TYPE_DOCUMENT);
#line 431 "document.c"
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
#line 67 "document.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 67 "document.vala"
	return _data15_;
#line 441 "document.c"
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 67 "document.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 451 "document.c"
		Document* self;
#line 67 "document.vala"
		self = _data15_->self;
#line 67 "document.vala"
		_g_object_unref0 (_data15_->completion);
#line 67 "document.vala"
		_g_object_unref0 (self);
#line 67 "document.vala"
		g_slice_free (Block15Data, _data15_);
#line 461 "document.c"
	}
}

static gboolean
__lambda38_ (Block15Data* _data15_)
{
	Document* self;
	GtkSourceCompletion* _tmp0_;
	gboolean result = FALSE;
#line 81 "document.vala"
	self = _data15_->self;
#line 83 "document.vala"
	_tmp0_ = _data15_->completion;
#line 83 "document.vala"
	if (_tmp0_ != NULL) {
#line 477 "document.c"
		GtkSourceCompletion* _tmp1_;
#line 84 "document.vala"
		_tmp1_ = _data15_->completion;
#line 84 "document.vala"
		gtk_source_completion_unblock_interactive (_tmp1_);
#line 483 "document.c"
	}
#line 86 "document.vala"
	result = FALSE;
#line 86 "document.vala"
	return result;
#line 489 "document.c"
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ (self);
#line 81 "document.vala"
	return result;
#line 499 "document.c"
}

void
document_insert (Document* self,
                 GtkTextIter* iter,
                 const gchar* text,
                 gint len)
{
	Block15Data* _data15_;
	DocumentTab* _tmp0_;
#line 67 "document.vala"
	g_return_if_fail (self != NULL);
#line 67 "document.vala"
	g_return_if_fail (iter != NULL);
#line 67 "document.vala"
	g_return_if_fail (text != NULL);
#line 67 "document.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 67 "document.vala"
	_data15_->_ref_count_ = 1;
#line 67 "document.vala"
	_data15_->self = g_object_ref (self);
#line 69 "document.vala"
	_data15_->completion = NULL;
#line 71 "document.vala"
	_tmp0_ = self->tab;
#line 71 "document.vala"
	if (_tmp0_ != NULL) {
#line 528 "document.c"
		DocumentTab* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		GtkSourceCompletion* _tmp7_;
#line 73 "document.vala"
		_tmp1_ = self->tab;
#line 73 "document.vala"
		_tmp2_ = document_tab_get_document_view (_tmp1_);
#line 73 "document.vala"
		_tmp3_ = _tmp2_;
#line 73 "document.vala"
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
#line 73 "document.vala"
		_tmp5_ = _tmp4_;
#line 73 "document.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 73 "document.vala"
		_g_object_unref0 (_data15_->completion);
#line 73 "document.vala"
		_data15_->completion = _tmp6_;
#line 74 "document.vala"
		_tmp7_ = _data15_->completion;
#line 74 "document.vala"
		gtk_source_completion_block_interactive (_tmp7_);
#line 556 "document.c"
	}
#line 77 "document.vala"
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, tepl_buffer_get_type (), TeplBuffer), iter, text, len);
#line 81 "document.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda38__gsource_func, block15_data_ref (_data15_), block15_data_unref);
#line 67 "document.vala"
	block15_data_unref (_data15_);
#line 67 "document.vala"
	_data15_ = NULL;
#line 566 "document.c"
}

void
document_load (Document* self,
               GFile* location)
{
	GError* _inner_error0_ = NULL;
#line 90 "document.vala"
	g_return_if_fail (self != NULL);
#line 90 "document.vala"
	g_return_if_fail (location != NULL);
#line 92 "document.vala"
	document_set_location (self, location);
#line 580 "document.c"
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* text = NULL;
		guint8* _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		GtkRecentManager* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 97 "document.vala"
		g_file_load_contents (location, NULL, &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
#line 97 "document.vala"
		chars = (g_free (chars), NULL);
#line 97 "document.vala"
		chars = _tmp0_;
#line 97 "document.vala"
		chars_length1 = _tmp1_;
#line 97 "document.vala"
		_chars_size_ = chars_length1;
#line 97 "document.vala"
		_g_free0 (self->priv->_etag);
#line 97 "document.vala"
		self->priv->_etag = _tmp2_;
#line 97 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 97 "document.vala"
			chars = (g_free (chars), NULL);
#line 613 "document.c"
			goto __catch8_g_error;
		}
#line 98 "document.vala"
		_tmp3_ = chars;
#line 98 "document.vala"
		_tmp3__length1 = chars_length1;
#line 98 "document.vala"
		chars = NULL;
#line 98 "document.vala"
		chars_length1 = 0;
#line 98 "document.vala"
		text = (gchar*) _tmp3_;
#line 100 "document.vala"
		_tmp4_ = text;
#line 100 "document.vala"
		if (g_utf8_validate (_tmp4_, (gssize) -1, NULL)) {
#line 630 "document.c"
			const gchar* _tmp5_;
#line 101 "document.vala"
			_tmp5_ = text;
#line 101 "document.vala"
			document_set_contents (self, _tmp5_);
#line 636 "document.c"
		} else {
			gchar* utf8_text = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
#line 106 "document.vala"
			_tmp6_ = text;
#line 106 "document.vala"
			_tmp7_ = document_to_utf8 (self, _tmp6_, &_inner_error0_);
#line 106 "document.vala"
			utf8_text = _tmp7_;
#line 106 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 106 "document.vala"
				_g_free0 (text);
#line 106 "document.vala"
				chars = (g_free (chars), NULL);
#line 654 "document.c"
				goto __catch8_g_error;
			}
#line 107 "document.vala"
			_tmp8_ = utf8_text;
#line 107 "document.vala"
			document_set_contents (self, _tmp8_);
#line 100 "document.vala"
			_g_free0 (utf8_text);
#line 663 "document.c"
		}
#line 110 "document.vala"
		document_update_syntax_highlighting (self);
#line 112 "document.vala"
		_tmp9_ = gtk_recent_manager_get_default ();
#line 112 "document.vala"
		_tmp10_ = g_file_get_uri (location);
#line 112 "document.vala"
		_tmp11_ = _tmp10_;
#line 112 "document.vala"
		gtk_recent_manager_add_item (_tmp9_, _tmp11_);
#line 112 "document.vala"
		_g_free0 (_tmp11_);
#line 94 "document.vala"
		_g_free0 (text);
#line 94 "document.vala"
		chars = (g_free (chars), NULL);
#line 681 "document.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		DocumentTab* _tmp14_;
#line 94 "document.vala"
		e = _inner_error0_;
#line 94 "document.vala"
		_inner_error0_ = NULL;
#line 116 "document.vala"
		_tmp12_ = e;
#line 116 "document.vala"
		_tmp13_ = _tmp12_->message;
#line 116 "document.vala"
		g_warning ("document.vala:116: %s", _tmp13_);
#line 118 "document.vala"
		_tmp14_ = self->tab;
#line 118 "document.vala"
		if (_tmp14_ != NULL) {
#line 704 "document.c"
			gchar* primary_msg = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			TeplInfoBar* infobar = NULL;
			const gchar* _tmp19_;
			GError* _tmp20_;
			const gchar* _tmp21_;
			TeplInfoBar* _tmp22_;
			DocumentTab* _tmp23_;
			TeplInfoBar* _tmp24_;
			TeplInfoBar* _tmp25_;
#line 120 "document.vala"
			_tmp15_ = g_file_get_parse_name (location);
#line 120 "document.vala"
			_tmp16_ = _tmp15_;
#line 120 "document.vala"
			_tmp17_ = g_strdup_printf (_ ("Impossible to load the file “%s”."), _tmp16_);
#line 120 "document.vala"
			_tmp18_ = _tmp17_;
#line 120 "document.vala"
			_g_free0 (_tmp16_);
#line 120 "document.vala"
			primary_msg = _tmp18_;
#line 122 "document.vala"
			_tmp19_ = primary_msg;
#line 122 "document.vala"
			_tmp20_ = e;
#line 122 "document.vala"
			_tmp21_ = _tmp20_->message;
#line 122 "document.vala"
			_tmp22_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp19_, _tmp21_);
#line 122 "document.vala"
			g_object_ref_sink (_tmp22_);
#line 122 "document.vala"
			infobar = _tmp22_;
#line 124 "document.vala"
			_tmp23_ = self->tab;
#line 124 "document.vala"
			_tmp24_ = infobar;
#line 124 "document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp23_, (GtkInfoBar*) _tmp24_);
#line 125 "document.vala"
			_tmp25_ = infobar;
#line 125 "document.vala"
			gtk_widget_show ((GtkWidget*) _tmp25_);
#line 118 "document.vala"
			_g_object_unref0 (infobar);
#line 118 "document.vala"
			_g_free0 (primary_msg);
#line 756 "document.c"
		}
#line 94 "document.vala"
		_g_error_free0 (e);
#line 760 "document.c"
	}
	__finally8:
#line 94 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 94 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 94 "document.vala"
		g_clear_error (&_inner_error0_);
#line 94 "document.vala"
		return;
#line 771 "document.c"
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 789 "document.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1428 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1429 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1429 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1429 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1430 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1431 "glib-2.0.vapi"
		start = string_length + start;
#line 816 "document.c"
	}
#line 1433 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1434 "glib-2.0.vapi"
		end = string_length + end;
#line 822 "document.c"
	}
#line 1436 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 828 "document.c"
	} else {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 832 "document.c"
	}
#line 1436 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1437 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 840 "document.c"
	} else {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 844 "document.c"
	}
#line 1437 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1438 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1439 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1439 "glib-2.0.vapi"
	result = _tmp4_;
#line 1439 "glib-2.0.vapi"
	return result;
#line 856 "document.c"
}

void
document_set_contents (Document* self,
                       const gchar* contents)
{
	gchar* contents2 = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
#line 130 "document.vala"
	g_return_if_fail (self != NULL);
#line 130 "document.vala"
	g_return_if_fail (contents != NULL);
#line 133 "document.vala"
	contents2 = NULL;
#line 134 "document.vala"
	_tmp0_ = strlen (contents);
#line 134 "document.vala"
	_tmp1_ = _tmp0_;
#line 134 "document.vala"
	if (string_get (contents, (glong) (_tmp1_ - 1)) == '\n') {
#line 883 "document.c"
		gchar* _tmp2_;
#line 135 "document.vala"
		_tmp2_ = string_slice (contents, (glong) 0, (glong) -1);
#line 135 "document.vala"
		_g_free0 (contents2);
#line 135 "document.vala"
		contents2 = _tmp2_;
#line 891 "document.c"
	}
#line 137 "document.vala"
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
#line 138 "document.vala"
	_tmp4_ = contents2;
#line 138 "document.vala"
	_tmp3_ = _tmp4_;
#line 138 "document.vala"
	if (_tmp3_ == NULL) {
#line 138 "document.vala"
		_tmp3_ = contents;
#line 903 "document.c"
	}
#line 138 "document.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp3_, -1);
#line 139 "document.vala"
	self->priv->new_file = TRUE;
#line 140 "document.vala"
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 141 "document.vala"
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
#line 145 "document.vala"
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp5_);
#line 145 "document.vala"
	iter = _tmp5_;
#line 146 "document.vala"
	_tmp6_ = iter;
#line 146 "document.vala"
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
#line 130 "document.vala"
	_g_free0 (contents2);
#line 923 "document.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1518 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1519 "glib-2.0.vapi"
	result = self;
#line 1519 "glib-2.0.vapi"
	return result;
#line 936 "document.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1503 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1504 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1504 "glib-2.0.vapi"
	res_length1 = -1;
#line 1504 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1505 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1505 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1505 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1506 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1506 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1506 "glib-2.0.vapi"
	if (result_length1) {
#line 1506 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 973 "document.c"
	}
#line 1506 "glib-2.0.vapi"
	result = _tmp2_;
#line 1506 "glib-2.0.vapi"
	return result;
#line 979 "document.c"
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
#line 200 "document.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 200 "document.vala"
	return _data16_;
#line 989 "document.c"
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 200 "document.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 999 "document.c"
		Document* self;
#line 200 "document.vala"
		self = _data16_->self;
#line 200 "document.vala"
		_g_object_unref0 (_data16_->infobar);
#line 200 "document.vala"
		_g_object_unref0 (self);
#line 200 "document.vala"
		g_slice_free (Block16Data, _data16_);
#line 1009 "document.c"
	}
}

static void
____lambda16_ (Block16Data* _data16_,
               gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp0_;
#line 214 "document.vala"
	self = _data16_->self;
#line 216 "document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 217 "document.vala"
		document_save (self, FALSE, FALSE);
#line 1025 "document.c"
	}
#line 218 "document.vala"
	_tmp0_ = _data16_->infobar;
#line 218 "document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1031 "document.c"
}

static void
_____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                      gint response_id,
                                      gpointer self)
{
#line 214 "document.vala"
	____lambda16_ (self, response_id);
#line 1041 "document.c"
}

void
document_save (Document* self,
               gboolean check_file_changed_on_disk,
               gboolean force)
{
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GError* _inner_error0_ = NULL;
#line 149 "document.vala"
	g_return_if_fail (self != NULL);
#line 151 "document.vala"
	_tmp0_ = self->priv->_location;
#line 151 "document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 154 "document.vala"
	if (!force) {
#line 154 "document.vala"
		_tmp2_ = !self->priv->new_file;
#line 1075 "document.c"
	} else {
#line 154 "document.vala"
		_tmp2_ = FALSE;
#line 1079 "document.c"
	}
#line 154 "document.vala"
	if (_tmp2_) {
#line 154 "document.vala"
		_tmp1_ = !gtk_text_buffer_get_modified ((GtkTextBuffer*) self);
#line 1085 "document.c"
	} else {
#line 154 "document.vala"
		_tmp1_ = FALSE;
#line 1089 "document.c"
	}
#line 154 "document.vala"
	if (_tmp1_) {
#line 155 "document.vala"
		return;
#line 1095 "document.c"
	}
#line 159 "document.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
#line 159 "document.vala"
	start = _tmp3_;
#line 159 "document.vala"
	end = _tmp4_;
#line 160 "document.vala"
	_tmp5_ = start;
#line 160 "document.vala"
	_tmp6_ = end;
#line 160 "document.vala"
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
#line 160 "document.vala"
	text = _tmp7_;
#line 163 "document.vala"
	_tmp8_ = text;
#line 163 "document.vala"
	_tmp9_ = text;
#line 163 "document.vala"
	_tmp10_ = strlen (_tmp9_);
#line 163 "document.vala"
	_tmp11_ = _tmp10_;
#line 163 "document.vala"
	if (string_get (_tmp8_, (glong) (_tmp11_ - 1)) != '\n') {
#line 1121 "document.c"
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
#line 164 "document.vala"
		_tmp12_ = text;
#line 164 "document.vala"
		_tmp13_ = string_to_string (_tmp12_);
#line 164 "document.vala"
		_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
#line 164 "document.vala"
		_g_free0 (text);
#line 164 "document.vala"
		text = _tmp14_;
#line 1135 "document.c"
	}
	{
		GSettings* settings = NULL;
		GSettings* _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean make_backup = FALSE;
		const gchar* _tmp18_ = NULL;
		gchar* etag = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* parent = NULL;
		GFile* _tmp37_;
		GFile* _tmp38_;
		gboolean _tmp39_ = FALSE;
		GFile* _tmp40_;
		GFile* _tmp43_;
		const gchar* _tmp44_;
		guint8* _tmp45_;
		gint _tmp45__length1;
		guint8* _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		gchar* _tmp48_ = NULL;
		GtkRecentManager* _tmp49_;
		GFile* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
#line 168 "document.vala"
		_tmp15_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 168 "document.vala"
		settings = _tmp15_;
#line 170 "document.vala"
		if (!self->priv->backup_made) {
#line 1169 "document.c"
			GSettings* _tmp17_;
#line 171 "document.vala"
			_tmp17_ = settings;
#line 171 "document.vala"
			_tmp16_ = g_settings_get_boolean (_tmp17_, "create-backup-copy");
#line 1175 "document.c"
		} else {
#line 170 "document.vala"
			_tmp16_ = FALSE;
#line 1179 "document.c"
		}
#line 170 "document.vala"
		make_backup = _tmp16_;
#line 173 "document.vala"
		if (check_file_changed_on_disk) {
#line 1185 "document.c"
			const gchar* _tmp19_;
#line 173 "document.vala"
			_tmp19_ = self->priv->_etag;
#line 173 "document.vala"
			_tmp18_ = _tmp19_;
#line 1191 "document.c"
		} else {
#line 173 "document.vala"
			_tmp18_ = NULL;
#line 1195 "document.c"
		}
#line 173 "document.vala"
		_tmp20_ = g_strdup (_tmp18_);
#line 173 "document.vala"
		etag = _tmp20_;
#line 176 "document.vala"
		_tmp21_ = self->priv->encoding;
#line 176 "document.vala"
		if (_tmp21_ != NULL) {
#line 1205 "document.c"
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
#line 177 "document.vala"
			_tmp23_ = text;
#line 177 "document.vala"
			_tmp24_ = text;
#line 177 "document.vala"
			_tmp25_ = strlen (_tmp24_);
#line 177 "document.vala"
			_tmp26_ = _tmp25_;
#line 177 "document.vala"
			_tmp27_ = self->priv->encoding;
#line 177 "document.vala"
			_tmp28_ = g_convert (_tmp23_, (gssize) _tmp26_, _tmp27_, "UTF-8", NULL, NULL, &_inner_error0_);
#line 177 "document.vala"
			_tmp22_ = _tmp28_;
#line 177 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 177 "document.vala"
				_g_free0 (etag);
#line 177 "document.vala"
				_g_object_unref0 (settings);
#line 1234 "document.c"
				goto __catch9_g_error;
			}
#line 177 "document.vala"
			_tmp29_ = _tmp22_;
#line 177 "document.vala"
			_tmp22_ = NULL;
#line 177 "document.vala"
			_g_free0 (text);
#line 177 "document.vala"
			text = _tmp29_;
#line 176 "document.vala"
			_g_free0 (_tmp22_);
#line 1247 "document.c"
		} else {
			gchar* _tmp30_ = NULL;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
#line 181 "document.vala"
			_tmp31_ = text;
#line 181 "document.vala"
			_tmp32_ = text;
#line 181 "document.vala"
			_tmp33_ = strlen (_tmp32_);
#line 181 "document.vala"
			_tmp34_ = _tmp33_;
#line 181 "document.vala"
			_tmp35_ = g_filename_from_utf8 (_tmp31_, (gssize) _tmp34_, NULL, NULL, &_inner_error0_);
#line 181 "document.vala"
			_tmp30_ = _tmp35_;
#line 181 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "document.vala"
				_g_free0 (etag);
#line 181 "document.vala"
				_g_object_unref0 (settings);
#line 1274 "document.c"
				goto __catch9_g_error;
			}
#line 181 "document.vala"
			_tmp36_ = _tmp30_;
#line 181 "document.vala"
			_tmp30_ = NULL;
#line 181 "document.vala"
			_g_free0 (text);
#line 181 "document.vala"
			text = _tmp36_;
#line 176 "document.vala"
			_g_free0 (_tmp30_);
#line 1287 "document.c"
		}
#line 184 "document.vala"
		_tmp37_ = self->priv->_location;
#line 184 "document.vala"
		_tmp38_ = g_file_get_parent (_tmp37_);
#line 184 "document.vala"
		parent = _tmp38_;
#line 185 "document.vala"
		_tmp40_ = parent;
#line 185 "document.vala"
		if (_tmp40_ != NULL) {
#line 1299 "document.c"
			GFile* _tmp41_;
#line 185 "document.vala"
			_tmp41_ = parent;
#line 185 "document.vala"
			_tmp39_ = !g_file_query_exists (_tmp41_, NULL);
#line 1305 "document.c"
		} else {
#line 185 "document.vala"
			_tmp39_ = FALSE;
#line 1309 "document.c"
		}
#line 185 "document.vala"
		if (_tmp39_) {
#line 1313 "document.c"
			GFile* _tmp42_;
#line 186 "document.vala"
			_tmp42_ = parent;
#line 186 "document.vala"
			g_file_make_directory_with_parents (_tmp42_, NULL, &_inner_error0_);
#line 186 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 186 "document.vala"
				_g_object_unref0 (parent);
#line 186 "document.vala"
				_g_free0 (etag);
#line 186 "document.vala"
				_g_object_unref0 (settings);
#line 1327 "document.c"
				goto __catch9_g_error;
			}
		}
#line 188 "document.vala"
		_tmp43_ = self->priv->_location;
#line 188 "document.vala"
		_tmp44_ = text;
#line 188 "document.vala"
		_tmp45_ = string_get_data (_tmp44_, &_tmp45__length1);
#line 188 "document.vala"
		_tmp46_ = _tmp45_;
#line 188 "document.vala"
		_tmp46__length1 = _tmp45__length1;
#line 188 "document.vala"
		_tmp47_ = etag;
#line 188 "document.vala"
		g_file_replace_contents (_tmp43_, _tmp46_, (gsize) _tmp46__length1, _tmp47_, make_backup, G_FILE_CREATE_NONE, &_tmp48_, NULL, &_inner_error0_);
#line 188 "document.vala"
		_g_free0 (self->priv->_etag);
#line 188 "document.vala"
		self->priv->_etag = _tmp48_;
#line 188 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 188 "document.vala"
			_g_object_unref0 (parent);
#line 188 "document.vala"
			_g_free0 (etag);
#line 188 "document.vala"
			_g_object_unref0 (settings);
#line 1357 "document.c"
			goto __catch9_g_error;
		}
#line 191 "document.vala"
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 193 "document.vala"
		_tmp49_ = gtk_recent_manager_get_default ();
#line 193 "document.vala"
		_tmp50_ = self->priv->_location;
#line 193 "document.vala"
		_tmp51_ = g_file_get_uri (_tmp50_);
#line 193 "document.vala"
		_tmp52_ = _tmp51_;
#line 193 "document.vala"
		gtk_recent_manager_add_item (_tmp49_, _tmp52_);
#line 193 "document.vala"
		_g_free0 (_tmp52_);
#line 194 "document.vala"
		self->priv->backup_made = TRUE;
#line 196 "document.vala"
		tepl_buffer_save_metadata_into_metadata_manager ((TeplBuffer*) self);
#line 166 "document.vala"
		_g_object_unref0 (parent);
#line 166 "document.vala"
		_g_free0 (etag);
#line 166 "document.vala"
		_g_object_unref0 (settings);
#line 1384 "document.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		gboolean _tmp53_ = FALSE;
		GError* _tmp54_;
#line 166 "document.vala"
		e = _inner_error0_;
#line 166 "document.vala"
		_inner_error0_ = NULL;
#line 200 "document.vala"
		_tmp54_ = e;
#line 200 "document.vala"
		if (g_error_matches (_tmp54_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
#line 1400 "document.c"
			DocumentTab* _tmp55_;
#line 200 "document.vala"
			_tmp55_ = self->tab;
#line 200 "document.vala"
			_tmp53_ = _tmp55_ != NULL;
#line 1406 "document.c"
		} else {
#line 200 "document.vala"
			_tmp53_ = FALSE;
#line 1410 "document.c"
		}
#line 200 "document.vala"
		if (_tmp53_) {
#line 1414 "document.c"
			Block16Data* _data16_;
			gchar* primary_msg = NULL;
			GFile* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* secondary_msg = NULL;
			gchar* _tmp61_;
			const gchar* _tmp62_;
			const gchar* _tmp63_;
			TeplInfoBar* _tmp64_;
			TeplInfoBar* _tmp65_;
			TeplInfoBar* _tmp66_;
			DocumentTab* _tmp67_;
			TeplInfoBar* _tmp68_;
			TeplInfoBar* _tmp69_;
			TeplInfoBar* _tmp70_;
#line 200 "document.vala"
			_data16_ = g_slice_new0 (Block16Data);
#line 200 "document.vala"
			_data16_->_ref_count_ = 1;
#line 200 "document.vala"
			_data16_->self = g_object_ref (self);
#line 202 "document.vala"
			_tmp56_ = self->priv->_location;
#line 202 "document.vala"
			_tmp57_ = g_file_get_parse_name (_tmp56_);
#line 202 "document.vala"
			_tmp58_ = _tmp57_;
#line 202 "document.vala"
			_tmp59_ = g_strdup_printf (_ ("The file %s has been modified since reading it."), _tmp58_);
#line 202 "document.vala"
			_tmp60_ = _tmp59_;
#line 202 "document.vala"
			_g_free0 (_tmp58_);
#line 202 "document.vala"
			primary_msg = _tmp60_;
#line 204 "document.vala"
			_tmp61_ = g_strdup (_ ("If you save it, all the external changes could be lost. Save it anyway" \
"?"));
#line 204 "document.vala"
			secondary_msg = _tmp61_;
#line 207 "document.vala"
			_tmp62_ = primary_msg;
#line 207 "document.vala"
			_tmp63_ = secondary_msg;
#line 207 "document.vala"
			_tmp64_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp62_, _tmp63_);
#line 207 "document.vala"
			g_object_ref_sink (_tmp64_);
#line 207 "document.vala"
			_data16_->infobar = _tmp64_;
#line 209 "document.vala"
			_tmp65_ = _data16_->infobar;
#line 209 "document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp65_, _ ("_Save Anyway"), (gint) GTK_RESPONSE_YES);
#line 210 "document.vala"
			_tmp66_ = _data16_->infobar;
#line 210 "document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp66_, _ ("_Don’t Save"), (gint) GTK_RESPONSE_CANCEL);
#line 211 "document.vala"
			_tmp67_ = self->tab;
#line 211 "document.vala"
			_tmp68_ = _data16_->infobar;
#line 211 "document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp67_, (GtkInfoBar*) _tmp68_);
#line 212 "document.vala"
			_tmp69_ = _data16_->infobar;
#line 212 "document.vala"
			gtk_widget_show ((GtkWidget*) _tmp69_);
#line 214 "document.vala"
			_tmp70_ = _data16_->infobar;
#line 214 "document.vala"
			g_signal_connect_data ((GtkInfoBar*) _tmp70_, "response", (GCallback) _____lambda16__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 200 "document.vala"
			_g_free0 (secondary_msg);
#line 200 "document.vala"
			_g_free0 (primary_msg);
#line 200 "document.vala"
			block16_data_unref (_data16_);
#line 200 "document.vala"
			_data16_ = NULL;
#line 1497 "document.c"
		} else {
			GError* _tmp71_;
			const gchar* _tmp72_;
			DocumentTab* _tmp73_;
#line 223 "document.vala"
			_tmp71_ = e;
#line 223 "document.vala"
			_tmp72_ = _tmp71_->message;
#line 223 "document.vala"
			g_warning ("document.vala:223: %s", _tmp72_);
#line 225 "document.vala"
			_tmp73_ = self->tab;
#line 225 "document.vala"
			if (_tmp73_ != NULL) {
#line 1512 "document.c"
				gchar* primary_msg = NULL;
				gchar* _tmp74_;
				TeplInfoBar* infobar = NULL;
				const gchar* _tmp75_;
				GError* _tmp76_;
				const gchar* _tmp77_;
				TeplInfoBar* _tmp78_;
				TeplInfoBar* _tmp79_;
				DocumentTab* _tmp80_;
				TeplInfoBar* _tmp81_;
				TeplInfoBar* _tmp82_;
#line 227 "document.vala"
				_tmp74_ = g_strdup (_ ("Impossible to save the file."));
#line 227 "document.vala"
				primary_msg = _tmp74_;
#line 228 "document.vala"
				_tmp75_ = primary_msg;
#line 228 "document.vala"
				_tmp76_ = e;
#line 228 "document.vala"
				_tmp77_ = _tmp76_->message;
#line 228 "document.vala"
				_tmp78_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp75_, _tmp77_);
#line 228 "document.vala"
				g_object_ref_sink (_tmp78_);
#line 228 "document.vala"
				infobar = _tmp78_;
#line 230 "document.vala"
				_tmp79_ = infobar;
#line 230 "document.vala"
				tepl_info_bar_add_close_button (_tmp79_);
#line 231 "document.vala"
				_tmp80_ = self->tab;
#line 231 "document.vala"
				_tmp81_ = infobar;
#line 231 "document.vala"
				tepl_tab_add_info_bar ((TeplTab*) _tmp80_, (GtkInfoBar*) _tmp81_);
#line 232 "document.vala"
				_tmp82_ = infobar;
#line 232 "document.vala"
				gtk_widget_show ((GtkWidget*) _tmp82_);
#line 225 "document.vala"
				_g_object_unref0 (infobar);
#line 225 "document.vala"
				_g_free0 (primary_msg);
#line 1558 "document.c"
			}
		}
#line 166 "document.vala"
		_g_error_free0 (e);
#line 1563 "document.c"
	}
	__finally9:
#line 166 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 166 "document.vala"
		_g_free0 (text);
#line 166 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 166 "document.vala"
		g_clear_error (&_inner_error0_);
#line 166 "document.vala"
		return;
#line 1576 "document.c"
	}
#line 149 "document.vala"
	_g_free0 (text);
#line 1580 "document.c"
}

static gchar*
document_to_utf8 (Document* self,
                  const gchar* text,
                  GError** error)
{
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 238 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 238 "document.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 1595 "document.c"
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
#line 240 "document.vala"
		charset_collection = ENCODINGS_CHARSETS;
#line 240 "document.vala"
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
#line 240 "document.vala"
		for (charset_it = 0; charset_it < charset_collection_length1; charset_it = charset_it + 1) {
#line 1607 "document.c"
			gchar* _tmp0_;
			gchar* charset = NULL;
#line 240 "document.vala"
			_tmp0_ = g_strdup (charset_collection[charset_it]);
#line 240 "document.vala"
			charset = _tmp0_;
#line 1614 "document.c"
			{
				{
					gchar* utf8_text = NULL;
					gint _tmp1_;
					gint _tmp2_;
					const gchar* _tmp3_;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
#line 244 "document.vala"
					_tmp1_ = strlen (text);
#line 244 "document.vala"
					_tmp2_ = _tmp1_;
#line 244 "document.vala"
					_tmp3_ = charset;
#line 244 "document.vala"
					_tmp4_ = g_convert (text, (gssize) _tmp2_, "UTF-8", _tmp3_, NULL, NULL, &_inner_error0_);
#line 244 "document.vala"
					utf8_text = _tmp4_;
#line 244 "document.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 244 "document.vala"
						if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 1638 "document.c"
							goto __catch10_g_convert_error;
						}
#line 244 "document.vala"
						_g_free0 (charset);
#line 244 "document.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 244 "document.vala"
						g_clear_error (&_inner_error0_);
#line 244 "document.vala"
						return NULL;
#line 1649 "document.c"
					}
#line 246 "document.vala"
					_tmp5_ = charset;
#line 246 "document.vala"
					_tmp6_ = g_strdup (_tmp5_);
#line 246 "document.vala"
					_g_free0 (self->priv->encoding);
#line 246 "document.vala"
					self->priv->encoding = _tmp6_;
#line 247 "document.vala"
					result = utf8_text;
#line 247 "document.vala"
					_g_free0 (charset);
#line 247 "document.vala"
					return result;
#line 1665 "document.c"
				}
				goto __finally10;
				__catch10_g_convert_error:
				{
					GError* e = NULL;
#line 242 "document.vala"
					e = _inner_error0_;
#line 242 "document.vala"
					_inner_error0_ = NULL;
#line 251 "document.vala"
					_g_error_free0 (e);
#line 251 "document.vala"
					_g_free0 (charset);
#line 251 "document.vala"
					continue;
#line 1681 "document.c"
				}
				__finally10:
#line 242 "document.vala"
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 242 "document.vala"
					g_propagate_error (error, _inner_error0_);
#line 242 "document.vala"
					_g_free0 (charset);
#line 242 "document.vala"
					return NULL;
#line 1692 "document.c"
				} else {
#line 242 "document.vala"
					_g_free0 (charset);
#line 242 "document.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 242 "document.vala"
					g_clear_error (&_inner_error0_);
#line 242 "document.vala"
					return NULL;
#line 1702 "document.c"
				}
#line 240 "document.vala"
				_g_free0 (charset);
#line 1706 "document.c"
			}
		}
	}
#line 254 "document.vala"
	_tmp7_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _ ("Error trying to convert the document to UTF-8"));
#line 254 "document.vala"
	_inner_error0_ = _tmp7_;
#line 254 "document.vala"
	if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 254 "document.vala"
		g_propagate_error (error, _inner_error0_);
#line 254 "document.vala"
		return NULL;
#line 1720 "document.c"
	} else {
#line 254 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 254 "document.vala"
		g_clear_error (&_inner_error0_);
#line 254 "document.vala"
		return NULL;
#line 1728 "document.c"
	}
}

static void
document_update_syntax_highlighting (Document* self)
{
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	gchar* content_type = NULL;
	GtkSourceLanguage* lang = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkSourceLanguage* _tmp10_;
	GtkSourceLanguage* _tmp11_;
	GtkSourceLanguage* _tmp12_;
	GError* _inner_error0_ = NULL;
#line 258 "document.vala"
	g_return_if_fail (self != NULL);
#line 260 "document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 260 "document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 260 "document.vala"
	lm = _tmp1_;
#line 261 "document.vala"
	content_type = NULL;
#line 1758 "document.c"
	{
		GFileInfo* info = NULL;
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 264 "document.vala"
		_tmp2_ = self->priv->_location;
#line 264 "document.vala"
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 264 "document.vala"
		info = _tmp3_;
#line 264 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1773 "document.c"
			goto __catch11_g_error;
		}
#line 266 "document.vala"
		_tmp4_ = g_file_info_get_content_type (info);
#line 266 "document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 266 "document.vala"
		_g_free0 (content_type);
#line 266 "document.vala"
		content_type = _tmp5_;
#line 262 "document.vala"
		_g_object_unref0 (info);
#line 1786 "document.c"
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
#line 262 "document.vala"
		e = _inner_error0_;
#line 262 "document.vala"
		_inner_error0_ = NULL;
#line 262 "document.vala"
		_g_error_free0 (e);
#line 1798 "document.c"
	}
	__finally11:
#line 262 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 262 "document.vala"
		_g_free0 (content_type);
#line 262 "document.vala"
		_g_object_unref0 (lm);
#line 262 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 262 "document.vala"
		g_clear_error (&_inner_error0_);
#line 262 "document.vala"
		return;
#line 1813 "document.c"
	}
#line 270 "document.vala"
	_tmp6_ = self->priv->_location;
#line 270 "document.vala"
	_tmp7_ = g_file_get_parse_name (_tmp6_);
#line 270 "document.vala"
	_tmp8_ = _tmp7_;
#line 270 "document.vala"
	_tmp9_ = content_type;
#line 270 "document.vala"
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
#line 270 "document.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 270 "document.vala"
	_tmp12_ = _tmp11_;
#line 270 "document.vala"
	_g_free0 (_tmp8_);
#line 270 "document.vala"
	lang = _tmp12_;
#line 271 "document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
#line 258 "document.vala"
	_g_object_unref0 (lang);
#line 258 "document.vala"
	_g_free0 (content_type);
#line 258 "document.vala"
	_g_object_unref0 (lm);
#line 1841 "document.c"
}

static void
document_update_project_id (Document* self)
{
	gint i = 0;
#line 274 "document.vala"
	g_return_if_fail (self != NULL);
#line 276 "document.vala"
	i = 0;
#line 1852 "document.c"
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 277 "document.vala"
		_tmp0_ = projects_get_default ();
#line 277 "document.vala"
		_tmp1_ = _tmp0_;
#line 277 "document.vala"
		_tmp2_ = projects_iterator (_tmp1_);
#line 277 "document.vala"
		_tmp3_ = _tmp2_;
#line 277 "document.vala"
		_projects_unref0 (_tmp1_);
#line 277 "document.vala"
		_project_it = _tmp3_;
#line 277 "document.vala"
		while (TRUE) {
#line 1873 "document.c"
			GeeIterator* _tmp4_;
			Project project = {0};
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_;
			Project _tmp9_ = {0};
			Project _tmp10_;
			GFile* _tmp11_;
			Project _tmp12_;
			GFile* _tmp13_;
			gint _tmp14_;
#line 277 "document.vala"
			_tmp4_ = _project_it;
#line 277 "document.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 277 "document.vala"
				break;
#line 1892 "document.c"
			}
#line 277 "document.vala"
			_tmp5_ = _project_it;
#line 277 "document.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 277 "document.vala"
			_tmp7_ = (Project*) _tmp6_;
#line 277 "document.vala"
			_tmp8_ = *_tmp7_;
#line 277 "document.vala"
			project_copy (&_tmp8_, &_tmp9_);
#line 277 "document.vala"
			_tmp10_ = _tmp9_;
#line 277 "document.vala"
			_project_free0 (_tmp7_);
#line 277 "document.vala"
			project = _tmp10_;
#line 279 "document.vala"
			_tmp11_ = self->priv->_location;
#line 279 "document.vala"
			_tmp12_ = project;
#line 279 "document.vala"
			_tmp13_ = _tmp12_.directory;
#line 279 "document.vala"
			if (g_file_has_prefix (_tmp11_, _tmp13_)) {
#line 281 "document.vala"
				document_set_project_id (self, i);
#line 282 "document.vala"
				project_destroy (&project);
#line 282 "document.vala"
				_g_object_unref0 (_project_it);
#line 282 "document.vala"
				return;
#line 1926 "document.c"
			}
#line 284 "document.vala"
			_tmp14_ = i;
#line 284 "document.vala"
			i = _tmp14_ + 1;
#line 277 "document.vala"
			project_destroy (&project);
#line 1934 "document.c"
		}
#line 277 "document.vala"
		_g_object_unref0 (_project_it);
#line 1938 "document.c"
	}
#line 287 "document.vala"
	document_set_project_id (self, -1);
#line 1942 "document.c"
}

gchar*
document_get_uri_for_display (Document* self)
{
	GFile* _tmp0_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result = NULL;
#line 290 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 292 "document.vala"
	_tmp0_ = self->priv->_location;
#line 292 "document.vala"
	if (_tmp0_ == NULL) {
#line 1961 "document.c"
		TeplFile* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 293 "document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 293 "document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 293 "document.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 293 "document.vala"
		result = _tmp3_;
#line 293 "document.vala"
		return result;
#line 1975 "document.c"
	}
#line 295 "document.vala"
	_tmp4_ = self->priv->_location;
#line 295 "document.vala"
	_tmp5_ = g_file_get_parse_name (_tmp4_);
#line 295 "document.vala"
	_tmp6_ = _tmp5_;
#line 295 "document.vala"
	_tmp7_ = tepl_utils_replace_home_dir_with_tilde (_tmp6_);
#line 295 "document.vala"
	_tmp8_ = _tmp7_;
#line 295 "document.vala"
	_g_free0 (_tmp6_);
#line 295 "document.vala"
	result = _tmp8_;
#line 295 "document.vala"
	return result;
#line 1993 "document.c"
}

gchar*
document_get_short_name_for_display (Document* self)
{
	GFile* _tmp0_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* result = NULL;
#line 298 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 300 "document.vala"
	_tmp0_ = self->priv->_location;
#line 300 "document.vala"
	if (_tmp0_ == NULL) {
#line 2009 "document.c"
		TeplFile* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 301 "document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 301 "document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 301 "document.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 301 "document.vala"
		result = _tmp3_;
#line 301 "document.vala"
		return result;
#line 2023 "document.c"
	}
#line 303 "document.vala"
	_tmp4_ = self->priv->_location;
#line 303 "document.vala"
	_tmp5_ = g_file_get_basename (_tmp4_);
#line 303 "document.vala"
	result = _tmp5_;
#line 303 "document.vala"
	return result;
#line 2033 "document.c"
}

gboolean
document_is_externally_modified (Document* self)
{
	GFile* _tmp0_;
	gchar* current_etag = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 306 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 308 "document.vala"
	_tmp0_ = self->priv->_location;
#line 308 "document.vala"
	if (_tmp0_ == NULL) {
#line 309 "document.vala"
		result = FALSE;
#line 309 "document.vala"
		return result;
#line 2055 "document.c"
	}
#line 311 "document.vala"
	current_etag = NULL;
#line 2059 "document.c"
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 314 "document.vala"
		_tmp1_ = self->priv->_location;
#line 314 "document.vala"
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 314 "document.vala"
		file_info = _tmp2_;
#line 314 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2075 "document.c"
			goto __catch12_g_error;
		}
#line 316 "document.vala"
		_tmp3_ = file_info;
#line 316 "document.vala"
		_tmp4_ = g_file_info_get_etag (_tmp3_);
#line 316 "document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 316 "document.vala"
		_g_free0 (current_etag);
#line 316 "document.vala"
		current_etag = _tmp5_;
#line 312 "document.vala"
		_g_object_unref0 (file_info);
#line 2090 "document.c"
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
#line 312 "document.vala"
		e = _inner_error0_;
#line 312 "document.vala"
		_inner_error0_ = NULL;
#line 320 "document.vala"
		result = FALSE;
#line 320 "document.vala"
		_g_error_free0 (e);
#line 320 "document.vala"
		_g_free0 (current_etag);
#line 320 "document.vala"
		return result;
#line 2108 "document.c"
	}
	__finally12:
#line 312 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2113 "document.c"
		gboolean _tmp6_ = FALSE;
#line 312 "document.vala"
		_g_free0 (current_etag);
#line 312 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 312 "document.vala"
		g_clear_error (&_inner_error0_);
#line 312 "document.vala"
		return _tmp6_;
#line 2123 "document.c"
	}
#line 323 "document.vala"
	_tmp8_ = current_etag;
#line 323 "document.vala"
	if (_tmp8_ != NULL) {
#line 2129 "document.c"
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 323 "document.vala"
		_tmp9_ = current_etag;
#line 323 "document.vala"
		_tmp10_ = self->priv->_etag;
#line 323 "document.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
#line 2138 "document.c"
	} else {
#line 323 "document.vala"
		_tmp7_ = FALSE;
#line 2142 "document.c"
	}
#line 323 "document.vala"
	result = _tmp7_;
#line 323 "document.vala"
	_g_free0 (current_etag);
#line 323 "document.vala"
	return result;
#line 2150 "document.c"
}

void
document_comment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
#line 326 "document.vala"
	g_return_if_fail (self != NULL);
#line 330 "document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 330 "document.vala"
	start = _tmp0_;
#line 330 "document.vala"
	end = _tmp1_;
#line 332 "document.vala"
	_tmp2_ = start;
#line 332 "document.vala"
	_tmp3_ = end;
#line 332 "document.vala"
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
#line 2176 "document.c"
}

void
document_comment_between (Document* self,
                          GtkTextIter* start_iter,
                          GtkTextIter* end_iter,
                          gboolean end_iter_set)
{
	gint start_line = 0;
	gint end_line = 0;
	GtkTextIter cur_iter = {0};
	GtkTextIter _tmp0_ = {0};
#line 336 "document.vala"
	g_return_if_fail (self != NULL);
#line 336 "document.vala"
	g_return_if_fail (start_iter != NULL);
#line 336 "document.vala"
	g_return_if_fail (end_iter != NULL);
#line 339 "document.vala"
	start_line = gtk_text_iter_get_line (start_iter);
#line 340 "document.vala"
	end_line = start_line;
#line 342 "document.vala"
	if (end_iter_set) {
#line 343 "document.vala"
		end_line = gtk_text_iter_get_line (end_iter);
#line 2203 "document.c"
	}
#line 346 "document.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp0_, start_line);
#line 346 "document.vala"
	cur_iter = _tmp0_;
#line 348 "document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2211 "document.c"
	{
		gint line_num = 0;
#line 350 "document.vala"
		line_num = start_line;
#line 2216 "document.c"
		{
			gboolean _tmp1_ = FALSE;
#line 350 "document.vala"
			_tmp1_ = TRUE;
#line 350 "document.vala"
			while (TRUE) {
#line 350 "document.vala"
				if (!_tmp1_) {
#line 2225 "document.c"
					gint _tmp2_;
#line 350 "document.vala"
					_tmp2_ = line_num;
#line 350 "document.vala"
					line_num = _tmp2_ + 1;
#line 2231 "document.c"
				}
#line 350 "document.vala"
				_tmp1_ = FALSE;
#line 350 "document.vala"
				if (!(line_num <= end_line)) {
#line 350 "document.vala"
					break;
#line 2239 "document.c"
				}
#line 352 "document.vala"
				if (gtk_text_iter_ends_line (&cur_iter)) {
#line 354 "document.vala"
					document_insert (self, &cur_iter, "%", -1);
#line 2245 "document.c"
				} else {
#line 356 "document.vala"
					document_insert (self, &cur_iter, "% ", -1);
#line 2249 "document.c"
				}
#line 358 "document.vala"
				gtk_text_iter_forward_line (&cur_iter);
#line 2253 "document.c"
			}
		}
	}
#line 361 "document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2259 "document.c"
}

void
document_uncomment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line = 0;
	gint end_line = 0;
	gint line_count = 0;
#line 364 "document.vala"
	g_return_if_fail (self != NULL);
#line 367 "document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 367 "document.vala"
	start = _tmp0_;
#line 367 "document.vala"
	end = _tmp1_;
#line 369 "document.vala"
	start_line = gtk_text_iter_get_line (&start);
#line 370 "document.vala"
	end_line = gtk_text_iter_get_line (&end);
#line 371 "document.vala"
	line_count = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
#line 373 "document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2288 "document.c"
	{
		gint i = 0;
#line 375 "document.vala"
		i = start_line;
#line 2293 "document.c"
		{
			gboolean _tmp2_ = FALSE;
#line 375 "document.vala"
			_tmp2_ = TRUE;
#line 375 "document.vala"
			while (TRUE) {
#line 2300 "document.c"
				GtkTextIter _tmp4_ = {0};
				gchar* line = NULL;
				GtkTextIter _tmp7_;
				GtkTextIter _tmp8_;
				gchar* _tmp9_;
				gint j = 0;
				gint start_delete = 0;
				gint stop_delete = 0;
				GtkTextIter _tmp18_ = {0};
				GtkTextIter _tmp19_ = {0};
#line 375 "document.vala"
				if (!_tmp2_) {
#line 2313 "document.c"
					gint _tmp3_;
#line 375 "document.vala"
					_tmp3_ = i;
#line 375 "document.vala"
					i = _tmp3_ + 1;
#line 2319 "document.c"
				}
#line 375 "document.vala"
				_tmp2_ = FALSE;
#line 375 "document.vala"
				if (!(i <= end_line)) {
#line 375 "document.vala"
					break;
#line 2327 "document.c"
				}
#line 377 "document.vala"
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp4_, i);
#line 377 "document.vala"
				start = _tmp4_;
#line 380 "document.vala"
				if (i == (line_count - 1)) {
#line 2335 "document.c"
					GtkTextIter _tmp5_ = {0};
#line 381 "document.vala"
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp5_);
#line 381 "document.vala"
					end = _tmp5_;
#line 2341 "document.c"
				} else {
					GtkTextIter _tmp6_ = {0};
#line 383 "document.vala"
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp6_, i + 1);
#line 383 "document.vala"
					end = _tmp6_;
#line 2348 "document.c"
				}
#line 385 "document.vala"
				_tmp7_ = start;
#line 385 "document.vala"
				_tmp8_ = end;
#line 385 "document.vala"
				_tmp9_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp7_, &_tmp8_, FALSE);
#line 385 "document.vala"
				line = _tmp9_;
#line 388 "document.vala"
				j = 0;
#line 389 "document.vala"
				start_delete = -1;
#line 390 "document.vala"
				stop_delete = -1;
#line 391 "document.vala"
				while (TRUE) {
#line 2366 "document.c"
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gint _tmp17_;
#line 391 "document.vala"
					_tmp10_ = line;
#line 391 "document.vala"
					if (!(string_get (_tmp10_, (glong) j) != '\0')) {
#line 391 "document.vala"
						break;
#line 2376 "document.c"
					}
#line 393 "document.vala"
					_tmp11_ = line;
#line 393 "document.vala"
					if (string_get (_tmp11_, (glong) j) == '%') {
#line 2382 "document.c"
						const gchar* _tmp12_;
#line 395 "document.vala"
						start_delete = j;
#line 396 "document.vala"
						stop_delete = j + 1;
#line 397 "document.vala"
						_tmp12_ = line;
#line 397 "document.vala"
						if (string_get (_tmp12_, (glong) (j + 1)) == ' ') {
#line 2392 "document.c"
							gint _tmp13_;
#line 398 "document.vala"
							_tmp13_ = stop_delete;
#line 398 "document.vala"
							stop_delete = _tmp13_ + 1;
#line 2398 "document.c"
						}
#line 399 "document.vala"
						break;
#line 2402 "document.c"
					} else {
						gboolean _tmp14_ = FALSE;
						const gchar* _tmp15_;
#line 402 "document.vala"
						_tmp15_ = line;
#line 402 "document.vala"
						if (string_get (_tmp15_, (glong) j) != ' ') {
#line 2410 "document.c"
							const gchar* _tmp16_;
#line 402 "document.vala"
							_tmp16_ = line;
#line 402 "document.vala"
							_tmp14_ = string_get (_tmp16_, (glong) j) != '\t';
#line 2416 "document.c"
						} else {
#line 402 "document.vala"
							_tmp14_ = FALSE;
#line 2420 "document.c"
						}
#line 402 "document.vala"
						if (_tmp14_) {
#line 403 "document.vala"
							break;
#line 2426 "document.c"
						}
					}
#line 405 "document.vala"
					_tmp17_ = j;
#line 405 "document.vala"
					j = _tmp17_ + 1;
#line 2433 "document.c"
				}
#line 408 "document.vala"
				if (start_delete == -1) {
#line 409 "document.vala"
					_g_free0 (line);
#line 409 "document.vala"
					continue;
#line 2441 "document.c"
				}
#line 411 "document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp18_, i, start_delete);
#line 411 "document.vala"
				start = _tmp18_;
#line 412 "document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp19_, i, stop_delete);
#line 412 "document.vala"
				end = _tmp19_;
#line 413 "document.vala"
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
#line 375 "document.vala"
				_g_free0 (line);
#line 2455 "document.c"
			}
		}
	}
#line 416 "document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2461 "document.c"
}

Project*
document_get_project (Document* self)
{
	gint _tmp0_;
	Projects* _tmp1_;
	Projects* _tmp2_;
	gint _tmp3_;
	Project* _tmp4_;
	Project* _tmp5_;
	Project* result = NULL;
#line 419 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 421 "document.vala"
	_tmp0_ = self->priv->_project_id;
#line 421 "document.vala"
	if (_tmp0_ == -1) {
#line 422 "document.vala"
		result = NULL;
#line 422 "document.vala"
		return result;
#line 2484 "document.c"
	}
#line 424 "document.vala"
	_tmp1_ = projects_get_default ();
#line 424 "document.vala"
	_tmp2_ = _tmp1_;
#line 424 "document.vala"
	_tmp3_ = self->priv->_project_id;
#line 424 "document.vala"
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
#line 424 "document.vala"
	_tmp5_ = _tmp4_;
#line 424 "document.vala"
	_projects_unref0 (_tmp2_);
#line 424 "document.vala"
	result = _tmp5_;
#line 424 "document.vala"
	return result;
#line 2502 "document.c"
}

GFile*
document_get_main_file (Document* self)
{
	GFile* _tmp0_;
	Project* project = NULL;
	Project* _tmp1_;
	Project* _tmp2_;
	Project* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* result = NULL;
#line 427 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 429 "document.vala"
	_tmp0_ = self->priv->_location;
#line 429 "document.vala"
	if (_tmp0_ == NULL) {
#line 430 "document.vala"
		result = NULL;
#line 430 "document.vala"
		return result;
#line 2526 "document.c"
	}
#line 432 "document.vala"
	_tmp1_ = document_get_project (self);
#line 432 "document.vala"
	project = _tmp1_;
#line 433 "document.vala"
	_tmp2_ = project;
#line 433 "document.vala"
	if (_tmp2_ == NULL) {
#line 2536 "document.c"
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 434 "document.vala"
		_tmp3_ = self->priv->_location;
#line 434 "document.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 434 "document.vala"
		result = _tmp4_;
#line 434 "document.vala"
		_project_free0 (project);
#line 434 "document.vala"
		return result;
#line 2549 "document.c"
	}
#line 436 "document.vala"
	_tmp5_ = project;
#line 436 "document.vala"
	_tmp6_ = (*_tmp5_).main_file;
#line 436 "document.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 436 "document.vala"
	result = _tmp7_;
#line 436 "document.vala"
	_project_free0 (project);
#line 436 "document.vala"
	return result;
#line 2563 "document.c"
}

gboolean
document_is_main_file_a_tex_file (Document* self)
{
	GFile* main_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result = FALSE;
#line 439 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 441 "document.vala"
	_tmp0_ = document_get_main_file (self);
#line 441 "document.vala"
	main_file = _tmp0_;
#line 442 "document.vala"
	_tmp1_ = main_file;
#line 442 "document.vala"
	if (_tmp1_ == NULL) {
#line 443 "document.vala"
		result = FALSE;
#line 443 "document.vala"
		_g_object_unref0 (main_file);
#line 443 "document.vala"
		return result;
#line 2593 "document.c"
	}
#line 445 "document.vala"
	_tmp2_ = main_file;
#line 445 "document.vala"
	_tmp3_ = g_file_get_parse_name (_tmp2_);
#line 445 "document.vala"
	path = _tmp3_;
#line 446 "document.vala"
	_tmp4_ = path;
#line 446 "document.vala"
	result = g_str_has_suffix (_tmp4_, ".tex");
#line 446 "document.vala"
	_g_free0 (path);
#line 446 "document.vala"
	_g_object_unref0 (main_file);
#line 446 "document.vala"
	return result;
#line 2611 "document.c"
}

DocumentStructure*
document_get_structure (Document* self)
{
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp3_;
	DocumentStructure* _tmp4_;
	DocumentStructure* result = NULL;
#line 449 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 451 "document.vala"
	_tmp0_ = self->priv->_structure;
#line 451 "document.vala"
	if (_tmp0_ == NULL) {
#line 2627 "document.c"
		DocumentStructure* _tmp1_;
		DocumentStructure* _tmp2_;
#line 453 "document.vala"
		_tmp1_ = document_structure_new (self);
#line 453 "document.vala"
		_g_object_unref0 (self->priv->_structure);
#line 453 "document.vala"
		self->priv->_structure = _tmp1_;
#line 454 "document.vala"
		_tmp2_ = self->priv->_structure;
#line 454 "document.vala"
		document_structure_parse (_tmp2_);
#line 2640 "document.c"
	}
#line 456 "document.vala"
	_tmp3_ = self->priv->_structure;
#line 456 "document.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 456 "document.vala"
	result = _tmp4_;
#line 456 "document.vala"
	return result;
#line 2650 "document.c"
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
#line 459 "document.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 459 "document.vala"
	return _data17_;
#line 2660 "document.c"
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 459 "document.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 2670 "document.c"
		Document* self;
#line 459 "document.vala"
		self = _data17_->self;
#line 459 "document.vala"
		_g_object_unref0 (_data17_->infobar);
#line 459 "document.vala"
		_g_object_unref0 (self);
#line 459 "document.vala"
		g_slice_free (Block17Data, _data17_);
#line 2680 "document.c"
	}
}

static void
__lambda27_ (Block17Data* _data17_,
             gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp4_;
#line 491 "document.vala"
	self = _data17_->self;
#line 493 "document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 2694 "document.c"
		MainWindow* main_window = NULL;
		DocumentTab* _tmp0_;
		GtkWindow* _tmp1_;
		MainWindow* _tmp2_;
#line 495 "document.vala"
		_tmp0_ = self->tab;
#line 495 "document.vala"
		_tmp1_ = utils_get_toplevel_window ((GtkWidget*) _tmp0_);
#line 495 "document.vala"
		main_window = IS_MAIN_WINDOW (_tmp1_) ? ((MainWindow*) _tmp1_) : NULL;
#line 498 "document.vala"
		_tmp2_ = main_window;
#line 498 "document.vala"
		if (_tmp2_ != NULL) {
#line 2709 "document.c"
			MainWindow* _tmp3_;
#line 499 "document.vala"
			_tmp3_ = main_window;
#line 499 "document.vala"
			main_window_save_document (_tmp3_, self, TRUE);
#line 2715 "document.c"
		}
	}
#line 502 "document.vala"
	_tmp4_ = _data17_->infobar;
#line 502 "document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 2722 "document.c"
}

static void
___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                    gint response_id,
                                    gpointer self)
{
#line 491 "document.vala"
	__lambda27_ (self, response_id);
#line 2732 "document.c"
}

gboolean
document_set_tmp_location (Document* self)
{
	Block17Data* _data17_;
	gchar* template = NULL;
	gchar* _tmp0_;
	gchar* tmp_dir = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	DocumentTab* _tmp14_;
	TeplInfoBar* _tmp15_;
	TeplInfoBar* _tmp16_;
	TeplInfoBar* _tmp17_;
	DocumentTab* _tmp18_;
	TeplInfoBar* _tmp19_;
	TeplInfoBar* _tmp20_;
	TeplInfoBar* _tmp21_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 459 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 459 "document.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 459 "document.vala"
	_data17_->_ref_count_ = 1;
#line 459 "document.vala"
	_data17_->self = g_object_ref (self);
#line 462 "document.vala"
	_tmp0_ = g_strdup ("latexila-XXXXXX");
#line 462 "document.vala"
	template = _tmp0_;
#line 2769 "document.c"
	{
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp5_;
#line 467 "document.vala"
		_tmp2_ = template;
#line 467 "document.vala"
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error0_);
#line 467 "document.vala"
		_tmp1_ = _tmp3_;
#line 467 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2783 "document.c"
			gboolean _tmp4_ = FALSE;
#line 467 "document.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 2787 "document.c"
				goto __catch13_g_file_error;
			}
#line 467 "document.vala"
			_g_free0 (tmp_dir);
#line 467 "document.vala"
			_g_free0 (template);
#line 467 "document.vala"
			block17_data_unref (_data17_);
#line 467 "document.vala"
			_data17_ = NULL;
#line 467 "document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 467 "document.vala"
			g_clear_error (&_inner_error0_);
#line 467 "document.vala"
			return _tmp4_;
#line 2804 "document.c"
		}
#line 467 "document.vala"
		_tmp5_ = _tmp1_;
#line 467 "document.vala"
		_tmp1_ = NULL;
#line 467 "document.vala"
		_g_free0 (tmp_dir);
#line 467 "document.vala"
		tmp_dir = _tmp5_;
#line 465 "document.vala"
		_g_free0 (_tmp1_);
#line 2816 "document.c"
	}
	goto __finally13;
	__catch13_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 465 "document.vala"
		e = _inner_error0_;
#line 465 "document.vala"
		_inner_error0_ = NULL;
#line 471 "document.vala"
		_tmp6_ = e;
#line 471 "document.vala"
		_tmp7_ = _tmp6_->message;
#line 471 "document.vala"
		g_warning ("document.vala:471: Impossible to create temporary directory: %s", _tmp7_);
#line 472 "document.vala"
		result = FALSE;
#line 472 "document.vala"
		_g_error_free0 (e);
#line 472 "document.vala"
		_g_free0 (tmp_dir);
#line 472 "document.vala"
		_g_free0 (template);
#line 472 "document.vala"
		block17_data_unref (_data17_);
#line 472 "document.vala"
		_data17_ = NULL;
#line 472 "document.vala"
		return result;
#line 2848 "document.c"
	}
	__finally13:
#line 465 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2853 "document.c"
		gboolean _tmp8_ = FALSE;
#line 465 "document.vala"
		_g_free0 (tmp_dir);
#line 465 "document.vala"
		_g_free0 (template);
#line 465 "document.vala"
		block17_data_unref (_data17_);
#line 465 "document.vala"
		_data17_ = NULL;
#line 465 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 465 "document.vala"
		g_clear_error (&_inner_error0_);
#line 465 "document.vala"
		return _tmp8_;
#line 2869 "document.c"
	}
#line 476 "document.vala"
	_tmp9_ = tmp_dir;
#line 476 "document.vala"
	_tmp10_ = g_build_filename (_tmp9_, "tmp.tex", NULL);
#line 476 "document.vala"
	_tmp11_ = _tmp10_;
#line 476 "document.vala"
	_tmp12_ = g_file_new_for_path (_tmp11_);
#line 476 "document.vala"
	_tmp13_ = _tmp12_;
#line 476 "document.vala"
	document_set_location (self, _tmp13_);
#line 476 "document.vala"
	_g_object_unref0 (_tmp13_);
#line 476 "document.vala"
	_g_free0 (_tmp11_);
#line 480 "document.vala"
	_tmp14_ = self->tab;
#line 480 "document.vala"
	if (_tmp14_ == NULL) {
#line 481 "document.vala"
		result = TRUE;
#line 481 "document.vala"
		_g_free0 (tmp_dir);
#line 481 "document.vala"
		_g_free0 (template);
#line 481 "document.vala"
		block17_data_unref (_data17_);
#line 481 "document.vala"
		_data17_ = NULL;
#line 481 "document.vala"
		return result;
#line 2903 "document.c"
	}
#line 483 "document.vala"
	_tmp15_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer."), _ ("Do you want to save the file in a safer place?"));
#line 483 "document.vala"
	g_object_ref_sink (_tmp15_);
#line 483 "document.vala"
	_data17_->infobar = _tmp15_;
#line 486 "document.vala"
	_tmp16_ = _data17_->infobar;
#line 486 "document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp16_, _ ("Save _As"), (gint) GTK_RESPONSE_YES);
#line 487 "document.vala"
	_tmp17_ = _data17_->infobar;
#line 487 "document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp17_, _ ("Cancel"), (gint) GTK_RESPONSE_NO);
#line 488 "document.vala"
	_tmp18_ = self->tab;
#line 488 "document.vala"
	_tmp19_ = _data17_->infobar;
#line 488 "document.vala"
	tepl_tab_add_info_bar ((TeplTab*) _tmp18_, (GtkInfoBar*) _tmp19_);
#line 489 "document.vala"
	_tmp20_ = _data17_->infobar;
#line 489 "document.vala"
	gtk_widget_show ((GtkWidget*) _tmp20_);
#line 491 "document.vala"
	_tmp21_ = _data17_->infobar;
#line 491 "document.vala"
	g_signal_connect_data ((GtkInfoBar*) _tmp21_, "response", (GCallback) ___lambda27__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
#line 505 "document.vala"
	result = TRUE;
#line 505 "document.vala"
	_g_free0 (tmp_dir);
#line 505 "document.vala"
	_g_free0 (template);
#line 505 "document.vala"
	block17_data_unref (_data17_);
#line 505 "document.vala"
	_data17_ = NULL;
#line 505 "document.vala"
	return result;
#line 2945 "document.c"
}

void
document_set_metadata (Document* self,
                       const gchar* key,
                       const gchar* val)
{
	TeplMetadata* _tmp0_;
#line 508 "document.vala"
	g_return_if_fail (self != NULL);
#line 508 "document.vala"
	g_return_if_fail (key != NULL);
#line 510 "document.vala"
	_tmp0_ = tepl_buffer_get_metadata ((TeplBuffer*) self);
#line 510 "document.vala"
	tepl_metadata_set (_tmp0_, key, val);
#line 511 "document.vala"
	tepl_buffer_save_metadata_into_metadata_manager ((TeplBuffer*) self);
#line 2964 "document.c"
}

GFile*
document_get_location (Document* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 24 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "document.vala"
	_tmp0_ = self->priv->_location;
#line 24 "document.vala"
	result = _tmp0_;
#line 24 "document.vala"
	return result;
#line 2980 "document.c"
}

void
document_set_location (Document* self,
                       GFile* value)
{
#line 24 "document.vala"
	g_return_if_fail (self != NULL);
#line 24 "document.vala"
	if (document_get_location (self) != value) {
#line 2991 "document.c"
		GFile* _tmp0_;
#line 24 "document.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 24 "document.vala"
		_g_object_unref0 (self->priv->_location);
#line 24 "document.vala"
		self->priv->_location = _tmp0_;
#line 24 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_LOCATION_PROPERTY]);
#line 3001 "document.c"
	}
}

gboolean
document_get_readonly (Document* self)
{
	gboolean result;
#line 25 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 25 "document.vala"
	result = self->priv->_readonly;
#line 25 "document.vala"
	return result;
#line 3015 "document.c"
}

void
document_set_readonly (Document* self,
                       gboolean value)
{
#line 25 "document.vala"
	g_return_if_fail (self != NULL);
#line 25 "document.vala"
	if (document_get_readonly (self) != value) {
#line 25 "document.vala"
		self->priv->_readonly = value;
#line 25 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_READONLY_PROPERTY]);
#line 3030 "document.c"
	}
}

gint
document_get_project_id (Document* self)
{
	gint result;
#line 27 "document.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "document.vala"
	result = self->priv->_project_id;
#line 27 "document.vala"
	return result;
#line 3044 "document.c"
}

void
document_set_project_id (Document* self,
                         gint value)
{
#line 27 "document.vala"
	g_return_if_fail (self != NULL);
#line 27 "document.vala"
	if (document_get_project_id (self) != value) {
#line 27 "document.vala"
		self->priv->_project_id = value;
#line 27 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_PROJECT_ID_PROPERTY]);
#line 3059 "document.c"
	}
}

static void
document_class_init (DocumentClass * klass,
                     gpointer klass_data)
{
#line 22 "document.vala"
	document_parent_class = g_type_class_peek_parent (klass);
#line 22 "document.vala"
	g_type_class_adjust_private_offset (klass, &Document_private_offset);
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION_PROPERTY, document_properties[DOCUMENT_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY_PROPERTY, document_properties[DOCUMENT_READONLY_PROPERTY] = g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID_PROPERTY, document_properties[DOCUMENT_PROJECT_ID_PROPERTY] = g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3083 "document.c"
}

static void
document_instance_init (Document * self,
                        gpointer klass)
{
#line 22 "document.vala"
	self->priv = document_get_instance_private (self);
#line 25 "document.vala"
	self->priv->_readonly = FALSE;
#line 27 "document.vala"
	self->priv->_project_id = -1;
#line 28 "document.vala"
	self->priv->backup_made = FALSE;
#line 30 "document.vala"
	self->priv->encoding = NULL;
#line 31 "document.vala"
	self->priv->new_file = TRUE;
#line 32 "document.vala"
	self->priv->_structure = NULL;
#line 3104 "document.c"
}

static void
document_finalize (GObject * obj)
{
	Document * self;
#line 22 "document.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
#line 24 "document.vala"
	_g_object_unref0 (self->priv->_location);
#line 29 "document.vala"
	_g_free0 (self->priv->_etag);
#line 30 "document.vala"
	_g_free0 (self->priv->encoding);
#line 32 "document.vala"
	_g_object_unref0 (self->priv->_structure);
#line 22 "document.vala"
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
#line 3123 "document.c"
}

GType
document_get_type (void)
{
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (tepl_buffer_get_type (), "Document", &g_define_type_info, 0);
		Document_private_offset = g_type_add_instance_private (document_type_id, sizeof (DocumentPrivate));
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}

static void
_vala_document_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "document.vala"
	switch (property_id) {
#line 22 "document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "document.vala"
		g_value_set_object (value, document_get_location (self));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "document.vala"
		g_value_set_boolean (value, document_get_readonly (self));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "document.vala"
		g_value_set_int (value, document_get_project_id (self));
#line 22 "document.vala"
		break;
#line 3168 "document.c"
		default:
#line 22 "document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document.vala"
		break;
#line 3174 "document.c"
	}
}

static void
_vala_document_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "document.vala"
	switch (property_id) {
#line 22 "document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "document.vala"
		document_set_location (self, g_value_get_object (value));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "document.vala"
		document_set_readonly (self, g_value_get_boolean (value));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "document.vala"
		document_set_project_id (self, g_value_get_int (value));
#line 22 "document.vala"
		break;
#line 3206 "document.c"
		default:
#line 22 "document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document.vala"
		break;
#line 3212 "document.c"
	}
}

