/* app_settings.c generated by valac 0.46.7, the Vala compiler
 * generated from app_settings.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _AppSettingsPrivate AppSettingsPrivate;
enum  {
	APP_SETTINGS_0_PROPERTY,
	APP_SETTINGS_SYSTEM_FONT_PROPERTY,
	APP_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* app_settings_properties[APP_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

struct _AppSettings {
	GSettings parent_instance;
	AppSettingsPrivate * priv;
};

struct _AppSettingsClass {
	GSettingsClass parent_class;
};

struct _AppSettingsPrivate {
	GSettings* editor;
	gchar* _system_font;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

static gint AppSettings_private_offset;
static gpointer app_settings_parent_class = NULL;
static AppSettings* app_settings_instance;
static AppSettings* app_settings_instance = NULL;

GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
static AppSettings* app_settings_new (void);
static AppSettings* app_settings_construct (GType object_type);
static void app_settings_initialize (AppSettings* self);
AppSettings* app_settings_get_default (void);
static void app_settings_set_system_font (AppSettings* self,
                                   const gchar* value);
static void __lambda4_ (AppSettings* self,
                 GSettings* setting,
                 const gchar* key);
static void app_settings_set_font (AppSettings* self,
                            const gchar* font);
const gchar* app_settings_get_system_font (AppSettings* self);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda118_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda118__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda119_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda119__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda120_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
GeeList* glatex_app_get_views (GlatexApp* self);
static void ___lambda120__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda121_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda121__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda122_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda122__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda123_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda123__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda124_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GeeList* glatex_app_get_documents (GlatexApp* self);
static void ___lambda124__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda125_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
void document_tab_set_auto_save (DocumentTab* self,
                                 gboolean value);
static void ___lambda125__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda126_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
void document_tab_set_auto_save_interval (DocumentTab* self,
                                          guint value);
static void ___lambda126__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
void document_view_set_font_from_string (DocumentView* self,
                                         const gchar* font);
static void app_settings_finalize (GObject * obj);
static void _vala_app_settings_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_app_settings_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
app_settings_get_instance_private (AppSettings* self)
{
	return G_STRUCT_MEMBER_P (self, AppSettings_private_offset);
}

static AppSettings*
app_settings_construct (GType object_type)
{
	AppSettings * self = NULL;
#line 31 "app_settings.vala"
	self = (AppSettings*) g_object_new (object_type, "schema-id", "org.gnome.gnome-latex", NULL);
#line 32 "app_settings.vala"
	app_settings_initialize (self);
#line 29 "app_settings.vala"
	return self;
#line 237 "app_settings.c"
}

static AppSettings*
app_settings_new (void)
{
#line 29 "app_settings.vala"
	return app_settings_construct (TYPE_APP_SETTINGS);
#line 245 "app_settings.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 39 "app_settings.vala"
	return self ? g_object_ref (self) : NULL;
#line 253 "app_settings.c"
}

AppSettings*
app_settings_get_default (void)
{
	AppSettings* _tmp0_;
	AppSettings* _tmp2_;
	AppSettings* _tmp3_;
	AppSettings* result = NULL;
#line 37 "app_settings.vala"
	_tmp0_ = app_settings_instance;
#line 37 "app_settings.vala"
	if (_tmp0_ == NULL) {
#line 267 "app_settings.c"
		AppSettings* _tmp1_;
#line 38 "app_settings.vala"
		_tmp1_ = app_settings_new ();
#line 38 "app_settings.vala"
		_g_object_unref0 (app_settings_instance);
#line 38 "app_settings.vala"
		app_settings_instance = _tmp1_;
#line 275 "app_settings.c"
	}
#line 39 "app_settings.vala"
	_tmp2_ = app_settings_instance;
#line 39 "app_settings.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 39 "app_settings.vala"
	result = _tmp3_;
#line 39 "app_settings.vala"
	return result;
#line 285 "app_settings.c"
}

static void
__lambda4_ (AppSettings* self,
            GSettings* setting,
            const gchar* key)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
#line 50 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 50 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 52 "app_settings.vala"
	_tmp0_ = g_settings_get_string (setting, key);
#line 52 "app_settings.vala"
	_tmp1_ = _tmp0_;
#line 52 "app_settings.vala"
	app_settings_set_system_font (self, _tmp1_);
#line 52 "app_settings.vala"
	_g_free0 (_tmp1_);
#line 53 "app_settings.vala"
	_tmp2_ = self->priv->editor;
#line 53 "app_settings.vala"
	if (g_settings_get_boolean (_tmp2_, "use-default-font")) {
#line 312 "app_settings.c"
		const gchar* _tmp3_;
#line 54 "app_settings.vala"
		_tmp3_ = self->priv->_system_font;
#line 54 "app_settings.vala"
		app_settings_set_font (self, _tmp3_);
#line 318 "app_settings.c"
	}
}

static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
#line 50 "app_settings.vala"
	__lambda4_ ((AppSettings*) self, _sender, key);
#line 329 "app_settings.c"
}

static void
__lambda118_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* font = NULL;
	gchar* _tmp5_;
#line 57 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 57 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 59 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 60 "app_settings.vala"
	if (val) {
#line 349 "app_settings.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 60 "app_settings.vala"
		_tmp1_ = self->priv->_system_font;
#line 60 "app_settings.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 60 "app_settings.vala"
		_g_free0 (_tmp0_);
#line 60 "app_settings.vala"
		_tmp0_ = _tmp2_;
#line 360 "app_settings.c"
	} else {
		GSettings* _tmp3_;
		gchar* _tmp4_;
#line 60 "app_settings.vala"
		_tmp3_ = self->priv->editor;
#line 60 "app_settings.vala"
		_tmp4_ = g_settings_get_string (_tmp3_, "editor-font");
#line 60 "app_settings.vala"
		_g_free0 (_tmp0_);
#line 60 "app_settings.vala"
		_tmp0_ = _tmp4_;
#line 372 "app_settings.c"
	}
#line 60 "app_settings.vala"
	_tmp5_ = g_strdup (_tmp0_);
#line 60 "app_settings.vala"
	font = _tmp5_;
#line 61 "app_settings.vala"
	app_settings_set_font (self, font);
#line 57 "app_settings.vala"
	_g_free0 (font);
#line 57 "app_settings.vala"
	_g_free0 (_tmp0_);
#line 384 "app_settings.c"
}

static void
___lambda118__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 57 "app_settings.vala"
	__lambda118_ ((AppSettings*) self, _sender, key);
#line 394 "app_settings.c"
}

static void
__lambda119_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 64 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 64 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 66 "app_settings.vala"
	_tmp0_ = self->priv->editor;
#line 66 "app_settings.vala"
	if (g_settings_get_boolean (_tmp0_, "use-default-font")) {
#line 67 "app_settings.vala"
		return;
#line 415 "app_settings.c"
	}
#line 68 "app_settings.vala"
	_tmp1_ = g_settings_get_string (setting, key);
#line 68 "app_settings.vala"
	_tmp2_ = _tmp1_;
#line 68 "app_settings.vala"
	app_settings_set_font (self, _tmp2_);
#line 68 "app_settings.vala"
	_g_free0 (_tmp2_);
#line 425 "app_settings.c"
}

static void
___lambda119__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 64 "app_settings.vala"
	__lambda119_ ((AppSettings*) self, _sender, key);
#line 435 "app_settings.c"
}

static void
__lambda120_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	guint val = 0U;
	guint _tmp0_ = 0U;
#line 71 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 71 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 74 "app_settings.vala"
	g_settings_get (setting, key, "u", &_tmp0_);
#line 74 "app_settings.vala"
	val = _tmp0_;
#line 453 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp1_;
		GlatexApp* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _view_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _view_index = 0;
#line 76 "app_settings.vala"
		_tmp1_ = glatex_app_get_instance ();
#line 76 "app_settings.vala"
		_tmp2_ = _tmp1_;
#line 76 "app_settings.vala"
		_tmp3_ = glatex_app_get_views (_tmp2_);
#line 76 "app_settings.vala"
		_tmp4_ = _tmp3_;
#line 76 "app_settings.vala"
		_g_object_unref0 (_tmp2_);
#line 76 "app_settings.vala"
		_view_list = _tmp4_;
#line 76 "app_settings.vala"
		_tmp5_ = _view_list;
#line 76 "app_settings.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 76 "app_settings.vala"
		_tmp7_ = _tmp6_;
#line 76 "app_settings.vala"
		_view_size = _tmp7_;
#line 76 "app_settings.vala"
		_view_index = -1;
#line 76 "app_settings.vala"
		while (TRUE) {
#line 489 "app_settings.c"
			DocumentView* view = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			DocumentView* _tmp10_;
#line 76 "app_settings.vala"
			_view_index = _view_index + 1;
#line 76 "app_settings.vala"
			if (!(_view_index < _view_size)) {
#line 76 "app_settings.vala"
				break;
#line 500 "app_settings.c"
			}
#line 76 "app_settings.vala"
			_tmp8_ = _view_list;
#line 76 "app_settings.vala"
			_tmp9_ = gee_list_get (_tmp8_, _view_index);
#line 76 "app_settings.vala"
			view = (DocumentView*) _tmp9_;
#line 77 "app_settings.vala"
			_tmp10_ = view;
#line 77 "app_settings.vala"
			gtk_source_view_set_tab_width ((GtkSourceView*) _tmp10_, val);
#line 76 "app_settings.vala"
			_g_object_unref0 (view);
#line 514 "app_settings.c"
		}
#line 76 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 518 "app_settings.c"
	}
}

static void
___lambda120__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 71 "app_settings.vala"
	__lambda120_ ((AppSettings*) self, _sender, key);
#line 529 "app_settings.c"
}

static void
__lambda121_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 80 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 80 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 82 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 544 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 84 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 84 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 84 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 84 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 84 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 84 "app_settings.vala"
		_view_list = _tmp3_;
#line 84 "app_settings.vala"
		_tmp4_ = _view_list;
#line 84 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 84 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 84 "app_settings.vala"
		_view_size = _tmp6_;
#line 84 "app_settings.vala"
		_view_index = -1;
#line 84 "app_settings.vala"
		while (TRUE) {
#line 580 "app_settings.c"
			DocumentView* view = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			DocumentView* _tmp9_;
#line 84 "app_settings.vala"
			_view_index = _view_index + 1;
#line 84 "app_settings.vala"
			if (!(_view_index < _view_size)) {
#line 84 "app_settings.vala"
				break;
#line 591 "app_settings.c"
			}
#line 84 "app_settings.vala"
			_tmp7_ = _view_list;
#line 84 "app_settings.vala"
			_tmp8_ = gee_list_get (_tmp7_, _view_index);
#line 84 "app_settings.vala"
			view = (DocumentView*) _tmp8_;
#line 85 "app_settings.vala"
			_tmp9_ = view;
#line 85 "app_settings.vala"
			gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) _tmp9_, val);
#line 84 "app_settings.vala"
			_g_object_unref0 (view);
#line 605 "app_settings.c"
		}
#line 84 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 609 "app_settings.c"
	}
}

static void
___lambda121__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 80 "app_settings.vala"
	__lambda121_ ((AppSettings*) self, _sender, key);
#line 620 "app_settings.c"
}

static void
__lambda122_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 88 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 88 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 90 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 635 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 92 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 92 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 92 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 92 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 92 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 92 "app_settings.vala"
		_view_list = _tmp3_;
#line 92 "app_settings.vala"
		_tmp4_ = _view_list;
#line 92 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 92 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 92 "app_settings.vala"
		_view_size = _tmp6_;
#line 92 "app_settings.vala"
		_view_index = -1;
#line 92 "app_settings.vala"
		while (TRUE) {
#line 671 "app_settings.c"
			DocumentView* view = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			DocumentView* _tmp9_;
#line 92 "app_settings.vala"
			_view_index = _view_index + 1;
#line 92 "app_settings.vala"
			if (!(_view_index < _view_size)) {
#line 92 "app_settings.vala"
				break;
#line 682 "app_settings.c"
			}
#line 92 "app_settings.vala"
			_tmp7_ = _view_list;
#line 92 "app_settings.vala"
			_tmp8_ = gee_list_get (_tmp7_, _view_index);
#line 92 "app_settings.vala"
			view = (DocumentView*) _tmp8_;
#line 93 "app_settings.vala"
			_tmp9_ = view;
#line 93 "app_settings.vala"
			gtk_source_view_set_show_line_numbers ((GtkSourceView*) _tmp9_, val);
#line 92 "app_settings.vala"
			_g_object_unref0 (view);
#line 696 "app_settings.c"
		}
#line 92 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 700 "app_settings.c"
	}
}

static void
___lambda122__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 88 "app_settings.vala"
	__lambda122_ ((AppSettings*) self, _sender, key);
#line 711 "app_settings.c"
}

static void
__lambda123_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 96 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 96 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 98 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 726 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 100 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 100 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 100 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 100 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 100 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 100 "app_settings.vala"
		_view_list = _tmp3_;
#line 100 "app_settings.vala"
		_tmp4_ = _view_list;
#line 100 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 100 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 100 "app_settings.vala"
		_view_size = _tmp6_;
#line 100 "app_settings.vala"
		_view_index = -1;
#line 100 "app_settings.vala"
		while (TRUE) {
#line 762 "app_settings.c"
			DocumentView* view = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			DocumentView* _tmp9_;
#line 100 "app_settings.vala"
			_view_index = _view_index + 1;
#line 100 "app_settings.vala"
			if (!(_view_index < _view_size)) {
#line 100 "app_settings.vala"
				break;
#line 773 "app_settings.c"
			}
#line 100 "app_settings.vala"
			_tmp7_ = _view_list;
#line 100 "app_settings.vala"
			_tmp8_ = gee_list_get (_tmp7_, _view_index);
#line 100 "app_settings.vala"
			view = (DocumentView*) _tmp8_;
#line 101 "app_settings.vala"
			_tmp9_ = view;
#line 101 "app_settings.vala"
			gtk_source_view_set_highlight_current_line ((GtkSourceView*) _tmp9_, val);
#line 100 "app_settings.vala"
			_g_object_unref0 (view);
#line 787 "app_settings.c"
		}
#line 100 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 791 "app_settings.c"
	}
}

static void
___lambda123__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 96 "app_settings.vala"
	__lambda123_ ((AppSettings*) self, _sender, key);
#line 802 "app_settings.c"
}

static void
__lambda124_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 104 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 104 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 106 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 817 "app_settings.c"
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _doc_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _doc_index = 0;
#line 108 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 108 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 108 "app_settings.vala"
		_tmp2_ = glatex_app_get_documents (_tmp1_);
#line 108 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 108 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 108 "app_settings.vala"
		_doc_list = _tmp3_;
#line 108 "app_settings.vala"
		_tmp4_ = _doc_list;
#line 108 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 108 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 108 "app_settings.vala"
		_doc_size = _tmp6_;
#line 108 "app_settings.vala"
		_doc_index = -1;
#line 108 "app_settings.vala"
		while (TRUE) {
#line 853 "app_settings.c"
			Document* doc = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			Document* _tmp9_;
#line 108 "app_settings.vala"
			_doc_index = _doc_index + 1;
#line 108 "app_settings.vala"
			if (!(_doc_index < _doc_size)) {
#line 108 "app_settings.vala"
				break;
#line 864 "app_settings.c"
			}
#line 108 "app_settings.vala"
			_tmp7_ = _doc_list;
#line 108 "app_settings.vala"
			_tmp8_ = gee_list_get (_tmp7_, _doc_index);
#line 108 "app_settings.vala"
			doc = (Document*) _tmp8_;
#line 109 "app_settings.vala"
			_tmp9_ = doc;
#line 109 "app_settings.vala"
			gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) _tmp9_, val);
#line 108 "app_settings.vala"
			_g_object_unref0 (doc);
#line 878 "app_settings.c"
		}
#line 108 "app_settings.vala"
		_g_object_unref0 (_doc_list);
#line 882 "app_settings.c"
	}
}

static void
___lambda124__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 104 "app_settings.vala"
	__lambda124_ ((AppSettings*) self, _sender, key);
#line 893 "app_settings.c"
}

static void
__lambda125_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 112 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 112 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 114 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 908 "app_settings.c"
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _doc_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _doc_index = 0;
#line 116 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 116 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 116 "app_settings.vala"
		_tmp2_ = glatex_app_get_documents (_tmp1_);
#line 116 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 116 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 116 "app_settings.vala"
		_doc_list = _tmp3_;
#line 116 "app_settings.vala"
		_tmp4_ = _doc_list;
#line 116 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 116 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 116 "app_settings.vala"
		_doc_size = _tmp6_;
#line 116 "app_settings.vala"
		_doc_index = -1;
#line 116 "app_settings.vala"
		while (TRUE) {
#line 944 "app_settings.c"
			Document* doc = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			Document* _tmp9_;
			DocumentTab* _tmp10_;
#line 116 "app_settings.vala"
			_doc_index = _doc_index + 1;
#line 116 "app_settings.vala"
			if (!(_doc_index < _doc_size)) {
#line 116 "app_settings.vala"
				break;
#line 956 "app_settings.c"
			}
#line 116 "app_settings.vala"
			_tmp7_ = _doc_list;
#line 116 "app_settings.vala"
			_tmp8_ = gee_list_get (_tmp7_, _doc_index);
#line 116 "app_settings.vala"
			doc = (Document*) _tmp8_;
#line 117 "app_settings.vala"
			_tmp9_ = doc;
#line 117 "app_settings.vala"
			_tmp10_ = _tmp9_->tab;
#line 117 "app_settings.vala"
			document_tab_set_auto_save (_tmp10_, val);
#line 116 "app_settings.vala"
			_g_object_unref0 (doc);
#line 972 "app_settings.c"
		}
#line 116 "app_settings.vala"
		_g_object_unref0 (_doc_list);
#line 976 "app_settings.c"
	}
}

static void
___lambda125__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 112 "app_settings.vala"
	__lambda125_ ((AppSettings*) self, _sender, key);
#line 987 "app_settings.c"
}

static void
__lambda126_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	guint val = 0U;
	guint _tmp0_ = 0U;
#line 120 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 120 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 123 "app_settings.vala"
	g_settings_get (setting, key, "u", &_tmp0_);
#line 123 "app_settings.vala"
	val = _tmp0_;
#line 1005 "app_settings.c"
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp1_;
		GlatexApp* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _doc_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _doc_index = 0;
#line 125 "app_settings.vala"
		_tmp1_ = glatex_app_get_instance ();
#line 125 "app_settings.vala"
		_tmp2_ = _tmp1_;
#line 125 "app_settings.vala"
		_tmp3_ = glatex_app_get_documents (_tmp2_);
#line 125 "app_settings.vala"
		_tmp4_ = _tmp3_;
#line 125 "app_settings.vala"
		_g_object_unref0 (_tmp2_);
#line 125 "app_settings.vala"
		_doc_list = _tmp4_;
#line 125 "app_settings.vala"
		_tmp5_ = _doc_list;
#line 125 "app_settings.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 125 "app_settings.vala"
		_tmp7_ = _tmp6_;
#line 125 "app_settings.vala"
		_doc_size = _tmp7_;
#line 125 "app_settings.vala"
		_doc_index = -1;
#line 125 "app_settings.vala"
		while (TRUE) {
#line 1041 "app_settings.c"
			Document* doc = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			Document* _tmp10_;
			DocumentTab* _tmp11_;
#line 125 "app_settings.vala"
			_doc_index = _doc_index + 1;
#line 125 "app_settings.vala"
			if (!(_doc_index < _doc_size)) {
#line 125 "app_settings.vala"
				break;
#line 1053 "app_settings.c"
			}
#line 125 "app_settings.vala"
			_tmp8_ = _doc_list;
#line 125 "app_settings.vala"
			_tmp9_ = gee_list_get (_tmp8_, _doc_index);
#line 125 "app_settings.vala"
			doc = (Document*) _tmp9_;
#line 126 "app_settings.vala"
			_tmp10_ = doc;
#line 126 "app_settings.vala"
			_tmp11_ = _tmp10_->tab;
#line 126 "app_settings.vala"
			document_tab_set_auto_save_interval (_tmp11_, val);
#line 125 "app_settings.vala"
			_g_object_unref0 (doc);
#line 1069 "app_settings.c"
		}
#line 125 "app_settings.vala"
		_g_object_unref0 (_doc_list);
#line 1073 "app_settings.c"
	}
}

static void
___lambda126__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 120 "app_settings.vala"
	__lambda126_ ((AppSettings*) self, _sender, key);
#line 1084 "app_settings.c"
}

static void
app_settings_initialize (AppSettings* self)
{
	GSettings* prefs = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* desktop_interface = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
#line 42 "app_settings.vala"
	g_return_if_fail (self != NULL);
#line 44 "app_settings.vala"
	_tmp0_ = g_settings_get_child ((GSettings*) self, "preferences");
#line 44 "app_settings.vala"
	prefs = _tmp0_;
#line 45 "app_settings.vala"
	_tmp1_ = g_settings_get_child (prefs, "editor");
#line 45 "app_settings.vala"
	_g_object_unref0 (self->priv->editor);
#line 45 "app_settings.vala"
	self->priv->editor = _tmp1_;
#line 47 "app_settings.vala"
	_tmp2_ = g_settings_new ("org.gnome.desktop.interface");
#line 47 "app_settings.vala"
	desktop_interface = _tmp2_;
#line 48 "app_settings.vala"
	_tmp3_ = g_settings_get_string (desktop_interface, "monospace-font-name");
#line 48 "app_settings.vala"
	_tmp4_ = _tmp3_;
#line 48 "app_settings.vala"
	app_settings_set_system_font (self, _tmp4_);
#line 48 "app_settings.vala"
	_g_free0 (_tmp4_);
#line 50 "app_settings.vala"
	g_signal_connect_object (desktop_interface, "changed::monospace-font-name", (GCallback) ___lambda4__g_settings_changed, self, 0);
#line 57 "app_settings.vala"
	_tmp5_ = self->priv->editor;
#line 57 "app_settings.vala"
	g_signal_connect_object (_tmp5_, "changed::use-default-font", (GCallback) ___lambda118__g_settings_changed, self, 0);
#line 64 "app_settings.vala"
	_tmp6_ = self->priv->editor;
#line 64 "app_settings.vala"
	g_signal_connect_object (_tmp6_, "changed::editor-font", (GCallback) ___lambda119__g_settings_changed, self, 0);
#line 71 "app_settings.vala"
	_tmp7_ = self->priv->editor;
#line 71 "app_settings.vala"
	g_signal_connect_object (_tmp7_, "changed::tabs-size", (GCallback) ___lambda120__g_settings_changed, self, 0);
#line 80 "app_settings.vala"
	_tmp8_ = self->priv->editor;
#line 80 "app_settings.vala"
	g_signal_connect_object (_tmp8_, "changed::insert-spaces", (GCallback) ___lambda121__g_settings_changed, self, 0);
#line 88 "app_settings.vala"
	_tmp9_ = self->priv->editor;
#line 88 "app_settings.vala"
	g_signal_connect_object (_tmp9_, "changed::display-line-numbers", (GCallback) ___lambda122__g_settings_changed, self, 0);
#line 96 "app_settings.vala"
	_tmp10_ = self->priv->editor;
#line 96 "app_settings.vala"
	g_signal_connect_object (_tmp10_, "changed::highlight-current-line", (GCallback) ___lambda123__g_settings_changed, self, 0);
#line 104 "app_settings.vala"
	_tmp11_ = self->priv->editor;
#line 104 "app_settings.vala"
	g_signal_connect_object (_tmp11_, "changed::bracket-matching", (GCallback) ___lambda124__g_settings_changed, self, 0);
#line 112 "app_settings.vala"
	_tmp12_ = self->priv->editor;
#line 112 "app_settings.vala"
	g_signal_connect_object (_tmp12_, "changed::auto-save", (GCallback) ___lambda125__g_settings_changed, self, 0);
#line 120 "app_settings.vala"
	_tmp13_ = self->priv->editor;
#line 120 "app_settings.vala"
	g_signal_connect_object (_tmp13_, "changed::auto-save-interval", (GCallback) ___lambda126__g_settings_changed, self, 0);
#line 42 "app_settings.vala"
	_g_object_unref0 (desktop_interface);
#line 42 "app_settings.vala"
	_g_object_unref0 (prefs);
#line 1172 "app_settings.c"
}

static void
app_settings_set_font (AppSettings* self,
                       const gchar* font)
{
#line 130 "app_settings.vala"
	g_return_if_fail (self != NULL);
#line 130 "app_settings.vala"
	g_return_if_fail (font != NULL);
#line 1183 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 132 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 132 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 132 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 132 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 132 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 132 "app_settings.vala"
		_view_list = _tmp3_;
#line 132 "app_settings.vala"
		_tmp4_ = _view_list;
#line 132 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 132 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 132 "app_settings.vala"
		_view_size = _tmp6_;
#line 132 "app_settings.vala"
		_view_index = -1;
#line 132 "app_settings.vala"
		while (TRUE) {
#line 1219 "app_settings.c"
			DocumentView* view = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			DocumentView* _tmp9_;
#line 132 "app_settings.vala"
			_view_index = _view_index + 1;
#line 132 "app_settings.vala"
			if (!(_view_index < _view_size)) {
#line 132 "app_settings.vala"
				break;
#line 1230 "app_settings.c"
			}
#line 132 "app_settings.vala"
			_tmp7_ = _view_list;
#line 132 "app_settings.vala"
			_tmp8_ = gee_list_get (_tmp7_, _view_index);
#line 132 "app_settings.vala"
			view = (DocumentView*) _tmp8_;
#line 133 "app_settings.vala"
			_tmp9_ = view;
#line 133 "app_settings.vala"
			document_view_set_font_from_string (_tmp9_, font);
#line 132 "app_settings.vala"
			_g_object_unref0 (view);
#line 1244 "app_settings.c"
		}
#line 132 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 1248 "app_settings.c"
	}
}

const gchar*
app_settings_get_system_font (AppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 26 "app_settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "app_settings.vala"
	_tmp0_ = self->priv->_system_font;
#line 26 "app_settings.vala"
	result = _tmp0_;
#line 26 "app_settings.vala"
	return result;
#line 1265 "app_settings.c"
}

static void
app_settings_set_system_font (AppSettings* self,
                              const gchar* value)
{
#line 26 "app_settings.vala"
	g_return_if_fail (self != NULL);
#line 26 "app_settings.vala"
	if (g_strcmp0 (value, app_settings_get_system_font (self)) != 0) {
#line 1276 "app_settings.c"
		gchar* _tmp0_;
#line 26 "app_settings.vala"
		_tmp0_ = g_strdup (value);
#line 26 "app_settings.vala"
		_g_free0 (self->priv->_system_font);
#line 26 "app_settings.vala"
		self->priv->_system_font = _tmp0_;
#line 26 "app_settings.vala"
		g_object_notify_by_pspec ((GObject *) self, app_settings_properties[APP_SETTINGS_SYSTEM_FONT_PROPERTY]);
#line 1286 "app_settings.c"
	}
}

static void
app_settings_class_init (AppSettingsClass * klass,
                         gpointer klass_data)
{
#line 20 "app_settings.vala"
	app_settings_parent_class = g_type_class_peek_parent (klass);
#line 20 "app_settings.vala"
	g_type_class_adjust_private_offset (klass, &AppSettings_private_offset);
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_app_settings_get_property;
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_app_settings_set_property;
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (klass)->finalize = app_settings_finalize;
#line 20 "app_settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_SYSTEM_FONT_PROPERTY, app_settings_properties[APP_SETTINGS_SYSTEM_FONT_PROPERTY] = g_param_spec_string ("system-font", "system-font", "system-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 1306 "app_settings.c"
}

static void
app_settings_instance_init (AppSettings * self,
                            gpointer klass)
{
#line 20 "app_settings.vala"
	self->priv = app_settings_get_instance_private (self);
#line 1315 "app_settings.c"
}

static void
app_settings_finalize (GObject * obj)
{
	AppSettings * self;
#line 20 "app_settings.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_SETTINGS, AppSettings);
#line 24 "app_settings.vala"
	_g_object_unref0 (self->priv->editor);
#line 26 "app_settings.vala"
	_g_free0 (self->priv->_system_font);
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (app_settings_parent_class)->finalize (obj);
#line 1330 "app_settings.c"
}

GType
app_settings_get_type (void)
{
	static volatile gsize app_settings_type_id__volatile = 0;
	if (g_once_init_enter (&app_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AppSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppSettings), 0, (GInstanceInitFunc) app_settings_instance_init, NULL };
		GType app_settings_type_id;
		app_settings_type_id = g_type_register_static (g_settings_get_type (), "AppSettings", &g_define_type_info, 0);
		AppSettings_private_offset = g_type_add_instance_private (app_settings_type_id, sizeof (AppSettingsPrivate));
		g_once_init_leave (&app_settings_type_id__volatile, app_settings_type_id);
	}
	return app_settings_type_id__volatile;
}

static void
_vala_app_settings_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	AppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_SETTINGS, AppSettings);
#line 20 "app_settings.vala"
	switch (property_id) {
#line 20 "app_settings.vala"
		case APP_SETTINGS_SYSTEM_FONT_PROPERTY:
#line 20 "app_settings.vala"
		g_value_set_string (value, app_settings_get_system_font (self));
#line 20 "app_settings.vala"
		break;
#line 1363 "app_settings.c"
		default:
#line 20 "app_settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "app_settings.vala"
		break;
#line 1369 "app_settings.c"
	}
}

static void
_vala_app_settings_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	AppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_SETTINGS, AppSettings);
#line 20 "app_settings.vala"
	switch (property_id) {
#line 20 "app_settings.vala"
		case APP_SETTINGS_SYSTEM_FONT_PROPERTY:
#line 20 "app_settings.vala"
		app_settings_set_system_font (self, g_value_get_string (value));
#line 20 "app_settings.vala"
		break;
#line 1389 "app_settings.c"
		default:
#line 20 "app_settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "app_settings.vala"
		break;
#line 1395 "app_settings.c"
	}
}

