/* utils.c generated by valac 0.46.6, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <tepl/tepl.h>
#include <latexila.h>
#include <gtk/gtk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

gchar* utils_str_middle_truncate (const gchar* str,
                                  guint max_length);
gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
gchar* utils_uri_get_dirname (const gchar* uri);
gchar* utils_get_dirname_for_display (GFile* location);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
gchar* utils_load_file (GFile* file);
gchar* utils_get_relative_path (GFile* origin,
                                GFile* target,
                                GFile* common_dir);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model,
                                     GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
void utils_flush_queue (void);

/*************************************************************************/
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1428 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1429 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1429 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1429 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1430 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1431 "glib-2.0.vapi"
		start = string_length + start;
#line 89 "utils.c"
	}
#line 1433 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1434 "glib-2.0.vapi"
		end = string_length + end;
#line 95 "utils.c"
	}
#line 1436 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 101 "utils.c"
	} else {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 105 "utils.c"
	}
#line 1436 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1437 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 113 "utils.c"
	} else {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 117 "utils.c"
	}
#line 1437 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1438 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1439 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1439 "glib-2.0.vapi"
	result = _tmp4_;
#line 1439 "glib-2.0.vapi"
	return result;
#line 129 "utils.c"
}

gchar*
utils_str_middle_truncate (const gchar* str,
                           guint max_length)
{
	gint _tmp0_;
	gint _tmp1_;
	guint half_length = 0U;
	gint l = 0;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result = NULL;
#line 27 "utils.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 29 "utils.vala"
	_tmp0_ = strlen (str);
#line 29 "utils.vala"
	_tmp1_ = _tmp0_;
#line 29 "utils.vala"
	if (((guint) _tmp1_) <= max_length) {
#line 159 "utils.c"
		gchar* _tmp2_;
#line 30 "utils.vala"
		_tmp2_ = g_strdup (str);
#line 30 "utils.vala"
		result = _tmp2_;
#line 30 "utils.vala"
		return result;
#line 167 "utils.c"
	}
#line 32 "utils.vala"
	half_length = (max_length - 4) / 2;
#line 33 "utils.vala"
	_tmp3_ = strlen (str);
#line 33 "utils.vala"
	_tmp4_ = _tmp3_;
#line 33 "utils.vala"
	l = _tmp4_;
#line 34 "utils.vala"
	_tmp5_ = string_slice (str, (glong) 0, (glong) half_length);
#line 34 "utils.vala"
	_tmp6_ = _tmp5_;
#line 34 "utils.vala"
	_tmp7_ = g_strconcat (_tmp6_, "...", NULL);
#line 34 "utils.vala"
	_tmp8_ = _tmp7_;
#line 34 "utils.vala"
	_tmp9_ = string_slice (str, (glong) (l - half_length), (glong) l);
#line 34 "utils.vala"
	_tmp10_ = _tmp9_;
#line 34 "utils.vala"
	_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
#line 34 "utils.vala"
	_tmp12_ = _tmp11_;
#line 34 "utils.vala"
	_g_free0 (_tmp10_);
#line 34 "utils.vala"
	_g_free0 (_tmp8_);
#line 34 "utils.vala"
	_g_free0 (_tmp6_);
#line 34 "utils.vala"
	result = _tmp12_;
#line 34 "utils.vala"
	return result;
#line 203 "utils.c"
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
#line 1238 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1239 "glib-2.0.vapi"
	if (0 < (*index)) {
#line 217 "utils.c"
		gchar* _tmp0_;
#line 1240 "glib-2.0.vapi"
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
#line 1240 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1241 "glib-2.0.vapi"
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1242 "glib-2.0.vapi"
		result = TRUE;
#line 1242 "glib-2.0.vapi"
		if (c) {
#line 1242 "glib-2.0.vapi"
			*c = _vala_c;
#line 231 "utils.c"
		}
#line 1242 "glib-2.0.vapi"
		return result;
#line 235 "utils.c"
	} else {
#line 1244 "glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1245 "glib-2.0.vapi"
		result = FALSE;
#line 1245 "glib-2.0.vapi"
		if (c) {
#line 1245 "glib-2.0.vapi"
			*c = _vala_c;
#line 245 "utils.c"
		}
#line 1245 "glib-2.0.vapi"
		return result;
#line 249 "utils.c"
	}
#line 1238 "glib-2.0.vapi"
	if (c) {
#line 1238 "glib-2.0.vapi"
		*c = _vala_c;
#line 255 "utils.c"
	}
}

gboolean
utils_char_is_escaped (const gchar* text,
                       glong char_index)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean escaped = FALSE;
	gint index = 0;
	gunichar cur_char = 0U;
	gboolean result = FALSE;
#line 37 "utils.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 39 "utils.vala"
	_tmp0_ = strlen (text);
#line 39 "utils.vala"
	_tmp1_ = _tmp0_;
#line 39 "utils.vala"
	g_return_val_if_fail (char_index < ((glong) _tmp1_), FALSE);
#line 41 "utils.vala"
	escaped = FALSE;
#line 42 "utils.vala"
	index = (gint) char_index;
#line 44 "utils.vala"
	while (TRUE) {
#line 283 "utils.c"
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
#line 44 "utils.vala"
		_tmp3_ = string_get_prev_char (text, &index, &_tmp2_);
#line 44 "utils.vala"
		cur_char = _tmp2_;
#line 44 "utils.vala"
		if (!_tmp3_) {
#line 44 "utils.vala"
			break;
#line 294 "utils.c"
		}
#line 46 "utils.vala"
		if (cur_char != ((gunichar) '\\')) {
#line 47 "utils.vala"
			break;
#line 300 "utils.c"
		}
#line 49 "utils.vala"
		escaped = !escaped;
#line 304 "utils.c"
	}
#line 52 "utils.vala"
	result = escaped;
#line 52 "utils.vala"
	return result;
#line 310 "utils.c"
}

const gchar*
utils_get_string_from_resource (const gchar* resource_path)
{
	GError* _inner_error0_ = NULL;
	const gchar* result = NULL;
#line 55 "utils.vala"
	g_return_val_if_fail (resource_path != NULL, NULL);
#line 320 "utils.c"
	{
		GBytes* bytes = NULL;
		GBytes* _tmp0_;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
#line 59 "utils.vala"
		_tmp0_ = g_resources_lookup_data (resource_path, 0, &_inner_error0_);
#line 59 "utils.vala"
		bytes = _tmp0_;
#line 59 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 332 "utils.c"
			goto __catch45_g_error;
		}
#line 60 "utils.vala"
		_tmp2_ = g_bytes_get_data (bytes, &_tmp1_);
#line 60 "utils.vala"
		result = (const gchar*) _tmp2_;
#line 60 "utils.vala"
		_g_bytes_unref0 (bytes);
#line 60 "utils.vala"
		return result;
#line 343 "utils.c"
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 57 "utils.vala"
		e = _inner_error0_;
#line 57 "utils.vala"
		_inner_error0_ = NULL;
#line 64 "utils.vala"
		_tmp3_ = e;
#line 64 "utils.vala"
		_tmp4_ = _tmp3_->message;
#line 64 "utils.vala"
		g_warning ("utils.vala:64: Failed to load data from resource '%s': %s", resource_path, _tmp4_);
#line 66 "utils.vala"
		result = NULL;
#line 66 "utils.vala"
		_g_error_free0 (e);
#line 66 "utils.vala"
		return result;
#line 367 "utils.c"
	}
	__finally45:
#line 57 "utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 57 "utils.vala"
	g_clear_error (&_inner_error0_);
#line 57 "utils.vala"
	return NULL;
#line 376 "utils.c"
}

/*************************************************************************/
gchar*
utils_uri_get_dirname (const gchar* uri)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 74 "utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 76 "utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 77 "utils.vala"
	_tmp0_ = g_path_get_dirname (uri);
#line 77 "utils.vala"
	dir = _tmp0_;
#line 78 "utils.vala"
	_tmp1_ = dir;
#line 78 "utils.vala"
	if (g_strcmp0 (_tmp1_, ".") == 0) {
#line 79 "utils.vala"
		result = NULL;
#line 79 "utils.vala"
		_g_free0 (dir);
#line 79 "utils.vala"
		return result;
#line 407 "utils.c"
	}
#line 80 "utils.vala"
	_tmp2_ = dir;
#line 80 "utils.vala"
	_tmp3_ = tepl_utils_replace_home_dir_with_tilde (_tmp2_);
#line 80 "utils.vala"
	result = _tmp3_;
#line 80 "utils.vala"
	_g_free0 (dir);
#line 80 "utils.vala"
	return result;
#line 419 "utils.c"
}

gchar*
utils_get_dirname_for_display (GFile* location)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 88 "utils.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 429 "utils.c"
	{
		GMount* mount = NULL;
		GMount* _tmp0_;
		gchar* mount_name = NULL;
		GMount* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* dirname = NULL;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 92 "utils.vala"
		_tmp0_ = g_file_find_enclosing_mount (location, NULL, &_inner_error0_);
#line 92 "utils.vala"
		mount = _tmp0_;
#line 92 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 454 "utils.c"
			goto __catch46_g_error;
		}
#line 93 "utils.vala"
		_tmp1_ = mount;
#line 93 "utils.vala"
		_tmp2_ = g_mount_get_name (_tmp1_);
#line 93 "utils.vala"
		mount_name = _tmp2_;
#line 95 "utils.vala"
		_tmp4_ = g_file_get_path (location);
#line 95 "utils.vala"
		_tmp3_ = _tmp4_;
#line 95 "utils.vala"
		if (_tmp3_ == NULL) {
#line 469 "utils.c"
			gchar* _tmp5_;
#line 95 "utils.vala"
			_tmp5_ = g_file_get_uri (location);
#line 95 "utils.vala"
			_g_free0 (_tmp3_);
#line 95 "utils.vala"
			_tmp3_ = _tmp5_;
#line 477 "utils.c"
		}
#line 94 "utils.vala"
		_tmp6_ = utils_uri_get_dirname (_tmp3_);
#line 94 "utils.vala"
		dirname = _tmp6_;
#line 97 "utils.vala"
		_tmp8_ = dirname;
#line 97 "utils.vala"
		if (_tmp8_ == NULL) {
#line 97 "utils.vala"
			_tmp7_ = TRUE;
#line 489 "utils.c"
		} else {
			const gchar* _tmp9_;
#line 97 "utils.vala"
			_tmp9_ = dirname;
#line 97 "utils.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, ".") == 0;
#line 496 "utils.c"
		}
#line 97 "utils.vala"
		if (_tmp7_) {
#line 98 "utils.vala"
			result = mount_name;
#line 98 "utils.vala"
			_g_free0 (dirname);
#line 98 "utils.vala"
			_g_free0 (_tmp3_);
#line 98 "utils.vala"
			_g_object_unref0 (mount);
#line 98 "utils.vala"
			return result;
#line 510 "utils.c"
		}
#line 99 "utils.vala"
		_tmp10_ = mount_name;
#line 99 "utils.vala"
		_tmp11_ = g_strconcat (_tmp10_, " ", NULL);
#line 99 "utils.vala"
		_tmp12_ = _tmp11_;
#line 99 "utils.vala"
		_tmp13_ = dirname;
#line 99 "utils.vala"
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 99 "utils.vala"
		_tmp15_ = _tmp14_;
#line 99 "utils.vala"
		_g_free0 (_tmp12_);
#line 99 "utils.vala"
		result = _tmp15_;
#line 99 "utils.vala"
		_g_free0 (dirname);
#line 99 "utils.vala"
		_g_free0 (_tmp3_);
#line 99 "utils.vala"
		_g_free0 (mount_name);
#line 99 "utils.vala"
		_g_object_unref0 (mount);
#line 99 "utils.vala"
		return result;
#line 538 "utils.c"
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* e = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp19_;
#line 90 "utils.vala"
		e = _inner_error0_;
#line 90 "utils.vala"
		_inner_error0_ = NULL;
#line 105 "utils.vala"
		_tmp17_ = g_file_get_path (location);
#line 105 "utils.vala"
		_tmp16_ = _tmp17_;
#line 105 "utils.vala"
		if (_tmp16_ == NULL) {
#line 557 "utils.c"
			gchar* _tmp18_;
#line 105 "utils.vala"
			_tmp18_ = g_file_get_uri (location);
#line 105 "utils.vala"
			_g_free0 (_tmp16_);
#line 105 "utils.vala"
			_tmp16_ = _tmp18_;
#line 565 "utils.c"
		}
#line 105 "utils.vala"
		_tmp19_ = utils_uri_get_dirname (_tmp16_);
#line 105 "utils.vala"
		result = _tmp19_;
#line 105 "utils.vala"
		_g_free0 (_tmp16_);
#line 105 "utils.vala"
		_g_error_free0 (e);
#line 105 "utils.vala"
		return result;
#line 577 "utils.c"
	}
	__finally46:
#line 90 "utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 90 "utils.vala"
	g_clear_error (&_inner_error0_);
#line 90 "utils.vala"
	return NULL;
#line 586 "utils.c"
}

void
utils_delete_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
#line 109 "utils.vala"
	g_return_if_fail (file != NULL);
#line 111 "utils.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 112 "utils.vala"
		return;
#line 599 "utils.c"
	}
	{
#line 116 "utils.vala"
		g_file_delete (file, NULL, &_inner_error0_);
#line 116 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 606 "utils.c"
			goto __catch47_g_error;
		}
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 114 "utils.vala"
		e = _inner_error0_;
#line 114 "utils.vala"
		_inner_error0_ = NULL;
#line 120 "utils.vala"
		_tmp0_ = g_file_get_parse_name (file);
#line 120 "utils.vala"
		_tmp1_ = _tmp0_;
#line 120 "utils.vala"
		_tmp2_ = e;
#line 120 "utils.vala"
		_tmp3_ = _tmp2_->message;
#line 120 "utils.vala"
		g_warning ("utils.vala:120: Delete file '%s' failed: %s", _tmp1_, _tmp3_);
#line 120 "utils.vala"
		_g_free0 (_tmp1_);
#line 114 "utils.vala"
		_g_error_free0 (e);
#line 636 "utils.c"
	}
	__finally47:
#line 114 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 114 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 114 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 114 "utils.vala"
		return;
#line 647 "utils.c"
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1503 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1504 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1504 "glib-2.0.vapi"
	res_length1 = -1;
#line 1504 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1505 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1505 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1505 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1506 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1506 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1506 "glib-2.0.vapi"
	if (result_length1) {
#line 1506 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 685 "utils.c"
	}
#line 1506 "glib-2.0.vapi"
	result = _tmp2_;
#line 1506 "glib-2.0.vapi"
	return result;
#line 691 "utils.c"
}

gboolean
utils_save_file (GFile* file,
                 const gchar* contents,
                 gboolean make_backup)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 124 "utils.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 124 "utils.vala"
	g_return_val_if_fail (contents != NULL, FALSE);
#line 705 "utils.c"
	{
		guint8* _tmp0_;
		gint _tmp0__length1;
		guint8* _tmp1_;
		gint _tmp1__length1;
#line 128 "utils.vala"
		latexila_utils_create_parent_directories (file, &_inner_error0_);
#line 128 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 715 "utils.c"
			goto __catch48_g_error;
		}
#line 130 "utils.vala"
		_tmp0_ = string_get_data (contents, &_tmp0__length1);
#line 130 "utils.vala"
		_tmp1_ = _tmp0_;
#line 130 "utils.vala"
		_tmp1__length1 = _tmp0__length1;
#line 130 "utils.vala"
		g_file_replace_contents (file, _tmp1_, (gsize) _tmp1__length1, NULL, make_backup, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
#line 130 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 728 "utils.c"
			goto __catch48_g_error;
		}
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 126 "utils.vala"
		e = _inner_error0_;
#line 126 "utils.vala"
		_inner_error0_ = NULL;
#line 135 "utils.vala"
		_tmp2_ = g_file_get_parse_name (file);
#line 135 "utils.vala"
		_tmp3_ = _tmp2_;
#line 135 "utils.vala"
		_tmp4_ = e;
#line 135 "utils.vala"
		_tmp5_ = _tmp4_->message;
#line 135 "utils.vala"
		g_warning ("utils.vala:135: Failed to save the file '%s': %s", _tmp3_, _tmp5_);
#line 135 "utils.vala"
		_g_free0 (_tmp3_);
#line 137 "utils.vala"
		result = FALSE;
#line 137 "utils.vala"
		_g_error_free0 (e);
#line 137 "utils.vala"
		return result;
#line 762 "utils.c"
	}
	__finally48:
#line 126 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 767 "utils.c"
		gboolean _tmp6_ = FALSE;
#line 126 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 126 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 126 "utils.vala"
		return _tmp6_;
#line 775 "utils.c"
	}
#line 140 "utils.vala"
	result = TRUE;
#line 140 "utils.vala"
	return result;
#line 781 "utils.c"
}

gchar*
utils_load_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 144 "utils.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 791 "utils.c"
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
#line 149 "utils.vala"
		g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error0_);
#line 149 "utils.vala"
		chars = (g_free (chars), NULL);
#line 149 "utils.vala"
		chars = _tmp0_;
#line 149 "utils.vala"
		chars_length1 = _tmp1_;
#line 149 "utils.vala"
		_chars_size_ = chars_length1;
#line 149 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 149 "utils.vala"
			chars = (g_free (chars), NULL);
#line 814 "utils.c"
			goto __catch49_g_error;
		}
#line 150 "utils.vala"
		_tmp2_ = chars;
#line 150 "utils.vala"
		_tmp2__length1 = chars_length1;
#line 150 "utils.vala"
		chars = NULL;
#line 150 "utils.vala"
		chars_length1 = 0;
#line 150 "utils.vala"
		result = (gchar*) _tmp2_;
#line 150 "utils.vala"
		chars = (g_free (chars), NULL);
#line 150 "utils.vala"
		return result;
#line 831 "utils.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 146 "utils.vala"
		e = _inner_error0_;
#line 146 "utils.vala"
		_inner_error0_ = NULL;
#line 154 "utils.vala"
		_tmp3_ = g_file_get_parse_name (file);
#line 154 "utils.vala"
		_tmp4_ = _tmp3_;
#line 154 "utils.vala"
		_tmp5_ = e;
#line 154 "utils.vala"
		_tmp6_ = _tmp5_->message;
#line 154 "utils.vala"
		g_warning ("utils.vala:154: Failed to load the file '%s': %s", _tmp4_, _tmp6_);
#line 154 "utils.vala"
		_g_free0 (_tmp4_);
#line 156 "utils.vala"
		result = NULL;
#line 156 "utils.vala"
		_g_error_free0 (e);
#line 156 "utils.vala"
		return result;
#line 863 "utils.c"
	}
	__finally49:
#line 146 "utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 146 "utils.vala"
	g_clear_error (&_inner_error0_);
#line 146 "utils.vala"
	return NULL;
#line 872 "utils.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 165 "utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 880 "utils.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 225 "utils.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 888 "utils.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 225 "utils.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 896 "utils.c"
}

gchar*
utils_get_relative_path (GFile* origin,
                         GFile* target,
                         GFile* common_dir)
{
	GFile* origin_dir = NULL;
	GFile* target_parent = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GList* target_dirs = NULL;
	GList* origin_dirs = NULL;
	guint dir_index = 0U;
	guint nb_common_dirs = 0U;
	gchar* relative_path = NULL;
	gchar* _tmp34_;
	guint nb_remaining_origin_dirs = 0U;
	GList* _tmp35_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* result = NULL;
#line 161 "utils.vala"
	g_return_val_if_fail (origin != NULL, NULL);
#line 161 "utils.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 161 "utils.vala"
	g_return_val_if_fail (common_dir != NULL, NULL);
#line 164 "utils.vala"
	if (g_file_equal (origin, common_dir)) {
#line 932 "utils.c"
		GFile* _tmp0_;
#line 165 "utils.vala"
		_tmp0_ = _g_object_ref0 (origin);
#line 165 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 165 "utils.vala"
		origin_dir = _tmp0_;
#line 940 "utils.c"
	} else {
		GFile* _tmp1_;
#line 167 "utils.vala"
		_tmp1_ = g_file_get_parent (origin);
#line 167 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 167 "utils.vala"
		origin_dir = _tmp1_;
#line 949 "utils.c"
	}
#line 169 "utils.vala"
	_tmp2_ = g_file_get_parent (target);
#line 169 "utils.vala"
	target_parent = _tmp2_;
#line 171 "utils.vala"
	_tmp3_ = origin_dir;
#line 171 "utils.vala"
	g_return_val_if_fail (_tmp3_ != NULL, NULL);
#line 172 "utils.vala"
	_tmp4_ = target_parent;
#line 172 "utils.vala"
	g_return_val_if_fail (_tmp4_ != NULL, NULL);
#line 175 "utils.vala"
	_tmp5_ = target_parent;
#line 175 "utils.vala"
	_tmp6_ = origin_dir;
#line 175 "utils.vala"
	if (g_file_equal (_tmp5_, _tmp6_)) {
#line 969 "utils.c"
		gchar* _tmp7_;
#line 176 "utils.vala"
		_tmp7_ = g_file_get_basename (target);
#line 176 "utils.vala"
		result = _tmp7_;
#line 176 "utils.vala"
		_g_object_unref0 (target_parent);
#line 176 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 176 "utils.vala"
		return result;
#line 981 "utils.c"
	}
#line 179 "utils.vala"
	target_dirs = NULL;
#line 180 "utils.vala"
	origin_dirs = NULL;
#line 182 "utils.vala"
	while (TRUE) {
#line 989 "utils.c"
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
#line 182 "utils.vala"
		_tmp9_ = target_parent;
#line 182 "utils.vala"
		if (_tmp9_ != NULL) {
#line 1000 "utils.c"
			GFile* _tmp10_;
#line 182 "utils.vala"
			_tmp10_ = target_parent;
#line 182 "utils.vala"
			_tmp8_ = !g_file_equal (_tmp10_, common_dir);
#line 1006 "utils.c"
		} else {
#line 182 "utils.vala"
			_tmp8_ = FALSE;
#line 1010 "utils.c"
		}
#line 182 "utils.vala"
		if (!_tmp8_) {
#line 182 "utils.vala"
			break;
#line 1016 "utils.c"
		}
#line 184 "utils.vala"
		_tmp11_ = target_parent;
#line 184 "utils.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 184 "utils.vala"
		target_dirs = g_list_prepend (target_dirs, _tmp12_);
#line 185 "utils.vala"
		_tmp13_ = target_parent;
#line 185 "utils.vala"
		_tmp14_ = g_file_get_parent (_tmp13_);
#line 185 "utils.vala"
		_g_object_unref0 (target_parent);
#line 185 "utils.vala"
		target_parent = _tmp14_;
#line 1032 "utils.c"
	}
#line 188 "utils.vala"
	while (TRUE) {
#line 1036 "utils.c"
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
#line 188 "utils.vala"
		_tmp16_ = origin_dir;
#line 188 "utils.vala"
		if (_tmp16_ != NULL) {
#line 1047 "utils.c"
			GFile* _tmp17_;
#line 188 "utils.vala"
			_tmp17_ = origin_dir;
#line 188 "utils.vala"
			_tmp15_ = !g_file_equal (_tmp17_, common_dir);
#line 1053 "utils.c"
		} else {
#line 188 "utils.vala"
			_tmp15_ = FALSE;
#line 1057 "utils.c"
		}
#line 188 "utils.vala"
		if (!_tmp15_) {
#line 188 "utils.vala"
			break;
#line 1063 "utils.c"
		}
#line 190 "utils.vala"
		_tmp18_ = origin_dir;
#line 190 "utils.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 190 "utils.vala"
		origin_dirs = g_list_prepend (origin_dirs, _tmp19_);
#line 191 "utils.vala"
		_tmp20_ = origin_dir;
#line 191 "utils.vala"
		_tmp21_ = g_file_get_parent (_tmp20_);
#line 191 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 191 "utils.vala"
		origin_dir = _tmp21_;
#line 1079 "utils.c"
	}
#line 195 "utils.vala"
	dir_index = (guint) 0;
#line 196 "utils.vala"
	while (TRUE) {
#line 1085 "utils.c"
		gboolean _tmp22_ = FALSE;
		GList* _tmp23_;
		GFile* cur_target_dir = NULL;
		GList* _tmp25_;
		gconstpointer _tmp26_;
		GFile* _tmp27_;
		GFile* cur_origin_dir = NULL;
		GList* _tmp28_;
		gconstpointer _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
		guint _tmp33_;
#line 196 "utils.vala"
		_tmp23_ = target_dirs;
#line 196 "utils.vala"
		if (dir_index < g_list_length (_tmp23_)) {
#line 1103 "utils.c"
			GList* _tmp24_;
#line 196 "utils.vala"
			_tmp24_ = origin_dirs;
#line 196 "utils.vala"
			_tmp22_ = dir_index < g_list_length (_tmp24_);
#line 1109 "utils.c"
		} else {
#line 196 "utils.vala"
			_tmp22_ = FALSE;
#line 1113 "utils.c"
		}
#line 196 "utils.vala"
		if (!_tmp22_) {
#line 196 "utils.vala"
			break;
#line 1119 "utils.c"
		}
#line 198 "utils.vala"
		_tmp25_ = target_dirs;
#line 198 "utils.vala"
		_tmp26_ = g_list_nth_data (_tmp25_, dir_index);
#line 198 "utils.vala"
		_tmp27_ = _g_object_ref0 ((GFile*) _tmp26_);
#line 198 "utils.vala"
		cur_target_dir = _tmp27_;
#line 199 "utils.vala"
		_tmp28_ = origin_dirs;
#line 199 "utils.vala"
		_tmp29_ = g_list_nth_data (_tmp28_, dir_index);
#line 199 "utils.vala"
		_tmp30_ = _g_object_ref0 ((GFile*) _tmp29_);
#line 199 "utils.vala"
		cur_origin_dir = _tmp30_;
#line 200 "utils.vala"
		_tmp31_ = cur_target_dir;
#line 200 "utils.vala"
		_tmp32_ = cur_origin_dir;
#line 200 "utils.vala"
		if (!g_file_equal (_tmp31_, _tmp32_)) {
#line 201 "utils.vala"
			_g_object_unref0 (cur_origin_dir);
#line 201 "utils.vala"
			_g_object_unref0 (cur_target_dir);
#line 201 "utils.vala"
			break;
#line 1149 "utils.c"
		}
#line 203 "utils.vala"
		_tmp33_ = dir_index;
#line 203 "utils.vala"
		dir_index = _tmp33_ + 1;
#line 196 "utils.vala"
		_g_object_unref0 (cur_origin_dir);
#line 196 "utils.vala"
		_g_object_unref0 (cur_target_dir);
#line 1159 "utils.c"
	}
#line 206 "utils.vala"
	nb_common_dirs = dir_index;
#line 209 "utils.vala"
	_tmp34_ = g_strdup ("");
#line 209 "utils.vala"
	relative_path = _tmp34_;
#line 212 "utils.vala"
	_tmp35_ = origin_dirs;
#line 212 "utils.vala"
	nb_remaining_origin_dirs = g_list_length (_tmp35_) - nb_common_dirs;
#line 1171 "utils.c"
	{
		guint i = 0U;
#line 213 "utils.vala"
		i = (guint) 0;
#line 1176 "utils.c"
		{
			gboolean _tmp36_ = FALSE;
#line 213 "utils.vala"
			_tmp36_ = TRUE;
#line 213 "utils.vala"
			while (TRUE) {
#line 1183 "utils.c"
				const gchar* _tmp38_;
				gchar* _tmp39_;
#line 213 "utils.vala"
				if (!_tmp36_) {
#line 1188 "utils.c"
					guint _tmp37_;
#line 213 "utils.vala"
					_tmp37_ = i;
#line 213 "utils.vala"
					i = _tmp37_ + 1;
#line 1194 "utils.c"
				}
#line 213 "utils.vala"
				_tmp36_ = FALSE;
#line 213 "utils.vala"
				if (!(i < nb_remaining_origin_dirs)) {
#line 213 "utils.vala"
					break;
#line 1202 "utils.c"
				}
#line 214 "utils.vala"
				_tmp38_ = relative_path;
#line 214 "utils.vala"
				_tmp39_ = g_strconcat (_tmp38_, "../", NULL);
#line 214 "utils.vala"
				_g_free0 (relative_path);
#line 214 "utils.vala"
				relative_path = _tmp39_;
#line 1212 "utils.c"
			}
		}
	}
	{
		guint i = 0U;
#line 217 "utils.vala"
		i = nb_common_dirs;
#line 1220 "utils.c"
		{
			gboolean _tmp40_ = FALSE;
#line 217 "utils.vala"
			_tmp40_ = TRUE;
#line 217 "utils.vala"
			while (TRUE) {
#line 1227 "utils.c"
				GList* _tmp42_;
				GFile* cur_target_dir = NULL;
				GList* _tmp43_;
				gconstpointer _tmp44_;
				GFile* _tmp45_;
				const gchar* _tmp46_;
				GFile* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
#line 217 "utils.vala"
				if (!_tmp40_) {
#line 1242 "utils.c"
					guint _tmp41_;
#line 217 "utils.vala"
					_tmp41_ = i;
#line 217 "utils.vala"
					i = _tmp41_ + 1;
#line 1248 "utils.c"
				}
#line 217 "utils.vala"
				_tmp40_ = FALSE;
#line 217 "utils.vala"
				_tmp42_ = target_dirs;
#line 217 "utils.vala"
				if (!(i < g_list_length (_tmp42_))) {
#line 217 "utils.vala"
					break;
#line 1258 "utils.c"
				}
#line 219 "utils.vala"
				_tmp43_ = target_dirs;
#line 219 "utils.vala"
				_tmp44_ = g_list_nth_data (_tmp43_, i);
#line 219 "utils.vala"
				_tmp45_ = _g_object_ref0 ((GFile*) _tmp44_);
#line 219 "utils.vala"
				cur_target_dir = _tmp45_;
#line 220 "utils.vala"
				_tmp46_ = relative_path;
#line 220 "utils.vala"
				_tmp47_ = cur_target_dir;
#line 220 "utils.vala"
				_tmp48_ = g_file_get_basename (_tmp47_);
#line 220 "utils.vala"
				_tmp49_ = _tmp48_;
#line 220 "utils.vala"
				_tmp50_ = g_strconcat (_tmp49_, "/", NULL);
#line 220 "utils.vala"
				_tmp51_ = _tmp50_;
#line 220 "utils.vala"
				_tmp52_ = g_strconcat (_tmp46_, _tmp51_, NULL);
#line 220 "utils.vala"
				_g_free0 (relative_path);
#line 220 "utils.vala"
				relative_path = _tmp52_;
#line 220 "utils.vala"
				_g_free0 (_tmp51_);
#line 220 "utils.vala"
				_g_free0 (_tmp49_);
#line 217 "utils.vala"
				_g_object_unref0 (cur_target_dir);
#line 1292 "utils.c"
			}
		}
	}
#line 224 "utils.vala"
	_tmp53_ = relative_path;
#line 224 "utils.vala"
	_tmp54_ = g_file_get_basename (target);
#line 224 "utils.vala"
	_tmp55_ = _tmp54_;
#line 224 "utils.vala"
	_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 224 "utils.vala"
	_g_free0 (relative_path);
#line 224 "utils.vala"
	relative_path = _tmp56_;
#line 224 "utils.vala"
	_g_free0 (_tmp55_);
#line 225 "utils.vala"
	result = relative_path;
#line 225 "utils.vala"
	(origin_dirs == NULL) ? NULL : (origin_dirs = (_g_list_free__g_object_unref0_ (origin_dirs), NULL));
#line 225 "utils.vala"
	(target_dirs == NULL) ? NULL : (target_dirs = (_g_list_free__g_object_unref0_ (target_dirs), NULL));
#line 225 "utils.vala"
	_g_object_unref0 (target_parent);
#line 225 "utils.vala"
	_g_object_unref0 (origin_dir);
#line 225 "utils.vala"
	return result;
#line 1322 "utils.c"
}

/*************************************************************************/
GtkScrolledWindow*
utils_add_scrollbar (GtkWidget* child)
{
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* result = NULL;
#line 232 "utils.vala"
	g_return_val_if_fail (child != NULL, NULL);
#line 234 "utils.vala"
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 234 "utils.vala"
	g_object_ref_sink (_tmp0_);
#line 234 "utils.vala"
	sw = _tmp0_;
#line 235 "utils.vala"
	gtk_container_add ((GtkContainer*) sw, child);
#line 236 "utils.vala"
	result = sw;
#line 236 "utils.vala"
	return result;
#line 1346 "utils.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 245 "utils.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1354 "utils.c"
}

gboolean
utils_tree_model_iter_prev (GtkTreeModel* model,
                            GtkTreeIter* iter)
{
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean result = FALSE;
#line 239 "utils.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 239 "utils.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 241 "utils.vala"
	_tmp0_ = *iter;
#line 241 "utils.vala"
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
#line 241 "utils.vala"
	path = _tmp1_;
#line 242 "utils.vala"
	_tmp2_ = path;
#line 242 "utils.vala"
	if (gtk_tree_path_prev (_tmp2_)) {
#line 1380 "utils.c"
		gboolean ret = FALSE;
		GtkTreePath* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
#line 244 "utils.vala"
		_tmp3_ = path;
#line 244 "utils.vala"
		_tmp5_ = gtk_tree_model_get_iter (model, &_tmp4_, _tmp3_);
#line 244 "utils.vala"
		*iter = _tmp4_;
#line 244 "utils.vala"
		ret = _tmp5_;
#line 245 "utils.vala"
		result = ret;
#line 245 "utils.vala"
		__vala_GtkTreePath_free0 (path);
#line 245 "utils.vala"
		return result;
#line 1399 "utils.c"
	}
#line 247 "utils.vala"
	result = FALSE;
#line 247 "utils.vala"
	__vala_GtkTreePath_free0 (path);
#line 247 "utils.vala"
	return result;
#line 1407 "utils.c"
}

gint
utils_get_selected_row (GtkTreeView* view,
                        GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gint result = 0;
#line 252 "utils.vala"
	g_return_val_if_fail (view != NULL, 0);
#line 254 "utils.vala"
	_tmp0_ = gtk_tree_view_get_selection (view);
#line 254 "utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 254 "utils.vala"
	select = _tmp1_;
#line 255 "utils.vala"
	_tmp2_ = select;
#line 255 "utils.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
#line 255 "utils.vala"
	_vala_iter = _tmp3_;
#line 255 "utils.vala"
	if (_tmp4_) {
#line 1438 "utils.c"
		GtkTreeModel* model = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		gint _tmp11_ = 0;
		gint* _tmp12_;
		gint _tmp13_;
#line 257 "utils.vala"
		_tmp5_ = gtk_tree_view_get_model (view);
#line 257 "utils.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 257 "utils.vala"
		model = _tmp6_;
#line 258 "utils.vala"
		_tmp7_ = model;
#line 258 "utils.vala"
		_tmp8_ = _vala_iter;
#line 258 "utils.vala"
		_tmp9_ = gtk_tree_model_get_path (_tmp7_, &_tmp8_);
#line 258 "utils.vala"
		path = _tmp9_;
#line 259 "utils.vala"
		_tmp10_ = path;
#line 259 "utils.vala"
		_tmp12_ = gtk_tree_path_get_indices_with_depth (_tmp10_, &_tmp11_);
#line 259 "utils.vala"
		_tmp13_ = _tmp12_[0];
#line 259 "utils.vala"
		result = _tmp13_;
#line 259 "utils.vala"
		__vala_GtkTreePath_free0 (path);
#line 259 "utils.vala"
		_g_object_unref0 (model);
#line 259 "utils.vala"
		_g_object_unref0 (select);
#line 259 "utils.vala"
		if (iter) {
#line 259 "utils.vala"
			*iter = _vala_iter;
#line 1482 "utils.c"
		}
#line 259 "utils.vala"
		return result;
#line 1486 "utils.c"
	}
#line 261 "utils.vala"
	result = -1;
#line 261 "utils.vala"
	_g_object_unref0 (select);
#line 261 "utils.vala"
	if (iter) {
#line 261 "utils.vala"
		*iter = _vala_iter;
#line 1496 "utils.c"
	}
#line 261 "utils.vala"
	return result;
#line 1500 "utils.c"
}

GtkWindow*
utils_get_toplevel_window (GtkWidget* widget)
{
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWindow* result = NULL;
#line 264 "utils.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 266 "utils.vala"
	_tmp0_ = gtk_widget_get_toplevel (widget);
#line 266 "utils.vala"
	toplevel = _tmp0_;
#line 268 "utils.vala"
	_tmp1_ = toplevel;
#line 268 "utils.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ())) {
#line 1520 "utils.c"
		GtkWidget* _tmp2_;
#line 269 "utils.vala"
		_tmp2_ = toplevel;
#line 269 "utils.vala"
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL;
#line 269 "utils.vala"
		return result;
#line 1528 "utils.c"
	}
#line 271 "utils.vala"
	result = NULL;
#line 271 "utils.vala"
	return result;
#line 1534 "utils.c"
}

/*************************************************************************/
void
utils_flush_queue (void)
{
#line 280 "utils.vala"
	while (TRUE) {
#line 280 "utils.vala"
		if (!gtk_events_pending ()) {
#line 280 "utils.vala"
			break;
#line 1547 "utils.c"
		}
#line 281 "utils.vala"
		gtk_main_iteration ();
#line 1551 "utils.c"
	}
}

