/* symbols.c generated by valac 0.46.6, the Vala compiler
 * generated from symbols.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

typedef enum  {
	SYMBOLS_CATEGORY_TYPE_NORMAL,
	SYMBOLS_CATEGORY_TYPE_MOST_USED
} SymbolsCategoryType;

#define TYPE_SYMBOLS_CATEGORY_TYPE (symbols_category_type_get_type ())
typedef enum  {
	SYMBOLS_CATEGORY_COLUMN_TYPE,
	SYMBOLS_CATEGORY_COLUMN_ICON,
	SYMBOLS_CATEGORY_COLUMN_NAME,
	SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE,
	SYMBOLS_CATEGORY_COLUMN_N_COLUMNS
} SymbolsCategoryColumn;

#define TYPE_SYMBOLS_CATEGORY_COLUMN (symbols_category_column_get_type ())
typedef enum  {
	SYMBOL_COLUMN_PIXBUF,
	SYMBOL_COLUMN_COMMAND,
	SYMBOL_COLUMN_TOOLTIP,
	SYMBOL_COLUMN_ID,
	SYMBOL_COLUMN_N_COLUMNS
} SymbolColumn;

#define TYPE_SYMBOL_COLUMN (symbol_column_get_type ())

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;
typedef struct _SymbolsPrivate SymbolsPrivate;

#define TYPE_NORMAL_SYMBOLS (normal_symbols_get_type ())
#define NORMAL_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NORMAL_SYMBOLS, NormalSymbols))
#define NORMAL_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NORMAL_SYMBOLS, NormalSymbolsClass))
#define IS_NORMAL_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NORMAL_SYMBOLS))
#define IS_NORMAL_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NORMAL_SYMBOLS))
#define NORMAL_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NORMAL_SYMBOLS, NormalSymbolsClass))

typedef struct _NormalSymbols NormalSymbols;
typedef struct _NormalSymbolsClass NormalSymbolsClass;
enum  {
	SYMBOLS_0_PROPERTY,
	SYMBOLS_NUM_PROPERTIES
};
static GParamSpec* symbols_properties[SYMBOLS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYMBOLS_TYPE_CATEGORY_INFO (symbols_category_info_get_type ())
typedef struct _SymbolsCategoryInfo SymbolsCategoryInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NormalSymbolsPrivate NormalSymbolsPrivate;

#define NORMAL_SYMBOLS_TYPE_SYMBOL_INFO (normal_symbols_symbol_info_get_type ())
typedef struct _NormalSymbolsSymbolInfo NormalSymbolsSymbolInfo;
enum  {
	NORMAL_SYMBOLS_0_PROPERTY,
	NORMAL_SYMBOLS_NUM_PROPERTIES
};
static GParamSpec* normal_symbols_properties[NORMAL_SYMBOLS_NUM_PROPERTIES];
#define _normal_symbols_symbol_info_free0(var) ((var == NULL) ? NULL : (var = (normal_symbols_symbol_info_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))

struct _Symbols {
	GObject parent_instance;
	SymbolsPrivate * priv;
};

struct _SymbolsClass {
	GObjectClass parent_class;
};

struct _SymbolsPrivate {
	GtkListStore* _categories_store;
	GeeMap* _normal_symbols_map;
};

struct _SymbolsCategoryInfo {
	gchar* name;
	gchar* icon;
	gchar* id;
};

struct _NormalSymbols {
	GtkListStore parent_instance;
	NormalSymbolsPrivate * priv;
};

struct _NormalSymbolsClass {
	GtkListStoreClass parent_class;
};

struct _NormalSymbolsSymbolInfo {
	gchar* latex_command;
	gchar* package_required;
};

struct _NormalSymbolsPrivate {
	gchar* _category_id;
	gchar* _resource_path;
	GeeMap* _data;
};

static gint Symbols_private_offset;
static gpointer symbols_parent_class = NULL;
static Symbols* symbols__instance;
static Symbols* symbols__instance = NULL;
static gint NormalSymbols_private_offset;
static gpointer normal_symbols_parent_class = NULL;

GType symbols_category_type_get_type (void) G_GNUC_CONST;
GType symbols_category_column_get_type (void) G_GNUC_CONST;
GType symbol_column_get_type (void) G_GNUC_CONST;
GType symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Symbols, g_object_unref)
GType normal_symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NormalSymbols, g_object_unref)
static GType symbols_category_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SymbolsCategoryInfo* symbols_category_info_dup (const SymbolsCategoryInfo* self);
static void symbols_category_info_free (SymbolsCategoryInfo* self);
static void symbols_category_info_copy (const SymbolsCategoryInfo* self,
                                 SymbolsCategoryInfo* dest);
static void symbols_category_info_destroy (SymbolsCategoryInfo* self);
static Symbols* symbols_new (void);
static Symbols* symbols_construct (GType object_type);
static void symbols_add_normal_category (Symbols* self,
                                  SymbolsCategoryInfo* info);
Symbols* symbols_get_default (void);
static void symbols_add_most_used_category (Symbols* self);
GtkTreeModel* symbols_get_categories_model (Symbols* self);
gboolean symbols_get_symbol_info (Symbols* self,
                                  const gchar* id,
                                  gchar* * command,
                                  gchar* * tooltip);
gboolean normal_symbols_get_symbol_info (NormalSymbols* self,
                                         const gchar* icon_file,
                                         gchar* * command,
                                         gchar* * package);
gchar* symbols_get_tooltip (const gchar* latex_command,
                            const gchar* package_required);
NormalSymbols* normal_symbols_new (const gchar* category_id);
NormalSymbols* normal_symbols_construct (GType object_type,
                                         const gchar* category_id);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
MostUsedSymbols* most_used_symbols_get_default (void);
GtkTreeModel* most_used_symbols_get_model (MostUsedSymbols* self);
GdkPixbuf* symbols_get_pixbuf (const gchar* symbol_id);
static void symbols_finalize (GObject * obj);
static GType normal_symbols_symbol_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static NormalSymbolsSymbolInfo* normal_symbols_symbol_info_dup (const NormalSymbolsSymbolInfo* self);
static void normal_symbols_symbol_info_free (NormalSymbolsSymbolInfo* self);
static void normal_symbols_symbol_info_copy (const NormalSymbolsSymbolInfo* self,
                                      NormalSymbolsSymbolInfo* dest);
static void normal_symbols_symbol_info_destroy (NormalSymbolsSymbolInfo* self);
static void normal_symbols_load_symbols (NormalSymbols* self);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
static void normal_symbols_parser_start (NormalSymbols* self,
                                  GMarkupParseContext* context,
                                  const gchar* name,
                                  gchar** attr_names,
                                  gint attr_names_length1,
                                  gchar** attr_values,
                                  gint attr_values_length1,
                                  GError** error);
static void _normal_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                     const gchar* element_name,
                                                                     gchar** attribute_names,
                                                                     gchar** attribute_values,
                                                                     gpointer self,
                                                                     GError** error);
static void normal_symbols_add_symbol (NormalSymbols* self,
                                const gchar* icon_file,
                                NormalSymbolsSymbolInfo* symbol);
static void normal_symbols_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const SymbolsCategoryInfo SYMBOLS__normal_categories[7] = {{N_ ("Greek"), "symbol_greek", "greek"}, {N_ ("Arrows"), "symbol_arrows", "arrows"}, {N_ ("Relations"), "symbol_relations", "relations"}, {N_ ("Operators"), "symbol_operators", "operators"}, {N_ ("Delimiters"), "symbol_delimiters", "delimiters"}, {N_ ("Misc math"), "symbol_misc_math", "misc-math"}, {N_ ("Misc text"), "symbol_misc_text", "misc-text"}};

GType
symbols_category_type_get_type (void)
{
	static volatile gsize symbols_category_type_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_category_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SYMBOLS_CATEGORY_TYPE_NORMAL, "SYMBOLS_CATEGORY_TYPE_NORMAL", "normal"}, {SYMBOLS_CATEGORY_TYPE_MOST_USED, "SYMBOLS_CATEGORY_TYPE_MOST_USED", "most-used"}, {0, NULL, NULL}};
		GType symbols_category_type_type_id;
		symbols_category_type_type_id = g_enum_register_static ("SymbolsCategoryType", values);
		g_once_init_leave (&symbols_category_type_type_id__volatile, symbols_category_type_type_id);
	}
	return symbols_category_type_type_id__volatile;
}

GType
symbols_category_column_get_type (void)
{
	static volatile gsize symbols_category_column_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_category_column_type_id__volatile)) {
		static const GEnumValue values[] = {{SYMBOLS_CATEGORY_COLUMN_TYPE, "SYMBOLS_CATEGORY_COLUMN_TYPE", "type"}, {SYMBOLS_CATEGORY_COLUMN_ICON, "SYMBOLS_CATEGORY_COLUMN_ICON", "icon"}, {SYMBOLS_CATEGORY_COLUMN_NAME, "SYMBOLS_CATEGORY_COLUMN_NAME", "name"}, {SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, "SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE", "symbols-store"}, {SYMBOLS_CATEGORY_COLUMN_N_COLUMNS, "SYMBOLS_CATEGORY_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType symbols_category_column_type_id;
		symbols_category_column_type_id = g_enum_register_static ("SymbolsCategoryColumn", values);
		g_once_init_leave (&symbols_category_column_type_id__volatile, symbols_category_column_type_id);
	}
	return symbols_category_column_type_id__volatile;
}

GType
symbol_column_get_type (void)
{
	static volatile gsize symbol_column_type_id__volatile = 0;
	if (g_once_init_enter (&symbol_column_type_id__volatile)) {
		static const GEnumValue values[] = {{SYMBOL_COLUMN_PIXBUF, "SYMBOL_COLUMN_PIXBUF", "pixbuf"}, {SYMBOL_COLUMN_COMMAND, "SYMBOL_COLUMN_COMMAND", "command"}, {SYMBOL_COLUMN_TOOLTIP, "SYMBOL_COLUMN_TOOLTIP", "tooltip"}, {SYMBOL_COLUMN_ID, "SYMBOL_COLUMN_ID", "id"}, {SYMBOL_COLUMN_N_COLUMNS, "SYMBOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType symbol_column_type_id;
		symbol_column_type_id = g_enum_register_static ("SymbolColumn", values);
		g_once_init_leave (&symbol_column_type_id__volatile, symbol_column_type_id);
	}
	return symbol_column_type_id__volatile;
}

static inline gpointer
symbols_get_instance_private (Symbols* self)
{
	return G_STRUCT_MEMBER_P (self, Symbols_private_offset);
}

static Symbols*
symbols_construct (GType object_type)
{
	Symbols * self = NULL;
	GtkListStore* _tmp0_;
	GeeHashMap* _tmp1_;
#line 75 "symbols.vala"
	self = (Symbols*) g_object_new (object_type, NULL);
#line 77 "symbols.vala"
	_tmp0_ = gtk_list_store_new ((gint) SYMBOLS_CATEGORY_COLUMN_N_COLUMNS, TYPE_SYMBOLS_CATEGORY_TYPE, G_TYPE_STRING, G_TYPE_STRING, gtk_tree_model_get_type (), -1);
#line 77 "symbols.vala"
	_g_object_unref0 (self->priv->_categories_store);
#line 77 "symbols.vala"
	self->priv->_categories_store = _tmp0_;
#line 84 "symbols.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_NORMAL_SYMBOLS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 84 "symbols.vala"
	_g_object_unref0 (self->priv->_normal_symbols_map);
#line 84 "symbols.vala"
	self->priv->_normal_symbols_map = (GeeMap*) _tmp1_;
#line 300 "symbols.c"
	{
		SymbolsCategoryInfo* info_collection = NULL;
		gint info_collection_length1 = 0;
		gint _info_collection_size_ = 0;
		gint info_it = 0;
#line 86 "symbols.vala"
		info_collection = SYMBOLS__normal_categories;
#line 86 "symbols.vala"
		info_collection_length1 = G_N_ELEMENTS (SYMBOLS__normal_categories);
#line 86 "symbols.vala"
		for (info_it = 0; info_it < info_collection_length1; info_it = info_it + 1) {
#line 312 "symbols.c"
			SymbolsCategoryInfo _tmp2_;
			SymbolsCategoryInfo _tmp3_ = {0};
			SymbolsCategoryInfo info = {0};
#line 86 "symbols.vala"
			_tmp2_ = info_collection[info_it];
#line 86 "symbols.vala"
			symbols_category_info_copy (&_tmp2_, &_tmp3_);
#line 86 "symbols.vala"
			info = _tmp3_;
#line 322 "symbols.c"
			{
				SymbolsCategoryInfo _tmp4_;
#line 87 "symbols.vala"
				_tmp4_ = info;
#line 87 "symbols.vala"
				symbols_add_normal_category (self, &_tmp4_);
#line 86 "symbols.vala"
				symbols_category_info_destroy (&info);
#line 331 "symbols.c"
			}
		}
	}
#line 75 "symbols.vala"
	return self;
#line 337 "symbols.c"
}

static Symbols*
symbols_new (void)
{
#line 75 "symbols.vala"
	return symbols_construct (TYPE_SYMBOLS);
#line 345 "symbols.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 102 "symbols.vala"
	return self ? g_object_ref (self) : NULL;
#line 353 "symbols.c"
}

Symbols*
symbols_get_default (void)
{
	Symbols* _tmp0_;
	Symbols* _tmp3_;
	Symbols* _tmp4_;
	Symbols* result = NULL;
#line 92 "symbols.vala"
	_tmp0_ = symbols__instance;
#line 92 "symbols.vala"
	if (_tmp0_ == NULL) {
#line 367 "symbols.c"
		Symbols* _tmp1_;
		Symbols* _tmp2_;
#line 94 "symbols.vala"
		_tmp1_ = symbols_new ();
#line 94 "symbols.vala"
		_g_object_unref0 (symbols__instance);
#line 94 "symbols.vala"
		symbols__instance = _tmp1_;
#line 99 "symbols.vala"
		_tmp2_ = symbols__instance;
#line 99 "symbols.vala"
		symbols_add_most_used_category (_tmp2_);
#line 380 "symbols.c"
	}
#line 102 "symbols.vala"
	_tmp3_ = symbols__instance;
#line 102 "symbols.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 102 "symbols.vala"
	result = _tmp4_;
#line 102 "symbols.vala"
	return result;
#line 390 "symbols.c"
}

GtkTreeModel*
symbols_get_categories_model (Symbols* self)
{
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* result = NULL;
#line 105 "symbols.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "symbols.vala"
	_tmp0_ = self->priv->_categories_store;
#line 107 "symbols.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp0_) : NULL);
#line 107 "symbols.vala"
	result = _tmp1_;
#line 107 "symbols.vala"
	return result;
#line 409 "symbols.c"
}

gboolean
symbols_get_symbol_info (Symbols* self,
                         const gchar* id,
                         gchar* * command,
                         gchar* * tooltip)
{
	gchar* _vala_command = NULL;
	gchar* _vala_tooltip = NULL;
	gchar** id_components = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint id_components_length1;
	gint _id_components_size_;
	gchar* category_id = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* icon_file = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GeeMap* _tmp6_;
	NormalSymbols* normal_symbols = NULL;
	GeeMap* _tmp7_;
	gpointer _tmp8_;
	gchar* package = NULL;
	gboolean ok = FALSE;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean result = FALSE;
#line 110 "symbols.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 110 "symbols.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 112 "symbols.vala"
	_g_free0 (_vala_command);
#line 112 "symbols.vala"
	_vala_command = NULL;
#line 113 "symbols.vala"
	_g_free0 (_vala_tooltip);
#line 113 "symbols.vala"
	_vala_tooltip = NULL;
#line 115 "symbols.vala"
	_tmp1_ = _tmp0_ = g_strsplit (id, "/", 0);
#line 115 "symbols.vala"
	id_components = _tmp1_;
#line 115 "symbols.vala"
	id_components_length1 = _vala_array_length (_tmp0_);
#line 115 "symbols.vala"
	_id_components_size_ = id_components_length1;
#line 116 "symbols.vala"
	g_return_val_if_fail (id_components_length1 == 2, FALSE);
#line 118 "symbols.vala"
	_tmp2_ = id_components[0];
#line 118 "symbols.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 118 "symbols.vala"
	category_id = _tmp3_;
#line 119 "symbols.vala"
	_tmp4_ = id_components[1];
#line 119 "symbols.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 119 "symbols.vala"
	icon_file = _tmp5_;
#line 121 "symbols.vala"
	_tmp6_ = self->priv->_normal_symbols_map;
#line 121 "symbols.vala"
	g_return_val_if_fail (gee_map_has_key (_tmp6_, category_id), FALSE);
#line 123 "symbols.vala"
	_tmp7_ = self->priv->_normal_symbols_map;
#line 123 "symbols.vala"
	_tmp8_ = gee_map_get (_tmp7_, category_id);
#line 123 "symbols.vala"
	normal_symbols = (NormalSymbols*) _tmp8_;
#line 125 "symbols.vala"
	package = NULL;
#line 126 "symbols.vala"
	_tmp11_ = normal_symbols_get_symbol_info (normal_symbols, icon_file, &_tmp9_, &_tmp10_);
#line 126 "symbols.vala"
	_g_free0 (_vala_command);
#line 126 "symbols.vala"
	_vala_command = _tmp9_;
#line 126 "symbols.vala"
	_g_free0 (package);
#line 126 "symbols.vala"
	package = _tmp10_;
#line 126 "symbols.vala"
	ok = _tmp11_;
#line 128 "symbols.vala"
	g_return_val_if_fail (ok, FALSE);
#line 130 "symbols.vala"
	_tmp12_ = _vala_command;
#line 130 "symbols.vala"
	_tmp13_ = package;
#line 130 "symbols.vala"
	_tmp14_ = symbols_get_tooltip (_tmp12_, _tmp13_);
#line 130 "symbols.vala"
	_g_free0 (_vala_tooltip);
#line 130 "symbols.vala"
	_vala_tooltip = _tmp14_;
#line 131 "symbols.vala"
	result = TRUE;
#line 131 "symbols.vala"
	_g_free0 (package);
#line 131 "symbols.vala"
	_g_object_unref0 (normal_symbols);
#line 131 "symbols.vala"
	_g_free0 (icon_file);
#line 131 "symbols.vala"
	_g_free0 (category_id);
#line 131 "symbols.vala"
	id_components = (_vala_array_free (id_components, id_components_length1, (GDestroyNotify) g_free), NULL);
#line 131 "symbols.vala"
	if (command) {
#line 131 "symbols.vala"
		*command = _vala_command;
#line 530 "symbols.c"
	} else {
#line 131 "symbols.vala"
		_g_free0 (_vala_command);
#line 534 "symbols.c"
	}
#line 131 "symbols.vala"
	if (tooltip) {
#line 131 "symbols.vala"
		*tooltip = _vala_tooltip;
#line 540 "symbols.c"
	} else {
#line 131 "symbols.vala"
		_g_free0 (_vala_tooltip);
#line 544 "symbols.c"
	}
#line 131 "symbols.vala"
	return result;
#line 548 "symbols.c"
}

static void
symbols_add_normal_category (Symbols* self,
                             SymbolsCategoryInfo* info)
{
	GtkListStore* store = NULL;
	SymbolsCategoryInfo _tmp0_;
	const gchar* _tmp1_;
	NormalSymbols* _tmp2_;
	GeeMap* _tmp3_;
	SymbolsCategoryInfo _tmp4_;
	const gchar* _tmp5_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_;
	SymbolsCategoryInfo _tmp10_;
	const gchar* _tmp11_;
	SymbolsCategoryInfo _tmp12_;
	const gchar* _tmp13_;
#line 134 "symbols.vala"
	g_return_if_fail (self != NULL);
#line 134 "symbols.vala"
	g_return_if_fail (info != NULL);
#line 136 "symbols.vala"
	_tmp0_ = *info;
#line 136 "symbols.vala"
	_tmp1_ = _tmp0_.id;
#line 136 "symbols.vala"
	_tmp2_ = normal_symbols_new (_tmp1_);
#line 136 "symbols.vala"
	store = (GtkListStore*) _tmp2_;
#line 138 "symbols.vala"
	_tmp3_ = self->priv->_normal_symbols_map;
#line 138 "symbols.vala"
	_tmp4_ = *info;
#line 138 "symbols.vala"
	_tmp5_ = _tmp4_.id;
#line 138 "symbols.vala"
	gee_map_set (_tmp3_, _tmp5_, IS_NORMAL_SYMBOLS (store) ? ((NormalSymbols*) store) : NULL);
#line 141 "symbols.vala"
	_tmp6_ = self->priv->_categories_store;
#line 141 "symbols.vala"
	gtk_list_store_append (_tmp6_, &_tmp7_);
#line 141 "symbols.vala"
	iter = _tmp7_;
#line 142 "symbols.vala"
	_tmp8_ = self->priv->_categories_store;
#line 142 "symbols.vala"
	_tmp9_ = iter;
#line 142 "symbols.vala"
	_tmp10_ = *info;
#line 142 "symbols.vala"
	_tmp11_ = _tmp10_.icon;
#line 142 "symbols.vala"
	_tmp12_ = *info;
#line 142 "symbols.vala"
	_tmp13_ = _tmp12_.name;
#line 142 "symbols.vala"
	gtk_list_store_set (_tmp8_, &_tmp9_, SYMBOLS_CATEGORY_COLUMN_TYPE, SYMBOLS_CATEGORY_TYPE_NORMAL, SYMBOLS_CATEGORY_COLUMN_ICON, _tmp11_, SYMBOLS_CATEGORY_COLUMN_NAME, _ (_tmp13_), SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, store, -1);
#line 134 "symbols.vala"
	_g_object_unref0 (store);
#line 613 "symbols.c"
}

static void
symbols_add_most_used_category (Symbols* self)
{
	GtkTreeModel* model = NULL;
	MostUsedSymbols* _tmp0_;
	MostUsedSymbols* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
#line 150 "symbols.vala"
	g_return_if_fail (self != NULL);
#line 152 "symbols.vala"
	_tmp0_ = most_used_symbols_get_default ();
#line 152 "symbols.vala"
	_tmp1_ = _tmp0_;
#line 152 "symbols.vala"
	_tmp2_ = most_used_symbols_get_model (_tmp1_);
#line 152 "symbols.vala"
	_tmp3_ = _tmp2_;
#line 152 "symbols.vala"
	_g_object_unref0 (_tmp1_);
#line 152 "symbols.vala"
	model = _tmp3_;
#line 155 "symbols.vala"
	_tmp4_ = self->priv->_categories_store;
#line 155 "symbols.vala"
	gtk_list_store_append (_tmp4_, &_tmp5_);
#line 155 "symbols.vala"
	iter = _tmp5_;
#line 156 "symbols.vala"
	_tmp6_ = self->priv->_categories_store;
#line 156 "symbols.vala"
	_tmp7_ = iter;
#line 156 "symbols.vala"
	gtk_list_store_set (_tmp6_, &_tmp7_, SYMBOLS_CATEGORY_COLUMN_TYPE, SYMBOLS_CATEGORY_TYPE_MOST_USED, SYMBOLS_CATEGORY_COLUMN_ICON, "help-about", SYMBOLS_CATEGORY_COLUMN_NAME, _ ("Most Used"), SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, model, -1);
#line 150 "symbols.vala"
	_g_object_unref0 (model);
#line 657 "symbols.c"
}

gchar*
symbols_get_tooltip (const gchar* latex_command,
                     const gchar* package_required)
{
	gchar* tooltip = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 164 "symbols.vala"
	g_return_val_if_fail (latex_command != NULL, NULL);
#line 168 "symbols.vala"
	_tmp0_ = g_markup_escape_text (latex_command, (gssize) -1);
#line 168 "symbols.vala"
	tooltip = _tmp0_;
#line 170 "symbols.vala"
	if (package_required != NULL) {
#line 675 "symbols.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 171 "symbols.vala"
		_tmp1_ = tooltip;
#line 171 "symbols.vala"
		_tmp2_ = g_strdup_printf (" (package %s)", package_required);
#line 171 "symbols.vala"
		_tmp3_ = _tmp2_;
#line 171 "symbols.vala"
		_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
#line 171 "symbols.vala"
		_g_free0 (tooltip);
#line 171 "symbols.vala"
		tooltip = _tmp4_;
#line 171 "symbols.vala"
		_g_free0 (_tmp3_);
#line 694 "symbols.c"
	}
#line 173 "symbols.vala"
	result = tooltip;
#line 173 "symbols.vala"
	return result;
#line 700 "symbols.c"
}

GdkPixbuf*
symbols_get_pixbuf (const gchar* symbol_id)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result = NULL;
#line 176 "symbols.vala"
	g_return_val_if_fail (symbol_id != NULL, NULL);
#line 710 "symbols.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
#line 180 "symbols.vala"
		_tmp1_ = g_strconcat ("/org/gnome/gnome-latex/symbols/", symbol_id, NULL);
#line 180 "symbols.vala"
		_tmp2_ = _tmp1_;
#line 180 "symbols.vala"
		_tmp3_ = gdk_pixbuf_new_from_resource (_tmp2_, &_inner_error0_);
#line 180 "symbols.vala"
		_tmp4_ = _tmp3_;
#line 180 "symbols.vala"
		_g_free0 (_tmp2_);
#line 180 "symbols.vala"
		_tmp0_ = _tmp4_;
#line 180 "symbols.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 732 "symbols.c"
			goto __catch43_g_error;
		}
#line 180 "symbols.vala"
		_tmp5_ = _tmp0_;
#line 180 "symbols.vala"
		_tmp0_ = NULL;
#line 180 "symbols.vala"
		result = _tmp5_;
#line 180 "symbols.vala"
		_g_object_unref0 (_tmp0_);
#line 180 "symbols.vala"
		return result;
#line 745 "symbols.c"
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 178 "symbols.vala"
		e = _inner_error0_;
#line 178 "symbols.vala"
		_inner_error0_ = NULL;
#line 185 "symbols.vala"
		_tmp6_ = e;
#line 185 "symbols.vala"
		_tmp7_ = _tmp6_->message;
#line 185 "symbols.vala"
		g_warning ("symbols.vala:185: Impossible to load the symbol '%s': %s", symbol_id, _tmp7_);
#line 186 "symbols.vala"
		result = NULL;
#line 186 "symbols.vala"
		_g_error_free0 (e);
#line 186 "symbols.vala"
		return result;
#line 769 "symbols.c"
	}
	__finally43:
#line 178 "symbols.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 178 "symbols.vala"
	g_clear_error (&_inner_error0_);
#line 178 "symbols.vala"
	return NULL;
#line 778 "symbols.c"
}

static void
symbols_category_info_copy (const SymbolsCategoryInfo* self,
                            SymbolsCategoryInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
#line 50 "symbols.vala"
	_tmp0_ = (*self).name;
#line 50 "symbols.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 50 "symbols.vala"
	_g_free0 ((*dest).name);
#line 50 "symbols.vala"
	(*dest).name = _tmp1_;
#line 50 "symbols.vala"
	_tmp2_ = (*self).icon;
#line 50 "symbols.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 50 "symbols.vala"
	_g_free0 ((*dest).icon);
#line 50 "symbols.vala"
	(*dest).icon = _tmp3_;
#line 50 "symbols.vala"
	_tmp4_ = (*self).id;
#line 50 "symbols.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 50 "symbols.vala"
	_g_free0 ((*dest).id);
#line 50 "symbols.vala"
	(*dest).id = _tmp5_;
#line 815 "symbols.c"
}

static void
symbols_category_info_destroy (SymbolsCategoryInfo* self)
{
#line 52 "symbols.vala"
	_g_free0 ((*self).name);
#line 53 "symbols.vala"
	_g_free0 ((*self).icon);
#line 54 "symbols.vala"
	_g_free0 ((*self).id);
#line 827 "symbols.c"
}

static SymbolsCategoryInfo*
symbols_category_info_dup (const SymbolsCategoryInfo* self)
{
	SymbolsCategoryInfo* dup;
#line 50 "symbols.vala"
	dup = g_new0 (SymbolsCategoryInfo, 1);
#line 50 "symbols.vala"
	symbols_category_info_copy (self, dup);
#line 50 "symbols.vala"
	return dup;
#line 840 "symbols.c"
}

static void
symbols_category_info_free (SymbolsCategoryInfo* self)
{
#line 50 "symbols.vala"
	symbols_category_info_destroy (self);
#line 50 "symbols.vala"
	g_free (self);
#line 850 "symbols.c"
}

static GType
symbols_category_info_get_type (void)
{
	static volatile gsize symbols_category_info_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_category_info_type_id__volatile)) {
		GType symbols_category_info_type_id;
		symbols_category_info_type_id = g_boxed_type_register_static ("SymbolsCategoryInfo", (GBoxedCopyFunc) symbols_category_info_dup, (GBoxedFreeFunc) symbols_category_info_free);
		g_once_init_leave (&symbols_category_info_type_id__volatile, symbols_category_info_type_id);
	}
	return symbols_category_info_type_id__volatile;
}

static void
symbols_class_init (SymbolsClass * klass,
                    gpointer klass_data)
{
#line 48 "symbols.vala"
	symbols_parent_class = g_type_class_peek_parent (klass);
#line 48 "symbols.vala"
	g_type_class_adjust_private_offset (klass, &Symbols_private_offset);
#line 48 "symbols.vala"
	G_OBJECT_CLASS (klass)->finalize = symbols_finalize;
#line 875 "symbols.c"
}

static void
symbols_instance_init (Symbols * self,
                       gpointer klass)
{
#line 48 "symbols.vala"
	self->priv = symbols_get_instance_private (self);
#line 884 "symbols.c"
}

static void
symbols_finalize (GObject * obj)
{
	Symbols * self;
#line 48 "symbols.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYMBOLS, Symbols);
#line 69 "symbols.vala"
	_g_object_unref0 (self->priv->_categories_store);
#line 72 "symbols.vala"
	_g_object_unref0 (self->priv->_normal_symbols_map);
#line 48 "symbols.vala"
	G_OBJECT_CLASS (symbols_parent_class)->finalize (obj);
#line 899 "symbols.c"
}

GType
symbols_get_type (void)
{
	static volatile gsize symbols_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Symbols), 0, (GInstanceInitFunc) symbols_instance_init, NULL };
		GType symbols_type_id;
		symbols_type_id = g_type_register_static (G_TYPE_OBJECT, "Symbols", &g_define_type_info, 0);
		Symbols_private_offset = g_type_add_instance_private (symbols_type_id, sizeof (SymbolsPrivate));
		g_once_init_leave (&symbols_type_id__volatile, symbols_type_id);
	}
	return symbols_type_id__volatile;
}

static inline gpointer
normal_symbols_get_instance_private (NormalSymbols* self)
{
	return G_STRUCT_MEMBER_P (self, NormalSymbols_private_offset);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1518 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1519 "glib-2.0.vapi"
	result = self;
#line 1519 "glib-2.0.vapi"
	return result;
#line 932 "symbols.c"
}

NormalSymbols*
normal_symbols_construct (GType object_type,
                          const gchar* category_id)
{
	NormalSymbols * self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GType* column_types = NULL;
	GType* _tmp4_;
	gint column_types_length1;
	gint _column_types_size_;
#line 205 "symbols.vala"
	g_return_val_if_fail (category_id != NULL, NULL);
#line 205 "symbols.vala"
	self = (NormalSymbols*) g_object_new (object_type, NULL);
#line 207 "symbols.vala"
	_tmp0_ = g_strdup (category_id);
#line 207 "symbols.vala"
	_g_free0 (self->priv->_category_id);
#line 207 "symbols.vala"
	self->priv->_category_id = _tmp0_;
#line 208 "symbols.vala"
	_tmp1_ = string_to_string (category_id);
#line 208 "symbols.vala"
	_tmp2_ = g_strconcat ("/org/gnome/gnome-latex/symbols/", _tmp1_, "/", NULL);
#line 208 "symbols.vala"
	_g_free0 (self->priv->_resource_path);
#line 208 "symbols.vala"
	self->priv->_resource_path = _tmp2_;
#line 210 "symbols.vala"
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NORMAL_SYMBOLS_TYPE_SYMBOL_INFO, (GBoxedCopyFunc) normal_symbols_symbol_info_dup, (GDestroyNotify) normal_symbols_symbol_info_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 210 "symbols.vala"
	_g_object_unref0 (self->priv->_data);
#line 210 "symbols.vala"
	self->priv->_data = (GeeMap*) _tmp3_;
#line 212 "symbols.vala"
	_tmp4_ = g_new0 (GType, 4);
#line 212 "symbols.vala"
	_tmp4_[0] = gdk_pixbuf_get_type ();
#line 212 "symbols.vala"
	_tmp4_[1] = G_TYPE_STRING;
#line 212 "symbols.vala"
	_tmp4_[2] = G_TYPE_STRING;
#line 212 "symbols.vala"
	_tmp4_[3] = G_TYPE_STRING;
#line 212 "symbols.vala"
	column_types = _tmp4_;
#line 212 "symbols.vala"
	column_types_length1 = 4;
#line 212 "symbols.vala"
	_column_types_size_ = column_types_length1;
#line 219 "symbols.vala"
	gtk_list_store_set_column_types ((GtkListStore*) self, (gint) column_types_length1, column_types);
#line 221 "symbols.vala"
	normal_symbols_load_symbols (self);
#line 205 "symbols.vala"
	column_types = (g_free (column_types), NULL);
#line 205 "symbols.vala"
	return self;
#line 996 "symbols.c"
}

NormalSymbols*
normal_symbols_new (const gchar* category_id)
{
#line 205 "symbols.vala"
	return normal_symbols_construct (TYPE_NORMAL_SYMBOLS, category_id);
#line 1004 "symbols.c"
}

gboolean
normal_symbols_get_symbol_info (NormalSymbols* self,
                                const gchar* icon_file,
                                gchar* * command,
                                gchar* * package)
{
	gchar* _vala_command = NULL;
	gchar* _vala_package = NULL;
	GeeMap* _tmp0_;
	NormalSymbolsSymbolInfo info = {0};
	GeeMap* _tmp1_;
	gpointer _tmp2_;
	NormalSymbolsSymbolInfo* _tmp3_;
	NormalSymbolsSymbolInfo _tmp4_;
	NormalSymbolsSymbolInfo _tmp5_ = {0};
	NormalSymbolsSymbolInfo _tmp6_;
	NormalSymbolsSymbolInfo _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	NormalSymbolsSymbolInfo _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean result = FALSE;
#line 224 "symbols.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 224 "symbols.vala"
	g_return_val_if_fail (icon_file != NULL, FALSE);
#line 226 "symbols.vala"
	_g_free0 (_vala_command);
#line 226 "symbols.vala"
	_vala_command = NULL;
#line 227 "symbols.vala"
	_g_free0 (_vala_package);
#line 227 "symbols.vala"
	_vala_package = NULL;
#line 229 "symbols.vala"
	_tmp0_ = self->priv->_data;
#line 229 "symbols.vala"
	if (!gee_map_has_key (_tmp0_, icon_file)) {
#line 230 "symbols.vala"
		result = FALSE;
#line 230 "symbols.vala"
		if (command) {
#line 230 "symbols.vala"
			*command = _vala_command;
#line 1052 "symbols.c"
		} else {
#line 230 "symbols.vala"
			_g_free0 (_vala_command);
#line 1056 "symbols.c"
		}
#line 230 "symbols.vala"
		if (package) {
#line 230 "symbols.vala"
			*package = _vala_package;
#line 1062 "symbols.c"
		} else {
#line 230 "symbols.vala"
			_g_free0 (_vala_package);
#line 1066 "symbols.c"
		}
#line 230 "symbols.vala"
		return result;
#line 1070 "symbols.c"
	}
#line 232 "symbols.vala"
	_tmp1_ = self->priv->_data;
#line 232 "symbols.vala"
	_tmp2_ = gee_map_get (_tmp1_, icon_file);
#line 232 "symbols.vala"
	_tmp3_ = (NormalSymbolsSymbolInfo*) _tmp2_;
#line 232 "symbols.vala"
	_tmp4_ = *_tmp3_;
#line 232 "symbols.vala"
	normal_symbols_symbol_info_copy (&_tmp4_, &_tmp5_);
#line 232 "symbols.vala"
	_tmp6_ = _tmp5_;
#line 232 "symbols.vala"
	_normal_symbols_symbol_info_free0 (_tmp3_);
#line 232 "symbols.vala"
	info = _tmp6_;
#line 233 "symbols.vala"
	_tmp7_ = info;
#line 233 "symbols.vala"
	_tmp8_ = _tmp7_.latex_command;
#line 233 "symbols.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 233 "symbols.vala"
	_g_free0 (_vala_command);
#line 233 "symbols.vala"
	_vala_command = _tmp9_;
#line 234 "symbols.vala"
	_tmp10_ = info;
#line 234 "symbols.vala"
	_tmp11_ = _tmp10_.package_required;
#line 234 "symbols.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 234 "symbols.vala"
	_g_free0 (_vala_package);
#line 234 "symbols.vala"
	_vala_package = _tmp12_;
#line 236 "symbols.vala"
	result = TRUE;
#line 236 "symbols.vala"
	normal_symbols_symbol_info_destroy (&info);
#line 236 "symbols.vala"
	if (command) {
#line 236 "symbols.vala"
		*command = _vala_command;
#line 1116 "symbols.c"
	} else {
#line 236 "symbols.vala"
		_g_free0 (_vala_command);
#line 1120 "symbols.c"
	}
#line 236 "symbols.vala"
	if (package) {
#line 236 "symbols.vala"
		*package = _vala_package;
#line 1126 "symbols.c"
	} else {
#line 236 "symbols.vala"
		_g_free0 (_vala_package);
#line 1130 "symbols.c"
	}
#line 236 "symbols.vala"
	return result;
#line 1134 "symbols.c"
}

static void
_normal_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                const gchar* element_name,
                                                                gchar** attribute_names,
                                                                gchar** attribute_values,
                                                                gpointer self,
                                                                GError** error)
{
#line 249 "symbols.vala"
	normal_symbols_parser_start ((NormalSymbols*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
#line 1147 "symbols.c"
}

static void
normal_symbols_load_symbols (NormalSymbols* self)
{
	const gchar* contents = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
#line 239 "symbols.vala"
	g_return_if_fail (self != NULL);
#line 241 "symbols.vala"
	_tmp0_ = self->priv->_resource_path;
#line 241 "symbols.vala"
	_tmp1_ = g_strconcat (_tmp0_, "data.xml", NULL);
#line 241 "symbols.vala"
	_tmp2_ = _tmp1_;
#line 241 "symbols.vala"
	_tmp3_ = utils_get_string_from_resource (_tmp2_);
#line 241 "symbols.vala"
	_tmp4_ = _tmp3_;
#line 241 "symbols.vala"
	_g_free0 (_tmp2_);
#line 241 "symbols.vala"
	contents = _tmp4_;
#line 244 "symbols.vala"
	_tmp5_ = contents;
#line 244 "symbols.vala"
	if (_tmp5_ == NULL) {
#line 245 "symbols.vala"
		return;
#line 1183 "symbols.c"
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp6_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp7_;
		GMarkupParseContext* _tmp8_;
		GMarkupParseContext* _tmp9_;
		const gchar* _tmp10_;
#line 249 "symbols.vala"
		_tmp6_.start_element = _normal_symbols_parser_start_gmarkup_parser_start_element_func;
#line 249 "symbols.vala"
		_tmp6_.end_element = NULL;
#line 249 "symbols.vala"
		_tmp6_.text = NULL;
#line 249 "symbols.vala"
		_tmp6_.passthrough = NULL;
#line 249 "symbols.vala"
		_tmp6_.error = NULL;
#line 249 "symbols.vala"
		parser = _tmp6_;
#line 250 "symbols.vala"
		_tmp7_ = parser;
#line 250 "symbols.vala"
		_tmp8_ = g_markup_parse_context_new (&_tmp7_, 0, self, NULL);
#line 250 "symbols.vala"
		context = _tmp8_;
#line 251 "symbols.vala"
		_tmp9_ = context;
#line 251 "symbols.vala"
		_tmp10_ = contents;
#line 251 "symbols.vala"
		g_markup_parse_context_parse (_tmp9_, _tmp10_, (gssize) -1, &_inner_error0_);
#line 251 "symbols.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 251 "symbols.vala"
			_g_markup_parse_context_unref0 (context);
#line 1221 "symbols.c"
			goto __catch44_g_error;
		}
#line 247 "symbols.vala"
		_g_markup_parse_context_unref0 (context);
#line 1226 "symbols.c"
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 247 "symbols.vala"
		e = _inner_error0_;
#line 247 "symbols.vala"
		_inner_error0_ = NULL;
#line 255 "symbols.vala"
		_tmp11_ = e;
#line 255 "symbols.vala"
		_tmp12_ = _tmp11_->message;
#line 255 "symbols.vala"
		g_warning ("symbols.vala:255: Impossible to load the symbols: %s", _tmp12_);
#line 247 "symbols.vala"
		_g_error_free0 (e);
#line 1246 "symbols.c"
	}
	__finally44:
#line 247 "symbols.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 247 "symbols.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 247 "symbols.vala"
		g_clear_error (&_inner_error0_);
#line 247 "symbols.vala"
		return;
#line 1257 "symbols.c"
	}
}

static void
normal_symbols_add_symbol (NormalSymbols* self,
                           const gchar* icon_file,
                           NormalSymbolsSymbolInfo* symbol)
{
	GeeMap* _tmp0_;
	NormalSymbolsSymbolInfo _tmp1_;
	gchar* tooltip = NULL;
	NormalSymbolsSymbolInfo _tmp2_;
	const gchar* _tmp3_;
	NormalSymbolsSymbolInfo _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* id = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp12_ = {0};
	GtkTreeIter _tmp13_;
	GdkPixbuf* _tmp14_;
	NormalSymbolsSymbolInfo _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
#line 259 "symbols.vala"
	g_return_if_fail (self != NULL);
#line 259 "symbols.vala"
	g_return_if_fail (icon_file != NULL);
#line 259 "symbols.vala"
	g_return_if_fail (symbol != NULL);
#line 261 "symbols.vala"
	_tmp0_ = self->priv->_data;
#line 261 "symbols.vala"
	_tmp1_ = *symbol;
#line 261 "symbols.vala"
	gee_map_set (_tmp0_, icon_file, &_tmp1_);
#line 263 "symbols.vala"
	_tmp2_ = *symbol;
#line 263 "symbols.vala"
	_tmp3_ = _tmp2_.latex_command;
#line 263 "symbols.vala"
	_tmp4_ = *symbol;
#line 263 "symbols.vala"
	_tmp5_ = _tmp4_.package_required;
#line 263 "symbols.vala"
	_tmp6_ = symbols_get_tooltip (_tmp3_, _tmp5_);
#line 263 "symbols.vala"
	tooltip = _tmp6_;
#line 266 "symbols.vala"
	_tmp7_ = self->priv->_category_id;
#line 266 "symbols.vala"
	_tmp8_ = g_strdup_printf ("%s/%s", _tmp7_, icon_file);
#line 266 "symbols.vala"
	id = _tmp8_;
#line 268 "symbols.vala"
	_tmp9_ = id;
#line 268 "symbols.vala"
	_tmp10_ = symbols_get_pixbuf (_tmp9_);
#line 268 "symbols.vala"
	pixbuf = _tmp10_;
#line 269 "symbols.vala"
	_tmp11_ = pixbuf;
#line 269 "symbols.vala"
	if (_tmp11_ == NULL) {
#line 270 "symbols.vala"
		_g_object_unref0 (pixbuf);
#line 270 "symbols.vala"
		_g_free0 (id);
#line 270 "symbols.vala"
		_g_free0 (tooltip);
#line 270 "symbols.vala"
		return;
#line 1337 "symbols.c"
	}
#line 273 "symbols.vala"
	gtk_list_store_append ((GtkListStore*) self, &_tmp12_);
#line 273 "symbols.vala"
	iter = _tmp12_;
#line 274 "symbols.vala"
	_tmp13_ = iter;
#line 274 "symbols.vala"
	_tmp14_ = pixbuf;
#line 274 "symbols.vala"
	_tmp15_ = *symbol;
#line 274 "symbols.vala"
	_tmp16_ = _tmp15_.latex_command;
#line 274 "symbols.vala"
	_tmp17_ = tooltip;
#line 274 "symbols.vala"
	_tmp18_ = id;
#line 274 "symbols.vala"
	gtk_list_store_set ((GtkListStore*) self, &_tmp13_, SYMBOL_COLUMN_PIXBUF, _tmp14_, SYMBOL_COLUMN_COMMAND, _tmp16_, SYMBOL_COLUMN_TOOLTIP, _tmp17_, SYMBOL_COLUMN_ID, _tmp18_, -1);
#line 259 "symbols.vala"
	_g_object_unref0 (pixbuf);
#line 259 "symbols.vala"
	_g_free0 (id);
#line 259 "symbols.vala"
	_g_free0 (tooltip);
#line 1363 "symbols.c"
}

static void
normal_symbols_parser_start (NormalSymbols* self,
                             GMarkupParseContext* context,
                             const gchar* name,
                             gchar** attr_names,
                             gint attr_names_length1,
                             gchar** attr_values,
                             gint attr_values_length1,
                             GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 285 "symbols.vala"
	static GQuark _tmp1_label0 = 0;
#line 285 "symbols.vala"
	static GQuark _tmp1_label1 = 0;
#line 1382 "symbols.c"
	GError* _inner_error0_ = NULL;
#line 282 "symbols.vala"
	g_return_if_fail (self != NULL);
#line 282 "symbols.vala"
	g_return_if_fail (context != NULL);
#line 282 "symbols.vala"
	g_return_if_fail (name != NULL);
#line 285 "symbols.vala"
	_tmp0_ = name;
#line 285 "symbols.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 285 "symbols.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("symbols")))) {
#line 285 "symbols.vala"
		switch (0) {
#line 1398 "symbols.c"
			default:
			{
#line 288 "symbols.vala"
				return;
#line 1403 "symbols.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("symbol")))) {
#line 285 "symbols.vala"
		switch (0) {
#line 1409 "symbols.c"
			default:
			{
				NormalSymbolsSymbolInfo symbol = {0};
				gchar* icon_file = NULL;
				const gchar* _tmp22_;
				NormalSymbolsSymbolInfo _tmp23_;
#line 291 "symbols.vala"
				memset (&symbol, 0, sizeof (NormalSymbolsSymbolInfo));
#line 292 "symbols.vala"
				_g_free0 (symbol.package_required);
#line 292 "symbols.vala"
				symbol.package_required = NULL;
#line 293 "symbols.vala"
				icon_file = NULL;
#line 1424 "symbols.c"
				{
					gint i = 0;
#line 295 "symbols.vala"
					i = 0;
#line 1429 "symbols.c"
					{
						gboolean _tmp3_ = FALSE;
#line 295 "symbols.vala"
						_tmp3_ = TRUE;
#line 295 "symbols.vala"
						while (TRUE) {
#line 1436 "symbols.c"
							const gchar* _tmp5_;
							const gchar* _tmp6_;
							GQuark _tmp8_ = 0U;
#line 297 "symbols.vala"
							static GQuark _tmp7_label0 = 0;
#line 297 "symbols.vala"
							static GQuark _tmp7_label1 = 0;
#line 297 "symbols.vala"
							static GQuark _tmp7_label2 = 0;
#line 295 "symbols.vala"
							if (!_tmp3_) {
#line 1448 "symbols.c"
								gint _tmp4_;
#line 295 "symbols.vala"
								_tmp4_ = i;
#line 295 "symbols.vala"
								i = _tmp4_ + 1;
#line 1454 "symbols.c"
							}
#line 295 "symbols.vala"
							_tmp3_ = FALSE;
#line 295 "symbols.vala"
							if (!(i < attr_names_length1)) {
#line 295 "symbols.vala"
								break;
#line 1462 "symbols.c"
							}
#line 297 "symbols.vala"
							_tmp5_ = attr_names[i];
#line 297 "symbols.vala"
							_tmp6_ = _tmp5_;
#line 297 "symbols.vala"
							_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
#line 297 "symbols.vala"
							if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("file")))) {
#line 297 "symbols.vala"
								switch (0) {
#line 1474 "symbols.c"
									default:
									{
										const gchar* _tmp9_;
										gchar* _tmp10_;
#line 300 "symbols.vala"
										_tmp9_ = attr_values[i];
#line 300 "symbols.vala"
										_tmp10_ = g_strdup (_tmp9_);
#line 300 "symbols.vala"
										_g_free0 (icon_file);
#line 300 "symbols.vala"
										icon_file = _tmp10_;
#line 301 "symbols.vala"
										break;
#line 1489 "symbols.c"
									}
								}
							} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("command")))) {
#line 297 "symbols.vala"
								switch (0) {
#line 1495 "symbols.c"
									default:
									{
										const gchar* _tmp11_;
										gchar* _tmp12_;
#line 304 "symbols.vala"
										_tmp11_ = attr_values[i];
#line 304 "symbols.vala"
										_tmp12_ = g_strdup (_tmp11_);
#line 304 "symbols.vala"
										_g_free0 (symbol.latex_command);
#line 304 "symbols.vala"
										symbol.latex_command = _tmp12_;
#line 305 "symbols.vala"
										break;
#line 1510 "symbols.c"
									}
								}
							} else if (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("package")))) {
#line 297 "symbols.vala"
								switch (0) {
#line 1516 "symbols.c"
									default:
									{
										const gchar* _tmp13_;
										gchar* _tmp14_;
#line 308 "symbols.vala"
										_tmp13_ = attr_values[i];
#line 308 "symbols.vala"
										_tmp14_ = g_strdup (_tmp13_);
#line 308 "symbols.vala"
										_g_free0 (symbol.package_required);
#line 308 "symbols.vala"
										symbol.package_required = _tmp14_;
#line 309 "symbols.vala"
										break;
#line 1531 "symbols.c"
									}
								}
							} else {
#line 297 "symbols.vala"
								switch (0) {
#line 1537 "symbols.c"
									default:
									{
										const gchar* _tmp15_;
										gchar* _tmp16_;
										gchar* _tmp17_;
										gchar* _tmp18_;
										gchar* _tmp19_;
										GError* _tmp20_;
										GError* _tmp21_;
#line 312 "symbols.vala"
										_tmp15_ = attr_names[i];
#line 312 "symbols.vala"
										_tmp16_ = g_strconcat ("unknown attribute \"", _tmp15_, NULL);
#line 312 "symbols.vala"
										_tmp17_ = _tmp16_;
#line 312 "symbols.vala"
										_tmp18_ = g_strconcat (_tmp17_, "\"", NULL);
#line 312 "symbols.vala"
										_tmp19_ = _tmp18_;
#line 312 "symbols.vala"
										_tmp20_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp19_);
#line 312 "symbols.vala"
										_tmp21_ = _tmp20_;
#line 312 "symbols.vala"
										_g_free0 (_tmp19_);
#line 312 "symbols.vala"
										_g_free0 (_tmp17_);
#line 312 "symbols.vala"
										_inner_error0_ = _tmp21_;
#line 312 "symbols.vala"
										if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 312 "symbols.vala"
											g_propagate_error (error, _inner_error0_);
#line 312 "symbols.vala"
											_g_free0 (icon_file);
#line 312 "symbols.vala"
											normal_symbols_symbol_info_destroy (&symbol);
#line 312 "symbols.vala"
											return;
#line 1577 "symbols.c"
										} else {
#line 312 "symbols.vala"
											_g_free0 (icon_file);
#line 312 "symbols.vala"
											normal_symbols_symbol_info_destroy (&symbol);
#line 312 "symbols.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 312 "symbols.vala"
											g_clear_error (&_inner_error0_);
#line 312 "symbols.vala"
											return;
#line 1589 "symbols.c"
										}
									}
								}
							}
						}
					}
				}
#line 317 "symbols.vala"
				_tmp22_ = icon_file;
#line 317 "symbols.vala"
				_tmp23_ = symbol;
#line 317 "symbols.vala"
				normal_symbols_add_symbol (self, _tmp22_, &_tmp23_);
#line 318 "symbols.vala"
				_g_free0 (icon_file);
#line 318 "symbols.vala"
				normal_symbols_symbol_info_destroy (&symbol);
#line 318 "symbols.vala"
				break;
#line 1609 "symbols.c"
			}
		}
	} else {
#line 285 "symbols.vala"
		switch (0) {
#line 1615 "symbols.c"
			default:
			{
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				GError* _tmp28_;
				GError* _tmp29_;
#line 321 "symbols.vala"
				_tmp24_ = g_strconcat ("unknown element \"", name, NULL);
#line 321 "symbols.vala"
				_tmp25_ = _tmp24_;
#line 321 "symbols.vala"
				_tmp26_ = g_strconcat (_tmp25_, "\"", NULL);
#line 321 "symbols.vala"
				_tmp27_ = _tmp26_;
#line 321 "symbols.vala"
				_tmp28_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp27_);
#line 321 "symbols.vala"
				_tmp29_ = _tmp28_;
#line 321 "symbols.vala"
				_g_free0 (_tmp27_);
#line 321 "symbols.vala"
				_g_free0 (_tmp25_);
#line 321 "symbols.vala"
				_inner_error0_ = _tmp29_;
#line 321 "symbols.vala"
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 321 "symbols.vala"
					g_propagate_error (error, _inner_error0_);
#line 321 "symbols.vala"
					return;
#line 1648 "symbols.c"
				} else {
#line 321 "symbols.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 321 "symbols.vala"
					g_clear_error (&_inner_error0_);
#line 321 "symbols.vala"
					return;
#line 1656 "symbols.c"
				}
			}
		}
	}
}

static void
normal_symbols_symbol_info_copy (const NormalSymbolsSymbolInfo* self,
                                 NormalSymbolsSymbolInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 193 "symbols.vala"
	_tmp0_ = (*self).latex_command;
#line 193 "symbols.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 193 "symbols.vala"
	_g_free0 ((*dest).latex_command);
#line 193 "symbols.vala"
	(*dest).latex_command = _tmp1_;
#line 193 "symbols.vala"
	_tmp2_ = (*self).package_required;
#line 193 "symbols.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 193 "symbols.vala"
	_g_free0 ((*dest).package_required);
#line 193 "symbols.vala"
	(*dest).package_required = _tmp3_;
#line 1687 "symbols.c"
}

static void
normal_symbols_symbol_info_destroy (NormalSymbolsSymbolInfo* self)
{
#line 195 "symbols.vala"
	_g_free0 ((*self).latex_command);
#line 196 "symbols.vala"
	_g_free0 ((*self).package_required);
#line 1697 "symbols.c"
}

static NormalSymbolsSymbolInfo*
normal_symbols_symbol_info_dup (const NormalSymbolsSymbolInfo* self)
{
	NormalSymbolsSymbolInfo* dup;
#line 193 "symbols.vala"
	dup = g_new0 (NormalSymbolsSymbolInfo, 1);
#line 193 "symbols.vala"
	normal_symbols_symbol_info_copy (self, dup);
#line 193 "symbols.vala"
	return dup;
#line 1710 "symbols.c"
}

static void
normal_symbols_symbol_info_free (NormalSymbolsSymbolInfo* self)
{
#line 193 "symbols.vala"
	normal_symbols_symbol_info_destroy (self);
#line 193 "symbols.vala"
	g_free (self);
#line 1720 "symbols.c"
}

static GType
normal_symbols_symbol_info_get_type (void)
{
	static volatile gsize normal_symbols_symbol_info_type_id__volatile = 0;
	if (g_once_init_enter (&normal_symbols_symbol_info_type_id__volatile)) {
		GType normal_symbols_symbol_info_type_id;
		normal_symbols_symbol_info_type_id = g_boxed_type_register_static ("NormalSymbolsSymbolInfo", (GBoxedCopyFunc) normal_symbols_symbol_info_dup, (GBoxedFreeFunc) normal_symbols_symbol_info_free);
		g_once_init_leave (&normal_symbols_symbol_info_type_id__volatile, normal_symbols_symbol_info_type_id);
	}
	return normal_symbols_symbol_info_type_id__volatile;
}

static void
normal_symbols_class_init (NormalSymbolsClass * klass,
                           gpointer klass_data)
{
#line 191 "symbols.vala"
	normal_symbols_parent_class = g_type_class_peek_parent (klass);
#line 191 "symbols.vala"
	g_type_class_adjust_private_offset (klass, &NormalSymbols_private_offset);
#line 191 "symbols.vala"
	G_OBJECT_CLASS (klass)->finalize = normal_symbols_finalize;
#line 1745 "symbols.c"
}

static void
normal_symbols_instance_init (NormalSymbols * self,
                              gpointer klass)
{
#line 191 "symbols.vala"
	self->priv = normal_symbols_get_instance_private (self);
#line 1754 "symbols.c"
}

static void
normal_symbols_finalize (GObject * obj)
{
	NormalSymbols * self;
#line 191 "symbols.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NORMAL_SYMBOLS, NormalSymbols);
#line 199 "symbols.vala"
	_g_free0 (self->priv->_category_id);
#line 200 "symbols.vala"
	_g_free0 (self->priv->_resource_path);
#line 203 "symbols.vala"
	_g_object_unref0 (self->priv->_data);
#line 191 "symbols.vala"
	G_OBJECT_CLASS (normal_symbols_parent_class)->finalize (obj);
#line 1771 "symbols.c"
}

GType
normal_symbols_get_type (void)
{
	static volatile gsize normal_symbols_type_id__volatile = 0;
	if (g_once_init_enter (&normal_symbols_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NormalSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) normal_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NormalSymbols), 0, (GInstanceInitFunc) normal_symbols_instance_init, NULL };
		GType normal_symbols_type_id;
		normal_symbols_type_id = g_type_register_static (gtk_list_store_get_type (), "NormalSymbols", &g_define_type_info, 0);
		NormalSymbols_private_offset = g_type_add_instance_private (normal_symbols_type_id, sizeof (NormalSymbolsPrivate));
		g_once_init_leave (&normal_symbols_type_id__volatile, normal_symbols_type_id);
	}
	return normal_symbols_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 183 "project_dialogs.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1795 "symbols.c"
		int i;
#line 183 "project_dialogs.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 183 "project_dialogs.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 183 "project_dialogs.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1803 "symbols.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 183 "project_dialogs.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 183 "project_dialogs.vala"
	g_free (array);
#line 1818 "symbols.c"
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 183 "project_dialogs.vala"
	if (array) {
#line 183 "project_dialogs.vala"
		while (((gpointer*) array)[length]) {
#line 183 "project_dialogs.vala"
			length++;
#line 1832 "symbols.c"
		}
	}
#line 183 "project_dialogs.vala"
	return length;
#line 1837 "symbols.c"
}

