/* structure_model.c generated by valac 0.46.6, the Vala compiler
 * generated from structure_model.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;
typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())
typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
typedef struct _StructureModelPrivate StructureModelPrivate;
enum  {
	STRUCTURE_MODEL_0_PROPERTY,
	STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY,
	STRUCTURE_MODEL_NUM_PROPERTIES
};
static GParamSpec* structure_model_properties[STRUCTURE_MODEL_NUM_PROPERTIES];
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
struct _StructureModel {
	GObject parent_instance;
	StructureModelPrivate * priv;
};

struct _StructureModelClass {
	GObjectClass parent_class;
};

struct _StructureModelPrivate {
	gboolean _emit_signals;
	GType* _column_types;
	gint _column_types_length1;
	gint __column_types_size_;
	GNode* _tree;
	gint _stamp;
	guint _nb_nodes;
	GNode* _end_node;
	GeeArrayList* _list_labels;
	GeeArrayList* _list_includes;
	GeeArrayList* _list_tables;
	GeeArrayList* _list_figures;
	GeeArrayList* _list_todos_and_fixmes;
};

static gint StructureModel_private_offset;
static gpointer structure_model_parent_class = NULL;
static GtkTreeModelIface * structure_model_gtk_tree_model_parent_iface = NULL;

GType struct_data_get_type (void) G_GNUC_CONST;
GType struct_type_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self,
                       StructData* dest);
void struct_data_destroy (StructData* self);
GType struct_column_get_type (void) G_GNUC_CONST;
GType struct_list_column_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
GType structure_model_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StructureModel, g_object_unref)
static void _struct_data_free0_ (gpointer var);
static gboolean _g_node_free_all_node (GNode* node,
                                GDestroyNotify free_func);
static void _g_node_free_all (GNode* self,
                       GDestroyNotify free_func);
static inline void _g_node_destroy__struct_data_free0_ (GNode* self);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void structure_model_new_stamp (StructureModel* self);
static void structure_model_reset_simple_lists (StructureModel* self);
static GtkTreeIter* structure_model_create_iter_at_node (StructureModel* self,
                                                  GNode* node);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static gboolean structure_model_iter_is_valid (StructureModel* self,
                                        GtkTreeIter* iter);
static GNode* structure_model_get_node_from_iter (StructureModel* self,
                                           GtkTreeIter* iter);
static gboolean structure_model_column_is_valid (StructureModel* self,
                                          gint index);
static GType structure_model_real_get_column_type (GtkTreeModel* base,
                                            gint index);
static gint structure_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreeModelFlags structure_model_real_get_flags (GtkTreeModel* base);
static gboolean structure_model_real_iter_has_child (GtkTreeModel* base,
                                              GtkTreeIter* iter);
static gint structure_model_real_iter_n_children (GtkTreeModel* base,
                                           GtkTreeIter* iter);
static void structure_model_real_get_value (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     gint column,
                                     GValue* val);
gchar* structure_get_icon_from_type (StructType type);
gchar* structure_get_type_name (StructType type);
static gboolean structure_model_real_iter_children (GtkTreeModel* base,
                                             GtkTreeIter* iter,
                                             GtkTreeIter* parent);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static gboolean structure_model_real_iter_next (GtkTreeModel* base,
                                         GtkTreeIter* iter);
static gboolean structure_model_real_iter_nth_child (GtkTreeModel* base,
                                              GtkTreeIter* iter,
                                              GtkTreeIter* parent,
                                              gint n);
static gboolean structure_model_real_iter_parent (GtkTreeModel* base,
                                           GtkTreeIter* iter,
                                           GtkTreeIter* child);
static gboolean structure_model_real_get_iter (GtkTreeModel* base,
                                        GtkTreeIter* iter,
                                        GtkTreePath* path);
static GtkTreePath* structure_model_real_get_path (GtkTreeModel* base,
                                            GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
guint structure_model_get_nb_items (StructureModel* self);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self,
                                              StructData* item);
static void structure_model_search_end_node (StructureModel* self);
gboolean structure_is_section (StructType type);
static GtkTreeIter* structure_model_insert_item_after (StructureModel* self,
                                                GNode* parent,
                                                GNode* sibling,
                                                StructData* item);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self,
                                                         GtkTreeIter* section_iter,
                                                         GError** error);
void structure_model_delete (StructureModel* self,
                             GtkTreeIter* iter);
static GNode* structure_model_delete_node (StructureModel* self,
                                    GNode* node);
static void structure_model_regenerate_simple_lists (StructureModel* self);
void structure_model_modify_data (StructureModel* self,
                                  GtkTreePath* path,
                                  const gchar* text,
                                  GtkTextMark* end_mark);
gboolean structure_model_get_emit_signals (StructureModel* self);
static void structure_model_make_children_between_marks (StructureModel* self,
                                                  GNode* node);
void structure_model_shift_right (StructureModel* self,
                                  GtkTreeIter* iter);
static void structure_model_shift_node (StructureModel* self,
                                 GNode* node,
                                 gboolean shift_right);
static void structure_model_reinsert_node (StructureModel* self,
                                    GNode* node,
                                    gboolean force_first_child);
void structure_model_shift_left (StructureModel* self,
                                 GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self,
                                                     GtkTreeIter* iter);
static gboolean structure_model_node_contains_subparagraph (StructureModel* self,
                                                     GNode* node);
static void structure_model_insert_node (StructureModel* self,
                                  GNode* node,
                                  gboolean force_first_child);
static void structure_model_insert_node_in_list (StructureModel* self,
                                          GNode* node);
static gint structure_model_compare_nodes (GtkTextMark* mark1,
                                    GtkTextMark* mark2);
void structure_model_populate_list (StructureModel* self,
                                    GtkListStore* store,
                                    StructType type);
static GeeArrayList* structure_model_get_list (StructureModel* self,
                                        StructType type);
GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self,
                                                          StructType list_type,
                                                          gint num);
gint structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                                  GtkTreeIter* tree_iter);
static gboolean __lambda42_ (StructureModel* self,
                      GNode* node);
static gboolean ___lambda42__gnode_traverse_func (GNode* node,
                                           gpointer self);
void structure_model_set_emit_signals (StructureModel* self,
                                       gboolean value);
static void structure_model_finalize (GObject * obj);
static void _vala_structure_model_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_structure_model_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static gpointer
_g_object_ref0 (gpointer self)
{
#line 38 "structure_model.vala"
	return self ? g_object_ref (self) : NULL;
#line 288 "structure_model.c"
}

void
struct_data_copy (const StructData* self,
                  StructData* dest)
{
	StructType _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextMark* _tmp5_;
	GtkTextMark* _tmp6_;
#line 38 "structure_model.vala"
	_tmp0_ = (*self).type;
#line 38 "structure_model.vala"
	(*dest).type = _tmp0_;
#line 38 "structure_model.vala"
	_tmp1_ = (*self).text;
#line 38 "structure_model.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 38 "structure_model.vala"
	_g_free0 ((*dest).text);
#line 38 "structure_model.vala"
	(*dest).text = _tmp2_;
#line 38 "structure_model.vala"
	_tmp3_ = (*self).start_mark;
#line 38 "structure_model.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 38 "structure_model.vala"
	_g_object_unref0 ((*dest).start_mark);
#line 38 "structure_model.vala"
	(*dest).start_mark = _tmp4_;
#line 38 "structure_model.vala"
	_tmp5_ = (*self).end_mark;
#line 38 "structure_model.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 38 "structure_model.vala"
	_g_object_unref0 ((*dest).end_mark);
#line 38 "structure_model.vala"
	(*dest).end_mark = _tmp6_;
#line 330 "structure_model.c"
}

void
struct_data_destroy (StructData* self)
{
#line 41 "structure_model.vala"
	_g_free0 ((*self).text);
#line 42 "structure_model.vala"
	_g_object_unref0 ((*self).start_mark);
#line 43 "structure_model.vala"
	_g_object_unref0 ((*self).end_mark);
#line 342 "structure_model.c"
}

StructData*
struct_data_dup (const StructData* self)
{
	StructData* dup;
#line 38 "structure_model.vala"
	dup = g_new0 (StructData, 1);
#line 38 "structure_model.vala"
	struct_data_copy (self, dup);
#line 38 "structure_model.vala"
	return dup;
#line 355 "structure_model.c"
}

void
struct_data_free (StructData* self)
{
#line 38 "structure_model.vala"
	struct_data_destroy (self);
#line 38 "structure_model.vala"
	g_free (self);
#line 365 "structure_model.c"
}

GType
struct_data_get_type (void)
{
	static volatile gsize struct_data_type_id__volatile = 0;
	if (g_once_init_enter (&struct_data_type_id__volatile)) {
		GType struct_data_type_id;
		struct_data_type_id = g_boxed_type_register_static ("StructData", (GBoxedCopyFunc) struct_data_dup, (GBoxedFreeFunc) struct_data_free);
		g_once_init_leave (&struct_data_type_id__volatile, struct_data_type_id);
	}
	return struct_data_type_id__volatile;
}

GType
struct_column_get_type (void)
{
	static volatile gsize struct_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_COLUMN_PIXBUF, "STRUCT_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_COLUMN_TEXT, "STRUCT_COLUMN_TEXT", "text"}, {STRUCT_COLUMN_TOOLTIP, "STRUCT_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_COLUMN_START_MARK, "STRUCT_COLUMN_START_MARK", "start-mark"}, {STRUCT_COLUMN_END_MARK, "STRUCT_COLUMN_END_MARK", "end-mark"}, {STRUCT_COLUMN_TYPE, "STRUCT_COLUMN_TYPE", "type"}, {STRUCT_COLUMN_N_COLUMNS, "STRUCT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_column_type_id;
		struct_column_type_id = g_enum_register_static ("StructColumn", values);
		g_once_init_leave (&struct_column_type_id__volatile, struct_column_type_id);
	}
	return struct_column_type_id__volatile;
}

GType
struct_list_column_get_type (void)
{
	static volatile gsize struct_list_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_list_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_LIST_COLUMN_PIXBUF, "STRUCT_LIST_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_LIST_COLUMN_TEXT, "STRUCT_LIST_COLUMN_TEXT", "text"}, {STRUCT_LIST_COLUMN_TOOLTIP, "STRUCT_LIST_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_LIST_COLUMN_N_COLUMNS, "STRUCT_LIST_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_list_column_type_id;
		struct_list_column_type_id = g_enum_register_static ("StructListColumn", values);
		g_once_init_leave (&struct_list_column_type_id__volatile, struct_list_column_type_id);
	}
	return struct_list_column_type_id__volatile;
}

GQuark
struct_error_quark (void)
{
#line 183 "project_dialogs.vala"
	return g_quark_from_static_string ("struct-error-quark");
#line 411 "structure_model.c"
}

static inline gpointer
structure_model_get_instance_private (StructureModel* self)
{
	return G_STRUCT_MEMBER_P (self, StructureModel_private_offset);
}

static void
_struct_data_free0_ (gpointer var)
{
#line 78 "structure_model.vala"
	(var == NULL) ? NULL : (var = (struct_data_free (var), NULL));
#line 425 "structure_model.c"
}

static gboolean
_g_node_free_all_node (GNode* node,
                       GDestroyNotify free_func)
{
#line 78 "structure_model.vala"
	(node->data == NULL) ? NULL : free_func (node->data);
#line 78 "structure_model.vala"
	return FALSE;
#line 436 "structure_model.c"
}

static void
_g_node_free_all (GNode* self,
                  GDestroyNotify free_func)
{
#line 78 "structure_model.vala"
	(free_func == NULL) ? NULL : g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, (GNodeTraverseFunc) _g_node_free_all_node, free_func);
#line 78 "structure_model.vala"
	g_node_destroy (self);
#line 447 "structure_model.c"
}

static inline void
_g_node_destroy__struct_data_free0_ (GNode* self)
{
#line 78 "structure_model.vala"
	_g_node_free_all (self, (GDestroyNotify) _struct_data_free0_);
#line 455 "structure_model.c"
}

static gpointer
_struct_data_dup0 (gpointer self)
{
#line 100 "structure_model.vala"
	return self ? struct_data_dup (self) : NULL;
#line 463 "structure_model.c"
}

StructureModel*
structure_model_construct (GType object_type)
{
	StructureModel * self = NULL;
	GType* _tmp0_;
	GType* _tmp1_;
	gint _tmp1__length1;
	GType* _tmp2_;
	gint _tmp2__length1;
	GType* _tmp3_;
	gint _tmp3__length1;
	GType* _tmp4_;
	gint _tmp4__length1;
	GType* _tmp5_;
	gint _tmp5__length1;
	GType* _tmp6_;
	gint _tmp6__length1;
	StructData empty_data = {0};
	StructData _tmp7_ = {0};
	StructData _tmp8_;
	StructData _tmp9_;
	StructData* _tmp10_;
	GNode* _tmp11_;
#line 89 "structure_model.vala"
	self = (StructureModel*) g_object_new (object_type, NULL);
#line 91 "structure_model.vala"
	_tmp0_ = g_new0 (GType, STRUCT_COLUMN_N_COLUMNS);
#line 91 "structure_model.vala"
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
#line 91 "structure_model.vala"
	self->priv->_column_types = _tmp0_;
#line 91 "structure_model.vala"
	self->priv->_column_types_length1 = STRUCT_COLUMN_N_COLUMNS;
#line 91 "structure_model.vala"
	self->priv->__column_types_size_ = self->priv->_column_types_length1;
#line 92 "structure_model.vala"
	_tmp1_ = self->priv->_column_types;
#line 92 "structure_model.vala"
	_tmp1__length1 = self->priv->_column_types_length1;
#line 92 "structure_model.vala"
	_tmp1_[STRUCT_COLUMN_PIXBUF] = G_TYPE_STRING;
#line 93 "structure_model.vala"
	_tmp2_ = self->priv->_column_types;
#line 93 "structure_model.vala"
	_tmp2__length1 = self->priv->_column_types_length1;
#line 93 "structure_model.vala"
	_tmp2_[STRUCT_COLUMN_TEXT] = G_TYPE_STRING;
#line 94 "structure_model.vala"
	_tmp3_ = self->priv->_column_types;
#line 94 "structure_model.vala"
	_tmp3__length1 = self->priv->_column_types_length1;
#line 94 "structure_model.vala"
	_tmp3_[STRUCT_COLUMN_TOOLTIP] = G_TYPE_STRING;
#line 95 "structure_model.vala"
	_tmp4_ = self->priv->_column_types;
#line 95 "structure_model.vala"
	_tmp4__length1 = self->priv->_column_types_length1;
#line 95 "structure_model.vala"
	_tmp4_[STRUCT_COLUMN_START_MARK] = gtk_text_mark_get_type ();
#line 96 "structure_model.vala"
	_tmp5_ = self->priv->_column_types;
#line 96 "structure_model.vala"
	_tmp5__length1 = self->priv->_column_types_length1;
#line 96 "structure_model.vala"
	_tmp5_[STRUCT_COLUMN_END_MARK] = gtk_text_mark_get_type ();
#line 97 "structure_model.vala"
	_tmp6_ = self->priv->_column_types;
#line 97 "structure_model.vala"
	_tmp6__length1 = self->priv->_column_types_length1;
#line 97 "structure_model.vala"
	_tmp6_[STRUCT_COLUMN_TYPE] = TYPE_STRUCT_TYPE;
#line 99 "structure_model.vala"
	empty_data = _tmp7_;
#line 100 "structure_model.vala"
	_tmp8_ = empty_data;
#line 100 "structure_model.vala"
	_tmp9_ = _tmp8_;
#line 100 "structure_model.vala"
	_tmp10_ = _struct_data_dup0 (&_tmp9_);
#line 100 "structure_model.vala"
	_tmp11_ = g_node_new (_tmp10_);
#line 100 "structure_model.vala"
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
#line 100 "structure_model.vala"
	self->priv->_tree = _tmp11_;
#line 102 "structure_model.vala"
	structure_model_new_stamp (self);
#line 103 "structure_model.vala"
	structure_model_reset_simple_lists (self);
#line 89 "structure_model.vala"
	struct_data_destroy (&empty_data);
#line 89 "structure_model.vala"
	return self;
#line 559 "structure_model.c"
}

StructureModel*
structure_model_new (void)
{
#line 89 "structure_model.vala"
	return structure_model_construct (TYPE_STRUCTURE_MODEL);
#line 567 "structure_model.c"
}

static void
structure_model_new_stamp (StructureModel* self)
{
#line 107 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 109 "structure_model.vala"
	self->priv->_stamp = (gint) g_random_int ();
#line 577 "structure_model.c"
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
#line 119 "structure_model.vala"
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
#line 585 "structure_model.c"
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
#line 119 "structure_model.vala"
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
#line 593 "structure_model.c"
}

static GtkTreeIter*
structure_model_create_iter_at_node (StructureModel* self,
                                     GNode* node)
{
	GNode* _tmp0_;
	GtkTreeIter new_iter = {0};
	GtkTreeIter* _tmp1_;
	GtkTreeIter* result = NULL;
#line 112 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 112 "structure_model.vala"
	g_return_val_if_fail (node != NULL, NULL);
#line 114 "structure_model.vala"
	_tmp0_ = self->priv->_tree;
#line 114 "structure_model.vala"
	g_return_val_if_fail (node != _tmp0_, NULL);
#line 116 "structure_model.vala"
	memset (&new_iter, 0, sizeof (GtkTreeIter));
#line 117 "structure_model.vala"
	new_iter.stamp = self->priv->_stamp;
#line 118 "structure_model.vala"
	new_iter.user_data = node;
#line 119 "structure_model.vala"
	_tmp1_ = __vala_GtkTreeIter_copy0 (&new_iter);
#line 119 "structure_model.vala"
	result = _tmp1_;
#line 119 "structure_model.vala"
	return result;
#line 624 "structure_model.c"
}

static gboolean
structure_model_iter_is_valid (StructureModel* self,
                               GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_;
	void* _tmp2_;
	GNode* node = NULL;
	GtkTreeIter _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	gconstpointer _tmp6_;
	StructData data = {0};
	GNode* _tmp7_;
	gconstpointer _tmp8_;
	StructData _tmp9_;
	StructData _tmp10_ = {0};
	StructData _tmp11_;
	const gchar* _tmp12_;
	gboolean result = FALSE;
#line 122 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 122 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 124 "structure_model.vala"
	_tmp0_ = *iter;
#line 124 "structure_model.vala"
	if (_tmp0_.stamp != self->priv->_stamp) {
#line 127 "structure_model.vala"
		result = FALSE;
#line 127 "structure_model.vala"
		return result;
#line 659 "structure_model.c"
	}
#line 130 "structure_model.vala"
	_tmp1_ = *iter;
#line 130 "structure_model.vala"
	_tmp2_ = _tmp1_.user_data;
#line 130 "structure_model.vala"
	if (_tmp2_ == NULL) {
#line 133 "structure_model.vala"
		result = FALSE;
#line 133 "structure_model.vala"
		return result;
#line 671 "structure_model.c"
	}
#line 136 "structure_model.vala"
	_tmp3_ = *iter;
#line 136 "structure_model.vala"
	_tmp4_ = structure_model_get_node_from_iter (self, &_tmp3_);
#line 136 "structure_model.vala"
	node = _tmp4_;
#line 137 "structure_model.vala"
	_tmp5_ = node;
#line 137 "structure_model.vala"
	_tmp6_ = _tmp5_->data;
#line 137 "structure_model.vala"
	if (((StructData*) _tmp6_) == NULL) {
#line 140 "structure_model.vala"
		result = FALSE;
#line 140 "structure_model.vala"
		return result;
#line 689 "structure_model.c"
	}
#line 143 "structure_model.vala"
	_tmp7_ = node;
#line 143 "structure_model.vala"
	_tmp8_ = _tmp7_->data;
#line 143 "structure_model.vala"
	_tmp9_ = *((StructData*) _tmp8_);
#line 143 "structure_model.vala"
	struct_data_copy (&_tmp9_, &_tmp10_);
#line 143 "structure_model.vala"
	data = _tmp10_;
#line 144 "structure_model.vala"
	_tmp11_ = data;
#line 144 "structure_model.vala"
	_tmp12_ = _tmp11_.text;
#line 144 "structure_model.vala"
	if (_tmp12_ == NULL) {
#line 147 "structure_model.vala"
		result = FALSE;
#line 147 "structure_model.vala"
		struct_data_destroy (&data);
#line 147 "structure_model.vala"
		return result;
#line 713 "structure_model.c"
	}
#line 150 "structure_model.vala"
	result = TRUE;
#line 150 "structure_model.vala"
	struct_data_destroy (&data);
#line 150 "structure_model.vala"
	return result;
#line 721 "structure_model.c"
}

static gboolean
structure_model_column_is_valid (StructureModel* self,
                                 gint index)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 153 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "structure_model.vala"
	if (0 <= index) {
#line 155 "structure_model.vala"
		_tmp0_ = index < ((gint) STRUCT_COLUMN_N_COLUMNS);
#line 736 "structure_model.c"
	} else {
#line 155 "structure_model.vala"
		_tmp0_ = FALSE;
#line 740 "structure_model.c"
	}
#line 155 "structure_model.vala"
	result = _tmp0_;
#line 155 "structure_model.vala"
	return result;
#line 746 "structure_model.c"
}

static GNode*
structure_model_get_node_from_iter (StructureModel* self,
                                    GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	GNode* result = NULL;
#line 159 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 161 "structure_model.vala"
	_tmp0_ = *iter;
#line 161 "structure_model.vala"
	_tmp1_ = _tmp0_.user_data;
#line 161 "structure_model.vala"
	result = (GNode*) _tmp1_;
#line 161 "structure_model.vala"
	return result;
#line 768 "structure_model.c"
}

/*************************************************************************/
static GType
structure_model_real_get_column_type (GtkTreeModel* base,
                                      gint index)
{
	StructureModel * self;
	GType* _tmp0_;
	gint _tmp0__length1;
	GType _tmp1_;
	GType result = 0UL;
#line 167 "structure_model.vala"
	self = (StructureModel*) base;
#line 169 "structure_model.vala"
	g_return_val_if_fail (structure_model_column_is_valid (self, index), G_TYPE_INVALID);
#line 171 "structure_model.vala"
	_tmp0_ = self->priv->_column_types;
#line 171 "structure_model.vala"
	_tmp0__length1 = self->priv->_column_types_length1;
#line 171 "structure_model.vala"
	_tmp1_ = _tmp0_[index];
#line 171 "structure_model.vala"
	result = _tmp1_;
#line 171 "structure_model.vala"
	return result;
#line 795 "structure_model.c"
}

static gint
structure_model_real_get_n_columns (GtkTreeModel* base)
{
	StructureModel * self;
	gint result = 0;
#line 174 "structure_model.vala"
	self = (StructureModel*) base;
#line 176 "structure_model.vala"
	result = (gint) STRUCT_COLUMN_N_COLUMNS;
#line 176 "structure_model.vala"
	return result;
#line 809 "structure_model.c"
}

static GtkTreeModelFlags
structure_model_real_get_flags (GtkTreeModel* base)
{
	StructureModel * self;
	GtkTreeModelFlags result = 0U;
#line 179 "structure_model.vala"
	self = (StructureModel*) base;
#line 181 "structure_model.vala"
	result = 0;
#line 181 "structure_model.vala"
	return result;
#line 823 "structure_model.c"
}

static gboolean
structure_model_real_iter_has_child (GtkTreeModel* base,
                                     GtkTreeIter* iter)
{
	StructureModel * self;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	gboolean result = FALSE;
#line 184 "structure_model.vala"
	self = (StructureModel*) base;
#line 184 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 186 "structure_model.vala"
	_tmp0_ = *iter;
#line 186 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 188 "structure_model.vala"
	_tmp1_ = *iter;
#line 188 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 188 "structure_model.vala"
	node = _tmp2_;
#line 189 "structure_model.vala"
	result = !G_NODE_IS_LEAF (node);
#line 189 "structure_model.vala"
	return result;
#line 854 "structure_model.c"
}

static gint
structure_model_real_iter_n_children (GtkTreeModel* base,
                                      GtkTreeIter* iter)
{
	StructureModel * self;
	GNode* node = NULL;
	GNode* _tmp4_;
	gint result = 0;
#line 192 "structure_model.vala"
	self = (StructureModel*) base;
#line 195 "structure_model.vala"
	if (iter == NULL) {
#line 869 "structure_model.c"
		GNode* _tmp0_;
#line 196 "structure_model.vala"
		_tmp0_ = self->priv->_tree;
#line 196 "structure_model.vala"
		node = _tmp0_;
#line 875 "structure_model.c"
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
#line 199 "structure_model.vala"
		_tmp1_ = *iter;
#line 199 "structure_model.vala"
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), -1);
#line 200 "structure_model.vala"
		_tmp2_ = *iter;
#line 200 "structure_model.vala"
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 200 "structure_model.vala"
		node = _tmp3_;
#line 890 "structure_model.c"
	}
#line 203 "structure_model.vala"
	_tmp4_ = node;
#line 203 "structure_model.vala"
	result = (gint) g_node_n_children (_tmp4_);
#line 203 "structure_model.vala"
	return result;
#line 898 "structure_model.c"
}

static void
structure_model_real_get_value (GtkTreeModel* base,
                                GtkTreeIter* iter,
                                gint column,
                                GValue* val)
{
	StructureModel * self;
	GValue _vala_val = {0};
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructData data = {0};
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructData _tmp5_;
	StructData _tmp6_ = {0};
#line 206 "structure_model.vala"
	self = (StructureModel*) base;
#line 206 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 208 "structure_model.vala"
	_tmp0_ = *iter;
#line 208 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 209 "structure_model.vala"
	g_return_if_fail (structure_model_column_is_valid (self, column));
#line 211 "structure_model.vala"
	_tmp1_ = *iter;
#line 211 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 211 "structure_model.vala"
	node = _tmp2_;
#line 212 "structure_model.vala"
	_tmp3_ = node;
#line 212 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 212 "structure_model.vala"
	_tmp5_ = *((StructData*) _tmp4_);
#line 212 "structure_model.vala"
	struct_data_copy (&_tmp5_, &_tmp6_);
#line 212 "structure_model.vala"
	data = _tmp6_;
#line 214 "structure_model.vala"
	switch (column) {
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_TEXT:
#line 948 "structure_model.c"
		{
			StructData _tmp7_;
			const gchar* _tmp8_;
			GValue _tmp9_ = {0};
#line 217 "structure_model.vala"
			_tmp7_ = data;
#line 217 "structure_model.vala"
			_tmp8_ = _tmp7_.text;
#line 217 "structure_model.vala"
			g_value_init (&_tmp9_, G_TYPE_STRING);
#line 217 "structure_model.vala"
			g_value_set_string (&_tmp9_, _tmp8_);
#line 217 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 217 "structure_model.vala"
			_vala_val = _tmp9_;
#line 218 "structure_model.vala"
			break;
#line 967 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_START_MARK:
#line 971 "structure_model.c"
		{
			StructData _tmp10_;
			GtkTextMark* _tmp11_;
			GValue _tmp12_ = {0};
#line 221 "structure_model.vala"
			_tmp10_ = data;
#line 221 "structure_model.vala"
			_tmp11_ = _tmp10_.start_mark;
#line 221 "structure_model.vala"
			g_value_init (&_tmp12_, gtk_text_mark_get_type ());
#line 221 "structure_model.vala"
			g_value_set_object (&_tmp12_, _tmp11_);
#line 221 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 221 "structure_model.vala"
			_vala_val = _tmp12_;
#line 222 "structure_model.vala"
			break;
#line 990 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_END_MARK:
#line 994 "structure_model.c"
		{
			StructData _tmp13_;
			GtkTextMark* _tmp14_;
			GValue _tmp15_ = {0};
#line 225 "structure_model.vala"
			_tmp13_ = data;
#line 225 "structure_model.vala"
			_tmp14_ = _tmp13_.end_mark;
#line 225 "structure_model.vala"
			g_value_init (&_tmp15_, gtk_text_mark_get_type ());
#line 225 "structure_model.vala"
			g_value_set_object (&_tmp15_, _tmp14_);
#line 225 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 225 "structure_model.vala"
			_vala_val = _tmp15_;
#line 226 "structure_model.vala"
			break;
#line 1013 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_TYPE:
#line 1017 "structure_model.c"
		{
			StructData _tmp16_;
			StructType _tmp17_;
			GValue _tmp18_ = {0};
#line 229 "structure_model.vala"
			_tmp16_ = data;
#line 229 "structure_model.vala"
			_tmp17_ = _tmp16_.type;
#line 229 "structure_model.vala"
			g_value_init (&_tmp18_, TYPE_STRUCT_TYPE);
#line 229 "structure_model.vala"
			g_value_set_enum (&_tmp18_, _tmp17_);
#line 229 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 229 "structure_model.vala"
			_vala_val = _tmp18_;
#line 230 "structure_model.vala"
			break;
#line 1036 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_PIXBUF:
#line 1040 "structure_model.c"
		{
			StructData _tmp19_;
			StructType _tmp20_;
			gchar* _tmp21_;
			GValue _tmp22_ = {0};
#line 233 "structure_model.vala"
			_tmp19_ = data;
#line 233 "structure_model.vala"
			_tmp20_ = _tmp19_.type;
#line 233 "structure_model.vala"
			_tmp21_ = structure_get_icon_from_type (_tmp20_);
#line 233 "structure_model.vala"
			g_value_init (&_tmp22_, G_TYPE_STRING);
#line 233 "structure_model.vala"
			g_value_take_string (&_tmp22_, _tmp21_);
#line 233 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 233 "structure_model.vala"
			_vala_val = _tmp22_;
#line 234 "structure_model.vala"
			break;
#line 1062 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_TOOLTIP:
#line 1066 "structure_model.c"
		{
			StructData _tmp23_;
			StructType _tmp24_;
			gchar* _tmp25_;
			GValue _tmp26_ = {0};
#line 237 "structure_model.vala"
			_tmp23_ = data;
#line 237 "structure_model.vala"
			_tmp24_ = _tmp23_.type;
#line 237 "structure_model.vala"
			_tmp25_ = structure_get_type_name (_tmp24_);
#line 237 "structure_model.vala"
			g_value_init (&_tmp26_, G_TYPE_STRING);
#line 237 "structure_model.vala"
			g_value_take_string (&_tmp26_, _tmp25_);
#line 237 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 237 "structure_model.vala"
			_vala_val = _tmp26_;
#line 238 "structure_model.vala"
			break;
#line 1088 "structure_model.c"
		}
		default:
		{
#line 241 "structure_model.vala"
			g_return_if_reached ();
#line 1094 "structure_model.c"
		}
	}
#line 206 "structure_model.vala"
	struct_data_destroy (&data);
#line 206 "structure_model.vala"
	if (val) {
#line 206 "structure_model.vala"
		*val = _vala_val;
#line 1103 "structure_model.c"
	} else {
#line 206 "structure_model.vala"
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 1107 "structure_model.c"
	}
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
#line 261 "structure_model.vala"
	g_boxed_free (gtk_tree_iter_get_type (), self);
#line 1116 "structure_model.c"
}

static gboolean
structure_model_real_iter_children (GtkTreeModel* base,
                                    GtkTreeIter* iter,
                                    GtkTreeIter* parent)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	GNode* node = NULL;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* _tmp8_;
	gboolean result = FALSE;
#line 245 "structure_model.vala"
	self = (StructureModel*) base;
#line 247 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 250 "structure_model.vala"
	if (parent == NULL) {
#line 1139 "structure_model.c"
		GNode* _tmp0_;
#line 251 "structure_model.vala"
		_tmp0_ = self->priv->_tree;
#line 251 "structure_model.vala"
		node = _tmp0_;
#line 1145 "structure_model.c"
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
#line 254 "structure_model.vala"
		_tmp1_ = *parent;
#line 254 "structure_model.vala"
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), FALSE);
#line 255 "structure_model.vala"
		_tmp2_ = *parent;
#line 255 "structure_model.vala"
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 255 "structure_model.vala"
		node = _tmp3_;
#line 1160 "structure_model.c"
	}
#line 258 "structure_model.vala"
	_tmp4_ = node;
#line 258 "structure_model.vala"
	if (G_NODE_IS_LEAF (_tmp4_)) {
#line 259 "structure_model.vala"
		result = FALSE;
#line 259 "structure_model.vala"
		if (iter) {
#line 259 "structure_model.vala"
			*iter = _vala_iter;
#line 1172 "structure_model.c"
		}
#line 259 "structure_model.vala"
		return result;
#line 1176 "structure_model.c"
	}
#line 261 "structure_model.vala"
	_tmp5_ = node;
#line 261 "structure_model.vala"
	_tmp6_ = g_node_first_child (_tmp5_);
#line 261 "structure_model.vala"
	_tmp7_ = structure_model_create_iter_at_node (self, _tmp6_);
#line 261 "structure_model.vala"
	_tmp8_ = _tmp7_;
#line 261 "structure_model.vala"
	_vala_iter = *_tmp8_;
#line 261 "structure_model.vala"
	__vala_GtkTreeIter_free0 (_tmp8_);
#line 262 "structure_model.vala"
	result = TRUE;
#line 262 "structure_model.vala"
	if (iter) {
#line 262 "structure_model.vala"
		*iter = _vala_iter;
#line 1196 "structure_model.c"
	}
#line 262 "structure_model.vala"
	return result;
#line 1200 "structure_model.c"
}

static gboolean
structure_model_real_iter_next (GtkTreeModel* base,
                                GtkTreeIter* iter)
{
	StructureModel * self;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* next_node = NULL;
	GNode* _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* _tmp8_;
	gboolean result = FALSE;
#line 265 "structure_model.vala"
	self = (StructureModel*) base;
#line 265 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 267 "structure_model.vala"
	_tmp0_ = *iter;
#line 267 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 269 "structure_model.vala"
	_tmp1_ = *iter;
#line 269 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 269 "structure_model.vala"
	node = _tmp2_;
#line 270 "structure_model.vala"
	_tmp3_ = node;
#line 270 "structure_model.vala"
	_tmp4_ = g_node_next_sibling (_tmp3_);
#line 270 "structure_model.vala"
	next_node = _tmp4_;
#line 271 "structure_model.vala"
	_tmp5_ = next_node;
#line 271 "structure_model.vala"
	if (_tmp5_ == NULL) {
#line 272 "structure_model.vala"
		result = FALSE;
#line 272 "structure_model.vala"
		return result;
#line 1248 "structure_model.c"
	}
#line 274 "structure_model.vala"
	_tmp6_ = next_node;
#line 274 "structure_model.vala"
	_tmp7_ = structure_model_create_iter_at_node (self, _tmp6_);
#line 274 "structure_model.vala"
	_tmp8_ = _tmp7_;
#line 274 "structure_model.vala"
	*iter = *_tmp8_;
#line 274 "structure_model.vala"
	__vala_GtkTreeIter_free0 (_tmp8_);
#line 275 "structure_model.vala"
	result = TRUE;
#line 275 "structure_model.vala"
	return result;
#line 1264 "structure_model.c"
}

static gboolean
structure_model_real_iter_nth_child (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     GtkTreeIter* parent,
                                     gint n)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	GNode* node = NULL;
	GNode* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GNode* _tmp7_;
	GNode* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter* _tmp10_;
	gboolean result = FALSE;
#line 278 "structure_model.vala"
	self = (StructureModel*) base;
#line 280 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 283 "structure_model.vala"
	if (parent == NULL) {
#line 1289 "structure_model.c"
		GNode* _tmp0_;
#line 284 "structure_model.vala"
		_tmp0_ = self->priv->_tree;
#line 284 "structure_model.vala"
		node = _tmp0_;
#line 1295 "structure_model.c"
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
#line 287 "structure_model.vala"
		_tmp1_ = *parent;
#line 287 "structure_model.vala"
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), FALSE);
#line 288 "structure_model.vala"
		_tmp2_ = *parent;
#line 288 "structure_model.vala"
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 288 "structure_model.vala"
		node = _tmp3_;
#line 1310 "structure_model.c"
	}
#line 291 "structure_model.vala"
	_tmp4_ = node;
#line 291 "structure_model.vala"
	if (G_NODE_IS_LEAF (_tmp4_)) {
#line 292 "structure_model.vala"
		result = FALSE;
#line 292 "structure_model.vala"
		if (iter) {
#line 292 "structure_model.vala"
			*iter = _vala_iter;
#line 1322 "structure_model.c"
		}
#line 292 "structure_model.vala"
		return result;
#line 1326 "structure_model.c"
	}
#line 294 "structure_model.vala"
	if (n < 0) {
#line 294 "structure_model.vala"
		_tmp5_ = TRUE;
#line 1332 "structure_model.c"
	} else {
		GNode* _tmp6_;
#line 294 "structure_model.vala"
		_tmp6_ = node;
#line 294 "structure_model.vala"
		_tmp5_ = g_node_n_children (_tmp6_) <= ((guint) n);
#line 1339 "structure_model.c"
	}
#line 294 "structure_model.vala"
	if (_tmp5_) {
#line 295 "structure_model.vala"
		result = FALSE;
#line 295 "structure_model.vala"
		if (iter) {
#line 295 "structure_model.vala"
			*iter = _vala_iter;
#line 1349 "structure_model.c"
		}
#line 295 "structure_model.vala"
		return result;
#line 1353 "structure_model.c"
	}
#line 297 "structure_model.vala"
	_tmp7_ = node;
#line 297 "structure_model.vala"
	_tmp8_ = g_node_nth_child (_tmp7_, (guint) n);
#line 297 "structure_model.vala"
	_tmp9_ = structure_model_create_iter_at_node (self, _tmp8_);
#line 297 "structure_model.vala"
	_tmp10_ = _tmp9_;
#line 297 "structure_model.vala"
	_vala_iter = *_tmp10_;
#line 297 "structure_model.vala"
	__vala_GtkTreeIter_free0 (_tmp10_);
#line 298 "structure_model.vala"
	result = TRUE;
#line 298 "structure_model.vala"
	if (iter) {
#line 298 "structure_model.vala"
		*iter = _vala_iter;
#line 1373 "structure_model.c"
	}
#line 298 "structure_model.vala"
	return result;
#line 1377 "structure_model.c"
}

static gboolean
structure_model_real_iter_parent (GtkTreeModel* base,
                                  GtkTreeIter* iter,
                                  GtkTreeIter* child)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* parent_node = NULL;
	GNode* _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GNode* _tmp7_;
	GNode* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter* _tmp10_;
	gboolean result = FALSE;
#line 301 "structure_model.vala"
	self = (StructureModel*) base;
#line 301 "structure_model.vala"
	g_return_val_if_fail (child != NULL, FALSE);
#line 303 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 305 "structure_model.vala"
	_tmp0_ = *child;
#line 305 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 307 "structure_model.vala"
	_tmp1_ = *child;
#line 307 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 307 "structure_model.vala"
	node = _tmp2_;
#line 308 "structure_model.vala"
	_tmp3_ = node;
#line 308 "structure_model.vala"
	_tmp4_ = _tmp3_->parent;
#line 308 "structure_model.vala"
	parent_node = _tmp4_;
#line 311 "structure_model.vala"
	_tmp5_ = parent_node;
#line 311 "structure_model.vala"
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
#line 314 "structure_model.vala"
	_tmp6_ = parent_node;
#line 314 "structure_model.vala"
	_tmp7_ = self->priv->_tree;
#line 314 "structure_model.vala"
	if (_tmp6_ == _tmp7_) {
#line 315 "structure_model.vala"
		result = FALSE;
#line 315 "structure_model.vala"
		if (iter) {
#line 315 "structure_model.vala"
			*iter = _vala_iter;
#line 1439 "structure_model.c"
		}
#line 315 "structure_model.vala"
		return result;
#line 1443 "structure_model.c"
	}
#line 317 "structure_model.vala"
	_tmp8_ = parent_node;
#line 317 "structure_model.vala"
	_tmp9_ = structure_model_create_iter_at_node (self, _tmp8_);
#line 317 "structure_model.vala"
	_tmp10_ = _tmp9_;
#line 317 "structure_model.vala"
	_vala_iter = *_tmp10_;
#line 317 "structure_model.vala"
	__vala_GtkTreeIter_free0 (_tmp10_);
#line 318 "structure_model.vala"
	result = TRUE;
#line 318 "structure_model.vala"
	if (iter) {
#line 318 "structure_model.vala"
		*iter = _vala_iter;
#line 1461 "structure_model.c"
	}
#line 318 "structure_model.vala"
	return result;
#line 1465 "structure_model.c"
}

static gboolean
structure_model_real_get_iter (GtkTreeModel* base,
                               GtkTreeIter* iter,
                               GtkTreePath* path)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gint depth = 0;
	gint* indices = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint indices_length1;
	gint _indices_size_;
	GNode* node = NULL;
	GNode* _tmp2_;
	GNode* _tmp11_;
	GtkTreeIter* _tmp12_;
	GtkTreeIter* _tmp13_;
	gboolean result = FALSE;
#line 321 "structure_model.vala"
	self = (StructureModel*) base;
#line 321 "structure_model.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 323 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 325 "structure_model.vala"
	depth = gtk_tree_path_get_depth (path);
#line 326 "structure_model.vala"
	g_return_val_if_fail (1 <= depth, FALSE);
#line 328 "structure_model.vala"
	_tmp1_ = gtk_tree_path_get_indices_with_depth (path, &_tmp0_);
#line 328 "structure_model.vala"
	indices = _tmp1_;
#line 328 "structure_model.vala"
	indices_length1 = _tmp0_;
#line 328 "structure_model.vala"
	_indices_size_ = indices_length1;
#line 330 "structure_model.vala"
	_tmp2_ = self->priv->_tree;
#line 330 "structure_model.vala"
	node = _tmp2_;
#line 1509 "structure_model.c"
	{
		gint cur_depth = 0;
#line 331 "structure_model.vala"
		cur_depth = 0;
#line 1514 "structure_model.c"
		{
			gboolean _tmp3_ = FALSE;
#line 331 "structure_model.vala"
			_tmp3_ = TRUE;
#line 331 "structure_model.vala"
			while (TRUE) {
#line 1521 "structure_model.c"
				gint indice = 0;
				gint* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gboolean _tmp7_ = FALSE;
				GNode* _tmp9_;
				GNode* _tmp10_;
#line 331 "structure_model.vala"
				if (!_tmp3_) {
#line 1531 "structure_model.c"
					gint _tmp4_;
#line 331 "structure_model.vala"
					_tmp4_ = cur_depth;
#line 331 "structure_model.vala"
					cur_depth = _tmp4_ + 1;
#line 1537 "structure_model.c"
				}
#line 331 "structure_model.vala"
				_tmp3_ = FALSE;
#line 331 "structure_model.vala"
				if (!(cur_depth < depth)) {
#line 331 "structure_model.vala"
					break;
#line 1545 "structure_model.c"
				}
#line 333 "structure_model.vala"
				_tmp5_ = indices;
#line 333 "structure_model.vala"
				_tmp5__length1 = indices_length1;
#line 333 "structure_model.vala"
				_tmp6_ = _tmp5_[cur_depth];
#line 333 "structure_model.vala"
				indice = _tmp6_;
#line 334 "structure_model.vala"
				if (indice < 0) {
#line 334 "structure_model.vala"
					_tmp7_ = TRUE;
#line 1559 "structure_model.c"
				} else {
					GNode* _tmp8_;
#line 334 "structure_model.vala"
					_tmp8_ = node;
#line 334 "structure_model.vala"
					_tmp7_ = g_node_n_children (_tmp8_) <= ((guint) indice);
#line 1566 "structure_model.c"
				}
#line 334 "structure_model.vala"
				if (_tmp7_) {
#line 335 "structure_model.vala"
					result = FALSE;
#line 335 "structure_model.vala"
					if (iter) {
#line 335 "structure_model.vala"
						*iter = _vala_iter;
#line 1576 "structure_model.c"
					}
#line 335 "structure_model.vala"
					return result;
#line 1580 "structure_model.c"
				}
#line 337 "structure_model.vala"
				_tmp9_ = node;
#line 337 "structure_model.vala"
				_tmp10_ = g_node_nth_child (_tmp9_, (guint) indice);
#line 337 "structure_model.vala"
				node = _tmp10_;
#line 1588 "structure_model.c"
			}
		}
	}
#line 340 "structure_model.vala"
	_tmp11_ = node;
#line 340 "structure_model.vala"
	_tmp12_ = structure_model_create_iter_at_node (self, _tmp11_);
#line 340 "structure_model.vala"
	_tmp13_ = _tmp12_;
#line 340 "structure_model.vala"
	_vala_iter = *_tmp13_;
#line 340 "structure_model.vala"
	__vala_GtkTreeIter_free0 (_tmp13_);
#line 341 "structure_model.vala"
	result = TRUE;
#line 341 "structure_model.vala"
	if (iter) {
#line 341 "structure_model.vala"
		*iter = _vala_iter;
#line 1608 "structure_model.c"
	}
#line 341 "structure_model.vala"
	return result;
#line 1612 "structure_model.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 344 "structure_model.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1620 "structure_model.c"
}

static GtkTreePath*
structure_model_real_get_path (GtkTreeModel* base,
                               GtkTreeIter* iter)
{
	StructureModel * self;
	GtkTreeIter _tmp0_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_;
	GNode* node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	GtkTreePath* result = NULL;
#line 344 "structure_model.vala"
	self = (StructureModel*) base;
#line 344 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 346 "structure_model.vala"
	_tmp0_ = *iter;
#line 346 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), NULL);
#line 348 "structure_model.vala"
	_tmp1_ = gtk_tree_path_new ();
#line 348 "structure_model.vala"
	path = _tmp1_;
#line 349 "structure_model.vala"
	_tmp2_ = *iter;
#line 349 "structure_model.vala"
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 349 "structure_model.vala"
	node = _tmp3_;
#line 351 "structure_model.vala"
	while (TRUE) {
#line 1655 "structure_model.c"
		GNode* _tmp4_;
		gint pos = 0;
		GNode* _tmp5_;
		GNode* _tmp6_;
		GNode* _tmp7_;
		GtkTreePath* _tmp8_;
		GNode* _tmp9_;
		GNode* _tmp10_;
#line 351 "structure_model.vala"
		_tmp4_ = node;
#line 351 "structure_model.vala"
		if (!(!G_NODE_IS_ROOT (_tmp4_))) {
#line 351 "structure_model.vala"
			break;
#line 1670 "structure_model.c"
		}
#line 353 "structure_model.vala"
		_tmp5_ = node;
#line 353 "structure_model.vala"
		_tmp6_ = _tmp5_->parent;
#line 353 "structure_model.vala"
		_tmp7_ = node;
#line 353 "structure_model.vala"
		pos = g_node_child_position (_tmp6_, _tmp7_);
#line 354 "structure_model.vala"
		_tmp8_ = path;
#line 354 "structure_model.vala"
		gtk_tree_path_prepend_index (_tmp8_, pos);
#line 355 "structure_model.vala"
		_tmp9_ = node;
#line 355 "structure_model.vala"
		_tmp10_ = _tmp9_->parent;
#line 355 "structure_model.vala"
		node = _tmp10_;
#line 1690 "structure_model.c"
	}
#line 358 "structure_model.vala"
	result = path;
#line 358 "structure_model.vala"
	return result;
#line 1696 "structure_model.c"
}

/*************************************************************************/
guint
structure_model_get_nb_items (StructureModel* self)
{
	guint result = 0U;
#line 365 "structure_model.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 367 "structure_model.vala"
	result = self->priv->_nb_nodes;
#line 367 "structure_model.vala"
	return result;
#line 1710 "structure_model.c"
}

GtkTreeIter*
structure_model_add_item_at_end (StructureModel* self,
                                 StructData* item)
{
	GNode* _tmp0_;
	StructType item_depth = 0;
	StructData _tmp1_;
	StructType _tmp2_;
	GNode* parent = NULL;
	GNode* _tmp3_;
	GNode* prev_sibling = NULL;
	GtkTreeIter* end_iter = NULL;
	GNode* _tmp16_;
	GNode* _tmp17_;
	StructData _tmp18_;
	GtkTreeIter* _tmp19_;
	GtkTreeIter* _tmp20_;
	GtkTreeIter* result = NULL;
#line 370 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 370 "structure_model.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 381 "structure_model.vala"
	_tmp0_ = self->priv->_end_node;
#line 381 "structure_model.vala"
	if (_tmp0_ == NULL) {
#line 382 "structure_model.vala"
		structure_model_search_end_node (self);
#line 1741 "structure_model.c"
	}
#line 385 "structure_model.vala"
	_tmp1_ = *item;
#line 385 "structure_model.vala"
	_tmp2_ = _tmp1_.type;
#line 385 "structure_model.vala"
	item_depth = _tmp2_;
#line 386 "structure_model.vala"
	_tmp3_ = self->priv->_end_node;
#line 386 "structure_model.vala"
	parent = _tmp3_;
#line 387 "structure_model.vala"
	prev_sibling = NULL;
#line 388 "structure_model.vala"
	while (TRUE) {
#line 1757 "structure_model.c"
		GNode* _tmp4_;
		GNode* _tmp5_;
		StructType cur_depth = 0;
		GNode* _tmp6_;
		gconstpointer _tmp7_;
		StructType _tmp8_;
		gboolean _tmp9_ = FALSE;
		StructType _tmp10_;
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
#line 390 "structure_model.vala"
		_tmp4_ = parent;
#line 390 "structure_model.vala"
		_tmp5_ = self->priv->_tree;
#line 390 "structure_model.vala"
		if (_tmp4_ == _tmp5_) {
#line 391 "structure_model.vala"
			break;
#line 1777 "structure_model.c"
		}
#line 393 "structure_model.vala"
		_tmp6_ = parent;
#line 393 "structure_model.vala"
		_tmp7_ = _tmp6_->data;
#line 393 "structure_model.vala"
		_tmp8_ = (*((StructData*) _tmp7_)).type;
#line 393 "structure_model.vala"
		cur_depth = _tmp8_;
#line 394 "structure_model.vala"
		_tmp10_ = cur_depth;
#line 394 "structure_model.vala"
		if (structure_is_section (_tmp10_)) {
#line 1791 "structure_model.c"
			StructType _tmp11_;
			StructType _tmp12_;
#line 394 "structure_model.vala"
			_tmp11_ = cur_depth;
#line 394 "structure_model.vala"
			_tmp12_ = item_depth;
#line 394 "structure_model.vala"
			_tmp9_ = _tmp11_ < _tmp12_;
#line 1800 "structure_model.c"
		} else {
#line 394 "structure_model.vala"
			_tmp9_ = FALSE;
#line 1804 "structure_model.c"
		}
#line 394 "structure_model.vala"
		if (_tmp9_) {
#line 395 "structure_model.vala"
			break;
#line 1810 "structure_model.c"
		}
#line 397 "structure_model.vala"
		_tmp13_ = parent;
#line 397 "structure_model.vala"
		prev_sibling = _tmp13_;
#line 398 "structure_model.vala"
		_tmp14_ = parent;
#line 398 "structure_model.vala"
		_tmp15_ = _tmp14_->parent;
#line 398 "structure_model.vala"
		parent = _tmp15_;
#line 1822 "structure_model.c"
	}
#line 402 "structure_model.vala"
	_tmp16_ = parent;
#line 402 "structure_model.vala"
	_tmp17_ = prev_sibling;
#line 402 "structure_model.vala"
	_tmp18_ = *item;
#line 402 "structure_model.vala"
	_tmp19_ = structure_model_insert_item_after (self, _tmp16_, _tmp17_, &_tmp18_);
#line 402 "structure_model.vala"
	end_iter = _tmp19_;
#line 404 "structure_model.vala"
	_tmp20_ = end_iter;
#line 404 "structure_model.vala"
	if (_tmp20_ != NULL) {
#line 1838 "structure_model.c"
		GtkTreeIter* _tmp21_;
		GtkTreeIter _tmp22_;
		GNode* _tmp23_;
#line 405 "structure_model.vala"
		_tmp21_ = end_iter;
#line 405 "structure_model.vala"
		_tmp22_ = *_tmp21_;
#line 405 "structure_model.vala"
		_tmp23_ = structure_model_get_node_from_iter (self, &_tmp22_);
#line 405 "structure_model.vala"
		self->priv->_end_node = _tmp23_;
#line 1850 "structure_model.c"
	}
#line 407 "structure_model.vala"
	result = end_iter;
#line 407 "structure_model.vala"
	return result;
#line 1856 "structure_model.c"
}

GtkTreeIter*
structure_model_get_next_sibling_or_parent (StructureModel* self,
                                            GtkTreeIter* section_iter,
                                            GError** error)
{
	GtkTreeIter _tmp0_;
	GNode* cur_node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
	gconstpointer _tmp5_;
	StructType _tmp6_;
	GError* _inner_error0_ = NULL;
	GtkTreeIter* result = NULL;
#line 412 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 412 "structure_model.vala"
	g_return_val_if_fail (section_iter != NULL, NULL);
#line 414 "structure_model.vala"
	_tmp0_ = *section_iter;
#line 414 "structure_model.vala"
	if (!structure_model_iter_is_valid (self, &_tmp0_)) {
#line 1881 "structure_model.c"
		GError* _tmp1_;
#line 415 "structure_model.vala"
		_tmp1_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not valid.");
#line 415 "structure_model.vala"
		_inner_error0_ = _tmp1_;
#line 415 "structure_model.vala"
		if (_inner_error0_->domain == STRUCT_ERROR) {
#line 415 "structure_model.vala"
			g_propagate_error (error, _inner_error0_);
#line 415 "structure_model.vala"
			return NULL;
#line 1893 "structure_model.c"
		} else {
#line 415 "structure_model.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 415 "structure_model.vala"
			g_clear_error (&_inner_error0_);
#line 415 "structure_model.vala"
			return NULL;
#line 1901 "structure_model.c"
		}
	}
#line 417 "structure_model.vala"
	_tmp2_ = *section_iter;
#line 417 "structure_model.vala"
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 417 "structure_model.vala"
	cur_node = _tmp3_;
#line 419 "structure_model.vala"
	_tmp4_ = cur_node;
#line 419 "structure_model.vala"
	_tmp5_ = _tmp4_->data;
#line 419 "structure_model.vala"
	_tmp6_ = (*((StructData*) _tmp5_)).type;
#line 419 "structure_model.vala"
	if (!structure_is_section (_tmp6_)) {
#line 1918 "structure_model.c"
		GError* _tmp7_;
#line 420 "structure_model.vala"
		_tmp7_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not a section.");
#line 420 "structure_model.vala"
		_inner_error0_ = _tmp7_;
#line 420 "structure_model.vala"
		if (_inner_error0_->domain == STRUCT_ERROR) {
#line 420 "structure_model.vala"
			g_propagate_error (error, _inner_error0_);
#line 420 "structure_model.vala"
			return NULL;
#line 1930 "structure_model.c"
		} else {
#line 420 "structure_model.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 420 "structure_model.vala"
			g_clear_error (&_inner_error0_);
#line 420 "structure_model.vala"
			return NULL;
#line 1938 "structure_model.c"
		}
	}
#line 422 "structure_model.vala"
	while (TRUE) {
#line 1943 "structure_model.c"
		gboolean _tmp8_ = FALSE;
		GNode* _tmp9_;
		GNode* next_sibling_node = NULL;
		GNode* _tmp12_;
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp17_;
		GNode* _tmp18_;
#line 422 "structure_model.vala"
		_tmp9_ = cur_node;
#line 422 "structure_model.vala"
		if (_tmp9_ != NULL) {
#line 1956 "structure_model.c"
			GNode* _tmp10_;
			GNode* _tmp11_;
#line 422 "structure_model.vala"
			_tmp10_ = cur_node;
#line 422 "structure_model.vala"
			_tmp11_ = self->priv->_tree;
#line 422 "structure_model.vala"
			_tmp8_ = _tmp10_ != _tmp11_;
#line 1965 "structure_model.c"
		} else {
#line 422 "structure_model.vala"
			_tmp8_ = FALSE;
#line 1969 "structure_model.c"
		}
#line 422 "structure_model.vala"
		if (!_tmp8_) {
#line 422 "structure_model.vala"
			break;
#line 1975 "structure_model.c"
		}
#line 424 "structure_model.vala"
		_tmp12_ = cur_node;
#line 424 "structure_model.vala"
		_tmp13_ = g_node_next_sibling (_tmp12_);
#line 424 "structure_model.vala"
		next_sibling_node = _tmp13_;
#line 426 "structure_model.vala"
		_tmp14_ = next_sibling_node;
#line 426 "structure_model.vala"
		if (_tmp14_ != NULL) {
#line 1987 "structure_model.c"
			GNode* _tmp15_;
			GtkTreeIter* _tmp16_;
#line 427 "structure_model.vala"
			_tmp15_ = next_sibling_node;
#line 427 "structure_model.vala"
			_tmp16_ = structure_model_create_iter_at_node (self, _tmp15_);
#line 427 "structure_model.vala"
			result = _tmp16_;
#line 427 "structure_model.vala"
			return result;
#line 1998 "structure_model.c"
		}
#line 429 "structure_model.vala"
		_tmp17_ = cur_node;
#line 429 "structure_model.vala"
		_tmp18_ = _tmp17_->parent;
#line 429 "structure_model.vala"
		cur_node = _tmp18_;
#line 2006 "structure_model.c"
	}
#line 432 "structure_model.vala"
	result = NULL;
#line 432 "structure_model.vala"
	return result;
#line 2012 "structure_model.c"
}

void
structure_model_delete (StructureModel* self,
                        GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
#line 435 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 435 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 437 "structure_model.vala"
	_tmp0_ = *iter;
#line 437 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 439 "structure_model.vala"
	_tmp1_ = *iter;
#line 439 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 439 "structure_model.vala"
	node = _tmp2_;
#line 440 "structure_model.vala"
	_tmp3_ = structure_model_delete_node (self, node);
#line 440 "structure_model.vala"
	_tmp4_ = _tmp3_;
#line 440 "structure_model.vala"
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_node_destroy__struct_data_free0_ (_tmp4_), NULL));
#line 441 "structure_model.vala"
	self->priv->_end_node = NULL;
#line 442 "structure_model.vala"
	structure_model_regenerate_simple_lists (self);
#line 2049 "structure_model.c"
}

void
structure_model_modify_data (StructureModel* self,
                             GtkTreePath* path,
                             const gchar* text,
                             GtkTextMark* end_mark)
{
	GtkTreeIter iter = {0};
	gboolean iter_is_valid = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GNode* node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GNode* _tmp5_;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	GNode* _tmp8_;
	gconstpointer _tmp9_;
	GtkTextMark* _tmp10_;
	gboolean _tmp11_;
	GNode* _tmp13_;
#line 445 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 445 "structure_model.vala"
	g_return_if_fail (path != NULL);
#line 445 "structure_model.vala"
	g_return_if_fail (end_mark != NULL);
#line 448 "structure_model.vala"
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
#line 448 "structure_model.vala"
	iter = _tmp0_;
#line 448 "structure_model.vala"
	iter_is_valid = _tmp1_;
#line 449 "structure_model.vala"
	g_return_if_fail (iter_is_valid);
#line 451 "structure_model.vala"
	_tmp2_ = iter;
#line 451 "structure_model.vala"
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 451 "structure_model.vala"
	node = _tmp3_;
#line 454 "structure_model.vala"
	structure_model_new_stamp (self);
#line 455 "structure_model.vala"
	_tmp4_ = text;
#line 455 "structure_model.vala"
	if (_tmp4_ == NULL) {
#line 455 "structure_model.vala"
		_tmp4_ = "";
#line 2102 "structure_model.c"
	}
#line 455 "structure_model.vala"
	_tmp5_ = node;
#line 455 "structure_model.vala"
	_tmp6_ = _tmp5_->data;
#line 455 "structure_model.vala"
	_tmp7_ = g_strdup (_tmp4_);
#line 455 "structure_model.vala"
	_g_free0 ((*((StructData*) _tmp6_)).text);
#line 455 "structure_model.vala"
	(*((StructData*) _tmp6_)).text = _tmp7_;
#line 456 "structure_model.vala"
	_tmp8_ = node;
#line 456 "structure_model.vala"
	_tmp9_ = _tmp8_->data;
#line 456 "structure_model.vala"
	_tmp10_ = _g_object_ref0 (end_mark);
#line 456 "structure_model.vala"
	_g_object_unref0 ((*((StructData*) _tmp9_)).end_mark);
#line 456 "structure_model.vala"
	(*((StructData*) _tmp9_)).end_mark = _tmp10_;
#line 458 "structure_model.vala"
	_tmp11_ = self->priv->_emit_signals;
#line 458 "structure_model.vala"
	if (_tmp11_) {
#line 2128 "structure_model.c"
		GtkTreeIter _tmp12_;
#line 459 "structure_model.vala"
		_tmp12_ = iter;
#line 459 "structure_model.vala"
		gtk_tree_model_row_changed ((GtkTreeModel*) self, path, &_tmp12_);
#line 2134 "structure_model.c"
	}
#line 461 "structure_model.vala"
	_tmp13_ = node;
#line 461 "structure_model.vala"
	structure_model_make_children_between_marks (self, _tmp13_);
#line 2140 "structure_model.c"
}

void
structure_model_shift_right (StructureModel* self,
                             GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	gboolean _tmp6_ = FALSE;
	StructType _tmp7_;
	StructType new_type = 0;
	StructType _tmp9_;
	GNode* new_parent = NULL;
	GNode* _tmp10_;
	GNode* _tmp11_;
	gint new_pos = 0;
	gboolean _tmp12_ = FALSE;
	GNode* _tmp13_;
	GNode* node_unlinked = NULL;
	GNode* _tmp22_;
	GNode* _tmp23_;
	GNode* _tmp24_;
	GNode* _tmp25_;
	GNode* _tmp26_;
	GNode* _tmp27_;
	GNode* _tmp28_;
#line 464 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 464 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 466 "structure_model.vala"
	_tmp0_ = *iter;
#line 466 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 468 "structure_model.vala"
	_tmp1_ = *iter;
#line 468 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 468 "structure_model.vala"
	node = _tmp2_;
#line 469 "structure_model.vala"
	_tmp3_ = node;
#line 469 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 469 "structure_model.vala"
	_tmp5_ = (*((StructData*) _tmp4_)).type;
#line 469 "structure_model.vala"
	type = _tmp5_;
#line 470 "structure_model.vala"
	_tmp7_ = type;
#line 470 "structure_model.vala"
	if (structure_is_section (_tmp7_)) {
#line 2199 "structure_model.c"
		StructType _tmp8_;
#line 470 "structure_model.vala"
		_tmp8_ = type;
#line 470 "structure_model.vala"
		_tmp6_ = _tmp8_ != STRUCT_TYPE_SUBPARAGRAPH;
#line 2205 "structure_model.c"
	} else {
#line 470 "structure_model.vala"
		_tmp6_ = FALSE;
#line 2209 "structure_model.c"
	}
#line 470 "structure_model.vala"
	g_return_if_fail (_tmp6_);
#line 472 "structure_model.vala"
	_tmp9_ = type;
#line 472 "structure_model.vala"
	new_type = _tmp9_ + 1;
#line 475 "structure_model.vala"
	_tmp10_ = node;
#line 475 "structure_model.vala"
	_tmp11_ = g_node_prev_sibling (_tmp10_);
#line 475 "structure_model.vala"
	new_parent = _tmp11_;
#line 478 "structure_model.vala"
	_tmp13_ = new_parent;
#line 478 "structure_model.vala"
	if (_tmp13_ == NULL) {
#line 478 "structure_model.vala"
		_tmp12_ = TRUE;
#line 2229 "structure_model.c"
	} else {
		StructType _tmp14_;
		GNode* _tmp15_;
		gconstpointer _tmp16_;
		StructType _tmp17_;
#line 478 "structure_model.vala"
		_tmp14_ = new_type;
#line 478 "structure_model.vala"
		_tmp15_ = new_parent;
#line 478 "structure_model.vala"
		_tmp16_ = _tmp15_->data;
#line 478 "structure_model.vala"
		_tmp17_ = (*((StructData*) _tmp16_)).type;
#line 478 "structure_model.vala"
		_tmp12_ = _tmp14_ <= _tmp17_;
#line 2245 "structure_model.c"
	}
#line 478 "structure_model.vala"
	if (_tmp12_) {
#line 2249 "structure_model.c"
		GNode* _tmp18_;
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
#line 481 "structure_model.vala"
		_tmp18_ = node;
#line 481 "structure_model.vala"
		_tmp19_ = _tmp18_->parent;
#line 481 "structure_model.vala"
		new_parent = _tmp19_;
#line 482 "structure_model.vala"
		_tmp20_ = new_parent;
#line 482 "structure_model.vala"
		_tmp21_ = node;
#line 482 "structure_model.vala"
		new_pos = g_node_child_position (_tmp20_, _tmp21_);
#line 2266 "structure_model.c"
	} else {
#line 486 "structure_model.vala"
		new_pos = -1;
#line 2270 "structure_model.c"
	}
#line 490 "structure_model.vala"
	_tmp22_ = node;
#line 490 "structure_model.vala"
	_tmp23_ = structure_model_delete_node (self, _tmp22_);
#line 490 "structure_model.vala"
	node_unlinked = _tmp23_;
#line 492 "structure_model.vala"
	_tmp24_ = node_unlinked;
#line 492 "structure_model.vala"
	structure_model_shift_node (self, _tmp24_, TRUE);
#line 494 "structure_model.vala"
	_tmp25_ = new_parent;
#line 494 "structure_model.vala"
	_tmp26_ = node_unlinked;
#line 494 "structure_model.vala"
	node_unlinked = NULL;
#line 494 "structure_model.vala"
	_tmp27_ = g_node_insert (_tmp25_, new_pos, _tmp26_);
#line 494 "structure_model.vala"
	node = _tmp27_;
#line 495 "structure_model.vala"
	_tmp28_ = node;
#line 495 "structure_model.vala"
	structure_model_reinsert_node (self, _tmp28_, FALSE);
#line 464 "structure_model.vala"
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
#line 2298 "structure_model.c"
}

void
structure_model_shift_left (StructureModel* self,
                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	gboolean _tmp6_ = FALSE;
	StructType _tmp7_;
	StructType new_type = 0;
	StructType _tmp9_;
	GNode* new_parent = NULL;
	gint new_pos = 0;
	GNode* parent = NULL;
	GNode* _tmp10_;
	GNode* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GNode* _tmp13_;
	GNode* _tmp14_;
	GNode* sibling = NULL;
	GNode* _tmp26_;
	GNode* _tmp27_;
	GNode* node_unlinked = NULL;
	GNode* _tmp28_;
	GNode* _tmp29_;
	GNode* _tmp30_;
	GNode* _tmp43_;
	GNode* _tmp44_;
	GNode* _tmp45_;
	GNode* _tmp46_;
#line 498 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 498 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 500 "structure_model.vala"
	_tmp0_ = *iter;
#line 500 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 502 "structure_model.vala"
	_tmp1_ = *iter;
#line 502 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 502 "structure_model.vala"
	node = _tmp2_;
#line 503 "structure_model.vala"
	_tmp3_ = node;
#line 503 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 503 "structure_model.vala"
	_tmp5_ = (*((StructData*) _tmp4_)).type;
#line 503 "structure_model.vala"
	type = _tmp5_;
#line 504 "structure_model.vala"
	_tmp7_ = type;
#line 504 "structure_model.vala"
	if (STRUCT_TYPE_PART < _tmp7_) {
#line 2362 "structure_model.c"
		StructType _tmp8_;
#line 504 "structure_model.vala"
		_tmp8_ = type;
#line 504 "structure_model.vala"
		_tmp6_ = _tmp8_ <= STRUCT_TYPE_SUBPARAGRAPH;
#line 2368 "structure_model.c"
	} else {
#line 504 "structure_model.vala"
		_tmp6_ = FALSE;
#line 2372 "structure_model.c"
	}
#line 504 "structure_model.vala"
	g_return_if_fail (_tmp6_);
#line 506 "structure_model.vala"
	_tmp9_ = type;
#line 506 "structure_model.vala"
	new_type = _tmp9_ - 1;
#line 512 "structure_model.vala"
	_tmp10_ = node;
#line 512 "structure_model.vala"
	_tmp11_ = _tmp10_->parent;
#line 512 "structure_model.vala"
	parent = _tmp11_;
#line 513 "structure_model.vala"
	_tmp13_ = parent;
#line 513 "structure_model.vala"
	_tmp14_ = self->priv->_tree;
#line 513 "structure_model.vala"
	if (_tmp13_ == _tmp14_) {
#line 513 "structure_model.vala"
		_tmp12_ = TRUE;
#line 2394 "structure_model.c"
	} else {
		GNode* _tmp15_;
		gconstpointer _tmp16_;
		StructType _tmp17_;
		StructType _tmp18_;
#line 513 "structure_model.vala"
		_tmp15_ = parent;
#line 513 "structure_model.vala"
		_tmp16_ = _tmp15_->data;
#line 513 "structure_model.vala"
		_tmp17_ = (*((StructData*) _tmp16_)).type;
#line 513 "structure_model.vala"
		_tmp18_ = new_type;
#line 513 "structure_model.vala"
		_tmp12_ = _tmp17_ < _tmp18_;
#line 2410 "structure_model.c"
	}
#line 513 "structure_model.vala"
	if (_tmp12_) {
#line 2414 "structure_model.c"
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
#line 516 "structure_model.vala"
		_tmp19_ = parent;
#line 516 "structure_model.vala"
		new_parent = _tmp19_;
#line 517 "structure_model.vala"
		_tmp20_ = parent;
#line 517 "structure_model.vala"
		_tmp21_ = node;
#line 517 "structure_model.vala"
		new_pos = g_node_child_position (_tmp20_, _tmp21_);
#line 2428 "structure_model.c"
	} else {
		GNode* _tmp22_;
		GNode* _tmp23_;
		GNode* _tmp24_;
		GNode* _tmp25_;
#line 521 "structure_model.vala"
		_tmp22_ = parent;
#line 521 "structure_model.vala"
		_tmp23_ = _tmp22_->parent;
#line 521 "structure_model.vala"
		new_parent = _tmp23_;
#line 522 "structure_model.vala"
		_tmp24_ = new_parent;
#line 522 "structure_model.vala"
		_tmp25_ = parent;
#line 522 "structure_model.vala"
		new_pos = g_node_child_position (_tmp24_, _tmp25_) + 1;
#line 2446 "structure_model.c"
	}
#line 526 "structure_model.vala"
	_tmp26_ = node;
#line 526 "structure_model.vala"
	_tmp27_ = g_node_next_sibling (_tmp26_);
#line 526 "structure_model.vala"
	sibling = _tmp27_;
#line 528 "structure_model.vala"
	_tmp28_ = node;
#line 528 "structure_model.vala"
	_tmp29_ = structure_model_delete_node (self, _tmp28_);
#line 528 "structure_model.vala"
	node_unlinked = _tmp29_;
#line 529 "structure_model.vala"
	_tmp30_ = node_unlinked;
#line 529 "structure_model.vala"
	structure_model_shift_node (self, _tmp30_, FALSE);
#line 532 "structure_model.vala"
	while (TRUE) {
#line 2466 "structure_model.c"
		GNode* _tmp31_;
		GNode* _tmp32_;
		gconstpointer _tmp33_;
		StructType _tmp34_;
		StructType _tmp35_;
		GNode* next_sibling = NULL;
		GNode* _tmp36_;
		GNode* _tmp37_;
		GNode* new_child = NULL;
		GNode* _tmp38_;
		GNode* _tmp39_;
		GNode* _tmp40_;
		GNode* _tmp41_;
		GNode* _tmp42_;
#line 532 "structure_model.vala"
		_tmp31_ = sibling;
#line 532 "structure_model.vala"
		if (!(_tmp31_ != NULL)) {
#line 532 "structure_model.vala"
			break;
#line 2487 "structure_model.c"
		}
#line 534 "structure_model.vala"
		_tmp32_ = sibling;
#line 534 "structure_model.vala"
		_tmp33_ = _tmp32_->data;
#line 534 "structure_model.vala"
		_tmp34_ = (*((StructData*) _tmp33_)).type;
#line 534 "structure_model.vala"
		_tmp35_ = new_type;
#line 534 "structure_model.vala"
		if (_tmp34_ <= _tmp35_) {
#line 535 "structure_model.vala"
			break;
#line 2501 "structure_model.c"
		}
#line 537 "structure_model.vala"
		_tmp36_ = sibling;
#line 537 "structure_model.vala"
		_tmp37_ = g_node_next_sibling (_tmp36_);
#line 537 "structure_model.vala"
		next_sibling = _tmp37_;
#line 539 "structure_model.vala"
		_tmp38_ = sibling;
#line 539 "structure_model.vala"
		_tmp39_ = structure_model_delete_node (self, _tmp38_);
#line 539 "structure_model.vala"
		new_child = _tmp39_;
#line 540 "structure_model.vala"
		_tmp40_ = node_unlinked;
#line 540 "structure_model.vala"
		_tmp41_ = new_child;
#line 540 "structure_model.vala"
		new_child = NULL;
#line 540 "structure_model.vala"
		g_node_append (_tmp40_, _tmp41_);
#line 542 "structure_model.vala"
		_tmp42_ = next_sibling;
#line 542 "structure_model.vala"
		sibling = _tmp42_;
#line 532 "structure_model.vala"
		(new_child == NULL) ? NULL : (new_child = (_g_node_destroy__struct_data_free0_ (new_child), NULL));
#line 2529 "structure_model.c"
	}
#line 546 "structure_model.vala"
	_tmp43_ = new_parent;
#line 546 "structure_model.vala"
	_tmp44_ = node_unlinked;
#line 546 "structure_model.vala"
	node_unlinked = NULL;
#line 546 "structure_model.vala"
	_tmp45_ = g_node_insert (_tmp43_, new_pos, _tmp44_);
#line 546 "structure_model.vala"
	node = _tmp45_;
#line 547 "structure_model.vala"
	_tmp46_ = node;
#line 547 "structure_model.vala"
	structure_model_reinsert_node (self, _tmp46_, FALSE);
#line 498 "structure_model.vala"
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
#line 2547 "structure_model.c"
}

gboolean
structure_model_item_contains_subparagraph (StructureModel* self,
                                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	gboolean result = FALSE;
#line 550 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 550 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 552 "structure_model.vala"
	_tmp0_ = *iter;
#line 552 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 554 "structure_model.vala"
	_tmp1_ = *iter;
#line 554 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 554 "structure_model.vala"
	node = _tmp2_;
#line 555 "structure_model.vala"
	result = structure_model_node_contains_subparagraph (self, node);
#line 555 "structure_model.vala"
	return result;
#line 2577 "structure_model.c"
}

static gboolean
structure_model_node_contains_subparagraph (StructureModel* self,
                                            GNode* node)
{
	StructType type = 0;
	gconstpointer _tmp0_;
	StructType _tmp1_;
	StructType _tmp2_;
	StructType _tmp3_;
	GNode* child = NULL;
	GNode* _tmp4_;
	gboolean result = FALSE;
#line 558 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 558 "structure_model.vala"
	g_return_val_if_fail (node != NULL, FALSE);
#line 560 "structure_model.vala"
	_tmp0_ = node->data;
#line 560 "structure_model.vala"
	_tmp1_ = (*((StructData*) _tmp0_)).type;
#line 560 "structure_model.vala"
	type = _tmp1_;
#line 562 "structure_model.vala"
	_tmp2_ = type;
#line 562 "structure_model.vala"
	if (_tmp2_ == STRUCT_TYPE_SUBPARAGRAPH) {
#line 563 "structure_model.vala"
		result = TRUE;
#line 563 "structure_model.vala"
		return result;
#line 2610 "structure_model.c"
	}
#line 565 "structure_model.vala"
	_tmp3_ = type;
#line 565 "structure_model.vala"
	if (!structure_is_section (_tmp3_)) {
#line 566 "structure_model.vala"
		result = FALSE;
#line 566 "structure_model.vala"
		return result;
#line 2620 "structure_model.c"
	}
#line 568 "structure_model.vala"
	_tmp4_ = g_node_first_child (node);
#line 568 "structure_model.vala"
	child = _tmp4_;
#line 569 "structure_model.vala"
	while (TRUE) {
#line 2628 "structure_model.c"
		GNode* _tmp5_;
		GNode* _tmp6_;
		GNode* _tmp7_;
		GNode* _tmp8_;
#line 569 "structure_model.vala"
		_tmp5_ = child;
#line 569 "structure_model.vala"
		if (!(_tmp5_ != NULL)) {
#line 569 "structure_model.vala"
			break;
#line 2639 "structure_model.c"
		}
#line 571 "structure_model.vala"
		_tmp6_ = child;
#line 571 "structure_model.vala"
		if (structure_model_node_contains_subparagraph (self, _tmp6_)) {
#line 572 "structure_model.vala"
			result = TRUE;
#line 572 "structure_model.vala"
			return result;
#line 2649 "structure_model.c"
		}
#line 573 "structure_model.vala"
		_tmp7_ = child;
#line 573 "structure_model.vala"
		_tmp8_ = g_node_next_sibling (_tmp7_);
#line 573 "structure_model.vala"
		child = _tmp8_;
#line 2657 "structure_model.c"
	}
#line 576 "structure_model.vala"
	result = FALSE;
#line 576 "structure_model.vala"
	return result;
#line 2663 "structure_model.c"
}

static void
structure_model_insert_node (StructureModel* self,
                             GNode* node,
                             gboolean force_first_child)
{
	guint _tmp0_;
	gboolean _tmp1_;
	GtkTreeIter item_iter = {0};
	GtkTreeIter* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkTreePath* item_path = NULL;
	GtkTreeIter _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_;
	GNode* parent = NULL;
	GNode* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GNode* _tmp11_;
	GNode* _tmp12_;
	gboolean first_child = FALSE;
	gboolean _tmp15_ = FALSE;
#line 579 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 579 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 581 "structure_model.vala"
	structure_model_new_stamp (self);
#line 582 "structure_model.vala"
	_tmp0_ = self->priv->_nb_nodes;
#line 582 "structure_model.vala"
	self->priv->_nb_nodes = _tmp0_ + 1;
#line 584 "structure_model.vala"
	_tmp1_ = self->priv->_emit_signals;
#line 584 "structure_model.vala"
	if (!_tmp1_) {
#line 585 "structure_model.vala"
		return;
#line 2705 "structure_model.c"
	}
#line 587 "structure_model.vala"
	_tmp2_ = structure_model_create_iter_at_node (self, node);
#line 587 "structure_model.vala"
	_tmp3_ = _tmp2_;
#line 587 "structure_model.vala"
	_tmp4_ = *_tmp3_;
#line 587 "structure_model.vala"
	__vala_GtkTreeIter_free0 (_tmp3_);
#line 587 "structure_model.vala"
	item_iter = _tmp4_;
#line 588 "structure_model.vala"
	_tmp5_ = item_iter;
#line 588 "structure_model.vala"
	_tmp6_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp5_);
#line 588 "structure_model.vala"
	item_path = _tmp6_;
#line 589 "structure_model.vala"
	_tmp7_ = item_path;
#line 589 "structure_model.vala"
	_tmp8_ = item_iter;
#line 589 "structure_model.vala"
	gtk_tree_model_row_inserted ((GtkTreeModel*) self, _tmp7_, &_tmp8_);
#line 593 "structure_model.vala"
	_tmp9_ = node->parent;
#line 593 "structure_model.vala"
	parent = _tmp9_;
#line 594 "structure_model.vala"
	_tmp11_ = parent;
#line 594 "structure_model.vala"
	_tmp12_ = self->priv->_tree;
#line 594 "structure_model.vala"
	if (_tmp11_ != _tmp12_) {
#line 2739 "structure_model.c"
		GNode* _tmp13_;
		GNode* _tmp14_;
#line 594 "structure_model.vala"
		_tmp13_ = parent;
#line 594 "structure_model.vala"
		_tmp14_ = _tmp13_->children;
#line 594 "structure_model.vala"
		_tmp10_ = _tmp14_ == node;
#line 2748 "structure_model.c"
	} else {
#line 594 "structure_model.vala"
		_tmp10_ = FALSE;
#line 2752 "structure_model.c"
	}
#line 594 "structure_model.vala"
	first_child = _tmp10_;
#line 595 "structure_model.vala"
	if (force_first_child) {
#line 595 "structure_model.vala"
		_tmp15_ = TRUE;
#line 2760 "structure_model.c"
	} else {
#line 595 "structure_model.vala"
		_tmp15_ = first_child;
#line 2764 "structure_model.c"
	}
#line 595 "structure_model.vala"
	if (_tmp15_) {
#line 2768 "structure_model.c"
		GtkTreeIter parent_iter = {0};
		GNode* _tmp16_;
		GtkTreeIter* _tmp17_;
		GtkTreeIter* _tmp18_;
		GtkTreeIter _tmp19_;
		GtkTreePath* parent_path = NULL;
		GtkTreeIter _tmp20_;
		GtkTreePath* _tmp21_;
		GtkTreePath* _tmp22_;
		GtkTreeIter _tmp23_;
#line 597 "structure_model.vala"
		_tmp16_ = parent;
#line 597 "structure_model.vala"
		_tmp17_ = structure_model_create_iter_at_node (self, _tmp16_);
#line 597 "structure_model.vala"
		_tmp18_ = _tmp17_;
#line 597 "structure_model.vala"
		_tmp19_ = *_tmp18_;
#line 597 "structure_model.vala"
		__vala_GtkTreeIter_free0 (_tmp18_);
#line 597 "structure_model.vala"
		parent_iter = _tmp19_;
#line 598 "structure_model.vala"
		_tmp20_ = parent_iter;
#line 598 "structure_model.vala"
		_tmp21_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp20_);
#line 598 "structure_model.vala"
		parent_path = _tmp21_;
#line 599 "structure_model.vala"
		_tmp22_ = parent_path;
#line 599 "structure_model.vala"
		_tmp23_ = parent_iter;
#line 599 "structure_model.vala"
		gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp22_, &_tmp23_);
#line 595 "structure_model.vala"
		__vala_GtkTreePath_free0 (parent_path);
#line 2805 "structure_model.c"
	}
#line 579 "structure_model.vala"
	__vala_GtkTreePath_free0 (item_path);
#line 2809 "structure_model.c"
}

static GNode*
g_node_unlink_vala (GNode* self)
{
	void* ptr = NULL;
	void* _tmp0_;
	GNode* result = NULL;
#line 5297 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 5299 "glib-2.0.vapi"
	ptr = self;
#line 5300 "glib-2.0.vapi"
	g_node_unlink (self);
#line 5301 "glib-2.0.vapi"
	_tmp0_ = ptr;
#line 5301 "glib-2.0.vapi"
	ptr = NULL;
#line 5301 "glib-2.0.vapi"
	result = (GNode*) _tmp0_;
#line 5301 "glib-2.0.vapi"
	return result;
#line 2832 "structure_model.c"
}

static GNode*
structure_model_delete_node (StructureModel* self,
                             GNode* node)
{
	GtkTreePath* path = NULL;
	GNode* parent = NULL;
	gboolean _tmp0_;
	GNode* node_unlinked = NULL;
	GNode* _tmp7_;
	GNode* _tmp8_;
	gboolean _tmp9_;
	GNode* result = NULL;
#line 603 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 603 "structure_model.vala"
	g_return_val_if_fail (node != NULL, NULL);
#line 605 "structure_model.vala"
	structure_model_new_stamp (self);
#line 607 "structure_model.vala"
	path = NULL;
#line 608 "structure_model.vala"
	parent = NULL;
#line 609 "structure_model.vala"
	_tmp0_ = self->priv->_emit_signals;
#line 609 "structure_model.vala"
	if (_tmp0_) {
#line 2861 "structure_model.c"
		GtkTreeIter* iter = NULL;
		GtkTreeIter* _tmp1_;
		GtkTreeIter* _tmp2_;
		GtkTreeIter* _tmp3_;
		GtkTreeIter _tmp4_;
		GtkTreePath* _tmp5_;
		GNode* _tmp6_;
#line 611 "structure_model.vala"
		_tmp1_ = structure_model_create_iter_at_node (self, node);
#line 611 "structure_model.vala"
		iter = _tmp1_;
#line 612 "structure_model.vala"
		_tmp2_ = iter;
#line 612 "structure_model.vala"
		g_return_val_if_fail (_tmp2_ != NULL, NULL);
#line 614 "structure_model.vala"
		_tmp3_ = iter;
#line 614 "structure_model.vala"
		_tmp4_ = *_tmp3_;
#line 614 "structure_model.vala"
		_tmp5_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp4_);
#line 614 "structure_model.vala"
		__vala_GtkTreePath_free0 (path);
#line 614 "structure_model.vala"
		path = _tmp5_;
#line 615 "structure_model.vala"
		_tmp6_ = node->parent;
#line 615 "structure_model.vala"
		parent = _tmp6_;
#line 609 "structure_model.vala"
		__vala_GtkTreeIter_free0 (iter);
#line 2893 "structure_model.c"
	}
#line 618 "structure_model.vala"
	_tmp7_ = g_node_unlink_vala (node);
#line 618 "structure_model.vala"
	node_unlinked = _tmp7_;
#line 619 "structure_model.vala"
	_tmp8_ = node_unlinked;
#line 619 "structure_model.vala"
	self->priv->_nb_nodes = self->priv->_nb_nodes - g_node_n_nodes (_tmp8_, G_TRAVERSE_ALL);
#line 621 "structure_model.vala"
	_tmp9_ = self->priv->_emit_signals;
#line 621 "structure_model.vala"
	if (_tmp9_) {
#line 2907 "structure_model.c"
		GtkTreePath* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GNode* _tmp12_;
		GNode* _tmp13_;
#line 623 "structure_model.vala"
		_tmp10_ = path;
#line 623 "structure_model.vala"
		gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp10_);
#line 625 "structure_model.vala"
		_tmp12_ = parent;
#line 625 "structure_model.vala"
		_tmp13_ = self->priv->_tree;
#line 625 "structure_model.vala"
		if (_tmp12_ != _tmp13_) {
#line 2922 "structure_model.c"
			GNode* _tmp14_;
			GNode* _tmp15_;
#line 625 "structure_model.vala"
			_tmp14_ = parent;
#line 625 "structure_model.vala"
			_tmp15_ = _tmp14_->children;
#line 625 "structure_model.vala"
			_tmp11_ = _tmp15_ == NULL;
#line 2931 "structure_model.c"
		} else {
#line 625 "structure_model.vala"
			_tmp11_ = FALSE;
#line 2935 "structure_model.c"
		}
#line 625 "structure_model.vala"
		if (_tmp11_) {
#line 2939 "structure_model.c"
			GtkTreeIter parent_iter = {0};
			GNode* _tmp16_;
			GtkTreeIter* _tmp17_;
			GtkTreeIter* _tmp18_;
			GtkTreeIter _tmp19_;
			GtkTreePath* parent_path = NULL;
			GtkTreeIter _tmp20_;
			GtkTreePath* _tmp21_;
			GtkTreePath* _tmp22_;
			GtkTreeIter _tmp23_;
#line 627 "structure_model.vala"
			_tmp16_ = parent;
#line 627 "structure_model.vala"
			_tmp17_ = structure_model_create_iter_at_node (self, _tmp16_);
#line 627 "structure_model.vala"
			_tmp18_ = _tmp17_;
#line 627 "structure_model.vala"
			_tmp19_ = *_tmp18_;
#line 627 "structure_model.vala"
			__vala_GtkTreeIter_free0 (_tmp18_);
#line 627 "structure_model.vala"
			parent_iter = _tmp19_;
#line 628 "structure_model.vala"
			_tmp20_ = parent_iter;
#line 628 "structure_model.vala"
			_tmp21_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp20_);
#line 628 "structure_model.vala"
			parent_path = _tmp21_;
#line 629 "structure_model.vala"
			_tmp22_ = parent_path;
#line 629 "structure_model.vala"
			_tmp23_ = parent_iter;
#line 629 "structure_model.vala"
			gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp22_, &_tmp23_);
#line 625 "structure_model.vala"
			__vala_GtkTreePath_free0 (parent_path);
#line 2976 "structure_model.c"
		}
	}
#line 633 "structure_model.vala"
	result = node_unlinked;
#line 633 "structure_model.vala"
	__vala_GtkTreePath_free0 (path);
#line 633 "structure_model.vala"
	return result;
#line 2985 "structure_model.c"
}

static void
structure_model_shift_node (StructureModel* self,
                            GNode* node,
                            gboolean shift_right)
{
	gconstpointer _tmp0_;
	StructType _tmp1_;
	GNode* child = NULL;
	GNode* _tmp12_;
#line 636 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 636 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 638 "structure_model.vala"
	_tmp0_ = node->data;
#line 638 "structure_model.vala"
	_tmp1_ = (*((StructData*) _tmp0_)).type;
#line 638 "structure_model.vala"
	if (!structure_is_section (_tmp1_)) {
#line 639 "structure_model.vala"
		return;
#line 3009 "structure_model.c"
	}
#line 641 "structure_model.vala"
	if (shift_right) {
#line 3013 "structure_model.c"
		gconstpointer _tmp2_;
		StructType _tmp3_;
#line 643 "structure_model.vala"
		_tmp2_ = node->data;
#line 643 "structure_model.vala"
		_tmp3_ = (*((StructData*) _tmp2_)).type;
#line 643 "structure_model.vala"
		if (_tmp3_ != STRUCT_TYPE_SUBPARAGRAPH) {
#line 3022 "structure_model.c"
			gconstpointer _tmp4_;
			gconstpointer _tmp5_;
			StructType _tmp6_;
#line 644 "structure_model.vala"
			_tmp4_ = node->data;
#line 644 "structure_model.vala"
			_tmp5_ = node->data;
#line 644 "structure_model.vala"
			_tmp6_ = (*((StructData*) _tmp5_)).type;
#line 644 "structure_model.vala"
			(*((StructData*) _tmp5_)).type = _tmp6_ + 1;
#line 3034 "structure_model.c"
		}
	} else {
		gconstpointer _tmp7_;
		StructType _tmp8_;
#line 646 "structure_model.vala"
		_tmp7_ = node->data;
#line 646 "structure_model.vala"
		_tmp8_ = (*((StructData*) _tmp7_)).type;
#line 646 "structure_model.vala"
		if (_tmp8_ != STRUCT_TYPE_PART) {
#line 3045 "structure_model.c"
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			StructType _tmp11_;
#line 647 "structure_model.vala"
			_tmp9_ = node->data;
#line 647 "structure_model.vala"
			_tmp10_ = node->data;
#line 647 "structure_model.vala"
			_tmp11_ = (*((StructData*) _tmp10_)).type;
#line 647 "structure_model.vala"
			(*((StructData*) _tmp10_)).type = _tmp11_ - 1;
#line 3057 "structure_model.c"
		}
	}
#line 649 "structure_model.vala"
	_tmp12_ = g_node_first_child (node);
#line 649 "structure_model.vala"
	child = _tmp12_;
#line 650 "structure_model.vala"
	while (TRUE) {
#line 3066 "structure_model.c"
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
		GNode* _tmp16_;
#line 650 "structure_model.vala"
		_tmp13_ = child;
#line 650 "structure_model.vala"
		if (!(_tmp13_ != NULL)) {
#line 650 "structure_model.vala"
			break;
#line 3077 "structure_model.c"
		}
#line 652 "structure_model.vala"
		_tmp14_ = child;
#line 652 "structure_model.vala"
		structure_model_shift_node (self, _tmp14_, shift_right);
#line 653 "structure_model.vala"
		_tmp15_ = child;
#line 653 "structure_model.vala"
		_tmp16_ = g_node_next_sibling (_tmp15_);
#line 653 "structure_model.vala"
		child = _tmp16_;
#line 3089 "structure_model.c"
	}
}

static void
structure_model_reinsert_node (StructureModel* self,
                               GNode* node,
                               gboolean force_first_child)
{
	GNode* child = NULL;
	GNode* _tmp0_;
	gboolean first_child = FALSE;
#line 657 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 657 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 659 "structure_model.vala"
	structure_model_insert_node (self, node, force_first_child);
#line 661 "structure_model.vala"
	_tmp0_ = g_node_first_child (node);
#line 661 "structure_model.vala"
	child = _tmp0_;
#line 662 "structure_model.vala"
	first_child = TRUE;
#line 664 "structure_model.vala"
	while (TRUE) {
#line 3115 "structure_model.c"
		GNode* _tmp1_;
		GNode* _tmp2_;
		GNode* _tmp3_;
		GNode* _tmp4_;
#line 664 "structure_model.vala"
		_tmp1_ = child;
#line 664 "structure_model.vala"
		if (!(_tmp1_ != NULL)) {
#line 664 "structure_model.vala"
			break;
#line 3126 "structure_model.c"
		}
#line 666 "structure_model.vala"
		_tmp2_ = child;
#line 666 "structure_model.vala"
		structure_model_reinsert_node (self, _tmp2_, first_child);
#line 667 "structure_model.vala"
		_tmp3_ = child;
#line 667 "structure_model.vala"
		_tmp4_ = g_node_next_sibling (_tmp3_);
#line 667 "structure_model.vala"
		child = _tmp4_;
#line 668 "structure_model.vala"
		first_child = FALSE;
#line 3140 "structure_model.c"
	}
}

static GtkTreeIter*
structure_model_insert_item_after (StructureModel* self,
                                   GNode* parent,
                                   GNode* sibling,
                                   StructData* item)
{
	StructData _tmp0_;
	const gchar* _tmp1_;
	GNode* new_node = NULL;
	StructData _tmp2_;
	StructData _tmp3_;
	StructData* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* result = NULL;
#line 672 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 672 "structure_model.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 672 "structure_model.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 675 "structure_model.vala"
	_tmp0_ = *item;
#line 675 "structure_model.vala"
	_tmp1_ = _tmp0_.text;
#line 675 "structure_model.vala"
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
#line 677 "structure_model.vala"
	_tmp2_ = *item;
#line 677 "structure_model.vala"
	_tmp3_ = _tmp2_;
#line 677 "structure_model.vala"
	_tmp4_ = _struct_data_dup0 (&_tmp3_);
#line 677 "structure_model.vala"
	_tmp5_ = g_node_new (_tmp4_);
#line 677 "structure_model.vala"
	_tmp6_ = g_node_insert_after (parent, sibling, _tmp5_);
#line 677 "structure_model.vala"
	new_node = _tmp6_;
#line 680 "structure_model.vala"
	structure_model_insert_node (self, new_node, FALSE);
#line 681 "structure_model.vala"
	structure_model_insert_node_in_list (self, new_node);
#line 683 "structure_model.vala"
	_tmp7_ = structure_model_create_iter_at_node (self, new_node);
#line 683 "structure_model.vala"
	result = _tmp7_;
#line 683 "structure_model.vala"
	return result;
#line 3194 "structure_model.c"
}

static void
structure_model_make_children_between_marks (StructureModel* self,
                                             GNode* node)
{
	StructData data = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_;
	StructData _tmp2_ = {0};
	StructData _tmp3_;
	GtkTextMark* _tmp4_;
	GNode* sibling = NULL;
	GNode* _tmp5_;
#line 686 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 686 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 688 "structure_model.vala"
	_tmp0_ = node->data;
#line 688 "structure_model.vala"
	_tmp1_ = *((StructData*) _tmp0_);
#line 688 "structure_model.vala"
	struct_data_copy (&_tmp1_, &_tmp2_);
#line 688 "structure_model.vala"
	data = _tmp2_;
#line 689 "structure_model.vala"
	_tmp3_ = data;
#line 689 "structure_model.vala"
	_tmp4_ = _tmp3_.end_mark;
#line 689 "structure_model.vala"
	if (_tmp4_ == NULL) {
#line 690 "structure_model.vala"
		struct_data_destroy (&data);
#line 690 "structure_model.vala"
		return;
#line 3231 "structure_model.c"
	}
#line 692 "structure_model.vala"
	_tmp5_ = g_node_next_sibling (node);
#line 692 "structure_model.vala"
	sibling = _tmp5_;
#line 693 "structure_model.vala"
	while (TRUE) {
#line 3239 "structure_model.c"
		GNode* _tmp6_;
		StructData sibling_data = {0};
		GNode* _tmp7_;
		gconstpointer _tmp8_;
		StructData _tmp9_;
		StructData _tmp10_ = {0};
		StructData _tmp11_;
		StructType _tmp12_;
		StructData _tmp13_;
		GtkTextMark* _tmp14_;
		StructData _tmp15_;
		GtkTextMark* _tmp16_;
		GNode* sibling_unlinked = NULL;
		GNode* _tmp17_;
		GNode* _tmp18_;
		GNode* new_child = NULL;
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
		GNode* _tmp22_;
#line 693 "structure_model.vala"
		_tmp6_ = sibling;
#line 693 "structure_model.vala"
		if (!(_tmp6_ != NULL)) {
#line 693 "structure_model.vala"
			break;
#line 3266 "structure_model.c"
		}
#line 695 "structure_model.vala"
		_tmp7_ = sibling;
#line 695 "structure_model.vala"
		_tmp8_ = _tmp7_->data;
#line 695 "structure_model.vala"
		_tmp9_ = *((StructData*) _tmp8_);
#line 695 "structure_model.vala"
		struct_data_copy (&_tmp9_, &_tmp10_);
#line 695 "structure_model.vala"
		sibling_data = _tmp10_;
#line 697 "structure_model.vala"
		_tmp11_ = sibling_data;
#line 697 "structure_model.vala"
		_tmp12_ = _tmp11_.type;
#line 697 "structure_model.vala"
		if (structure_is_section (_tmp12_)) {
#line 698 "structure_model.vala"
			struct_data_destroy (&sibling_data);
#line 698 "structure_model.vala"
			break;
#line 3288 "structure_model.c"
		}
#line 701 "structure_model.vala"
		_tmp13_ = data;
#line 701 "structure_model.vala"
		_tmp14_ = _tmp13_.end_mark;
#line 701 "structure_model.vala"
		_tmp15_ = sibling_data;
#line 701 "structure_model.vala"
		_tmp16_ = _tmp15_.start_mark;
#line 701 "structure_model.vala"
		if (structure_model_compare_nodes (_tmp14_, _tmp16_) <= 0) {
#line 702 "structure_model.vala"
			struct_data_destroy (&sibling_data);
#line 702 "structure_model.vala"
			break;
#line 3304 "structure_model.c"
		}
#line 705 "structure_model.vala"
		_tmp17_ = sibling;
#line 705 "structure_model.vala"
		_tmp18_ = structure_model_delete_node (self, _tmp17_);
#line 705 "structure_model.vala"
		sibling_unlinked = _tmp18_;
#line 708 "structure_model.vala"
		_tmp19_ = sibling_unlinked;
#line 708 "structure_model.vala"
		sibling_unlinked = NULL;
#line 708 "structure_model.vala"
		_tmp20_ = g_node_append (node, _tmp19_);
#line 708 "structure_model.vala"
		new_child = _tmp20_;
#line 709 "structure_model.vala"
		_tmp21_ = new_child;
#line 709 "structure_model.vala"
		structure_model_insert_node (self, _tmp21_, FALSE);
#line 711 "structure_model.vala"
		_tmp22_ = g_node_next_sibling (node);
#line 711 "structure_model.vala"
		sibling = _tmp22_;
#line 693 "structure_model.vala"
		(sibling_unlinked == NULL) ? NULL : (sibling_unlinked = (_g_node_destroy__struct_data_free0_ (sibling_unlinked), NULL));
#line 693 "structure_model.vala"
		struct_data_destroy (&sibling_data);
#line 3332 "structure_model.c"
	}
#line 686 "structure_model.vala"
	struct_data_destroy (&data);
#line 3336 "structure_model.c"
}

static void
structure_model_search_end_node (StructureModel* self)
{
	GNode* _tmp0_;
#line 715 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 717 "structure_model.vala"
	_tmp0_ = self->priv->_tree;
#line 717 "structure_model.vala"
	self->priv->_end_node = _tmp0_;
#line 718 "structure_model.vala"
	while (TRUE) {
#line 3351 "structure_model.c"
		GNode* _tmp1_;
		GNode* _tmp2_;
		GNode* _tmp3_;
#line 718 "structure_model.vala"
		_tmp1_ = self->priv->_end_node;
#line 718 "structure_model.vala"
		if (!(!G_NODE_IS_LEAF (_tmp1_))) {
#line 718 "structure_model.vala"
			break;
#line 3361 "structure_model.c"
		}
#line 719 "structure_model.vala"
		_tmp2_ = self->priv->_end_node;
#line 719 "structure_model.vala"
		_tmp3_ = g_node_last_child (_tmp2_);
#line 719 "structure_model.vala"
		self->priv->_end_node = _tmp3_;
#line 3369 "structure_model.c"
	}
}

static gint
structure_model_compare_nodes (GtkTextMark* mark1,
                               GtkTextMark* mark2)
{
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter iter1 = {0};
	GtkTextIter iter2 = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	gint result = 0;
#line 726 "structure_model.vala"
	g_return_val_if_fail (mark1 != NULL, 0);
#line 726 "structure_model.vala"
	g_return_val_if_fail (mark2 != NULL, 0);
#line 728 "structure_model.vala"
	_tmp0_ = gtk_text_mark_get_buffer (mark1);
#line 728 "structure_model.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 728 "structure_model.vala"
	doc = _tmp1_;
#line 730 "structure_model.vala"
	_tmp2_ = gtk_text_mark_get_buffer (mark2);
#line 730 "structure_model.vala"
	g_return_val_if_fail (doc == _tmp2_, 0);
#line 735 "structure_model.vala"
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp3_, mark1);
#line 735 "structure_model.vala"
	iter1 = _tmp3_;
#line 736 "structure_model.vala"
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp4_, mark2);
#line 736 "structure_model.vala"
	iter2 = _tmp4_;
#line 738 "structure_model.vala"
	_tmp5_ = iter2;
#line 738 "structure_model.vala"
	result = gtk_text_iter_compare (&iter1, &_tmp5_);
#line 738 "structure_model.vala"
	_g_object_unref0 (doc);
#line 738 "structure_model.vala"
	return result;
#line 3417 "structure_model.c"
}

/*************************************************************************/
void
structure_model_populate_list (StructureModel* self,
                               GtkListStore* store,
                               StructType type)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 745 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 745 "structure_model.vala"
	g_return_if_fail (store != NULL);
#line 747 "structure_model.vala"
	_tmp0_ = structure_model_get_list (self, type);
#line 747 "structure_model.vala"
	list = _tmp0_;
#line 748 "structure_model.vala"
	_tmp1_ = list;
#line 748 "structure_model.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 3441 "structure_model.c"
	{
		GeeArrayList* _node_list = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _node_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _node_index = 0;
#line 750 "structure_model.vala"
		_tmp2_ = list;
#line 750 "structure_model.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 750 "structure_model.vala"
		_node_list = _tmp3_;
#line 750 "structure_model.vala"
		_tmp4_ = _node_list;
#line 750 "structure_model.vala"
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
#line 750 "structure_model.vala"
		_tmp6_ = _tmp5_;
#line 750 "structure_model.vala"
		_node_size = _tmp6_;
#line 750 "structure_model.vala"
		_node_index = -1;
#line 750 "structure_model.vala"
		while (TRUE) {
#line 3469 "structure_model.c"
			GNode* node = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			StructData data = {0};
			GNode* _tmp9_;
			gconstpointer _tmp10_;
			StructData _tmp11_;
			StructData _tmp12_ = {0};
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp13_ = {0};
			GtkTreeIter _tmp14_;
			StructData _tmp15_;
			StructType _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			StructData _tmp19_;
			const gchar* _tmp20_;
			StructData _tmp21_;
			StructType _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
#line 750 "structure_model.vala"
			_node_index = _node_index + 1;
#line 750 "structure_model.vala"
			if (!(_node_index < _node_size)) {
#line 750 "structure_model.vala"
				break;
#line 3497 "structure_model.c"
			}
#line 750 "structure_model.vala"
			_tmp7_ = _node_list;
#line 750 "structure_model.vala"
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _node_index);
#line 750 "structure_model.vala"
			node = (GNode*) _tmp8_;
#line 752 "structure_model.vala"
			_tmp9_ = node;
#line 752 "structure_model.vala"
			_tmp10_ = _tmp9_->data;
#line 752 "structure_model.vala"
			_tmp11_ = *((StructData*) _tmp10_);
#line 752 "structure_model.vala"
			struct_data_copy (&_tmp11_, &_tmp12_);
#line 752 "structure_model.vala"
			data = _tmp12_;
#line 755 "structure_model.vala"
			gtk_list_store_append (store, &_tmp13_);
#line 755 "structure_model.vala"
			iter = _tmp13_;
#line 756 "structure_model.vala"
			_tmp14_ = iter;
#line 756 "structure_model.vala"
			_tmp15_ = data;
#line 756 "structure_model.vala"
			_tmp16_ = _tmp15_.type;
#line 756 "structure_model.vala"
			_tmp17_ = structure_get_icon_from_type (_tmp16_);
#line 756 "structure_model.vala"
			_tmp18_ = _tmp17_;
#line 756 "structure_model.vala"
			_tmp19_ = data;
#line 756 "structure_model.vala"
			_tmp20_ = _tmp19_.text;
#line 756 "structure_model.vala"
			_tmp21_ = data;
#line 756 "structure_model.vala"
			_tmp22_ = _tmp21_.type;
#line 756 "structure_model.vala"
			_tmp23_ = structure_get_type_name (_tmp22_);
#line 756 "structure_model.vala"
			_tmp24_ = _tmp23_;
#line 756 "structure_model.vala"
			gtk_list_store_set (store, &_tmp14_, STRUCT_LIST_COLUMN_PIXBUF, _tmp18_, STRUCT_LIST_COLUMN_TEXT, _tmp20_, STRUCT_LIST_COLUMN_TOOLTIP, _tmp24_, -1);
#line 756 "structure_model.vala"
			_g_free0 (_tmp24_);
#line 756 "structure_model.vala"
			_g_free0 (_tmp18_);
#line 750 "structure_model.vala"
			struct_data_destroy (&data);
#line 3549 "structure_model.c"
		}
#line 750 "structure_model.vala"
		_g_object_unref0 (_node_list);
#line 3553 "structure_model.c"
	}
#line 745 "structure_model.vala"
	_g_object_unref0 (list);
#line 3557 "structure_model.c"
}

GtkTreePath*
structure_model_get_tree_path_from_list_num (StructureModel* self,
                                             StructType list_type,
                                             gint num)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	GtkTreeIter* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter _tmp10_;
	GtkTreePath* _tmp11_;
	GtkTreePath* _tmp12_;
	GtkTreePath* result = NULL;
#line 764 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 766 "structure_model.vala"
	_tmp0_ = structure_model_get_list (self, list_type);
#line 766 "structure_model.vala"
	list = _tmp0_;
#line 767 "structure_model.vala"
	_tmp1_ = list;
#line 767 "structure_model.vala"
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
#line 769 "structure_model.vala"
	if (0 <= num) {
#line 3589 "structure_model.c"
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 769 "structure_model.vala"
		_tmp3_ = list;
#line 769 "structure_model.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 769 "structure_model.vala"
		_tmp5_ = _tmp4_;
#line 769 "structure_model.vala"
		_tmp2_ = num < _tmp5_;
#line 3601 "structure_model.c"
	} else {
#line 769 "structure_model.vala"
		_tmp2_ = FALSE;
#line 3605 "structure_model.c"
	}
#line 769 "structure_model.vala"
	g_return_val_if_fail (_tmp2_, NULL);
#line 771 "structure_model.vala"
	_tmp6_ = list;
#line 771 "structure_model.vala"
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, num);
#line 771 "structure_model.vala"
	_tmp8_ = structure_model_create_iter_at_node (self, (GNode*) _tmp7_);
#line 771 "structure_model.vala"
	_tmp9_ = _tmp8_;
#line 771 "structure_model.vala"
	_tmp10_ = *_tmp9_;
#line 771 "structure_model.vala"
	_tmp11_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp10_);
#line 771 "structure_model.vala"
	_tmp12_ = _tmp11_;
#line 771 "structure_model.vala"
	__vala_GtkTreeIter_free0 (_tmp9_);
#line 771 "structure_model.vala"
	result = _tmp12_;
#line 771 "structure_model.vala"
	_g_object_unref0 (list);
#line 771 "structure_model.vala"
	return result;
#line 3631 "structure_model.c"
}

gint
structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                             GtkTreeIter* tree_iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GeeArrayList* list = NULL;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint result = 0;
#line 775 "structure_model.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 775 "structure_model.vala"
	g_return_val_if_fail (tree_iter != NULL, 0);
#line 777 "structure_model.vala"
	_tmp0_ = *tree_iter;
#line 777 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), -1);
#line 779 "structure_model.vala"
	_tmp1_ = *tree_iter;
#line 779 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 779 "structure_model.vala"
	node = _tmp2_;
#line 781 "structure_model.vala"
	_tmp3_ = node;
#line 781 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 781 "structure_model.vala"
	_tmp5_ = (*((StructData*) _tmp4_)).type;
#line 781 "structure_model.vala"
	_tmp6_ = structure_model_get_list (self, _tmp5_);
#line 781 "structure_model.vala"
	list = _tmp6_;
#line 782 "structure_model.vala"
	_tmp7_ = list;
#line 782 "structure_model.vala"
	g_return_val_if_fail (_tmp7_ != NULL, -1);
#line 3677 "structure_model.c"
	{
		gint num = 0;
#line 784 "structure_model.vala"
		num = 0;
#line 3682 "structure_model.c"
		{
			gboolean _tmp8_ = FALSE;
#line 784 "structure_model.vala"
			_tmp8_ = TRUE;
#line 784 "structure_model.vala"
			while (TRUE) {
#line 3689 "structure_model.c"
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				GNode* _tmp15_;
#line 784 "structure_model.vala"
				if (!_tmp8_) {
#line 3698 "structure_model.c"
					gint _tmp9_;
#line 784 "structure_model.vala"
					_tmp9_ = num;
#line 784 "structure_model.vala"
					num = _tmp9_ + 1;
#line 3704 "structure_model.c"
				}
#line 784 "structure_model.vala"
				_tmp8_ = FALSE;
#line 784 "structure_model.vala"
				_tmp10_ = list;
#line 784 "structure_model.vala"
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
#line 784 "structure_model.vala"
				_tmp12_ = _tmp11_;
#line 784 "structure_model.vala"
				if (!(num < _tmp12_)) {
#line 784 "structure_model.vala"
					break;
#line 3718 "structure_model.c"
				}
#line 786 "structure_model.vala"
				_tmp13_ = list;
#line 786 "structure_model.vala"
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, num);
#line 786 "structure_model.vala"
				_tmp15_ = node;
#line 786 "structure_model.vala"
				if (((GNode*) _tmp14_) == _tmp15_) {
#line 787 "structure_model.vala"
					result = num;
#line 787 "structure_model.vala"
					_g_object_unref0 (list);
#line 787 "structure_model.vala"
					return result;
#line 3734 "structure_model.c"
				}
			}
		}
	}
#line 790 "structure_model.vala"
	g_return_val_if_reached (-1);
#line 775 "structure_model.vala"
	_g_object_unref0 (list);
#line 3743 "structure_model.c"
}

static void
structure_model_insert_node_in_list (StructureModel* self,
                                     GNode* node)
{
	StructData item = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_;
	StructData _tmp2_ = {0};
	GeeArrayList* list = NULL;
	StructData _tmp3_;
	StructType _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
#line 793 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 793 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 795 "structure_model.vala"
	_tmp0_ = node->data;
#line 795 "structure_model.vala"
	_tmp1_ = *((StructData*) _tmp0_);
#line 795 "structure_model.vala"
	struct_data_copy (&_tmp1_, &_tmp2_);
#line 795 "structure_model.vala"
	item = _tmp2_;
#line 797 "structure_model.vala"
	_tmp3_ = item;
#line 797 "structure_model.vala"
	_tmp4_ = _tmp3_.type;
#line 797 "structure_model.vala"
	_tmp5_ = structure_model_get_list (self, _tmp4_);
#line 797 "structure_model.vala"
	list = _tmp5_;
#line 798 "structure_model.vala"
	_tmp6_ = list;
#line 798 "structure_model.vala"
	if (_tmp6_ != NULL) {
#line 3783 "structure_model.c"
		GeeArrayList* _tmp7_;
#line 799 "structure_model.vala"
		_tmp7_ = list;
#line 799 "structure_model.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, node);
#line 3789 "structure_model.c"
	}
#line 793 "structure_model.vala"
	_g_object_unref0 (list);
#line 793 "structure_model.vala"
	struct_data_destroy (&item);
#line 3795 "structure_model.c"
}

static gboolean
__lambda42_ (StructureModel* self,
             GNode* node)
{
	gboolean result = FALSE;
#line 806 "structure_model.vala"
	g_return_val_if_fail (node != NULL, FALSE);
#line 808 "structure_model.vala"
	structure_model_insert_node_in_list (self, node);
#line 811 "structure_model.vala"
	result = FALSE;
#line 811 "structure_model.vala"
	return result;
#line 3811 "structure_model.c"
}

static gboolean
___lambda42__gnode_traverse_func (GNode* node,
                                  gpointer self)
{
	gboolean result;
	result = __lambda42_ ((StructureModel*) self, node);
#line 806 "structure_model.vala"
	return result;
#line 3822 "structure_model.c"
}

static void
structure_model_regenerate_simple_lists (StructureModel* self)
{
	GNode* _tmp0_;
#line 802 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 804 "structure_model.vala"
	structure_model_reset_simple_lists (self);
#line 806 "structure_model.vala"
	_tmp0_ = self->priv->_tree;
#line 806 "structure_model.vala"
	g_node_traverse (_tmp0_, G_PRE_ORDER, G_TRAVERSE_ALL, -1, ___lambda42__gnode_traverse_func, self);
#line 3837 "structure_model.c"
}

static void
structure_model_reset_simple_lists (StructureModel* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
#line 815 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 817 "structure_model.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 817 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_labels);
#line 817 "structure_model.vala"
	self->priv->_list_labels = _tmp0_;
#line 818 "structure_model.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 818 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_includes);
#line 818 "structure_model.vala"
	self->priv->_list_includes = _tmp1_;
#line 819 "structure_model.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 819 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_tables);
#line 819 "structure_model.vala"
	self->priv->_list_tables = _tmp2_;
#line 820 "structure_model.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 820 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_figures);
#line 820 "structure_model.vala"
	self->priv->_list_figures = _tmp3_;
#line 821 "structure_model.vala"
	_tmp4_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 821 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
#line 821 "structure_model.vala"
	self->priv->_list_todos_and_fixmes = _tmp4_;
#line 3880 "structure_model.c"
}

static GeeArrayList*
structure_model_get_list (StructureModel* self,
                          StructType type)
{
	GeeArrayList* result = NULL;
#line 824 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 826 "structure_model.vala"
	if (structure_is_section (type)) {
#line 827 "structure_model.vala"
		result = NULL;
#line 827 "structure_model.vala"
		return result;
#line 3896 "structure_model.c"
	}
#line 829 "structure_model.vala"
	switch (type) {
#line 829 "structure_model.vala"
		case STRUCT_TYPE_LABEL:
#line 3902 "structure_model.c"
		{
			GeeArrayList* _tmp0_;
			GeeArrayList* _tmp1_;
#line 832 "structure_model.vala"
			_tmp0_ = self->priv->_list_labels;
#line 832 "structure_model.vala"
			_tmp1_ = _g_object_ref0 (_tmp0_);
#line 832 "structure_model.vala"
			result = _tmp1_;
#line 832 "structure_model.vala"
			return result;
#line 3914 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_INCLUDE:
#line 3918 "structure_model.c"
		{
			GeeArrayList* _tmp2_;
			GeeArrayList* _tmp3_;
#line 835 "structure_model.vala"
			_tmp2_ = self->priv->_list_includes;
#line 835 "structure_model.vala"
			_tmp3_ = _g_object_ref0 (_tmp2_);
#line 835 "structure_model.vala"
			result = _tmp3_;
#line 835 "structure_model.vala"
			return result;
#line 3930 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_TABLE:
#line 3934 "structure_model.c"
		{
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
#line 838 "structure_model.vala"
			_tmp4_ = self->priv->_list_tables;
#line 838 "structure_model.vala"
			_tmp5_ = _g_object_ref0 (_tmp4_);
#line 838 "structure_model.vala"
			result = _tmp5_;
#line 838 "structure_model.vala"
			return result;
#line 3946 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_FIGURE:
#line 829 "structure_model.vala"
		case STRUCT_TYPE_IMAGE:
#line 3952 "structure_model.c"
		{
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
#line 842 "structure_model.vala"
			_tmp6_ = self->priv->_list_figures;
#line 842 "structure_model.vala"
			_tmp7_ = _g_object_ref0 (_tmp6_);
#line 842 "structure_model.vala"
			result = _tmp7_;
#line 842 "structure_model.vala"
			return result;
#line 3964 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_TODO:
#line 829 "structure_model.vala"
		case STRUCT_TYPE_FIXME:
#line 3970 "structure_model.c"
		{
			GeeArrayList* _tmp8_;
			GeeArrayList* _tmp9_;
#line 846 "structure_model.vala"
			_tmp8_ = self->priv->_list_todos_and_fixmes;
#line 846 "structure_model.vala"
			_tmp9_ = _g_object_ref0 (_tmp8_);
#line 846 "structure_model.vala"
			result = _tmp9_;
#line 846 "structure_model.vala"
			return result;
#line 3982 "structure_model.c"
		}
		default:
		{
#line 849 "structure_model.vala"
			result = NULL;
#line 849 "structure_model.vala"
			return result;
#line 3990 "structure_model.c"
		}
	}
}

gboolean
structure_model_get_emit_signals (StructureModel* self)
{
	gboolean result;
#line 75 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 75 "structure_model.vala"
	result = self->priv->_emit_signals;
#line 75 "structure_model.vala"
	return result;
#line 4005 "structure_model.c"
}

void
structure_model_set_emit_signals (StructureModel* self,
                                  gboolean value)
{
#line 75 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 75 "structure_model.vala"
	if (structure_model_get_emit_signals (self) != value) {
#line 75 "structure_model.vala"
		self->priv->_emit_signals = value;
#line 75 "structure_model.vala"
		g_object_notify_by_pspec ((GObject *) self, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY]);
#line 4020 "structure_model.c"
	}
}

static void
structure_model_class_init (StructureModelClass * klass,
                            gpointer klass_data)
{
#line 70 "structure_model.vala"
	structure_model_parent_class = g_type_class_peek_parent (klass);
#line 70 "structure_model.vala"
	g_type_class_adjust_private_offset (klass, &StructureModel_private_offset);
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_structure_model_get_property;
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_structure_model_set_property;
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (klass)->finalize = structure_model_finalize;
#line 70 "structure_model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY] = g_param_spec_boolean ("emit-signals", "emit-signals", "emit-signals", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4040 "structure_model.c"
}

static void
structure_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface,
                                               gpointer iface_data)
{
#line 70 "structure_model.vala"
	structure_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
#line 70 "structure_model.vala"
	iface->get_column_type = (GType (*) (GtkTreeModel*, gint)) structure_model_real_get_column_type;
#line 70 "structure_model.vala"
	iface->get_n_columns = (gint (*) (GtkTreeModel*)) structure_model_real_get_n_columns;
#line 70 "structure_model.vala"
	iface->get_flags = (GtkTreeModelFlags (*) (GtkTreeModel*)) structure_model_real_get_flags;
#line 70 "structure_model.vala"
	iface->iter_has_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_has_child;
#line 70 "structure_model.vala"
	iface->iter_n_children = (gint (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_n_children;
#line 70 "structure_model.vala"
	iface->get_value = (void (*) (GtkTreeModel*, GtkTreeIter*, gint, GValue*)) structure_model_real_get_value;
#line 70 "structure_model.vala"
	iface->iter_children = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_children;
#line 70 "structure_model.vala"
	iface->iter_next = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_next;
#line 70 "structure_model.vala"
	iface->iter_nth_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) structure_model_real_iter_nth_child;
#line 70 "structure_model.vala"
	iface->iter_parent = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_parent;
#line 70 "structure_model.vala"
	iface->get_iter = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) structure_model_real_get_iter;
#line 70 "structure_model.vala"
	iface->get_path = (GtkTreePath* (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_get_path;
#line 4073 "structure_model.c"
}

static void
structure_model_instance_init (StructureModel * self,
                               gpointer klass)
{
#line 70 "structure_model.vala"
	self->priv = structure_model_get_instance_private (self);
#line 75 "structure_model.vala"
	self->priv->_emit_signals = FALSE;
#line 80 "structure_model.vala"
	self->priv->_nb_nodes = (guint) 0;
#line 81 "structure_model.vala"
	self->priv->_end_node = NULL;
#line 4088 "structure_model.c"
}

static void
structure_model_finalize (GObject * obj)
{
	StructureModel * self;
#line 70 "structure_model.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRUCTURE_MODEL, StructureModel);
#line 77 "structure_model.vala"
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
#line 78 "structure_model.vala"
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
#line 83 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_labels);
#line 84 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_includes);
#line 85 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_tables);
#line 86 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_figures);
#line 87 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (structure_model_parent_class)->finalize (obj);
#line 4113 "structure_model.c"
}

GType
structure_model_get_type (void)
{
	static volatile gsize structure_model_type_id__volatile = 0;
	if (g_once_init_enter (&structure_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StructureModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StructureModel), 0, (GInstanceInitFunc) structure_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) structure_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType structure_model_type_id;
		structure_model_type_id = g_type_register_static (G_TYPE_OBJECT, "StructureModel", &g_define_type_info, 0);
		g_type_add_interface_static (structure_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
		StructureModel_private_offset = g_type_add_instance_private (structure_model_type_id, sizeof (StructureModelPrivate));
		g_once_init_leave (&structure_model_type_id__volatile, structure_model_type_id);
	}
	return structure_model_type_id__volatile;
}

static void
_vala_structure_model_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
#line 70 "structure_model.vala"
	switch (property_id) {
#line 70 "structure_model.vala"
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
#line 70 "structure_model.vala"
		g_value_set_boolean (value, structure_model_get_emit_signals (self));
#line 70 "structure_model.vala"
		break;
#line 4148 "structure_model.c"
		default:
#line 70 "structure_model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "structure_model.vala"
		break;
#line 4154 "structure_model.c"
	}
}

static void
_vala_structure_model_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
#line 70 "structure_model.vala"
	switch (property_id) {
#line 70 "structure_model.vala"
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
#line 70 "structure_model.vala"
		structure_model_set_emit_signals (self, g_value_get_boolean (value));
#line 70 "structure_model.vala"
		break;
#line 4174 "structure_model.c"
		default:
#line 70 "structure_model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "structure_model.vala"
		break;
#line 4180 "structure_model.c"
	}
}

