/* main_window_file.c generated by valac 0.46.6, the Vala compiler
 * generated from main_window_file.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <amtk/amtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <latexila.h>
#include <gobject/gvaluecollector.h>

#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;
typedef struct _MainWindowFilePrivate MainWindowFilePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _MainWindowPrivate MainWindowPrivate;
typedef struct _ParamSpecMainWindowFile ParamSpecMainWindowFile;

struct _MainWindowFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowFilePrivate * priv;
};

struct _MainWindowFileClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowFile *self);
};

struct _MainWindowFilePrivate {
	MainWindow* _main_window;
	GtkActionGroup* _action_group;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ParamSpecMainWindowFile {
	GParamSpec parent_instance;
};

static gint MainWindowFile_private_offset;
static gpointer main_window_file_parent_class = NULL;

gpointer main_window_file_ref (gpointer instance);
void main_window_file_unref (gpointer instance);
GParamSpec* param_spec_main_window_file (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_file (GValue* value,
                                 gpointer v_object);
void value_take_main_window_file (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_file (const GValue* value);
GType main_window_file_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowFile, main_window_file_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
void main_window_file_on_file_new (MainWindowFile* self);
static void _main_window_file_on_file_new_gtk_action_callback (GtkAction* action,
                                                        gpointer self);
void main_window_file_on_file_open (MainWindowFile* self);
static void _main_window_file_on_file_open_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_file_on_file_save (MainWindowFile* self);
static void _main_window_file_on_file_save_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_file_on_file_save_as (MainWindowFile* self);
static void _main_window_file_on_file_save_as_gtk_action_callback (GtkAction* action,
                                                            gpointer self);
void main_window_file_on_create_template (MainWindowFile* self);
static void _main_window_file_on_create_template_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
void main_window_file_on_manage_templates (MainWindowFile* self);
static void _main_window_file_on_manage_templates_gtk_action_callback (GtkAction* action,
                                                                gpointer self);
void main_window_file_on_file_close (MainWindowFile* self);
static void _main_window_file_on_file_close_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
MainWindowFile* main_window_file_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowFile* main_window_file_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
static void main_window_file_configure_recent_chooser (MainWindowFile* self,
                                                GtkRecentChooser* recent_chooser);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
static void __lambda60_ (MainWindowFile* self,
                  GtkRecentChooser* chooser);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void ___lambda60__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender,
                                                     gpointer self);
void main_window_file_update_sensitivity (MainWindowFile* self);
TeplTab* tepl_tab_group_get_active_tab (TeplTabGroup* self);
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
Document* document_tab_get_document (DocumentTab* self);
void document_set_contents (Document* self,
                            const gchar* contents);
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
static void main_window_file_finalize (MainWindowFile * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GtkActionEntry MAIN_WINDOW_FILE__action_entries[9] = {{"File", NULL, N_ ("_File")}, {"FileNew", "document-new", N_ ("_New"), "<Control>N", N_ ("New file"), (GCallback) _main_window_file_on_file_new_gtk_action_callback}, {"FileNewWindow", NULL, N_ ("New _Window"), NULL, N_ ("Create a new window")}, {"FileOpen", "document-open", N_ ("_Open"), "<Control>O", N_ ("Open a file"), (GCallback) _main_window_file_on_file_open_gtk_action_callback}, {"FileSave", "document-save", N_ ("_Save"), "<Control>S", N_ ("Save the current file"), (GCallback) _main_window_file_on_file_save_gtk_action_callback}, {"FileSaveAs", "document-save-as", N_ ("Save _As"), "<Shift><Control>S", N_ ("Save the current file with a different name"), (GCallback) _main_window_file_on_file_save_as_gtk_action_callback}, {"FileCreateTemplate", NULL, N_ ("Create _Template From Document…"), NULL, N_ ("Create a new template from the current document"), (GCallback) _main_window_file_on_create_template_gtk_action_callback}, {"FileManageTemplates", NULL, N_ ("_Manage Personal Templates…"), NULL, N_ ("Manage personal templates"), (GCallback) _main_window_file_on_manage_templates_gtk_action_callback}, {"FileClose", "window-close", N_ ("_Close"), "<Control>W", N_ ("Close the current file"), (GCallback) _main_window_file_on_file_close_gtk_action_callback}};

static inline gpointer
main_window_file_get_instance_private (MainWindowFile* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindowFile_private_offset);
}

static void
_main_window_file_on_file_new_gtk_action_callback (GtkAction* action,
                                                   gpointer self)
{
#line 28 "main_window_file.vala"
	main_window_file_on_file_new ((MainWindowFile*) self);
#line 226 "main_window_file.c"
}

static void
_main_window_file_on_file_open_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 28 "main_window_file.vala"
	main_window_file_on_file_open ((MainWindowFile*) self);
#line 235 "main_window_file.c"
}

static void
_main_window_file_on_file_save_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 28 "main_window_file.vala"
	main_window_file_on_file_save ((MainWindowFile*) self);
#line 244 "main_window_file.c"
}

static void
_main_window_file_on_file_save_as_gtk_action_callback (GtkAction* action,
                                                       gpointer self)
{
#line 28 "main_window_file.vala"
	main_window_file_on_file_save_as ((MainWindowFile*) self);
#line 253 "main_window_file.c"
}

static void
_main_window_file_on_create_template_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
#line 28 "main_window_file.vala"
	main_window_file_on_create_template ((MainWindowFile*) self);
#line 262 "main_window_file.c"
}

static void
_main_window_file_on_manage_templates_gtk_action_callback (GtkAction* action,
                                                           gpointer self)
{
#line 28 "main_window_file.vala"
	main_window_file_on_manage_templates ((MainWindowFile*) self);
#line 271 "main_window_file.c"
}

static void
_main_window_file_on_file_close_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
#line 28 "main_window_file.vala"
	main_window_file_on_file_close ((MainWindowFile*) self);
#line 280 "main_window_file.c"
}

MainWindowFile*
main_window_file_construct (GType object_type,
                            MainWindow* main_window,
                            GtkUIManager* ui_manager)
{
	MainWindowFile* self = NULL;
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkAction* recent_action = NULL;
	GtkRecentAction* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkActionGroup* _tmp5_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp6_;
	GtkActionGroup* _tmp7_;
#line 60 "main_window_file.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 60 "main_window_file.vala"
	g_return_val_if_fail (ui_manager != NULL, NULL);
#line 60 "main_window_file.vala"
	self = (MainWindowFile*) g_type_create_instance (object_type);
#line 62 "main_window_file.vala"
	self->priv->_main_window = main_window;
#line 64 "main_window_file.vala"
	_tmp0_ = gtk_action_group_new ("FileMenuActionGroup");
#line 64 "main_window_file.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 64 "main_window_file.vala"
	self->priv->_action_group = _tmp0_;
#line 65 "main_window_file.vala"
	_tmp1_ = self->priv->_action_group;
#line 65 "main_window_file.vala"
	gtk_action_group_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
#line 66 "main_window_file.vala"
	_tmp2_ = self->priv->_action_group;
#line 66 "main_window_file.vala"
	gtk_action_group_add_actions (_tmp2_, MAIN_WINDOW_FILE__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_FILE__action_entries), self);
#line 69 "main_window_file.vala"
	_tmp3_ = (GtkRecentAction*) gtk_recent_action_new ("FileOpenRecent", _ ("Open _Recent"), _ ("Open recently used files"), "");
#line 69 "main_window_file.vala"
	recent_action = (GtkAction*) _tmp3_;
#line 71 "main_window_file.vala"
	main_window_file_configure_recent_chooser (self, G_TYPE_CHECK_INSTANCE_TYPE (recent_action, gtk_recent_chooser_get_type ()) ? ((GtkRecentChooser*) recent_action) : NULL);
#line 72 "main_window_file.vala"
	_tmp4_ = self->priv->_action_group;
#line 72 "main_window_file.vala"
	gtk_action_group_add_action (_tmp4_, recent_action);
#line 74 "main_window_file.vala"
	_tmp5_ = self->priv->_action_group;
#line 74 "main_window_file.vala"
	gtk_ui_manager_insert_action_group (ui_manager, _tmp5_, 0);
#line 76 "main_window_file.vala"
	_tmp6_ = glatex_app_get_instance ();
#line 76 "main_window_file.vala"
	app = _tmp6_;
#line 77 "main_window_file.vala"
	_tmp7_ = self->priv->_action_group;
#line 77 "main_window_file.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "tepl-new-window", _tmp7_, "FileNewWindow");
#line 60 "main_window_file.vala"
	_g_object_unref0 (app);
#line 60 "main_window_file.vala"
	_g_object_unref0 (recent_action);
#line 60 "main_window_file.vala"
	return self;
#line 349 "main_window_file.c"
}

MainWindowFile*
main_window_file_new (MainWindow* main_window,
                      GtkUIManager* ui_manager)
{
#line 60 "main_window_file.vala"
	return main_window_file_construct (TYPE_MAIN_WINDOW_FILE, main_window, ui_manager);
#line 358 "main_window_file.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 83 "main_window_file.vala"
	return self ? g_object_ref (self) : NULL;
#line 366 "main_window_file.c"
}

GtkToolItem*
main_window_file_get_toolbar_open_button (MainWindowFile* self)
{
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_;
	GtkRecentManager* _tmp1_;
	GtkWidget* recent_menu = NULL;
	GtkRecentChooserMenu* _tmp2_;
	GtkMenuToolButton* open_button = NULL;
	GtkMenuToolButton* _tmp3_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp4_;
	GtkAction* _tmp5_;
	GtkAction* _tmp6_;
	GtkToolItem* result = NULL;
#line 81 "main_window_file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "main_window_file.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 83 "main_window_file.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 83 "main_window_file.vala"
	recent_manager = _tmp1_;
#line 84 "main_window_file.vala"
	_tmp2_ = (GtkRecentChooserMenu*) gtk_recent_chooser_menu_new_for_manager (recent_manager);
#line 84 "main_window_file.vala"
	g_object_ref_sink (_tmp2_);
#line 84 "main_window_file.vala"
	recent_menu = (GtkWidget*) _tmp2_;
#line 85 "main_window_file.vala"
	main_window_file_configure_recent_chooser (self, G_TYPE_CHECK_INSTANCE_TYPE (recent_menu, gtk_recent_chooser_get_type ()) ? ((GtkRecentChooser*) recent_menu) : NULL);
#line 87 "main_window_file.vala"
	_tmp3_ = (GtkMenuToolButton*) gtk_menu_tool_button_new (NULL, NULL);
#line 87 "main_window_file.vala"
	g_object_ref_sink (_tmp3_);
#line 87 "main_window_file.vala"
	open_button = _tmp3_;
#line 88 "main_window_file.vala"
	gtk_tool_button_set_icon_name ((GtkToolButton*) open_button, "document-open");
#line 89 "main_window_file.vala"
	gtk_menu_tool_button_set_menu (open_button, recent_menu);
#line 90 "main_window_file.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) open_button, _ ("Open a file"));
#line 91 "main_window_file.vala"
	gtk_menu_tool_button_set_arrow_tooltip_text (open_button, _ ("Open a recently used file"));
#line 93 "main_window_file.vala"
	_tmp4_ = self->priv->_action_group;
#line 93 "main_window_file.vala"
	_tmp5_ = gtk_action_group_get_action (_tmp4_, "FileOpen");
#line 93 "main_window_file.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 93 "main_window_file.vala"
	action = _tmp6_;
#line 94 "main_window_file.vala"
	gtk_activatable_set_related_action ((GtkActivatable*) open_button, action);
#line 96 "main_window_file.vala"
	result = (GtkToolItem*) open_button;
#line 96 "main_window_file.vala"
	_g_object_unref0 (action);
#line 96 "main_window_file.vala"
	_g_object_unref0 (recent_menu);
#line 96 "main_window_file.vala"
	_g_object_unref0 (recent_manager);
#line 96 "main_window_file.vala"
	return result;
#line 434 "main_window_file.c"
}

static void
__lambda60_ (MainWindowFile* self,
             GtkRecentChooser* chooser)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	MainWindow* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
#line 109 "main_window_file.vala"
	g_return_if_fail (chooser != NULL);
#line 111 "main_window_file.vala"
	_tmp0_ = gtk_recent_chooser_get_current_uri (chooser);
#line 111 "main_window_file.vala"
	uri = _tmp0_;
#line 112 "main_window_file.vala"
	_tmp1_ = self->priv->_main_window;
#line 112 "main_window_file.vala"
	_tmp2_ = g_file_new_for_uri (uri);
#line 112 "main_window_file.vala"
	_tmp3_ = _tmp2_;
#line 112 "main_window_file.vala"
	_tmp4_ = main_window_open_document (_tmp1_, _tmp3_, TRUE);
#line 112 "main_window_file.vala"
	_tmp5_ = _tmp4_;
#line 112 "main_window_file.vala"
	_g_object_unref0 (_tmp5_);
#line 112 "main_window_file.vala"
	_g_object_unref0 (_tmp3_);
#line 109 "main_window_file.vala"
	_g_free0 (uri);
#line 470 "main_window_file.c"
}

static void
___lambda60__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender,
                                                gpointer self)
{
#line 109 "main_window_file.vala"
	__lambda60_ ((MainWindowFile*) self, _sender);
#line 479 "main_window_file.c"
}

static void
main_window_file_configure_recent_chooser (MainWindowFile* self,
                                           GtkRecentChooser* recent_chooser)
{
	GtkRecentFilter* filter = NULL;
	GtkRecentFilter* _tmp0_;
#line 99 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 99 "main_window_file.vala"
	g_return_if_fail (recent_chooser != NULL);
#line 101 "main_window_file.vala"
	gtk_recent_chooser_set_local_only (recent_chooser, FALSE);
#line 102 "main_window_file.vala"
	gtk_recent_chooser_set_show_tips (recent_chooser, TRUE);
#line 103 "main_window_file.vala"
	gtk_recent_chooser_set_sort_type (recent_chooser, GTK_RECENT_SORT_MRU);
#line 105 "main_window_file.vala"
	_tmp0_ = gtk_recent_filter_new ();
#line 105 "main_window_file.vala"
	g_object_ref_sink (_tmp0_);
#line 105 "main_window_file.vala"
	filter = _tmp0_;
#line 106 "main_window_file.vala"
	gtk_recent_filter_add_application (filter, PACKAGE_NAME);
#line 107 "main_window_file.vala"
	gtk_recent_chooser_set_filter (recent_chooser, filter);
#line 109 "main_window_file.vala"
	g_signal_connect (recent_chooser, "item-activated", (GCallback) ___lambda60__gtk_recent_chooser_item_activated, self);
#line 99 "main_window_file.vala"
	_g_object_unref0 (filter);
#line 512 "main_window_file.c"
}

void
main_window_file_update_sensitivity (MainWindowFile* self)
{
	TeplApplicationWindow* tepl_window = NULL;
	MainWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplApplicationWindow* _tmp2_;
	gboolean sensitive = FALSE;
	TeplApplicationWindow* _tmp3_;
	TeplTab* _tmp4_;
	TeplTab* _tmp5_;
	gchar** action_names = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint action_names_length1;
	gint _action_names_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
#line 118 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 120 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 120 "main_window_file.vala"
	_tmp1_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) _tmp0_);
#line 120 "main_window_file.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 120 "main_window_file.vala"
	tepl_window = _tmp2_;
#line 122 "main_window_file.vala"
	_tmp3_ = tepl_window;
#line 122 "main_window_file.vala"
	_tmp4_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) _tmp3_);
#line 122 "main_window_file.vala"
	_tmp5_ = _tmp4_;
#line 122 "main_window_file.vala"
	sensitive = _tmp5_ != NULL;
#line 124 "main_window_file.vala"
	_tmp6_ = g_strdup ("FileSave");
#line 124 "main_window_file.vala"
	_tmp7_ = g_strdup ("FileSaveAs");
#line 124 "main_window_file.vala"
	_tmp8_ = g_strdup ("FileClose");
#line 124 "main_window_file.vala"
	_tmp9_ = g_strdup ("FileCreateTemplate");
#line 124 "main_window_file.vala"
	_tmp10_ = g_new0 (gchar*, 4 + 1);
#line 124 "main_window_file.vala"
	_tmp10_[0] = _tmp6_;
#line 124 "main_window_file.vala"
	_tmp10_[1] = _tmp7_;
#line 124 "main_window_file.vala"
	_tmp10_[2] = _tmp8_;
#line 124 "main_window_file.vala"
	_tmp10_[3] = _tmp9_;
#line 124 "main_window_file.vala"
	action_names = _tmp10_;
#line 124 "main_window_file.vala"
	action_names_length1 = 4;
#line 124 "main_window_file.vala"
	_action_names_size_ = action_names_length1;
#line 132 "main_window_file.vala"
	_tmp11_ = action_names;
#line 132 "main_window_file.vala"
	_tmp11__length1 = action_names_length1;
#line 582 "main_window_file.c"
	{
		gchar** action_name_collection = NULL;
		gint action_name_collection_length1 = 0;
		gint _action_name_collection_size_ = 0;
		gint action_name_it = 0;
#line 132 "main_window_file.vala"
		action_name_collection = _tmp11_;
#line 132 "main_window_file.vala"
		action_name_collection_length1 = _tmp11__length1;
#line 132 "main_window_file.vala"
		for (action_name_it = 0; action_name_it < action_name_collection_length1; action_name_it = action_name_it + 1) {
#line 594 "main_window_file.c"
			gchar* _tmp12_;
			gchar* action_name = NULL;
#line 132 "main_window_file.vala"
			_tmp12_ = g_strdup (action_name_collection[action_name_it]);
#line 132 "main_window_file.vala"
			action_name = _tmp12_;
#line 601 "main_window_file.c"
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp13_;
				const gchar* _tmp14_;
				GtkAction* _tmp15_;
				GtkAction* _tmp16_;
				GtkAction* _tmp17_;
#line 134 "main_window_file.vala"
				_tmp13_ = self->priv->_action_group;
#line 134 "main_window_file.vala"
				_tmp14_ = action_name;
#line 134 "main_window_file.vala"
				_tmp15_ = gtk_action_group_get_action (_tmp13_, _tmp14_);
#line 134 "main_window_file.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 134 "main_window_file.vala"
				action = _tmp16_;
#line 135 "main_window_file.vala"
				_tmp17_ = action;
#line 135 "main_window_file.vala"
				gtk_action_set_sensitive (_tmp17_, sensitive);
#line 132 "main_window_file.vala"
				_g_object_unref0 (action);
#line 132 "main_window_file.vala"
				_g_free0 (action_name);
#line 627 "main_window_file.c"
			}
		}
	}
#line 118 "main_window_file.vala"
	action_names = (_vala_array_free (action_names, action_names_length1, (GDestroyNotify) g_free), NULL);
#line 118 "main_window_file.vala"
	_g_object_unref0 (tepl_window);
#line 635 "main_window_file.c"
}

void
main_window_file_on_file_new (MainWindowFile* self)
{
	gchar* contents = NULL;
	MainWindow* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 141 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 143 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 143 "main_window_file.vala"
	_tmp1_ = latexila_templates_dialogs_open ((GtkWindow*) _tmp0_);
#line 143 "main_window_file.vala"
	contents = _tmp1_;
#line 145 "main_window_file.vala"
	_tmp2_ = contents;
#line 145 "main_window_file.vala"
	if (_tmp2_ != NULL) {
#line 657 "main_window_file.c"
		DocumentTab* tab = NULL;
		MainWindow* _tmp3_;
		DocumentTab* _tmp4_;
		DocumentTab* _tmp5_;
		Document* _tmp6_;
		Document* _tmp7_;
		const gchar* _tmp8_;
#line 147 "main_window_file.vala"
		_tmp3_ = self->priv->_main_window;
#line 147 "main_window_file.vala"
		_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
#line 147 "main_window_file.vala"
		tab = _tmp4_;
#line 148 "main_window_file.vala"
		_tmp5_ = tab;
#line 148 "main_window_file.vala"
		_tmp6_ = document_tab_get_document (_tmp5_);
#line 148 "main_window_file.vala"
		_tmp7_ = _tmp6_;
#line 148 "main_window_file.vala"
		_tmp8_ = contents;
#line 148 "main_window_file.vala"
		document_set_contents (_tmp7_, _tmp8_);
#line 145 "main_window_file.vala"
		_g_object_unref0 (tab);
#line 683 "main_window_file.c"
	}
#line 141 "main_window_file.vala"
	_g_free0 (contents);
#line 687 "main_window_file.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 190 "main_window_file.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 695 "main_window_file.c"
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
#line 190 "main_window_file.vala"
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 703 "main_window_file.c"
}

void
main_window_file_on_file_open (MainWindowFile* self)
{
	GtkFileChooserDialog* file_chooser = NULL;
	MainWindow* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	gboolean _tmp2_ = FALSE;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GtkFileChooserDialog* _tmp29_;
	GtkFileChooserDialog* _tmp30_;
	GtkFileFilter* latex_filter = NULL;
	GtkFileFilter* _tmp31_;
	GtkFileFilter* _tmp32_;
	GtkFileFilter* _tmp33_;
	GtkFileFilter* _tmp34_;
	GtkFileChooserDialog* _tmp35_;
	GtkFileFilter* _tmp36_;
	GtkFileFilter* _tmp37_;
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp38_;
	GtkFileFilter* _tmp39_;
	GtkFileFilter* _tmp40_;
	GtkFileChooserDialog* _tmp41_;
	GtkFileFilter* _tmp42_;
	GtkFileFilter* _tmp43_;
	GSList* files_to_open = NULL;
	GtkFileChooserDialog* _tmp44_;
	MainWindow* _tmp47_;
	GtkFileChooserDialog* _tmp48_;
	gchar* _tmp49_;
	GtkFileChooserDialog* _tmp50_;
	gboolean jump_to = FALSE;
	GSList* _tmp51_;
#line 152 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 154 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 154 "main_window_file.vala"
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Open Files"), (GtkWindow*) _tmp0_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Open"), GTK_RESPONSE_ACCEPT, NULL);
#line 154 "main_window_file.vala"
	g_object_ref_sink (_tmp1_);
#line 154 "main_window_file.vala"
	file_chooser = _tmp1_;
#line 162 "main_window_file.vala"
	_tmp3_ = self->priv->_main_window;
#line 162 "main_window_file.vala"
	_tmp4_ = main_window_get_active_document (_tmp3_);
#line 162 "main_window_file.vala"
	_tmp5_ = _tmp4_;
#line 162 "main_window_file.vala"
	if (_tmp5_ != NULL) {
#line 759 "main_window_file.c"
		MainWindow* _tmp6_;
		Document* _tmp7_;
		Document* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
#line 163 "main_window_file.vala"
		_tmp6_ = self->priv->_main_window;
#line 163 "main_window_file.vala"
		_tmp7_ = main_window_get_active_document (_tmp6_);
#line 163 "main_window_file.vala"
		_tmp8_ = _tmp7_;
#line 163 "main_window_file.vala"
		_tmp9_ = document_get_location (_tmp8_);
#line 163 "main_window_file.vala"
		_tmp10_ = _tmp9_;
#line 163 "main_window_file.vala"
		_tmp2_ = _tmp10_ != NULL;
#line 777 "main_window_file.c"
	} else {
#line 162 "main_window_file.vala"
		_tmp2_ = FALSE;
#line 781 "main_window_file.c"
	}
#line 162 "main_window_file.vala"
	if (_tmp2_) {
#line 785 "main_window_file.c"
		GFile* location = NULL;
		MainWindow* _tmp11_;
		Document* _tmp12_;
		Document* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		gchar* dirname = NULL;
		GFile* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GtkFileChooserDialog* _tmp22_;
		const gchar* _tmp23_;
#line 165 "main_window_file.vala"
		_tmp11_ = self->priv->_main_window;
#line 165 "main_window_file.vala"
		_tmp12_ = main_window_get_active_document (_tmp11_);
#line 165 "main_window_file.vala"
		_tmp13_ = _tmp12_;
#line 165 "main_window_file.vala"
		_tmp14_ = document_get_location (_tmp13_);
#line 165 "main_window_file.vala"
		_tmp15_ = _tmp14_;
#line 165 "main_window_file.vala"
		_tmp16_ = _g_object_ref0 (_tmp15_);
#line 165 "main_window_file.vala"
		location = _tmp16_;
#line 166 "main_window_file.vala"
		_tmp17_ = location;
#line 166 "main_window_file.vala"
		_tmp18_ = g_file_get_parent (_tmp17_);
#line 166 "main_window_file.vala"
		_tmp19_ = _tmp18_;
#line 166 "main_window_file.vala"
		_tmp20_ = g_file_get_path (_tmp19_);
#line 166 "main_window_file.vala"
		_tmp21_ = _tmp20_;
#line 166 "main_window_file.vala"
		_g_object_unref0 (_tmp19_);
#line 166 "main_window_file.vala"
		dirname = _tmp21_;
#line 167 "main_window_file.vala"
		_tmp22_ = file_chooser;
#line 167 "main_window_file.vala"
		_tmp23_ = dirname;
#line 167 "main_window_file.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp22_, _tmp23_);
#line 162 "main_window_file.vala"
		_g_free0 (dirname);
#line 162 "main_window_file.vala"
		_g_object_unref0 (location);
#line 839 "main_window_file.c"
	} else {
		MainWindow* _tmp24_;
		const gchar* _tmp25_;
#line 169 "main_window_file.vala"
		_tmp24_ = self->priv->_main_window;
#line 169 "main_window_file.vala"
		_tmp25_ = _tmp24_->default_location;
#line 169 "main_window_file.vala"
		if (_tmp25_ != NULL) {
#line 849 "main_window_file.c"
			GtkFileChooserDialog* _tmp26_;
			MainWindow* _tmp27_;
			const gchar* _tmp28_;
#line 170 "main_window_file.vala"
			_tmp26_ = file_chooser;
#line 170 "main_window_file.vala"
			_tmp27_ = self->priv->_main_window;
#line 170 "main_window_file.vala"
			_tmp28_ = _tmp27_->default_location;
#line 170 "main_window_file.vala"
			gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp26_, _tmp28_);
#line 861 "main_window_file.c"
		}
	}
#line 172 "main_window_file.vala"
	_tmp29_ = file_chooser;
#line 172 "main_window_file.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp29_, FALSE);
#line 173 "main_window_file.vala"
	_tmp30_ = file_chooser;
#line 173 "main_window_file.vala"
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp30_, TRUE);
#line 176 "main_window_file.vala"
	_tmp31_ = gtk_file_filter_new ();
#line 176 "main_window_file.vala"
	g_object_ref_sink (_tmp31_);
#line 176 "main_window_file.vala"
	latex_filter = _tmp31_;
#line 177 "main_window_file.vala"
	_tmp32_ = latex_filter;
#line 177 "main_window_file.vala"
	gtk_file_filter_set_name (_tmp32_, _ ("All LaTeX Files"));
#line 178 "main_window_file.vala"
	_tmp33_ = latex_filter;
#line 178 "main_window_file.vala"
	gtk_file_filter_add_pattern (_tmp33_, "*.tex");
#line 179 "main_window_file.vala"
	_tmp34_ = latex_filter;
#line 179 "main_window_file.vala"
	gtk_file_filter_add_pattern (_tmp34_, "*.bib");
#line 180 "main_window_file.vala"
	_tmp35_ = file_chooser;
#line 180 "main_window_file.vala"
	_tmp36_ = latex_filter;
#line 180 "main_window_file.vala"
	_tmp37_ = _g_object_ref0 (_tmp36_);
#line 180 "main_window_file.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp35_, _tmp37_);
#line 183 "main_window_file.vala"
	_tmp38_ = gtk_file_filter_new ();
#line 183 "main_window_file.vala"
	g_object_ref_sink (_tmp38_);
#line 183 "main_window_file.vala"
	all_files_filter = _tmp38_;
#line 184 "main_window_file.vala"
	_tmp39_ = all_files_filter;
#line 184 "main_window_file.vala"
	gtk_file_filter_set_name (_tmp39_, _ ("All Files"));
#line 185 "main_window_file.vala"
	_tmp40_ = all_files_filter;
#line 185 "main_window_file.vala"
	gtk_file_filter_add_pattern (_tmp40_, "*");
#line 186 "main_window_file.vala"
	_tmp41_ = file_chooser;
#line 186 "main_window_file.vala"
	_tmp42_ = all_files_filter;
#line 186 "main_window_file.vala"
	_tmp43_ = _g_object_ref0 (_tmp42_);
#line 186 "main_window_file.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp41_, _tmp43_);
#line 188 "main_window_file.vala"
	files_to_open = NULL;
#line 189 "main_window_file.vala"
	_tmp44_ = file_chooser;
#line 189 "main_window_file.vala"
	if (gtk_dialog_run ((GtkDialog*) _tmp44_) == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 926 "main_window_file.c"
		GtkFileChooserDialog* _tmp45_;
		GSList* _tmp46_;
#line 190 "main_window_file.vala"
		_tmp45_ = file_chooser;
#line 190 "main_window_file.vala"
		_tmp46_ = gtk_file_chooser_get_files ((GtkFileChooser*) _tmp45_);
#line 190 "main_window_file.vala"
		(files_to_open == NULL) ? NULL : (files_to_open = (_g_slist_free__g_object_unref0_ (files_to_open), NULL));
#line 190 "main_window_file.vala"
		files_to_open = _tmp46_;
#line 937 "main_window_file.c"
	}
#line 192 "main_window_file.vala"
	_tmp47_ = self->priv->_main_window;
#line 192 "main_window_file.vala"
	_tmp48_ = file_chooser;
#line 192 "main_window_file.vala"
	_tmp49_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp48_);
#line 192 "main_window_file.vala"
	_g_free0 (_tmp47_->default_location);
#line 192 "main_window_file.vala"
	_tmp47_->default_location = _tmp49_;
#line 193 "main_window_file.vala"
	_tmp50_ = file_chooser;
#line 193 "main_window_file.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp50_);
#line 197 "main_window_file.vala"
	jump_to = TRUE;
#line 198 "main_window_file.vala"
	_tmp51_ = files_to_open;
#line 957 "main_window_file.c"
	{
		GSList* file_collection = NULL;
		GSList* file_it = NULL;
#line 198 "main_window_file.vala"
		file_collection = _tmp51_;
#line 198 "main_window_file.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 965 "main_window_file.c"
			GFile* _tmp52_;
			GFile* file = NULL;
#line 198 "main_window_file.vala"
			_tmp52_ = _g_object_ref0 ((GFile*) file_it->data);
#line 198 "main_window_file.vala"
			file = _tmp52_;
#line 972 "main_window_file.c"
			{
				MainWindow* _tmp53_;
				GFile* _tmp54_;
				DocumentTab* _tmp55_;
				DocumentTab* _tmp56_;
#line 200 "main_window_file.vala"
				_tmp53_ = self->priv->_main_window;
#line 200 "main_window_file.vala"
				_tmp54_ = file;
#line 200 "main_window_file.vala"
				_tmp55_ = main_window_open_document (_tmp53_, _tmp54_, jump_to);
#line 200 "main_window_file.vala"
				_tmp56_ = _tmp55_;
#line 200 "main_window_file.vala"
				_g_object_unref0 (_tmp56_);
#line 201 "main_window_file.vala"
				jump_to = FALSE;
#line 198 "main_window_file.vala"
				_g_object_unref0 (file);
#line 992 "main_window_file.c"
			}
		}
	}
#line 152 "main_window_file.vala"
	(files_to_open == NULL) ? NULL : (files_to_open = (_g_slist_free__g_object_unref0_ (files_to_open), NULL));
#line 152 "main_window_file.vala"
	_g_object_unref0 (all_files_filter);
#line 152 "main_window_file.vala"
	_g_object_unref0 (latex_filter);
#line 152 "main_window_file.vala"
	_g_object_unref0 (file_chooser);
#line 1004 "main_window_file.c"
}

void
main_window_file_on_file_save (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
#line 205 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 207 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 207 "main_window_file.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 207 "main_window_file.vala"
	_tmp2_ = _tmp1_;
#line 207 "main_window_file.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 208 "main_window_file.vala"
	_tmp3_ = self->priv->_main_window;
#line 208 "main_window_file.vala"
	_tmp4_ = self->priv->_main_window;
#line 208 "main_window_file.vala"
	_tmp5_ = main_window_get_active_document (_tmp4_);
#line 208 "main_window_file.vala"
	_tmp6_ = _tmp5_;
#line 208 "main_window_file.vala"
	main_window_save_document (_tmp3_, _tmp6_, FALSE);
#line 1037 "main_window_file.c"
}

void
main_window_file_on_file_save_as (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
#line 211 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 213 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 213 "main_window_file.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 213 "main_window_file.vala"
	_tmp2_ = _tmp1_;
#line 213 "main_window_file.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 214 "main_window_file.vala"
	_tmp3_ = self->priv->_main_window;
#line 214 "main_window_file.vala"
	_tmp4_ = self->priv->_main_window;
#line 214 "main_window_file.vala"
	_tmp5_ = main_window_get_active_document (_tmp4_);
#line 214 "main_window_file.vala"
	_tmp6_ = _tmp5_;
#line 214 "main_window_file.vala"
	main_window_save_document (_tmp3_, _tmp6_, TRUE);
#line 1070 "main_window_file.c"
}

void
main_window_file_on_create_template (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	Document* doc = NULL;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	gchar* template_contents = NULL;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	gchar* _tmp11_;
	MainWindow* _tmp12_;
#line 217 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 219 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 219 "main_window_file.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 219 "main_window_file.vala"
	_tmp2_ = _tmp1_;
#line 219 "main_window_file.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 224 "main_window_file.vala"
	_tmp3_ = self->priv->_main_window;
#line 224 "main_window_file.vala"
	_tmp4_ = main_window_get_active_document (_tmp3_);
#line 224 "main_window_file.vala"
	_tmp5_ = _tmp4_;
#line 224 "main_window_file.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 224 "main_window_file.vala"
	doc = _tmp6_;
#line 225 "main_window_file.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) doc, &_tmp7_, &_tmp8_);
#line 225 "main_window_file.vala"
	start = _tmp7_;
#line 225 "main_window_file.vala"
	end = _tmp8_;
#line 226 "main_window_file.vala"
	_tmp9_ = start;
#line 226 "main_window_file.vala"
	_tmp10_ = end;
#line 226 "main_window_file.vala"
	_tmp11_ = gtk_text_buffer_get_text ((GtkTextBuffer*) doc, &_tmp9_, &_tmp10_, FALSE);
#line 226 "main_window_file.vala"
	template_contents = _tmp11_;
#line 228 "main_window_file.vala"
	_tmp12_ = self->priv->_main_window;
#line 228 "main_window_file.vala"
	latexila_templates_dialogs_create_template ((GtkWindow*) _tmp12_, template_contents);
#line 217 "main_window_file.vala"
	_g_free0 (template_contents);
#line 217 "main_window_file.vala"
	_g_object_unref0 (doc);
#line 1135 "main_window_file.c"
}

void
main_window_file_on_manage_templates (MainWindowFile* self)
{
	GtkDialog* dialog = NULL;
	MainWindow* _tmp0_;
	LatexilaTemplatesManageDialog* _tmp1_;
#line 231 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 233 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 233 "main_window_file.vala"
	_tmp1_ = (LatexilaTemplatesManageDialog*) latexila_templates_manage_dialog_new ((GtkWindow*) _tmp0_);
#line 233 "main_window_file.vala"
	g_object_ref_sink (_tmp1_);
#line 233 "main_window_file.vala"
	dialog = (GtkDialog*) _tmp1_;
#line 234 "main_window_file.vala"
	gtk_dialog_run (dialog);
#line 235 "main_window_file.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 231 "main_window_file.vala"
	_g_object_unref0 (dialog);
#line 1160 "main_window_file.c"
}

void
main_window_file_on_file_close (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	DocumentTab* _tmp5_;
	DocumentTab* _tmp6_;
#line 238 "main_window_file.vala"
	g_return_if_fail (self != NULL);
#line 240 "main_window_file.vala"
	_tmp0_ = self->priv->_main_window;
#line 240 "main_window_file.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 240 "main_window_file.vala"
	_tmp2_ = _tmp1_;
#line 240 "main_window_file.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 241 "main_window_file.vala"
	_tmp3_ = self->priv->_main_window;
#line 241 "main_window_file.vala"
	_tmp4_ = self->priv->_main_window;
#line 241 "main_window_file.vala"
	_tmp5_ = main_window_get_active_tab (_tmp4_);
#line 241 "main_window_file.vala"
	_tmp6_ = _tmp5_;
#line 241 "main_window_file.vala"
	main_window_close_tab (_tmp3_, _tmp6_, FALSE);
#line 1193 "main_window_file.c"
}

static void
value_main_window_file_init (GValue* value)
{
#line 26 "main_window_file.vala"
	value->data[0].v_pointer = NULL;
#line 1201 "main_window_file.c"
}

static void
value_main_window_file_free_value (GValue* value)
{
#line 26 "main_window_file.vala"
	if (value->data[0].v_pointer) {
#line 26 "main_window_file.vala"
		main_window_file_unref (value->data[0].v_pointer);
#line 1211 "main_window_file.c"
	}
}

static void
value_main_window_file_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
#line 26 "main_window_file.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "main_window_file.vala"
		dest_value->data[0].v_pointer = main_window_file_ref (src_value->data[0].v_pointer);
#line 1223 "main_window_file.c"
	} else {
#line 26 "main_window_file.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1227 "main_window_file.c"
	}
}

static gpointer
value_main_window_file_peek_pointer (const GValue* value)
{
#line 26 "main_window_file.vala"
	return value->data[0].v_pointer;
#line 1236 "main_window_file.c"
}

static gchar*
value_main_window_file_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
#line 26 "main_window_file.vala"
	if (collect_values[0].v_pointer) {
#line 1247 "main_window_file.c"
		MainWindowFile * object;
		object = collect_values[0].v_pointer;
#line 26 "main_window_file.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "main_window_file.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1254 "main_window_file.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "main_window_file.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1258 "main_window_file.c"
		}
#line 26 "main_window_file.vala"
		value->data[0].v_pointer = main_window_file_ref (object);
#line 1262 "main_window_file.c"
	} else {
#line 26 "main_window_file.vala"
		value->data[0].v_pointer = NULL;
#line 1266 "main_window_file.c"
	}
#line 26 "main_window_file.vala"
	return NULL;
#line 1270 "main_window_file.c"
}

static gchar*
value_main_window_file_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	MainWindowFile ** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "main_window_file.vala"
	if (!object_p) {
#line 26 "main_window_file.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1285 "main_window_file.c"
	}
#line 26 "main_window_file.vala"
	if (!value->data[0].v_pointer) {
#line 26 "main_window_file.vala"
		*object_p = NULL;
#line 1291 "main_window_file.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "main_window_file.vala"
		*object_p = value->data[0].v_pointer;
#line 1295 "main_window_file.c"
	} else {
#line 26 "main_window_file.vala"
		*object_p = main_window_file_ref (value->data[0].v_pointer);
#line 1299 "main_window_file.c"
	}
#line 26 "main_window_file.vala"
	return NULL;
#line 1303 "main_window_file.c"
}

GParamSpec*
param_spec_main_window_file (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecMainWindowFile* spec;
#line 26 "main_window_file.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_FILE), NULL);
#line 26 "main_window_file.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "main_window_file.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "main_window_file.vala"
	return G_PARAM_SPEC (spec);
#line 1322 "main_window_file.c"
}

gpointer
value_get_main_window_file (const GValue* value)
{
#line 26 "main_window_file.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE), NULL);
#line 26 "main_window_file.vala"
	return value->data[0].v_pointer;
#line 1332 "main_window_file.c"
}

void
value_set_main_window_file (GValue* value,
                            gpointer v_object)
{
	MainWindowFile * old;
#line 26 "main_window_file.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE));
#line 26 "main_window_file.vala"
	old = value->data[0].v_pointer;
#line 26 "main_window_file.vala"
	if (v_object) {
#line 26 "main_window_file.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_FILE));
#line 26 "main_window_file.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "main_window_file.vala"
		value->data[0].v_pointer = v_object;
#line 26 "main_window_file.vala"
		main_window_file_ref (value->data[0].v_pointer);
#line 1354 "main_window_file.c"
	} else {
#line 26 "main_window_file.vala"
		value->data[0].v_pointer = NULL;
#line 1358 "main_window_file.c"
	}
#line 26 "main_window_file.vala"
	if (old) {
#line 26 "main_window_file.vala"
		main_window_file_unref (old);
#line 1364 "main_window_file.c"
	}
}

void
value_take_main_window_file (GValue* value,
                             gpointer v_object)
{
	MainWindowFile * old;
#line 26 "main_window_file.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE));
#line 26 "main_window_file.vala"
	old = value->data[0].v_pointer;
#line 26 "main_window_file.vala"
	if (v_object) {
#line 26 "main_window_file.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_FILE));
#line 26 "main_window_file.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "main_window_file.vala"
		value->data[0].v_pointer = v_object;
#line 1385 "main_window_file.c"
	} else {
#line 26 "main_window_file.vala"
		value->data[0].v_pointer = NULL;
#line 1389 "main_window_file.c"
	}
#line 26 "main_window_file.vala"
	if (old) {
#line 26 "main_window_file.vala"
		main_window_file_unref (old);
#line 1395 "main_window_file.c"
	}
}

static void
main_window_file_class_init (MainWindowFileClass * klass,
                             gpointer klass_data)
{
#line 26 "main_window_file.vala"
	main_window_file_parent_class = g_type_class_peek_parent (klass);
#line 26 "main_window_file.vala"
	((MainWindowFileClass *) klass)->finalize = main_window_file_finalize;
#line 26 "main_window_file.vala"
	g_type_class_adjust_private_offset (klass, &MainWindowFile_private_offset);
#line 1409 "main_window_file.c"
}

static void
main_window_file_instance_init (MainWindowFile * self,
                                gpointer klass)
{
#line 26 "main_window_file.vala"
	self->priv = main_window_file_get_instance_private (self);
#line 26 "main_window_file.vala"
	self->ref_count = 1;
#line 1420 "main_window_file.c"
}

static void
main_window_file_finalize (MainWindowFile * obj)
{
	MainWindowFile * self;
#line 26 "main_window_file.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_FILE, MainWindowFile);
#line 26 "main_window_file.vala"
	g_signal_handlers_destroy (self);
#line 58 "main_window_file.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 1433 "main_window_file.c"
}

GType
main_window_file_get_type (void)
{
	static volatile gsize main_window_file_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_file_init, value_main_window_file_free_value, value_main_window_file_copy_value, value_main_window_file_peek_pointer, "p", value_main_window_file_collect_value, "p", value_main_window_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowFile), 0, (GInstanceInitFunc) main_window_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_file_type_id;
		main_window_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		MainWindowFile_private_offset = g_type_add_instance_private (main_window_file_type_id, sizeof (MainWindowFilePrivate));
		g_once_init_leave (&main_window_file_type_id__volatile, main_window_file_type_id);
	}
	return main_window_file_type_id__volatile;
}

gpointer
main_window_file_ref (gpointer instance)
{
	MainWindowFile * self;
	self = instance;
#line 26 "main_window_file.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "main_window_file.vala"
	return instance;
#line 1461 "main_window_file.c"
}

void
main_window_file_unref (gpointer instance)
{
	MainWindowFile * self;
	self = instance;
#line 26 "main_window_file.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "main_window_file.vala"
		MAIN_WINDOW_FILE_GET_CLASS (self)->finalize (self);
#line 26 "main_window_file.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1475 "main_window_file.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1486 "main_window_file.c"
		int i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1494 "main_window_file.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 1509 "main_window_file.c"
}

