/* main_window_build_tools.c generated by valac 0.46.6, the Vala compiler
 * generated from main_window_build_tools.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012, 2014 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <amtk/amtk.h>
#include <tepl/tepl.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;
typedef struct _MainWindowBuildToolsPrivate MainWindowBuildToolsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block22Data Block22Data;
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _ParamSpecMainWindowBuildTools ParamSpecMainWindowBuildTools;

struct _MainWindowBuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowBuildToolsPrivate * priv;
};

struct _MainWindowBuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowBuildTools *self);
};

struct _MainWindowBuildToolsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	LatexilaBuildView* _build_view;
	BottomPanel* _bottom_panel;
	GCancellable* _cancellable;
	GAsyncResult* _build_tool_result;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _dynamic_action_group;
	guint _menu_ui_id;
};

struct _Block22Data {
	int _ref_count_;
	MainWindowBuildTools* self;
	LatexilaBuildTool* tool;
};

struct _ParamSpecMainWindowBuildTools {
	GParamSpec parent_instance;
};

static gint MainWindowBuildTools_private_offset;
static gpointer main_window_build_tools_parent_class = NULL;

gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void value_set_main_window_build_tools (GValue* value,
                                        gpointer v_object);
void value_take_main_window_build_tools (GValue* value,
                                         gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowBuildTools, main_window_build_tools_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType bottom_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BottomPanel, g_object_unref)
void main_window_build_tools_on_clean (MainWindowBuildTools* self);
static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action,
                                                            gpointer self);
void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self);
static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action,
                                                                     gpointer self);
void main_window_build_tools_on_view_log (MainWindowBuildTools* self);
static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window,
                                                   GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type,
                                                         MainWindow* main_window,
                                                         GtkUIManager* ui_manager);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
static void main_window_build_tools_update_menu (MainWindowBuildTools* self);
static void __lambda29_ (MainWindowBuildTools* self);
static void ___lambda29__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                                 gpointer self);
static void __lambda30_ (MainWindowBuildTools* self);
static void ___lambda30__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                               gpointer self);
static void __lambda31_ (MainWindowBuildTools* self);
static void ___lambda31__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                                 gpointer self);
static void __lambda32_ (MainWindowBuildTools* self);
static void ___lambda32__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                               gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                             LatexilaBuildView* build_view);
static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self);
static void __lambda33_ (MainWindowBuildTools* self,
                  GFile* file,
                  gint start_line,
                  gint end_line);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
static void ___lambda33__latexila_build_view_jump_to_file (LatexilaBuildView* _sender,
                                                    GFile* file,
                                                    gint start_line,
                                                    gint end_line,
                                                    gpointer self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                               BottomPanel* bottom_panel);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
Document* main_window_get_active_document (MainWindow* self);
gboolean document_is_main_file_a_tex_file (Document* self);
static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self,
                                                            gint tool_num);
static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self,
                                                            LatexilaBuildTool* tool,
                                                            const gchar* action_name);
static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self,
                                                             gint tool_num);
static LatexilaBuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self,
                                                                     const gchar* action_name);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      const gchar* needle);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self,
                                                      GtkAction* action);
static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender,
                                                                           gpointer self);
static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self,
                                                 LatexilaBuildTool* build_tool,
                                                 const gchar* action_name,
                                                 gint* accel_num);
static void main_window_build_tools_add_separator (MainWindowBuildTools* self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
gboolean document_set_tmp_location (Document* self);
gint document_get_project_id (Document* self);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
GeeList* glatex_app_get_documents (GlatexApp* self);
void utils_flush_queue (void);
static void __lambda28_ (Block22Data* _data22_,
                  GObject* obj,
                  GAsyncResult* _result_);
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_structure (GValue* value,
                                      gpointer v_object);
void value_take_main_window_structure (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowStructure, main_window_structure_unref)
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
void main_window_structure_refresh (MainWindowStructure* self);
static void ___lambda28__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
GType clean_build_files_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CleanBuildFiles, g_object_unref)
CleanBuildFiles* clean_build_files_new (MainWindow* main_window,
                                        Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type,
                                              MainWindow* main_window,
                                              Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
Document* document_tab_get_document (DocumentTab* self);
void document_set_readonly (Document* self,
                            gboolean value);
static void main_window_build_tools_finalize (MainWindowBuildTools * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW_BUILD_TOOLS__action_entries[5] = {{"Build", NULL, N_ ("_Build")}, {"BuildClean", "edit-clear-all", N_ ("Cleanup Build _Files"), NULL, N_ ("Clean-up build files (*.aux, *.log, *.out, *.toc, etc)"), (GCallback) _main_window_build_tools_on_clean_gtk_action_callback}, {"BuildStopExecution", "process-stop", N_ ("_Stop Execution"), NULL, N_ ("Stop Execution"), (GCallback) _main_window_build_tools_on_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", N_ ("View _Log"), NULL, N_ ("View Log"), (GCallback) _main_window_build_tools_on_view_log_gtk_action_callback}, {"BuildToolsPreferences", "preferences-system", N_ ("_Manage Build Tools"), NULL, N_ ("Manage Build Tools")}};
static const GtkToggleActionEntry MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries[3] = {{"BuildShowDetails", "zoom-in", N_ ("Show _Details"), NULL, N_ ("Show Details"), (GCallback) NULL}, {"BuildShowWarnings", "dialog-warning", N_ ("Show _Warnings"), NULL, N_ ("Show Warnings"), (GCallback) NULL}, {"BuildShowBadBoxes", "badbox", N_ ("Show _Bad Boxes"), NULL, N_ ("Show Bad Boxes"), (GCallback) NULL}};

static inline gpointer
main_window_build_tools_get_instance_private (MainWindowBuildTools* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindowBuildTools_private_offset);
}

static void
_main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action,
                                                       gpointer self)
{
#line 26 "main_window_build_tools.vala"
	main_window_build_tools_on_clean ((MainWindowBuildTools*) self);
#line 330 "main_window_build_tools.c"
}

static void
_main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action,
                                                                gpointer self)
{
#line 26 "main_window_build_tools.vala"
	main_window_build_tools_on_stop_execution ((MainWindowBuildTools*) self);
#line 339 "main_window_build_tools.c"
}

static void
_main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
#line 26 "main_window_build_tools.vala"
	main_window_build_tools_on_view_log ((MainWindowBuildTools*) self);
#line 348 "main_window_build_tools.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 72 "main_window_build_tools.vala"
	return self ? g_object_ref (self) : NULL;
#line 356 "main_window_build_tools.c"
}

static void
__lambda29_ (MainWindowBuildTools* self)
{
#line 96 "main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 364 "main_window_build_tools.c"
}

static void
___lambda29__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                            gpointer self)
{
#line 96 "main_window_build_tools.vala"
	__lambda29_ ((MainWindowBuildTools*) self);
#line 373 "main_window_build_tools.c"
}

static void
__lambda30_ (MainWindowBuildTools* self)
{
#line 97 "main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 381 "main_window_build_tools.c"
}

static void
___lambda30__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                          gpointer self)
{
#line 97 "main_window_build_tools.vala"
	__lambda30_ ((MainWindowBuildTools*) self);
#line 390 "main_window_build_tools.c"
}

static void
__lambda31_ (MainWindowBuildTools* self)
{
#line 101 "main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 398 "main_window_build_tools.c"
}

static void
___lambda31__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                            gpointer self)
{
#line 101 "main_window_build_tools.vala"
	__lambda31_ ((MainWindowBuildTools*) self);
#line 407 "main_window_build_tools.c"
}

static void
__lambda32_ (MainWindowBuildTools* self)
{
#line 102 "main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 415 "main_window_build_tools.c"
}

static void
___lambda32__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                          gpointer self)
{
#line 102 "main_window_build_tools.vala"
	__lambda32_ ((MainWindowBuildTools*) self);
#line 424 "main_window_build_tools.c"
}

MainWindowBuildTools*
main_window_build_tools_construct (GType object_type,
                                   MainWindow* main_window,
                                   GtkUIManager* ui_manager)
{
	MainWindowBuildTools* self = NULL;
	GtkUIManager* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkAction* stop_exec = NULL;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkAction* _tmp7_;
	GtkActionGroup* _tmp8_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp9_;
	GtkActionGroup* _tmp10_;
	GtkActionGroup* _tmp11_;
	GtkActionGroup* _tmp12_;
	LatexilaBuildToolsPersonal* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_;
	LatexilaBuildToolsPersonal* _tmp14_;
	LatexilaBuildToolsDefault* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp15_;
	LatexilaBuildToolsDefault* _tmp16_;
#line 69 "main_window_build_tools.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 69 "main_window_build_tools.vala"
	g_return_val_if_fail (ui_manager != NULL, NULL);
#line 69 "main_window_build_tools.vala"
	self = (MainWindowBuildTools*) g_type_create_instance (object_type);
#line 71 "main_window_build_tools.vala"
	self->priv->_main_window = main_window;
#line 72 "main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (ui_manager);
#line 72 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 72 "main_window_build_tools.vala"
	self->priv->_ui_manager = _tmp0_;
#line 75 "main_window_build_tools.vala"
	_tmp1_ = gtk_action_group_new ("BuildMenuActionGroup");
#line 75 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_static_action_group);
#line 75 "main_window_build_tools.vala"
	self->priv->_static_action_group = _tmp1_;
#line 76 "main_window_build_tools.vala"
	_tmp2_ = self->priv->_static_action_group;
#line 76 "main_window_build_tools.vala"
	gtk_action_group_set_translation_domain (_tmp2_, GETTEXT_PACKAGE);
#line 77 "main_window_build_tools.vala"
	_tmp3_ = self->priv->_static_action_group;
#line 77 "main_window_build_tools.vala"
	gtk_action_group_add_actions (_tmp3_, MAIN_WINDOW_BUILD_TOOLS__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__action_entries), self);
#line 78 "main_window_build_tools.vala"
	_tmp4_ = self->priv->_static_action_group;
#line 78 "main_window_build_tools.vala"
	gtk_action_group_add_toggle_actions (_tmp4_, MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries), self);
#line 80 "main_window_build_tools.vala"
	_tmp5_ = self->priv->_static_action_group;
#line 80 "main_window_build_tools.vala"
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "BuildStopExecution");
#line 80 "main_window_build_tools.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 80 "main_window_build_tools.vala"
	stop_exec = _tmp7_;
#line 81 "main_window_build_tools.vala"
	gtk_action_set_sensitive (stop_exec, FALSE);
#line 83 "main_window_build_tools.vala"
	_tmp8_ = self->priv->_static_action_group;
#line 83 "main_window_build_tools.vala"
	gtk_ui_manager_insert_action_group (ui_manager, _tmp8_, 0);
#line 85 "main_window_build_tools.vala"
	_tmp9_ = glatex_app_get_instance ();
#line 85 "main_window_build_tools.vala"
	app = _tmp9_;
#line 86 "main_window_build_tools.vala"
	_tmp10_ = self->priv->_static_action_group;
#line 86 "main_window_build_tools.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "manage-build-tools", _tmp10_, "BuildToolsPreferences");
#line 90 "main_window_build_tools.vala"
	_tmp11_ = gtk_action_group_new ("BuildToolsActions");
#line 90 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_dynamic_action_group);
#line 90 "main_window_build_tools.vala"
	self->priv->_dynamic_action_group = _tmp11_;
#line 91 "main_window_build_tools.vala"
	_tmp12_ = self->priv->_dynamic_action_group;
#line 91 "main_window_build_tools.vala"
	gtk_ui_manager_insert_action_group (ui_manager, _tmp12_, 0);
#line 92 "main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 94 "main_window_build_tools.vala"
	_tmp13_ = latexila_build_tools_personal_get_instance ();
#line 94 "main_window_build_tools.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 94 "main_window_build_tools.vala"
	personal_build_tools = _tmp14_;
#line 96 "main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "modified", (GCallback) ___lambda29__latexila_build_tools_modified, self);
#line 97 "main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "loaded", (GCallback) ___lambda30__latexila_build_tools_loaded, self);
#line 99 "main_window_build_tools.vala"
	_tmp15_ = latexila_build_tools_default_get_instance ();
#line 99 "main_window_build_tools.vala"
	_tmp16_ = _g_object_ref0 (_tmp15_);
#line 99 "main_window_build_tools.vala"
	default_build_tools = _tmp16_;
#line 101 "main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "modified", (GCallback) ___lambda31__latexila_build_tools_modified, self);
#line 102 "main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "loaded", (GCallback) ___lambda32__latexila_build_tools_loaded, self);
#line 69 "main_window_build_tools.vala"
	_g_object_unref0 (default_build_tools);
#line 69 "main_window_build_tools.vala"
	_g_object_unref0 (personal_build_tools);
#line 69 "main_window_build_tools.vala"
	_g_object_unref0 (app);
#line 69 "main_window_build_tools.vala"
	_g_object_unref0 (stop_exec);
#line 69 "main_window_build_tools.vala"
	return self;
#line 550 "main_window_build_tools.c"
}

MainWindowBuildTools*
main_window_build_tools_new (MainWindow* main_window,
                             GtkUIManager* ui_manager)
{
#line 69 "main_window_build_tools.vala"
	return main_window_build_tools_construct (TYPE_MAIN_WINDOW_BUILD_TOOLS, main_window, ui_manager);
#line 559 "main_window_build_tools.c"
}

static void
__lambda33_ (MainWindowBuildTools* self,
             GFile* file,
             gint start_line,
             gint end_line)
{
#line 110 "main_window_build_tools.vala"
	g_return_if_fail (file != NULL);
#line 112 "main_window_build_tools.vala"
	if (start_line == -1) {
#line 572 "main_window_build_tools.c"
		MainWindow* _tmp0_;
		DocumentTab* _tmp1_;
		DocumentTab* _tmp2_;
#line 113 "main_window_build_tools.vala"
		_tmp0_ = self->priv->_main_window;
#line 113 "main_window_build_tools.vala"
		_tmp1_ = main_window_open_document (_tmp0_, file, TRUE);
#line 113 "main_window_build_tools.vala"
		_tmp2_ = _tmp1_;
#line 113 "main_window_build_tools.vala"
		_g_object_unref0 (_tmp2_);
#line 584 "main_window_build_tools.c"
	} else {
		MainWindow* _tmp3_;
#line 115 "main_window_build_tools.vala"
		_tmp3_ = self->priv->_main_window;
#line 115 "main_window_build_tools.vala"
		main_window_jump_to_file_position (_tmp3_, file, start_line, end_line);
#line 591 "main_window_build_tools.c"
	}
}

static void
___lambda33__latexila_build_view_jump_to_file (LatexilaBuildView* _sender,
                                               GFile* file,
                                               gint start_line,
                                               gint end_line,
                                               gpointer self)
{
#line 110 "main_window_build_tools.vala"
	__lambda33_ ((MainWindowBuildTools*) self, file, start_line, end_line);
#line 604 "main_window_build_tools.c"
}

void
main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                        LatexilaBuildView* build_view)
{
	LatexilaBuildView* _tmp0_;
	LatexilaBuildView* _tmp1_;
#line 105 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 105 "main_window_build_tools.vala"
	g_return_if_fail (build_view != NULL);
#line 107 "main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (build_view);
#line 107 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_view);
#line 107 "main_window_build_tools.vala"
	self->priv->_build_view = _tmp0_;
#line 108 "main_window_build_tools.vala"
	main_window_build_tools_connect_toggle_actions (self);
#line 110 "main_window_build_tools.vala"
	_tmp1_ = self->priv->_build_view;
#line 110 "main_window_build_tools.vala"
	g_signal_connect (_tmp1_, "jump-to-file", (GCallback) ___lambda33__latexila_build_view_jump_to_file, self);
#line 629 "main_window_build_tools.c"
}

void
main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                          BottomPanel* bottom_panel)
{
	BottomPanel* _tmp0_;
#line 119 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 119 "main_window_build_tools.vala"
	g_return_if_fail (bottom_panel != NULL);
#line 121 "main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (bottom_panel);
#line 121 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_bottom_panel);
#line 121 "main_window_build_tools.vala"
	self->priv->_bottom_panel = _tmp0_;
#line 647 "main_window_build_tools.c"
}

void
main_window_build_tools_update_sensitivity (MainWindowBuildTools* self)
{
	gboolean build_tool_is_running = FALSE;
	GCancellable* _tmp0_;
	GtkAction* stop_exec_action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp5_;
	GSimpleAction* preferences_action = NULL;
	GlatexApp* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GtkAction* clean_action = NULL;
	GtkActionGroup* _tmp10_;
	GtkAction* _tmp11_;
	GtkAction* _tmp12_;
	GtkAction* view_log_action = NULL;
	GtkActionGroup* _tmp13_;
	GtkAction* _tmp14_;
	GtkAction* _tmp15_;
	MainWindow* _tmp16_;
	DocumentTab* _tmp17_;
	DocumentTab* _tmp18_;
	gboolean is_tex = FALSE;
	MainWindow* _tmp22_;
	Document* _tmp23_;
	Document* _tmp24_;
	GtkAction* _tmp25_;
	GtkActionGroup* _tmp28_;
	GtkAction* _tmp29_;
	LatexilaBuildTools* build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp30_;
	LatexilaBuildTools* _tmp31_;
	gint tool_num = 0;
	LatexilaBuildTools* _tmp32_;
	GList* _tmp33_;
	LatexilaBuildToolsPersonal* _tmp39_;
	LatexilaBuildTools* _tmp40_;
	LatexilaBuildTools* _tmp41_;
	GList* _tmp42_;
#line 124 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 126 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_cancellable;
#line 126 "main_window_build_tools.vala"
	build_tool_is_running = _tmp0_ != NULL;
#line 128 "main_window_build_tools.vala"
	_tmp1_ = self->priv->_static_action_group;
#line 128 "main_window_build_tools.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildStopExecution");
#line 128 "main_window_build_tools.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 128 "main_window_build_tools.vala"
	stop_exec_action = _tmp3_;
#line 129 "main_window_build_tools.vala"
	_tmp4_ = stop_exec_action;
#line 129 "main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp4_, build_tool_is_running);
#line 131 "main_window_build_tools.vala"
	_tmp5_ = glatex_app_get_instance ();
#line 131 "main_window_build_tools.vala"
	app = _tmp5_;
#line 132 "main_window_build_tools.vala"
	_tmp6_ = app;
#line 132 "main_window_build_tools.vala"
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) _tmp6_, "manage-build-tools");
#line 132 "main_window_build_tools.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp7_) : NULL);
#line 132 "main_window_build_tools.vala"
	preferences_action = _tmp8_;
#line 136 "main_window_build_tools.vala"
	_tmp9_ = preferences_action;
#line 136 "main_window_build_tools.vala"
	g_simple_action_set_enabled (_tmp9_, !build_tool_is_running);
#line 138 "main_window_build_tools.vala"
	_tmp10_ = self->priv->_static_action_group;
#line 138 "main_window_build_tools.vala"
	_tmp11_ = gtk_action_group_get_action (_tmp10_, "BuildClean");
#line 138 "main_window_build_tools.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 138 "main_window_build_tools.vala"
	clean_action = _tmp12_;
#line 139 "main_window_build_tools.vala"
	_tmp13_ = self->priv->_static_action_group;
#line 139 "main_window_build_tools.vala"
	_tmp14_ = gtk_action_group_get_action (_tmp13_, "BuildViewLog");
#line 139 "main_window_build_tools.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 139 "main_window_build_tools.vala"
	view_log_action = _tmp15_;
#line 141 "main_window_build_tools.vala"
	_tmp16_ = self->priv->_main_window;
#line 141 "main_window_build_tools.vala"
	_tmp17_ = main_window_get_active_tab (_tmp16_);
#line 141 "main_window_build_tools.vala"
	_tmp18_ = _tmp17_;
#line 141 "main_window_build_tools.vala"
	if (_tmp18_ == NULL) {
#line 753 "main_window_build_tools.c"
		GtkActionGroup* _tmp19_;
		GtkAction* _tmp20_;
		GtkAction* _tmp21_;
#line 143 "main_window_build_tools.vala"
		_tmp19_ = self->priv->_dynamic_action_group;
#line 143 "main_window_build_tools.vala"
		gtk_action_group_set_sensitive (_tmp19_, FALSE);
#line 144 "main_window_build_tools.vala"
		_tmp20_ = clean_action;
#line 144 "main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp20_, FALSE);
#line 145 "main_window_build_tools.vala"
		_tmp21_ = view_log_action;
#line 145 "main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp21_, FALSE);
#line 146 "main_window_build_tools.vala"
		_g_object_unref0 (view_log_action);
#line 146 "main_window_build_tools.vala"
		_g_object_unref0 (clean_action);
#line 146 "main_window_build_tools.vala"
		_g_object_unref0 (preferences_action);
#line 146 "main_window_build_tools.vala"
		_g_object_unref0 (app);
#line 146 "main_window_build_tools.vala"
		_g_object_unref0 (stop_exec_action);
#line 146 "main_window_build_tools.vala"
		return;
#line 781 "main_window_build_tools.c"
	}
#line 149 "main_window_build_tools.vala"
	_tmp22_ = self->priv->_main_window;
#line 149 "main_window_build_tools.vala"
	_tmp23_ = main_window_get_active_document (_tmp22_);
#line 149 "main_window_build_tools.vala"
	_tmp24_ = _tmp23_;
#line 149 "main_window_build_tools.vala"
	is_tex = document_is_main_file_a_tex_file (_tmp24_);
#line 150 "main_window_build_tools.vala"
	_tmp25_ = view_log_action;
#line 150 "main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp25_, is_tex);
#line 152 "main_window_build_tools.vala"
	if (build_tool_is_running) {
#line 797 "main_window_build_tools.c"
		GtkActionGroup* _tmp26_;
		GtkAction* _tmp27_;
#line 154 "main_window_build_tools.vala"
		_tmp26_ = self->priv->_dynamic_action_group;
#line 154 "main_window_build_tools.vala"
		gtk_action_group_set_sensitive (_tmp26_, FALSE);
#line 155 "main_window_build_tools.vala"
		_tmp27_ = clean_action;
#line 155 "main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp27_, FALSE);
#line 156 "main_window_build_tools.vala"
		_g_object_unref0 (view_log_action);
#line 156 "main_window_build_tools.vala"
		_g_object_unref0 (clean_action);
#line 156 "main_window_build_tools.vala"
		_g_object_unref0 (preferences_action);
#line 156 "main_window_build_tools.vala"
		_g_object_unref0 (app);
#line 156 "main_window_build_tools.vala"
		_g_object_unref0 (stop_exec_action);
#line 156 "main_window_build_tools.vala"
		return;
#line 820 "main_window_build_tools.c"
	}
#line 159 "main_window_build_tools.vala"
	_tmp28_ = self->priv->_dynamic_action_group;
#line 159 "main_window_build_tools.vala"
	gtk_action_group_set_sensitive (_tmp28_, TRUE);
#line 160 "main_window_build_tools.vala"
	_tmp29_ = clean_action;
#line 160 "main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp29_, is_tex);
#line 162 "main_window_build_tools.vala"
	_tmp30_ = latexila_build_tools_default_get_instance ();
#line 162 "main_window_build_tools.vala"
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp30_) : NULL);
#line 162 "main_window_build_tools.vala"
	build_tools = _tmp31_;
#line 165 "main_window_build_tools.vala"
	tool_num = 0;
#line 166 "main_window_build_tools.vala"
	_tmp32_ = build_tools;
#line 166 "main_window_build_tools.vala"
	_tmp33_ = _tmp32_->build_tools;
#line 842 "main_window_build_tools.c"
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
#line 166 "main_window_build_tools.vala"
		tool_collection = _tmp33_;
#line 166 "main_window_build_tools.vala"
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
#line 850 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp34_;
			LatexilaBuildTool* tool = NULL;
#line 166 "main_window_build_tools.vala"
			_tmp34_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
#line 166 "main_window_build_tools.vala"
			tool = _tmp34_;
#line 857 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gchar* _tmp35_;
				LatexilaBuildTool* _tmp36_;
				const gchar* _tmp37_;
				gint _tmp38_;
#line 168 "main_window_build_tools.vala"
				_tmp35_ = main_window_build_tools_get_default_build_tool_name (self, tool_num);
#line 168 "main_window_build_tools.vala"
				action_name = _tmp35_;
#line 169 "main_window_build_tools.vala"
				_tmp36_ = tool;
#line 169 "main_window_build_tools.vala"
				_tmp37_ = action_name;
#line 169 "main_window_build_tools.vala"
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp36_, _tmp37_);
#line 170 "main_window_build_tools.vala"
				_tmp38_ = tool_num;
#line 170 "main_window_build_tools.vala"
				tool_num = _tmp38_ + 1;
#line 166 "main_window_build_tools.vala"
				_g_free0 (action_name);
#line 166 "main_window_build_tools.vala"
				_g_object_unref0 (tool);
#line 882 "main_window_build_tools.c"
			}
		}
	}
#line 173 "main_window_build_tools.vala"
	_tmp39_ = latexila_build_tools_personal_get_instance ();
#line 173 "main_window_build_tools.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp39_) : NULL);
#line 173 "main_window_build_tools.vala"
	_g_object_unref0 (build_tools);
#line 173 "main_window_build_tools.vala"
	build_tools = _tmp40_;
#line 174 "main_window_build_tools.vala"
	tool_num = 0;
#line 175 "main_window_build_tools.vala"
	_tmp41_ = build_tools;
#line 175 "main_window_build_tools.vala"
	_tmp42_ = _tmp41_->build_tools;
#line 900 "main_window_build_tools.c"
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
#line 175 "main_window_build_tools.vala"
		tool_collection = _tmp42_;
#line 175 "main_window_build_tools.vala"
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
#line 908 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp43_;
			LatexilaBuildTool* tool = NULL;
#line 175 "main_window_build_tools.vala"
			_tmp43_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
#line 175 "main_window_build_tools.vala"
			tool = _tmp43_;
#line 915 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gchar* _tmp44_;
				LatexilaBuildTool* _tmp45_;
				const gchar* _tmp46_;
				gint _tmp47_;
#line 177 "main_window_build_tools.vala"
				_tmp44_ = main_window_build_tools_get_personal_build_tool_name (self, tool_num);
#line 177 "main_window_build_tools.vala"
				action_name = _tmp44_;
#line 178 "main_window_build_tools.vala"
				_tmp45_ = tool;
#line 178 "main_window_build_tools.vala"
				_tmp46_ = action_name;
#line 178 "main_window_build_tools.vala"
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp45_, _tmp46_);
#line 179 "main_window_build_tools.vala"
				_tmp47_ = tool_num;
#line 179 "main_window_build_tools.vala"
				tool_num = _tmp47_ + 1;
#line 175 "main_window_build_tools.vala"
				_g_free0 (action_name);
#line 175 "main_window_build_tools.vala"
				_g_object_unref0 (tool);
#line 940 "main_window_build_tools.c"
			}
		}
	}
#line 124 "main_window_build_tools.vala"
	_g_object_unref0 (build_tools);
#line 124 "main_window_build_tools.vala"
	_g_object_unref0 (view_log_action);
#line 124 "main_window_build_tools.vala"
	_g_object_unref0 (clean_action);
#line 124 "main_window_build_tools.vala"
	_g_object_unref0 (preferences_action);
#line 124 "main_window_build_tools.vala"
	_g_object_unref0 (app);
#line 124 "main_window_build_tools.vala"
	_g_object_unref0 (stop_exec_action);
#line 956 "main_window_build_tools.c"
}

static gchar*
main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self,
                                                     gint tool_num)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 183 "main_window_build_tools.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 185 "main_window_build_tools.vala"
	_tmp0_ = g_strdup_printf ("%i", tool_num);
#line 185 "main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 185 "main_window_build_tools.vala"
	_tmp2_ = g_strconcat ("DefaultBuildTool_", _tmp1_, NULL);
#line 185 "main_window_build_tools.vala"
	_tmp3_ = _tmp2_;
#line 185 "main_window_build_tools.vala"
	_g_free0 (_tmp1_);
#line 185 "main_window_build_tools.vala"
	result = _tmp3_;
#line 185 "main_window_build_tools.vala"
	return result;
#line 984 "main_window_build_tools.c"
}

static gchar*
main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self,
                                                      gint tool_num)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 188 "main_window_build_tools.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "main_window_build_tools.vala"
	_tmp0_ = g_strdup_printf ("%i", tool_num);
#line 190 "main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 190 "main_window_build_tools.vala"
	_tmp2_ = g_strconcat ("PersonalBuildTool_", _tmp1_, NULL);
#line 190 "main_window_build_tools.vala"
	_tmp3_ = _tmp2_;
#line 190 "main_window_build_tools.vala"
	_g_free0 (_tmp1_);
#line 190 "main_window_build_tools.vala"
	result = _tmp3_;
#line 190 "main_window_build_tools.vala"
	return result;
#line 1012 "main_window_build_tools.c"
}

static LatexilaBuildTool*
main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self,
                                                  const gchar* action_name)
{
	LatexilaBuildTools* build_tools = NULL;
	gchar** name = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint name_length1;
	gint _name_size_;
	gint tool_num = 0;
	const gchar* _tmp6_;
	LatexilaBuildTools* _tmp7_;
	LatexilaBuildTool* _tmp8_;
	LatexilaBuildTool* _tmp9_;
	LatexilaBuildTool* result = NULL;
#line 193 "main_window_build_tools.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 193 "main_window_build_tools.vala"
	g_return_val_if_fail (action_name != NULL, NULL);
#line 197 "main_window_build_tools.vala"
	if (g_str_has_prefix (action_name, "DefaultBuildTool_")) {
#line 1037 "main_window_build_tools.c"
		LatexilaBuildToolsDefault* _tmp0_;
		LatexilaBuildTools* _tmp1_;
#line 198 "main_window_build_tools.vala"
		_tmp0_ = latexila_build_tools_default_get_instance ();
#line 198 "main_window_build_tools.vala"
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
#line 198 "main_window_build_tools.vala"
		_g_object_unref0 (build_tools);
#line 198 "main_window_build_tools.vala"
		build_tools = _tmp1_;
#line 1048 "main_window_build_tools.c"
	} else {
#line 200 "main_window_build_tools.vala"
		if (g_str_has_prefix (action_name, "PersonalBuildTool_")) {
#line 1052 "main_window_build_tools.c"
			LatexilaBuildToolsPersonal* _tmp2_;
			LatexilaBuildTools* _tmp3_;
#line 201 "main_window_build_tools.vala"
			_tmp2_ = latexila_build_tools_personal_get_instance ();
#line 201 "main_window_build_tools.vala"
			_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp2_) : NULL);
#line 201 "main_window_build_tools.vala"
			_g_object_unref0 (build_tools);
#line 201 "main_window_build_tools.vala"
			build_tools = _tmp3_;
#line 1063 "main_window_build_tools.c"
		} else {
#line 204 "main_window_build_tools.vala"
			g_return_val_if_reached (NULL);
#line 1067 "main_window_build_tools.c"
		}
	}
#line 206 "main_window_build_tools.vala"
	_tmp5_ = _tmp4_ = g_strsplit (action_name, "_", 0);
#line 206 "main_window_build_tools.vala"
	name = _tmp5_;
#line 206 "main_window_build_tools.vala"
	name_length1 = _vala_array_length (_tmp4_);
#line 206 "main_window_build_tools.vala"
	_name_size_ = name_length1;
#line 207 "main_window_build_tools.vala"
	g_return_val_if_fail (name_length1 == 2, NULL);
#line 209 "main_window_build_tools.vala"
	_tmp6_ = name[1];
#line 209 "main_window_build_tools.vala"
	tool_num = atoi (_tmp6_);
#line 211 "main_window_build_tools.vala"
	_tmp7_ = build_tools;
#line 211 "main_window_build_tools.vala"
	_tmp8_ = latexila_build_tools_nth (_tmp7_, (guint) tool_num);
#line 211 "main_window_build_tools.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 211 "main_window_build_tools.vala"
	result = _tmp9_;
#line 211 "main_window_build_tools.vala"
	name = (_vala_array_free (name, name_length1, (GDestroyNotify) g_free), NULL);
#line 211 "main_window_build_tools.vala"
	_g_object_unref0 (build_tools);
#line 211 "main_window_build_tools.vala"
	return result;
#line 1098 "main_window_build_tools.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             const gchar* needle)
{
	int i;
#line 235 "main_window_build_tools.vala"
	for (i = 0; i < stack_length; i++) {
#line 235 "main_window_build_tools.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 235 "main_window_build_tools.vala"
			return TRUE;
#line 1113 "main_window_build_tools.c"
		}
	}
#line 235 "main_window_build_tools.vala"
	return FALSE;
#line 1118 "main_window_build_tools.c"
}

static void
main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self,
                                                       LatexilaBuildTool* tool,
                                                       const gchar* action_name)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	Document* active_doc = NULL;
	MainWindow* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	gboolean unsaved_doc = FALSE;
	Document* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* path = NULL;
	Document* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* ext = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** extensions = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gint extensions_length1;
	gint _extensions_size_;
	gboolean _tmp27_ = FALSE;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_;
	gboolean sensitive = FALSE;
	GtkAction* _tmp36_;
#line 214 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 214 "main_window_build_tools.vala"
	g_return_if_fail (tool != NULL);
#line 214 "main_window_build_tools.vala"
	g_return_if_fail (action_name != NULL);
#line 217 "main_window_build_tools.vala"
	g_object_get (tool, "enabled", &_tmp0_, NULL);
#line 217 "main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 217 "main_window_build_tools.vala"
	if (!_tmp1_) {
#line 218 "main_window_build_tools.vala"
		return;
#line 1183 "main_window_build_tools.c"
	}
#line 220 "main_window_build_tools.vala"
	_tmp2_ = self->priv->_dynamic_action_group;
#line 220 "main_window_build_tools.vala"
	_tmp3_ = gtk_action_group_get_action (_tmp2_, action_name);
#line 220 "main_window_build_tools.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 220 "main_window_build_tools.vala"
	action = _tmp4_;
#line 222 "main_window_build_tools.vala"
	_tmp5_ = self->priv->_main_window;
#line 222 "main_window_build_tools.vala"
	_tmp6_ = main_window_get_active_document (_tmp5_);
#line 222 "main_window_build_tools.vala"
	_tmp7_ = _tmp6_;
#line 222 "main_window_build_tools.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 222 "main_window_build_tools.vala"
	active_doc = _tmp8_;
#line 223 "main_window_build_tools.vala"
	_tmp9_ = active_doc;
#line 223 "main_window_build_tools.vala"
	_tmp10_ = document_get_location (_tmp9_);
#line 223 "main_window_build_tools.vala"
	_tmp11_ = _tmp10_;
#line 223 "main_window_build_tools.vala"
	unsaved_doc = _tmp11_ == NULL;
#line 225 "main_window_build_tools.vala"
	if (unsaved_doc) {
#line 1213 "main_window_build_tools.c"
		GtkAction* _tmp12_;
		GList* _tmp13_;
#line 227 "main_window_build_tools.vala"
		_tmp12_ = action;
#line 227 "main_window_build_tools.vala"
		_tmp13_ = latexila_build_tool_get_jobs (tool);
#line 227 "main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp12_, _tmp13_ != NULL);
#line 228 "main_window_build_tools.vala"
		_g_object_unref0 (active_doc);
#line 228 "main_window_build_tools.vala"
		_g_object_unref0 (action);
#line 228 "main_window_build_tools.vala"
		return;
#line 1228 "main_window_build_tools.c"
	}
#line 231 "main_window_build_tools.vala"
	_tmp14_ = active_doc;
#line 231 "main_window_build_tools.vala"
	_tmp15_ = document_get_main_file (_tmp14_);
#line 231 "main_window_build_tools.vala"
	_tmp16_ = _tmp15_;
#line 231 "main_window_build_tools.vala"
	_tmp17_ = g_file_get_parse_name (_tmp16_);
#line 231 "main_window_build_tools.vala"
	_tmp18_ = _tmp17_;
#line 231 "main_window_build_tools.vala"
	_g_object_unref0 (_tmp16_);
#line 231 "main_window_build_tools.vala"
	path = _tmp18_;
#line 232 "main_window_build_tools.vala"
	_tmp19_ = path;
#line 232 "main_window_build_tools.vala"
	_tmp20_ = tepl_utils_get_file_extension (_tmp19_);
#line 232 "main_window_build_tools.vala"
	ext = _tmp20_;
#line 234 "main_window_build_tools.vala"
	g_object_get (tool, "extensions", &_tmp21_, NULL);
#line 234 "main_window_build_tools.vala"
	_tmp22_ = _tmp21_;
#line 234 "main_window_build_tools.vala"
	_tmp23_ = _tmp22_;
#line 234 "main_window_build_tools.vala"
	_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, " ", 0);
#line 234 "main_window_build_tools.vala"
	_tmp26_ = _tmp25_;
#line 234 "main_window_build_tools.vala"
	_tmp26__length1 = _vala_array_length (_tmp24_);
#line 234 "main_window_build_tools.vala"
	_g_free0 (_tmp23_);
#line 234 "main_window_build_tools.vala"
	extensions = _tmp26_;
#line 234 "main_window_build_tools.vala"
	extensions_length1 = _tmp26__length1;
#line 234 "main_window_build_tools.vala"
	_extensions_size_ = extensions_length1;
#line 235 "main_window_build_tools.vala"
	g_object_get (tool, "extensions", &_tmp28_, NULL);
#line 235 "main_window_build_tools.vala"
	_tmp29_ = _tmp28_;
#line 235 "main_window_build_tools.vala"
	_tmp30_ = _tmp29_;
#line 235 "main_window_build_tools.vala"
	_tmp31_ = strlen (_tmp30_);
#line 235 "main_window_build_tools.vala"
	_tmp32_ = _tmp31_;
#line 235 "main_window_build_tools.vala"
	_tmp33_ = _tmp32_ == 0;
#line 235 "main_window_build_tools.vala"
	_g_free0 (_tmp30_);
#line 235 "main_window_build_tools.vala"
	if (_tmp33_) {
#line 235 "main_window_build_tools.vala"
		_tmp27_ = TRUE;
#line 1288 "main_window_build_tools.c"
	} else {
		const gchar* _tmp34_;
		gchar** _tmp35_;
		gint _tmp35__length1;
#line 235 "main_window_build_tools.vala"
		_tmp34_ = ext;
#line 235 "main_window_build_tools.vala"
		_tmp35_ = extensions;
#line 235 "main_window_build_tools.vala"
		_tmp35__length1 = extensions_length1;
#line 235 "main_window_build_tools.vala"
		_tmp27_ = _vala_string_array_contains (_tmp35_, _tmp35__length1, _tmp34_);
#line 1301 "main_window_build_tools.c"
	}
#line 235 "main_window_build_tools.vala"
	sensitive = _tmp27_;
#line 236 "main_window_build_tools.vala"
	_tmp36_ = action;
#line 236 "main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp36_, sensitive);
#line 214 "main_window_build_tools.vala"
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
#line 214 "main_window_build_tools.vala"
	_g_free0 (ext);
#line 214 "main_window_build_tools.vala"
	_g_free0 (path);
#line 214 "main_window_build_tools.vala"
	_g_object_unref0 (active_doc);
#line 214 "main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 1319 "main_window_build_tools.c"
}

void
main_window_build_tools_save_state (MainWindowBuildTools* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
#line 239 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 241 "main_window_build_tools.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 241 "main_window_build_tools.vala"
	settings = _tmp0_;
#line 244 "main_window_build_tools.vala"
	_tmp1_ = self->priv->_static_action_group;
#line 244 "main_window_build_tools.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildShowWarnings");
#line 244 "main_window_build_tools.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
#line 244 "main_window_build_tools.vala"
	action = _tmp3_;
#line 246 "main_window_build_tools.vala"
	_tmp4_ = action;
#line 246 "main_window_build_tools.vala"
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
#line 246 "main_window_build_tools.vala"
	_tmp6_ = _tmp5_;
#line 246 "main_window_build_tools.vala"
	g_settings_set_boolean (settings, "show-build-warnings", _tmp6_);
#line 248 "main_window_build_tools.vala"
	_tmp7_ = self->priv->_static_action_group;
#line 248 "main_window_build_tools.vala"
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowBadBoxes");
#line 248 "main_window_build_tools.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
#line 248 "main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 248 "main_window_build_tools.vala"
	action = _tmp9_;
#line 249 "main_window_build_tools.vala"
	_tmp10_ = action;
#line 249 "main_window_build_tools.vala"
	_tmp11_ = gtk_toggle_action_get_active (_tmp10_);
#line 249 "main_window_build_tools.vala"
	_tmp12_ = _tmp11_;
#line 249 "main_window_build_tools.vala"
	g_settings_set_boolean (settings, "show-build-badboxes", _tmp12_);
#line 239 "main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 239 "main_window_build_tools.vala"
	_g_object_unref0 (settings);
#line 1384 "main_window_build_tools.c"
}

static void
_main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender,
                                                                      gpointer self)
{
#line 261 "main_window_build_tools.vala"
	main_window_build_tools_activate_dynamic_action ((MainWindowBuildTools*) self, _sender);
#line 1393 "main_window_build_tools.c"
}

static void
main_window_build_tools_update_menu (MainWindowBuildTools* self)
{
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp2_;
	GList* _tmp3_;
	LatexilaBuildTools* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp9_;
	LatexilaBuildTools* _tmp10_;
	LatexilaBuildTools* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp11_;
	LatexilaBuildTools* _tmp12_;
	gboolean _tmp13_ = FALSE;
	LatexilaBuildTools* _tmp14_;
	GList* _tmp15_;
	GtkUIManager* _tmp18_;
	gint tool_num = 0;
	gint accel_num = 0;
	LatexilaBuildTools* _tmp19_;
	GList* _tmp20_;
	LatexilaBuildTools* _tmp26_;
	GList* _tmp27_;
#line 252 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 254 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_dynamic_action_group;
#line 254 "main_window_build_tools.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 256 "main_window_build_tools.vala"
	if (self->priv->_menu_ui_id != ((guint) 0)) {
#line 1426 "main_window_build_tools.c"
		GtkUIManager* _tmp1_;
#line 257 "main_window_build_tools.vala"
		_tmp1_ = self->priv->_ui_manager;
#line 257 "main_window_build_tools.vala"
		gtk_ui_manager_remove_ui (_tmp1_, self->priv->_menu_ui_id);
#line 1432 "main_window_build_tools.c"
	}
#line 259 "main_window_build_tools.vala"
	_tmp2_ = self->priv->_dynamic_action_group;
#line 259 "main_window_build_tools.vala"
	_tmp3_ = gtk_action_group_list_actions (_tmp2_);
#line 1438 "main_window_build_tools.c"
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
#line 259 "main_window_build_tools.vala"
		action_collection = _tmp3_;
#line 259 "main_window_build_tools.vala"
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
#line 1446 "main_window_build_tools.c"
			GtkAction* _tmp4_;
			GtkAction* action = NULL;
#line 259 "main_window_build_tools.vala"
			_tmp4_ = _g_object_ref0 ((GtkAction*) action_it->data);
#line 259 "main_window_build_tools.vala"
			action = _tmp4_;
#line 1453 "main_window_build_tools.c"
			{
				GtkAction* _tmp5_;
				guint _tmp6_;
				GtkActionGroup* _tmp7_;
				GtkAction* _tmp8_;
#line 261 "main_window_build_tools.vala"
				_tmp5_ = action;
#line 261 "main_window_build_tools.vala"
				g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp6_, NULL, FALSE);
#line 261 "main_window_build_tools.vala"
				g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
#line 262 "main_window_build_tools.vala"
				_tmp7_ = self->priv->_dynamic_action_group;
#line 262 "main_window_build_tools.vala"
				_tmp8_ = action;
#line 262 "main_window_build_tools.vala"
				gtk_action_group_remove_action (_tmp7_, _tmp8_);
#line 259 "main_window_build_tools.vala"
				_g_object_unref0 (action);
#line 1473 "main_window_build_tools.c"
			}
		}
#line 259 "main_window_build_tools.vala"
		(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
#line 1478 "main_window_build_tools.c"
	}
#line 265 "main_window_build_tools.vala"
	_tmp9_ = latexila_build_tools_default_get_instance ();
#line 265 "main_window_build_tools.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp9_) : NULL);
#line 265 "main_window_build_tools.vala"
	default_build_tools = _tmp10_;
#line 267 "main_window_build_tools.vala"
	_tmp11_ = latexila_build_tools_personal_get_instance ();
#line 267 "main_window_build_tools.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp11_) : NULL);
#line 267 "main_window_build_tools.vala"
	personal_build_tools = _tmp12_;
#line 271 "main_window_build_tools.vala"
	_tmp14_ = default_build_tools;
#line 271 "main_window_build_tools.vala"
	_tmp15_ = _tmp14_->build_tools;
#line 271 "main_window_build_tools.vala"
	if (_tmp15_ == NULL) {
#line 1498 "main_window_build_tools.c"
		LatexilaBuildTools* _tmp16_;
		GList* _tmp17_;
#line 272 "main_window_build_tools.vala"
		_tmp16_ = personal_build_tools;
#line 272 "main_window_build_tools.vala"
		_tmp17_ = _tmp16_->build_tools;
#line 272 "main_window_build_tools.vala"
		_tmp13_ = _tmp17_ == NULL;
#line 1507 "main_window_build_tools.c"
	} else {
#line 271 "main_window_build_tools.vala"
		_tmp13_ = FALSE;
#line 1511 "main_window_build_tools.c"
	}
#line 271 "main_window_build_tools.vala"
	if (_tmp13_) {
#line 274 "main_window_build_tools.vala"
		self->priv->_menu_ui_id = (guint) 0;
#line 275 "main_window_build_tools.vala"
		_g_object_unref0 (personal_build_tools);
#line 275 "main_window_build_tools.vala"
		_g_object_unref0 (default_build_tools);
#line 275 "main_window_build_tools.vala"
		return;
#line 1523 "main_window_build_tools.c"
	}
#line 278 "main_window_build_tools.vala"
	_tmp18_ = self->priv->_ui_manager;
#line 278 "main_window_build_tools.vala"
	self->priv->_menu_ui_id = gtk_ui_manager_new_merge_id (_tmp18_);
#line 281 "main_window_build_tools.vala"
	tool_num = 0;
#line 282 "main_window_build_tools.vala"
	accel_num = 2;
#line 283 "main_window_build_tools.vala"
	_tmp19_ = default_build_tools;
#line 283 "main_window_build_tools.vala"
	_tmp20_ = _tmp19_->build_tools;
#line 1537 "main_window_build_tools.c"
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
#line 283 "main_window_build_tools.vala"
		build_tool_collection = _tmp20_;
#line 283 "main_window_build_tools.vala"
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
#line 1545 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp21_;
			LatexilaBuildTool* build_tool = NULL;
#line 283 "main_window_build_tools.vala"
			_tmp21_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
#line 283 "main_window_build_tools.vala"
			build_tool = _tmp21_;
#line 1552 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gchar* _tmp22_;
				LatexilaBuildTool* _tmp23_;
				const gchar* _tmp24_;
				gint _tmp25_;
#line 285 "main_window_build_tools.vala"
				_tmp22_ = main_window_build_tools_get_default_build_tool_name (self, tool_num);
#line 285 "main_window_build_tools.vala"
				action_name = _tmp22_;
#line 286 "main_window_build_tools.vala"
				_tmp23_ = build_tool;
#line 286 "main_window_build_tools.vala"
				_tmp24_ = action_name;
#line 286 "main_window_build_tools.vala"
				main_window_build_tools_add_dynamic_action (self, _tmp23_, _tmp24_, &accel_num);
#line 287 "main_window_build_tools.vala"
				_tmp25_ = tool_num;
#line 287 "main_window_build_tools.vala"
				tool_num = _tmp25_ + 1;
#line 283 "main_window_build_tools.vala"
				_g_free0 (action_name);
#line 283 "main_window_build_tools.vala"
				_g_object_unref0 (build_tool);
#line 1577 "main_window_build_tools.c"
			}
		}
	}
#line 290 "main_window_build_tools.vala"
	main_window_build_tools_add_separator (self);
#line 293 "main_window_build_tools.vala"
	tool_num = 0;
#line 294 "main_window_build_tools.vala"
	_tmp26_ = personal_build_tools;
#line 294 "main_window_build_tools.vala"
	_tmp27_ = _tmp26_->build_tools;
#line 1589 "main_window_build_tools.c"
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
#line 294 "main_window_build_tools.vala"
		build_tool_collection = _tmp27_;
#line 294 "main_window_build_tools.vala"
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
#line 1597 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp28_;
			LatexilaBuildTool* build_tool = NULL;
#line 294 "main_window_build_tools.vala"
			_tmp28_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
#line 294 "main_window_build_tools.vala"
			build_tool = _tmp28_;
#line 1604 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gchar* _tmp29_;
				LatexilaBuildTool* _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_;
#line 296 "main_window_build_tools.vala"
				_tmp29_ = main_window_build_tools_get_personal_build_tool_name (self, tool_num);
#line 296 "main_window_build_tools.vala"
				action_name = _tmp29_;
#line 297 "main_window_build_tools.vala"
				_tmp30_ = build_tool;
#line 297 "main_window_build_tools.vala"
				_tmp31_ = action_name;
#line 297 "main_window_build_tools.vala"
				main_window_build_tools_add_dynamic_action (self, _tmp30_, _tmp31_, &accel_num);
#line 298 "main_window_build_tools.vala"
				_tmp32_ = tool_num;
#line 298 "main_window_build_tools.vala"
				tool_num = _tmp32_ + 1;
#line 294 "main_window_build_tools.vala"
				_g_free0 (action_name);
#line 294 "main_window_build_tools.vala"
				_g_object_unref0 (build_tool);
#line 1629 "main_window_build_tools.c"
			}
		}
	}
#line 301 "main_window_build_tools.vala"
	main_window_build_tools_update_sensitivity (self);
#line 252 "main_window_build_tools.vala"
	_g_object_unref0 (personal_build_tools);
#line 252 "main_window_build_tools.vala"
	_g_object_unref0 (default_build_tools);
#line 1639 "main_window_build_tools.c"
}

static void
main_window_build_tools_add_separator (MainWindowBuildTools* self)
{
	GtkUIManager* _tmp0_;
	GtkUIManager* _tmp1_;
#line 304 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 306 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 306 "main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp0_, self->priv->_menu_ui_id, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
#line 310 "main_window_build_tools.vala"
	_tmp1_ = self->priv->_ui_manager;
#line 310 "main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp1_, self->priv->_menu_ui_id, "/MainToolbar/BuildToolsPlaceholderToolbar", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
#line 1657 "main_window_build_tools.c"
}

static void
main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self,
                                            LatexilaBuildTool* build_tool,
                                            const gchar* action_name,
                                            gint* accel_num)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkAction* action = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkAction* _tmp6_;
	GtkAction* _tmp7_;
	GtkAction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkAction* _tmp12_;
	gchar* accel = NULL;
	GtkActionGroup* _tmp16_;
	GtkAction* _tmp17_;
	const gchar* _tmp18_;
	GtkAction* _tmp19_;
	GtkUIManager* _tmp20_;
	GtkUIManager* _tmp21_;
	gint _tmp22_;
#line 315 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 315 "main_window_build_tools.vala"
	g_return_if_fail (build_tool != NULL);
#line 315 "main_window_build_tools.vala"
	g_return_if_fail (action_name != NULL);
#line 318 "main_window_build_tools.vala"
	g_object_get (build_tool, "enabled", &_tmp0_, NULL);
#line 318 "main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 318 "main_window_build_tools.vala"
	if (!_tmp1_) {
#line 319 "main_window_build_tools.vala"
		return;
#line 1702 "main_window_build_tools.c"
	}
#line 321 "main_window_build_tools.vala"
	g_object_get (build_tool, "label", &_tmp2_, NULL);
#line 321 "main_window_build_tools.vala"
	_tmp3_ = _tmp2_;
#line 321 "main_window_build_tools.vala"
	_tmp4_ = _tmp3_;
#line 321 "main_window_build_tools.vala"
	_tmp5_ = latexila_build_tool_get_description (build_tool);
#line 321 "main_window_build_tools.vala"
	_tmp6_ = gtk_action_new (action_name, _tmp4_, _tmp5_, NULL);
#line 321 "main_window_build_tools.vala"
	_tmp7_ = _tmp6_;
#line 321 "main_window_build_tools.vala"
	_g_free0 (_tmp4_);
#line 321 "main_window_build_tools.vala"
	action = _tmp7_;
#line 323 "main_window_build_tools.vala"
	_tmp8_ = action;
#line 323 "main_window_build_tools.vala"
	g_object_get (build_tool, "icon", &_tmp9_, NULL);
#line 323 "main_window_build_tools.vala"
	_tmp10_ = _tmp9_;
#line 323 "main_window_build_tools.vala"
	_tmp11_ = _tmp10_;
#line 323 "main_window_build_tools.vala"
	gtk_action_set_icon_name (_tmp8_, _tmp11_);
#line 323 "main_window_build_tools.vala"
	_g_free0 (_tmp11_);
#line 324 "main_window_build_tools.vala"
	_tmp12_ = action;
#line 324 "main_window_build_tools.vala"
	gtk_action_set_always_show_image (_tmp12_, TRUE);
#line 328 "main_window_build_tools.vala"
	accel = NULL;
#line 329 "main_window_build_tools.vala"
	if ((*accel_num) <= 11) {
#line 1740 "main_window_build_tools.c"
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 330 "main_window_build_tools.vala"
		_tmp13_ = g_strdup_printf ("%i", *accel_num);
#line 330 "main_window_build_tools.vala"
		_tmp14_ = _tmp13_;
#line 330 "main_window_build_tools.vala"
		_tmp15_ = g_strconcat ("<Release>F", _tmp14_, NULL);
#line 330 "main_window_build_tools.vala"
		_g_free0 (accel);
#line 330 "main_window_build_tools.vala"
		accel = _tmp15_;
#line 330 "main_window_build_tools.vala"
		_g_free0 (_tmp14_);
#line 1756 "main_window_build_tools.c"
	}
#line 332 "main_window_build_tools.vala"
	_tmp16_ = self->priv->_dynamic_action_group;
#line 332 "main_window_build_tools.vala"
	_tmp17_ = action;
#line 332 "main_window_build_tools.vala"
	_tmp18_ = accel;
#line 332 "main_window_build_tools.vala"
	gtk_action_group_add_action_with_accel (_tmp16_, _tmp17_, _tmp18_);
#line 333 "main_window_build_tools.vala"
	_tmp19_ = action;
#line 333 "main_window_build_tools.vala"
	g_signal_connect (_tmp19_, "activate", (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
#line 335 "main_window_build_tools.vala"
	_tmp20_ = self->priv->_ui_manager;
#line 335 "main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp20_, self->priv->_menu_ui_id, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", action_name, action_name, GTK_UI_MANAGER_MENUITEM, FALSE);
#line 339 "main_window_build_tools.vala"
	_tmp21_ = self->priv->_ui_manager;
#line 339 "main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp21_, self->priv->_menu_ui_id, "/MainToolbar/BuildToolsPlaceholderToolbar", action_name, action_name, GTK_UI_MANAGER_TOOLITEM, FALSE);
#line 343 "main_window_build_tools.vala"
	_tmp22_ = *accel_num;
#line 343 "main_window_build_tools.vala"
	*accel_num = _tmp22_ + 1;
#line 315 "main_window_build_tools.vala"
	_g_free0 (accel);
#line 315 "main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 1786 "main_window_build_tools.c"
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
#line 346 "main_window_build_tools.vala"
	g_atomic_int_inc (&_data22_->_ref_count_);
#line 346 "main_window_build_tools.vala"
	return _data22_;
#line 1796 "main_window_build_tools.c"
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
#line 346 "main_window_build_tools.vala"
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
#line 1806 "main_window_build_tools.c"
		MainWindowBuildTools* self;
#line 346 "main_window_build_tools.vala"
		self = _data22_->self;
#line 346 "main_window_build_tools.vala"
		_g_object_unref0 (_data22_->tool);
#line 346 "main_window_build_tools.vala"
		_main_window_build_tools_unref0 (self);
#line 346 "main_window_build_tools.vala"
		g_slice_free (Block22Data, _data22_);
#line 1816 "main_window_build_tools.c"
	}
}

static void
__lambda28_ (Block22Data* _data22_,
             GObject* obj,
             GAsyncResult* _result_)
{
	MainWindowBuildTools* self;
	GAsyncResult* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	MainWindow* _tmp2_;
	MainWindowStructure* _tmp3_;
	MainWindowStructure* _tmp4_;
#line 395 "main_window_build_tools.vala"
	self = _data22_->self;
#line 395 "main_window_build_tools.vala"
	g_return_if_fail (_result_ != NULL);
#line 397 "main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (_result_);
#line 397 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_tool_result);
#line 397 "main_window_build_tools.vala"
	self->priv->_build_tool_result = _tmp0_;
#line 398 "main_window_build_tools.vala"
	_tmp1_ = _data22_->tool;
#line 398 "main_window_build_tools.vala"
	latexila_build_tool_run_finish (_tmp1_, _result_);
#line 399 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 399 "main_window_build_tools.vala"
	self->priv->_cancellable = NULL;
#line 400 "main_window_build_tools.vala"
	main_window_build_tools_update_sensitivity (self);
#line 406 "main_window_build_tools.vala"
	_tmp2_ = self->priv->_main_window;
#line 406 "main_window_build_tools.vala"
	_tmp3_ = main_window_get_main_window_structure (_tmp2_);
#line 406 "main_window_build_tools.vala"
	_tmp4_ = _tmp3_;
#line 406 "main_window_build_tools.vala"
	main_window_structure_refresh (_tmp4_);
#line 406 "main_window_build_tools.vala"
	_main_window_structure_unref0 (_tmp4_);
#line 1861 "main_window_build_tools.c"
}

static void
___lambda28__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 395 "main_window_build_tools.vala"
	__lambda28_ (self, source_object, res);
#line 395 "main_window_build_tools.vala"
	block22_data_unref (self);
#line 1873 "main_window_build_tools.c"
}

static void
main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self,
                                                 GtkAction* action)
{
	Block22Data* _data22_;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	LatexilaBuildView* _tmp3_;
	BottomPanel* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	LatexilaBuildTool* _tmp8_;
	Document* active_doc = NULL;
	MainWindow* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	LatexilaBuildTool* _tmp13_;
	GList* _tmp14_;
	LatexilaBuildTool* _tmp18_;
	GList* _tmp19_;
	GFile* main_file = NULL;
	Document* _tmp43_;
	GFile* _tmp44_;
	GCancellable* _tmp45_;
	LatexilaBuildTool* _tmp46_;
	LatexilaBuildView* _tmp47_;
	GCancellable* _tmp48_;
	BottomPanel* _tmp49_;
#line 346 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 346 "main_window_build_tools.vala"
	g_return_if_fail (action != NULL);
#line 346 "main_window_build_tools.vala"
	_data22_ = g_slice_new0 (Block22Data);
#line 346 "main_window_build_tools.vala"
	_data22_->_ref_count_ = 1;
#line 346 "main_window_build_tools.vala"
	_data22_->self = main_window_build_tools_ref (self);
#line 348 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_main_window;
#line 348 "main_window_build_tools.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 348 "main_window_build_tools.vala"
	_tmp2_ = _tmp1_;
#line 348 "main_window_build_tools.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 349 "main_window_build_tools.vala"
	_tmp3_ = self->priv->_build_view;
#line 349 "main_window_build_tools.vala"
	g_return_if_fail (_tmp3_ != NULL);
#line 350 "main_window_build_tools.vala"
	_tmp4_ = self->priv->_bottom_panel;
#line 350 "main_window_build_tools.vala"
	g_return_if_fail (_tmp4_ != NULL);
#line 352 "main_window_build_tools.vala"
	_tmp5_ = gtk_action_get_name (action);
#line 352 "main_window_build_tools.vala"
	_tmp6_ = _tmp5_;
#line 352 "main_window_build_tools.vala"
	_tmp7_ = main_window_build_tools_get_build_tool_from_name (self, _tmp6_);
#line 352 "main_window_build_tools.vala"
	_data22_->tool = _tmp7_;
#line 353 "main_window_build_tools.vala"
	_tmp8_ = _data22_->tool;
#line 353 "main_window_build_tools.vala"
	g_return_if_fail (_tmp8_ != NULL);
#line 355 "main_window_build_tools.vala"
	_tmp9_ = self->priv->_main_window;
#line 355 "main_window_build_tools.vala"
	_tmp10_ = main_window_get_active_document (_tmp9_);
#line 355 "main_window_build_tools.vala"
	_tmp11_ = _tmp10_;
#line 355 "main_window_build_tools.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 355 "main_window_build_tools.vala"
	active_doc = _tmp12_;
#line 357 "main_window_build_tools.vala"
	_tmp13_ = _data22_->tool;
#line 357 "main_window_build_tools.vala"
	_tmp14_ = latexila_build_tool_get_jobs (_tmp13_);
#line 357 "main_window_build_tools.vala"
	if (_tmp14_ == NULL) {
#line 1961 "main_window_build_tools.c"
		Document* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
#line 358 "main_window_build_tools.vala"
		_tmp15_ = active_doc;
#line 358 "main_window_build_tools.vala"
		_tmp16_ = document_get_location (_tmp15_);
#line 358 "main_window_build_tools.vala"
		_tmp17_ = _tmp16_;
#line 358 "main_window_build_tools.vala"
		g_return_if_fail (_tmp17_ != NULL);
#line 1973 "main_window_build_tools.c"
	}
#line 361 "main_window_build_tools.vala"
	_tmp18_ = _data22_->tool;
#line 361 "main_window_build_tools.vala"
	_tmp19_ = latexila_build_tool_get_jobs (_tmp18_);
#line 361 "main_window_build_tools.vala"
	if (_tmp19_ != NULL) {
#line 1981 "main_window_build_tools.c"
		Document* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		gint project_id = 0;
		Document* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
#line 363 "main_window_build_tools.vala"
		_tmp20_ = active_doc;
#line 363 "main_window_build_tools.vala"
		_tmp21_ = document_get_location (_tmp20_);
#line 363 "main_window_build_tools.vala"
		_tmp22_ = _tmp21_;
#line 363 "main_window_build_tools.vala"
		if (_tmp22_ == NULL) {
#line 1997 "main_window_build_tools.c"
			gboolean tmp_location_set = FALSE;
			Document* _tmp23_;
#line 365 "main_window_build_tools.vala"
			_tmp23_ = active_doc;
#line 365 "main_window_build_tools.vala"
			tmp_location_set = document_set_tmp_location (_tmp23_);
#line 366 "main_window_build_tools.vala"
			g_return_if_fail (tmp_location_set);
#line 2006 "main_window_build_tools.c"
		}
#line 369 "main_window_build_tools.vala"
		_tmp24_ = active_doc;
#line 369 "main_window_build_tools.vala"
		_tmp25_ = document_get_project_id (_tmp24_);
#line 369 "main_window_build_tools.vala"
		_tmp26_ = _tmp25_;
#line 369 "main_window_build_tools.vala"
		project_id = _tmp26_;
#line 371 "main_window_build_tools.vala"
		if (project_id == -1) {
#line 2018 "main_window_build_tools.c"
			Document* _tmp27_;
#line 372 "main_window_build_tools.vala"
			_tmp27_ = active_doc;
#line 372 "main_window_build_tools.vala"
			document_save (_tmp27_, TRUE, FALSE);
#line 2024 "main_window_build_tools.c"
		} else {
			GeeList* docs = NULL;
			GlatexApp* _tmp28_;
			GlatexApp* _tmp29_;
			GeeList* _tmp30_;
			GeeList* _tmp31_;
#line 377 "main_window_build_tools.vala"
			_tmp28_ = glatex_app_get_instance ();
#line 377 "main_window_build_tools.vala"
			_tmp29_ = _tmp28_;
#line 377 "main_window_build_tools.vala"
			_tmp30_ = glatex_app_get_documents (_tmp29_);
#line 377 "main_window_build_tools.vala"
			_tmp31_ = _tmp30_;
#line 377 "main_window_build_tools.vala"
			_g_object_unref0 (_tmp29_);
#line 377 "main_window_build_tools.vala"
			docs = _tmp31_;
#line 2043 "main_window_build_tools.c"
			{
				GeeList* _doc_list = NULL;
				GeeList* _tmp32_;
				GeeList* _tmp33_;
				gint _doc_size = 0;
				GeeList* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _doc_index = 0;
#line 378 "main_window_build_tools.vala"
				_tmp32_ = docs;
#line 378 "main_window_build_tools.vala"
				_tmp33_ = _g_object_ref0 (_tmp32_);
#line 378 "main_window_build_tools.vala"
				_doc_list = _tmp33_;
#line 378 "main_window_build_tools.vala"
				_tmp34_ = _doc_list;
#line 378 "main_window_build_tools.vala"
				_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
#line 378 "main_window_build_tools.vala"
				_tmp36_ = _tmp35_;
#line 378 "main_window_build_tools.vala"
				_doc_size = _tmp36_;
#line 378 "main_window_build_tools.vala"
				_doc_index = -1;
#line 378 "main_window_build_tools.vala"
				while (TRUE) {
#line 2071 "main_window_build_tools.c"
					Document* doc = NULL;
					GeeList* _tmp37_;
					gpointer _tmp38_;
					Document* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
#line 378 "main_window_build_tools.vala"
					_doc_index = _doc_index + 1;
#line 378 "main_window_build_tools.vala"
					if (!(_doc_index < _doc_size)) {
#line 378 "main_window_build_tools.vala"
						break;
#line 2084 "main_window_build_tools.c"
					}
#line 378 "main_window_build_tools.vala"
					_tmp37_ = _doc_list;
#line 378 "main_window_build_tools.vala"
					_tmp38_ = gee_list_get (_tmp37_, _doc_index);
#line 378 "main_window_build_tools.vala"
					doc = (Document*) _tmp38_;
#line 380 "main_window_build_tools.vala"
					_tmp39_ = doc;
#line 380 "main_window_build_tools.vala"
					_tmp40_ = document_get_project_id (_tmp39_);
#line 380 "main_window_build_tools.vala"
					_tmp41_ = _tmp40_;
#line 380 "main_window_build_tools.vala"
					if (_tmp41_ == project_id) {
#line 2100 "main_window_build_tools.c"
						Document* _tmp42_;
#line 381 "main_window_build_tools.vala"
						_tmp42_ = doc;
#line 381 "main_window_build_tools.vala"
						document_save (_tmp42_, TRUE, FALSE);
#line 2106 "main_window_build_tools.c"
					}
#line 378 "main_window_build_tools.vala"
					_g_object_unref0 (doc);
#line 2110 "main_window_build_tools.c"
				}
#line 378 "main_window_build_tools.vala"
				_g_object_unref0 (_doc_list);
#line 2114 "main_window_build_tools.c"
			}
#line 371 "main_window_build_tools.vala"
			_g_object_unref0 (docs);
#line 2118 "main_window_build_tools.c"
		}
#line 386 "main_window_build_tools.vala"
		utils_flush_queue ();
#line 2122 "main_window_build_tools.c"
	}
#line 391 "main_window_build_tools.vala"
	_tmp43_ = active_doc;
#line 391 "main_window_build_tools.vala"
	_tmp44_ = document_get_main_file (_tmp43_);
#line 391 "main_window_build_tools.vala"
	main_file = _tmp44_;
#line 392 "main_window_build_tools.vala"
	_tmp45_ = g_cancellable_new ();
#line 392 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 392 "main_window_build_tools.vala"
	self->priv->_cancellable = _tmp45_;
#line 393 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_tool_result);
#line 393 "main_window_build_tools.vala"
	self->priv->_build_tool_result = NULL;
#line 394 "main_window_build_tools.vala"
	main_window_build_tools_update_sensitivity (self);
#line 395 "main_window_build_tools.vala"
	_tmp46_ = _data22_->tool;
#line 395 "main_window_build_tools.vala"
	_tmp47_ = self->priv->_build_view;
#line 395 "main_window_build_tools.vala"
	_tmp48_ = self->priv->_cancellable;
#line 395 "main_window_build_tools.vala"
	latexila_build_tool_run_async (_tmp46_, main_file, _tmp47_, _tmp48_, ___lambda28__gasync_ready_callback, block22_data_ref (_data22_));
#line 409 "main_window_build_tools.vala"
	_tmp49_ = self->priv->_bottom_panel;
#line 409 "main_window_build_tools.vala"
	gtk_widget_show ((GtkWidget*) _tmp49_);
#line 346 "main_window_build_tools.vala"
	_g_object_unref0 (main_file);
#line 346 "main_window_build_tools.vala"
	_g_object_unref0 (active_doc);
#line 346 "main_window_build_tools.vala"
	block22_data_unref (_data22_);
#line 346 "main_window_build_tools.vala"
	_data22_ = NULL;
#line 2162 "main_window_build_tools.c"
}

static void
main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self)
{
	LatexilaBuildView* _tmp0_;
	GSettings* settings = NULL;
	GSettings* _tmp1_;
	GtkToggleAction* action_details = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	LatexilaBuildView* _tmp5_;
	LatexilaBuildView* _tmp6_;
	GtkToggleAction* action_warnings = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	LatexilaBuildView* _tmp10_;
	GtkToggleAction* action_badboxes = NULL;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_;
	GtkToggleAction* _tmp13_;
	LatexilaBuildView* _tmp14_;
#line 412 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 414 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_build_view;
#line 414 "main_window_build_tools.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 416 "main_window_build_tools.vala"
	_tmp1_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 416 "main_window_build_tools.vala"
	settings = _tmp1_;
#line 420 "main_window_build_tools.vala"
	_tmp2_ = self->priv->_static_action_group;
#line 420 "main_window_build_tools.vala"
	_tmp3_ = gtk_action_group_get_action (_tmp2_, "BuildShowDetails");
#line 420 "main_window_build_tools.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp3_) : NULL);
#line 420 "main_window_build_tools.vala"
	action_details = _tmp4_;
#line 423 "main_window_build_tools.vala"
	gtk_toggle_action_set_active (action_details, FALSE);
#line 425 "main_window_build_tools.vala"
	_tmp5_ = self->priv->_build_view;
#line 425 "main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) action_details, "active", (GObject*) _tmp5_, "show-details", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 428 "main_window_build_tools.vala"
	_tmp6_ = self->priv->_build_view;
#line 428 "main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "has-details", (GObject*) action_details, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 433 "main_window_build_tools.vala"
	_tmp7_ = self->priv->_static_action_group;
#line 433 "main_window_build_tools.vala"
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowWarnings");
#line 433 "main_window_build_tools.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
#line 433 "main_window_build_tools.vala"
	action_warnings = _tmp9_;
#line 436 "main_window_build_tools.vala"
	gtk_toggle_action_set_active (action_warnings, g_settings_get_boolean (settings, "show-build-warnings"));
#line 438 "main_window_build_tools.vala"
	_tmp10_ = self->priv->_build_view;
#line 438 "main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) action_warnings, "active", (GObject*) _tmp10_, "show-warnings", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 443 "main_window_build_tools.vala"
	_tmp11_ = self->priv->_static_action_group;
#line 443 "main_window_build_tools.vala"
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "BuildShowBadBoxes");
#line 443 "main_window_build_tools.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp12_) : NULL);
#line 443 "main_window_build_tools.vala"
	action_badboxes = _tmp13_;
#line 446 "main_window_build_tools.vala"
	gtk_toggle_action_set_active (action_badboxes, g_settings_get_boolean (settings, "show-build-badboxes"));
#line 448 "main_window_build_tools.vala"
	_tmp14_ = self->priv->_build_view;
#line 448 "main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) action_badboxes, "active", (GObject*) _tmp14_, "show-badboxes", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 412 "main_window_build_tools.vala"
	_g_object_unref0 (action_badboxes);
#line 412 "main_window_build_tools.vala"
	_g_object_unref0 (action_warnings);
#line 412 "main_window_build_tools.vala"
	_g_object_unref0 (action_details);
#line 412 "main_window_build_tools.vala"
	_g_object_unref0 (settings);
#line 2251 "main_window_build_tools.c"
}

void
main_window_build_tools_on_stop_execution (MainWindowBuildTools* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 454 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 456 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_cancellable;
#line 456 "main_window_build_tools.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 457 "main_window_build_tools.vala"
	_tmp1_ = self->priv->_cancellable;
#line 457 "main_window_build_tools.vala"
	g_cancellable_cancel (_tmp1_);
#line 2269 "main_window_build_tools.c"
}

void
main_window_build_tools_on_clean (MainWindowBuildTools* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	CleanBuildFiles* build_files = NULL;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	CleanBuildFiles* _tmp7_;
#line 460 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 462 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_main_window;
#line 462 "main_window_build_tools.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 462 "main_window_build_tools.vala"
	_tmp2_ = _tmp1_;
#line 462 "main_window_build_tools.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 464 "main_window_build_tools.vala"
	_tmp3_ = self->priv->_main_window;
#line 464 "main_window_build_tools.vala"
	_tmp4_ = self->priv->_main_window;
#line 464 "main_window_build_tools.vala"
	_tmp5_ = main_window_get_active_document (_tmp4_);
#line 464 "main_window_build_tools.vala"
	_tmp6_ = _tmp5_;
#line 464 "main_window_build_tools.vala"
	_tmp7_ = clean_build_files_new (_tmp3_, _tmp6_);
#line 464 "main_window_build_tools.vala"
	build_files = _tmp7_;
#line 467 "main_window_build_tools.vala"
	clean_build_files_clean (build_files);
#line 460 "main_window_build_tools.vala"
	_g_object_unref0 (build_files);
#line 2310 "main_window_build_tools.c"
}

void
main_window_build_tools_on_view_log (MainWindowBuildTools* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GFile* mainfile = NULL;
	MainWindow* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	GFile* _tmp9_;
	GFile* directory = NULL;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* basename = NULL;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFile* file = NULL;
	GFile* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	DocumentTab* tab = NULL;
	MainWindow* _tmp22_;
	GFile* _tmp23_;
	DocumentTab* _tmp24_;
	DocumentTab* _tmp25_;
#line 470 "main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 472 "main_window_build_tools.vala"
	_tmp0_ = self->priv->_main_window;
#line 472 "main_window_build_tools.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 472 "main_window_build_tools.vala"
	_tmp2_ = _tmp1_;
#line 472 "main_window_build_tools.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 473 "main_window_build_tools.vala"
	_tmp3_ = self->priv->_main_window;
#line 473 "main_window_build_tools.vala"
	_tmp4_ = main_window_get_active_document (_tmp3_);
#line 473 "main_window_build_tools.vala"
	_tmp5_ = _tmp4_;
#line 473 "main_window_build_tools.vala"
	g_return_if_fail (document_is_main_file_a_tex_file (_tmp5_));
#line 475 "main_window_build_tools.vala"
	_tmp6_ = self->priv->_main_window;
#line 475 "main_window_build_tools.vala"
	_tmp7_ = main_window_get_active_document (_tmp6_);
#line 475 "main_window_build_tools.vala"
	_tmp8_ = _tmp7_;
#line 475 "main_window_build_tools.vala"
	_tmp9_ = document_get_main_file (_tmp8_);
#line 475 "main_window_build_tools.vala"
	mainfile = _tmp9_;
#line 476 "main_window_build_tools.vala"
	_tmp10_ = mainfile;
#line 476 "main_window_build_tools.vala"
	_tmp11_ = g_file_get_parent (_tmp10_);
#line 476 "main_window_build_tools.vala"
	directory = _tmp11_;
#line 478 "main_window_build_tools.vala"
	_tmp12_ = mainfile;
#line 478 "main_window_build_tools.vala"
	_tmp13_ = g_file_get_basename (_tmp12_);
#line 478 "main_window_build_tools.vala"
	_tmp14_ = _tmp13_;
#line 478 "main_window_build_tools.vala"
	_tmp15_ = tepl_utils_get_file_shortname (_tmp14_);
#line 478 "main_window_build_tools.vala"
	_tmp16_ = _tmp15_;
#line 478 "main_window_build_tools.vala"
	_tmp17_ = g_strconcat (_tmp16_, ".log", NULL);
#line 478 "main_window_build_tools.vala"
	_tmp18_ = _tmp17_;
#line 478 "main_window_build_tools.vala"
	_g_free0 (_tmp16_);
#line 478 "main_window_build_tools.vala"
	_g_free0 (_tmp14_);
#line 478 "main_window_build_tools.vala"
	basename = _tmp18_;
#line 479 "main_window_build_tools.vala"
	_tmp19_ = directory;
#line 479 "main_window_build_tools.vala"
	_tmp20_ = basename;
#line 479 "main_window_build_tools.vala"
	_tmp21_ = g_file_get_child (_tmp19_, _tmp20_);
#line 479 "main_window_build_tools.vala"
	file = _tmp21_;
#line 480 "main_window_build_tools.vala"
	_tmp22_ = self->priv->_main_window;
#line 480 "main_window_build_tools.vala"
	_tmp23_ = file;
#line 480 "main_window_build_tools.vala"
	_tmp24_ = main_window_open_document (_tmp22_, _tmp23_, TRUE);
#line 480 "main_window_build_tools.vala"
	tab = _tmp24_;
#line 482 "main_window_build_tools.vala"
	_tmp25_ = tab;
#line 482 "main_window_build_tools.vala"
	if (_tmp25_ == NULL) {
#line 483 "main_window_build_tools.vala"
		g_warning ("main_window_build_tools.vala:483: Impossible to view log");
#line 2423 "main_window_build_tools.c"
	} else {
		DocumentTab* _tmp26_;
		Document* _tmp27_;
		Document* _tmp28_;
#line 485 "main_window_build_tools.vala"
		_tmp26_ = tab;
#line 485 "main_window_build_tools.vala"
		_tmp27_ = document_tab_get_document (_tmp26_);
#line 485 "main_window_build_tools.vala"
		_tmp28_ = _tmp27_;
#line 485 "main_window_build_tools.vala"
		document_set_readonly (_tmp28_, TRUE);
#line 2436 "main_window_build_tools.c"
	}
#line 470 "main_window_build_tools.vala"
	_g_object_unref0 (tab);
#line 470 "main_window_build_tools.vala"
	_g_object_unref0 (file);
#line 470 "main_window_build_tools.vala"
	_g_free0 (basename);
#line 470 "main_window_build_tools.vala"
	_g_object_unref0 (directory);
#line 470 "main_window_build_tools.vala"
	_g_object_unref0 (mainfile);
#line 2448 "main_window_build_tools.c"
}

static void
value_main_window_build_tools_init (GValue* value)
{
#line 24 "main_window_build_tools.vala"
	value->data[0].v_pointer = NULL;
#line 2456 "main_window_build_tools.c"
}

static void
value_main_window_build_tools_free_value (GValue* value)
{
#line 24 "main_window_build_tools.vala"
	if (value->data[0].v_pointer) {
#line 24 "main_window_build_tools.vala"
		main_window_build_tools_unref (value->data[0].v_pointer);
#line 2466 "main_window_build_tools.c"
	}
}

static void
value_main_window_build_tools_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 24 "main_window_build_tools.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "main_window_build_tools.vala"
		dest_value->data[0].v_pointer = main_window_build_tools_ref (src_value->data[0].v_pointer);
#line 2478 "main_window_build_tools.c"
	} else {
#line 24 "main_window_build_tools.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2482 "main_window_build_tools.c"
	}
}

static gpointer
value_main_window_build_tools_peek_pointer (const GValue* value)
{
#line 24 "main_window_build_tools.vala"
	return value->data[0].v_pointer;
#line 2491 "main_window_build_tools.c"
}

static gchar*
value_main_window_build_tools_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 24 "main_window_build_tools.vala"
	if (collect_values[0].v_pointer) {
#line 2502 "main_window_build_tools.c"
		MainWindowBuildTools * object;
		object = collect_values[0].v_pointer;
#line 24 "main_window_build_tools.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "main_window_build_tools.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2509 "main_window_build_tools.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "main_window_build_tools.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2513 "main_window_build_tools.c"
		}
#line 24 "main_window_build_tools.vala"
		value->data[0].v_pointer = main_window_build_tools_ref (object);
#line 2517 "main_window_build_tools.c"
	} else {
#line 24 "main_window_build_tools.vala"
		value->data[0].v_pointer = NULL;
#line 2521 "main_window_build_tools.c"
	}
#line 24 "main_window_build_tools.vala"
	return NULL;
#line 2525 "main_window_build_tools.c"
}

static gchar*
value_main_window_build_tools_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	MainWindowBuildTools ** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "main_window_build_tools.vala"
	if (!object_p) {
#line 24 "main_window_build_tools.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2540 "main_window_build_tools.c"
	}
#line 24 "main_window_build_tools.vala"
	if (!value->data[0].v_pointer) {
#line 24 "main_window_build_tools.vala"
		*object_p = NULL;
#line 2546 "main_window_build_tools.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "main_window_build_tools.vala"
		*object_p = value->data[0].v_pointer;
#line 2550 "main_window_build_tools.c"
	} else {
#line 24 "main_window_build_tools.vala"
		*object_p = main_window_build_tools_ref (value->data[0].v_pointer);
#line 2554 "main_window_build_tools.c"
	}
#line 24 "main_window_build_tools.vala"
	return NULL;
#line 2558 "main_window_build_tools.c"
}

GParamSpec*
param_spec_main_window_build_tools (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ParamSpecMainWindowBuildTools* spec;
#line 24 "main_window_build_tools.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
#line 24 "main_window_build_tools.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "main_window_build_tools.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "main_window_build_tools.vala"
	return G_PARAM_SPEC (spec);
#line 2577 "main_window_build_tools.c"
}

gpointer
value_get_main_window_build_tools (const GValue* value)
{
#line 24 "main_window_build_tools.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
#line 24 "main_window_build_tools.vala"
	return value->data[0].v_pointer;
#line 2587 "main_window_build_tools.c"
}

void
value_set_main_window_build_tools (GValue* value,
                                   gpointer v_object)
{
	MainWindowBuildTools * old;
#line 24 "main_window_build_tools.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "main_window_build_tools.vala"
	old = value->data[0].v_pointer;
#line 24 "main_window_build_tools.vala"
	if (v_object) {
#line 24 "main_window_build_tools.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "main_window_build_tools.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "main_window_build_tools.vala"
		value->data[0].v_pointer = v_object;
#line 24 "main_window_build_tools.vala"
		main_window_build_tools_ref (value->data[0].v_pointer);
#line 2609 "main_window_build_tools.c"
	} else {
#line 24 "main_window_build_tools.vala"
		value->data[0].v_pointer = NULL;
#line 2613 "main_window_build_tools.c"
	}
#line 24 "main_window_build_tools.vala"
	if (old) {
#line 24 "main_window_build_tools.vala"
		main_window_build_tools_unref (old);
#line 2619 "main_window_build_tools.c"
	}
}

void
value_take_main_window_build_tools (GValue* value,
                                    gpointer v_object)
{
	MainWindowBuildTools * old;
#line 24 "main_window_build_tools.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "main_window_build_tools.vala"
	old = value->data[0].v_pointer;
#line 24 "main_window_build_tools.vala"
	if (v_object) {
#line 24 "main_window_build_tools.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "main_window_build_tools.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "main_window_build_tools.vala"
		value->data[0].v_pointer = v_object;
#line 2640 "main_window_build_tools.c"
	} else {
#line 24 "main_window_build_tools.vala"
		value->data[0].v_pointer = NULL;
#line 2644 "main_window_build_tools.c"
	}
#line 24 "main_window_build_tools.vala"
	if (old) {
#line 24 "main_window_build_tools.vala"
		main_window_build_tools_unref (old);
#line 2650 "main_window_build_tools.c"
	}
}

static void
main_window_build_tools_class_init (MainWindowBuildToolsClass * klass,
                                    gpointer klass_data)
{
#line 24 "main_window_build_tools.vala"
	main_window_build_tools_parent_class = g_type_class_peek_parent (klass);
#line 24 "main_window_build_tools.vala"
	((MainWindowBuildToolsClass *) klass)->finalize = main_window_build_tools_finalize;
#line 24 "main_window_build_tools.vala"
	g_type_class_adjust_private_offset (klass, &MainWindowBuildTools_private_offset);
#line 2664 "main_window_build_tools.c"
}

static void
main_window_build_tools_instance_init (MainWindowBuildTools * self,
                                       gpointer klass)
{
#line 24 "main_window_build_tools.vala"
	self->priv = main_window_build_tools_get_instance_private (self);
#line 24 "main_window_build_tools.vala"
	self->ref_count = 1;
#line 2675 "main_window_build_tools.c"
}

static void
main_window_build_tools_finalize (MainWindowBuildTools * obj)
{
	MainWindowBuildTools * self;
#line 24 "main_window_build_tools.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools);
#line 24 "main_window_build_tools.vala"
	g_signal_handlers_destroy (self);
#line 57 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 58 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_view);
#line 59 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_bottom_panel);
#line 62 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 63 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_tool_result);
#line 65 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_static_action_group);
#line 66 "main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_dynamic_action_group);
#line 2700 "main_window_build_tools.c"
}

GType
main_window_build_tools_get_type (void)
{
	static volatile gsize main_window_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_build_tools_init, value_main_window_build_tools_free_value, value_main_window_build_tools_copy_value, value_main_window_build_tools_peek_pointer, "p", value_main_window_build_tools_collect_value, "p", value_main_window_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowBuildTools), 0, (GInstanceInitFunc) main_window_build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_build_tools_type_id;
		main_window_build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowBuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		MainWindowBuildTools_private_offset = g_type_add_instance_private (main_window_build_tools_type_id, sizeof (MainWindowBuildToolsPrivate));
		g_once_init_leave (&main_window_build_tools_type_id__volatile, main_window_build_tools_type_id);
	}
	return main_window_build_tools_type_id__volatile;
}

gpointer
main_window_build_tools_ref (gpointer instance)
{
	MainWindowBuildTools * self;
	self = instance;
#line 24 "main_window_build_tools.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "main_window_build_tools.vala"
	return instance;
#line 2728 "main_window_build_tools.c"
}

void
main_window_build_tools_unref (gpointer instance)
{
	MainWindowBuildTools * self;
	self = instance;
#line 24 "main_window_build_tools.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "main_window_build_tools.vala"
		MAIN_WINDOW_BUILD_TOOLS_GET_CLASS (self)->finalize (self);
#line 24 "main_window_build_tools.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2742 "main_window_build_tools.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 2753 "main_window_build_tools.c"
		int i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 2761 "main_window_build_tools.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 2776 "main_window_build_tools.c"
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 2790 "main_window_build_tools.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 2795 "main_window_build_tools.c"
}

