/* main_window.c generated by valac 0.46.6, the Vala compiler
 * generated from main_window.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2015, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "config.h"
#include <amtk/amtk.h>
#include <gio/gio.h>
#include <latexila.h>
#include <gee.h>
#include <gtksourceview/gtksource.h>

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;

#define TYPE_CUSTOM_STATUSBAR (custom_statusbar_get_type ())
#define CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbar))
#define CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))
#define IS_CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_STATUSBAR))
#define IS_CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_STATUSBAR))
#define CUSTOM_STATUSBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))

typedef struct _CustomStatusbar CustomStatusbar;
typedef struct _CustomStatusbarClass CustomStatusbarClass;

#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;

#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;

#define TYPE_MAIN_WINDOW_EDIT (main_window_edit_get_type ())
#define MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEdit))
#define MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))
#define IS_MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_EDIT))
#define IS_MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_EDIT))
#define MAIN_WINDOW_EDIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))

typedef struct _MainWindowEdit MainWindowEdit;
typedef struct _MainWindowEditClass MainWindowEditClass;

#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;

#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;

#define TYPE_MAIN_WINDOW_TOOLS (main_window_tools_get_type ())
#define MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowTools))
#define MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))
#define IS_MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_TOOLS))
#define IS_MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_TOOLS))
#define MAIN_WINDOW_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))

typedef struct _MainWindowTools MainWindowTools;
typedef struct _MainWindowToolsClass MainWindowToolsClass;
enum  {
	MAIN_WINDOW_0_PROPERTY,
	MAIN_WINDOW_ACTIVE_TAB_PROPERTY,
	MAIN_WINDOW_ACTIVE_VIEW_PROPERTY,
	MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY,
	MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* main_window_properties[MAIN_WINDOW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _main_window_file_unref0(var) ((var == NULL) ? NULL : (var = (main_window_file_unref (var), NULL)))
#define _main_window_edit_unref0(var) ((var == NULL) ? NULL : (var = (main_window_edit_unref (var), NULL)))
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))
#define _main_window_documents_unref0(var) ((var == NULL) ? NULL : (var = (main_window_documents_unref (var), NULL)))
#define _main_window_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_tools_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_SIDE_PANEL (side_panel_get_type ())
#define SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIDE_PANEL, SidePanel))
#define SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIDE_PANEL, SidePanelClass))
#define IS_SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIDE_PANEL))
#define IS_SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIDE_PANEL))
#define SIDE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIDE_PANEL, SidePanelClass))

typedef struct _SidePanel SidePanel;
typedef struct _SidePanelClass SidePanelClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_LATEX_MENU (latex_menu_get_type ())
#define LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_MENU, LatexMenu))
#define LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_MENU, LatexMenuClass))
#define IS_LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_MENU))
#define IS_LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_MENU))
#define LATEX_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_MENU, LatexMenuClass))

typedef struct _LatexMenu LatexMenu;
typedef struct _LatexMenuClass LatexMenuClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SYMBOLS_VIEW (symbols_view_get_type ())
#define SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS_VIEW, SymbolsView))
#define SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS_VIEW, SymbolsViewClass))
#define IS_SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS_VIEW))
#define IS_SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS_VIEW))
#define SYMBOLS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS_VIEW, SymbolsViewClass))

typedef struct _SymbolsView SymbolsView;
typedef struct _SymbolsViewClass SymbolsViewClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block23Data Block23Data;
typedef struct _DocumentPrivate DocumentPrivate;
typedef struct _Block24Data Block24Data;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	DocumentsPanel* _documents_panel;
	CustomStatusbar* _statusbar;
	GotoLine* _goto_line;
	SearchAndReplace* _search_and_replace;
	GtkPaned* _main_hpaned;
	GtkPaned* _vpaned;
	GtkUIManager* _ui_manager;
	GtkActionGroup* _action_group;
	GtkActionGroup* _latex_action_group;
	MainWindowFile* _main_window_file;
	MainWindowEdit* _main_window_edit;
	MainWindowBuildTools* _main_window_build_tools;
	MainWindowStructure* _main_window_structure;
	MainWindowDocuments* _main_window_documents;
	MainWindowTools* _main_window_tools;
	guint _tip_message_cid;
};

struct _Block23Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
	GtkInfoBar* infobar;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _Block24Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
};

static gint MainWindow_private_offset;
static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType documents_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentsPanel, g_object_unref)
GType custom_statusbar_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CustomStatusbar, g_object_unref)
GType goto_line_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GotoLine, g_object_unref)
GType search_and_replace_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchAndReplace, g_object_unref)
gpointer main_window_file_ref (gpointer instance);
void main_window_file_unref (gpointer instance);
GParamSpec* param_spec_main_window_file (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_file (GValue* value,
                                 gpointer v_object);
void value_take_main_window_file (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_file (const GValue* value);
GType main_window_file_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowFile, main_window_file_unref)
gpointer main_window_edit_ref (gpointer instance);
void main_window_edit_unref (gpointer instance);
GParamSpec* param_spec_main_window_edit (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_edit (GValue* value,
                                 gpointer v_object);
void value_take_main_window_edit (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_edit (const GValue* value);
GType main_window_edit_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowEdit, main_window_edit_unref)
gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void value_set_main_window_build_tools (GValue* value,
                                        gpointer v_object);
void value_take_main_window_build_tools (GValue* value,
                                         gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowBuildTools, main_window_build_tools_unref)
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_structure (GValue* value,
                                      gpointer v_object);
void value_take_main_window_structure (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowStructure, main_window_structure_unref)
gpointer main_window_documents_ref (gpointer instance);
void main_window_documents_unref (gpointer instance);
GParamSpec* param_spec_main_window_documents (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_documents (GValue* value,
                                      gpointer v_object);
void value_take_main_window_documents (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_documents (const GValue* value);
GType main_window_documents_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowDocuments, main_window_documents_unref)
gpointer main_window_tools_ref (gpointer instance);
void main_window_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_tools (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_main_window_tools (GValue* value,
                                  gpointer v_object);
void value_take_main_window_tools (GValue* value,
                                   gpointer v_object);
gpointer value_get_main_window_tools (const GValue* value);
GType main_window_tools_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowTools, main_window_tools_unref)
void main_window_on_view_zoom_in (MainWindow* self);
static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
void main_window_on_view_zoom_out (MainWindow* self);
static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action,
                                                        gpointer self);
void main_window_on_view_zoom_reset (MainWindow* self);
static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
void main_window_on_search_find (MainWindow* self);
static void _main_window_on_search_find_gtk_action_callback (GtkAction* action,
                                                      gpointer self);
void main_window_on_search_replace (MainWindow* self);
static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_on_search_goto_line (MainWindow* self);
static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action,
                                                           gpointer self);
void main_window_on_search_forward (MainWindow* self);
static void _main_window_on_search_forward_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_on_projects_new (MainWindow* self);
static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
void main_window_on_projects_config_current (MainWindow* self);
static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action,
                                                                  gpointer self);
void main_window_on_projects_manage (MainWindow* self);
static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
void main_window_on_help_latex_reference (MainWindow* self);
static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
MainWindow* main_window_new (GlatexApp* app);
MainWindow* main_window_construct (GType object_type,
                                   GlatexApp* app);
static void main_window_initialize_ui_manager (MainWindow* self);
MainWindowFile* main_window_file_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowFile* main_window_file_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window,
                                                   GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type,
                                                         MainWindow* main_window,
                                                         GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_new (MainWindow* main_window,
                                                GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_construct (GType object_type,
                                                      MainWindow* main_window,
                                                      GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_new (GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_construct (GType object_type,
                                                      GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_new (MainWindow* main_window,
                                        GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_construct (GType object_type,
                                              MainWindow* main_window,
                                              GtkUIManager* ui_manager);
static void main_window_show_images_in_menu (MainWindow* self);
static void main_window_update_file_actions_sensitivity (MainWindow* self);
static GtkToolbar* main_window_get_main_toolbar (MainWindow* self);
static GtkToolbar* main_window_get_edit_toolbar (MainWindow* self);
GType side_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidePanel, g_object_unref)
static SidePanel* main_window_get_side_panel (MainWindow* self);
static void main_window_init_documents_panel (MainWindow* self);
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type,
                               MainWindow* main_window);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type,
                                                MainWindow* main_window);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
GType bottom_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BottomPanel, g_object_unref)
static BottomPanel* main_window_get_bottom_panel (MainWindow* self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                               BottomPanel* bottom_panel);
CustomStatusbar* custom_statusbar_new (void);
CustomStatusbar* custom_statusbar_construct (GType object_type);
static void __lambda82_ (MainWindow* self);
void main_window_update_config_project_sensitivity (MainWindow* self);
static void main_window_update_cursor_position_statusbar (MainWindow* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_get_active_tab (MainWindow* self);
void search_and_replace_hide (SearchAndReplace* self);
static void ___lambda82__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda83_ (MainWindow* self);
static void ___lambda83__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda84_ (MainWindow* self);
static void ___lambda84__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void main_window_support_drag_and_drop (MainWindow* self);
static gboolean __lambda86_ (MainWindow* self);
gboolean main_window_quit (MainWindow* self);
static gboolean ___lambda86__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
static void main_window_restore_state (MainWindow* self);
static void main_window_show_or_hide_widgets (MainWindow* self);
LatexMenu* latex_menu_new (MainWindow* main_window);
LatexMenu* latex_menu_construct (GType object_type,
                                 MainWindow* main_window);
GType latex_menu_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LatexMenu, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
static void __lambda65_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void main_window_on_menu_item_select (MainWindow* self,
                                      GtkMenuItem* proxy);
static void _main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                            gpointer self);
static void main_window_on_menu_item_deselect (MainWindow* self,
                                        GtkMenuItem* proxy);
static void _main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                                gpointer self);
static void ___lambda65__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                                GtkAction* action,
                                                GtkWidget* proxy,
                                                gpointer self);
static void __lambda66_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void ___lambda66__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                                   GtkAction* action,
                                                   GtkWidget* proxy,
                                                   gpointer self);
GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
SidePanel* side_panel_new (void);
SidePanel* side_panel_construct (GType object_type);
GType symbols_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SymbolsView, g_object_unref)
SymbolsView* symbols_view_new (MainWindow* main_window);
SymbolsView* symbols_view_construct (GType object_type,
                                     MainWindow* main_window);
void side_panel_add_component (SidePanel* self,
                               const gchar* name,
                               const gchar* icon_name,
                               GtkGrid* component);
GType file_browser_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileBrowser, g_object_unref)
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type,
                                     MainWindow* main_window);
GType structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Structure, g_object_unref)
Structure* structure_new (MainWindow* main_window);
Structure* structure_construct (GType object_type,
                                MainWindow* main_window);
void main_window_structure_set_structure (MainWindowStructure* self,
                                          Structure* structure);
void side_panel_restore_state (SidePanel* self);
DocumentsPanel* documents_panel_new (MainWindow* main_window);
DocumentsPanel* documents_panel_construct (GType object_type,
                                           MainWindow* main_window);
void main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                                DocumentsPanel* documents_panel);
static void __lambda81_ (MainWindow* self,
                  GdkEventButton* event);
static void ___lambda81__documents_panel_right_click (DocumentsPanel* _sender,
                                               GdkEventButton* event,
                                               gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                             LatexilaBuildView* build_view);
BottomPanel* bottom_panel_new (LatexilaBuildView* build_view,
                               GtkToolbar* toolbar);
BottomPanel* bottom_panel_construct (GType object_type,
                                     LatexilaBuildView* build_view,
                                     GtkToolbar* toolbar);
static void __lambda85_ (MainWindow* self,
                  GdkDragContext* dc,
                  gint x,
                  gint y,
                  GtkSelectionData* selection_data,
                  guint info,
                  guint time);
static void _vala_array_add5 (GFile** * array,
                       int* length,
                       int* size,
                       GFile* value);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                gint files_length1);
static void ___lambda85__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time_,
                                                 gpointer self);
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GeeList* main_window_get_documents (MainWindow* self);
Document* document_tab_get_document (DocumentTab* self);
GeeList* main_window_get_unsaved_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
GeeList* main_window_get_views (MainWindow* self);
DocumentView* document_tab_get_document_view (DocumentTab* self);
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
GFile* document_get_location (Document* self);
void main_window_set_active_tab (MainWindow* self,
                                 DocumentTab* value);
static DocumentTab* main_window_create_tab_from_location (MainWindow* self,
                                                   GFile* location,
                                                   gboolean jump_to);
void document_set_readonly (Document* self,
                            gboolean value);
static void ______lambda41_ (Block23Data* _data23_,
                      gint response_id);
TeplView* tepl_tab_get_view (TeplTab* self);
static void _______lambda41__gtk_info_bar_response (GtkInfoBar* _sender,
                                             gint response_id,
                                             gpointer self);
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
static DocumentTab* main_window_process_create_tab (MainWindow* self,
                                             DocumentTab* tab,
                                             gboolean jump_to);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type,
                                                   GFile* location);
void main_window_create_tab_with_view (MainWindow* self,
                                       DocumentView* view);
DocumentTab* document_tab_new_with_view (DocumentView* document_view);
DocumentTab* document_tab_construct_with_view (GType object_type,
                                               DocumentView* document_view);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void __lambda15_ (Block24Data* _data24_);
gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
static void ___lambda15__tepl_tab_close_request (TeplTab* _sender,
                                          gpointer self);
static void __lambda18_ (Block24Data* _data24_);
static void main_window_sync_name (MainWindow* self,
                            DocumentTab* tab);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda34_ (Block24Data* _data24_);
static void ___lambda34__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda35_ (MainWindow* self);
static void ___lambda35__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda36_ (Block24Data* _data24_);
static void ___lambda36__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                                    gpointer self);
static void __lambda37_ (Block24Data* _data24_);
static void ___lambda37__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void _main_window_update_cursor_position_statusbar_tepl_buffer_tepl_cursor_moved (TeplBuffer* _sender,
                                                                                  gpointer self);
void documents_panel_add_tab (DocumentsPanel* self,
                              DocumentTab* tab,
                              gint position,
                              gboolean jump_to);
void main_window_edit_update_sensitivity (MainWindowEdit* self);
void main_window_tools_update_sensitivity (MainWindowTools* self);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
void documents_panel_remove_tab (DocumentsPanel* self,
                                 DocumentTab* tab);
void main_window_documents_update_document_name (MainWindowDocuments* self,
                                                 DocumentTab* tab);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
Document* main_window_get_active_document (MainWindow* self);
void main_window_structure_refresh (MainWindowStructure* self);
void document_set_location (Document* self,
                            GFile* value);
gboolean main_window_close_all_documents (MainWindow* self);
void documents_panel_remove_all_tabs (DocumentsPanel* self);
void dialogs_close_several_unsaved_documents (MainWindow* window,
                                              GeeList* unsaved_docs);
void main_window_remove_all_tabs (MainWindow* self);
DocumentView* main_window_get_active_view (MainWindow* self);
void custom_statusbar_set_cursor_position (CustomStatusbar* self,
                                           gint line,
                                           gint col);
void main_window_save_state (MainWindow* self);
void main_window_structure_save_state (MainWindowStructure* self);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
void utils_flush_queue (void);
TeplTab* tepl_tab_group_get_active_tab (TeplTabGroup* self);
void main_window_file_update_sensitivity (MainWindowFile* self);
gint document_get_project_id (Document* self);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
void document_view_set_font_from_settings (DocumentView* self);
void search_and_replace_show_search (SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
void goto_line_show (GotoLine* self);
GFile* document_get_main_file (Document* self);
void project_dialogs_new_project (MainWindow* main_window);
gboolean project_dialogs_configure_project (GtkWindow* main_window,
                                            gint project_id);
void project_dialogs_manage_projects (MainWindow* main_window);
static void main_window_finalize (GObject * obj);
static void _vala_main_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_main_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW__action_entries[18] = {{"FileQuit", "application-exit", N_ ("_Quit"), "<Control>Q", N_ ("Quit the program")}, {"View", NULL, N_ ("_View")}, {"ViewZoomIn", "zoom-in", N_ ("Zoom _In"), "<Control>plus", N_ ("Enlarge the font"), (GCallback) _main_window_on_view_zoom_in_gtk_action_callback}, {"ViewZoomOut", "zoom-out", N_ ("Zoom _Out"), "<Control>minus", N_ ("Shrink the font"), (GCallback) _main_window_on_view_zoom_out_gtk_action_callback}, {"ViewZoomReset", "zoom-original", N_ ("_Reset Zoom"), "<Control>0", N_ ("Reset the size of the font"), (GCallback) _main_window_on_view_zoom_reset_gtk_action_callback}, {"Search", NULL, N_ ("_Search")}, {"SearchFind", "edit-find", N_ ("_Find"), "<Control>F", N_ ("Search for text"), (GCallback) _main_window_on_search_find_gtk_action_callback}, {"SearchReplace", "edit-find-replace", N_ ("Find and _Replace"), "<Control>H", N_ ("Search for and replace text"), (GCallback) _main_window_on_search_replace_gtk_action_callback}, {"SearchGoToLine", "go-jump", N_ ("_Go to Line…"), "<Control>L", N_ ("Go to a specific line"), (GCallback) _main_window_on_search_goto_line_gtk_action_callback}, {"SearchForward", NULL, N_ ("_Jump to PDF"), "<Control><Alt>F", N_ ("Jump to the associated position in the PDF file. Another shortcut: Ctr" \
"l+click, which works in both directions."), (GCallback) _main_window_on_search_forward_gtk_action_callback}, {"Projects", NULL, N_ ("_Projects")}, {"ProjectsNew", "document-new", N_ ("_New Project"), "", N_ ("Create a new project"), (GCallback) _main_window_on_projects_new_gtk_action_callback}, {"ProjectsConfigCurrent", "document-properties", N_ ("_Configure Current Project"), NULL, N_ ("Change the main file of the current project"), (GCallback) _main_window_on_projects_config_current_gtk_action_callback}, {"ProjectsManage", "preferences-system", N_ ("_Manage Projects"), NULL, N_ ("Manage Projects"), (GCallback) _main_window_on_projects_manage_gtk_action_callback}, {"Help", NULL, N_ ("_Help")}, {"HelpContents", "help-browser", N_ ("_Contents"), "<Release>F1", N_ ("Open the GNOME LaTeX documentation")}, {"HelpLatexReference", NULL, N_ ("_LaTeX Reference"), NULL, N_ ("The Kile LaTeX Reference"), (GCallback) _main_window_on_help_latex_reference_gtk_action_callback}, {"HelpAbout", "help-about", N_ ("_About"), NULL, N_ ("About GNOME LaTeX")}};
static const GtkToggleActionEntry MAIN_WINDOW__toggle_action_entries[4] = {{"ViewMainToolbar", NULL, N_ ("_Main Toolbar"), NULL, N_ ("Show or hide the main toolbar"), (GCallback) NULL}, {"ViewEditToolbar", NULL, N_ ("_Edit Toolbar"), NULL, N_ ("Show or hide the edit toolbar"), (GCallback) NULL}, {"ViewSidePanel", NULL, N_ ("_Side panel"), "<Release>F12", N_ ("Show or hide the side panel"), (GCallback) NULL}, {"ViewBottomPanel", NULL, N_ ("_Bottom panel"), NULL, N_ ("Show or hide the bottom panel"), (GCallback) NULL}};

static inline gpointer
main_window_get_instance_private (MainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindow_private_offset);
}

static void
_main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_view_zoom_in ((MainWindow*) self);
#line 789 "main_window.c"
}

static void
_main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action,
                                                   gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_view_zoom_out ((MainWindow*) self);
#line 798 "main_window.c"
}

static void
_main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_view_zoom_reset ((MainWindow*) self);
#line 807 "main_window.c"
}

static void
_main_window_on_search_find_gtk_action_callback (GtkAction* action,
                                                 gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_search_find ((MainWindow*) self);
#line 816 "main_window.c"
}

static void
_main_window_on_search_replace_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_search_replace ((MainWindow*) self);
#line 825 "main_window.c"
}

static void
_main_window_on_search_goto_line_gtk_action_callback (GtkAction* action,
                                                      gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_search_goto_line ((MainWindow*) self);
#line 834 "main_window.c"
}

static void
_main_window_on_search_forward_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_search_forward ((MainWindow*) self);
#line 843 "main_window.c"
}

static void
_main_window_on_projects_new_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_projects_new ((MainWindow*) self);
#line 852 "main_window.c"
}

static void
_main_window_on_projects_config_current_gtk_action_callback (GtkAction* action,
                                                             gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_projects_config_current ((MainWindow*) self);
#line 861 "main_window.c"
}

static void
_main_window_on_projects_manage_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_projects_manage ((MainWindow*) self);
#line 870 "main_window.c"
}

static void
_main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_help_latex_reference ((MainWindow*) self);
#line 879 "main_window.c"
}

/*************************************************************************/
static gpointer
_g_object_ref0 (gpointer self)
{
#line 155 "main_window.vala"
	return self ? g_object_ref (self) : NULL;
#line 888 "main_window.c"
}

static void
__lambda82_ (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
#line 265 "main_window.vala"
	main_window_update_file_actions_sensitivity (self);
#line 266 "main_window.vala"
	main_window_update_config_project_sensitivity (self);
#line 267 "main_window.vala"
	main_window_update_cursor_position_statusbar (self);
#line 269 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 269 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 269 "main_window.vala"
	if (_tmp1_ == NULL) {
#line 908 "main_window.c"
		GotoLine* _tmp2_;
		SearchAndReplace* _tmp3_;
#line 271 "main_window.vala"
		_tmp2_ = self->priv->_goto_line;
#line 271 "main_window.vala"
		gtk_widget_hide ((GtkWidget*) _tmp2_);
#line 272 "main_window.vala"
		_tmp3_ = self->priv->_search_and_replace;
#line 272 "main_window.vala"
		search_and_replace_hide (_tmp3_);
#line 919 "main_window.c"
	}
#line 275 "main_window.vala"
	g_object_notify ((GObject*) self, "active-tab");
#line 923 "main_window.c"
}

static void
___lambda82__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 263 "main_window.vala"
	__lambda82_ ((MainWindow*) self);
#line 933 "main_window.c"
}

static void
__lambda83_ (MainWindow* self)
{
#line 280 "main_window.vala"
	g_object_notify ((GObject*) self, "active-view");
#line 941 "main_window.c"
}

static void
___lambda83__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 278 "main_window.vala"
	__lambda83_ ((MainWindow*) self);
#line 951 "main_window.c"
}

static void
__lambda84_ (MainWindow* self)
{
#line 285 "main_window.vala"
	g_object_notify ((GObject*) self, "active-document");
#line 959 "main_window.c"
}

static void
___lambda84__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 283 "main_window.vala"
	__lambda84_ ((MainWindow*) self);
#line 969 "main_window.c"
}

static gboolean
__lambda86_ (MainWindow* self)
{
	gboolean result = FALSE;
#line 297 "main_window.vala"
	main_window_quit (self);
#line 300 "main_window.vala"
	result = TRUE;
#line 300 "main_window.vala"
	return result;
#line 982 "main_window.c"
}

static gboolean
___lambda86__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda86_ ((MainWindow*) self);
#line 295 "main_window.vala"
	return result;
#line 994 "main_window.c"
}

MainWindow*
main_window_construct (GType object_type,
                       GlatexApp* app)
{
	MainWindow * self = NULL;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	GtkUIManager* _tmp2_;
	MainWindowFile* _tmp3_;
	GtkUIManager* _tmp4_;
	MainWindowEdit* _tmp5_;
	GtkUIManager* _tmp6_;
	MainWindowBuildTools* _tmp7_;
	GtkUIManager* _tmp8_;
	MainWindowDocuments* _tmp9_;
	GtkUIManager* _tmp10_;
	MainWindowStructure* _tmp11_;
	GtkUIManager* _tmp12_;
	MainWindowTools* _tmp13_;
	GtkGrid* main_vgrid = NULL;
	GtkGrid* _tmp14_;
	GtkWidget* menu = NULL;
	GtkUIManager* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkPaned* menu_paned = NULL;
	GtkPaned* _tmp18_;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp19_;
	GdkRGBA transparent = {0};
	GdkRGBA _tmp20_;
	GtkToolbar* main_toolbar = NULL;
	GtkToolbar* _tmp21_;
	GtkToolbar* edit_toolbar = NULL;
	GtkToolbar* _tmp22_;
	GtkPaned* _tmp23_;
	GtkPaned* _tmp24_;
	GtkPaned* _tmp25_;
	SidePanel* side_panel = NULL;
	SidePanel* _tmp26_;
	GtkPaned* _tmp27_;
	GtkPaned* _tmp28_;
	GtkPaned* _tmp29_;
	GtkPaned* _tmp30_;
	GtkPaned* _tmp31_;
	GtkGrid* docs_vgrid = NULL;
	GtkGrid* _tmp32_;
	DocumentsPanel* _tmp33_;
	GotoLine* _tmp34_;
	GotoLine* _tmp35_;
	SearchAndReplace* _tmp36_;
	SearchAndReplace* _tmp37_;
	GtkWidget* _tmp38_;
	GtkWidget* _tmp39_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp40_;
	MainWindowBuildTools* _tmp41_;
	GtkPaned* _tmp42_;
	GtkPaned* _tmp43_;
	CustomStatusbar* _tmp44_;
	CustomStatusbar* _tmp45_;
	CustomStatusbar* _tmp46_;
	CustomStatusbar* _tmp47_;
	DocumentsPanel* _tmp48_;
#line 150 "main_window.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 152 "main_window.vala"
	self = (MainWindow*) g_object_new (object_type, "application", app, NULL);
#line 155 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 155 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 155 "main_window.vala"
	tepl_window = _tmp1_;
#line 160 "main_window.vala"
	main_window_initialize_ui_manager (self);
#line 162 "main_window.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 162 "main_window.vala"
	_tmp3_ = main_window_file_new (self, _tmp2_);
#line 162 "main_window.vala"
	_main_window_file_unref0 (self->priv->_main_window_file);
#line 162 "main_window.vala"
	self->priv->_main_window_file = _tmp3_;
#line 163 "main_window.vala"
	_tmp4_ = self->priv->_ui_manager;
#line 163 "main_window.vala"
	_tmp5_ = main_window_edit_new (self, _tmp4_);
#line 163 "main_window.vala"
	_main_window_edit_unref0 (self->priv->_main_window_edit);
#line 163 "main_window.vala"
	self->priv->_main_window_edit = _tmp5_;
#line 164 "main_window.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 164 "main_window.vala"
	_tmp7_ = main_window_build_tools_new (self, _tmp6_);
#line 164 "main_window.vala"
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
#line 164 "main_window.vala"
	self->priv->_main_window_build_tools = _tmp7_;
#line 165 "main_window.vala"
	_tmp8_ = self->priv->_ui_manager;
#line 165 "main_window.vala"
	_tmp9_ = main_window_documents_new (self, _tmp8_);
#line 165 "main_window.vala"
	_main_window_documents_unref0 (self->priv->_main_window_documents);
#line 165 "main_window.vala"
	self->priv->_main_window_documents = _tmp9_;
#line 166 "main_window.vala"
	_tmp10_ = self->priv->_ui_manager;
#line 166 "main_window.vala"
	_tmp11_ = main_window_structure_new (_tmp10_);
#line 166 "main_window.vala"
	_main_window_structure_unref0 (self->priv->_main_window_structure);
#line 166 "main_window.vala"
	self->priv->_main_window_structure = _tmp11_;
#line 167 "main_window.vala"
	_tmp12_ = self->priv->_ui_manager;
#line 167 "main_window.vala"
	_tmp13_ = main_window_tools_new (self, _tmp12_);
#line 167 "main_window.vala"
	_main_window_tools_unref0 (self->priv->_main_window_tools);
#line 167 "main_window.vala"
	self->priv->_main_window_tools = _tmp13_;
#line 169 "main_window.vala"
	main_window_show_images_in_menu (self);
#line 170 "main_window.vala"
	main_window_update_file_actions_sensitivity (self);
#line 174 "main_window.vala"
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
#line 174 "main_window.vala"
	g_object_ref_sink (_tmp14_);
#line 174 "main_window.vala"
	main_vgrid = _tmp14_;
#line 175 "main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) main_vgrid, GTK_ORIENTATION_VERTICAL);
#line 176 "main_window.vala"
	gtk_widget_show ((GtkWidget*) main_vgrid);
#line 177 "main_window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vgrid);
#line 181 "main_window.vala"
	_tmp15_ = self->priv->_ui_manager;
#line 181 "main_window.vala"
	_tmp16_ = gtk_ui_manager_get_widget (_tmp15_, "/MainMenu");
#line 181 "main_window.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 181 "main_window.vala"
	menu = _tmp17_;
#line 184 "main_window.vala"
	_tmp18_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
#line 184 "main_window.vala"
	g_object_ref_sink (_tmp18_);
#line 184 "main_window.vala"
	menu_paned = _tmp18_;
#line 185 "main_window.vala"
	_tmp19_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
#line 185 "main_window.vala"
	g_object_ref_sink (_tmp19_);
#line 185 "main_window.vala"
	viewport = _tmp19_;
#line 186 "main_window.vala"
	gtk_viewport_set_shadow_type (viewport, GTK_SHADOW_NONE);
#line 187 "main_window.vala"
	memset (&transparent, 0, sizeof (GdkRGBA));
#line 188 "main_window.vala"
	transparent.alpha = 0.0;
#line 189 "main_window.vala"
	_tmp20_ = transparent;
#line 189 "main_window.vala"
	gtk_widget_override_background_color ((GtkWidget*) viewport, GTK_STATE_FLAG_NORMAL, &_tmp20_);
#line 190 "main_window.vala"
	gtk_container_add ((GtkContainer*) viewport, menu);
#line 191 "main_window.vala"
	gtk_paned_add1 (menu_paned, (GtkWidget*) viewport);
#line 192 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) menu_paned);
#line 193 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) menu_paned);
#line 197 "main_window.vala"
	_tmp21_ = main_window_get_main_toolbar (self);
#line 197 "main_window.vala"
	main_toolbar = _tmp21_;
#line 198 "main_window.vala"
	_tmp22_ = main_window_get_edit_toolbar (self);
#line 198 "main_window.vala"
	edit_toolbar = _tmp22_;
#line 199 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) main_toolbar);
#line 200 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) edit_toolbar);
#line 207 "main_window.vala"
	_tmp23_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
#line 207 "main_window.vala"
	g_object_ref_sink (_tmp23_);
#line 207 "main_window.vala"
	_g_object_unref0 (self->priv->_main_hpaned);
#line 207 "main_window.vala"
	self->priv->_main_hpaned = _tmp23_;
#line 208 "main_window.vala"
	_tmp24_ = self->priv->_main_hpaned;
#line 208 "main_window.vala"
	gtk_widget_show ((GtkWidget*) _tmp24_);
#line 209 "main_window.vala"
	_tmp25_ = self->priv->_main_hpaned;
#line 209 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp25_);
#line 213 "main_window.vala"
	_tmp26_ = main_window_get_side_panel (self);
#line 213 "main_window.vala"
	side_panel = _tmp26_;
#line 214 "main_window.vala"
	_tmp27_ = self->priv->_main_hpaned;
#line 214 "main_window.vala"
	gtk_paned_pack1 (_tmp27_, (GtkWidget*) side_panel, FALSE, FALSE);
#line 221 "main_window.vala"
	_tmp28_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_VERTICAL);
#line 221 "main_window.vala"
	g_object_ref_sink (_tmp28_);
#line 221 "main_window.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 221 "main_window.vala"
	self->priv->_vpaned = _tmp28_;
#line 222 "main_window.vala"
	_tmp29_ = self->priv->_vpaned;
#line 222 "main_window.vala"
	gtk_widget_show ((GtkWidget*) _tmp29_);
#line 223 "main_window.vala"
	_tmp30_ = self->priv->_main_hpaned;
#line 223 "main_window.vala"
	_tmp31_ = self->priv->_vpaned;
#line 223 "main_window.vala"
	gtk_paned_add2 (_tmp30_, (GtkWidget*) _tmp31_);
#line 227 "main_window.vala"
	_tmp32_ = (GtkGrid*) gtk_grid_new ();
#line 227 "main_window.vala"
	g_object_ref_sink (_tmp32_);
#line 227 "main_window.vala"
	docs_vgrid = _tmp32_;
#line 228 "main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) docs_vgrid, GTK_ORIENTATION_VERTICAL);
#line 229 "main_window.vala"
	gtk_grid_set_row_spacing (docs_vgrid, (guint) 2);
#line 230 "main_window.vala"
	gtk_widget_show ((GtkWidget*) docs_vgrid);
#line 233 "main_window.vala"
	main_window_init_documents_panel (self);
#line 234 "main_window.vala"
	_tmp33_ = self->priv->_documents_panel;
#line 234 "main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp33_);
#line 237 "main_window.vala"
	_tmp34_ = goto_line_new (self);
#line 237 "main_window.vala"
	g_object_ref_sink (_tmp34_);
#line 237 "main_window.vala"
	_g_object_unref0 (self->priv->_goto_line);
#line 237 "main_window.vala"
	self->priv->_goto_line = _tmp34_;
#line 238 "main_window.vala"
	_tmp35_ = self->priv->_goto_line;
#line 238 "main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp35_);
#line 241 "main_window.vala"
	_tmp36_ = search_and_replace_new (self);
#line 241 "main_window.vala"
	_g_object_unref0 (self->priv->_search_and_replace);
#line 241 "main_window.vala"
	self->priv->_search_and_replace = _tmp36_;
#line 242 "main_window.vala"
	_tmp37_ = self->priv->_search_and_replace;
#line 242 "main_window.vala"
	_tmp38_ = search_and_replace_get_widget (_tmp37_);
#line 242 "main_window.vala"
	_tmp39_ = _tmp38_;
#line 242 "main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, _tmp39_);
#line 242 "main_window.vala"
	_g_object_unref0 (_tmp39_);
#line 246 "main_window.vala"
	_tmp40_ = main_window_get_bottom_panel (self);
#line 246 "main_window.vala"
	bottom_panel = _tmp40_;
#line 247 "main_window.vala"
	_tmp41_ = self->priv->_main_window_build_tools;
#line 247 "main_window.vala"
	main_window_build_tools_set_bottom_panel (_tmp41_, bottom_panel);
#line 250 "main_window.vala"
	_tmp42_ = self->priv->_vpaned;
#line 250 "main_window.vala"
	gtk_paned_pack1 (_tmp42_, (GtkWidget*) docs_vgrid, TRUE, TRUE);
#line 251 "main_window.vala"
	_tmp43_ = self->priv->_vpaned;
#line 251 "main_window.vala"
	gtk_paned_pack2 (_tmp43_, (GtkWidget*) bottom_panel, FALSE, FALSE);
#line 255 "main_window.vala"
	_tmp44_ = custom_statusbar_new ();
#line 255 "main_window.vala"
	g_object_ref_sink (_tmp44_);
#line 255 "main_window.vala"
	_g_object_unref0 (self->priv->_statusbar);
#line 255 "main_window.vala"
	self->priv->_statusbar = _tmp44_;
#line 256 "main_window.vala"
	_tmp45_ = self->priv->_statusbar;
#line 256 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp45_);
#line 257 "main_window.vala"
	_tmp46_ = self->priv->_statusbar;
#line 257 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp46_);
#line 259 "main_window.vala"
	_tmp47_ = self->priv->_statusbar;
#line 259 "main_window.vala"
	self->priv->_tip_message_cid = gtk_statusbar_get_context_id ((GtkStatusbar*) _tmp47_, "tip_message");
#line 263 "main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-tab", (GCallback) ___lambda82__g_object_notify, self, 0);
#line 278 "main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-view", (GCallback) ___lambda83__g_object_notify, self, 0);
#line 283 "main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-buffer", (GCallback) ___lambda84__g_object_notify, self, 0);
#line 288 "main_window.vala"
	_tmp48_ = self->priv->_documents_panel;
#line 288 "main_window.vala"
	tepl_application_window_set_tab_group (tepl_window, (TeplTabGroup*) _tmp48_);
#line 289 "main_window.vala"
	tepl_application_window_set_handle_title (tepl_window, TRUE);
#line 293 "main_window.vala"
	main_window_support_drag_and_drop (self);
#line 295 "main_window.vala"
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda86__gtk_widget_delete_event, self, 0);
#line 303 "main_window.vala"
	main_window_restore_state (self);
#line 304 "main_window.vala"
	main_window_show_or_hide_widgets (self);
#line 305 "main_window.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 150 "main_window.vala"
	_g_object_unref0 (bottom_panel);
#line 150 "main_window.vala"
	_g_object_unref0 (docs_vgrid);
#line 150 "main_window.vala"
	_g_object_unref0 (side_panel);
#line 150 "main_window.vala"
	_g_object_unref0 (edit_toolbar);
#line 150 "main_window.vala"
	_g_object_unref0 (main_toolbar);
#line 150 "main_window.vala"
	_g_object_unref0 (viewport);
#line 150 "main_window.vala"
	_g_object_unref0 (menu_paned);
#line 150 "main_window.vala"
	_g_object_unref0 (menu);
#line 150 "main_window.vala"
	_g_object_unref0 (main_vgrid);
#line 150 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 150 "main_window.vala"
	return self;
#line 1356 "main_window.c"
}

MainWindow*
main_window_new (GlatexApp* app)
{
#line 150 "main_window.vala"
	return main_window_construct (TYPE_MAIN_WINDOW, app);
#line 1364 "main_window.c"
}

static void
main_window_show_images_in_menu (MainWindow* self)
{
	GtkUIManager* _tmp0_;
	GList* _tmp1_;
#line 310 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 312 "main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 312 "main_window.vala"
	_tmp1_ = gtk_ui_manager_get_action_groups (_tmp0_);
#line 1378 "main_window.c"
	{
		GList* action_group_collection = NULL;
		GList* action_group_it = NULL;
#line 312 "main_window.vala"
		action_group_collection = _tmp1_;
#line 312 "main_window.vala"
		for (action_group_it = action_group_collection; action_group_it != NULL; action_group_it = action_group_it->next) {
#line 1386 "main_window.c"
			GtkActionGroup* _tmp2_;
			GtkActionGroup* action_group = NULL;
#line 312 "main_window.vala"
			_tmp2_ = _g_object_ref0 ((GtkActionGroup*) action_group_it->data);
#line 312 "main_window.vala"
			action_group = _tmp2_;
#line 1393 "main_window.c"
			{
				GtkActionGroup* _tmp3_;
				GList* _tmp4_;
#line 314 "main_window.vala"
				_tmp3_ = action_group;
#line 314 "main_window.vala"
				_tmp4_ = gtk_action_group_list_actions (_tmp3_);
#line 1401 "main_window.c"
				{
					GList* action_collection = NULL;
					GList* action_it = NULL;
#line 314 "main_window.vala"
					action_collection = _tmp4_;
#line 314 "main_window.vala"
					for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
#line 1409 "main_window.c"
						GtkAction* _tmp5_;
						GtkAction* action = NULL;
#line 314 "main_window.vala"
						_tmp5_ = _g_object_ref0 ((GtkAction*) action_it->data);
#line 314 "main_window.vala"
						action = _tmp5_;
#line 1416 "main_window.c"
						{
							GtkAction* _tmp6_;
#line 316 "main_window.vala"
							_tmp6_ = action;
#line 316 "main_window.vala"
							gtk_action_set_always_show_image (_tmp6_, TRUE);
#line 314 "main_window.vala"
							_g_object_unref0 (action);
#line 1425 "main_window.c"
						}
					}
#line 314 "main_window.vala"
					(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
#line 1430 "main_window.c"
				}
#line 312 "main_window.vala"
				_g_object_unref0 (action_group);
#line 1434 "main_window.c"
			}
		}
	}
}

static void
_main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                       gpointer self)
{
#line 361 "main_window.vala"
	main_window_on_menu_item_select ((MainWindow*) self, _sender);
#line 1446 "main_window.c"
}

static void
_main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                           gpointer self)
{
#line 362 "main_window.vala"
	main_window_on_menu_item_deselect ((MainWindow*) self, _sender);
#line 1455 "main_window.c"
}

static void
__lambda65_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
#line 356 "main_window.vala"
	g_return_if_fail (action != NULL);
#line 356 "main_window.vala"
	g_return_if_fail (p != NULL);
#line 358 "main_window.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
#line 1469 "main_window.c"
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		GtkMenuItem* _tmp2_;
#line 360 "main_window.vala"
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
#line 360 "main_window.vala"
		proxy = _tmp0_;
#line 361 "main_window.vala"
		_tmp1_ = proxy;
#line 361 "main_window.vala"
		g_signal_connect_object (_tmp1_, "select", (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self, 0);
#line 362 "main_window.vala"
		_tmp2_ = proxy;
#line 362 "main_window.vala"
		g_signal_connect_object (_tmp2_, "deselect", (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self, 0);
#line 358 "main_window.vala"
		_g_object_unref0 (proxy);
#line 1488 "main_window.c"
	}
}

static void
___lambda65__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                           GtkAction* action,
                                           GtkWidget* proxy,
                                           gpointer self)
{
#line 356 "main_window.vala"
	__lambda65_ ((MainWindow*) self, action, proxy);
#line 1500 "main_window.c"
}

static void
__lambda66_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
#line 366 "main_window.vala"
	g_return_if_fail (action != NULL);
#line 366 "main_window.vala"
	g_return_if_fail (p != NULL);
#line 368 "main_window.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
#line 1514 "main_window.c"
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		guint _tmp2_;
		GtkMenuItem* _tmp3_;
		guint _tmp4_;
#line 370 "main_window.vala"
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
#line 370 "main_window.vala"
		proxy = _tmp0_;
#line 371 "main_window.vala"
		_tmp1_ = proxy;
#line 371 "main_window.vala"
		g_signal_parse_name ("select", gtk_menu_item_get_type (), &_tmp2_, NULL, FALSE);
#line 371 "main_window.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self);
#line 372 "main_window.vala"
		_tmp3_ = proxy;
#line 372 "main_window.vala"
		g_signal_parse_name ("deselect", gtk_menu_item_get_type (), &_tmp4_, NULL, FALSE);
#line 372 "main_window.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self);
#line 368 "main_window.vala"
		_g_object_unref0 (proxy);
#line 1539 "main_window.c"
	}
}

static void
___lambda66__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                              GtkAction* action,
                                              GtkWidget* proxy,
                                              gpointer self)
{
#line 366 "main_window.vala"
	__lambda66_ ((MainWindow*) self, action, proxy);
#line 1551 "main_window.c"
}

static void
main_window_initialize_ui_manager (MainWindow* self)
{
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	LatexMenu* _tmp4_;
	GtkUIManager* _tmp5_;
	GtkUIManager* _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkUIManager* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkUIManager* _tmp13_;
	GtkAccelGroup* _tmp14_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkActionGroup* _tmp17_;
	GtkActionGroup* _tmp18_;
	GtkUIManager* _tmp19_;
	GtkUIManager* _tmp20_;
	GError* _inner_error0_ = NULL;
#line 321 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 323 "main_window.vala"
	_tmp0_ = gtk_action_group_new ("ActionGroup");
#line 323 "main_window.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 323 "main_window.vala"
	self->priv->_action_group = _tmp0_;
#line 324 "main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 324 "main_window.vala"
	gtk_action_group_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
#line 325 "main_window.vala"
	_tmp2_ = self->priv->_action_group;
#line 325 "main_window.vala"
	gtk_action_group_add_actions (_tmp2_, MAIN_WINDOW__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__action_entries), self);
#line 326 "main_window.vala"
	_tmp3_ = self->priv->_action_group;
#line 326 "main_window.vala"
	gtk_action_group_add_toggle_actions (_tmp3_, MAIN_WINDOW__toggle_action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__toggle_action_entries), self);
#line 328 "main_window.vala"
	_tmp4_ = latex_menu_new (self);
#line 328 "main_window.vala"
	_g_object_unref0 (self->priv->_latex_action_group);
#line 328 "main_window.vala"
	self->priv->_latex_action_group = (GtkActionGroup*) _tmp4_;
#line 330 "main_window.vala"
	_tmp5_ = gtk_ui_manager_new ();
#line 330 "main_window.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 330 "main_window.vala"
	self->priv->_ui_manager = _tmp5_;
#line 331 "main_window.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 331 "main_window.vala"
	_tmp7_ = self->priv->_action_group;
#line 331 "main_window.vala"
	gtk_ui_manager_insert_action_group (_tmp6_, _tmp7_, 0);
#line 332 "main_window.vala"
	_tmp8_ = self->priv->_ui_manager;
#line 332 "main_window.vala"
	_tmp9_ = self->priv->_latex_action_group;
#line 332 "main_window.vala"
	gtk_ui_manager_insert_action_group (_tmp8_, _tmp9_, 0);
#line 1621 "main_window.c"
	{
		gchar* path = NULL;
		gchar* _tmp10_;
		GtkUIManager* _tmp11_;
#line 336 "main_window.vala"
		_tmp10_ = g_build_filename (DATA_DIR, "ui", "ui.xml", NULL);
#line 336 "main_window.vala"
		path = _tmp10_;
#line 337 "main_window.vala"
		_tmp11_ = self->priv->_ui_manager;
#line 337 "main_window.vala"
		gtk_ui_manager_add_ui_from_file (_tmp11_, path, &_inner_error0_);
#line 337 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 337 "main_window.vala"
			_g_free0 (path);
#line 1638 "main_window.c"
			goto __catch30_g_error;
		}
#line 334 "main_window.vala"
		_g_free0 (path);
#line 1643 "main_window.c"
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp12_;
#line 334 "main_window.vala"
		err = _inner_error0_;
#line 334 "main_window.vala"
		_inner_error0_ = NULL;
#line 341 "main_window.vala"
		_tmp12_ = err->message;
#line 341 "main_window.vala"
		g_error ("main_window.vala:341: %s", _tmp12_);
#line 334 "main_window.vala"
		_g_error_free0 (err);
#line 1660 "main_window.c"
	}
	__finally30:
#line 334 "main_window.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 334 "main_window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 334 "main_window.vala"
		g_clear_error (&_inner_error0_);
#line 334 "main_window.vala"
		return;
#line 1671 "main_window.c"
	}
#line 344 "main_window.vala"
	_tmp13_ = self->priv->_ui_manager;
#line 344 "main_window.vala"
	_tmp14_ = gtk_ui_manager_get_accel_group (_tmp13_);
#line 344 "main_window.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp14_);
#line 346 "main_window.vala"
	_tmp15_ = glatex_app_get_instance ();
#line 346 "main_window.vala"
	app = _tmp15_;
#line 347 "main_window.vala"
	_tmp16_ = self->priv->_action_group;
#line 347 "main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "quit", _tmp16_, "FileQuit");
#line 349 "main_window.vala"
	_tmp17_ = self->priv->_action_group;
#line 349 "main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "help", _tmp17_, "HelpContents");
#line 351 "main_window.vala"
	_tmp18_ = self->priv->_action_group;
#line 351 "main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "about", _tmp18_, "HelpAbout");
#line 356 "main_window.vala"
	_tmp19_ = self->priv->_ui_manager;
#line 356 "main_window.vala"
	g_signal_connect_object (_tmp19_, "connect-proxy", (GCallback) ___lambda65__gtk_ui_manager_connect_proxy, self, 0);
#line 366 "main_window.vala"
	_tmp20_ = self->priv->_ui_manager;
#line 366 "main_window.vala"
	g_signal_connect_object (_tmp20_, "disconnect-proxy", (GCallback) ___lambda66__gtk_ui_manager_disconnect_proxy, self, 0);
#line 321 "main_window.vala"
	_g_object_unref0 (app);
#line 1705 "main_window.c"
}

static void
main_window_on_menu_item_select (MainWindow* self,
                                 GtkMenuItem* proxy)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
#line 377 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 377 "main_window.vala"
	g_return_if_fail (proxy != NULL);
#line 379 "main_window.vala"
	_tmp0_ = gtk_activatable_get_related_action ((GtkActivatable*) proxy);
#line 379 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 379 "main_window.vala"
	action = _tmp1_;
#line 380 "main_window.vala"
	_tmp2_ = action;
#line 380 "main_window.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 381 "main_window.vala"
	_tmp3_ = action;
#line 381 "main_window.vala"
	_tmp4_ = gtk_action_get_tooltip (_tmp3_);
#line 381 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 381 "main_window.vala"
	if (_tmp5_ != NULL) {
#line 1741 "main_window.c"
		CustomStatusbar* _tmp6_;
		GtkAction* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 382 "main_window.vala"
		_tmp6_ = self->priv->_statusbar;
#line 382 "main_window.vala"
		_tmp7_ = action;
#line 382 "main_window.vala"
		_tmp8_ = gtk_action_get_tooltip (_tmp7_);
#line 382 "main_window.vala"
		_tmp9_ = _tmp8_;
#line 382 "main_window.vala"
		gtk_statusbar_push ((GtkStatusbar*) _tmp6_, self->priv->_tip_message_cid, _tmp9_);
#line 1756 "main_window.c"
	}
#line 377 "main_window.vala"
	_g_object_unref0 (action);
#line 1760 "main_window.c"
}

static void
main_window_on_menu_item_deselect (MainWindow* self,
                                   GtkMenuItem* proxy)
{
	CustomStatusbar* _tmp0_;
#line 385 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 385 "main_window.vala"
	g_return_if_fail (proxy != NULL);
#line 387 "main_window.vala"
	_tmp0_ = self->priv->_statusbar;
#line 387 "main_window.vala"
	gtk_statusbar_pop ((GtkStatusbar*) _tmp0_, self->priv->_tip_message_cid);
#line 1776 "main_window.c"
}

static GtkToolbar*
main_window_get_main_toolbar (MainWindow* self)
{
	GtkToolbar* main_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolItem* open_button = NULL;
	MainWindowFile* _tmp3_;
	GtkToolItem* _tmp4_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	GtkToolbar* result = NULL;
#line 390 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 392 "main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 392 "main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/MainToolbar");
#line 392 "main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
#line 392 "main_window.vala"
	main_toolbar = _tmp2_;
#line 393 "main_window.vala"
	_tmp3_ = self->priv->_main_window_file;
#line 393 "main_window.vala"
	_tmp4_ = main_window_file_get_toolbar_open_button (_tmp3_);
#line 393 "main_window.vala"
	open_button = _tmp4_;
#line 394 "main_window.vala"
	gtk_toolbar_insert (main_toolbar, open_button, 1);
#line 396 "main_window.vala"
	gtk_toolbar_set_style (main_toolbar, GTK_TOOLBAR_ICONS);
#line 397 "main_window.vala"
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) main_toolbar);
#line 397 "main_window.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 397 "main_window.vala"
	context = _tmp6_;
#line 398 "main_window.vala"
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
#line 400 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) main_toolbar);
#line 402 "main_window.vala"
	_tmp7_ = self->priv->_action_group;
#line 402 "main_window.vala"
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "ViewMainToolbar");
#line 402 "main_window.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
#line 402 "main_window.vala"
	action = _tmp9_;
#line 404 "main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 406 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) main_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 409 "main_window.vala"
	result = main_toolbar;
#line 409 "main_window.vala"
	_g_object_unref0 (action);
#line 409 "main_window.vala"
	_g_object_unref0 (context);
#line 409 "main_window.vala"
	_g_object_unref0 (open_button);
#line 409 "main_window.vala"
	return result;
#line 1849 "main_window.c"
}

static GtkToolbar*
main_window_get_edit_toolbar (MainWindow* self)
{
	GtkToolbar* edit_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkToggleAction* _tmp7_;
	GtkToolbar* result = NULL;
#line 412 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 414 "main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 414 "main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/EditToolbar");
#line 414 "main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
#line 414 "main_window.vala"
	edit_toolbar = _tmp2_;
#line 415 "main_window.vala"
	gtk_toolbar_set_style (edit_toolbar, GTK_TOOLBAR_ICONS);
#line 417 "main_window.vala"
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) edit_toolbar);
#line 417 "main_window.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 417 "main_window.vala"
	context = _tmp4_;
#line 418 "main_window.vala"
	gtk_style_context_add_class (context, "gnome-latex-edit-toolbar");
#line 420 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) edit_toolbar);
#line 422 "main_window.vala"
	_tmp5_ = self->priv->_action_group;
#line 422 "main_window.vala"
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "ViewEditToolbar");
#line 422 "main_window.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp6_) : NULL);
#line 422 "main_window.vala"
	action = _tmp7_;
#line 424 "main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 426 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) edit_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 429 "main_window.vala"
	result = edit_toolbar;
#line 429 "main_window.vala"
	_g_object_unref0 (action);
#line 429 "main_window.vala"
	_g_object_unref0 (context);
#line 429 "main_window.vala"
	return result;
#line 1909 "main_window.c"
}

static SidePanel*
main_window_get_side_panel (MainWindow* self)
{
	SidePanel* side_panel = NULL;
	SidePanel* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	SymbolsView* symbols = NULL;
	SymbolsView* _tmp4_;
	FileBrowser* file_browser = NULL;
	FileBrowser* _tmp5_;
	Structure* structure = NULL;
	Structure* _tmp6_;
	MainWindowStructure* _tmp7_;
	SidePanel* result = NULL;
#line 432 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 434 "main_window.vala"
	_tmp0_ = side_panel_new ();
#line 434 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 434 "main_window.vala"
	side_panel = _tmp0_;
#line 435 "main_window.vala"
	gtk_widget_show ((GtkWidget*) side_panel);
#line 438 "main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 438 "main_window.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewSidePanel");
#line 438 "main_window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
#line 438 "main_window.vala"
	action = _tmp3_;
#line 439 "main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 441 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) side_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 445 "main_window.vala"
	_tmp4_ = symbols_view_new (self);
#line 445 "main_window.vala"
	g_object_ref_sink (_tmp4_);
#line 445 "main_window.vala"
	symbols = _tmp4_;
#line 446 "main_window.vala"
	side_panel_add_component (side_panel, _ ("Symbols"), "symbol_greek", (GtkGrid*) symbols);
#line 449 "main_window.vala"
	_tmp5_ = file_browser_new (self);
#line 449 "main_window.vala"
	g_object_ref_sink (_tmp5_);
#line 449 "main_window.vala"
	file_browser = _tmp5_;
#line 450 "main_window.vala"
	side_panel_add_component (side_panel, _ ("File Browser"), "document-open", (GtkGrid*) file_browser);
#line 453 "main_window.vala"
	_tmp6_ = structure_new (self);
#line 453 "main_window.vala"
	g_object_ref_sink (_tmp6_);
#line 453 "main_window.vala"
	structure = _tmp6_;
#line 454 "main_window.vala"
	_tmp7_ = self->priv->_main_window_structure;
#line 454 "main_window.vala"
	main_window_structure_set_structure (_tmp7_, structure);
#line 455 "main_window.vala"
	side_panel_add_component (side_panel, _ ("Structure"), GTK_STOCK_INDEX, (GtkGrid*) structure);
#line 457 "main_window.vala"
	side_panel_restore_state (side_panel);
#line 459 "main_window.vala"
	result = side_panel;
#line 459 "main_window.vala"
	_g_object_unref0 (structure);
#line 459 "main_window.vala"
	_g_object_unref0 (file_browser);
#line 459 "main_window.vala"
	_g_object_unref0 (symbols);
#line 459 "main_window.vala"
	_g_object_unref0 (action);
#line 459 "main_window.vala"
	return result;
#line 1993 "main_window.c"
}

static void
__lambda81_ (MainWindow* self,
             GdkEventButton* event)
{
	GtkMenu* popup_menu = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkMenu* _tmp2_;
#line 469 "main_window.vala"
	g_return_if_fail (event != NULL);
#line 471 "main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 471 "main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/NotebookPopup");
#line 471 "main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_get_type ()) ? ((GtkMenu*) _tmp1_) : NULL);
#line 471 "main_window.vala"
	popup_menu = _tmp2_;
#line 472 "main_window.vala"
	gtk_menu_popup_at_pointer (popup_menu, (GdkEvent*) event);
#line 469 "main_window.vala"
	_g_object_unref0 (popup_menu);
#line 2018 "main_window.c"
}

static void
___lambda81__documents_panel_right_click (DocumentsPanel* _sender,
                                          GdkEventButton* event,
                                          gpointer self)
{
#line 469 "main_window.vala"
	__lambda81_ ((MainWindow*) self, event);
#line 2028 "main_window.c"
}

static void
main_window_init_documents_panel (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	MainWindowDocuments* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
#line 462 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 464 "main_window.vala"
	_tmp0_ = documents_panel_new (self);
#line 464 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 464 "main_window.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 464 "main_window.vala"
	self->priv->_documents_panel = _tmp0_;
#line 465 "main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 465 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
#line 467 "main_window.vala"
	_tmp2_ = self->priv->_main_window_documents;
#line 467 "main_window.vala"
	_tmp3_ = self->priv->_documents_panel;
#line 467 "main_window.vala"
	main_window_documents_set_documents_panel (_tmp2_, _tmp3_);
#line 469 "main_window.vala"
	_tmp4_ = self->priv->_documents_panel;
#line 469 "main_window.vala"
	g_signal_connect_object (_tmp4_, "right-click", (GCallback) ___lambda81__documents_panel_right_click, self, 0);
#line 2063 "main_window.c"
}

static BottomPanel*
main_window_get_bottom_panel (MainWindow* self)
{
	LatexilaBuildView* build_view = NULL;
	LatexilaBuildView* _tmp0_;
	MainWindowBuildTools* _tmp1_;
	GtkToolbar* build_toolbar = NULL;
	GtkUIManager* _tmp2_;
	GtkWidget* _tmp3_;
	GtkToolbar* _tmp4_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp5_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	BottomPanel* result = NULL;
#line 476 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 478 "main_window.vala"
	_tmp0_ = latexila_build_view_new ();
#line 478 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 478 "main_window.vala"
	build_view = _tmp0_;
#line 479 "main_window.vala"
	_tmp1_ = self->priv->_main_window_build_tools;
#line 479 "main_window.vala"
	main_window_build_tools_set_build_view (_tmp1_, build_view);
#line 481 "main_window.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 481 "main_window.vala"
	_tmp3_ = gtk_ui_manager_get_widget (_tmp2_, "/BuildToolbar");
#line 481 "main_window.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp3_) : NULL);
#line 481 "main_window.vala"
	build_toolbar = _tmp4_;
#line 482 "main_window.vala"
	gtk_toolbar_set_style (build_toolbar, GTK_TOOLBAR_ICONS);
#line 483 "main_window.vala"
	gtk_toolbar_set_icon_size (build_toolbar, GTK_ICON_SIZE_MENU);
#line 484 "main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) build_toolbar, GTK_ORIENTATION_VERTICAL);
#line 486 "main_window.vala"
	_tmp5_ = bottom_panel_new (build_view, build_toolbar);
#line 486 "main_window.vala"
	g_object_ref_sink (_tmp5_);
#line 486 "main_window.vala"
	bottom_panel = _tmp5_;
#line 489 "main_window.vala"
	_tmp6_ = self->priv->_action_group;
#line 489 "main_window.vala"
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewBottomPanel");
#line 489 "main_window.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
#line 489 "main_window.vala"
	action = _tmp8_;
#line 491 "main_window.vala"
	gtk_toggle_action_set_active (action, FALSE);
#line 493 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) bottom_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 496 "main_window.vala"
	result = bottom_panel;
#line 496 "main_window.vala"
	_g_object_unref0 (action);
#line 496 "main_window.vala"
	_g_object_unref0 (build_toolbar);
#line 496 "main_window.vala"
	_g_object_unref0 (build_view);
#line 496 "main_window.vala"
	return result;
#line 2137 "main_window.c"
}

static void
main_window_restore_state (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkWindowState state = 0U;
	GSettings* _tmp4_;
	GdkWindowState _tmp5_;
	GdkWindowState _tmp6_;
	GtkPaned* _tmp7_;
	GSettings* _tmp8_;
	GtkPaned* _tmp9_;
	GSettings* _tmp10_;
#line 499 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 501 "main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 501 "main_window.vala"
	settings = _tmp0_;
#line 507 "main_window.vala"
	_tmp1_ = settings;
#line 507 "main_window.vala"
	g_settings_get (_tmp1_, "size", "(ii)", &_tmp2_, &_tmp3_);
#line 507 "main_window.vala"
	width = _tmp2_;
#line 507 "main_window.vala"
	height = _tmp3_;
#line 508 "main_window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, width, height);
#line 510 "main_window.vala"
	_tmp4_ = settings;
#line 510 "main_window.vala"
	state = (GdkWindowState) g_settings_get_int (_tmp4_, "state");
#line 511 "main_window.vala"
	_tmp5_ = state;
#line 511 "main_window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
#line 512 "main_window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 2184 "main_window.c"
	} else {
#line 514 "main_window.vala"
		gtk_window_unmaximize ((GtkWindow*) self);
#line 2188 "main_window.c"
	}
#line 516 "main_window.vala"
	_tmp6_ = state;
#line 516 "main_window.vala"
	if ((_tmp6_ & GDK_WINDOW_STATE_STICKY) == GDK_WINDOW_STATE_STICKY) {
#line 517 "main_window.vala"
		gtk_window_stick ((GtkWindow*) self);
#line 2196 "main_window.c"
	} else {
#line 519 "main_window.vala"
		gtk_window_unstick ((GtkWindow*) self);
#line 2200 "main_window.c"
	}
#line 523 "main_window.vala"
	_tmp7_ = self->priv->_main_hpaned;
#line 523 "main_window.vala"
	_tmp8_ = settings;
#line 523 "main_window.vala"
	gtk_paned_set_position (_tmp7_, g_settings_get_int (_tmp8_, "side-panel-size"));
#line 524 "main_window.vala"
	_tmp9_ = self->priv->_vpaned;
#line 524 "main_window.vala"
	_tmp10_ = settings;
#line 524 "main_window.vala"
	gtk_paned_set_position (_tmp9_, g_settings_get_int (_tmp10_, "vertical-paned-position"));
#line 499 "main_window.vala"
	_g_object_unref0 (settings);
#line 2216 "main_window.c"
}

static void
_vala_array_add5 (GFile** * array,
                  int* length,
                  int* size,
                  GFile* value)
{
#line 540 "main_window.vala"
	if ((*length) == (*size)) {
#line 540 "main_window.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 540 "main_window.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2231 "main_window.c"
	}
#line 540 "main_window.vala"
	(*array)[(*length)++] = value;
#line 540 "main_window.vala"
	(*array)[*length] = NULL;
#line 2237 "main_window.c"
}

static void
__lambda85_ (MainWindow* self,
             GdkDragContext* dc,
             gint x,
             gint y,
             GtkSelectionData* selection_data,
             guint info,
             guint time)
{
	GlatexApp* app = NULL;
	GlatexApp* _tmp0_;
	GFile** files = NULL;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	GlatexApp* _tmp11_;
	GFile** _tmp12_;
	gint _tmp12__length1;
#line 532 "main_window.vala"
	g_return_if_fail (dc != NULL);
#line 532 "main_window.vala"
	g_return_if_fail (selection_data != NULL);
#line 534 "main_window.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 534 "main_window.vala"
	app = _tmp0_;
#line 536 "main_window.vala"
	_tmp1_ = g_new0 (GFile*, 0 + 1);
#line 536 "main_window.vala"
	files = _tmp1_;
#line 536 "main_window.vala"
	files_length1 = 0;
#line 536 "main_window.vala"
	_files_size_ = files_length1;
#line 537 "main_window.vala"
	_tmp3_ = _tmp2_ = gtk_selection_data_get_uris (selection_data);
#line 2278 "main_window.c"
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 537 "main_window.vala"
		uri_collection = _tmp3_;
#line 537 "main_window.vala"
		uri_collection_length1 = _vala_array_length (_tmp2_);
#line 537 "main_window.vala"
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
#line 2290 "main_window.c"
			gchar* _tmp4_;
			gchar* uri = NULL;
#line 537 "main_window.vala"
			_tmp4_ = g_strdup (uri_collection[uri_it]);
#line 537 "main_window.vala"
			uri = _tmp4_;
#line 2297 "main_window.c"
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 539 "main_window.vala"
				_tmp5_ = uri;
#line 539 "main_window.vala"
				_tmp6_ = strlen (_tmp5_);
#line 539 "main_window.vala"
				_tmp7_ = _tmp6_;
#line 539 "main_window.vala"
				if (0 < _tmp7_) {
#line 2310 "main_window.c"
					GFile** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					GFile* _tmp10_;
#line 540 "main_window.vala"
					_tmp8_ = files;
#line 540 "main_window.vala"
					_tmp8__length1 = files_length1;
#line 540 "main_window.vala"
					_tmp9_ = uri;
#line 540 "main_window.vala"
					_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 540 "main_window.vala"
					_vala_array_add5 (&files, &files_length1, &_files_size_, _tmp10_);
#line 2325 "main_window.c"
				}
#line 537 "main_window.vala"
				_g_free0 (uri);
#line 2329 "main_window.c"
			}
		}
#line 537 "main_window.vala"
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2334 "main_window.c"
	}
#line 543 "main_window.vala"
	_tmp11_ = app;
#line 543 "main_window.vala"
	_tmp12_ = files;
#line 543 "main_window.vala"
	_tmp12__length1 = files_length1;
#line 543 "main_window.vala"
	glatex_app_open_documents (_tmp11_, _tmp12_, (gint) _tmp12__length1);
#line 544 "main_window.vala"
	gtk_drag_finish (dc, TRUE, TRUE, (guint32) time);
#line 532 "main_window.vala"
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 532 "main_window.vala"
	_g_object_unref0 (app);
#line 2350 "main_window.c"
}

static void
___lambda85__gtk_widget_drag_data_received (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            gpointer self)
{
#line 532 "main_window.vala"
	__lambda85_ ((MainWindow*) self, context, x, y, selection_data, info, time_);
#line 2365 "main_window.c"
}

static void
main_window_support_drag_and_drop (MainWindow* self)
{
	GtkTargetEntry* _tmp0_;
	GtkTargetEntry* _tmp1_;
	gint _tmp1__length1;
#line 528 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 530 "main_window.vala"
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
#line 530 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 530 "main_window.vala"
	_tmp1__length1 = 0;
#line 530 "main_window.vala"
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp1_, (gint) 0, GDK_ACTION_COPY);
#line 530 "main_window.vala"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 531 "main_window.vala"
	gtk_drag_dest_add_uri_targets ((GtkWidget*) self);
#line 532 "main_window.vala"
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) ___lambda85__gtk_widget_drag_data_received, self, 0);
#line 2390 "main_window.c"
}

static void
main_window_show_or_hide_widgets (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkToggleAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	GtkToggleAction* _tmp12_;
	GtkActionGroup* _tmp13_;
	GtkAction* _tmp14_;
	GtkToggleAction* _tmp15_;
	GtkToggleAction* _tmp16_;
#line 548 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 550 "main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 550 "main_window.vala"
	settings = _tmp0_;
#line 552 "main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 552 "main_window.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewMainToolbar");
#line 552 "main_window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
#line 552 "main_window.vala"
	action = _tmp3_;
#line 554 "main_window.vala"
	_tmp4_ = action;
#line 554 "main_window.vala"
	gtk_toggle_action_set_active (_tmp4_, g_settings_get_boolean (settings, "main-toolbar-visible"));
#line 556 "main_window.vala"
	_tmp5_ = self->priv->_action_group;
#line 556 "main_window.vala"
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "ViewEditToolbar");
#line 556 "main_window.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp6_) : NULL);
#line 556 "main_window.vala"
	_g_object_unref0 (action);
#line 556 "main_window.vala"
	action = _tmp7_;
#line 557 "main_window.vala"
	_tmp8_ = action;
#line 557 "main_window.vala"
	gtk_toggle_action_set_active (_tmp8_, g_settings_get_boolean (settings, "edit-toolbar-visible"));
#line 559 "main_window.vala"
	_tmp9_ = self->priv->_action_group;
#line 559 "main_window.vala"
	_tmp10_ = gtk_action_group_get_action (_tmp9_, "ViewSidePanel");
#line 559 "main_window.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp10_) : NULL);
#line 559 "main_window.vala"
	_g_object_unref0 (action);
#line 559 "main_window.vala"
	action = _tmp11_;
#line 560 "main_window.vala"
	_tmp12_ = action;
#line 560 "main_window.vala"
	gtk_toggle_action_set_active (_tmp12_, g_settings_get_boolean (settings, "side-panel-visible"));
#line 562 "main_window.vala"
	_tmp13_ = self->priv->_action_group;
#line 562 "main_window.vala"
	_tmp14_ = gtk_action_group_get_action (_tmp13_, "ViewBottomPanel");
#line 562 "main_window.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp14_) : NULL);
#line 562 "main_window.vala"
	_g_object_unref0 (action);
#line 562 "main_window.vala"
	action = _tmp15_;
#line 563 "main_window.vala"
	_tmp16_ = action;
#line 563 "main_window.vala"
	gtk_toggle_action_set_active (_tmp16_, g_settings_get_boolean (settings, "bottom-panel-visible"));
#line 548 "main_window.vala"
	_g_object_unref0 (action);
#line 548 "main_window.vala"
	_g_object_unref0 (settings);
#line 2479 "main_window.c"
}

/*************************************************************************/
static gpointer
_main_window_structure_ref0 (gpointer self)
{
#line 571 "main_window.vala"
	return self ? main_window_structure_ref (self) : NULL;
#line 2488 "main_window.c"
}

MainWindowStructure*
main_window_get_main_window_structure (MainWindow* self)
{
	MainWindowStructure* _tmp0_;
	MainWindowStructure* _tmp1_;
	MainWindowStructure* result = NULL;
#line 569 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 571 "main_window.vala"
	_tmp0_ = self->priv->_main_window_structure;
#line 571 "main_window.vala"
	_tmp1_ = _main_window_structure_ref0 (_tmp0_);
#line 571 "main_window.vala"
	result = _tmp1_;
#line 571 "main_window.vala"
	return result;
#line 2507 "main_window.c"
}

/*************************************************************************/
GeeList*
main_window_get_documents (MainWindow* self)
{
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp1_;
	GeeList* result = NULL;
#line 577 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 579 "main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 579 "main_window.vala"
	all_documents = (GeeList*) _tmp0_;
#line 580 "main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 580 "main_window.vala"
	nb_documents = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp1_);
#line 2529 "main_window.c"
	{
		gint i = 0;
#line 581 "main_window.vala"
		i = 0;
#line 2534 "main_window.c"
		{
			gboolean _tmp2_ = FALSE;
#line 581 "main_window.vala"
			_tmp2_ = TRUE;
#line 581 "main_window.vala"
			while (TRUE) {
#line 2541 "main_window.c"
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp4_;
				GtkWidget* _tmp5_;
				DocumentTab* _tmp6_;
				GeeList* _tmp7_;
				DocumentTab* _tmp8_;
				Document* _tmp9_;
				Document* _tmp10_;
#line 581 "main_window.vala"
				if (!_tmp2_) {
#line 2552 "main_window.c"
					gint _tmp3_;
#line 581 "main_window.vala"
					_tmp3_ = i;
#line 581 "main_window.vala"
					i = _tmp3_ + 1;
#line 2558 "main_window.c"
				}
#line 581 "main_window.vala"
				_tmp2_ = FALSE;
#line 581 "main_window.vala"
				if (!(i < nb_documents)) {
#line 581 "main_window.vala"
					break;
#line 2566 "main_window.c"
				}
#line 583 "main_window.vala"
				_tmp4_ = self->priv->_documents_panel;
#line 583 "main_window.vala"
				_tmp5_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp4_, i);
#line 583 "main_window.vala"
				_tmp6_ = _g_object_ref0 (IS_DOCUMENT_TAB (_tmp5_) ? ((DocumentTab*) _tmp5_) : NULL);
#line 583 "main_window.vala"
				tab = _tmp6_;
#line 584 "main_window.vala"
				_tmp7_ = all_documents;
#line 584 "main_window.vala"
				_tmp8_ = tab;
#line 584 "main_window.vala"
				_tmp9_ = document_tab_get_document (_tmp8_);
#line 584 "main_window.vala"
				_tmp10_ = _tmp9_;
#line 584 "main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp7_, _tmp10_);
#line 581 "main_window.vala"
				_g_object_unref0 (tab);
#line 2588 "main_window.c"
			}
		}
	}
#line 587 "main_window.vala"
	result = all_documents;
#line 587 "main_window.vala"
	return result;
#line 2596 "main_window.c"
}

GeeList*
main_window_get_unsaved_documents (MainWindow* self)
{
	GeeList* unsaved_documents = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* result = NULL;
#line 590 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 592 "main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 592 "main_window.vala"
	unsaved_documents = (GeeList*) _tmp0_;
#line 2611 "main_window.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
#line 593 "main_window.vala"
		_tmp1_ = main_window_get_documents (self);
#line 593 "main_window.vala"
		_doc_list = _tmp1_;
#line 593 "main_window.vala"
		_tmp2_ = _doc_list;
#line 593 "main_window.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 593 "main_window.vala"
		_tmp4_ = _tmp3_;
#line 593 "main_window.vala"
		_doc_size = _tmp4_;
#line 593 "main_window.vala"
		_doc_index = -1;
#line 593 "main_window.vala"
		while (TRUE) {
#line 2636 "main_window.c"
			Document* doc = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Document* _tmp7_;
#line 593 "main_window.vala"
			_doc_index = _doc_index + 1;
#line 593 "main_window.vala"
			if (!(_doc_index < _doc_size)) {
#line 593 "main_window.vala"
				break;
#line 2647 "main_window.c"
			}
#line 593 "main_window.vala"
			_tmp5_ = _doc_list;
#line 593 "main_window.vala"
			_tmp6_ = gee_list_get (_tmp5_, _doc_index);
#line 593 "main_window.vala"
			doc = (Document*) _tmp6_;
#line 595 "main_window.vala"
			_tmp7_ = doc;
#line 595 "main_window.vala"
			if (gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp7_)) {
#line 2659 "main_window.c"
				GeeList* _tmp8_;
				Document* _tmp9_;
#line 596 "main_window.vala"
				_tmp8_ = unsaved_documents;
#line 596 "main_window.vala"
				_tmp9_ = doc;
#line 596 "main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp8_, _tmp9_);
#line 2668 "main_window.c"
			}
#line 593 "main_window.vala"
			_g_object_unref0 (doc);
#line 2672 "main_window.c"
		}
#line 593 "main_window.vala"
		_g_object_unref0 (_doc_list);
#line 2676 "main_window.c"
	}
#line 599 "main_window.vala"
	result = unsaved_documents;
#line 599 "main_window.vala"
	return result;
#line 2682 "main_window.c"
}

GeeList*
main_window_get_views (MainWindow* self)
{
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	DocumentsPanel* _tmp1_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp2_;
	GeeList* result = NULL;
#line 602 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 604 "main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 604 "main_window.vala"
	all_views = (GeeList*) _tmp0_;
#line 606 "main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 606 "main_window.vala"
	if (_tmp1_ == NULL) {
#line 607 "main_window.vala"
		result = all_views;
#line 607 "main_window.vala"
		return result;
#line 2708 "main_window.c"
	}
#line 609 "main_window.vala"
	_tmp2_ = self->priv->_documents_panel;
#line 609 "main_window.vala"
	nb_documents = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp2_);
#line 2714 "main_window.c"
	{
		gint i = 0;
#line 611 "main_window.vala"
		i = 0;
#line 2719 "main_window.c"
		{
			gboolean _tmp3_ = FALSE;
#line 611 "main_window.vala"
			_tmp3_ = TRUE;
#line 611 "main_window.vala"
			while (TRUE) {
#line 2726 "main_window.c"
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp5_;
				GtkWidget* _tmp6_;
				DocumentTab* _tmp7_;
				GeeList* _tmp8_;
				DocumentTab* _tmp9_;
				DocumentView* _tmp10_;
				DocumentView* _tmp11_;
#line 611 "main_window.vala"
				if (!_tmp3_) {
#line 2737 "main_window.c"
					gint _tmp4_;
#line 611 "main_window.vala"
					_tmp4_ = i;
#line 611 "main_window.vala"
					i = _tmp4_ + 1;
#line 2743 "main_window.c"
				}
#line 611 "main_window.vala"
				_tmp3_ = FALSE;
#line 611 "main_window.vala"
				if (!(i < nb_documents)) {
#line 611 "main_window.vala"
					break;
#line 2751 "main_window.c"
				}
#line 613 "main_window.vala"
				_tmp5_ = self->priv->_documents_panel;
#line 613 "main_window.vala"
				_tmp6_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp5_, i);
#line 613 "main_window.vala"
				_tmp7_ = _g_object_ref0 (IS_DOCUMENT_TAB (_tmp6_) ? ((DocumentTab*) _tmp6_) : NULL);
#line 613 "main_window.vala"
				tab = _tmp7_;
#line 614 "main_window.vala"
				_tmp8_ = all_views;
#line 614 "main_window.vala"
				_tmp9_ = tab;
#line 614 "main_window.vala"
				_tmp10_ = document_tab_get_document_view (_tmp9_);
#line 614 "main_window.vala"
				_tmp11_ = _tmp10_;
#line 614 "main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp8_, _tmp11_);
#line 611 "main_window.vala"
				_g_object_unref0 (tab);
#line 2773 "main_window.c"
			}
		}
	}
#line 617 "main_window.vala"
	result = all_views;
#line 617 "main_window.vala"
	return result;
#line 2781 "main_window.c"
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
#line 630 "main_window.vala"
	g_atomic_int_inc (&_data23_->_ref_count_);
#line 630 "main_window.vala"
	return _data23_;
#line 2791 "main_window.c"
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
#line 630 "main_window.vala"
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
#line 2801 "main_window.c"
		MainWindow* self;
#line 630 "main_window.vala"
		self = _data23_->self;
#line 630 "main_window.vala"
		_g_object_unref0 (_data23_->infobar);
#line 630 "main_window.vala"
		_g_object_unref0 (_data23_->tab);
#line 630 "main_window.vala"
		_g_object_unref0 (self);
#line 630 "main_window.vala"
		g_slice_free (Block23Data, _data23_);
#line 2813 "main_window.c"
	}
}

static void
______lambda41_ (Block23Data* _data23_,
                 gint response_id)
{
	MainWindow* self;
	GtkInfoBar* _tmp3_;
	DocumentTab* _tmp4_;
	TeplView* _tmp5_;
	TeplView* _tmp6_;
#line 659 "main_window.vala"
	self = _data23_->self;
#line 661 "main_window.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 2830 "main_window.c"
		DocumentTab* _tmp0_;
		Document* _tmp1_;
		Document* _tmp2_;
#line 662 "main_window.vala"
		_tmp0_ = _data23_->tab;
#line 662 "main_window.vala"
		_tmp1_ = document_tab_get_document (_tmp0_);
#line 662 "main_window.vala"
		_tmp2_ = _tmp1_;
#line 662 "main_window.vala"
		document_set_readonly (_tmp2_, FALSE);
#line 2842 "main_window.c"
	}
#line 663 "main_window.vala"
	_tmp3_ = _data23_->infobar;
#line 663 "main_window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 664 "main_window.vala"
	_tmp4_ = _data23_->tab;
#line 664 "main_window.vala"
	_tmp5_ = tepl_tab_get_view ((TeplTab*) _tmp4_);
#line 664 "main_window.vala"
	_tmp6_ = _tmp5_;
#line 664 "main_window.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
#line 2856 "main_window.c"
}

static void
_______lambda41__gtk_info_bar_response (GtkInfoBar* _sender,
                                        gint response_id,
                                        gpointer self)
{
#line 659 "main_window.vala"
	______lambda41_ (self, response_id);
#line 2866 "main_window.c"
}

DocumentTab*
main_window_open_document (MainWindow* self,
                           GFile* location,
                           gboolean jump_to)
{
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	DocumentTab* _tmp48_;
	DocumentTab* result = NULL;
#line 620 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 620 "main_window.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 623 "main_window.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 623 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 623 "main_window.vala"
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
#line 623 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 623 "main_window.vala"
	_g_object_unref0 (_tmp1_);
#line 2894 "main_window.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 623 "main_window.vala"
		window_collection = _tmp3_;
#line 623 "main_window.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 2902 "main_window.c"
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
#line 623 "main_window.vala"
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 623 "main_window.vala"
			window = _tmp4_;
#line 2909 "main_window.c"
			{
				GtkWindow* _tmp5_;
				MainWindow* w = NULL;
				GtkWindow* _tmp6_;
				MainWindow* _tmp7_;
#line 625 "main_window.vala"
				_tmp5_ = window;
#line 625 "main_window.vala"
				if (!IS_MAIN_WINDOW (_tmp5_)) {
#line 626 "main_window.vala"
					_g_object_unref0 (window);
#line 626 "main_window.vala"
					continue;
#line 2923 "main_window.c"
				}
#line 628 "main_window.vala"
				_tmp6_ = window;
#line 628 "main_window.vala"
				_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
#line 628 "main_window.vala"
				w = _tmp7_;
#line 2931 "main_window.c"
				{
					GeeList* _doc_list = NULL;
					MainWindow* _tmp8_;
					GeeList* _tmp9_;
					gint _doc_size = 0;
					GeeList* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint _doc_index = 0;
#line 630 "main_window.vala"
					_tmp8_ = w;
#line 630 "main_window.vala"
					_tmp9_ = main_window_get_documents (_tmp8_);
#line 630 "main_window.vala"
					_doc_list = _tmp9_;
#line 630 "main_window.vala"
					_tmp10_ = _doc_list;
#line 630 "main_window.vala"
					_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
#line 630 "main_window.vala"
					_tmp12_ = _tmp11_;
#line 630 "main_window.vala"
					_doc_size = _tmp12_;
#line 630 "main_window.vala"
					_doc_index = -1;
#line 630 "main_window.vala"
					while (TRUE) {
#line 2959 "main_window.c"
						Block23Data* _data23_;
						Document* doc = NULL;
						GeeList* _tmp13_;
						gpointer _tmp14_;
						gboolean _tmp15_ = FALSE;
						Document* _tmp16_;
						GFile* _tmp17_;
						GFile* _tmp18_;
						MainWindow* _tmp22_;
						DocumentTab* _tmp28_;
						DocumentTab* _tmp29_;
						Document* _tmp30_;
						Document* _tmp31_;
						gchar* primary_msg = NULL;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* secondary_msg = NULL;
						gchar* _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						TeplInfoBar* _tmp39_;
						GtkInfoBar* _tmp40_;
						GtkInfoBar* _tmp41_;
						DocumentTab* _tmp42_;
						GtkInfoBar* _tmp43_;
						GtkInfoBar* _tmp44_;
						GtkInfoBar* _tmp45_;
						DocumentTab* _tmp46_;
						DocumentTab* _tmp47_;
#line 630 "main_window.vala"
						_data23_ = g_slice_new0 (Block23Data);
#line 630 "main_window.vala"
						_data23_->_ref_count_ = 1;
#line 630 "main_window.vala"
						_data23_->self = g_object_ref (self);
#line 630 "main_window.vala"
						_doc_index = _doc_index + 1;
#line 630 "main_window.vala"
						if (!(_doc_index < _doc_size)) {
#line 630 "main_window.vala"
							block23_data_unref (_data23_);
#line 630 "main_window.vala"
							_data23_ = NULL;
#line 630 "main_window.vala"
							break;
#line 3007 "main_window.c"
						}
#line 630 "main_window.vala"
						_tmp13_ = _doc_list;
#line 630 "main_window.vala"
						_tmp14_ = gee_list_get (_tmp13_, _doc_index);
#line 630 "main_window.vala"
						doc = (Document*) _tmp14_;
#line 632 "main_window.vala"
						_tmp16_ = doc;
#line 632 "main_window.vala"
						_tmp17_ = document_get_location (_tmp16_);
#line 632 "main_window.vala"
						_tmp18_ = _tmp17_;
#line 632 "main_window.vala"
						if (_tmp18_ == NULL) {
#line 632 "main_window.vala"
							_tmp15_ = TRUE;
#line 3025 "main_window.c"
						} else {
							Document* _tmp19_;
							GFile* _tmp20_;
							GFile* _tmp21_;
#line 632 "main_window.vala"
							_tmp19_ = doc;
#line 632 "main_window.vala"
							_tmp20_ = document_get_location (_tmp19_);
#line 632 "main_window.vala"
							_tmp21_ = _tmp20_;
#line 632 "main_window.vala"
							_tmp15_ = !g_file_equal (location, _tmp21_);
#line 3038 "main_window.c"
						}
#line 632 "main_window.vala"
						if (_tmp15_) {
#line 633 "main_window.vala"
							_g_object_unref0 (doc);
#line 633 "main_window.vala"
							block23_data_unref (_data23_);
#line 633 "main_window.vala"
							_data23_ = NULL;
#line 633 "main_window.vala"
							continue;
#line 3050 "main_window.c"
						}
#line 636 "main_window.vala"
						_tmp22_ = w;
#line 636 "main_window.vala"
						if (self == _tmp22_) {
#line 3056 "main_window.c"
							Document* _tmp25_;
							DocumentTab* _tmp26_;
							DocumentTab* _tmp27_;
#line 638 "main_window.vala"
							if (jump_to) {
#line 3062 "main_window.c"
								Document* _tmp23_;
								DocumentTab* _tmp24_;
#line 639 "main_window.vala"
								_tmp23_ = doc;
#line 639 "main_window.vala"
								_tmp24_ = _tmp23_->tab;
#line 639 "main_window.vala"
								main_window_set_active_tab (self, _tmp24_);
#line 3071 "main_window.c"
							}
#line 640 "main_window.vala"
							_tmp25_ = doc;
#line 640 "main_window.vala"
							_tmp26_ = _tmp25_->tab;
#line 640 "main_window.vala"
							_tmp27_ = _g_object_ref0 (_tmp26_);
#line 640 "main_window.vala"
							result = _tmp27_;
#line 640 "main_window.vala"
							_g_object_unref0 (doc);
#line 640 "main_window.vala"
							block23_data_unref (_data23_);
#line 640 "main_window.vala"
							_data23_ = NULL;
#line 640 "main_window.vala"
							_g_object_unref0 (_doc_list);
#line 640 "main_window.vala"
							_g_object_unref0 (w);
#line 640 "main_window.vala"
							_g_object_unref0 (window);
#line 640 "main_window.vala"
							return result;
#line 3095 "main_window.c"
						}
#line 644 "main_window.vala"
						_tmp28_ = main_window_create_tab_from_location (self, location, jump_to);
#line 644 "main_window.vala"
						_data23_->tab = _tmp28_;
#line 645 "main_window.vala"
						_tmp29_ = _data23_->tab;
#line 645 "main_window.vala"
						_tmp30_ = document_tab_get_document (_tmp29_);
#line 645 "main_window.vala"
						_tmp31_ = _tmp30_;
#line 645 "main_window.vala"
						document_set_readonly (_tmp31_, TRUE);
#line 647 "main_window.vala"
						_tmp32_ = g_file_get_parse_name (location);
#line 647 "main_window.vala"
						_tmp33_ = _tmp32_;
#line 647 "main_window.vala"
						_tmp34_ = g_strdup_printf (_ ("This file (%s) is already opened in another GNOME LaTeX window."), _tmp33_);
#line 647 "main_window.vala"
						_tmp35_ = _tmp34_;
#line 647 "main_window.vala"
						_g_free0 (_tmp33_);
#line 647 "main_window.vala"
						primary_msg = _tmp35_;
#line 650 "main_window.vala"
						_tmp36_ = g_strdup (_ ("GNOME LaTeX opened this instance of the file in a non-editable way. Do" \
" you want to edit it anyway?"));
#line 650 "main_window.vala"
						secondary_msg = _tmp36_;
#line 652 "main_window.vala"
						_tmp37_ = primary_msg;
#line 652 "main_window.vala"
						_tmp38_ = secondary_msg;
#line 652 "main_window.vala"
						_tmp39_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp37_, _tmp38_);
#line 652 "main_window.vala"
						g_object_ref_sink (_tmp39_);
#line 652 "main_window.vala"
						_data23_->infobar = (GtkInfoBar*) _tmp39_;
#line 654 "main_window.vala"
						_tmp40_ = _data23_->infobar;
#line 654 "main_window.vala"
						gtk_info_bar_add_button (_tmp40_, _ ("Edit Anyway"), (gint) GTK_RESPONSE_YES);
#line 655 "main_window.vala"
						_tmp41_ = _data23_->infobar;
#line 655 "main_window.vala"
						gtk_info_bar_add_button (_tmp41_, _ ("Don’t Edit"), (gint) GTK_RESPONSE_NO);
#line 656 "main_window.vala"
						_tmp42_ = _data23_->tab;
#line 656 "main_window.vala"
						_tmp43_ = _data23_->infobar;
#line 656 "main_window.vala"
						tepl_tab_add_info_bar ((TeplTab*) _tmp42_, _tmp43_);
#line 657 "main_window.vala"
						_tmp44_ = _data23_->infobar;
#line 657 "main_window.vala"
						gtk_widget_show ((GtkWidget*) _tmp44_);
#line 659 "main_window.vala"
						_tmp45_ = _data23_->infobar;
#line 659 "main_window.vala"
						g_signal_connect_data (_tmp45_, "response", (GCallback) _______lambda41__gtk_info_bar_response, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 667 "main_window.vala"
						_tmp46_ = _data23_->tab;
#line 667 "main_window.vala"
						_tmp47_ = _g_object_ref0 (_tmp46_);
#line 667 "main_window.vala"
						result = _tmp47_;
#line 667 "main_window.vala"
						_g_free0 (secondary_msg);
#line 667 "main_window.vala"
						_g_free0 (primary_msg);
#line 667 "main_window.vala"
						_g_object_unref0 (doc);
#line 667 "main_window.vala"
						block23_data_unref (_data23_);
#line 667 "main_window.vala"
						_data23_ = NULL;
#line 667 "main_window.vala"
						_g_object_unref0 (_doc_list);
#line 667 "main_window.vala"
						_g_object_unref0 (w);
#line 667 "main_window.vala"
						_g_object_unref0 (window);
#line 667 "main_window.vala"
						return result;
#line 3181 "main_window.c"
					}
#line 630 "main_window.vala"
					_g_object_unref0 (_doc_list);
#line 3185 "main_window.c"
				}
#line 623 "main_window.vala"
				_g_object_unref0 (w);
#line 623 "main_window.vala"
				_g_object_unref0 (window);
#line 3191 "main_window.c"
			}
		}
	}
#line 671 "main_window.vala"
	_tmp48_ = main_window_create_tab_from_location (self, location, jump_to);
#line 671 "main_window.vala"
	result = _tmp48_;
#line 671 "main_window.vala"
	return result;
#line 3201 "main_window.c"
}

DocumentTab*
main_window_create_tab (MainWindow* self,
                        gboolean jump_to)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* result = NULL;
#line 674 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 676 "main_window.vala"
	_tmp0_ = document_tab_new ();
#line 676 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 676 "main_window.vala"
	tab = _tmp0_;
#line 677 "main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
#line 677 "main_window.vala"
	result = _tmp1_;
#line 677 "main_window.vala"
	_g_object_unref0 (tab);
#line 677 "main_window.vala"
	return result;
#line 3228 "main_window.c"
}

static DocumentTab*
main_window_create_tab_from_location (MainWindow* self,
                                      GFile* location,
                                      gboolean jump_to)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* result = NULL;
#line 680 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 680 "main_window.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 682 "main_window.vala"
	_tmp0_ = document_tab_new_from_location (location);
#line 682 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 682 "main_window.vala"
	tab = _tmp0_;
#line 683 "main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
#line 683 "main_window.vala"
	result = _tmp1_;
#line 683 "main_window.vala"
	_g_object_unref0 (tab);
#line 683 "main_window.vala"
	return result;
#line 3258 "main_window.c"
}

void
main_window_create_tab_with_view (MainWindow* self,
                                  DocumentView* view)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
#line 686 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 686 "main_window.vala"
	g_return_if_fail (view != NULL);
#line 688 "main_window.vala"
	_tmp0_ = document_tab_new_with_view (view);
#line 688 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 688 "main_window.vala"
	tab = _tmp0_;
#line 689 "main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, TRUE);
#line 689 "main_window.vala"
	_tmp2_ = _tmp1_;
#line 689 "main_window.vala"
	_g_object_unref0 (_tmp2_);
#line 686 "main_window.vala"
	_g_object_unref0 (tab);
#line 3287 "main_window.c"
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
#line 692 "main_window.vala"
	g_atomic_int_inc (&_data24_->_ref_count_);
#line 692 "main_window.vala"
	return _data24_;
#line 3297 "main_window.c"
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
#line 692 "main_window.vala"
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
#line 3307 "main_window.c"
		MainWindow* self;
#line 692 "main_window.vala"
		self = _data24_->self;
#line 692 "main_window.vala"
		_g_object_unref0 (_data24_->tab);
#line 692 "main_window.vala"
		_g_object_unref0 (self);
#line 692 "main_window.vala"
		g_slice_free (Block24Data, _data24_);
#line 3317 "main_window.c"
	}
}

static void
__lambda15_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 697 "main_window.vala"
	self = _data24_->self;
#line 698 "main_window.vala"
	main_window_close_tab (self, _data24_->tab, FALSE);
#line 699 "main_window.vala"
	g_signal_stop_emission_by_name (_data24_->tab, "close-request");
#line 3331 "main_window.c"
}

static void
___lambda15__tepl_tab_close_request (TeplTab* _sender,
                                     gpointer self)
{
#line 697 "main_window.vala"
	__lambda15_ (self);
#line 3340 "main_window.c"
}

static void
__lambda18_ (Block24Data* _data24_)
{
	MainWindow* self;
	MainWindowBuildTools* _tmp0_;
#line 704 "main_window.vala"
	self = _data24_->self;
#line 706 "main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 707 "main_window.vala"
	_tmp0_ = self->priv->_main_window_build_tools;
#line 707 "main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp0_);
#line 3356 "main_window.c"
}

static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 704 "main_window.vala"
	__lambda18_ (self);
#line 3366 "main_window.c"
}

static void
__lambda34_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 710 "main_window.vala"
	self = _data24_->self;
#line 712 "main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 3377 "main_window.c"
}

static void
___lambda34__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 710 "main_window.vala"
	__lambda34_ (self);
#line 3387 "main_window.c"
}

static void
__lambda35_ (MainWindow* self)
{
	MainWindowBuildTools* _tmp0_;
#line 717 "main_window.vala"
	_tmp0_ = self->priv->_main_window_build_tools;
#line 717 "main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp0_);
#line 3398 "main_window.c"
}

static void
___lambda35__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 715 "main_window.vala"
	__lambda35_ ((MainWindow*) self);
#line 3408 "main_window.c"
}

static void
__lambda36_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 720 "main_window.vala"
	self = _data24_->self;
#line 720 "main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 3419 "main_window.c"
}

static void
___lambda36__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                               gpointer self)
{
#line 720 "main_window.vala"
	__lambda36_ (self);
#line 3428 "main_window.c"
}

static void
__lambda37_ (Block24Data* _data24_)
{
	MainWindow* self;
#line 721 "main_window.vala"
	self = _data24_->self;
#line 721 "main_window.vala"
	main_window_sync_name (self, _data24_->tab);
#line 3439 "main_window.c"
}

static void
___lambda37__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 721 "main_window.vala"
	__lambda37_ (self);
#line 3449 "main_window.c"
}

static void
_main_window_update_cursor_position_statusbar_tepl_buffer_tepl_cursor_moved (TeplBuffer* _sender,
                                                                             gpointer self)
{
#line 722 "main_window.vala"
	main_window_update_cursor_position_statusbar ((MainWindow*) self);
#line 3458 "main_window.c"
}

static DocumentTab*
main_window_process_create_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean jump_to)
{
	Block24Data* _data24_;
	DocumentTab* _tmp0_;
	Document* doc = NULL;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	DocumentsPanel* _tmp10_;
	MainWindowEdit* _tmp11_;
	MainWindowTools* _tmp12_;
	DocumentTab* _tmp13_;
	DocumentTab* result = NULL;
#line 692 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 692 "main_window.vala"
	_data24_ = g_slice_new0 (Block24Data);
#line 692 "main_window.vala"
	_data24_->_ref_count_ = 1;
#line 692 "main_window.vala"
	_data24_->self = g_object_ref (self);
#line 692 "main_window.vala"
	_tmp0_ = _g_object_ref0 (tab);
#line 692 "main_window.vala"
	_g_object_unref0 (_data24_->tab);
#line 692 "main_window.vala"
	_data24_->tab = _tmp0_;
#line 694 "main_window.vala"
	if (_data24_->tab == NULL) {
#line 695 "main_window.vala"
		result = NULL;
#line 695 "main_window.vala"
		block24_data_unref (_data24_);
#line 695 "main_window.vala"
		_data24_ = NULL;
#line 695 "main_window.vala"
		return result;
#line 3507 "main_window.c"
	}
#line 697 "main_window.vala"
	g_signal_connect_data ((TeplTab*) _data24_->tab, "close-request", (GCallback) ___lambda15__tepl_tab_close_request, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 702 "main_window.vala"
	_tmp1_ = document_tab_get_document (_data24_->tab);
#line 702 "main_window.vala"
	_tmp2_ = _tmp1_;
#line 702 "main_window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 702 "main_window.vala"
	doc = _tmp3_;
#line 704 "main_window.vala"
	_tmp4_ = doc;
#line 704 "main_window.vala"
	g_signal_connect_data ((GObject*) _tmp4_, "notify::location", (GCallback) ___lambda18__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 710 "main_window.vala"
	_tmp5_ = doc;
#line 710 "main_window.vala"
	g_signal_connect_data ((GObject*) _tmp5_, "notify::tepl-short-title", (GCallback) ___lambda34__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 715 "main_window.vala"
	_tmp6_ = doc;
#line 715 "main_window.vala"
	g_signal_connect_object ((GObject*) _tmp6_, "notify::project-id", (GCallback) ___lambda35__g_object_notify, self, 0);
#line 720 "main_window.vala"
	_tmp7_ = doc;
#line 720 "main_window.vala"
	g_signal_connect_data ((GtkTextBuffer*) _tmp7_, "modified-changed", (GCallback) ___lambda36__gtk_text_buffer_modified_changed, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 721 "main_window.vala"
	_tmp8_ = doc;
#line 721 "main_window.vala"
	g_signal_connect_data ((GObject*) _tmp8_, "notify::readonly", (GCallback) ___lambda37__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 722 "main_window.vala"
	_tmp9_ = doc;
#line 722 "main_window.vala"
	g_signal_connect_object ((TeplBuffer*) _tmp9_, "tepl-cursor-moved", (GCallback) _main_window_update_cursor_position_statusbar_tepl_buffer_tepl_cursor_moved, self, 0);
#line 724 "main_window.vala"
	gtk_widget_show ((GtkWidget*) _data24_->tab);
#line 727 "main_window.vala"
	_tmp10_ = self->priv->_documents_panel;
#line 727 "main_window.vala"
	documents_panel_add_tab (_tmp10_, _data24_->tab, -1, jump_to);
#line 729 "main_window.vala"
	_tmp11_ = self->priv->_main_window_edit;
#line 729 "main_window.vala"
	main_window_edit_update_sensitivity (_tmp11_);
#line 730 "main_window.vala"
	_tmp12_ = self->priv->_main_window_tools;
#line 730 "main_window.vala"
	main_window_tools_update_sensitivity (_tmp12_);
#line 732 "main_window.vala"
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
#line 733 "main_window.vala"
		gtk_window_present ((GtkWindow*) self);
#line 3561 "main_window.c"
	}
#line 735 "main_window.vala"
	_tmp13_ = _g_object_ref0 (_data24_->tab);
#line 735 "main_window.vala"
	result = _tmp13_;
#line 735 "main_window.vala"
	_g_object_unref0 (doc);
#line 735 "main_window.vala"
	block24_data_unref (_data24_);
#line 735 "main_window.vala"
	_data24_ = NULL;
#line 735 "main_window.vala"
	return result;
#line 3575 "main_window.c"
}

gboolean
main_window_close_tab (MainWindow* self,
                       DocumentTab* tab,
                       gboolean force_close)
{
	gboolean _tmp0_ = FALSE;
	DocumentsPanel* _tmp18_;
	gboolean result = FALSE;
#line 739 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 739 "main_window.vala"
	g_return_val_if_fail (tab != NULL, FALSE);
#line 744 "main_window.vala"
	if (!force_close) {
#line 3592 "main_window.c"
		TeplBuffer* _tmp1_;
#line 744 "main_window.vala"
		_tmp1_ = tepl_tab_get_buffer ((TeplTab*) tab);
#line 744 "main_window.vala"
		_tmp0_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
#line 3598 "main_window.c"
	} else {
#line 744 "main_window.vala"
		_tmp0_ = FALSE;
#line 3602 "main_window.c"
	}
#line 744 "main_window.vala"
	if (_tmp0_) {
#line 3606 "main_window.c"
		GtkDialog* dialog = NULL;
		TeplBuffer* _tmp2_;
		TeplFile* _tmp3_;
		const gchar* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkDialog* _tmp6_;
		Document* _tmp7_;
		Document* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GtkDialog* _tmp17_;
#line 746 "main_window.vala"
		_tmp2_ = tepl_tab_get_buffer ((TeplTab*) tab);
#line 746 "main_window.vala"
		_tmp3_ = tepl_buffer_get_file (_tmp2_);
#line 746 "main_window.vala"
		_tmp4_ = tepl_file_get_short_name (_tmp3_);
#line 746 "main_window.vala"
		_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Save changes to document “%s” before closing?"), _tmp4_);
#line 746 "main_window.vala"
		g_object_ref_sink (_tmp5_);
#line 746 "main_window.vala"
		dialog = (GtkDialog*) _tmp5_;
#line 753 "main_window.vala"
		_tmp6_ = dialog;
#line 753 "main_window.vala"
		gtk_dialog_add_buttons (_tmp6_, _ ("Close _without Saving"), GTK_RESPONSE_CLOSE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
#line 756 "main_window.vala"
		_tmp7_ = document_tab_get_document (tab);
#line 756 "main_window.vala"
		_tmp8_ = _tmp7_;
#line 756 "main_window.vala"
		_tmp9_ = document_get_location (_tmp8_);
#line 756 "main_window.vala"
		_tmp10_ = _tmp9_;
#line 756 "main_window.vala"
		if (_tmp10_ == NULL) {
#line 3644 "main_window.c"
			GtkDialog* _tmp11_;
#line 757 "main_window.vala"
			_tmp11_ = dialog;
#line 757 "main_window.vala"
			gtk_dialog_add_button (_tmp11_, _ ("Save _As"), (gint) GTK_RESPONSE_ACCEPT);
#line 3650 "main_window.c"
		} else {
			GtkDialog* _tmp12_;
#line 759 "main_window.vala"
			_tmp12_ = dialog;
#line 759 "main_window.vala"
			gtk_dialog_add_button (_tmp12_, _ ("_Save"), (gint) GTK_RESPONSE_ACCEPT);
#line 3657 "main_window.c"
		}
#line 761 "main_window.vala"
		while (TRUE) {
#line 3661 "main_window.c"
			gint res = 0;
			GtkDialog* _tmp13_;
#line 763 "main_window.vala"
			_tmp13_ = dialog;
#line 763 "main_window.vala"
			res = gtk_dialog_run (_tmp13_);
#line 765 "main_window.vala"
			if (res == ((gint) GTK_RESPONSE_CLOSE)) {
#line 766 "main_window.vala"
				break;
#line 3672 "main_window.c"
			} else {
#line 769 "main_window.vala"
				if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 3676 "main_window.c"
					Document* _tmp14_;
					Document* _tmp15_;
#line 771 "main_window.vala"
					_tmp14_ = document_tab_get_document (tab);
#line 771 "main_window.vala"
					_tmp15_ = _tmp14_;
#line 771 "main_window.vala"
					if (main_window_save_document (self, _tmp15_, FALSE)) {
#line 772 "main_window.vala"
						break;
#line 3687 "main_window.c"
					}
#line 773 "main_window.vala"
					continue;
#line 3691 "main_window.c"
				} else {
					GtkDialog* _tmp16_;
#line 779 "main_window.vala"
					_tmp16_ = dialog;
#line 779 "main_window.vala"
					gtk_widget_destroy ((GtkWidget*) _tmp16_);
#line 780 "main_window.vala"
					result = FALSE;
#line 780 "main_window.vala"
					_g_object_unref0 (dialog);
#line 780 "main_window.vala"
					return result;
#line 3704 "main_window.c"
				}
			}
		}
#line 784 "main_window.vala"
		_tmp17_ = dialog;
#line 784 "main_window.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp17_);
#line 744 "main_window.vala"
		_g_object_unref0 (dialog);
#line 3714 "main_window.c"
	}
#line 787 "main_window.vala"
	_tmp18_ = self->priv->_documents_panel;
#line 787 "main_window.vala"
	documents_panel_remove_tab (_tmp18_, tab);
#line 788 "main_window.vala"
	result = TRUE;
#line 788 "main_window.vala"
	return result;
#line 3724 "main_window.c"
}

static void
main_window_sync_name (MainWindow* self,
                       DocumentTab* tab)
{
	MainWindowDocuments* _tmp0_;
#line 791 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 791 "main_window.vala"
	g_return_if_fail (tab != NULL);
#line 793 "main_window.vala"
	_tmp0_ = self->priv->_main_window_documents;
#line 793 "main_window.vala"
	main_window_documents_update_document_name (_tmp0_, tab);
#line 3740 "main_window.c"
}

gboolean
main_window_save_document (MainWindow* self,
                           Document* doc,
                           gboolean force_save_as)
{
	gboolean _tmp0_ = FALSE;
	GtkFileChooserDialog* file_chooser = NULL;
	GtkFileChooserDialog* _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	GtkFileChooserDialog* _tmp8_;
	gchar* short_name = NULL;
	TeplFile* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	const gchar* _tmp20_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	gint response = 0;
	GtkFileChooserDialog* _tmp29_;
	GtkFileChooserDialog* _tmp33_;
	gchar* _tmp34_;
	GtkFileChooserDialog* _tmp35_;
	GFile* _tmp36_;
	GFile* _tmp37_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 797 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 797 "main_window.vala"
	g_return_val_if_fail (doc != NULL, FALSE);
#line 799 "main_window.vala"
	if (!force_save_as) {
#line 3777 "main_window.c"
		GFile* _tmp1_;
		GFile* _tmp2_;
#line 799 "main_window.vala"
		_tmp1_ = document_get_location (doc);
#line 799 "main_window.vala"
		_tmp2_ = _tmp1_;
#line 799 "main_window.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 3786 "main_window.c"
	} else {
#line 799 "main_window.vala"
		_tmp0_ = FALSE;
#line 3790 "main_window.c"
	}
#line 799 "main_window.vala"
	if (_tmp0_) {
#line 3794 "main_window.c"
		Document* _tmp3_;
		Document* _tmp4_;
#line 801 "main_window.vala"
		document_save (doc, TRUE, FALSE);
#line 803 "main_window.vala"
		_tmp3_ = main_window_get_active_document (self);
#line 803 "main_window.vala"
		_tmp4_ = _tmp3_;
#line 803 "main_window.vala"
		if (doc == _tmp4_) {
#line 3805 "main_window.c"
			MainWindowStructure* _tmp5_;
#line 804 "main_window.vala"
			_tmp5_ = self->priv->_main_window_structure;
#line 804 "main_window.vala"
			main_window_structure_refresh (_tmp5_);
#line 3811 "main_window.c"
		}
#line 806 "main_window.vala"
		result = TRUE;
#line 806 "main_window.vala"
		return result;
#line 3817 "main_window.c"
	}
#line 809 "main_window.vala"
	_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save"), GTK_RESPONSE_ACCEPT, NULL);
#line 809 "main_window.vala"
	g_object_ref_sink (_tmp6_);
#line 809 "main_window.vala"
	file_chooser = _tmp6_;
#line 815 "main_window.vala"
	_tmp7_ = file_chooser;
#line 815 "main_window.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp7_, TRUE);
#line 816 "main_window.vala"
	_tmp8_ = file_chooser;
#line 816 "main_window.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp8_, FALSE);
#line 818 "main_window.vala"
	_tmp9_ = tepl_buffer_get_file ((TeplBuffer*) doc);
#line 818 "main_window.vala"
	_tmp10_ = tepl_file_get_short_name (_tmp9_);
#line 818 "main_window.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 818 "main_window.vala"
	short_name = _tmp11_;
#line 819 "main_window.vala"
	_tmp12_ = document_get_location (doc);
#line 819 "main_window.vala"
	_tmp13_ = _tmp12_;
#line 819 "main_window.vala"
	if (_tmp13_ == NULL) {
#line 3847 "main_window.c"
		GtkFileChooserDialog* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 820 "main_window.vala"
		_tmp14_ = file_chooser;
#line 820 "main_window.vala"
		_tmp15_ = short_name;
#line 820 "main_window.vala"
		_tmp16_ = g_strconcat (_tmp15_, ".tex", NULL);
#line 820 "main_window.vala"
		_tmp17_ = _tmp16_;
#line 820 "main_window.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp14_, _tmp17_);
#line 820 "main_window.vala"
		_g_free0 (_tmp17_);
#line 3864 "main_window.c"
	} else {
		GtkFileChooserDialog* _tmp18_;
		const gchar* _tmp19_;
#line 822 "main_window.vala"
		_tmp18_ = file_chooser;
#line 822 "main_window.vala"
		_tmp19_ = short_name;
#line 822 "main_window.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp18_, _tmp19_);
#line 3874 "main_window.c"
	}
#line 824 "main_window.vala"
	_tmp20_ = self->default_location;
#line 824 "main_window.vala"
	if (_tmp20_ != NULL) {
#line 3880 "main_window.c"
		GtkFileChooserDialog* _tmp21_;
		const gchar* _tmp22_;
#line 825 "main_window.vala"
		_tmp21_ = file_chooser;
#line 825 "main_window.vala"
		_tmp22_ = self->default_location;
#line 825 "main_window.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp21_, _tmp22_);
#line 3889 "main_window.c"
	}
#line 827 "main_window.vala"
	_tmp23_ = document_get_location (doc);
#line 827 "main_window.vala"
	_tmp24_ = _tmp23_;
#line 827 "main_window.vala"
	if (_tmp24_ != NULL) {
#line 3897 "main_window.c"
		{
			GtkFileChooserDialog* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
#line 832 "main_window.vala"
			_tmp25_ = file_chooser;
#line 832 "main_window.vala"
			_tmp26_ = document_get_location (doc);
#line 832 "main_window.vala"
			_tmp27_ = _tmp26_;
#line 832 "main_window.vala"
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp25_, _tmp27_, &_inner_error0_);
#line 832 "main_window.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3912 "main_window.c"
				goto __catch31_g_error;
			}
		}
		goto __finally31;
		__catch31_g_error:
		{
			GError* e = NULL;
#line 829 "main_window.vala"
			e = _inner_error0_;
#line 829 "main_window.vala"
			_inner_error0_ = NULL;
#line 829 "main_window.vala"
			_g_error_free0 (e);
#line 3926 "main_window.c"
		}
		__finally31:
#line 829 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3931 "main_window.c"
			gboolean _tmp28_ = FALSE;
#line 829 "main_window.vala"
			_g_free0 (short_name);
#line 829 "main_window.vala"
			_g_object_unref0 (file_chooser);
#line 829 "main_window.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 829 "main_window.vala"
			g_clear_error (&_inner_error0_);
#line 829 "main_window.vala"
			return _tmp28_;
#line 3943 "main_window.c"
		}
	}
#line 837 "main_window.vala"
	_tmp29_ = file_chooser;
#line 837 "main_window.vala"
	response = gtk_dialog_run ((GtkDialog*) _tmp29_);
#line 838 "main_window.vala"
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 3952 "main_window.c"
		GtkFileChooserDialog* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
#line 839 "main_window.vala"
		_tmp30_ = file_chooser;
#line 839 "main_window.vala"
		_tmp31_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp30_);
#line 839 "main_window.vala"
		_tmp32_ = _tmp31_;
#line 839 "main_window.vala"
		document_set_location (doc, _tmp32_);
#line 839 "main_window.vala"
		_g_object_unref0 (_tmp32_);
#line 3966 "main_window.c"
	}
#line 841 "main_window.vala"
	_tmp33_ = file_chooser;
#line 841 "main_window.vala"
	_tmp34_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp33_);
#line 841 "main_window.vala"
	_g_free0 (self->default_location);
#line 841 "main_window.vala"
	self->default_location = _tmp34_;
#line 842 "main_window.vala"
	_tmp35_ = file_chooser;
#line 842 "main_window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp35_);
#line 844 "main_window.vala"
	_tmp36_ = document_get_location (doc);
#line 844 "main_window.vala"
	_tmp37_ = _tmp36_;
#line 844 "main_window.vala"
	if (_tmp37_ != NULL) {
#line 3986 "main_window.c"
		Document* _tmp38_;
		Document* _tmp39_;
#line 847 "main_window.vala"
		document_save (doc, FALSE, TRUE);
#line 849 "main_window.vala"
		_tmp38_ = main_window_get_active_document (self);
#line 849 "main_window.vala"
		_tmp39_ = _tmp38_;
#line 849 "main_window.vala"
		if (doc == _tmp39_) {
#line 3997 "main_window.c"
			MainWindowStructure* _tmp40_;
#line 850 "main_window.vala"
			_tmp40_ = self->priv->_main_window_structure;
#line 850 "main_window.vala"
			main_window_structure_refresh (_tmp40_);
#line 4003 "main_window.c"
		}
#line 852 "main_window.vala"
		result = TRUE;
#line 852 "main_window.vala"
		_g_free0 (short_name);
#line 852 "main_window.vala"
		_g_object_unref0 (file_chooser);
#line 852 "main_window.vala"
		return result;
#line 4013 "main_window.c"
	}
#line 854 "main_window.vala"
	result = FALSE;
#line 854 "main_window.vala"
	_g_free0 (short_name);
#line 854 "main_window.vala"
	_g_object_unref0 (file_chooser);
#line 854 "main_window.vala"
	return result;
#line 4023 "main_window.c"
}

gboolean
main_window_close_all_documents (MainWindow* self)
{
	GeeList* unsaved_documents = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result = FALSE;
#line 858 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 860 "main_window.vala"
	_tmp0_ = main_window_get_unsaved_documents (self);
#line 860 "main_window.vala"
	unsaved_documents = _tmp0_;
#line 863 "main_window.vala"
	_tmp1_ = unsaved_documents;
#line 863 "main_window.vala"
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 863 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 863 "main_window.vala"
	if (_tmp3_ == 0) {
#line 4049 "main_window.c"
		DocumentsPanel* _tmp4_;
#line 865 "main_window.vala"
		_tmp4_ = self->priv->_documents_panel;
#line 865 "main_window.vala"
		documents_panel_remove_all_tabs (_tmp4_);
#line 866 "main_window.vala"
		result = TRUE;
#line 866 "main_window.vala"
		_g_object_unref0 (unsaved_documents);
#line 866 "main_window.vala"
		return result;
#line 4061 "main_window.c"
	} else {
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 870 "main_window.vala"
		_tmp5_ = unsaved_documents;
#line 870 "main_window.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 870 "main_window.vala"
		_tmp7_ = _tmp6_;
#line 870 "main_window.vala"
		if (_tmp7_ == 1) {
#line 4074 "main_window.c"
			Document* doc = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			Document* _tmp10_;
			DocumentTab* _tmp11_;
			Document* _tmp12_;
			DocumentTab* _tmp13_;
#line 872 "main_window.vala"
			_tmp8_ = unsaved_documents;
#line 872 "main_window.vala"
			_tmp9_ = gee_list_first (_tmp8_);
#line 872 "main_window.vala"
			doc = (Document*) _tmp9_;
#line 873 "main_window.vala"
			_tmp10_ = doc;
#line 873 "main_window.vala"
			_tmp11_ = _tmp10_->tab;
#line 873 "main_window.vala"
			main_window_set_active_tab (self, _tmp11_);
#line 874 "main_window.vala"
			_tmp12_ = doc;
#line 874 "main_window.vala"
			_tmp13_ = _tmp12_->tab;
#line 874 "main_window.vala"
			if (main_window_close_tab (self, _tmp13_, FALSE)) {
#line 4100 "main_window.c"
				DocumentsPanel* _tmp14_;
#line 876 "main_window.vala"
				_tmp14_ = self->priv->_documents_panel;
#line 876 "main_window.vala"
				documents_panel_remove_all_tabs (_tmp14_);
#line 877 "main_window.vala"
				result = TRUE;
#line 877 "main_window.vala"
				_g_object_unref0 (doc);
#line 877 "main_window.vala"
				_g_object_unref0 (unsaved_documents);
#line 877 "main_window.vala"
				return result;
#line 4114 "main_window.c"
			}
#line 870 "main_window.vala"
			_g_object_unref0 (doc);
#line 4118 "main_window.c"
		} else {
			GeeList* _tmp15_;
			DocumentsPanel* _tmp16_;
#line 884 "main_window.vala"
			_tmp15_ = unsaved_documents;
#line 884 "main_window.vala"
			dialogs_close_several_unsaved_documents (self, _tmp15_);
#line 885 "main_window.vala"
			_tmp16_ = self->priv->_documents_panel;
#line 885 "main_window.vala"
			if (gtk_notebook_get_n_pages ((GtkNotebook*) _tmp16_) == 0) {
#line 886 "main_window.vala"
				result = TRUE;
#line 886 "main_window.vala"
				_g_object_unref0 (unsaved_documents);
#line 886 "main_window.vala"
				return result;
#line 4136 "main_window.c"
			}
		}
	}
#line 889 "main_window.vala"
	result = FALSE;
#line 889 "main_window.vala"
	_g_object_unref0 (unsaved_documents);
#line 889 "main_window.vala"
	return result;
#line 4146 "main_window.c"
}

void
main_window_remove_all_tabs (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
#line 892 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 894 "main_window.vala"
	_tmp0_ = self->priv->_documents_panel;
#line 894 "main_window.vala"
	documents_panel_remove_all_tabs (_tmp0_);
#line 4159 "main_window.c"
}

static void
main_window_update_cursor_position_statusbar (MainWindow* self)
{
	DocumentView* _tmp0_;
	DocumentView* _tmp1_;
	GtkTextIter iter = {0};
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gint row = 0;
	gint col = 0;
	DocumentView* _tmp9_;
	DocumentView* _tmp10_;
	GtkTextIter _tmp11_;
	CustomStatusbar* _tmp12_;
#line 897 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 899 "main_window.vala"
	_tmp0_ = main_window_get_active_view (self);
#line 899 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 899 "main_window.vala"
	if (_tmp1_ == NULL) {
#line 4188 "main_window.c"
		CustomStatusbar* _tmp2_;
#line 901 "main_window.vala"
		_tmp2_ = self->priv->_statusbar;
#line 901 "main_window.vala"
		custom_statusbar_set_cursor_position (_tmp2_, -1, -1);
#line 902 "main_window.vala"
		return;
#line 4196 "main_window.c"
	}
#line 906 "main_window.vala"
	_tmp3_ = main_window_get_active_document (self);
#line 906 "main_window.vala"
	_tmp4_ = _tmp3_;
#line 906 "main_window.vala"
	_tmp5_ = main_window_get_active_document (self);
#line 906 "main_window.vala"
	_tmp6_ = _tmp5_;
#line 906 "main_window.vala"
	_tmp7_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp6_);
#line 906 "main_window.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp4_, &_tmp8_, _tmp7_);
#line 906 "main_window.vala"
	iter = _tmp8_;
#line 907 "main_window.vala"
	row = (gint) gtk_text_iter_get_line (&iter);
#line 908 "main_window.vala"
	_tmp9_ = main_window_get_active_view (self);
#line 908 "main_window.vala"
	_tmp10_ = _tmp9_;
#line 908 "main_window.vala"
	_tmp11_ = iter;
#line 908 "main_window.vala"
	col = (gint) gtk_source_view_get_visual_column ((GtkSourceView*) _tmp10_, &_tmp11_);
#line 909 "main_window.vala"
	_tmp12_ = self->priv->_statusbar;
#line 909 "main_window.vala"
	custom_statusbar_set_cursor_position (_tmp12_, row + 1, col + 1);
#line 4226 "main_window.c"
}

void
main_window_save_state (MainWindow* self)
{
	GSettings* settings_window = NULL;
	GSettings* _tmp0_;
	GdkWindowState state = 0U;
	GdkWindow* _tmp1_;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkPaned* _tmp4_;
	GtkPaned* _tmp5_;
	MainWindowStructure* _tmp6_;
	GSettings* settings_ui = NULL;
	GSettings* _tmp7_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp8_;
	GtkAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkActionGroup* _tmp14_;
	GtkAction* _tmp15_;
	GtkToggleAction* _tmp16_;
	GtkToggleAction* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GtkActionGroup* _tmp20_;
	GtkAction* _tmp21_;
	GtkToggleAction* _tmp22_;
	GtkToggleAction* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GtkActionGroup* _tmp26_;
	GtkAction* _tmp27_;
	GtkToggleAction* _tmp28_;
	GtkToggleAction* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	MainWindowBuildTools* _tmp32_;
#line 912 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 915 "main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 915 "main_window.vala"
	settings_window = _tmp0_;
#line 917 "main_window.vala"
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
#line 917 "main_window.vala"
	state = gdk_window_get_state (_tmp1_);
#line 918 "main_window.vala"
	g_settings_set_int (settings_window, "state", (gint) state);
#line 923 "main_window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
#line 923 "main_window.vala"
	width = _tmp2_;
#line 923 "main_window.vala"
	height = _tmp3_;
#line 924 "main_window.vala"
	g_settings_set (settings_window, "size", "(ii)", width, height);
#line 926 "main_window.vala"
	_tmp4_ = self->priv->_main_hpaned;
#line 926 "main_window.vala"
	g_settings_set_int (settings_window, "side-panel-size", gtk_paned_get_position (_tmp4_));
#line 927 "main_window.vala"
	_tmp5_ = self->priv->_vpaned;
#line 927 "main_window.vala"
	g_settings_set_int (settings_window, "vertical-paned-position", gtk_paned_get_position (_tmp5_));
#line 929 "main_window.vala"
	_tmp6_ = self->priv->_main_window_structure;
#line 929 "main_window.vala"
	main_window_structure_save_state (_tmp6_);
#line 932 "main_window.vala"
	_tmp7_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 932 "main_window.vala"
	settings_ui = _tmp7_;
#line 938 "main_window.vala"
	_tmp8_ = self->priv->_action_group;
#line 938 "main_window.vala"
	_tmp9_ = gtk_action_group_get_action (_tmp8_, "ViewMainToolbar");
#line 938 "main_window.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 938 "main_window.vala"
	action = _tmp10_;
#line 939 "main_window.vala"
	_tmp11_ = action;
#line 939 "main_window.vala"
	_tmp12_ = gtk_toggle_action_get_active (_tmp11_);
#line 939 "main_window.vala"
	_tmp13_ = _tmp12_;
#line 939 "main_window.vala"
	g_settings_set_boolean (settings_ui, "main-toolbar-visible", _tmp13_);
#line 941 "main_window.vala"
	_tmp14_ = self->priv->_action_group;
#line 941 "main_window.vala"
	_tmp15_ = gtk_action_group_get_action (_tmp14_, "ViewEditToolbar");
#line 941 "main_window.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 941 "main_window.vala"
	_g_object_unref0 (action);
#line 941 "main_window.vala"
	action = _tmp16_;
#line 942 "main_window.vala"
	_tmp17_ = action;
#line 942 "main_window.vala"
	_tmp18_ = gtk_toggle_action_get_active (_tmp17_);
#line 942 "main_window.vala"
	_tmp19_ = _tmp18_;
#line 942 "main_window.vala"
	g_settings_set_boolean (settings_ui, "edit-toolbar-visible", _tmp19_);
#line 944 "main_window.vala"
	_tmp20_ = self->priv->_action_group;
#line 944 "main_window.vala"
	_tmp21_ = gtk_action_group_get_action (_tmp20_, "ViewSidePanel");
#line 944 "main_window.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 944 "main_window.vala"
	_g_object_unref0 (action);
#line 944 "main_window.vala"
	action = _tmp22_;
#line 945 "main_window.vala"
	_tmp23_ = action;
#line 945 "main_window.vala"
	_tmp24_ = gtk_toggle_action_get_active (_tmp23_);
#line 945 "main_window.vala"
	_tmp25_ = _tmp24_;
#line 945 "main_window.vala"
	g_settings_set_boolean (settings_ui, "side-panel-visible", _tmp25_);
#line 947 "main_window.vala"
	_tmp26_ = self->priv->_action_group;
#line 947 "main_window.vala"
	_tmp27_ = gtk_action_group_get_action (_tmp26_, "ViewBottomPanel");
#line 947 "main_window.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 947 "main_window.vala"
	_g_object_unref0 (action);
#line 947 "main_window.vala"
	action = _tmp28_;
#line 948 "main_window.vala"
	_tmp29_ = action;
#line 948 "main_window.vala"
	_tmp30_ = gtk_toggle_action_get_active (_tmp29_);
#line 948 "main_window.vala"
	_tmp31_ = _tmp30_;
#line 948 "main_window.vala"
	g_settings_set_boolean (settings_ui, "bottom-panel-visible", _tmp31_);
#line 950 "main_window.vala"
	_tmp32_ = self->priv->_main_window_build_tools;
#line 950 "main_window.vala"
	main_window_build_tools_save_state (_tmp32_);
#line 912 "main_window.vala"
	_g_object_unref0 (action);
#line 912 "main_window.vala"
	_g_object_unref0 (settings_ui);
#line 912 "main_window.vala"
	_g_object_unref0 (settings_window);
#line 4387 "main_window.c"
}

void
main_window_jump_to_file_position (MainWindow* self,
                                   GFile* file,
                                   gint start_line,
                                   gint end_line)
{
	gboolean _tmp0_ = FALSE;
	DocumentTab* tab = NULL;
	DocumentTab* _tmp1_;
	TeplView* _tmp2_;
	TeplView* _tmp3_;
#line 955 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 955 "main_window.vala"
	g_return_if_fail (file != NULL);
#line 957 "main_window.vala"
	if (start_line >= 0) {
#line 957 "main_window.vala"
		_tmp0_ = end_line >= 0;
#line 4409 "main_window.c"
	} else {
#line 957 "main_window.vala"
		_tmp0_ = FALSE;
#line 4413 "main_window.c"
	}
#line 957 "main_window.vala"
	g_return_if_fail (_tmp0_);
#line 959 "main_window.vala"
	_tmp1_ = main_window_open_document (self, file, TRUE);
#line 959 "main_window.vala"
	tab = _tmp1_;
#line 962 "main_window.vala"
	utils_flush_queue ();
#line 964 "main_window.vala"
	_tmp2_ = tepl_tab_get_view ((TeplTab*) tab);
#line 964 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 964 "main_window.vala"
	tepl_view_select_lines (_tmp3_, start_line, end_line);
#line 955 "main_window.vala"
	_g_object_unref0 (tab);
#line 4431 "main_window.c"
}

/*************************************************************************/
static void
main_window_update_file_actions_sensitivity (MainWindow* self)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	gboolean sensitive = FALSE;
	TeplApplicationWindow* _tmp2_;
	TeplTab* _tmp3_;
	TeplTab* _tmp4_;
	gchar** file_actions = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint file_actions_length1;
	gint _file_actions_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GtkActionGroup* _tmp21_;
	MainWindowFile* _tmp22_;
	MainWindowEdit* _tmp23_;
	MainWindowBuildTools* _tmp24_;
	MainWindowTools* _tmp25_;
#line 970 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 972 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 972 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 972 "main_window.vala"
	tepl_window = _tmp1_;
#line 974 "main_window.vala"
	_tmp2_ = tepl_window;
#line 974 "main_window.vala"
	_tmp3_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) _tmp2_);
#line 974 "main_window.vala"
	_tmp4_ = _tmp3_;
#line 974 "main_window.vala"
	sensitive = _tmp4_ != NULL;
#line 977 "main_window.vala"
	_tmp5_ = g_strdup ("ViewZoomIn");
#line 977 "main_window.vala"
	_tmp6_ = g_strdup ("ViewZoomOut");
#line 977 "main_window.vala"
	_tmp7_ = g_strdup ("ViewZoomReset");
#line 977 "main_window.vala"
	_tmp8_ = g_strdup ("SearchFind");
#line 977 "main_window.vala"
	_tmp9_ = g_strdup ("SearchReplace");
#line 977 "main_window.vala"
	_tmp10_ = g_strdup ("SearchGoToLine");
#line 977 "main_window.vala"
	_tmp11_ = g_strdup ("SearchForward");
#line 977 "main_window.vala"
	_tmp12_ = g_strdup ("ProjectsConfigCurrent");
#line 977 "main_window.vala"
	_tmp13_ = g_new0 (gchar*, 8 + 1);
#line 977 "main_window.vala"
	_tmp13_[0] = _tmp5_;
#line 977 "main_window.vala"
	_tmp13_[1] = _tmp6_;
#line 977 "main_window.vala"
	_tmp13_[2] = _tmp7_;
#line 977 "main_window.vala"
	_tmp13_[3] = _tmp8_;
#line 977 "main_window.vala"
	_tmp13_[4] = _tmp9_;
#line 977 "main_window.vala"
	_tmp13_[5] = _tmp10_;
#line 977 "main_window.vala"
	_tmp13_[6] = _tmp11_;
#line 977 "main_window.vala"
	_tmp13_[7] = _tmp12_;
#line 977 "main_window.vala"
	file_actions = _tmp13_;
#line 977 "main_window.vala"
	file_actions_length1 = 8;
#line 977 "main_window.vala"
	_file_actions_size_ = file_actions_length1;
#line 989 "main_window.vala"
	_tmp14_ = file_actions;
#line 989 "main_window.vala"
	_tmp14__length1 = file_actions_length1;
#line 4524 "main_window.c"
	{
		gchar** file_action_collection = NULL;
		gint file_action_collection_length1 = 0;
		gint _file_action_collection_size_ = 0;
		gint file_action_it = 0;
#line 989 "main_window.vala"
		file_action_collection = _tmp14_;
#line 989 "main_window.vala"
		file_action_collection_length1 = _tmp14__length1;
#line 989 "main_window.vala"
		for (file_action_it = 0; file_action_it < file_action_collection_length1; file_action_it = file_action_it + 1) {
#line 4536 "main_window.c"
			gchar* _tmp15_;
			gchar* file_action = NULL;
#line 989 "main_window.vala"
			_tmp15_ = g_strdup (file_action_collection[file_action_it]);
#line 989 "main_window.vala"
			file_action = _tmp15_;
#line 4543 "main_window.c"
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp16_;
				const gchar* _tmp17_;
				GtkAction* _tmp18_;
				GtkAction* _tmp19_;
				GtkAction* _tmp20_;
#line 991 "main_window.vala"
				_tmp16_ = self->priv->_action_group;
#line 991 "main_window.vala"
				_tmp17_ = file_action;
#line 991 "main_window.vala"
				_tmp18_ = gtk_action_group_get_action (_tmp16_, _tmp17_);
#line 991 "main_window.vala"
				_tmp19_ = _g_object_ref0 (_tmp18_);
#line 991 "main_window.vala"
				action = _tmp19_;
#line 992 "main_window.vala"
				_tmp20_ = action;
#line 992 "main_window.vala"
				gtk_action_set_sensitive (_tmp20_, sensitive);
#line 989 "main_window.vala"
				_g_object_unref0 (action);
#line 989 "main_window.vala"
				_g_free0 (file_action);
#line 4569 "main_window.c"
			}
		}
	}
#line 995 "main_window.vala"
	_tmp21_ = self->priv->_latex_action_group;
#line 995 "main_window.vala"
	gtk_action_group_set_sensitive (_tmp21_, sensitive);
#line 997 "main_window.vala"
	_tmp22_ = self->priv->_main_window_file;
#line 997 "main_window.vala"
	main_window_file_update_sensitivity (_tmp22_);
#line 998 "main_window.vala"
	_tmp23_ = self->priv->_main_window_edit;
#line 998 "main_window.vala"
	main_window_edit_update_sensitivity (_tmp23_);
#line 999 "main_window.vala"
	_tmp24_ = self->priv->_main_window_build_tools;
#line 999 "main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp24_);
#line 1000 "main_window.vala"
	_tmp25_ = self->priv->_main_window_tools;
#line 1000 "main_window.vala"
	main_window_tools_update_sensitivity (_tmp25_);
#line 970 "main_window.vala"
	file_actions = (_vala_array_free (file_actions, file_actions_length1, (GDestroyNotify) g_free), NULL);
#line 970 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 4597 "main_window.c"
}

void
main_window_update_config_project_sensitivity (MainWindow* self)
{
	GtkAction* action = NULL;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	GtkAction* _tmp10_;
#line 1003 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1005 "main_window.vala"
	_tmp0_ = self->priv->_action_group;
#line 1005 "main_window.vala"
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "ProjectsConfigCurrent");
#line 1005 "main_window.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1005 "main_window.vala"
	action = _tmp2_;
#line 1006 "main_window.vala"
	_tmp4_ = main_window_get_active_tab (self);
#line 1006 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 1006 "main_window.vala"
	if (_tmp5_ != NULL) {
#line 4627 "main_window.c"
		Document* _tmp6_;
		Document* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 1006 "main_window.vala"
		_tmp6_ = main_window_get_active_document (self);
#line 1006 "main_window.vala"
		_tmp7_ = _tmp6_;
#line 1006 "main_window.vala"
		_tmp8_ = document_get_project_id (_tmp7_);
#line 1006 "main_window.vala"
		_tmp9_ = _tmp8_;
#line 1006 "main_window.vala"
		_tmp3_ = _tmp9_ != -1;
#line 4642 "main_window.c"
	} else {
#line 1006 "main_window.vala"
		_tmp3_ = FALSE;
#line 4646 "main_window.c"
	}
#line 1006 "main_window.vala"
	_tmp10_ = action;
#line 1006 "main_window.vala"
	gtk_action_set_sensitive (_tmp10_, _tmp3_);
#line 1003 "main_window.vala"
	_g_object_unref0 (action);
#line 4654 "main_window.c"
}

static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 1018 "main_window.vala"
	if ((*length) == (*size)) {
#line 1018 "main_window.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1018 "main_window.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4669 "main_window.c"
	}
#line 1018 "main_window.vala"
	(*array)[(*length)++] = value;
#line 1018 "main_window.vala"
	(*array)[*length] = NULL;
#line 4675 "main_window.c"
}

gboolean
main_window_quit (MainWindow* self)
{
	gchar** list_uris = NULL;
	gchar** _tmp0_;
	gint list_uris_length1;
	gint _list_uris_size_;
	GSettings* settings = NULL;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gboolean result = FALSE;
#line 1011 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1014 "main_window.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 1014 "main_window.vala"
	list_uris = _tmp0_;
#line 1014 "main_window.vala"
	list_uris_length1 = 0;
#line 1014 "main_window.vala"
	_list_uris_size_ = list_uris_length1;
#line 4701 "main_window.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
#line 1015 "main_window.vala"
		_tmp1_ = main_window_get_documents (self);
#line 1015 "main_window.vala"
		_doc_list = _tmp1_;
#line 1015 "main_window.vala"
		_tmp2_ = _doc_list;
#line 1015 "main_window.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 1015 "main_window.vala"
		_tmp4_ = _tmp3_;
#line 1015 "main_window.vala"
		_doc_size = _tmp4_;
#line 1015 "main_window.vala"
		_doc_index = -1;
#line 1015 "main_window.vala"
		while (TRUE) {
#line 4726 "main_window.c"
			Document* doc = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Document* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
#line 1015 "main_window.vala"
			_doc_index = _doc_index + 1;
#line 1015 "main_window.vala"
			if (!(_doc_index < _doc_size)) {
#line 1015 "main_window.vala"
				break;
#line 4739 "main_window.c"
			}
#line 1015 "main_window.vala"
			_tmp5_ = _doc_list;
#line 1015 "main_window.vala"
			_tmp6_ = gee_list_get (_tmp5_, _doc_index);
#line 1015 "main_window.vala"
			doc = (Document*) _tmp6_;
#line 1017 "main_window.vala"
			_tmp7_ = doc;
#line 1017 "main_window.vala"
			_tmp8_ = document_get_location (_tmp7_);
#line 1017 "main_window.vala"
			_tmp9_ = _tmp8_;
#line 1017 "main_window.vala"
			if (_tmp9_ != NULL) {
#line 4755 "main_window.c"
				gchar** _tmp10_;
				gint _tmp10__length1;
				Document* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				gchar* _tmp14_;
#line 1018 "main_window.vala"
				_tmp10_ = list_uris;
#line 1018 "main_window.vala"
				_tmp10__length1 = list_uris_length1;
#line 1018 "main_window.vala"
				_tmp11_ = doc;
#line 1018 "main_window.vala"
				_tmp12_ = document_get_location (_tmp11_);
#line 1018 "main_window.vala"
				_tmp13_ = _tmp12_;
#line 1018 "main_window.vala"
				_tmp14_ = g_file_get_uri (_tmp13_);
#line 1018 "main_window.vala"
				_vala_array_add6 (&list_uris, &list_uris_length1, &_list_uris_size_, _tmp14_);
#line 4776 "main_window.c"
			}
#line 1015 "main_window.vala"
			_g_object_unref0 (doc);
#line 4780 "main_window.c"
		}
#line 1015 "main_window.vala"
		_g_object_unref0 (_doc_list);
#line 4784 "main_window.c"
	}
#line 1021 "main_window.vala"
	_tmp15_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 1021 "main_window.vala"
	settings = _tmp15_;
#line 1022 "main_window.vala"
	_tmp16_ = settings;
#line 1022 "main_window.vala"
	_tmp17_ = list_uris;
#line 1022 "main_window.vala"
	_tmp17__length1 = list_uris_length1;
#line 1022 "main_window.vala"
	g_settings_set_strv (_tmp16_, "documents", _tmp17_);
#line 1024 "main_window.vala"
	if (main_window_close_all_documents (self)) {
#line 1026 "main_window.vala"
		main_window_save_state (self);
#line 1027 "main_window.vala"
		gtk_widget_destroy ((GtkWidget*) self);
#line 1028 "main_window.vala"
		result = TRUE;
#line 1028 "main_window.vala"
		_g_object_unref0 (settings);
#line 1028 "main_window.vala"
		list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
#line 1028 "main_window.vala"
		return result;
#line 4812 "main_window.c"
	}
#line 1031 "main_window.vala"
	result = FALSE;
#line 1031 "main_window.vala"
	_g_object_unref0 (settings);
#line 1031 "main_window.vala"
	list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
#line 1031 "main_window.vala"
	return result;
#line 4822 "main_window.c"
}

/*************************************************************************/
void
main_window_on_view_zoom_in (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1039 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1041 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1041 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1041 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1042 "main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1042 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1042 "main_window.vala"
	document_view_enlarge_font (_tmp3_);
#line 4847 "main_window.c"
}

void
main_window_on_view_zoom_out (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1045 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1047 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1047 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1047 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1048 "main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1048 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1048 "main_window.vala"
	document_view_shrink_font (_tmp3_);
#line 4871 "main_window.c"
}

void
main_window_on_view_zoom_reset (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1051 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1053 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1053 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1053 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1054 "main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1054 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1054 "main_window.vala"
	document_view_set_font_from_settings (_tmp3_);
#line 4895 "main_window.c"
}

void
main_window_on_search_find (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
#line 1059 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1061 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1061 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1061 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1062 "main_window.vala"
	_tmp2_ = self->priv->_search_and_replace;
#line 1062 "main_window.vala"
	search_and_replace_show_search (_tmp2_);
#line 4916 "main_window.c"
}

void
main_window_on_search_replace (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
#line 1065 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1067 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1067 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1067 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1068 "main_window.vala"
	_tmp2_ = self->priv->_search_and_replace;
#line 1068 "main_window.vala"
	search_and_replace_show_search_and_replace (_tmp2_);
#line 4937 "main_window.c"
}

void
main_window_on_search_goto_line (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	GotoLine* _tmp2_;
#line 1071 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1073 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1073 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1073 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1074 "main_window.vala"
	_tmp2_ = self->priv->_goto_line;
#line 1074 "main_window.vala"
	goto_line_show (_tmp2_);
#line 4958 "main_window.c"
}

void
main_window_on_search_forward (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp2_;
	LatexilaSynctex* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
#line 1077 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1079 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1079 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1079 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1081 "main_window.vala"
	_tmp2_ = latexila_synctex_get_instance ();
#line 1081 "main_window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1081 "main_window.vala"
	synctex = _tmp3_;
#line 1082 "main_window.vala"
	_tmp4_ = main_window_get_active_document (self);
#line 1082 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 1082 "main_window.vala"
	_tmp6_ = main_window_get_active_document (self);
#line 1082 "main_window.vala"
	_tmp7_ = _tmp6_;
#line 1082 "main_window.vala"
	_tmp8_ = document_get_location (_tmp7_);
#line 1082 "main_window.vala"
	_tmp9_ = _tmp8_;
#line 1082 "main_window.vala"
	_tmp10_ = main_window_get_active_document (self);
#line 1082 "main_window.vala"
	_tmp11_ = _tmp10_;
#line 1082 "main_window.vala"
	_tmp12_ = document_get_main_file (_tmp11_);
#line 1082 "main_window.vala"
	_tmp13_ = _tmp12_;
#line 1082 "main_window.vala"
	latexila_synctex_forward_search (synctex, (GtkTextBuffer*) _tmp5_, _tmp9_, _tmp13_, (guint) GDK_CURRENT_TIME);
#line 1082 "main_window.vala"
	_g_object_unref0 (_tmp13_);
#line 1077 "main_window.vala"
	_g_object_unref0 (synctex);
#line 5019 "main_window.c"
}

void
main_window_on_projects_new (MainWindow* self)
{
#line 1088 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1090 "main_window.vala"
	project_dialogs_new_project (self);
#line 5029 "main_window.c"
}

void
main_window_on_projects_config_current (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 1093 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1095 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1095 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1095 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1096 "main_window.vala"
	_tmp2_ = main_window_get_active_document (self);
#line 1096 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1096 "main_window.vala"
	_tmp4_ = document_get_project_id (_tmp3_);
#line 1096 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 1096 "main_window.vala"
	g_return_if_fail (_tmp5_ != -1);
#line 1097 "main_window.vala"
	_tmp6_ = main_window_get_active_document (self);
#line 1097 "main_window.vala"
	_tmp7_ = _tmp6_;
#line 1097 "main_window.vala"
	_tmp8_ = document_get_project_id (_tmp7_);
#line 1097 "main_window.vala"
	_tmp9_ = _tmp8_;
#line 1097 "main_window.vala"
	project_dialogs_configure_project ((GtkWindow*) self, _tmp9_);
#line 5073 "main_window.c"
}

void
main_window_on_projects_manage (MainWindow* self)
{
#line 1100 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1102 "main_window.vala"
	project_dialogs_manage_projects (self);
#line 5083 "main_window.c"
}

void
main_window_on_help_latex_reference (MainWindow* self)
{
	GError* _inner_error0_ = NULL;
#line 1107 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 5092 "main_window.c"
	{
		gchar* uri = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
#line 1111 "main_window.vala"
		_tmp0_ = g_build_filename (DATA_DIR, "latexhelp.html", NULL, NULL);
#line 1111 "main_window.vala"
		_tmp1_ = _tmp0_;
#line 1111 "main_window.vala"
		_tmp2_ = g_filename_to_uri (_tmp1_, NULL, &_inner_error0_);
#line 1111 "main_window.vala"
		_tmp3_ = _tmp2_;
#line 1111 "main_window.vala"
		_g_free0 (_tmp1_);
#line 1111 "main_window.vala"
		uri = _tmp3_;
#line 1111 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 5114 "main_window.c"
			goto __catch32_g_error;
		}
#line 1113 "main_window.vala"
		_tmp4_ = uri;
#line 1113 "main_window.vala"
		latexila_utils_show_uri ((GtkWidget*) self, _tmp4_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 1113 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1113 "main_window.vala"
			_g_free0 (uri);
#line 5125 "main_window.c"
			goto __catch32_g_error;
		}
#line 1109 "main_window.vala"
		_g_free0 (uri);
#line 5130 "main_window.c"
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 1109 "main_window.vala"
		e = _inner_error0_;
#line 1109 "main_window.vala"
		_inner_error0_ = NULL;
#line 1117 "main_window.vala"
		_tmp5_ = e;
#line 1117 "main_window.vala"
		_tmp6_ = _tmp5_->message;
#line 1117 "main_window.vala"
		g_warning ("main_window.vala:1117: Impossible to open the LaTeX reference: %s", _tmp6_);
#line 1109 "main_window.vala"
		_g_error_free0 (e);
#line 5150 "main_window.c"
	}
	__finally32:
#line 1109 "main_window.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1109 "main_window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1109 "main_window.vala"
		g_clear_error (&_inner_error0_);
#line 1109 "main_window.vala"
		return;
#line 5161 "main_window.c"
	}
}

DocumentTab*
main_window_get_active_tab (MainWindow* self)
{
	DocumentTab* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplTab* _tmp2_;
#line 112 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 114 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 114 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 114 "main_window.vala"
	tepl_window = _tmp1_;
#line 116 "main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) tepl_window);
#line 116 "main_window.vala"
	result = IS_DOCUMENT_TAB (_tmp2_) ? ((DocumentTab*) _tmp2_) : NULL;
#line 116 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 116 "main_window.vala"
	return result;
#line 5189 "main_window.c"
}

void
main_window_set_active_tab (MainWindow* self,
                            DocumentTab* value)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
#line 119 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 121 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 121 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 121 "main_window.vala"
	tepl_window = _tmp1_;
#line 123 "main_window.vala"
	tepl_tab_group_set_active_tab ((TeplTabGroup*) tepl_window, (TeplTab*) value);
#line 119 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 119 "main_window.vala"
	g_object_notify_by_pspec ((GObject *) self, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY]);
#line 5213 "main_window.c"
}

DocumentView*
main_window_get_active_view (MainWindow* self)
{
	DocumentView* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplView* _tmp2_;
#line 129 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 131 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 131 "main_window.vala"
	tepl_window = _tmp1_;
#line 133 "main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_view ((TeplTabGroup*) tepl_window);
#line 133 "main_window.vala"
	result = IS_DOCUMENT_VIEW (_tmp2_) ? ((DocumentView*) _tmp2_) : NULL;
#line 133 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 133 "main_window.vala"
	return result;
#line 5240 "main_window.c"
}

Document*
main_window_get_active_document (MainWindow* self)
{
	Document* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplBuffer* _tmp2_;
#line 139 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 141 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 141 "main_window.vala"
	tepl_window = _tmp1_;
#line 143 "main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_buffer ((TeplTabGroup*) tepl_window);
#line 143 "main_window.vala"
	result = IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL;
#line 143 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 143 "main_window.vala"
	return result;
#line 5267 "main_window.c"
}

static void
main_window_class_init (MainWindowClass * klass,
                        gpointer klass_data)
{
#line 22 "main_window.vala"
	main_window_parent_class = g_type_class_peek_parent (klass);
#line 22 "main_window.vala"
	g_type_class_adjust_private_offset (klass, &MainWindow_private_offset);
#line 22 "main_window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
#line 22 "main_window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_main_window_set_property;
#line 22 "main_window.vala"
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
#line 5284 "main_window.c"
	/*************************************************************************/
#line 22 "main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_TAB_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY] = g_param_spec_object ("active-tab", "active-tab", "active-tab", TYPE_DOCUMENT_TAB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_VIEW_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_VIEW_PROPERTY] = g_param_spec_object ("active-view", "active-view", "active-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY] = g_param_spec_object ("active-document", "active-document", "active-document", TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 5292 "main_window.c"
}

static void
main_window_instance_init (MainWindow * self,
                           gpointer klass)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 22 "main_window.vala"
	self->priv = main_window_get_instance_private (self);
#line 85 "main_window.vala"
	_tmp0_ = g_get_home_dir ();
#line 85 "main_window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 85 "main_window.vala"
	self->default_location = _tmp1_;
#line 5309 "main_window.c"
}

static void
main_window_finalize (GObject * obj)
{
	MainWindow * self;
#line 22 "main_window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
#line 85 "main_window.vala"
	_g_free0 (self->default_location);
#line 86 "main_window.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 87 "main_window.vala"
	_g_object_unref0 (self->priv->_statusbar);
#line 88 "main_window.vala"
	_g_object_unref0 (self->priv->_goto_line);
#line 89 "main_window.vala"
	_g_object_unref0 (self->priv->_search_and_replace);
#line 90 "main_window.vala"
	_g_object_unref0 (self->priv->_main_hpaned);
#line 91 "main_window.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 93 "main_window.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 94 "main_window.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 95 "main_window.vala"
	_g_object_unref0 (self->priv->_latex_action_group);
#line 97 "main_window.vala"
	_main_window_file_unref0 (self->priv->_main_window_file);
#line 98 "main_window.vala"
	_main_window_edit_unref0 (self->priv->_main_window_edit);
#line 99 "main_window.vala"
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
#line 100 "main_window.vala"
	_main_window_structure_unref0 (self->priv->_main_window_structure);
#line 101 "main_window.vala"
	_main_window_documents_unref0 (self->priv->_main_window_documents);
#line 102 "main_window.vala"
	_main_window_tools_unref0 (self->priv->_main_window_tools);
#line 22 "main_window.vala"
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
#line 5352 "main_window.c"
}

GType
main_window_get_type (void)
{
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
		MainWindow_private_offset = g_type_add_instance_private (main_window_type_id, sizeof (MainWindowPrivate));
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}

static void
_vala_main_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
#line 22 "main_window.vala"
	switch (property_id) {
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
#line 22 "main_window.vala"
		g_value_set_object (value, main_window_get_active_tab (self));
#line 22 "main_window.vala"
		break;
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_VIEW_PROPERTY:
#line 22 "main_window.vala"
		g_value_set_object (value, main_window_get_active_view (self));
#line 22 "main_window.vala"
		break;
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY:
#line 22 "main_window.vala"
		g_value_set_object (value, main_window_get_active_document (self));
#line 22 "main_window.vala"
		break;
#line 5397 "main_window.c"
		default:
#line 22 "main_window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "main_window.vala"
		break;
#line 5403 "main_window.c"
	}
}

static void
_vala_main_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
#line 22 "main_window.vala"
	switch (property_id) {
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
#line 22 "main_window.vala"
		main_window_set_active_tab (self, g_value_get_object (value));
#line 22 "main_window.vala"
		break;
#line 5423 "main_window.c"
		default:
#line 22 "main_window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "main_window.vala"
		break;
#line 5429 "main_window.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5440 "main_window.c"
		int i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5448 "main_window.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 5463 "main_window.c"
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 5477 "main_window.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 5482 "main_window.c"
}

