/* document_view.c generated by valac 0.46.6, the Vala compiler
 * generated from document_view.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2016 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <latexila.h>
#include <gdk/gdk.h>
#include <gspell/gspell.h>
#include <glib/gi18n-lib.h>

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentViewPrivate DocumentViewPrivate;
enum  {
	DOCUMENT_VIEW_0_PROPERTY,
	DOCUMENT_VIEW_NUM_PROPERTIES
};
static GParamSpec* document_view_properties[DOCUMENT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block18Data Block18Data;

struct _DocumentView {
	TeplView parent_instance;
	DocumentViewPrivate * priv;
};

struct _DocumentViewClass {
	TeplViewClass parent_class;
};

struct _DocumentViewPrivate {
	GSettings* _editor_settings;
	PangoFontDescription* _font_desc;
};

struct _Block18Data {
	int _ref_count_;
	DocumentView* self;
	GspellChecker* spell_checker;
};

static gint DocumentView_private_offset;
static gpointer document_view_parent_class = NULL;
static gboolean document_view__no_spell_language_dialog_shown;
static gboolean document_view__no_spell_language_dialog_shown = FALSE;

GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
#define DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE "metadata::latexila-spell-language"
#define DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL "metadata::latexila-inline-spell"
#define DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR "1"
#define DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR "0"
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type,
                                       Document* doc);
static void __lambda45_ (DocumentView* self,
                  GObject* d,
                  GParamSpec* p);
gboolean document_get_readonly (Document* self);
static void ___lambda45__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
void document_view_set_font_from_settings (DocumentView* self);
GType completion_provider_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
CompletionProvider* completion_provider_get_default (void);
static void document_view_hide_completion_calltip_when_needed (DocumentView* self);
static void document_view_init_spell_checking (DocumentView* self);
static gboolean document_view_on_button_release_event (DocumentView* self,
                                                GdkEventButton* event);
static gboolean _document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                 GdkEventButton* event,
                                                                                 gpointer self);
GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
AppSettings* app_settings_get_default (void);
const gchar* app_settings_get_system_font (AppSettings* self);
void document_view_set_font_from_string (DocumentView* self,
                                         const gchar* font);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static void __lambda46_ (DocumentView* self);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void ___lambda46__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static GspellLanguage* document_view_get_spell_language (DocumentView* self);
void document_view_setup_inline_spell_checker (DocumentView* self);
static void document_view_inline_checker_enabled_notify_cb (DocumentView* self);
static void _document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void __lambda47_ (Block18Data* _data18_);
static void ___lambda47__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda48_ (Block18Data* _data18_);
static void ___lambda48__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda49_ (DocumentView* self);
static void ___lambda49__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
gchar* document_get_metadata (Document* self,
                              const gchar* key);
static GspellChecker* document_view_get_spell_checker (DocumentView* self);
void document_view_launch_spell_checker_dialog (DocumentView* self);
void document_view_launch_spell_language_chooser_dialog (DocumentView* self);
void document_view_save_spell_language_metadata (DocumentView* self);
void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
void document_view_save_inline_spell_metadata (DocumentView* self);
static void document_view_finalize (GObject * obj);

static inline gpointer
document_view_get_instance_private (DocumentView* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentView_private_offset);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 32 "document_view.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 202 "document_view.c"
}

static void
__lambda45_ (DocumentView* self,
             GObject* d,
             GParamSpec* p)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 40 "document_view.vala"
	g_return_if_fail (d != NULL);
#line 40 "document_view.vala"
	g_return_if_fail (p != NULL);
#line 42 "document_view.vala"
	_tmp0_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (d, TYPE_DOCUMENT, Document));
#line 42 "document_view.vala"
	_tmp1_ = _tmp0_;
#line 42 "document_view.vala"
	gtk_text_view_set_editable ((GtkTextView*) self, !_tmp1_);
#line 222 "document_view.c"
}

static void
___lambda45__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 40 "document_view.vala"
	__lambda45_ ((DocumentView*) self, _sender, pspec);
#line 232 "document_view.c"
}

static gboolean
_document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                        GdkEventButton* event,
                                                                        gpointer self)
{
	gboolean result;
	result = document_view_on_button_release_event ((DocumentView*) self, event);
#line 92 "document_view.vala"
	return result;
#line 244 "document_view.c"
}

DocumentView*
document_view_construct (GType object_type,
                         Document* doc)
{
	DocumentView * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	guint tmp = 0U;
	GSettings* _tmp2_;
	guint _tmp3_ = 0U;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GError* _inner_error0_ = NULL;
#line 36 "document_view.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 36 "document_view.vala"
	self = (DocumentView*) g_object_new (object_type, NULL);
#line 38 "document_view.vala"
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) doc);
#line 40 "document_view.vala"
	g_signal_connect_object ((GObject*) doc, "notify::readonly", (GCallback) ___lambda45__g_object_notify, self, 0);
#line 45 "document_view.vala"
	gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_WORD);
#line 46 "document_view.vala"
	gtk_source_view_set_auto_indent ((GtkSourceView*) self, TRUE);
#line 47 "document_view.vala"
	gtk_source_view_set_indent_width ((GtkSourceView*) self, -1);
#line 49 "document_view.vala"
	latexila_view_configure_space_drawer ((GtkSourceView*) self);
#line 52 "document_view.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 52 "document_view.vala"
	_g_object_unref0 (self->priv->_editor_settings);
#line 52 "document_view.vala"
	self->priv->_editor_settings = _tmp0_;
#line 54 "document_view.vala"
	_tmp1_ = self->priv->_editor_settings;
#line 54 "document_view.vala"
	g_settings_bind (_tmp1_, "forget-no-tabs", (GObject*) self, "smart-backspace", G_SETTINGS_BIND_GET);
#line 57 "document_view.vala"
	document_view_set_font_from_settings (self);
#line 61 "document_view.vala"
	_tmp2_ = self->priv->_editor_settings;
#line 61 "document_view.vala"
	g_settings_get (_tmp2_, "tabs-size", "u", &_tmp3_);
#line 61 "document_view.vala"
	tmp = _tmp3_;
#line 62 "document_view.vala"
	gtk_source_view_set_tab_width ((GtkSourceView*) self, tmp);
#line 64 "document_view.vala"
	_tmp4_ = self->priv->_editor_settings;
#line 64 "document_view.vala"
	gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) self, g_settings_get_boolean (_tmp4_, "insert-spaces"));
#line 65 "document_view.vala"
	_tmp5_ = self->priv->_editor_settings;
#line 65 "document_view.vala"
	gtk_source_view_set_show_line_numbers ((GtkSourceView*) self, g_settings_get_boolean (_tmp5_, "display-line-numbers"));
#line 66 "document_view.vala"
	_tmp6_ = self->priv->_editor_settings;
#line 66 "document_view.vala"
	gtk_source_view_set_highlight_current_line ((GtkSourceView*) self, g_settings_get_boolean (_tmp6_, "highlight-current-line"));
#line 67 "document_view.vala"
	_tmp7_ = self->priv->_editor_settings;
#line 67 "document_view.vala"
	gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) doc, g_settings_get_boolean (_tmp7_, "bracket-matching"));
#line 69 "document_view.vala"
	gtk_source_view_set_smart_home_end ((GtkSourceView*) self, GTK_SOURCE_SMART_HOME_END_AFTER);
#line 316 "document_view.c"
	{
		CompletionProvider* provider = NULL;
		CompletionProvider* _tmp8_;
		GtkSourceCompletion* _tmp9_;
		GtkSourceCompletion* _tmp10_;
		GtkSourceCompletion* _tmp11_;
		GtkSourceCompletion* _tmp12_;
		GtkSourceCompletion* _tmp13_;
		GtkSourceCompletion* _tmp14_;
		GtkSourceCompletion* _tmp15_;
		GtkSourceCompletion* _tmp16_;
		GtkSourceCompletion* _tmp17_;
		GtkSourceCompletion* _tmp18_;
#line 74 "document_view.vala"
		_tmp8_ = completion_provider_get_default ();
#line 74 "document_view.vala"
		provider = _tmp8_;
#line 75 "document_view.vala"
		_tmp9_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 75 "document_view.vala"
		_tmp10_ = _tmp9_;
#line 75 "document_view.vala"
		gtk_source_completion_add_provider (_tmp10_, (GtkSourceCompletionProvider*) provider, &_inner_error0_);
#line 75 "document_view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 75 "document_view.vala"
			_g_object_unref0 (provider);
#line 344 "document_view.c"
			goto __catch16_g_error;
		}
#line 76 "document_view.vala"
		_tmp11_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 76 "document_view.vala"
		_tmp12_ = _tmp11_;
#line 76 "document_view.vala"
		g_object_set (_tmp12_, "remember-info-visibility", TRUE, NULL);
#line 77 "document_view.vala"
		_tmp13_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 77 "document_view.vala"
		_tmp14_ = _tmp13_;
#line 77 "document_view.vala"
		g_object_set (_tmp14_, "show-headers", FALSE, NULL);
#line 78 "document_view.vala"
		_tmp15_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 78 "document_view.vala"
		_tmp16_ = _tmp15_;
#line 78 "document_view.vala"
		g_object_set (_tmp16_, "auto-complete-delay", (guint) 0, NULL);
#line 79 "document_view.vala"
		_tmp17_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 79 "document_view.vala"
		_tmp18_ = _tmp17_;
#line 79 "document_view.vala"
		g_object_set (_tmp18_, "accelerators", (guint) 0, NULL);
#line 81 "document_view.vala"
		document_view_hide_completion_calltip_when_needed (self);
#line 72 "document_view.vala"
		_g_object_unref0 (provider);
#line 375 "document_view.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
#line 72 "document_view.vala"
		e = _inner_error0_;
#line 72 "document_view.vala"
		_inner_error0_ = NULL;
#line 85 "document_view.vala"
		_tmp19_ = e;
#line 85 "document_view.vala"
		_tmp20_ = _tmp19_->message;
#line 85 "document_view.vala"
		g_warning ("document_view.vala:85: Completion: %s", _tmp20_);
#line 72 "document_view.vala"
		_g_error_free0 (e);
#line 395 "document_view.c"
	}
	__finally16:
#line 72 "document_view.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 72 "document_view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 72 "document_view.vala"
		g_clear_error (&_inner_error0_);
#line 72 "document_view.vala"
		return NULL;
#line 406 "document_view.c"
	}
#line 89 "document_view.vala"
	document_view_init_spell_checking (self);
#line 92 "document_view.vala"
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _document_view_on_button_release_event_gtk_widget_button_release_event, self, 0);
#line 36 "document_view.vala"
	return self;
#line 414 "document_view.c"
}

DocumentView*
document_view_new (Document* doc)
{
#line 36 "document_view.vala"
	return document_view_construct (TYPE_DOCUMENT_VIEW, doc);
#line 422 "document_view.c"
}

void
document_view_set_font_from_settings (DocumentView* self)
{
	gchar* font = NULL;
	GSettings* _tmp0_;
	const gchar* _tmp8_;
#line 95 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 98 "document_view.vala"
	_tmp0_ = self->priv->_editor_settings;
#line 98 "document_view.vala"
	if (g_settings_get_boolean (_tmp0_, "use-default-font")) {
#line 437 "document_view.c"
		AppSettings* _tmp1_;
		AppSettings* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 99 "document_view.vala"
		_tmp1_ = app_settings_get_default ();
#line 99 "document_view.vala"
		_tmp2_ = _tmp1_;
#line 99 "document_view.vala"
		_tmp3_ = app_settings_get_system_font (_tmp2_);
#line 99 "document_view.vala"
		_tmp4_ = _tmp3_;
#line 99 "document_view.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 99 "document_view.vala"
		_g_free0 (font);
#line 99 "document_view.vala"
		font = _tmp5_;
#line 99 "document_view.vala"
		_g_object_unref0 (_tmp2_);
#line 459 "document_view.c"
	} else {
		GSettings* _tmp6_;
		gchar* _tmp7_;
#line 101 "document_view.vala"
		_tmp6_ = self->priv->_editor_settings;
#line 101 "document_view.vala"
		_tmp7_ = g_settings_get_string (_tmp6_, "editor-font");
#line 101 "document_view.vala"
		_g_free0 (font);
#line 101 "document_view.vala"
		font = _tmp7_;
#line 471 "document_view.c"
	}
#line 103 "document_view.vala"
	_tmp8_ = font;
#line 103 "document_view.vala"
	document_view_set_font_from_string (self, _tmp8_);
#line 95 "document_view.vala"
	_g_free0 (font);
#line 479 "document_view.c"
}

void
document_view_set_font_from_string (DocumentView* self,
                                    const gchar* font)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
#line 106 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 106 "document_view.vala"
	g_return_if_fail (font != NULL);
#line 108 "document_view.vala"
	_tmp0_ = pango_font_description_from_string (font);
#line 108 "document_view.vala"
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
#line 108 "document_view.vala"
	self->priv->_font_desc = _tmp0_;
#line 109 "document_view.vala"
	_tmp1_ = self->priv->_font_desc;
#line 109 "document_view.vala"
	gtk_widget_override_font ((GtkWidget*) self, _tmp1_);
#line 502 "document_view.c"
}

void
document_view_enlarge_font (DocumentView* self)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
#line 112 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 115 "document_view.vala"
	_tmp0_ = self->priv->_font_desc;
#line 115 "document_view.vala"
	_tmp1_ = self->priv->_font_desc;
#line 115 "document_view.vala"
	pango_font_description_set_size (_tmp0_, pango_font_description_get_size (_tmp1_) + PANGO_SCALE);
#line 116 "document_view.vala"
	_tmp2_ = self->priv->_font_desc;
#line 116 "document_view.vala"
	gtk_widget_override_font ((GtkWidget*) self, _tmp2_);
#line 523 "document_view.c"
}

void
document_view_shrink_font (DocumentView* self)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
#line 119 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 122 "document_view.vala"
	_tmp0_ = self->priv->_font_desc;
#line 122 "document_view.vala"
	_tmp1_ = self->priv->_font_desc;
#line 122 "document_view.vala"
	pango_font_description_set_size (_tmp0_, pango_font_description_get_size (_tmp1_) - PANGO_SCALE);
#line 123 "document_view.vala"
	_tmp2_ = self->priv->_font_desc;
#line 123 "document_view.vala"
	gtk_widget_override_font ((GtkWidget*) self, _tmp2_);
#line 544 "document_view.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 132 "document_view.vala"
	return self ? g_object_ref (self) : NULL;
#line 552 "document_view.c"
}

static gboolean
document_view_on_button_release_event (DocumentView* self,
                                       GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 126 "document_view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "document_view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 129 "document_view.vala"
	if (event->button == ((guint) 1)) {
#line 567 "document_view.c"
		GdkModifierType _tmp1_;
#line 130 "document_view.vala"
		_tmp1_ = event->state;
#line 130 "document_view.vala"
		_tmp0_ = (_tmp1_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
#line 573 "document_view.c"
	} else {
#line 129 "document_view.vala"
		_tmp0_ = FALSE;
#line 577 "document_view.c"
	}
#line 129 "document_view.vala"
	if (_tmp0_) {
#line 581 "document_view.c"
		LatexilaSynctex* synctex = NULL;
		LatexilaSynctex* _tmp2_;
		LatexilaSynctex* _tmp3_;
		Document* doc = NULL;
		GtkTextBuffer* _tmp4_;
		GtkTextBuffer* _tmp5_;
		Document* _tmp6_;
		LatexilaSynctex* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		Document* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		Document* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
#line 132 "document_view.vala"
		_tmp2_ = latexila_synctex_get_instance ();
#line 132 "document_view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 132 "document_view.vala"
		synctex = _tmp3_;
#line 133 "document_view.vala"
		_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 133 "document_view.vala"
		_tmp5_ = _tmp4_;
#line 133 "document_view.vala"
		_tmp6_ = _g_object_ref0 (IS_DOCUMENT (_tmp5_) ? ((Document*) _tmp5_) : NULL);
#line 133 "document_view.vala"
		doc = _tmp6_;
#line 134 "document_view.vala"
		_tmp7_ = synctex;
#line 134 "document_view.vala"
		_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 134 "document_view.vala"
		_tmp9_ = _tmp8_;
#line 134 "document_view.vala"
		_tmp10_ = doc;
#line 134 "document_view.vala"
		_tmp11_ = document_get_location (_tmp10_);
#line 134 "document_view.vala"
		_tmp12_ = _tmp11_;
#line 134 "document_view.vala"
		_tmp13_ = doc;
#line 134 "document_view.vala"
		_tmp14_ = document_get_main_file (_tmp13_);
#line 134 "document_view.vala"
		_tmp15_ = _tmp14_;
#line 134 "document_view.vala"
		latexila_synctex_forward_search (_tmp7_, _tmp9_, _tmp12_, _tmp15_, (guint) event->time);
#line 134 "document_view.vala"
		_g_object_unref0 (_tmp15_);
#line 129 "document_view.vala"
		_g_object_unref0 (doc);
#line 129 "document_view.vala"
		_g_object_unref0 (synctex);
#line 638 "document_view.c"
	}
#line 139 "document_view.vala"
	result = FALSE;
#line 139 "document_view.vala"
	return result;
#line 644 "document_view.c"
}

static void
__lambda46_ (DocumentView* self)
{
	CompletionProvider* provider = NULL;
	CompletionProvider* _tmp0_;
#line 146 "document_view.vala"
	_tmp0_ = completion_provider_get_default ();
#line 146 "document_view.vala"
	provider = _tmp0_;
#line 147 "document_view.vala"
	completion_provider_hide_calltip_window (provider);
#line 144 "document_view.vala"
	_g_object_unref0 (provider);
#line 660 "document_view.c"
}

static void
___lambda46__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 144 "document_view.vala"
	__lambda46_ ((DocumentView*) self);
#line 670 "document_view.c"
}

static void
document_view_hide_completion_calltip_when_needed (DocumentView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
#line 142 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 144 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 144 "document_view.vala"
	_tmp1_ = _tmp0_;
#line 144 "document_view.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::cursor-position", (GCallback) ___lambda46__g_object_notify, self, 0);
#line 686 "document_view.c"
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
#line 153 "document_view.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 153 "document_view.vala"
	return _data18_;
#line 696 "document_view.c"
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 153 "document_view.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 706 "document_view.c"
		DocumentView* self;
#line 153 "document_view.vala"
		self = _data18_->self;
#line 153 "document_view.vala"
		_g_object_unref0 (_data18_->spell_checker);
#line 153 "document_view.vala"
		_g_object_unref0 (self);
#line 153 "document_view.vala"
		g_slice_free (Block18Data, _data18_);
#line 716 "document_view.c"
	}
}

static void
_document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
#line 165 "document_view.vala"
	document_view_inline_checker_enabled_notify_cb ((DocumentView*) self);
#line 727 "document_view.c"
}

static void
__lambda47_ (Block18Data* _data18_)
{
	DocumentView* self;
	GspellLanguage* _tmp0_;
#line 169 "document_view.vala"
	self = _data18_->self;
#line 171 "document_view.vala"
	_tmp0_ = document_view_get_spell_language (self);
#line 171 "document_view.vala"
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
#line 172 "document_view.vala"
	document_view_setup_inline_spell_checker (self);
#line 743 "document_view.c"
}

static void
___lambda47__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 169 "document_view.vala"
	__lambda47_ (self);
#line 753 "document_view.c"
}

static void
__lambda48_ (Block18Data* _data18_)
{
	DocumentView* self;
	GspellLanguage* _tmp0_;
#line 175 "document_view.vala"
	self = _data18_->self;
#line 177 "document_view.vala"
	_tmp0_ = document_view_get_spell_language (self);
#line 177 "document_view.vala"
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
#line 767 "document_view.c"
}

static void
___lambda48__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
#line 175 "document_view.vala"
	__lambda48_ (self);
#line 777 "document_view.c"
}

static void
__lambda49_ (DocumentView* self)
{
#line 182 "document_view.vala"
	document_view_setup_inline_spell_checker (self);
#line 785 "document_view.c"
}

static void
___lambda49__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
#line 180 "document_view.vala"
	__lambda49_ ((DocumentView*) self);
#line 795 "document_view.c"
}

static void
document_view_init_spell_checking (DocumentView* self)
{
	Block18Data* _data18_;
	GspellLanguage* _tmp0_;
	GspellChecker* _tmp1_;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GspellTextBuffer* _tmp4_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp5_;
	GspellTextView* _tmp6_;
	Document* doc = NULL;
	GtkTextBuffer* _tmp7_;
	Document* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
#line 153 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 153 "document_view.vala"
	_data18_ = g_slice_new0 (Block18Data);
#line 153 "document_view.vala"
	_data18_->_ref_count_ = 1;
#line 153 "document_view.vala"
	_data18_->self = g_object_ref (self);
#line 155 "document_view.vala"
	_tmp0_ = document_view_get_spell_language (self);
#line 155 "document_view.vala"
	_tmp1_ = gspell_checker_new (_tmp0_);
#line 155 "document_view.vala"
	_data18_->spell_checker = _tmp1_;
#line 157 "document_view.vala"
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 157 "document_view.vala"
	_tmp3_ = _tmp2_;
#line 157 "document_view.vala"
	_tmp4_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp3_);
#line 157 "document_view.vala"
	gspell_buffer = _tmp4_;
#line 159 "document_view.vala"
	gspell_text_buffer_set_spell_checker (gspell_buffer, _data18_->spell_checker);
#line 161 "document_view.vala"
	document_view_setup_inline_spell_checker (self);
#line 163 "document_view.vala"
	_tmp5_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 163 "document_view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 163 "document_view.vala"
	gspell_view = _tmp6_;
#line 165 "document_view.vala"
	g_signal_connect_object ((GObject*) gspell_view, "notify::inline-spell-checking", (GCallback) _document_view_inline_checker_enabled_notify_cb_g_object_notify, self, 0);
#line 167 "document_view.vala"
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 167 "document_view.vala"
	_tmp8_ = _g_object_ref0 (IS_DOCUMENT (_tmp7_) ? ((Document*) _tmp7_) : NULL);
#line 167 "document_view.vala"
	doc = _tmp8_;
#line 169 "document_view.vala"
	g_signal_connect_data ((GObject*) doc, "notify::location", (GCallback) ___lambda47__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 175 "document_view.vala"
	_tmp9_ = self->priv->_editor_settings;
#line 175 "document_view.vala"
	g_signal_connect_data (_tmp9_, "changed::spell-checking-language", (GCallback) ___lambda48__g_settings_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 180 "document_view.vala"
	_tmp10_ = self->priv->_editor_settings;
#line 180 "document_view.vala"
	g_signal_connect_object (_tmp10_, "changed::highlight-misspelled-words", (GCallback) ___lambda49__g_settings_changed, self, 0);
#line 153 "document_view.vala"
	_g_object_unref0 (doc);
#line 153 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 153 "document_view.vala"
	block18_data_unref (_data18_);
#line 153 "document_view.vala"
	_data18_ = NULL;
#line 874 "document_view.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 891 "document_view.c"
}

static GspellLanguage*
document_view_get_spell_language (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gchar* lang_code = NULL;
	Document* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GspellLanguage* _tmp9_;
	GspellLanguage* result = NULL;
#line 186 "document_view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 188 "document_view.vala"
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
#line 188 "document_view.vala"
	doc = _tmp1_;
#line 190 "document_view.vala"
	_tmp2_ = doc;
#line 190 "document_view.vala"
	_tmp3_ = document_get_metadata (_tmp2_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE);
#line 190 "document_view.vala"
	lang_code = _tmp3_;
#line 191 "document_view.vala"
	_tmp4_ = lang_code;
#line 191 "document_view.vala"
	if (_tmp4_ == NULL) {
#line 926 "document_view.c"
		GSettings* _tmp5_;
		gchar* _tmp6_;
#line 192 "document_view.vala"
		_tmp5_ = self->priv->_editor_settings;
#line 192 "document_view.vala"
		_tmp6_ = g_settings_get_string (_tmp5_, "spell-checking-language");
#line 192 "document_view.vala"
		_g_free0 (lang_code);
#line 192 "document_view.vala"
		lang_code = _tmp6_;
#line 937 "document_view.c"
	}
#line 194 "document_view.vala"
	_tmp7_ = lang_code;
#line 194 "document_view.vala"
	if (string_get (_tmp7_, (glong) 0) == '\0') {
#line 195 "document_view.vala"
		result = NULL;
#line 195 "document_view.vala"
		_g_free0 (lang_code);
#line 195 "document_view.vala"
		_g_object_unref0 (doc);
#line 195 "document_view.vala"
		return result;
#line 951 "document_view.c"
	}
#line 197 "document_view.vala"
	_tmp8_ = lang_code;
#line 197 "document_view.vala"
	_tmp9_ = gspell_language_lookup (_tmp8_);
#line 197 "document_view.vala"
	result = _tmp9_;
#line 197 "document_view.vala"
	_g_free0 (lang_code);
#line 197 "document_view.vala"
	_g_object_unref0 (doc);
#line 197 "document_view.vala"
	return result;
#line 965 "document_view.c"
}

static GspellChecker*
document_view_get_spell_checker (DocumentView* self)
{
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GspellTextBuffer* _tmp2_;
	GspellChecker* _tmp3_;
	GspellChecker* result = NULL;
#line 200 "document_view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 202 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 202 "document_view.vala"
	_tmp1_ = _tmp0_;
#line 202 "document_view.vala"
	_tmp2_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp1_);
#line 202 "document_view.vala"
	gspell_buffer = _tmp2_;
#line 205 "document_view.vala"
	_tmp3_ = gspell_text_buffer_get_spell_checker (gspell_buffer);
#line 205 "document_view.vala"
	result = _tmp3_;
#line 205 "document_view.vala"
	return result;
#line 993 "document_view.c"
}

void
document_view_setup_inline_spell_checker (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gboolean enabled = FALSE;
	gchar* metadata = NULL;
	Document* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp7_;
	GspellTextView* _tmp8_;
#line 208 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 210 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 210 "document_view.vala"
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
#line 210 "document_view.vala"
	doc = _tmp1_;
#line 214 "document_view.vala"
	_tmp2_ = doc;
#line 214 "document_view.vala"
	_tmp3_ = document_get_metadata (_tmp2_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL);
#line 214 "document_view.vala"
	metadata = _tmp3_;
#line 215 "document_view.vala"
	_tmp4_ = metadata;
#line 215 "document_view.vala"
	if (_tmp4_ != NULL) {
#line 1028 "document_view.c"
		const gchar* _tmp5_;
#line 216 "document_view.vala"
		_tmp5_ = metadata;
#line 216 "document_view.vala"
		enabled = g_strcmp0 (_tmp5_, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR) == 0;
#line 1034 "document_view.c"
	} else {
		GSettings* _tmp6_;
#line 218 "document_view.vala"
		_tmp6_ = self->priv->_editor_settings;
#line 218 "document_view.vala"
		enabled = g_settings_get_boolean (_tmp6_, "highlight-misspelled-words");
#line 1041 "document_view.c"
	}
#line 220 "document_view.vala"
	_tmp7_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 220 "document_view.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 220 "document_view.vala"
	gspell_view = _tmp8_;
#line 222 "document_view.vala"
	gspell_text_view_set_inline_spell_checking (gspell_view, enabled);
#line 208 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 208 "document_view.vala"
	_g_free0 (metadata);
#line 208 "document_view.vala"
	_g_object_unref0 (doc);
#line 1057 "document_view.c"
}

void
document_view_launch_spell_checker_dialog (DocumentView* self)
{
	GspellNavigator* navigator = NULL;
	GspellNavigator* _tmp0_;
	GspellNavigator* _tmp1_;
	GspellCheckerDialog* dialog = NULL;
	GtkWidget* _tmp2_;
	GspellCheckerDialog* _tmp3_;
#line 225 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 227 "document_view.vala"
	_tmp0_ = gspell_navigator_text_view_new (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 227 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 227 "document_view.vala"
	navigator = _tmp1_;
#line 229 "document_view.vala"
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 229 "document_view.vala"
	_tmp3_ = (GspellCheckerDialog*) gspell_checker_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, navigator);
#line 229 "document_view.vala"
	g_object_ref_sink (_tmp3_);
#line 229 "document_view.vala"
	dialog = _tmp3_;
#line 232 "document_view.vala"
	gtk_widget_show ((GtkWidget*) dialog);
#line 225 "document_view.vala"
	_g_object_unref0 (dialog);
#line 225 "document_view.vala"
	_g_object_unref0 (navigator);
#line 1091 "document_view.c"
}

void
document_view_launch_spell_language_chooser_dialog (DocumentView* self)
{
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_;
	GspellChecker* _tmp1_;
	GspellLanguageChooserDialog* dialog = NULL;
	GtkWidget* _tmp2_;
	GspellLanguage* _tmp3_;
	GspellLanguageChooserDialog* _tmp4_;
	GspellLanguage* lang = NULL;
	GspellLanguage* _tmp5_;
#line 235 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 237 "document_view.vala"
	_tmp0_ = document_view_get_spell_checker (self);
#line 237 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 237 "document_view.vala"
	spell_checker = _tmp1_;
#line 238 "document_view.vala"
	g_return_if_fail (spell_checker != NULL);
#line 240 "document_view.vala"
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 240 "document_view.vala"
	_tmp3_ = gspell_checker_get_language (spell_checker);
#line 240 "document_view.vala"
	_tmp4_ = (GspellLanguageChooserDialog*) gspell_language_chooser_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, _tmp3_, (GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL) | GTK_DIALOG_USE_HEADER_BAR);
#line 240 "document_view.vala"
	g_object_ref_sink (_tmp4_);
#line 240 "document_view.vala"
	dialog = _tmp4_;
#line 247 "document_view.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 249 "document_view.vala"
	_tmp5_ = gspell_language_chooser_get_language ((GspellLanguageChooser*) dialog);
#line 249 "document_view.vala"
	lang = _tmp5_;
#line 250 "document_view.vala"
	gspell_checker_set_language (spell_checker, lang);
#line 252 "document_view.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 235 "document_view.vala"
	_g_object_unref0 (dialog);
#line 235 "document_view.vala"
	_g_object_unref0 (spell_checker);
#line 1140 "document_view.c"
}

void
document_view_save_spell_language_metadata (DocumentView* self)
{
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_;
	GspellChecker* _tmp1_;
	GspellChecker* _tmp2_;
	Document* doc = NULL;
	GtkTextBuffer* _tmp3_;
	Document* _tmp4_;
	GspellLanguage* lang = NULL;
	GspellChecker* _tmp5_;
	GspellLanguage* _tmp6_;
	GspellLanguage* _tmp7_;
#line 255 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 257 "document_view.vala"
	_tmp0_ = document_view_get_spell_checker (self);
#line 257 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 257 "document_view.vala"
	spell_checker = _tmp1_;
#line 258 "document_view.vala"
	_tmp2_ = spell_checker;
#line 258 "document_view.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 260 "document_view.vala"
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 260 "document_view.vala"
	_tmp4_ = _g_object_ref0 (IS_DOCUMENT (_tmp3_) ? ((Document*) _tmp3_) : NULL);
#line 260 "document_view.vala"
	doc = _tmp4_;
#line 262 "document_view.vala"
	_tmp5_ = spell_checker;
#line 262 "document_view.vala"
	_tmp6_ = gspell_checker_get_language (_tmp5_);
#line 262 "document_view.vala"
	lang = _tmp6_;
#line 263 "document_view.vala"
	_tmp7_ = lang;
#line 263 "document_view.vala"
	if (_tmp7_ != NULL) {
#line 1185 "document_view.c"
		Document* _tmp8_;
		GspellLanguage* _tmp9_;
		const gchar* _tmp10_;
#line 264 "document_view.vala"
		_tmp8_ = doc;
#line 264 "document_view.vala"
		_tmp9_ = lang;
#line 264 "document_view.vala"
		_tmp10_ = gspell_language_get_code (_tmp9_);
#line 264 "document_view.vala"
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE, _tmp10_);
#line 1197 "document_view.c"
	} else {
		Document* _tmp11_;
#line 266 "document_view.vala"
		_tmp11_ = doc;
#line 266 "document_view.vala"
		document_set_metadata (_tmp11_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_SPELL_LANGUAGE, NULL);
#line 1204 "document_view.c"
	}
#line 255 "document_view.vala"
	_g_object_unref0 (doc);
#line 255 "document_view.vala"
	_g_object_unref0 (spell_checker);
#line 1210 "document_view.c"
}

void
document_view_save_inline_spell_metadata (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp2_;
	GspellTextView* _tmp3_;
	GspellTextView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
#line 269 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 271 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 271 "document_view.vala"
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
#line 271 "document_view.vala"
	doc = _tmp1_;
#line 273 "document_view.vala"
	_tmp2_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 273 "document_view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 273 "document_view.vala"
	gspell_view = _tmp3_;
#line 276 "document_view.vala"
	_tmp4_ = gspell_view;
#line 276 "document_view.vala"
	_tmp5_ = gspell_text_view_get_inline_spell_checking (_tmp4_);
#line 276 "document_view.vala"
	_tmp6_ = _tmp5_;
#line 276 "document_view.vala"
	if (_tmp6_) {
#line 1247 "document_view.c"
		Document* _tmp7_;
#line 278 "document_view.vala"
		_tmp7_ = doc;
#line 278 "document_view.vala"
		document_set_metadata (_tmp7_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR);
#line 1253 "document_view.c"
	} else {
		Document* _tmp8_;
#line 283 "document_view.vala"
		_tmp8_ = doc;
#line 283 "document_view.vala"
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_ATTRIBUTE_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR);
#line 1260 "document_view.c"
	}
#line 269 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 269 "document_view.vala"
	_g_object_unref0 (doc);
#line 1266 "document_view.c"
}

static void
document_view_inline_checker_enabled_notify_cb (DocumentView* self)
{
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp0_;
	GspellTextView* _tmp1_;
	GspellTextView* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp5_;
	GspellChecker* _tmp6_;
	GspellChecker* _tmp7_;
	GspellChecker* _tmp8_;
	GspellLanguage* _tmp9_;
	GspellTextView* _tmp10_;
	GtkMessageDialog* dialog = NULL;
	GtkWidget* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
	gint response = 0;
	GtkMessageDialog* _tmp14_;
	GtkMessageDialog* _tmp17_;
	GError* _inner_error0_ = NULL;
#line 288 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 290 "document_view.vala"
	_tmp0_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 290 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 290 "document_view.vala"
	gspell_view = _tmp1_;
#line 292 "document_view.vala"
	_tmp2_ = gspell_view;
#line 292 "document_view.vala"
	_tmp3_ = gspell_text_view_get_inline_spell_checking (_tmp2_);
#line 292 "document_view.vala"
	_tmp4_ = _tmp3_;
#line 292 "document_view.vala"
	if (!_tmp4_) {
#line 293 "document_view.vala"
		_g_object_unref0 (gspell_view);
#line 293 "document_view.vala"
		return;
#line 1313 "document_view.c"
	}
#line 295 "document_view.vala"
	_tmp5_ = document_view_get_spell_checker (self);
#line 295 "document_view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 295 "document_view.vala"
	spell_checker = _tmp6_;
#line 296 "document_view.vala"
	_tmp7_ = spell_checker;
#line 296 "document_view.vala"
	g_return_if_fail (_tmp7_ != NULL);
#line 298 "document_view.vala"
	_tmp8_ = spell_checker;
#line 298 "document_view.vala"
	_tmp9_ = gspell_checker_get_language (_tmp8_);
#line 298 "document_view.vala"
	if (_tmp9_ != NULL) {
#line 299 "document_view.vala"
		_g_object_unref0 (spell_checker);
#line 299 "document_view.vala"
		_g_object_unref0 (gspell_view);
#line 299 "document_view.vala"
		return;
#line 1337 "document_view.c"
	}
#line 301 "document_view.vala"
	_tmp10_ = gspell_view;
#line 301 "document_view.vala"
	gspell_text_view_set_inline_spell_checking (_tmp10_, FALSE);
#line 303 "document_view.vala"
	if (document_view__no_spell_language_dialog_shown) {
#line 304 "document_view.vala"
		_g_object_unref0 (spell_checker);
#line 304 "document_view.vala"
		_g_object_unref0 (gspell_view);
#line 304 "document_view.vala"
		return;
#line 1351 "document_view.c"
	}
#line 306 "document_view.vala"
	document_view__no_spell_language_dialog_shown = TRUE;
#line 308 "document_view.vala"
	_tmp11_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 308 "document_view.vala"
	_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp11_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _ ("No dictionaries available for the spell-checking."));
#line 308 "document_view.vala"
	g_object_ref_sink (_tmp12_);
#line 308 "document_view.vala"
	dialog = _tmp12_;
#line 314 "document_view.vala"
	_tmp13_ = dialog;
#line 314 "document_view.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp13_, _ ("_Help"), GTK_RESPONSE_HELP, _ ("_OK"), GTK_RESPONSE_OK, NULL, NULL);
#line 318 "document_view.vala"
	_tmp14_ = dialog;
#line 318 "document_view.vala"
	response = gtk_dialog_run ((GtkDialog*) _tmp14_);
#line 320 "document_view.vala"
	if (response == ((gint) GTK_RESPONSE_HELP)) {
#line 1373 "document_view.c"
		{
#line 324 "document_view.vala"
			latexila_utils_show_uri ((GtkWidget*) self, "help:latexila/spell_checking", (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 324 "document_view.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1379 "document_view.c"
				goto __catch17_g_error;
			}
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
#line 322 "document_view.vala"
			e = _inner_error0_;
#line 322 "document_view.vala"
			_inner_error0_ = NULL;
#line 329 "document_view.vala"
			_tmp15_ = e;
#line 329 "document_view.vala"
			_tmp16_ = _tmp15_->message;
#line 329 "document_view.vala"
			g_warning ("document_view.vala:329: Impossible to open the documentation: %s", _tmp16_);
#line 322 "document_view.vala"
			_g_error_free0 (e);
#line 1401 "document_view.c"
		}
		__finally17:
#line 322 "document_view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 322 "document_view.vala"
			_g_object_unref0 (dialog);
#line 322 "document_view.vala"
			_g_object_unref0 (spell_checker);
#line 322 "document_view.vala"
			_g_object_unref0 (gspell_view);
#line 322 "document_view.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 322 "document_view.vala"
			g_clear_error (&_inner_error0_);
#line 322 "document_view.vala"
			return;
#line 1418 "document_view.c"
		}
	}
#line 333 "document_view.vala"
	_tmp17_ = dialog;
#line 333 "document_view.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
#line 288 "document_view.vala"
	_g_object_unref0 (dialog);
#line 288 "document_view.vala"
	_g_object_unref0 (spell_checker);
#line 288 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 1431 "document_view.c"
}

static void
document_view_class_init (DocumentViewClass * klass,
                          gpointer klass_data)
{
#line 22 "document_view.vala"
	document_view_parent_class = g_type_class_peek_parent (klass);
#line 22 "document_view.vala"
	g_type_class_adjust_private_offset (klass, &DocumentView_private_offset);
#line 22 "document_view.vala"
	G_OBJECT_CLASS (klass)->finalize = document_view_finalize;
#line 1444 "document_view.c"
}

static void
document_view_instance_init (DocumentView * self,
                             gpointer klass)
{
#line 22 "document_view.vala"
	self->priv = document_view_get_instance_private (self);
#line 1453 "document_view.c"
}

static void
document_view_finalize (GObject * obj)
{
	DocumentView * self;
#line 22 "document_view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_VIEW, DocumentView);
#line 31 "document_view.vala"
	_g_object_unref0 (self->priv->_editor_settings);
#line 32 "document_view.vala"
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
#line 22 "document_view.vala"
	G_OBJECT_CLASS (document_view_parent_class)->finalize (obj);
#line 1468 "document_view.c"
}

GType
document_view_get_type (void)
{
	static volatile gsize document_view_type_id__volatile = 0;
	if (g_once_init_enter (&document_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentView), 0, (GInstanceInitFunc) document_view_instance_init, NULL };
		GType document_view_type_id;
		document_view_type_id = g_type_register_static (tepl_view_get_type (), "DocumentView", &g_define_type_info, 0);
		DocumentView_private_offset = g_type_add_instance_private (document_view_type_id, sizeof (DocumentViewPrivate));
		g_once_init_leave (&document_view_type_id__volatile, document_view_type_id);
	}
	return document_view_type_id__volatile;
}

