/* document.c generated by valac 0.46.6, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib/gstdio.h>

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
enum  {
	DOCUMENT_0_PROPERTY,
	DOCUMENT_LOCATION_PROPERTY,
	DOCUMENT_READONLY_PROPERTY,
	DOCUMENT_PROJECT_ID_PROPERTY,
	DOCUMENT_NUM_PROPERTIES
};
static GParamSpec* document_properties[DOCUMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
	GFileInfo* _metadata_info;
};

struct _Block15Data {
	int _ref_count_;
	Document* self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

static gint Document_private_offset;
static gpointer document_parent_class = NULL;

GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
GType document_structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentStructure, g_object_unref)
Document* document_new (void);
Document* document_construct (GType object_type);
static void __lambda43_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda43__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda44_ (Document* self);
static void ___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* document_tab_get_document_view (DocumentTab* self);
static gboolean __lambda38_ (Block15Data* _data15_);
static gboolean ___lambda38__gsource_func (gpointer self);
void document_load (Document* self,
                    GFile* location);
void document_set_location (Document* self,
                            GFile* value);
void document_set_contents (Document* self,
                            const gchar* contents);
static gchar* document_to_utf8 (Document* self,
                         const gchar* text,
                         GError** error);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
GFile* document_get_location (Document* self);
static void document_save_metadata (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda16_ (Block16Data* _data16_,
                    gint response_id);
static void _____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                           gint response_id,
                                           gpointer self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
Projects* projects_get_default (void);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self,
                              gint value);
gchar* document_get_uri_for_display (Document* self);
gchar* document_get_short_name_for_display (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
void document_uncomment_selected_lines (Document* self);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self,
                       gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
void document_structure_parse (DocumentStructure* self);
gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda27_ (Block17Data* _data17_,
                  gint response_id);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
static void ___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                         gint response_id,
                                         gpointer self);
void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
gchar* document_get_metadata (Document* self,
                              const gchar* key);
gboolean document_get_readonly (Document* self);
void document_set_readonly (Document* self,
                            gboolean value);
static void document_finalize (GObject * obj);
static void _vala_document_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_document_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

static inline gpointer
document_get_instance_private (Document* self)
{
	return G_STRUCT_MEMBER_P (self, Document_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 38 "document.vala"
	return self ? g_object_ref (self) : NULL;
#line 302 "document.c"
}

static void
__lambda43_ (Document* self)
{
#line 43 "document.vala"
	document_update_syntax_highlighting (self);
#line 44 "document.vala"
	document_update_project_id (self);
#line 312 "document.c"
}

static void
___lambda43__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 41 "document.vala"
	__lambda43_ ((Document*) self);
#line 322 "document.c"
}

static void
__lambda44_ (Document* self)
{
#line 49 "document.vala"
	self->priv->new_file = FALSE;
#line 330 "document.c"
}

static void
___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
#line 47 "document.vala"
	__lambda44_ ((Document*) self);
#line 339 "document.c"
}

Document*
document_construct (GType object_type)
{
	Document * self = NULL;
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	GSettings* editor_settings = NULL;
	GSettings* _tmp3_;
	TeplFile* _tmp4_;
#line 35 "document.vala"
	self = (Document*) g_object_new (object_type, NULL);
#line 38 "document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 38 "document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "document.vala"
	lm = _tmp1_;
#line 39 "document.vala"
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
#line 39 "document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
#line 41 "document.vala"
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda43__g_object_notify, self, 0);
#line 47 "document.vala"
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda44__gtk_text_buffer_changed, self, 0);
#line 52 "document.vala"
	_tmp3_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 52 "document.vala"
	editor_settings = _tmp3_;
#line 54 "document.vala"
	g_settings_bind (editor_settings, "scheme", (GObject*) self, "tepl-style-scheme-id", G_SETTINGS_BIND_GET);
#line 59 "document.vala"
	_tmp4_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 59 "document.vala"
	g_object_bind_property_with_closures ((GObject*) self, "location", (GObject*) _tmp4_, "location", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 35 "document.vala"
	_g_object_unref0 (editor_settings);
#line 35 "document.vala"
	_g_object_unref0 (lm);
#line 35 "document.vala"
	return self;
#line 385 "document.c"
}

Document*
document_new (void)
{
#line 35 "document.vala"
	return document_construct (TYPE_DOCUMENT);
#line 393 "document.c"
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
#line 63 "document.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 63 "document.vala"
	return _data15_;
#line 403 "document.c"
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 63 "document.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 413 "document.c"
		Document* self;
#line 63 "document.vala"
		self = _data15_->self;
#line 63 "document.vala"
		_g_object_unref0 (_data15_->completion);
#line 63 "document.vala"
		_g_object_unref0 (self);
#line 63 "document.vala"
		g_slice_free (Block15Data, _data15_);
#line 423 "document.c"
	}
}

static gboolean
__lambda38_ (Block15Data* _data15_)
{
	Document* self;
	GtkSourceCompletion* _tmp0_;
	gboolean result = FALSE;
#line 77 "document.vala"
	self = _data15_->self;
#line 79 "document.vala"
	_tmp0_ = _data15_->completion;
#line 79 "document.vala"
	if (_tmp0_ != NULL) {
#line 439 "document.c"
		GtkSourceCompletion* _tmp1_;
#line 80 "document.vala"
		_tmp1_ = _data15_->completion;
#line 80 "document.vala"
		gtk_source_completion_unblock_interactive (_tmp1_);
#line 445 "document.c"
	}
#line 82 "document.vala"
	result = FALSE;
#line 82 "document.vala"
	return result;
#line 451 "document.c"
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ (self);
#line 77 "document.vala"
	return result;
#line 461 "document.c"
}

void
document_insert (Document* self,
                 GtkTextIter* iter,
                 const gchar* text,
                 gint len)
{
	Block15Data* _data15_;
	DocumentTab* _tmp0_;
#line 63 "document.vala"
	g_return_if_fail (self != NULL);
#line 63 "document.vala"
	g_return_if_fail (iter != NULL);
#line 63 "document.vala"
	g_return_if_fail (text != NULL);
#line 63 "document.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 63 "document.vala"
	_data15_->_ref_count_ = 1;
#line 63 "document.vala"
	_data15_->self = g_object_ref (self);
#line 65 "document.vala"
	_data15_->completion = NULL;
#line 67 "document.vala"
	_tmp0_ = self->tab;
#line 67 "document.vala"
	if (_tmp0_ != NULL) {
#line 490 "document.c"
		DocumentTab* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		GtkSourceCompletion* _tmp7_;
#line 69 "document.vala"
		_tmp1_ = self->tab;
#line 69 "document.vala"
		_tmp2_ = document_tab_get_document_view (_tmp1_);
#line 69 "document.vala"
		_tmp3_ = _tmp2_;
#line 69 "document.vala"
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
#line 69 "document.vala"
		_tmp5_ = _tmp4_;
#line 69 "document.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 69 "document.vala"
		_g_object_unref0 (_data15_->completion);
#line 69 "document.vala"
		_data15_->completion = _tmp6_;
#line 70 "document.vala"
		_tmp7_ = _data15_->completion;
#line 70 "document.vala"
		gtk_source_completion_block_interactive (_tmp7_);
#line 518 "document.c"
	}
#line 73 "document.vala"
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, tepl_buffer_get_type (), TeplBuffer), iter, text, len);
#line 77 "document.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda38__gsource_func, block15_data_ref (_data15_), block15_data_unref);
#line 63 "document.vala"
	block15_data_unref (_data15_);
#line 63 "document.vala"
	_data15_ = NULL;
#line 528 "document.c"
}

void
document_load (Document* self,
               GFile* location)
{
	GError* _inner_error0_ = NULL;
#line 86 "document.vala"
	g_return_if_fail (self != NULL);
#line 86 "document.vala"
	g_return_if_fail (location != NULL);
#line 540 "document.c"
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
#line 92 "document.vala"
		_tmp1_ = g_file_query_info (location, "metadata::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 92 "document.vala"
		_tmp0_ = _tmp1_;
#line 92 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 551 "document.c"
			goto __catch8_g_error;
		}
#line 92 "document.vala"
		_tmp2_ = _tmp0_;
#line 92 "document.vala"
		_tmp0_ = NULL;
#line 92 "document.vala"
		_g_object_unref0 (self->priv->_metadata_info);
#line 92 "document.vala"
		self->priv->_metadata_info = _tmp2_;
#line 90 "document.vala"
		_g_object_unref0 (_tmp0_);
#line 564 "document.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GFileInfo* _tmp5_;
#line 90 "document.vala"
		e = _inner_error0_;
#line 90 "document.vala"
		_inner_error0_ = NULL;
#line 96 "document.vala"
		_tmp3_ = e;
#line 96 "document.vala"
		_tmp4_ = _tmp3_->message;
#line 96 "document.vala"
		g_warning ("document.vala:96: Get document metadata failed: %s", _tmp4_);
#line 97 "document.vala"
		_tmp5_ = g_file_info_new ();
#line 97 "document.vala"
		_g_object_unref0 (self->priv->_metadata_info);
#line 97 "document.vala"
		self->priv->_metadata_info = _tmp5_;
#line 90 "document.vala"
		_g_error_free0 (e);
#line 591 "document.c"
	}
	__finally8:
#line 90 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 90 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 90 "document.vala"
		g_clear_error (&_inner_error0_);
#line 90 "document.vala"
		return;
#line 602 "document.c"
	}
#line 100 "document.vala"
	document_set_location (self, location);
#line 606 "document.c"
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp6_ = NULL;
		gsize _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		gchar* text = NULL;
		guint8* _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		GtkRecentManager* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 105 "document.vala"
		g_file_load_contents (location, NULL, &_tmp6_, &_tmp7_, &_tmp8_, &_inner_error0_);
#line 105 "document.vala"
		chars = (g_free (chars), NULL);
#line 105 "document.vala"
		chars = _tmp6_;
#line 105 "document.vala"
		chars_length1 = _tmp7_;
#line 105 "document.vala"
		_chars_size_ = chars_length1;
#line 105 "document.vala"
		_g_free0 (self->priv->_etag);
#line 105 "document.vala"
		self->priv->_etag = _tmp8_;
#line 105 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 105 "document.vala"
			chars = (g_free (chars), NULL);
#line 639 "document.c"
			goto __catch9_g_error;
		}
#line 106 "document.vala"
		_tmp9_ = chars;
#line 106 "document.vala"
		_tmp9__length1 = chars_length1;
#line 106 "document.vala"
		chars = NULL;
#line 106 "document.vala"
		chars_length1 = 0;
#line 106 "document.vala"
		text = (gchar*) _tmp9_;
#line 108 "document.vala"
		_tmp10_ = text;
#line 108 "document.vala"
		if (g_utf8_validate (_tmp10_, (gssize) -1, NULL)) {
#line 656 "document.c"
			const gchar* _tmp11_;
#line 109 "document.vala"
			_tmp11_ = text;
#line 109 "document.vala"
			document_set_contents (self, _tmp11_);
#line 662 "document.c"
		} else {
			gchar* utf8_text = NULL;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
#line 114 "document.vala"
			_tmp12_ = text;
#line 114 "document.vala"
			_tmp13_ = document_to_utf8 (self, _tmp12_, &_inner_error0_);
#line 114 "document.vala"
			utf8_text = _tmp13_;
#line 114 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 114 "document.vala"
				_g_free0 (text);
#line 114 "document.vala"
				chars = (g_free (chars), NULL);
#line 680 "document.c"
				goto __catch9_g_error;
			}
#line 115 "document.vala"
			_tmp14_ = utf8_text;
#line 115 "document.vala"
			document_set_contents (self, _tmp14_);
#line 108 "document.vala"
			_g_free0 (utf8_text);
#line 689 "document.c"
		}
#line 118 "document.vala"
		document_update_syntax_highlighting (self);
#line 120 "document.vala"
		_tmp15_ = gtk_recent_manager_get_default ();
#line 120 "document.vala"
		_tmp16_ = g_file_get_uri (location);
#line 120 "document.vala"
		_tmp17_ = _tmp16_;
#line 120 "document.vala"
		gtk_recent_manager_add_item (_tmp15_, _tmp17_);
#line 120 "document.vala"
		_g_free0 (_tmp17_);
#line 102 "document.vala"
		_g_free0 (text);
#line 102 "document.vala"
		chars = (g_free (chars), NULL);
#line 707 "document.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		DocumentTab* _tmp20_;
#line 102 "document.vala"
		e = _inner_error0_;
#line 102 "document.vala"
		_inner_error0_ = NULL;
#line 124 "document.vala"
		_tmp18_ = e;
#line 124 "document.vala"
		_tmp19_ = _tmp18_->message;
#line 124 "document.vala"
		g_warning ("document.vala:124: %s", _tmp19_);
#line 126 "document.vala"
		_tmp20_ = self->tab;
#line 126 "document.vala"
		if (_tmp20_ != NULL) {
#line 730 "document.c"
			gchar* primary_msg = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			TeplInfoBar* infobar = NULL;
			const gchar* _tmp25_;
			GError* _tmp26_;
			const gchar* _tmp27_;
			TeplInfoBar* _tmp28_;
			DocumentTab* _tmp29_;
			TeplInfoBar* _tmp30_;
			TeplInfoBar* _tmp31_;
#line 128 "document.vala"
			_tmp21_ = g_file_get_parse_name (location);
#line 128 "document.vala"
			_tmp22_ = _tmp21_;
#line 128 "document.vala"
			_tmp23_ = g_strdup_printf (_ ("Impossible to load the file “%s”."), _tmp22_);
#line 128 "document.vala"
			_tmp24_ = _tmp23_;
#line 128 "document.vala"
			_g_free0 (_tmp22_);
#line 128 "document.vala"
			primary_msg = _tmp24_;
#line 130 "document.vala"
			_tmp25_ = primary_msg;
#line 130 "document.vala"
			_tmp26_ = e;
#line 130 "document.vala"
			_tmp27_ = _tmp26_->message;
#line 130 "document.vala"
			_tmp28_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp25_, _tmp27_);
#line 130 "document.vala"
			g_object_ref_sink (_tmp28_);
#line 130 "document.vala"
			infobar = _tmp28_;
#line 132 "document.vala"
			_tmp29_ = self->tab;
#line 132 "document.vala"
			_tmp30_ = infobar;
#line 132 "document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp29_, (GtkInfoBar*) _tmp30_);
#line 133 "document.vala"
			_tmp31_ = infobar;
#line 133 "document.vala"
			gtk_widget_show ((GtkWidget*) _tmp31_);
#line 126 "document.vala"
			_g_object_unref0 (infobar);
#line 126 "document.vala"
			_g_free0 (primary_msg);
#line 782 "document.c"
		}
#line 102 "document.vala"
		_g_error_free0 (e);
#line 786 "document.c"
	}
	__finally9:
#line 102 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 102 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 102 "document.vala"
		g_clear_error (&_inner_error0_);
#line 102 "document.vala"
		return;
#line 797 "document.c"
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 815 "document.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1428 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1429 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1429 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1429 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1430 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1431 "glib-2.0.vapi"
		start = string_length + start;
#line 842 "document.c"
	}
#line 1433 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1434 "glib-2.0.vapi"
		end = string_length + end;
#line 848 "document.c"
	}
#line 1436 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 854 "document.c"
	} else {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 858 "document.c"
	}
#line 1436 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1437 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 866 "document.c"
	} else {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 870 "document.c"
	}
#line 1437 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1438 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1439 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1439 "glib-2.0.vapi"
	result = _tmp4_;
#line 1439 "glib-2.0.vapi"
	return result;
#line 882 "document.c"
}

void
document_set_contents (Document* self,
                       const gchar* contents)
{
	gchar* contents2 = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
#line 138 "document.vala"
	g_return_if_fail (self != NULL);
#line 138 "document.vala"
	g_return_if_fail (contents != NULL);
#line 141 "document.vala"
	contents2 = NULL;
#line 142 "document.vala"
	_tmp0_ = strlen (contents);
#line 142 "document.vala"
	_tmp1_ = _tmp0_;
#line 142 "document.vala"
	if (string_get (contents, (glong) (_tmp1_ - 1)) == '\n') {
#line 909 "document.c"
		gchar* _tmp2_;
#line 143 "document.vala"
		_tmp2_ = string_slice (contents, (glong) 0, (glong) -1);
#line 143 "document.vala"
		_g_free0 (contents2);
#line 143 "document.vala"
		contents2 = _tmp2_;
#line 917 "document.c"
	}
#line 145 "document.vala"
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
#line 146 "document.vala"
	_tmp4_ = contents2;
#line 146 "document.vala"
	_tmp3_ = _tmp4_;
#line 146 "document.vala"
	if (_tmp3_ == NULL) {
#line 146 "document.vala"
		_tmp3_ = contents;
#line 929 "document.c"
	}
#line 146 "document.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp3_, -1);
#line 147 "document.vala"
	self->priv->new_file = TRUE;
#line 148 "document.vala"
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 149 "document.vala"
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
#line 153 "document.vala"
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp5_);
#line 153 "document.vala"
	iter = _tmp5_;
#line 154 "document.vala"
	_tmp6_ = iter;
#line 154 "document.vala"
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
#line 138 "document.vala"
	_g_free0 (contents2);
#line 949 "document.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1518 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1519 "glib-2.0.vapi"
	result = self;
#line 1519 "glib-2.0.vapi"
	return result;
#line 962 "document.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1503 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1504 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1504 "glib-2.0.vapi"
	res_length1 = -1;
#line 1504 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1505 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1505 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1505 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1506 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1506 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1506 "glib-2.0.vapi"
	if (result_length1) {
#line 1506 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 999 "document.c"
	}
#line 1506 "glib-2.0.vapi"
	result = _tmp2_;
#line 1506 "glib-2.0.vapi"
	return result;
#line 1005 "document.c"
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
#line 208 "document.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 208 "document.vala"
	return _data16_;
#line 1015 "document.c"
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 208 "document.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1025 "document.c"
		Document* self;
#line 208 "document.vala"
		self = _data16_->self;
#line 208 "document.vala"
		_g_object_unref0 (_data16_->infobar);
#line 208 "document.vala"
		_g_object_unref0 (self);
#line 208 "document.vala"
		g_slice_free (Block16Data, _data16_);
#line 1035 "document.c"
	}
}

static void
____lambda16_ (Block16Data* _data16_,
               gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp0_;
#line 222 "document.vala"
	self = _data16_->self;
#line 224 "document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 225 "document.vala"
		document_save (self, FALSE, FALSE);
#line 1051 "document.c"
	}
#line 226 "document.vala"
	_tmp0_ = _data16_->infobar;
#line 226 "document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1057 "document.c"
}

static void
_____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                      gint response_id,
                                      gpointer self)
{
#line 222 "document.vala"
	____lambda16_ (self, response_id);
#line 1067 "document.c"
}

void
document_save (Document* self,
               gboolean check_file_changed_on_disk,
               gboolean force)
{
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GError* _inner_error0_ = NULL;
#line 157 "document.vala"
	g_return_if_fail (self != NULL);
#line 159 "document.vala"
	_tmp0_ = self->priv->_location;
#line 159 "document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 162 "document.vala"
	if (!force) {
#line 162 "document.vala"
		_tmp2_ = !self->priv->new_file;
#line 1101 "document.c"
	} else {
#line 162 "document.vala"
		_tmp2_ = FALSE;
#line 1105 "document.c"
	}
#line 162 "document.vala"
	if (_tmp2_) {
#line 162 "document.vala"
		_tmp1_ = !gtk_text_buffer_get_modified ((GtkTextBuffer*) self);
#line 1111 "document.c"
	} else {
#line 162 "document.vala"
		_tmp1_ = FALSE;
#line 1115 "document.c"
	}
#line 162 "document.vala"
	if (_tmp1_) {
#line 163 "document.vala"
		return;
#line 1121 "document.c"
	}
#line 167 "document.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
#line 167 "document.vala"
	start = _tmp3_;
#line 167 "document.vala"
	end = _tmp4_;
#line 168 "document.vala"
	_tmp5_ = start;
#line 168 "document.vala"
	_tmp6_ = end;
#line 168 "document.vala"
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
#line 168 "document.vala"
	text = _tmp7_;
#line 171 "document.vala"
	_tmp8_ = text;
#line 171 "document.vala"
	_tmp9_ = text;
#line 171 "document.vala"
	_tmp10_ = strlen (_tmp9_);
#line 171 "document.vala"
	_tmp11_ = _tmp10_;
#line 171 "document.vala"
	if (string_get (_tmp8_, (glong) (_tmp11_ - 1)) != '\n') {
#line 1147 "document.c"
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
#line 172 "document.vala"
		_tmp12_ = text;
#line 172 "document.vala"
		_tmp13_ = string_to_string (_tmp12_);
#line 172 "document.vala"
		_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
#line 172 "document.vala"
		_g_free0 (text);
#line 172 "document.vala"
		text = _tmp14_;
#line 1161 "document.c"
	}
	{
		GSettings* settings = NULL;
		GSettings* _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean make_backup = FALSE;
		const gchar* _tmp18_ = NULL;
		gchar* etag = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* parent = NULL;
		GFile* _tmp37_;
		GFile* _tmp38_;
		gboolean _tmp39_ = FALSE;
		GFile* _tmp40_;
		GFile* _tmp43_;
		const gchar* _tmp44_;
		guint8* _tmp45_;
		gint _tmp45__length1;
		guint8* _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		gchar* _tmp48_ = NULL;
		GtkRecentManager* _tmp49_;
		GFile* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
#line 176 "document.vala"
		_tmp15_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 176 "document.vala"
		settings = _tmp15_;
#line 178 "document.vala"
		if (!self->priv->backup_made) {
#line 1195 "document.c"
			GSettings* _tmp17_;
#line 179 "document.vala"
			_tmp17_ = settings;
#line 179 "document.vala"
			_tmp16_ = g_settings_get_boolean (_tmp17_, "create-backup-copy");
#line 1201 "document.c"
		} else {
#line 178 "document.vala"
			_tmp16_ = FALSE;
#line 1205 "document.c"
		}
#line 178 "document.vala"
		make_backup = _tmp16_;
#line 181 "document.vala"
		if (check_file_changed_on_disk) {
#line 1211 "document.c"
			const gchar* _tmp19_;
#line 181 "document.vala"
			_tmp19_ = self->priv->_etag;
#line 181 "document.vala"
			_tmp18_ = _tmp19_;
#line 1217 "document.c"
		} else {
#line 181 "document.vala"
			_tmp18_ = NULL;
#line 1221 "document.c"
		}
#line 181 "document.vala"
		_tmp20_ = g_strdup (_tmp18_);
#line 181 "document.vala"
		etag = _tmp20_;
#line 184 "document.vala"
		_tmp21_ = self->priv->encoding;
#line 184 "document.vala"
		if (_tmp21_ != NULL) {
#line 1231 "document.c"
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
#line 185 "document.vala"
			_tmp23_ = text;
#line 185 "document.vala"
			_tmp24_ = text;
#line 185 "document.vala"
			_tmp25_ = strlen (_tmp24_);
#line 185 "document.vala"
			_tmp26_ = _tmp25_;
#line 185 "document.vala"
			_tmp27_ = self->priv->encoding;
#line 185 "document.vala"
			_tmp28_ = g_convert (_tmp23_, (gssize) _tmp26_, _tmp27_, "UTF-8", NULL, NULL, &_inner_error0_);
#line 185 "document.vala"
			_tmp22_ = _tmp28_;
#line 185 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "document.vala"
				_g_free0 (etag);
#line 185 "document.vala"
				_g_object_unref0 (settings);
#line 1260 "document.c"
				goto __catch10_g_error;
			}
#line 185 "document.vala"
			_tmp29_ = _tmp22_;
#line 185 "document.vala"
			_tmp22_ = NULL;
#line 185 "document.vala"
			_g_free0 (text);
#line 185 "document.vala"
			text = _tmp29_;
#line 184 "document.vala"
			_g_free0 (_tmp22_);
#line 1273 "document.c"
		} else {
			gchar* _tmp30_ = NULL;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
#line 189 "document.vala"
			_tmp31_ = text;
#line 189 "document.vala"
			_tmp32_ = text;
#line 189 "document.vala"
			_tmp33_ = strlen (_tmp32_);
#line 189 "document.vala"
			_tmp34_ = _tmp33_;
#line 189 "document.vala"
			_tmp35_ = g_filename_from_utf8 (_tmp31_, (gssize) _tmp34_, NULL, NULL, &_inner_error0_);
#line 189 "document.vala"
			_tmp30_ = _tmp35_;
#line 189 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 189 "document.vala"
				_g_free0 (etag);
#line 189 "document.vala"
				_g_object_unref0 (settings);
#line 1300 "document.c"
				goto __catch10_g_error;
			}
#line 189 "document.vala"
			_tmp36_ = _tmp30_;
#line 189 "document.vala"
			_tmp30_ = NULL;
#line 189 "document.vala"
			_g_free0 (text);
#line 189 "document.vala"
			text = _tmp36_;
#line 184 "document.vala"
			_g_free0 (_tmp30_);
#line 1313 "document.c"
		}
#line 192 "document.vala"
		_tmp37_ = self->priv->_location;
#line 192 "document.vala"
		_tmp38_ = g_file_get_parent (_tmp37_);
#line 192 "document.vala"
		parent = _tmp38_;
#line 193 "document.vala"
		_tmp40_ = parent;
#line 193 "document.vala"
		if (_tmp40_ != NULL) {
#line 1325 "document.c"
			GFile* _tmp41_;
#line 193 "document.vala"
			_tmp41_ = parent;
#line 193 "document.vala"
			_tmp39_ = !g_file_query_exists (_tmp41_, NULL);
#line 1331 "document.c"
		} else {
#line 193 "document.vala"
			_tmp39_ = FALSE;
#line 1335 "document.c"
		}
#line 193 "document.vala"
		if (_tmp39_) {
#line 1339 "document.c"
			GFile* _tmp42_;
#line 194 "document.vala"
			_tmp42_ = parent;
#line 194 "document.vala"
			g_file_make_directory_with_parents (_tmp42_, NULL, &_inner_error0_);
#line 194 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 194 "document.vala"
				_g_object_unref0 (parent);
#line 194 "document.vala"
				_g_free0 (etag);
#line 194 "document.vala"
				_g_object_unref0 (settings);
#line 1353 "document.c"
				goto __catch10_g_error;
			}
		}
#line 196 "document.vala"
		_tmp43_ = self->priv->_location;
#line 196 "document.vala"
		_tmp44_ = text;
#line 196 "document.vala"
		_tmp45_ = string_get_data (_tmp44_, &_tmp45__length1);
#line 196 "document.vala"
		_tmp46_ = _tmp45_;
#line 196 "document.vala"
		_tmp46__length1 = _tmp45__length1;
#line 196 "document.vala"
		_tmp47_ = etag;
#line 196 "document.vala"
		g_file_replace_contents (_tmp43_, _tmp46_, (gsize) _tmp46__length1, _tmp47_, make_backup, G_FILE_CREATE_NONE, &_tmp48_, NULL, &_inner_error0_);
#line 196 "document.vala"
		_g_free0 (self->priv->_etag);
#line 196 "document.vala"
		self->priv->_etag = _tmp48_;
#line 196 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 196 "document.vala"
			_g_object_unref0 (parent);
#line 196 "document.vala"
			_g_free0 (etag);
#line 196 "document.vala"
			_g_object_unref0 (settings);
#line 1383 "document.c"
			goto __catch10_g_error;
		}
#line 199 "document.vala"
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 201 "document.vala"
		_tmp49_ = gtk_recent_manager_get_default ();
#line 201 "document.vala"
		_tmp50_ = self->priv->_location;
#line 201 "document.vala"
		_tmp51_ = g_file_get_uri (_tmp50_);
#line 201 "document.vala"
		_tmp52_ = _tmp51_;
#line 201 "document.vala"
		gtk_recent_manager_add_item (_tmp49_, _tmp52_);
#line 201 "document.vala"
		_g_free0 (_tmp52_);
#line 202 "document.vala"
		self->priv->backup_made = TRUE;
#line 204 "document.vala"
		document_save_metadata (self);
#line 174 "document.vala"
		_g_object_unref0 (parent);
#line 174 "document.vala"
		_g_free0 (etag);
#line 174 "document.vala"
		_g_object_unref0 (settings);
#line 1410 "document.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		gboolean _tmp53_ = FALSE;
		GError* _tmp54_;
#line 174 "document.vala"
		e = _inner_error0_;
#line 174 "document.vala"
		_inner_error0_ = NULL;
#line 208 "document.vala"
		_tmp54_ = e;
#line 208 "document.vala"
		if (g_error_matches (_tmp54_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
#line 1426 "document.c"
			DocumentTab* _tmp55_;
#line 208 "document.vala"
			_tmp55_ = self->tab;
#line 208 "document.vala"
			_tmp53_ = _tmp55_ != NULL;
#line 1432 "document.c"
		} else {
#line 208 "document.vala"
			_tmp53_ = FALSE;
#line 1436 "document.c"
		}
#line 208 "document.vala"
		if (_tmp53_) {
#line 1440 "document.c"
			Block16Data* _data16_;
			gchar* primary_msg = NULL;
			GFile* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* secondary_msg = NULL;
			gchar* _tmp61_;
			const gchar* _tmp62_;
			const gchar* _tmp63_;
			TeplInfoBar* _tmp64_;
			TeplInfoBar* _tmp65_;
			TeplInfoBar* _tmp66_;
			DocumentTab* _tmp67_;
			TeplInfoBar* _tmp68_;
			TeplInfoBar* _tmp69_;
			TeplInfoBar* _tmp70_;
#line 208 "document.vala"
			_data16_ = g_slice_new0 (Block16Data);
#line 208 "document.vala"
			_data16_->_ref_count_ = 1;
#line 208 "document.vala"
			_data16_->self = g_object_ref (self);
#line 210 "document.vala"
			_tmp56_ = self->priv->_location;
#line 210 "document.vala"
			_tmp57_ = g_file_get_parse_name (_tmp56_);
#line 210 "document.vala"
			_tmp58_ = _tmp57_;
#line 210 "document.vala"
			_tmp59_ = g_strdup_printf (_ ("The file %s has been modified since reading it."), _tmp58_);
#line 210 "document.vala"
			_tmp60_ = _tmp59_;
#line 210 "document.vala"
			_g_free0 (_tmp58_);
#line 210 "document.vala"
			primary_msg = _tmp60_;
#line 212 "document.vala"
			_tmp61_ = g_strdup (_ ("If you save it, all the external changes could be lost. Save it anyway" \
"?"));
#line 212 "document.vala"
			secondary_msg = _tmp61_;
#line 215 "document.vala"
			_tmp62_ = primary_msg;
#line 215 "document.vala"
			_tmp63_ = secondary_msg;
#line 215 "document.vala"
			_tmp64_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp62_, _tmp63_);
#line 215 "document.vala"
			g_object_ref_sink (_tmp64_);
#line 215 "document.vala"
			_data16_->infobar = _tmp64_;
#line 217 "document.vala"
			_tmp65_ = _data16_->infobar;
#line 217 "document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp65_, _ ("_Save Anyway"), (gint) GTK_RESPONSE_YES);
#line 218 "document.vala"
			_tmp66_ = _data16_->infobar;
#line 218 "document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp66_, _ ("_Don’t Save"), (gint) GTK_RESPONSE_CANCEL);
#line 219 "document.vala"
			_tmp67_ = self->tab;
#line 219 "document.vala"
			_tmp68_ = _data16_->infobar;
#line 219 "document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp67_, (GtkInfoBar*) _tmp68_);
#line 220 "document.vala"
			_tmp69_ = _data16_->infobar;
#line 220 "document.vala"
			gtk_widget_show ((GtkWidget*) _tmp69_);
#line 222 "document.vala"
			_tmp70_ = _data16_->infobar;
#line 222 "document.vala"
			g_signal_connect_data ((GtkInfoBar*) _tmp70_, "response", (GCallback) _____lambda16__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 208 "document.vala"
			_g_free0 (secondary_msg);
#line 208 "document.vala"
			_g_free0 (primary_msg);
#line 208 "document.vala"
			block16_data_unref (_data16_);
#line 208 "document.vala"
			_data16_ = NULL;
#line 1523 "document.c"
		} else {
			GError* _tmp71_;
			const gchar* _tmp72_;
			DocumentTab* _tmp73_;
#line 231 "document.vala"
			_tmp71_ = e;
#line 231 "document.vala"
			_tmp72_ = _tmp71_->message;
#line 231 "document.vala"
			g_warning ("document.vala:231: %s", _tmp72_);
#line 233 "document.vala"
			_tmp73_ = self->tab;
#line 233 "document.vala"
			if (_tmp73_ != NULL) {
#line 1538 "document.c"
				gchar* primary_msg = NULL;
				gchar* _tmp74_;
				TeplInfoBar* infobar = NULL;
				const gchar* _tmp75_;
				GError* _tmp76_;
				const gchar* _tmp77_;
				TeplInfoBar* _tmp78_;
				TeplInfoBar* _tmp79_;
				DocumentTab* _tmp80_;
				TeplInfoBar* _tmp81_;
				TeplInfoBar* _tmp82_;
#line 235 "document.vala"
				_tmp74_ = g_strdup (_ ("Impossible to save the file."));
#line 235 "document.vala"
				primary_msg = _tmp74_;
#line 236 "document.vala"
				_tmp75_ = primary_msg;
#line 236 "document.vala"
				_tmp76_ = e;
#line 236 "document.vala"
				_tmp77_ = _tmp76_->message;
#line 236 "document.vala"
				_tmp78_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp75_, _tmp77_);
#line 236 "document.vala"
				g_object_ref_sink (_tmp78_);
#line 236 "document.vala"
				infobar = _tmp78_;
#line 238 "document.vala"
				_tmp79_ = infobar;
#line 238 "document.vala"
				tepl_info_bar_add_close_button (_tmp79_);
#line 239 "document.vala"
				_tmp80_ = self->tab;
#line 239 "document.vala"
				_tmp81_ = infobar;
#line 239 "document.vala"
				tepl_tab_add_info_bar ((TeplTab*) _tmp80_, (GtkInfoBar*) _tmp81_);
#line 240 "document.vala"
				_tmp82_ = infobar;
#line 240 "document.vala"
				gtk_widget_show ((GtkWidget*) _tmp82_);
#line 233 "document.vala"
				_g_object_unref0 (infobar);
#line 233 "document.vala"
				_g_free0 (primary_msg);
#line 1584 "document.c"
			}
		}
#line 174 "document.vala"
		_g_error_free0 (e);
#line 1589 "document.c"
	}
	__finally10:
#line 174 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 174 "document.vala"
		_g_free0 (text);
#line 174 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 174 "document.vala"
		g_clear_error (&_inner_error0_);
#line 174 "document.vala"
		return;
#line 1602 "document.c"
	}
#line 157 "document.vala"
	_g_free0 (text);
#line 1606 "document.c"
}

static gchar*
document_to_utf8 (Document* self,
                  const gchar* text,
                  GError** error)
{
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 246 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 246 "document.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 1621 "document.c"
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
#line 248 "document.vala"
		charset_collection = ENCODINGS_CHARSETS;
#line 248 "document.vala"
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
#line 248 "document.vala"
		for (charset_it = 0; charset_it < charset_collection_length1; charset_it = charset_it + 1) {
#line 1633 "document.c"
			gchar* _tmp0_;
			gchar* charset = NULL;
#line 248 "document.vala"
			_tmp0_ = g_strdup (charset_collection[charset_it]);
#line 248 "document.vala"
			charset = _tmp0_;
#line 1640 "document.c"
			{
				{
					gchar* utf8_text = NULL;
					gint _tmp1_;
					gint _tmp2_;
					const gchar* _tmp3_;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
#line 252 "document.vala"
					_tmp1_ = strlen (text);
#line 252 "document.vala"
					_tmp2_ = _tmp1_;
#line 252 "document.vala"
					_tmp3_ = charset;
#line 252 "document.vala"
					_tmp4_ = g_convert (text, (gssize) _tmp2_, "UTF-8", _tmp3_, NULL, NULL, &_inner_error0_);
#line 252 "document.vala"
					utf8_text = _tmp4_;
#line 252 "document.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 252 "document.vala"
						if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 1664 "document.c"
							goto __catch11_g_convert_error;
						}
#line 252 "document.vala"
						_g_free0 (charset);
#line 252 "document.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 252 "document.vala"
						g_clear_error (&_inner_error0_);
#line 252 "document.vala"
						return NULL;
#line 1675 "document.c"
					}
#line 254 "document.vala"
					_tmp5_ = charset;
#line 254 "document.vala"
					_tmp6_ = g_strdup (_tmp5_);
#line 254 "document.vala"
					_g_free0 (self->priv->encoding);
#line 254 "document.vala"
					self->priv->encoding = _tmp6_;
#line 255 "document.vala"
					result = utf8_text;
#line 255 "document.vala"
					_g_free0 (charset);
#line 255 "document.vala"
					return result;
#line 1691 "document.c"
				}
				goto __finally11;
				__catch11_g_convert_error:
				{
					GError* e = NULL;
#line 250 "document.vala"
					e = _inner_error0_;
#line 250 "document.vala"
					_inner_error0_ = NULL;
#line 259 "document.vala"
					_g_error_free0 (e);
#line 259 "document.vala"
					_g_free0 (charset);
#line 259 "document.vala"
					continue;
#line 1707 "document.c"
				}
				__finally11:
#line 250 "document.vala"
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 250 "document.vala"
					g_propagate_error (error, _inner_error0_);
#line 250 "document.vala"
					_g_free0 (charset);
#line 250 "document.vala"
					return NULL;
#line 1718 "document.c"
				} else {
#line 250 "document.vala"
					_g_free0 (charset);
#line 250 "document.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 250 "document.vala"
					g_clear_error (&_inner_error0_);
#line 250 "document.vala"
					return NULL;
#line 1728 "document.c"
				}
#line 248 "document.vala"
				_g_free0 (charset);
#line 1732 "document.c"
			}
		}
	}
#line 262 "document.vala"
	_tmp7_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _ ("Error trying to convert the document to UTF-8"));
#line 262 "document.vala"
	_inner_error0_ = _tmp7_;
#line 262 "document.vala"
	if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 262 "document.vala"
		g_propagate_error (error, _inner_error0_);
#line 262 "document.vala"
		return NULL;
#line 1746 "document.c"
	} else {
#line 262 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 262 "document.vala"
		g_clear_error (&_inner_error0_);
#line 262 "document.vala"
		return NULL;
#line 1754 "document.c"
	}
}

static void
document_update_syntax_highlighting (Document* self)
{
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	gchar* content_type = NULL;
	GtkSourceLanguage* lang = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkSourceLanguage* _tmp10_;
	GtkSourceLanguage* _tmp11_;
	GtkSourceLanguage* _tmp12_;
	GError* _inner_error0_ = NULL;
#line 266 "document.vala"
	g_return_if_fail (self != NULL);
#line 268 "document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 268 "document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 268 "document.vala"
	lm = _tmp1_;
#line 269 "document.vala"
	content_type = NULL;
#line 1784 "document.c"
	{
		GFileInfo* info = NULL;
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 272 "document.vala"
		_tmp2_ = self->priv->_location;
#line 272 "document.vala"
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 272 "document.vala"
		info = _tmp3_;
#line 272 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1799 "document.c"
			goto __catch12_g_error;
		}
#line 274 "document.vala"
		_tmp4_ = g_file_info_get_content_type (info);
#line 274 "document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 274 "document.vala"
		_g_free0 (content_type);
#line 274 "document.vala"
		content_type = _tmp5_;
#line 270 "document.vala"
		_g_object_unref0 (info);
#line 1812 "document.c"
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
#line 270 "document.vala"
		e = _inner_error0_;
#line 270 "document.vala"
		_inner_error0_ = NULL;
#line 270 "document.vala"
		_g_error_free0 (e);
#line 1824 "document.c"
	}
	__finally12:
#line 270 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 270 "document.vala"
		_g_free0 (content_type);
#line 270 "document.vala"
		_g_object_unref0 (lm);
#line 270 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 270 "document.vala"
		g_clear_error (&_inner_error0_);
#line 270 "document.vala"
		return;
#line 1839 "document.c"
	}
#line 278 "document.vala"
	_tmp6_ = self->priv->_location;
#line 278 "document.vala"
	_tmp7_ = g_file_get_parse_name (_tmp6_);
#line 278 "document.vala"
	_tmp8_ = _tmp7_;
#line 278 "document.vala"
	_tmp9_ = content_type;
#line 278 "document.vala"
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
#line 278 "document.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 278 "document.vala"
	_tmp12_ = _tmp11_;
#line 278 "document.vala"
	_g_free0 (_tmp8_);
#line 278 "document.vala"
	lang = _tmp12_;
#line 279 "document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
#line 266 "document.vala"
	_g_object_unref0 (lang);
#line 266 "document.vala"
	_g_free0 (content_type);
#line 266 "document.vala"
	_g_object_unref0 (lm);
#line 1867 "document.c"
}

static void
document_update_project_id (Document* self)
{
	gint i = 0;
#line 282 "document.vala"
	g_return_if_fail (self != NULL);
#line 284 "document.vala"
	i = 0;
#line 1878 "document.c"
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 285 "document.vala"
		_tmp0_ = projects_get_default ();
#line 285 "document.vala"
		_tmp1_ = _tmp0_;
#line 285 "document.vala"
		_tmp2_ = projects_iterator (_tmp1_);
#line 285 "document.vala"
		_tmp3_ = _tmp2_;
#line 285 "document.vala"
		_projects_unref0 (_tmp1_);
#line 285 "document.vala"
		_project_it = _tmp3_;
#line 285 "document.vala"
		while (TRUE) {
#line 1899 "document.c"
			GeeIterator* _tmp4_;
			Project project = {0};
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_;
			Project _tmp9_ = {0};
			Project _tmp10_;
			GFile* _tmp11_;
			Project _tmp12_;
			GFile* _tmp13_;
			gint _tmp14_;
#line 285 "document.vala"
			_tmp4_ = _project_it;
#line 285 "document.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 285 "document.vala"
				break;
#line 1918 "document.c"
			}
#line 285 "document.vala"
			_tmp5_ = _project_it;
#line 285 "document.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 285 "document.vala"
			_tmp7_ = (Project*) _tmp6_;
#line 285 "document.vala"
			_tmp8_ = *_tmp7_;
#line 285 "document.vala"
			project_copy (&_tmp8_, &_tmp9_);
#line 285 "document.vala"
			_tmp10_ = _tmp9_;
#line 285 "document.vala"
			_project_free0 (_tmp7_);
#line 285 "document.vala"
			project = _tmp10_;
#line 287 "document.vala"
			_tmp11_ = self->priv->_location;
#line 287 "document.vala"
			_tmp12_ = project;
#line 287 "document.vala"
			_tmp13_ = _tmp12_.directory;
#line 287 "document.vala"
			if (g_file_has_prefix (_tmp11_, _tmp13_)) {
#line 289 "document.vala"
				document_set_project_id (self, i);
#line 290 "document.vala"
				project_destroy (&project);
#line 290 "document.vala"
				_g_object_unref0 (_project_it);
#line 290 "document.vala"
				return;
#line 1952 "document.c"
			}
#line 292 "document.vala"
			_tmp14_ = i;
#line 292 "document.vala"
			i = _tmp14_ + 1;
#line 285 "document.vala"
			project_destroy (&project);
#line 1960 "document.c"
		}
#line 285 "document.vala"
		_g_object_unref0 (_project_it);
#line 1964 "document.c"
	}
#line 295 "document.vala"
	document_set_project_id (self, -1);
#line 1968 "document.c"
}

gchar*
document_get_uri_for_display (Document* self)
{
	GFile* _tmp0_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result = NULL;
#line 298 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 300 "document.vala"
	_tmp0_ = self->priv->_location;
#line 300 "document.vala"
	if (_tmp0_ == NULL) {
#line 1987 "document.c"
		TeplFile* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 301 "document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 301 "document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 301 "document.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 301 "document.vala"
		result = _tmp3_;
#line 301 "document.vala"
		return result;
#line 2001 "document.c"
	}
#line 303 "document.vala"
	_tmp4_ = self->priv->_location;
#line 303 "document.vala"
	_tmp5_ = g_file_get_parse_name (_tmp4_);
#line 303 "document.vala"
	_tmp6_ = _tmp5_;
#line 303 "document.vala"
	_tmp7_ = tepl_utils_replace_home_dir_with_tilde (_tmp6_);
#line 303 "document.vala"
	_tmp8_ = _tmp7_;
#line 303 "document.vala"
	_g_free0 (_tmp6_);
#line 303 "document.vala"
	result = _tmp8_;
#line 303 "document.vala"
	return result;
#line 2019 "document.c"
}

gchar*
document_get_short_name_for_display (Document* self)
{
	GFile* _tmp0_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* result = NULL;
#line 306 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 308 "document.vala"
	_tmp0_ = self->priv->_location;
#line 308 "document.vala"
	if (_tmp0_ == NULL) {
#line 2035 "document.c"
		TeplFile* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 309 "document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 309 "document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 309 "document.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 309 "document.vala"
		result = _tmp3_;
#line 309 "document.vala"
		return result;
#line 2049 "document.c"
	}
#line 311 "document.vala"
	_tmp4_ = self->priv->_location;
#line 311 "document.vala"
	_tmp5_ = g_file_get_basename (_tmp4_);
#line 311 "document.vala"
	result = _tmp5_;
#line 311 "document.vala"
	return result;
#line 2059 "document.c"
}

gboolean
document_is_externally_modified (Document* self)
{
	GFile* _tmp0_;
	gchar* current_etag = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 314 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 316 "document.vala"
	_tmp0_ = self->priv->_location;
#line 316 "document.vala"
	if (_tmp0_ == NULL) {
#line 317 "document.vala"
		result = FALSE;
#line 317 "document.vala"
		return result;
#line 2081 "document.c"
	}
#line 319 "document.vala"
	current_etag = NULL;
#line 2085 "document.c"
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 322 "document.vala"
		_tmp1_ = self->priv->_location;
#line 322 "document.vala"
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 322 "document.vala"
		file_info = _tmp2_;
#line 322 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2101 "document.c"
			goto __catch13_g_error;
		}
#line 324 "document.vala"
		_tmp3_ = file_info;
#line 324 "document.vala"
		_tmp4_ = g_file_info_get_etag (_tmp3_);
#line 324 "document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 324 "document.vala"
		_g_free0 (current_etag);
#line 324 "document.vala"
		current_etag = _tmp5_;
#line 320 "document.vala"
		_g_object_unref0 (file_info);
#line 2116 "document.c"
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
#line 320 "document.vala"
		e = _inner_error0_;
#line 320 "document.vala"
		_inner_error0_ = NULL;
#line 328 "document.vala"
		result = FALSE;
#line 328 "document.vala"
		_g_error_free0 (e);
#line 328 "document.vala"
		_g_free0 (current_etag);
#line 328 "document.vala"
		return result;
#line 2134 "document.c"
	}
	__finally13:
#line 320 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2139 "document.c"
		gboolean _tmp6_ = FALSE;
#line 320 "document.vala"
		_g_free0 (current_etag);
#line 320 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 320 "document.vala"
		g_clear_error (&_inner_error0_);
#line 320 "document.vala"
		return _tmp6_;
#line 2149 "document.c"
	}
#line 331 "document.vala"
	_tmp8_ = current_etag;
#line 331 "document.vala"
	if (_tmp8_ != NULL) {
#line 2155 "document.c"
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 331 "document.vala"
		_tmp9_ = current_etag;
#line 331 "document.vala"
		_tmp10_ = self->priv->_etag;
#line 331 "document.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
#line 2164 "document.c"
	} else {
#line 331 "document.vala"
		_tmp7_ = FALSE;
#line 2168 "document.c"
	}
#line 331 "document.vala"
	result = _tmp7_;
#line 331 "document.vala"
	_g_free0 (current_etag);
#line 331 "document.vala"
	return result;
#line 2176 "document.c"
}

void
document_comment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
#line 334 "document.vala"
	g_return_if_fail (self != NULL);
#line 338 "document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 338 "document.vala"
	start = _tmp0_;
#line 338 "document.vala"
	end = _tmp1_;
#line 340 "document.vala"
	_tmp2_ = start;
#line 340 "document.vala"
	_tmp3_ = end;
#line 340 "document.vala"
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
#line 2202 "document.c"
}

void
document_comment_between (Document* self,
                          GtkTextIter* start_iter,
                          GtkTextIter* end_iter,
                          gboolean end_iter_set)
{
	gint start_line = 0;
	gint end_line = 0;
	GtkTextIter cur_iter = {0};
	GtkTextIter _tmp0_ = {0};
#line 344 "document.vala"
	g_return_if_fail (self != NULL);
#line 344 "document.vala"
	g_return_if_fail (start_iter != NULL);
#line 344 "document.vala"
	g_return_if_fail (end_iter != NULL);
#line 347 "document.vala"
	start_line = gtk_text_iter_get_line (start_iter);
#line 348 "document.vala"
	end_line = start_line;
#line 350 "document.vala"
	if (end_iter_set) {
#line 351 "document.vala"
		end_line = gtk_text_iter_get_line (end_iter);
#line 2229 "document.c"
	}
#line 354 "document.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp0_, start_line);
#line 354 "document.vala"
	cur_iter = _tmp0_;
#line 356 "document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2237 "document.c"
	{
		gint line_num = 0;
#line 358 "document.vala"
		line_num = start_line;
#line 2242 "document.c"
		{
			gboolean _tmp1_ = FALSE;
#line 358 "document.vala"
			_tmp1_ = TRUE;
#line 358 "document.vala"
			while (TRUE) {
#line 358 "document.vala"
				if (!_tmp1_) {
#line 2251 "document.c"
					gint _tmp2_;
#line 358 "document.vala"
					_tmp2_ = line_num;
#line 358 "document.vala"
					line_num = _tmp2_ + 1;
#line 2257 "document.c"
				}
#line 358 "document.vala"
				_tmp1_ = FALSE;
#line 358 "document.vala"
				if (!(line_num <= end_line)) {
#line 358 "document.vala"
					break;
#line 2265 "document.c"
				}
#line 360 "document.vala"
				if (gtk_text_iter_ends_line (&cur_iter)) {
#line 362 "document.vala"
					document_insert (self, &cur_iter, "%", -1);
#line 2271 "document.c"
				} else {
#line 364 "document.vala"
					document_insert (self, &cur_iter, "% ", -1);
#line 2275 "document.c"
				}
#line 366 "document.vala"
				gtk_text_iter_forward_line (&cur_iter);
#line 2279 "document.c"
			}
		}
	}
#line 369 "document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2285 "document.c"
}

void
document_uncomment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line = 0;
	gint end_line = 0;
	gint line_count = 0;
#line 372 "document.vala"
	g_return_if_fail (self != NULL);
#line 375 "document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 375 "document.vala"
	start = _tmp0_;
#line 375 "document.vala"
	end = _tmp1_;
#line 377 "document.vala"
	start_line = gtk_text_iter_get_line (&start);
#line 378 "document.vala"
	end_line = gtk_text_iter_get_line (&end);
#line 379 "document.vala"
	line_count = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
#line 381 "document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2314 "document.c"
	{
		gint i = 0;
#line 383 "document.vala"
		i = start_line;
#line 2319 "document.c"
		{
			gboolean _tmp2_ = FALSE;
#line 383 "document.vala"
			_tmp2_ = TRUE;
#line 383 "document.vala"
			while (TRUE) {
#line 2326 "document.c"
				GtkTextIter _tmp4_ = {0};
				gchar* line = NULL;
				GtkTextIter _tmp7_;
				GtkTextIter _tmp8_;
				gchar* _tmp9_;
				gint j = 0;
				gint start_delete = 0;
				gint stop_delete = 0;
				GtkTextIter _tmp18_ = {0};
				GtkTextIter _tmp19_ = {0};
#line 383 "document.vala"
				if (!_tmp2_) {
#line 2339 "document.c"
					gint _tmp3_;
#line 383 "document.vala"
					_tmp3_ = i;
#line 383 "document.vala"
					i = _tmp3_ + 1;
#line 2345 "document.c"
				}
#line 383 "document.vala"
				_tmp2_ = FALSE;
#line 383 "document.vala"
				if (!(i <= end_line)) {
#line 383 "document.vala"
					break;
#line 2353 "document.c"
				}
#line 385 "document.vala"
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp4_, i);
#line 385 "document.vala"
				start = _tmp4_;
#line 388 "document.vala"
				if (i == (line_count - 1)) {
#line 2361 "document.c"
					GtkTextIter _tmp5_ = {0};
#line 389 "document.vala"
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp5_);
#line 389 "document.vala"
					end = _tmp5_;
#line 2367 "document.c"
				} else {
					GtkTextIter _tmp6_ = {0};
#line 391 "document.vala"
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp6_, i + 1);
#line 391 "document.vala"
					end = _tmp6_;
#line 2374 "document.c"
				}
#line 393 "document.vala"
				_tmp7_ = start;
#line 393 "document.vala"
				_tmp8_ = end;
#line 393 "document.vala"
				_tmp9_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp7_, &_tmp8_, FALSE);
#line 393 "document.vala"
				line = _tmp9_;
#line 396 "document.vala"
				j = 0;
#line 397 "document.vala"
				start_delete = -1;
#line 398 "document.vala"
				stop_delete = -1;
#line 399 "document.vala"
				while (TRUE) {
#line 2392 "document.c"
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gint _tmp17_;
#line 399 "document.vala"
					_tmp10_ = line;
#line 399 "document.vala"
					if (!(string_get (_tmp10_, (glong) j) != '\0')) {
#line 399 "document.vala"
						break;
#line 2402 "document.c"
					}
#line 401 "document.vala"
					_tmp11_ = line;
#line 401 "document.vala"
					if (string_get (_tmp11_, (glong) j) == '%') {
#line 2408 "document.c"
						const gchar* _tmp12_;
#line 403 "document.vala"
						start_delete = j;
#line 404 "document.vala"
						stop_delete = j + 1;
#line 405 "document.vala"
						_tmp12_ = line;
#line 405 "document.vala"
						if (string_get (_tmp12_, (glong) (j + 1)) == ' ') {
#line 2418 "document.c"
							gint _tmp13_;
#line 406 "document.vala"
							_tmp13_ = stop_delete;
#line 406 "document.vala"
							stop_delete = _tmp13_ + 1;
#line 2424 "document.c"
						}
#line 407 "document.vala"
						break;
#line 2428 "document.c"
					} else {
						gboolean _tmp14_ = FALSE;
						const gchar* _tmp15_;
#line 410 "document.vala"
						_tmp15_ = line;
#line 410 "document.vala"
						if (string_get (_tmp15_, (glong) j) != ' ') {
#line 2436 "document.c"
							const gchar* _tmp16_;
#line 410 "document.vala"
							_tmp16_ = line;
#line 410 "document.vala"
							_tmp14_ = string_get (_tmp16_, (glong) j) != '\t';
#line 2442 "document.c"
						} else {
#line 410 "document.vala"
							_tmp14_ = FALSE;
#line 2446 "document.c"
						}
#line 410 "document.vala"
						if (_tmp14_) {
#line 411 "document.vala"
							break;
#line 2452 "document.c"
						}
					}
#line 413 "document.vala"
					_tmp17_ = j;
#line 413 "document.vala"
					j = _tmp17_ + 1;
#line 2459 "document.c"
				}
#line 416 "document.vala"
				if (start_delete == -1) {
#line 417 "document.vala"
					_g_free0 (line);
#line 417 "document.vala"
					continue;
#line 2467 "document.c"
				}
#line 419 "document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp18_, i, start_delete);
#line 419 "document.vala"
				start = _tmp18_;
#line 420 "document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp19_, i, stop_delete);
#line 420 "document.vala"
				end = _tmp19_;
#line 421 "document.vala"
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
#line 383 "document.vala"
				_g_free0 (line);
#line 2481 "document.c"
			}
		}
	}
#line 424 "document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2487 "document.c"
}

Project*
document_get_project (Document* self)
{
	gint _tmp0_;
	Projects* _tmp1_;
	Projects* _tmp2_;
	gint _tmp3_;
	Project* _tmp4_;
	Project* _tmp5_;
	Project* result = NULL;
#line 427 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 429 "document.vala"
	_tmp0_ = self->priv->_project_id;
#line 429 "document.vala"
	if (_tmp0_ == -1) {
#line 430 "document.vala"
		result = NULL;
#line 430 "document.vala"
		return result;
#line 2510 "document.c"
	}
#line 432 "document.vala"
	_tmp1_ = projects_get_default ();
#line 432 "document.vala"
	_tmp2_ = _tmp1_;
#line 432 "document.vala"
	_tmp3_ = self->priv->_project_id;
#line 432 "document.vala"
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
#line 432 "document.vala"
	_tmp5_ = _tmp4_;
#line 432 "document.vala"
	_projects_unref0 (_tmp2_);
#line 432 "document.vala"
	result = _tmp5_;
#line 432 "document.vala"
	return result;
#line 2528 "document.c"
}

GFile*
document_get_main_file (Document* self)
{
	GFile* _tmp0_;
	Project* project = NULL;
	Project* _tmp1_;
	Project* _tmp2_;
	Project* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* result = NULL;
#line 435 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 437 "document.vala"
	_tmp0_ = self->priv->_location;
#line 437 "document.vala"
	if (_tmp0_ == NULL) {
#line 438 "document.vala"
		result = NULL;
#line 438 "document.vala"
		return result;
#line 2552 "document.c"
	}
#line 440 "document.vala"
	_tmp1_ = document_get_project (self);
#line 440 "document.vala"
	project = _tmp1_;
#line 441 "document.vala"
	_tmp2_ = project;
#line 441 "document.vala"
	if (_tmp2_ == NULL) {
#line 2562 "document.c"
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 442 "document.vala"
		_tmp3_ = self->priv->_location;
#line 442 "document.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 442 "document.vala"
		result = _tmp4_;
#line 442 "document.vala"
		_project_free0 (project);
#line 442 "document.vala"
		return result;
#line 2575 "document.c"
	}
#line 444 "document.vala"
	_tmp5_ = project;
#line 444 "document.vala"
	_tmp6_ = (*_tmp5_).main_file;
#line 444 "document.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 444 "document.vala"
	result = _tmp7_;
#line 444 "document.vala"
	_project_free0 (project);
#line 444 "document.vala"
	return result;
#line 2589 "document.c"
}

gboolean
document_is_main_file_a_tex_file (Document* self)
{
	GFile* main_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result = FALSE;
#line 447 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 449 "document.vala"
	_tmp0_ = document_get_main_file (self);
#line 449 "document.vala"
	main_file = _tmp0_;
#line 450 "document.vala"
	_tmp1_ = main_file;
#line 450 "document.vala"
	if (_tmp1_ == NULL) {
#line 451 "document.vala"
		result = FALSE;
#line 451 "document.vala"
		_g_object_unref0 (main_file);
#line 451 "document.vala"
		return result;
#line 2619 "document.c"
	}
#line 453 "document.vala"
	_tmp2_ = main_file;
#line 453 "document.vala"
	_tmp3_ = g_file_get_parse_name (_tmp2_);
#line 453 "document.vala"
	path = _tmp3_;
#line 454 "document.vala"
	_tmp4_ = path;
#line 454 "document.vala"
	result = g_str_has_suffix (_tmp4_, ".tex");
#line 454 "document.vala"
	_g_free0 (path);
#line 454 "document.vala"
	_g_object_unref0 (main_file);
#line 454 "document.vala"
	return result;
#line 2637 "document.c"
}

DocumentStructure*
document_get_structure (Document* self)
{
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp3_;
	DocumentStructure* _tmp4_;
	DocumentStructure* result = NULL;
#line 457 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 459 "document.vala"
	_tmp0_ = self->priv->_structure;
#line 459 "document.vala"
	if (_tmp0_ == NULL) {
#line 2653 "document.c"
		DocumentStructure* _tmp1_;
		DocumentStructure* _tmp2_;
#line 461 "document.vala"
		_tmp1_ = document_structure_new (self);
#line 461 "document.vala"
		_g_object_unref0 (self->priv->_structure);
#line 461 "document.vala"
		self->priv->_structure = _tmp1_;
#line 462 "document.vala"
		_tmp2_ = self->priv->_structure;
#line 462 "document.vala"
		document_structure_parse (_tmp2_);
#line 2666 "document.c"
	}
#line 464 "document.vala"
	_tmp3_ = self->priv->_structure;
#line 464 "document.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 464 "document.vala"
	result = _tmp4_;
#line 464 "document.vala"
	return result;
#line 2676 "document.c"
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
#line 467 "document.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 467 "document.vala"
	return _data17_;
#line 2686 "document.c"
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 467 "document.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 2696 "document.c"
		Document* self;
#line 467 "document.vala"
		self = _data17_->self;
#line 467 "document.vala"
		_g_object_unref0 (_data17_->infobar);
#line 467 "document.vala"
		_g_object_unref0 (self);
#line 467 "document.vala"
		g_slice_free (Block17Data, _data17_);
#line 2706 "document.c"
	}
}

static void
__lambda27_ (Block17Data* _data17_,
             gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp4_;
#line 499 "document.vala"
	self = _data17_->self;
#line 501 "document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 2720 "document.c"
		MainWindow* main_window = NULL;
		DocumentTab* _tmp0_;
		GtkWindow* _tmp1_;
		MainWindow* _tmp2_;
#line 503 "document.vala"
		_tmp0_ = self->tab;
#line 503 "document.vala"
		_tmp1_ = utils_get_toplevel_window ((GtkWidget*) _tmp0_);
#line 503 "document.vala"
		main_window = IS_MAIN_WINDOW (_tmp1_) ? ((MainWindow*) _tmp1_) : NULL;
#line 506 "document.vala"
		_tmp2_ = main_window;
#line 506 "document.vala"
		if (_tmp2_ != NULL) {
#line 2735 "document.c"
			MainWindow* _tmp3_;
#line 507 "document.vala"
			_tmp3_ = main_window;
#line 507 "document.vala"
			main_window_save_document (_tmp3_, self, TRUE);
#line 2741 "document.c"
		}
	}
#line 510 "document.vala"
	_tmp4_ = _data17_->infobar;
#line 510 "document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 2748 "document.c"
}

static void
___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                    gint response_id,
                                    gpointer self)
{
#line 499 "document.vala"
	__lambda27_ (self, response_id);
#line 2758 "document.c"
}

gboolean
document_set_tmp_location (Document* self)
{
	Block17Data* _data17_;
	gchar* template = NULL;
	gchar* _tmp0_;
	gchar* tmp_dir = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	DocumentTab* _tmp14_;
	TeplInfoBar* _tmp15_;
	TeplInfoBar* _tmp16_;
	TeplInfoBar* _tmp17_;
	DocumentTab* _tmp18_;
	TeplInfoBar* _tmp19_;
	TeplInfoBar* _tmp20_;
	TeplInfoBar* _tmp21_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 467 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 467 "document.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 467 "document.vala"
	_data17_->_ref_count_ = 1;
#line 467 "document.vala"
	_data17_->self = g_object_ref (self);
#line 470 "document.vala"
	_tmp0_ = g_strdup ("latexila-XXXXXX");
#line 470 "document.vala"
	template = _tmp0_;
#line 2795 "document.c"
	{
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp5_;
#line 475 "document.vala"
		_tmp2_ = template;
#line 475 "document.vala"
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error0_);
#line 475 "document.vala"
		_tmp1_ = _tmp3_;
#line 475 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2809 "document.c"
			gboolean _tmp4_ = FALSE;
#line 475 "document.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 2813 "document.c"
				goto __catch14_g_file_error;
			}
#line 475 "document.vala"
			_g_free0 (tmp_dir);
#line 475 "document.vala"
			_g_free0 (template);
#line 475 "document.vala"
			block17_data_unref (_data17_);
#line 475 "document.vala"
			_data17_ = NULL;
#line 475 "document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 475 "document.vala"
			g_clear_error (&_inner_error0_);
#line 475 "document.vala"
			return _tmp4_;
#line 2830 "document.c"
		}
#line 475 "document.vala"
		_tmp5_ = _tmp1_;
#line 475 "document.vala"
		_tmp1_ = NULL;
#line 475 "document.vala"
		_g_free0 (tmp_dir);
#line 475 "document.vala"
		tmp_dir = _tmp5_;
#line 473 "document.vala"
		_g_free0 (_tmp1_);
#line 2842 "document.c"
	}
	goto __finally14;
	__catch14_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 473 "document.vala"
		e = _inner_error0_;
#line 473 "document.vala"
		_inner_error0_ = NULL;
#line 479 "document.vala"
		_tmp6_ = e;
#line 479 "document.vala"
		_tmp7_ = _tmp6_->message;
#line 479 "document.vala"
		g_warning ("document.vala:479: Impossible to create temporary directory: %s", _tmp7_);
#line 480 "document.vala"
		result = FALSE;
#line 480 "document.vala"
		_g_error_free0 (e);
#line 480 "document.vala"
		_g_free0 (tmp_dir);
#line 480 "document.vala"
		_g_free0 (template);
#line 480 "document.vala"
		block17_data_unref (_data17_);
#line 480 "document.vala"
		_data17_ = NULL;
#line 480 "document.vala"
		return result;
#line 2874 "document.c"
	}
	__finally14:
#line 473 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2879 "document.c"
		gboolean _tmp8_ = FALSE;
#line 473 "document.vala"
		_g_free0 (tmp_dir);
#line 473 "document.vala"
		_g_free0 (template);
#line 473 "document.vala"
		block17_data_unref (_data17_);
#line 473 "document.vala"
		_data17_ = NULL;
#line 473 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 473 "document.vala"
		g_clear_error (&_inner_error0_);
#line 473 "document.vala"
		return _tmp8_;
#line 2895 "document.c"
	}
#line 484 "document.vala"
	_tmp9_ = tmp_dir;
#line 484 "document.vala"
	_tmp10_ = g_build_filename (_tmp9_, "tmp.tex", NULL);
#line 484 "document.vala"
	_tmp11_ = _tmp10_;
#line 484 "document.vala"
	_tmp12_ = g_file_new_for_path (_tmp11_);
#line 484 "document.vala"
	_tmp13_ = _tmp12_;
#line 484 "document.vala"
	document_set_location (self, _tmp13_);
#line 484 "document.vala"
	_g_object_unref0 (_tmp13_);
#line 484 "document.vala"
	_g_free0 (_tmp11_);
#line 488 "document.vala"
	_tmp14_ = self->tab;
#line 488 "document.vala"
	if (_tmp14_ == NULL) {
#line 489 "document.vala"
		result = TRUE;
#line 489 "document.vala"
		_g_free0 (tmp_dir);
#line 489 "document.vala"
		_g_free0 (template);
#line 489 "document.vala"
		block17_data_unref (_data17_);
#line 489 "document.vala"
		_data17_ = NULL;
#line 489 "document.vala"
		return result;
#line 2929 "document.c"
	}
#line 491 "document.vala"
	_tmp15_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer."), _ ("Do you want to save the file in a safer place?"));
#line 491 "document.vala"
	g_object_ref_sink (_tmp15_);
#line 491 "document.vala"
	_data17_->infobar = _tmp15_;
#line 494 "document.vala"
	_tmp16_ = _data17_->infobar;
#line 494 "document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp16_, _ ("Save _As"), (gint) GTK_RESPONSE_YES);
#line 495 "document.vala"
	_tmp17_ = _data17_->infobar;
#line 495 "document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp17_, _ ("Cancel"), (gint) GTK_RESPONSE_NO);
#line 496 "document.vala"
	_tmp18_ = self->tab;
#line 496 "document.vala"
	_tmp19_ = _data17_->infobar;
#line 496 "document.vala"
	tepl_tab_add_info_bar ((TeplTab*) _tmp18_, (GtkInfoBar*) _tmp19_);
#line 497 "document.vala"
	_tmp20_ = _data17_->infobar;
#line 497 "document.vala"
	gtk_widget_show ((GtkWidget*) _tmp20_);
#line 499 "document.vala"
	_tmp21_ = _data17_->infobar;
#line 499 "document.vala"
	g_signal_connect_data ((GtkInfoBar*) _tmp21_, "response", (GCallback) ___lambda27__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
#line 513 "document.vala"
	result = TRUE;
#line 513 "document.vala"
	_g_free0 (tmp_dir);
#line 513 "document.vala"
	_g_free0 (template);
#line 513 "document.vala"
	block17_data_unref (_data17_);
#line 513 "document.vala"
	_data17_ = NULL;
#line 513 "document.vala"
	return result;
#line 2971 "document.c"
}

static void
document_save_metadata (Document* self)
{
	GFileInfo* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 516 "document.vala"
	g_return_if_fail (self != NULL);
#line 518 "document.vala"
	_tmp0_ = self->priv->_metadata_info;
#line 518 "document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 520 "document.vala"
	_tmp1_ = self->priv->_location;
#line 520 "document.vala"
	if (_tmp1_ == NULL) {
#line 521 "document.vala"
		return;
#line 2992 "document.c"
	}
	{
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
#line 525 "document.vala"
		_tmp2_ = self->priv->_location;
#line 525 "document.vala"
		_tmp3_ = self->priv->_metadata_info;
#line 525 "document.vala"
		g_file_set_attributes_from_info (_tmp2_, _tmp3_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 525 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3005 "document.c"
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 523 "document.vala"
		_error_ = _inner_error0_;
#line 523 "document.vala"
		_inner_error0_ = NULL;
#line 530 "document.vala"
		_tmp4_ = _error_;
#line 530 "document.vala"
		_tmp5_ = _tmp4_->message;
#line 530 "document.vala"
		g_warning ("document.vala:530: Set document metadata failed: %s", _tmp5_);
#line 523 "document.vala"
		_g_error_free0 (_error_);
#line 3027 "document.c"
	}
	__finally15:
#line 523 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 523 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 523 "document.vala"
		g_clear_error (&_inner_error0_);
#line 523 "document.vala"
		return;
#line 3038 "document.c"
	}
}

void
document_set_metadata (Document* self,
                       const gchar* key,
                       const gchar* val)
{
	GFileInfo* _tmp0_;
#line 534 "document.vala"
	g_return_if_fail (self != NULL);
#line 534 "document.vala"
	g_return_if_fail (key != NULL);
#line 536 "document.vala"
	_tmp0_ = self->priv->_metadata_info;
#line 536 "document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 538 "document.vala"
	if (val != NULL) {
#line 3058 "document.c"
		GFileInfo* _tmp1_;
#line 539 "document.vala"
		_tmp1_ = self->priv->_metadata_info;
#line 539 "document.vala"
		g_file_info_set_attribute_string (_tmp1_, key, val);
#line 3064 "document.c"
	} else {
		GFileInfo* _tmp2_;
#line 542 "document.vala"
		_tmp2_ = self->priv->_metadata_info;
#line 542 "document.vala"
		g_file_info_set_attribute (_tmp2_, key, G_FILE_ATTRIBUTE_TYPE_INVALID, NULL);
#line 3071 "document.c"
	}
#line 544 "document.vala"
	document_save_metadata (self);
#line 3075 "document.c"
}

gchar*
document_get_metadata (Document* self,
                       const gchar* key)
{
	GFileInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFileInfo* _tmp2_;
	gchar* result = NULL;
#line 547 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 547 "document.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 549 "document.vala"
	_tmp0_ = self->priv->_metadata_info;
#line 549 "document.vala"
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
#line 551 "document.vala"
	_tmp2_ = self->priv->_metadata_info;
#line 551 "document.vala"
	if (g_file_info_has_attribute (_tmp2_, key)) {
#line 3098 "document.c"
		GFileInfo* _tmp3_;
#line 552 "document.vala"
		_tmp3_ = self->priv->_metadata_info;
#line 552 "document.vala"
		_tmp1_ = g_file_info_get_attribute_type (_tmp3_, key) == G_FILE_ATTRIBUTE_TYPE_STRING;
#line 3104 "document.c"
	} else {
#line 551 "document.vala"
		_tmp1_ = FALSE;
#line 3108 "document.c"
	}
#line 551 "document.vala"
	if (_tmp1_) {
#line 3112 "document.c"
		GFileInfo* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 553 "document.vala"
		_tmp4_ = self->priv->_metadata_info;
#line 553 "document.vala"
		_tmp5_ = g_file_info_get_attribute_string (_tmp4_, key);
#line 553 "document.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 553 "document.vala"
		result = _tmp6_;
#line 553 "document.vala"
		return result;
#line 3126 "document.c"
	}
#line 555 "document.vala"
	result = NULL;
#line 555 "document.vala"
	return result;
#line 3132 "document.c"
}

GFile*
document_get_location (Document* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 24 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "document.vala"
	_tmp0_ = self->priv->_location;
#line 24 "document.vala"
	result = _tmp0_;
#line 24 "document.vala"
	return result;
#line 3148 "document.c"
}

void
document_set_location (Document* self,
                       GFile* value)
{
#line 24 "document.vala"
	g_return_if_fail (self != NULL);
#line 24 "document.vala"
	if (document_get_location (self) != value) {
#line 3159 "document.c"
		GFile* _tmp0_;
#line 24 "document.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 24 "document.vala"
		_g_object_unref0 (self->priv->_location);
#line 24 "document.vala"
		self->priv->_location = _tmp0_;
#line 24 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_LOCATION_PROPERTY]);
#line 3169 "document.c"
	}
}

gboolean
document_get_readonly (Document* self)
{
	gboolean result;
#line 25 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 25 "document.vala"
	result = self->priv->_readonly;
#line 25 "document.vala"
	return result;
#line 3183 "document.c"
}

void
document_set_readonly (Document* self,
                       gboolean value)
{
#line 25 "document.vala"
	g_return_if_fail (self != NULL);
#line 25 "document.vala"
	if (document_get_readonly (self) != value) {
#line 25 "document.vala"
		self->priv->_readonly = value;
#line 25 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_READONLY_PROPERTY]);
#line 3198 "document.c"
	}
}

gint
document_get_project_id (Document* self)
{
	gint result;
#line 27 "document.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "document.vala"
	result = self->priv->_project_id;
#line 27 "document.vala"
	return result;
#line 3212 "document.c"
}

void
document_set_project_id (Document* self,
                         gint value)
{
#line 27 "document.vala"
	g_return_if_fail (self != NULL);
#line 27 "document.vala"
	if (document_get_project_id (self) != value) {
#line 27 "document.vala"
		self->priv->_project_id = value;
#line 27 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_PROJECT_ID_PROPERTY]);
#line 3227 "document.c"
	}
}

static void
document_class_init (DocumentClass * klass,
                     gpointer klass_data)
{
#line 22 "document.vala"
	document_parent_class = g_type_class_peek_parent (klass);
#line 22 "document.vala"
	g_type_class_adjust_private_offset (klass, &Document_private_offset);
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION_PROPERTY, document_properties[DOCUMENT_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY_PROPERTY, document_properties[DOCUMENT_READONLY_PROPERTY] = g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID_PROPERTY, document_properties[DOCUMENT_PROJECT_ID_PROPERTY] = g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3251 "document.c"
}

static void
document_instance_init (Document * self,
                        gpointer klass)
{
	GFileInfo* _tmp0_;
#line 22 "document.vala"
	self->priv = document_get_instance_private (self);
#line 25 "document.vala"
	self->priv->_readonly = FALSE;
#line 27 "document.vala"
	self->priv->_project_id = -1;
#line 28 "document.vala"
	self->priv->backup_made = FALSE;
#line 30 "document.vala"
	self->priv->encoding = NULL;
#line 31 "document.vala"
	self->priv->new_file = TRUE;
#line 32 "document.vala"
	self->priv->_structure = NULL;
#line 33 "document.vala"
	_tmp0_ = g_file_info_new ();
#line 33 "document.vala"
	self->priv->_metadata_info = _tmp0_;
#line 3277 "document.c"
}

static void
document_finalize (GObject * obj)
{
	Document * self;
#line 22 "document.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
#line 24 "document.vala"
	_g_object_unref0 (self->priv->_location);
#line 29 "document.vala"
	_g_free0 (self->priv->_etag);
#line 30 "document.vala"
	_g_free0 (self->priv->encoding);
#line 32 "document.vala"
	_g_object_unref0 (self->priv->_structure);
#line 33 "document.vala"
	_g_object_unref0 (self->priv->_metadata_info);
#line 22 "document.vala"
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
#line 3298 "document.c"
}

GType
document_get_type (void)
{
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (tepl_buffer_get_type (), "Document", &g_define_type_info, 0);
		Document_private_offset = g_type_add_instance_private (document_type_id, sizeof (DocumentPrivate));
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}

static void
_vala_document_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "document.vala"
	switch (property_id) {
#line 22 "document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "document.vala"
		g_value_set_object (value, document_get_location (self));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "document.vala"
		g_value_set_boolean (value, document_get_readonly (self));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "document.vala"
		g_value_set_int (value, document_get_project_id (self));
#line 22 "document.vala"
		break;
#line 3343 "document.c"
		default:
#line 22 "document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document.vala"
		break;
#line 3349 "document.c"
	}
}

static void
_vala_document_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "document.vala"
	switch (property_id) {
#line 22 "document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "document.vala"
		document_set_location (self, g_value_get_object (value));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "document.vala"
		document_set_readonly (self, g_value_get_boolean (value));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "document.vala"
		document_set_project_id (self, g_value_get_int (value));
#line 22 "document.vala"
		break;
#line 3381 "document.c"
		default:
#line 22 "document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document.vala"
		break;
#line 3387 "document.c"
	}
}

