/* dialogs.c generated by valac 0.46.6, the Vala compiler
 * generated from dialogs.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <tepl/tepl.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

typedef enum  {
	DIALOGS_UNSAVED_DOC_COLUMN_SAVE,
	DIALOGS_UNSAVED_DOC_COLUMN_NAME,
	DIALOGS_UNSAVED_DOC_COLUMN_DOC,
	DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS
} DialogsUnsavedDocColumn;

#define DIALOGS_TYPE_UNSAVED_DOC_COLUMN (dialogs_unsaved_doc_column_get_type ())

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block12Data Block12Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
typedef struct _DocumentPrivate DocumentPrivate;

struct _Block12Data {
	int _ref_count_;
	GtkListStore* store;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

GType dialogs_unsaved_doc_column_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
void dialogs_close_several_unsaved_documents (MainWindow* window,
                                              GeeList* unsaved_docs);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda19_ (Block12Data* _data12_,
                  const gchar* path_str);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void ___lambda19__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                                    const gchar* path,
                                                    gpointer self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
void main_window_remove_all_tabs (MainWindow* self);
GeeList* main_window_get_documents (MainWindow* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);

GType
dialogs_unsaved_doc_column_get_type (void)
{
	static volatile gsize dialogs_unsaved_doc_column_type_id__volatile = 0;
	if (g_once_init_enter (&dialogs_unsaved_doc_column_type_id__volatile)) {
		static const GEnumValue values[] = {{DIALOGS_UNSAVED_DOC_COLUMN_SAVE, "DIALOGS_UNSAVED_DOC_COLUMN_SAVE", "save"}, {DIALOGS_UNSAVED_DOC_COLUMN_NAME, "DIALOGS_UNSAVED_DOC_COLUMN_NAME", "name"}, {DIALOGS_UNSAVED_DOC_COLUMN_DOC, "DIALOGS_UNSAVED_DOC_COLUMN_DOC", "doc"}, {DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, "DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType dialogs_unsaved_doc_column_type_id;
		dialogs_unsaved_doc_column_type_id = g_enum_register_static ("DialogsUnsavedDocColumn", values);
		g_once_init_leave (&dialogs_unsaved_doc_column_type_id__volatile, dialogs_unsaved_doc_column_type_id);
	}
	return dialogs_unsaved_doc_column_type_id__volatile;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
#line 32 "dialogs.vala"
	g_atomic_int_inc (&_data12_->_ref_count_);
#line 32 "dialogs.vala"
	return _data12_;
#line 141 "dialogs.c"
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
#line 32 "dialogs.vala"
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
#line 32 "dialogs.vala"
		_g_object_unref0 (_data12_->store);
#line 32 "dialogs.vala"
		g_slice_free (Block12Data, _data12_);
#line 155 "dialogs.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 50 "dialogs.vala"
	return self ? g_object_ref (self) : NULL;
#line 164 "dialogs.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 101 "dialogs.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 172 "dialogs.c"
}

static void
__lambda19_ (Block12Data* _data12_,
             const gchar* path_str)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkListStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
#line 101 "dialogs.vala"
	g_return_if_fail (path_str != NULL);
#line 103 "dialogs.vala"
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
#line 103 "dialogs.vala"
	path = _tmp0_;
#line 106 "dialogs.vala"
	_tmp1_ = _data12_->store;
#line 106 "dialogs.vala"
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp1_, &_tmp2_, path);
#line 106 "dialogs.vala"
	iter = _tmp2_;
#line 107 "dialogs.vala"
	_tmp3_ = _data12_->store;
#line 107 "dialogs.vala"
	_tmp4_ = iter;
#line 107 "dialogs.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &_tmp5_, -1, -1);
#line 107 "dialogs.vala"
	active = _tmp5_;
#line 109 "dialogs.vala"
	_tmp6_ = _data12_->store;
#line 109 "dialogs.vala"
	_tmp7_ = iter;
#line 109 "dialogs.vala"
	gtk_list_store_set (_tmp6_, &_tmp7_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, !active, -1, -1);
#line 101 "dialogs.vala"
	__vala_GtkTreePath_free0 (path);
#line 218 "dialogs.c"
}

static void
___lambda19__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                               const gchar* path,
                                               gpointer self)
{
#line 101 "dialogs.vala"
	__lambda19_ (self, path);
#line 228 "dialogs.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 144 "dialogs.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 236 "dialogs.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 144 "dialogs.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 244 "dialogs.c"
}

void
dialogs_close_several_unsaved_documents (MainWindow* window,
                                         GeeList* unsaved_docs)
{
	Block12Data* _data12_;
	gint _tmp0_;
	gint _tmp1_;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp2_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkGrid* _tmp11_;
	GtkImage* image = NULL;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkGrid* _tmp14_;
	GtkImage* _tmp15_;
	GtkLabel* primary_label = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkGrid* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* select_label = NULL;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkTreeView* treeview = NULL;
	GtkTreeView* _tmp38_;
	GtkTreeView* _tmp39_;
	GtkTreeView* _tmp40_;
	GtkTreeView* _tmp41_;
	GtkListStore* _tmp42_;
	GtkTreeView* _tmp57_;
	GtkListStore* _tmp58_;
	GtkCellRendererToggle* renderer1 = NULL;
	GtkCellRendererToggle* _tmp59_;
	GtkCellRendererToggle* _tmp60_;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererToggle* _tmp61_;
	GtkTreeViewColumn* _tmp62_;
	GtkTreeView* _tmp63_;
	GtkTreeViewColumn* _tmp64_;
	GtkCellRendererText* renderer2 = NULL;
	GtkCellRendererText* _tmp65_;
	GtkCellRendererText* _tmp66_;
	GtkTreeViewColumn* _tmp67_;
	GtkTreeView* _tmp68_;
	GtkTreeViewColumn* _tmp69_;
	GtkScrolledWindow* sw = NULL;
	GtkTreeView* _tmp70_;
	GtkScrolledWindow* _tmp71_;
	GtkScrolledWindow* _tmp72_;
	GtkScrolledWindow* _tmp73_;
	GtkGrid* _tmp74_;
	GtkScrolledWindow* _tmp75_;
	GtkLabel* secondary_label = NULL;
	GtkLabel* _tmp76_;
	GtkLabel* _tmp77_;
	GtkLabel* _tmp78_;
	GtkLabel* _tmp79_;
	GtkGrid* _tmp80_;
	GtkLabel* _tmp81_;
	GtkGrid* _tmp82_;
	gint resp = 0;
	GtkDialog* _tmp83_;
	GtkDialog* _tmp111_;
#line 32 "dialogs.vala"
	g_return_if_fail (window != NULL);
#line 32 "dialogs.vala"
	g_return_if_fail (unsaved_docs != NULL);
#line 32 "dialogs.vala"
	_data12_ = g_slice_new0 (Block12Data);
#line 32 "dialogs.vala"
	_data12_->_ref_count_ = 1;
#line 35 "dialogs.vala"
	_tmp0_ = gee_collection_get_size ((GeeCollection*) unsaved_docs);
#line 35 "dialogs.vala"
	_tmp1_ = _tmp0_;
#line 35 "dialogs.vala"
	g_return_if_fail (_tmp1_ >= 2);
#line 37 "dialogs.vala"
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, _ ("Close _without Saving"), GTK_RESPONSE_CLOSE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save"), GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 37 "dialogs.vala"
	g_object_ref_sink (_tmp2_);
#line 37 "dialogs.vala"
	dialog = _tmp2_;
#line 45 "dialogs.vala"
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
#line 45 "dialogs.vala"
	g_object_ref_sink (_tmp3_);
#line 45 "dialogs.vala"
	grid = _tmp3_;
#line 46 "dialogs.vala"
	_tmp4_ = grid;
#line 46 "dialogs.vala"
	gtk_grid_set_column_spacing (_tmp4_, (guint) 12);
#line 47 "dialogs.vala"
	_tmp5_ = grid;
#line 47 "dialogs.vala"
	gtk_grid_set_row_spacing (_tmp5_, (guint) 8);
#line 48 "dialogs.vala"
	_tmp6_ = grid;
#line 48 "dialogs.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp6_, (guint) 5);
#line 50 "dialogs.vala"
	_tmp7_ = dialog;
#line 50 "dialogs.vala"
	_tmp8_ = gtk_dialog_get_content_area (_tmp7_);
#line 50 "dialogs.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_box_get_type ()) ? ((GtkBox*) _tmp8_) : NULL);
#line 50 "dialogs.vala"
	content_area = _tmp9_;
#line 51 "dialogs.vala"
	_tmp10_ = content_area;
#line 51 "dialogs.vala"
	_tmp11_ = grid;
#line 51 "dialogs.vala"
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
#line 54 "dialogs.vala"
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
#line 54 "dialogs.vala"
	g_object_ref_sink (_tmp12_);
#line 54 "dialogs.vala"
	image = _tmp12_;
#line 55 "dialogs.vala"
	_tmp13_ = image;
#line 55 "dialogs.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
#line 56 "dialogs.vala"
	_tmp14_ = grid;
#line 56 "dialogs.vala"
	_tmp15_ = image;
#line 56 "dialogs.vala"
	gtk_grid_attach (_tmp14_, (GtkWidget*) _tmp15_, 0, 0, 1, 4);
#line 59 "dialogs.vala"
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
#line 59 "dialogs.vala"
	g_object_ref_sink (_tmp16_);
#line 59 "dialogs.vala"
	primary_label = _tmp16_;
#line 60 "dialogs.vala"
	_tmp17_ = primary_label;
#line 60 "dialogs.vala"
	gtk_label_set_line_wrap (_tmp17_, TRUE);
#line 61 "dialogs.vala"
	_tmp18_ = primary_label;
#line 61 "dialogs.vala"
	gtk_label_set_use_markup (_tmp18_, TRUE);
#line 62 "dialogs.vala"
	_tmp19_ = primary_label;
#line 62 "dialogs.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
#line 63 "dialogs.vala"
	_tmp20_ = primary_label;
#line 63 "dialogs.vala"
	gtk_label_set_selectable (_tmp20_, TRUE);
#line 64 "dialogs.vala"
	_tmp21_ = primary_label;
#line 64 "dialogs.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp21_, 4);
#line 65 "dialogs.vala"
	_tmp22_ = primary_label;
#line 65 "dialogs.vala"
	_tmp23_ = gee_collection_get_size ((GeeCollection*) unsaved_docs);
#line 65 "dialogs.vala"
	_tmp24_ = _tmp23_;
#line 65 "dialogs.vala"
	_tmp25_ = g_strdup_printf (_ ("There are %d documents with unsaved changes. Save changes before closi" \
"ng?"), _tmp24_);
#line 65 "dialogs.vala"
	_tmp26_ = _tmp25_;
#line 65 "dialogs.vala"
	_tmp27_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _tmp26_, NULL);
#line 65 "dialogs.vala"
	_tmp28_ = _tmp27_;
#line 65 "dialogs.vala"
	_tmp29_ = g_strconcat (_tmp28_, "</span>", NULL);
#line 65 "dialogs.vala"
	_tmp30_ = _tmp29_;
#line 65 "dialogs.vala"
	gtk_label_set_markup (_tmp22_, _tmp30_);
#line 65 "dialogs.vala"
	_g_free0 (_tmp30_);
#line 65 "dialogs.vala"
	_g_free0 (_tmp28_);
#line 65 "dialogs.vala"
	_g_free0 (_tmp26_);
#line 70 "dialogs.vala"
	_tmp31_ = grid;
#line 70 "dialogs.vala"
	_tmp32_ = primary_label;
#line 70 "dialogs.vala"
	gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 1, 0, 1, 1);
#line 72 "dialogs.vala"
	_tmp33_ = (GtkLabel*) gtk_label_new (_ ("Select the documents you want to save:"));
#line 72 "dialogs.vala"
	g_object_ref_sink (_tmp33_);
#line 72 "dialogs.vala"
	select_label = _tmp33_;
#line 73 "dialogs.vala"
	_tmp34_ = select_label;
#line 73 "dialogs.vala"
	gtk_label_set_line_wrap (_tmp34_, TRUE);
#line 74 "dialogs.vala"
	_tmp35_ = select_label;
#line 74 "dialogs.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp35_, GTK_ALIGN_START);
#line 75 "dialogs.vala"
	_tmp36_ = grid;
#line 75 "dialogs.vala"
	_tmp37_ = select_label;
#line 75 "dialogs.vala"
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 1, 1, 1, 1);
#line 78 "dialogs.vala"
	_tmp38_ = (GtkTreeView*) gtk_tree_view_new ();
#line 78 "dialogs.vala"
	g_object_ref_sink (_tmp38_);
#line 78 "dialogs.vala"
	treeview = _tmp38_;
#line 79 "dialogs.vala"
	_tmp39_ = treeview;
#line 79 "dialogs.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp39_, 260, 120);
#line 80 "dialogs.vala"
	_tmp40_ = treeview;
#line 80 "dialogs.vala"
	gtk_tree_view_set_headers_visible (_tmp40_, FALSE);
#line 81 "dialogs.vala"
	_tmp41_ = treeview;
#line 81 "dialogs.vala"
	gtk_tree_view_set_enable_search (_tmp41_, FALSE);
#line 83 "dialogs.vala"
	_tmp42_ = gtk_list_store_new ((gint) DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, TYPE_DOCUMENT, -1);
#line 83 "dialogs.vala"
	_data12_->store = _tmp42_;
#line 504 "dialogs.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp43_;
		gint _doc_size = 0;
		GeeList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _doc_index = 0;
#line 87 "dialogs.vala"
		_tmp43_ = _g_object_ref0 (unsaved_docs);
#line 87 "dialogs.vala"
		_doc_list = _tmp43_;
#line 87 "dialogs.vala"
		_tmp44_ = _doc_list;
#line 87 "dialogs.vala"
		_tmp45_ = gee_collection_get_size ((GeeCollection*) _tmp44_);
#line 87 "dialogs.vala"
		_tmp46_ = _tmp45_;
#line 87 "dialogs.vala"
		_doc_size = _tmp46_;
#line 87 "dialogs.vala"
		_doc_index = -1;
#line 87 "dialogs.vala"
		while (TRUE) {
#line 529 "dialogs.c"
			Document* doc = NULL;
			GeeList* _tmp47_;
			gpointer _tmp48_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp49_;
			GtkTreeIter _tmp50_ = {0};
			GtkListStore* _tmp51_;
			GtkTreeIter _tmp52_;
			Document* _tmp53_;
			TeplFile* _tmp54_;
			const gchar* _tmp55_;
			Document* _tmp56_;
#line 87 "dialogs.vala"
			_doc_index = _doc_index + 1;
#line 87 "dialogs.vala"
			if (!(_doc_index < _doc_size)) {
#line 87 "dialogs.vala"
				break;
#line 548 "dialogs.c"
			}
#line 87 "dialogs.vala"
			_tmp47_ = _doc_list;
#line 87 "dialogs.vala"
			_tmp48_ = gee_list_get (_tmp47_, _doc_index);
#line 87 "dialogs.vala"
			doc = (Document*) _tmp48_;
#line 90 "dialogs.vala"
			_tmp49_ = _data12_->store;
#line 90 "dialogs.vala"
			gtk_list_store_append (_tmp49_, &_tmp50_);
#line 90 "dialogs.vala"
			iter = _tmp50_;
#line 91 "dialogs.vala"
			_tmp51_ = _data12_->store;
#line 91 "dialogs.vala"
			_tmp52_ = iter;
#line 91 "dialogs.vala"
			_tmp53_ = doc;
#line 91 "dialogs.vala"
			_tmp54_ = tepl_buffer_get_file ((TeplBuffer*) _tmp53_);
#line 91 "dialogs.vala"
			_tmp55_ = tepl_file_get_short_name (_tmp54_);
#line 91 "dialogs.vala"
			_tmp56_ = doc;
#line 91 "dialogs.vala"
			gtk_list_store_set (_tmp51_, &_tmp52_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, TRUE, DIALOGS_UNSAVED_DOC_COLUMN_NAME, _tmp55_, DIALOGS_UNSAVED_DOC_COLUMN_DOC, _tmp56_, -1, -1);
#line 87 "dialogs.vala"
			_g_object_unref0 (doc);
#line 578 "dialogs.c"
		}
#line 87 "dialogs.vala"
		_g_object_unref0 (_doc_list);
#line 582 "dialogs.c"
	}
#line 98 "dialogs.vala"
	_tmp57_ = treeview;
#line 98 "dialogs.vala"
	_tmp58_ = _data12_->store;
#line 98 "dialogs.vala"
	gtk_tree_view_set_model (_tmp57_, (GtkTreeModel*) _tmp58_);
#line 99 "dialogs.vala"
	_tmp59_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
#line 99 "dialogs.vala"
	g_object_ref_sink (_tmp59_);
#line 99 "dialogs.vala"
	renderer1 = _tmp59_;
#line 101 "dialogs.vala"
	_tmp60_ = renderer1;
#line 101 "dialogs.vala"
	g_signal_connect_data (_tmp60_, "toggled", (GCallback) ___lambda19__gtk_cell_renderer_toggle_toggled, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 112 "dialogs.vala"
	_tmp61_ = renderer1;
#line 112 "dialogs.vala"
	_tmp62_ = gtk_tree_view_column_new_with_attributes ("Save?", (GtkCellRenderer*) _tmp61_, "active", DIALOGS_UNSAVED_DOC_COLUMN_SAVE, NULL, NULL);
#line 112 "dialogs.vala"
	g_object_ref_sink (_tmp62_);
#line 112 "dialogs.vala"
	column = _tmp62_;
#line 114 "dialogs.vala"
	_tmp63_ = treeview;
#line 114 "dialogs.vala"
	_tmp64_ = column;
#line 114 "dialogs.vala"
	gtk_tree_view_append_column (_tmp63_, _tmp64_);
#line 116 "dialogs.vala"
	_tmp65_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 116 "dialogs.vala"
	g_object_ref_sink (_tmp65_);
#line 116 "dialogs.vala"
	renderer2 = _tmp65_;
#line 117 "dialogs.vala"
	_tmp66_ = renderer2;
#line 117 "dialogs.vala"
	_tmp67_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) _tmp66_, "text", DIALOGS_UNSAVED_DOC_COLUMN_NAME, NULL, NULL);
#line 117 "dialogs.vala"
	g_object_ref_sink (_tmp67_);
#line 117 "dialogs.vala"
	_g_object_unref0 (column);
#line 117 "dialogs.vala"
	column = _tmp67_;
#line 119 "dialogs.vala"
	_tmp68_ = treeview;
#line 119 "dialogs.vala"
	_tmp69_ = column;
#line 119 "dialogs.vala"
	gtk_tree_view_append_column (_tmp68_, _tmp69_);
#line 122 "dialogs.vala"
	_tmp70_ = treeview;
#line 122 "dialogs.vala"
	_tmp71_ = utils_add_scrollbar ((GtkWidget*) _tmp70_);
#line 122 "dialogs.vala"
	sw = _tmp71_;
#line 123 "dialogs.vala"
	_tmp72_ = sw;
#line 123 "dialogs.vala"
	gtk_scrolled_window_set_shadow_type (_tmp72_, GTK_SHADOW_IN);
#line 124 "dialogs.vala"
	_tmp73_ = sw;
#line 124 "dialogs.vala"
	g_object_set ((GtkWidget*) _tmp73_, "expand", TRUE, NULL);
#line 125 "dialogs.vala"
	_tmp74_ = grid;
#line 125 "dialogs.vala"
	_tmp75_ = sw;
#line 125 "dialogs.vala"
	gtk_grid_attach (_tmp74_, (GtkWidget*) _tmp75_, 1, 2, 1, 1);
#line 128 "dialogs.vala"
	_tmp76_ = (GtkLabel*) gtk_label_new (_ ("If you don’t save, all your changes will be permanently lost."));
#line 128 "dialogs.vala"
	g_object_ref_sink (_tmp76_);
#line 128 "dialogs.vala"
	secondary_label = _tmp76_;
#line 130 "dialogs.vala"
	_tmp77_ = secondary_label;
#line 130 "dialogs.vala"
	gtk_label_set_line_wrap (_tmp77_, TRUE);
#line 131 "dialogs.vala"
	_tmp78_ = secondary_label;
#line 131 "dialogs.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp78_, GTK_ALIGN_START);
#line 132 "dialogs.vala"
	_tmp79_ = secondary_label;
#line 132 "dialogs.vala"
	gtk_label_set_selectable (_tmp79_, TRUE);
#line 133 "dialogs.vala"
	_tmp80_ = grid;
#line 133 "dialogs.vala"
	_tmp81_ = secondary_label;
#line 133 "dialogs.vala"
	gtk_grid_attach (_tmp80_, (GtkWidget*) _tmp81_, 1, 3, 1, 1);
#line 135 "dialogs.vala"
	_tmp82_ = grid;
#line 135 "dialogs.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp82_);
#line 137 "dialogs.vala"
	_tmp83_ = dialog;
#line 137 "dialogs.vala"
	resp = gtk_dialog_run (_tmp83_);
#line 140 "dialogs.vala"
	if (resp == ((gint) GTK_RESPONSE_CLOSE)) {
#line 141 "dialogs.vala"
		main_window_remove_all_tabs (window);
#line 692 "dialogs.c"
	} else {
#line 144 "dialogs.vala"
		if (resp == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 696 "dialogs.c"
			GList* selected_docs = NULL;
			GtkTreeIter iter = {0};
			gboolean valid = FALSE;
			GtkListStore* _tmp93_;
			GtkTreeIter _tmp94_ = {0};
			gboolean _tmp95_;
			GList* _tmp106_;
			{
				GeeList* _doc_list = NULL;
				GeeList* _tmp84_;
				gint _doc_size = 0;
				GeeList* _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				gint _doc_index = 0;
#line 147 "dialogs.vala"
				_tmp84_ = main_window_get_documents (window);
#line 147 "dialogs.vala"
				_doc_list = _tmp84_;
#line 147 "dialogs.vala"
				_tmp85_ = _doc_list;
#line 147 "dialogs.vala"
				_tmp86_ = gee_collection_get_size ((GeeCollection*) _tmp85_);
#line 147 "dialogs.vala"
				_tmp87_ = _tmp86_;
#line 147 "dialogs.vala"
				_doc_size = _tmp87_;
#line 147 "dialogs.vala"
				_doc_index = -1;
#line 147 "dialogs.vala"
				while (TRUE) {
#line 728 "dialogs.c"
					Document* doc = NULL;
					GeeList* _tmp88_;
					gpointer _tmp89_;
					Document* _tmp90_;
#line 147 "dialogs.vala"
					_doc_index = _doc_index + 1;
#line 147 "dialogs.vala"
					if (!(_doc_index < _doc_size)) {
#line 147 "dialogs.vala"
						break;
#line 739 "dialogs.c"
					}
#line 147 "dialogs.vala"
					_tmp88_ = _doc_list;
#line 147 "dialogs.vala"
					_tmp89_ = gee_list_get (_tmp88_, _doc_index);
#line 147 "dialogs.vala"
					doc = (Document*) _tmp89_;
#line 149 "dialogs.vala"
					_tmp90_ = doc;
#line 149 "dialogs.vala"
					if (!gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp90_)) {
#line 751 "dialogs.c"
						Document* _tmp91_;
						DocumentTab* _tmp92_;
#line 150 "dialogs.vala"
						_tmp91_ = doc;
#line 150 "dialogs.vala"
						_tmp92_ = _tmp91_->tab;
#line 150 "dialogs.vala"
						main_window_close_tab (window, _tmp92_, FALSE);
#line 760 "dialogs.c"
					}
#line 147 "dialogs.vala"
					_g_object_unref0 (doc);
#line 764 "dialogs.c"
				}
#line 147 "dialogs.vala"
				_g_object_unref0 (_doc_list);
#line 768 "dialogs.c"
			}
#line 154 "dialogs.vala"
			selected_docs = NULL;
#line 156 "dialogs.vala"
			_tmp93_ = _data12_->store;
#line 156 "dialogs.vala"
			_tmp95_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp93_, &_tmp94_);
#line 156 "dialogs.vala"
			iter = _tmp94_;
#line 156 "dialogs.vala"
			valid = _tmp95_;
#line 157 "dialogs.vala"
			while (TRUE) {
#line 782 "dialogs.c"
				gboolean selected = FALSE;
				Document* doc = NULL;
				GtkListStore* _tmp96_;
				GtkTreeIter _tmp97_;
				gboolean _tmp98_ = FALSE;
				Document* _tmp99_ = NULL;
				GtkListStore* _tmp104_;
				gboolean _tmp105_;
#line 157 "dialogs.vala"
				if (!valid) {
#line 157 "dialogs.vala"
					break;
#line 795 "dialogs.c"
				}
#line 161 "dialogs.vala"
				_tmp96_ = _data12_->store;
#line 161 "dialogs.vala"
				_tmp97_ = iter;
#line 161 "dialogs.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp96_, &_tmp97_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &_tmp98_, DIALOGS_UNSAVED_DOC_COLUMN_DOC, &_tmp99_, -1, -1);
#line 161 "dialogs.vala"
				selected = _tmp98_;
#line 161 "dialogs.vala"
				_g_object_unref0 (doc);
#line 161 "dialogs.vala"
				doc = _tmp99_;
#line 165 "dialogs.vala"
				if (selected) {
#line 811 "dialogs.c"
					Document* _tmp100_;
					Document* _tmp101_;
#line 166 "dialogs.vala"
					_tmp100_ = doc;
#line 166 "dialogs.vala"
					_tmp101_ = _g_object_ref0 (_tmp100_);
#line 166 "dialogs.vala"
					selected_docs = g_list_prepend (selected_docs, _tmp101_);
#line 820 "dialogs.c"
				} else {
					Document* _tmp102_;
					DocumentTab* _tmp103_;
#line 170 "dialogs.vala"
					_tmp102_ = doc;
#line 170 "dialogs.vala"
					_tmp103_ = _tmp102_->tab;
#line 170 "dialogs.vala"
					main_window_close_tab (window, _tmp103_, TRUE);
#line 830 "dialogs.c"
				}
#line 172 "dialogs.vala"
				_tmp104_ = _data12_->store;
#line 172 "dialogs.vala"
				_tmp105_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp104_, &iter);
#line 172 "dialogs.vala"
				valid = _tmp105_;
#line 157 "dialogs.vala"
				_g_object_unref0 (doc);
#line 840 "dialogs.c"
			}
#line 174 "dialogs.vala"
			selected_docs = g_list_reverse (selected_docs);
#line 176 "dialogs.vala"
			_tmp106_ = selected_docs;
#line 846 "dialogs.c"
			{
				GList* doc_collection = NULL;
				GList* doc_it = NULL;
#line 176 "dialogs.vala"
				doc_collection = _tmp106_;
#line 176 "dialogs.vala"
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
#line 854 "dialogs.c"
					Document* _tmp107_;
					Document* doc = NULL;
#line 176 "dialogs.vala"
					_tmp107_ = _g_object_ref0 ((Document*) doc_it->data);
#line 176 "dialogs.vala"
					doc = _tmp107_;
#line 861 "dialogs.c"
					{
						Document* _tmp108_;
#line 178 "dialogs.vala"
						_tmp108_ = doc;
#line 178 "dialogs.vala"
						if (main_window_save_document (window, _tmp108_, FALSE)) {
#line 868 "dialogs.c"
							Document* _tmp109_;
							DocumentTab* _tmp110_;
#line 179 "dialogs.vala"
							_tmp109_ = doc;
#line 179 "dialogs.vala"
							_tmp110_ = _tmp109_->tab;
#line 179 "dialogs.vala"
							main_window_close_tab (window, _tmp110_, TRUE);
#line 877 "dialogs.c"
						}
#line 176 "dialogs.vala"
						_g_object_unref0 (doc);
#line 881 "dialogs.c"
					}
				}
			}
#line 144 "dialogs.vala"
			(selected_docs == NULL) ? NULL : (selected_docs = (_g_list_free__g_object_unref0_ (selected_docs), NULL));
#line 887 "dialogs.c"
		}
	}
#line 183 "dialogs.vala"
	_tmp111_ = dialog;
#line 183 "dialogs.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp111_);
#line 32 "dialogs.vala"
	_g_object_unref0 (secondary_label);
#line 32 "dialogs.vala"
	_g_object_unref0 (sw);
#line 32 "dialogs.vala"
	_g_object_unref0 (renderer2);
#line 32 "dialogs.vala"
	_g_object_unref0 (column);
#line 32 "dialogs.vala"
	_g_object_unref0 (renderer1);
#line 32 "dialogs.vala"
	_g_object_unref0 (treeview);
#line 32 "dialogs.vala"
	_g_object_unref0 (select_label);
#line 32 "dialogs.vala"
	_g_object_unref0 (primary_label);
#line 32 "dialogs.vala"
	_g_object_unref0 (image);
#line 32 "dialogs.vala"
	_g_object_unref0 (content_area);
#line 32 "dialogs.vala"
	_g_object_unref0 (grid);
#line 32 "dialogs.vala"
	_g_object_unref0 (dialog);
#line 32 "dialogs.vala"
	block12_data_unref (_data12_);
#line 32 "dialogs.vala"
	_data12_ = NULL;
#line 922 "dialogs.c"
}

