/* document.c generated by valac 0.40.10, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <tepl/tepl.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <latexila.h>
#include <glib/gstdio.h>


#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
enum  {
	DOCUMENT_0_PROPERTY,
	DOCUMENT_LOCATION_PROPERTY,
	DOCUMENT_READONLY_PROPERTY,
	DOCUMENT_PROJECT_ID_PROPERTY,
	DOCUMENT_NUM_PROPERTIES
};
static GParamSpec* document_properties[DOCUMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
	GFileInfo* _metadata_info;
};

struct _Block15Data {
	int _ref_count_;
	Document* self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};


static gpointer document_parent_class = NULL;

GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
GType document_structure_get_type (void) G_GNUC_CONST;
#define DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT, DocumentPrivate))
Document* document_new (void);
Document* document_construct (GType object_type);
static void __lambda43_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda43__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda44_ (Document* self);
static void ___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_document_view (DocumentTab* self);
static gboolean __lambda38_ (Block15Data* _data15_);
static gboolean ___lambda38__gsource_func (gpointer self);
void document_load (Document* self,
                    GFile* location);
void document_set_location (Document* self,
                            GFile* value);
void document_set_contents (Document* self,
                            const gchar* contents);
static gchar* document_to_utf8 (Document* self,
                         const gchar* text,
                         GError** error);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
GFile* document_get_location (Document* self);
static void document_save_metadata (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda16_ (Block16Data* _data16_,
                    gint response_id);
static void _____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                           gint response_id,
                                           gpointer self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self,
                              gint value);
gchar* document_get_uri_for_display (Document* self);
gchar* document_get_short_name_for_display (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
void document_uncomment_selected_lines (Document* self);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self,
                       gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
void document_structure_parse (DocumentStructure* self);
gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda27_ (Block17Data* _data17_,
                  gint response_id);
GType main_window_get_type (void) G_GNUC_CONST;
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
static void ___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                         gint response_id,
                                         gpointer self);
void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
gchar* document_get_metadata (Document* self,
                              const gchar* key);
gboolean document_get_readonly (Document* self);
void document_set_readonly (Document* self,
                            gboolean value);
static void document_finalize (GObject * obj);
static void _vala_document_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_document_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

static gpointer
_g_object_ref0 (gpointer self)
{
#line 43 "/home/seb/gnome/gnome-latex/src/document.vala"
	return self ? g_object_ref (self) : NULL;
#line 294 "document.c"
}


static void
__lambda43_ (Document* self)
{
#line 48 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_update_syntax_highlighting (self);
#line 49 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_update_project_id (self);
#line 305 "document.c"
}


static void
___lambda43__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 46 "/home/seb/gnome/gnome-latex/src/document.vala"
	__lambda43_ ((Document*) self);
#line 316 "document.c"
}


static void
__lambda44_ (Document* self)
{
#line 54 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->new_file = FALSE;
#line 325 "document.c"
}


static void
___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
#line 52 "/home/seb/gnome/gnome-latex/src/document.vala"
	__lambda44_ ((Document*) self);
#line 335 "document.c"
}


Document*
document_construct (GType object_type)
{
	Document * self = NULL;
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	GSettings* editor_settings = NULL;
	GSettings* _tmp3_;
	TeplFile* _tmp4_;
#line 35 "/home/seb/gnome/gnome-latex/src/document.vala"
	self = (Document*) g_object_new (object_type, NULL);
#line 40 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_object_ref ((GObject*) self);
#line 43 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 43 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 43 "/home/seb/gnome/gnome-latex/src/document.vala"
	lm = _tmp1_;
#line 44 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
#line 44 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
#line 46 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda43__g_object_notify, self, 0);
#line 52 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda44__gtk_text_buffer_changed, self, 0);
#line 57 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp3_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 57 "/home/seb/gnome/gnome-latex/src/document.vala"
	editor_settings = _tmp3_;
#line 59 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_settings_bind (editor_settings, "scheme", (GObject*) self, "tepl-style-scheme-id", G_SETTINGS_BIND_GET);
#line 64 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 64 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_object_bind_property_with_closures ((GObject*) self, "location", (GObject*) _tmp4_, "location", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 35 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (editor_settings);
#line 35 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (lm);
#line 35 "/home/seb/gnome/gnome-latex/src/document.vala"
	return self;
#line 384 "document.c"
}


Document*
document_new (void)
{
#line 35 "/home/seb/gnome/gnome-latex/src/document.vala"
	return document_construct (TYPE_DOCUMENT);
#line 393 "document.c"
}


static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	return _data15_;
#line 404 "document.c"
}


static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 415 "document.c"
		Document* self;
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
		self = _data15_->self;
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (_data15_->completion);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (self);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_slice_free (Block15Data, _data15_);
#line 425 "document.c"
	}
}


static gboolean
__lambda38_ (Block15Data* _data15_)
{
	Document* self;
	gboolean result = FALSE;
	GtkSourceCompletion* _tmp0_;
#line 82 "/home/seb/gnome/gnome-latex/src/document.vala"
	self = _data15_->self;
#line 84 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = _data15_->completion;
#line 84 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ != NULL) {
#line 442 "document.c"
		GtkSourceCompletion* _tmp1_;
#line 85 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = _data15_->completion;
#line 85 "/home/seb/gnome/gnome-latex/src/document.vala"
		gtk_source_completion_unblock_interactive (_tmp1_);
#line 448 "document.c"
	}
#line 87 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = FALSE;
#line 87 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 454 "document.c"
}


static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ (self);
#line 82 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 465 "document.c"
}


void
document_insert (Document* self,
                 GtkTextIter* iter,
                 const gchar* text,
                 gint len)
{
	Block15Data* _data15_;
	DocumentTab* _tmp0_;
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (iter != NULL);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (text != NULL);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data15_->_ref_count_ = 1;
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data15_->self = g_object_ref (self);
#line 70 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data15_->completion = NULL;
#line 72 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->tab;
#line 72 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ != NULL) {
#line 495 "document.c"
		DocumentTab* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		GtkSourceCompletion* _tmp7_;
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = self->tab;
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = document_tab_get_document_view (_tmp1_);
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = _tmp2_;
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp5_ = _tmp4_;
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (_data15_->completion);
#line 74 "/home/seb/gnome/gnome-latex/src/document.vala"
		_data15_->completion = _tmp6_;
#line 75 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp7_ = _data15_->completion;
#line 75 "/home/seb/gnome/gnome-latex/src/document.vala"
		gtk_source_completion_block_interactive (_tmp7_);
#line 523 "document.c"
	}
#line 78 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, tepl_buffer_get_type (), TeplBuffer), iter, text, len);
#line 82 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda38__gsource_func, block15_data_ref (_data15_), block15_data_unref);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	block15_data_unref (_data15_);
#line 68 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data15_ = NULL;
#line 533 "document.c"
}


void
document_load (Document* self,
               GFile* location)
{
	GError * _inner_error_ = NULL;
#line 91 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (location != NULL);
#line 546 "document.c"
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
#line 97 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = g_file_query_info (location, "metadata::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 97 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp0_ = _tmp1_;
#line 97 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 557 "document.c"
			goto __catch8_g_error;
		}
#line 97 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = _tmp0_;
#line 97 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp0_ = NULL;
#line 97 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (self->priv->_metadata_info);
#line 97 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_metadata_info = _tmp2_;
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (_tmp0_);
#line 570 "document.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GFileInfo* _tmp5_;
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
		e = _inner_error_;
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
		_inner_error_ = NULL;
#line 101 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = e;
#line 101 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp4_ = _tmp3_->message;
#line 101 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_warning ("document.vala:101: Get document metadata failed: %s", _tmp4_);
#line 102 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp5_ = g_file_info_new ();
#line 102 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (self->priv->_metadata_info);
#line 102 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_metadata_info = _tmp5_;
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_error_free0 (e);
#line 597 "document.c"
	}
	__finally8:
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 95 "/home/seb/gnome/gnome-latex/src/document.vala"
		return;
#line 608 "document.c"
	}
#line 105 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_set_location (self, location);
#line 612 "document.c"
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp6_ = NULL;
		gsize _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* text = NULL;
		guint8* _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gboolean _tmp11_;
		GtkRecentManager* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_file_load_contents (location, NULL, &_tmp6_, &_tmp7_, &_tmp8_, &_inner_error_);
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		chars = (g_free (chars), NULL);
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		chars = _tmp6_;
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		chars_length1 = _tmp7_;
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		_chars_size_ = chars_length1;
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (self->priv->_etag);
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_etag = _tmp8_;
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 110 "/home/seb/gnome/gnome-latex/src/document.vala"
			chars = (g_free (chars), NULL);
#line 646 "document.c"
			goto __catch9_g_error;
		}
#line 111 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp9_ = chars;
#line 111 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp9__length1 = chars_length1;
#line 111 "/home/seb/gnome/gnome-latex/src/document.vala"
		chars = NULL;
#line 111 "/home/seb/gnome/gnome-latex/src/document.vala"
		chars_length1 = 0;
#line 111 "/home/seb/gnome/gnome-latex/src/document.vala"
		text = (gchar*) _tmp9_;
#line 113 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp10_ = text;
#line 113 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp11_ = g_utf8_validate (_tmp10_, (gssize) -1, NULL);
#line 113 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (_tmp11_) {
#line 665 "document.c"
			const gchar* _tmp12_;
#line 114 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp12_ = text;
#line 114 "/home/seb/gnome/gnome-latex/src/document.vala"
			document_set_contents (self, _tmp12_);
#line 671 "document.c"
		} else {
			gchar* utf8_text = NULL;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
#line 119 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp13_ = text;
#line 119 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp14_ = document_to_utf8 (self, _tmp13_, &_inner_error_);
#line 119 "/home/seb/gnome/gnome-latex/src/document.vala"
			utf8_text = _tmp14_;
#line 119 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 119 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_free0 (text);
#line 119 "/home/seb/gnome/gnome-latex/src/document.vala"
				chars = (g_free (chars), NULL);
#line 689 "document.c"
				goto __catch9_g_error;
			}
#line 120 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp15_ = utf8_text;
#line 120 "/home/seb/gnome/gnome-latex/src/document.vala"
			document_set_contents (self, _tmp15_);
#line 113 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (utf8_text);
#line 698 "document.c"
		}
#line 123 "/home/seb/gnome/gnome-latex/src/document.vala"
		document_update_syntax_highlighting (self);
#line 125 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp16_ = gtk_recent_manager_get_default ();
#line 125 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp17_ = g_file_get_uri (location);
#line 125 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp18_ = _tmp17_;
#line 125 "/home/seb/gnome/gnome-latex/src/document.vala"
		gtk_recent_manager_add_item (_tmp16_, _tmp18_);
#line 125 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (_tmp18_);
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (text);
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		chars = (g_free (chars), NULL);
#line 716 "document.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		DocumentTab* _tmp21_;
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		e = _inner_error_;
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		_inner_error_ = NULL;
#line 129 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp19_ = e;
#line 129 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp20_ = _tmp19_->message;
#line 129 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_warning ("document.vala:129: %s", _tmp20_);
#line 131 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp21_ = self->tab;
#line 131 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (_tmp21_ != NULL) {
#line 739 "document.c"
			gchar* primary_msg = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			TeplInfoBar* infobar = NULL;
			const gchar* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			TeplInfoBar* _tmp29_;
			DocumentTab* _tmp30_;
			TeplInfoBar* _tmp31_;
			TeplInfoBar* _tmp32_;
#line 133 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp22_ = g_file_get_parse_name (location);
#line 133 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp23_ = _tmp22_;
#line 133 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp24_ = g_strdup_printf (_ ("Impossible to load the file “%s”."), _tmp23_);
#line 133 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp25_ = _tmp24_;
#line 133 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (_tmp23_);
#line 133 "/home/seb/gnome/gnome-latex/src/document.vala"
			primary_msg = _tmp25_;
#line 135 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp26_ = primary_msg;
#line 135 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp27_ = e;
#line 135 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp28_ = _tmp27_->message;
#line 135 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp29_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp26_, _tmp28_);
#line 135 "/home/seb/gnome/gnome-latex/src/document.vala"
			g_object_ref_sink (_tmp29_);
#line 135 "/home/seb/gnome/gnome-latex/src/document.vala"
			infobar = _tmp29_;
#line 137 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp30_ = self->tab;
#line 137 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp31_ = infobar;
#line 137 "/home/seb/gnome/gnome-latex/src/document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp30_, (GtkInfoBar*) _tmp31_);
#line 138 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp32_ = infobar;
#line 138 "/home/seb/gnome/gnome-latex/src/document.vala"
			gtk_widget_show ((GtkWidget*) _tmp32_);
#line 131 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_object_unref0 (infobar);
#line 131 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (primary_msg);
#line 791 "document.c"
		}
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_error_free0 (e);
#line 795 "document.c"
	}
	__finally9:
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 107 "/home/seb/gnome/gnome-latex/src/document.vala"
		return;
#line 806 "document.c"
	}
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1180 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 825 "document.c"
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
#line 1425 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1426 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1426 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1426 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1427 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 851 "document.c"
		glong _tmp2_;
#line 1428 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = string_length;
#line 1428 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		start = _tmp2_ + start;
#line 857 "document.c"
	}
#line 1430 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 861 "document.c"
		glong _tmp3_;
#line 1431 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1431 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		end = _tmp3_ + end;
#line 867 "document.c"
	}
#line 1433 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 871 "document.c"
		glong _tmp5_;
#line 1433 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1433 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = start <= _tmp5_;
#line 877 "document.c"
	} else {
#line 1433 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = FALSE;
#line 881 "document.c"
	}
#line 1433 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp4_, NULL);
#line 1434 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 887 "document.c"
		glong _tmp7_;
#line 1434 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = string_length;
#line 1434 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = end <= _tmp7_;
#line 893 "document.c"
	} else {
#line 1434 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = FALSE;
#line 897 "document.c"
	}
#line 1434 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp6_, NULL);
#line 1435 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1436 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1436 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp8_;
#line 1436 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 909 "document.c"
}


void
document_set_contents (Document* self,
                       const gchar* contents)
{
	gchar* contents2 = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
#line 143 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 143 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (contents != NULL);
#line 146 "/home/seb/gnome/gnome-latex/src/document.vala"
	contents2 = NULL;
#line 147 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = strlen (contents);
#line 147 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = _tmp0_;
#line 147 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (string_get (contents, (glong) (_tmp1_ - 1)) == '\n') {
#line 937 "document.c"
		gchar* _tmp2_;
#line 148 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = string_slice (contents, (glong) 0, (glong) -1);
#line 148 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (contents2);
#line 148 "/home/seb/gnome/gnome-latex/src/document.vala"
		contents2 = _tmp2_;
#line 945 "document.c"
	}
#line 150 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
#line 151 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = contents2;
#line 151 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp3_ = _tmp4_;
#line 151 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp3_ == NULL) {
#line 151 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = contents;
#line 957 "document.c"
	}
#line 151 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp3_, -1);
#line 152 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->new_file = TRUE;
#line 153 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 154 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
#line 158 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp5_);
#line 158 "/home/seb/gnome/gnome-latex/src/document.vala"
	iter = _tmp5_;
#line 159 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp6_ = iter;
#line 159 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
#line 143 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (contents2);
#line 977 "document.c"
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1512 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1513 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = self;
#line 1513 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 991 "document.c"
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1498 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1499 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1499 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1499 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1500 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1500 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1500 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1500 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1038 "document.c"
	}
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1501 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1044 "document.c"
}


static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
	return _data16_;
#line 1055 "document.c"
}


static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1066 "document.c"
		Document* self;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
		self = _data16_->self;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (_data16_->infobar);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (self);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_slice_free (Block16Data, _data16_);
#line 1076 "document.c"
	}
}


static void
____lambda16_ (Block16Data* _data16_,
               gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp0_;
#line 227 "/home/seb/gnome/gnome-latex/src/document.vala"
	self = _data16_->self;
#line 229 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 230 "/home/seb/gnome/gnome-latex/src/document.vala"
		document_save (self, FALSE, FALSE);
#line 1093 "document.c"
	}
#line 231 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = _data16_->infobar;
#line 231 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1099 "document.c"
}


static void
_____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                      gint response_id,
                                      gpointer self)
{
#line 227 "/home/seb/gnome/gnome-latex/src/document.vala"
	____lambda16_ (self, response_id);
#line 1110 "document.c"
}


void
document_save (Document* self,
               gboolean check_file_changed_on_disk,
               gboolean force)
{
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp6_;
	GtkTextIter _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
#line 162 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 164 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_location;
#line 164 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (!force) {
#line 1143 "document.c"
		gboolean _tmp3_;
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = self->priv->new_file;
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = !_tmp3_;
#line 1149 "document.c"
	} else {
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = FALSE;
#line 1153 "document.c"
	}
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp2_) {
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = !gtk_text_buffer_get_modified ((GtkTextBuffer*) self);
#line 1159 "document.c"
	} else {
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = FALSE;
#line 1163 "document.c"
	}
#line 167 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp1_) {
#line 168 "/home/seb/gnome/gnome-latex/src/document.vala"
		return;
#line 1169 "document.c"
	}
#line 172 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp4_, &_tmp5_);
#line 172 "/home/seb/gnome/gnome-latex/src/document.vala"
	start = _tmp4_;
#line 172 "/home/seb/gnome/gnome-latex/src/document.vala"
	end = _tmp5_;
#line 173 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp6_ = start;
#line 173 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp7_ = end;
#line 173 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp8_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp6_, &_tmp7_, FALSE);
#line 173 "/home/seb/gnome/gnome-latex/src/document.vala"
	text = _tmp8_;
#line 176 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp9_ = text;
#line 176 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp10_ = text;
#line 176 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp11_ = strlen (_tmp10_);
#line 176 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp12_ = _tmp11_;
#line 176 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (string_get (_tmp9_, (glong) (_tmp12_ - 1)) != '\n') {
#line 1195 "document.c"
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
#line 177 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp13_ = text;
#line 177 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp14_ = string_to_string (_tmp13_);
#line 177 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
#line 177 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (text);
#line 177 "/home/seb/gnome/gnome-latex/src/document.vala"
		text = _tmp15_;
#line 1209 "document.c"
	}
	{
		GSettings* settings = NULL;
		GSettings* _tmp16_;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_;
		gboolean make_backup = FALSE;
		const gchar* _tmp20_ = NULL;
		gchar* etag = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		GFile* parent = NULL;
		GFile* _tmp39_;
		GFile* _tmp40_;
		gboolean _tmp41_ = FALSE;
		GFile* _tmp42_;
		GFile* _tmp45_;
		const gchar* _tmp46_;
		guint8* _tmp47_;
		gint _tmp47__length1;
		guint8* _tmp48_;
		gint _tmp48__length1;
		const gchar* _tmp49_;
		gboolean _tmp50_;
		gchar* _tmp51_ = NULL;
		GtkRecentManager* _tmp52_;
		GFile* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
#line 181 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp16_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 181 "/home/seb/gnome/gnome-latex/src/document.vala"
		settings = _tmp16_;
#line 183 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp18_ = self->priv->backup_made;
#line 183 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (!_tmp18_) {
#line 1247 "document.c"
			GSettings* _tmp19_;
#line 184 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp19_ = settings;
#line 184 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp17_ = g_settings_get_boolean (_tmp19_, "create-backup-copy");
#line 1253 "document.c"
		} else {
#line 183 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp17_ = FALSE;
#line 1257 "document.c"
		}
#line 183 "/home/seb/gnome/gnome-latex/src/document.vala"
		make_backup = _tmp17_;
#line 186 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (check_file_changed_on_disk) {
#line 1263 "document.c"
			const gchar* _tmp21_;
#line 186 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp21_ = self->priv->_etag;
#line 186 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp20_ = _tmp21_;
#line 1269 "document.c"
		} else {
#line 186 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp20_ = NULL;
#line 1273 "document.c"
		}
#line 186 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp22_ = g_strdup (_tmp20_);
#line 186 "/home/seb/gnome/gnome-latex/src/document.vala"
		etag = _tmp22_;
#line 189 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp23_ = self->priv->encoding;
#line 189 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (_tmp23_ != NULL) {
#line 1283 "document.c"
			gchar* _tmp24_ = NULL;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp25_ = text;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp26_ = text;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp27_ = strlen (_tmp26_);
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp28_ = _tmp27_;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp29_ = self->priv->encoding;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp30_ = g_convert (_tmp25_, (gssize) _tmp28_, _tmp29_, "UTF-8", NULL, NULL, &_inner_error_);
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp24_ = _tmp30_;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_free0 (etag);
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_object_unref0 (settings);
#line 1312 "document.c"
				goto __catch10_g_error;
			}
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp31_ = _tmp24_;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp24_ = NULL;
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (text);
#line 190 "/home/seb/gnome/gnome-latex/src/document.vala"
			text = _tmp31_;
#line 189 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (_tmp24_);
#line 1325 "document.c"
		} else {
			gchar* _tmp32_ = NULL;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp33_ = text;
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp34_ = text;
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp35_ = strlen (_tmp34_);
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp36_ = _tmp35_;
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp37_ = g_filename_from_utf8 (_tmp33_, (gssize) _tmp36_, NULL, NULL, &_inner_error_);
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp32_ = _tmp37_;
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_free0 (etag);
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_object_unref0 (settings);
#line 1352 "document.c"
				goto __catch10_g_error;
			}
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp38_ = _tmp32_;
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp32_ = NULL;
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (text);
#line 194 "/home/seb/gnome/gnome-latex/src/document.vala"
			text = _tmp38_;
#line 189 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (_tmp32_);
#line 1365 "document.c"
		}
#line 197 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp39_ = self->priv->_location;
#line 197 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp40_ = g_file_get_parent (_tmp39_);
#line 197 "/home/seb/gnome/gnome-latex/src/document.vala"
		parent = _tmp40_;
#line 198 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp42_ = parent;
#line 198 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (_tmp42_ != NULL) {
#line 1377 "document.c"
			GFile* _tmp43_;
#line 198 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp43_ = parent;
#line 198 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp41_ = !g_file_query_exists (_tmp43_, NULL);
#line 1383 "document.c"
		} else {
#line 198 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp41_ = FALSE;
#line 1387 "document.c"
		}
#line 198 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (_tmp41_) {
#line 1391 "document.c"
			GFile* _tmp44_;
#line 199 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp44_ = parent;
#line 199 "/home/seb/gnome/gnome-latex/src/document.vala"
			g_file_make_directory_with_parents (_tmp44_, NULL, &_inner_error_);
#line 199 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 199 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_object_unref0 (parent);
#line 199 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_free0 (etag);
#line 199 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_object_unref0 (settings);
#line 1405 "document.c"
				goto __catch10_g_error;
			}
		}
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp45_ = self->priv->_location;
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp46_ = text;
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp47_ = string_get_data (_tmp46_, &_tmp47__length1);
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp48_ = _tmp47_;
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp48__length1 = _tmp47__length1;
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp49_ = etag;
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp50_ = make_backup;
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_file_replace_contents (_tmp45_, _tmp48_, (gsize) _tmp48__length1, _tmp49_, _tmp50_, G_FILE_CREATE_NONE, &_tmp51_, NULL, &_inner_error_);
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (self->priv->_etag);
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_etag = _tmp51_;
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_object_unref0 (parent);
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (etag);
#line 201 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_object_unref0 (settings);
#line 1437 "document.c"
			goto __catch10_g_error;
		}
#line 204 "/home/seb/gnome/gnome-latex/src/document.vala"
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 206 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp52_ = gtk_recent_manager_get_default ();
#line 206 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp53_ = self->priv->_location;
#line 206 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp54_ = g_file_get_uri (_tmp53_);
#line 206 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp55_ = _tmp54_;
#line 206 "/home/seb/gnome/gnome-latex/src/document.vala"
		gtk_recent_manager_add_item (_tmp52_, _tmp55_);
#line 206 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (_tmp55_);
#line 207 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->backup_made = TRUE;
#line 209 "/home/seb/gnome/gnome-latex/src/document.vala"
		document_save_metadata (self);
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (parent);
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (etag);
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (settings);
#line 1464 "document.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		gboolean _tmp56_ = FALSE;
		GError* _tmp57_;
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		e = _inner_error_;
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		_inner_error_ = NULL;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp57_ = e;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (g_error_matches (_tmp57_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
#line 1480 "document.c"
			DocumentTab* _tmp58_;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp58_ = self->tab;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp56_ = _tmp58_ != NULL;
#line 1486 "document.c"
		} else {
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp56_ = FALSE;
#line 1490 "document.c"
		}
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (_tmp56_) {
#line 1494 "document.c"
			Block16Data* _data16_;
			gchar* primary_msg = NULL;
			GFile* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* secondary_msg = NULL;
			gchar* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			TeplInfoBar* _tmp67_;
			TeplInfoBar* _tmp68_;
			TeplInfoBar* _tmp69_;
			DocumentTab* _tmp70_;
			TeplInfoBar* _tmp71_;
			TeplInfoBar* _tmp72_;
			TeplInfoBar* _tmp73_;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_data16_ = g_slice_new0 (Block16Data);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_data16_->_ref_count_ = 1;
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_data16_->self = g_object_ref (self);
#line 215 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp59_ = self->priv->_location;
#line 215 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp60_ = g_file_get_parse_name (_tmp59_);
#line 215 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp61_ = _tmp60_;
#line 215 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp62_ = g_strdup_printf (_ ("The file %s has been modified since reading it."), _tmp61_);
#line 215 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp63_ = _tmp62_;
#line 215 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (_tmp61_);
#line 215 "/home/seb/gnome/gnome-latex/src/document.vala"
			primary_msg = _tmp63_;
#line 217 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp64_ = g_strdup (_ ("If you save it, all the external changes could be lost. Save it anyway" \
"?"));
#line 217 "/home/seb/gnome/gnome-latex/src/document.vala"
			secondary_msg = _tmp64_;
#line 220 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp65_ = primary_msg;
#line 220 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp66_ = secondary_msg;
#line 220 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp67_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp65_, _tmp66_);
#line 220 "/home/seb/gnome/gnome-latex/src/document.vala"
			g_object_ref_sink (_tmp67_);
#line 220 "/home/seb/gnome/gnome-latex/src/document.vala"
			_data16_->infobar = _tmp67_;
#line 222 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp68_ = _data16_->infobar;
#line 222 "/home/seb/gnome/gnome-latex/src/document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp68_, _ ("_Save Anyway"), (gint) GTK_RESPONSE_YES);
#line 223 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp69_ = _data16_->infobar;
#line 223 "/home/seb/gnome/gnome-latex/src/document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp69_, _ ("_Don’t Save"), (gint) GTK_RESPONSE_CANCEL);
#line 224 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp70_ = self->tab;
#line 224 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp71_ = _data16_->infobar;
#line 224 "/home/seb/gnome/gnome-latex/src/document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp70_, (GtkInfoBar*) _tmp71_);
#line 225 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp72_ = _data16_->infobar;
#line 225 "/home/seb/gnome/gnome-latex/src/document.vala"
			gtk_widget_show ((GtkWidget*) _tmp72_);
#line 227 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp73_ = _data16_->infobar;
#line 227 "/home/seb/gnome/gnome-latex/src/document.vala"
			g_signal_connect_data ((GtkInfoBar*) _tmp73_, "response", (GCallback) _____lambda16__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (secondary_msg);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (primary_msg);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			block16_data_unref (_data16_);
#line 213 "/home/seb/gnome/gnome-latex/src/document.vala"
			_data16_ = NULL;
#line 1577 "document.c"
		} else {
			GError* _tmp74_;
			const gchar* _tmp75_;
			DocumentTab* _tmp76_;
#line 236 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp74_ = e;
#line 236 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp75_ = _tmp74_->message;
#line 236 "/home/seb/gnome/gnome-latex/src/document.vala"
			g_warning ("document.vala:236: %s", _tmp75_);
#line 238 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp76_ = self->tab;
#line 238 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (_tmp76_ != NULL) {
#line 1592 "document.c"
				gchar* primary_msg = NULL;
				gchar* _tmp77_;
				TeplInfoBar* infobar = NULL;
				const gchar* _tmp78_;
				GError* _tmp79_;
				const gchar* _tmp80_;
				TeplInfoBar* _tmp81_;
				TeplInfoBar* _tmp82_;
				DocumentTab* _tmp83_;
				TeplInfoBar* _tmp84_;
				TeplInfoBar* _tmp85_;
#line 240 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp77_ = g_strdup (_ ("Impossible to save the file."));
#line 240 "/home/seb/gnome/gnome-latex/src/document.vala"
				primary_msg = _tmp77_;
#line 241 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp78_ = primary_msg;
#line 241 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp79_ = e;
#line 241 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp80_ = _tmp79_->message;
#line 241 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp81_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp78_, _tmp80_);
#line 241 "/home/seb/gnome/gnome-latex/src/document.vala"
				g_object_ref_sink (_tmp81_);
#line 241 "/home/seb/gnome/gnome-latex/src/document.vala"
				infobar = _tmp81_;
#line 243 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp82_ = infobar;
#line 243 "/home/seb/gnome/gnome-latex/src/document.vala"
				tepl_info_bar_add_close_button (_tmp82_);
#line 244 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp83_ = self->tab;
#line 244 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp84_ = infobar;
#line 244 "/home/seb/gnome/gnome-latex/src/document.vala"
				tepl_tab_add_info_bar ((TeplTab*) _tmp83_, (GtkInfoBar*) _tmp84_);
#line 245 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp85_ = infobar;
#line 245 "/home/seb/gnome/gnome-latex/src/document.vala"
				gtk_widget_show ((GtkWidget*) _tmp85_);
#line 238 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_object_unref0 (infobar);
#line 238 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_free0 (primary_msg);
#line 1638 "document.c"
			}
		}
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_error_free0 (e);
#line 1643 "document.c"
	}
	__finally10:
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (text);
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 179 "/home/seb/gnome/gnome-latex/src/document.vala"
		return;
#line 1656 "document.c"
	}
#line 162 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (text);
#line 1660 "document.c"
}


static gchar*
document_to_utf8 (Document* self,
                  const gchar* text,
                  GError** error)
{
	gchar* result = NULL;
	GError* _tmp7_;
	GError * _inner_error_ = NULL;
#line 251 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 251 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 1676 "document.c"
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
#line 253 "/home/seb/gnome/gnome-latex/src/document.vala"
		charset_collection = ENCODINGS_CHARSETS;
#line 253 "/home/seb/gnome/gnome-latex/src/document.vala"
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
#line 253 "/home/seb/gnome/gnome-latex/src/document.vala"
		for (charset_it = 0; charset_it < G_N_ELEMENTS (ENCODINGS_CHARSETS); charset_it = charset_it + 1) {
#line 1688 "document.c"
			gchar* _tmp0_;
			gchar* charset = NULL;
#line 253 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp0_ = g_strdup (charset_collection[charset_it]);
#line 253 "/home/seb/gnome/gnome-latex/src/document.vala"
			charset = _tmp0_;
#line 1695 "document.c"
			{
				{
					gchar* utf8_text = NULL;
					gint _tmp1_;
					gint _tmp2_;
					const gchar* _tmp3_;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp1_ = strlen (text);
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp2_ = _tmp1_;
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp3_ = charset;
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp4_ = g_convert (text, (gssize) _tmp2_, "UTF-8", _tmp3_, NULL, NULL, &_inner_error_);
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
					utf8_text = _tmp4_;
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
						if (_inner_error_->domain == G_CONVERT_ERROR) {
#line 1719 "document.c"
							goto __catch11_g_convert_error;
						}
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
						_g_free0 (charset);
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
						g_clear_error (&_inner_error_);
#line 257 "/home/seb/gnome/gnome-latex/src/document.vala"
						return NULL;
#line 1730 "document.c"
					}
#line 259 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp5_ = charset;
#line 259 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp6_ = g_strdup (_tmp5_);
#line 259 "/home/seb/gnome/gnome-latex/src/document.vala"
					_g_free0 (self->priv->encoding);
#line 259 "/home/seb/gnome/gnome-latex/src/document.vala"
					self->priv->encoding = _tmp6_;
#line 260 "/home/seb/gnome/gnome-latex/src/document.vala"
					result = utf8_text;
#line 260 "/home/seb/gnome/gnome-latex/src/document.vala"
					_g_free0 (charset);
#line 260 "/home/seb/gnome/gnome-latex/src/document.vala"
					return result;
#line 1746 "document.c"
				}
				goto __finally11;
				__catch11_g_convert_error:
				{
					GError* e = NULL;
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					e = _inner_error_;
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					_inner_error_ = NULL;
#line 264 "/home/seb/gnome/gnome-latex/src/document.vala"
					_g_error_free0 (e);
#line 264 "/home/seb/gnome/gnome-latex/src/document.vala"
					_g_free0 (charset);
#line 264 "/home/seb/gnome/gnome-latex/src/document.vala"
					continue;
#line 1762 "document.c"
				}
				__finally11:
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (_inner_error_->domain == G_CONVERT_ERROR) {
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					g_propagate_error (error, _inner_error_);
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					_g_free0 (charset);
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					return NULL;
#line 1773 "document.c"
				} else {
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					_g_free0 (charset);
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					g_clear_error (&_inner_error_);
#line 255 "/home/seb/gnome/gnome-latex/src/document.vala"
					return NULL;
#line 1783 "document.c"
				}
#line 253 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_free0 (charset);
#line 1787 "document.c"
			}
		}
	}
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp7_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _ ("Error trying to convert the document to UTF-8"));
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
	_inner_error_ = _tmp7_;
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_inner_error_->domain == G_CONVERT_ERROR) {
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_propagate_error (error, _inner_error_);
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
		return NULL;
#line 1801 "document.c"
	} else {
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 267 "/home/seb/gnome/gnome-latex/src/document.vala"
		return NULL;
#line 1809 "document.c"
	}
}


static void
document_update_syntax_highlighting (Document* self)
{
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	gchar* content_type = NULL;
	GtkSourceLanguage* lang = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkSourceLanguage* _tmp10_;
	GtkSourceLanguage* _tmp11_;
	GtkSourceLanguage* _tmp12_;
	GError * _inner_error_ = NULL;
#line 271 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 273 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 273 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 273 "/home/seb/gnome/gnome-latex/src/document.vala"
	lm = _tmp1_;
#line 274 "/home/seb/gnome/gnome-latex/src/document.vala"
	content_type = NULL;
#line 1840 "document.c"
	{
		GFileInfo* info = NULL;
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 277 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = self->priv->_location;
#line 277 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 277 "/home/seb/gnome/gnome-latex/src/document.vala"
		info = _tmp3_;
#line 277 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1855 "document.c"
			goto __catch12_g_error;
		}
#line 279 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp4_ = g_file_info_get_content_type (info);
#line 279 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 279 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (content_type);
#line 279 "/home/seb/gnome/gnome-latex/src/document.vala"
		content_type = _tmp5_;
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (info);
#line 1868 "document.c"
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		e = _inner_error_;
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		_inner_error_ = NULL;
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_error_free0 (e);
#line 1880 "document.c"
	}
	__finally12:
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (content_type);
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (lm);
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 275 "/home/seb/gnome/gnome-latex/src/document.vala"
		return;
#line 1895 "document.c"
	}
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp6_ = self->priv->_location;
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp7_ = g_file_get_parse_name (_tmp6_);
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp8_ = _tmp7_;
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp9_ = content_type;
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp12_ = _tmp11_;
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (_tmp8_);
#line 283 "/home/seb/gnome/gnome-latex/src/document.vala"
	lang = _tmp12_;
#line 284 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
#line 271 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (lang);
#line 271 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (content_type);
#line 271 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (lm);
#line 1923 "document.c"
}


static void
document_update_project_id (Document* self)
{
	gint i = 0;
#line 287 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 289 "/home/seb/gnome/gnome-latex/src/document.vala"
	i = 0;
#line 1935 "document.c"
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp0_ = projects_get_default ();
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = _tmp0_;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = projects_iterator (_tmp1_);
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = _tmp2_;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		_projects_unref0 (_tmp1_);
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		_project_it = _tmp3_;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		while (TRUE) {
#line 1956 "document.c"
			GeeIterator* _tmp4_;
			Project project = {0};
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_ = {0};
			Project _tmp9_;
			GFile* _tmp10_;
			Project _tmp11_;
			GFile* _tmp12_;
			gint _tmp14_;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp4_ = _project_it;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
				break;
#line 1974 "document.c"
			}
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp5_ = _project_it;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp7_ = (Project*) _tmp6_;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			project_copy (_tmp7_, &_tmp8_);
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp9_ = _tmp8_;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			_project_free0 (_tmp7_);
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			project = _tmp9_;
#line 292 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp10_ = self->priv->_location;
#line 292 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp11_ = project;
#line 292 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp12_ = _tmp11_.directory;
#line 292 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (g_file_has_prefix (_tmp10_, _tmp12_)) {
#line 1998 "document.c"
				gint _tmp13_;
#line 294 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp13_ = i;
#line 294 "/home/seb/gnome/gnome-latex/src/document.vala"
				document_set_project_id (self, _tmp13_);
#line 295 "/home/seb/gnome/gnome-latex/src/document.vala"
				project_destroy (&project);
#line 295 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_object_unref0 (_project_it);
#line 295 "/home/seb/gnome/gnome-latex/src/document.vala"
				return;
#line 2010 "document.c"
			}
#line 297 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp14_ = i;
#line 297 "/home/seb/gnome/gnome-latex/src/document.vala"
			i = _tmp14_ + 1;
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
			project_destroy (&project);
#line 2018 "document.c"
		}
#line 290 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (_project_it);
#line 2022 "document.c"
	}
#line 300 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_set_project_id (self, -1);
#line 2026 "document.c"
}


gchar*
document_get_uri_for_display (Document* self)
{
	gchar* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 303 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 305 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_location;
#line 305 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ == NULL) {
#line 2046 "document.c"
		TeplFile* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 306 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 306 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 306 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 306 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = _tmp3_;
#line 306 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2060 "document.c"
	}
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = self->priv->_location;
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp5_ = g_file_get_parse_name (_tmp4_);
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp6_ = _tmp5_;
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp7_ = latexila_utils_replace_home_dir_with_tilde (_tmp6_);
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp8_ = _tmp7_;
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (_tmp6_);
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp8_;
#line 308 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 2078 "document.c"
}


gchar*
document_get_short_name_for_display (Document* self)
{
	gchar* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp4_;
	gchar* _tmp5_;
#line 311 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 313 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_location;
#line 313 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ == NULL) {
#line 2095 "document.c"
		TeplFile* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 314 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 314 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 314 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 314 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = _tmp3_;
#line 314 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2109 "document.c"
	}
#line 316 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = self->priv->_location;
#line 316 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp5_ = g_file_get_basename (_tmp4_);
#line 316 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp5_;
#line 316 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 2119 "document.c"
}


gboolean
document_is_externally_modified (Document* self)
{
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* current_etag = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 319 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 321 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_location;
#line 321 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ == NULL) {
#line 322 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = FALSE;
#line 322 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2142 "document.c"
	}
#line 324 "/home/seb/gnome/gnome-latex/src/document.vala"
	current_etag = NULL;
#line 2146 "document.c"
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 327 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = self->priv->_location;
#line 327 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 327 "/home/seb/gnome/gnome-latex/src/document.vala"
		file_info = _tmp2_;
#line 327 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2162 "document.c"
			goto __catch13_g_error;
		}
#line 329 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = file_info;
#line 329 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp4_ = g_file_info_get_etag (_tmp3_);
#line 329 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 329 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (current_etag);
#line 329 "/home/seb/gnome/gnome-latex/src/document.vala"
		current_etag = _tmp5_;
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (file_info);
#line 2177 "document.c"
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
		e = _inner_error_;
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
		_inner_error_ = NULL;
#line 333 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = FALSE;
#line 333 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_error_free0 (e);
#line 333 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (current_etag);
#line 333 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2195 "document.c"
	}
	__finally13:
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2200 "document.c"
		gboolean _tmp6_ = FALSE;
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (current_etag);
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 325 "/home/seb/gnome/gnome-latex/src/document.vala"
		return _tmp6_;
#line 2210 "document.c"
	}
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp8_ = current_etag;
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp8_ != NULL) {
#line 2216 "document.c"
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp9_ = current_etag;
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp10_ = self->priv->_etag;
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
#line 2225 "document.c"
	} else {
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp7_ = FALSE;
#line 2229 "document.c"
	}
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp7_;
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (current_etag);
#line 336 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 2237 "document.c"
}


void
document_comment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
#line 339 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 343 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 343 "/home/seb/gnome/gnome-latex/src/document.vala"
	start = _tmp0_;
#line 343 "/home/seb/gnome/gnome-latex/src/document.vala"
	end = _tmp1_;
#line 345 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp2_ = start;
#line 345 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp3_ = end;
#line 345 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
#line 2264 "document.c"
}


void
document_comment_between (Document* self,
                          GtkTextIter* start_iter,
                          GtkTextIter* end_iter,
                          gboolean end_iter_set)
{
	gint start_line = 0;
	gint end_line = 0;
	gint _tmp0_;
	GtkTextIter cur_iter = {0};
	gint _tmp1_;
	GtkTextIter _tmp2_ = {0};
#line 349 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 349 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (start_iter != NULL);
#line 349 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (end_iter != NULL);
#line 352 "/home/seb/gnome/gnome-latex/src/document.vala"
	start_line = gtk_text_iter_get_line (start_iter);
#line 353 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = start_line;
#line 353 "/home/seb/gnome/gnome-latex/src/document.vala"
	end_line = _tmp0_;
#line 355 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (end_iter_set) {
#line 356 "/home/seb/gnome/gnome-latex/src/document.vala"
		end_line = gtk_text_iter_get_line (end_iter);
#line 2296 "document.c"
	}
#line 359 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = start_line;
#line 359 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
#line 359 "/home/seb/gnome/gnome-latex/src/document.vala"
	cur_iter = _tmp2_;
#line 361 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2306 "document.c"
	{
		gint line_num = 0;
		gint _tmp3_;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = start_line;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
		line_num = _tmp3_;
#line 2314 "document.c"
		{
			gboolean _tmp4_ = FALSE;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp4_ = TRUE;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
			while (TRUE) {
#line 2321 "document.c"
				gint _tmp6_;
				gint _tmp7_;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (!_tmp4_) {
#line 2326 "document.c"
					gint _tmp5_;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp5_ = line_num;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
					line_num = _tmp5_ + 1;
#line 2332 "document.c"
				}
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp4_ = FALSE;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp6_ = line_num;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp7_ = end_line;
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (!(_tmp6_ <= _tmp7_)) {
#line 363 "/home/seb/gnome/gnome-latex/src/document.vala"
					break;
#line 2344 "document.c"
				}
#line 365 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (gtk_text_iter_ends_line (&cur_iter)) {
#line 367 "/home/seb/gnome/gnome-latex/src/document.vala"
					document_insert (self, &cur_iter, "%", -1);
#line 2350 "document.c"
				} else {
#line 369 "/home/seb/gnome/gnome-latex/src/document.vala"
					document_insert (self, &cur_iter, "% ", -1);
#line 2354 "document.c"
				}
#line 371 "/home/seb/gnome/gnome-latex/src/document.vala"
				gtk_text_iter_forward_line (&cur_iter);
#line 2358 "document.c"
			}
		}
	}
#line 374 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2364 "document.c"
}


void
document_uncomment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line = 0;
	gint end_line = 0;
	gint line_count = 0;
#line 377 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 380 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 380 "/home/seb/gnome/gnome-latex/src/document.vala"
	start = _tmp0_;
#line 380 "/home/seb/gnome/gnome-latex/src/document.vala"
	end = _tmp1_;
#line 382 "/home/seb/gnome/gnome-latex/src/document.vala"
	start_line = gtk_text_iter_get_line (&start);
#line 383 "/home/seb/gnome/gnome-latex/src/document.vala"
	end_line = gtk_text_iter_get_line (&end);
#line 384 "/home/seb/gnome/gnome-latex/src/document.vala"
	line_count = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
#line 386 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2394 "document.c"
	{
		gint i = 0;
		gint _tmp2_;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = start_line;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
		i = _tmp2_;
#line 2402 "document.c"
		{
			gboolean _tmp3_ = FALSE;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp3_ = TRUE;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
			while (TRUE) {
#line 2409 "document.c"
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GtkTextIter _tmp8_ = {0};
				gint _tmp9_;
				gint _tmp10_;
				gchar* line = NULL;
				GtkTextIter _tmp14_;
				GtkTextIter _tmp15_;
				gchar* _tmp16_;
				gint j = 0;
				gint start_delete = 0;
				gint stop_delete = 0;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				GtkTextIter _tmp35_ = {0};
				gint _tmp36_;
				gint _tmp37_;
				GtkTextIter _tmp38_ = {0};
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (!_tmp3_) {
#line 2432 "document.c"
					gint _tmp4_;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp4_ = i;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
					i = _tmp4_ + 1;
#line 2438 "document.c"
				}
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp3_ = FALSE;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp5_ = i;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp6_ = end_line;
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (!(_tmp5_ <= _tmp6_)) {
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
					break;
#line 2450 "document.c"
				}
#line 390 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp7_ = i;
#line 390 "/home/seb/gnome/gnome-latex/src/document.vala"
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp8_, _tmp7_);
#line 390 "/home/seb/gnome/gnome-latex/src/document.vala"
				start = _tmp8_;
#line 393 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp9_ = i;
#line 393 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp10_ = line_count;
#line 393 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (_tmp9_ == (_tmp10_ - 1)) {
#line 2464 "document.c"
					GtkTextIter _tmp11_ = {0};
#line 394 "/home/seb/gnome/gnome-latex/src/document.vala"
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp11_);
#line 394 "/home/seb/gnome/gnome-latex/src/document.vala"
					end = _tmp11_;
#line 2470 "document.c"
				} else {
					gint _tmp12_;
					GtkTextIter _tmp13_ = {0};
#line 396 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp12_ = i;
#line 396 "/home/seb/gnome/gnome-latex/src/document.vala"
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp13_, _tmp12_ + 1);
#line 396 "/home/seb/gnome/gnome-latex/src/document.vala"
					end = _tmp13_;
#line 2480 "document.c"
				}
#line 398 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp14_ = start;
#line 398 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp15_ = end;
#line 398 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp16_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp14_, &_tmp15_, FALSE);
#line 398 "/home/seb/gnome/gnome-latex/src/document.vala"
				line = _tmp16_;
#line 401 "/home/seb/gnome/gnome-latex/src/document.vala"
				j = 0;
#line 402 "/home/seb/gnome/gnome-latex/src/document.vala"
				start_delete = -1;
#line 403 "/home/seb/gnome/gnome-latex/src/document.vala"
				stop_delete = -1;
#line 404 "/home/seb/gnome/gnome-latex/src/document.vala"
				while (TRUE) {
#line 2498 "document.c"
					const gchar* _tmp17_;
					gint _tmp18_;
					const gchar* _tmp19_;
					gint _tmp20_;
					gint _tmp31_;
#line 404 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp17_ = line;
#line 404 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp18_ = j;
#line 404 "/home/seb/gnome/gnome-latex/src/document.vala"
					if (!(string_get (_tmp17_, (glong) _tmp18_) != '\0')) {
#line 404 "/home/seb/gnome/gnome-latex/src/document.vala"
						break;
#line 2512 "document.c"
					}
#line 406 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp19_ = line;
#line 406 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp20_ = j;
#line 406 "/home/seb/gnome/gnome-latex/src/document.vala"
					if (string_get (_tmp19_, (glong) _tmp20_) == '%') {
#line 2520 "document.c"
						gint _tmp21_;
						gint _tmp22_;
						const gchar* _tmp23_;
						gint _tmp24_;
#line 408 "/home/seb/gnome/gnome-latex/src/document.vala"
						_tmp21_ = j;
#line 408 "/home/seb/gnome/gnome-latex/src/document.vala"
						start_delete = _tmp21_;
#line 409 "/home/seb/gnome/gnome-latex/src/document.vala"
						_tmp22_ = j;
#line 409 "/home/seb/gnome/gnome-latex/src/document.vala"
						stop_delete = _tmp22_ + 1;
#line 410 "/home/seb/gnome/gnome-latex/src/document.vala"
						_tmp23_ = line;
#line 410 "/home/seb/gnome/gnome-latex/src/document.vala"
						_tmp24_ = j;
#line 410 "/home/seb/gnome/gnome-latex/src/document.vala"
						if (string_get (_tmp23_, (glong) (_tmp24_ + 1)) == ' ') {
#line 2539 "document.c"
							gint _tmp25_;
#line 411 "/home/seb/gnome/gnome-latex/src/document.vala"
							_tmp25_ = stop_delete;
#line 411 "/home/seb/gnome/gnome-latex/src/document.vala"
							stop_delete = _tmp25_ + 1;
#line 2545 "document.c"
						}
#line 412 "/home/seb/gnome/gnome-latex/src/document.vala"
						break;
#line 2549 "document.c"
					} else {
						gboolean _tmp26_ = FALSE;
						const gchar* _tmp27_;
						gint _tmp28_;
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
						_tmp27_ = line;
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
						_tmp28_ = j;
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
						if (string_get (_tmp27_, (glong) _tmp28_) != ' ') {
#line 2560 "document.c"
							const gchar* _tmp29_;
							gint _tmp30_;
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
							_tmp29_ = line;
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
							_tmp30_ = j;
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
							_tmp26_ = string_get (_tmp29_, (glong) _tmp30_) != '\t';
#line 2569 "document.c"
						} else {
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
							_tmp26_ = FALSE;
#line 2573 "document.c"
						}
#line 415 "/home/seb/gnome/gnome-latex/src/document.vala"
						if (_tmp26_) {
#line 416 "/home/seb/gnome/gnome-latex/src/document.vala"
							break;
#line 2579 "document.c"
						}
					}
#line 418 "/home/seb/gnome/gnome-latex/src/document.vala"
					_tmp31_ = j;
#line 418 "/home/seb/gnome/gnome-latex/src/document.vala"
					j = _tmp31_ + 1;
#line 2586 "document.c"
				}
#line 421 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp32_ = start_delete;
#line 421 "/home/seb/gnome/gnome-latex/src/document.vala"
				if (_tmp32_ == -1) {
#line 422 "/home/seb/gnome/gnome-latex/src/document.vala"
					_g_free0 (line);
#line 422 "/home/seb/gnome/gnome-latex/src/document.vala"
					continue;
#line 2596 "document.c"
				}
#line 424 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp33_ = i;
#line 424 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp34_ = start_delete;
#line 424 "/home/seb/gnome/gnome-latex/src/document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp35_, _tmp33_, _tmp34_);
#line 424 "/home/seb/gnome/gnome-latex/src/document.vala"
				start = _tmp35_;
#line 425 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp36_ = i;
#line 425 "/home/seb/gnome/gnome-latex/src/document.vala"
				_tmp37_ = stop_delete;
#line 425 "/home/seb/gnome/gnome-latex/src/document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp38_, _tmp36_, _tmp37_);
#line 425 "/home/seb/gnome/gnome-latex/src/document.vala"
				end = _tmp38_;
#line 426 "/home/seb/gnome/gnome-latex/src/document.vala"
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
#line 388 "/home/seb/gnome/gnome-latex/src/document.vala"
				_g_free0 (line);
#line 2618 "document.c"
			}
		}
	}
#line 429 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2624 "document.c"
}


Project*
document_get_project (Document* self)
{
	Project* result = NULL;
	gint _tmp0_;
	Projects* _tmp1_;
	Projects* _tmp2_;
	gint _tmp3_;
	Project* _tmp4_;
	Project* _tmp5_;
#line 432 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 434 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_project_id;
#line 434 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ == -1) {
#line 435 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = NULL;
#line 435 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2648 "document.c"
	}
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = projects_get_default ();
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp2_ = _tmp1_;
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp3_ = self->priv->_project_id;
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp5_ = _tmp4_;
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	_projects_unref0 (_tmp2_);
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp5_;
#line 437 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 2666 "document.c"
}


GFile*
document_get_main_file (Document* self)
{
	GFile* result = NULL;
	GFile* _tmp0_;
	Project* project = NULL;
	Project* _tmp1_;
	Project* _tmp2_;
	Project* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
#line 440 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 442 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_location;
#line 442 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ == NULL) {
#line 443 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = NULL;
#line 443 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2691 "document.c"
	}
#line 445 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = document_get_project (self);
#line 445 "/home/seb/gnome/gnome-latex/src/document.vala"
	project = _tmp1_;
#line 446 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp2_ = project;
#line 446 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp2_ == NULL) {
#line 2701 "document.c"
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 447 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = self->priv->_location;
#line 447 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 447 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = _tmp4_;
#line 447 "/home/seb/gnome/gnome-latex/src/document.vala"
		_project_free0 (project);
#line 447 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2714 "document.c"
	}
#line 449 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp5_ = project;
#line 449 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp6_ = (*_tmp5_).main_file;
#line 449 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 449 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp7_;
#line 449 "/home/seb/gnome/gnome-latex/src/document.vala"
	_project_free0 (project);
#line 449 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 2728 "document.c"
}


gboolean
document_is_main_file_a_tex_file (Document* self)
{
	gboolean result = FALSE;
	GFile* main_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 452 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 454 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = document_get_main_file (self);
#line 454 "/home/seb/gnome/gnome-latex/src/document.vala"
	main_file = _tmp0_;
#line 455 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = main_file;
#line 455 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp1_ == NULL) {
#line 456 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = FALSE;
#line 456 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (main_file);
#line 456 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 2759 "document.c"
	}
#line 458 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp2_ = main_file;
#line 458 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp3_ = g_file_get_parse_name (_tmp2_);
#line 458 "/home/seb/gnome/gnome-latex/src/document.vala"
	path = _tmp3_;
#line 459 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = path;
#line 459 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = g_str_has_suffix (_tmp4_, ".tex");
#line 459 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (path);
#line 459 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (main_file);
#line 459 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 2777 "document.c"
}


DocumentStructure*
document_get_structure (Document* self)
{
	DocumentStructure* result = NULL;
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp3_;
	DocumentStructure* _tmp4_;
#line 462 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 464 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_structure;
#line 464 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp0_ == NULL) {
#line 2794 "document.c"
		DocumentStructure* _tmp1_;
		DocumentStructure* _tmp2_;
#line 466 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = document_structure_new (self);
#line 466 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (self->priv->_structure);
#line 466 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_structure = _tmp1_;
#line 467 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = self->priv->_structure;
#line 467 "/home/seb/gnome/gnome-latex/src/document.vala"
		document_structure_parse (_tmp2_);
#line 2807 "document.c"
	}
#line 469 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp3_ = self->priv->_structure;
#line 469 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 469 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp4_;
#line 469 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 2817 "document.c"
}


static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
	return _data17_;
#line 2828 "document.c"
}


static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 2839 "document.c"
		Document* self;
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
		self = _data17_->self;
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (_data17_->infobar);
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (self);
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_slice_free (Block17Data, _data17_);
#line 2849 "document.c"
	}
}


static void
__lambda27_ (Block17Data* _data17_,
             gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp4_;
#line 504 "/home/seb/gnome/gnome-latex/src/document.vala"
	self = _data17_->self;
#line 506 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 2864 "document.c"
		MainWindow* main_window = NULL;
		DocumentTab* _tmp0_;
		GtkWindow* _tmp1_;
		MainWindow* _tmp2_;
#line 508 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp0_ = self->tab;
#line 508 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = utils_get_toplevel_window ((GtkWidget*) _tmp0_);
#line 508 "/home/seb/gnome/gnome-latex/src/document.vala"
		main_window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp1_) : NULL;
#line 511 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = main_window;
#line 511 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (_tmp2_ != NULL) {
#line 2879 "document.c"
			MainWindow* _tmp3_;
#line 512 "/home/seb/gnome/gnome-latex/src/document.vala"
			_tmp3_ = main_window;
#line 512 "/home/seb/gnome/gnome-latex/src/document.vala"
			main_window_save_document (_tmp3_, self, TRUE);
#line 2885 "document.c"
		}
	}
#line 515 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp4_ = _data17_->infobar;
#line 515 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 2892 "document.c"
}


static void
___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                    gint response_id,
                                    gpointer self)
{
#line 504 "/home/seb/gnome/gnome-latex/src/document.vala"
	__lambda27_ (self, response_id);
#line 2903 "document.c"
}


gboolean
document_set_tmp_location (Document* self)
{
	gboolean result = FALSE;
	Block17Data* _data17_;
	gchar* template = NULL;
	gchar* _tmp0_;
	gchar* tmp_dir = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	DocumentTab* _tmp14_;
	TeplInfoBar* _tmp15_;
	TeplInfoBar* _tmp16_;
	TeplInfoBar* _tmp17_;
	DocumentTab* _tmp18_;
	TeplInfoBar* _tmp19_;
	TeplInfoBar* _tmp20_;
	TeplInfoBar* _tmp21_;
	GError * _inner_error_ = NULL;
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data17_->_ref_count_ = 1;
#line 472 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data17_->self = g_object_ref (self);
#line 475 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = g_strdup ("latexila-XXXXXX");
#line 475 "/home/seb/gnome/gnome-latex/src/document.vala"
	template = _tmp0_;
#line 2941 "document.c"
	{
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp5_;
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = template;
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error_);
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = _tmp3_;
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2955 "document.c"
			gboolean _tmp4_ = FALSE;
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 2959 "document.c"
				goto __catch14_g_file_error;
			}
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (tmp_dir);
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			_g_free0 (template);
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			block17_data_unref (_data17_);
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			_data17_ = NULL;
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			g_clear_error (&_inner_error_);
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
			return _tmp4_;
#line 2976 "document.c"
		}
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp5_ = _tmp1_;
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = NULL;
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (tmp_dir);
#line 480 "/home/seb/gnome/gnome-latex/src/document.vala"
		tmp_dir = _tmp5_;
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (_tmp1_);
#line 2988 "document.c"
	}
	goto __finally14;
	__catch14_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		e = _inner_error_;
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		_inner_error_ = NULL;
#line 484 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp6_ = e;
#line 484 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp7_ = _tmp6_->message;
#line 484 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_warning ("document.vala:484: Impossible to create temporary directory: %s", _tmp7_);
#line 485 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = FALSE;
#line 485 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_error_free0 (e);
#line 485 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (tmp_dir);
#line 485 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (template);
#line 485 "/home/seb/gnome/gnome-latex/src/document.vala"
		block17_data_unref (_data17_);
#line 485 "/home/seb/gnome/gnome-latex/src/document.vala"
		_data17_ = NULL;
#line 485 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 3020 "document.c"
	}
	__finally14:
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3025 "document.c"
		gboolean _tmp8_ = FALSE;
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (tmp_dir);
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (template);
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		block17_data_unref (_data17_);
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		_data17_ = NULL;
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 478 "/home/seb/gnome/gnome-latex/src/document.vala"
		return _tmp8_;
#line 3041 "document.c"
	}
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp9_ = tmp_dir;
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp10_ = g_build_filename (_tmp9_, "tmp.tex", NULL);
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp11_ = _tmp10_;
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp12_ = g_file_new_for_path (_tmp11_);
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp13_ = _tmp12_;
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_set_location (self, _tmp13_);
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (_tmp13_);
#line 489 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (_tmp11_);
#line 493 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp14_ = self->tab;
#line 493 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp14_ == NULL) {
#line 494 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = TRUE;
#line 494 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (tmp_dir);
#line 494 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_free0 (template);
#line 494 "/home/seb/gnome/gnome-latex/src/document.vala"
		block17_data_unref (_data17_);
#line 494 "/home/seb/gnome/gnome-latex/src/document.vala"
		_data17_ = NULL;
#line 494 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 3075 "document.c"
	}
#line 496 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp15_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer."), _ ("Do you want to save the file in a safer place?"));
#line 496 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_object_ref_sink (_tmp15_);
#line 496 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data17_->infobar = _tmp15_;
#line 499 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp16_ = _data17_->infobar;
#line 499 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp16_, _ ("Save _As"), (gint) GTK_RESPONSE_YES);
#line 500 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp17_ = _data17_->infobar;
#line 500 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp17_, _ ("Cancel"), (gint) GTK_RESPONSE_NO);
#line 501 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp18_ = self->tab;
#line 501 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp19_ = _data17_->infobar;
#line 501 "/home/seb/gnome/gnome-latex/src/document.vala"
	tepl_tab_add_info_bar ((TeplTab*) _tmp18_, (GtkInfoBar*) _tmp19_);
#line 502 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp20_ = _data17_->infobar;
#line 502 "/home/seb/gnome/gnome-latex/src/document.vala"
	gtk_widget_show ((GtkWidget*) _tmp20_);
#line 504 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp21_ = _data17_->infobar;
#line 504 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_signal_connect_data ((GtkInfoBar*) _tmp21_, "response", (GCallback) ___lambda27__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
#line 518 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = TRUE;
#line 518 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (tmp_dir);
#line 518 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (template);
#line 518 "/home/seb/gnome/gnome-latex/src/document.vala"
	block17_data_unref (_data17_);
#line 518 "/home/seb/gnome/gnome-latex/src/document.vala"
	_data17_ = NULL;
#line 518 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 3117 "document.c"
}


static void
document_save_metadata (Document* self)
{
	GFileInfo* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
#line 521 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 523 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_metadata_info;
#line 523 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 525 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp1_ = self->priv->_location;
#line 525 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp1_ == NULL) {
#line 526 "/home/seb/gnome/gnome-latex/src/document.vala"
		return;
#line 3139 "document.c"
	}
	{
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
#line 530 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = self->priv->_location;
#line 530 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = self->priv->_metadata_info;
#line 530 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_file_set_attributes_from_info (_tmp2_, _tmp3_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 530 "/home/seb/gnome/gnome-latex/src/document.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3152 "document.c"
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 528 "/home/seb/gnome/gnome-latex/src/document.vala"
		_error_ = _inner_error_;
#line 528 "/home/seb/gnome/gnome-latex/src/document.vala"
		_inner_error_ = NULL;
#line 535 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp4_ = _error_;
#line 535 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp5_ = _tmp4_->message;
#line 535 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_warning ("document.vala:535: Set document metadata failed: %s", _tmp5_);
#line 528 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_error_free0 (_error_);
#line 3174 "document.c"
	}
	__finally15:
#line 528 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 528 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_clear_error (&_inner_error_);
#line 528 "/home/seb/gnome/gnome-latex/src/document.vala"
		return;
#line 3185 "document.c"
	}
}


void
document_set_metadata (Document* self,
                       const gchar* key,
                       const gchar* val)
{
	GFileInfo* _tmp0_;
#line 539 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 539 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (key != NULL);
#line 541 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_metadata_info;
#line 541 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 543 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (val != NULL) {
#line 3206 "document.c"
		GFileInfo* _tmp1_;
#line 544 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = self->priv->_metadata_info;
#line 544 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_file_info_set_attribute_string (_tmp1_, key, val);
#line 3212 "document.c"
	} else {
		GFileInfo* _tmp2_;
#line 547 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp2_ = self->priv->_metadata_info;
#line 547 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_file_info_set_attribute (_tmp2_, key, G_FILE_ATTRIBUTE_TYPE_INVALID, NULL);
#line 3219 "document.c"
	}
#line 549 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_save_metadata (self);
#line 3223 "document.c"
}


gchar*
document_get_metadata (Document* self,
                       const gchar* key)
{
	gchar* result = NULL;
	GFileInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFileInfo* _tmp2_;
#line 552 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 552 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 554 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_metadata_info;
#line 554 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
#line 556 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp2_ = self->priv->_metadata_info;
#line 556 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (g_file_info_has_attribute (_tmp2_, key)) {
#line 3247 "document.c"
		GFileInfo* _tmp3_;
#line 557 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp3_ = self->priv->_metadata_info;
#line 557 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = g_file_info_get_attribute_type (_tmp3_, key) == G_FILE_ATTRIBUTE_TYPE_STRING;
#line 3253 "document.c"
	} else {
#line 556 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp1_ = FALSE;
#line 3257 "document.c"
	}
#line 556 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (_tmp1_) {
#line 3261 "document.c"
		GFileInfo* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 558 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp4_ = self->priv->_metadata_info;
#line 558 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp5_ = g_file_info_get_attribute_string (_tmp4_, key);
#line 558 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 558 "/home/seb/gnome/gnome-latex/src/document.vala"
		result = _tmp6_;
#line 558 "/home/seb/gnome/gnome-latex/src/document.vala"
		return result;
#line 3275 "document.c"
	}
#line 560 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = NULL;
#line 560 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 3281 "document.c"
}


GFile*
document_get_location (Document* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_location;
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp0_;
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 3298 "document.c"
}


void
document_set_location (Document* self,
                       GFile* value)
{
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (document_get_location (self) != value) {
#line 3310 "document.c"
		GFile* _tmp0_;
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
		_g_object_unref0 (self->priv->_location);
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_location = _tmp0_;
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_LOCATION_PROPERTY]);
#line 3320 "document.c"
	}
}


gboolean
document_get_readonly (Document* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_readonly;
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp0_;
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 3338 "document.c"
}


void
document_set_readonly (Document* self,
                       gboolean value)
{
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (document_get_readonly (self) != value) {
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_readonly = value;
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_READONLY_PROPERTY]);
#line 3354 "document.c"
	}
}


gint
document_get_project_id (Document* self)
{
	gint result;
	gint _tmp0_;
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = self->priv->_project_id;
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
	result = _tmp0_;
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
	return result;
#line 3372 "document.c"
}


void
document_set_project_id (Document* self,
                         gint value)
{
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_return_if_fail (self != NULL);
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
	if (document_get_project_id (self) != value) {
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
		self->priv->_project_id = value;
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_PROJECT_ID_PROPERTY]);
#line 3388 "document.c"
	}
}


static void
document_class_init (DocumentClass * klass)
{
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	document_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_type_class_add_private (klass, sizeof (DocumentPrivate));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION_PROPERTY, document_properties[DOCUMENT_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY_PROPERTY, document_properties[DOCUMENT_READONLY_PROPERTY] = g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID_PROPERTY, document_properties[DOCUMENT_PROJECT_ID_PROPERTY] = g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3412 "document.c"
}


static void
document_instance_init (Document * self)
{
	GFileInfo* _tmp0_;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv = DOCUMENT_GET_PRIVATE (self);
#line 25 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->_readonly = FALSE;
#line 27 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->_project_id = -1;
#line 28 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->backup_made = FALSE;
#line 30 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->encoding = NULL;
#line 31 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->new_file = TRUE;
#line 32 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->_structure = NULL;
#line 33 "/home/seb/gnome/gnome-latex/src/document.vala"
	_tmp0_ = g_file_info_new ();
#line 33 "/home/seb/gnome/gnome-latex/src/document.vala"
	self->priv->_metadata_info = _tmp0_;
#line 3438 "document.c"
}


static void
document_finalize (GObject * obj)
{
	Document * self;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
#line 24 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (self->priv->_location);
#line 29 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (self->priv->_etag);
#line 30 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_free0 (self->priv->encoding);
#line 32 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (self->priv->_structure);
#line 33 "/home/seb/gnome/gnome-latex/src/document.vala"
	_g_object_unref0 (self->priv->_metadata_info);
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
#line 3460 "document.c"
}


GType
document_get_type (void)
{
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (tepl_buffer_get_type (), "Document", &g_define_type_info, 0);
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}


static void
_vala_document_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	switch (property_id) {
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_value_set_object (value, document_get_location (self));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_value_set_boolean (value, document_get_readonly (self));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		g_value_set_int (value, document_get_project_id (self));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 3506 "document.c"
		default:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 3512 "document.c"
	}
}


static void
_vala_document_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
	switch (property_id) {
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		document_set_location (self, g_value_get_object (value));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		document_set_readonly (self, g_value_get_boolean (value));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		document_set_project_id (self, g_value_get_int (value));
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 3545 "document.c"
		default:
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/seb/gnome/gnome-latex/src/document.vala"
		break;
#line 3551 "document.c"
	}
}



