/* utils.c generated by valac 0.40.8, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <latexila.h>
#include <gtk/gtk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))



gchar* utils_str_middle_truncate (const gchar* str,
                                  guint max_length);
gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
gchar* utils_uri_get_dirname (const gchar* uri);
gchar* utils_get_dirname_for_display (GFile* location);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
gchar* utils_load_file (GFile* file);
gchar* utils_get_relative_path (GFile* origin,
                                GFile* target,
                                GFile* common_dir);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model,
                                     GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
void utils_flush_queue (void);


/*************************************************************************/
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
#line 1369 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1370 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1370 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1370 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1371 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 91 "utils.c"
		glong _tmp2_;
#line 1372 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = string_length;
#line 1372 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		start = _tmp2_ + start;
#line 97 "utils.c"
	}
#line 1374 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 101 "utils.c"
		glong _tmp3_;
#line 1375 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1375 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		end = _tmp3_ + end;
#line 107 "utils.c"
	}
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 111 "utils.c"
		glong _tmp5_;
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = start <= _tmp5_;
#line 117 "utils.c"
	} else {
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = FALSE;
#line 121 "utils.c"
	}
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp4_, NULL);
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 127 "utils.c"
		glong _tmp7_;
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = string_length;
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = end <= _tmp7_;
#line 133 "utils.c"
	} else {
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = FALSE;
#line 137 "utils.c"
	}
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp6_, NULL);
#line 1379 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1380 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1380 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp8_;
#line 1380 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 149 "utils.c"
}


gchar*
utils_str_middle_truncate (const gchar* str,
                           guint max_length)
{
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	guint half_length = 0U;
	gint l = 0;
	gint _tmp3_;
	gint _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	guint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
#line 27 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 29 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp0_ = strlen (str);
#line 29 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp1_ = _tmp0_;
#line 29 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (((guint) _tmp1_) <= max_length) {
#line 184 "utils.c"
		gchar* _tmp2_;
#line 30 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2_ = g_strdup (str);
#line 30 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = _tmp2_;
#line 30 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 192 "utils.c"
	}
#line 32 "/home/seb/gnome/gnome-latex/src/utils.vala"
	half_length = (max_length - 4) / 2;
#line 33 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp3_ = strlen (str);
#line 33 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp4_ = _tmp3_;
#line 33 "/home/seb/gnome/gnome-latex/src/utils.vala"
	l = _tmp4_;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp5_ = half_length;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp6_ = string_slice (str, (glong) 0, (glong) _tmp5_);
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp7_ = _tmp6_;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp8_ = g_strconcat (_tmp7_, "...", NULL);
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp9_ = _tmp8_;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp10_ = l;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp11_ = half_length;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp12_ = l;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp13_ = string_slice (str, (glong) (_tmp10_ - _tmp11_), (glong) _tmp12_);
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp14_ = _tmp13_;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp15_ = g_strconcat (_tmp9_, _tmp14_, NULL);
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp16_ = _tmp15_;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_free0 (_tmp14_);
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_free0 (_tmp9_);
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_free0 (_tmp7_);
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = _tmp16_;
#line 34 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 236 "utils.c"
}


static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
#line 1182 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1183 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (0 < (*index)) {
#line 251 "utils.c"
		gchar* _tmp0_;
#line 1184 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
#line 1184 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1185 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1186 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1186 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		if (c) {
#line 1186 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 265 "utils.c"
		}
#line 1186 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 269 "utils.c"
	} else {
#line 1188 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1189 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1189 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		if (c) {
#line 1189 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 279 "utils.c"
		}
#line 1189 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 283 "utils.c"
	}
#line 1182 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (c) {
#line 1182 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 289 "utils.c"
	}
}


gboolean
utils_char_is_escaped (const gchar* text,
                       glong char_index)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gboolean escaped = FALSE;
	gint index = 0;
	gunichar cur_char = 0U;
#line 37 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 39 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp0_ = strlen (text);
#line 39 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp1_ = _tmp0_;
#line 39 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (char_index < ((glong) _tmp1_), FALSE);
#line 41 "/home/seb/gnome/gnome-latex/src/utils.vala"
	escaped = FALSE;
#line 42 "/home/seb/gnome/gnome-latex/src/utils.vala"
	index = (gint) char_index;
#line 44 "/home/seb/gnome/gnome-latex/src/utils.vala"
	while (TRUE) {
#line 318 "utils.c"
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		gunichar _tmp4_;
		gboolean _tmp5_;
#line 44 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp3_ = string_get_prev_char (text, &index, &_tmp2_);
#line 44 "/home/seb/gnome/gnome-latex/src/utils.vala"
		cur_char = _tmp2_;
#line 44 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (!_tmp3_) {
#line 44 "/home/seb/gnome/gnome-latex/src/utils.vala"
			break;
#line 331 "utils.c"
		}
#line 46 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp4_ = cur_char;
#line 46 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp4_ != ((gunichar) '\\')) {
#line 47 "/home/seb/gnome/gnome-latex/src/utils.vala"
			break;
#line 339 "utils.c"
		}
#line 49 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp5_ = escaped;
#line 49 "/home/seb/gnome/gnome-latex/src/utils.vala"
		escaped = !_tmp5_;
#line 345 "utils.c"
	}
#line 52 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = escaped;
#line 52 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 351 "utils.c"
}


const gchar*
utils_get_string_from_resource (const gchar* resource_path)
{
	const gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 55 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (resource_path != NULL, NULL);
#line 362 "utils.c"
	{
		GBytes* bytes = NULL;
		GBytes* _tmp0_;
		gsize _tmp1_;
		guint8* _tmp2_;
#line 59 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp0_ = g_resources_lookup_data (resource_path, 0, &_inner_error_);
#line 59 "/home/seb/gnome/gnome-latex/src/utils.vala"
		bytes = _tmp0_;
#line 59 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 374 "utils.c"
			goto __catch45_g_error;
		}
#line 60 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2_ = g_bytes_get_data (bytes, &_tmp1_);
#line 60 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = (const gchar*) _tmp2_;
#line 60 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_bytes_unref0 (bytes);
#line 60 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 385 "utils.c"
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 57 "/home/seb/gnome/gnome-latex/src/utils.vala"
		e = _inner_error_;
#line 57 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_inner_error_ = NULL;
#line 64 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp3_ = e;
#line 64 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp4_ = _tmp3_->message;
#line 64 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_warning ("utils.vala:64: Failed to load data from resource '%s': %s", resource_path, _tmp4_);
#line 66 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = NULL;
#line 66 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_error_free0 (e);
#line 66 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 409 "utils.c"
	}
	__finally45:
#line 57 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_clear_error (&_inner_error_);
#line 57 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return NULL;
#line 418 "utils.c"
}


/*************************************************************************/
gchar*
utils_uri_get_dirname (const gchar* uri)
{
	gchar* result = NULL;
	gchar* dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 74 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 76 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 77 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp0_ = g_path_get_dirname (uri);
#line 77 "/home/seb/gnome/gnome-latex/src/utils.vala"
	dir = _tmp0_;
#line 78 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp1_ = dir;
#line 78 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (g_strcmp0 (_tmp1_, ".") == 0) {
#line 79 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = NULL;
#line 79 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (dir);
#line 79 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 450 "utils.c"
	}
#line 80 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp2_ = dir;
#line 80 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp3_ = latexila_utils_replace_home_dir_with_tilde (_tmp2_);
#line 80 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = _tmp3_;
#line 80 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_free0 (dir);
#line 80 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 462 "utils.c"
}


gchar*
utils_get_dirname_for_display (GFile* location)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 88 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 473 "utils.c"
	{
		GMount* mount = NULL;
		GMount* _tmp0_;
		gchar* mount_name = NULL;
		GMount* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* dirname = NULL;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 92 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp0_ = g_file_find_enclosing_mount (location, NULL, &_inner_error_);
#line 92 "/home/seb/gnome/gnome-latex/src/utils.vala"
		mount = _tmp0_;
#line 92 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 498 "utils.c"
			goto __catch46_g_error;
		}
#line 93 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp1_ = mount;
#line 93 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2_ = g_mount_get_name (_tmp1_);
#line 93 "/home/seb/gnome/gnome-latex/src/utils.vala"
		mount_name = _tmp2_;
#line 95 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp4_ = g_file_get_path (location);
#line 95 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp3_ = _tmp4_;
#line 95 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp3_ == NULL) {
#line 513 "utils.c"
			gchar* _tmp5_;
#line 95 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp5_ = g_file_get_uri (location);
#line 95 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_g_free0 (_tmp3_);
#line 95 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp3_ = _tmp5_;
#line 521 "utils.c"
		}
#line 94 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp6_ = utils_uri_get_dirname (_tmp3_);
#line 94 "/home/seb/gnome/gnome-latex/src/utils.vala"
		dirname = _tmp6_;
#line 97 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp8_ = dirname;
#line 97 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp8_ == NULL) {
#line 97 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp7_ = TRUE;
#line 533 "utils.c"
		} else {
			const gchar* _tmp9_;
#line 97 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp9_ = dirname;
#line 97 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, ".") == 0;
#line 540 "utils.c"
		}
#line 97 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp7_) {
#line 98 "/home/seb/gnome/gnome-latex/src/utils.vala"
			result = mount_name;
#line 98 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_g_free0 (dirname);
#line 98 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_g_free0 (_tmp3_);
#line 98 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_g_object_unref0 (mount);
#line 98 "/home/seb/gnome/gnome-latex/src/utils.vala"
			return result;
#line 554 "utils.c"
		}
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp10_ = mount_name;
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp11_ = g_strconcat (_tmp10_, " ", NULL);
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp12_ = _tmp11_;
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp13_ = dirname;
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp15_ = _tmp14_;
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (_tmp12_);
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = _tmp15_;
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (dirname);
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (_tmp3_);
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (mount_name);
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (mount);
#line 99 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 582 "utils.c"
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* e = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp19_;
#line 90 "/home/seb/gnome/gnome-latex/src/utils.vala"
		e = _inner_error_;
#line 90 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_inner_error_ = NULL;
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp17_ = g_file_get_path (location);
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp16_ = _tmp17_;
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp16_ == NULL) {
#line 601 "utils.c"
			gchar* _tmp18_;
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp18_ = g_file_get_uri (location);
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_g_free0 (_tmp16_);
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp16_ = _tmp18_;
#line 609 "utils.c"
		}
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp19_ = utils_uri_get_dirname (_tmp16_);
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = _tmp19_;
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (_tmp16_);
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_error_free0 (e);
#line 105 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 621 "utils.c"
	}
	__finally46:
#line 90 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 90 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_clear_error (&_inner_error_);
#line 90 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return NULL;
#line 630 "utils.c"
}


void
utils_delete_file (GFile* file)
{
	GError * _inner_error_ = NULL;
#line 109 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_if_fail (file != NULL);
#line 111 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 112 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return;
#line 644 "utils.c"
	}
	{
#line 116 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_file_delete (file, NULL, &_inner_error_);
#line 116 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 651 "utils.c"
			goto __catch47_g_error;
		}
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 114 "/home/seb/gnome/gnome-latex/src/utils.vala"
		e = _inner_error_;
#line 114 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_inner_error_ = NULL;
#line 120 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp0_ = g_file_get_parse_name (file);
#line 120 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp1_ = _tmp0_;
#line 120 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2_ = e;
#line 120 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp3_ = _tmp2_->message;
#line 120 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_warning ("utils.vala:120: Delete file '%s' failed: %s", _tmp1_, _tmp3_);
#line 120 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (_tmp1_);
#line 114 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_error_free0 (e);
#line 681 "utils.c"
	}
	__finally47:
#line 114 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 114 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_clear_error (&_inner_error_);
#line 114 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return;
#line 692 "utils.c"
	}
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1442 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1443 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1443 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1443 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1444 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1444 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1444 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1444 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 740 "utils.c"
	}
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1445 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 746 "utils.c"
}


gboolean
utils_save_file (GFile* file,
                 const gchar* contents,
                 gboolean make_backup)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 124 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 124 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (contents != NULL, FALSE);
#line 761 "utils.c"
	{
		guint8* _tmp0_;
		gint _tmp0__length1;
		guint8* _tmp1_;
		gint _tmp1__length1;
#line 128 "/home/seb/gnome/gnome-latex/src/utils.vala"
		latexila_utils_create_parent_directories (file, &_inner_error_);
#line 128 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 771 "utils.c"
			goto __catch48_g_error;
		}
#line 130 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp0_ = string_get_data (contents, &_tmp0__length1);
#line 130 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp1_ = _tmp0_;
#line 130 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp1__length1 = _tmp0__length1;
#line 130 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_file_replace_contents (file, _tmp1_, (gsize) _tmp1__length1, NULL, make_backup, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
#line 130 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 784 "utils.c"
			goto __catch48_g_error;
		}
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 126 "/home/seb/gnome/gnome-latex/src/utils.vala"
		e = _inner_error_;
#line 126 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_inner_error_ = NULL;
#line 135 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2_ = g_file_get_parse_name (file);
#line 135 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp3_ = _tmp2_;
#line 135 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp4_ = e;
#line 135 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp5_ = _tmp4_->message;
#line 135 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_warning ("utils.vala:135: Failed to save the file '%s': %s", _tmp3_, _tmp5_);
#line 135 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (_tmp3_);
#line 137 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = FALSE;
#line 137 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_error_free0 (e);
#line 137 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 818 "utils.c"
	}
	__finally48:
#line 126 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 823 "utils.c"
		gboolean _tmp6_ = FALSE;
#line 126 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_clear_error (&_inner_error_);
#line 126 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return _tmp6_;
#line 831 "utils.c"
	}
#line 140 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = TRUE;
#line 140 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 837 "utils.c"
}


gchar*
utils_load_file (GFile* file)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 144 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 848 "utils.c"
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_;
		guint8* _tmp2_;
		gint _tmp2__length1;
#line 149 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 149 "/home/seb/gnome/gnome-latex/src/utils.vala"
		chars = (g_free (chars), NULL);
#line 149 "/home/seb/gnome/gnome-latex/src/utils.vala"
		chars = _tmp0_;
#line 149 "/home/seb/gnome/gnome-latex/src/utils.vala"
		chars_length1 = _tmp1_;
#line 149 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_chars_size_ = chars_length1;
#line 149 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 149 "/home/seb/gnome/gnome-latex/src/utils.vala"
			chars = (g_free (chars), NULL);
#line 871 "utils.c"
			goto __catch49_g_error;
		}
#line 150 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2_ = chars;
#line 150 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2__length1 = chars_length1;
#line 150 "/home/seb/gnome/gnome-latex/src/utils.vala"
		chars = NULL;
#line 150 "/home/seb/gnome/gnome-latex/src/utils.vala"
		chars_length1 = 0;
#line 150 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = (gchar*) _tmp2_;
#line 150 "/home/seb/gnome/gnome-latex/src/utils.vala"
		chars = (g_free (chars), NULL);
#line 150 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 888 "utils.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 146 "/home/seb/gnome/gnome-latex/src/utils.vala"
		e = _inner_error_;
#line 146 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_inner_error_ = NULL;
#line 154 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp3_ = g_file_get_parse_name (file);
#line 154 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp4_ = _tmp3_;
#line 154 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp5_ = e;
#line 154 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp6_ = _tmp5_->message;
#line 154 "/home/seb/gnome/gnome-latex/src/utils.vala"
		g_warning ("utils.vala:154: Failed to load the file '%s': %s", _tmp4_, _tmp6_);
#line 154 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_free0 (_tmp4_);
#line 156 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = NULL;
#line 156 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_error_free0 (e);
#line 156 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 920 "utils.c"
	}
	__finally49:
#line 146 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_clear_error (&_inner_error_);
#line 146 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return NULL;
#line 929 "utils.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 165 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 938 "utils.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 947 "utils.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 956 "utils.c"
}


gchar*
utils_get_relative_path (GFile* origin,
                         GFile* target,
                         GFile* common_dir)
{
	gchar* result = NULL;
	GFile* origin_dir = NULL;
	GFile* target_parent = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GList* target_dirs = NULL;
	GList* origin_dirs = NULL;
	guint dir_index = 0U;
	guint nb_common_dirs = 0U;
	guint _tmp38_;
	gchar* relative_path = NULL;
	gchar* _tmp39_;
	guint nb_remaining_origin_dirs = 0U;
	GList* _tmp40_;
	guint _tmp41_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
#line 161 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (origin != NULL, NULL);
#line 161 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 161 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (common_dir != NULL, NULL);
#line 164 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (g_file_equal (origin, common_dir)) {
#line 995 "utils.c"
		GFile* _tmp0_;
#line 165 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp0_ = _g_object_ref0 (origin);
#line 165 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (origin_dir);
#line 165 "/home/seb/gnome/gnome-latex/src/utils.vala"
		origin_dir = _tmp0_;
#line 1003 "utils.c"
	} else {
		GFile* _tmp1_;
#line 167 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp1_ = g_file_get_parent (origin);
#line 167 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (origin_dir);
#line 167 "/home/seb/gnome/gnome-latex/src/utils.vala"
		origin_dir = _tmp1_;
#line 1012 "utils.c"
	}
#line 169 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp2_ = g_file_get_parent (target);
#line 169 "/home/seb/gnome/gnome-latex/src/utils.vala"
	target_parent = _tmp2_;
#line 171 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp3_ = origin_dir;
#line 171 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (_tmp3_ != NULL, NULL);
#line 172 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp4_ = target_parent;
#line 172 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (_tmp4_ != NULL, NULL);
#line 175 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp5_ = target_parent;
#line 175 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp6_ = origin_dir;
#line 175 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (g_file_equal (_tmp5_, _tmp6_)) {
#line 1032 "utils.c"
		gchar* _tmp7_;
#line 176 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp7_ = g_file_get_basename (target);
#line 176 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = _tmp7_;
#line 176 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (target_parent);
#line 176 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (origin_dir);
#line 176 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 1044 "utils.c"
	}
#line 179 "/home/seb/gnome/gnome-latex/src/utils.vala"
	target_dirs = NULL;
#line 180 "/home/seb/gnome/gnome-latex/src/utils.vala"
	origin_dirs = NULL;
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
	while (TRUE) {
#line 1052 "utils.c"
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp9_ = target_parent;
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp9_ != NULL) {
#line 1063 "utils.c"
			GFile* _tmp10_;
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp10_ = target_parent;
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp8_ = !g_file_equal (_tmp10_, common_dir);
#line 1069 "utils.c"
		} else {
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp8_ = FALSE;
#line 1073 "utils.c"
		}
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (!_tmp8_) {
#line 182 "/home/seb/gnome/gnome-latex/src/utils.vala"
			break;
#line 1079 "utils.c"
		}
#line 184 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp11_ = target_parent;
#line 184 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 184 "/home/seb/gnome/gnome-latex/src/utils.vala"
		target_dirs = g_list_prepend (target_dirs, _tmp12_);
#line 185 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp13_ = target_parent;
#line 185 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp14_ = g_file_get_parent (_tmp13_);
#line 185 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (target_parent);
#line 185 "/home/seb/gnome/gnome-latex/src/utils.vala"
		target_parent = _tmp14_;
#line 1095 "utils.c"
	}
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
	while (TRUE) {
#line 1099 "utils.c"
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp16_ = origin_dir;
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp16_ != NULL) {
#line 1110 "utils.c"
			GFile* _tmp17_;
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp17_ = origin_dir;
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp15_ = !g_file_equal (_tmp17_, common_dir);
#line 1116 "utils.c"
		} else {
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp15_ = FALSE;
#line 1120 "utils.c"
		}
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (!_tmp15_) {
#line 188 "/home/seb/gnome/gnome-latex/src/utils.vala"
			break;
#line 1126 "utils.c"
		}
#line 190 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp18_ = origin_dir;
#line 190 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 190 "/home/seb/gnome/gnome-latex/src/utils.vala"
		origin_dirs = g_list_prepend (origin_dirs, _tmp19_);
#line 191 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp20_ = origin_dir;
#line 191 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp21_ = g_file_get_parent (_tmp20_);
#line 191 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (origin_dir);
#line 191 "/home/seb/gnome/gnome-latex/src/utils.vala"
		origin_dir = _tmp21_;
#line 1142 "utils.c"
	}
#line 195 "/home/seb/gnome/gnome-latex/src/utils.vala"
	dir_index = (guint) 0;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
	while (TRUE) {
#line 1148 "utils.c"
		gboolean _tmp22_ = FALSE;
		guint _tmp23_;
		GList* _tmp24_;
		GFile* cur_target_dir = NULL;
		GList* _tmp27_;
		guint _tmp28_;
		gconstpointer _tmp29_;
		GFile* _tmp30_;
		GFile* cur_origin_dir = NULL;
		GList* _tmp31_;
		guint _tmp32_;
		gconstpointer _tmp33_;
		GFile* _tmp34_;
		GFile* _tmp35_;
		GFile* _tmp36_;
		guint _tmp37_;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp23_ = dir_index;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp24_ = target_dirs;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (_tmp23_ < g_list_length (_tmp24_)) {
#line 1171 "utils.c"
			guint _tmp25_;
			GList* _tmp26_;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp25_ = dir_index;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp26_ = origin_dirs;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp22_ = _tmp25_ < g_list_length (_tmp26_);
#line 1180 "utils.c"
		} else {
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp22_ = FALSE;
#line 1184 "utils.c"
		}
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (!_tmp22_) {
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
			break;
#line 1190 "utils.c"
		}
#line 198 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp27_ = target_dirs;
#line 198 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp28_ = dir_index;
#line 198 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp29_ = g_list_nth_data (_tmp27_, _tmp28_);
#line 198 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp30_ = _g_object_ref0 ((GFile*) _tmp29_);
#line 198 "/home/seb/gnome/gnome-latex/src/utils.vala"
		cur_target_dir = _tmp30_;
#line 199 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp31_ = origin_dirs;
#line 199 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp32_ = dir_index;
#line 199 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp33_ = g_list_nth_data (_tmp31_, _tmp32_);
#line 199 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp34_ = _g_object_ref0 ((GFile*) _tmp33_);
#line 199 "/home/seb/gnome/gnome-latex/src/utils.vala"
		cur_origin_dir = _tmp34_;
#line 200 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp35_ = cur_target_dir;
#line 200 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp36_ = cur_origin_dir;
#line 200 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (!g_file_equal (_tmp35_, _tmp36_)) {
#line 201 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_g_object_unref0 (cur_origin_dir);
#line 201 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_g_object_unref0 (cur_target_dir);
#line 201 "/home/seb/gnome/gnome-latex/src/utils.vala"
			break;
#line 1224 "utils.c"
		}
#line 203 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp37_ = dir_index;
#line 203 "/home/seb/gnome/gnome-latex/src/utils.vala"
		dir_index = _tmp37_ + 1;
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (cur_origin_dir);
#line 196 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (cur_target_dir);
#line 1234 "utils.c"
	}
#line 206 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp38_ = dir_index;
#line 206 "/home/seb/gnome/gnome-latex/src/utils.vala"
	nb_common_dirs = _tmp38_;
#line 209 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp39_ = g_strdup ("");
#line 209 "/home/seb/gnome/gnome-latex/src/utils.vala"
	relative_path = _tmp39_;
#line 212 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp40_ = origin_dirs;
#line 212 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp41_ = nb_common_dirs;
#line 212 "/home/seb/gnome/gnome-latex/src/utils.vala"
	nb_remaining_origin_dirs = g_list_length (_tmp40_) - _tmp41_;
#line 1250 "utils.c"
	{
		guint i = 0U;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
		i = (guint) 0;
#line 1255 "utils.c"
		{
			gboolean _tmp42_ = FALSE;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp42_ = TRUE;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
			while (TRUE) {
#line 1262 "utils.c"
				guint _tmp44_;
				guint _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
				if (!_tmp42_) {
#line 1269 "utils.c"
					guint _tmp43_;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
					_tmp43_ = i;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
					i = _tmp43_ + 1;
#line 1275 "utils.c"
				}
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp42_ = FALSE;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp44_ = i;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp45_ = nb_remaining_origin_dirs;
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
				if (!(_tmp44_ < _tmp45_)) {
#line 213 "/home/seb/gnome/gnome-latex/src/utils.vala"
					break;
#line 1287 "utils.c"
				}
#line 214 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp46_ = relative_path;
#line 214 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp47_ = g_strconcat (_tmp46_, "../", NULL);
#line 214 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_g_free0 (relative_path);
#line 214 "/home/seb/gnome/gnome-latex/src/utils.vala"
				relative_path = _tmp47_;
#line 1297 "utils.c"
			}
		}
	}
	{
		guint i = 0U;
		guint _tmp48_;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp48_ = nb_common_dirs;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
		i = _tmp48_;
#line 1308 "utils.c"
		{
			gboolean _tmp49_ = FALSE;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
			_tmp49_ = TRUE;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
			while (TRUE) {
#line 1315 "utils.c"
				guint _tmp51_;
				GList* _tmp52_;
				GFile* cur_target_dir = NULL;
				GList* _tmp53_;
				guint _tmp54_;
				gconstpointer _tmp55_;
				GFile* _tmp56_;
				const gchar* _tmp57_;
				GFile* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
				if (!_tmp49_) {
#line 1332 "utils.c"
					guint _tmp50_;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
					_tmp50_ = i;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
					i = _tmp50_ + 1;
#line 1338 "utils.c"
				}
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp49_ = FALSE;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp51_ = i;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp52_ = target_dirs;
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
				if (!(_tmp51_ < g_list_length (_tmp52_))) {
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
					break;
#line 1350 "utils.c"
				}
#line 219 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp53_ = target_dirs;
#line 219 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp54_ = i;
#line 219 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp55_ = g_list_nth_data (_tmp53_, _tmp54_);
#line 219 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp56_ = _g_object_ref0 ((GFile*) _tmp55_);
#line 219 "/home/seb/gnome/gnome-latex/src/utils.vala"
				cur_target_dir = _tmp56_;
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp57_ = relative_path;
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp58_ = cur_target_dir;
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp59_ = g_file_get_basename (_tmp58_);
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp60_ = _tmp59_;
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp61_ = g_strconcat (_tmp60_, "/", NULL);
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp62_ = _tmp61_;
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_tmp63_ = g_strconcat (_tmp57_, _tmp62_, NULL);
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_g_free0 (relative_path);
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				relative_path = _tmp63_;
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_g_free0 (_tmp62_);
#line 220 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_g_free0 (_tmp60_);
#line 217 "/home/seb/gnome/gnome-latex/src/utils.vala"
				_g_object_unref0 (cur_target_dir);
#line 1386 "utils.c"
			}
		}
	}
#line 224 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp64_ = relative_path;
#line 224 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp65_ = g_file_get_basename (target);
#line 224 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp66_ = _tmp65_;
#line 224 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp67_ = g_strconcat (_tmp64_, _tmp66_, NULL);
#line 224 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_free0 (relative_path);
#line 224 "/home/seb/gnome/gnome-latex/src/utils.vala"
	relative_path = _tmp67_;
#line 224 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_free0 (_tmp66_);
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = relative_path;
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	(origin_dirs == NULL) ? NULL : (origin_dirs = (_g_list_free__g_object_unref0_ (origin_dirs), NULL));
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	(target_dirs == NULL) ? NULL : (target_dirs = (_g_list_free__g_object_unref0_ (target_dirs), NULL));
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_object_unref0 (target_parent);
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_object_unref0 (origin_dir);
#line 225 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 1416 "utils.c"
}


/*************************************************************************/
GtkScrolledWindow*
utils_add_scrollbar (GtkWidget* child)
{
	GtkScrolledWindow* result = NULL;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_;
#line 232 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (child != NULL, NULL);
#line 234 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 234 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_object_ref_sink (_tmp0_);
#line 234 "/home/seb/gnome/gnome-latex/src/utils.vala"
	sw = _tmp0_;
#line 235 "/home/seb/gnome/gnome-latex/src/utils.vala"
	gtk_container_add ((GtkContainer*) sw, child);
#line 236 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = sw;
#line 236 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 1441 "utils.c"
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 245 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1450 "utils.c"
}


gboolean
utils_tree_model_iter_prev (GtkTreeModel* model,
                            GtkTreeIter* iter)
{
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
#line 239 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 239 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 241 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp0_ = *iter;
#line 241 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
#line 241 "/home/seb/gnome/gnome-latex/src/utils.vala"
	path = _tmp1_;
#line 242 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp2_ = path;
#line 242 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (gtk_tree_path_prev (_tmp2_)) {
#line 1477 "utils.c"
		gboolean ret = FALSE;
		GtkTreePath* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
#line 244 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp3_ = path;
#line 244 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp5_ = gtk_tree_model_get_iter (model, &_tmp4_, _tmp3_);
#line 244 "/home/seb/gnome/gnome-latex/src/utils.vala"
		*iter = _tmp4_;
#line 244 "/home/seb/gnome/gnome-latex/src/utils.vala"
		ret = _tmp5_;
#line 245 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = ret;
#line 245 "/home/seb/gnome/gnome-latex/src/utils.vala"
		__vala_GtkTreePath_free0 (path);
#line 245 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 1496 "utils.c"
	}
#line 247 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = FALSE;
#line 247 "/home/seb/gnome/gnome-latex/src/utils.vala"
	__vala_GtkTreePath_free0 (path);
#line 247 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 1504 "utils.c"
}


gint
utils_get_selected_row (GtkTreeView* view,
                        GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	gint result = 0;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
#line 252 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (view != NULL, 0);
#line 254 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp0_ = gtk_tree_view_get_selection (view);
#line 254 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 254 "/home/seb/gnome/gnome-latex/src/utils.vala"
	select = _tmp1_;
#line 255 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp2_ = select;
#line 255 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
#line 255 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_vala_iter = _tmp3_;
#line 255 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (_tmp4_) {
#line 1536 "utils.c"
		GtkTreeModel* model = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		gint _tmp11_;
		gint* _tmp12_;
		gint _tmp13_;
#line 257 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp5_ = gtk_tree_view_get_model (view);
#line 257 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 257 "/home/seb/gnome/gnome-latex/src/utils.vala"
		model = _tmp6_;
#line 258 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp7_ = model;
#line 258 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp8_ = _vala_iter;
#line 258 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp9_ = gtk_tree_model_get_path (_tmp7_, &_tmp8_);
#line 258 "/home/seb/gnome/gnome-latex/src/utils.vala"
		path = _tmp9_;
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp10_ = path;
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp12_ = gtk_tree_path_get_indices_with_depth (_tmp10_, &_tmp11_);
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp13_ = _tmp12_[0];
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = _tmp13_;
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		__vala_GtkTreePath_free0 (path);
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (model);
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_g_object_unref0 (select);
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (iter) {
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
			*iter = _vala_iter;
#line 1580 "utils.c"
		}
#line 259 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 1584 "utils.c"
	}
#line 261 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = -1;
#line 261 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_g_object_unref0 (select);
#line 261 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (iter) {
#line 261 "/home/seb/gnome/gnome-latex/src/utils.vala"
		*iter = _vala_iter;
#line 1594 "utils.c"
	}
#line 261 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 1598 "utils.c"
}


GtkWindow*
utils_get_toplevel_window (GtkWidget* widget)
{
	GtkWindow* result = NULL;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
#line 264 "/home/seb/gnome/gnome-latex/src/utils.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 266 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp0_ = gtk_widget_get_toplevel (widget);
#line 266 "/home/seb/gnome/gnome-latex/src/utils.vala"
	toplevel = _tmp0_;
#line 268 "/home/seb/gnome/gnome-latex/src/utils.vala"
	_tmp1_ = toplevel;
#line 268 "/home/seb/gnome/gnome-latex/src/utils.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ())) {
#line 1619 "utils.c"
		GtkWidget* _tmp2_;
#line 269 "/home/seb/gnome/gnome-latex/src/utils.vala"
		_tmp2_ = toplevel;
#line 269 "/home/seb/gnome/gnome-latex/src/utils.vala"
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL;
#line 269 "/home/seb/gnome/gnome-latex/src/utils.vala"
		return result;
#line 1627 "utils.c"
	}
#line 271 "/home/seb/gnome/gnome-latex/src/utils.vala"
	result = NULL;
#line 271 "/home/seb/gnome/gnome-latex/src/utils.vala"
	return result;
#line 1633 "utils.c"
}


/*************************************************************************/
void
utils_flush_queue (void)
{
#line 280 "/home/seb/gnome/gnome-latex/src/utils.vala"
	while (TRUE) {
#line 280 "/home/seb/gnome/gnome-latex/src/utils.vala"
		if (!gtk_events_pending ()) {
#line 280 "/home/seb/gnome/gnome-latex/src/utils.vala"
			break;
#line 1647 "utils.c"
		}
#line 281 "/home/seb/gnome/gnome-latex/src/utils.vala"
		gtk_main_iteration ();
#line 1651 "utils.c"
	}
}



