/* latex_menu.c generated by valac 0.40.8, the Vala compiler
 * generated from latex_menu.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <latexila.h>
#include <amtk/amtk.h>
#include <gio/gio.h>


#define TYPE_LATEX_MENU (latex_menu_get_type ())
#define LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_MENU, LatexMenu))
#define LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_MENU, LatexMenuClass))
#define IS_LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_MENU))
#define IS_LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_MENU))
#define LATEX_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_MENU, LatexMenuClass))

typedef struct _LatexMenu LatexMenu;
typedef struct _LatexMenuClass LatexMenuClass;
typedef struct _LatexMenuPrivate LatexMenuPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	LATEX_MENU_0_PROPERTY,
	LATEX_MENU_NUM_PROPERTIES
};
static GParamSpec* latex_menu_properties[LATEX_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MENU_TOOL_ACTION (menu_tool_action_get_type ())
#define MENU_TOOL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_TOOL_ACTION, MenuToolAction))
#define MENU_TOOL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_TOOL_ACTION, MenuToolActionClass))
#define IS_MENU_TOOL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_TOOL_ACTION))
#define IS_MENU_TOOL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_TOOL_ACTION))
#define MENU_TOOL_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_TOOL_ACTION, MenuToolActionClass))

typedef struct _MenuToolAction MenuToolAction;
typedef struct _MenuToolActionClass MenuToolActionClass;

struct _LatexMenu {
	GtkActionGroup parent_instance;
	LatexMenuPrivate * priv;
};

struct _LatexMenuClass {
	GtkActionGroupClass parent_class;
};

struct _LatexMenuPrivate {
	MainWindow* main_window;
};


static gpointer latex_menu_parent_class = NULL;

GType latex_menu_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define LATEX_MENU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEX_MENU, LatexMenuPrivate))
LatexMenu* latex_menu_new (MainWindow* main_window);
LatexMenu* latex_menu_construct (GType object_type,
                                 MainWindow* main_window);
static GtkAction* latex_menu_get_menu_tool_action (LatexMenu* self,
                                            const gchar* name,
                                            const gchar* label,
                                            const gchar* icon_name);
MenuToolAction* menu_tool_action_new (const gchar* name,
                                      const gchar* label,
                                      const gchar* tooltip,
                                      const gchar* icon_name);
MenuToolAction* menu_tool_action_construct (GType object_type,
                                            const gchar* name,
                                            const gchar* label,
                                            const gchar* tooltip,
                                            const gchar* icon_name);
GType menu_tool_action_get_type (void) G_GNUC_CONST;
static void latex_menu_finalize (GObject * obj);

static const GtkActionEntry LATEX_MENU_latex_action_entries[23] = {{"Latex", NULL, "_LaTeX"}, {"Sectioning", "sectioning", N_ ("_Sectioning")}, {"References", "references", N_ ("_References")}, {"Environments", "format-justify-center", "_Environments"}, {"ListEnvironments", "list-itemize", N_ ("_List Environments")}, {"CharacterSize", "character-size", N_ ("_Characters Sizes")}, {"FontStyles", "bold", N_ ("_Font Styles")}, {"FontFamily", NULL, N_ ("_Font Family")}, {"FontSeries", NULL, N_ ("F_ont Series")}, {"FontShape", NULL, N_ ("Fo_nt Shape")}, {"Tabular", "table", N_ ("_Tabular")}, {"Presentation", "x-office-presentation", "_Presentation"}, {"Spacing", NULL, N_ ("_Spacing")}, {"Accents", NULL, N_ ("International _Accents")}, {"LatexMisc", NULL, N_ ("_Misc")}, {"Math", NULL, N_ ("_Math")}, {"MathEnvironments", NULL, N_ ("_Math Environments")}, {"MathFunctions", NULL, N_ ("Math _Functions")}, {"MathFontStyles", NULL, N_ ("Math Font _Styles")}, {"MathAccents", NULL, N_ ("Math _Accents")}, {"MathSpaces", NULL, N_ ("Math _Spaces")}, {"MathLeftDelimiters", "delimiters-left", N_ ("_Left Delimiters")}, {"MathRightDelimiters", "delimiters-right", N_ ("Right _Delimiters")}};

LatexMenu*
latex_menu_construct (GType object_type,
                      MainWindow* main_window)
{
	LatexMenu * self = NULL;
	GtkAction* sectioning = NULL;
	GtkAction* _tmp0_;
	GtkAction* sizes = NULL;
	GtkAction* _tmp1_;
	GtkAction* references = NULL;
	GtkAction* _tmp2_;
	GtkAction* presentation_env = NULL;
	GtkAction* _tmp3_;
	GtkAction* math_env = NULL;
	GtkAction* _tmp4_;
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 60 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	self = (LatexMenu*) g_object_new (object_type, "name", "LatexActionGroup", NULL);
#line 61 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_action_group_set_translation_domain ((GtkActionGroup*) self, GETTEXT_PACKAGE);
#line 63 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	self->priv->main_window = main_window;
#line 66 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_tmp0_ = latex_menu_get_menu_tool_action (self, "SectioningToolItem", _ ("Sectioning"), "sectioning");
#line 66 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	sectioning = _tmp0_;
#line 69 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_tmp1_ = latex_menu_get_menu_tool_action (self, "CharacterSizeToolItem", _ ("Characters Sizes"), "character-size");
#line 69 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	sizes = _tmp1_;
#line 72 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_tmp2_ = latex_menu_get_menu_tool_action (self, "ReferencesToolItem", _ ("References"), "references");
#line 72 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	references = _tmp2_;
#line 75 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_tmp3_ = latex_menu_get_menu_tool_action (self, "PresentationToolItem", _ ("Presentation Environments"), "x-office-presentation");
#line 75 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	presentation_env = _tmp3_;
#line 78 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_tmp4_ = latex_menu_get_menu_tool_action (self, "MathEnvironmentsToolItem", _ ("Math Environments"), "math");
#line 78 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	math_env = _tmp4_;
#line 81 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_action_group_add_actions ((GtkActionGroup*) self, LATEX_MENU_latex_action_entries, (guint) G_N_ELEMENTS (LATEX_MENU_latex_action_entries), self);
#line 82 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, sectioning);
#line 83 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, sizes);
#line 84 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, references);
#line 85 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, presentation_env);
#line 86 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_action_group_add_action ((GtkActionGroup*) self, math_env);
#line 90 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	latexila_latex_commands_add_actions ((GtkApplicationWindow*) main_window);
#line 93 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::part", (GtkActionGroup*) self, "SectioningPart");
#line 95 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::chapter", (GtkActionGroup*) self, "SectioningChapter");
#line 97 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::section", (GtkActionGroup*) self, "SectioningSection");
#line 99 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::subsection", (GtkActionGroup*) self, "SectioningSubsection");
#line 101 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::subsubsection", (GtkActionGroup*) self, "SectioningSubsubsection");
#line 103 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::paragraph", (GtkActionGroup*) self, "SectioningParagraph");
#line 105 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::subparagraph", (GtkActionGroup*) self, "SectioningSubparagraph");
#line 109 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::label", (GtkActionGroup*) self, "ReferencesLabel");
#line 111 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::ref", (GtkActionGroup*) self, "ReferencesRef");
#line 113 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::pageref", (GtkActionGroup*) self, "ReferencesPageref");
#line 115 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::index", (GtkActionGroup*) self, "ReferencesIndex");
#line 117 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::footnote", (GtkActionGroup*) self, "ReferencesFootnote");
#line 119 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::cite", (GtkActionGroup*) self, "ReferencesCite");
#line 123 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::center", (GtkActionGroup*) self, "EnvCenter");
#line 125 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::flushleft", (GtkActionGroup*) self, "EnvLeft");
#line 127 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::flushright", (GtkActionGroup*) self, "EnvRight");
#line 129 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-figure", (GtkActionGroup*) self, "EnvFigure");
#line 131 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-table", (GtkActionGroup*) self, "EnvTable");
#line 133 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::quote", (GtkActionGroup*) self, "EnvQuote");
#line 135 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::quotation", (GtkActionGroup*) self, "EnvQuotation");
#line 137 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::verse", (GtkActionGroup*) self, "EnvVerse");
#line 139 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::verbatim", (GtkActionGroup*) self, "EnvVerbatim");
#line 141 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::minipage", (GtkActionGroup*) self, "EnvMinipage");
#line 143 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::titlepage", (GtkActionGroup*) self, "EnvTitlepage");
#line 147 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-simple::itemize", (GtkActionGroup*) self, "ListEnvItemize");
#line 149 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-simple::enumerate", (GtkActionGroup*) self, "ListEnvEnumerate");
#line 151 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-description", (GtkActionGroup*) self, "ListEnvDescription");
#line 153 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-list-env-list", (GtkActionGroup*) self, "ListEnvList");
#line 155 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::item", (GtkActionGroup*) self, "ListEnvItem");
#line 159 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::tiny", (GtkActionGroup*) self, "CharacterSizeTiny");
#line 161 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::scriptsize", (GtkActionGroup*) self, "CharacterSizeScriptsize");
#line 163 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::footnotesize", (GtkActionGroup*) self, "CharacterSizeFootnotesize");
#line 165 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::small", (GtkActionGroup*) self, "CharacterSizeSmall");
#line 167 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::normalsize", (GtkActionGroup*) self, "CharacterSizeNormalsize");
#line 169 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::large", (GtkActionGroup*) self, "CharacterSizelarge");
#line 171 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::Large", (GtkActionGroup*) self, "CharacterSizeLarge");
#line 173 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::LARGE", (GtkActionGroup*) self, "CharacterSizeLARGE");
#line 175 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::huge", (GtkActionGroup*) self, "CharacterSizehuge");
#line 177 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::Huge", (GtkActionGroup*) self, "CharacterSizeHuge");
#line 181 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textbf", (GtkActionGroup*) self, "Bold");
#line 183 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textit", (GtkActionGroup*) self, "Italic");
#line 185 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::texttt", (GtkActionGroup*) self, "Typewriter");
#line 187 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textsl", (GtkActionGroup*) self, "Slanted");
#line 189 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textsc", (GtkActionGroup*) self, "SmallCaps");
#line 191 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::textsf", (GtkActionGroup*) self, "SansSerif");
#line 193 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::emph", (GtkActionGroup*) self, "Emph");
#line 195 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::underline", (GtkActionGroup*) self, "Underline");
#line 198 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::rmfamily", (GtkActionGroup*) self, "FontFamilyRoman");
#line 200 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::sffamily", (GtkActionGroup*) self, "FontFamilySansSerif");
#line 202 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::ttfamily", (GtkActionGroup*) self, "FontFamilyMonospace");
#line 205 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::mdseries", (GtkActionGroup*) self, "FontSeriesMedium");
#line 207 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::bfseries", (GtkActionGroup*) self, "FontSeriesBold");
#line 210 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::upshape", (GtkActionGroup*) self, "FontShapeUpright");
#line 212 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::itshape", (GtkActionGroup*) self, "FontShapeItalic");
#line 214 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::slshape", (GtkActionGroup*) self, "FontShapeSlanted");
#line 216 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-char-style::scshape", (GtkActionGroup*) self, "FontShapeSmallCaps");
#line 220 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::tabbing", (GtkActionGroup*) self, "TabularTabbing");
#line 222 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-tabular-tabular", (GtkActionGroup*) self, "TabularTabular");
#line 224 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-tabular-multicolumn", (GtkActionGroup*) self, "TabularMulticolumn");
#line 226 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::hline", (GtkActionGroup*) self, "TabularHline");
#line 228 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::vline", (GtkActionGroup*) self, "TabularVline");
#line 230 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-tabular-cline", (GtkActionGroup*) self, "TabularCline");
#line 234 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-presentation-frame", (GtkActionGroup*) self, "PresentationFrame");
#line 236 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-presentation-block", (GtkActionGroup*) self, "PresentationBlock");
#line 238 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-presentation-columns", (GtkActionGroup*) self, "PresentationColumns");
#line 242 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-spacing-new-line", (GtkActionGroup*) self, "SpacingNewLine");
#line 244 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-newline::newpage", (GtkActionGroup*) self, "SpacingNewPage");
#line 246 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-newline::linebreak", (GtkActionGroup*) self, "SpacingLineBreak");
#line 248 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-newline::pagebreak", (GtkActionGroup*) self, "SpacingPageBreak");
#line 250 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::bigskip", (GtkActionGroup*) self, "SpacingBigSkip");
#line 252 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::medskip", (GtkActionGroup*) self, "SpacingMedSkip");
#line 254 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::hspace", (GtkActionGroup*) self, "SpacingHSpace");
#line 256 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::vspace", (GtkActionGroup*) self, "SpacingVSpace");
#line 258 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::noindent", (GtkActionGroup*) self, "SpacingNoIndent");
#line 262 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('\\'')", (GtkActionGroup*) self, "Accent0");
#line 264 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('`')", (GtkActionGroup*) self, "Accent1");
#line 266 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('^')", (GtkActionGroup*) self, "Accent2");
#line 268 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('\"')", (GtkActionGroup*) self, "Accent3");
#line 270 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('~')", (GtkActionGroup*) self, "Accent4");
#line 272 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('=')", (GtkActionGroup*) self, "Accent5");
#line 274 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('.')", (GtkActionGroup*) self, "Accent6");
#line 276 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('v')", (GtkActionGroup*) self, "Accent7");
#line 278 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('u')", (GtkActionGroup*) self, "Accent8");
#line 280 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('H')", (GtkActionGroup*) self, "Accent9");
#line 282 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('c')", (GtkActionGroup*) self, "Accent10");
#line 284 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('k')", (GtkActionGroup*) self, "Accent11");
#line 286 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('d')", (GtkActionGroup*) self, "Accent12");
#line 288 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('b')", (GtkActionGroup*) self, "Accent13");
#line 290 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('r')", (GtkActionGroup*) self, "Accent14");
#line 292 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces('t')", (GtkActionGroup*) self, "Accent15");
#line 296 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::documentclass", (GtkActionGroup*) self, "LatexDocumentClass");
#line 298 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::usepackage", (GtkActionGroup*) self, "LatexUsepackage");
#line 300 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-ams-packages", (GtkActionGroup*) self, "LatexAMS");
#line 302 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::author", (GtkActionGroup*) self, "LatexAuthor");
#line 304 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::title", (GtkActionGroup*) self, "LatexTitle");
#line 306 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::document", (GtkActionGroup*) self, "LatexBeginDocument");
#line 308 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-simple::maketitle", (GtkActionGroup*) self, "LatexMakeTitle");
#line 310 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-simple::tableofcontents", (GtkActionGroup*) self, "LatexTableOfContents");
#line 312 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::abstract", (GtkActionGroup*) self, "LatexAbstract");
#line 314 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::includegraphics", (GtkActionGroup*) self, "LatexIncludeGraphics");
#line 316 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::input", (GtkActionGroup*) self, "LatexInput");
#line 320 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-env-normal", (GtkActionGroup*) self, "MathEnvNormal");
#line 322 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-env-centered", (GtkActionGroup*) self, "MathEnvCentered");
#line 324 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::equation", (GtkActionGroup*) self, "MathEnvNumbered");
#line 326 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-env-array", (GtkActionGroup*) self, "MathEnvArray");
#line 328 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-env-simple::align", (GtkActionGroup*) self, "MathEnvNumberedArray");
#line 332 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-superscript", (GtkActionGroup*) self, "MathSuperscript");
#line 334 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-subscript", (GtkActionGroup*) self, "MathSubscript");
#line 336 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-frac", (GtkActionGroup*) self, "MathFrac");
#line 338 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::sqrt", (GtkActionGroup*) self, "MathSquareRoot");
#line 340 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-misc-nth-root", (GtkActionGroup*) self, "MathNthRoot");
#line 344 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::arccos", (GtkActionGroup*) self, "MathFuncArccos");
#line 346 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::arcsin", (GtkActionGroup*) self, "MathFuncArcsin");
#line 348 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::arctan", (GtkActionGroup*) self, "MathFuncArctan");
#line 350 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::cos", (GtkActionGroup*) self, "MathFuncCos");
#line 352 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::cosh", (GtkActionGroup*) self, "MathFuncCosh");
#line 354 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::cot", (GtkActionGroup*) self, "MathFuncCot");
#line 356 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::coth", (GtkActionGroup*) self, "MathFuncCoth");
#line 358 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::csc", (GtkActionGroup*) self, "MathFuncCsc");
#line 360 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::deg", (GtkActionGroup*) self, "MathFuncDeg");
#line 362 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::det", (GtkActionGroup*) self, "MathFuncDet");
#line 364 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::dim", (GtkActionGroup*) self, "MathFuncDim");
#line 366 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::exp", (GtkActionGroup*) self, "MathFuncExp");
#line 368 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::gcd", (GtkActionGroup*) self, "MathFuncGcd");
#line 370 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::hom", (GtkActionGroup*) self, "MathFuncHom");
#line 372 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::inf", (GtkActionGroup*) self, "MathFuncInf");
#line 374 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::ker", (GtkActionGroup*) self, "MathFuncKer");
#line 376 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::lg", (GtkActionGroup*) self, "MathFuncLg");
#line 378 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::lim", (GtkActionGroup*) self, "MathFuncLim");
#line 380 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::liminf", (GtkActionGroup*) self, "MathFuncLiminf");
#line 382 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::limsup", (GtkActionGroup*) self, "MathFuncLimsup");
#line 384 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::ln", (GtkActionGroup*) self, "MathFuncLn");
#line 386 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::log", (GtkActionGroup*) self, "MathFuncLog");
#line 388 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::max", (GtkActionGroup*) self, "MathFuncMax");
#line 390 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::min", (GtkActionGroup*) self, "MathFuncMin");
#line 392 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sec", (GtkActionGroup*) self, "MathFuncSec");
#line 394 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sin", (GtkActionGroup*) self, "MathFuncSin");
#line 396 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sinh", (GtkActionGroup*) self, "MathFuncSinh");
#line 398 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::sup", (GtkActionGroup*) self, "MathFuncSup");
#line 400 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::tan", (GtkActionGroup*) self, "MathFuncTan");
#line 402 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::tanh", (GtkActionGroup*) self, "MathFuncTanh");
#line 406 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathrm", (GtkActionGroup*) self, "MathFSrm");
#line 408 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathit", (GtkActionGroup*) self, "MathFSit");
#line 410 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathbf", (GtkActionGroup*) self, "MathFSbf");
#line 412 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathsf", (GtkActionGroup*) self, "MathFSsf");
#line 414 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathtt", (GtkActionGroup*) self, "MathFStt");
#line 416 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathcal", (GtkActionGroup*) self, "MathFScal");
#line 418 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathbb", (GtkActionGroup*) self, "MathFSbb");
#line 420 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathfrak", (GtkActionGroup*) self, "MathFSfrak");
#line 424 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::acute", (GtkActionGroup*) self, "MathAccentAcute");
#line 426 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::grave", (GtkActionGroup*) self, "MathAccentGrave");
#line 428 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::tilde", (GtkActionGroup*) self, "MathAccentTilde");
#line 430 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::bar", (GtkActionGroup*) self, "MathAccentBar");
#line 432 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::vec", (GtkActionGroup*) self, "MathAccentVec");
#line 434 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::hat", (GtkActionGroup*) self, "MathAccentHat");
#line 436 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::check", (GtkActionGroup*) self, "MathAccentCheck");
#line 438 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::breve", (GtkActionGroup*) self, "MathAccentBreve");
#line 440 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::dot", (GtkActionGroup*) self, "MathAccentDot");
#line 442 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::ddot", (GtkActionGroup*) self, "MathAccentDdot");
#line 444 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-braces::mathring", (GtkActionGroup*) self, "MathAccentRing");
#line 448 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-spaces-small", (GtkActionGroup*) self, "MathSpaceSmall");
#line 450 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-spaces-medium", (GtkActionGroup*) self, "MathSpaceMedium");
#line 452 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-spaces-large", (GtkActionGroup*) self, "MathSpaceLarge");
#line 454 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::quad", (GtkActionGroup*) self, "MathSpaceQuad");
#line 456 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.latex-command-with-space::qquad", (GtkActionGroup*) self, "MathSpaceQquad");
#line 460 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left1", (GtkActionGroup*) self, "MathLeftDelimiter1");
#line 462 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left2", (GtkActionGroup*) self, "MathLeftDelimiter2");
#line 464 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left3", (GtkActionGroup*) self, "MathLeftDelimiter3");
#line 466 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left4", (GtkActionGroup*) self, "MathLeftDelimiter4");
#line 468 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left5", (GtkActionGroup*) self, "MathLeftDelimiter5");
#line 470 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left6", (GtkActionGroup*) self, "MathLeftDelimiter6");
#line 472 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left7", (GtkActionGroup*) self, "MathLeftDelimiter7");
#line 474 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left8", (GtkActionGroup*) self, "MathLeftDelimiter8");
#line 476 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-left9", (GtkActionGroup*) self, "MathLeftDelimiter9");
#line 480 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right1", (GtkActionGroup*) self, "MathRightDelimiter1");
#line 482 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right2", (GtkActionGroup*) self, "MathRightDelimiter2");
#line 484 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right3", (GtkActionGroup*) self, "MathRightDelimiter3");
#line 486 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right4", (GtkActionGroup*) self, "MathRightDelimiter4");
#line 488 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right5", (GtkActionGroup*) self, "MathRightDelimiter5");
#line 490 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right6", (GtkActionGroup*) self, "MathRightDelimiter6");
#line 492 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right7", (GtkActionGroup*) self, "MathRightDelimiter7");
#line 494 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right8", (GtkActionGroup*) self, "MathRightDelimiter8");
#line 496 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	amtk_utils_create_gtk_action ((GActionMap*) main_window, "win.math-command-delimiter-right9", (GtkActionGroup*) self, "MathRightDelimiter9");
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_g_object_unref0 (math_env);
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_g_object_unref0 (presentation_env);
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_g_object_unref0 (references);
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_g_object_unref0 (sizes);
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_g_object_unref0 (sectioning);
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	return self;
#line 549 "latex_menu.c"
}


LatexMenu*
latex_menu_new (MainWindow* main_window)
{
#line 58 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	return latex_menu_construct (TYPE_LATEX_MENU, main_window);
#line 558 "latex_menu.c"
}


static GtkAction*
latex_menu_get_menu_tool_action (LatexMenu* self,
                                 const gchar* name,
                                 const gchar* label,
                                 const gchar* icon_name)
{
	GtkAction* result = NULL;
	GtkAction* action = NULL;
	MenuToolAction* _tmp0_;
	GtkActivatable* menu_tool_button = NULL;
	GtkMenuToolButton* _tmp1_;
#line 500 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 500 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 502 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_tmp0_ = menu_tool_action_new (name, label, label, icon_name);
#line 502 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	action = (GtkAction*) _tmp0_;
#line 503 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_tmp1_ = (GtkMenuToolButton*) gtk_menu_tool_button_new (NULL, NULL);
#line 503 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	g_object_ref_sink (_tmp1_);
#line 503 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	menu_tool_button = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_activatable_get_type (), GtkActivatable);
#line 504 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	gtk_activatable_set_related_action (menu_tool_button, action);
#line 505 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	result = action;
#line 505 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	_g_object_unref0 (menu_tool_button);
#line 505 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	return result;
#line 595 "latex_menu.c"
}


static void
latex_menu_class_init (LatexMenuClass * klass)
{
#line 22 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	latex_menu_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	g_type_class_add_private (klass, sizeof (LatexMenuPrivate));
#line 22 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	G_OBJECT_CLASS (klass)->finalize = latex_menu_finalize;
#line 608 "latex_menu.c"
}


static void
latex_menu_instance_init (LatexMenu * self)
{
#line 22 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	self->priv = LATEX_MENU_GET_PRIVATE (self);
#line 617 "latex_menu.c"
}


static void
latex_menu_finalize (GObject * obj)
{
	LatexMenu * self;
#line 22 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LATEX_MENU, LatexMenu);
#line 22 "/home/seb/gnome/gnome-latex/src/latex_menu.vala"
	G_OBJECT_CLASS (latex_menu_parent_class)->finalize (obj);
#line 629 "latex_menu.c"
}


GType
latex_menu_get_type (void)
{
	static volatile gsize latex_menu_type_id__volatile = 0;
	if (g_once_init_enter (&latex_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latex_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexMenu), 0, (GInstanceInitFunc) latex_menu_instance_init, NULL };
		GType latex_menu_type_id;
		latex_menu_type_id = g_type_register_static (gtk_action_group_get_type (), "LatexMenu", &g_define_type_info, 0);
		g_once_init_leave (&latex_menu_type_id__volatile, latex_menu_type_id);
	}
	return latex_menu_type_id__volatile;
}



