/* build_tool_dialog.c generated by valac 0.40.8, the Vala compiler
 * generated from build_tool_dialog.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2015 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The configuration of a single build tool.*/


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _BuildToolDialogPrivate BuildToolDialogPrivate;
enum  {
	BUILD_TOOL_DIALOG_0_PROPERTY,
	BUILD_TOOL_DIALOG_NUM_PROPERTIES
};
static GParamSpec* build_tool_dialog_properties[BUILD_TOOL_DIALOG_NUM_PROPERTIES];

#define BUILD_TOOL_DIALOG_TYPE_ICON_COLUMN (build_tool_dialog_icon_column_get_type ())

#define BUILD_TOOL_DIALOG_TYPE_JOB_COLUMN (build_tool_dialog_job_column_get_type ())

#define BUILD_TOOL_DIALOG_TYPE_POST_PROCESSOR_COLUMN (build_tool_dialog_post_processor_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BuildToolDialog {
	GObject parent_instance;
	BuildToolDialogPrivate * priv;
};

struct _BuildToolDialogClass {
	GObjectClass parent_class;
};

struct _BuildToolDialogPrivate {
	GtkDialog* _dialog;
	GtkEntry* _entry_label;
	GtkEntry* _entry_desc;
	GtkEntry* _entry_extensions;
	GtkEntry* _entry_files_to_open;
	GtkListStore* _icons_store;
	GtkComboBox* _icons_combobox;
	GtkListStore* _jobs_store;
	GtkTreeView* _jobs_view;
};

typedef enum  {
	BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME,
	BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL,
	BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS
} BuildToolDialogIconColumn;

typedef enum  {
	BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND,
	BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR,
	BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS
} BuildToolDialogJobColumn;

typedef enum  {
	BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME,
	BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS
} BuildToolDialogPostProcessorColumn;

struct _Block1Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* remove_button;
	GtkTreeSelection* select;
};

struct _Block2Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block3Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};


static gpointer build_tool_dialog_parent_class = NULL;

GType build_tool_dialog_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogPrivate))
static GType build_tool_dialog_icon_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType build_tool_dialog_job_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType build_tool_dialog_post_processor_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BuildToolDialog* build_tool_dialog_new (GtkWindow* parent,
                                        gboolean editable);
BuildToolDialog* build_tool_dialog_construct (GType object_type,
                                              GtkWindow* parent,
                                              gboolean editable);
static void build_tool_dialog_init_text_entries (BuildToolDialog* self,
                                          gboolean editable);
static void build_tool_dialog_init_icons_store (BuildToolDialog* self);
static void build_tool_dialog_init_icons_combobox (BuildToolDialog* self);
static void build_tool_dialog_init_jobs (BuildToolDialog* self,
                                  gboolean editable);
static GtkGrid* build_tool_dialog_get_main_grid (BuildToolDialog* self,
                                          gboolean editable);
gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self,
                                            LatexilaBuildTools* build_tools,
                                            gint build_tool_num);
static void build_tool_dialog_set_build_tool (BuildToolDialog* self,
                                       LatexilaBuildTool* build_tool);
static LatexilaBuildTool* build_tool_dialog_retrieve_build_tool (BuildToolDialog* self);
gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void build_tool_dialog_set_new_build_tool (BuildToolDialog* self);
static void build_tool_dialog_add_icon (BuildToolDialog* self,
                                 const gchar* icon_name,
                                 const gchar* label);
static void ___lambda98_ (BuildToolDialog* self,
                   const gchar* path_string,
                   const gchar* new_text);
static void ____lambda98__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                  const gchar* path,
                                                  const gchar* new_text,
                                                  gpointer self);
static void __lambda99_ (BuildToolDialog* self,
                  const gchar* path_string,
                  const gchar* new_text);
static void ___lambda99__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                 const gchar* path,
                                                 const gchar* new_text,
                                                 gpointer self);
static GtkToolButton* build_tool_dialog_get_add_button (BuildToolDialog* self);
static void __lambda100_ (BuildToolDialog* self);
static void build_tool_dialog_add_build_job (BuildToolDialog* self,
                                      LatexilaBuildJob* job);
static void ___lambda100__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static GtkToolButton* build_tool_dialog_get_remove_button (BuildToolDialog* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda101_ (Block1Data* _data1_);
static void ___lambda101__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void __lambda102_ (BuildToolDialog* self);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void ___lambda102__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static GtkToolButton* build_tool_dialog_get_up_button (BuildToolDialog* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda103_ (Block2Data* _data2_);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void ___lambda103__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void __lambda104_ (Block2Data* _data2_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model,
                                     GtkTreeIter* iter);
static void ___lambda104__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static GtkToolButton* build_tool_dialog_get_down_button (BuildToolDialog* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda105_ (Block3Data* _data3_);
static void ___lambda105__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void __lambda106_ (Block3Data* _data3_);
static void ___lambda106__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static GtkGrid* build_tool_dialog_get_label_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_desc_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_extensions_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_icons_grid (BuildToolDialog* self);
static GtkWidget* build_tool_dialog_get_jobs_grid (BuildToolDialog* self,
                                            gboolean editable);
static GtkWidget* build_tool_dialog_get_files_to_open_grid (BuildToolDialog* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void build_tool_dialog_finalize (GObject * obj);


static GType
build_tool_dialog_icon_column_get_type (void)
{
	static volatile gsize build_tool_dialog_icon_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_icon_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, "BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME", "icon-name"}, {BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, "BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL", "label"}, {BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_icon_column_type_id;
		build_tool_dialog_icon_column_type_id = g_enum_register_static ("BuildToolDialogIconColumn", values);
		g_once_init_leave (&build_tool_dialog_icon_column_type_id__volatile, build_tool_dialog_icon_column_type_id);
	}
	return build_tool_dialog_icon_column_type_id__volatile;
}


static GType
build_tool_dialog_job_column_get_type (void)
{
	static volatile gsize build_tool_dialog_job_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_job_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, "BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND", "command"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR", "post-processor"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_job_column_type_id;
		build_tool_dialog_job_column_type_id = g_enum_register_static ("BuildToolDialogJobColumn", values);
		g_once_init_leave (&build_tool_dialog_job_column_type_id__volatile, build_tool_dialog_job_column_type_id);
	}
	return build_tool_dialog_job_column_type_id__volatile;
}


static GType
build_tool_dialog_post_processor_column_get_type (void)
{
	static volatile gsize build_tool_dialog_post_processor_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_post_processor_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, "BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME", "name"}, {BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_post_processor_column_type_id;
		build_tool_dialog_post_processor_column_type_id = g_enum_register_static ("BuildToolDialogPostProcessorColumn", values);
		g_once_init_leave (&build_tool_dialog_post_processor_column_type_id__volatile, build_tool_dialog_post_processor_column_type_id);
	}
	return build_tool_dialog_post_processor_column_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 84 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 269 "build_tool_dialog.c"
}


BuildToolDialog*
build_tool_dialog_construct (GType object_type,
                             GtkWindow* parent,
                             gboolean editable)
{
	BuildToolDialog * self = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
#line 61 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 61 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self = (BuildToolDialog*) g_object_new (object_type, NULL);
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp2_ == NULL) {
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_tmp1_);
#line 305 "build_tool_dialog.c"
	}
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_dialog);
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_dialog = _tmp2_;
#line 65 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = self->priv->_dialog;
#line 65 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp3_, TRUE);
#line 66 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = self->priv->_dialog;
#line 66 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
#line 67 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = self->priv->_dialog;
#line 67 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, parent);
#line 69 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (editable) {
#line 325 "build_tool_dialog.c"
		GtkDialog* _tmp6_;
		GtkDialog* _tmp7_;
		GtkDialog* _tmp8_;
		GtkDialog* _tmp9_;
#line 71 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp6_ = self->priv->_dialog;
#line 71 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_window_set_title ((GtkWindow*) _tmp6_, _ ("Personal Build Tool"));
#line 72 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp7_ = self->priv->_dialog;
#line 72 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_dialog_add_button (_tmp7_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 73 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp8_ = self->priv->_dialog;
#line 73 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_dialog_add_button (_tmp8_, _ ("_Apply"), (gint) GTK_RESPONSE_APPLY);
#line 74 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp9_ = self->priv->_dialog;
#line 74 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_dialog_set_default_response (_tmp9_, (gint) GTK_RESPONSE_APPLY);
#line 346 "build_tool_dialog.c"
	} else {
		GtkDialog* _tmp10_;
#line 77 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp10_ = self->priv->_dialog;
#line 77 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_window_set_title ((GtkWindow*) _tmp10_, _ ("Default Build Tool (read-only)"));
#line 353 "build_tool_dialog.c"
	}
#line 79 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_init_text_entries (self, editable);
#line 80 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_init_icons_store (self);
#line 81 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_init_icons_combobox (self);
#line 82 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_init_jobs (self, editable);
#line 84 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = self->priv->_dialog;
#line 84 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = gtk_dialog_get_content_area (_tmp11_);
#line 84 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 84 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	content_area = _tmp13_;
#line 85 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp14_ = build_tool_dialog_get_main_grid (self, editable);
#line 85 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp15_ = _tmp14_;
#line 85 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_box_pack_start (content_area, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
#line 85 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (_tmp15_);
#line 86 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_show_all ((GtkWidget*) content_area);
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (content_area);
#line 63 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return self;
#line 385 "build_tool_dialog.c"
}


BuildToolDialog*
build_tool_dialog_new (GtkWindow* parent,
                       gboolean editable)
{
#line 61 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return build_tool_dialog_construct (TYPE_BUILD_TOOL_DIALOG, parent, editable);
#line 395 "build_tool_dialog.c"
}


gboolean
build_tool_dialog_open_build_tool (BuildToolDialog* self,
                                   LatexilaBuildTools* build_tools,
                                   gint build_tool_num)
{
	gboolean result = FALSE;
	LatexilaBuildTool* build_tool = NULL;
	LatexilaBuildTool* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	LatexilaBuildTool* _tmp2_;
	LatexilaBuildTool* _tmp3_;
	gboolean apply = FALSE;
	GtkDialog* _tmp4_;
	gboolean _tmp5_;
	GtkDialog* _tmp14_;
#line 90 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (build_tools != NULL, FALSE);
#line 92 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = latexila_build_tools_nth (build_tools, (guint) build_tool_num);
#line 92 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 92 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool = _tmp1_;
#line 93 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = build_tool;
#line 93 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (_tmp2_ != NULL, FALSE);
#line 95 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = build_tool;
#line 95 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_set_build_tool (self, _tmp3_);
#line 97 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = self->priv->_dialog;
#line 97 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	apply = gtk_dialog_run (_tmp4_) == ((gint) GTK_RESPONSE_APPLY);
#line 99 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = apply;
#line 99 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp5_) {
#line 440 "build_tool_dialog.c"
		LatexilaBuildTool* new_build_tool = NULL;
		LatexilaBuildTool* _tmp6_;
		LatexilaBuildTool* _tmp7_;
		LatexilaBuildTool* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		LatexilaBuildToolsPersonal* personal_build_tools = NULL;
		LatexilaBuildToolsPersonal* _tmp11_;
		LatexilaBuildToolsPersonal* _tmp12_;
		LatexilaBuildTool* _tmp13_;
#line 101 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp6_ = build_tool_dialog_retrieve_build_tool (self);
#line 101 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		new_build_tool = _tmp6_;
#line 102 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp7_ = new_build_tool;
#line 102 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp8_ = build_tool;
#line 102 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_object_get (_tmp8_, "enabled", &_tmp9_, NULL);
#line 102 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp10_ = _tmp9_;
#line 102 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_object_set (_tmp7_, "enabled", _tmp10_, NULL);
#line 104 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (build_tools, latexila_build_tools_personal_get_type ()) ? ((LatexilaBuildToolsPersonal*) build_tools) : NULL);
#line 104 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		personal_build_tools = _tmp11_;
#line 106 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp12_ = personal_build_tools;
#line 106 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp13_ = new_build_tool;
#line 106 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		latexila_build_tools_personal_replace (_tmp12_, _tmp13_, (guint) build_tool_num);
#line 99 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (personal_build_tools);
#line 99 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (new_build_tool);
#line 479 "build_tool_dialog.c"
	}
#line 109 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp14_ = self->priv->_dialog;
#line 109 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp14_);
#line 110 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = apply;
#line 110 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (build_tool);
#line 110 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 491 "build_tool_dialog.c"
}


gboolean
build_tool_dialog_create_personal_build_tool (BuildToolDialog* self)
{
	gboolean result = FALSE;
	gboolean apply = FALSE;
	GtkDialog* _tmp0_;
	gboolean _tmp1_;
	GtkDialog* _tmp8_;
#line 115 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 117 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_set_new_build_tool (self);
#line 119 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_dialog;
#line 119 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	apply = gtk_dialog_run (_tmp0_) == ((gint) GTK_RESPONSE_APPLY);
#line 121 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = apply;
#line 121 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp1_) {
#line 515 "build_tool_dialog.c"
		LatexilaBuildTool* new_build_tool = NULL;
		LatexilaBuildTool* _tmp2_;
		LatexilaBuildTool* _tmp3_;
		LatexilaBuildToolsPersonal* build_tools = NULL;
		LatexilaBuildToolsPersonal* _tmp4_;
		LatexilaBuildToolsPersonal* _tmp5_;
		LatexilaBuildToolsPersonal* _tmp6_;
		LatexilaBuildTool* _tmp7_;
#line 123 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp2_ = build_tool_dialog_retrieve_build_tool (self);
#line 123 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		new_build_tool = _tmp2_;
#line 124 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp3_ = new_build_tool;
#line 124 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_object_set (_tmp3_, "enabled", TRUE, NULL);
#line 126 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp4_ = latexila_build_tools_personal_get_instance ();
#line 126 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 126 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		build_tools = _tmp5_;
#line 128 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp6_ = build_tools;
#line 128 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp7_ = new_build_tool;
#line 128 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		latexila_build_tools_personal_add (_tmp6_, _tmp7_);
#line 121 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (build_tools);
#line 121 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (new_build_tool);
#line 548 "build_tool_dialog.c"
	}
#line 131 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = self->priv->_dialog;
#line 131 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp8_);
#line 132 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = apply;
#line 132 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 558 "build_tool_dialog.c"
}


/*************************************************************************/
static void
build_tool_dialog_init_text_entries (BuildToolDialog* self,
                                     gboolean editable)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
#line 138 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
#line 140 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 140 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_label);
#line 140 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_entry_label = _tmp0_;
#line 141 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
#line 141 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp1_);
#line 141 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_desc);
#line 141 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_entry_desc = _tmp1_;
#line 142 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
#line 142 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp2_);
#line 142 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_extensions);
#line 142 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_entry_extensions = _tmp2_;
#line 143 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
#line 143 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp3_);
#line 143 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_files_to_open);
#line 143 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_entry_files_to_open = _tmp3_;
#line 145 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = self->priv->_entry_label;
#line 145 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_editable_set_editable ((GtkEditable*) _tmp4_, editable);
#line 146 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = self->priv->_entry_desc;
#line 146 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_editable_set_editable ((GtkEditable*) _tmp5_, editable);
#line 147 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = self->priv->_entry_extensions;
#line 147 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_editable_set_editable ((GtkEditable*) _tmp6_, editable);
#line 148 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = self->priv->_entry_files_to_open;
#line 148 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_editable_set_editable ((GtkEditable*) _tmp7_, editable);
#line 625 "build_tool_dialog.c"
}


static void
build_tool_dialog_init_icons_store (BuildToolDialog* self)
{
	GtkListStore* _tmp0_;
#line 151 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 153 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 153 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_icons_store);
#line 153 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_icons_store = _tmp0_;
#line 158 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "system-run", _ ("Execute"));
#line 159 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "compile_dvi", "LaTeX → DVI");
#line 160 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "compile_pdf", "LaTeX → PDF");
#line 161 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "compile_ps", "LaTeX → PS");
#line 162 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, GTK_STOCK_CONVERT, _ ("Convert"));
#line 163 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "text-x-generic", _ ("View File"));
#line 164 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "latexila-dvi", _ ("View DVI"));
#line 165 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "latexila-pdf", _ ("View PDF"));
#line 166 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_icon (self, "latexila-ps", _ ("View PS"));
#line 659 "build_tool_dialog.c"
}


static void
build_tool_dialog_add_icon (BuildToolDialog* self,
                            const gchar* icon_name,
                            const gchar* label)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
#line 169 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 169 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (icon_name != NULL);
#line 169 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (label != NULL);
#line 172 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_icons_store;
#line 172 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_append (_tmp0_, &_tmp1_);
#line 172 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp1_;
#line 173 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = self->priv->_icons_store;
#line 173 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = iter;
#line 173 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_set (_tmp2_, &_tmp3_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, icon_name, BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, label, -1);
#line 691 "build_tool_dialog.c"
}


static void
build_tool_dialog_init_icons_combobox (BuildToolDialog* self)
{
	GtkListStore* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkComboBox* _tmp7_;
#line 179 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_icons_store;
#line 181 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp0_);
#line 181 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp1_);
#line 181 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_icons_combobox);
#line 181 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_icons_combobox = _tmp1_;
#line 183 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 183 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp2_);
#line 183 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	pixbuf_renderer = _tmp2_;
#line 184 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = self->priv->_icons_combobox;
#line 184 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
#line 185 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = self->priv->_icons_combobox;
#line 185 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) pixbuf_renderer, "icon-name", BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, NULL);
#line 188 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 188 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp5_);
#line 188 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	text_renderer = _tmp5_;
#line 189 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = self->priv->_icons_combobox;
#line 189 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) text_renderer, TRUE);
#line 190 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = self->priv->_icons_combobox;
#line 190 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, NULL);
#line 179 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (text_renderer);
#line 179 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 752 "build_tool_dialog.c"
}


static void
___lambda98_ (BuildToolDialog* self,
              const gchar* path_string,
              const gchar* new_text)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
#line 248 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (path_string != NULL);
#line 248 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (new_text != NULL);
#line 251 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_jobs_store;
#line 251 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp1_, path_string);
#line 251 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp1_;
#line 252 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = self->priv->_jobs_store;
#line 252 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = iter;
#line 252 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_set (_tmp2_, &_tmp3_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, new_text, -1);
#line 782 "build_tool_dialog.c"
}


static void
____lambda98__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                             const gchar* path,
                                             const gchar* new_text,
                                             gpointer self)
{
#line 248 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	___lambda98_ ((BuildToolDialog*) self, path, new_text);
#line 794 "build_tool_dialog.c"
}


static void
__lambda99_ (BuildToolDialog* self,
             const gchar* path_string,
             const gchar* new_text)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
#line 256 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (path_string != NULL);
#line 256 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (new_text != NULL);
#line 259 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_jobs_store;
#line 259 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp1_, path_string);
#line 259 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp1_;
#line 260 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = self->priv->_jobs_store;
#line 260 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = iter;
#line 260 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_set (_tmp2_, &_tmp3_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, new_text, -1);
#line 824 "build_tool_dialog.c"
}


static void
___lambda99__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                            const gchar* path,
                                            const gchar* new_text,
                                            gpointer self)
{
#line 256 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda99_ ((BuildToolDialog*) self, path, new_text);
#line 836 "build_tool_dialog.c"
}


static void
build_tool_dialog_init_jobs (BuildToolDialog* self,
                             gboolean editable)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* post_processor_store = NULL;
	GtkListStore* _tmp3_;
	GtkListStore* _tmp14_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp17_;
	GtkTreeViewColumn* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkTreeView* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	GtkCellRendererCombo* combo_renderer = NULL;
	GtkCellRendererCombo* _tmp22_;
	GtkCellRendererCombo* _tmp23_;
	GtkCellRendererCombo* _tmp24_;
	GtkListStore* _tmp25_;
	GtkCellRendererCombo* _tmp26_;
	GtkCellRendererCombo* _tmp27_;
	GtkTreeView* _tmp28_;
	GtkCellRendererCombo* _tmp29_;
	GtkCellRendererCombo* _tmp31_;
#line 194 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 196 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_jobs_store);
#line 196 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_jobs_store = _tmp0_;
#line 201 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = self->priv->_jobs_store;
#line 201 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp1_);
#line 201 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp2_);
#line 201 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_jobs_view);
#line 201 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv->_jobs_view = _tmp2_;
#line 205 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS, G_TYPE_STRING, -1);
#line 205 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	post_processor_store = _tmp3_;
#line 891 "build_tool_dialog.c"
	{
		gint type = 0;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		type = 0;
#line 896 "build_tool_dialog.c"
		{
			gboolean _tmp4_ = FALSE;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp4_ = TRUE;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			while (TRUE) {
#line 903 "build_tool_dialog.c"
				gint _tmp6_;
				const gchar* name = NULL;
				gint _tmp7_;
				const gchar* _tmp8_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp9_;
				GtkTreeIter _tmp10_ = {0};
				GtkListStore* _tmp11_;
				GtkTreeIter _tmp12_;
				const gchar* _tmp13_;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				if (!_tmp4_) {
#line 916 "build_tool_dialog.c"
					gint _tmp5_;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
					_tmp5_ = type;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
					type = _tmp5_ + 1;
#line 922 "build_tool_dialog.c"
				}
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp4_ = FALSE;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp6_ = type;
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				if (!(_tmp6_ < ((gint) LATEXILA_POST_PROCESSOR_TYPE_NB_TYPES))) {
#line 209 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
					break;
#line 932 "build_tool_dialog.c"
				}
#line 211 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp7_ = type;
#line 211 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp8_ = latexila_post_processor_get_name_from_type ((LatexilaPostProcessorType) _tmp7_);
#line 211 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				name = _tmp8_;
#line 215 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp9_ = post_processor_store;
#line 215 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				gtk_list_store_append (_tmp9_, &_tmp10_);
#line 215 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				iter = _tmp10_;
#line 216 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp11_ = post_processor_store;
#line 216 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp12_ = iter;
#line 216 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp13_ = name;
#line 216 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				gtk_list_store_set (_tmp11_, &_tmp12_, BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, _tmp13_, -1);
#line 954 "build_tool_dialog.c"
			}
		}
	}
#line 219 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp14_ = post_processor_store;
#line 219 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp14_, (gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, GTK_SORT_ASCENDING);
#line 224 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 224 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp15_);
#line 224 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	text_renderer = _tmp15_;
#line 229 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp16_ = text_renderer;
#line 229 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp16_, "editable", TRUE, NULL);
#line 231 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp17_ = text_renderer;
#line 231 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp18_ = gtk_tree_view_column_new_with_attributes (_ ("Commands"), (GtkCellRenderer*) _tmp17_, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, NULL);
#line 231 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp18_);
#line 231 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	column = _tmp18_;
#line 233 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp19_ = column;
#line 233 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_view_column_set_resizable (_tmp19_, TRUE);
#line 234 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp20_ = self->priv->_jobs_view;
#line 234 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp21_ = column;
#line 234 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_view_append_column (_tmp20_, _tmp21_);
#line 236 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp22_ = (GtkCellRendererCombo*) gtk_cell_renderer_combo_new ();
#line 236 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp22_);
#line 236 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	combo_renderer = _tmp22_;
#line 237 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp23_ = combo_renderer;
#line 237 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set ((GtkCellRendererText*) _tmp23_, "editable", editable, NULL);
#line 238 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp24_ = combo_renderer;
#line 238 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp25_ = post_processor_store;
#line 238 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp24_, "model", (GtkTreeModel*) _tmp25_, NULL);
#line 239 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp26_ = combo_renderer;
#line 239 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp26_, "text-column", (gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, NULL);
#line 240 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp27_ = combo_renderer;
#line 240 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp27_, "has-entry", FALSE, NULL);
#line 241 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp28_ = self->priv->_jobs_view;
#line 241 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp29_ = combo_renderer;
#line 241 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp28_, -1, _ ("Post Processor"), (GtkCellRenderer*) _tmp29_, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, NULL);
#line 246 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (editable) {
#line 1022 "build_tool_dialog.c"
		GtkCellRendererText* _tmp30_;
#line 248 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp30_ = text_renderer;
#line 248 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_signal_connect_object (_tmp30_, "edited", (GCallback) ____lambda98__gtk_cell_renderer_text_edited, self, 0);
#line 1028 "build_tool_dialog.c"
	}
#line 256 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp31_ = combo_renderer;
#line 256 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_object ((GtkCellRendererText*) _tmp31_, "edited", (GCallback) ___lambda99__gtk_cell_renderer_text_edited, self, 0);
#line 194 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (combo_renderer);
#line 194 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (column);
#line 194 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (text_renderer);
#line 194 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (post_processor_store);
#line 1042 "build_tool_dialog.c"
}


/*************************************************************************/
static void
__lambda100_ (BuildToolDialog* self)
{
	LatexilaBuildJob* new_job = NULL;
	LatexilaBuildJob* _tmp0_;
#line 275 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = latexila_build_job_new ();
#line 275 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	new_job = _tmp0_;
#line 276 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (new_job, "command", "", NULL);
#line 277 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (new_job, "post-processor-type", LATEXILA_POST_PROCESSOR_TYPE_ALL_OUTPUT, NULL);
#line 278 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_add_build_job (self, new_job);
#line 273 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (new_job);
#line 1064 "build_tool_dialog.c"
}


static void
___lambda100__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 273 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda100_ ((BuildToolDialog*) self);
#line 1074 "build_tool_dialog.c"
}


static GtkToolButton*
build_tool_dialog_get_add_button (BuildToolDialog* self)
{
	GtkToolButton* result = NULL;
	GtkToolButton* add_button = NULL;
	GtkToolButton* _tmp0_;
#line 267 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 269 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 269 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 269 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	add_button = _tmp0_;
#line 270 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
#line 271 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _ ("Add…"));
#line 273 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda100__gtk_tool_button_clicked, self, 0);
#line 281 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = add_button;
#line 281 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 1102 "build_tool_dialog.c"
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return _data1_;
#line 1113 "build_tool_dialog.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1124 "build_tool_dialog.c"
		BuildToolDialog* self;
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		self = _data1_->self;
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_data1_->remove_button);
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (self);
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_slice_free (Block1Data, _data1_);
#line 1134 "build_tool_dialog.c"
	}
}


static void
__lambda101_ (Block1Data* _data1_)
{
	BuildToolDialog* self;
	gboolean row_selected = FALSE;
#line 295 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self = _data1_->self;
#line 297 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	row_selected = gtk_tree_selection_count_selected_rows (_data1_->select) > 0;
#line 298 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data1_->remove_button, row_selected);
#line 1150 "build_tool_dialog.c"
}


static void
___lambda101__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 295 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda101_ (self);
#line 1160 "build_tool_dialog.c"
}


static void
__lambda102_ (BuildToolDialog* self)
{
	GtkTreeIter iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
#line 306 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_jobs_view;
#line 306 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
#line 306 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp1_;
#line 306 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	selected_row = _tmp2_;
#line 307 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = selected_row;
#line 307 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp3_ >= 0) {
#line 1185 "build_tool_dialog.c"
		GtkListStore* _tmp4_;
#line 308 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp4_ = self->priv->_jobs_store;
#line 308 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_list_store_remove (_tmp4_, &iter);
#line 1191 "build_tool_dialog.c"
	}
}


static void
___lambda102__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 303 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda102_ ((BuildToolDialog*) self);
#line 1202 "build_tool_dialog.c"
}


static GtkToolButton*
build_tool_dialog_get_remove_button (BuildToolDialog* self)
{
	GtkToolButton* result = NULL;
	Block1Data* _data1_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data1_->_ref_count_ = 1;
#line 284 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data1_->self = g_object_ref (self);
#line 286 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 286 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 286 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data1_->remove_button = _tmp0_;
#line 287 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_button_set_icon_name (_data1_->remove_button, "list-remove-symbolic");
#line 288 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data1_->remove_button, _ ("Remove"));
#line 292 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data1_->remove_button, FALSE);
#line 294 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = self->priv->_jobs_view;
#line 294 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
#line 294 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data1_->select = _tmp2_;
#line 295 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_data (_data1_->select, "changed", (GCallback) ___lambda101__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 303 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_object (_data1_->remove_button, "clicked", (GCallback) ___lambda102__gtk_tool_button_clicked, self, 0);
#line 311 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = _g_object_ref0 (_data1_->remove_button);
#line 311 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp3_;
#line 311 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	block1_data_unref (_data1_);
#line 311 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data1_ = NULL;
#line 311 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 1255 "build_tool_dialog.c"
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return _data2_;
#line 1266 "build_tool_dialog.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1277 "build_tool_dialog.c"
		BuildToolDialog* self;
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		self = _data2_->self;
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_data2_->up_button);
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (self);
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_slice_free (Block2Data, _data2_);
#line 1287 "build_tool_dialog.c"
	}
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 332 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1297 "build_tool_dialog.c"
}


static void
__vala_GtkTreePath_free0_ (gpointer var)
{
#line 332 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
#line 1306 "build_tool_dialog.c"
}


static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
#line 332 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
#line 1315 "build_tool_dialog.c"
}


static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
#line 335 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return g_boxed_copy (gtk_tree_path_get_type (), self);
#line 1324 "build_tool_dialog.c"
}


static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
#line 335 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return self ? _vala_GtkTreePath_copy (self) : NULL;
#line 1333 "build_tool_dialog.c"
}


static void
__lambda103_ (Block2Data* _data2_)
{
	BuildToolDialog* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 325 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self = _data2_->self;
#line 327 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data2_->select, NULL);
#line 327 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	selected_rows = _tmp0_;
#line 329 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = selected_rows;
#line 329 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (g_list_length (_tmp1_) == ((guint) 0)) {
#line 331 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, FALSE);
#line 332 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 332 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		return;
#line 1370 "build_tool_dialog.c"
	}
#line 335 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = selected_rows;
#line 335 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 335 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
#line 335 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	path_selected = _tmp4_;
#line 336 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = path_selected;
#line 336 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
#line 336 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = _tmp7_[0];
#line 336 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	row_num = _tmp8_;
#line 338 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = row_num;
#line 338 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, _tmp9_ > 0);
#line 325 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__vala_GtkTreePath_free0 (path_selected);
#line 325 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 1396 "build_tool_dialog.c"
}


static void
___lambda103__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 325 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda103_ (self);
#line 1406 "build_tool_dialog.c"
}


static void
__lambda104_ (Block2Data* _data2_)
{
	BuildToolDialog* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
#line 343 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self = _data2_->self;
#line 347 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_jobs_view;
#line 347 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
#line 347 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter_selected = _tmp1_;
#line 347 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	selected_row = _tmp2_;
#line 349 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = selected_row;
#line 349 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp3_ > 0) {
#line 1434 "build_tool_dialog.c"
		GtkTreeIter iter_up = {0};
		GtkTreeIter _tmp4_;
		GtkListStore* _tmp5_;
		gboolean _tmp6_;
#line 351 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp4_ = iter_selected;
#line 351 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		iter_up = _tmp4_;
#line 352 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp5_ = self->priv->_jobs_store;
#line 352 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp6_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp5_, &iter_up);
#line 352 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		if (_tmp6_) {
#line 1449 "build_tool_dialog.c"
			GtkListStore* _tmp7_;
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_;
#line 354 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp7_ = self->priv->_jobs_store;
#line 354 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp8_ = iter_selected;
#line 354 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp9_ = iter_up;
#line 354 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
#line 357 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			g_signal_emit_by_name (_data2_->select, "changed");
#line 1463 "build_tool_dialog.c"
		}
	}
}


static void
___lambda104__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 343 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda104_ (self);
#line 1475 "build_tool_dialog.c"
}


static GtkToolButton*
build_tool_dialog_get_up_button (BuildToolDialog* self)
{
	GtkToolButton* result = NULL;
	Block2Data* _data2_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data2_->_ref_count_ = 1;
#line 314 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data2_->self = g_object_ref (self);
#line 316 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 316 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 316 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data2_->up_button = _tmp0_;
#line 317 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_button_set_icon_name (_data2_->up_button, "go-up-symbolic");
#line 318 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data2_->up_button, _ ("Move up"));
#line 322 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, FALSE);
#line 324 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = self->priv->_jobs_view;
#line 324 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
#line 324 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data2_->select = _tmp2_;
#line 325 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_data (_data2_->select, "changed", (GCallback) ___lambda103__gtk_tree_selection_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 343 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_data (_data2_->up_button, "clicked", (GCallback) ___lambda104__gtk_tool_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 362 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = _g_object_ref0 (_data2_->up_button);
#line 362 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp3_;
#line 362 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	block2_data_unref (_data2_);
#line 362 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data2_ = NULL;
#line 362 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 1528 "build_tool_dialog.c"
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return _data3_;
#line 1539 "build_tool_dialog.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1550 "build_tool_dialog.c"
		BuildToolDialog* self;
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		self = _data3_->self;
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_data3_->down_button);
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (self);
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_slice_free (Block3Data, _data3_);
#line 1560 "build_tool_dialog.c"
	}
}


static void
__lambda105_ (Block3Data* _data3_)
{
	BuildToolDialog* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gint _tmp8_;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp9_;
	GtkTreeModel* _tmp10_;
	gint nb_rows = 0;
	GtkTreeModel* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
#line 376 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self = _data3_->self;
#line 378 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data3_->select, NULL);
#line 378 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	selected_rows = _tmp0_;
#line 380 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = selected_rows;
#line 380 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (g_list_length (_tmp1_) == ((guint) 0)) {
#line 382 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, FALSE);
#line 383 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 383 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		return;
#line 1604 "build_tool_dialog.c"
	}
#line 386 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = selected_rows;
#line 386 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 386 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
#line 386 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	path_selected = _tmp4_;
#line 387 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = path_selected;
#line 387 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
#line 387 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = _tmp7_[0];
#line 387 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	row_num = _tmp8_;
#line 389 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = self->priv->_jobs_store;
#line 389 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp9_) : NULL);
#line 389 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	model = _tmp10_;
#line 390 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = model;
#line 390 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	nb_rows = gtk_tree_model_iter_n_children (_tmp11_, NULL);
#line 392 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = row_num;
#line 392 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp13_ = nb_rows;
#line 392 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, _tmp12_ < (_tmp13_ - 1));
#line 376 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (model);
#line 376 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__vala_GtkTreePath_free0 (path_selected);
#line 376 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 1644 "build_tool_dialog.c"
}


static void
___lambda105__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 376 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda105_ (self);
#line 1654 "build_tool_dialog.c"
}


static void
__lambda106_ (Block3Data* _data3_)
{
	BuildToolDialog* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
#line 397 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self = _data3_->self;
#line 401 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_jobs_view;
#line 401 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
#line 401 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter_selected = _tmp1_;
#line 401 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	selected_row = _tmp2_;
#line 403 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = selected_row;
#line 403 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp3_ >= 0) {
#line 1682 "build_tool_dialog.c"
		GtkTreeIter iter_down = {0};
		GtkTreeIter _tmp4_;
		GtkListStore* _tmp5_;
		gboolean _tmp6_;
#line 405 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp4_ = iter_selected;
#line 405 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		iter_down = _tmp4_;
#line 406 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp5_ = self->priv->_jobs_store;
#line 406 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter_down);
#line 406 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		if (_tmp6_) {
#line 1697 "build_tool_dialog.c"
			GtkListStore* _tmp7_;
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_;
#line 408 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp7_ = self->priv->_jobs_store;
#line 408 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp8_ = iter_selected;
#line 408 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp9_ = iter_down;
#line 408 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
#line 411 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			g_signal_emit_by_name (_data3_->select, "changed");
#line 1711 "build_tool_dialog.c"
		}
	}
}


static void
___lambda106__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 397 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	__lambda106_ (self);
#line 1723 "build_tool_dialog.c"
}


static GtkToolButton*
build_tool_dialog_get_down_button (BuildToolDialog* self)
{
	GtkToolButton* result = NULL;
	Block3Data* _data3_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data3_->_ref_count_ = 1;
#line 365 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data3_->self = g_object_ref (self);
#line 367 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 367 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 367 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data3_->down_button = _tmp0_;
#line 368 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_button_set_icon_name (_data3_->down_button, "go-down-symbolic");
#line 369 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data3_->down_button, _ ("Move down"));
#line 373 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, FALSE);
#line 375 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = self->priv->_jobs_view;
#line 375 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
#line 375 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data3_->select = _tmp2_;
#line 376 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_data (_data3_->select, "changed", (GCallback) ___lambda105__gtk_tree_selection_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 397 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_connect_data (_data3_->down_button, "clicked", (GCallback) ___lambda106__gtk_tool_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 416 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = _g_object_ref0 (_data3_->down_button);
#line 416 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp3_;
#line 416 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	block3_data_unref (_data3_);
#line 416 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_data3_ = NULL;
#line 416 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 1776 "build_tool_dialog.c"
}


/*************************************************************************/
static void
build_tool_dialog_set_new_build_tool (BuildToolDialog* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkListStore* _tmp5_;
	GtkTreeView* _tmp6_;
#line 422 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 424 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_entry_label;
#line 424 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp0_, "");
#line 425 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = self->priv->_entry_desc;
#line 425 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp1_, "");
#line 426 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = self->priv->_entry_extensions;
#line 426 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp2_, "");
#line 427 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = self->priv->_entry_files_to_open;
#line 427 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp3_, "");
#line 429 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = self->priv->_icons_combobox;
#line 429 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_combo_box_set_active (_tmp4_, 0);
#line 431 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = self->priv->_jobs_store;
#line 431 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_clear (_tmp5_);
#line 432 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = self->priv->_jobs_view;
#line 432 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_view_columns_autosize (_tmp6_);
#line 1821 "build_tool_dialog.c"
}


static void
build_tool_dialog_set_build_tool (BuildToolDialog* self,
                                  LatexilaBuildTool* build_tool)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	GtkEntry* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkEntry* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkEntry* _tmp17_;
	GtkComboBox* _tmp18_;
	GtkTreeIter iter = {0};
	gboolean ok = FALSE;
	GtkListStore* _tmp19_;
	GtkTreeIter _tmp20_ = {0};
	gboolean _tmp21_;
	gboolean _tmp22_;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp23_;
	GtkTreeModel* _tmp24_;
	GtkListStore* _tmp37_;
	GList* _tmp38_;
	GtkTreeView* _tmp41_;
#line 435 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 435 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (build_tool != NULL);
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_get (build_tool, "label", &_tmp1_, NULL);
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = _tmp1_;
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = _tmp2_;
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp0_ == NULL) {
#line 1869 "build_tool_dialog.c"
		gchar* _tmp3_;
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp3_ = g_strdup ("");
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_free0 (_tmp0_);
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp0_ = _tmp3_;
#line 1877 "build_tool_dialog.c"
	}
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = self->priv->_entry_label;
#line 439 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp4_, _tmp0_);
#line 440 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = latexila_build_tool_get_description (build_tool);
#line 440 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = _tmp6_;
#line 440 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp5_ == NULL) {
#line 440 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp5_ = "";
#line 1891 "build_tool_dialog.c"
	}
#line 440 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = self->priv->_entry_desc;
#line 440 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp7_, _tmp5_);
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_get (build_tool, "extensions", &_tmp9_, NULL);
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = _tmp9_;
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = _tmp10_;
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp8_ == NULL) {
#line 1905 "build_tool_dialog.c"
		gchar* _tmp11_;
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp11_ = g_strdup ("");
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_free0 (_tmp8_);
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp8_ = _tmp11_;
#line 1913 "build_tool_dialog.c"
	}
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = self->priv->_entry_extensions;
#line 441 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp12_, _tmp8_);
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_get (build_tool, "files-to-open", &_tmp14_, NULL);
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp15_ = _tmp14_;
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp13_ = _tmp15_;
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (_tmp13_ == NULL) {
#line 1927 "build_tool_dialog.c"
		gchar* _tmp16_;
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp16_ = g_strdup ("");
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_free0 (_tmp13_);
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp13_ = _tmp16_;
#line 1935 "build_tool_dialog.c"
	}
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp17_ = self->priv->_entry_files_to_open;
#line 442 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_entry_set_text (_tmp17_, _tmp13_);
#line 446 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp18_ = self->priv->_icons_combobox;
#line 446 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_combo_box_set_active (_tmp18_, 0);
#line 449 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp19_ = self->priv->_icons_store;
#line 449 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp21_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp19_, &_tmp20_);
#line 449 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp20_;
#line 449 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	ok = _tmp21_;
#line 450 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp22_ = ok;
#line 450 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (_tmp22_);
#line 452 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp23_ = self->priv->_icons_store;
#line 452 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp23_) : NULL);
#line 452 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	model = _tmp24_;
#line 1963 "build_tool_dialog.c"
	{
		gboolean _tmp25_ = FALSE;
#line 454 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp25_ = TRUE;
#line 454 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		while (TRUE) {
#line 1970 "build_tool_dialog.c"
			gchar* icon_name = NULL;
			GtkTreeModel* _tmp28_;
			GtkTreeIter _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
#line 454 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			if (!_tmp25_) {
#line 1981 "build_tool_dialog.c"
				GtkListStore* _tmp26_;
				gboolean _tmp27_;
#line 465 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp26_ = self->priv->_icons_store;
#line 465 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp27_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp26_, &iter);
#line 465 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				if (!_tmp27_) {
#line 465 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
					break;
#line 1992 "build_tool_dialog.c"
				}
			}
#line 454 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp25_ = FALSE;
#line 457 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp28_ = model;
#line 457 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp29_ = iter;
#line 457 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			gtk_tree_model_get (_tmp28_, &_tmp29_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, &icon_name, -1);
#line 459 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp30_ = icon_name;
#line 459 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			g_object_get (build_tool, "icon", &_tmp31_, NULL);
#line 459 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp32_ = _tmp31_;
#line 459 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp33_ = _tmp32_;
#line 459 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp34_ = g_strcmp0 (_tmp30_, _tmp33_) == 0;
#line 459 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_g_free0 (_tmp33_);
#line 459 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			if (_tmp34_) {
#line 2017 "build_tool_dialog.c"
				GtkComboBox* _tmp35_;
				GtkTreeIter _tmp36_;
#line 461 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp35_ = self->priv->_icons_combobox;
#line 461 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp36_ = iter;
#line 461 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				gtk_combo_box_set_active_iter (_tmp35_, &_tmp36_);
#line 462 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_g_free0 (icon_name);
#line 462 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				break;
#line 2030 "build_tool_dialog.c"
			}
#line 454 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_g_free0 (icon_name);
#line 2034 "build_tool_dialog.c"
		}
	}
#line 469 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp37_ = self->priv->_jobs_store;
#line 469 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_clear (_tmp37_);
#line 470 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp38_ = latexila_build_tool_get_jobs (build_tool);
#line 2043 "build_tool_dialog.c"
	{
		GList* build_job_collection = NULL;
		GList* build_job_it = NULL;
#line 470 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		build_job_collection = _tmp38_;
#line 470 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		for (build_job_it = build_job_collection; build_job_it != NULL; build_job_it = build_job_it->next) {
#line 2051 "build_tool_dialog.c"
			LatexilaBuildJob* _tmp39_;
			LatexilaBuildJob* build_job = NULL;
#line 470 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp39_ = _g_object_ref0 ((LatexilaBuildJob*) build_job_it->data);
#line 470 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			build_job = _tmp39_;
#line 2058 "build_tool_dialog.c"
			{
				LatexilaBuildJob* _tmp40_;
#line 471 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_tmp40_ = build_job;
#line 471 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				build_tool_dialog_add_build_job (self, _tmp40_);
#line 470 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
				_g_object_unref0 (build_job);
#line 2067 "build_tool_dialog.c"
			}
		}
	}
#line 473 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp41_ = self->priv->_jobs_view;
#line 473 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_view_columns_autosize (_tmp41_);
#line 435 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (model);
#line 435 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp13_);
#line 435 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp8_);
#line 435 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp0_);
#line 2083 "build_tool_dialog.c"
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1251 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 2108 "build_tool_dialog.c"
}


static LatexilaBuildTool*
build_tool_dialog_retrieve_build_tool (BuildToolDialog* self)
{
	LatexilaBuildTool* result = NULL;
	LatexilaBuildTool* tool = NULL;
	LatexilaBuildTool* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	GtkEntry* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	LatexilaBuildTool* _tmp13_;
	GtkEntry* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	LatexilaBuildTool* _tmp19_;
	GtkEntry* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp25_;
	GtkTreeIter _tmp26_ = {0};
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp27_;
	GtkTreeModel* _tmp28_;
	gchar* icon_name = NULL;
	GtkTreeModel* _tmp29_;
	GtkTreeIter _tmp30_;
	LatexilaBuildTool* _tmp31_;
	const gchar* _tmp32_;
	GtkListStore* _tmp33_;
	GtkTreeModel* _tmp34_;
	gboolean valid = FALSE;
	GtkListStore* _tmp35_;
	GtkTreeIter _tmp36_ = {0};
	gboolean _tmp37_;
#line 477 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 479 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = latexila_build_tool_new ();
#line 479 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	tool = _tmp0_;
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = tool;
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = self->priv->_entry_label;
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = gtk_entry_get_text (_tmp2_);
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = _tmp3_;
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = string_strip (_tmp4_);
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = _tmp5_;
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp1_, "label", _tmp6_, NULL);
#line 483 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp6_);
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = tool;
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = self->priv->_entry_desc;
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = gtk_entry_get_text (_tmp8_);
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = _tmp9_;
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = string_strip (_tmp10_);
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = _tmp11_;
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp7_, "description", _tmp12_, NULL);
#line 484 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp12_);
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp13_ = tool;
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp14_ = self->priv->_entry_extensions;
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp15_ = gtk_entry_get_text (_tmp14_);
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp16_ = _tmp15_;
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp17_ = string_strip (_tmp16_);
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp18_ = _tmp17_;
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp13_, "extensions", _tmp18_, NULL);
#line 485 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp18_);
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp19_ = tool;
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp20_ = self->priv->_entry_files_to_open;
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp21_ = gtk_entry_get_text (_tmp20_);
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp22_ = _tmp21_;
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp23_ = string_strip (_tmp22_);
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp24_ = _tmp23_;
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp19_, "files-to-open", _tmp24_, NULL);
#line 486 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp24_);
#line 491 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp25_ = self->priv->_icons_combobox;
#line 491 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_combo_box_get_active_iter (_tmp25_, &_tmp26_);
#line 491 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp26_;
#line 492 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp27_ = self->priv->_icons_store;
#line 492 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp27_) : NULL);
#line 492 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	model = _tmp28_;
#line 494 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp29_ = model;
#line 494 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp30_ = iter;
#line 494 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_tree_model_get (_tmp29_, &_tmp30_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, &icon_name, -1);
#line 495 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp31_ = tool;
#line 495 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp32_ = icon_name;
#line 495 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set (_tmp31_, "icon", _tmp32_, NULL);
#line 499 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp33_ = self->priv->_jobs_store;
#line 499 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp33_) : NULL);
#line 499 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (model);
#line 499 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	model = _tmp34_;
#line 500 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp35_ = self->priv->_jobs_store;
#line 500 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp37_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp35_, &_tmp36_);
#line 500 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp36_;
#line 500 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	valid = _tmp37_;
#line 502 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	while (TRUE) {
#line 2271 "build_tool_dialog.c"
		gboolean _tmp38_;
		LatexilaBuildJob* job = NULL;
		LatexilaBuildJob* _tmp39_;
		gchar* command = NULL;
		gchar* post_processor_name = NULL;
		GtkTreeModel* _tmp40_;
		GtkTreeIter _tmp41_;
		LatexilaBuildJob* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		LatexilaPostProcessorType type = 0;
		const gchar* _tmp46_;
		LatexilaPostProcessorType _tmp47_ = 0;
		gboolean _tmp48_;
		LatexilaBuildTool* _tmp51_;
		LatexilaBuildJob* _tmp52_;
		GtkListStore* _tmp53_;
		gboolean _tmp54_;
#line 502 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp38_ = valid;
#line 502 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		if (!_tmp38_) {
#line 502 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			break;
#line 2297 "build_tool_dialog.c"
		}
#line 504 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp39_ = latexila_build_job_new ();
#line 504 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		job = _tmp39_;
#line 508 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp40_ = model;
#line 508 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp41_ = iter;
#line 508 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_tree_model_get (_tmp40_, &_tmp41_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, &command, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, &post_processor_name, -1);
#line 513 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp42_ = job;
#line 513 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp43_ = command;
#line 513 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp44_ = string_strip (_tmp43_);
#line 513 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp45_ = _tmp44_;
#line 513 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_object_set (_tmp42_, "command", _tmp45_, NULL);
#line 513 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_free0 (_tmp45_);
#line 516 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp46_ = post_processor_name;
#line 516 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp48_ = latexila_post_processor_get_type_from_name (_tmp46_, &_tmp47_);
#line 516 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		type = _tmp47_;
#line 516 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		if (_tmp48_) {
#line 2329 "build_tool_dialog.c"
			LatexilaBuildJob* _tmp49_;
			LatexilaPostProcessorType _tmp50_;
#line 517 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp49_ = job;
#line 517 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			_tmp50_ = type;
#line 517 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
			g_object_set (_tmp49_, "post-processor-type", _tmp50_, NULL);
#line 2338 "build_tool_dialog.c"
		}
#line 519 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp51_ = tool;
#line 519 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp52_ = job;
#line 519 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		latexila_build_tool_add_job (_tmp51_, _tmp52_);
#line 521 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp53_ = self->priv->_jobs_store;
#line 521 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp54_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp53_, &iter);
#line 521 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		valid = _tmp54_;
#line 502 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_free0 (post_processor_name);
#line 502 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_free0 (command);
#line 502 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (job);
#line 2358 "build_tool_dialog.c"
	}
#line 524 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = tool;
#line 524 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (icon_name);
#line 524 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (model);
#line 524 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 2368 "build_tool_dialog.c"
}


/*************************************************************************/
static void
build_tool_dialog_add_build_job (BuildToolDialog* self,
                                 LatexilaBuildJob* job)
{
	gchar* post_processor_name = NULL;
	LatexilaPostProcessorType _tmp0_;
	LatexilaPostProcessorType _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkTreeSelection* select = NULL;
	GtkTreeView* _tmp11_;
	GtkTreeSelection* _tmp12_;
#line 530 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (self != NULL);
#line 530 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_if_fail (job != NULL);
#line 532 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_get (job, "post-processor-type", &_tmp0_, NULL);
#line 532 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = _tmp0_;
#line 532 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = latexila_post_processor_get_name_from_type (_tmp1_);
#line 532 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 532 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	post_processor_name = _tmp3_;
#line 536 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = self->priv->_jobs_store;
#line 536 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_append (_tmp4_, &_tmp5_);
#line 536 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	iter = _tmp5_;
#line 537 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = self->priv->_jobs_store;
#line 537 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = iter;
#line 537 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_get (job, "command", &_tmp8_, NULL);
#line 537 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = _tmp8_;
#line 537 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = _tmp9_;
#line 537 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_list_store_set (_tmp6_, &_tmp7_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp10_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, post_processor_name, -1);
#line 537 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp10_);
#line 543 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = self->priv->_jobs_view;
#line 543 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
#line 543 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	select = _tmp12_;
#line 544 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_signal_emit_by_name (select, "changed");
#line 530 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (post_processor_name);
#line 2437 "build_tool_dialog.c"
}


/*************************************************************************/
static GtkGrid*
build_tool_dialog_get_main_grid (BuildToolDialog* self,
                                 gboolean editable)
{
	GtkGrid* result = NULL;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
#line 550 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 552 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 552 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 552 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	main_grid = _tmp0_;
#line 553 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_set_row_spacing (main_grid, (guint) 5);
#line 554 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_set_column_spacing (main_grid, (guint) 5);
#line 556 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = build_tool_dialog_get_label_grid (self);
#line 556 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = _tmp1_;
#line 556 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp2_, 0, 0, 1, 1);
#line 556 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (_tmp2_);
#line 557 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = build_tool_dialog_get_desc_grid (self);
#line 557 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = _tmp3_;
#line 557 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (main_grid, _tmp4_, 1, 0, 1, 1);
#line 557 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (_tmp4_);
#line 558 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = build_tool_dialog_get_extensions_grid (self);
#line 558 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = _tmp5_;
#line 558 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (main_grid, _tmp6_, 0, 1, 1, 1);
#line 558 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (_tmp6_);
#line 559 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = build_tool_dialog_get_icons_grid (self);
#line 559 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = _tmp7_;
#line 559 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (main_grid, _tmp8_, 1, 1, 1, 1);
#line 559 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (_tmp8_);
#line 560 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = build_tool_dialog_get_jobs_grid (self, editable);
#line 560 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = _tmp9_;
#line 560 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (main_grid, _tmp10_, 0, 2, 2, 1);
#line 560 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (_tmp10_);
#line 561 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = build_tool_dialog_get_files_to_open_grid (self);
#line 561 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = _tmp11_;
#line 561 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (main_grid, _tmp12_, 0, 3, 2, 1);
#line 561 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (_tmp12_);
#line 563 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = main_grid;
#line 563 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 2525 "build_tool_dialog.c"
}


static GtkGrid*
build_tool_dialog_get_label_grid (BuildToolDialog* self)
{
	GtkGrid* result = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* title = NULL;
	GtkLabel* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* arrow = NULL;
	GtkLabel* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
#line 566 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 568 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 568 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 568 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	grid = _tmp0_;
#line 569 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_set_row_spacing (grid, (guint) 6);
#line 570 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 6);
#line 572 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
#line 572 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp1_);
#line 572 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	title = _tmp1_;
#line 573 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = g_strconcat ("<b>", _ ("Label"), NULL);
#line 573 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = _tmp2_;
#line 573 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = g_strconcat (_tmp3_, "</b>", NULL);
#line 573 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = _tmp4_;
#line 573 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_label_set_markup (title, _tmp5_);
#line 573 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp5_);
#line 573 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp3_);
#line 574 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_halign ((GtkWidget*) title, GTK_ALIGN_START);
#line 575 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (grid, (GtkWidget*) title, 0, 0, 1, 1);
#line 577 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = (GtkLabel*) gtk_label_new ("→");
#line 577 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp6_);
#line 577 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	arrow = _tmp6_;
#line 578 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) arrow, _ ("You can select this arrow and copy/paste it!"));
#line 579 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_halign ((GtkWidget*) arrow, GTK_ALIGN_CENTER);
#line 580 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) arrow, TRUE);
#line 581 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_label_set_selectable (arrow, TRUE);
#line 582 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (grid, (GtkWidget*) arrow, 1, 0, 1, 1);
#line 583 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) grid, FALSE);
#line 585 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = self->priv->_entry_label;
#line 585 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 12);
#line 586 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = self->priv->_entry_label;
#line 586 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_attach (grid, (GtkWidget*) _tmp8_, 0, 1, 2, 1);
#line 588 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = grid;
#line 588 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (arrow);
#line 588 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (title);
#line 588 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 2615 "build_tool_dialog.c"
}


static GtkWidget*
build_tool_dialog_get_desc_grid (BuildToolDialog* self)
{
	GtkWidget* result = NULL;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
#line 591 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 593 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_entry_desc;
#line 593 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
#line 594 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = self->priv->_entry_desc;
#line 594 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = latexila_utils_get_dialog_component (_ ("Description"), (GtkWidget*) _tmp1_);
#line 594 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 594 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp3_;
#line 594 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 2643 "build_tool_dialog.c"
}


static GtkWidget*
build_tool_dialog_get_extensions_grid (BuildToolDialog* self)
{
	GtkWidget* result = NULL;
	GtkEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkEntry* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
#line 597 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_entry_extensions;
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = g_strconcat (_ ("File extensions for which the build tool can be executed."), "\n", NULL);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = _tmp1_;
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = g_strconcat (_tmp2_, _ ("The extensions are separated by spaces."), NULL);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = _tmp3_;
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = _tmp5_;
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = g_strconcat (_tmp6_, _ ("If it is empty, all extensions are allowed."), NULL);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = _tmp7_;
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp8_);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp8_);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp6_);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp4_);
#line 599 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp2_);
#line 604 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = self->priv->_entry_extensions;
#line 604 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = latexila_utils_get_dialog_component (_ ("Extensions"), (GtkWidget*) _tmp9_);
#line 604 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 604 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp11_;
#line 604 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 2703 "build_tool_dialog.c"
}


static GtkWidget*
build_tool_dialog_get_icons_grid (BuildToolDialog* self)
{
	GtkWidget* result = NULL;
	GtkComboBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
#line 607 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 609 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_icons_combobox;
#line 609 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = latexila_utils_get_dialog_component (_ ("Icon"), (GtkWidget*) _tmp0_);
#line 609 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 609 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp2_;
#line 609 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 2726 "build_tool_dialog.c"
}


static GtkWidget*
build_tool_dialog_get_jobs_grid (BuildToolDialog* self,
                                 gboolean editable)
{
	GtkWidget* result = NULL;
	GtkLabel* placeholders = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* placeholder_filename = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* placeholder_shortname = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkGrid* placeholders_grid = NULL;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	GtkGrid* _tmp16_;
	GtkLabel* _tmp17_;
	GtkGrid* _tmp18_;
	GtkLabel* _tmp19_;
	GtkGrid* _tmp20_;
	GtkLabel* _tmp21_;
	GtkTreeView* _tmp22_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkTreeView* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkBox* jobs_box = NULL;
	GtkBox* _tmp27_;
	GtkGrid* _tmp28_;
	GtkBox* _tmp29_;
	GtkGrid* _tmp30_;
	GtkBox* _tmp31_;
	GtkScrolledWindow* _tmp32_;
	GtkBox* _tmp59_;
	GtkWidget* _tmp60_;
	GtkWidget* _tmp61_;
#line 612 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 616 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Placeholders:"));
#line 616 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 616 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	placeholders = _tmp0_;
#line 618 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new ("$filename");
#line 618 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp1_);
#line 618 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	placeholder_filename = _tmp1_;
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = placeholder_filename;
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = g_strconcat (_ ("The active document’s filename."), "\n", NULL);
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = _tmp3_;
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = g_strconcat (_tmp4_, _ ("If the active document belongs to a project, the main file is chosen."), NULL);
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = _tmp5_;
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp6_);
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp6_);
#line 619 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp4_);
#line 623 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = (GtkLabel*) gtk_label_new ("$shortname");
#line 623 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp7_);
#line 623 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	placeholder_shortname = _tmp7_;
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = placeholder_shortname;
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = g_strconcat (_ ("The active document’s filename without its extension."), "\n", NULL);
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = _tmp9_;
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = g_strconcat (_tmp10_, _ ("If the active document belongs to a project, the main file is chosen."), NULL);
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = _tmp11_;
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _tmp12_);
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp12_);
#line 624 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp10_);
#line 628 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
#line 628 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp13_);
#line 628 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	placeholders_grid = _tmp13_;
#line 629 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp14_ = placeholders_grid;
#line 629 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp14_, GTK_ORIENTATION_HORIZONTAL);
#line 630 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp15_ = placeholders_grid;
#line 630 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_grid_set_column_spacing (_tmp15_, (guint) 10);
#line 631 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp16_ = placeholders_grid;
#line 631 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp17_ = placeholders;
#line 631 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
#line 632 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp18_ = placeholders_grid;
#line 632 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp19_ = placeholder_filename;
#line 632 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
#line 633 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp20_ = placeholders_grid;
#line 633 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp21_ = placeholder_shortname;
#line 633 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
#line 637 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp22_ = self->priv->_jobs_view;
#line 637 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_set ((GtkWidget*) _tmp22_, "expand", TRUE, NULL);
#line 639 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp23_ = self->priv->_jobs_view;
#line 639 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp24_ = utils_add_scrollbar ((GtkWidget*) _tmp23_);
#line 639 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	scrolled_window = _tmp24_;
#line 640 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp25_ = scrolled_window;
#line 640 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp25_, 600, 120);
#line 641 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp26_ = scrolled_window;
#line 641 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_scrolled_window_set_shadow_type (_tmp26_, GTK_SHADOW_IN);
#line 645 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 645 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_object_ref_sink (_tmp27_);
#line 645 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	jobs_box = _tmp27_;
#line 646 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp28_ = placeholders_grid;
#line 646 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp28_, 8);
#line 647 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp29_ = jobs_box;
#line 647 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp30_ = placeholders_grid;
#line 647 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, FALSE, TRUE, (guint) 0);
#line 648 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp31_ = jobs_box;
#line 648 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp32_ = scrolled_window;
#line 648 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, TRUE, TRUE, (guint) 0);
#line 650 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	if (editable) {
#line 2903 "build_tool_dialog.c"
		GtkToolbar* toolbar = NULL;
		GtkToolbar* _tmp33_;
		GtkToolbar* _tmp34_;
		GtkToolButton* _tmp35_;
		GtkToolButton* _tmp36_;
		GtkToolbar* _tmp37_;
		GtkToolButton* _tmp38_;
		GtkToolButton* _tmp39_;
		GtkToolbar* _tmp40_;
		GtkToolButton* _tmp41_;
		GtkToolButton* _tmp42_;
		GtkToolbar* _tmp43_;
		GtkToolButton* _tmp44_;
		GtkToolButton* _tmp45_;
		GtkToolbar* _tmp46_;
		GtkToolbar* _tmp47_;
		GtkBox* _tmp48_;
		GtkToolbar* _tmp49_;
		GtkStyleContext* context = NULL;
		GtkScrolledWindow* _tmp50_;
		GtkStyleContext* _tmp51_;
		GtkStyleContext* _tmp52_;
		GtkStyleContext* _tmp53_;
		GtkToolbar* _tmp54_;
		GtkStyleContext* _tmp55_;
		GtkStyleContext* _tmp56_;
		GtkStyleContext* _tmp57_;
		GtkStyleContext* _tmp58_;
#line 654 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp33_ = (GtkToolbar*) gtk_toolbar_new ();
#line 654 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		g_object_ref_sink (_tmp33_);
#line 654 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		toolbar = _tmp33_;
#line 655 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp34_ = toolbar;
#line 655 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp35_ = build_tool_dialog_get_add_button (self);
#line 655 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp36_ = _tmp35_;
#line 655 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_toolbar_insert (_tmp34_, (GtkToolItem*) _tmp36_, -1);
#line 655 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_tmp36_);
#line 656 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp37_ = toolbar;
#line 656 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp38_ = build_tool_dialog_get_remove_button (self);
#line 656 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp39_ = _tmp38_;
#line 656 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_toolbar_insert (_tmp37_, (GtkToolItem*) _tmp39_, -1);
#line 656 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_tmp39_);
#line 657 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp40_ = toolbar;
#line 657 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp41_ = build_tool_dialog_get_up_button (self);
#line 657 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp42_ = _tmp41_;
#line 657 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_toolbar_insert (_tmp40_, (GtkToolItem*) _tmp42_, -1);
#line 657 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_tmp42_);
#line 658 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp43_ = toolbar;
#line 658 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp44_ = build_tool_dialog_get_down_button (self);
#line 658 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp45_ = _tmp44_;
#line 658 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_toolbar_insert (_tmp43_, (GtkToolItem*) _tmp45_, -1);
#line 658 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (_tmp45_);
#line 660 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp46_ = toolbar;
#line 660 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_toolbar_set_icon_size (_tmp46_, GTK_ICON_SIZE_MENU);
#line 661 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp47_ = toolbar;
#line 661 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_toolbar_set_style (_tmp47_, GTK_TOOLBAR_ICONS);
#line 663 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp48_ = jobs_box;
#line 663 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp49_ = toolbar;
#line 663 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, FALSE, TRUE, (guint) 0);
#line 667 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp50_ = scrolled_window;
#line 667 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp51_ = gtk_widget_get_style_context ((GtkWidget*) _tmp50_);
#line 667 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp52_ = _g_object_ref0 (_tmp51_);
#line 667 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		context = _tmp52_;
#line 668 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp53_ = context;
#line 668 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_style_context_set_junction_sides (_tmp53_, GTK_JUNCTION_BOTTOM);
#line 670 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp54_ = toolbar;
#line 670 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp55_ = gtk_widget_get_style_context ((GtkWidget*) _tmp54_);
#line 670 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp56_ = _g_object_ref0 (_tmp55_);
#line 670 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (context);
#line 670 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		context = _tmp56_;
#line 671 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp57_ = context;
#line 671 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_style_context_add_class (_tmp57_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
#line 672 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_tmp58_ = context;
#line 672 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		gtk_style_context_set_junction_sides (_tmp58_, GTK_JUNCTION_TOP);
#line 650 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (context);
#line 650 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
		_g_object_unref0 (toolbar);
#line 3026 "build_tool_dialog.c"
	}
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp59_ = jobs_box;
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp60_ = latexila_utils_get_dialog_component (_ ("Jobs"), (GtkWidget*) _tmp59_);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp61_ = _g_object_ref0 (_tmp60_);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp61_;
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (jobs_box);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (scrolled_window);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (placeholders_grid);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (placeholder_shortname);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (placeholder_filename);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (placeholders);
#line 675 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 3050 "build_tool_dialog.c"
}


static GtkWidget*
build_tool_dialog_get_files_to_open_grid (BuildToolDialog* self)
{
	GtkWidget* result = NULL;
	GtkEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
#line 678 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp0_ = self->priv->_entry_files_to_open;
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp1_ = g_strconcat (_ ("List of files to open after executing the build jobs."), "\n", NULL);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp2_ = _tmp1_;
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp3_ = g_strconcat (_tmp2_, _ ("The files are separated by spaces."), NULL);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp4_ = _tmp3_;
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp6_ = _tmp5_;
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp7_ = g_strconcat (_tmp6_, _ ("You should use the placeholders to specify the files."), NULL);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp8_ = _tmp7_;
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp8_);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp8_);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp6_);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp4_);
#line 680 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_free0 (_tmp2_);
#line 685 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp9_ = self->priv->_entry_files_to_open;
#line 685 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
#line 686 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp10_ = self->priv->_entry_files_to_open;
#line 686 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp11_ = latexila_utils_get_dialog_component (_ ("Files to open"), (GtkWidget*) _tmp10_);
#line 686 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 686 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	result = _tmp12_;
#line 686 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	return result;
#line 3115 "build_tool_dialog.c"
}


static void
build_tool_dialog_class_init (BuildToolDialogClass * klass)
{
#line 26 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	build_tool_dialog_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	g_type_class_add_private (klass, sizeof (BuildToolDialogPrivate));
#line 26 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = build_tool_dialog_finalize;
#line 3128 "build_tool_dialog.c"
}


static void
build_tool_dialog_instance_init (BuildToolDialog * self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self->priv = BUILD_TOOL_DIALOG_GET_PRIVATE (self);
#line 3137 "build_tool_dialog.c"
}


static void
build_tool_dialog_finalize (GObject * obj)
{
	BuildToolDialog * self;
#line 26 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOL_DIALOG, BuildToolDialog);
#line 48 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_dialog);
#line 50 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_label);
#line 51 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_desc);
#line 52 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_extensions);
#line 53 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_entry_files_to_open);
#line 55 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_icons_store);
#line 56 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_icons_combobox);
#line 58 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_jobs_store);
#line 59 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	_g_object_unref0 (self->priv->_jobs_view);
#line 61 "/home/seb/gnome/gnome-latex/src/build_tool_dialog.vala"
	G_OBJECT_CLASS (build_tool_dialog_parent_class)->finalize (obj);
#line 3167 "build_tool_dialog.c"
}


GType
build_tool_dialog_get_type (void)
{
	static volatile gsize build_tool_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolDialog), 0, (GInstanceInitFunc) build_tool_dialog_instance_init, NULL };
		GType build_tool_dialog_type_id;
		build_tool_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolDialog", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_dialog_type_id__volatile, build_tool_dialog_type_id);
	}
	return build_tool_dialog_type_id__volatile;
}



