/* structure_model.c generated by valac 0.40.0.227-717ea, the Vala compiler
 * generated from structure_model.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>


#define TYPE_STRUCT_DATA (struct_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _StructData StructData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
typedef struct _StructureModelPrivate StructureModelPrivate;
enum  {
	STRUCTURE_MODEL_0_PROPERTY,
	STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY,
	STRUCTURE_MODEL_NUM_PROPERTIES
};
static GParamSpec* structure_model_properties[STRUCTURE_MODEL_NUM_PROPERTIES];
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
struct _StructureModel {
	GObject parent_instance;
	StructureModelPrivate * priv;
};

struct _StructureModelClass {
	GObjectClass parent_class;
};

struct _StructureModelPrivate {
	gboolean _emit_signals;
	GType* _column_types;
	gint _column_types_length1;
	gint __column_types_size_;
	GNode* _tree;
	gint _stamp;
	guint _nb_nodes;
	GNode* _end_node;
	GeeArrayList* _list_labels;
	GeeArrayList* _list_includes;
	GeeArrayList* _list_tables;
	GeeArrayList* _list_figures;
	GeeArrayList* _list_todos_and_fixmes;
};


static gint StructureModel_private_offset;
static gpointer structure_model_parent_class = NULL;
static GtkTreeModelIface * structure_model_gtk_tree_model_parent_iface = NULL;

GType struct_data_get_type (void) G_GNUC_CONST;
GType struct_type_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self,
                       StructData* dest);
void struct_data_destroy (StructData* self);
GType struct_column_get_type (void) G_GNUC_CONST;
GType struct_list_column_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
GType structure_model_get_type (void) G_GNUC_CONST;
static void _struct_data_free0_ (gpointer var);
static gboolean _g_node_free_all_node (GNode* node,
                                GDestroyNotify free_func);
static void _g_node_free_all (GNode* self,
                       GDestroyNotify free_func);
static inline void _g_node_destroy__struct_data_free0_ (GNode* self);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void structure_model_new_stamp (StructureModel* self);
static void structure_model_reset_simple_lists (StructureModel* self);
static GtkTreeIter* structure_model_create_iter_at_node (StructureModel* self,
                                                  GNode* node);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean structure_model_iter_is_valid (StructureModel* self,
                                        GtkTreeIter* iter);
static GNode* structure_model_get_node_from_iter (StructureModel* self,
                                           GtkTreeIter* iter);
static gboolean structure_model_column_is_valid (StructureModel* self,
                                          gint index);
static GType structure_model_real_get_column_type (GtkTreeModel* base,
                                            gint index);
static gint structure_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreeModelFlags structure_model_real_get_flags (GtkTreeModel* base);
static gboolean structure_model_real_iter_has_child (GtkTreeModel* base,
                                              GtkTreeIter* iter);
static gint structure_model_real_iter_n_children (GtkTreeModel* base,
                                           GtkTreeIter* iter);
static void structure_model_real_get_value (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     gint column,
                                     GValue* val);
gchar* structure_get_icon_from_type (StructType type);
gchar* structure_get_type_name (StructType type);
static gboolean structure_model_real_iter_children (GtkTreeModel* base,
                                             GtkTreeIter* iter,
                                             GtkTreeIter* parent);
static gboolean structure_model_real_iter_next (GtkTreeModel* base,
                                         GtkTreeIter* iter);
static gboolean structure_model_real_iter_nth_child (GtkTreeModel* base,
                                              GtkTreeIter* iter,
                                              GtkTreeIter* parent,
                                              gint n);
static gboolean structure_model_real_iter_parent (GtkTreeModel* base,
                                           GtkTreeIter* iter,
                                           GtkTreeIter* child);
static gboolean structure_model_real_get_iter (GtkTreeModel* base,
                                        GtkTreeIter* iter,
                                        GtkTreePath* path);
static GtkTreePath* structure_model_real_get_path (GtkTreeModel* base,
                                            GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
guint structure_model_get_nb_items (StructureModel* self);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self,
                                              StructData* item);
static void structure_model_search_end_node (StructureModel* self);
gboolean structure_is_section (StructType type);
static GtkTreeIter* structure_model_insert_item_after (StructureModel* self,
                                                GNode* parent,
                                                GNode* sibling,
                                                StructData* item);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self,
                                                         GtkTreeIter* section_iter,
                                                         GError** error);
void structure_model_delete (StructureModel* self,
                             GtkTreeIter* iter);
static GNode* structure_model_delete_node (StructureModel* self,
                                    GNode* node);
static void structure_model_regenerate_simple_lists (StructureModel* self);
void structure_model_modify_data (StructureModel* self,
                                  GtkTreePath* path,
                                  const gchar* text,
                                  GtkTextMark* end_mark);
gboolean structure_model_get_emit_signals (StructureModel* self);
static void structure_model_make_children_between_marks (StructureModel* self,
                                                  GNode* node);
void structure_model_shift_right (StructureModel* self,
                                  GtkTreeIter* iter);
static void structure_model_shift_node (StructureModel* self,
                                 GNode* node,
                                 gboolean shift_right);
static void structure_model_reinsert_node (StructureModel* self,
                                    GNode* node,
                                    gboolean force_first_child);
void structure_model_shift_left (StructureModel* self,
                                 GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self,
                                                     GtkTreeIter* iter);
static gboolean structure_model_node_contains_subparagraph (StructureModel* self,
                                                     GNode* node);
static void structure_model_insert_node (StructureModel* self,
                                  GNode* node,
                                  gboolean force_first_child);
static void structure_model_insert_node_in_list (StructureModel* self,
                                          GNode* node);
static gint structure_model_compare_nodes (GtkTextMark* mark1,
                                    GtkTextMark* mark2);
void structure_model_populate_list (StructureModel* self,
                                    GtkListStore* store,
                                    StructType type);
static GeeArrayList* structure_model_get_list (StructureModel* self,
                                        StructType type);
GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self,
                                                          StructType list_type,
                                                          gint num);
gint structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                                  GtkTreeIter* tree_iter);
static gboolean __lambda42_ (StructureModel* self,
                      GNode* node);
static gboolean ___lambda42__gnode_traverse_func (GNode* node,
                                           gpointer self);
void structure_model_set_emit_signals (StructureModel* self,
                                       gboolean value);
static void structure_model_finalize (GObject * obj);
static void _vala_structure_model_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_structure_model_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);


static gpointer
_g_object_ref0 (gpointer self)
{
#line 38 "structure_model.vala"
	return self ? g_object_ref (self) : NULL;
#line 292 "structure_model.c"
}


void
struct_data_copy (const StructData* self,
                  StructData* dest)
{
	StructType _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextMark* _tmp5_;
	GtkTextMark* _tmp6_;
#line 38 "structure_model.vala"
	_tmp0_ = (*self).type;
#line 38 "structure_model.vala"
	(*dest).type = _tmp0_;
#line 38 "structure_model.vala"
	_tmp1_ = (*self).text;
#line 38 "structure_model.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 38 "structure_model.vala"
	_g_free0 ((*dest).text);
#line 38 "structure_model.vala"
	(*dest).text = _tmp2_;
#line 38 "structure_model.vala"
	_tmp3_ = (*self).start_mark;
#line 38 "structure_model.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 38 "structure_model.vala"
	_g_object_unref0 ((*dest).start_mark);
#line 38 "structure_model.vala"
	(*dest).start_mark = _tmp4_;
#line 38 "structure_model.vala"
	_tmp5_ = (*self).end_mark;
#line 38 "structure_model.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 38 "structure_model.vala"
	_g_object_unref0 ((*dest).end_mark);
#line 38 "structure_model.vala"
	(*dest).end_mark = _tmp6_;
#line 335 "structure_model.c"
}


void
struct_data_destroy (StructData* self)
{
#line 41 "structure_model.vala"
	_g_free0 ((*self).text);
#line 42 "structure_model.vala"
	_g_object_unref0 ((*self).start_mark);
#line 43 "structure_model.vala"
	_g_object_unref0 ((*self).end_mark);
#line 348 "structure_model.c"
}


StructData*
struct_data_dup (const StructData* self)
{
	StructData* dup;
#line 38 "structure_model.vala"
	dup = g_new0 (StructData, 1);
#line 38 "structure_model.vala"
	struct_data_copy (self, dup);
#line 38 "structure_model.vala"
	return dup;
#line 362 "structure_model.c"
}


void
struct_data_free (StructData* self)
{
#line 38 "structure_model.vala"
	struct_data_destroy (self);
#line 38 "structure_model.vala"
	g_free (self);
#line 373 "structure_model.c"
}


GType
struct_data_get_type (void)
{
	static volatile gsize struct_data_type_id__volatile = 0;
	if (g_once_init_enter (&struct_data_type_id__volatile)) {
		GType struct_data_type_id;
		struct_data_type_id = g_boxed_type_register_static ("StructData", (GBoxedCopyFunc) struct_data_dup, (GBoxedFreeFunc) struct_data_free);
		g_once_init_leave (&struct_data_type_id__volatile, struct_data_type_id);
	}
	return struct_data_type_id__volatile;
}


GType
struct_column_get_type (void)
{
	static volatile gsize struct_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_COLUMN_PIXBUF, "STRUCT_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_COLUMN_TEXT, "STRUCT_COLUMN_TEXT", "text"}, {STRUCT_COLUMN_TOOLTIP, "STRUCT_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_COLUMN_START_MARK, "STRUCT_COLUMN_START_MARK", "start-mark"}, {STRUCT_COLUMN_END_MARK, "STRUCT_COLUMN_END_MARK", "end-mark"}, {STRUCT_COLUMN_TYPE, "STRUCT_COLUMN_TYPE", "type"}, {STRUCT_COLUMN_N_COLUMNS, "STRUCT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_column_type_id;
		struct_column_type_id = g_enum_register_static ("StructColumn", values);
		g_once_init_leave (&struct_column_type_id__volatile, struct_column_type_id);
	}
	return struct_column_type_id__volatile;
}


GType
struct_list_column_get_type (void)
{
	static volatile gsize struct_list_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_list_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_LIST_COLUMN_PIXBUF, "STRUCT_LIST_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_LIST_COLUMN_TEXT, "STRUCT_LIST_COLUMN_TEXT", "text"}, {STRUCT_LIST_COLUMN_TOOLTIP, "STRUCT_LIST_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_LIST_COLUMN_N_COLUMNS, "STRUCT_LIST_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_list_column_type_id;
		struct_list_column_type_id = g_enum_register_static ("StructListColumn", values);
		g_once_init_leave (&struct_list_column_type_id__volatile, struct_list_column_type_id);
	}
	return struct_list_column_type_id__volatile;
}


GQuark
struct_error_quark (void)
{
#line 183 "project_dialogs.vala"
	return g_quark_from_static_string ("struct_error-quark");
#line 423 "structure_model.c"
}


static inline gpointer
structure_model_get_instance_private (StructureModel* self)
{
	return G_STRUCT_MEMBER_P (self, StructureModel_private_offset);
}


static void
_struct_data_free0_ (gpointer var)
{
#line 78 "structure_model.vala"
	(var == NULL) ? NULL : (var = (struct_data_free (var), NULL));
#line 439 "structure_model.c"
}


static gboolean
_g_node_free_all_node (GNode* node,
                       GDestroyNotify free_func)
{
#line 78 "structure_model.vala"
	(node->data == NULL) ? NULL : free_func (node->data);
#line 78 "structure_model.vala"
	return FALSE;
#line 451 "structure_model.c"
}


static void
_g_node_free_all (GNode* self,
                  GDestroyNotify free_func)
{
#line 78 "structure_model.vala"
	(free_func == NULL) ? NULL : g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, (GNodeTraverseFunc) _g_node_free_all_node, free_func);
#line 78 "structure_model.vala"
	g_node_destroy (self);
#line 463 "structure_model.c"
}


static inline void
_g_node_destroy__struct_data_free0_ (GNode* self)
{
#line 78 "structure_model.vala"
	_g_node_free_all (self, (GDestroyNotify) _struct_data_free0_);
#line 472 "structure_model.c"
}


static gpointer
_struct_data_dup0 (gpointer self)
{
#line 100 "structure_model.vala"
	return self ? struct_data_dup (self) : NULL;
#line 481 "structure_model.c"
}


StructureModel*
structure_model_construct (GType object_type)
{
	StructureModel * self = NULL;
	GType* _tmp0_;
	GType* _tmp1_;
	gint _tmp1__length1;
	GType _tmp2_;
	GType* _tmp3_;
	gint _tmp3__length1;
	GType _tmp4_;
	GType* _tmp5_;
	gint _tmp5__length1;
	GType _tmp6_;
	GType* _tmp7_;
	gint _tmp7__length1;
	GType _tmp8_;
	GType* _tmp9_;
	gint _tmp9__length1;
	GType _tmp10_;
	GType* _tmp11_;
	gint _tmp11__length1;
	GType _tmp12_;
	StructData empty_data = {0};
	StructData _tmp13_ = {0};
	StructData _tmp14_;
	StructData _tmp15_;
	StructData* _tmp16_;
	GNode* _tmp17_;
#line 89 "structure_model.vala"
	self = (StructureModel*) g_object_new (object_type, NULL);
#line 91 "structure_model.vala"
	_tmp0_ = g_new0 (GType, STRUCT_COLUMN_N_COLUMNS);
#line 91 "structure_model.vala"
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
#line 91 "structure_model.vala"
	self->priv->_column_types = _tmp0_;
#line 91 "structure_model.vala"
	self->priv->_column_types_length1 = STRUCT_COLUMN_N_COLUMNS;
#line 91 "structure_model.vala"
	self->priv->__column_types_size_ = self->priv->_column_types_length1;
#line 92 "structure_model.vala"
	_tmp1_ = self->priv->_column_types;
#line 92 "structure_model.vala"
	_tmp1__length1 = self->priv->_column_types_length1;
#line 92 "structure_model.vala"
	_tmp1_[STRUCT_COLUMN_PIXBUF] = G_TYPE_STRING;
#line 92 "structure_model.vala"
	_tmp2_ = _tmp1_[STRUCT_COLUMN_PIXBUF];
#line 93 "structure_model.vala"
	_tmp3_ = self->priv->_column_types;
#line 93 "structure_model.vala"
	_tmp3__length1 = self->priv->_column_types_length1;
#line 93 "structure_model.vala"
	_tmp3_[STRUCT_COLUMN_TEXT] = G_TYPE_STRING;
#line 93 "structure_model.vala"
	_tmp4_ = _tmp3_[STRUCT_COLUMN_TEXT];
#line 94 "structure_model.vala"
	_tmp5_ = self->priv->_column_types;
#line 94 "structure_model.vala"
	_tmp5__length1 = self->priv->_column_types_length1;
#line 94 "structure_model.vala"
	_tmp5_[STRUCT_COLUMN_TOOLTIP] = G_TYPE_STRING;
#line 94 "structure_model.vala"
	_tmp6_ = _tmp5_[STRUCT_COLUMN_TOOLTIP];
#line 95 "structure_model.vala"
	_tmp7_ = self->priv->_column_types;
#line 95 "structure_model.vala"
	_tmp7__length1 = self->priv->_column_types_length1;
#line 95 "structure_model.vala"
	_tmp7_[STRUCT_COLUMN_START_MARK] = gtk_text_mark_get_type ();
#line 95 "structure_model.vala"
	_tmp8_ = _tmp7_[STRUCT_COLUMN_START_MARK];
#line 96 "structure_model.vala"
	_tmp9_ = self->priv->_column_types;
#line 96 "structure_model.vala"
	_tmp9__length1 = self->priv->_column_types_length1;
#line 96 "structure_model.vala"
	_tmp9_[STRUCT_COLUMN_END_MARK] = gtk_text_mark_get_type ();
#line 96 "structure_model.vala"
	_tmp10_ = _tmp9_[STRUCT_COLUMN_END_MARK];
#line 97 "structure_model.vala"
	_tmp11_ = self->priv->_column_types;
#line 97 "structure_model.vala"
	_tmp11__length1 = self->priv->_column_types_length1;
#line 97 "structure_model.vala"
	_tmp11_[STRUCT_COLUMN_TYPE] = TYPE_STRUCT_TYPE;
#line 97 "structure_model.vala"
	_tmp12_ = _tmp11_[STRUCT_COLUMN_TYPE];
#line 99 "structure_model.vala"
	empty_data = _tmp13_;
#line 100 "structure_model.vala"
	_tmp14_ = empty_data;
#line 100 "structure_model.vala"
	_tmp15_ = _tmp14_;
#line 100 "structure_model.vala"
	_tmp16_ = _struct_data_dup0 (&_tmp15_);
#line 100 "structure_model.vala"
	_tmp17_ = g_node_new (_tmp16_);
#line 100 "structure_model.vala"
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
#line 100 "structure_model.vala"
	self->priv->_tree = _tmp17_;
#line 102 "structure_model.vala"
	structure_model_new_stamp (self);
#line 103 "structure_model.vala"
	structure_model_reset_simple_lists (self);
#line 89 "structure_model.vala"
	struct_data_destroy (&empty_data);
#line 89 "structure_model.vala"
	return self;
#line 596 "structure_model.c"
}


StructureModel*
structure_model_new (void)
{
#line 89 "structure_model.vala"
	return structure_model_construct (TYPE_STRUCTURE_MODEL);
#line 605 "structure_model.c"
}


static void
structure_model_new_stamp (StructureModel* self)
{
#line 107 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 109 "structure_model.vala"
	self->priv->_stamp = (gint) g_random_int ();
#line 616 "structure_model.c"
}


static GtkTreeIter*
_gtk_tree_iter_dup (GtkTreeIter* self)
{
	GtkTreeIter* dup;
#line 119 "structure_model.vala"
	dup = g_new0 (GtkTreeIter, 1);
#line 119 "structure_model.vala"
	memcpy (dup, self, sizeof (GtkTreeIter));
#line 119 "structure_model.vala"
	return dup;
#line 630 "structure_model.c"
}


static gpointer
__gtk_tree_iter_dup0 (gpointer self)
{
#line 119 "structure_model.vala"
	return self ? _gtk_tree_iter_dup (self) : NULL;
#line 639 "structure_model.c"
}


static GtkTreeIter*
structure_model_create_iter_at_node (StructureModel* self,
                                     GNode* node)
{
	GtkTreeIter* result = NULL;
	GNode* _tmp0_;
	GtkTreeIter new_iter = {0};
	gint _tmp1_;
	GtkTreeIter* _tmp2_;
#line 112 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 112 "structure_model.vala"
	g_return_val_if_fail (node != NULL, NULL);
#line 114 "structure_model.vala"
	_tmp0_ = self->priv->_tree;
#line 114 "structure_model.vala"
	g_return_val_if_fail (node != _tmp0_, NULL);
#line 116 "structure_model.vala"
	memset (&new_iter, 0, sizeof (GtkTreeIter));
#line 117 "structure_model.vala"
	_tmp1_ = self->priv->_stamp;
#line 117 "structure_model.vala"
	new_iter.stamp = _tmp1_;
#line 118 "structure_model.vala"
	new_iter.user_data = node;
#line 119 "structure_model.vala"
	_tmp2_ = __gtk_tree_iter_dup0 (&new_iter);
#line 119 "structure_model.vala"
	result = _tmp2_;
#line 119 "structure_model.vala"
	return result;
#line 674 "structure_model.c"
}


static gboolean
structure_model_iter_is_valid (StructureModel* self,
                               GtkTreeIter* iter)
{
	gboolean result = FALSE;
	GtkTreeIter _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkTreeIter _tmp3_;
	void* _tmp4_;
	GNode* node = NULL;
	GtkTreeIter _tmp5_;
	GNode* _tmp6_;
	GNode* _tmp7_;
	gconstpointer _tmp8_;
	StructData data = {0};
	GNode* _tmp9_;
	gconstpointer _tmp10_;
	StructData _tmp11_ = {0};
	StructData _tmp12_;
	const gchar* _tmp13_;
#line 122 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 122 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 124 "structure_model.vala"
	_tmp0_ = *iter;
#line 124 "structure_model.vala"
	_tmp1_ = _tmp0_.stamp;
#line 124 "structure_model.vala"
	_tmp2_ = self->priv->_stamp;
#line 124 "structure_model.vala"
	if (_tmp1_ != _tmp2_) {
#line 127 "structure_model.vala"
		result = FALSE;
#line 127 "structure_model.vala"
		return result;
#line 715 "structure_model.c"
	}
#line 130 "structure_model.vala"
	_tmp3_ = *iter;
#line 130 "structure_model.vala"
	_tmp4_ = _tmp3_.user_data;
#line 130 "structure_model.vala"
	if (_tmp4_ == NULL) {
#line 133 "structure_model.vala"
		result = FALSE;
#line 133 "structure_model.vala"
		return result;
#line 727 "structure_model.c"
	}
#line 136 "structure_model.vala"
	_tmp5_ = *iter;
#line 136 "structure_model.vala"
	_tmp6_ = structure_model_get_node_from_iter (self, &_tmp5_);
#line 136 "structure_model.vala"
	node = _tmp6_;
#line 137 "structure_model.vala"
	_tmp7_ = node;
#line 137 "structure_model.vala"
	_tmp8_ = _tmp7_->data;
#line 137 "structure_model.vala"
	if (((StructData*) _tmp8_) == NULL) {
#line 140 "structure_model.vala"
		result = FALSE;
#line 140 "structure_model.vala"
		return result;
#line 745 "structure_model.c"
	}
#line 143 "structure_model.vala"
	_tmp9_ = node;
#line 143 "structure_model.vala"
	_tmp10_ = _tmp9_->data;
#line 143 "structure_model.vala"
	struct_data_copy ((StructData*) _tmp10_, &_tmp11_);
#line 143 "structure_model.vala"
	data = _tmp11_;
#line 144 "structure_model.vala"
	_tmp12_ = data;
#line 144 "structure_model.vala"
	_tmp13_ = _tmp12_.text;
#line 144 "structure_model.vala"
	if (_tmp13_ == NULL) {
#line 147 "structure_model.vala"
		result = FALSE;
#line 147 "structure_model.vala"
		struct_data_destroy (&data);
#line 147 "structure_model.vala"
		return result;
#line 767 "structure_model.c"
	}
#line 150 "structure_model.vala"
	result = TRUE;
#line 150 "structure_model.vala"
	struct_data_destroy (&data);
#line 150 "structure_model.vala"
	return result;
#line 775 "structure_model.c"
}


static gboolean
structure_model_column_is_valid (StructureModel* self,
                                 gint index)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 153 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "structure_model.vala"
	if (0 <= index) {
#line 155 "structure_model.vala"
		_tmp0_ = index < ((gint) STRUCT_COLUMN_N_COLUMNS);
#line 791 "structure_model.c"
	} else {
#line 155 "structure_model.vala"
		_tmp0_ = FALSE;
#line 795 "structure_model.c"
	}
#line 155 "structure_model.vala"
	result = _tmp0_;
#line 155 "structure_model.vala"
	return result;
#line 801 "structure_model.c"
}


static GNode*
structure_model_get_node_from_iter (StructureModel* self,
                                    GtkTreeIter* iter)
{
	GNode* result = NULL;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
#line 159 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 161 "structure_model.vala"
	_tmp0_ = *iter;
#line 161 "structure_model.vala"
	_tmp1_ = _tmp0_.user_data;
#line 161 "structure_model.vala"
	result = (GNode*) _tmp1_;
#line 161 "structure_model.vala"
	return result;
#line 824 "structure_model.c"
}


/*************************************************************************/
static GType
structure_model_real_get_column_type (GtkTreeModel* base,
                                      gint index)
{
	StructureModel * self;
	GType result = 0UL;
	GType* _tmp0_;
	gint _tmp0__length1;
	GType _tmp1_;
#line 167 "structure_model.vala"
	self = (StructureModel*) base;
#line 169 "structure_model.vala"
	g_return_val_if_fail (structure_model_column_is_valid (self, index), G_TYPE_INVALID);
#line 171 "structure_model.vala"
	_tmp0_ = self->priv->_column_types;
#line 171 "structure_model.vala"
	_tmp0__length1 = self->priv->_column_types_length1;
#line 171 "structure_model.vala"
	_tmp1_ = _tmp0_[index];
#line 171 "structure_model.vala"
	result = _tmp1_;
#line 171 "structure_model.vala"
	return result;
#line 852 "structure_model.c"
}


static gint
structure_model_real_get_n_columns (GtkTreeModel* base)
{
	StructureModel * self;
	gint result = 0;
#line 174 "structure_model.vala"
	self = (StructureModel*) base;
#line 176 "structure_model.vala"
	result = (gint) STRUCT_COLUMN_N_COLUMNS;
#line 176 "structure_model.vala"
	return result;
#line 867 "structure_model.c"
}


static GtkTreeModelFlags
structure_model_real_get_flags (GtkTreeModel* base)
{
	StructureModel * self;
	GtkTreeModelFlags result = 0;
#line 179 "structure_model.vala"
	self = (StructureModel*) base;
#line 181 "structure_model.vala"
	result = 0;
#line 181 "structure_model.vala"
	return result;
#line 882 "structure_model.c"
}


static gboolean
structure_model_real_iter_has_child (GtkTreeModel* base,
                                     GtkTreeIter* iter)
{
	StructureModel * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
#line 184 "structure_model.vala"
	self = (StructureModel*) base;
#line 184 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 186 "structure_model.vala"
	_tmp0_ = *iter;
#line 186 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 188 "structure_model.vala"
	_tmp1_ = *iter;
#line 188 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 188 "structure_model.vala"
	node = _tmp2_;
#line 189 "structure_model.vala"
	result = !G_NODE_IS_LEAF (node);
#line 189 "structure_model.vala"
	return result;
#line 914 "structure_model.c"
}


static gint
structure_model_real_iter_n_children (GtkTreeModel* base,
                                      GtkTreeIter* iter)
{
	StructureModel * self;
	gint result = 0;
	GNode* node = NULL;
	GNode* _tmp4_;
#line 192 "structure_model.vala"
	self = (StructureModel*) base;
#line 195 "structure_model.vala"
	if (iter == NULL) {
#line 930 "structure_model.c"
		GNode* _tmp0_;
#line 196 "structure_model.vala"
		_tmp0_ = self->priv->_tree;
#line 196 "structure_model.vala"
		node = _tmp0_;
#line 936 "structure_model.c"
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
#line 199 "structure_model.vala"
		_tmp1_ = *iter;
#line 199 "structure_model.vala"
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), -1);
#line 200 "structure_model.vala"
		_tmp2_ = *iter;
#line 200 "structure_model.vala"
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 200 "structure_model.vala"
		node = _tmp3_;
#line 951 "structure_model.c"
	}
#line 203 "structure_model.vala"
	_tmp4_ = node;
#line 203 "structure_model.vala"
	result = (gint) g_node_n_children (_tmp4_);
#line 203 "structure_model.vala"
	return result;
#line 959 "structure_model.c"
}


static void
structure_model_real_get_value (GtkTreeModel* base,
                                GtkTreeIter* iter,
                                gint column,
                                GValue* val)
{
	StructureModel * self;
	GValue _vala_val = {0};
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructData data = {0};
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructData _tmp5_ = {0};
#line 206 "structure_model.vala"
	self = (StructureModel*) base;
#line 206 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 208 "structure_model.vala"
	_tmp0_ = *iter;
#line 208 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 209 "structure_model.vala"
	g_return_if_fail (structure_model_column_is_valid (self, column));
#line 211 "structure_model.vala"
	_tmp1_ = *iter;
#line 211 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 211 "structure_model.vala"
	node = _tmp2_;
#line 212 "structure_model.vala"
	_tmp3_ = node;
#line 212 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 212 "structure_model.vala"
	struct_data_copy ((StructData*) _tmp4_, &_tmp5_);
#line 212 "structure_model.vala"
	data = _tmp5_;
#line 214 "structure_model.vala"
	switch (column) {
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_TEXT:
#line 1007 "structure_model.c"
		{
			StructData _tmp6_;
			const gchar* _tmp7_;
			GValue _tmp8_ = {0};
#line 217 "structure_model.vala"
			_tmp6_ = data;
#line 217 "structure_model.vala"
			_tmp7_ = _tmp6_.text;
#line 217 "structure_model.vala"
			g_value_init (&_tmp8_, G_TYPE_STRING);
#line 217 "structure_model.vala"
			g_value_set_string (&_tmp8_, _tmp7_);
#line 217 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 217 "structure_model.vala"
			_vala_val = _tmp8_;
#line 218 "structure_model.vala"
			break;
#line 1026 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_START_MARK:
#line 1030 "structure_model.c"
		{
			StructData _tmp9_;
			GtkTextMark* _tmp10_;
			GValue _tmp11_ = {0};
#line 221 "structure_model.vala"
			_tmp9_ = data;
#line 221 "structure_model.vala"
			_tmp10_ = _tmp9_.start_mark;
#line 221 "structure_model.vala"
			g_value_init (&_tmp11_, gtk_text_mark_get_type ());
#line 221 "structure_model.vala"
			g_value_set_object (&_tmp11_, _tmp10_);
#line 221 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 221 "structure_model.vala"
			_vala_val = _tmp11_;
#line 222 "structure_model.vala"
			break;
#line 1049 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_END_MARK:
#line 1053 "structure_model.c"
		{
			StructData _tmp12_;
			GtkTextMark* _tmp13_;
			GValue _tmp14_ = {0};
#line 225 "structure_model.vala"
			_tmp12_ = data;
#line 225 "structure_model.vala"
			_tmp13_ = _tmp12_.end_mark;
#line 225 "structure_model.vala"
			g_value_init (&_tmp14_, gtk_text_mark_get_type ());
#line 225 "structure_model.vala"
			g_value_set_object (&_tmp14_, _tmp13_);
#line 225 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 225 "structure_model.vala"
			_vala_val = _tmp14_;
#line 226 "structure_model.vala"
			break;
#line 1072 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_TYPE:
#line 1076 "structure_model.c"
		{
			StructData _tmp15_;
			StructType _tmp16_;
			GValue _tmp17_ = {0};
#line 229 "structure_model.vala"
			_tmp15_ = data;
#line 229 "structure_model.vala"
			_tmp16_ = _tmp15_.type;
#line 229 "structure_model.vala"
			g_value_init (&_tmp17_, TYPE_STRUCT_TYPE);
#line 229 "structure_model.vala"
			g_value_set_enum (&_tmp17_, _tmp16_);
#line 229 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 229 "structure_model.vala"
			_vala_val = _tmp17_;
#line 230 "structure_model.vala"
			break;
#line 1095 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_PIXBUF:
#line 1099 "structure_model.c"
		{
			StructData _tmp18_;
			StructType _tmp19_;
			gchar* _tmp20_;
			GValue _tmp21_ = {0};
#line 233 "structure_model.vala"
			_tmp18_ = data;
#line 233 "structure_model.vala"
			_tmp19_ = _tmp18_.type;
#line 233 "structure_model.vala"
			_tmp20_ = structure_get_icon_from_type (_tmp19_);
#line 233 "structure_model.vala"
			g_value_init (&_tmp21_, G_TYPE_STRING);
#line 233 "structure_model.vala"
			g_value_take_string (&_tmp21_, _tmp20_);
#line 233 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 233 "structure_model.vala"
			_vala_val = _tmp21_;
#line 234 "structure_model.vala"
			break;
#line 1121 "structure_model.c"
		}
#line 214 "structure_model.vala"
		case STRUCT_COLUMN_TOOLTIP:
#line 1125 "structure_model.c"
		{
			StructData _tmp22_;
			StructType _tmp23_;
			gchar* _tmp24_;
			GValue _tmp25_ = {0};
#line 237 "structure_model.vala"
			_tmp22_ = data;
#line 237 "structure_model.vala"
			_tmp23_ = _tmp22_.type;
#line 237 "structure_model.vala"
			_tmp24_ = structure_get_type_name (_tmp23_);
#line 237 "structure_model.vala"
			g_value_init (&_tmp25_, G_TYPE_STRING);
#line 237 "structure_model.vala"
			g_value_take_string (&_tmp25_, _tmp24_);
#line 237 "structure_model.vala"
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 237 "structure_model.vala"
			_vala_val = _tmp25_;
#line 238 "structure_model.vala"
			break;
#line 1147 "structure_model.c"
		}
		default:
		{
#line 241 "structure_model.vala"
			g_return_if_reached ();
#line 1153 "structure_model.c"
		}
	}
#line 206 "structure_model.vala"
	struct_data_destroy (&data);
#line 206 "structure_model.vala"
	if (val) {
#line 206 "structure_model.vala"
		*val = _vala_val;
#line 1162 "structure_model.c"
	} else {
#line 206 "structure_model.vala"
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
#line 1166 "structure_model.c"
	}
}


static gboolean
structure_model_real_iter_children (GtkTreeModel* base,
                                    GtkTreeIter* iter,
                                    GtkTreeIter* parent)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GNode* node = NULL;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* _tmp8_;
#line 245 "structure_model.vala"
	self = (StructureModel*) base;
#line 247 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 250 "structure_model.vala"
	if (parent == NULL) {
#line 1191 "structure_model.c"
		GNode* _tmp0_;
#line 251 "structure_model.vala"
		_tmp0_ = self->priv->_tree;
#line 251 "structure_model.vala"
		node = _tmp0_;
#line 1197 "structure_model.c"
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
#line 254 "structure_model.vala"
		_tmp1_ = *parent;
#line 254 "structure_model.vala"
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), FALSE);
#line 255 "structure_model.vala"
		_tmp2_ = *parent;
#line 255 "structure_model.vala"
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 255 "structure_model.vala"
		node = _tmp3_;
#line 1212 "structure_model.c"
	}
#line 258 "structure_model.vala"
	_tmp4_ = node;
#line 258 "structure_model.vala"
	if (G_NODE_IS_LEAF (_tmp4_)) {
#line 259 "structure_model.vala"
		result = FALSE;
#line 259 "structure_model.vala"
		if (iter) {
#line 259 "structure_model.vala"
			*iter = _vala_iter;
#line 1224 "structure_model.c"
		}
#line 259 "structure_model.vala"
		return result;
#line 1228 "structure_model.c"
	}
#line 261 "structure_model.vala"
	_tmp5_ = node;
#line 261 "structure_model.vala"
	_tmp6_ = g_node_first_child (_tmp5_);
#line 261 "structure_model.vala"
	_tmp7_ = structure_model_create_iter_at_node (self, _tmp6_);
#line 261 "structure_model.vala"
	_tmp8_ = _tmp7_;
#line 261 "structure_model.vala"
	_vala_iter = *_tmp8_;
#line 261 "structure_model.vala"
	_g_free0 (_tmp8_);
#line 262 "structure_model.vala"
	result = TRUE;
#line 262 "structure_model.vala"
	if (iter) {
#line 262 "structure_model.vala"
		*iter = _vala_iter;
#line 1248 "structure_model.c"
	}
#line 262 "structure_model.vala"
	return result;
#line 1252 "structure_model.c"
}


static gboolean
structure_model_real_iter_next (GtkTreeModel* base,
                                GtkTreeIter* iter)
{
	StructureModel * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* next_node = NULL;
	GNode* _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* _tmp8_;
#line 265 "structure_model.vala"
	self = (StructureModel*) base;
#line 265 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 267 "structure_model.vala"
	_tmp0_ = *iter;
#line 267 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 269 "structure_model.vala"
	_tmp1_ = *iter;
#line 269 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 269 "structure_model.vala"
	node = _tmp2_;
#line 270 "structure_model.vala"
	_tmp3_ = node;
#line 270 "structure_model.vala"
	_tmp4_ = g_node_next_sibling (_tmp3_);
#line 270 "structure_model.vala"
	next_node = _tmp4_;
#line 271 "structure_model.vala"
	_tmp5_ = next_node;
#line 271 "structure_model.vala"
	if (_tmp5_ == NULL) {
#line 272 "structure_model.vala"
		result = FALSE;
#line 272 "structure_model.vala"
		return result;
#line 1301 "structure_model.c"
	}
#line 274 "structure_model.vala"
	_tmp6_ = next_node;
#line 274 "structure_model.vala"
	_tmp7_ = structure_model_create_iter_at_node (self, _tmp6_);
#line 274 "structure_model.vala"
	_tmp8_ = _tmp7_;
#line 274 "structure_model.vala"
	*iter = *_tmp8_;
#line 274 "structure_model.vala"
	_g_free0 (_tmp8_);
#line 275 "structure_model.vala"
	result = TRUE;
#line 275 "structure_model.vala"
	return result;
#line 1317 "structure_model.c"
}


static gboolean
structure_model_real_iter_nth_child (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     GtkTreeIter* parent,
                                     gint n)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GNode* node = NULL;
	GNode* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GNode* _tmp7_;
	GNode* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter* _tmp10_;
#line 278 "structure_model.vala"
	self = (StructureModel*) base;
#line 280 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 283 "structure_model.vala"
	if (parent == NULL) {
#line 1343 "structure_model.c"
		GNode* _tmp0_;
#line 284 "structure_model.vala"
		_tmp0_ = self->priv->_tree;
#line 284 "structure_model.vala"
		node = _tmp0_;
#line 1349 "structure_model.c"
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
#line 287 "structure_model.vala"
		_tmp1_ = *parent;
#line 287 "structure_model.vala"
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), FALSE);
#line 288 "structure_model.vala"
		_tmp2_ = *parent;
#line 288 "structure_model.vala"
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 288 "structure_model.vala"
		node = _tmp3_;
#line 1364 "structure_model.c"
	}
#line 291 "structure_model.vala"
	_tmp4_ = node;
#line 291 "structure_model.vala"
	if (G_NODE_IS_LEAF (_tmp4_)) {
#line 292 "structure_model.vala"
		result = FALSE;
#line 292 "structure_model.vala"
		if (iter) {
#line 292 "structure_model.vala"
			*iter = _vala_iter;
#line 1376 "structure_model.c"
		}
#line 292 "structure_model.vala"
		return result;
#line 1380 "structure_model.c"
	}
#line 294 "structure_model.vala"
	if (n < 0) {
#line 294 "structure_model.vala"
		_tmp5_ = TRUE;
#line 1386 "structure_model.c"
	} else {
		GNode* _tmp6_;
#line 294 "structure_model.vala"
		_tmp6_ = node;
#line 294 "structure_model.vala"
		_tmp5_ = g_node_n_children (_tmp6_) <= ((guint) n);
#line 1393 "structure_model.c"
	}
#line 294 "structure_model.vala"
	if (_tmp5_) {
#line 295 "structure_model.vala"
		result = FALSE;
#line 295 "structure_model.vala"
		if (iter) {
#line 295 "structure_model.vala"
			*iter = _vala_iter;
#line 1403 "structure_model.c"
		}
#line 295 "structure_model.vala"
		return result;
#line 1407 "structure_model.c"
	}
#line 297 "structure_model.vala"
	_tmp7_ = node;
#line 297 "structure_model.vala"
	_tmp8_ = g_node_nth_child (_tmp7_, (guint) n);
#line 297 "structure_model.vala"
	_tmp9_ = structure_model_create_iter_at_node (self, _tmp8_);
#line 297 "structure_model.vala"
	_tmp10_ = _tmp9_;
#line 297 "structure_model.vala"
	_vala_iter = *_tmp10_;
#line 297 "structure_model.vala"
	_g_free0 (_tmp10_);
#line 298 "structure_model.vala"
	result = TRUE;
#line 298 "structure_model.vala"
	if (iter) {
#line 298 "structure_model.vala"
		*iter = _vala_iter;
#line 1427 "structure_model.c"
	}
#line 298 "structure_model.vala"
	return result;
#line 1431 "structure_model.c"
}


static gboolean
structure_model_real_iter_parent (GtkTreeModel* base,
                                  GtkTreeIter* iter,
                                  GtkTreeIter* child)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* parent_node = NULL;
	GNode* _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GNode* _tmp7_;
	GNode* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter* _tmp10_;
#line 301 "structure_model.vala"
	self = (StructureModel*) base;
#line 301 "structure_model.vala"
	g_return_val_if_fail (child != NULL, FALSE);
#line 303 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 305 "structure_model.vala"
	_tmp0_ = *child;
#line 305 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 307 "structure_model.vala"
	_tmp1_ = *child;
#line 307 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 307 "structure_model.vala"
	node = _tmp2_;
#line 308 "structure_model.vala"
	_tmp3_ = node;
#line 308 "structure_model.vala"
	_tmp4_ = _tmp3_->parent;
#line 308 "structure_model.vala"
	parent_node = _tmp4_;
#line 311 "structure_model.vala"
	_tmp5_ = parent_node;
#line 311 "structure_model.vala"
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
#line 314 "structure_model.vala"
	_tmp6_ = parent_node;
#line 314 "structure_model.vala"
	_tmp7_ = self->priv->_tree;
#line 314 "structure_model.vala"
	if (_tmp6_ == _tmp7_) {
#line 315 "structure_model.vala"
		result = FALSE;
#line 315 "structure_model.vala"
		if (iter) {
#line 315 "structure_model.vala"
			*iter = _vala_iter;
#line 1494 "structure_model.c"
		}
#line 315 "structure_model.vala"
		return result;
#line 1498 "structure_model.c"
	}
#line 317 "structure_model.vala"
	_tmp8_ = parent_node;
#line 317 "structure_model.vala"
	_tmp9_ = structure_model_create_iter_at_node (self, _tmp8_);
#line 317 "structure_model.vala"
	_tmp10_ = _tmp9_;
#line 317 "structure_model.vala"
	_vala_iter = *_tmp10_;
#line 317 "structure_model.vala"
	_g_free0 (_tmp10_);
#line 318 "structure_model.vala"
	result = TRUE;
#line 318 "structure_model.vala"
	if (iter) {
#line 318 "structure_model.vala"
		*iter = _vala_iter;
#line 1516 "structure_model.c"
	}
#line 318 "structure_model.vala"
	return result;
#line 1520 "structure_model.c"
}


static gboolean
structure_model_real_get_iter (GtkTreeModel* base,
                               GtkTreeIter* iter,
                               GtkTreePath* path)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gint depth = 0;
	gint _tmp0_;
	gint* indices = NULL;
	gint _tmp1_;
	gint* _tmp2_;
	gint indices_length1;
	gint _indices_size_;
	GNode* node = NULL;
	GNode* _tmp3_;
	GNode* _tmp18_;
	GtkTreeIter* _tmp19_;
	GtkTreeIter* _tmp20_;
#line 321 "structure_model.vala"
	self = (StructureModel*) base;
#line 321 "structure_model.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 323 "structure_model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 325 "structure_model.vala"
	depth = gtk_tree_path_get_depth (path);
#line 326 "structure_model.vala"
	_tmp0_ = depth;
#line 326 "structure_model.vala"
	g_return_val_if_fail (1 <= _tmp0_, FALSE);
#line 328 "structure_model.vala"
	_tmp2_ = gtk_tree_path_get_indices_with_depth (path, &_tmp1_);
#line 328 "structure_model.vala"
	indices = _tmp2_;
#line 328 "structure_model.vala"
	indices_length1 = _tmp1_;
#line 328 "structure_model.vala"
	_indices_size_ = indices_length1;
#line 330 "structure_model.vala"
	_tmp3_ = self->priv->_tree;
#line 330 "structure_model.vala"
	node = _tmp3_;
#line 1568 "structure_model.c"
	{
		gint cur_depth = 0;
#line 331 "structure_model.vala"
		cur_depth = 0;
#line 1573 "structure_model.c"
		{
			gboolean _tmp4_ = FALSE;
#line 331 "structure_model.vala"
			_tmp4_ = TRUE;
#line 331 "structure_model.vala"
			while (TRUE) {
#line 1580 "structure_model.c"
				gint _tmp6_;
				gint _tmp7_;
				gint indice = 0;
				gint* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				gint _tmp10_;
				gboolean _tmp11_ = FALSE;
				gint _tmp12_;
				GNode* _tmp15_;
				gint _tmp16_;
				GNode* _tmp17_;
#line 331 "structure_model.vala"
				if (!_tmp4_) {
#line 1595 "structure_model.c"
					gint _tmp5_;
#line 331 "structure_model.vala"
					_tmp5_ = cur_depth;
#line 331 "structure_model.vala"
					cur_depth = _tmp5_ + 1;
#line 1601 "structure_model.c"
				}
#line 331 "structure_model.vala"
				_tmp4_ = FALSE;
#line 331 "structure_model.vala"
				_tmp6_ = cur_depth;
#line 331 "structure_model.vala"
				_tmp7_ = depth;
#line 331 "structure_model.vala"
				if (!(_tmp6_ < _tmp7_)) {
#line 331 "structure_model.vala"
					break;
#line 1613 "structure_model.c"
				}
#line 333 "structure_model.vala"
				_tmp8_ = indices;
#line 333 "structure_model.vala"
				_tmp8__length1 = indices_length1;
#line 333 "structure_model.vala"
				_tmp9_ = cur_depth;
#line 333 "structure_model.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 333 "structure_model.vala"
				indice = _tmp10_;
#line 334 "structure_model.vala"
				_tmp12_ = indice;
#line 334 "structure_model.vala"
				if (_tmp12_ < 0) {
#line 334 "structure_model.vala"
					_tmp11_ = TRUE;
#line 1631 "structure_model.c"
				} else {
					GNode* _tmp13_;
					gint _tmp14_;
#line 334 "structure_model.vala"
					_tmp13_ = node;
#line 334 "structure_model.vala"
					_tmp14_ = indice;
#line 334 "structure_model.vala"
					_tmp11_ = g_node_n_children (_tmp13_) <= ((guint) _tmp14_);
#line 1641 "structure_model.c"
				}
#line 334 "structure_model.vala"
				if (_tmp11_) {
#line 335 "structure_model.vala"
					result = FALSE;
#line 335 "structure_model.vala"
					if (iter) {
#line 335 "structure_model.vala"
						*iter = _vala_iter;
#line 1651 "structure_model.c"
					}
#line 335 "structure_model.vala"
					return result;
#line 1655 "structure_model.c"
				}
#line 337 "structure_model.vala"
				_tmp15_ = node;
#line 337 "structure_model.vala"
				_tmp16_ = indice;
#line 337 "structure_model.vala"
				_tmp17_ = g_node_nth_child (_tmp15_, (guint) _tmp16_);
#line 337 "structure_model.vala"
				node = _tmp17_;
#line 1665 "structure_model.c"
			}
		}
	}
#line 340 "structure_model.vala"
	_tmp18_ = node;
#line 340 "structure_model.vala"
	_tmp19_ = structure_model_create_iter_at_node (self, _tmp18_);
#line 340 "structure_model.vala"
	_tmp20_ = _tmp19_;
#line 340 "structure_model.vala"
	_vala_iter = *_tmp20_;
#line 340 "structure_model.vala"
	_g_free0 (_tmp20_);
#line 341 "structure_model.vala"
	result = TRUE;
#line 341 "structure_model.vala"
	if (iter) {
#line 341 "structure_model.vala"
		*iter = _vala_iter;
#line 1685 "structure_model.c"
	}
#line 341 "structure_model.vala"
	return result;
#line 1689 "structure_model.c"
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 344 "structure_model.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1698 "structure_model.c"
}


static GtkTreePath*
structure_model_real_get_path (GtkTreeModel* base,
                               GtkTreeIter* iter)
{
	StructureModel * self;
	GtkTreePath* result = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_;
	GNode* node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
#line 344 "structure_model.vala"
	self = (StructureModel*) base;
#line 344 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 346 "structure_model.vala"
	_tmp0_ = *iter;
#line 346 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), NULL);
#line 348 "structure_model.vala"
	_tmp1_ = gtk_tree_path_new ();
#line 348 "structure_model.vala"
	path = _tmp1_;
#line 349 "structure_model.vala"
	_tmp2_ = *iter;
#line 349 "structure_model.vala"
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 349 "structure_model.vala"
	node = _tmp3_;
#line 351 "structure_model.vala"
	while (TRUE) {
#line 1734 "structure_model.c"
		GNode* _tmp4_;
		gint pos = 0;
		GNode* _tmp5_;
		GNode* _tmp6_;
		GNode* _tmp7_;
		GtkTreePath* _tmp8_;
		gint _tmp9_;
		GNode* _tmp10_;
		GNode* _tmp11_;
#line 351 "structure_model.vala"
		_tmp4_ = node;
#line 351 "structure_model.vala"
		if (!(!G_NODE_IS_ROOT (_tmp4_))) {
#line 351 "structure_model.vala"
			break;
#line 1750 "structure_model.c"
		}
#line 353 "structure_model.vala"
		_tmp5_ = node;
#line 353 "structure_model.vala"
		_tmp6_ = _tmp5_->parent;
#line 353 "structure_model.vala"
		_tmp7_ = node;
#line 353 "structure_model.vala"
		pos = g_node_child_position (_tmp6_, _tmp7_);
#line 354 "structure_model.vala"
		_tmp8_ = path;
#line 354 "structure_model.vala"
		_tmp9_ = pos;
#line 354 "structure_model.vala"
		gtk_tree_path_prepend_index (_tmp8_, _tmp9_);
#line 355 "structure_model.vala"
		_tmp10_ = node;
#line 355 "structure_model.vala"
		_tmp11_ = _tmp10_->parent;
#line 355 "structure_model.vala"
		node = _tmp11_;
#line 1772 "structure_model.c"
	}
#line 358 "structure_model.vala"
	result = path;
#line 358 "structure_model.vala"
	return result;
#line 1778 "structure_model.c"
}


/*************************************************************************/
guint
structure_model_get_nb_items (StructureModel* self)
{
	guint result = 0U;
	guint _tmp0_;
#line 365 "structure_model.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 367 "structure_model.vala"
	_tmp0_ = self->priv->_nb_nodes;
#line 367 "structure_model.vala"
	result = _tmp0_;
#line 367 "structure_model.vala"
	return result;
#line 1796 "structure_model.c"
}


GtkTreeIter*
structure_model_add_item_at_end (StructureModel* self,
                                 StructData* item)
{
	GtkTreeIter* result = NULL;
	GNode* _tmp0_;
	StructType item_depth = 0;
	StructData _tmp1_;
	StructType _tmp2_;
	GNode* parent = NULL;
	GNode* _tmp3_;
	GNode* prev_sibling = NULL;
	GtkTreeIter* end_iter = NULL;
	GNode* _tmp16_;
	GNode* _tmp17_;
	StructData _tmp18_;
	GtkTreeIter* _tmp19_;
	GtkTreeIter* _tmp20_;
#line 370 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 370 "structure_model.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 381 "structure_model.vala"
	_tmp0_ = self->priv->_end_node;
#line 381 "structure_model.vala"
	if (_tmp0_ == NULL) {
#line 382 "structure_model.vala"
		structure_model_search_end_node (self);
#line 1828 "structure_model.c"
	}
#line 385 "structure_model.vala"
	_tmp1_ = *item;
#line 385 "structure_model.vala"
	_tmp2_ = _tmp1_.type;
#line 385 "structure_model.vala"
	item_depth = _tmp2_;
#line 386 "structure_model.vala"
	_tmp3_ = self->priv->_end_node;
#line 386 "structure_model.vala"
	parent = _tmp3_;
#line 387 "structure_model.vala"
	prev_sibling = NULL;
#line 388 "structure_model.vala"
	while (TRUE) {
#line 1844 "structure_model.c"
		GNode* _tmp4_;
		GNode* _tmp5_;
		StructType cur_depth = 0;
		GNode* _tmp6_;
		gconstpointer _tmp7_;
		StructType _tmp8_;
		gboolean _tmp9_ = FALSE;
		StructType _tmp10_;
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
#line 390 "structure_model.vala"
		_tmp4_ = parent;
#line 390 "structure_model.vala"
		_tmp5_ = self->priv->_tree;
#line 390 "structure_model.vala"
		if (_tmp4_ == _tmp5_) {
#line 391 "structure_model.vala"
			break;
#line 1864 "structure_model.c"
		}
#line 393 "structure_model.vala"
		_tmp6_ = parent;
#line 393 "structure_model.vala"
		_tmp7_ = _tmp6_->data;
#line 393 "structure_model.vala"
		_tmp8_ = (*((StructData*) _tmp7_)).type;
#line 393 "structure_model.vala"
		cur_depth = _tmp8_;
#line 394 "structure_model.vala"
		_tmp10_ = cur_depth;
#line 394 "structure_model.vala"
		if (structure_is_section (_tmp10_)) {
#line 1878 "structure_model.c"
			StructType _tmp11_;
			StructType _tmp12_;
#line 394 "structure_model.vala"
			_tmp11_ = cur_depth;
#line 394 "structure_model.vala"
			_tmp12_ = item_depth;
#line 394 "structure_model.vala"
			_tmp9_ = _tmp11_ < _tmp12_;
#line 1887 "structure_model.c"
		} else {
#line 394 "structure_model.vala"
			_tmp9_ = FALSE;
#line 1891 "structure_model.c"
		}
#line 394 "structure_model.vala"
		if (_tmp9_) {
#line 395 "structure_model.vala"
			break;
#line 1897 "structure_model.c"
		}
#line 397 "structure_model.vala"
		_tmp13_ = parent;
#line 397 "structure_model.vala"
		prev_sibling = _tmp13_;
#line 398 "structure_model.vala"
		_tmp14_ = parent;
#line 398 "structure_model.vala"
		_tmp15_ = _tmp14_->parent;
#line 398 "structure_model.vala"
		parent = _tmp15_;
#line 1909 "structure_model.c"
	}
#line 402 "structure_model.vala"
	_tmp16_ = parent;
#line 402 "structure_model.vala"
	_tmp17_ = prev_sibling;
#line 402 "structure_model.vala"
	_tmp18_ = *item;
#line 402 "structure_model.vala"
	_tmp19_ = structure_model_insert_item_after (self, _tmp16_, _tmp17_, &_tmp18_);
#line 402 "structure_model.vala"
	end_iter = _tmp19_;
#line 404 "structure_model.vala"
	_tmp20_ = end_iter;
#line 404 "structure_model.vala"
	if (_tmp20_ != NULL) {
#line 1925 "structure_model.c"
		GtkTreeIter* _tmp21_;
		GtkTreeIter _tmp22_;
		GNode* _tmp23_;
#line 405 "structure_model.vala"
		_tmp21_ = end_iter;
#line 405 "structure_model.vala"
		_tmp22_ = *_tmp21_;
#line 405 "structure_model.vala"
		_tmp23_ = structure_model_get_node_from_iter (self, &_tmp22_);
#line 405 "structure_model.vala"
		self->priv->_end_node = _tmp23_;
#line 1937 "structure_model.c"
	}
#line 407 "structure_model.vala"
	result = end_iter;
#line 407 "structure_model.vala"
	return result;
#line 1943 "structure_model.c"
}


GtkTreeIter*
structure_model_get_next_sibling_or_parent (StructureModel* self,
                                            GtkTreeIter* section_iter,
                                            GError** error)
{
	GtkTreeIter* result = NULL;
	GtkTreeIter _tmp0_;
	GNode* cur_node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
	gconstpointer _tmp5_;
	StructType _tmp6_;
	GError * _inner_error_ = NULL;
#line 412 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 412 "structure_model.vala"
	g_return_val_if_fail (section_iter != NULL, NULL);
#line 414 "structure_model.vala"
	_tmp0_ = *section_iter;
#line 414 "structure_model.vala"
	if (!structure_model_iter_is_valid (self, &_tmp0_)) {
#line 1969 "structure_model.c"
		GError* _tmp1_;
#line 415 "structure_model.vala"
		_tmp1_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not valid.");
#line 415 "structure_model.vala"
		_inner_error_ = _tmp1_;
#line 415 "structure_model.vala"
		if (_inner_error_->domain == STRUCT_ERROR) {
#line 415 "structure_model.vala"
			g_propagate_error (error, _inner_error_);
#line 415 "structure_model.vala"
			return NULL;
#line 1981 "structure_model.c"
		} else {
#line 415 "structure_model.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 415 "structure_model.vala"
			g_clear_error (&_inner_error_);
#line 415 "structure_model.vala"
			return NULL;
#line 1989 "structure_model.c"
		}
	}
#line 417 "structure_model.vala"
	_tmp2_ = *section_iter;
#line 417 "structure_model.vala"
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
#line 417 "structure_model.vala"
	cur_node = _tmp3_;
#line 419 "structure_model.vala"
	_tmp4_ = cur_node;
#line 419 "structure_model.vala"
	_tmp5_ = _tmp4_->data;
#line 419 "structure_model.vala"
	_tmp6_ = (*((StructData*) _tmp5_)).type;
#line 419 "structure_model.vala"
	if (!structure_is_section (_tmp6_)) {
#line 2006 "structure_model.c"
		GError* _tmp7_;
#line 420 "structure_model.vala"
		_tmp7_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not a section.");
#line 420 "structure_model.vala"
		_inner_error_ = _tmp7_;
#line 420 "structure_model.vala"
		if (_inner_error_->domain == STRUCT_ERROR) {
#line 420 "structure_model.vala"
			g_propagate_error (error, _inner_error_);
#line 420 "structure_model.vala"
			return NULL;
#line 2018 "structure_model.c"
		} else {
#line 420 "structure_model.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 420 "structure_model.vala"
			g_clear_error (&_inner_error_);
#line 420 "structure_model.vala"
			return NULL;
#line 2026 "structure_model.c"
		}
	}
#line 422 "structure_model.vala"
	while (TRUE) {
#line 2031 "structure_model.c"
		gboolean _tmp8_ = FALSE;
		GNode* _tmp9_;
		GNode* next_sibling_node = NULL;
		GNode* _tmp12_;
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp17_;
		GNode* _tmp18_;
#line 422 "structure_model.vala"
		_tmp9_ = cur_node;
#line 422 "structure_model.vala"
		if (_tmp9_ != NULL) {
#line 2044 "structure_model.c"
			GNode* _tmp10_;
			GNode* _tmp11_;
#line 422 "structure_model.vala"
			_tmp10_ = cur_node;
#line 422 "structure_model.vala"
			_tmp11_ = self->priv->_tree;
#line 422 "structure_model.vala"
			_tmp8_ = _tmp10_ != _tmp11_;
#line 2053 "structure_model.c"
		} else {
#line 422 "structure_model.vala"
			_tmp8_ = FALSE;
#line 2057 "structure_model.c"
		}
#line 422 "structure_model.vala"
		if (!_tmp8_) {
#line 422 "structure_model.vala"
			break;
#line 2063 "structure_model.c"
		}
#line 424 "structure_model.vala"
		_tmp12_ = cur_node;
#line 424 "structure_model.vala"
		_tmp13_ = g_node_next_sibling (_tmp12_);
#line 424 "structure_model.vala"
		next_sibling_node = _tmp13_;
#line 426 "structure_model.vala"
		_tmp14_ = next_sibling_node;
#line 426 "structure_model.vala"
		if (_tmp14_ != NULL) {
#line 2075 "structure_model.c"
			GNode* _tmp15_;
			GtkTreeIter* _tmp16_;
#line 427 "structure_model.vala"
			_tmp15_ = next_sibling_node;
#line 427 "structure_model.vala"
			_tmp16_ = structure_model_create_iter_at_node (self, _tmp15_);
#line 427 "structure_model.vala"
			result = _tmp16_;
#line 427 "structure_model.vala"
			return result;
#line 2086 "structure_model.c"
		}
#line 429 "structure_model.vala"
		_tmp17_ = cur_node;
#line 429 "structure_model.vala"
		_tmp18_ = _tmp17_->parent;
#line 429 "structure_model.vala"
		cur_node = _tmp18_;
#line 2094 "structure_model.c"
	}
#line 432 "structure_model.vala"
	result = NULL;
#line 432 "structure_model.vala"
	return result;
#line 2100 "structure_model.c"
}


void
structure_model_delete (StructureModel* self,
                        GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
#line 435 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 435 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 437 "structure_model.vala"
	_tmp0_ = *iter;
#line 437 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 439 "structure_model.vala"
	_tmp1_ = *iter;
#line 439 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 439 "structure_model.vala"
	node = _tmp2_;
#line 440 "structure_model.vala"
	_tmp3_ = structure_model_delete_node (self, node);
#line 440 "structure_model.vala"
	_tmp4_ = _tmp3_;
#line 440 "structure_model.vala"
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_node_destroy__struct_data_free0_ (_tmp4_), NULL));
#line 441 "structure_model.vala"
	self->priv->_end_node = NULL;
#line 442 "structure_model.vala"
	structure_model_regenerate_simple_lists (self);
#line 2138 "structure_model.c"
}


void
structure_model_modify_data (StructureModel* self,
                             GtkTreePath* path,
                             const gchar* text,
                             GtkTextMark* end_mark)
{
	GtkTreeIter iter = {0};
	gboolean iter_is_valid = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean _tmp2_;
	GNode* node = NULL;
	GtkTreeIter _tmp3_;
	GNode* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GNode* _tmp6_;
	gconstpointer _tmp7_;
	gchar* _tmp8_;
	GNode* _tmp9_;
	gconstpointer _tmp10_;
	GtkTextMark* _tmp11_;
	gboolean _tmp12_;
	GNode* _tmp14_;
#line 445 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 445 "structure_model.vala"
	g_return_if_fail (path != NULL);
#line 445 "structure_model.vala"
	g_return_if_fail (end_mark != NULL);
#line 448 "structure_model.vala"
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
#line 448 "structure_model.vala"
	iter = _tmp0_;
#line 448 "structure_model.vala"
	iter_is_valid = _tmp1_;
#line 449 "structure_model.vala"
	_tmp2_ = iter_is_valid;
#line 449 "structure_model.vala"
	g_return_if_fail (_tmp2_);
#line 451 "structure_model.vala"
	_tmp3_ = iter;
#line 451 "structure_model.vala"
	_tmp4_ = structure_model_get_node_from_iter (self, &_tmp3_);
#line 451 "structure_model.vala"
	node = _tmp4_;
#line 454 "structure_model.vala"
	structure_model_new_stamp (self);
#line 455 "structure_model.vala"
	_tmp5_ = text;
#line 455 "structure_model.vala"
	if (_tmp5_ == NULL) {
#line 455 "structure_model.vala"
		_tmp5_ = "";
#line 2195 "structure_model.c"
	}
#line 455 "structure_model.vala"
	_tmp6_ = node;
#line 455 "structure_model.vala"
	_tmp7_ = _tmp6_->data;
#line 455 "structure_model.vala"
	_tmp8_ = g_strdup (_tmp5_);
#line 455 "structure_model.vala"
	_g_free0 ((*((StructData*) _tmp7_)).text);
#line 455 "structure_model.vala"
	(*((StructData*) _tmp7_)).text = _tmp8_;
#line 456 "structure_model.vala"
	_tmp9_ = node;
#line 456 "structure_model.vala"
	_tmp10_ = _tmp9_->data;
#line 456 "structure_model.vala"
	_tmp11_ = _g_object_ref0 (end_mark);
#line 456 "structure_model.vala"
	_g_object_unref0 ((*((StructData*) _tmp10_)).end_mark);
#line 456 "structure_model.vala"
	(*((StructData*) _tmp10_)).end_mark = _tmp11_;
#line 458 "structure_model.vala"
	_tmp12_ = self->priv->_emit_signals;
#line 458 "structure_model.vala"
	if (_tmp12_) {
#line 2221 "structure_model.c"
		GtkTreeIter _tmp13_;
#line 459 "structure_model.vala"
		_tmp13_ = iter;
#line 459 "structure_model.vala"
		gtk_tree_model_row_changed ((GtkTreeModel*) self, path, &_tmp13_);
#line 2227 "structure_model.c"
	}
#line 461 "structure_model.vala"
	_tmp14_ = node;
#line 461 "structure_model.vala"
	structure_model_make_children_between_marks (self, _tmp14_);
#line 2233 "structure_model.c"
}


void
structure_model_shift_right (StructureModel* self,
                             GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	gboolean _tmp6_ = FALSE;
	StructType _tmp7_;
	StructType new_type = 0;
	StructType _tmp9_;
	GNode* new_parent = NULL;
	GNode* _tmp10_;
	GNode* _tmp11_;
	gint new_pos = 0;
	gboolean _tmp12_ = FALSE;
	GNode* _tmp13_;
	GNode* node_unlinked = NULL;
	GNode* _tmp22_;
	GNode* _tmp23_;
	GNode* _tmp24_;
	GNode* _tmp25_;
	gint _tmp26_;
	GNode* _tmp27_;
	GNode* _tmp28_;
	GNode* _tmp29_;
#line 464 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 464 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 466 "structure_model.vala"
	_tmp0_ = *iter;
#line 466 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 468 "structure_model.vala"
	_tmp1_ = *iter;
#line 468 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 468 "structure_model.vala"
	node = _tmp2_;
#line 469 "structure_model.vala"
	_tmp3_ = node;
#line 469 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 469 "structure_model.vala"
	_tmp5_ = (*((StructData*) _tmp4_)).type;
#line 469 "structure_model.vala"
	type = _tmp5_;
#line 470 "structure_model.vala"
	_tmp7_ = type;
#line 470 "structure_model.vala"
	if (structure_is_section (_tmp7_)) {
#line 2294 "structure_model.c"
		StructType _tmp8_;
#line 470 "structure_model.vala"
		_tmp8_ = type;
#line 470 "structure_model.vala"
		_tmp6_ = _tmp8_ != STRUCT_TYPE_SUBPARAGRAPH;
#line 2300 "structure_model.c"
	} else {
#line 470 "structure_model.vala"
		_tmp6_ = FALSE;
#line 2304 "structure_model.c"
	}
#line 470 "structure_model.vala"
	g_return_if_fail (_tmp6_);
#line 472 "structure_model.vala"
	_tmp9_ = type;
#line 472 "structure_model.vala"
	new_type = _tmp9_ + 1;
#line 475 "structure_model.vala"
	_tmp10_ = node;
#line 475 "structure_model.vala"
	_tmp11_ = g_node_prev_sibling (_tmp10_);
#line 475 "structure_model.vala"
	new_parent = _tmp11_;
#line 478 "structure_model.vala"
	_tmp13_ = new_parent;
#line 478 "structure_model.vala"
	if (_tmp13_ == NULL) {
#line 478 "structure_model.vala"
		_tmp12_ = TRUE;
#line 2324 "structure_model.c"
	} else {
		StructType _tmp14_;
		GNode* _tmp15_;
		gconstpointer _tmp16_;
		StructType _tmp17_;
#line 478 "structure_model.vala"
		_tmp14_ = new_type;
#line 478 "structure_model.vala"
		_tmp15_ = new_parent;
#line 478 "structure_model.vala"
		_tmp16_ = _tmp15_->data;
#line 478 "structure_model.vala"
		_tmp17_ = (*((StructData*) _tmp16_)).type;
#line 478 "structure_model.vala"
		_tmp12_ = _tmp14_ <= _tmp17_;
#line 2340 "structure_model.c"
	}
#line 478 "structure_model.vala"
	if (_tmp12_) {
#line 2344 "structure_model.c"
		GNode* _tmp18_;
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
#line 481 "structure_model.vala"
		_tmp18_ = node;
#line 481 "structure_model.vala"
		_tmp19_ = _tmp18_->parent;
#line 481 "structure_model.vala"
		new_parent = _tmp19_;
#line 482 "structure_model.vala"
		_tmp20_ = new_parent;
#line 482 "structure_model.vala"
		_tmp21_ = node;
#line 482 "structure_model.vala"
		new_pos = g_node_child_position (_tmp20_, _tmp21_);
#line 2361 "structure_model.c"
	} else {
#line 486 "structure_model.vala"
		new_pos = -1;
#line 2365 "structure_model.c"
	}
#line 490 "structure_model.vala"
	_tmp22_ = node;
#line 490 "structure_model.vala"
	_tmp23_ = structure_model_delete_node (self, _tmp22_);
#line 490 "structure_model.vala"
	node_unlinked = _tmp23_;
#line 492 "structure_model.vala"
	_tmp24_ = node_unlinked;
#line 492 "structure_model.vala"
	structure_model_shift_node (self, _tmp24_, TRUE);
#line 494 "structure_model.vala"
	_tmp25_ = new_parent;
#line 494 "structure_model.vala"
	_tmp26_ = new_pos;
#line 494 "structure_model.vala"
	_tmp27_ = node_unlinked;
#line 494 "structure_model.vala"
	node_unlinked = NULL;
#line 494 "structure_model.vala"
	_tmp28_ = g_node_insert (_tmp25_, _tmp26_, _tmp27_);
#line 494 "structure_model.vala"
	node = _tmp28_;
#line 495 "structure_model.vala"
	_tmp29_ = node;
#line 495 "structure_model.vala"
	structure_model_reinsert_node (self, _tmp29_, FALSE);
#line 464 "structure_model.vala"
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
#line 2395 "structure_model.c"
}


void
structure_model_shift_left (StructureModel* self,
                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	gboolean _tmp6_ = FALSE;
	StructType _tmp7_;
	StructType new_type = 0;
	StructType _tmp9_;
	GNode* new_parent = NULL;
	gint new_pos = 0;
	GNode* parent = NULL;
	GNode* _tmp10_;
	GNode* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GNode* _tmp13_;
	GNode* _tmp14_;
	GNode* sibling = NULL;
	GNode* _tmp26_;
	GNode* _tmp27_;
	GNode* node_unlinked = NULL;
	GNode* _tmp28_;
	GNode* _tmp29_;
	GNode* _tmp30_;
	GNode* _tmp43_;
	gint _tmp44_;
	GNode* _tmp45_;
	GNode* _tmp46_;
	GNode* _tmp47_;
#line 498 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 498 "structure_model.vala"
	g_return_if_fail (iter != NULL);
#line 500 "structure_model.vala"
	_tmp0_ = *iter;
#line 500 "structure_model.vala"
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
#line 502 "structure_model.vala"
	_tmp1_ = *iter;
#line 502 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 502 "structure_model.vala"
	node = _tmp2_;
#line 503 "structure_model.vala"
	_tmp3_ = node;
#line 503 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 503 "structure_model.vala"
	_tmp5_ = (*((StructData*) _tmp4_)).type;
#line 503 "structure_model.vala"
	type = _tmp5_;
#line 504 "structure_model.vala"
	_tmp7_ = type;
#line 504 "structure_model.vala"
	if (STRUCT_TYPE_PART < _tmp7_) {
#line 2461 "structure_model.c"
		StructType _tmp8_;
#line 504 "structure_model.vala"
		_tmp8_ = type;
#line 504 "structure_model.vala"
		_tmp6_ = _tmp8_ <= STRUCT_TYPE_SUBPARAGRAPH;
#line 2467 "structure_model.c"
	} else {
#line 504 "structure_model.vala"
		_tmp6_ = FALSE;
#line 2471 "structure_model.c"
	}
#line 504 "structure_model.vala"
	g_return_if_fail (_tmp6_);
#line 506 "structure_model.vala"
	_tmp9_ = type;
#line 506 "structure_model.vala"
	new_type = _tmp9_ - 1;
#line 512 "structure_model.vala"
	_tmp10_ = node;
#line 512 "structure_model.vala"
	_tmp11_ = _tmp10_->parent;
#line 512 "structure_model.vala"
	parent = _tmp11_;
#line 513 "structure_model.vala"
	_tmp13_ = parent;
#line 513 "structure_model.vala"
	_tmp14_ = self->priv->_tree;
#line 513 "structure_model.vala"
	if (_tmp13_ == _tmp14_) {
#line 513 "structure_model.vala"
		_tmp12_ = TRUE;
#line 2493 "structure_model.c"
	} else {
		GNode* _tmp15_;
		gconstpointer _tmp16_;
		StructType _tmp17_;
		StructType _tmp18_;
#line 513 "structure_model.vala"
		_tmp15_ = parent;
#line 513 "structure_model.vala"
		_tmp16_ = _tmp15_->data;
#line 513 "structure_model.vala"
		_tmp17_ = (*((StructData*) _tmp16_)).type;
#line 513 "structure_model.vala"
		_tmp18_ = new_type;
#line 513 "structure_model.vala"
		_tmp12_ = _tmp17_ < _tmp18_;
#line 2509 "structure_model.c"
	}
#line 513 "structure_model.vala"
	if (_tmp12_) {
#line 2513 "structure_model.c"
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
#line 516 "structure_model.vala"
		_tmp19_ = parent;
#line 516 "structure_model.vala"
		new_parent = _tmp19_;
#line 517 "structure_model.vala"
		_tmp20_ = parent;
#line 517 "structure_model.vala"
		_tmp21_ = node;
#line 517 "structure_model.vala"
		new_pos = g_node_child_position (_tmp20_, _tmp21_);
#line 2527 "structure_model.c"
	} else {
		GNode* _tmp22_;
		GNode* _tmp23_;
		GNode* _tmp24_;
		GNode* _tmp25_;
#line 521 "structure_model.vala"
		_tmp22_ = parent;
#line 521 "structure_model.vala"
		_tmp23_ = _tmp22_->parent;
#line 521 "structure_model.vala"
		new_parent = _tmp23_;
#line 522 "structure_model.vala"
		_tmp24_ = new_parent;
#line 522 "structure_model.vala"
		_tmp25_ = parent;
#line 522 "structure_model.vala"
		new_pos = g_node_child_position (_tmp24_, _tmp25_) + 1;
#line 2545 "structure_model.c"
	}
#line 526 "structure_model.vala"
	_tmp26_ = node;
#line 526 "structure_model.vala"
	_tmp27_ = g_node_next_sibling (_tmp26_);
#line 526 "structure_model.vala"
	sibling = _tmp27_;
#line 528 "structure_model.vala"
	_tmp28_ = node;
#line 528 "structure_model.vala"
	_tmp29_ = structure_model_delete_node (self, _tmp28_);
#line 528 "structure_model.vala"
	node_unlinked = _tmp29_;
#line 529 "structure_model.vala"
	_tmp30_ = node_unlinked;
#line 529 "structure_model.vala"
	structure_model_shift_node (self, _tmp30_, FALSE);
#line 532 "structure_model.vala"
	while (TRUE) {
#line 2565 "structure_model.c"
		GNode* _tmp31_;
		GNode* _tmp32_;
		gconstpointer _tmp33_;
		StructType _tmp34_;
		StructType _tmp35_;
		GNode* next_sibling = NULL;
		GNode* _tmp36_;
		GNode* _tmp37_;
		GNode* new_child = NULL;
		GNode* _tmp38_;
		GNode* _tmp39_;
		GNode* _tmp40_;
		GNode* _tmp41_;
		GNode* _tmp42_;
#line 532 "structure_model.vala"
		_tmp31_ = sibling;
#line 532 "structure_model.vala"
		if (!(_tmp31_ != NULL)) {
#line 532 "structure_model.vala"
			break;
#line 2586 "structure_model.c"
		}
#line 534 "structure_model.vala"
		_tmp32_ = sibling;
#line 534 "structure_model.vala"
		_tmp33_ = _tmp32_->data;
#line 534 "structure_model.vala"
		_tmp34_ = (*((StructData*) _tmp33_)).type;
#line 534 "structure_model.vala"
		_tmp35_ = new_type;
#line 534 "structure_model.vala"
		if (_tmp34_ <= _tmp35_) {
#line 535 "structure_model.vala"
			break;
#line 2600 "structure_model.c"
		}
#line 537 "structure_model.vala"
		_tmp36_ = sibling;
#line 537 "structure_model.vala"
		_tmp37_ = g_node_next_sibling (_tmp36_);
#line 537 "structure_model.vala"
		next_sibling = _tmp37_;
#line 539 "structure_model.vala"
		_tmp38_ = sibling;
#line 539 "structure_model.vala"
		_tmp39_ = structure_model_delete_node (self, _tmp38_);
#line 539 "structure_model.vala"
		new_child = _tmp39_;
#line 540 "structure_model.vala"
		_tmp40_ = node_unlinked;
#line 540 "structure_model.vala"
		_tmp41_ = new_child;
#line 540 "structure_model.vala"
		new_child = NULL;
#line 540 "structure_model.vala"
		g_node_append (_tmp40_, _tmp41_);
#line 542 "structure_model.vala"
		_tmp42_ = next_sibling;
#line 542 "structure_model.vala"
		sibling = _tmp42_;
#line 532 "structure_model.vala"
		(new_child == NULL) ? NULL : (new_child = (_g_node_destroy__struct_data_free0_ (new_child), NULL));
#line 2628 "structure_model.c"
	}
#line 546 "structure_model.vala"
	_tmp43_ = new_parent;
#line 546 "structure_model.vala"
	_tmp44_ = new_pos;
#line 546 "structure_model.vala"
	_tmp45_ = node_unlinked;
#line 546 "structure_model.vala"
	node_unlinked = NULL;
#line 546 "structure_model.vala"
	_tmp46_ = g_node_insert (_tmp43_, _tmp44_, _tmp45_);
#line 546 "structure_model.vala"
	node = _tmp46_;
#line 547 "structure_model.vala"
	_tmp47_ = node;
#line 547 "structure_model.vala"
	structure_model_reinsert_node (self, _tmp47_, FALSE);
#line 498 "structure_model.vala"
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
#line 2648 "structure_model.c"
}


gboolean
structure_model_item_contains_subparagraph (StructureModel* self,
                                            GtkTreeIter* iter)
{
	gboolean result = FALSE;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
#line 550 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 550 "structure_model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 552 "structure_model.vala"
	_tmp0_ = *iter;
#line 552 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
#line 554 "structure_model.vala"
	_tmp1_ = *iter;
#line 554 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 554 "structure_model.vala"
	node = _tmp2_;
#line 555 "structure_model.vala"
	result = structure_model_node_contains_subparagraph (self, node);
#line 555 "structure_model.vala"
	return result;
#line 2679 "structure_model.c"
}


static gboolean
structure_model_node_contains_subparagraph (StructureModel* self,
                                            GNode* node)
{
	gboolean result = FALSE;
	StructType type = 0;
	gconstpointer _tmp0_;
	StructType _tmp1_;
	StructType _tmp2_;
	StructType _tmp3_;
	GNode* child = NULL;
	GNode* _tmp4_;
#line 558 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 558 "structure_model.vala"
	g_return_val_if_fail (node != NULL, FALSE);
#line 560 "structure_model.vala"
	_tmp0_ = node->data;
#line 560 "structure_model.vala"
	_tmp1_ = (*((StructData*) _tmp0_)).type;
#line 560 "structure_model.vala"
	type = _tmp1_;
#line 562 "structure_model.vala"
	_tmp2_ = type;
#line 562 "structure_model.vala"
	if (_tmp2_ == STRUCT_TYPE_SUBPARAGRAPH) {
#line 563 "structure_model.vala"
		result = TRUE;
#line 563 "structure_model.vala"
		return result;
#line 2713 "structure_model.c"
	}
#line 565 "structure_model.vala"
	_tmp3_ = type;
#line 565 "structure_model.vala"
	if (!structure_is_section (_tmp3_)) {
#line 566 "structure_model.vala"
		result = FALSE;
#line 566 "structure_model.vala"
		return result;
#line 2723 "structure_model.c"
	}
#line 568 "structure_model.vala"
	_tmp4_ = g_node_first_child (node);
#line 568 "structure_model.vala"
	child = _tmp4_;
#line 569 "structure_model.vala"
	while (TRUE) {
#line 2731 "structure_model.c"
		GNode* _tmp5_;
		GNode* _tmp6_;
		GNode* _tmp7_;
		GNode* _tmp8_;
#line 569 "structure_model.vala"
		_tmp5_ = child;
#line 569 "structure_model.vala"
		if (!(_tmp5_ != NULL)) {
#line 569 "structure_model.vala"
			break;
#line 2742 "structure_model.c"
		}
#line 571 "structure_model.vala"
		_tmp6_ = child;
#line 571 "structure_model.vala"
		if (structure_model_node_contains_subparagraph (self, _tmp6_)) {
#line 572 "structure_model.vala"
			result = TRUE;
#line 572 "structure_model.vala"
			return result;
#line 2752 "structure_model.c"
		}
#line 573 "structure_model.vala"
		_tmp7_ = child;
#line 573 "structure_model.vala"
		_tmp8_ = g_node_next_sibling (_tmp7_);
#line 573 "structure_model.vala"
		child = _tmp8_;
#line 2760 "structure_model.c"
	}
#line 576 "structure_model.vala"
	result = FALSE;
#line 576 "structure_model.vala"
	return result;
#line 2766 "structure_model.c"
}


static void
structure_model_insert_node (StructureModel* self,
                             GNode* node,
                             gboolean force_first_child)
{
	guint _tmp0_;
	gboolean _tmp1_;
	GtkTreeIter item_iter = {0};
	GtkTreeIter* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkTreePath* item_path = NULL;
	GtkTreeIter _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_;
	GNode* parent = NULL;
	GNode* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GNode* _tmp11_;
	GNode* _tmp12_;
	gboolean first_child = FALSE;
	gboolean _tmp15_ = FALSE;
#line 579 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 579 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 581 "structure_model.vala"
	structure_model_new_stamp (self);
#line 582 "structure_model.vala"
	_tmp0_ = self->priv->_nb_nodes;
#line 582 "structure_model.vala"
	self->priv->_nb_nodes = _tmp0_ + 1;
#line 584 "structure_model.vala"
	_tmp1_ = self->priv->_emit_signals;
#line 584 "structure_model.vala"
	if (!_tmp1_) {
#line 585 "structure_model.vala"
		return;
#line 2809 "structure_model.c"
	}
#line 587 "structure_model.vala"
	_tmp2_ = structure_model_create_iter_at_node (self, node);
#line 587 "structure_model.vala"
	_tmp3_ = _tmp2_;
#line 587 "structure_model.vala"
	_tmp4_ = *_tmp3_;
#line 587 "structure_model.vala"
	_g_free0 (_tmp3_);
#line 587 "structure_model.vala"
	item_iter = _tmp4_;
#line 588 "structure_model.vala"
	_tmp5_ = item_iter;
#line 588 "structure_model.vala"
	_tmp6_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp5_);
#line 588 "structure_model.vala"
	item_path = _tmp6_;
#line 589 "structure_model.vala"
	_tmp7_ = item_path;
#line 589 "structure_model.vala"
	_tmp8_ = item_iter;
#line 589 "structure_model.vala"
	gtk_tree_model_row_inserted ((GtkTreeModel*) self, _tmp7_, &_tmp8_);
#line 593 "structure_model.vala"
	_tmp9_ = node->parent;
#line 593 "structure_model.vala"
	parent = _tmp9_;
#line 594 "structure_model.vala"
	_tmp11_ = parent;
#line 594 "structure_model.vala"
	_tmp12_ = self->priv->_tree;
#line 594 "structure_model.vala"
	if (_tmp11_ != _tmp12_) {
#line 2843 "structure_model.c"
		GNode* _tmp13_;
		GNode* _tmp14_;
#line 594 "structure_model.vala"
		_tmp13_ = parent;
#line 594 "structure_model.vala"
		_tmp14_ = _tmp13_->children;
#line 594 "structure_model.vala"
		_tmp10_ = _tmp14_ == node;
#line 2852 "structure_model.c"
	} else {
#line 594 "structure_model.vala"
		_tmp10_ = FALSE;
#line 2856 "structure_model.c"
	}
#line 594 "structure_model.vala"
	first_child = _tmp10_;
#line 595 "structure_model.vala"
	if (force_first_child) {
#line 595 "structure_model.vala"
		_tmp15_ = TRUE;
#line 2864 "structure_model.c"
	} else {
		gboolean _tmp16_;
#line 595 "structure_model.vala"
		_tmp16_ = first_child;
#line 595 "structure_model.vala"
		_tmp15_ = _tmp16_;
#line 2871 "structure_model.c"
	}
#line 595 "structure_model.vala"
	if (_tmp15_) {
#line 2875 "structure_model.c"
		GtkTreeIter parent_iter = {0};
		GNode* _tmp17_;
		GtkTreeIter* _tmp18_;
		GtkTreeIter* _tmp19_;
		GtkTreeIter _tmp20_;
		GtkTreePath* parent_path = NULL;
		GtkTreeIter _tmp21_;
		GtkTreePath* _tmp22_;
		GtkTreePath* _tmp23_;
		GtkTreeIter _tmp24_;
#line 597 "structure_model.vala"
		_tmp17_ = parent;
#line 597 "structure_model.vala"
		_tmp18_ = structure_model_create_iter_at_node (self, _tmp17_);
#line 597 "structure_model.vala"
		_tmp19_ = _tmp18_;
#line 597 "structure_model.vala"
		_tmp20_ = *_tmp19_;
#line 597 "structure_model.vala"
		_g_free0 (_tmp19_);
#line 597 "structure_model.vala"
		parent_iter = _tmp20_;
#line 598 "structure_model.vala"
		_tmp21_ = parent_iter;
#line 598 "structure_model.vala"
		_tmp22_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp21_);
#line 598 "structure_model.vala"
		parent_path = _tmp22_;
#line 599 "structure_model.vala"
		_tmp23_ = parent_path;
#line 599 "structure_model.vala"
		_tmp24_ = parent_iter;
#line 599 "structure_model.vala"
		gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp23_, &_tmp24_);
#line 595 "structure_model.vala"
		__vala_GtkTreePath_free0 (parent_path);
#line 2912 "structure_model.c"
	}
#line 579 "structure_model.vala"
	__vala_GtkTreePath_free0 (item_path);
#line 2916 "structure_model.c"
}


static GNode*
g_node_unlink_vala (GNode* self)
{
	GNode* result = NULL;
	void* ptr = NULL;
	void* _tmp0_;
#line 5158 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 5160 "glib-2.0.vapi"
	ptr = self;
#line 5161 "glib-2.0.vapi"
	g_node_unlink (self);
#line 5162 "glib-2.0.vapi"
	_tmp0_ = ptr;
#line 5162 "glib-2.0.vapi"
	ptr = NULL;
#line 5162 "glib-2.0.vapi"
	result = (GNode*) _tmp0_;
#line 5162 "glib-2.0.vapi"
	return result;
#line 2940 "structure_model.c"
}


static GNode*
structure_model_delete_node (StructureModel* self,
                             GNode* node)
{
	GNode* result = NULL;
	GtkTreePath* path = NULL;
	GNode* parent = NULL;
	gboolean _tmp0_;
	GNode* node_unlinked = NULL;
	GNode* _tmp7_;
	guint _tmp8_;
	GNode* _tmp9_;
	gboolean _tmp10_;
#line 603 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 603 "structure_model.vala"
	g_return_val_if_fail (node != NULL, NULL);
#line 605 "structure_model.vala"
	structure_model_new_stamp (self);
#line 607 "structure_model.vala"
	path = NULL;
#line 608 "structure_model.vala"
	parent = NULL;
#line 609 "structure_model.vala"
	_tmp0_ = self->priv->_emit_signals;
#line 609 "structure_model.vala"
	if (_tmp0_) {
#line 2971 "structure_model.c"
		GtkTreeIter* iter = NULL;
		GtkTreeIter* _tmp1_;
		GtkTreeIter* _tmp2_;
		GtkTreeIter* _tmp3_;
		GtkTreeIter _tmp4_;
		GtkTreePath* _tmp5_;
		GNode* _tmp6_;
#line 611 "structure_model.vala"
		_tmp1_ = structure_model_create_iter_at_node (self, node);
#line 611 "structure_model.vala"
		iter = _tmp1_;
#line 612 "structure_model.vala"
		_tmp2_ = iter;
#line 612 "structure_model.vala"
		g_return_val_if_fail (_tmp2_ != NULL, NULL);
#line 614 "structure_model.vala"
		_tmp3_ = iter;
#line 614 "structure_model.vala"
		_tmp4_ = *_tmp3_;
#line 614 "structure_model.vala"
		_tmp5_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp4_);
#line 614 "structure_model.vala"
		__vala_GtkTreePath_free0 (path);
#line 614 "structure_model.vala"
		path = _tmp5_;
#line 615 "structure_model.vala"
		_tmp6_ = node->parent;
#line 615 "structure_model.vala"
		parent = _tmp6_;
#line 609 "structure_model.vala"
		_g_free0 (iter);
#line 3003 "structure_model.c"
	}
#line 618 "structure_model.vala"
	_tmp7_ = g_node_unlink_vala (node);
#line 618 "structure_model.vala"
	node_unlinked = _tmp7_;
#line 619 "structure_model.vala"
	_tmp8_ = self->priv->_nb_nodes;
#line 619 "structure_model.vala"
	_tmp9_ = node_unlinked;
#line 619 "structure_model.vala"
	self->priv->_nb_nodes = _tmp8_ - g_node_n_nodes (_tmp9_, G_TRAVERSE_ALL);
#line 621 "structure_model.vala"
	_tmp10_ = self->priv->_emit_signals;
#line 621 "structure_model.vala"
	if (_tmp10_) {
#line 3019 "structure_model.c"
		GtkTreePath* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GNode* _tmp13_;
		GNode* _tmp14_;
#line 623 "structure_model.vala"
		_tmp11_ = path;
#line 623 "structure_model.vala"
		gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp11_);
#line 625 "structure_model.vala"
		_tmp13_ = parent;
#line 625 "structure_model.vala"
		_tmp14_ = self->priv->_tree;
#line 625 "structure_model.vala"
		if (_tmp13_ != _tmp14_) {
#line 3034 "structure_model.c"
			GNode* _tmp15_;
			GNode* _tmp16_;
#line 625 "structure_model.vala"
			_tmp15_ = parent;
#line 625 "structure_model.vala"
			_tmp16_ = _tmp15_->children;
#line 625 "structure_model.vala"
			_tmp12_ = _tmp16_ == NULL;
#line 3043 "structure_model.c"
		} else {
#line 625 "structure_model.vala"
			_tmp12_ = FALSE;
#line 3047 "structure_model.c"
		}
#line 625 "structure_model.vala"
		if (_tmp12_) {
#line 3051 "structure_model.c"
			GtkTreeIter parent_iter = {0};
			GNode* _tmp17_;
			GtkTreeIter* _tmp18_;
			GtkTreeIter* _tmp19_;
			GtkTreeIter _tmp20_;
			GtkTreePath* parent_path = NULL;
			GtkTreeIter _tmp21_;
			GtkTreePath* _tmp22_;
			GtkTreePath* _tmp23_;
			GtkTreeIter _tmp24_;
#line 627 "structure_model.vala"
			_tmp17_ = parent;
#line 627 "structure_model.vala"
			_tmp18_ = structure_model_create_iter_at_node (self, _tmp17_);
#line 627 "structure_model.vala"
			_tmp19_ = _tmp18_;
#line 627 "structure_model.vala"
			_tmp20_ = *_tmp19_;
#line 627 "structure_model.vala"
			_g_free0 (_tmp19_);
#line 627 "structure_model.vala"
			parent_iter = _tmp20_;
#line 628 "structure_model.vala"
			_tmp21_ = parent_iter;
#line 628 "structure_model.vala"
			_tmp22_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp21_);
#line 628 "structure_model.vala"
			parent_path = _tmp22_;
#line 629 "structure_model.vala"
			_tmp23_ = parent_path;
#line 629 "structure_model.vala"
			_tmp24_ = parent_iter;
#line 629 "structure_model.vala"
			gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp23_, &_tmp24_);
#line 625 "structure_model.vala"
			__vala_GtkTreePath_free0 (parent_path);
#line 3088 "structure_model.c"
		}
	}
#line 633 "structure_model.vala"
	result = node_unlinked;
#line 633 "structure_model.vala"
	__vala_GtkTreePath_free0 (path);
#line 633 "structure_model.vala"
	return result;
#line 3097 "structure_model.c"
}


static void
structure_model_shift_node (StructureModel* self,
                            GNode* node,
                            gboolean shift_right)
{
	gconstpointer _tmp0_;
	StructType _tmp1_;
	GNode* child = NULL;
	GNode* _tmp12_;
#line 636 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 636 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 638 "structure_model.vala"
	_tmp0_ = node->data;
#line 638 "structure_model.vala"
	_tmp1_ = (*((StructData*) _tmp0_)).type;
#line 638 "structure_model.vala"
	if (!structure_is_section (_tmp1_)) {
#line 639 "structure_model.vala"
		return;
#line 3122 "structure_model.c"
	}
#line 641 "structure_model.vala"
	if (shift_right) {
#line 3126 "structure_model.c"
		gconstpointer _tmp2_;
		StructType _tmp3_;
#line 643 "structure_model.vala"
		_tmp2_ = node->data;
#line 643 "structure_model.vala"
		_tmp3_ = (*((StructData*) _tmp2_)).type;
#line 643 "structure_model.vala"
		if (_tmp3_ != STRUCT_TYPE_SUBPARAGRAPH) {
#line 3135 "structure_model.c"
			gconstpointer _tmp4_;
			gconstpointer _tmp5_;
			StructType _tmp6_;
#line 644 "structure_model.vala"
			_tmp4_ = node->data;
#line 644 "structure_model.vala"
			_tmp5_ = node->data;
#line 644 "structure_model.vala"
			_tmp6_ = (*((StructData*) _tmp5_)).type;
#line 644 "structure_model.vala"
			(*((StructData*) _tmp5_)).type = _tmp6_ + 1;
#line 3147 "structure_model.c"
		}
	} else {
		gconstpointer _tmp7_;
		StructType _tmp8_;
#line 646 "structure_model.vala"
		_tmp7_ = node->data;
#line 646 "structure_model.vala"
		_tmp8_ = (*((StructData*) _tmp7_)).type;
#line 646 "structure_model.vala"
		if (_tmp8_ != STRUCT_TYPE_PART) {
#line 3158 "structure_model.c"
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			StructType _tmp11_;
#line 647 "structure_model.vala"
			_tmp9_ = node->data;
#line 647 "structure_model.vala"
			_tmp10_ = node->data;
#line 647 "structure_model.vala"
			_tmp11_ = (*((StructData*) _tmp10_)).type;
#line 647 "structure_model.vala"
			(*((StructData*) _tmp10_)).type = _tmp11_ - 1;
#line 3170 "structure_model.c"
		}
	}
#line 649 "structure_model.vala"
	_tmp12_ = g_node_first_child (node);
#line 649 "structure_model.vala"
	child = _tmp12_;
#line 650 "structure_model.vala"
	while (TRUE) {
#line 3179 "structure_model.c"
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
		GNode* _tmp16_;
#line 650 "structure_model.vala"
		_tmp13_ = child;
#line 650 "structure_model.vala"
		if (!(_tmp13_ != NULL)) {
#line 650 "structure_model.vala"
			break;
#line 3190 "structure_model.c"
		}
#line 652 "structure_model.vala"
		_tmp14_ = child;
#line 652 "structure_model.vala"
		structure_model_shift_node (self, _tmp14_, shift_right);
#line 653 "structure_model.vala"
		_tmp15_ = child;
#line 653 "structure_model.vala"
		_tmp16_ = g_node_next_sibling (_tmp15_);
#line 653 "structure_model.vala"
		child = _tmp16_;
#line 3202 "structure_model.c"
	}
}


static void
structure_model_reinsert_node (StructureModel* self,
                               GNode* node,
                               gboolean force_first_child)
{
	GNode* child = NULL;
	GNode* _tmp0_;
	gboolean first_child = FALSE;
#line 657 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 657 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 659 "structure_model.vala"
	structure_model_insert_node (self, node, force_first_child);
#line 661 "structure_model.vala"
	_tmp0_ = g_node_first_child (node);
#line 661 "structure_model.vala"
	child = _tmp0_;
#line 662 "structure_model.vala"
	first_child = TRUE;
#line 664 "structure_model.vala"
	while (TRUE) {
#line 3229 "structure_model.c"
		GNode* _tmp1_;
		GNode* _tmp2_;
		gboolean _tmp3_;
		GNode* _tmp4_;
		GNode* _tmp5_;
#line 664 "structure_model.vala"
		_tmp1_ = child;
#line 664 "structure_model.vala"
		if (!(_tmp1_ != NULL)) {
#line 664 "structure_model.vala"
			break;
#line 3241 "structure_model.c"
		}
#line 666 "structure_model.vala"
		_tmp2_ = child;
#line 666 "structure_model.vala"
		_tmp3_ = first_child;
#line 666 "structure_model.vala"
		structure_model_reinsert_node (self, _tmp2_, _tmp3_);
#line 667 "structure_model.vala"
		_tmp4_ = child;
#line 667 "structure_model.vala"
		_tmp5_ = g_node_next_sibling (_tmp4_);
#line 667 "structure_model.vala"
		child = _tmp5_;
#line 668 "structure_model.vala"
		first_child = FALSE;
#line 3257 "structure_model.c"
	}
}


static GtkTreeIter*
structure_model_insert_item_after (StructureModel* self,
                                   GNode* parent,
                                   GNode* sibling,
                                   StructData* item)
{
	GtkTreeIter* result = NULL;
	StructData _tmp0_;
	const gchar* _tmp1_;
	GNode* new_node = NULL;
	StructData _tmp2_;
	StructData _tmp3_;
	StructData* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
#line 672 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 672 "structure_model.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 672 "structure_model.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 675 "structure_model.vala"
	_tmp0_ = *item;
#line 675 "structure_model.vala"
	_tmp1_ = _tmp0_.text;
#line 675 "structure_model.vala"
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
#line 677 "structure_model.vala"
	_tmp2_ = *item;
#line 677 "structure_model.vala"
	_tmp3_ = _tmp2_;
#line 677 "structure_model.vala"
	_tmp4_ = _struct_data_dup0 (&_tmp3_);
#line 677 "structure_model.vala"
	_tmp5_ = g_node_new (_tmp4_);
#line 677 "structure_model.vala"
	_tmp6_ = g_node_insert_after (parent, sibling, _tmp5_);
#line 677 "structure_model.vala"
	new_node = _tmp6_;
#line 680 "structure_model.vala"
	structure_model_insert_node (self, new_node, FALSE);
#line 681 "structure_model.vala"
	structure_model_insert_node_in_list (self, new_node);
#line 683 "structure_model.vala"
	_tmp7_ = structure_model_create_iter_at_node (self, new_node);
#line 683 "structure_model.vala"
	result = _tmp7_;
#line 683 "structure_model.vala"
	return result;
#line 3312 "structure_model.c"
}


static void
structure_model_make_children_between_marks (StructureModel* self,
                                             GNode* node)
{
	StructData data = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_ = {0};
	StructData _tmp2_;
	GtkTextMark* _tmp3_;
	GNode* sibling = NULL;
	GNode* _tmp4_;
#line 686 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 686 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 688 "structure_model.vala"
	_tmp0_ = node->data;
#line 688 "structure_model.vala"
	struct_data_copy ((StructData*) _tmp0_, &_tmp1_);
#line 688 "structure_model.vala"
	data = _tmp1_;
#line 689 "structure_model.vala"
	_tmp2_ = data;
#line 689 "structure_model.vala"
	_tmp3_ = _tmp2_.end_mark;
#line 689 "structure_model.vala"
	if (_tmp3_ == NULL) {
#line 690 "structure_model.vala"
		struct_data_destroy (&data);
#line 690 "structure_model.vala"
		return;
#line 3347 "structure_model.c"
	}
#line 692 "structure_model.vala"
	_tmp4_ = g_node_next_sibling (node);
#line 692 "structure_model.vala"
	sibling = _tmp4_;
#line 693 "structure_model.vala"
	while (TRUE) {
#line 3355 "structure_model.c"
		GNode* _tmp5_;
		StructData sibling_data = {0};
		GNode* _tmp6_;
		gconstpointer _tmp7_;
		StructData _tmp8_ = {0};
		StructData _tmp9_;
		StructType _tmp10_;
		StructData _tmp11_;
		GtkTextMark* _tmp12_;
		StructData _tmp13_;
		GtkTextMark* _tmp14_;
		GNode* sibling_unlinked = NULL;
		GNode* _tmp15_;
		GNode* _tmp16_;
		GNode* new_child = NULL;
		GNode* _tmp17_;
		GNode* _tmp18_;
		GNode* _tmp19_;
		GNode* _tmp20_;
#line 693 "structure_model.vala"
		_tmp5_ = sibling;
#line 693 "structure_model.vala"
		if (!(_tmp5_ != NULL)) {
#line 693 "structure_model.vala"
			break;
#line 3381 "structure_model.c"
		}
#line 695 "structure_model.vala"
		_tmp6_ = sibling;
#line 695 "structure_model.vala"
		_tmp7_ = _tmp6_->data;
#line 695 "structure_model.vala"
		struct_data_copy ((StructData*) _tmp7_, &_tmp8_);
#line 695 "structure_model.vala"
		sibling_data = _tmp8_;
#line 697 "structure_model.vala"
		_tmp9_ = sibling_data;
#line 697 "structure_model.vala"
		_tmp10_ = _tmp9_.type;
#line 697 "structure_model.vala"
		if (structure_is_section (_tmp10_)) {
#line 698 "structure_model.vala"
			struct_data_destroy (&sibling_data);
#line 698 "structure_model.vala"
			break;
#line 3401 "structure_model.c"
		}
#line 701 "structure_model.vala"
		_tmp11_ = data;
#line 701 "structure_model.vala"
		_tmp12_ = _tmp11_.end_mark;
#line 701 "structure_model.vala"
		_tmp13_ = sibling_data;
#line 701 "structure_model.vala"
		_tmp14_ = _tmp13_.start_mark;
#line 701 "structure_model.vala"
		if (structure_model_compare_nodes (_tmp12_, _tmp14_) <= 0) {
#line 702 "structure_model.vala"
			struct_data_destroy (&sibling_data);
#line 702 "structure_model.vala"
			break;
#line 3417 "structure_model.c"
		}
#line 705 "structure_model.vala"
		_tmp15_ = sibling;
#line 705 "structure_model.vala"
		_tmp16_ = structure_model_delete_node (self, _tmp15_);
#line 705 "structure_model.vala"
		sibling_unlinked = _tmp16_;
#line 708 "structure_model.vala"
		_tmp17_ = sibling_unlinked;
#line 708 "structure_model.vala"
		sibling_unlinked = NULL;
#line 708 "structure_model.vala"
		_tmp18_ = g_node_append (node, _tmp17_);
#line 708 "structure_model.vala"
		new_child = _tmp18_;
#line 709 "structure_model.vala"
		_tmp19_ = new_child;
#line 709 "structure_model.vala"
		structure_model_insert_node (self, _tmp19_, FALSE);
#line 711 "structure_model.vala"
		_tmp20_ = g_node_next_sibling (node);
#line 711 "structure_model.vala"
		sibling = _tmp20_;
#line 693 "structure_model.vala"
		(sibling_unlinked == NULL) ? NULL : (sibling_unlinked = (_g_node_destroy__struct_data_free0_ (sibling_unlinked), NULL));
#line 693 "structure_model.vala"
		struct_data_destroy (&sibling_data);
#line 3445 "structure_model.c"
	}
#line 686 "structure_model.vala"
	struct_data_destroy (&data);
#line 3449 "structure_model.c"
}


static void
structure_model_search_end_node (StructureModel* self)
{
	GNode* _tmp0_;
#line 715 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 717 "structure_model.vala"
	_tmp0_ = self->priv->_tree;
#line 717 "structure_model.vala"
	self->priv->_end_node = _tmp0_;
#line 718 "structure_model.vala"
	while (TRUE) {
#line 3465 "structure_model.c"
		GNode* _tmp1_;
		GNode* _tmp2_;
		GNode* _tmp3_;
#line 718 "structure_model.vala"
		_tmp1_ = self->priv->_end_node;
#line 718 "structure_model.vala"
		if (!(!G_NODE_IS_LEAF (_tmp1_))) {
#line 718 "structure_model.vala"
			break;
#line 3475 "structure_model.c"
		}
#line 719 "structure_model.vala"
		_tmp2_ = self->priv->_end_node;
#line 719 "structure_model.vala"
		_tmp3_ = g_node_last_child (_tmp2_);
#line 719 "structure_model.vala"
		self->priv->_end_node = _tmp3_;
#line 3483 "structure_model.c"
	}
}


static gint
structure_model_compare_nodes (GtkTextMark* mark1,
                               GtkTextMark* mark2)
{
	gint result = 0;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter iter1 = {0};
	GtkTextIter iter2 = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
#line 726 "structure_model.vala"
	g_return_val_if_fail (mark1 != NULL, 0);
#line 726 "structure_model.vala"
	g_return_val_if_fail (mark2 != NULL, 0);
#line 728 "structure_model.vala"
	_tmp0_ = gtk_text_mark_get_buffer (mark1);
#line 728 "structure_model.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 728 "structure_model.vala"
	doc = _tmp1_;
#line 730 "structure_model.vala"
	_tmp2_ = gtk_text_mark_get_buffer (mark2);
#line 730 "structure_model.vala"
	g_return_val_if_fail (doc == _tmp2_, 0);
#line 735 "structure_model.vala"
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp3_, mark1);
#line 735 "structure_model.vala"
	iter1 = _tmp3_;
#line 736 "structure_model.vala"
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp4_, mark2);
#line 736 "structure_model.vala"
	iter2 = _tmp4_;
#line 738 "structure_model.vala"
	_tmp5_ = iter2;
#line 738 "structure_model.vala"
	result = gtk_text_iter_compare (&iter1, &_tmp5_);
#line 738 "structure_model.vala"
	_g_object_unref0 (doc);
#line 738 "structure_model.vala"
	return result;
#line 3532 "structure_model.c"
}


/*************************************************************************/
void
structure_model_populate_list (StructureModel* self,
                               GtkListStore* store,
                               StructType type)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 745 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 745 "structure_model.vala"
	g_return_if_fail (store != NULL);
#line 747 "structure_model.vala"
	_tmp0_ = structure_model_get_list (self, type);
#line 747 "structure_model.vala"
	list = _tmp0_;
#line 748 "structure_model.vala"
	_tmp1_ = list;
#line 748 "structure_model.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 3557 "structure_model.c"
	{
		GeeArrayList* _node_list = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _node_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _node_index = 0;
#line 750 "structure_model.vala"
		_tmp2_ = list;
#line 750 "structure_model.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 750 "structure_model.vala"
		_node_list = _tmp3_;
#line 750 "structure_model.vala"
		_tmp4_ = _node_list;
#line 750 "structure_model.vala"
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
#line 750 "structure_model.vala"
		_tmp6_ = _tmp5_;
#line 750 "structure_model.vala"
		_node_size = _tmp6_;
#line 750 "structure_model.vala"
		_node_index = -1;
#line 750 "structure_model.vala"
		while (TRUE) {
#line 3585 "structure_model.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GNode* node = NULL;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			StructData data = {0};
			GNode* _tmp13_;
			gconstpointer _tmp14_;
			StructData _tmp15_ = {0};
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp16_ = {0};
			GtkTreeIter _tmp17_;
			StructData _tmp18_;
			StructType _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			StructData _tmp22_;
			const gchar* _tmp23_;
			StructData _tmp24_;
			StructType _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
#line 750 "structure_model.vala"
			_tmp7_ = _node_index;
#line 750 "structure_model.vala"
			_node_index = _tmp7_ + 1;
#line 750 "structure_model.vala"
			_tmp8_ = _node_index;
#line 750 "structure_model.vala"
			_tmp9_ = _node_size;
#line 750 "structure_model.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 750 "structure_model.vala"
				break;
#line 3622 "structure_model.c"
			}
#line 750 "structure_model.vala"
			_tmp10_ = _node_list;
#line 750 "structure_model.vala"
			_tmp11_ = _node_index;
#line 750 "structure_model.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 750 "structure_model.vala"
			node = (GNode*) _tmp12_;
#line 752 "structure_model.vala"
			_tmp13_ = node;
#line 752 "structure_model.vala"
			_tmp14_ = _tmp13_->data;
#line 752 "structure_model.vala"
			struct_data_copy ((StructData*) _tmp14_, &_tmp15_);
#line 752 "structure_model.vala"
			data = _tmp15_;
#line 755 "structure_model.vala"
			gtk_list_store_append (store, &_tmp16_);
#line 755 "structure_model.vala"
			iter = _tmp16_;
#line 756 "structure_model.vala"
			_tmp17_ = iter;
#line 756 "structure_model.vala"
			_tmp18_ = data;
#line 756 "structure_model.vala"
			_tmp19_ = _tmp18_.type;
#line 756 "structure_model.vala"
			_tmp20_ = structure_get_icon_from_type (_tmp19_);
#line 756 "structure_model.vala"
			_tmp21_ = _tmp20_;
#line 756 "structure_model.vala"
			_tmp22_ = data;
#line 756 "structure_model.vala"
			_tmp23_ = _tmp22_.text;
#line 756 "structure_model.vala"
			_tmp24_ = data;
#line 756 "structure_model.vala"
			_tmp25_ = _tmp24_.type;
#line 756 "structure_model.vala"
			_tmp26_ = structure_get_type_name (_tmp25_);
#line 756 "structure_model.vala"
			_tmp27_ = _tmp26_;
#line 756 "structure_model.vala"
			gtk_list_store_set (store, &_tmp17_, STRUCT_LIST_COLUMN_PIXBUF, _tmp21_, STRUCT_LIST_COLUMN_TEXT, _tmp23_, STRUCT_LIST_COLUMN_TOOLTIP, _tmp27_, -1);
#line 756 "structure_model.vala"
			_g_free0 (_tmp27_);
#line 756 "structure_model.vala"
			_g_free0 (_tmp21_);
#line 750 "structure_model.vala"
			struct_data_destroy (&data);
#line 3674 "structure_model.c"
		}
#line 750 "structure_model.vala"
		_g_object_unref0 (_node_list);
#line 3678 "structure_model.c"
	}
#line 745 "structure_model.vala"
	_g_object_unref0 (list);
#line 3682 "structure_model.c"
}


GtkTreePath*
structure_model_get_tree_path_from_list_num (StructureModel* self,
                                             StructType list_type,
                                             gint num)
{
	GtkTreePath* result = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	GtkTreeIter* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter _tmp10_;
	GtkTreePath* _tmp11_;
	GtkTreePath* _tmp12_;
#line 764 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 766 "structure_model.vala"
	_tmp0_ = structure_model_get_list (self, list_type);
#line 766 "structure_model.vala"
	list = _tmp0_;
#line 767 "structure_model.vala"
	_tmp1_ = list;
#line 767 "structure_model.vala"
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
#line 769 "structure_model.vala"
	if (0 <= num) {
#line 3715 "structure_model.c"
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 769 "structure_model.vala"
		_tmp3_ = list;
#line 769 "structure_model.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 769 "structure_model.vala"
		_tmp5_ = _tmp4_;
#line 769 "structure_model.vala"
		_tmp2_ = num < _tmp5_;
#line 3727 "structure_model.c"
	} else {
#line 769 "structure_model.vala"
		_tmp2_ = FALSE;
#line 3731 "structure_model.c"
	}
#line 769 "structure_model.vala"
	g_return_val_if_fail (_tmp2_, NULL);
#line 771 "structure_model.vala"
	_tmp6_ = list;
#line 771 "structure_model.vala"
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, num);
#line 771 "structure_model.vala"
	_tmp8_ = structure_model_create_iter_at_node (self, (GNode*) _tmp7_);
#line 771 "structure_model.vala"
	_tmp9_ = _tmp8_;
#line 771 "structure_model.vala"
	_tmp10_ = *_tmp9_;
#line 771 "structure_model.vala"
	_tmp11_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp10_);
#line 771 "structure_model.vala"
	_tmp12_ = _tmp11_;
#line 771 "structure_model.vala"
	_g_free0 (_tmp9_);
#line 771 "structure_model.vala"
	result = _tmp12_;
#line 771 "structure_model.vala"
	_g_object_unref0 (list);
#line 771 "structure_model.vala"
	return result;
#line 3757 "structure_model.c"
}


gint
structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                             GtkTreeIter* tree_iter)
{
	gint result = 0;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GeeArrayList* list = NULL;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
#line 775 "structure_model.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 775 "structure_model.vala"
	g_return_val_if_fail (tree_iter != NULL, 0);
#line 777 "structure_model.vala"
	_tmp0_ = *tree_iter;
#line 777 "structure_model.vala"
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), -1);
#line 779 "structure_model.vala"
	_tmp1_ = *tree_iter;
#line 779 "structure_model.vala"
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
#line 779 "structure_model.vala"
	node = _tmp2_;
#line 781 "structure_model.vala"
	_tmp3_ = node;
#line 781 "structure_model.vala"
	_tmp4_ = _tmp3_->data;
#line 781 "structure_model.vala"
	_tmp5_ = (*((StructData*) _tmp4_)).type;
#line 781 "structure_model.vala"
	_tmp6_ = structure_model_get_list (self, _tmp5_);
#line 781 "structure_model.vala"
	list = _tmp6_;
#line 782 "structure_model.vala"
	_tmp7_ = list;
#line 782 "structure_model.vala"
	g_return_val_if_fail (_tmp7_ != NULL, -1);
#line 3804 "structure_model.c"
	{
		gint num = 0;
#line 784 "structure_model.vala"
		num = 0;
#line 3809 "structure_model.c"
		{
			gboolean _tmp8_ = FALSE;
#line 784 "structure_model.vala"
			_tmp8_ = TRUE;
#line 784 "structure_model.vala"
			while (TRUE) {
#line 3816 "structure_model.c"
				gint _tmp10_;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gpointer _tmp16_;
				GNode* _tmp17_;
#line 784 "structure_model.vala"
				if (!_tmp8_) {
#line 3827 "structure_model.c"
					gint _tmp9_;
#line 784 "structure_model.vala"
					_tmp9_ = num;
#line 784 "structure_model.vala"
					num = _tmp9_ + 1;
#line 3833 "structure_model.c"
				}
#line 784 "structure_model.vala"
				_tmp8_ = FALSE;
#line 784 "structure_model.vala"
				_tmp10_ = num;
#line 784 "structure_model.vala"
				_tmp11_ = list;
#line 784 "structure_model.vala"
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
#line 784 "structure_model.vala"
				_tmp13_ = _tmp12_;
#line 784 "structure_model.vala"
				if (!(_tmp10_ < _tmp13_)) {
#line 784 "structure_model.vala"
					break;
#line 3849 "structure_model.c"
				}
#line 786 "structure_model.vala"
				_tmp14_ = list;
#line 786 "structure_model.vala"
				_tmp15_ = num;
#line 786 "structure_model.vala"
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
#line 786 "structure_model.vala"
				_tmp17_ = node;
#line 786 "structure_model.vala"
				if (((GNode*) _tmp16_) == _tmp17_) {
#line 787 "structure_model.vala"
					result = num;
#line 787 "structure_model.vala"
					_g_object_unref0 (list);
#line 787 "structure_model.vala"
					return result;
#line 3867 "structure_model.c"
				}
			}
		}
	}
#line 790 "structure_model.vala"
	g_return_val_if_reached (-1);
#line 775 "structure_model.vala"
	_g_object_unref0 (list);
#line 3876 "structure_model.c"
}


static void
structure_model_insert_node_in_list (StructureModel* self,
                                     GNode* node)
{
	StructData item = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_ = {0};
	GeeArrayList* list = NULL;
	StructData _tmp2_;
	StructType _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
#line 793 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 793 "structure_model.vala"
	g_return_if_fail (node != NULL);
#line 795 "structure_model.vala"
	_tmp0_ = node->data;
#line 795 "structure_model.vala"
	struct_data_copy ((StructData*) _tmp0_, &_tmp1_);
#line 795 "structure_model.vala"
	item = _tmp1_;
#line 797 "structure_model.vala"
	_tmp2_ = item;
#line 797 "structure_model.vala"
	_tmp3_ = _tmp2_.type;
#line 797 "structure_model.vala"
	_tmp4_ = structure_model_get_list (self, _tmp3_);
#line 797 "structure_model.vala"
	list = _tmp4_;
#line 798 "structure_model.vala"
	_tmp5_ = list;
#line 798 "structure_model.vala"
	if (_tmp5_ != NULL) {
#line 3914 "structure_model.c"
		GeeArrayList* _tmp6_;
#line 799 "structure_model.vala"
		_tmp6_ = list;
#line 799 "structure_model.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, node);
#line 3920 "structure_model.c"
	}
#line 793 "structure_model.vala"
	_g_object_unref0 (list);
#line 793 "structure_model.vala"
	struct_data_destroy (&item);
#line 3926 "structure_model.c"
}


static gboolean
__lambda42_ (StructureModel* self,
             GNode* node)
{
	gboolean result = FALSE;
#line 806 "structure_model.vala"
	g_return_val_if_fail (node != NULL, FALSE);
#line 808 "structure_model.vala"
	structure_model_insert_node_in_list (self, node);
#line 811 "structure_model.vala"
	result = FALSE;
#line 811 "structure_model.vala"
	return result;
#line 3943 "structure_model.c"
}


static gboolean
___lambda42__gnode_traverse_func (GNode* node,
                                  gpointer self)
{
	gboolean result;
	result = __lambda42_ ((StructureModel*) self, node);
#line 806 "structure_model.vala"
	return result;
#line 3955 "structure_model.c"
}


static void
structure_model_regenerate_simple_lists (StructureModel* self)
{
	GNode* _tmp0_;
#line 802 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 804 "structure_model.vala"
	structure_model_reset_simple_lists (self);
#line 806 "structure_model.vala"
	_tmp0_ = self->priv->_tree;
#line 806 "structure_model.vala"
	g_node_traverse (_tmp0_, G_PRE_ORDER, G_TRAVERSE_ALL, -1, ___lambda42__gnode_traverse_func, self);
#line 3971 "structure_model.c"
}


static void
structure_model_reset_simple_lists (StructureModel* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
#line 815 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 817 "structure_model.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 817 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_labels);
#line 817 "structure_model.vala"
	self->priv->_list_labels = _tmp0_;
#line 818 "structure_model.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 818 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_includes);
#line 818 "structure_model.vala"
	self->priv->_list_includes = _tmp1_;
#line 819 "structure_model.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 819 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_tables);
#line 819 "structure_model.vala"
	self->priv->_list_tables = _tmp2_;
#line 820 "structure_model.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 820 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_figures);
#line 820 "structure_model.vala"
	self->priv->_list_figures = _tmp3_;
#line 821 "structure_model.vala"
	_tmp4_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
#line 821 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
#line 821 "structure_model.vala"
	self->priv->_list_todos_and_fixmes = _tmp4_;
#line 4015 "structure_model.c"
}


static GeeArrayList*
structure_model_get_list (StructureModel* self,
                          StructType type)
{
	GeeArrayList* result = NULL;
#line 824 "structure_model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 826 "structure_model.vala"
	if (structure_is_section (type)) {
#line 827 "structure_model.vala"
		result = NULL;
#line 827 "structure_model.vala"
		return result;
#line 4032 "structure_model.c"
	}
#line 829 "structure_model.vala"
	switch (type) {
#line 829 "structure_model.vala"
		case STRUCT_TYPE_LABEL:
#line 4038 "structure_model.c"
		{
			GeeArrayList* _tmp0_;
			GeeArrayList* _tmp1_;
#line 832 "structure_model.vala"
			_tmp0_ = self->priv->_list_labels;
#line 832 "structure_model.vala"
			_tmp1_ = _g_object_ref0 (_tmp0_);
#line 832 "structure_model.vala"
			result = _tmp1_;
#line 832 "structure_model.vala"
			return result;
#line 4050 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_INCLUDE:
#line 4054 "structure_model.c"
		{
			GeeArrayList* _tmp2_;
			GeeArrayList* _tmp3_;
#line 835 "structure_model.vala"
			_tmp2_ = self->priv->_list_includes;
#line 835 "structure_model.vala"
			_tmp3_ = _g_object_ref0 (_tmp2_);
#line 835 "structure_model.vala"
			result = _tmp3_;
#line 835 "structure_model.vala"
			return result;
#line 4066 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_TABLE:
#line 4070 "structure_model.c"
		{
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
#line 838 "structure_model.vala"
			_tmp4_ = self->priv->_list_tables;
#line 838 "structure_model.vala"
			_tmp5_ = _g_object_ref0 (_tmp4_);
#line 838 "structure_model.vala"
			result = _tmp5_;
#line 838 "structure_model.vala"
			return result;
#line 4082 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_FIGURE:
#line 829 "structure_model.vala"
		case STRUCT_TYPE_IMAGE:
#line 4088 "structure_model.c"
		{
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
#line 842 "structure_model.vala"
			_tmp6_ = self->priv->_list_figures;
#line 842 "structure_model.vala"
			_tmp7_ = _g_object_ref0 (_tmp6_);
#line 842 "structure_model.vala"
			result = _tmp7_;
#line 842 "structure_model.vala"
			return result;
#line 4100 "structure_model.c"
		}
#line 829 "structure_model.vala"
		case STRUCT_TYPE_TODO:
#line 829 "structure_model.vala"
		case STRUCT_TYPE_FIXME:
#line 4106 "structure_model.c"
		{
			GeeArrayList* _tmp8_;
			GeeArrayList* _tmp9_;
#line 846 "structure_model.vala"
			_tmp8_ = self->priv->_list_todos_and_fixmes;
#line 846 "structure_model.vala"
			_tmp9_ = _g_object_ref0 (_tmp8_);
#line 846 "structure_model.vala"
			result = _tmp9_;
#line 846 "structure_model.vala"
			return result;
#line 4118 "structure_model.c"
		}
		default:
		{
#line 849 "structure_model.vala"
			result = NULL;
#line 849 "structure_model.vala"
			return result;
#line 4126 "structure_model.c"
		}
	}
}


gboolean
structure_model_get_emit_signals (StructureModel* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 75 "structure_model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 75 "structure_model.vala"
	_tmp0_ = self->priv->_emit_signals;
#line 75 "structure_model.vala"
	result = _tmp0_;
#line 75 "structure_model.vala"
	return result;
#line 4145 "structure_model.c"
}


void
structure_model_set_emit_signals (StructureModel* self,
                                  gboolean value)
{
#line 75 "structure_model.vala"
	g_return_if_fail (self != NULL);
#line 75 "structure_model.vala"
	if (structure_model_get_emit_signals (self) != value) {
#line 75 "structure_model.vala"
		self->priv->_emit_signals = value;
#line 75 "structure_model.vala"
		g_object_notify_by_pspec ((GObject *) self, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY]);
#line 4161 "structure_model.c"
	}
}


static void
structure_model_class_init (StructureModelClass * klass)
{
#line 70 "structure_model.vala"
	structure_model_parent_class = g_type_class_peek_parent (klass);
#line 70 "structure_model.vala"
	g_type_class_adjust_private_offset (klass, &StructureModel_private_offset);
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_structure_model_get_property;
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_structure_model_set_property;
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (klass)->finalize = structure_model_finalize;
#line 70 "structure_model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY] = g_param_spec_boolean ("emit-signals", "emit-signals", "emit-signals", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4181 "structure_model.c"
}


static void
structure_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface)
{
#line 70 "structure_model.vala"
	structure_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
#line 70 "structure_model.vala"
	iface->get_column_type = (GType (*) (GtkTreeModel *, gint)) structure_model_real_get_column_type;
#line 70 "structure_model.vala"
	iface->get_n_columns = (gint (*) (GtkTreeModel *)) structure_model_real_get_n_columns;
#line 70 "structure_model.vala"
	iface->get_flags = (GtkTreeModelFlags (*) (GtkTreeModel *)) structure_model_real_get_flags;
#line 70 "structure_model.vala"
	iface->iter_has_child = (gboolean (*) (GtkTreeModel *, GtkTreeIter*)) structure_model_real_iter_has_child;
#line 70 "structure_model.vala"
	iface->iter_n_children = (gint (*) (GtkTreeModel *, GtkTreeIter*)) structure_model_real_iter_n_children;
#line 70 "structure_model.vala"
	iface->get_value = (void (*) (GtkTreeModel *, GtkTreeIter*, gint, GValue*)) structure_model_real_get_value;
#line 70 "structure_model.vala"
	iface->iter_children = (gboolean (*) (GtkTreeModel *, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_children;
#line 70 "structure_model.vala"
	iface->iter_next = (gboolean (*) (GtkTreeModel *, GtkTreeIter*)) structure_model_real_iter_next;
#line 70 "structure_model.vala"
	iface->iter_nth_child = (gboolean (*) (GtkTreeModel *, GtkTreeIter*, GtkTreeIter*, gint)) structure_model_real_iter_nth_child;
#line 70 "structure_model.vala"
	iface->iter_parent = (gboolean (*) (GtkTreeModel *, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_parent;
#line 70 "structure_model.vala"
	iface->get_iter = (gboolean (*) (GtkTreeModel *, GtkTreeIter*, GtkTreePath*)) structure_model_real_get_iter;
#line 70 "structure_model.vala"
	iface->get_path = (GtkTreePath* (*) (GtkTreeModel *, GtkTreeIter*)) structure_model_real_get_path;
#line 4214 "structure_model.c"
}


static void
structure_model_instance_init (StructureModel * self)
{
#line 70 "structure_model.vala"
	self->priv = structure_model_get_instance_private (self);
#line 75 "structure_model.vala"
	self->priv->_emit_signals = FALSE;
#line 80 "structure_model.vala"
	self->priv->_nb_nodes = (guint) 0;
#line 81 "structure_model.vala"
	self->priv->_end_node = NULL;
#line 4229 "structure_model.c"
}


static void
structure_model_finalize (GObject * obj)
{
	StructureModel * self;
#line 70 "structure_model.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRUCTURE_MODEL, StructureModel);
#line 77 "structure_model.vala"
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
#line 78 "structure_model.vala"
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
#line 83 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_labels);
#line 84 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_includes);
#line 85 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_tables);
#line 86 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_figures);
#line 87 "structure_model.vala"
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
#line 70 "structure_model.vala"
	G_OBJECT_CLASS (structure_model_parent_class)->finalize (obj);
#line 4255 "structure_model.c"
}


GType
structure_model_get_type (void)
{
	static volatile gsize structure_model_type_id__volatile = 0;
	if (g_once_init_enter (&structure_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StructureModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StructureModel), 0, (GInstanceInitFunc) structure_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) structure_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType structure_model_type_id;
		structure_model_type_id = g_type_register_static (G_TYPE_OBJECT, "StructureModel", &g_define_type_info, 0);
		StructureModel_private_offset = g_type_add_instance_private (structure_model_type_id, sizeof (StructureModelPrivate));
		g_type_add_interface_static (structure_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
		g_once_init_leave (&structure_model_type_id__volatile, structure_model_type_id);
	}
	return structure_model_type_id__volatile;
}


static void
_vala_structure_model_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
#line 70 "structure_model.vala"
	switch (property_id) {
#line 70 "structure_model.vala"
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
#line 70 "structure_model.vala"
		g_value_set_boolean (value, structure_model_get_emit_signals (self));
#line 70 "structure_model.vala"
		break;
#line 4292 "structure_model.c"
		default:
#line 70 "structure_model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "structure_model.vala"
		break;
#line 4298 "structure_model.c"
	}
}


static void
_vala_structure_model_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
#line 70 "structure_model.vala"
	switch (property_id) {
#line 70 "structure_model.vala"
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
#line 70 "structure_model.vala"
		structure_model_set_emit_signals (self, g_value_get_boolean (value));
#line 70 "structure_model.vala"
		break;
#line 4319 "structure_model.c"
		default:
#line 70 "structure_model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "structure_model.vala"
		break;
#line 4325 "structure_model.c"
	}
}



