/* structure.c generated by valac 0.40.0.227-717ea, the Vala compiler
 * generated from structure.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <latexila.h>


#define TYPE_STRUCT_TYPE (struct_type_get_type ())

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;
typedef struct _StructurePrivate StructurePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
enum  {
	STRUCTURE_0_PROPERTY,
	STRUCTURE_NUM_PROPERTIES
};
static GParamSpec* structure_properties[STRUCTURE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block31Data Block31Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
enum  {
	STRUCTURE_NO_ITEMS_SELECTED_SIGNAL,
	STRUCTURE_ITEM_SELECTED_SIGNAL,
	STRUCTURE_SHOW_POPUP_MENU_SIGNAL,
	STRUCTURE_NUM_SIGNALS
};
static guint structure_signals[STRUCTURE_NUM_SIGNALS] = {0};

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

struct _Structure {
	GtkGrid parent_instance;
	StructurePrivate * priv;
};

struct _StructureClass {
	GtkGridClass parent_class;
};

struct _StructurePrivate {
	MainWindow* _main_window;
	GtkToggleToolButton** _simple_list_buttons;
	gint _simple_list_buttons_length1;
	gint __simple_list_buttons_size_;
	GtkPaned* _vpaned;
	GtkTreeView* _tree_view;
	DocumentStructure* _document_structure;
	StructureModel* _model;
	GtkTreeView* _list_view;
	GtkScrolledWindow* _list_view_sw;
	GtkListStore* _list_store;
	StructType _current_list_type;
	gboolean _list_is_hidden;
	gboolean _first_select;
};

struct _Block31Data {
	int _ref_count_;
	Structure* self;
	GtkToggleToolButton* button;
	StructType type;
};

typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()

static gint Structure_private_offset;
static gpointer structure_parent_class = NULL;
static gchar** structure__icons;
static gint structure__icons_length1;
static gchar** structure__icons = NULL;
static gint structure__icons_length1 = 0;
static gint _structure__icons_size_ = 0;
static gchar** structure__names;
static gint structure__names_length1;
static gchar** structure__names = NULL;
static gint structure__names_length1 = 0;
static gint _structure__names_size_ = 0;
static gchar** structure__action_names;
static gint structure__action_names_length1;
static gchar** structure__action_names = NULL;
static gint structure__action_names_length1 = 0;
static gint _structure__action_names_size_ = 0;

GType struct_type_get_type (void) G_GNUC_CONST;
GType struct_action_get_type (void) G_GNUC_CONST;
GType structure_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType document_structure_get_type (void) G_GNUC_CONST;
GType structure_model_get_type (void) G_GNUC_CONST;
Structure* structure_new (MainWindow* main_window);
Structure* structure_construct (GType object_type,
                                MainWindow* main_window);
static void structure_init_toolbar (Structure* self);
static void structure_init_vpaned (Structure* self);
static void structure_init_list_view (Structure* self);
static void structure_init_tree_view (Structure* self);
void structure_connect_parsing (Structure* self);
static void _structure_connect_parsing_gtk_widget_show (GtkWidget* _sender,
                                                 gpointer self);
void structure_disconnect_parsing (Structure* self);
static void _structure_disconnect_parsing_gtk_widget_hide (GtkWidget* _sender,
                                                    gpointer self);
void structure_refresh (Structure* self);
GType document_get_type (void) G_GNUC_CONST;
static void structure_show_document (Structure* self,
                              Document* doc,
                              gboolean force_parse);
Document* main_window_get_active_document (MainWindow* self);
static GtkToolButton* structure_get_refresh_button (Structure* self);
static GtkToolButton* structure_get_collapse_all_button (Structure* self);
static void structure_init_simple_list_buttons (Structure* self);
static void __lambda5_ (Structure* self);
static void ___lambda5__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
static void __lambda7_ (Structure* self);
static void ___lambda7__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
static GtkToggleToolButton* structure_create_simple_list_button (Structure* self,
                                                          StructType type,
                                                          const gchar* tooltip);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
gchar* structure_get_icon_from_type (StructType type);
static void _vala_array_add7 (GtkToggleToolButton** * array,
                       int* length,
                       int* size,
                       GtkToggleToolButton* value);
static void __lambda8_ (Block31Data* _data31_);
static void structure_populate_simple_list (Structure* self);
static void ___lambda8__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
void structure_model_populate_list (StructureModel* self,
                                    GtkListStore* store,
                                    StructType type);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void structure_select_simple_list_item (Structure* self,
                                        GtkTreeIter* tree_iter);
void structure_save_state (Structure* self);
static GtkTreeView* structure_get_new_tree_view (Structure* self,
                                          gint pixbuf_col,
                                          gint text_col,
                                          gint tooltip_col);
GType struct_list_column_get_type (void) G_GNUC_CONST;
static gboolean __lambda9_ (Structure* self,
                     GtkTreeSelection* select,
                     GtkTreeModel* model,
                     GtkTreePath* path,
                     gboolean path_currently_selected);
static gboolean structure_select_list_row (Structure* self,
                                    GtkTreePath* list_path);
static gboolean ___lambda9__gtk_tree_selection_func (GtkTreeSelection* selection,
                                              GtkTreeModel* model,
                                              GtkTreePath* path,
                                              gboolean path_currently_selected,
                                              gpointer self);
static void __lambda10_ (Structure* self,
                  GtkTreePath* path);
static void ___lambda10__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
GType struct_column_get_type (void) G_GNUC_CONST;
static gboolean __lambda11_ (Structure* self,
                      GtkTreeSelection* select,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      gboolean path_currently_selected);
static gboolean structure_select_tree_row (Structure* self,
                                    GtkTreePath* tree_path);
static gboolean ___lambda11__gtk_tree_selection_func (GtkTreeSelection* selection,
                                               GtkTreeModel* model,
                                               GtkTreePath* path,
                                               gboolean path_currently_selected,
                                               gpointer self);
static void __lambda12_ (Structure* self,
                  GtkTreePath* path);
static void ___lambda12__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
static gboolean __lambda13_ (Structure* self,
                      GdkEventButton* event);
static gboolean ___lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda14_ (Structure* self);
static gboolean ___lambda14__gtk_widget_popup_menu (GtkWidget* _sender,
                                             gpointer self);
GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self,
                                                          StructType list_type,
                                                          gint num);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
static GeeArrayList* structure_get_simple_list_types (Structure* self,
                                               StructType type);
gint structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                                  GtkTreeIter* tree_iter);
gboolean structure_is_section (StructType type);
static void structure_show_active_document (Structure* self);
static void structure_set_model (Structure* self,
                          StructureModel* model);
static void structure_on_parsing_done (Structure* self);
static void _structure_on_parsing_done_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self);
DocumentStructure* document_get_structure (Document* self);
void document_structure_parse (DocumentStructure* self);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
StructureModel* document_structure_get_model (DocumentStructure* self);
void structure_model_set_emit_signals (StructureModel* self,
                                       gboolean value);
guint structure_model_get_nb_items (StructureModel* self);
static void _structure_show_active_document_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
gboolean structure_is_common_type (StructType type);
void structure_do_action (Structure* self,
                          StructAction action_type);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void structure_open_referenced_file (Structure* self,
                                     GtkTreeIter* iter);
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self,
                                   StructAction action_type,
                                   GtkTreeIter* tree_iter,
                                   gboolean* refresh_simple_list,
                                   GError** error);
static gchar* structure_get_action_name (StructAction action_type);
GFile* document_get_location (Document* self);
static void structure_open_included_file (Structure* self,
                                   GFile* referenced_file);
static void structure_open_image (Structure* self,
                           GFile* referenced_file);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
gchar* structure_get_type_name (StructType type);
static void structure_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GType
struct_type_get_type (void)
{
	static volatile gsize struct_type_type_id__volatile = 0;
	if (g_once_init_enter (&struct_type_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_TYPE_BEGIN_COMMON_TYPES, "STRUCT_TYPE_BEGIN_COMMON_TYPES", "begin-common-types"}, {STRUCT_TYPE_PART, "STRUCT_TYPE_PART", "part"}, {STRUCT_TYPE_CHAPTER, "STRUCT_TYPE_CHAPTER", "chapter"}, {STRUCT_TYPE_SECTION, "STRUCT_TYPE_SECTION", "section"}, {STRUCT_TYPE_SUBSECTION, "STRUCT_TYPE_SUBSECTION", "subsection"}, {STRUCT_TYPE_SUBSUBSECTION, "STRUCT_TYPE_SUBSUBSECTION", "subsubsection"}, {STRUCT_TYPE_PARAGRAPH, "STRUCT_TYPE_PARAGRAPH", "paragraph"}, {STRUCT_TYPE_SUBPARAGRAPH, "STRUCT_TYPE_SUBPARAGRAPH", "subparagraph"}, {STRUCT_TYPE_LABEL, "STRUCT_TYPE_LABEL", "label"}, {STRUCT_TYPE_INCLUDE, "STRUCT_TYPE_INCLUDE", "include"}, {STRUCT_TYPE_IMAGE, "STRUCT_TYPE_IMAGE", "image"}, {STRUCT_TYPE_TODO, "STRUCT_TYPE_TODO", "todo"}, {STRUCT_TYPE_FIXME, "STRUCT_TYPE_FIXME", "fixme"}, {STRUCT_TYPE_END_COMMON_TYPES, "STRUCT_TYPE_END_COMMON_TYPES", "end-common-types"}, {STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES, "STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES", "begin-low-level-types"}, {STRUCT_TYPE_BEGIN_FIGURE, "STRUCT_TYPE_BEGIN_FIGURE", "begin-figure"}, {STRUCT_TYPE_END_FIGURE, "STRUCT_TYPE_END_FIGURE", "end-figure"}, {STRUCT_TYPE_BEGIN_TABLE, "STRUCT_TYPE_BEGIN_TABLE", "begin-table"}, {STRUCT_TYPE_END_TABLE, "STRUCT_TYPE_END_TABLE", "end-table"}, {STRUCT_TYPE_BEGIN_VERBATIM, "STRUCT_TYPE_BEGIN_VERBATIM", "begin-verbatim"}, {STRUCT_TYPE_END_VERBATIM, "STRUCT_TYPE_END_VERBATIM", "end-verbatim"}, {STRUCT_TYPE_END_DOCUMENT, "STRUCT_TYPE_END_DOCUMENT", "end-document"}, {STRUCT_TYPE_CAPTION, "STRUCT_TYPE_CAPTION", "caption"}, {STRUCT_TYPE_END_LOW_LEVEL_TYPES, "STRUCT_TYPE_END_LOW_LEVEL_TYPES", "end-low-level-types"}, {STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES, "STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES", "begin-high-level-types"}, {STRUCT_TYPE_TABLE, "STRUCT_TYPE_TABLE", "table"}, {STRUCT_TYPE_FIGURE, "STRUCT_TYPE_FIGURE", "figure"}, {STRUCT_TYPE_END_HIGH_LEVEL_TYPES, "STRUCT_TYPE_END_HIGH_LEVEL_TYPES", "end-high-level-types"}, {STRUCT_TYPE_NB_TYPES, "STRUCT_TYPE_NB_TYPES", "nb-types"}, {0, NULL, NULL}};
		GType struct_type_type_id;
		struct_type_type_id = g_enum_register_static ("StructType", values);
		g_once_init_leave (&struct_type_type_id__volatile, struct_type_type_id);
	}
	return struct_type_type_id__volatile;
}


GType
struct_action_get_type (void)
{
	static volatile gsize struct_action_type_id__volatile = 0;
	if (g_once_init_enter (&struct_action_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_ACTION_CUT, "STRUCT_ACTION_CUT", "cut"}, {STRUCT_ACTION_COPY, "STRUCT_ACTION_COPY", "copy"}, {STRUCT_ACTION_DELETE, "STRUCT_ACTION_DELETE", "delete"}, {STRUCT_ACTION_SELECT, "STRUCT_ACTION_SELECT", "select"}, {STRUCT_ACTION_COMMENT, "STRUCT_ACTION_COMMENT", "comment"}, {STRUCT_ACTION_SHIFT_LEFT, "STRUCT_ACTION_SHIFT_LEFT", "shift-left"}, {STRUCT_ACTION_SHIFT_RIGHT, "STRUCT_ACTION_SHIFT_RIGHT", "shift-right"}, {STRUCT_ACTION_OPEN_FILE, "STRUCT_ACTION_OPEN_FILE", "open-file"}, {STRUCT_ACTION_NB_ACTIONS, "STRUCT_ACTION_NB_ACTIONS", "nb-actions"}, {0, NULL, NULL}};
		GType struct_action_type_id;
		struct_action_type_id = g_enum_register_static ("StructAction", values);
		g_once_init_leave (&struct_action_type_id__volatile, struct_action_type_id);
	}
	return struct_action_type_id__volatile;
}


static inline gpointer
structure_get_instance_private (Structure* self)
{
	return G_STRUCT_MEMBER_P (self, Structure_private_offset);
}


static void
_structure_connect_parsing_gtk_widget_show (GtkWidget* _sender,
                                            gpointer self)
{
#line 133 "structure.vala"
	structure_connect_parsing ((Structure*) self);
#line 464 "structure.c"
}


static void
_structure_disconnect_parsing_gtk_widget_hide (GtkWidget* _sender,
                                               gpointer self)
{
#line 134 "structure.vala"
	structure_disconnect_parsing ((Structure*) self);
#line 474 "structure.c"
}


Structure*
structure_construct (GType object_type,
                     MainWindow* main_window)
{
	Structure * self = NULL;
	GtkScrolledWindow* _tmp0_;
#line 121 "structure.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 121 "structure.vala"
	self = (Structure*) g_object_new (object_type, NULL);
#line 123 "structure.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
#line 124 "structure.vala"
	self->priv->_main_window = main_window;
#line 126 "structure.vala"
	structure_init_toolbar (self);
#line 127 "structure.vala"
	structure_init_vpaned (self);
#line 128 "structure.vala"
	structure_init_list_view (self);
#line 129 "structure.vala"
	structure_init_tree_view (self);
#line 130 "structure.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 131 "structure.vala"
	_tmp0_ = self->priv->_list_view_sw;
#line 131 "structure.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 133 "structure.vala"
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _structure_connect_parsing_gtk_widget_show, self, 0);
#line 134 "structure.vala"
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) _structure_disconnect_parsing_gtk_widget_hide, self, 0);
#line 121 "structure.vala"
	return self;
#line 512 "structure.c"
}


Structure*
structure_new (MainWindow* main_window)
{
#line 121 "structure.vala"
	return structure_construct (TYPE_STRUCTURE, main_window);
#line 521 "structure.c"
}


void
structure_refresh (Structure* self)
{
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
#line 137 "structure.vala"
	g_return_if_fail (self != NULL);
#line 139 "structure.vala"
	_tmp0_ = self->priv->_main_window;
#line 139 "structure.vala"
	_tmp1_ = main_window_get_active_document (_tmp0_);
#line 139 "structure.vala"
	_tmp2_ = _tmp1_;
#line 139 "structure.vala"
	structure_show_document (self, _tmp2_, TRUE);
#line 541 "structure.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 156 "structure.vala"
	return self ? g_object_ref (self) : NULL;
#line 550 "structure.c"
}


static void
structure_init_toolbar (Structure* self)
{
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp0_;
	GtkToolbar* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolbar* _tmp3_;
	GtkToolbar* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	GtkToolbar* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolbar* _tmp10_;
	GtkSeparatorToolItem* _tmp11_;
	GtkSeparatorToolItem* _tmp12_;
	GtkToggleToolButton** _tmp13_;
	gint _tmp13__length1;
#line 142 "structure.vala"
	g_return_if_fail (self != NULL);
#line 144 "structure.vala"
	_tmp0_ = (GtkToolbar*) gtk_toolbar_new ();
#line 144 "structure.vala"
	g_object_ref_sink (_tmp0_);
#line 144 "structure.vala"
	toolbar = _tmp0_;
#line 145 "structure.vala"
	_tmp1_ = toolbar;
#line 145 "structure.vala"
	gtk_toolbar_set_icon_size (_tmp1_, GTK_ICON_SIZE_MENU);
#line 146 "structure.vala"
	_tmp2_ = toolbar;
#line 146 "structure.vala"
	gtk_toolbar_set_style (_tmp2_, GTK_TOOLBAR_ICONS);
#line 147 "structure.vala"
	_tmp3_ = toolbar;
#line 147 "structure.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
#line 149 "structure.vala"
	_tmp4_ = toolbar;
#line 149 "structure.vala"
	_tmp5_ = structure_get_refresh_button (self);
#line 149 "structure.vala"
	_tmp6_ = _tmp5_;
#line 149 "structure.vala"
	gtk_toolbar_insert (_tmp4_, (GtkToolItem*) _tmp6_, -1);
#line 149 "structure.vala"
	_g_object_unref0 (_tmp6_);
#line 150 "structure.vala"
	_tmp7_ = toolbar;
#line 150 "structure.vala"
	_tmp8_ = structure_get_collapse_all_button (self);
#line 150 "structure.vala"
	_tmp9_ = _tmp8_;
#line 150 "structure.vala"
	gtk_toolbar_insert (_tmp7_, (GtkToolItem*) _tmp9_, -1);
#line 150 "structure.vala"
	_g_object_unref0 (_tmp9_);
#line 152 "structure.vala"
	_tmp10_ = toolbar;
#line 152 "structure.vala"
	_tmp11_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
#line 152 "structure.vala"
	g_object_ref_sink (_tmp11_);
#line 152 "structure.vala"
	_tmp12_ = _tmp11_;
#line 152 "structure.vala"
	gtk_toolbar_insert (_tmp10_, (GtkToolItem*) _tmp12_, -1);
#line 152 "structure.vala"
	_g_object_unref0 (_tmp12_);
#line 154 "structure.vala"
	structure_init_simple_list_buttons (self);
#line 156 "structure.vala"
	_tmp13_ = self->priv->_simple_list_buttons;
#line 156 "structure.vala"
	_tmp13__length1 = self->priv->_simple_list_buttons_length1;
#line 631 "structure.c"
	{
		GtkToggleToolButton** simple_list_button_collection = NULL;
		gint simple_list_button_collection_length1 = 0;
		gint _simple_list_button_collection_size_ = 0;
		gint simple_list_button_it = 0;
#line 156 "structure.vala"
		simple_list_button_collection = _tmp13_;
#line 156 "structure.vala"
		simple_list_button_collection_length1 = _tmp13__length1;
#line 156 "structure.vala"
		for (simple_list_button_it = 0; simple_list_button_it < _tmp13__length1; simple_list_button_it = simple_list_button_it + 1) {
#line 643 "structure.c"
			GtkToggleToolButton* _tmp14_;
			GtkToggleToolButton* simple_list_button = NULL;
#line 156 "structure.vala"
			_tmp14_ = _g_object_ref0 (simple_list_button_collection[simple_list_button_it]);
#line 156 "structure.vala"
			simple_list_button = _tmp14_;
#line 650 "structure.c"
			{
				GtkToolbar* _tmp15_;
				GtkToggleToolButton* _tmp16_;
#line 157 "structure.vala"
				_tmp15_ = toolbar;
#line 157 "structure.vala"
				_tmp16_ = simple_list_button;
#line 157 "structure.vala"
				gtk_toolbar_insert (_tmp15_, (GtkToolItem*) _tmp16_, -1);
#line 156 "structure.vala"
				_g_object_unref0 (simple_list_button);
#line 662 "structure.c"
			}
		}
	}
#line 142 "structure.vala"
	_g_object_unref0 (toolbar);
#line 668 "structure.c"
}


static void
__lambda5_ (Structure* self)
{
#line 169 "structure.vala"
	structure_refresh (self);
#line 677 "structure.c"
}


static void
___lambda5__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
#line 167 "structure.vala"
	__lambda5_ ((Structure*) self);
#line 687 "structure.c"
}


static GtkToolButton*
structure_get_refresh_button (Structure* self)
{
	GtkToolButton* result = NULL;
	GtkToolButton* refresh_button = NULL;
	GtkToolButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 160 "structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "structure.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 162 "structure.vala"
	g_object_ref_sink (_tmp0_);
#line 162 "structure.vala"
	refresh_button = _tmp0_;
#line 163 "structure.vala"
	gtk_tool_button_set_icon_name (refresh_button, "view-refresh");
#line 164 "structure.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) refresh_button, _ ("Refresh"));
#line 165 "structure.vala"
	_tmp1_ = gtk_widget_get_tooltip_text ((GtkWidget*) refresh_button);
#line 165 "structure.vala"
	_tmp2_ = _tmp1_;
#line 165 "structure.vala"
	_tmp3_ = _tmp2_;
#line 165 "structure.vala"
	gtk_tool_button_set_label (refresh_button, _tmp3_);
#line 165 "structure.vala"
	_g_free0 (_tmp3_);
#line 167 "structure.vala"
	g_signal_connect_object (refresh_button, "clicked", (GCallback) ___lambda5__gtk_tool_button_clicked, self, 0);
#line 172 "structure.vala"
	result = refresh_button;
#line 172 "structure.vala"
	return result;
#line 728 "structure.c"
}


static void
__lambda7_ (Structure* self)
{
	GtkTreeView* _tmp0_;
#line 182 "structure.vala"
	_tmp0_ = self->priv->_tree_view;
#line 182 "structure.vala"
	gtk_tree_view_collapse_all (_tmp0_);
#line 740 "structure.c"
}


static void
___lambda7__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
#line 182 "structure.vala"
	__lambda7_ ((Structure*) self);
#line 750 "structure.c"
}


static GtkToolButton*
structure_get_collapse_all_button (Structure* self)
{
	GtkToolButton* result = NULL;
	GtkToolButton* collapse_button = NULL;
	GtkToolButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 175 "structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 177 "structure.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 177 "structure.vala"
	g_object_ref_sink (_tmp0_);
#line 177 "structure.vala"
	collapse_button = _tmp0_;
#line 178 "structure.vala"
	gtk_tool_button_set_icon_name (collapse_button, "zoom-out");
#line 179 "structure.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) collapse_button, _ ("Collapse All"));
#line 180 "structure.vala"
	_tmp1_ = gtk_widget_get_tooltip_text ((GtkWidget*) collapse_button);
#line 180 "structure.vala"
	_tmp2_ = _tmp1_;
#line 180 "structure.vala"
	_tmp3_ = _tmp2_;
#line 180 "structure.vala"
	gtk_tool_button_set_label (collapse_button, _tmp3_);
#line 180 "structure.vala"
	_g_free0 (_tmp3_);
#line 182 "structure.vala"
	g_signal_connect_object (collapse_button, "clicked", (GCallback) ___lambda7__gtk_tool_button_clicked, self, 0);
#line 184 "structure.vala"
	result = collapse_button;
#line 184 "structure.vala"
	return result;
#line 791 "structure.c"
}


static void
structure_init_simple_list_buttons (Structure* self)
{
	GtkToggleToolButton* _tmp0_;
	GtkToggleToolButton* _tmp1_;
	GtkToggleToolButton* _tmp2_;
	GtkToggleToolButton* _tmp3_;
	GtkToggleToolButton* _tmp4_;
	GtkToggleToolButton* _tmp5_;
	GtkToggleToolButton* _tmp6_;
	GtkToggleToolButton* _tmp7_;
	GtkToggleToolButton* _tmp8_;
	GtkToggleToolButton* _tmp9_;
#line 187 "structure.vala"
	g_return_if_fail (self != NULL);
#line 189 "structure.vala"
	_tmp0_ = structure_create_simple_list_button (self, STRUCT_TYPE_LABEL, _ ("Show labels"));
#line 189 "structure.vala"
	_tmp1_ = _tmp0_;
#line 189 "structure.vala"
	_g_object_unref0 (_tmp1_);
#line 190 "structure.vala"
	_tmp2_ = structure_create_simple_list_button (self, STRUCT_TYPE_INCLUDE, _ ("Show included files"));
#line 190 "structure.vala"
	_tmp3_ = _tmp2_;
#line 190 "structure.vala"
	_g_object_unref0 (_tmp3_);
#line 191 "structure.vala"
	_tmp4_ = structure_create_simple_list_button (self, STRUCT_TYPE_TABLE, _ ("Show tables"));
#line 191 "structure.vala"
	_tmp5_ = _tmp4_;
#line 191 "structure.vala"
	_g_object_unref0 (_tmp5_);
#line 192 "structure.vala"
	_tmp6_ = structure_create_simple_list_button (self, STRUCT_TYPE_FIGURE, _ ("Show figures and images"));
#line 192 "structure.vala"
	_tmp7_ = _tmp6_;
#line 192 "structure.vala"
	_g_object_unref0 (_tmp7_);
#line 195 "structure.vala"
	_tmp8_ = structure_create_simple_list_button (self, STRUCT_TYPE_TODO, _ ("Show TODOs and FIXMEs"));
#line 195 "structure.vala"
	_tmp9_ = _tmp8_;
#line 195 "structure.vala"
	_g_object_unref0 (_tmp9_);
#line 840 "structure.c"
}


static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
#line 201 "structure.vala"
	g_atomic_int_inc (&_data31_->_ref_count_);
#line 201 "structure.vala"
	return _data31_;
#line 851 "structure.c"
}


static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
#line 201 "structure.vala"
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
#line 862 "structure.c"
		Structure* self;
#line 201 "structure.vala"
		self = _data31_->self;
#line 201 "structure.vala"
		_g_object_unref0 (_data31_->button);
#line 201 "structure.vala"
		g_slice_free (Block31Data, _data31_);
#line 870 "structure.c"
	}
}


static void
_vala_array_add7 (GtkToggleToolButton** * array,
                  int* length,
                  int* size,
                  GtkToggleToolButton* value)
{
#line 208 "structure.vala"
	if ((*length) == (*size)) {
#line 208 "structure.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 208 "structure.vala"
		*array = g_renew (GtkToggleToolButton*, *array, (*size) + 1);
#line 887 "structure.c"
	}
#line 208 "structure.vala"
	(*array)[(*length)++] = value;
#line 208 "structure.vala"
	(*array)[*length] = NULL;
#line 893 "structure.c"
}


static void
__lambda8_ (Block31Data* _data31_)
{
	Structure* self;
	GtkScrolledWindow* _tmp4_;
	GtkToggleToolButton** _tmp5_;
	gint _tmp5__length1;
#line 210 "structure.vala"
	self = _data31_->self;
#line 212 "structure.vala"
	if (!gtk_toggle_tool_button_get_active (_data31_->button)) {
#line 908 "structure.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
#line 214 "structure.vala"
		_tmp1_ = self->priv->_list_is_hidden;
#line 214 "structure.vala"
		if (!_tmp1_) {
#line 915 "structure.c"
			StructType _tmp2_;
#line 214 "structure.vala"
			_tmp2_ = self->priv->_current_list_type;
#line 214 "structure.vala"
			_tmp0_ = _data31_->type == _tmp2_;
#line 921 "structure.c"
		} else {
#line 214 "structure.vala"
			_tmp0_ = FALSE;
#line 925 "structure.c"
		}
#line 214 "structure.vala"
		if (_tmp0_) {
#line 929 "structure.c"
			GtkScrolledWindow* _tmp3_;
#line 216 "structure.vala"
			self->priv->_list_is_hidden = TRUE;
#line 217 "structure.vala"
			_tmp3_ = self->priv->_list_view_sw;
#line 217 "structure.vala"
			gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 937 "structure.c"
		}
#line 219 "structure.vala"
		return;
#line 941 "structure.c"
	}
#line 222 "structure.vala"
	self->priv->_current_list_type = _data31_->type;
#line 223 "structure.vala"
	self->priv->_list_is_hidden = FALSE;
#line 224 "structure.vala"
	_tmp4_ = self->priv->_list_view_sw;
#line 224 "structure.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
#line 225 "structure.vala"
	structure_populate_simple_list (self);
#line 228 "structure.vala"
	_tmp5_ = self->priv->_simple_list_buttons;
#line 228 "structure.vala"
	_tmp5__length1 = self->priv->_simple_list_buttons_length1;
#line 957 "structure.c"
	{
		GtkToggleToolButton** simple_list_button_collection = NULL;
		gint simple_list_button_collection_length1 = 0;
		gint _simple_list_button_collection_size_ = 0;
		gint simple_list_button_it = 0;
#line 228 "structure.vala"
		simple_list_button_collection = _tmp5_;
#line 228 "structure.vala"
		simple_list_button_collection_length1 = _tmp5__length1;
#line 228 "structure.vala"
		for (simple_list_button_it = 0; simple_list_button_it < _tmp5__length1; simple_list_button_it = simple_list_button_it + 1) {
#line 969 "structure.c"
			GtkToggleToolButton* _tmp6_;
			GtkToggleToolButton* simple_list_button = NULL;
#line 228 "structure.vala"
			_tmp6_ = _g_object_ref0 (simple_list_button_collection[simple_list_button_it]);
#line 228 "structure.vala"
			simple_list_button = _tmp6_;
#line 976 "structure.c"
			{
				GtkToggleToolButton* _tmp7_;
				GtkToggleToolButton* _tmp8_;
#line 230 "structure.vala"
				_tmp7_ = simple_list_button;
#line 230 "structure.vala"
				if (_tmp7_ == _data31_->button) {
#line 231 "structure.vala"
					_g_object_unref0 (simple_list_button);
#line 231 "structure.vala"
					continue;
#line 988 "structure.c"
				}
#line 233 "structure.vala"
				_tmp8_ = simple_list_button;
#line 233 "structure.vala"
				gtk_toggle_tool_button_set_active (_tmp8_, FALSE);
#line 228 "structure.vala"
				_g_object_unref0 (simple_list_button);
#line 996 "structure.c"
			}
		}
	}
}


static void
___lambda8__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
#line 210 "structure.vala"
	__lambda8_ (self);
#line 1009 "structure.c"
}


static GtkToggleToolButton*
structure_create_simple_list_button (Structure* self,
                                     StructType type,
                                     const gchar* tooltip)
{
	GtkToggleToolButton* result = NULL;
	Block31Data* _data31_;
	GtkToggleToolButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkToggleToolButton** _tmp3_;
	gint _tmp3__length1;
	GtkToggleToolButton* _tmp4_;
	GClosure* _tmp5_;
	GtkToggleToolButton* _tmp6_;
#line 201 "structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 201 "structure.vala"
	g_return_val_if_fail (tooltip != NULL, NULL);
#line 201 "structure.vala"
	_data31_ = g_slice_new0 (Block31Data);
#line 201 "structure.vala"
	_data31_->_ref_count_ = 1;
#line 201 "structure.vala"
	_data31_->self = self;
#line 201 "structure.vala"
	_data31_->type = type;
#line 203 "structure.vala"
	_tmp0_ = (GtkToggleToolButton*) gtk_toggle_tool_button_new ();
#line 203 "structure.vala"
	g_object_ref_sink (_tmp0_);
#line 203 "structure.vala"
	_data31_->button = _tmp0_;
#line 204 "structure.vala"
	_tmp1_ = structure_get_icon_from_type (_data31_->type);
#line 204 "structure.vala"
	_tmp2_ = _tmp1_;
#line 204 "structure.vala"
	gtk_tool_button_set_icon_name ((GtkToolButton*) _data31_->button, _tmp2_);
#line 204 "structure.vala"
	_g_free0 (_tmp2_);
#line 205 "structure.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _data31_->button, tooltip);
#line 206 "structure.vala"
	gtk_tool_button_set_label ((GtkToolButton*) _data31_->button, tooltip);
#line 208 "structure.vala"
	_tmp3_ = self->priv->_simple_list_buttons;
#line 208 "structure.vala"
	_tmp3__length1 = self->priv->_simple_list_buttons_length1;
#line 208 "structure.vala"
	_tmp4_ = _g_object_ref0 (_data31_->button);
#line 208 "structure.vala"
	_vala_array_add7 (&self->priv->_simple_list_buttons, &self->priv->_simple_list_buttons_length1, &self->priv->__simple_list_buttons_size_, _tmp4_);
#line 210 "structure.vala"
	_tmp5_ = g_cclosure_new ((GCallback) ___lambda8__gtk_tool_button_clicked, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref);
#line 210 "structure.vala"
	g_object_watch_closure ((GObject *) self, _tmp5_);
#line 210 "structure.vala"
	g_signal_connect_closure ((GtkToolButton*) _data31_->button, "clicked", _tmp5_, FALSE);
#line 237 "structure.vala"
	_tmp6_ = _g_object_ref0 (_data31_->button);
#line 237 "structure.vala"
	result = _tmp6_;
#line 237 "structure.vala"
	block31_data_unref (_data31_);
#line 237 "structure.vala"
	_data31_ = NULL;
#line 237 "structure.vala"
	return result;
#line 1082 "structure.c"
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 255 "structure.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1091 "structure.c"
}


static void
__vala_GtkTreePath_free0_ (gpointer var)
{
#line 255 "structure.vala"
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
#line 1100 "structure.c"
}


static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
#line 255 "structure.vala"
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
#line 1109 "structure.c"
}


static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
#line 257 "structure.vala"
	return g_boxed_copy (gtk_tree_path_get_type (), self);
#line 1118 "structure.c"
}


static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
#line 257 "structure.vala"
	return self ? _vala_GtkTreePath_copy (self) : NULL;
#line 1127 "structure.c"
}


static void
structure_populate_simple_list (Structure* self)
{
	GtkListStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	StructureModel* _tmp2_;
	StructureModel* _tmp4_;
	GtkListStore* _tmp5_;
	StructType _tmp6_;
	GtkTreeSelection* tree_select = NULL;
	GtkTreeView* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* _tmp9_;
	GList* selected_rows = NULL;
	GtkTreeSelection* _tmp10_;
	GList* _tmp11_;
	GList* _tmp12_;
	GtkTreePath* tree_path = NULL;
	GList* _tmp13_;
	gconstpointer _tmp14_;
	GtkTreePath* _tmp15_;
	GtkTreeIter tree_iter = {0};
	StructureModel* _tmp16_;
	GtkTreePath* _tmp17_;
	GtkTreeIter _tmp18_ = {0};
	gboolean _tmp19_;
	GtkTreeIter _tmp20_;
#line 240 "structure.vala"
	g_return_if_fail (self != NULL);
#line 242 "structure.vala"
	_tmp0_ = self->priv->_list_store;
#line 242 "structure.vala"
	gtk_list_store_clear (_tmp0_);
#line 244 "structure.vala"
	_tmp2_ = self->priv->_model;
#line 244 "structure.vala"
	if (_tmp2_ == NULL) {
#line 244 "structure.vala"
		_tmp1_ = TRUE;
#line 1170 "structure.c"
	} else {
		gboolean _tmp3_;
#line 244 "structure.vala"
		_tmp3_ = self->priv->_list_is_hidden;
#line 244 "structure.vala"
		_tmp1_ = _tmp3_;
#line 1177 "structure.c"
	}
#line 244 "structure.vala"
	if (_tmp1_) {
#line 245 "structure.vala"
		return;
#line 1183 "structure.c"
	}
#line 247 "structure.vala"
	_tmp4_ = self->priv->_model;
#line 247 "structure.vala"
	_tmp5_ = self->priv->_list_store;
#line 247 "structure.vala"
	_tmp6_ = self->priv->_current_list_type;
#line 247 "structure.vala"
	structure_model_populate_list (_tmp4_, _tmp5_, _tmp6_);
#line 251 "structure.vala"
	_tmp7_ = self->priv->_tree_view;
#line 251 "structure.vala"
	_tmp8_ = gtk_tree_view_get_selection (_tmp7_);
#line 251 "structure.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 251 "structure.vala"
	tree_select = _tmp9_;
#line 252 "structure.vala"
	_tmp10_ = tree_select;
#line 252 "structure.vala"
	_tmp11_ = gtk_tree_selection_get_selected_rows (_tmp10_, NULL);
#line 252 "structure.vala"
	selected_rows = _tmp11_;
#line 254 "structure.vala"
	_tmp12_ = selected_rows;
#line 254 "structure.vala"
	if (g_list_length (_tmp12_) != ((guint) 1)) {
#line 255 "structure.vala"
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 255 "structure.vala"
		_g_object_unref0 (tree_select);
#line 255 "structure.vala"
		return;
#line 1217 "structure.c"
	}
#line 257 "structure.vala"
	_tmp13_ = selected_rows;
#line 257 "structure.vala"
	_tmp14_ = g_list_nth_data (_tmp13_, (guint) 0);
#line 257 "structure.vala"
	_tmp15_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp14_);
#line 257 "structure.vala"
	tree_path = _tmp15_;
#line 259 "structure.vala"
	_tmp16_ = self->priv->_model;
#line 259 "structure.vala"
	_tmp17_ = tree_path;
#line 259 "structure.vala"
	_tmp19_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp16_, &_tmp18_, _tmp17_);
#line 259 "structure.vala"
	tree_iter = _tmp18_;
#line 259 "structure.vala"
	if (!_tmp19_) {
#line 260 "structure.vala"
		g_return_if_reached ();
#line 1239 "structure.c"
	}
#line 262 "structure.vala"
	_tmp20_ = tree_iter;
#line 262 "structure.vala"
	structure_select_simple_list_item (self, &_tmp20_);
#line 240 "structure.vala"
	__vala_GtkTreePath_free0 (tree_path);
#line 240 "structure.vala"
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 240 "structure.vala"
	_g_object_unref0 (tree_select);
#line 1251 "structure.c"
}


static void
structure_init_vpaned (Structure* self)
{
	GtkPaned* _tmp0_;
	GtkPaned* _tmp1_;
	GtkPaned* _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	GtkPaned* _tmp4_;
#line 265 "structure.vala"
	g_return_if_fail (self != NULL);
#line 267 "structure.vala"
	_tmp0_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_VERTICAL);
#line 267 "structure.vala"
	g_object_ref_sink (_tmp0_);
#line 267 "structure.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 267 "structure.vala"
	self->priv->_vpaned = _tmp0_;
#line 268 "structure.vala"
	_tmp1_ = self->priv->_vpaned;
#line 268 "structure.vala"
	g_object_set ((GtkWidget*) _tmp1_, "expand", TRUE, NULL);
#line 269 "structure.vala"
	_tmp2_ = self->priv->_vpaned;
#line 269 "structure.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
#line 271 "structure.vala"
	_tmp3_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 271 "structure.vala"
	settings = _tmp3_;
#line 272 "structure.vala"
	_tmp4_ = self->priv->_vpaned;
#line 272 "structure.vala"
	gtk_paned_set_position (_tmp4_, g_settings_get_int (settings, "structure-paned-position"));
#line 265 "structure.vala"
	_g_object_unref0 (settings);
#line 1292 "structure.c"
}


void
structure_save_state (Structure* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkPaned* _tmp1_;
#line 275 "structure.vala"
	g_return_if_fail (self != NULL);
#line 277 "structure.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 277 "structure.vala"
	settings = _tmp0_;
#line 278 "structure.vala"
	_tmp1_ = self->priv->_vpaned;
#line 278 "structure.vala"
	g_settings_set_int (settings, "structure-paned-position", gtk_paned_get_position (_tmp1_));
#line 275 "structure.vala"
	_g_object_unref0 (settings);
#line 1314 "structure.c"
}


static gboolean
__lambda9_ (Structure* self,
            GtkTreeSelection* select,
            GtkTreeModel* model,
            GtkTreePath* path,
            gboolean path_currently_selected)
{
	gboolean result = FALSE;
#line 296 "structure.vala"
	g_return_val_if_fail (select != NULL, FALSE);
#line 296 "structure.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 296 "structure.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 299 "structure.vala"
	if (path_currently_selected) {
#line 300 "structure.vala"
		result = TRUE;
#line 300 "structure.vala"
		return result;
#line 1338 "structure.c"
	}
#line 302 "structure.vala"
	result = structure_select_list_row (self, path);
#line 302 "structure.vala"
	return result;
#line 1344 "structure.c"
}


static gboolean
___lambda9__gtk_tree_selection_func (GtkTreeSelection* selection,
                                     GtkTreeModel* model,
                                     GtkTreePath* path,
                                     gboolean path_currently_selected,
                                     gpointer self)
{
	gboolean result;
	result = __lambda9_ ((Structure*) self, selection, model, path, path_currently_selected);
#line 296 "structure.vala"
	return result;
#line 1359 "structure.c"
}


static void
__lambda10_ (Structure* self,
             GtkTreePath* path)
{
#line 306 "structure.vala"
	g_return_if_fail (path != NULL);
#line 306 "structure.vala"
	structure_select_list_row (self, path);
#line 1371 "structure.c"
}


static void
___lambda10__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
#line 306 "structure.vala"
	__lambda10_ ((Structure*) self, path);
#line 1383 "structure.c"
}


static void
structure_init_list_view (Structure* self)
{
	GtkTreeView* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeSelection* list_select = NULL;
	GtkTreeView* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeSelection* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	GtkPaned* _tmp11_;
	GtkScrolledWindow* _tmp12_;
#line 281 "structure.vala"
	g_return_if_fail (self != NULL);
#line 283 "structure.vala"
	_tmp0_ = structure_get_new_tree_view (self, (gint) STRUCT_LIST_COLUMN_PIXBUF, (gint) STRUCT_LIST_COLUMN_TEXT, (gint) STRUCT_LIST_COLUMN_TOOLTIP);
#line 283 "structure.vala"
	_g_object_unref0 (self->priv->_list_view);
#line 283 "structure.vala"
	self->priv->_list_view = _tmp0_;
#line 286 "structure.vala"
	_tmp1_ = gtk_list_store_new ((gint) STRUCT_LIST_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 286 "structure.vala"
	_g_object_unref0 (self->priv->_list_store);
#line 286 "structure.vala"
	self->priv->_list_store = _tmp1_;
#line 292 "structure.vala"
	_tmp2_ = self->priv->_list_view;
#line 292 "structure.vala"
	_tmp3_ = self->priv->_list_store;
#line 292 "structure.vala"
	gtk_tree_view_set_model (_tmp2_, (GtkTreeModel*) _tmp3_);
#line 295 "structure.vala"
	_tmp4_ = self->priv->_list_view;
#line 295 "structure.vala"
	_tmp5_ = gtk_tree_view_get_selection (_tmp4_);
#line 295 "structure.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 295 "structure.vala"
	list_select = _tmp6_;
#line 296 "structure.vala"
	gtk_tree_selection_set_select_function (list_select, ___lambda9__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
#line 306 "structure.vala"
	_tmp7_ = self->priv->_list_view;
#line 306 "structure.vala"
	g_signal_connect_object (_tmp7_, "row-activated", (GCallback) ___lambda10__gtk_tree_view_row_activated, self, 0);
#line 309 "structure.vala"
	_tmp8_ = self->priv->_list_view;
#line 309 "structure.vala"
	_tmp9_ = utils_add_scrollbar ((GtkWidget*) _tmp8_);
#line 309 "structure.vala"
	_g_object_unref0 (self->priv->_list_view_sw);
#line 309 "structure.vala"
	self->priv->_list_view_sw = _tmp9_;
#line 310 "structure.vala"
	_tmp10_ = self->priv->_list_view_sw;
#line 310 "structure.vala"
	gtk_scrolled_window_set_shadow_type (_tmp10_, GTK_SHADOW_IN);
#line 312 "structure.vala"
	_tmp11_ = self->priv->_vpaned;
#line 312 "structure.vala"
	_tmp12_ = self->priv->_list_view_sw;
#line 312 "structure.vala"
	gtk_paned_pack1 (_tmp11_, (GtkWidget*) _tmp12_, FALSE, FALSE);
#line 281 "structure.vala"
	_g_object_unref0 (list_select);
#line 1458 "structure.c"
}


static gboolean
__lambda11_ (Structure* self,
             GtkTreeSelection* select,
             GtkTreeModel* model,
             GtkTreePath* path,
             gboolean path_currently_selected)
{
	gboolean result = FALSE;
#line 324 "structure.vala"
	g_return_val_if_fail (select != NULL, FALSE);
#line 324 "structure.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 324 "structure.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 327 "structure.vala"
	if (path_currently_selected) {
#line 329 "structure.vala"
		g_signal_emit (self, structure_signals[STRUCTURE_NO_ITEMS_SELECTED_SIGNAL], 0);
#line 330 "structure.vala"
		result = TRUE;
#line 330 "structure.vala"
		return result;
#line 1484 "structure.c"
	}
#line 333 "structure.vala"
	result = structure_select_tree_row (self, path);
#line 333 "structure.vala"
	return result;
#line 1490 "structure.c"
}


static gboolean
___lambda11__gtk_tree_selection_func (GtkTreeSelection* selection,
                                      GtkTreeModel* model,
                                      GtkTreePath* path,
                                      gboolean path_currently_selected,
                                      gpointer self)
{
	gboolean result;
	result = __lambda11_ ((Structure*) self, selection, model, path, path_currently_selected);
#line 324 "structure.vala"
	return result;
#line 1505 "structure.c"
}


static void
__lambda12_ (Structure* self,
             GtkTreePath* path)
{
#line 337 "structure.vala"
	g_return_if_fail (path != NULL);
#line 337 "structure.vala"
	structure_select_tree_row (self, path);
#line 1517 "structure.c"
}


static void
___lambda12__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
#line 337 "structure.vala"
	__lambda12_ ((Structure*) self, path);
#line 1529 "structure.c"
}


static gboolean
__lambda13_ (Structure* self,
             GdkEventButton* event)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
#line 340 "structure.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 343 "structure.vala"
	_tmp1_ = event->button;
#line 343 "structure.vala"
	if (_tmp1_ == ((guint) 3)) {
#line 1546 "structure.c"
		GdkEventType _tmp2_;
#line 343 "structure.vala"
		_tmp2_ = event->type;
#line 343 "structure.vala"
		_tmp0_ = _tmp2_ == GDK_BUTTON_PRESS;
#line 1552 "structure.c"
	} else {
#line 343 "structure.vala"
		_tmp0_ = FALSE;
#line 1556 "structure.c"
	}
#line 343 "structure.vala"
	if (_tmp0_) {
#line 344 "structure.vala"
		g_signal_emit (self, structure_signals[STRUCTURE_SHOW_POPUP_MENU_SIGNAL], 0, event);
#line 1562 "structure.c"
	}
#line 347 "structure.vala"
	result = FALSE;
#line 347 "structure.vala"
	return result;
#line 1568 "structure.c"
}


static gboolean
___lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda13_ ((Structure*) self, event);
#line 340 "structure.vala"
	return result;
#line 1581 "structure.c"
}


static gboolean
__lambda14_ (Structure* self)
{
	gboolean result = FALSE;
#line 352 "structure.vala"
	g_signal_emit (self, structure_signals[STRUCTURE_SHOW_POPUP_MENU_SIGNAL], 0, NULL);
#line 353 "structure.vala"
	result = TRUE;
#line 353 "structure.vala"
	return result;
#line 1595 "structure.c"
}


static gboolean
___lambda14__gtk_widget_popup_menu (GtkWidget* _sender,
                                    gpointer self)
{
	gboolean result;
	result = __lambda14_ ((Structure*) self);
#line 350 "structure.vala"
	return result;
#line 1607 "structure.c"
}


static void
structure_init_tree_view (Structure* self)
{
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* tree_select = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkScrolledWindow* sw = NULL;
	GtkTreeView* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkPaned* _tmp10_;
#line 315 "structure.vala"
	g_return_if_fail (self != NULL);
#line 317 "structure.vala"
	_tmp0_ = structure_get_new_tree_view (self, (gint) STRUCT_COLUMN_PIXBUF, (gint) STRUCT_COLUMN_TEXT, (gint) STRUCT_COLUMN_TOOLTIP);
#line 317 "structure.vala"
	_g_object_unref0 (self->priv->_tree_view);
#line 317 "structure.vala"
	self->priv->_tree_view = _tmp0_;
#line 320 "structure.vala"
	_tmp1_ = self->priv->_tree_view;
#line 320 "structure.vala"
	gtk_tree_view_set_enable_tree_lines (_tmp1_, TRUE);
#line 323 "structure.vala"
	_tmp2_ = self->priv->_tree_view;
#line 323 "structure.vala"
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
#line 323 "structure.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 323 "structure.vala"
	tree_select = _tmp4_;
#line 324 "structure.vala"
	gtk_tree_selection_set_select_function (tree_select, ___lambda11__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
#line 337 "structure.vala"
	_tmp5_ = self->priv->_tree_view;
#line 337 "structure.vala"
	g_signal_connect_object (_tmp5_, "row-activated", (GCallback) ___lambda12__gtk_tree_view_row_activated, self, 0);
#line 340 "structure.vala"
	_tmp6_ = self->priv->_tree_view;
#line 340 "structure.vala"
	g_signal_connect_object ((GtkWidget*) _tmp6_, "button-press-event", (GCallback) ___lambda13__gtk_widget_button_press_event, self, 0);
#line 350 "structure.vala"
	_tmp7_ = self->priv->_tree_view;
#line 350 "structure.vala"
	g_signal_connect_object ((GtkWidget*) _tmp7_, "popup-menu", (GCallback) ___lambda14__gtk_widget_popup_menu, self, 0);
#line 357 "structure.vala"
	_tmp8_ = self->priv->_tree_view;
#line 357 "structure.vala"
	_tmp9_ = utils_add_scrollbar ((GtkWidget*) _tmp8_);
#line 357 "structure.vala"
	sw = _tmp9_;
#line 358 "structure.vala"
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
#line 360 "structure.vala"
	_tmp10_ = self->priv->_vpaned;
#line 360 "structure.vala"
	gtk_paned_add2 (_tmp10_, (GtkWidget*) sw);
#line 315 "structure.vala"
	_g_object_unref0 (sw);
#line 315 "structure.vala"
	_g_object_unref0 (tree_select);
#line 1677 "structure.c"
}


static GtkTreeView*
structure_get_new_tree_view (Structure* self,
                             gint pixbuf_col,
                             gint text_col,
                             gint tooltip_col)
{
	GtkTreeView* result = NULL;
	GtkTreeView* tree_view = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp1_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp2_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp3_;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* _tmp5_;
#line 363 "structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 365 "structure.vala"
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
#line 365 "structure.vala"
	g_object_ref_sink (_tmp0_);
#line 365 "structure.vala"
	tree_view = _tmp0_;
#line 366 "structure.vala"
	gtk_tree_view_set_headers_visible (tree_view, FALSE);
#line 368 "structure.vala"
	_tmp1_ = gtk_tree_view_column_new ();
#line 368 "structure.vala"
	g_object_ref_sink (_tmp1_);
#line 368 "structure.vala"
	column = _tmp1_;
#line 369 "structure.vala"
	gtk_tree_view_append_column (tree_view, column);
#line 372 "structure.vala"
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 372 "structure.vala"
	g_object_ref_sink (_tmp2_);
#line 372 "structure.vala"
	pixbuf_renderer = _tmp2_;
#line 373 "structure.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
#line 374 "structure.vala"
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", pixbuf_col, NULL, NULL);
#line 377 "structure.vala"
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 377 "structure.vala"
	g_object_ref_sink (_tmp3_);
#line 377 "structure.vala"
	text_renderer = _tmp3_;
#line 378 "structure.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
#line 379 "structure.vala"
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", text_col, NULL, NULL);
#line 382 "structure.vala"
	gtk_tree_view_set_tooltip_column (tree_view, tooltip_col);
#line 385 "structure.vala"
	_tmp4_ = gtk_tree_view_get_selection (tree_view);
#line 385 "structure.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 385 "structure.vala"
	select = _tmp5_;
#line 386 "structure.vala"
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
#line 388 "structure.vala"
	result = tree_view;
#line 388 "structure.vala"
	_g_object_unref0 (select);
#line 388 "structure.vala"
	_g_object_unref0 (text_renderer);
#line 388 "structure.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 388 "structure.vala"
	_g_object_unref0 (column);
#line 388 "structure.vala"
	return result;
#line 1759 "structure.c"
}


static gboolean
structure_select_list_row (Structure* self,
                           GtkTreePath* list_path)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	StructureModel* _tmp1_;
	GtkTreeSelection* tree_select = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* _tmp5_;
	gint row_num = 0;
	gint _tmp6_;
	gint* _tmp7_;
	gint _tmp8_;
	GtkTreePath* tree_path = NULL;
	StructureModel* _tmp9_;
	StructType _tmp10_;
	gint _tmp11_;
	GtkTreePath* _tmp12_;
	GtkTreePath* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreePath* _tmp15_;
	GtkTreeSelection* _tmp16_;
	GtkTreePath* _tmp17_;
	GtkTreeView* _tmp18_;
	GtkTreePath* _tmp19_;
#line 391 "structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 391 "structure.vala"
	g_return_val_if_fail (list_path != NULL, FALSE);
#line 393 "structure.vala"
	_tmp0_ = self->priv->_first_select;
#line 393 "structure.vala"
	if (!_tmp0_) {
#line 395 "structure.vala"
		self->priv->_first_select = TRUE;
#line 396 "structure.vala"
		result = TRUE;
#line 396 "structure.vala"
		return result;
#line 1805 "structure.c"
	}
#line 399 "structure.vala"
	_tmp1_ = self->priv->_model;
#line 399 "structure.vala"
	g_return_val_if_fail (_tmp1_ != NULL, FALSE);
#line 402 "structure.vala"
	_tmp2_ = self->priv->_tree_view;
#line 402 "structure.vala"
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
#line 402 "structure.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 402 "structure.vala"
	tree_select = _tmp4_;
#line 403 "structure.vala"
	_tmp5_ = tree_select;
#line 403 "structure.vala"
	gtk_tree_selection_unselect_all (_tmp5_);
#line 405 "structure.vala"
	_tmp7_ = gtk_tree_path_get_indices_with_depth (list_path, &_tmp6_);
#line 405 "structure.vala"
	_tmp8_ = _tmp7_[0];
#line 405 "structure.vala"
	row_num = _tmp8_;
#line 407 "structure.vala"
	_tmp9_ = self->priv->_model;
#line 407 "structure.vala"
	_tmp10_ = self->priv->_current_list_type;
#line 407 "structure.vala"
	_tmp11_ = row_num;
#line 407 "structure.vala"
	_tmp12_ = structure_model_get_tree_path_from_list_num (_tmp9_, _tmp10_, _tmp11_);
#line 407 "structure.vala"
	tree_path = _tmp12_;
#line 410 "structure.vala"
	_tmp13_ = tree_path;
#line 410 "structure.vala"
	g_return_val_if_fail (_tmp13_ != NULL, FALSE);
#line 412 "structure.vala"
	_tmp14_ = self->priv->_tree_view;
#line 412 "structure.vala"
	_tmp15_ = tree_path;
#line 412 "structure.vala"
	gtk_tree_view_expand_to_path (_tmp14_, _tmp15_);
#line 414 "structure.vala"
	self->priv->_first_select = FALSE;
#line 415 "structure.vala"
	_tmp16_ = tree_select;
#line 415 "structure.vala"
	_tmp17_ = tree_path;
#line 415 "structure.vala"
	gtk_tree_selection_select_path (_tmp16_, _tmp17_);
#line 417 "structure.vala"
	_tmp18_ = self->priv->_tree_view;
#line 417 "structure.vala"
	_tmp19_ = tree_path;
#line 417 "structure.vala"
	gtk_tree_view_scroll_to_cell (_tmp18_, _tmp19_, NULL, TRUE, (gfloat) 0.5, (gfloat) 0);
#line 420 "structure.vala"
	result = TRUE;
#line 420 "structure.vala"
	__vala_GtkTreePath_free0 (tree_path);
#line 420 "structure.vala"
	_g_object_unref0 (tree_select);
#line 420 "structure.vala"
	return result;
#line 1871 "structure.c"
}


static gboolean
structure_select_tree_row (Structure* self,
                           GtkTreePath* tree_path)
{
	gboolean result = FALSE;
	gboolean first_select = FALSE;
	gboolean _tmp0_;
	GtkTreeIter tree_iter = {0};
	StructureModel* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkTextMark* mark = NULL;
	StructType type = 0;
	StructureModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GtkTextBuffer* doc = NULL;
	GtkTextMark* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	MainWindow* _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	GtkTextIter text_iter = {0};
	GtkTextBuffer* _tmp13_;
	GtkTextMark* _tmp14_;
	GtkTextIter _tmp15_ = {0};
	GtkTextBuffer* _tmp16_;
	GtkTextIter _tmp17_;
	MainWindow* _tmp18_;
	DocumentView* _tmp19_;
	DocumentView* _tmp20_;
	GtkTextBuffer* _tmp21_;
	GtkTextMark* _tmp22_;
	StructType _tmp23_;
	GtkTreeIter _tmp24_;
#line 423 "structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 423 "structure.vala"
	g_return_val_if_fail (tree_path != NULL, FALSE);
#line 427 "structure.vala"
	_tmp0_ = self->priv->_first_select;
#line 427 "structure.vala"
	first_select = _tmp0_;
#line 428 "structure.vala"
	self->priv->_first_select = TRUE;
#line 431 "structure.vala"
	_tmp1_ = self->priv->_model;
#line 431 "structure.vala"
	_tmp3_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp1_, &_tmp2_, tree_path);
#line 431 "structure.vala"
	tree_iter = _tmp2_;
#line 431 "structure.vala"
	if (!_tmp3_) {
#line 432 "structure.vala"
		g_return_val_if_reached (FALSE);
#line 1931 "structure.c"
	}
#line 436 "structure.vala"
	_tmp4_ = self->priv->_model;
#line 436 "structure.vala"
	_tmp5_ = tree_iter;
#line 436 "structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, STRUCT_COLUMN_START_MARK, &mark, STRUCT_COLUMN_TYPE, &type, -1);
#line 442 "structure.vala"
	_tmp6_ = mark;
#line 442 "structure.vala"
	_tmp7_ = gtk_text_mark_get_buffer (_tmp6_);
#line 442 "structure.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 442 "structure.vala"
	doc = _tmp8_;
#line 443 "structure.vala"
	_tmp9_ = doc;
#line 443 "structure.vala"
	_tmp10_ = self->priv->_main_window;
#line 443 "structure.vala"
	_tmp11_ = main_window_get_active_document (_tmp10_);
#line 443 "structure.vala"
	_tmp12_ = _tmp11_;
#line 443 "structure.vala"
	g_return_val_if_fail (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_text_buffer_get_type (), GtkTextBuffer), FALSE);
#line 447 "structure.vala"
	_tmp13_ = doc;
#line 447 "structure.vala"
	_tmp14_ = mark;
#line 447 "structure.vala"
	gtk_text_buffer_get_iter_at_mark (_tmp13_, &_tmp15_, _tmp14_);
#line 447 "structure.vala"
	text_iter = _tmp15_;
#line 448 "structure.vala"
	_tmp16_ = doc;
#line 448 "structure.vala"
	_tmp17_ = text_iter;
#line 448 "structure.vala"
	gtk_text_buffer_place_cursor (_tmp16_, &_tmp17_);
#line 451 "structure.vala"
	_tmp18_ = self->priv->_main_window;
#line 451 "structure.vala"
	_tmp19_ = main_window_get_active_view (_tmp18_);
#line 451 "structure.vala"
	_tmp20_ = _tmp19_;
#line 451 "structure.vala"
	_tmp21_ = doc;
#line 451 "structure.vala"
	_tmp22_ = gtk_text_buffer_get_insert (_tmp21_);
#line 451 "structure.vala"
	gtk_text_view_scroll_to_mark ((GtkTextView*) _tmp20_, _tmp22_, (gdouble) 0, TRUE, (gdouble) 1, (gdouble) 0);
#line 453 "structure.vala"
	_tmp23_ = type;
#line 453 "structure.vala"
	g_signal_emit (self, structure_signals[STRUCTURE_ITEM_SELECTED_SIGNAL], 0, _tmp23_);
#line 456 "structure.vala"
	if (!first_select) {
#line 457 "structure.vala"
		result = TRUE;
#line 457 "structure.vala"
		_g_object_unref0 (doc);
#line 457 "structure.vala"
		_g_object_unref0 (mark);
#line 457 "structure.vala"
		return result;
#line 1997 "structure.c"
	}
#line 459 "structure.vala"
	_tmp24_ = tree_iter;
#line 459 "structure.vala"
	structure_select_simple_list_item (self, &_tmp24_);
#line 462 "structure.vala"
	result = TRUE;
#line 462 "structure.vala"
	_g_object_unref0 (doc);
#line 462 "structure.vala"
	_g_object_unref0 (mark);
#line 462 "structure.vala"
	return result;
#line 2011 "structure.c"
}


static void
structure_select_simple_list_item (Structure* self,
                                   GtkTreeIter* tree_iter)
{
	gboolean _tmp0_;
	GtkTreeSelection* list_select = NULL;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	StructType type = 0;
	StructureModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GeeArrayList* current_list_types = NULL;
	StructType _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	StructType _tmp10_;
	gint row_num = 0;
	StructureModel* _tmp11_;
	GtkTreeIter _tmp12_;
	gint _tmp13_;
	GtkTreePath* list_path = NULL;
	gint _tmp14_;
	GtkTreePath* _tmp15_;
	GtkTreeSelection* _tmp16_;
	GtkTreePath* _tmp17_;
	GtkTreeView* _tmp18_;
	GtkTreePath* _tmp19_;
#line 467 "structure.vala"
	g_return_if_fail (self != NULL);
#line 467 "structure.vala"
	g_return_if_fail (tree_iter != NULL);
#line 469 "structure.vala"
	_tmp0_ = self->priv->_list_is_hidden;
#line 469 "structure.vala"
	if (_tmp0_) {
#line 470 "structure.vala"
		return;
#line 2054 "structure.c"
	}
#line 472 "structure.vala"
	_tmp1_ = self->priv->_list_view;
#line 472 "structure.vala"
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
#line 472 "structure.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 472 "structure.vala"
	list_select = _tmp3_;
#line 473 "structure.vala"
	_tmp4_ = list_select;
#line 473 "structure.vala"
	gtk_tree_selection_unselect_all (_tmp4_);
#line 476 "structure.vala"
	_tmp5_ = self->priv->_model;
#line 476 "structure.vala"
	_tmp6_ = *tree_iter;
#line 476 "structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp5_, &_tmp6_, STRUCT_COLUMN_TYPE, &type, -1, -1);
#line 478 "structure.vala"
	_tmp7_ = self->priv->_current_list_type;
#line 478 "structure.vala"
	_tmp8_ = structure_get_simple_list_types (self, _tmp7_);
#line 478 "structure.vala"
	current_list_types = _tmp8_;
#line 481 "structure.vala"
	_tmp9_ = current_list_types;
#line 481 "structure.vala"
	_tmp10_ = type;
#line 481 "structure.vala"
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp9_, (gpointer) ((gintptr) _tmp10_))) {
#line 482 "structure.vala"
		_g_object_unref0 (current_list_types);
#line 482 "structure.vala"
		_g_object_unref0 (list_select);
#line 482 "structure.vala"
		return;
#line 2092 "structure.c"
	}
#line 484 "structure.vala"
	_tmp11_ = self->priv->_model;
#line 484 "structure.vala"
	_tmp12_ = *tree_iter;
#line 484 "structure.vala"
	row_num = structure_model_get_list_num_from_tree_iter (_tmp11_, &_tmp12_);
#line 486 "structure.vala"
	_tmp13_ = row_num;
#line 486 "structure.vala"
	if (_tmp13_ == -1) {
#line 487 "structure.vala"
		_g_object_unref0 (current_list_types);
#line 487 "structure.vala"
		_g_object_unref0 (list_select);
#line 487 "structure.vala"
		return;
#line 2110 "structure.c"
	}
#line 489 "structure.vala"
	_tmp14_ = row_num;
#line 489 "structure.vala"
	_tmp15_ = gtk_tree_path_new_from_indices (_tmp14_, -1, -1);
#line 489 "structure.vala"
	list_path = _tmp15_;
#line 491 "structure.vala"
	self->priv->_first_select = FALSE;
#line 492 "structure.vala"
	_tmp16_ = list_select;
#line 492 "structure.vala"
	_tmp17_ = list_path;
#line 492 "structure.vala"
	gtk_tree_selection_select_path (_tmp16_, _tmp17_);
#line 494 "structure.vala"
	_tmp18_ = self->priv->_list_view;
#line 494 "structure.vala"
	_tmp19_ = list_path;
#line 494 "structure.vala"
	gtk_tree_view_scroll_to_cell (_tmp18_, _tmp19_, NULL, FALSE, (gfloat) 0, (gfloat) 0);
#line 467 "structure.vala"
	__vala_GtkTreePath_free0 (list_path);
#line 467 "structure.vala"
	_g_object_unref0 (current_list_types);
#line 467 "structure.vala"
	_g_object_unref0 (list_select);
#line 2138 "structure.c"
}


static GeeArrayList*
structure_get_simple_list_types (Structure* self,
                                 StructType type)
{
	GeeArrayList* result = NULL;
	GeeArrayList* types = NULL;
	GeeArrayList* _tmp0_;
#line 499 "structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 501 "structure.vala"
	g_return_val_if_fail (!structure_is_section (type), NULL);
#line 503 "structure.vala"
	_tmp0_ = gee_array_list_new (TYPE_STRUCT_TYPE, NULL, NULL, NULL, NULL, NULL);
#line 503 "structure.vala"
	types = _tmp0_;
#line 505 "structure.vala"
	switch (type) {
#line 505 "structure.vala"
		case STRUCT_TYPE_FIGURE:
#line 505 "structure.vala"
		case STRUCT_TYPE_IMAGE:
#line 2163 "structure.c"
		{
			GeeArrayList* _tmp1_;
			GeeArrayList* _tmp2_;
#line 509 "structure.vala"
			_tmp1_ = types;
#line 509 "structure.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, (gpointer) ((gintptr) STRUCT_TYPE_FIGURE));
#line 510 "structure.vala"
			_tmp2_ = types;
#line 510 "structure.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((gintptr) STRUCT_TYPE_IMAGE));
#line 511 "structure.vala"
			break;
#line 2177 "structure.c"
		}
#line 505 "structure.vala"
		case STRUCT_TYPE_TODO:
#line 505 "structure.vala"
		case STRUCT_TYPE_FIXME:
#line 2183 "structure.c"
		{
			GeeArrayList* _tmp3_;
			GeeArrayList* _tmp4_;
#line 515 "structure.vala"
			_tmp3_ = types;
#line 515 "structure.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, (gpointer) ((gintptr) STRUCT_TYPE_TODO));
#line 516 "structure.vala"
			_tmp4_ = types;
#line 516 "structure.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (gpointer) ((gintptr) STRUCT_TYPE_FIXME));
#line 517 "structure.vala"
			break;
#line 2197 "structure.c"
		}
		default:
		{
			GeeArrayList* _tmp5_;
#line 520 "structure.vala"
			_tmp5_ = types;
#line 520 "structure.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (gpointer) ((gintptr) type));
#line 521 "structure.vala"
			break;
#line 2208 "structure.c"
		}
	}
#line 524 "structure.vala"
	result = types;
#line 524 "structure.vala"
	return result;
#line 2215 "structure.c"
}


static void
structure_show_active_document (Structure* self)
{
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
#line 527 "structure.vala"
	g_return_if_fail (self != NULL);
#line 529 "structure.vala"
	_tmp0_ = self->priv->_main_window;
#line 529 "structure.vala"
	_tmp1_ = main_window_get_active_document (_tmp0_);
#line 529 "structure.vala"
	_tmp2_ = _tmp1_;
#line 529 "structure.vala"
	structure_show_document (self, _tmp2_, FALSE);
#line 2235 "structure.c"
}


static void
_structure_on_parsing_done_g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self)
{
#line 538 "structure.vala"
	structure_on_parsing_done ((Structure*) self);
#line 2246 "structure.c"
}


static void
structure_show_document (Structure* self,
                         Document* doc,
                         gboolean force_parse)
{
	GtkTreeView* _tmp0_;
	DocumentStructure* _tmp1_;
	DocumentStructure* _tmp5_;
	DocumentStructure* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
#line 532 "structure.vala"
	g_return_if_fail (self != NULL);
#line 534 "structure.vala"
	structure_set_model (self, NULL);
#line 535 "structure.vala"
	_tmp0_ = self->priv->_tree_view;
#line 535 "structure.vala"
	gtk_tree_view_columns_autosize (_tmp0_);
#line 537 "structure.vala"
	_tmp1_ = self->priv->_document_structure;
#line 537 "structure.vala"
	if (_tmp1_ != NULL) {
#line 2273 "structure.c"
		DocumentStructure* _tmp2_;
		guint _tmp3_;
		GQuark _tmp4_;
#line 538 "structure.vala"
		_tmp2_ = self->priv->_document_structure;
#line 538 "structure.vala"
		g_signal_parse_name ("notify::parsing-done", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
#line 538 "structure.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _structure_on_parsing_done_g_object_notify, self);
#line 2283 "structure.c"
	}
#line 540 "structure.vala"
	if (doc == NULL) {
#line 542 "structure.vala"
		_g_object_unref0 (self->priv->_document_structure);
#line 542 "structure.vala"
		self->priv->_document_structure = NULL;
#line 543 "structure.vala"
		return;
#line 2293 "structure.c"
	}
#line 546 "structure.vala"
	_tmp5_ = document_get_structure (doc);
#line 546 "structure.vala"
	_g_object_unref0 (self->priv->_document_structure);
#line 546 "structure.vala"
	self->priv->_document_structure = _tmp5_;
#line 548 "structure.vala"
	if (force_parse) {
#line 2303 "structure.c"
		DocumentStructure* _tmp6_;
#line 549 "structure.vala"
		_tmp6_ = self->priv->_document_structure;
#line 549 "structure.vala"
		document_structure_parse (_tmp6_);
#line 2309 "structure.c"
	}
#line 551 "structure.vala"
	_tmp7_ = self->priv->_document_structure;
#line 551 "structure.vala"
	_tmp8_ = document_structure_get_parsing_done (_tmp7_);
#line 551 "structure.vala"
	_tmp9_ = _tmp8_;
#line 551 "structure.vala"
	if (_tmp9_) {
#line 552 "structure.vala"
		structure_on_parsing_done (self);
#line 2321 "structure.c"
	} else {
		DocumentStructure* _tmp10_;
#line 554 "structure.vala"
		_tmp10_ = self->priv->_document_structure;
#line 554 "structure.vala"
		g_signal_connect_object ((GObject*) _tmp10_, "notify::parsing-done", (GCallback) _structure_on_parsing_done_g_object_notify, self, 0);
#line 2328 "structure.c"
	}
}


static void
structure_on_parsing_done (Structure* self)
{
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 557 "structure.vala"
	g_return_if_fail (self != NULL);
#line 559 "structure.vala"
	_tmp0_ = self->priv->_document_structure;
#line 559 "structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 561 "structure.vala"
	_tmp1_ = self->priv->_document_structure;
#line 561 "structure.vala"
	_tmp2_ = document_structure_get_parsing_done (_tmp1_);
#line 561 "structure.vala"
	_tmp3_ = _tmp2_;
#line 561 "structure.vala"
	if (_tmp3_) {
#line 2354 "structure.c"
		DocumentStructure* _tmp4_;
		StructureModel* _tmp5_;
		StructureModel* _tmp6_;
#line 562 "structure.vala"
		_tmp4_ = self->priv->_document_structure;
#line 562 "structure.vala"
		_tmp5_ = document_structure_get_model (_tmp4_);
#line 562 "structure.vala"
		_tmp6_ = _tmp5_;
#line 562 "structure.vala"
		structure_set_model (self, _tmp6_);
#line 562 "structure.vala"
		_g_object_unref0 (_tmp6_);
#line 2368 "structure.c"
	}
}


static void
structure_set_model (Structure* self,
                     StructureModel* model)
{
	StructureModel* _tmp0_;
	GtkTreeView* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 565 "structure.vala"
	g_return_if_fail (self != NULL);
#line 567 "structure.vala"
	if (model != NULL) {
#line 568 "structure.vala"
		structure_model_set_emit_signals (model, TRUE);
#line 2386 "structure.c"
	}
#line 570 "structure.vala"
	_tmp0_ = _g_object_ref0 (model);
#line 570 "structure.vala"
	_g_object_unref0 (self->priv->_model);
#line 570 "structure.vala"
	self->priv->_model = _tmp0_;
#line 571 "structure.vala"
	_tmp1_ = self->priv->_tree_view;
#line 571 "structure.vala"
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) model);
#line 574 "structure.vala"
	if (model != NULL) {
#line 574 "structure.vala"
		_tmp2_ = structure_model_get_nb_items (model) <= ((guint) 2000);
#line 2402 "structure.c"
	} else {
#line 574 "structure.vala"
		_tmp2_ = FALSE;
#line 2406 "structure.c"
	}
#line 574 "structure.vala"
	if (_tmp2_) {
#line 2410 "structure.c"
		GtkTreeView* _tmp3_;
#line 575 "structure.vala"
		_tmp3_ = self->priv->_tree_view;
#line 575 "structure.vala"
		gtk_tree_view_expand_all (_tmp3_);
#line 2416 "structure.c"
	}
#line 577 "structure.vala"
	structure_populate_simple_list (self);
#line 2420 "structure.c"
}


static void
_structure_show_active_document_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
#line 582 "structure.vala"
	structure_show_active_document ((Structure*) self);
#line 2431 "structure.c"
}


void
structure_connect_parsing (Structure* self)
{
	MainWindow* _tmp0_;
#line 580 "structure.vala"
	g_return_if_fail (self != NULL);
#line 582 "structure.vala"
	_tmp0_ = self->priv->_main_window;
#line 582 "structure.vala"
	g_signal_connect_object ((GObject*) _tmp0_, "notify::active-document", (GCallback) _structure_show_active_document_g_object_notify, self, 0);
#line 583 "structure.vala"
	structure_show_active_document (self);
#line 2447 "structure.c"
}


void
structure_disconnect_parsing (Structure* self)
{
	MainWindow* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
#line 586 "structure.vala"
	g_return_if_fail (self != NULL);
#line 588 "structure.vala"
	_tmp0_ = self->priv->_main_window;
#line 588 "structure.vala"
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
#line 588 "structure.vala"
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _structure_show_active_document_g_object_notify, self);
#line 2465 "structure.c"
}


gboolean
structure_is_section (StructType type)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 595 "structure.vala"
	if (STRUCT_TYPE_PART <= type) {
#line 595 "structure.vala"
		_tmp0_ = type <= STRUCT_TYPE_SUBPARAGRAPH;
#line 2478 "structure.c"
	} else {
#line 595 "structure.vala"
		_tmp0_ = FALSE;
#line 2482 "structure.c"
	}
#line 595 "structure.vala"
	result = _tmp0_;
#line 595 "structure.vala"
	return result;
#line 2488 "structure.c"
}


gboolean
structure_is_common_type (StructType type)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 600 "structure.vala"
	if (STRUCT_TYPE_BEGIN_COMMON_TYPES < type) {
#line 601 "structure.vala"
		_tmp0_ = type < STRUCT_TYPE_END_COMMON_TYPES;
#line 2501 "structure.c"
	} else {
#line 600 "structure.vala"
		_tmp0_ = FALSE;
#line 2505 "structure.c"
	}
#line 600 "structure.vala"
	result = _tmp0_;
#line 600 "structure.vala"
	return result;
#line 2511 "structure.c"
}


/*************************************************************************/
void
structure_do_action (Structure* self,
                     StructAction action_type)
{
	GtkTreeIter selected_iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	gboolean refresh_simple_list = FALSE;
	gboolean _tmp20_;
	GError * _inner_error_ = NULL;
#line 608 "structure.vala"
	g_return_if_fail (self != NULL);
#line 611 "structure.vala"
	_tmp0_ = self->priv->_tree_view;
#line 611 "structure.vala"
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
#line 611 "structure.vala"
	selected_iter = _tmp1_;
#line 611 "structure.vala"
	selected_row = _tmp2_;
#line 613 "structure.vala"
	_tmp3_ = selected_row;
#line 613 "structure.vala"
	g_return_if_fail (_tmp3_ != -1);
#line 615 "structure.vala"
	if (action_type == STRUCT_ACTION_OPEN_FILE) {
#line 2545 "structure.c"
		GtkTreeIter _tmp4_;
#line 617 "structure.vala"
		_tmp4_ = selected_iter;
#line 617 "structure.vala"
		structure_open_referenced_file (self, &_tmp4_);
#line 618 "structure.vala"
		return;
#line 2553 "structure.c"
	}
#line 621 "structure.vala"
	refresh_simple_list = FALSE;
#line 2557 "structure.c"
	{
		DocumentStructure* _tmp5_;
		GtkTreeIter _tmp6_;
		gboolean _tmp7_ = FALSE;
#line 625 "structure.vala"
		_tmp5_ = self->priv->_document_structure;
#line 625 "structure.vala"
		_tmp6_ = selected_iter;
#line 625 "structure.vala"
		document_structure_do_action (_tmp5_, action_type, &_tmp6_, &_tmp7_, &_inner_error_);
#line 625 "structure.vala"
		refresh_simple_list = _tmp7_;
#line 625 "structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 625 "structure.vala"
			if (_inner_error_->domain == STRUCT_ERROR) {
#line 2574 "structure.c"
				goto __catch42_struct_error;
			}
#line 625 "structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 625 "structure.vala"
			g_clear_error (&_inner_error_);
#line 625 "structure.vala"
			return;
#line 2583 "structure.c"
		}
	}
	goto __finally42;
	__catch42_struct_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		MainWindow* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkMessageDialog* _tmp11_;
		GtkMessageDialog* _tmp12_;
		GError* _tmp13_;
		GtkMessageDialog* _tmp18_;
		GtkMessageDialog* _tmp19_;
#line 623 "structure.vala"
		e = _inner_error_;
#line 623 "structure.vala"
		_inner_error_ = NULL;
#line 630 "structure.vala"
		_tmp8_ = self->priv->_main_window;
#line 630 "structure.vala"
		_tmp9_ = structure_get_action_name (action_type);
#line 630 "structure.vala"
		_tmp10_ = _tmp9_;
#line 630 "structure.vala"
		_tmp11_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Structure action error: %s"), _tmp10_);
#line 630 "structure.vala"
		g_object_ref_sink (_tmp11_);
#line 630 "structure.vala"
		_tmp12_ = _tmp11_;
#line 630 "structure.vala"
		_g_free0 (_tmp10_);
#line 630 "structure.vala"
		dialog = _tmp12_;
#line 637 "structure.vala"
		_tmp13_ = e;
#line 637 "structure.vala"
		if (g_error_matches (_tmp13_, STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED)) {
#line 2623 "structure.c"
			GtkMessageDialog* _tmp14_;
#line 638 "structure.vala"
			_tmp14_ = dialog;
#line 638 "structure.vala"
			g_object_set (_tmp14_, "secondary-text", _ ("The structure data seems outdated. Please refresh the structure."), NULL);
#line 2629 "structure.c"
		} else {
			GtkMessageDialog* _tmp15_;
			GError* _tmp16_;
			const gchar* _tmp17_;
#line 641 "structure.vala"
			_tmp15_ = dialog;
#line 641 "structure.vala"
			_tmp16_ = e;
#line 641 "structure.vala"
			_tmp17_ = _tmp16_->message;
#line 641 "structure.vala"
			g_object_set (_tmp15_, "secondary-text", _tmp17_, NULL);
#line 2642 "structure.c"
		}
#line 643 "structure.vala"
		_tmp18_ = dialog;
#line 643 "structure.vala"
		gtk_dialog_run ((GtkDialog*) _tmp18_);
#line 644 "structure.vala"
		_tmp19_ = dialog;
#line 644 "structure.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp19_);
#line 645 "structure.vala"
		_g_object_unref0 (dialog);
#line 645 "structure.vala"
		_g_error_free0 (e);
#line 645 "structure.vala"
		return;
#line 2658 "structure.c"
	}
	__finally42:
#line 623 "structure.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 623 "structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 623 "structure.vala"
		g_clear_error (&_inner_error_);
#line 623 "structure.vala"
		return;
#line 2669 "structure.c"
	}
#line 649 "structure.vala"
	_tmp20_ = refresh_simple_list;
#line 649 "structure.vala"
	if (_tmp20_) {
#line 650 "structure.vala"
		structure_populate_simple_list (self);
#line 2677 "structure.c"
	}
}


static void
structure_open_referenced_file (Structure* self,
                                GtkTreeIter* iter)
{
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	StructType type = 0;
	gchar* filename = NULL;
	StructureModel* _tmp3_;
	GtkTreeIter _tmp4_;
	GFile* doc_location = NULL;
	MainWindow* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* parent = NULL;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* referenced_file = NULL;
	GFile* _tmp15_;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	StructType _tmp18_;
#line 653 "structure.vala"
	g_return_if_fail (self != NULL);
#line 653 "structure.vala"
	g_return_if_fail (iter != NULL);
#line 655 "structure.vala"
	_tmp0_ = self->priv->_main_window;
#line 655 "structure.vala"
	_tmp1_ = main_window_get_active_document (_tmp0_);
#line 655 "structure.vala"
	_tmp2_ = _tmp1_;
#line 655 "structure.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 660 "structure.vala"
	_tmp3_ = self->priv->_model;
#line 660 "structure.vala"
	_tmp4_ = *iter;
#line 660 "structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_TEXT, &filename, -1);
#line 665 "structure.vala"
	_tmp5_ = self->priv->_main_window;
#line 665 "structure.vala"
	_tmp6_ = main_window_get_active_document (_tmp5_);
#line 665 "structure.vala"
	_tmp7_ = _tmp6_;
#line 665 "structure.vala"
	_tmp8_ = document_get_location (_tmp7_);
#line 665 "structure.vala"
	_tmp9_ = _tmp8_;
#line 665 "structure.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 665 "structure.vala"
	doc_location = _tmp10_;
#line 666 "structure.vala"
	_tmp11_ = doc_location;
#line 666 "structure.vala"
	if (_tmp11_ == NULL) {
#line 667 "structure.vala"
		_g_object_unref0 (doc_location);
#line 667 "structure.vala"
		_g_free0 (filename);
#line 667 "structure.vala"
		return;
#line 2752 "structure.c"
	}
#line 669 "structure.vala"
	_tmp12_ = doc_location;
#line 669 "structure.vala"
	_tmp13_ = g_file_get_parent (_tmp12_);
#line 669 "structure.vala"
	parent = _tmp13_;
#line 670 "structure.vala"
	_tmp14_ = parent;
#line 670 "structure.vala"
	g_return_if_fail (_tmp14_ != NULL);
#line 672 "structure.vala"
	_tmp15_ = parent;
#line 672 "structure.vala"
	_tmp16_ = filename;
#line 672 "structure.vala"
	_tmp17_ = g_file_get_child (_tmp15_, _tmp16_);
#line 672 "structure.vala"
	referenced_file = _tmp17_;
#line 674 "structure.vala"
	_tmp18_ = type;
#line 674 "structure.vala"
	switch (_tmp18_) {
#line 674 "structure.vala"
		case STRUCT_TYPE_INCLUDE:
#line 2778 "structure.c"
		{
			GFile* _tmp19_;
#line 677 "structure.vala"
			_tmp19_ = referenced_file;
#line 677 "structure.vala"
			structure_open_included_file (self, _tmp19_);
#line 678 "structure.vala"
			break;
#line 2787 "structure.c"
		}
#line 674 "structure.vala"
		case STRUCT_TYPE_IMAGE:
#line 2791 "structure.c"
		{
			GFile* _tmp20_;
#line 681 "structure.vala"
			_tmp20_ = referenced_file;
#line 681 "structure.vala"
			structure_open_image (self, _tmp20_);
#line 682 "structure.vala"
			break;
#line 2800 "structure.c"
		}
		default:
		{
#line 685 "structure.vala"
			g_return_if_reached ();
#line 2806 "structure.c"
		}
	}
#line 653 "structure.vala"
	_g_object_unref0 (referenced_file);
#line 653 "structure.vala"
	_g_object_unref0 (parent);
#line 653 "structure.vala"
	_g_object_unref0 (doc_location);
#line 653 "structure.vala"
	_g_free0 (filename);
#line 2817 "structure.c"
}


static void
structure_open_included_file (Structure* self,
                              GFile* referenced_file)
{
	GFile* file_to_open = NULL;
	MainWindow* _tmp10_;
	GFile* _tmp11_;
	DocumentTab* _tmp12_;
	DocumentTab* _tmp13_;
#line 689 "structure.vala"
	g_return_if_fail (self != NULL);
#line 689 "structure.vala"
	g_return_if_fail (referenced_file != NULL);
#line 693 "structure.vala"
	if (g_file_query_exists (referenced_file, NULL)) {
#line 2836 "structure.c"
		GFile* _tmp0_;
#line 694 "structure.vala"
		_tmp0_ = _g_object_ref0 (referenced_file);
#line 694 "structure.vala"
		_g_object_unref0 (file_to_open);
#line 694 "structure.vala"
		file_to_open = _tmp0_;
#line 2844 "structure.c"
	} else {
		gchar* uri = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 698 "structure.vala"
		_tmp1_ = g_file_get_uri (referenced_file);
#line 698 "structure.vala"
		uri = _tmp1_;
#line 699 "structure.vala"
		_tmp2_ = uri;
#line 699 "structure.vala"
		_tmp3_ = g_strconcat (_tmp2_, ".tex", NULL);
#line 699 "structure.vala"
		_tmp4_ = _tmp3_;
#line 699 "structure.vala"
		_tmp5_ = g_file_new_for_uri (_tmp4_);
#line 699 "structure.vala"
		_g_object_unref0 (file_to_open);
#line 699 "structure.vala"
		file_to_open = _tmp5_;
#line 699 "structure.vala"
		_g_free0 (_tmp4_);
#line 701 "structure.vala"
		_tmp6_ = file_to_open;
#line 701 "structure.vala"
		if (!g_file_query_exists (_tmp6_, NULL)) {
#line 2875 "structure.c"
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 703 "structure.vala"
			_tmp7_ = file_to_open;
#line 703 "structure.vala"
			_tmp8_ = g_file_get_parse_name (_tmp7_);
#line 703 "structure.vala"
			_tmp9_ = _tmp8_;
#line 703 "structure.vala"
			g_warning ("structure.vala:703: Structure: the file '%s' doesn't exist.", _tmp9_);
#line 703 "structure.vala"
			_g_free0 (_tmp9_);
#line 705 "structure.vala"
			_g_free0 (uri);
#line 705 "structure.vala"
			_g_object_unref0 (file_to_open);
#line 705 "structure.vala"
			return;
#line 2895 "structure.c"
		}
#line 693 "structure.vala"
		_g_free0 (uri);
#line 2899 "structure.c"
	}
#line 709 "structure.vala"
	_tmp10_ = self->priv->_main_window;
#line 709 "structure.vala"
	_tmp11_ = file_to_open;
#line 709 "structure.vala"
	_tmp12_ = main_window_open_document (_tmp10_, _tmp11_, TRUE);
#line 709 "structure.vala"
	_tmp13_ = _tmp12_;
#line 709 "structure.vala"
	_g_object_unref0 (_tmp13_);
#line 689 "structure.vala"
	_g_object_unref0 (file_to_open);
#line 2913 "structure.c"
}


static void
structure_open_image (Structure* self,
                      GFile* referenced_file)
{
	GError * _inner_error_ = NULL;
#line 712 "structure.vala"
	g_return_if_fail (self != NULL);
#line 712 "structure.vala"
	g_return_if_fail (referenced_file != NULL);
#line 2926 "structure.c"
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
#line 716 "structure.vala"
		_tmp0_ = g_file_get_uri (referenced_file);
#line 716 "structure.vala"
		_tmp1_ = _tmp0_;
#line 716 "structure.vala"
		latexila_utils_show_uri ((GtkWidget*) self, _tmp1_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
#line 716 "structure.vala"
		_g_free0 (_tmp1_);
#line 716 "structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2940 "structure.c"
			goto __catch43_g_error;
		}
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 714 "structure.vala"
		e = _inner_error_;
#line 714 "structure.vala"
		_inner_error_ = NULL;
#line 720 "structure.vala"
		_tmp2_ = e;
#line 720 "structure.vala"
		_tmp3_ = _tmp2_->message;
#line 720 "structure.vala"
		g_warning ("structure.vala:720: Structure: can not open image: %s", _tmp3_);
#line 714 "structure.vala"
		_g_error_free0 (e);
#line 2962 "structure.c"
	}
	__finally43:
#line 714 "structure.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 714 "structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 714 "structure.vala"
		g_clear_error (&_inner_error_);
#line 714 "structure.vala"
		return;
#line 2973 "structure.c"
	}
}


static gchar*
structure_get_action_name (StructAction action_type)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	gchar* _tmp28_;
#line 726 "structure.vala"
	_tmp0_ = structure__action_names;
#line 726 "structure.vala"
	_tmp0__length1 = structure__action_names_length1;
#line 726 "structure.vala"
	if (_tmp0_ == NULL) {
#line 2994 "structure.c"
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar* _tmp24_;
		gchar* _tmp25_;
#line 728 "structure.vala"
		_tmp1_ = g_new0 (gchar*, STRUCT_ACTION_NB_ACTIONS + 1);
#line 728 "structure.vala"
		structure__action_names = (_vala_array_free (structure__action_names, structure__action_names_length1, (GDestroyNotify) g_free), NULL);
#line 728 "structure.vala"
		structure__action_names = _tmp1_;
#line 728 "structure.vala"
		structure__action_names_length1 = STRUCT_ACTION_NB_ACTIONS;
#line 728 "structure.vala"
		_structure__action_names_size_ = structure__action_names_length1;
#line 730 "structure.vala"
		_tmp2_ = structure__action_names;
#line 730 "structure.vala"
		_tmp2__length1 = structure__action_names_length1;
#line 730 "structure.vala"
		_tmp3_ = g_strdup (_ ("cut"));
#line 730 "structure.vala"
		_g_free0 (_tmp2_[STRUCT_ACTION_CUT]);
#line 730 "structure.vala"
		_tmp2_[STRUCT_ACTION_CUT] = _tmp3_;
#line 730 "structure.vala"
		_tmp4_ = _tmp2_[STRUCT_ACTION_CUT];
#line 732 "structure.vala"
		_tmp5_ = structure__action_names;
#line 732 "structure.vala"
		_tmp5__length1 = structure__action_names_length1;
#line 732 "structure.vala"
		_tmp6_ = g_strdup (_ ("copy"));
#line 732 "structure.vala"
		_g_free0 (_tmp5_[STRUCT_ACTION_COPY]);
#line 732 "structure.vala"
		_tmp5_[STRUCT_ACTION_COPY] = _tmp6_;
#line 732 "structure.vala"
		_tmp7_ = _tmp5_[STRUCT_ACTION_COPY];
#line 733 "structure.vala"
		_tmp8_ = structure__action_names;
#line 733 "structure.vala"
		_tmp8__length1 = structure__action_names_length1;
#line 733 "structure.vala"
		_tmp9_ = g_strdup (_ ("delete"));
#line 733 "structure.vala"
		_g_free0 (_tmp8_[STRUCT_ACTION_DELETE]);
#line 733 "structure.vala"
		_tmp8_[STRUCT_ACTION_DELETE] = _tmp9_;
#line 733 "structure.vala"
		_tmp10_ = _tmp8_[STRUCT_ACTION_DELETE];
#line 734 "structure.vala"
		_tmp11_ = structure__action_names;
#line 734 "structure.vala"
		_tmp11__length1 = structure__action_names_length1;
#line 734 "structure.vala"
		_tmp12_ = g_strdup (_ ("select"));
#line 734 "structure.vala"
		_g_free0 (_tmp11_[STRUCT_ACTION_SELECT]);
#line 734 "structure.vala"
		_tmp11_[STRUCT_ACTION_SELECT] = _tmp12_;
#line 734 "structure.vala"
		_tmp13_ = _tmp11_[STRUCT_ACTION_SELECT];
#line 736 "structure.vala"
		_tmp14_ = structure__action_names;
#line 736 "structure.vala"
		_tmp14__length1 = structure__action_names_length1;
#line 736 "structure.vala"
		_tmp15_ = g_strdup (_ ("comment"));
#line 736 "structure.vala"
		_g_free0 (_tmp14_[STRUCT_ACTION_COMMENT]);
#line 736 "structure.vala"
		_tmp14_[STRUCT_ACTION_COMMENT] = _tmp15_;
#line 736 "structure.vala"
		_tmp16_ = _tmp14_[STRUCT_ACTION_COMMENT];
#line 738 "structure.vala"
		_tmp17_ = structure__action_names;
#line 738 "structure.vala"
		_tmp17__length1 = structure__action_names_length1;
#line 738 "structure.vala"
		_tmp18_ = g_strdup (_ ("shift left"));
#line 738 "structure.vala"
		_g_free0 (_tmp17_[STRUCT_ACTION_SHIFT_LEFT]);
#line 738 "structure.vala"
		_tmp17_[STRUCT_ACTION_SHIFT_LEFT] = _tmp18_;
#line 738 "structure.vala"
		_tmp19_ = _tmp17_[STRUCT_ACTION_SHIFT_LEFT];
#line 740 "structure.vala"
		_tmp20_ = structure__action_names;
#line 740 "structure.vala"
		_tmp20__length1 = structure__action_names_length1;
#line 740 "structure.vala"
		_tmp21_ = g_strdup (_ ("shift right"));
#line 740 "structure.vala"
		_g_free0 (_tmp20_[STRUCT_ACTION_SHIFT_RIGHT]);
#line 740 "structure.vala"
		_tmp20_[STRUCT_ACTION_SHIFT_RIGHT] = _tmp21_;
#line 740 "structure.vala"
		_tmp22_ = _tmp20_[STRUCT_ACTION_SHIFT_RIGHT];
#line 741 "structure.vala"
		_tmp23_ = structure__action_names;
#line 741 "structure.vala"
		_tmp23__length1 = structure__action_names_length1;
#line 741 "structure.vala"
		_tmp24_ = g_strdup (_ ("open file"));
#line 741 "structure.vala"
		_g_free0 (_tmp23_[STRUCT_ACTION_OPEN_FILE]);
#line 741 "structure.vala"
		_tmp23_[STRUCT_ACTION_OPEN_FILE] = _tmp24_;
#line 741 "structure.vala"
		_tmp25_ = _tmp23_[STRUCT_ACTION_OPEN_FILE];
#line 3134 "structure.c"
	}
#line 744 "structure.vala"
	_tmp26_ = structure__action_names;
#line 744 "structure.vala"
	_tmp26__length1 = structure__action_names_length1;
#line 744 "structure.vala"
	_tmp27_ = _tmp26_[action_type];
#line 744 "structure.vala"
	_tmp28_ = g_strdup (_tmp27_);
#line 744 "structure.vala"
	result = _tmp28_;
#line 744 "structure.vala"
	return result;
#line 3148 "structure.c"
}


gchar*
structure_get_icon_from_type (StructType type)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp44_;
	gint _tmp44__length1;
	const gchar* _tmp45_;
	gchar* _tmp46_;
#line 749 "structure.vala"
	_tmp0_ = structure__icons;
#line 749 "structure.vala"
	_tmp0__length1 = structure__icons_length1;
#line 749 "structure.vala"
	if (_tmp0_ == NULL) {
#line 3168 "structure.c"
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar** _tmp41_;
		gint _tmp41__length1;
		gchar* _tmp42_;
		gchar* _tmp43_;
#line 751 "structure.vala"
		_tmp1_ = g_new0 (gchar*, STRUCT_TYPE_NB_TYPES + 1);
#line 751 "structure.vala"
		structure__icons = (_vala_array_free (structure__icons, structure__icons_length1, (GDestroyNotify) g_free), NULL);
#line 751 "structure.vala"
		structure__icons = _tmp1_;
#line 751 "structure.vala"
		structure__icons_length1 = STRUCT_TYPE_NB_TYPES;
#line 751 "structure.vala"
		_structure__icons_size_ = structure__icons_length1;
#line 752 "structure.vala"
		_tmp2_ = structure__icons;
#line 752 "structure.vala"
		_tmp2__length1 = structure__icons_length1;
#line 752 "structure.vala"
		_tmp3_ = g_strdup ("tree_part");
#line 752 "structure.vala"
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
#line 752 "structure.vala"
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
#line 752 "structure.vala"
		_tmp4_ = _tmp2_[STRUCT_TYPE_PART];
#line 753 "structure.vala"
		_tmp5_ = structure__icons;
#line 753 "structure.vala"
		_tmp5__length1 = structure__icons_length1;
#line 753 "structure.vala"
		_tmp6_ = g_strdup ("tree_chapter");
#line 753 "structure.vala"
		_g_free0 (_tmp5_[STRUCT_TYPE_CHAPTER]);
#line 753 "structure.vala"
		_tmp5_[STRUCT_TYPE_CHAPTER] = _tmp6_;
#line 753 "structure.vala"
		_tmp7_ = _tmp5_[STRUCT_TYPE_CHAPTER];
#line 754 "structure.vala"
		_tmp8_ = structure__icons;
#line 754 "structure.vala"
		_tmp8__length1 = structure__icons_length1;
#line 754 "structure.vala"
		_tmp9_ = g_strdup ("tree_section");
#line 754 "structure.vala"
		_g_free0 (_tmp8_[STRUCT_TYPE_SECTION]);
#line 754 "structure.vala"
		_tmp8_[STRUCT_TYPE_SECTION] = _tmp9_;
#line 754 "structure.vala"
		_tmp10_ = _tmp8_[STRUCT_TYPE_SECTION];
#line 755 "structure.vala"
		_tmp11_ = structure__icons;
#line 755 "structure.vala"
		_tmp11__length1 = structure__icons_length1;
#line 755 "structure.vala"
		_tmp12_ = g_strdup ("tree_subsection");
#line 755 "structure.vala"
		_g_free0 (_tmp11_[STRUCT_TYPE_SUBSECTION]);
#line 755 "structure.vala"
		_tmp11_[STRUCT_TYPE_SUBSECTION] = _tmp12_;
#line 755 "structure.vala"
		_tmp13_ = _tmp11_[STRUCT_TYPE_SUBSECTION];
#line 756 "structure.vala"
		_tmp14_ = structure__icons;
#line 756 "structure.vala"
		_tmp14__length1 = structure__icons_length1;
#line 756 "structure.vala"
		_tmp15_ = g_strdup ("tree_subsubsection");
#line 756 "structure.vala"
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBSUBSECTION]);
#line 756 "structure.vala"
		_tmp14_[STRUCT_TYPE_SUBSUBSECTION] = _tmp15_;
#line 756 "structure.vala"
		_tmp16_ = _tmp14_[STRUCT_TYPE_SUBSUBSECTION];
#line 757 "structure.vala"
		_tmp17_ = structure__icons;
#line 757 "structure.vala"
		_tmp17__length1 = structure__icons_length1;
#line 757 "structure.vala"
		_tmp18_ = g_strdup ("tree_paragraph");
#line 757 "structure.vala"
		_g_free0 (_tmp17_[STRUCT_TYPE_PARAGRAPH]);
#line 757 "structure.vala"
		_tmp17_[STRUCT_TYPE_PARAGRAPH] = _tmp18_;
#line 757 "structure.vala"
		_tmp19_ = _tmp17_[STRUCT_TYPE_PARAGRAPH];
#line 758 "structure.vala"
		_tmp20_ = structure__icons;
#line 758 "structure.vala"
		_tmp20__length1 = structure__icons_length1;
#line 758 "structure.vala"
		_tmp21_ = g_strdup ("tree_paragraph");
#line 758 "structure.vala"
		_g_free0 (_tmp20_[STRUCT_TYPE_SUBPARAGRAPH]);
#line 758 "structure.vala"
		_tmp20_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp21_;
#line 758 "structure.vala"
		_tmp22_ = _tmp20_[STRUCT_TYPE_SUBPARAGRAPH];
#line 759 "structure.vala"
		_tmp23_ = structure__icons;
#line 759 "structure.vala"
		_tmp23__length1 = structure__icons_length1;
#line 759 "structure.vala"
		_tmp24_ = g_strdup ("tree_label");
#line 759 "structure.vala"
		_g_free0 (_tmp23_[STRUCT_TYPE_LABEL]);
#line 759 "structure.vala"
		_tmp23_[STRUCT_TYPE_LABEL] = _tmp24_;
#line 759 "structure.vala"
		_tmp25_ = _tmp23_[STRUCT_TYPE_LABEL];
#line 760 "structure.vala"
		_tmp26_ = structure__icons;
#line 760 "structure.vala"
		_tmp26__length1 = structure__icons_length1;
#line 760 "structure.vala"
		_tmp27_ = g_strdup ("tree_todo");
#line 760 "structure.vala"
		_g_free0 (_tmp26_[STRUCT_TYPE_TODO]);
#line 760 "structure.vala"
		_tmp26_[STRUCT_TYPE_TODO] = _tmp27_;
#line 760 "structure.vala"
		_tmp28_ = _tmp26_[STRUCT_TYPE_TODO];
#line 761 "structure.vala"
		_tmp29_ = structure__icons;
#line 761 "structure.vala"
		_tmp29__length1 = structure__icons_length1;
#line 761 "structure.vala"
		_tmp30_ = g_strdup ("tree_todo");
#line 761 "structure.vala"
		_g_free0 (_tmp29_[STRUCT_TYPE_FIXME]);
#line 761 "structure.vala"
		_tmp29_[STRUCT_TYPE_FIXME] = _tmp30_;
#line 761 "structure.vala"
		_tmp31_ = _tmp29_[STRUCT_TYPE_FIXME];
#line 762 "structure.vala"
		_tmp32_ = structure__icons;
#line 762 "structure.vala"
		_tmp32__length1 = structure__icons_length1;
#line 762 "structure.vala"
		_tmp33_ = g_strdup ("table");
#line 762 "structure.vala"
		_g_free0 (_tmp32_[STRUCT_TYPE_TABLE]);
#line 762 "structure.vala"
		_tmp32_[STRUCT_TYPE_TABLE] = _tmp33_;
#line 762 "structure.vala"
		_tmp34_ = _tmp32_[STRUCT_TYPE_TABLE];
#line 763 "structure.vala"
		_tmp35_ = structure__icons;
#line 763 "structure.vala"
		_tmp35__length1 = structure__icons_length1;
#line 763 "structure.vala"
		_tmp36_ = g_strdup ("image-x-generic");
#line 763 "structure.vala"
		_g_free0 (_tmp35_[STRUCT_TYPE_FIGURE]);
#line 763 "structure.vala"
		_tmp35_[STRUCT_TYPE_FIGURE] = _tmp36_;
#line 763 "structure.vala"
		_tmp37_ = _tmp35_[STRUCT_TYPE_FIGURE];
#line 764 "structure.vala"
		_tmp38_ = structure__icons;
#line 764 "structure.vala"
		_tmp38__length1 = structure__icons_length1;
#line 764 "structure.vala"
		_tmp39_ = g_strdup ("image-x-generic");
#line 764 "structure.vala"
		_g_free0 (_tmp38_[STRUCT_TYPE_IMAGE]);
#line 764 "structure.vala"
		_tmp38_[STRUCT_TYPE_IMAGE] = _tmp39_;
#line 764 "structure.vala"
		_tmp40_ = _tmp38_[STRUCT_TYPE_IMAGE];
#line 765 "structure.vala"
		_tmp41_ = structure__icons;
#line 765 "structure.vala"
		_tmp41__length1 = structure__icons_length1;
#line 765 "structure.vala"
		_tmp42_ = g_strdup ("text-x-generic");
#line 765 "structure.vala"
		_g_free0 (_tmp41_[STRUCT_TYPE_INCLUDE]);
#line 765 "structure.vala"
		_tmp41_[STRUCT_TYPE_INCLUDE] = _tmp42_;
#line 765 "structure.vala"
		_tmp43_ = _tmp41_[STRUCT_TYPE_INCLUDE];
#line 3404 "structure.c"
	}
#line 768 "structure.vala"
	_tmp44_ = structure__icons;
#line 768 "structure.vala"
	_tmp44__length1 = structure__icons_length1;
#line 768 "structure.vala"
	_tmp45_ = _tmp44_[type];
#line 768 "structure.vala"
	_tmp46_ = g_strdup (_tmp45_);
#line 768 "structure.vala"
	result = _tmp46_;
#line 768 "structure.vala"
	return result;
#line 3418 "structure.c"
}


gchar*
structure_get_type_name (StructType type)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp44_;
	gint _tmp44__length1;
	const gchar* _tmp45_;
	gchar* _tmp46_;
#line 773 "structure.vala"
	_tmp0_ = structure__names;
#line 773 "structure.vala"
	_tmp0__length1 = structure__names_length1;
#line 773 "structure.vala"
	if (_tmp0_ == NULL) {
#line 3438 "structure.c"
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar** _tmp41_;
		gint _tmp41__length1;
		gchar* _tmp42_;
		gchar* _tmp43_;
#line 775 "structure.vala"
		_tmp1_ = g_new0 (gchar*, STRUCT_TYPE_NB_TYPES + 1);
#line 775 "structure.vala"
		structure__names = (_vala_array_free (structure__names, structure__names_length1, (GDestroyNotify) g_free), NULL);
#line 775 "structure.vala"
		structure__names = _tmp1_;
#line 775 "structure.vala"
		structure__names_length1 = STRUCT_TYPE_NB_TYPES;
#line 775 "structure.vala"
		_structure__names_size_ = structure__names_length1;
#line 776 "structure.vala"
		_tmp2_ = structure__names;
#line 776 "structure.vala"
		_tmp2__length1 = structure__names_length1;
#line 776 "structure.vala"
		_tmp3_ = g_strdup (_ ("Part"));
#line 776 "structure.vala"
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
#line 776 "structure.vala"
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
#line 776 "structure.vala"
		_tmp4_ = _tmp2_[STRUCT_TYPE_PART];
#line 777 "structure.vala"
		_tmp5_ = structure__names;
#line 777 "structure.vala"
		_tmp5__length1 = structure__names_length1;
#line 777 "structure.vala"
		_tmp6_ = g_strdup (_ ("Chapter"));
#line 777 "structure.vala"
		_g_free0 (_tmp5_[STRUCT_TYPE_CHAPTER]);
#line 777 "structure.vala"
		_tmp5_[STRUCT_TYPE_CHAPTER] = _tmp6_;
#line 777 "structure.vala"
		_tmp7_ = _tmp5_[STRUCT_TYPE_CHAPTER];
#line 778 "structure.vala"
		_tmp8_ = structure__names;
#line 778 "structure.vala"
		_tmp8__length1 = structure__names_length1;
#line 778 "structure.vala"
		_tmp9_ = g_strdup (_ ("Section"));
#line 778 "structure.vala"
		_g_free0 (_tmp8_[STRUCT_TYPE_SECTION]);
#line 778 "structure.vala"
		_tmp8_[STRUCT_TYPE_SECTION] = _tmp9_;
#line 778 "structure.vala"
		_tmp10_ = _tmp8_[STRUCT_TYPE_SECTION];
#line 779 "structure.vala"
		_tmp11_ = structure__names;
#line 779 "structure.vala"
		_tmp11__length1 = structure__names_length1;
#line 779 "structure.vala"
		_tmp12_ = g_strdup (_ ("Sub-section"));
#line 779 "structure.vala"
		_g_free0 (_tmp11_[STRUCT_TYPE_SUBSECTION]);
#line 779 "structure.vala"
		_tmp11_[STRUCT_TYPE_SUBSECTION] = _tmp12_;
#line 779 "structure.vala"
		_tmp13_ = _tmp11_[STRUCT_TYPE_SUBSECTION];
#line 780 "structure.vala"
		_tmp14_ = structure__names;
#line 780 "structure.vala"
		_tmp14__length1 = structure__names_length1;
#line 780 "structure.vala"
		_tmp15_ = g_strdup (_ ("Sub-sub-section"));
#line 780 "structure.vala"
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBSUBSECTION]);
#line 780 "structure.vala"
		_tmp14_[STRUCT_TYPE_SUBSUBSECTION] = _tmp15_;
#line 780 "structure.vala"
		_tmp16_ = _tmp14_[STRUCT_TYPE_SUBSUBSECTION];
#line 781 "structure.vala"
		_tmp17_ = structure__names;
#line 781 "structure.vala"
		_tmp17__length1 = structure__names_length1;
#line 781 "structure.vala"
		_tmp18_ = g_strdup (_ ("Paragraph"));
#line 781 "structure.vala"
		_g_free0 (_tmp17_[STRUCT_TYPE_PARAGRAPH]);
#line 781 "structure.vala"
		_tmp17_[STRUCT_TYPE_PARAGRAPH] = _tmp18_;
#line 781 "structure.vala"
		_tmp19_ = _tmp17_[STRUCT_TYPE_PARAGRAPH];
#line 782 "structure.vala"
		_tmp20_ = structure__names;
#line 782 "structure.vala"
		_tmp20__length1 = structure__names_length1;
#line 782 "structure.vala"
		_tmp21_ = g_strdup (_ ("Sub-paragraph"));
#line 782 "structure.vala"
		_g_free0 (_tmp20_[STRUCT_TYPE_SUBPARAGRAPH]);
#line 782 "structure.vala"
		_tmp20_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp21_;
#line 782 "structure.vala"
		_tmp22_ = _tmp20_[STRUCT_TYPE_SUBPARAGRAPH];
#line 783 "structure.vala"
		_tmp23_ = structure__names;
#line 783 "structure.vala"
		_tmp23__length1 = structure__names_length1;
#line 783 "structure.vala"
		_tmp24_ = g_strdup (_ ("Label"));
#line 783 "structure.vala"
		_g_free0 (_tmp23_[STRUCT_TYPE_LABEL]);
#line 783 "structure.vala"
		_tmp23_[STRUCT_TYPE_LABEL] = _tmp24_;
#line 783 "structure.vala"
		_tmp25_ = _tmp23_[STRUCT_TYPE_LABEL];
#line 784 "structure.vala"
		_tmp26_ = structure__names;
#line 784 "structure.vala"
		_tmp26__length1 = structure__names_length1;
#line 784 "structure.vala"
		_tmp27_ = g_strdup ("TODO");
#line 784 "structure.vala"
		_g_free0 (_tmp26_[STRUCT_TYPE_TODO]);
#line 784 "structure.vala"
		_tmp26_[STRUCT_TYPE_TODO] = _tmp27_;
#line 784 "structure.vala"
		_tmp28_ = _tmp26_[STRUCT_TYPE_TODO];
#line 785 "structure.vala"
		_tmp29_ = structure__names;
#line 785 "structure.vala"
		_tmp29__length1 = structure__names_length1;
#line 785 "structure.vala"
		_tmp30_ = g_strdup ("FIXME");
#line 785 "structure.vala"
		_g_free0 (_tmp29_[STRUCT_TYPE_FIXME]);
#line 785 "structure.vala"
		_tmp29_[STRUCT_TYPE_FIXME] = _tmp30_;
#line 785 "structure.vala"
		_tmp31_ = _tmp29_[STRUCT_TYPE_FIXME];
#line 786 "structure.vala"
		_tmp32_ = structure__names;
#line 786 "structure.vala"
		_tmp32__length1 = structure__names_length1;
#line 786 "structure.vala"
		_tmp33_ = g_strdup (_ ("Table"));
#line 786 "structure.vala"
		_g_free0 (_tmp32_[STRUCT_TYPE_TABLE]);
#line 786 "structure.vala"
		_tmp32_[STRUCT_TYPE_TABLE] = _tmp33_;
#line 786 "structure.vala"
		_tmp34_ = _tmp32_[STRUCT_TYPE_TABLE];
#line 788 "structure.vala"
		_tmp35_ = structure__names;
#line 788 "structure.vala"
		_tmp35__length1 = structure__names_length1;
#line 788 "structure.vala"
		_tmp36_ = g_strdup (_ ("Figure"));
#line 788 "structure.vala"
		_g_free0 (_tmp35_[STRUCT_TYPE_FIGURE]);
#line 788 "structure.vala"
		_tmp35_[STRUCT_TYPE_FIGURE] = _tmp36_;
#line 788 "structure.vala"
		_tmp37_ = _tmp35_[STRUCT_TYPE_FIGURE];
#line 789 "structure.vala"
		_tmp38_ = structure__names;
#line 789 "structure.vala"
		_tmp38__length1 = structure__names_length1;
#line 789 "structure.vala"
		_tmp39_ = g_strdup (_ ("Image"));
#line 789 "structure.vala"
		_g_free0 (_tmp38_[STRUCT_TYPE_IMAGE]);
#line 789 "structure.vala"
		_tmp38_[STRUCT_TYPE_IMAGE] = _tmp39_;
#line 789 "structure.vala"
		_tmp40_ = _tmp38_[STRUCT_TYPE_IMAGE];
#line 790 "structure.vala"
		_tmp41_ = structure__names;
#line 790 "structure.vala"
		_tmp41__length1 = structure__names_length1;
#line 790 "structure.vala"
		_tmp42_ = g_strdup (_ ("File included"));
#line 790 "structure.vala"
		_g_free0 (_tmp41_[STRUCT_TYPE_INCLUDE]);
#line 790 "structure.vala"
		_tmp41_[STRUCT_TYPE_INCLUDE] = _tmp42_;
#line 790 "structure.vala"
		_tmp43_ = _tmp41_[STRUCT_TYPE_INCLUDE];
#line 3674 "structure.c"
	}
#line 793 "structure.vala"
	_tmp44_ = structure__names;
#line 793 "structure.vala"
	_tmp44__length1 = structure__names_length1;
#line 793 "structure.vala"
	_tmp45_ = _tmp44_[type];
#line 793 "structure.vala"
	_tmp46_ = g_strdup (_tmp45_);
#line 793 "structure.vala"
	result = _tmp46_;
#line 793 "structure.vala"
	return result;
#line 3688 "structure.c"
}


static void
structure_class_init (StructureClass * klass)
{
#line 92 "structure.vala"
	structure_parent_class = g_type_class_peek_parent (klass);
#line 92 "structure.vala"
	g_type_class_adjust_private_offset (klass, &Structure_private_offset);
#line 92 "structure.vala"
	G_OBJECT_CLASS (klass)->finalize = structure_finalize;
#line 92 "structure.vala"
	structure_signals[STRUCTURE_NO_ITEMS_SELECTED_SIGNAL] = g_signal_new ("no-items-selected", TYPE_STRUCTURE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 92 "structure.vala"
	structure_signals[STRUCTURE_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", TYPE_STRUCTURE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_STRUCT_TYPE);
#line 92 "structure.vala"
	structure_signals[STRUCTURE_SHOW_POPUP_MENU_SIGNAL] = g_signal_new ("show-popup-menu", TYPE_STRUCTURE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gdk_event_get_type ());
#line 3707 "structure.c"
}


static void
structure_instance_init (Structure * self)
{
	GtkToggleToolButton** _tmp0_;
#line 92 "structure.vala"
	self->priv = structure_get_instance_private (self);
#line 96 "structure.vala"
	_tmp0_ = g_new0 (GtkToggleToolButton*, 0 + 1);
#line 96 "structure.vala"
	self->priv->_simple_list_buttons = _tmp0_;
#line 96 "structure.vala"
	self->priv->_simple_list_buttons_length1 = 0;
#line 96 "structure.vala"
	self->priv->__simple_list_buttons_size_ = self->priv->_simple_list_buttons_length1;
#line 100 "structure.vala"
	self->priv->_document_structure = NULL;
#line 101 "structure.vala"
	self->priv->_model = NULL;
#line 109 "structure.vala"
	self->priv->_list_is_hidden = TRUE;
#line 111 "structure.vala"
	self->priv->_first_select = TRUE;
#line 3733 "structure.c"
}


static void
structure_finalize (GObject * obj)
{
	Structure * self;
#line 92 "structure.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRUCTURE, Structure);
#line 96 "structure.vala"
	self->priv->_simple_list_buttons = (_vala_array_free (self->priv->_simple_list_buttons, self->priv->_simple_list_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
#line 97 "structure.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 99 "structure.vala"
	_g_object_unref0 (self->priv->_tree_view);
#line 100 "structure.vala"
	_g_object_unref0 (self->priv->_document_structure);
#line 101 "structure.vala"
	_g_object_unref0 (self->priv->_model);
#line 103 "structure.vala"
	_g_object_unref0 (self->priv->_list_view);
#line 104 "structure.vala"
	_g_object_unref0 (self->priv->_list_view_sw);
#line 105 "structure.vala"
	_g_object_unref0 (self->priv->_list_store);
#line 92 "structure.vala"
	G_OBJECT_CLASS (structure_parent_class)->finalize (obj);
#line 3761 "structure.c"
}


GType
structure_get_type (void)
{
	static volatile gsize structure_type_id__volatile = 0;
	if (g_once_init_enter (&structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Structure), 0, (GInstanceInitFunc) structure_instance_init, NULL };
		GType structure_type_id;
		structure_type_id = g_type_register_static (gtk_grid_get_type (), "Structure", &g_define_type_info, 0);
		Structure_private_offset = g_type_add_instance_private (structure_type_id, sizeof (StructurePrivate));
		g_once_init_leave (&structure_type_id__volatile, structure_type_id);
	}
	return structure_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 183 "project_dialogs.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3787 "structure.c"
		int i;
#line 183 "project_dialogs.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 183 "project_dialogs.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 183 "project_dialogs.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3795 "structure.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 183 "project_dialogs.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 183 "project_dialogs.vala"
	g_free (array);
#line 3811 "structure.c"
}



