/* document_tab.c generated by valac 0.40.0.227-717ea, the Vala compiler
 * generated from document_tab.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010, 2011, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <tepl/tepl.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
typedef struct _DocumentTabPrivate DocumentTabPrivate;
enum  {
	DOCUMENT_TAB_0_PROPERTY,
	DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY,
	DOCUMENT_TAB_DOCUMENT_PROPERTY,
	DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY,
	DOCUMENT_TAB_AUTO_SAVE_PROPERTY,
	DOCUMENT_TAB_NUM_PROPERTIES
};
static GParamSpec* document_tab_properties[DOCUMENT_TAB_NUM_PROPERTIES];

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DocumentPrivate DocumentPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block14Data Block14Data;

struct _DocumentTab {
	TeplTab parent_instance;
	DocumentTabPrivate * priv;
};

struct _DocumentTabClass {
	TeplTabClass parent_class;
};

struct _DocumentTabPrivate {
	gboolean ask_if_externally_modified;
	guint auto_save_timeout;
	guint _auto_save_interval;
	gboolean _auto_save;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _Block14Data {
	int _ref_count_;
	DocumentTab* self;
	TeplInfoBar* infobar;
};


static gint DocumentTab_private_offset;
static gpointer document_tab_parent_class = NULL;

GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
GType document_view_get_type (void) G_GNUC_CONST;
Document* document_new (void);
Document* document_construct (GType object_type);
GType document_get_type (void) G_GNUC_CONST;
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type,
                                       Document* doc);
static void document_tab_initialize (DocumentTab* self);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type,
                                                   GFile* location);
Document* document_tab_get_document (DocumentTab* self);
void document_load (Document* self,
                    GFile* location);
DocumentTab* document_tab_new_with_view (DocumentView* document_view);
DocumentTab* document_tab_construct_with_view (GType object_type,
                                               DocumentView* document_view);
DocumentView* document_tab_get_document_view (DocumentTab* self);
static gboolean document_tab_view_focused_in (DocumentTab* self);
static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                  GdkEventFocus* event,
                                                                  gpointer self);
TeplView* tepl_tab_get_view (TeplTab* self);
void document_tab_set_auto_save (DocumentTab* self,
                                 gboolean value);
void document_tab_set_auto_save_interval (DocumentTab* self,
                                          guint value);
static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self);
static void __lambda21_ (DocumentTab* self);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
gchar* document_tab_get_menu_tip (DocumentTab* self);
gchar* document_get_uri_for_display (Document* self);
gboolean document_is_externally_modified (Document* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
GFile* document_get_location (Document* self);
static void ___lambda20_ (Block14Data* _data14_,
                   gint response_id);
static void ____lambda20__gtk_info_bar_response (GtkInfoBar* _sender,
                                          gint response_id,
                                          gpointer self);
static void document_tab_install_auto_save_timeout (DocumentTab* self);
gboolean document_tab_get_auto_save (DocumentTab* self);
guint document_tab_get_auto_save_interval (DocumentTab* self);
static gboolean document_tab_on_auto_save (DocumentTab* self);
static gboolean _document_tab_on_auto_save_gsource_func (gpointer self);
gboolean document_get_readonly (Document* self);
static void document_tab_remove_auto_save_timeout (DocumentTab* self);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
static void document_tab_finalize (GObject * obj);
static void _vala_document_tab_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_document_tab_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);


static inline gpointer
document_tab_get_instance_private (DocumentTab* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentTab_private_offset);
}


DocumentTab*
document_tab_construct (GType object_type)
{
	DocumentTab * self = NULL;
	DocumentView* document_view = NULL;
	Document* _tmp0_;
	Document* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 103 "document_tab.vala"
	_tmp0_ = document_new ();
#line 103 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 103 "document_tab.vala"
	_tmp2_ = document_view_new (_tmp1_);
#line 103 "document_tab.vala"
	g_object_ref_sink (_tmp2_);
#line 103 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 103 "document_tab.vala"
	_g_object_unref0 (_tmp1_);
#line 103 "document_tab.vala"
	document_view = _tmp3_;
#line 104 "document_tab.vala"
	self = (DocumentTab*) g_object_new (object_type, "view", document_view, NULL);
#line 105 "document_tab.vala"
	document_tab_initialize (self);
#line 101 "document_tab.vala"
	_g_object_unref0 (document_view);
#line 101 "document_tab.vala"
	return self;
#line 221 "document_tab.c"
}


DocumentTab*
document_tab_new (void)
{
#line 101 "document_tab.vala"
	return document_tab_construct (TYPE_DOCUMENT_TAB);
#line 230 "document_tab.c"
}


DocumentTab*
document_tab_construct_from_location (GType object_type,
                                      GFile* location)
{
	DocumentTab * self = NULL;
	Document* _tmp0_;
	Document* _tmp1_;
#line 108 "document_tab.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 110 "document_tab.vala"
	self = (DocumentTab*) document_tab_construct (object_type);
#line 111 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 111 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 111 "document_tab.vala"
	document_load (_tmp1_, location);
#line 108 "document_tab.vala"
	return self;
#line 253 "document_tab.c"
}


DocumentTab*
document_tab_new_from_location (GFile* location)
{
#line 108 "document_tab.vala"
	return document_tab_construct_from_location (TYPE_DOCUMENT_TAB, location);
#line 262 "document_tab.c"
}


DocumentTab*
document_tab_construct_with_view (GType object_type,
                                  DocumentView* document_view)
{
	DocumentTab * self = NULL;
#line 114 "document_tab.vala"
	g_return_val_if_fail (document_view != NULL, NULL);
#line 116 "document_tab.vala"
	self = (DocumentTab*) g_object_new (object_type, "view", document_view, NULL);
#line 117 "document_tab.vala"
	document_tab_initialize (self);
#line 114 "document_tab.vala"
	return self;
#line 279 "document_tab.c"
}


DocumentTab*
document_tab_new_with_view (DocumentView* document_view)
{
#line 114 "document_tab.vala"
	return document_tab_construct_with_view (TYPE_DOCUMENT_TAB, document_view);
#line 288 "document_tab.c"
}


static gboolean
_document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                         GdkEventFocus* event,
                                                         gpointer self)
{
	gboolean result;
	result = document_tab_view_focused_in ((DocumentTab*) self);
#line 124 "document_tab.vala"
	return result;
#line 301 "document_tab.c"
}


static void
__lambda21_ (DocumentTab* self)
{
	guint _tmp0_;
#line 140 "document_tab.vala"
	_tmp0_ = self->priv->auto_save_timeout;
#line 140 "document_tab.vala"
	if (_tmp0_ <= ((guint) 0)) {
#line 141 "document_tab.vala"
		document_tab_install_auto_save_timeout_if_needed (self);
#line 315 "document_tab.c"
	}
}


static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 138 "document_tab.vala"
	__lambda21_ ((DocumentTab*) self);
#line 327 "document_tab.c"
}


static void
document_tab_initialize (DocumentTab* self)
{
	Document* _tmp0_;
	Document* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	TeplView* _tmp4_;
	TeplView* _tmp5_;
	GSettings* settings = NULL;
	GSettings* _tmp6_;
	guint tmp = 0U;
	Document* _tmp7_;
	Document* _tmp8_;
#line 120 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 122 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 122 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 122 "document_tab.vala"
	_tmp1_->tab = self;
#line 124 "document_tab.vala"
	_tmp2_ = document_tab_get_document_view (self);
#line 124 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 124 "document_tab.vala"
	g_signal_connect_object ((GtkWidget*) _tmp3_, "focus-in-event", (GCallback) _document_tab_view_focused_in_gtk_widget_focus_in_event, self, 0);
#line 126 "document_tab.vala"
	_tmp4_ = tepl_tab_get_view ((TeplTab*) self);
#line 126 "document_tab.vala"
	_tmp5_ = _tmp4_;
#line 126 "document_tab.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
#line 129 "document_tab.vala"
	_tmp6_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 129 "document_tab.vala"
	settings = _tmp6_;
#line 131 "document_tab.vala"
	document_tab_set_auto_save (self, g_settings_get_boolean (settings, "auto-save"));
#line 133 "document_tab.vala"
	g_settings_get (settings, "auto-save-interval", "u", &tmp);
#line 134 "document_tab.vala"
	document_tab_set_auto_save_interval (self, tmp);
#line 136 "document_tab.vala"
	document_tab_install_auto_save_timeout_if_needed (self);
#line 138 "document_tab.vala"
	_tmp7_ = document_tab_get_document (self);
#line 138 "document_tab.vala"
	_tmp8_ = _tmp7_;
#line 138 "document_tab.vala"
	g_signal_connect_object ((GObject*) _tmp8_, "notify::location", (GCallback) ___lambda21__g_object_notify, self, 0);
#line 120 "document_tab.vala"
	_g_object_unref0 (settings);
#line 385 "document_tab.c"
}


gchar*
document_tab_get_menu_tip (DocumentTab* self)
{
	gchar* result = NULL;
	Document* _tmp0_;
	Document* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 145 "document_tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 147 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 147 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 147 "document_tab.vala"
	_tmp2_ = document_get_uri_for_display (_tmp1_);
#line 147 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 147 "document_tab.vala"
	_tmp4_ = g_strdup_printf (_ ("Activate “%s”"), _tmp3_);
#line 147 "document_tab.vala"
	_tmp5_ = _tmp4_;
#line 147 "document_tab.vala"
	_g_free0 (_tmp3_);
#line 147 "document_tab.vala"
	result = _tmp5_;
#line 147 "document_tab.vala"
	return result;
#line 419 "document_tab.c"
}


static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
#line 162 "document_tab.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 162 "document_tab.vala"
	return _data14_;
#line 430 "document_tab.c"
}


static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 162 "document_tab.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 441 "document_tab.c"
		DocumentTab* self;
#line 162 "document_tab.vala"
		self = _data14_->self;
#line 162 "document_tab.vala"
		_g_object_unref0 (_data14_->infobar);
#line 162 "document_tab.vala"
		g_slice_free (Block14Data, _data14_);
#line 449 "document_tab.c"
	}
}


static void
___lambda20_ (Block14Data* _data14_,
              gint response_id)
{
	DocumentTab* self;
	TeplInfoBar* _tmp6_;
	DocumentView* _tmp7_;
	DocumentView* _tmp8_;
#line 182 "document_tab.vala"
	self = _data14_->self;
#line 184 "document_tab.vala"
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
#line 466 "document_tab.c"
		Document* _tmp0_;
		Document* _tmp1_;
		Document* _tmp2_;
		Document* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
#line 186 "document_tab.vala"
		_tmp0_ = document_tab_get_document (self);
#line 186 "document_tab.vala"
		_tmp1_ = _tmp0_;
#line 186 "document_tab.vala"
		_tmp2_ = document_tab_get_document (self);
#line 186 "document_tab.vala"
		_tmp3_ = _tmp2_;
#line 186 "document_tab.vala"
		_tmp4_ = document_get_location (_tmp3_);
#line 186 "document_tab.vala"
		_tmp5_ = _tmp4_;
#line 186 "document_tab.vala"
		document_load (_tmp1_, _tmp5_);
#line 187 "document_tab.vala"
		self->priv->ask_if_externally_modified = FALSE;
#line 489 "document_tab.c"
	}
#line 190 "document_tab.vala"
	_tmp6_ = _data14_->infobar;
#line 190 "document_tab.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
#line 191 "document_tab.vala"
	_tmp7_ = document_tab_get_document_view (self);
#line 191 "document_tab.vala"
	_tmp8_ = _tmp7_;
#line 191 "document_tab.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
#line 501 "document_tab.c"
}


static void
____lambda20__gtk_info_bar_response (GtkInfoBar* _sender,
                                     gint response_id,
                                     gpointer self)
{
#line 182 "document_tab.vala"
	___lambda20_ (self, response_id);
#line 512 "document_tab.c"
}


static gboolean
document_tab_view_focused_in (DocumentTab* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	TeplBuffer* _tmp1_;
	TeplFile* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
#line 150 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "document_tab.vala"
	_tmp0_ = self->priv->ask_if_externally_modified;
#line 155 "document_tab.vala"
	if (_tmp0_) {
#line 156 "document_tab.vala"
		result = FALSE;
#line 156 "document_tab.vala"
		return result;
#line 535 "document_tab.c"
	}
#line 159 "document_tab.vala"
	_tmp1_ = tepl_tab_get_buffer ((TeplTab*) self);
#line 159 "document_tab.vala"
	_tmp2_ = tepl_buffer_get_file (_tmp1_);
#line 159 "document_tab.vala"
	if (!tepl_file_is_local (_tmp2_)) {
#line 160 "document_tab.vala"
		result = FALSE;
#line 160 "document_tab.vala"
		return result;
#line 547 "document_tab.c"
	}
#line 162 "document_tab.vala"
	_tmp3_ = document_tab_get_document (self);
#line 162 "document_tab.vala"
	_tmp4_ = _tmp3_;
#line 162 "document_tab.vala"
	if (document_is_externally_modified (_tmp4_)) {
#line 555 "document_tab.c"
		Block14Data* _data14_;
		gchar* primary_msg = NULL;
		Document* _tmp5_;
		Document* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* secondary_msg = NULL;
		Document* _tmp13_;
		Document* _tmp14_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		TeplInfoBar* _tmp19_;
		TeplInfoBar* _tmp20_;
		TeplInfoBar* _tmp21_;
		TeplInfoBar* _tmp22_;
		TeplInfoBar* _tmp23_;
		TeplInfoBar* _tmp24_;
		GClosure* _tmp25_;
#line 162 "document_tab.vala"
		_data14_ = g_slice_new0 (Block14Data);
#line 162 "document_tab.vala"
		_data14_->_ref_count_ = 1;
#line 162 "document_tab.vala"
		_data14_->self = self;
#line 164 "document_tab.vala"
		self->priv->ask_if_externally_modified = TRUE;
#line 166 "document_tab.vala"
		_tmp5_ = document_tab_get_document (self);
#line 166 "document_tab.vala"
		_tmp6_ = _tmp5_;
#line 166 "document_tab.vala"
		_tmp7_ = document_get_location (_tmp6_);
#line 166 "document_tab.vala"
		_tmp8_ = _tmp7_;
#line 166 "document_tab.vala"
		_tmp9_ = g_file_get_parse_name (_tmp8_);
#line 166 "document_tab.vala"
		_tmp10_ = _tmp9_;
#line 166 "document_tab.vala"
		_tmp11_ = g_strdup_printf (_ ("The file %s changed on disk."), _tmp10_);
#line 166 "document_tab.vala"
		_tmp12_ = _tmp11_;
#line 166 "document_tab.vala"
		_g_free0 (_tmp10_);
#line 166 "document_tab.vala"
		primary_msg = _tmp12_;
#line 170 "document_tab.vala"
		_tmp13_ = document_tab_get_document (self);
#line 170 "document_tab.vala"
		_tmp14_ = _tmp13_;
#line 170 "document_tab.vala"
		if (gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp14_)) {
#line 612 "document_tab.c"
			gchar* _tmp15_;
#line 171 "document_tab.vala"
			_tmp15_ = g_strdup (_ ("Do you want to drop your changes and reload the file?"));
#line 171 "document_tab.vala"
			_g_free0 (secondary_msg);
#line 171 "document_tab.vala"
			secondary_msg = _tmp15_;
#line 620 "document_tab.c"
		} else {
			gchar* _tmp16_;
#line 173 "document_tab.vala"
			_tmp16_ = g_strdup (_ ("Do you want to reload the file?"));
#line 173 "document_tab.vala"
			_g_free0 (secondary_msg);
#line 173 "document_tab.vala"
			secondary_msg = _tmp16_;
#line 629 "document_tab.c"
		}
#line 175 "document_tab.vala"
		_tmp17_ = primary_msg;
#line 175 "document_tab.vala"
		_tmp18_ = secondary_msg;
#line 175 "document_tab.vala"
		_tmp19_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp17_, _tmp18_);
#line 175 "document_tab.vala"
		g_object_ref_sink (_tmp19_);
#line 175 "document_tab.vala"
		_data14_->infobar = _tmp19_;
#line 177 "document_tab.vala"
		_tmp20_ = _data14_->infobar;
#line 177 "document_tab.vala"
		gtk_info_bar_add_button ((GtkInfoBar*) _tmp20_, _ ("_Reload"), (gint) GTK_RESPONSE_OK);
#line 178 "document_tab.vala"
		_tmp21_ = _data14_->infobar;
#line 178 "document_tab.vala"
		gtk_info_bar_add_button ((GtkInfoBar*) _tmp21_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 179 "document_tab.vala"
		_tmp22_ = _data14_->infobar;
#line 179 "document_tab.vala"
		tepl_tab_add_info_bar ((TeplTab*) self, (GtkInfoBar*) _tmp22_);
#line 180 "document_tab.vala"
		_tmp23_ = _data14_->infobar;
#line 180 "document_tab.vala"
		gtk_widget_show ((GtkWidget*) _tmp23_);
#line 182 "document_tab.vala"
		_tmp24_ = _data14_->infobar;
#line 182 "document_tab.vala"
		_tmp25_ = g_cclosure_new ((GCallback) ____lambda20__gtk_info_bar_response, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref);
#line 182 "document_tab.vala"
		g_object_watch_closure ((GObject *) self, _tmp25_);
#line 182 "document_tab.vala"
		g_signal_connect_closure ((GtkInfoBar*) _tmp24_, "response", _tmp25_, FALSE);
#line 162 "document_tab.vala"
		_g_free0 (secondary_msg);
#line 162 "document_tab.vala"
		_g_free0 (primary_msg);
#line 162 "document_tab.vala"
		block14_data_unref (_data14_);
#line 162 "document_tab.vala"
		_data14_ = NULL;
#line 673 "document_tab.c"
	}
#line 195 "document_tab.vala"
	result = FALSE;
#line 195 "document_tab.vala"
	return result;
#line 679 "document_tab.c"
}


static gboolean
_document_tab_on_auto_save_gsource_func (gpointer self)
{
	gboolean result;
	result = document_tab_on_auto_save ((DocumentTab*) self);
#line 204 "document_tab.vala"
	return result;
#line 690 "document_tab.c"
}


static void
document_tab_install_auto_save_timeout (DocumentTab* self)
{
	guint _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
#line 198 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 200 "document_tab.vala"
	_tmp0_ = self->priv->auto_save_timeout;
#line 200 "document_tab.vala"
	g_return_if_fail (_tmp0_ <= ((guint) 0));
#line 201 "document_tab.vala"
	_tmp1_ = document_tab_get_auto_save (self);
#line 201 "document_tab.vala"
	_tmp2_ = _tmp1_;
#line 201 "document_tab.vala"
	g_return_if_fail (_tmp2_);
#line 202 "document_tab.vala"
	_tmp3_ = document_tab_get_auto_save_interval (self);
#line 202 "document_tab.vala"
	_tmp4_ = _tmp3_;
#line 202 "document_tab.vala"
	g_return_if_fail (_tmp4_ > ((guint) 0));
#line 204 "document_tab.vala"
	_tmp5_ = document_tab_get_auto_save_interval (self);
#line 204 "document_tab.vala"
	_tmp6_ = _tmp5_;
#line 204 "document_tab.vala"
	self->priv->auto_save_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp6_ * 60, _document_tab_on_auto_save_gsource_func, g_object_ref (self), g_object_unref);
#line 728 "document_tab.c"
}


static gboolean
document_tab_install_auto_save_timeout_if_needed (DocumentTab* self)
{
	gboolean result = FALSE;
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 207 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 209 "document_tab.vala"
	_tmp0_ = self->priv->auto_save_timeout;
#line 209 "document_tab.vala"
	g_return_val_if_fail (_tmp0_ <= ((guint) 0), FALSE);
#line 211 "document_tab.vala"
	_tmp3_ = document_tab_get_auto_save (self);
#line 211 "document_tab.vala"
	_tmp4_ = _tmp3_;
#line 211 "document_tab.vala"
	if (_tmp4_) {
#line 753 "document_tab.c"
		Document* _tmp5_;
		Document* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
#line 211 "document_tab.vala"
		_tmp5_ = document_tab_get_document (self);
#line 211 "document_tab.vala"
		_tmp6_ = _tmp5_;
#line 211 "document_tab.vala"
		_tmp7_ = document_get_location (_tmp6_);
#line 211 "document_tab.vala"
		_tmp8_ = _tmp7_;
#line 211 "document_tab.vala"
		_tmp2_ = _tmp8_ != NULL;
#line 768 "document_tab.c"
	} else {
#line 211 "document_tab.vala"
		_tmp2_ = FALSE;
#line 772 "document_tab.c"
	}
#line 211 "document_tab.vala"
	if (_tmp2_) {
#line 776 "document_tab.c"
		Document* _tmp9_;
		Document* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
#line 211 "document_tab.vala"
		_tmp9_ = document_tab_get_document (self);
#line 211 "document_tab.vala"
		_tmp10_ = _tmp9_;
#line 211 "document_tab.vala"
		_tmp11_ = document_get_readonly (_tmp10_);
#line 211 "document_tab.vala"
		_tmp12_ = _tmp11_;
#line 211 "document_tab.vala"
		_tmp1_ = !_tmp12_;
#line 791 "document_tab.c"
	} else {
#line 211 "document_tab.vala"
		_tmp1_ = FALSE;
#line 795 "document_tab.c"
	}
#line 211 "document_tab.vala"
	if (_tmp1_) {
#line 213 "document_tab.vala"
		document_tab_install_auto_save_timeout (self);
#line 214 "document_tab.vala"
		result = TRUE;
#line 214 "document_tab.vala"
		return result;
#line 805 "document_tab.c"
	}
#line 217 "document_tab.vala"
	result = FALSE;
#line 217 "document_tab.vala"
	return result;
#line 811 "document_tab.c"
}


static void
document_tab_remove_auto_save_timeout (DocumentTab* self)
{
	guint _tmp0_;
	guint _tmp1_;
#line 220 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 222 "document_tab.vala"
	_tmp0_ = self->priv->auto_save_timeout;
#line 222 "document_tab.vala"
	g_return_if_fail (_tmp0_ > ((guint) 0));
#line 224 "document_tab.vala"
	_tmp1_ = self->priv->auto_save_timeout;
#line 224 "document_tab.vala"
	g_source_remove (_tmp1_);
#line 225 "document_tab.vala"
	self->priv->auto_save_timeout = (guint) 0;
#line 832 "document_tab.c"
}


static gboolean
document_tab_on_auto_save (DocumentTab* self)
{
	gboolean result = FALSE;
	Document* _tmp0_;
	Document* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	guint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	Document* _tmp13_;
	Document* _tmp14_;
#line 228 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 230 "document_tab.vala"
	_tmp0_ = document_tab_get_document (self);
#line 230 "document_tab.vala"
	_tmp1_ = _tmp0_;
#line 230 "document_tab.vala"
	_tmp2_ = document_get_location (_tmp1_);
#line 230 "document_tab.vala"
	_tmp3_ = _tmp2_;
#line 230 "document_tab.vala"
	g_return_val_if_fail (_tmp3_ != NULL, FALSE);
#line 231 "document_tab.vala"
	_tmp4_ = document_tab_get_document (self);
#line 231 "document_tab.vala"
	_tmp5_ = _tmp4_;
#line 231 "document_tab.vala"
	_tmp6_ = document_get_readonly (_tmp5_);
#line 231 "document_tab.vala"
	_tmp7_ = _tmp6_;
#line 231 "document_tab.vala"
	g_return_val_if_fail (!_tmp7_, FALSE);
#line 232 "document_tab.vala"
	_tmp8_ = self->priv->auto_save_timeout;
#line 232 "document_tab.vala"
	g_return_val_if_fail (_tmp8_ > ((guint) 0), FALSE);
#line 233 "document_tab.vala"
	_tmp9_ = document_tab_get_auto_save (self);
#line 233 "document_tab.vala"
	_tmp10_ = _tmp9_;
#line 233 "document_tab.vala"
	g_return_val_if_fail (_tmp10_, FALSE);
#line 234 "document_tab.vala"
	_tmp11_ = document_tab_get_auto_save_interval (self);
#line 234 "document_tab.vala"
	_tmp12_ = _tmp11_;
#line 234 "document_tab.vala"
	g_return_val_if_fail (_tmp12_ > ((guint) 0), FALSE);
#line 236 "document_tab.vala"
	_tmp13_ = document_tab_get_document (self);
#line 236 "document_tab.vala"
	_tmp14_ = _tmp13_;
#line 236 "document_tab.vala"
	if (gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp14_)) {
#line 899 "document_tab.c"
		Document* _tmp15_;
		Document* _tmp16_;
#line 237 "document_tab.vala"
		_tmp15_ = document_tab_get_document (self);
#line 237 "document_tab.vala"
		_tmp16_ = _tmp15_;
#line 237 "document_tab.vala"
		document_save (_tmp16_, TRUE, FALSE);
#line 908 "document_tab.c"
	}
#line 239 "document_tab.vala"
	result = TRUE;
#line 239 "document_tab.vala"
	return result;
#line 914 "document_tab.c"
}


DocumentView*
document_tab_get_document_view (DocumentTab* self)
{
	DocumentView* result;
	TeplView* _tmp0_;
#line 26 "document_tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "document_tab.vala"
	_tmp0_ = tepl_tab_get_view ((TeplTab*) self);
#line 26 "document_tab.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DOCUMENT_VIEW) ? ((DocumentView*) _tmp0_) : NULL;
#line 26 "document_tab.vala"
	return result;
#line 931 "document_tab.c"
}


Document*
document_tab_get_document (DocumentTab* self)
{
	Document* result;
	TeplBuffer* _tmp0_;
#line 31 "document_tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "document_tab.vala"
	_tmp0_ = tepl_tab_get_buffer ((TeplTab*) self);
#line 31 "document_tab.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DOCUMENT) ? ((Document*) _tmp0_) : NULL;
#line 31 "document_tab.vala"
	return result;
#line 948 "document_tab.c"
}


guint
document_tab_get_auto_save_interval (DocumentTab* self)
{
	guint result;
	guint _tmp0_;
#line 41 "document_tab.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 43 "document_tab.vala"
	_tmp0_ = self->priv->_auto_save_interval;
#line 43 "document_tab.vala"
	result = _tmp0_;
#line 43 "document_tab.vala"
	return result;
#line 965 "document_tab.c"
}


void
document_tab_set_auto_save_interval (DocumentTab* self,
                                     guint value)
{
	guint _tmp0_;
	gboolean _tmp1_;
	guint _tmp2_;
#line 46 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 48 "document_tab.vala"
	g_return_if_fail (value > ((guint) 0));
#line 50 "document_tab.vala"
	_tmp0_ = self->priv->_auto_save_interval;
#line 50 "document_tab.vala"
	if (_tmp0_ == value) {
#line 51 "document_tab.vala"
		return;
#line 986 "document_tab.c"
	}
#line 53 "document_tab.vala"
	self->priv->_auto_save_interval = value;
#line 55 "document_tab.vala"
	_tmp1_ = self->priv->_auto_save;
#line 55 "document_tab.vala"
	if (!_tmp1_) {
#line 56 "document_tab.vala"
		return;
#line 996 "document_tab.c"
	}
#line 58 "document_tab.vala"
	_tmp2_ = self->priv->auto_save_timeout;
#line 58 "document_tab.vala"
	if (_tmp2_ > ((guint) 0)) {
#line 1002 "document_tab.c"
		Document* _tmp3_;
		Document* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		Document* _tmp7_;
		Document* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
#line 60 "document_tab.vala"
		_tmp3_ = document_tab_get_document (self);
#line 60 "document_tab.vala"
		_tmp4_ = _tmp3_;
#line 60 "document_tab.vala"
		_tmp5_ = document_get_location (_tmp4_);
#line 60 "document_tab.vala"
		_tmp6_ = _tmp5_;
#line 60 "document_tab.vala"
		g_return_if_fail (_tmp6_ != NULL);
#line 61 "document_tab.vala"
		_tmp7_ = document_tab_get_document (self);
#line 61 "document_tab.vala"
		_tmp8_ = _tmp7_;
#line 61 "document_tab.vala"
		_tmp9_ = document_get_readonly (_tmp8_);
#line 61 "document_tab.vala"
		_tmp10_ = _tmp9_;
#line 61 "document_tab.vala"
		g_return_if_fail (!_tmp10_);
#line 62 "document_tab.vala"
		document_tab_remove_auto_save_timeout (self);
#line 63 "document_tab.vala"
		document_tab_install_auto_save_timeout (self);
#line 1035 "document_tab.c"
	}
#line 46 "document_tab.vala"
	g_object_notify_by_pspec ((GObject *) self, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY]);
#line 1039 "document_tab.c"
}


gboolean
document_tab_get_auto_save (DocumentTab* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 71 "document_tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "document_tab.vala"
	_tmp0_ = self->priv->_auto_save;
#line 73 "document_tab.vala"
	result = _tmp0_;
#line 73 "document_tab.vala"
	return result;
#line 1056 "document_tab.c"
}


void
document_tab_set_auto_save (DocumentTab* self,
                            gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_;
#line 76 "document_tab.vala"
	g_return_if_fail (self != NULL);
#line 78 "document_tab.vala"
	_tmp0_ = self->priv->_auto_save;
#line 78 "document_tab.vala"
	if (value == _tmp0_) {
#line 79 "document_tab.vala"
		return;
#line 1083 "document_tab.c"
	}
#line 81 "document_tab.vala"
	self->priv->_auto_save = value;
#line 83 "document_tab.vala"
	_tmp4_ = self->priv->_auto_save;
#line 83 "document_tab.vala"
	if (_tmp4_) {
#line 1091 "document_tab.c"
		guint _tmp5_;
#line 83 "document_tab.vala"
		_tmp5_ = self->priv->auto_save_timeout;
#line 83 "document_tab.vala"
		_tmp3_ = _tmp5_ <= ((guint) 0);
#line 1097 "document_tab.c"
	} else {
#line 83 "document_tab.vala"
		_tmp3_ = FALSE;
#line 1101 "document_tab.c"
	}
#line 83 "document_tab.vala"
	if (_tmp3_) {
#line 1105 "document_tab.c"
		Document* _tmp6_;
		Document* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
#line 83 "document_tab.vala"
		_tmp6_ = document_tab_get_document (self);
#line 83 "document_tab.vala"
		_tmp7_ = _tmp6_;
#line 83 "document_tab.vala"
		_tmp8_ = document_get_location (_tmp7_);
#line 83 "document_tab.vala"
		_tmp9_ = _tmp8_;
#line 83 "document_tab.vala"
		_tmp2_ = _tmp9_ != NULL;
#line 1120 "document_tab.c"
	} else {
#line 83 "document_tab.vala"
		_tmp2_ = FALSE;
#line 1124 "document_tab.c"
	}
#line 83 "document_tab.vala"
	if (_tmp2_) {
#line 1128 "document_tab.c"
		Document* _tmp10_;
		Document* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
#line 84 "document_tab.vala"
		_tmp10_ = document_tab_get_document (self);
#line 84 "document_tab.vala"
		_tmp11_ = _tmp10_;
#line 84 "document_tab.vala"
		_tmp12_ = document_get_readonly (_tmp11_);
#line 84 "document_tab.vala"
		_tmp13_ = _tmp12_;
#line 84 "document_tab.vala"
		_tmp1_ = !_tmp13_;
#line 1143 "document_tab.c"
	} else {
#line 83 "document_tab.vala"
		_tmp1_ = FALSE;
#line 1147 "document_tab.c"
	}
#line 83 "document_tab.vala"
	if (_tmp1_) {
#line 86 "document_tab.vala"
		document_tab_install_auto_save_timeout (self);
#line 87 "document_tab.vala"
		return;
#line 1155 "document_tab.c"
	}
#line 90 "document_tab.vala"
	_tmp15_ = self->priv->_auto_save;
#line 90 "document_tab.vala"
	if (!_tmp15_) {
#line 1161 "document_tab.c"
		guint _tmp16_;
#line 90 "document_tab.vala"
		_tmp16_ = self->priv->auto_save_timeout;
#line 90 "document_tab.vala"
		_tmp14_ = _tmp16_ > ((guint) 0);
#line 1167 "document_tab.c"
	} else {
#line 90 "document_tab.vala"
		_tmp14_ = FALSE;
#line 1171 "document_tab.c"
	}
#line 90 "document_tab.vala"
	if (_tmp14_) {
#line 92 "document_tab.vala"
		document_tab_remove_auto_save_timeout (self);
#line 93 "document_tab.vala"
		return;
#line 1179 "document_tab.c"
	}
#line 96 "document_tab.vala"
	_tmp20_ = self->priv->_auto_save;
#line 96 "document_tab.vala"
	if (!_tmp20_) {
#line 1185 "document_tab.c"
		guint _tmp21_;
#line 96 "document_tab.vala"
		_tmp21_ = self->priv->auto_save_timeout;
#line 96 "document_tab.vala"
		_tmp19_ = _tmp21_ <= ((guint) 0);
#line 1191 "document_tab.c"
	} else {
#line 96 "document_tab.vala"
		_tmp19_ = FALSE;
#line 1195 "document_tab.c"
	}
#line 96 "document_tab.vala"
	if (_tmp19_) {
#line 96 "document_tab.vala"
		_tmp18_ = TRUE;
#line 1201 "document_tab.c"
	} else {
		Document* _tmp22_;
		Document* _tmp23_;
		GFile* _tmp24_;
		GFile* _tmp25_;
#line 97 "document_tab.vala"
		_tmp22_ = document_tab_get_document (self);
#line 97 "document_tab.vala"
		_tmp23_ = _tmp22_;
#line 97 "document_tab.vala"
		_tmp24_ = document_get_location (_tmp23_);
#line 97 "document_tab.vala"
		_tmp25_ = _tmp24_;
#line 97 "document_tab.vala"
		_tmp18_ = _tmp25_ == NULL;
#line 1217 "document_tab.c"
	}
#line 96 "document_tab.vala"
	if (_tmp18_) {
#line 96 "document_tab.vala"
		_tmp17_ = TRUE;
#line 1223 "document_tab.c"
	} else {
		Document* _tmp26_;
		Document* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
#line 97 "document_tab.vala"
		_tmp26_ = document_tab_get_document (self);
#line 97 "document_tab.vala"
		_tmp27_ = _tmp26_;
#line 97 "document_tab.vala"
		_tmp28_ = document_get_readonly (_tmp27_);
#line 97 "document_tab.vala"
		_tmp29_ = _tmp28_;
#line 97 "document_tab.vala"
		_tmp17_ = _tmp29_;
#line 1239 "document_tab.c"
	}
#line 96 "document_tab.vala"
	g_return_if_fail (_tmp17_);
#line 76 "document_tab.vala"
	g_object_notify_by_pspec ((GObject *) self, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_PROPERTY]);
#line 1245 "document_tab.c"
}


static void
document_tab_class_init (DocumentTabClass * klass)
{
#line 22 "document_tab.vala"
	document_tab_parent_class = g_type_class_peek_parent (klass);
#line 22 "document_tab.vala"
	g_type_class_adjust_private_offset (klass, &DocumentTab_private_offset);
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_tab_get_property;
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_tab_set_property;
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (klass)->finalize = document_tab_finalize;
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY, document_tab_properties[DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY] = g_param_spec_object ("document-view", "document-view", "document-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_DOCUMENT_PROPERTY, document_tab_properties[DOCUMENT_TAB_DOCUMENT_PROPERTY] = g_param_spec_object ("document", "document", "document", TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY] = g_param_spec_uint ("auto-save-interval", "auto-save-interval", "auto-save-interval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document_tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE_PROPERTY, document_tab_properties[DOCUMENT_TAB_AUTO_SAVE_PROPERTY] = g_param_spec_boolean ("auto-save", "auto-save", "auto-save", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1270 "document_tab.c"
}


static void
document_tab_instance_init (DocumentTab * self)
{
#line 22 "document_tab.vala"
	self->priv = document_tab_get_instance_private (self);
#line 34 "document_tab.vala"
	self->priv->ask_if_externally_modified = FALSE;
#line 1281 "document_tab.c"
}


static void
document_tab_finalize (GObject * obj)
{
	DocumentTab * self;
#line 22 "document_tab.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_TAB, DocumentTab);
#line 22 "document_tab.vala"
	G_OBJECT_CLASS (document_tab_parent_class)->finalize (obj);
#line 1293 "document_tab.c"
}


GType
document_tab_get_type (void)
{
	static volatile gsize document_tab_type_id__volatile = 0;
	if (g_once_init_enter (&document_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentTab), 0, (GInstanceInitFunc) document_tab_instance_init, NULL };
		GType document_tab_type_id;
		document_tab_type_id = g_type_register_static (tepl_tab_get_type (), "DocumentTab", &g_define_type_info, 0);
		DocumentTab_private_offset = g_type_add_instance_private (document_tab_type_id, sizeof (DocumentTabPrivate));
		g_once_init_leave (&document_tab_type_id__volatile, document_tab_type_id);
	}
	return document_tab_type_id__volatile;
}


static void
_vala_document_tab_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	DocumentTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_TAB, DocumentTab);
#line 22 "document_tab.vala"
	switch (property_id) {
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_DOCUMENT_VIEW_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_object (value, document_tab_get_document_view (self));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_DOCUMENT_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_object (value, document_tab_get_document (self));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_uint (value, document_tab_get_auto_save_interval (self));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_PROPERTY:
#line 22 "document_tab.vala"
		g_value_set_boolean (value, document_tab_get_auto_save (self));
#line 22 "document_tab.vala"
		break;
#line 1346 "document_tab.c"
		default:
#line 22 "document_tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document_tab.vala"
		break;
#line 1352 "document_tab.c"
	}
}


static void
_vala_document_tab_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	DocumentTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_TAB, DocumentTab);
#line 22 "document_tab.vala"
	switch (property_id) {
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL_PROPERTY:
#line 22 "document_tab.vala"
		document_tab_set_auto_save_interval (self, g_value_get_uint (value));
#line 22 "document_tab.vala"
		break;
#line 22 "document_tab.vala"
		case DOCUMENT_TAB_AUTO_SAVE_PROPERTY:
#line 22 "document_tab.vala"
		document_tab_set_auto_save (self, g_value_get_boolean (value));
#line 22 "document_tab.vala"
		break;
#line 1379 "document_tab.c"
		default:
#line 22 "document_tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document_tab.vala"
		break;
#line 1385 "document_tab.c"
	}
}



