/* document_structure.c generated by valac 0.40.0.227-717ea, the Vala compiler
 * generated from document_structure.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>


#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _DocumentStructurePrivate DocumentStructurePrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;

#define DOCUMENT_STRUCTURE_TYPE_ENV_DATA (document_structure_env_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _DocumentStructureEnvData DocumentStructureEnvData;
enum  {
	DOCUMENT_STRUCTURE_0_PROPERTY,
	DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY,
	DOCUMENT_STRUCTURE_NUM_PROPERTIES
};
static GParamSpec* document_structure_properties[DOCUMENT_STRUCTURE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _document_structure_env_data_free0(var) ((var == NULL) ? NULL : (var = (document_structure_env_data_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

struct _DocumentStructure {
	GObject parent_instance;
	DocumentStructurePrivate * priv;
};

struct _DocumentStructureClass {
	GObjectClass parent_class;
};

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _DocumentStructureEnvData {
	GtkTreePath* path;
	StructType type;
	gchar* first_caption;
};

struct _DocumentStructurePrivate {
	Document* _doc;
	gint _nb_marks;
	GtkTextMark* _end_document_mark;
	StructureModel* _model;
	gboolean _in_verbatim_env;
	DocumentStructureEnvData* _last_env_data;
	gint _start_parsing_line;
	GTimer* _timer;
	guint _idle_id;
	gboolean _parsing_done;
};

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;


static gint DocumentStructure_private_offset;
static gpointer document_structure_parent_class = NULL;
static GRegex* document_structure__chars_regex;
static GRegex* document_structure__chars_regex = NULL;
static GRegex* document_structure__comment_regex;
static GRegex* document_structure__comment_regex = NULL;
static GRegex* document_structure__command_name_regex;
static GRegex* document_structure__command_name_regex = NULL;
static gchar** document_structure__section_names;
static gint document_structure__section_names_length1;
static gchar** document_structure__section_names = NULL;
static gint document_structure__section_names_length1 = 0;
static gint _document_structure__section_names_size_ = 0;

GType document_structure_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType structure_model_get_type (void) G_GNUC_CONST;
static GType document_structure_env_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType struct_type_get_type (void) G_GNUC_CONST;
static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self);
static void document_structure_env_data_free (DocumentStructureEnvData* self);
static void document_structure_env_data_copy (const DocumentStructureEnvData* self,
                                       DocumentStructureEnvData* dest);
static void document_structure_env_data_destroy (DocumentStructureEnvData* self);
#define DOCUMENT_STRUCTURE_MARK_NAME_PREFIX "struct_item_"
#define DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH 60
#define DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE 2000
#define DOCUMENT_STRUCTURE__measure_parsing_time FALSE
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
void document_structure_parse (DocumentStructure* self);
static void document_structure_set_parsing_done (DocumentStructure* self,
                                          gboolean value);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void document_structure_clear_all_structure_marks (DocumentStructure* self);
static gboolean __lambda6_ (DocumentStructure* self);
static gboolean document_structure_parse_impl (DocumentStructure* self);
static gboolean ___lambda6__gsource_func (gpointer self);
StructureModel* document_structure_get_model (DocumentStructure* self);
static gchar* document_structure_get_line_contents_at_iter (DocumentStructure* self,
                                                     GtkTextIter* iter);
static gboolean document_structure_search_low_level_item (DocumentStructure* self,
                                                   const gchar* line,
                                                   gint start_index,
                                                   StructType** type,
                                                   gchar* * contents,
                                                   gint** start_match_index,
                                                   gint** end_match_index);
static void document_structure_handle_item (DocumentStructure* self,
                                     StructType type,
                                     const gchar* contents,
                                     GtkTextIter* iter);
static gint* _int_dup (gint* self);
gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
static gboolean document_structure_search_markup (DocumentStructure* self,
                                           const gchar* line,
                                           gint after_backslash_index,
                                           StructType** type,
                                           gchar* * contents,
                                           gint** end_match_index);
static gboolean document_structure_search_comment (DocumentStructure* self,
                                            const gchar* line,
                                            gint after_percent_index,
                                            StructType** type,
                                            gchar* * contents,
                                            gint** end_match_index);
static gchar* document_structure_get_markup_name (DocumentStructure* self,
                                           const gchar* line,
                                           gint after_backslash_index,
                                           gint** begin_contents_index);
static gboolean document_structure_search_env (DocumentStructure* self,
                                        const gchar* line,
                                        gint begin_contents_index,
                                        gboolean is_begin_env,
                                        StructType** type,
                                        gint** end_match_index);
static StructType* document_structure_get_markup_type (DocumentStructure* self,
                                                const gchar* markup_name);
static gchar* document_structure_get_markup_contents (DocumentStructure* self,
                                               const gchar* line,
                                               gint begin_contents_index,
                                               gint** end_match_index);
static StructType* _struct_type_dup (StructType* self);
static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self,
                                                          const gchar* line,
                                                          gint start_index,
                                                          gint* begin_contents_index);
static gchar* document_structure_truncate (DocumentStructure* self,
                                    const gchar* text);
static GtkTreeIter* document_structure_add_item (DocumentStructure* self,
                                          StructType type,
                                          const gchar* text,
                                          GtkTextIter* start_iter);
gboolean structure_is_common_type (StructType type);
static void document_structure_create_new_environment (DocumentStructure* self,
                                                StructType type,
                                                GtkTextIter* start_iter);
static gboolean document_structure_verify_end_environment_type (DocumentStructure* self,
                                                         StructType type);
static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self,
                                                            GtkTextIter* iter);
void structure_model_modify_data (StructureModel* self,
                                  GtkTreePath* path,
                                  const gchar* text,
                                  GtkTextMark* end_mark);
static void _vala_GtkTreePath_free (GtkTreePath* self);
GType struct_data_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self,
                       StructData* dest);
void struct_data_destroy (StructData* self);
static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self,
                                               StructData* data);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self,
                                              StructData* item);
GType struct_action_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self,
                                   StructAction action_type,
                                   GtkTreeIter* tree_iter,
                                   gboolean* refresh_simple_list,
                                   GError** error);
static gboolean document_structure_comment_item (DocumentStructure* self,
                                          GtkTreeIter* tree_iter);
void structure_model_delete (StructureModel* self,
                             GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self,
                                                     GtkTreeIter* iter);
static gboolean document_structure_shift_item (DocumentStructure* self,
                                        GtkTreeIter* tree_iter,
                                        gboolean shift_right,
                                        gboolean* doc_modified);
void structure_model_shift_right (StructureModel* self,
                                  GtkTreeIter* iter);
void structure_model_shift_left (StructureModel* self,
                                 GtkTreeIter* iter);
static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self,
                                                   GtkTreeIter* tree_iter,
                                                   GtkTextIter* start_iter,
                                                   GtkTextIter* end_iter);
static void document_structure_backward_indentation (DocumentStructure* self,
                                              GtkTextIter* iter);
GType struct_column_get_type (void) G_GNUC_CONST;
gboolean structure_is_section (StructType type);
void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self,
                                                         GtkTreeIter* section_iter,
                                                         GError** error);
static void document_structure_get_end_document_iter (DocumentStructure* self,
                                               gboolean* end_of_file,
                                               GtkTextIter* result);
static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self,
                                                       StructType item_type,
                                                       const gchar* item_contents,
                                                       GtkTextIter* start_match_iter,
                                                       gboolean is_start,
                                                       GtkTextIter* end_match_iter);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static gboolean document_structure_same_items (DocumentStructure* self,
                                        StructType item_type,
                                        const gchar* item_contents,
                                        StructType item_found_type,
                                        const gchar* item_found_contents,
                                        gboolean start);
static gchar* document_structure_get_section_name_from_type (DocumentStructure* self,
                                                      StructType type);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void document_structure_finalize (GObject * obj);
static void _vala_document_structure_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_document_structure_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
document_structure_get_instance_private (DocumentStructure* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentStructure_private_offset);
}


DocumentStructure*
document_structure_construct (GType object_type,
                              Document* doc)
{
	DocumentStructure * self = NULL;
	GRegex* _tmp0_;
	GError * _inner_error_ = NULL;
#line 66 "document_structure.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 66 "document_structure.vala"
	self = (DocumentStructure*) g_object_new (object_type, NULL);
#line 68 "document_structure.vala"
	self->priv->_doc = doc;
#line 70 "document_structure.vala"
	_tmp0_ = document_structure__chars_regex;
#line 70 "document_structure.vala"
	if (_tmp0_ != NULL) {
#line 71 "document_structure.vala"
		return self;
#line 411 "document_structure.c"
	}
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
#line 75 "document_structure.vala"
		_tmp2_ = g_regex_new ("\\\\|%", 0, 0, &_inner_error_);
#line 75 "document_structure.vala"
		_tmp1_ = _tmp2_;
#line 75 "document_structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "document_structure.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 431 "document_structure.c"
				goto __catch3_g_regex_error;
			}
#line 75 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 75 "document_structure.vala"
			g_clear_error (&_inner_error_);
#line 75 "document_structure.vala"
			return NULL;
#line 440 "document_structure.c"
		}
#line 75 "document_structure.vala"
		_tmp3_ = _tmp1_;
#line 75 "document_structure.vala"
		_tmp1_ = NULL;
#line 75 "document_structure.vala"
		_g_regex_unref0 (document_structure__chars_regex);
#line 75 "document_structure.vala"
		document_structure__chars_regex = _tmp3_;
#line 77 "document_structure.vala"
		_tmp5_ = g_regex_new ("^(?P<type>TODO|FIXME)\\s*:?\\s*(?P<text>.*)$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
#line 77 "document_structure.vala"
		_tmp4_ = _tmp5_;
#line 77 "document_structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 77 "document_structure.vala"
			_g_regex_unref0 (_tmp1_);
#line 77 "document_structure.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 460 "document_structure.c"
				goto __catch3_g_regex_error;
			}
#line 77 "document_structure.vala"
			_g_regex_unref0 (_tmp1_);
#line 77 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "document_structure.vala"
			g_clear_error (&_inner_error_);
#line 77 "document_structure.vala"
			return NULL;
#line 471 "document_structure.c"
		}
#line 77 "document_structure.vala"
		_tmp6_ = _tmp4_;
#line 77 "document_structure.vala"
		_tmp4_ = NULL;
#line 77 "document_structure.vala"
		_g_regex_unref0 (document_structure__comment_regex);
#line 77 "document_structure.vala"
		document_structure__comment_regex = _tmp6_;
#line 83 "document_structure.vala"
		_tmp8_ = g_regex_new ("^(?P<name>[a-z]+\\*?)\\s*(\\[|{)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
#line 83 "document_structure.vala"
		_tmp7_ = _tmp8_;
#line 83 "document_structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 83 "document_structure.vala"
			_g_regex_unref0 (_tmp4_);
#line 83 "document_structure.vala"
			_g_regex_unref0 (_tmp1_);
#line 83 "document_structure.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 493 "document_structure.c"
				goto __catch3_g_regex_error;
			}
#line 83 "document_structure.vala"
			_g_regex_unref0 (_tmp4_);
#line 83 "document_structure.vala"
			_g_regex_unref0 (_tmp1_);
#line 83 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 83 "document_structure.vala"
			g_clear_error (&_inner_error_);
#line 83 "document_structure.vala"
			return NULL;
#line 506 "document_structure.c"
		}
#line 83 "document_structure.vala"
		_tmp9_ = _tmp7_;
#line 83 "document_structure.vala"
		_tmp7_ = NULL;
#line 83 "document_structure.vala"
		_g_regex_unref0 (document_structure__command_name_regex);
#line 83 "document_structure.vala"
		document_structure__command_name_regex = _tmp9_;
#line 73 "document_structure.vala"
		_g_regex_unref0 (_tmp7_);
#line 73 "document_structure.vala"
		_g_regex_unref0 (_tmp4_);
#line 73 "document_structure.vala"
		_g_regex_unref0 (_tmp1_);
#line 522 "document_structure.c"
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 73 "document_structure.vala"
		e = _inner_error_;
#line 73 "document_structure.vala"
		_inner_error_ = NULL;
#line 88 "document_structure.vala"
		_tmp10_ = e;
#line 88 "document_structure.vala"
		_tmp11_ = _tmp10_->message;
#line 88 "document_structure.vala"
		g_warning ("document_structure.vala:88: Structure: %s", _tmp11_);
#line 73 "document_structure.vala"
		_g_error_free0 (e);
#line 542 "document_structure.c"
	}
	__finally3:
#line 73 "document_structure.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 73 "document_structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 73 "document_structure.vala"
		g_clear_error (&_inner_error_);
#line 73 "document_structure.vala"
		return NULL;
#line 553 "document_structure.c"
	}
#line 66 "document_structure.vala"
	return self;
#line 557 "document_structure.c"
}


DocumentStructure*
document_structure_new (Document* doc)
{
#line 66 "document_structure.vala"
	return document_structure_construct (TYPE_DOCUMENT_STRUCTURE, doc);
#line 566 "document_structure.c"
}


static gboolean
__lambda6_ (DocumentStructure* self)
{
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp0_;
#line 117 "document_structure.vala"
	ret = document_structure_parse_impl (self);
#line 119 "document_structure.vala"
	_tmp0_ = ret;
#line 119 "document_structure.vala"
	if (!_tmp0_) {
#line 120 "document_structure.vala"
		self->priv->_idle_id = (guint) 0;
#line 584 "document_structure.c"
	}
#line 122 "document_structure.vala"
	result = ret;
#line 122 "document_structure.vala"
	return result;
#line 590 "document_structure.c"
}


static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((DocumentStructure*) self);
#line 115 "document_structure.vala"
	return result;
#line 601 "document_structure.c"
}


void
document_structure_parse (DocumentStructure* self)
{
	StructureModel* _tmp0_;
	guint _tmp1_;
#line 101 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 104 "document_structure.vala"
	document_structure_set_parsing_done (self, FALSE);
#line 105 "document_structure.vala"
	_tmp0_ = structure_model_new ();
#line 105 "document_structure.vala"
	_g_object_unref0 (self->priv->_model);
#line 105 "document_structure.vala"
	self->priv->_model = _tmp0_;
#line 106 "document_structure.vala"
	_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 106 "document_structure.vala"
	self->priv->_last_env_data = NULL;
#line 107 "document_structure.vala"
	self->priv->_start_parsing_line = 0;
#line 109 "document_structure.vala"
	_g_object_unref0 (self->priv->_end_document_mark);
#line 109 "document_structure.vala"
	self->priv->_end_document_mark = NULL;
#line 110 "document_structure.vala"
	document_structure_clear_all_structure_marks (self);
#line 112 "document_structure.vala"
	_tmp1_ = self->priv->_idle_id;
#line 112 "document_structure.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 636 "document_structure.c"
		guint _tmp2_;
#line 113 "document_structure.vala"
		_tmp2_ = self->priv->_idle_id;
#line 113 "document_structure.vala"
		g_source_remove (_tmp2_);
#line 642 "document_structure.c"
	}
#line 115 "document_structure.vala"
	self->priv->_idle_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
#line 646 "document_structure.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 128 "document_structure.vala"
	return self ? g_object_ref (self) : NULL;
#line 655 "document_structure.c"
}


StructureModel*
document_structure_get_model (DocumentStructure* self)
{
	StructureModel* result = NULL;
	StructureModel* _tmp0_;
	StructureModel* _tmp1_;
#line 126 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 128 "document_structure.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 128 "document_structure.vala"
	result = _tmp1_;
#line 128 "document_structure.vala"
	return result;
#line 675 "document_structure.c"
}


/*************************************************************************/
static gboolean
document_structure_parse_impl (DocumentStructure* self)
{
	gboolean result = FALSE;
	Document* _tmp0_;
	GtkTextIter line_iter = {0};
	Document* _tmp4_;
	gint _tmp5_;
	GtkTextIter _tmp6_ = {0};
	gint nb_lines_parsed = 0;
#line 135 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 137 "document_structure.vala"
	_tmp0_ = self->priv->_doc;
#line 137 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 138 "document_structure.vala"
		result = FALSE;
#line 138 "document_structure.vala"
		return result;
#line 700 "document_structure.c"
	}
#line 140 "document_structure.vala"
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
#line 704 "document_structure.c"
		GTimer* _tmp1_;
#line 142 "document_structure.vala"
		_tmp1_ = self->priv->_timer;
#line 142 "document_structure.vala"
		if (_tmp1_ == NULL) {
#line 710 "document_structure.c"
			GTimer* _tmp2_;
#line 143 "document_structure.vala"
			_tmp2_ = g_timer_new ();
#line 143 "document_structure.vala"
			_g_timer_destroy0 (self->priv->_timer);
#line 143 "document_structure.vala"
			self->priv->_timer = _tmp2_;
#line 718 "document_structure.c"
		} else {
			GTimer* _tmp3_;
#line 145 "document_structure.vala"
			_tmp3_ = self->priv->_timer;
#line 145 "document_structure.vala"
			g_timer_continue (_tmp3_);
#line 725 "document_structure.c"
		}
	}
#line 150 "document_structure.vala"
	_tmp4_ = self->priv->_doc;
#line 150 "document_structure.vala"
	_tmp5_ = self->priv->_start_parsing_line;
#line 150 "document_structure.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp4_, &_tmp6_, _tmp5_);
#line 150 "document_structure.vala"
	line_iter = _tmp6_;
#line 152 "document_structure.vala"
	nb_lines_parsed = 0;
#line 738 "document_structure.c"
	{
		gboolean _tmp7_ = FALSE;
#line 154 "document_structure.vala"
		_tmp7_ = TRUE;
#line 154 "document_structure.vala"
		while (TRUE) {
#line 745 "document_structure.c"
			gint _tmp8_;
			gchar* line_text = NULL;
			GtkTextIter _tmp11_;
			gchar* _tmp12_;
			gint start_index = 0;
			gint line_length = 0;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp32_;
#line 154 "document_structure.vala"
			if (!_tmp7_) {
#line 196 "document_structure.vala"
				if (!gtk_text_iter_forward_line (&line_iter)) {
#line 196 "document_structure.vala"
					break;
#line 762 "document_structure.c"
				}
			}
#line 154 "document_structure.vala"
			_tmp7_ = FALSE;
#line 158 "document_structure.vala"
			_tmp8_ = nb_lines_parsed;
#line 158 "document_structure.vala"
			if (_tmp8_ == DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE) {
#line 771 "document_structure.c"
				gint _tmp9_;
#line 160 "document_structure.vala"
				_tmp9_ = self->priv->_start_parsing_line;
#line 160 "document_structure.vala"
				self->priv->_start_parsing_line = _tmp9_ + DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE;
#line 162 "document_structure.vala"
				if (DOCUMENT_STRUCTURE__measure_parsing_time) {
#line 779 "document_structure.c"
					GTimer* _tmp10_;
#line 163 "document_structure.vala"
					_tmp10_ = self->priv->_timer;
#line 163 "document_structure.vala"
					g_timer_stop (_tmp10_);
#line 785 "document_structure.c"
				}
#line 165 "document_structure.vala"
				result = TRUE;
#line 165 "document_structure.vala"
				return result;
#line 791 "document_structure.c"
			}
#line 169 "document_structure.vala"
			_tmp11_ = line_iter;
#line 169 "document_structure.vala"
			_tmp12_ = document_structure_get_line_contents_at_iter (self, &_tmp11_);
#line 169 "document_structure.vala"
			line_text = _tmp12_;
#line 172 "document_structure.vala"
			start_index = 0;
#line 173 "document_structure.vala"
			_tmp13_ = line_text;
#line 173 "document_structure.vala"
			_tmp14_ = strlen (_tmp13_);
#line 173 "document_structure.vala"
			_tmp15_ = _tmp14_;
#line 173 "document_structure.vala"
			line_length = _tmp15_;
#line 174 "document_structure.vala"
			while (TRUE) {
#line 811 "document_structure.c"
				gint _tmp16_;
				gint _tmp17_;
				StructType* type = NULL;
				gchar* contents = NULL;
				gint* start_match_index = NULL;
				gint* end_match_index = NULL;
				gboolean item_found = FALSE;
				const gchar* _tmp18_;
				gint _tmp19_;
				StructType* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gint* _tmp22_ = NULL;
				gint* _tmp23_ = NULL;
				gboolean _tmp24_;
				gboolean _tmp25_;
				GtkTextIter iter = {0};
				GtkTextIter _tmp26_;
				gint* _tmp27_;
				StructType* _tmp28_;
				const gchar* _tmp29_;
				GtkTextIter _tmp30_;
				gint* _tmp31_;
#line 174 "document_structure.vala"
				_tmp16_ = start_index;
#line 174 "document_structure.vala"
				_tmp17_ = line_length;
#line 174 "document_structure.vala"
				if (!(_tmp16_ < _tmp17_)) {
#line 174 "document_structure.vala"
					break;
#line 842 "document_structure.c"
				}
#line 181 "document_structure.vala"
				_tmp18_ = line_text;
#line 181 "document_structure.vala"
				_tmp19_ = start_index;
#line 181 "document_structure.vala"
				_tmp24_ = document_structure_search_low_level_item (self, _tmp18_, _tmp19_, &_tmp20_, &_tmp21_, &_tmp22_, &_tmp23_);
#line 181 "document_structure.vala"
				_g_free0 (type);
#line 181 "document_structure.vala"
				type = _tmp20_;
#line 181 "document_structure.vala"
				_g_free0 (contents);
#line 181 "document_structure.vala"
				contents = _tmp21_;
#line 181 "document_structure.vala"
				_g_free0 (start_match_index);
#line 181 "document_structure.vala"
				start_match_index = _tmp22_;
#line 181 "document_structure.vala"
				_g_free0 (end_match_index);
#line 181 "document_structure.vala"
				end_match_index = _tmp23_;
#line 181 "document_structure.vala"
				item_found = _tmp24_;
#line 184 "document_structure.vala"
				_tmp25_ = item_found;
#line 184 "document_structure.vala"
				if (!_tmp25_) {
#line 185 "document_structure.vala"
					_g_free0 (end_match_index);
#line 185 "document_structure.vala"
					_g_free0 (start_match_index);
#line 185 "document_structure.vala"
					_g_free0 (contents);
#line 185 "document_structure.vala"
					_g_free0 (type);
#line 185 "document_structure.vala"
					break;
#line 882 "document_structure.c"
				}
#line 187 "document_structure.vala"
				_tmp26_ = line_iter;
#line 187 "document_structure.vala"
				iter = _tmp26_;
#line 188 "document_structure.vala"
				_tmp27_ = start_match_index;
#line 188 "document_structure.vala"
				gtk_text_iter_set_line_index (&iter, *_tmp27_);
#line 189 "document_structure.vala"
				_tmp28_ = type;
#line 189 "document_structure.vala"
				_tmp29_ = contents;
#line 189 "document_structure.vala"
				_tmp30_ = iter;
#line 189 "document_structure.vala"
				document_structure_handle_item (self, *_tmp28_, _tmp29_, &_tmp30_);
#line 191 "document_structure.vala"
				_tmp31_ = end_match_index;
#line 191 "document_structure.vala"
				start_index = *_tmp31_;
#line 174 "document_structure.vala"
				_g_free0 (end_match_index);
#line 174 "document_structure.vala"
				_g_free0 (start_match_index);
#line 174 "document_structure.vala"
				_g_free0 (contents);
#line 174 "document_structure.vala"
				_g_free0 (type);
#line 912 "document_structure.c"
			}
#line 194 "document_structure.vala"
			_tmp32_ = nb_lines_parsed;
#line 194 "document_structure.vala"
			nb_lines_parsed = _tmp32_ + 1;
#line 154 "document_structure.vala"
			_g_free0 (line_text);
#line 920 "document_structure.c"
		}
	}
#line 198 "document_structure.vala"
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
#line 925 "document_structure.c"
		GTimer* _tmp33_;
		GTimer* _tmp34_;
		gdouble _tmp35_;
		GTimer* _tmp36_;
#line 200 "document_structure.vala"
		_tmp33_ = self->priv->_timer;
#line 200 "document_structure.vala"
		g_timer_stop (_tmp33_);
#line 201 "document_structure.vala"
		_tmp34_ = self->priv->_timer;
#line 201 "document_structure.vala"
		_tmp35_ = g_timer_elapsed (_tmp34_, NULL);
#line 201 "document_structure.vala"
		g_message ("document_structure.vala:201: Structure parsing took %f seconds", _tmp35_);
#line 202 "document_structure.vala"
		_tmp36_ = self->priv->_timer;
#line 202 "document_structure.vala"
		g_timer_reset (_tmp36_);
#line 944 "document_structure.c"
	}
#line 205 "document_structure.vala"
	document_structure_set_parsing_done (self, TRUE);
#line 206 "document_structure.vala"
	result = FALSE;
#line 206 "document_structure.vala"
	return result;
#line 952 "document_structure.c"
}


static gint*
_int_dup (gint* self)
{
	gint* dup;
#line 240 "document_structure.vala"
	dup = g_new0 (gint, 1);
#line 240 "document_structure.vala"
	memcpy (dup, self, sizeof (gint));
#line 240 "document_structure.vala"
	return dup;
#line 966 "document_structure.c"
}


static gpointer
__int_dup0 (gpointer self)
{
#line 240 "document_structure.vala"
	return self ? _int_dup (self) : NULL;
#line 975 "document_structure.c"
}


static gboolean
document_structure_search_low_level_item (DocumentStructure* self,
                                          const gchar* line,
                                          gint start_index,
                                          StructType** type,
                                          gchar* * contents,
                                          gint** start_match_index,
                                          gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_start_match_index = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	GMatchInfo* match_info = NULL;
	GError * _inner_error_ = NULL;
#line 216 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 216 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 220 "document_structure.vala"
	_g_free0 (_vala_type);
#line 220 "document_structure.vala"
	_vala_type = NULL;
#line 221 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 221 "document_structure.vala"
	_vala_contents = NULL;
#line 222 "document_structure.vala"
	_g_free0 (_vala_start_match_index);
#line 222 "document_structure.vala"
	_vala_start_match_index = NULL;
#line 223 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 223 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 1015 "document_structure.c"
	{
		GRegex* _tmp0_;
		GMatchInfo* _tmp1_ = NULL;
#line 229 "document_structure.vala"
		_tmp0_ = document_structure__chars_regex;
#line 229 "document_structure.vala"
		g_regex_match_full (_tmp0_, line, (gssize) -1, start_index, 0, &_tmp1_, &_inner_error_);
#line 229 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 229 "document_structure.vala"
		match_info = _tmp1_;
#line 229 "document_structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1029 "document_structure.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 227 "document_structure.vala"
		e = _inner_error_;
#line 227 "document_structure.vala"
		_inner_error_ = NULL;
#line 233 "document_structure.vala"
		_tmp2_ = e;
#line 233 "document_structure.vala"
		_tmp3_ = _tmp2_->message;
#line 233 "document_structure.vala"
		g_warning ("document_structure.vala:233: Structure parsing: chars regex: %s", _tmp3_);
#line 234 "document_structure.vala"
		result = FALSE;
#line 234 "document_structure.vala"
		_g_error_free0 (e);
#line 234 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 234 "document_structure.vala"
		if (type) {
#line 234 "document_structure.vala"
			*type = _vala_type;
#line 1059 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1063 "document_structure.c"
		}
#line 234 "document_structure.vala"
		if (contents) {
#line 234 "document_structure.vala"
			*contents = _vala_contents;
#line 1069 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1073 "document_structure.c"
		}
#line 234 "document_structure.vala"
		if (start_match_index) {
#line 234 "document_structure.vala"
			*start_match_index = _vala_start_match_index;
#line 1079 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_start_match_index);
#line 1083 "document_structure.c"
		}
#line 234 "document_structure.vala"
		if (end_match_index) {
#line 234 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1089 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1093 "document_structure.c"
		}
#line 234 "document_structure.vala"
		return result;
#line 1097 "document_structure.c"
	}
	__finally4:
#line 227 "document_structure.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1102 "document_structure.c"
		gboolean _tmp4_ = FALSE;
#line 227 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 227 "document_structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "document_structure.vala"
		g_clear_error (&_inner_error_);
#line 227 "document_structure.vala"
		return _tmp4_;
#line 1112 "document_structure.c"
	}
#line 237 "document_structure.vala"
	while (TRUE) {
#line 1116 "document_structure.c"
		GMatchInfo* _tmp5_;
		gint after_char_index = 0;
		GMatchInfo* _tmp6_;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_;
		gint _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
#line 237 "document_structure.vala"
		_tmp5_ = match_info;
#line 237 "document_structure.vala"
		if (!g_match_info_matches (_tmp5_)) {
#line 237 "document_structure.vala"
			break;
#line 1132 "document_structure.c"
		}
#line 240 "document_structure.vala"
		_tmp6_ = match_info;
#line 240 "document_structure.vala"
		_tmp9_ = g_match_info_fetch_pos (_tmp6_, 0, &_tmp7_, &_tmp8_);
#line 240 "document_structure.vala"
		_g_free0 (_vala_start_match_index);
#line 240 "document_structure.vala"
		_tmp10_ = _tmp7_;
#line 240 "document_structure.vala"
		_tmp11_ = __int_dup0 (&_tmp10_);
#line 240 "document_structure.vala"
		_vala_start_match_index = _tmp11_;
#line 240 "document_structure.vala"
		after_char_index = _tmp8_;
#line 240 "document_structure.vala"
		if (!_tmp9_) {
#line 242 "document_structure.vala"
			g_warning ("document_structure.vala:242: Structure parsing: position can not be fe" \
"tched");
#line 243 "document_structure.vala"
			result = FALSE;
#line 243 "document_structure.vala"
			_g_match_info_unref0 (match_info);
#line 243 "document_structure.vala"
			if (type) {
#line 243 "document_structure.vala"
				*type = _vala_type;
#line 1160 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_type);
#line 1164 "document_structure.c"
			}
#line 243 "document_structure.vala"
			if (contents) {
#line 243 "document_structure.vala"
				*contents = _vala_contents;
#line 1170 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_contents);
#line 1174 "document_structure.c"
			}
#line 243 "document_structure.vala"
			if (start_match_index) {
#line 243 "document_structure.vala"
				*start_match_index = _vala_start_match_index;
#line 1180 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_start_match_index);
#line 1184 "document_structure.c"
			}
#line 243 "document_structure.vala"
			if (end_match_index) {
#line 243 "document_structure.vala"
				*end_match_index = _vala_end_match_index;
#line 1190 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 1194 "document_structure.c"
			}
#line 243 "document_structure.vala"
			return result;
#line 1198 "document_structure.c"
		}
#line 246 "document_structure.vala"
		_tmp12_ = _vala_start_match_index;
#line 246 "document_structure.vala"
		if (!utils_char_is_escaped (line, *_tmp12_)) {
#line 1204 "document_structure.c"
			gchar* char_matched = NULL;
			GMatchInfo* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
#line 248 "document_structure.vala"
			_tmp13_ = match_info;
#line 248 "document_structure.vala"
			_tmp14_ = g_match_info_fetch (_tmp13_, 0);
#line 248 "document_structure.vala"
			char_matched = _tmp14_;
#line 251 "document_structure.vala"
			_tmp15_ = char_matched;
#line 251 "document_structure.vala"
			if (g_strcmp0 (_tmp15_, "\\") == 0) {
#line 1219 "document_structure.c"
				gboolean markup_found = FALSE;
				gint _tmp16_;
				StructType* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gint* _tmp19_ = NULL;
				gboolean _tmp20_;
				gboolean _tmp21_;
#line 253 "document_structure.vala"
				_tmp16_ = after_char_index;
#line 253 "document_structure.vala"
				_tmp20_ = document_structure_search_markup (self, line, _tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
#line 253 "document_structure.vala"
				_g_free0 (_vala_type);
#line 253 "document_structure.vala"
				_vala_type = _tmp17_;
#line 253 "document_structure.vala"
				_g_free0 (_vala_contents);
#line 253 "document_structure.vala"
				_vala_contents = _tmp18_;
#line 253 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 253 "document_structure.vala"
				_vala_end_match_index = _tmp19_;
#line 253 "document_structure.vala"
				markup_found = _tmp20_;
#line 256 "document_structure.vala"
				_tmp21_ = markup_found;
#line 256 "document_structure.vala"
				if (_tmp21_) {
#line 257 "document_structure.vala"
					result = TRUE;
#line 257 "document_structure.vala"
					_g_free0 (char_matched);
#line 257 "document_structure.vala"
					_g_match_info_unref0 (match_info);
#line 257 "document_structure.vala"
					if (type) {
#line 257 "document_structure.vala"
						*type = _vala_type;
#line 1259 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_type);
#line 1263 "document_structure.c"
					}
#line 257 "document_structure.vala"
					if (contents) {
#line 257 "document_structure.vala"
						*contents = _vala_contents;
#line 1269 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_contents);
#line 1273 "document_structure.c"
					}
#line 257 "document_structure.vala"
					if (start_match_index) {
#line 257 "document_structure.vala"
						*start_match_index = _vala_start_match_index;
#line 1279 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_start_match_index);
#line 1283 "document_structure.c"
					}
#line 257 "document_structure.vala"
					if (end_match_index) {
#line 257 "document_structure.vala"
						*end_match_index = _vala_end_match_index;
#line 1289 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_end_match_index);
#line 1293 "document_structure.c"
					}
#line 257 "document_structure.vala"
					return result;
#line 1297 "document_structure.c"
				}
			} else {
				gint _tmp22_;
				StructType* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gint* _tmp25_ = NULL;
				gboolean _tmp26_;
#line 267 "document_structure.vala"
				_tmp22_ = after_char_index;
#line 267 "document_structure.vala"
				_tmp26_ = document_structure_search_comment (self, line, _tmp22_, &_tmp23_, &_tmp24_, &_tmp25_);
#line 267 "document_structure.vala"
				_g_free0 (_vala_type);
#line 267 "document_structure.vala"
				_vala_type = _tmp23_;
#line 267 "document_structure.vala"
				_g_free0 (_vala_contents);
#line 267 "document_structure.vala"
				_vala_contents = _tmp24_;
#line 267 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 267 "document_structure.vala"
				_vala_end_match_index = _tmp25_;
#line 267 "document_structure.vala"
				result = _tmp26_;
#line 267 "document_structure.vala"
				_g_free0 (char_matched);
#line 267 "document_structure.vala"
				_g_match_info_unref0 (match_info);
#line 267 "document_structure.vala"
				if (type) {
#line 267 "document_structure.vala"
					*type = _vala_type;
#line 1331 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_type);
#line 1335 "document_structure.c"
				}
#line 267 "document_structure.vala"
				if (contents) {
#line 267 "document_structure.vala"
					*contents = _vala_contents;
#line 1341 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_contents);
#line 1345 "document_structure.c"
				}
#line 267 "document_structure.vala"
				if (start_match_index) {
#line 267 "document_structure.vala"
					*start_match_index = _vala_start_match_index;
#line 1351 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_start_match_index);
#line 1355 "document_structure.c"
				}
#line 267 "document_structure.vala"
				if (end_match_index) {
#line 267 "document_structure.vala"
					*end_match_index = _vala_end_match_index;
#line 1361 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_end_match_index);
#line 1365 "document_structure.c"
				}
#line 267 "document_structure.vala"
				return result;
#line 1369 "document_structure.c"
			}
#line 246 "document_structure.vala"
			_g_free0 (char_matched);
#line 1373 "document_structure.c"
		}
		{
			GMatchInfo* _tmp27_;
#line 274 "document_structure.vala"
			_tmp27_ = match_info;
#line 274 "document_structure.vala"
			g_match_info_next (_tmp27_, &_inner_error_);
#line 274 "document_structure.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "document_structure.c"
				gboolean _tmp28_ = FALSE;
#line 274 "document_structure.vala"
				if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1387 "document_structure.c"
					goto __catch5_g_regex_error;
				}
#line 274 "document_structure.vala"
				_g_match_info_unref0 (match_info);
#line 274 "document_structure.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 274 "document_structure.vala"
				g_clear_error (&_inner_error_);
#line 274 "document_structure.vala"
				return _tmp28_;
#line 1398 "document_structure.c"
			}
		}
		goto __finally5;
		__catch5_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
#line 272 "document_structure.vala"
			e = _inner_error_;
#line 272 "document_structure.vala"
			_inner_error_ = NULL;
#line 278 "document_structure.vala"
			_tmp29_ = e;
#line 278 "document_structure.vala"
			_tmp30_ = _tmp29_->message;
#line 278 "document_structure.vala"
			g_warning ("document_structure.vala:278: Structure parsing: %s", _tmp30_);
#line 279 "document_structure.vala"
			_g_error_free0 (e);
#line 279 "document_structure.vala"
			break;
#line 1421 "document_structure.c"
		}
		__finally5:
#line 272 "document_structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "document_structure.c"
			gboolean _tmp31_ = FALSE;
#line 272 "document_structure.vala"
			_g_match_info_unref0 (match_info);
#line 272 "document_structure.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 272 "document_structure.vala"
			g_clear_error (&_inner_error_);
#line 272 "document_structure.vala"
			return _tmp31_;
#line 1436 "document_structure.c"
		}
	}
#line 283 "document_structure.vala"
	result = FALSE;
#line 283 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 283 "document_structure.vala"
	if (type) {
#line 283 "document_structure.vala"
		*type = _vala_type;
#line 1447 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_type);
#line 1451 "document_structure.c"
	}
#line 283 "document_structure.vala"
	if (contents) {
#line 283 "document_structure.vala"
		*contents = _vala_contents;
#line 1457 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 1461 "document_structure.c"
	}
#line 283 "document_structure.vala"
	if (start_match_index) {
#line 283 "document_structure.vala"
		*start_match_index = _vala_start_match_index;
#line 1467 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_start_match_index);
#line 1471 "document_structure.c"
	}
#line 283 "document_structure.vala"
	if (end_match_index) {
#line 283 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 1477 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 1481 "document_structure.c"
	}
#line 283 "document_structure.vala"
	return result;
#line 1485 "document_structure.c"
}


static gboolean
document_structure_search_markup (DocumentStructure* self,
                                  const gchar* line,
                                  gint after_backslash_index,
                                  StructType** type,
                                  gchar* * contents,
                                  gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gint* begin_contents_index = NULL;
	gchar* name = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean is_begin_env = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	const gchar* _tmp12_;
	StructType* _tmp13_;
	StructType* _tmp14_;
	gint* _tmp15_;
	gint* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
#line 286 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 286 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 289 "document_structure.vala"
	_g_free0 (_vala_type);
#line 289 "document_structure.vala"
	_vala_type = NULL;
#line 290 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 290 "document_structure.vala"
	_vala_contents = NULL;
#line 291 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 291 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 295 "document_structure.vala"
	_tmp1_ = document_structure_get_markup_name (self, line, after_backslash_index, &_tmp0_);
#line 295 "document_structure.vala"
	_g_free0 (begin_contents_index);
#line 295 "document_structure.vala"
	begin_contents_index = _tmp0_;
#line 295 "document_structure.vala"
	name = _tmp1_;
#line 298 "document_structure.vala"
	_tmp2_ = name;
#line 298 "document_structure.vala"
	if (_tmp2_ == NULL) {
#line 299 "document_structure.vala"
		result = FALSE;
#line 299 "document_structure.vala"
		_g_free0 (name);
#line 299 "document_structure.vala"
		_g_free0 (begin_contents_index);
#line 299 "document_structure.vala"
		if (type) {
#line 299 "document_structure.vala"
			*type = _vala_type;
#line 1555 "document_structure.c"
		} else {
#line 299 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1559 "document_structure.c"
		}
#line 299 "document_structure.vala"
		if (contents) {
#line 299 "document_structure.vala"
			*contents = _vala_contents;
#line 1565 "document_structure.c"
		} else {
#line 299 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1569 "document_structure.c"
		}
#line 299 "document_structure.vala"
		if (end_match_index) {
#line 299 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1575 "document_structure.c"
		} else {
#line 299 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1579 "document_structure.c"
		}
#line 299 "document_structure.vala"
		return result;
#line 1583 "document_structure.c"
	}
#line 302 "document_structure.vala"
	_tmp3_ = name;
#line 302 "document_structure.vala"
	is_begin_env = g_strcmp0 (_tmp3_, "begin") == 0;
#line 303 "document_structure.vala"
	_tmp5_ = is_begin_env;
#line 303 "document_structure.vala"
	if (_tmp5_) {
#line 303 "document_structure.vala"
		_tmp4_ = TRUE;
#line 1595 "document_structure.c"
	} else {
		const gchar* _tmp6_;
#line 303 "document_structure.vala"
		_tmp6_ = name;
#line 303 "document_structure.vala"
		_tmp4_ = g_strcmp0 (_tmp6_, "end") == 0;
#line 1602 "document_structure.c"
	}
#line 303 "document_structure.vala"
	if (_tmp4_) {
#line 1606 "document_structure.c"
		gint* _tmp7_;
		gboolean _tmp8_;
		StructType* _tmp9_ = NULL;
		gint* _tmp10_ = NULL;
		gboolean _tmp11_;
#line 305 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 305 "document_structure.vala"
		_vala_contents = NULL;
#line 306 "document_structure.vala"
		_tmp7_ = begin_contents_index;
#line 306 "document_structure.vala"
		_tmp8_ = is_begin_env;
#line 306 "document_structure.vala"
		_tmp11_ = document_structure_search_env (self, line, *_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 306 "document_structure.vala"
		_g_free0 (_vala_type);
#line 306 "document_structure.vala"
		_vala_type = _tmp9_;
#line 306 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 306 "document_structure.vala"
		_vala_end_match_index = _tmp10_;
#line 306 "document_structure.vala"
		result = _tmp11_;
#line 306 "document_structure.vala"
		_g_free0 (name);
#line 306 "document_structure.vala"
		_g_free0 (begin_contents_index);
#line 306 "document_structure.vala"
		if (type) {
#line 306 "document_structure.vala"
			*type = _vala_type;
#line 1640 "document_structure.c"
		} else {
#line 306 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1644 "document_structure.c"
		}
#line 306 "document_structure.vala"
		if (contents) {
#line 306 "document_structure.vala"
			*contents = _vala_contents;
#line 1650 "document_structure.c"
		} else {
#line 306 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1654 "document_structure.c"
		}
#line 306 "document_structure.vala"
		if (end_match_index) {
#line 306 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1660 "document_structure.c"
		} else {
#line 306 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1664 "document_structure.c"
		}
#line 306 "document_structure.vala"
		return result;
#line 1668 "document_structure.c"
	}
#line 311 "document_structure.vala"
	_tmp12_ = name;
#line 311 "document_structure.vala"
	_tmp13_ = document_structure_get_markup_type (self, _tmp12_);
#line 311 "document_structure.vala"
	_g_free0 (_vala_type);
#line 311 "document_structure.vala"
	_vala_type = _tmp13_;
#line 312 "document_structure.vala"
	_tmp14_ = _vala_type;
#line 312 "document_structure.vala"
	if (_tmp14_ == NULL) {
#line 313 "document_structure.vala"
		result = FALSE;
#line 313 "document_structure.vala"
		_g_free0 (name);
#line 313 "document_structure.vala"
		_g_free0 (begin_contents_index);
#line 313 "document_structure.vala"
		if (type) {
#line 313 "document_structure.vala"
			*type = _vala_type;
#line 1692 "document_structure.c"
		} else {
#line 313 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1696 "document_structure.c"
		}
#line 313 "document_structure.vala"
		if (contents) {
#line 313 "document_structure.vala"
			*contents = _vala_contents;
#line 1702 "document_structure.c"
		} else {
#line 313 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1706 "document_structure.c"
		}
#line 313 "document_structure.vala"
		if (end_match_index) {
#line 313 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1712 "document_structure.c"
		} else {
#line 313 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1716 "document_structure.c"
		}
#line 313 "document_structure.vala"
		return result;
#line 1720 "document_structure.c"
	}
#line 315 "document_structure.vala"
	_tmp15_ = begin_contents_index;
#line 315 "document_structure.vala"
	_tmp17_ = document_structure_get_markup_contents (self, line, *_tmp15_, &_tmp16_);
#line 315 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 315 "document_structure.vala"
	_vala_end_match_index = _tmp16_;
#line 315 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 315 "document_structure.vala"
	_vala_contents = _tmp17_;
#line 316 "document_structure.vala"
	_tmp18_ = _vala_contents;
#line 316 "document_structure.vala"
	result = _tmp18_ != NULL;
#line 316 "document_structure.vala"
	_g_free0 (name);
#line 316 "document_structure.vala"
	_g_free0 (begin_contents_index);
#line 316 "document_structure.vala"
	if (type) {
#line 316 "document_structure.vala"
		*type = _vala_type;
#line 1746 "document_structure.c"
	} else {
#line 316 "document_structure.vala"
		_g_free0 (_vala_type);
#line 1750 "document_structure.c"
	}
#line 316 "document_structure.vala"
	if (contents) {
#line 316 "document_structure.vala"
		*contents = _vala_contents;
#line 1756 "document_structure.c"
	} else {
#line 316 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 1760 "document_structure.c"
	}
#line 316 "document_structure.vala"
	if (end_match_index) {
#line 316 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 1766 "document_structure.c"
	} else {
#line 316 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 1770 "document_structure.c"
	}
#line 316 "document_structure.vala"
	return result;
#line 1774 "document_structure.c"
}


static StructType*
_struct_type_dup (StructType* self)
{
	StructType* dup;
#line 332 "document_structure.vala"
	dup = g_new0 (StructType, 1);
#line 332 "document_structure.vala"
	memcpy (dup, self, sizeof (StructType));
#line 332 "document_structure.vala"
	return dup;
#line 1788 "document_structure.c"
}


static gpointer
__struct_type_dup0 (gpointer self)
{
#line 332 "document_structure.vala"
	return self ? _struct_type_dup (self) : NULL;
#line 1797 "document_structure.c"
}


static gboolean
document_structure_search_env (DocumentStructure* self,
                               const gchar* line,
                               gint begin_contents_index,
                               gboolean is_begin_env,
                               StructType** type,
                               gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gchar* contents = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
#line 319 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 319 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 322 "document_structure.vala"
	_g_free0 (_vala_type);
#line 322 "document_structure.vala"
	_vala_type = NULL;
#line 324 "document_structure.vala"
	_tmp1_ = document_structure_get_markup_contents (self, line, begin_contents_index, &_tmp0_);
#line 324 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 324 "document_structure.vala"
	_vala_end_match_index = _tmp0_;
#line 324 "document_structure.vala"
	contents = _tmp1_;
#line 327 "document_structure.vala"
	_tmp2_ = contents;
#line 327 "document_structure.vala"
	if (_tmp2_ == NULL) {
#line 328 "document_structure.vala"
		result = FALSE;
#line 328 "document_structure.vala"
		_g_free0 (contents);
#line 328 "document_structure.vala"
		if (type) {
#line 328 "document_structure.vala"
			*type = _vala_type;
#line 1850 "document_structure.c"
		} else {
#line 328 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1854 "document_structure.c"
		}
#line 328 "document_structure.vala"
		if (end_match_index) {
#line 328 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1860 "document_structure.c"
		} else {
#line 328 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1864 "document_structure.c"
		}
#line 328 "document_structure.vala"
		return result;
#line 1868 "document_structure.c"
	}
#line 330 "document_structure.vala"
	_tmp4_ = contents;
#line 330 "document_structure.vala"
	if (g_strcmp0 (_tmp4_, "verbatim") == 0) {
#line 330 "document_structure.vala"
		_tmp3_ = TRUE;
#line 1876 "document_structure.c"
	} else {
		const gchar* _tmp5_;
#line 330 "document_structure.vala"
		_tmp5_ = contents;
#line 330 "document_structure.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "verbatim*") == 0;
#line 1883 "document_structure.c"
	}
#line 330 "document_structure.vala"
	if (_tmp3_) {
#line 1887 "document_structure.c"
		StructType _tmp6_ = 0;
		StructType* _tmp7_;
#line 332 "document_structure.vala"
		if (is_begin_env) {
#line 332 "document_structure.vala"
			_tmp6_ = STRUCT_TYPE_BEGIN_VERBATIM;
#line 1894 "document_structure.c"
		} else {
#line 332 "document_structure.vala"
			_tmp6_ = STRUCT_TYPE_END_VERBATIM;
#line 1898 "document_structure.c"
		}
#line 332 "document_structure.vala"
		_tmp7_ = __struct_type_dup0 (&_tmp6_);
#line 332 "document_structure.vala"
		_g_free0 (_vala_type);
#line 332 "document_structure.vala"
		_vala_type = _tmp7_;
#line 333 "document_structure.vala"
		result = TRUE;
#line 333 "document_structure.vala"
		_g_free0 (contents);
#line 333 "document_structure.vala"
		if (type) {
#line 333 "document_structure.vala"
			*type = _vala_type;
#line 1914 "document_structure.c"
		} else {
#line 333 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1918 "document_structure.c"
		}
#line 333 "document_structure.vala"
		if (end_match_index) {
#line 333 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1924 "document_structure.c"
		} else {
#line 333 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1928 "document_structure.c"
		}
#line 333 "document_structure.vala"
		return result;
#line 1932 "document_structure.c"
	}
#line 336 "document_structure.vala"
	_tmp8_ = contents;
#line 336 "document_structure.vala"
	if (g_strcmp0 (_tmp8_, "figure") == 0) {
#line 1938 "document_structure.c"
		StructType _tmp9_ = 0;
		StructType* _tmp10_;
#line 338 "document_structure.vala"
		if (is_begin_env) {
#line 338 "document_structure.vala"
			_tmp9_ = STRUCT_TYPE_BEGIN_FIGURE;
#line 1945 "document_structure.c"
		} else {
#line 338 "document_structure.vala"
			_tmp9_ = STRUCT_TYPE_END_FIGURE;
#line 1949 "document_structure.c"
		}
#line 338 "document_structure.vala"
		_tmp10_ = __struct_type_dup0 (&_tmp9_);
#line 338 "document_structure.vala"
		_g_free0 (_vala_type);
#line 338 "document_structure.vala"
		_vala_type = _tmp10_;
#line 339 "document_structure.vala"
		result = TRUE;
#line 339 "document_structure.vala"
		_g_free0 (contents);
#line 339 "document_structure.vala"
		if (type) {
#line 339 "document_structure.vala"
			*type = _vala_type;
#line 1965 "document_structure.c"
		} else {
#line 339 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1969 "document_structure.c"
		}
#line 339 "document_structure.vala"
		if (end_match_index) {
#line 339 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1975 "document_structure.c"
		} else {
#line 339 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1979 "document_structure.c"
		}
#line 339 "document_structure.vala"
		return result;
#line 1983 "document_structure.c"
	}
#line 342 "document_structure.vala"
	_tmp11_ = contents;
#line 342 "document_structure.vala"
	if (g_strcmp0 (_tmp11_, "table") == 0) {
#line 1989 "document_structure.c"
		StructType _tmp12_ = 0;
		StructType* _tmp13_;
#line 344 "document_structure.vala"
		if (is_begin_env) {
#line 344 "document_structure.vala"
			_tmp12_ = STRUCT_TYPE_BEGIN_TABLE;
#line 1996 "document_structure.c"
		} else {
#line 344 "document_structure.vala"
			_tmp12_ = STRUCT_TYPE_END_TABLE;
#line 2000 "document_structure.c"
		}
#line 344 "document_structure.vala"
		_tmp13_ = __struct_type_dup0 (&_tmp12_);
#line 344 "document_structure.vala"
		_g_free0 (_vala_type);
#line 344 "document_structure.vala"
		_vala_type = _tmp13_;
#line 345 "document_structure.vala"
		result = TRUE;
#line 345 "document_structure.vala"
		_g_free0 (contents);
#line 345 "document_structure.vala"
		if (type) {
#line 345 "document_structure.vala"
			*type = _vala_type;
#line 2016 "document_structure.c"
		} else {
#line 345 "document_structure.vala"
			_g_free0 (_vala_type);
#line 2020 "document_structure.c"
		}
#line 345 "document_structure.vala"
		if (end_match_index) {
#line 345 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 2026 "document_structure.c"
		} else {
#line 345 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 2030 "document_structure.c"
		}
#line 345 "document_structure.vala"
		return result;
#line 2034 "document_structure.c"
	}
#line 348 "document_structure.vala"
	_tmp15_ = contents;
#line 348 "document_structure.vala"
	if (g_strcmp0 (_tmp15_, "document") == 0) {
#line 348 "document_structure.vala"
		_tmp14_ = !is_begin_env;
#line 2042 "document_structure.c"
	} else {
#line 348 "document_structure.vala"
		_tmp14_ = FALSE;
#line 2046 "document_structure.c"
	}
#line 348 "document_structure.vala"
	if (_tmp14_) {
#line 2050 "document_structure.c"
		StructType _tmp16_;
		StructType* _tmp17_;
#line 350 "document_structure.vala"
		_tmp16_ = STRUCT_TYPE_END_DOCUMENT;
#line 350 "document_structure.vala"
		_tmp17_ = __struct_type_dup0 (&_tmp16_);
#line 350 "document_structure.vala"
		_g_free0 (_vala_type);
#line 350 "document_structure.vala"
		_vala_type = _tmp17_;
#line 351 "document_structure.vala"
		result = TRUE;
#line 351 "document_structure.vala"
		_g_free0 (contents);
#line 351 "document_structure.vala"
		if (type) {
#line 351 "document_structure.vala"
			*type = _vala_type;
#line 2069 "document_structure.c"
		} else {
#line 351 "document_structure.vala"
			_g_free0 (_vala_type);
#line 2073 "document_structure.c"
		}
#line 351 "document_structure.vala"
		if (end_match_index) {
#line 351 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 2079 "document_structure.c"
		} else {
#line 351 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 2083 "document_structure.c"
		}
#line 351 "document_structure.vala"
		return result;
#line 2087 "document_structure.c"
	}
#line 354 "document_structure.vala"
	result = FALSE;
#line 354 "document_structure.vala"
	_g_free0 (contents);
#line 354 "document_structure.vala"
	if (type) {
#line 354 "document_structure.vala"
		*type = _vala_type;
#line 2097 "document_structure.c"
	} else {
#line 354 "document_structure.vala"
		_g_free0 (_vala_type);
#line 2101 "document_structure.c"
	}
#line 354 "document_structure.vala"
	if (end_match_index) {
#line 354 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 2107 "document_structure.c"
	} else {
#line 354 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 2111 "document_structure.c"
	}
#line 354 "document_structure.vala"
	return result;
#line 2115 "document_structure.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "glib-2.0.vapi"
		result = maxlen;
#line 1338 "glib-2.0.vapi"
		return result;
#line 2139 "document_structure.c"
	} else {
		gchar* _tmp2_;
#line 1340 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "glib-2.0.vapi"
		return result;
#line 2148 "document_structure.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 2169 "document_structure.c"
	} else {
#line 1349 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2173 "document_structure.c"
	}
#line 1349 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 2179 "document_structure.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 2189 "document_structure.c"
	}
#line 1356 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 2193 "document_structure.c"
		glong _tmp3_;
#line 1357 "glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 2201 "document_structure.c"
	} else {
		glong _tmp4_;
#line 1360 "glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 2208 "document_structure.c"
	}
#line 1362 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 2212 "document_structure.c"
		glong _tmp5_;
#line 1363 "glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 2218 "document_structure.c"
	}
#line 1365 "glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "glib-2.0.vapi"
	return result;
#line 2230 "document_structure.c"
}


static gchar*
document_structure_get_markup_name (DocumentStructure* self,
                                    const gchar* line,
                                    gint after_backslash_index,
                                    gint** begin_contents_index)
{
	gint* _vala_begin_contents_index = NULL;
	gchar* result = NULL;
	gchar* after_backslash_text = NULL;
	gchar* _tmp0_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp1_;
	const gchar* _tmp2_;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	gint pos = 0;
	GMatchInfo* _tmp5_;
	gint _tmp6_ = 0;
	gint begin_first_arg_index = 0;
	gint _tmp7_;
	gchar* markup_name = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_ = 0;
	gboolean _tmp12_;
	gint _tmp13_;
	gint* _tmp14_;
#line 358 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 358 "document_structure.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 361 "document_structure.vala"
	_g_free0 (_vala_begin_contents_index);
#line 361 "document_structure.vala"
	_vala_begin_contents_index = NULL;
#line 364 "document_structure.vala"
	_tmp0_ = string_substring (line, (glong) after_backslash_index, (glong) -1);
#line 364 "document_structure.vala"
	after_backslash_text = _tmp0_;
#line 367 "document_structure.vala"
	_tmp1_ = document_structure__command_name_regex;
#line 367 "document_structure.vala"
	_tmp2_ = after_backslash_text;
#line 367 "document_structure.vala"
	_tmp4_ = g_regex_match (_tmp1_, _tmp2_, 0, &_tmp3_);
#line 367 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 367 "document_structure.vala"
	match_info = _tmp3_;
#line 367 "document_structure.vala"
	if (!_tmp4_) {
#line 368 "document_structure.vala"
		result = NULL;
#line 368 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 368 "document_structure.vala"
		_g_free0 (after_backslash_text);
#line 368 "document_structure.vala"
		if (begin_contents_index) {
#line 368 "document_structure.vala"
			*begin_contents_index = _vala_begin_contents_index;
#line 2296 "document_structure.c"
		} else {
#line 368 "document_structure.vala"
			_g_free0 (_vala_begin_contents_index);
#line 2300 "document_structure.c"
		}
#line 368 "document_structure.vala"
		return result;
#line 2304 "document_structure.c"
	}
#line 371 "document_structure.vala"
	_tmp5_ = match_info;
#line 371 "document_structure.vala"
	g_match_info_fetch_pos (_tmp5_, 0, NULL, &_tmp6_);
#line 371 "document_structure.vala"
	pos = _tmp6_;
#line 372 "document_structure.vala"
	_tmp7_ = pos;
#line 372 "document_structure.vala"
	begin_first_arg_index = after_backslash_index + _tmp7_;
#line 374 "document_structure.vala"
	_tmp8_ = match_info;
#line 374 "document_structure.vala"
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "name");
#line 374 "document_structure.vala"
	markup_name = _tmp9_;
#line 377 "document_structure.vala"
	_tmp10_ = begin_first_arg_index;
#line 377 "document_structure.vala"
	_tmp12_ = document_structure_search_firt_non_optional_arg (self, line, _tmp10_ - 1, &_tmp11_);
#line 377 "document_structure.vala"
	_g_free0 (_vala_begin_contents_index);
#line 377 "document_structure.vala"
	_tmp13_ = _tmp11_;
#line 377 "document_structure.vala"
	_tmp14_ = __int_dup0 (&_tmp13_);
#line 377 "document_structure.vala"
	_vala_begin_contents_index = _tmp14_;
#line 377 "document_structure.vala"
	if (_tmp12_) {
#line 380 "document_structure.vala"
		result = markup_name;
#line 380 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 380 "document_structure.vala"
		_g_free0 (after_backslash_text);
#line 380 "document_structure.vala"
		if (begin_contents_index) {
#line 380 "document_structure.vala"
			*begin_contents_index = _vala_begin_contents_index;
#line 2346 "document_structure.c"
		} else {
#line 380 "document_structure.vala"
			_g_free0 (_vala_begin_contents_index);
#line 2350 "document_structure.c"
		}
#line 380 "document_structure.vala"
		return result;
#line 2354 "document_structure.c"
	}
#line 383 "document_structure.vala"
	result = NULL;
#line 383 "document_structure.vala"
	_g_free0 (markup_name);
#line 383 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 383 "document_structure.vala"
	_g_free0 (after_backslash_text);
#line 383 "document_structure.vala"
	if (begin_contents_index) {
#line 383 "document_structure.vala"
		*begin_contents_index = _vala_begin_contents_index;
#line 2368 "document_structure.c"
	} else {
#line 383 "document_structure.vala"
		_g_free0 (_vala_begin_contents_index);
#line 2372 "document_structure.c"
	}
#line 383 "document_structure.vala"
	return result;
#line 2376 "document_structure.c"
}


static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
#line 1143 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1144 "glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1145 "glib-2.0.vapi"
	_tmp0_ = _vala_c;
#line 1145 "glib-2.0.vapi"
	if (_tmp0_ != ((gunichar) 0)) {
#line 2396 "document_structure.c"
		gchar* _tmp1_;
#line 1146 "glib-2.0.vapi"
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1146 "glib-2.0.vapi"
		*index = (gint) (_tmp1_ - ((gchar*) self));
#line 1147 "glib-2.0.vapi"
		result = TRUE;
#line 1147 "glib-2.0.vapi"
		if (c) {
#line 1147 "glib-2.0.vapi"
			*c = _vala_c;
#line 2408 "document_structure.c"
		}
#line 1147 "glib-2.0.vapi"
		return result;
#line 2412 "document_structure.c"
	} else {
#line 1149 "glib-2.0.vapi"
		result = FALSE;
#line 1149 "glib-2.0.vapi"
		if (c) {
#line 1149 "glib-2.0.vapi"
			*c = _vala_c;
#line 2420 "document_structure.c"
		}
#line 1149 "glib-2.0.vapi"
		return result;
#line 2424 "document_structure.c"
	}
#line 1143 "glib-2.0.vapi"
	if (c) {
#line 1143 "glib-2.0.vapi"
		*c = _vala_c;
#line 2430 "document_structure.c"
	}
}


static gboolean
document_structure_search_firt_non_optional_arg (DocumentStructure* self,
                                                 const gchar* line,
                                                 gint start_index,
                                                 gint* begin_contents_index)
{
	gint _vala_begin_contents_index = 0;
	gboolean result = FALSE;
	gint cur_index = 0;
	gboolean in_optional_arg = FALSE;
	gint additional_bracket_level = 0;
#line 387 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 387 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 390 "document_structure.vala"
	_vala_begin_contents_index = 0;
#line 392 "document_structure.vala"
	cur_index = start_index;
#line 393 "document_structure.vala"
	in_optional_arg = FALSE;
#line 394 "document_structure.vala"
	additional_bracket_level = 0;
#line 396 "document_structure.vala"
	while (TRUE) {
#line 2460 "document_structure.c"
		gint next_index = 0;
		gint _tmp0_;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp12_;
		gint _tmp13_;
#line 398 "document_structure.vala"
		_tmp0_ = cur_index;
#line 398 "document_structure.vala"
		next_index = _tmp0_;
#line 400 "document_structure.vala"
		_tmp2_ = string_get_next_char (line, &next_index, &_tmp1_);
#line 400 "document_structure.vala"
		cur_char = _tmp1_;
#line 400 "document_structure.vala"
		end = !_tmp2_;
#line 402 "document_structure.vala"
		_tmp3_ = in_optional_arg;
#line 402 "document_structure.vala"
		if (_tmp3_) {
#line 2484 "document_structure.c"
			gunichar _tmp4_;
#line 404 "document_structure.vala"
			_tmp4_ = cur_char;
#line 404 "document_structure.vala"
			switch (_tmp4_) {
#line 404 "document_structure.vala"
				case ']':
#line 2492 "document_structure.c"
				{
					gint _tmp5_;
#line 407 "document_structure.vala"
					_tmp5_ = cur_index;
#line 407 "document_structure.vala"
					if (!utils_char_is_escaped (line, (glong) _tmp5_)) {
#line 2499 "document_structure.c"
						gint _tmp6_;
#line 409 "document_structure.vala"
						_tmp6_ = additional_bracket_level;
#line 409 "document_structure.vala"
						if (0 < _tmp6_) {
#line 2505 "document_structure.c"
							gint _tmp7_;
#line 410 "document_structure.vala"
							_tmp7_ = additional_bracket_level;
#line 410 "document_structure.vala"
							additional_bracket_level = _tmp7_ - 1;
#line 2511 "document_structure.c"
						} else {
#line 412 "document_structure.vala"
							in_optional_arg = FALSE;
#line 2515 "document_structure.c"
						}
					}
#line 414 "document_structure.vala"
					break;
#line 2520 "document_structure.c"
				}
#line 404 "document_structure.vala"
				case '[':
#line 2524 "document_structure.c"
				{
					gint _tmp8_;
#line 417 "document_structure.vala"
					_tmp8_ = cur_index;
#line 417 "document_structure.vala"
					if (!utils_char_is_escaped (line, (glong) _tmp8_)) {
#line 2531 "document_structure.c"
						gint _tmp9_;
#line 418 "document_structure.vala"
						_tmp9_ = additional_bracket_level;
#line 418 "document_structure.vala"
						additional_bracket_level = _tmp9_ + 1;
#line 2537 "document_structure.c"
					}
#line 419 "document_structure.vala"
					break;
#line 2541 "document_structure.c"
				}
				default:
#line 404 "document_structure.vala"
				break;
#line 2546 "document_structure.c"
			}
		} else {
			gunichar _tmp10_;
#line 426 "document_structure.vala"
			_tmp10_ = cur_char;
#line 426 "document_structure.vala"
			switch (_tmp10_) {
#line 426 "document_structure.vala"
				case '{':
#line 2556 "document_structure.c"
				{
					gint _tmp11_;
#line 429 "document_structure.vala"
					_tmp11_ = next_index;
#line 429 "document_structure.vala"
					_vala_begin_contents_index = _tmp11_;
#line 430 "document_structure.vala"
					result = TRUE;
#line 430 "document_structure.vala"
					if (begin_contents_index) {
#line 430 "document_structure.vala"
						*begin_contents_index = _vala_begin_contents_index;
#line 2569 "document_structure.c"
					}
#line 430 "document_structure.vala"
					return result;
#line 2573 "document_structure.c"
				}
#line 426 "document_structure.vala"
				case '[':
#line 2577 "document_structure.c"
				{
#line 433 "document_structure.vala"
					in_optional_arg = TRUE;
#line 434 "document_structure.vala"
					break;
#line 2583 "document_structure.c"
				}
#line 426 "document_structure.vala"
				case ' ':
#line 426 "document_structure.vala"
				case '\t':
#line 2589 "document_structure.c"
				{
#line 438 "document_structure.vala"
					break;
#line 2593 "document_structure.c"
				}
				default:
				{
#line 441 "document_structure.vala"
					result = FALSE;
#line 441 "document_structure.vala"
					if (begin_contents_index) {
#line 441 "document_structure.vala"
						*begin_contents_index = _vala_begin_contents_index;
#line 2603 "document_structure.c"
					}
#line 441 "document_structure.vala"
					return result;
#line 2607 "document_structure.c"
				}
			}
		}
#line 445 "document_structure.vala"
		_tmp12_ = end;
#line 445 "document_structure.vala"
		if (_tmp12_) {
#line 446 "document_structure.vala"
			result = FALSE;
#line 446 "document_structure.vala"
			if (begin_contents_index) {
#line 446 "document_structure.vala"
				*begin_contents_index = _vala_begin_contents_index;
#line 2621 "document_structure.c"
			}
#line 446 "document_structure.vala"
			return result;
#line 2625 "document_structure.c"
		}
#line 448 "document_structure.vala"
		_tmp13_ = next_index;
#line 448 "document_structure.vala"
		cur_index = _tmp13_;
#line 2631 "document_structure.c"
	}
#line 387 "document_structure.vala"
	if (begin_contents_index) {
#line 387 "document_structure.vala"
		*begin_contents_index = _vala_begin_contents_index;
#line 2637 "document_structure.c"
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
#line 1369 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1370 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1370 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1370 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1371 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 2664 "document_structure.c"
		glong _tmp2_;
#line 1372 "glib-2.0.vapi"
		_tmp2_ = string_length;
#line 1372 "glib-2.0.vapi"
		start = _tmp2_ + start;
#line 2670 "document_structure.c"
	}
#line 1374 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 2674 "document_structure.c"
		glong _tmp3_;
#line 1375 "glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1375 "glib-2.0.vapi"
		end = _tmp3_ + end;
#line 2680 "document_structure.c"
	}
#line 1377 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 2684 "document_structure.c"
		glong _tmp5_;
#line 1377 "glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1377 "glib-2.0.vapi"
		_tmp4_ = start <= _tmp5_;
#line 2690 "document_structure.c"
	} else {
#line 1377 "glib-2.0.vapi"
		_tmp4_ = FALSE;
#line 2694 "document_structure.c"
	}
#line 1377 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp4_, NULL);
#line 1378 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 2700 "document_structure.c"
		glong _tmp7_;
#line 1378 "glib-2.0.vapi"
		_tmp7_ = string_length;
#line 1378 "glib-2.0.vapi"
		_tmp6_ = end <= _tmp7_;
#line 2706 "document_structure.c"
	} else {
#line 1378 "glib-2.0.vapi"
		_tmp6_ = FALSE;
#line 2710 "document_structure.c"
	}
#line 1378 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp6_, NULL);
#line 1379 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1380 "glib-2.0.vapi"
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1380 "glib-2.0.vapi"
	result = _tmp8_;
#line 1380 "glib-2.0.vapi"
	return result;
#line 2722 "document_structure.c"
}


static gchar*
document_structure_get_markup_contents (DocumentStructure* self,
                                        const gchar* line,
                                        gint begin_contents_index,
                                        gint** end_match_index)
{
	gint* _vala_end_match_index = NULL;
	gchar* result = NULL;
	gint brace_level = 0;
	gint cur_index = 0;
#line 453 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 453 "document_structure.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 456 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 456 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 458 "document_structure.vala"
	brace_level = 0;
#line 459 "document_structure.vala"
	cur_index = begin_contents_index;
#line 461 "document_structure.vala"
	while (TRUE) {
#line 2750 "document_structure.c"
		gint next_index = 0;
		gint _tmp0_;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_ = FALSE;
		gunichar _tmp4_;
		gboolean _tmp17_;
		gint _tmp18_;
#line 463 "document_structure.vala"
		_tmp0_ = cur_index;
#line 463 "document_structure.vala"
		next_index = _tmp0_;
#line 465 "document_structure.vala"
		_tmp2_ = string_get_next_char (line, &next_index, &_tmp1_);
#line 465 "document_structure.vala"
		cur_char = _tmp1_;
#line 465 "document_structure.vala"
		end = !_tmp2_;
#line 467 "document_structure.vala"
		_tmp4_ = cur_char;
#line 467 "document_structure.vala"
		if (_tmp4_ == ((gunichar) '{')) {
#line 2775 "document_structure.c"
			gint _tmp5_;
#line 467 "document_structure.vala"
			_tmp5_ = cur_index;
#line 467 "document_structure.vala"
			_tmp3_ = !utils_char_is_escaped (line, (glong) _tmp5_);
#line 2781 "document_structure.c"
		} else {
#line 467 "document_structure.vala"
			_tmp3_ = FALSE;
#line 2785 "document_structure.c"
		}
#line 467 "document_structure.vala"
		if (_tmp3_) {
#line 2789 "document_structure.c"
			gint _tmp6_;
#line 468 "document_structure.vala"
			_tmp6_ = brace_level;
#line 468 "document_structure.vala"
			brace_level = _tmp6_ + 1;
#line 2795 "document_structure.c"
		} else {
			gboolean _tmp7_ = FALSE;
			gunichar _tmp8_;
#line 470 "document_structure.vala"
			_tmp8_ = cur_char;
#line 470 "document_structure.vala"
			if (_tmp8_ == ((gunichar) '}')) {
#line 2803 "document_structure.c"
				gint _tmp9_;
#line 470 "document_structure.vala"
				_tmp9_ = cur_index;
#line 470 "document_structure.vala"
				_tmp7_ = !utils_char_is_escaped (line, (glong) _tmp9_);
#line 2809 "document_structure.c"
			} else {
#line 470 "document_structure.vala"
				_tmp7_ = FALSE;
#line 2813 "document_structure.c"
			}
#line 470 "document_structure.vala"
			if (_tmp7_) {
#line 2817 "document_structure.c"
				gint _tmp10_;
#line 472 "document_structure.vala"
				_tmp10_ = brace_level;
#line 472 "document_structure.vala"
				if (_tmp10_ > 0) {
#line 2823 "document_structure.c"
					gint _tmp11_;
#line 473 "document_structure.vala"
					_tmp11_ = brace_level;
#line 473 "document_structure.vala"
					brace_level = _tmp11_ - 1;
#line 2829 "document_structure.c"
				} else {
					gchar* contents = NULL;
					gint _tmp12_;
					gchar* _tmp13_;
					const gchar* _tmp14_;
					gint _tmp15_;
					gint* _tmp16_;
#line 478 "document_structure.vala"
					_tmp12_ = cur_index;
#line 478 "document_structure.vala"
					_tmp13_ = string_slice (line, (glong) begin_contents_index, (glong) _tmp12_);
#line 478 "document_structure.vala"
					contents = _tmp13_;
#line 481 "document_structure.vala"
					_tmp14_ = contents;
#line 481 "document_structure.vala"
					if (g_strcmp0 (_tmp14_, "") == 0) {
#line 482 "document_structure.vala"
						result = NULL;
#line 482 "document_structure.vala"
						_g_free0 (contents);
#line 482 "document_structure.vala"
						if (end_match_index) {
#line 482 "document_structure.vala"
							*end_match_index = _vala_end_match_index;
#line 2855 "document_structure.c"
						} else {
#line 482 "document_structure.vala"
							_g_free0 (_vala_end_match_index);
#line 2859 "document_structure.c"
						}
#line 482 "document_structure.vala"
						return result;
#line 2863 "document_structure.c"
					}
#line 484 "document_structure.vala"
					_tmp15_ = next_index;
#line 484 "document_structure.vala"
					_tmp16_ = __int_dup0 (&_tmp15_);
#line 484 "document_structure.vala"
					_g_free0 (_vala_end_match_index);
#line 484 "document_structure.vala"
					_vala_end_match_index = _tmp16_;
#line 486 "document_structure.vala"
					result = contents;
#line 486 "document_structure.vala"
					if (end_match_index) {
#line 486 "document_structure.vala"
						*end_match_index = _vala_end_match_index;
#line 2879 "document_structure.c"
					} else {
#line 486 "document_structure.vala"
						_g_free0 (_vala_end_match_index);
#line 2883 "document_structure.c"
					}
#line 486 "document_structure.vala"
					return result;
#line 2887 "document_structure.c"
				}
			}
		}
#line 490 "document_structure.vala"
		_tmp17_ = end;
#line 490 "document_structure.vala"
		if (_tmp17_) {
#line 491 "document_structure.vala"
			result = NULL;
#line 491 "document_structure.vala"
			if (end_match_index) {
#line 491 "document_structure.vala"
				*end_match_index = _vala_end_match_index;
#line 2901 "document_structure.c"
			} else {
#line 491 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 2905 "document_structure.c"
			}
#line 491 "document_structure.vala"
			return result;
#line 2909 "document_structure.c"
		}
#line 493 "document_structure.vala"
		_tmp18_ = next_index;
#line 493 "document_structure.vala"
		cur_index = _tmp18_;
#line 2915 "document_structure.c"
	}
#line 453 "document_structure.vala"
	if (end_match_index) {
#line 453 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 2921 "document_structure.c"
	} else {
#line 453 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 2925 "document_structure.c"
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "glib-2.0.vapi"
	result = _result_;
#line 1251 "glib-2.0.vapi"
	return result;
#line 2951 "document_structure.c"
}


static gboolean
document_structure_search_comment (DocumentStructure* self,
                                   const gchar* line,
                                   gint after_percent_index,
                                   StructType** type,
                                   gchar* * contents,
                                   gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gchar* text_after = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	StructType _tmp10_ = 0;
	const gchar* _tmp11_;
	StructType* _tmp12_;
	GMatchInfo* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint* _tmp17_;
#line 497 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 497 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 500 "document_structure.vala"
	_g_free0 (_vala_type);
#line 500 "document_structure.vala"
	_vala_type = NULL;
#line 501 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 501 "document_structure.vala"
	_vala_contents = NULL;
#line 502 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 502 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 504 "document_structure.vala"
	_tmp0_ = string_substring (line, (glong) after_percent_index, (glong) -1);
#line 504 "document_structure.vala"
	_tmp1_ = _tmp0_;
#line 504 "document_structure.vala"
	_tmp2_ = string_strip (_tmp1_);
#line 504 "document_structure.vala"
	_tmp3_ = _tmp2_;
#line 504 "document_structure.vala"
	_g_free0 (_tmp1_);
#line 504 "document_structure.vala"
	text_after = _tmp3_;
#line 507 "document_structure.vala"
	_tmp4_ = document_structure__comment_regex;
#line 507 "document_structure.vala"
	_tmp5_ = text_after;
#line 507 "document_structure.vala"
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
#line 507 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 507 "document_structure.vala"
	match_info = _tmp6_;
#line 507 "document_structure.vala"
	if (!_tmp7_) {
#line 508 "document_structure.vala"
		result = FALSE;
#line 508 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 508 "document_structure.vala"
		_g_free0 (text_after);
#line 508 "document_structure.vala"
		if (type) {
#line 508 "document_structure.vala"
			*type = _vala_type;
#line 3038 "document_structure.c"
		} else {
#line 508 "document_structure.vala"
			_g_free0 (_vala_type);
#line 3042 "document_structure.c"
		}
#line 508 "document_structure.vala"
		if (contents) {
#line 508 "document_structure.vala"
			*contents = _vala_contents;
#line 3048 "document_structure.c"
		} else {
#line 508 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 3052 "document_structure.c"
		}
#line 508 "document_structure.vala"
		if (end_match_index) {
#line 508 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 3058 "document_structure.c"
		} else {
#line 508 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 3062 "document_structure.c"
		}
#line 508 "document_structure.vala"
		return result;
#line 3066 "document_structure.c"
	}
#line 510 "document_structure.vala"
	_tmp8_ = match_info;
#line 510 "document_structure.vala"
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "type");
#line 510 "document_structure.vala"
	type_str = _tmp9_;
#line 511 "document_structure.vala"
	_tmp11_ = type_str;
#line 511 "document_structure.vala"
	if (g_strcmp0 (_tmp11_, "TODO") == 0) {
#line 511 "document_structure.vala"
		_tmp10_ = STRUCT_TYPE_TODO;
#line 3080 "document_structure.c"
	} else {
#line 511 "document_structure.vala"
		_tmp10_ = STRUCT_TYPE_FIXME;
#line 3084 "document_structure.c"
	}
#line 511 "document_structure.vala"
	_tmp12_ = __struct_type_dup0 (&_tmp10_);
#line 511 "document_structure.vala"
	_g_free0 (_vala_type);
#line 511 "document_structure.vala"
	_vala_type = _tmp12_;
#line 513 "document_structure.vala"
	_tmp13_ = match_info;
#line 513 "document_structure.vala"
	_tmp14_ = g_match_info_fetch_named (_tmp13_, "text");
#line 513 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 513 "document_structure.vala"
	_vala_contents = _tmp14_;
#line 514 "document_structure.vala"
	_tmp15_ = strlen (line);
#line 514 "document_structure.vala"
	_tmp16_ = _tmp15_;
#line 514 "document_structure.vala"
	_tmp17_ = __int_dup0 (&_tmp16_);
#line 514 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 514 "document_structure.vala"
	_vala_end_match_index = _tmp17_;
#line 516 "document_structure.vala"
	result = TRUE;
#line 516 "document_structure.vala"
	_g_free0 (type_str);
#line 516 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 516 "document_structure.vala"
	_g_free0 (text_after);
#line 516 "document_structure.vala"
	if (type) {
#line 516 "document_structure.vala"
		*type = _vala_type;
#line 3122 "document_structure.c"
	} else {
#line 516 "document_structure.vala"
		_g_free0 (_vala_type);
#line 3126 "document_structure.c"
	}
#line 516 "document_structure.vala"
	if (contents) {
#line 516 "document_structure.vala"
		*contents = _vala_contents;
#line 3132 "document_structure.c"
	} else {
#line 516 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 3136 "document_structure.c"
	}
#line 516 "document_structure.vala"
	if (end_match_index) {
#line 516 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 3142 "document_structure.c"
	} else {
#line 516 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 3146 "document_structure.c"
	}
#line 516 "document_structure.vala"
	return result;
#line 3150 "document_structure.c"
}


static void
document_structure_handle_item (DocumentStructure* self,
                                StructType type,
                                const gchar* contents,
                                GtkTextIter* iter)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 519 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 519 "document_structure.vala"
	g_return_if_fail (iter != NULL);
#line 522 "document_structure.vala"
	_tmp0_ = self->priv->_in_verbatim_env;
#line 522 "document_structure.vala"
	if (_tmp0_) {
#line 524 "document_structure.vala"
		if (type == STRUCT_TYPE_END_VERBATIM) {
#line 525 "document_structure.vala"
			self->priv->_in_verbatim_env = FALSE;
#line 3174 "document_structure.c"
		}
#line 527 "document_structure.vala"
		return;
#line 3178 "document_structure.c"
	}
#line 530 "document_structure.vala"
	if (type == STRUCT_TYPE_TODO) {
#line 530 "document_structure.vala"
		_tmp1_ = TRUE;
#line 3184 "document_structure.c"
	} else {
#line 530 "document_structure.vala"
		_tmp1_ = type == STRUCT_TYPE_FIXME;
#line 3188 "document_structure.c"
	}
#line 530 "document_structure.vala"
	if (_tmp1_) {
#line 3192 "document_structure.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GtkTextIter _tmp5_;
		GtkTreeIter* _tmp6_;
		GtkTreeIter* _tmp7_;
#line 531 "document_structure.vala"
		_tmp3_ = document_structure_truncate (self, contents);
#line 531 "document_structure.vala"
		_tmp2_ = _tmp3_;
#line 531 "document_structure.vala"
		if (_tmp2_ == NULL) {
#line 3204 "document_structure.c"
			gchar* _tmp4_;
#line 531 "document_structure.vala"
			_tmp4_ = g_strdup (contents);
#line 531 "document_structure.vala"
			_g_free0 (_tmp2_);
#line 531 "document_structure.vala"
			_tmp2_ = _tmp4_;
#line 3212 "document_structure.c"
		}
#line 531 "document_structure.vala"
		_tmp5_ = *iter;
#line 531 "document_structure.vala"
		_tmp6_ = document_structure_add_item (self, type, _tmp2_, &_tmp5_);
#line 531 "document_structure.vala"
		_tmp7_ = _tmp6_;
#line 531 "document_structure.vala"
		_g_free0 (_tmp7_);
#line 530 "document_structure.vala"
		_g_free0 (_tmp2_);
#line 3224 "document_structure.c"
	} else {
#line 534 "document_structure.vala"
		if (structure_is_common_type (type)) {
#line 3228 "document_structure.c"
			GtkTextIter _tmp8_;
			GtkTreeIter* _tmp9_;
			GtkTreeIter* _tmp10_;
#line 535 "document_structure.vala"
			_tmp8_ = *iter;
#line 535 "document_structure.vala"
			_tmp9_ = document_structure_add_item (self, type, contents, &_tmp8_);
#line 535 "document_structure.vala"
			_tmp10_ = _tmp9_;
#line 535 "document_structure.vala"
			_g_free0 (_tmp10_);
#line 3240 "document_structure.c"
		} else {
#line 538 "document_structure.vala"
			if (type == STRUCT_TYPE_BEGIN_VERBATIM) {
#line 539 "document_structure.vala"
				self->priv->_in_verbatim_env = TRUE;
#line 3246 "document_structure.c"
			} else {
				gboolean _tmp11_ = FALSE;
#line 542 "document_structure.vala"
				if (type == STRUCT_TYPE_BEGIN_FIGURE) {
#line 542 "document_structure.vala"
					_tmp11_ = TRUE;
#line 3253 "document_structure.c"
				} else {
#line 542 "document_structure.vala"
					_tmp11_ = type == STRUCT_TYPE_BEGIN_TABLE;
#line 3257 "document_structure.c"
				}
#line 542 "document_structure.vala"
				if (_tmp11_) {
#line 3261 "document_structure.c"
					GtkTextIter _tmp12_;
#line 543 "document_structure.vala"
					_tmp12_ = *iter;
#line 543 "document_structure.vala"
					document_structure_create_new_environment (self, type, &_tmp12_);
#line 3267 "document_structure.c"
				} else {
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
#line 546 "document_structure.vala"
					if (type == STRUCT_TYPE_CAPTION) {
#line 3273 "document_structure.c"
						DocumentStructureEnvData* _tmp15_;
#line 546 "document_structure.vala"
						_tmp15_ = self->priv->_last_env_data;
#line 546 "document_structure.vala"
						_tmp14_ = _tmp15_ != NULL;
#line 3279 "document_structure.c"
					} else {
#line 546 "document_structure.vala"
						_tmp14_ = FALSE;
#line 3283 "document_structure.c"
					}
#line 546 "document_structure.vala"
					if (_tmp14_) {
#line 3287 "document_structure.c"
						DocumentStructureEnvData* _tmp16_;
						const gchar* _tmp17_;
#line 547 "document_structure.vala"
						_tmp16_ = self->priv->_last_env_data;
#line 547 "document_structure.vala"
						_tmp17_ = (*_tmp16_).first_caption;
#line 547 "document_structure.vala"
						_tmp13_ = _tmp17_ == NULL;
#line 3296 "document_structure.c"
					} else {
#line 546 "document_structure.vala"
						_tmp13_ = FALSE;
#line 3300 "document_structure.c"
					}
#line 546 "document_structure.vala"
					if (_tmp13_) {
#line 3304 "document_structure.c"
						gchar* _tmp18_ = NULL;
						gchar* _tmp19_;
						DocumentStructureEnvData* _tmp21_;
						gchar* _tmp22_;
#line 549 "document_structure.vala"
						_tmp19_ = document_structure_truncate (self, contents);
#line 549 "document_structure.vala"
						_tmp18_ = _tmp19_;
#line 549 "document_structure.vala"
						if (_tmp18_ == NULL) {
#line 3315 "document_structure.c"
							gchar* _tmp20_;
#line 549 "document_structure.vala"
							_tmp20_ = g_strdup (contents);
#line 549 "document_structure.vala"
							_g_free0 (_tmp18_);
#line 549 "document_structure.vala"
							_tmp18_ = _tmp20_;
#line 3323 "document_structure.c"
						}
#line 549 "document_structure.vala"
						_tmp21_ = self->priv->_last_env_data;
#line 549 "document_structure.vala"
						_tmp22_ = _tmp18_;
#line 549 "document_structure.vala"
						_tmp18_ = NULL;
#line 549 "document_structure.vala"
						_g_free0 ((*_tmp21_).first_caption);
#line 549 "document_structure.vala"
						(*_tmp21_).first_caption = _tmp22_;
#line 546 "document_structure.vala"
						_g_free0 (_tmp18_);
#line 3337 "document_structure.c"
					} else {
#line 553 "document_structure.vala"
						if (document_structure_verify_end_environment_type (self, type)) {
#line 3341 "document_structure.c"
							GtkTextMark* end_mark = NULL;
							GtkTextIter _tmp23_;
							GtkTextMark* _tmp24_;
							StructureModel* _tmp25_;
							DocumentStructureEnvData* _tmp26_;
							GtkTreePath* _tmp27_;
							DocumentStructureEnvData* _tmp28_;
							const gchar* _tmp29_;
							GtkTextMark* _tmp30_;
#line 555 "document_structure.vala"
							_tmp23_ = *iter;
#line 555 "document_structure.vala"
							_tmp24_ = document_structure_create_text_mark_from_iter (self, &_tmp23_);
#line 555 "document_structure.vala"
							end_mark = _tmp24_;
#line 556 "document_structure.vala"
							_tmp25_ = self->priv->_model;
#line 556 "document_structure.vala"
							_tmp26_ = self->priv->_last_env_data;
#line 556 "document_structure.vala"
							_tmp27_ = (*_tmp26_).path;
#line 556 "document_structure.vala"
							_tmp28_ = self->priv->_last_env_data;
#line 556 "document_structure.vala"
							_tmp29_ = (*_tmp28_).first_caption;
#line 556 "document_structure.vala"
							_tmp30_ = end_mark;
#line 556 "document_structure.vala"
							structure_model_modify_data (_tmp25_, _tmp27_, _tmp29_, _tmp30_);
#line 558 "document_structure.vala"
							_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 558 "document_structure.vala"
							self->priv->_last_env_data = NULL;
#line 553 "document_structure.vala"
							_g_object_unref0 (end_mark);
#line 3377 "document_structure.c"
						} else {
#line 562 "document_structure.vala"
							if (type == STRUCT_TYPE_END_DOCUMENT) {
#line 3381 "document_structure.c"
								GtkTextIter _tmp31_;
								GtkTextMark* _tmp32_;
#line 563 "document_structure.vala"
								_tmp31_ = *iter;
#line 563 "document_structure.vala"
								_tmp32_ = document_structure_create_text_mark_from_iter (self, &_tmp31_);
#line 563 "document_structure.vala"
								_g_object_unref0 (self->priv->_end_document_mark);
#line 563 "document_structure.vala"
								self->priv->_end_document_mark = _tmp32_;
#line 3392 "document_structure.c"
							}
						}
					}
				}
			}
		}
	}
}


static gpointer
_document_structure_env_data_dup0 (gpointer self)
{
#line 571 "document_structure.vala"
	return self ? document_structure_env_data_dup (self) : NULL;
#line 3408 "document_structure.c"
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 580 "document_structure.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 3417 "document_structure.c"
}


static void
document_structure_create_new_environment (DocumentStructure* self,
                                           StructType type,
                                           GtkTextIter* start_iter)
{
	gboolean _tmp0_ = FALSE;
	DocumentStructureEnvData _tmp1_ = {0};
	DocumentStructureEnvData _tmp2_;
	DocumentStructureEnvData* _tmp3_;
	DocumentStructureEnvData* _tmp4_;
	GtkTreeIter tree_iter = {0};
	DocumentStructureEnvData* _tmp7_;
	StructType _tmp8_;
	GtkTextIter _tmp9_;
	GtkTreeIter* _tmp10_;
	GtkTreeIter* _tmp11_;
	GtkTreeIter _tmp12_;
	DocumentStructureEnvData* _tmp13_;
	StructureModel* _tmp14_;
	GtkTreeIter _tmp15_;
	GtkTreePath* _tmp16_;
#line 566 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 566 "document_structure.vala"
	g_return_if_fail (start_iter != NULL);
#line 568 "document_structure.vala"
	if (type == STRUCT_TYPE_BEGIN_FIGURE) {
#line 568 "document_structure.vala"
		_tmp0_ = TRUE;
#line 3450 "document_structure.c"
	} else {
#line 569 "document_structure.vala"
		_tmp0_ = type == STRUCT_TYPE_BEGIN_TABLE;
#line 3454 "document_structure.c"
	}
#line 568 "document_structure.vala"
	g_return_if_fail (_tmp0_);
#line 571 "document_structure.vala"
	memset (&_tmp1_, 0, sizeof (DocumentStructureEnvData));
#line 571 "document_structure.vala"
	_tmp2_ = _tmp1_;
#line 571 "document_structure.vala"
	_tmp3_ = _document_structure_env_data_dup0 (&_tmp2_);
#line 571 "document_structure.vala"
	_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 571 "document_structure.vala"
	self->priv->_last_env_data = _tmp3_;
#line 571 "document_structure.vala"
	document_structure_env_data_destroy (&_tmp2_);
#line 572 "document_structure.vala"
	_tmp4_ = self->priv->_last_env_data;
#line 572 "document_structure.vala"
	_g_free0 ((*_tmp4_).first_caption);
#line 572 "document_structure.vala"
	(*_tmp4_).first_caption = NULL;
#line 574 "document_structure.vala"
	if (type == STRUCT_TYPE_BEGIN_TABLE) {
#line 3478 "document_structure.c"
		DocumentStructureEnvData* _tmp5_;
#line 575 "document_structure.vala"
		_tmp5_ = self->priv->_last_env_data;
#line 575 "document_structure.vala"
		(*_tmp5_).type = STRUCT_TYPE_TABLE;
#line 3484 "document_structure.c"
	} else {
		DocumentStructureEnvData* _tmp6_;
#line 577 "document_structure.vala"
		_tmp6_ = self->priv->_last_env_data;
#line 577 "document_structure.vala"
		(*_tmp6_).type = STRUCT_TYPE_FIGURE;
#line 3491 "document_structure.c"
	}
#line 579 "document_structure.vala"
	_tmp7_ = self->priv->_last_env_data;
#line 579 "document_structure.vala"
	_tmp8_ = (*_tmp7_).type;
#line 579 "document_structure.vala"
	_tmp9_ = *start_iter;
#line 579 "document_structure.vala"
	_tmp10_ = document_structure_add_item (self, _tmp8_, NULL, &_tmp9_);
#line 579 "document_structure.vala"
	_tmp11_ = _tmp10_;
#line 579 "document_structure.vala"
	_tmp12_ = *_tmp11_;
#line 579 "document_structure.vala"
	_g_free0 (_tmp11_);
#line 579 "document_structure.vala"
	tree_iter = _tmp12_;
#line 580 "document_structure.vala"
	_tmp13_ = self->priv->_last_env_data;
#line 580 "document_structure.vala"
	_tmp14_ = self->priv->_model;
#line 580 "document_structure.vala"
	_tmp15_ = tree_iter;
#line 580 "document_structure.vala"
	_tmp16_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp14_, &_tmp15_);
#line 580 "document_structure.vala"
	__vala_GtkTreePath_free0 ((*_tmp13_).path);
#line 580 "document_structure.vala"
	(*_tmp13_).path = _tmp16_;
#line 3521 "document_structure.c"
}


static gboolean
document_structure_verify_end_environment_type (DocumentStructure* self,
                                                StructType type)
{
	gboolean result = FALSE;
	DocumentStructureEnvData* _tmp0_;
#line 583 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 585 "document_structure.vala"
	_tmp0_ = self->priv->_last_env_data;
#line 585 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 586 "document_structure.vala"
		result = FALSE;
#line 586 "document_structure.vala"
		return result;
#line 3541 "document_structure.c"
	}
#line 588 "document_structure.vala"
	if (type == STRUCT_TYPE_END_TABLE) {
#line 3545 "document_structure.c"
		DocumentStructureEnvData* _tmp1_;
		StructType _tmp2_;
#line 589 "document_structure.vala"
		_tmp1_ = self->priv->_last_env_data;
#line 589 "document_structure.vala"
		_tmp2_ = (*_tmp1_).type;
#line 589 "document_structure.vala"
		result = _tmp2_ == STRUCT_TYPE_TABLE;
#line 589 "document_structure.vala"
		return result;
#line 3556 "document_structure.c"
	}
#line 591 "document_structure.vala"
	if (type == STRUCT_TYPE_END_FIGURE) {
#line 3560 "document_structure.c"
		DocumentStructureEnvData* _tmp3_;
		StructType _tmp4_;
#line 592 "document_structure.vala"
		_tmp3_ = self->priv->_last_env_data;
#line 592 "document_structure.vala"
		_tmp4_ = (*_tmp3_).type;
#line 592 "document_structure.vala"
		result = _tmp4_ == STRUCT_TYPE_FIGURE;
#line 592 "document_structure.vala"
		return result;
#line 3571 "document_structure.c"
	}
#line 594 "document_structure.vala"
	result = FALSE;
#line 594 "document_structure.vala"
	return result;
#line 3577 "document_structure.c"
}


static GtkTreeIter*
document_structure_add_item (DocumentStructure* self,
                             StructType type,
                             const gchar* text,
                             GtkTextIter* start_iter)
{
	GtkTreeIter* result = NULL;
	StructData data = {0};
	StructData _tmp0_ = {0};
	gchar* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextMark* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
#line 597 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 597 "document_structure.vala"
	g_return_val_if_fail (start_iter != NULL, NULL);
#line 599 "document_structure.vala"
	data = _tmp0_;
#line 600 "document_structure.vala"
	data.type = type;
#line 601 "document_structure.vala"
	_tmp1_ = g_strdup (text);
#line 601 "document_structure.vala"
	_g_free0 (data.text);
#line 601 "document_structure.vala"
	data.text = _tmp1_;
#line 602 "document_structure.vala"
	_tmp2_ = *start_iter;
#line 602 "document_structure.vala"
	_tmp3_ = document_structure_create_text_mark_from_iter (self, &_tmp2_);
#line 602 "document_structure.vala"
	_g_object_unref0 (data.start_mark);
#line 602 "document_structure.vala"
	data.start_mark = _tmp3_;
#line 603 "document_structure.vala"
	_g_object_unref0 (data.end_mark);
#line 603 "document_structure.vala"
	data.end_mark = NULL;
#line 605 "document_structure.vala"
	_tmp4_ = data;
#line 605 "document_structure.vala"
	_tmp5_ = document_structure_add_item_data (self, &_tmp4_);
#line 605 "document_structure.vala"
	result = _tmp5_;
#line 605 "document_structure.vala"
	struct_data_destroy (&data);
#line 605 "document_structure.vala"
	return result;
#line 3631 "document_structure.c"
}


static GtkTreeIter*
document_structure_add_item_data (DocumentStructure* self,
                                  StructData* data)
{
	GtkTreeIter* result = NULL;
	StructData _tmp0_;
	const gchar* _tmp1_;
	StructureModel* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
#line 608 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 608 "document_structure.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 610 "document_structure.vala"
	_tmp0_ = *data;
#line 610 "document_structure.vala"
	_tmp1_ = _tmp0_.text;
#line 610 "document_structure.vala"
	if (_tmp1_ == NULL) {
#line 3655 "document_structure.c"
		gchar* _tmp2_;
#line 611 "document_structure.vala"
		_tmp2_ = g_strdup ("");
#line 611 "document_structure.vala"
		_g_free0 ((*data).text);
#line 611 "document_structure.vala"
		(*data).text = _tmp2_;
#line 3663 "document_structure.c"
	}
#line 613 "document_structure.vala"
	_tmp3_ = self->priv->_model;
#line 613 "document_structure.vala"
	_tmp4_ = *data;
#line 613 "document_structure.vala"
	_tmp5_ = structure_model_add_item_at_end (_tmp3_, &_tmp4_);
#line 613 "document_structure.vala"
	result = _tmp5_;
#line 613 "document_structure.vala"
	return result;
#line 3675 "document_structure.c"
}


static GtkTextMark*
document_structure_create_text_mark_from_iter (DocumentStructure* self,
                                               GtkTextIter* iter)
{
	GtkTextMark* result = NULL;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* name = NULL;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextMark* _tmp9_;
	gint _tmp10_;
#line 616 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 616 "document_structure.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 618 "document_structure.vala"
	_tmp0_ = gtk_text_iter_get_buffer (iter);
#line 618 "document_structure.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 618 "document_structure.vala"
	doc = _tmp1_;
#line 619 "document_structure.vala"
	_tmp2_ = self->priv->_nb_marks;
#line 619 "document_structure.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 619 "document_structure.vala"
	_tmp4_ = _tmp3_;
#line 619 "document_structure.vala"
	_tmp5_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp4_, NULL);
#line 619 "document_structure.vala"
	_tmp6_ = _tmp5_;
#line 619 "document_structure.vala"
	_g_free0 (_tmp4_);
#line 619 "document_structure.vala"
	name = _tmp6_;
#line 620 "document_structure.vala"
	_tmp7_ = *iter;
#line 620 "document_structure.vala"
	_tmp8_ = gtk_text_buffer_create_mark (doc, name, &_tmp7_, FALSE);
#line 620 "document_structure.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 620 "document_structure.vala"
	mark = _tmp9_;
#line 621 "document_structure.vala"
	_tmp10_ = self->priv->_nb_marks;
#line 621 "document_structure.vala"
	self->priv->_nb_marks = _tmp10_ + 1;
#line 623 "document_structure.vala"
	result = mark;
#line 623 "document_structure.vala"
	_g_free0 (name);
#line 623 "document_structure.vala"
	_g_object_unref0 (doc);
#line 623 "document_structure.vala"
	return result;
#line 3742 "document_structure.c"
}


static void
document_structure_clear_all_structure_marks (DocumentStructure* self)
{
#line 626 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 3751 "document_structure.c"
	{
		gint i = 0;
#line 628 "document_structure.vala"
		i = 0;
#line 3756 "document_structure.c"
		{
			gboolean _tmp0_ = FALSE;
#line 628 "document_structure.vala"
			_tmp0_ = TRUE;
#line 628 "document_structure.vala"
			while (TRUE) {
#line 3763 "document_structure.c"
				gint _tmp2_;
				gint _tmp3_;
				gchar* mark_name = NULL;
				gint _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GtkTextMark* mark = NULL;
				Document* _tmp9_;
				const gchar* _tmp10_;
				GtkTextMark* _tmp11_;
				GtkTextMark* _tmp12_;
				GtkTextMark* _tmp13_;
#line 628 "document_structure.vala"
				if (!_tmp0_) {
#line 3780 "document_structure.c"
					gint _tmp1_;
#line 628 "document_structure.vala"
					_tmp1_ = i;
#line 628 "document_structure.vala"
					i = _tmp1_ + 1;
#line 3786 "document_structure.c"
				}
#line 628 "document_structure.vala"
				_tmp0_ = FALSE;
#line 628 "document_structure.vala"
				_tmp2_ = i;
#line 628 "document_structure.vala"
				_tmp3_ = self->priv->_nb_marks;
#line 628 "document_structure.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 628 "document_structure.vala"
					break;
#line 3798 "document_structure.c"
				}
#line 630 "document_structure.vala"
				_tmp4_ = i;
#line 630 "document_structure.vala"
				_tmp5_ = g_strdup_printf ("%i", _tmp4_);
#line 630 "document_structure.vala"
				_tmp6_ = _tmp5_;
#line 630 "document_structure.vala"
				_tmp7_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp6_, NULL);
#line 630 "document_structure.vala"
				_tmp8_ = _tmp7_;
#line 630 "document_structure.vala"
				_g_free0 (_tmp6_);
#line 630 "document_structure.vala"
				mark_name = _tmp8_;
#line 631 "document_structure.vala"
				_tmp9_ = self->priv->_doc;
#line 631 "document_structure.vala"
				_tmp10_ = mark_name;
#line 631 "document_structure.vala"
				_tmp11_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) _tmp9_, _tmp10_);
#line 631 "document_structure.vala"
				_tmp12_ = _g_object_ref0 (_tmp11_);
#line 631 "document_structure.vala"
				mark = _tmp12_;
#line 632 "document_structure.vala"
				_tmp13_ = mark;
#line 632 "document_structure.vala"
				if (_tmp13_ != NULL) {
#line 3828 "document_structure.c"
					Document* _tmp14_;
					GtkTextMark* _tmp15_;
#line 633 "document_structure.vala"
					_tmp14_ = self->priv->_doc;
#line 633 "document_structure.vala"
					_tmp15_ = mark;
#line 633 "document_structure.vala"
					gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp14_, _tmp15_);
#line 3837 "document_structure.c"
				}
#line 628 "document_structure.vala"
				_g_object_unref0 (mark);
#line 628 "document_structure.vala"
				_g_free0 (mark_name);
#line 3843 "document_structure.c"
			}
		}
	}
#line 636 "document_structure.vala"
	self->priv->_nb_marks = 0;
#line 3849 "document_structure.c"
}


static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gint result = 0;
	gchar* _tmp0_;
#line 1174 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1175 "glib-2.0.vapi"
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
#line 1175 "glib-2.0.vapi"
	result = (gint) (_tmp0_ - ((gchar*) self));
#line 1175 "glib-2.0.vapi"
	return result;
#line 3867 "document_structure.c"
}


static gchar*
document_structure_truncate (DocumentStructure* self,
                             const gchar* text)
{
	gchar* result = NULL;
	gint index = 0;
	gint _tmp0_;
	gchar* _tmp1_;
#line 640 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 642 "document_structure.vala"
	if (text == NULL) {
#line 643 "document_structure.vala"
		result = NULL;
#line 643 "document_structure.vala"
		return result;
#line 3887 "document_structure.c"
	}
#line 645 "document_structure.vala"
	if (g_utf8_strlen (text, (gssize) -1) <= DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH) {
#line 646 "document_structure.vala"
		result = NULL;
#line 646 "document_structure.vala"
		return result;
#line 3895 "document_structure.c"
	}
#line 648 "document_structure.vala"
	index = string_index_of_nth_char (text, (glong) DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH);
#line 649 "document_structure.vala"
	_tmp0_ = index;
#line 649 "document_structure.vala"
	_tmp1_ = string_substring (text, (glong) 0, (glong) _tmp0_);
#line 649 "document_structure.vala"
	result = _tmp1_;
#line 649 "document_structure.vala"
	return result;
#line 3907 "document_structure.c"
}


static StructType*
document_structure_get_markup_type (DocumentStructure* self,
                                    const gchar* markup_name)
{
	StructType* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label0 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label1 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label2 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label3 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label4 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label5 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label6 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label7 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label8 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label9 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label10 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label11 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label12 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label13 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label14 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label15 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label16 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label17 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label18 = 0;
#line 652 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 652 "document_structure.vala"
	g_return_val_if_fail (markup_name != NULL, NULL);
#line 654 "document_structure.vala"
	_tmp0_ = markup_name;
#line 654 "document_structure.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 654 "document_structure.vala"
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("part")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("part*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3968 "document_structure.c"
			default:
			{
				StructType _tmp3_;
				StructType* _tmp4_;
#line 658 "document_structure.vala"
				_tmp3_ = STRUCT_TYPE_PART;
#line 658 "document_structure.vala"
				_tmp4_ = __struct_type_dup0 (&_tmp3_);
#line 658 "document_structure.vala"
				result = _tmp4_;
#line 658 "document_structure.vala"
				return result;
#line 3981 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("chapter")))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("chapter*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3987 "document_structure.c"
			default:
			{
				StructType _tmp5_;
				StructType* _tmp6_;
#line 662 "document_structure.vala"
				_tmp5_ = STRUCT_TYPE_CHAPTER;
#line 662 "document_structure.vala"
				_tmp6_ = __struct_type_dup0 (&_tmp5_);
#line 662 "document_structure.vala"
				result = _tmp6_;
#line 662 "document_structure.vala"
				return result;
#line 4000 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("section")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("section*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4006 "document_structure.c"
			default:
			{
				StructType _tmp7_;
				StructType* _tmp8_;
#line 666 "document_structure.vala"
				_tmp7_ = STRUCT_TYPE_SECTION;
#line 666 "document_structure.vala"
				_tmp8_ = __struct_type_dup0 (&_tmp7_);
#line 666 "document_structure.vala"
				result = _tmp8_;
#line 666 "document_structure.vala"
				return result;
#line 4019 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("subsection")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("subsection*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4025 "document_structure.c"
			default:
			{
				StructType _tmp9_;
				StructType* _tmp10_;
#line 670 "document_structure.vala"
				_tmp9_ = STRUCT_TYPE_SUBSECTION;
#line 670 "document_structure.vala"
				_tmp10_ = __struct_type_dup0 (&_tmp9_);
#line 670 "document_structure.vala"
				result = _tmp10_;
#line 670 "document_structure.vala"
				return result;
#line 4038 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("subsubsection")))) || (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("subsubsection*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4044 "document_structure.c"
			default:
			{
				StructType _tmp11_;
				StructType* _tmp12_;
#line 674 "document_structure.vala"
				_tmp11_ = STRUCT_TYPE_SUBSUBSECTION;
#line 674 "document_structure.vala"
				_tmp12_ = __struct_type_dup0 (&_tmp11_);
#line 674 "document_structure.vala"
				result = _tmp12_;
#line 674 "document_structure.vala"
				return result;
#line 4057 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("paragraph")))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("paragraph*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4063 "document_structure.c"
			default:
			{
				StructType _tmp13_;
				StructType* _tmp14_;
#line 678 "document_structure.vala"
				_tmp13_ = STRUCT_TYPE_PARAGRAPH;
#line 678 "document_structure.vala"
				_tmp14_ = __struct_type_dup0 (&_tmp13_);
#line 678 "document_structure.vala"
				result = _tmp14_;
#line 678 "document_structure.vala"
				return result;
#line 4076 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("subparagraph")))) || (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("subparagraph*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4082 "document_structure.c"
			default:
			{
				StructType _tmp15_;
				StructType* _tmp16_;
#line 682 "document_structure.vala"
				_tmp15_ = STRUCT_TYPE_SUBPARAGRAPH;
#line 682 "document_structure.vala"
				_tmp16_ = __struct_type_dup0 (&_tmp15_);
#line 682 "document_structure.vala"
				result = _tmp16_;
#line 682 "document_structure.vala"
				return result;
#line 4095 "document_structure.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("label")))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4101 "document_structure.c"
			default:
			{
				StructType _tmp17_;
				StructType* _tmp18_;
#line 685 "document_structure.vala"
				_tmp17_ = STRUCT_TYPE_LABEL;
#line 685 "document_structure.vala"
				_tmp18_ = __struct_type_dup0 (&_tmp17_);
#line 685 "document_structure.vala"
				result = _tmp18_;
#line 685 "document_structure.vala"
				return result;
#line 4114 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("input")))) || (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("include"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4120 "document_structure.c"
			default:
			{
				StructType _tmp19_;
				StructType* _tmp20_;
#line 689 "document_structure.vala"
				_tmp19_ = STRUCT_TYPE_INCLUDE;
#line 689 "document_structure.vala"
				_tmp20_ = __struct_type_dup0 (&_tmp19_);
#line 689 "document_structure.vala"
				result = _tmp20_;
#line 689 "document_structure.vala"
				return result;
#line 4133 "document_structure.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("includegraphics")))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4139 "document_structure.c"
			default:
			{
				StructType _tmp21_;
				StructType* _tmp22_;
#line 692 "document_structure.vala"
				_tmp21_ = STRUCT_TYPE_IMAGE;
#line 692 "document_structure.vala"
				_tmp22_ = __struct_type_dup0 (&_tmp21_);
#line 692 "document_structure.vala"
				result = _tmp22_;
#line 692 "document_structure.vala"
				return result;
#line 4152 "document_structure.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("caption")))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 4158 "document_structure.c"
			default:
			{
				StructType _tmp23_;
				StructType* _tmp24_;
#line 695 "document_structure.vala"
				_tmp23_ = STRUCT_TYPE_CAPTION;
#line 695 "document_structure.vala"
				_tmp24_ = __struct_type_dup0 (&_tmp23_);
#line 695 "document_structure.vala"
				result = _tmp24_;
#line 695 "document_structure.vala"
				return result;
#line 4171 "document_structure.c"
			}
		}
	} else {
#line 654 "document_structure.vala"
		switch (0) {
#line 4177 "document_structure.c"
			default:
			{
#line 698 "document_structure.vala"
				result = NULL;
#line 698 "document_structure.vala"
				return result;
#line 4184 "document_structure.c"
			}
		}
	}
}


static gchar*
document_structure_get_line_contents_at_iter (DocumentStructure* self,
                                              GtkTextIter* iter)
{
	gchar* result = NULL;
	GtkTextIter begin_line = {0};
	GtkTextIter _tmp0_;
	GtkTextIter end_line = {0};
	GtkTextIter _tmp1_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
#line 702 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 702 "document_structure.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 704 "document_structure.vala"
	_tmp0_ = *iter;
#line 704 "document_structure.vala"
	begin_line = _tmp0_;
#line 705 "document_structure.vala"
	gtk_text_iter_set_line_offset (&begin_line, 0);
#line 707 "document_structure.vala"
	_tmp1_ = *iter;
#line 707 "document_structure.vala"
	end_line = _tmp1_;
#line 708 "document_structure.vala"
	if (!gtk_text_iter_ends_line (iter)) {
#line 709 "document_structure.vala"
		gtk_text_iter_forward_to_line_end (&end_line);
#line 4224 "document_structure.c"
	}
#line 711 "document_structure.vala"
	_tmp2_ = gtk_text_iter_get_buffer (iter);
#line 711 "document_structure.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 711 "document_structure.vala"
	buffer = _tmp3_;
#line 712 "document_structure.vala"
	_tmp4_ = begin_line;
#line 712 "document_structure.vala"
	_tmp5_ = end_line;
#line 712 "document_structure.vala"
	_tmp6_ = gtk_text_buffer_get_text (buffer, &_tmp4_, &_tmp5_, FALSE);
#line 712 "document_structure.vala"
	result = _tmp6_;
#line 712 "document_structure.vala"
	_g_object_unref0 (buffer);
#line 712 "document_structure.vala"
	return result;
#line 4244 "document_structure.c"
}


/*************************************************************************/
void
document_structure_do_action (DocumentStructure* self,
                              StructAction action_type,
                              GtkTreeIter* tree_iter,
                              gboolean* refresh_simple_list,
                              GError** error)
{
	gboolean _vala_refresh_simple_list = FALSE;
	Document* _tmp0_;
	gboolean shift_right = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gboolean found = FALSE;
	GtkTreeIter _tmp27_;
	GtkTextIter _tmp28_ = {0};
	GtkTextIter _tmp29_ = {0};
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp45_ = FALSE;
	GError * _inner_error_ = NULL;
#line 718 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 718 "document_structure.vala"
	g_return_if_fail (tree_iter != NULL);
#line 721 "document_structure.vala"
	_vala_refresh_simple_list = FALSE;
#line 723 "document_structure.vala"
	_tmp0_ = self->priv->_doc;
#line 723 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 724 "document_structure.vala"
		if (refresh_simple_list) {
#line 724 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4286 "document_structure.c"
		}
#line 724 "document_structure.vala"
		return;
#line 4290 "document_structure.c"
	}
#line 728 "document_structure.vala"
	if (action_type == STRUCT_ACTION_COMMENT) {
#line 4294 "document_structure.c"
		GtkTreeIter _tmp1_;
		StructureModel* _tmp3_;
		GtkTreeIter _tmp4_;
#line 730 "document_structure.vala"
		_tmp1_ = *tree_iter;
#line 730 "document_structure.vala"
		if (!document_structure_comment_item (self, &_tmp1_)) {
#line 4302 "document_structure.c"
			GError* _tmp2_;
#line 731 "document_structure.vala"
			_tmp2_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
#line 731 "document_structure.vala"
			_inner_error_ = _tmp2_;
#line 731 "document_structure.vala"
			if (_inner_error_->domain == STRUCT_ERROR) {
#line 731 "document_structure.vala"
				g_propagate_error (error, _inner_error_);
#line 731 "document_structure.vala"
				return;
#line 4314 "document_structure.c"
			} else {
#line 731 "document_structure.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 731 "document_structure.vala"
				g_clear_error (&_inner_error_);
#line 731 "document_structure.vala"
				return;
#line 4322 "document_structure.c"
			}
		}
#line 733 "document_structure.vala"
		_tmp3_ = self->priv->_model;
#line 733 "document_structure.vala"
		_tmp4_ = *tree_iter;
#line 733 "document_structure.vala"
		structure_model_delete (_tmp3_, &_tmp4_);
#line 734 "document_structure.vala"
		_vala_refresh_simple_list = TRUE;
#line 735 "document_structure.vala"
		if (refresh_simple_list) {
#line 735 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4337 "document_structure.c"
		}
#line 735 "document_structure.vala"
		return;
#line 4341 "document_structure.c"
	}
#line 740 "document_structure.vala"
	shift_right = action_type == STRUCT_ACTION_SHIFT_RIGHT;
#line 741 "document_structure.vala"
	_tmp6_ = shift_right;
#line 741 "document_structure.vala"
	if (_tmp6_) {
#line 741 "document_structure.vala"
		_tmp5_ = TRUE;
#line 4351 "document_structure.c"
	} else {
#line 741 "document_structure.vala"
		_tmp5_ = action_type == STRUCT_ACTION_SHIFT_LEFT;
#line 4355 "document_structure.c"
	}
#line 741 "document_structure.vala"
	if (_tmp5_) {
#line 4359 "document_structure.c"
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		Document* _tmp12_;
		gboolean doc_modified = FALSE;
		gboolean success = FALSE;
		GtkTreeIter _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		Document* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp22_;
#line 743 "document_structure.vala"
		_tmp8_ = shift_right;
#line 743 "document_structure.vala"
		if (_tmp8_) {
#line 4376 "document_structure.c"
			StructureModel* _tmp9_;
			GtkTreeIter _tmp10_;
#line 743 "document_structure.vala"
			_tmp9_ = self->priv->_model;
#line 743 "document_structure.vala"
			_tmp10_ = *tree_iter;
#line 743 "document_structure.vala"
			_tmp7_ = structure_model_item_contains_subparagraph (_tmp9_, &_tmp10_);
#line 4385 "document_structure.c"
		} else {
#line 743 "document_structure.vala"
			_tmp7_ = FALSE;
#line 4389 "document_structure.c"
		}
#line 743 "document_structure.vala"
		if (_tmp7_) {
#line 4393 "document_structure.c"
			GError* _tmp11_;
#line 744 "document_structure.vala"
			_tmp11_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, _ ("The structure item already contains a sub-paragraph."));
#line 744 "document_structure.vala"
			_inner_error_ = _tmp11_;
#line 744 "document_structure.vala"
			if (_inner_error_->domain == STRUCT_ERROR) {
#line 744 "document_structure.vala"
				g_propagate_error (error, _inner_error_);
#line 744 "document_structure.vala"
				return;
#line 4405 "document_structure.c"
			} else {
#line 744 "document_structure.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 744 "document_structure.vala"
				g_clear_error (&_inner_error_);
#line 744 "document_structure.vala"
				return;
#line 4413 "document_structure.c"
			}
		}
#line 747 "document_structure.vala"
		_tmp12_ = self->priv->_doc;
#line 747 "document_structure.vala"
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp12_);
#line 749 "document_structure.vala"
		_tmp13_ = *tree_iter;
#line 749 "document_structure.vala"
		_tmp14_ = shift_right;
#line 749 "document_structure.vala"
		_tmp16_ = document_structure_shift_item (self, &_tmp13_, _tmp14_, &_tmp15_);
#line 749 "document_structure.vala"
		doc_modified = _tmp15_;
#line 749 "document_structure.vala"
		success = _tmp16_;
#line 750 "document_structure.vala"
		_tmp17_ = self->priv->_doc;
#line 750 "document_structure.vala"
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp17_);
#line 752 "document_structure.vala"
		_tmp18_ = success;
#line 752 "document_structure.vala"
		if (!_tmp18_) {
#line 4438 "document_structure.c"
			gboolean _tmp19_;
			GError* _tmp21_;
#line 754 "document_structure.vala"
			_tmp19_ = doc_modified;
#line 754 "document_structure.vala"
			if (_tmp19_) {
#line 4445 "document_structure.c"
				Document* _tmp20_;
#line 755 "document_structure.vala"
				_tmp20_ = self->priv->_doc;
#line 755 "document_structure.vala"
				gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp20_);
#line 4451 "document_structure.c"
			}
#line 757 "document_structure.vala"
			_tmp21_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
#line 757 "document_structure.vala"
			_inner_error_ = _tmp21_;
#line 757 "document_structure.vala"
			if (_inner_error_->domain == STRUCT_ERROR) {
#line 757 "document_structure.vala"
				g_propagate_error (error, _inner_error_);
#line 757 "document_structure.vala"
				return;
#line 4463 "document_structure.c"
			} else {
#line 757 "document_structure.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 757 "document_structure.vala"
				g_clear_error (&_inner_error_);
#line 757 "document_structure.vala"
				return;
#line 4471 "document_structure.c"
			}
		}
#line 760 "document_structure.vala"
		_tmp22_ = shift_right;
#line 760 "document_structure.vala"
		if (_tmp22_) {
#line 4478 "document_structure.c"
			StructureModel* _tmp23_;
			GtkTreeIter _tmp24_;
#line 761 "document_structure.vala"
			_tmp23_ = self->priv->_model;
#line 761 "document_structure.vala"
			_tmp24_ = *tree_iter;
#line 761 "document_structure.vala"
			structure_model_shift_right (_tmp23_, &_tmp24_);
#line 4487 "document_structure.c"
		} else {
			StructureModel* _tmp25_;
			GtkTreeIter _tmp26_;
#line 763 "document_structure.vala"
			_tmp25_ = self->priv->_model;
#line 763 "document_structure.vala"
			_tmp26_ = *tree_iter;
#line 763 "document_structure.vala"
			structure_model_shift_left (_tmp25_, &_tmp26_);
#line 4497 "document_structure.c"
		}
#line 764 "document_structure.vala"
		if (refresh_simple_list) {
#line 764 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4503 "document_structure.c"
		}
#line 764 "document_structure.vala"
		return;
#line 4507 "document_structure.c"
	}
#line 771 "document_structure.vala"
	_tmp27_ = *tree_iter;
#line 771 "document_structure.vala"
	_tmp30_ = document_structure_get_exact_item_bounds (self, &_tmp27_, &_tmp28_, &_tmp29_);
#line 771 "document_structure.vala"
	start_iter = _tmp28_;
#line 771 "document_structure.vala"
	end_iter = _tmp29_;
#line 771 "document_structure.vala"
	found = _tmp30_;
#line 773 "document_structure.vala"
	_tmp31_ = found;
#line 773 "document_structure.vala"
	if (!_tmp31_) {
#line 4523 "document_structure.c"
		GError* _tmp32_;
#line 774 "document_structure.vala"
		_tmp32_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
#line 774 "document_structure.vala"
		_inner_error_ = _tmp32_;
#line 774 "document_structure.vala"
		if (_inner_error_->domain == STRUCT_ERROR) {
#line 774 "document_structure.vala"
			g_propagate_error (error, _inner_error_);
#line 774 "document_structure.vala"
			return;
#line 4535 "document_structure.c"
		} else {
#line 774 "document_structure.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 774 "document_structure.vala"
			g_clear_error (&_inner_error_);
#line 774 "document_structure.vala"
			return;
#line 4543 "document_structure.c"
		}
	}
#line 776 "document_structure.vala"
	if (gtk_text_iter_get_line (&start_iter) != gtk_text_iter_get_line (&end_iter)) {
#line 778 "document_structure.vala"
		document_structure_backward_indentation (self, &start_iter);
#line 779 "document_structure.vala"
		document_structure_backward_indentation (self, &end_iter);
#line 4552 "document_structure.c"
	}
#line 782 "document_structure.vala"
	if (action_type == STRUCT_ACTION_SELECT) {
#line 4556 "document_structure.c"
		Document* _tmp33_;
		GtkTextIter _tmp34_;
		GtkTextIter _tmp35_;
#line 784 "document_structure.vala"
		_tmp33_ = self->priv->_doc;
#line 784 "document_structure.vala"
		_tmp34_ = start_iter;
#line 784 "document_structure.vala"
		_tmp35_ = end_iter;
#line 784 "document_structure.vala"
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp33_, &_tmp34_, &_tmp35_);
#line 785 "document_structure.vala"
		if (refresh_simple_list) {
#line 785 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4572 "document_structure.c"
		}
#line 785 "document_structure.vala"
		return;
#line 4576 "document_structure.c"
	}
#line 788 "document_structure.vala"
	if (action_type == STRUCT_ACTION_COPY) {
#line 788 "document_structure.vala"
		_tmp36_ = TRUE;
#line 4582 "document_structure.c"
	} else {
#line 788 "document_structure.vala"
		_tmp36_ = action_type == STRUCT_ACTION_CUT;
#line 4586 "document_structure.c"
	}
#line 788 "document_structure.vala"
	if (_tmp36_) {
#line 4590 "document_structure.c"
		gchar* data = NULL;
		Document* _tmp37_;
		GtkTextIter _tmp38_;
		GtkTextIter _tmp39_;
		gchar* _tmp40_;
		GtkClipboard* clipboard = NULL;
		GtkClipboard* _tmp41_;
		GtkClipboard* _tmp42_;
		GtkClipboard* _tmp43_;
		const gchar* _tmp44_;
#line 790 "document_structure.vala"
		_tmp37_ = self->priv->_doc;
#line 790 "document_structure.vala"
		_tmp38_ = start_iter;
#line 790 "document_structure.vala"
		_tmp39_ = end_iter;
#line 790 "document_structure.vala"
		_tmp40_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp37_, &_tmp38_, &_tmp39_, FALSE);
#line 790 "document_structure.vala"
		data = _tmp40_;
#line 791 "document_structure.vala"
		_tmp41_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
#line 791 "document_structure.vala"
		_tmp42_ = _g_object_ref0 (_tmp41_);
#line 791 "document_structure.vala"
		clipboard = _tmp42_;
#line 792 "document_structure.vala"
		_tmp43_ = clipboard;
#line 792 "document_structure.vala"
		_tmp44_ = data;
#line 792 "document_structure.vala"
		gtk_clipboard_set_text (_tmp43_, _tmp44_, -1);
#line 788 "document_structure.vala"
		_g_object_unref0 (clipboard);
#line 788 "document_structure.vala"
		_g_free0 (data);
#line 4627 "document_structure.c"
	}
#line 795 "document_structure.vala"
	if (action_type == STRUCT_ACTION_DELETE) {
#line 795 "document_structure.vala"
		_tmp45_ = TRUE;
#line 4633 "document_structure.c"
	} else {
#line 795 "document_structure.vala"
		_tmp45_ = action_type == STRUCT_ACTION_CUT;
#line 4637 "document_structure.c"
	}
#line 795 "document_structure.vala"
	if (_tmp45_) {
#line 4641 "document_structure.c"
		Document* _tmp46_;
		Document* _tmp47_;
		Document* _tmp48_;
		StructureModel* _tmp49_;
		GtkTreeIter _tmp50_;
#line 797 "document_structure.vala"
		_tmp46_ = self->priv->_doc;
#line 797 "document_structure.vala"
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp46_);
#line 798 "document_structure.vala"
		_tmp47_ = self->priv->_doc;
#line 798 "document_structure.vala"
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp47_, &start_iter, &end_iter);
#line 799 "document_structure.vala"
		_tmp48_ = self->priv->_doc;
#line 799 "document_structure.vala"
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp48_);
#line 801 "document_structure.vala"
		_tmp49_ = self->priv->_model;
#line 801 "document_structure.vala"
		_tmp50_ = *tree_iter;
#line 801 "document_structure.vala"
		structure_model_delete (_tmp49_, &_tmp50_);
#line 802 "document_structure.vala"
		_vala_refresh_simple_list = TRUE;
#line 4667 "document_structure.c"
	}
#line 718 "document_structure.vala"
	if (refresh_simple_list) {
#line 718 "document_structure.vala"
		*refresh_simple_list = _vala_refresh_simple_list;
#line 4673 "document_structure.c"
	}
}


static gboolean
document_structure_comment_item (DocumentStructure* self,
                                 GtkTreeIter* tree_iter)
{
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean end_iter_set = FALSE;
	Document* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextMark* _tmp6_;
	StructType _tmp10_;
	GtkTreeIter* next_section_iter = NULL;
	gboolean go_one_line_backward = FALSE;
	GtkTreeIter* _tmp24_;
	gboolean _tmp34_;
	Document* _tmp35_;
	GtkTextIter _tmp36_;
	GtkTextIter _tmp37_;
	gboolean _tmp38_;
	GError * _inner_error_ = NULL;
#line 807 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 807 "document_structure.vala"
	g_return_val_if_fail (tree_iter != NULL, FALSE);
#line 810 "document_structure.vala"
	start_mark = NULL;
#line 811 "document_structure.vala"
	end_mark = NULL;
#line 813 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 813 "document_structure.vala"
	_tmp1_ = *tree_iter;
#line 813 "document_structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, -1, -1);
#line 820 "document_structure.vala"
	end_iter = _tmp2_;
#line 821 "document_structure.vala"
	end_iter_set = FALSE;
#line 823 "document_structure.vala"
	_tmp3_ = self->priv->_doc;
#line 823 "document_structure.vala"
	_tmp4_ = start_mark;
#line 823 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
#line 823 "document_structure.vala"
	start_iter = _tmp5_;
#line 825 "document_structure.vala"
	_tmp6_ = end_mark;
#line 825 "document_structure.vala"
	if (_tmp6_ != NULL) {
#line 4736 "document_structure.c"
		Document* _tmp7_;
		GtkTextMark* _tmp8_;
		GtkTextIter _tmp9_ = {0};
#line 827 "document_structure.vala"
		_tmp7_ = self->priv->_doc;
#line 827 "document_structure.vala"
		_tmp8_ = end_mark;
#line 827 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
#line 827 "document_structure.vala"
		end_iter = _tmp9_;
#line 828 "document_structure.vala"
		end_iter_set = TRUE;
#line 4750 "document_structure.c"
	}
#line 832 "document_structure.vala"
	_tmp10_ = type;
#line 832 "document_structure.vala"
	if (!structure_is_section (_tmp10_)) {
#line 4756 "document_structure.c"
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		gboolean _tmp14_;
#line 834 "document_structure.vala"
		_tmp11_ = self->priv->_doc;
#line 834 "document_structure.vala"
		_tmp12_ = start_iter;
#line 834 "document_structure.vala"
		_tmp13_ = end_iter;
#line 834 "document_structure.vala"
		_tmp14_ = end_iter_set;
#line 834 "document_structure.vala"
		document_comment_between (_tmp11_, &_tmp12_, &_tmp13_, _tmp14_);
#line 835 "document_structure.vala"
		result = TRUE;
#line 835 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 835 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 835 "document_structure.vala"
		return result;
#line 4779 "document_structure.c"
	}
#line 841 "document_structure.vala"
	next_section_iter = NULL;
#line 4783 "document_structure.c"
	{
		GtkTreeIter* _tmp15_ = NULL;
		StructureModel* _tmp16_;
		GtkTreeIter _tmp17_;
		GtkTreeIter* _tmp18_;
		GtkTreeIter* _tmp20_;
#line 844 "document_structure.vala"
		_tmp16_ = self->priv->_model;
#line 844 "document_structure.vala"
		_tmp17_ = *tree_iter;
#line 844 "document_structure.vala"
		_tmp18_ = structure_model_get_next_sibling_or_parent (_tmp16_, &_tmp17_, &_inner_error_);
#line 844 "document_structure.vala"
		_tmp15_ = _tmp18_;
#line 844 "document_structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4800 "document_structure.c"
			gboolean _tmp19_ = FALSE;
#line 844 "document_structure.vala"
			if (_inner_error_->domain == STRUCT_ERROR) {
#line 4804 "document_structure.c"
				goto __catch6_struct_error;
			}
#line 844 "document_structure.vala"
			_g_free0 (next_section_iter);
#line 844 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 844 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 844 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 844 "document_structure.vala"
			g_clear_error (&_inner_error_);
#line 844 "document_structure.vala"
			return _tmp19_;
#line 4819 "document_structure.c"
		}
#line 844 "document_structure.vala"
		_tmp20_ = _tmp15_;
#line 844 "document_structure.vala"
		_tmp15_ = NULL;
#line 844 "document_structure.vala"
		_g_free0 (next_section_iter);
#line 844 "document_structure.vala"
		next_section_iter = _tmp20_;
#line 842 "document_structure.vala"
		_g_free0 (_tmp15_);
#line 4831 "document_structure.c"
	}
	goto __finally6;
	__catch6_struct_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
#line 842 "document_structure.vala"
		e = _inner_error_;
#line 842 "document_structure.vala"
		_inner_error_ = NULL;
#line 848 "document_structure.vala"
		_tmp21_ = e;
#line 848 "document_structure.vala"
		_tmp22_ = _tmp21_->message;
#line 848 "document_structure.vala"
		g_warning ("document_structure.vala:848: Structure: get next sibling or parent: %s", _tmp22_);
#line 849 "document_structure.vala"
		result = FALSE;
#line 849 "document_structure.vala"
		_g_error_free0 (e);
#line 849 "document_structure.vala"
		_g_free0 (next_section_iter);
#line 849 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 849 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 849 "document_structure.vala"
		return result;
#line 4861 "document_structure.c"
	}
	__finally6:
#line 842 "document_structure.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4866 "document_structure.c"
		gboolean _tmp23_ = FALSE;
#line 842 "document_structure.vala"
		_g_free0 (next_section_iter);
#line 842 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 842 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 842 "document_structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 842 "document_structure.vala"
		g_clear_error (&_inner_error_);
#line 842 "document_structure.vala"
		return _tmp23_;
#line 4880 "document_structure.c"
	}
#line 852 "document_structure.vala"
	go_one_line_backward = TRUE;
#line 855 "document_structure.vala"
	_tmp24_ = next_section_iter;
#line 855 "document_structure.vala"
	if (_tmp24_ == NULL) {
#line 4888 "document_structure.c"
		gboolean end_of_file = FALSE;
		gboolean _tmp25_ = FALSE;
		GtkTextIter _tmp26_ = {0};
		gboolean _tmp27_;
#line 858 "document_structure.vala"
		document_structure_get_end_document_iter (self, &_tmp25_, &_tmp26_);
#line 858 "document_structure.vala"
		end_of_file = _tmp25_;
#line 858 "document_structure.vala"
		end_iter = _tmp26_;
#line 859 "document_structure.vala"
		end_iter_set = TRUE;
#line 860 "document_structure.vala"
		_tmp27_ = end_of_file;
#line 860 "document_structure.vala"
		go_one_line_backward = !_tmp27_;
#line 4905 "document_structure.c"
	} else {
		StructureModel* _tmp28_;
		GtkTreeIter* _tmp29_;
		GtkTreeIter _tmp30_;
		Document* _tmp31_;
		GtkTextMark* _tmp32_;
		GtkTextIter _tmp33_ = {0};
#line 865 "document_structure.vala"
		_tmp28_ = self->priv->_model;
#line 865 "document_structure.vala"
		_tmp29_ = next_section_iter;
#line 865 "document_structure.vala"
		_tmp30_ = *_tmp29_;
#line 865 "document_structure.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp28_, &_tmp30_, STRUCT_COLUMN_START_MARK, &end_mark, -1, -1);
#line 869 "document_structure.vala"
		_tmp31_ = self->priv->_doc;
#line 869 "document_structure.vala"
		_tmp32_ = end_mark;
#line 869 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp31_, &_tmp33_, _tmp32_);
#line 869 "document_structure.vala"
		end_iter = _tmp33_;
#line 870 "document_structure.vala"
		end_iter_set = TRUE;
#line 4931 "document_structure.c"
	}
#line 873 "document_structure.vala"
	_tmp34_ = go_one_line_backward;
#line 873 "document_structure.vala"
	if (_tmp34_) {
#line 875 "document_structure.vala"
		if (!gtk_text_iter_backward_line (&end_iter)) {
#line 876 "document_structure.vala"
			end_iter_set = FALSE;
#line 4941 "document_structure.c"
		}
	}
#line 879 "document_structure.vala"
	_tmp35_ = self->priv->_doc;
#line 879 "document_structure.vala"
	_tmp36_ = start_iter;
#line 879 "document_structure.vala"
	_tmp37_ = end_iter;
#line 879 "document_structure.vala"
	_tmp38_ = end_iter_set;
#line 879 "document_structure.vala"
	document_comment_between (_tmp35_, &_tmp36_, &_tmp37_, _tmp38_);
#line 880 "document_structure.vala"
	result = TRUE;
#line 880 "document_structure.vala"
	_g_free0 (next_section_iter);
#line 880 "document_structure.vala"
	_g_object_unref0 (end_mark);
#line 880 "document_structure.vala"
	_g_object_unref0 (start_mark);
#line 880 "document_structure.vala"
	return result;
#line 4964 "document_structure.c"
}


static gboolean
document_structure_get_exact_item_bounds (DocumentStructure* self,
                                          GtkTreeIter* tree_iter,
                                          GtkTextIter* start_iter,
                                          GtkTextIter* end_iter)
{
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gboolean result = FALSE;
	StructType item_type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	gchar* item_contents = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	Document* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gboolean found = FALSE;
	StructType _tmp5_;
	const gchar* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gboolean _tmp9_;
	gboolean _tmp10_;
	StructType _tmp11_;
	GtkTextMark* _tmp34_;
	GtkTextIter end_env_iter = {0};
	Document* _tmp35_;
	GtkTextMark* _tmp36_;
	GtkTextIter _tmp37_ = {0};
	StructType _tmp38_;
	const gchar* _tmp39_;
	GtkTextIter _tmp40_;
	GtkTextIter _tmp41_ = {0};
	gboolean _tmp42_;
	GError * _inner_error_ = NULL;
#line 884 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 884 "document_structure.vala"
	g_return_val_if_fail (tree_iter != NULL, FALSE);
#line 889 "document_structure.vala"
	start_mark = NULL;
#line 890 "document_structure.vala"
	end_mark = NULL;
#line 891 "document_structure.vala"
	item_contents = NULL;
#line 893 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 893 "document_structure.vala"
	_tmp1_ = *tree_iter;
#line 893 "document_structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
#line 901 "document_structure.vala"
	_tmp2_ = self->priv->_doc;
#line 901 "document_structure.vala"
	_tmp3_ = start_mark;
#line 901 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp2_, &_tmp4_, _tmp3_);
#line 901 "document_structure.vala"
	_vala_start_iter = _tmp4_;
#line 905 "document_structure.vala"
	_tmp5_ = item_type;
#line 905 "document_structure.vala"
	_tmp6_ = item_contents;
#line 905 "document_structure.vala"
	_tmp7_ = _vala_start_iter;
#line 905 "document_structure.vala"
	_tmp9_ = document_structure_get_low_level_item_bounds (self, _tmp5_, _tmp6_, &_tmp7_, TRUE, &_tmp8_);
#line 905 "document_structure.vala"
	_vala_end_iter = _tmp8_;
#line 905 "document_structure.vala"
	found = _tmp9_;
#line 908 "document_structure.vala"
	_tmp10_ = found;
#line 908 "document_structure.vala"
	if (!_tmp10_) {
#line 909 "document_structure.vala"
		result = FALSE;
#line 909 "document_structure.vala"
		_g_free0 (item_contents);
#line 909 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 909 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 909 "document_structure.vala"
		if (start_iter) {
#line 909 "document_structure.vala"
			*start_iter = _vala_start_iter;
#line 5057 "document_structure.c"
		}
#line 909 "document_structure.vala"
		if (end_iter) {
#line 909 "document_structure.vala"
			*end_iter = _vala_end_iter;
#line 5063 "document_structure.c"
		}
#line 909 "document_structure.vala"
		return result;
#line 5067 "document_structure.c"
	}
#line 914 "document_structure.vala"
	_tmp11_ = item_type;
#line 914 "document_structure.vala"
	if (structure_is_section (_tmp11_)) {
#line 5073 "document_structure.c"
		GtkTreeIter* next_section_iter = NULL;
		GtkTreeIter* _tmp21_;
		StructureModel* _tmp23_;
		GtkTreeIter* _tmp24_;
		GtkTreeIter _tmp25_;
		Document* _tmp26_;
		GtkTextMark* _tmp27_;
		GtkTextIter _tmp28_ = {0};
		StructType _tmp29_;
		const gchar* _tmp30_;
		GtkTextIter _tmp31_;
		gboolean _tmp32_;
#line 916 "document_structure.vala"
		next_section_iter = NULL;
#line 5088 "document_structure.c"
		{
			GtkTreeIter* _tmp12_ = NULL;
			StructureModel* _tmp13_;
			GtkTreeIter _tmp14_;
			GtkTreeIter* _tmp15_;
			GtkTreeIter* _tmp17_;
#line 919 "document_structure.vala"
			_tmp13_ = self->priv->_model;
#line 919 "document_structure.vala"
			_tmp14_ = *tree_iter;
#line 919 "document_structure.vala"
			_tmp15_ = structure_model_get_next_sibling_or_parent (_tmp13_, &_tmp14_, &_inner_error_);
#line 919 "document_structure.vala"
			_tmp12_ = _tmp15_;
#line 919 "document_structure.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5105 "document_structure.c"
				gboolean _tmp16_ = FALSE;
#line 919 "document_structure.vala"
				if (_inner_error_->domain == STRUCT_ERROR) {
#line 5109 "document_structure.c"
					goto __catch7_struct_error;
				}
#line 919 "document_structure.vala"
				_g_free0 (next_section_iter);
#line 919 "document_structure.vala"
				_g_free0 (item_contents);
#line 919 "document_structure.vala"
				_g_object_unref0 (end_mark);
#line 919 "document_structure.vala"
				_g_object_unref0 (start_mark);
#line 919 "document_structure.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 919 "document_structure.vala"
				g_clear_error (&_inner_error_);
#line 919 "document_structure.vala"
				return _tmp16_;
#line 5126 "document_structure.c"
			}
#line 919 "document_structure.vala"
			_tmp17_ = _tmp12_;
#line 919 "document_structure.vala"
			_tmp12_ = NULL;
#line 919 "document_structure.vala"
			_g_free0 (next_section_iter);
#line 919 "document_structure.vala"
			next_section_iter = _tmp17_;
#line 917 "document_structure.vala"
			_g_free0 (_tmp12_);
#line 5138 "document_structure.c"
		}
		goto __finally7;
		__catch7_struct_error:
		{
			GError* e = NULL;
			GError* _tmp18_;
			const gchar* _tmp19_;
#line 917 "document_structure.vala"
			e = _inner_error_;
#line 917 "document_structure.vala"
			_inner_error_ = NULL;
#line 923 "document_structure.vala"
			_tmp18_ = e;
#line 923 "document_structure.vala"
			_tmp19_ = _tmp18_->message;
#line 923 "document_structure.vala"
			g_warning ("document_structure.vala:923: Structure: get next sibling or parent: %s", _tmp19_);
#line 924 "document_structure.vala"
			result = FALSE;
#line 924 "document_structure.vala"
			_g_error_free0 (e);
#line 924 "document_structure.vala"
			_g_free0 (next_section_iter);
#line 924 "document_structure.vala"
			_g_free0 (item_contents);
#line 924 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 924 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 924 "document_structure.vala"
			if (start_iter) {
#line 924 "document_structure.vala"
				*start_iter = _vala_start_iter;
#line 5172 "document_structure.c"
			}
#line 924 "document_structure.vala"
			if (end_iter) {
#line 924 "document_structure.vala"
				*end_iter = _vala_end_iter;
#line 5178 "document_structure.c"
			}
#line 924 "document_structure.vala"
			return result;
#line 5182 "document_structure.c"
		}
		__finally7:
#line 917 "document_structure.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5187 "document_structure.c"
			gboolean _tmp20_ = FALSE;
#line 917 "document_structure.vala"
			_g_free0 (next_section_iter);
#line 917 "document_structure.vala"
			_g_free0 (item_contents);
#line 917 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 917 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 917 "document_structure.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 917 "document_structure.vala"
			g_clear_error (&_inner_error_);
#line 917 "document_structure.vala"
			return _tmp20_;
#line 5203 "document_structure.c"
		}
#line 928 "document_structure.vala"
		_tmp21_ = next_section_iter;
#line 928 "document_structure.vala"
		if (_tmp21_ == NULL) {
#line 5209 "document_structure.c"
			GtkTextIter _tmp22_ = {0};
#line 930 "document_structure.vala"
			document_structure_get_end_document_iter (self, NULL, &_tmp22_);
#line 930 "document_structure.vala"
			_vala_end_iter = _tmp22_;
#line 931 "document_structure.vala"
			result = TRUE;
#line 931 "document_structure.vala"
			_g_free0 (next_section_iter);
#line 931 "document_structure.vala"
			_g_free0 (item_contents);
#line 931 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 931 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 931 "document_structure.vala"
			if (start_iter) {
#line 931 "document_structure.vala"
				*start_iter = _vala_start_iter;
#line 5229 "document_structure.c"
			}
#line 931 "document_structure.vala"
			if (end_iter) {
#line 931 "document_structure.vala"
				*end_iter = _vala_end_iter;
#line 5235 "document_structure.c"
			}
#line 931 "document_structure.vala"
			return result;
#line 5239 "document_structure.c"
		}
#line 934 "document_structure.vala"
		_tmp23_ = self->priv->_model;
#line 934 "document_structure.vala"
		_tmp24_ = next_section_iter;
#line 934 "document_structure.vala"
		_tmp25_ = *_tmp24_;
#line 934 "document_structure.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp23_, &_tmp25_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
#line 940 "document_structure.vala"
		_tmp26_ = self->priv->_doc;
#line 940 "document_structure.vala"
		_tmp27_ = start_mark;
#line 940 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp26_, &_tmp28_, _tmp27_);
#line 940 "document_structure.vala"
		_vala_end_iter = _tmp28_;
#line 942 "document_structure.vala"
		_tmp29_ = item_type;
#line 942 "document_structure.vala"
		_tmp30_ = item_contents;
#line 942 "document_structure.vala"
		_tmp31_ = _vala_end_iter;
#line 942 "document_structure.vala"
		_tmp32_ = document_structure_get_low_level_item_bounds (self, _tmp29_, _tmp30_, &_tmp31_, TRUE, NULL);
#line 942 "document_structure.vala"
		result = _tmp32_;
#line 942 "document_structure.vala"
		_g_free0 (next_section_iter);
#line 942 "document_structure.vala"
		_g_free0 (item_contents);
#line 942 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 942 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 942 "document_structure.vala"
		if (start_iter) {
#line 942 "document_structure.vala"
			*start_iter = _vala_start_iter;
#line 5279 "document_structure.c"
		}
#line 942 "document_structure.vala"
		if (end_iter) {
#line 942 "document_structure.vala"
			*end_iter = _vala_end_iter;
#line 5285 "document_structure.c"
		}
#line 942 "document_structure.vala"
		return result;
#line 5289 "document_structure.c"
	} else {
		StructType _tmp33_;
#line 947 "document_structure.vala"
		_tmp33_ = item_type;
#line 947 "document_structure.vala"
		if (structure_is_common_type (_tmp33_)) {
#line 948 "document_structure.vala"
			result = TRUE;
#line 948 "document_structure.vala"
			_g_free0 (item_contents);
#line 948 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 948 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 948 "document_structure.vala"
			if (start_iter) {
#line 948 "document_structure.vala"
				*start_iter = _vala_start_iter;
#line 5308 "document_structure.c"
			}
#line 948 "document_structure.vala"
			if (end_iter) {
#line 948 "document_structure.vala"
				*end_iter = _vala_end_iter;
#line 5314 "document_structure.c"
			}
#line 948 "document_structure.vala"
			return result;
#line 5318 "document_structure.c"
		}
	}
#line 951 "document_structure.vala"
	_tmp34_ = end_mark;
#line 951 "document_structure.vala"
	if (_tmp34_ == NULL) {
#line 952 "document_structure.vala"
		result = FALSE;
#line 952 "document_structure.vala"
		_g_free0 (item_contents);
#line 952 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 952 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 952 "document_structure.vala"
		if (start_iter) {
#line 952 "document_structure.vala"
			*start_iter = _vala_start_iter;
#line 5337 "document_structure.c"
		}
#line 952 "document_structure.vala"
		if (end_iter) {
#line 952 "document_structure.vala"
			*end_iter = _vala_end_iter;
#line 5343 "document_structure.c"
		}
#line 952 "document_structure.vala"
		return result;
#line 5347 "document_structure.c"
	}
#line 955 "document_structure.vala"
	_tmp35_ = self->priv->_doc;
#line 955 "document_structure.vala"
	_tmp36_ = end_mark;
#line 955 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp35_, &_tmp37_, _tmp36_);
#line 955 "document_structure.vala"
	end_env_iter = _tmp37_;
#line 957 "document_structure.vala"
	_tmp38_ = item_type;
#line 957 "document_structure.vala"
	_tmp39_ = item_contents;
#line 957 "document_structure.vala"
	_tmp40_ = end_env_iter;
#line 957 "document_structure.vala"
	_tmp42_ = document_structure_get_low_level_item_bounds (self, _tmp38_, _tmp39_, &_tmp40_, FALSE, &_tmp41_);
#line 957 "document_structure.vala"
	_vala_end_iter = _tmp41_;
#line 957 "document_structure.vala"
	result = _tmp42_;
#line 957 "document_structure.vala"
	_g_free0 (item_contents);
#line 957 "document_structure.vala"
	_g_object_unref0 (end_mark);
#line 957 "document_structure.vala"
	_g_object_unref0 (start_mark);
#line 957 "document_structure.vala"
	if (start_iter) {
#line 957 "document_structure.vala"
		*start_iter = _vala_start_iter;
#line 5379 "document_structure.c"
	}
#line 957 "document_structure.vala"
	if (end_iter) {
#line 957 "document_structure.vala"
		*end_iter = _vala_end_iter;
#line 5385 "document_structure.c"
	}
#line 957 "document_structure.vala"
	return result;
#line 5389 "document_structure.c"
}


static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
#line 979 "document_structure.vala"
	if (s1 == s2) {
#line 979 "document_structure.vala"
		return TRUE;
#line 5401 "document_structure.c"
	}
#line 979 "document_structure.vala"
	if (s1 == NULL) {
#line 979 "document_structure.vala"
		return FALSE;
#line 5407 "document_structure.c"
	}
#line 979 "document_structure.vala"
	if (s2 == NULL) {
#line 979 "document_structure.vala"
		return FALSE;
#line 5413 "document_structure.c"
	}
#line 979 "document_structure.vala"
	return (*s1) == (*s2);
#line 5417 "document_structure.c"
}


static gboolean
document_structure_get_low_level_item_bounds (DocumentStructure* self,
                                              StructType item_type,
                                              const gchar* item_contents,
                                              GtkTextIter* start_match_iter,
                                              gboolean is_start,
                                              GtkTextIter* end_match_iter)
{
	GtkTextIter _vala_end_match_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp1_;
	gchar* _tmp2_;
	gint start_index = 0;
	StructType* low_level_type = NULL;
	gchar* contents = NULL;
	gint* start_match_index = NULL;
	gint* end_match_index = NULL;
	gboolean found = FALSE;
	const gchar* _tmp3_;
	gint _tmp4_;
	StructType* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint* _tmp7_ = NULL;
	gint* _tmp8_ = NULL;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	const gchar* _tmp14_;
	StructType* _tmp16_;
	const gchar* _tmp17_;
#line 961 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 961 "document_structure.vala"
	g_return_val_if_fail (item_contents != NULL, FALSE);
#line 961 "document_structure.vala"
	g_return_val_if_fail (start_match_iter != NULL, FALSE);
#line 964 "document_structure.vala"
	_vala_end_match_iter = _tmp0_;
#line 966 "document_structure.vala"
	_tmp1_ = *start_match_iter;
#line 966 "document_structure.vala"
	_tmp2_ = document_structure_get_line_contents_at_iter (self, &_tmp1_);
#line 966 "document_structure.vala"
	line = _tmp2_;
#line 969 "document_structure.vala"
	start_index = gtk_text_iter_get_line_index (start_match_iter);
#line 975 "document_structure.vala"
	_tmp3_ = line;
#line 975 "document_structure.vala"
	_tmp4_ = start_index;
#line 975 "document_structure.vala"
	_tmp9_ = document_structure_search_low_level_item (self, _tmp3_, _tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
#line 975 "document_structure.vala"
	_g_free0 (low_level_type);
#line 975 "document_structure.vala"
	low_level_type = _tmp5_;
#line 975 "document_structure.vala"
	_g_free0 (contents);
#line 975 "document_structure.vala"
	contents = _tmp6_;
#line 975 "document_structure.vala"
	_g_free0 (start_match_index);
#line 975 "document_structure.vala"
	start_match_index = _tmp7_;
#line 975 "document_structure.vala"
	_g_free0 (end_match_index);
#line 975 "document_structure.vala"
	end_match_index = _tmp8_;
#line 975 "document_structure.vala"
	found = _tmp9_;
#line 979 "document_structure.vala"
	_tmp11_ = found;
#line 979 "document_structure.vala"
	if (!_tmp11_) {
#line 979 "document_structure.vala"
		_tmp10_ = TRUE;
#line 5499 "document_structure.c"
	} else {
		gint _tmp12_;
		gint* _tmp13_;
#line 979 "document_structure.vala"
		_tmp12_ = start_index;
#line 979 "document_structure.vala"
		_tmp13_ = start_match_index;
#line 979 "document_structure.vala"
		_tmp10_ = _int_equal (&_tmp12_, _tmp13_) != TRUE;
#line 5509 "document_structure.c"
	}
#line 979 "document_structure.vala"
	if (_tmp10_) {
#line 980 "document_structure.vala"
		result = FALSE;
#line 980 "document_structure.vala"
		_g_free0 (end_match_index);
#line 980 "document_structure.vala"
		_g_free0 (start_match_index);
#line 980 "document_structure.vala"
		_g_free0 (contents);
#line 980 "document_structure.vala"
		_g_free0 (low_level_type);
#line 980 "document_structure.vala"
		_g_free0 (line);
#line 980 "document_structure.vala"
		if (end_match_iter) {
#line 980 "document_structure.vala"
			*end_match_iter = _vala_end_match_iter;
#line 5529 "document_structure.c"
		}
#line 980 "document_structure.vala"
		return result;
#line 5533 "document_structure.c"
	}
#line 982 "document_structure.vala"
	_tmp14_ = contents;
#line 982 "document_structure.vala"
	if (_tmp14_ == NULL) {
#line 5539 "document_structure.c"
		gchar* _tmp15_;
#line 983 "document_structure.vala"
		_tmp15_ = g_strdup ("");
#line 983 "document_structure.vala"
		_g_free0 (contents);
#line 983 "document_structure.vala"
		contents = _tmp15_;
#line 5547 "document_structure.c"
	}
#line 986 "document_structure.vala"
	_tmp16_ = low_level_type;
#line 986 "document_structure.vala"
	_tmp17_ = contents;
#line 986 "document_structure.vala"
	if (document_structure_same_items (self, item_type, item_contents, *_tmp16_, _tmp17_, is_start)) {
#line 5555 "document_structure.c"
		GtkTextIter _tmp18_;
		gint* _tmp19_;
#line 988 "document_structure.vala"
		_tmp18_ = *start_match_iter;
#line 988 "document_structure.vala"
		_vala_end_match_iter = _tmp18_;
#line 989 "document_structure.vala"
		_tmp19_ = end_match_index;
#line 989 "document_structure.vala"
		gtk_text_iter_set_line_index (&_vala_end_match_iter, *_tmp19_);
#line 990 "document_structure.vala"
		result = TRUE;
#line 990 "document_structure.vala"
		_g_free0 (end_match_index);
#line 990 "document_structure.vala"
		_g_free0 (start_match_index);
#line 990 "document_structure.vala"
		_g_free0 (contents);
#line 990 "document_structure.vala"
		_g_free0 (low_level_type);
#line 990 "document_structure.vala"
		_g_free0 (line);
#line 990 "document_structure.vala"
		if (end_match_iter) {
#line 990 "document_structure.vala"
			*end_match_iter = _vala_end_match_iter;
#line 5582 "document_structure.c"
		}
#line 990 "document_structure.vala"
		return result;
#line 5586 "document_structure.c"
	}
#line 993 "document_structure.vala"
	result = FALSE;
#line 993 "document_structure.vala"
	_g_free0 (end_match_index);
#line 993 "document_structure.vala"
	_g_free0 (start_match_index);
#line 993 "document_structure.vala"
	_g_free0 (contents);
#line 993 "document_structure.vala"
	_g_free0 (low_level_type);
#line 993 "document_structure.vala"
	_g_free0 (line);
#line 993 "document_structure.vala"
	if (end_match_iter) {
#line 993 "document_structure.vala"
		*end_match_iter = _vala_end_match_iter;
#line 5604 "document_structure.c"
	}
#line 993 "document_structure.vala"
	return result;
#line 5608 "document_structure.c"
}


static gboolean
document_structure_same_items (DocumentStructure* self,
                               StructType item_type,
                               const gchar* item_contents,
                               StructType item_found_type,
                               const gchar* item_found_contents,
                               gboolean start)
{
	gboolean result = FALSE;
#line 999 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 999 "document_structure.vala"
	g_return_val_if_fail (item_contents != NULL, FALSE);
#line 999 "document_structure.vala"
	g_return_val_if_fail (item_found_contents != NULL, FALSE);
#line 1002 "document_structure.vala"
	if (structure_is_common_type (item_found_type)) {
#line 5629 "document_structure.c"
		gboolean same_type = FALSE;
		gboolean same_contents = FALSE;
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
#line 1004 "document_structure.vala"
		same_type = item_type == item_found_type;
#line 1005 "document_structure.vala"
		same_contents = g_strcmp0 (item_contents, item_found_contents) == 0;
#line 1006 "document_structure.vala"
		_tmp1_ = same_type;
#line 1006 "document_structure.vala"
		if (_tmp1_) {
#line 5642 "document_structure.c"
			gboolean _tmp2_;
#line 1006 "document_structure.vala"
			_tmp2_ = same_contents;
#line 1006 "document_structure.vala"
			_tmp0_ = _tmp2_;
#line 5648 "document_structure.c"
		} else {
#line 1006 "document_structure.vala"
			_tmp0_ = FALSE;
#line 5652 "document_structure.c"
		}
#line 1006 "document_structure.vala"
		result = _tmp0_;
#line 1006 "document_structure.vala"
		return result;
#line 5658 "document_structure.c"
	}
#line 1009 "document_structure.vala"
	if (item_type == STRUCT_TYPE_FIGURE) {
#line 1011 "document_structure.vala"
		if (start) {
#line 1012 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_BEGIN_FIGURE;
#line 1012 "document_structure.vala"
			return result;
#line 5668 "document_structure.c"
		} else {
#line 1014 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_END_FIGURE;
#line 1014 "document_structure.vala"
			return result;
#line 5674 "document_structure.c"
		}
	}
#line 1017 "document_structure.vala"
	if (item_type == STRUCT_TYPE_TABLE) {
#line 1019 "document_structure.vala"
		if (start) {
#line 1020 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_BEGIN_TABLE;
#line 1020 "document_structure.vala"
			return result;
#line 5685 "document_structure.c"
		} else {
#line 1022 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_END_TABLE;
#line 1022 "document_structure.vala"
			return result;
#line 5691 "document_structure.c"
		}
	}
#line 1025 "document_structure.vala"
	result = FALSE;
#line 1025 "document_structure.vala"
	return result;
#line 5698 "document_structure.c"
}


static void
document_structure_get_end_document_iter (DocumentStructure* self,
                                          gboolean* end_of_file,
                                          GtkTextIter* result)
{
	gboolean _vala_end_of_file = FALSE;
	GtkTextMark* _tmp0_;
	GtkTextIter eof_iter = {0};
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
#line 1029 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 1031 "document_structure.vala"
	_tmp0_ = self->priv->_end_document_mark;
#line 1031 "document_structure.vala"
	if (_tmp0_ != NULL) {
#line 5718 "document_structure.c"
		GtkTextIter end_document_iter = {0};
		Document* _tmp1_;
		GtkTextMark* _tmp2_;
		GtkTextIter _tmp3_ = {0};
#line 1033 "document_structure.vala"
		_vala_end_of_file = FALSE;
#line 1035 "document_structure.vala"
		_tmp1_ = self->priv->_doc;
#line 1035 "document_structure.vala"
		_tmp2_ = self->priv->_end_document_mark;
#line 1035 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp1_, &_tmp3_, _tmp2_);
#line 1035 "document_structure.vala"
		end_document_iter = _tmp3_;
#line 1036 "document_structure.vala"
		*result = end_document_iter;
#line 1036 "document_structure.vala"
		if (end_of_file) {
#line 1036 "document_structure.vala"
			*end_of_file = _vala_end_of_file;
#line 5739 "document_structure.c"
		}
#line 1036 "document_structure.vala"
		return;
#line 5743 "document_structure.c"
	}
#line 1039 "document_structure.vala"
	_vala_end_of_file = TRUE;
#line 1041 "document_structure.vala"
	_tmp4_ = self->priv->_doc;
#line 1041 "document_structure.vala"
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) _tmp4_, &_tmp5_);
#line 1041 "document_structure.vala"
	eof_iter = _tmp5_;
#line 1042 "document_structure.vala"
	*result = eof_iter;
#line 1042 "document_structure.vala"
	if (end_of_file) {
#line 1042 "document_structure.vala"
		*end_of_file = _vala_end_of_file;
#line 5759 "document_structure.c"
	}
#line 1042 "document_structure.vala"
	return;
#line 5763 "document_structure.c"
}


static void
document_structure_backward_indentation (DocumentStructure* self,
                                         GtkTextIter* iter)
{
	gint line_num = 0;
	GtkTextIter begin_line_iter = {0};
	Document* _tmp0_;
	gint _tmp1_;
	GtkTextIter _tmp2_ = {0};
	gchar* text_between = NULL;
	Document* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
#line 1047 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 1047 "document_structure.vala"
	g_return_if_fail (iter != NULL);
#line 1049 "document_structure.vala"
	if (gtk_text_iter_starts_line (iter)) {
#line 1050 "document_structure.vala"
		return;
#line 5793 "document_structure.c"
	}
#line 1052 "document_structure.vala"
	line_num = gtk_text_iter_get_line (iter);
#line 1054 "document_structure.vala"
	_tmp0_ = self->priv->_doc;
#line 1054 "document_structure.vala"
	_tmp1_ = line_num;
#line 1054 "document_structure.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp0_, &_tmp2_, _tmp1_);
#line 1054 "document_structure.vala"
	begin_line_iter = _tmp2_;
#line 1056 "document_structure.vala"
	_tmp3_ = self->priv->_doc;
#line 1056 "document_structure.vala"
	_tmp4_ = begin_line_iter;
#line 1056 "document_structure.vala"
	_tmp5_ = *iter;
#line 1056 "document_structure.vala"
	_tmp6_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp3_, &_tmp4_, &_tmp5_, FALSE);
#line 1056 "document_structure.vala"
	text_between = _tmp6_;
#line 1057 "document_structure.vala"
	_tmp7_ = text_between;
#line 1057 "document_structure.vala"
	_tmp8_ = string_strip (_tmp7_);
#line 1057 "document_structure.vala"
	_tmp9_ = _tmp8_;
#line 1057 "document_structure.vala"
	_tmp10_ = g_strcmp0 (_tmp9_, "") == 0;
#line 1057 "document_structure.vala"
	_g_free0 (_tmp9_);
#line 1057 "document_structure.vala"
	if (_tmp10_) {
#line 5827 "document_structure.c"
		GtkTextIter _tmp11_;
#line 1058 "document_structure.vala"
		_tmp11_ = begin_line_iter;
#line 1058 "document_structure.vala"
		*iter = _tmp11_;
#line 5833 "document_structure.c"
	}
#line 1047 "document_structure.vala"
	_g_free0 (text_between);
#line 5837 "document_structure.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "glib-2.0.vapi"
	return result;
#line 5855 "document_structure.c"
}


static gboolean
document_structure_shift_item (DocumentStructure* self,
                               GtkTreeIter* tree_iter,
                               gboolean shift_right,
                               gboolean* doc_modified)
{
	gboolean _vala_doc_modified = FALSE;
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp4_;
	GtkTextIter text_iter = {0};
	Document* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp8_;
	gchar* _tmp9_;
	gint backslash_index = 0;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint after_backslash_index = 0;
	gint _tmp12_;
	gchar* markup_name = NULL;
	const gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	StructType* markup_type = NULL;
	const gchar* _tmp17_;
	StructType* _tmp18_;
	StructType* _tmp19_;
	StructType markup_type_hack = 0;
	StructType* _tmp20_;
	StructType _tmp21_;
	StructType _tmp22_;
	gboolean with_star = FALSE;
	const gchar* _tmp23_;
	StructType new_type = 0;
	gchar* new_markup_name = NULL;
	StructType _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_;
	GtkTextIter begin_markup_name_iter = {0};
	GtkTextIter _tmp32_;
	gint _tmp33_;
	GtkTextIter end_markup_name_iter = {0};
	GtkTextIter _tmp34_;
	gint _tmp35_;
	const gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	Document* _tmp39_;
	Document* _tmp40_;
	const gchar* _tmp41_;
	gint nb_children = 0;
	StructureModel* _tmp42_;
	GtkTreeIter _tmp43_;
#line 1061 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1061 "document_structure.vala"
	g_return_val_if_fail (tree_iter != NULL, FALSE);
#line 1064 "document_structure.vala"
	_vala_doc_modified = FALSE;
#line 1069 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 1069 "document_structure.vala"
	_tmp1_ = *tree_iter;
#line 1069 "document_structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &mark, -1);
#line 1073 "document_structure.vala"
	if (shift_right) {
#line 5934 "document_structure.c"
		StructType _tmp2_;
#line 1074 "document_structure.vala"
		_tmp2_ = type;
#line 1074 "document_structure.vala"
		g_return_val_if_fail (_tmp2_ != STRUCT_TYPE_SUBPARAGRAPH, FALSE);
#line 5940 "document_structure.c"
	} else {
		StructType _tmp3_;
#line 1076 "document_structure.vala"
		_tmp3_ = type;
#line 1076 "document_structure.vala"
		g_return_val_if_fail (_tmp3_ != STRUCT_TYPE_PART, FALSE);
#line 5947 "document_structure.c"
	}
#line 1078 "document_structure.vala"
	_tmp4_ = type;
#line 1078 "document_structure.vala"
	if (!structure_is_section (_tmp4_)) {
#line 1079 "document_structure.vala"
		result = TRUE;
#line 1079 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1079 "document_structure.vala"
		if (doc_modified) {
#line 1079 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 5961 "document_structure.c"
		}
#line 1079 "document_structure.vala"
		return result;
#line 5965 "document_structure.c"
	}
#line 1083 "document_structure.vala"
	_tmp5_ = self->priv->_doc;
#line 1083 "document_structure.vala"
	_tmp6_ = mark;
#line 1083 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp5_, &_tmp7_, _tmp6_);
#line 1083 "document_structure.vala"
	text_iter = _tmp7_;
#line 1085 "document_structure.vala"
	_tmp8_ = text_iter;
#line 1085 "document_structure.vala"
	_tmp9_ = document_structure_get_line_contents_at_iter (self, &_tmp8_);
#line 1085 "document_structure.vala"
	line = _tmp9_;
#line 1087 "document_structure.vala"
	backslash_index = gtk_text_iter_get_line_index (&text_iter);
#line 1088 "document_structure.vala"
	_tmp10_ = line;
#line 1088 "document_structure.vala"
	_tmp11_ = backslash_index;
#line 1088 "document_structure.vala"
	if (string_get (_tmp10_, (glong) _tmp11_) != '\\') {
#line 1089 "document_structure.vala"
		result = FALSE;
#line 1089 "document_structure.vala"
		_g_free0 (line);
#line 1089 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1089 "document_structure.vala"
		if (doc_modified) {
#line 1089 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 5999 "document_structure.c"
		}
#line 1089 "document_structure.vala"
		return result;
#line 6003 "document_structure.c"
	}
#line 1091 "document_structure.vala"
	_tmp12_ = backslash_index;
#line 1091 "document_structure.vala"
	after_backslash_index = _tmp12_ + 1;
#line 1092 "document_structure.vala"
	_tmp13_ = line;
#line 1092 "document_structure.vala"
	_tmp14_ = after_backslash_index;
#line 1092 "document_structure.vala"
	_tmp15_ = document_structure_get_markup_name (self, _tmp13_, _tmp14_, NULL);
#line 1092 "document_structure.vala"
	markup_name = _tmp15_;
#line 1093 "document_structure.vala"
	_tmp16_ = markup_name;
#line 1093 "document_structure.vala"
	if (_tmp16_ == NULL) {
#line 1094 "document_structure.vala"
		result = FALSE;
#line 1094 "document_structure.vala"
		_g_free0 (markup_name);
#line 1094 "document_structure.vala"
		_g_free0 (line);
#line 1094 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1094 "document_structure.vala"
		if (doc_modified) {
#line 1094 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 6033 "document_structure.c"
		}
#line 1094 "document_structure.vala"
		return result;
#line 6037 "document_structure.c"
	}
#line 1096 "document_structure.vala"
	_tmp17_ = markup_name;
#line 1096 "document_structure.vala"
	_tmp18_ = document_structure_get_markup_type (self, _tmp17_);
#line 1096 "document_structure.vala"
	markup_type = _tmp18_;
#line 1097 "document_structure.vala"
	_tmp19_ = markup_type;
#line 1097 "document_structure.vala"
	if (_tmp19_ == NULL) {
#line 1098 "document_structure.vala"
		result = FALSE;
#line 1098 "document_structure.vala"
		_g_free0 (markup_type);
#line 1098 "document_structure.vala"
		_g_free0 (markup_name);
#line 1098 "document_structure.vala"
		_g_free0 (line);
#line 1098 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1098 "document_structure.vala"
		if (doc_modified) {
#line 1098 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 6063 "document_structure.c"
		}
#line 1098 "document_structure.vala"
		return result;
#line 6067 "document_structure.c"
	}
#line 1102 "document_structure.vala"
	_tmp20_ = markup_type;
#line 1102 "document_structure.vala"
	markup_type_hack = *_tmp20_;
#line 1103 "document_structure.vala"
	_tmp21_ = type;
#line 1103 "document_structure.vala"
	_tmp22_ = markup_type_hack;
#line 1103 "document_structure.vala"
	if (((gint) _tmp21_) != ((gint) _tmp22_)) {
#line 1104 "document_structure.vala"
		result = FALSE;
#line 1104 "document_structure.vala"
		_g_free0 (markup_type);
#line 1104 "document_structure.vala"
		_g_free0 (markup_name);
#line 1104 "document_structure.vala"
		_g_free0 (line);
#line 1104 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1104 "document_structure.vala"
		if (doc_modified) {
#line 1104 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 6093 "document_structure.c"
		}
#line 1104 "document_structure.vala"
		return result;
#line 6097 "document_structure.c"
	}
#line 1107 "document_structure.vala"
	_tmp23_ = markup_name;
#line 1107 "document_structure.vala"
	with_star = g_str_has_suffix (_tmp23_, "*");
#line 1110 "document_structure.vala"
	if (shift_right) {
#line 6105 "document_structure.c"
		StructType _tmp24_;
#line 1111 "document_structure.vala"
		_tmp24_ = type;
#line 1111 "document_structure.vala"
		new_type = _tmp24_ + 1;
#line 6111 "document_structure.c"
	} else {
		StructType _tmp25_;
#line 1113 "document_structure.vala"
		_tmp25_ = type;
#line 1113 "document_structure.vala"
		new_type = _tmp25_ - 1;
#line 6118 "document_structure.c"
	}
#line 1115 "document_structure.vala"
	_tmp26_ = new_type;
#line 1115 "document_structure.vala"
	_tmp27_ = document_structure_get_section_name_from_type (self, _tmp26_);
#line 1115 "document_structure.vala"
	new_markup_name = _tmp27_;
#line 1116 "document_structure.vala"
	_tmp28_ = new_markup_name;
#line 1116 "document_structure.vala"
	g_return_val_if_fail (_tmp28_ != NULL, FALSE);
#line 1118 "document_structure.vala"
	_tmp29_ = with_star;
#line 1118 "document_structure.vala"
	if (_tmp29_) {
#line 6134 "document_structure.c"
		const gchar* _tmp30_;
		gchar* _tmp31_;
#line 1119 "document_structure.vala"
		_tmp30_ = new_markup_name;
#line 1119 "document_structure.vala"
		_tmp31_ = g_strconcat (_tmp30_, "*", NULL);
#line 1119 "document_structure.vala"
		_g_free0 (new_markup_name);
#line 1119 "document_structure.vala"
		new_markup_name = _tmp31_;
#line 6145 "document_structure.c"
	}
#line 1122 "document_structure.vala"
	_tmp32_ = text_iter;
#line 1122 "document_structure.vala"
	begin_markup_name_iter = _tmp32_;
#line 1123 "document_structure.vala"
	_tmp33_ = after_backslash_index;
#line 1123 "document_structure.vala"
	gtk_text_iter_set_line_index (&begin_markup_name_iter, _tmp33_);
#line 1125 "document_structure.vala"
	_tmp34_ = text_iter;
#line 1125 "document_structure.vala"
	end_markup_name_iter = _tmp34_;
#line 1126 "document_structure.vala"
	_tmp35_ = after_backslash_index;
#line 1126 "document_structure.vala"
	_tmp36_ = markup_name;
#line 1126 "document_structure.vala"
	_tmp37_ = strlen (_tmp36_);
#line 1126 "document_structure.vala"
	_tmp38_ = _tmp37_;
#line 1126 "document_structure.vala"
	gtk_text_iter_set_line_index (&end_markup_name_iter, _tmp35_ + _tmp38_);
#line 1128 "document_structure.vala"
	_tmp39_ = self->priv->_doc;
#line 1128 "document_structure.vala"
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp39_, &begin_markup_name_iter, &end_markup_name_iter);
#line 1129 "document_structure.vala"
	_tmp40_ = self->priv->_doc;
#line 1129 "document_structure.vala"
	_tmp41_ = new_markup_name;
#line 1129 "document_structure.vala"
	document_insert (_tmp40_, &begin_markup_name_iter, _tmp41_, -1);
#line 1130 "document_structure.vala"
	_vala_doc_modified = TRUE;
#line 1133 "document_structure.vala"
	_tmp42_ = self->priv->_model;
#line 1133 "document_structure.vala"
	_tmp43_ = *tree_iter;
#line 1133 "document_structure.vala"
	nb_children = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp42_, &_tmp43_);
#line 6187 "document_structure.c"
	{
		gint child_num = 0;
#line 1134 "document_structure.vala"
		child_num = 0;
#line 6192 "document_structure.c"
		{
			gboolean _tmp44_ = FALSE;
#line 1134 "document_structure.vala"
			_tmp44_ = TRUE;
#line 1134 "document_structure.vala"
			while (TRUE) {
#line 6199 "document_structure.c"
				gint _tmp46_;
				gint _tmp47_;
				GtkTreeIter child_iter = {0};
				gboolean child_iter_set = FALSE;
				StructureModel* _tmp48_;
				GtkTreeIter _tmp49_;
				gint _tmp50_;
				GtkTreeIter _tmp51_ = {0};
				gboolean _tmp52_;
				gboolean _tmp53_;
				GtkTreeIter _tmp54_;
				gboolean _tmp55_;
#line 1134 "document_structure.vala"
				if (!_tmp44_) {
#line 6214 "document_structure.c"
					gint _tmp45_;
#line 1134 "document_structure.vala"
					_tmp45_ = child_num;
#line 1134 "document_structure.vala"
					child_num = _tmp45_ + 1;
#line 6220 "document_structure.c"
				}
#line 1134 "document_structure.vala"
				_tmp44_ = FALSE;
#line 1134 "document_structure.vala"
				_tmp46_ = child_num;
#line 1134 "document_structure.vala"
				_tmp47_ = nb_children;
#line 1134 "document_structure.vala"
				if (!(_tmp46_ < _tmp47_)) {
#line 1134 "document_structure.vala"
					break;
#line 6232 "document_structure.c"
				}
#line 1137 "document_structure.vala"
				_tmp48_ = self->priv->_model;
#line 1137 "document_structure.vala"
				_tmp49_ = *tree_iter;
#line 1137 "document_structure.vala"
				_tmp50_ = child_num;
#line 1137 "document_structure.vala"
				_tmp52_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp48_, &_tmp51_, &_tmp49_, _tmp50_);
#line 1137 "document_structure.vala"
				child_iter = _tmp51_;
#line 1137 "document_structure.vala"
				child_iter_set = _tmp52_;
#line 1139 "document_structure.vala"
				_tmp53_ = child_iter_set;
#line 1139 "document_structure.vala"
				g_return_val_if_fail (_tmp53_, FALSE);
#line 1141 "document_structure.vala"
				_tmp54_ = child_iter;
#line 1141 "document_structure.vala"
				_tmp55_ = document_structure_shift_item (self, &_tmp54_, shift_right, NULL);
#line 1141 "document_structure.vala"
				if (!_tmp55_) {
#line 1142 "document_structure.vala"
					result = FALSE;
#line 1142 "document_structure.vala"
					_g_free0 (new_markup_name);
#line 1142 "document_structure.vala"
					_g_free0 (markup_type);
#line 1142 "document_structure.vala"
					_g_free0 (markup_name);
#line 1142 "document_structure.vala"
					_g_free0 (line);
#line 1142 "document_structure.vala"
					_g_object_unref0 (mark);
#line 1142 "document_structure.vala"
					if (doc_modified) {
#line 1142 "document_structure.vala"
						*doc_modified = _vala_doc_modified;
#line 6272 "document_structure.c"
					}
#line 1142 "document_structure.vala"
					return result;
#line 6276 "document_structure.c"
				}
			}
		}
	}
#line 1145 "document_structure.vala"
	result = TRUE;
#line 1145 "document_structure.vala"
	_g_free0 (new_markup_name);
#line 1145 "document_structure.vala"
	_g_free0 (markup_type);
#line 1145 "document_structure.vala"
	_g_free0 (markup_name);
#line 1145 "document_structure.vala"
	_g_free0 (line);
#line 1145 "document_structure.vala"
	_g_object_unref0 (mark);
#line 1145 "document_structure.vala"
	if (doc_modified) {
#line 1145 "document_structure.vala"
		*doc_modified = _vala_doc_modified;
#line 6297 "document_structure.c"
	}
#line 1145 "document_structure.vala"
	return result;
#line 6301 "document_structure.c"
}


static gchar*
document_structure_get_section_name_from_type (DocumentStructure* self,
                                               StructType type)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
#line 1148 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1150 "document_structure.vala"
	_tmp0_ = document_structure__section_names;
#line 1150 "document_structure.vala"
	_tmp0__length1 = document_structure__section_names_length1;
#line 1150 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 6324 "document_structure.c"
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 1152 "document_structure.vala"
		_tmp1_ = g_new0 (gchar*, 7 + 1);
#line 1152 "document_structure.vala"
		document_structure__section_names = (_vala_array_free (document_structure__section_names, document_structure__section_names_length1, (GDestroyNotify) g_free), NULL);
#line 1152 "document_structure.vala"
		document_structure__section_names = _tmp1_;
#line 1152 "document_structure.vala"
		document_structure__section_names_length1 = 7;
#line 1152 "document_structure.vala"
		_document_structure__section_names_size_ = document_structure__section_names_length1;
#line 1153 "document_structure.vala"
		_tmp2_ = document_structure__section_names;
#line 1153 "document_structure.vala"
		_tmp2__length1 = document_structure__section_names_length1;
#line 1153 "document_structure.vala"
		_tmp3_ = g_strdup ("part");
#line 1153 "document_structure.vala"
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
#line 1153 "document_structure.vala"
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
#line 1153 "document_structure.vala"
		_tmp4_ = _tmp2_[STRUCT_TYPE_PART];
#line 1154 "document_structure.vala"
		_tmp5_ = document_structure__section_names;
#line 1154 "document_structure.vala"
		_tmp5__length1 = document_structure__section_names_length1;
#line 1154 "document_structure.vala"
		_tmp6_ = g_strdup ("chapter");
#line 1154 "document_structure.vala"
		_g_free0 (_tmp5_[STRUCT_TYPE_CHAPTER]);
#line 1154 "document_structure.vala"
		_tmp5_[STRUCT_TYPE_CHAPTER] = _tmp6_;
#line 1154 "document_structure.vala"
		_tmp7_ = _tmp5_[STRUCT_TYPE_CHAPTER];
#line 1155 "document_structure.vala"
		_tmp8_ = document_structure__section_names;
#line 1155 "document_structure.vala"
		_tmp8__length1 = document_structure__section_names_length1;
#line 1155 "document_structure.vala"
		_tmp9_ = g_strdup ("section");
#line 1155 "document_structure.vala"
		_g_free0 (_tmp8_[STRUCT_TYPE_SECTION]);
#line 1155 "document_structure.vala"
		_tmp8_[STRUCT_TYPE_SECTION] = _tmp9_;
#line 1155 "document_structure.vala"
		_tmp10_ = _tmp8_[STRUCT_TYPE_SECTION];
#line 1156 "document_structure.vala"
		_tmp11_ = document_structure__section_names;
#line 1156 "document_structure.vala"
		_tmp11__length1 = document_structure__section_names_length1;
#line 1156 "document_structure.vala"
		_tmp12_ = g_strdup ("subsection");
#line 1156 "document_structure.vala"
		_g_free0 (_tmp11_[STRUCT_TYPE_SUBSECTION]);
#line 1156 "document_structure.vala"
		_tmp11_[STRUCT_TYPE_SUBSECTION] = _tmp12_;
#line 1156 "document_structure.vala"
		_tmp13_ = _tmp11_[STRUCT_TYPE_SUBSECTION];
#line 1157 "document_structure.vala"
		_tmp14_ = document_structure__section_names;
#line 1157 "document_structure.vala"
		_tmp14__length1 = document_structure__section_names_length1;
#line 1157 "document_structure.vala"
		_tmp15_ = g_strdup ("subsubsection");
#line 1157 "document_structure.vala"
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBSUBSECTION]);
#line 1157 "document_structure.vala"
		_tmp14_[STRUCT_TYPE_SUBSUBSECTION] = _tmp15_;
#line 1157 "document_structure.vala"
		_tmp16_ = _tmp14_[STRUCT_TYPE_SUBSUBSECTION];
#line 1158 "document_structure.vala"
		_tmp17_ = document_structure__section_names;
#line 1158 "document_structure.vala"
		_tmp17__length1 = document_structure__section_names_length1;
#line 1158 "document_structure.vala"
		_tmp18_ = g_strdup ("paragraph");
#line 1158 "document_structure.vala"
		_g_free0 (_tmp17_[STRUCT_TYPE_PARAGRAPH]);
#line 1158 "document_structure.vala"
		_tmp17_[STRUCT_TYPE_PARAGRAPH] = _tmp18_;
#line 1158 "document_structure.vala"
		_tmp19_ = _tmp17_[STRUCT_TYPE_PARAGRAPH];
#line 1159 "document_structure.vala"
		_tmp20_ = document_structure__section_names;
#line 1159 "document_structure.vala"
		_tmp20__length1 = document_structure__section_names_length1;
#line 1159 "document_structure.vala"
		_tmp21_ = g_strdup ("subparagraph");
#line 1159 "document_structure.vala"
		_g_free0 (_tmp20_[STRUCT_TYPE_SUBPARAGRAPH]);
#line 1159 "document_structure.vala"
		_tmp20_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp21_;
#line 1159 "document_structure.vala"
		_tmp22_ = _tmp20_[STRUCT_TYPE_SUBPARAGRAPH];
#line 6448 "document_structure.c"
	}
#line 1162 "document_structure.vala"
	g_return_val_if_fail (structure_is_section (type), NULL);
#line 1164 "document_structure.vala"
	_tmp23_ = document_structure__section_names;
#line 1164 "document_structure.vala"
	_tmp23__length1 = document_structure__section_names_length1;
#line 1164 "document_structure.vala"
	_tmp24_ = _tmp23_[type];
#line 1164 "document_structure.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 1164 "document_structure.vala"
	result = _tmp25_;
#line 1164 "document_structure.vala"
	return result;
#line 6464 "document_structure.c"
}


gboolean
document_structure_get_parsing_done (DocumentStructure* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 64 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 64 "document_structure.vala"
	_tmp0_ = self->priv->_parsing_done;
#line 64 "document_structure.vala"
	result = _tmp0_;
#line 64 "document_structure.vala"
	return result;
#line 6481 "document_structure.c"
}


static void
document_structure_set_parsing_done (DocumentStructure* self,
                                     gboolean value)
{
#line 64 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 64 "document_structure.vala"
	if (document_structure_get_parsing_done (self) != value) {
#line 64 "document_structure.vala"
		self->priv->_parsing_done = value;
#line 64 "document_structure.vala"
		g_object_notify_by_pspec ((GObject *) self, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY]);
#line 6497 "document_structure.c"
	}
}


static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
#line 29 "document_structure.vala"
	return g_boxed_copy (gtk_tree_path_get_type (), self);
#line 6507 "document_structure.c"
}


static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
#line 29 "document_structure.vala"
	return self ? _vala_GtkTreePath_copy (self) : NULL;
#line 6516 "document_structure.c"
}


static void
document_structure_env_data_copy (const DocumentStructureEnvData* self,
                                  DocumentStructureEnvData* dest)
{
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	StructType _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 29 "document_structure.vala"
	_tmp0_ = (*self).path;
#line 29 "document_structure.vala"
	_tmp1_ = __vala_GtkTreePath_copy0 (_tmp0_);
#line 29 "document_structure.vala"
	__vala_GtkTreePath_free0 ((*dest).path);
#line 29 "document_structure.vala"
	(*dest).path = _tmp1_;
#line 29 "document_structure.vala"
	_tmp2_ = (*self).type;
#line 29 "document_structure.vala"
	(*dest).type = _tmp2_;
#line 29 "document_structure.vala"
	_tmp3_ = (*self).first_caption;
#line 29 "document_structure.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 29 "document_structure.vala"
	_g_free0 ((*dest).first_caption);
#line 29 "document_structure.vala"
	(*dest).first_caption = _tmp4_;
#line 6549 "document_structure.c"
}


static void
document_structure_env_data_destroy (DocumentStructureEnvData* self)
{
#line 31 "document_structure.vala"
	__vala_GtkTreePath_free0 ((*self).path);
#line 33 "document_structure.vala"
	_g_free0 ((*self).first_caption);
#line 6560 "document_structure.c"
}


static DocumentStructureEnvData*
document_structure_env_data_dup (const DocumentStructureEnvData* self)
{
	DocumentStructureEnvData* dup;
#line 29 "document_structure.vala"
	dup = g_new0 (DocumentStructureEnvData, 1);
#line 29 "document_structure.vala"
	document_structure_env_data_copy (self, dup);
#line 29 "document_structure.vala"
	return dup;
#line 6574 "document_structure.c"
}


static void
document_structure_env_data_free (DocumentStructureEnvData* self)
{
#line 29 "document_structure.vala"
	document_structure_env_data_destroy (self);
#line 29 "document_structure.vala"
	g_free (self);
#line 6585 "document_structure.c"
}


static GType
document_structure_env_data_get_type (void)
{
	static volatile gsize document_structure_env_data_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_env_data_type_id__volatile)) {
		GType document_structure_env_data_type_id;
		document_structure_env_data_type_id = g_boxed_type_register_static ("DocumentStructureEnvData", (GBoxedCopyFunc) document_structure_env_data_dup, (GBoxedFreeFunc) document_structure_env_data_free);
		g_once_init_leave (&document_structure_env_data_type_id__volatile, document_structure_env_data_type_id);
	}
	return document_structure_env_data_type_id__volatile;
}


static void
document_structure_class_init (DocumentStructureClass * klass)
{
#line 26 "document_structure.vala"
	document_structure_parent_class = g_type_class_peek_parent (klass);
#line 26 "document_structure.vala"
	g_type_class_adjust_private_offset (klass, &DocumentStructure_private_offset);
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_structure_get_property;
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_structure_set_property;
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (klass)->finalize = document_structure_finalize;
#line 26 "document_structure.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY] = g_param_spec_boolean ("parsing-done", "parsing-done", "parsing-done", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 6617 "document_structure.c"
}


static void
document_structure_instance_init (DocumentStructure * self)
{
#line 26 "document_structure.vala"
	self->priv = document_structure_get_instance_private (self);
#line 36 "document_structure.vala"
	self->priv->_doc = NULL;
#line 37 "document_structure.vala"
	self->priv->_nb_marks = 0;
#line 39 "document_structure.vala"
	self->priv->_end_document_mark = NULL;
#line 41 "document_structure.vala"
	self->priv->_model = NULL;
#line 47 "document_structure.vala"
	self->priv->_in_verbatim_env = FALSE;
#line 49 "document_structure.vala"
	self->priv->_last_env_data = NULL;
#line 56 "document_structure.vala"
	self->priv->_start_parsing_line = 0;
#line 58 "document_structure.vala"
	self->priv->_timer = NULL;
#line 62 "document_structure.vala"
	self->priv->_idle_id = (guint) 0;
#line 64 "document_structure.vala"
	self->priv->_parsing_done = FALSE;
#line 6646 "document_structure.c"
}


static void
document_structure_finalize (GObject * obj)
{
	DocumentStructure * self;
	guint _tmp0_;
#line 26 "document_structure.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
#line 94 "document_structure.vala"
	_tmp0_ = self->priv->_idle_id;
#line 94 "document_structure.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 6661 "document_structure.c"
		guint _tmp1_;
#line 96 "document_structure.vala"
		_tmp1_ = self->priv->_idle_id;
#line 96 "document_structure.vala"
		g_source_remove (_tmp1_);
#line 97 "document_structure.vala"
		self->priv->_idle_id = (guint) 0;
#line 6669 "document_structure.c"
	}
#line 39 "document_structure.vala"
	_g_object_unref0 (self->priv->_end_document_mark);
#line 41 "document_structure.vala"
	_g_object_unref0 (self->priv->_model);
#line 49 "document_structure.vala"
	_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 58 "document_structure.vala"
	_g_timer_destroy0 (self->priv->_timer);
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (document_structure_parent_class)->finalize (obj);
#line 6681 "document_structure.c"
}


GType
document_structure_get_type (void)
{
	static volatile gsize document_structure_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentStructure), 0, (GInstanceInitFunc) document_structure_instance_init, NULL };
		GType document_structure_type_id;
		document_structure_type_id = g_type_register_static (G_TYPE_OBJECT, "DocumentStructure", &g_define_type_info, 0);
		DocumentStructure_private_offset = g_type_add_instance_private (document_structure_type_id, sizeof (DocumentStructurePrivate));
		g_once_init_leave (&document_structure_type_id__volatile, document_structure_type_id);
	}
	return document_structure_type_id__volatile;
}


static void
_vala_document_structure_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
#line 26 "document_structure.vala"
	switch (property_id) {
#line 26 "document_structure.vala"
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
#line 26 "document_structure.vala"
		g_value_set_boolean (value, document_structure_get_parsing_done (self));
#line 26 "document_structure.vala"
		break;
#line 6716 "document_structure.c"
		default:
#line 26 "document_structure.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "document_structure.vala"
		break;
#line 6722 "document_structure.c"
	}
}


static void
_vala_document_structure_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
#line 26 "document_structure.vala"
	switch (property_id) {
#line 26 "document_structure.vala"
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
#line 26 "document_structure.vala"
		document_structure_set_parsing_done (self, g_value_get_boolean (value));
#line 26 "document_structure.vala"
		break;
#line 6743 "document_structure.c"
		default:
#line 26 "document_structure.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "document_structure.vala"
		break;
#line 6749 "document_structure.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 6761 "document_structure.c"
		int i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 6769 "document_structure.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 6785 "document_structure.c"
}



