/* app_settings.c generated by valac 0.40.0.227-717ea, the Vala compiler
 * generated from app_settings.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>


#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _AppSettingsPrivate AppSettingsPrivate;
enum  {
	APP_SETTINGS_0_PROPERTY,
	APP_SETTINGS_SYSTEM_FONT_PROPERTY,
	APP_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* app_settings_properties[APP_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

struct _AppSettings {
	GSettings parent_instance;
	AppSettingsPrivate * priv;
};

struct _AppSettingsClass {
	GSettingsClass parent_class;
};

struct _AppSettingsPrivate {
	GSettings* editor;
	gchar* _system_font;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};


static gint AppSettings_private_offset;
static gpointer app_settings_parent_class = NULL;
static AppSettings* app_settings_instance;
static AppSettings* app_settings_instance = NULL;

GType app_settings_get_type (void) G_GNUC_CONST;
static AppSettings* app_settings_new (void);
static AppSettings* app_settings_construct (GType object_type);
static void app_settings_initialize (AppSettings* self);
AppSettings* app_settings_get_default (void);
static void app_settings_set_system_font (AppSettings* self,
                                   const gchar* value);
static void __lambda4_ (AppSettings* self,
                 GSettings* setting,
                 const gchar* key);
static void app_settings_set_font (AppSettings* self,
                            const gchar* font);
const gchar* app_settings_get_system_font (AppSettings* self);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda120_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda120__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda121_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda121__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda122_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
GType document_view_get_type (void) G_GNUC_CONST;
GType glatex_app_get_type (void) G_GNUC_CONST;
GlatexApp* glatex_app_get_instance (void);
GeeList* glatex_app_get_views (GlatexApp* self);
static void ___lambda122__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda123_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda123__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda124_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda124__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda125_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
static void ___lambda125__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda126_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
GType document_get_type (void) G_GNUC_CONST;
GeeList* glatex_app_get_documents (GlatexApp* self);
static void ___lambda126__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda127_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
GType document_tab_get_type (void) G_GNUC_CONST;
void document_tab_set_auto_save (DocumentTab* self,
                                 gboolean value);
static void ___lambda127__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void __lambda128_ (AppSettings* self,
                   GSettings* setting,
                   const gchar* key);
void document_tab_set_auto_save_interval (DocumentTab* self,
                                          guint value);
static void ___lambda128__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
void document_view_set_font_from_string (DocumentView* self,
                                         const gchar* font);
static void app_settings_finalize (GObject * obj);
static void _vala_app_settings_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_app_settings_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);


static inline gpointer
app_settings_get_instance_private (AppSettings* self)
{
	return G_STRUCT_MEMBER_P (self, AppSettings_private_offset);
}


static AppSettings*
app_settings_construct (GType object_type)
{
	AppSettings * self = NULL;
#line 31 "app_settings.vala"
	self = (AppSettings*) g_object_new (object_type, "schema-id", "org.gnome.gnome-latex", NULL);
#line 32 "app_settings.vala"
	app_settings_initialize (self);
#line 29 "app_settings.vala"
	return self;
#line 237 "app_settings.c"
}


static AppSettings*
app_settings_new (void)
{
#line 29 "app_settings.vala"
	return app_settings_construct (TYPE_APP_SETTINGS);
#line 246 "app_settings.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 39 "app_settings.vala"
	return self ? g_object_ref (self) : NULL;
#line 255 "app_settings.c"
}


AppSettings*
app_settings_get_default (void)
{
	AppSettings* result = NULL;
	AppSettings* _tmp0_;
	AppSettings* _tmp2_;
	AppSettings* _tmp3_;
#line 37 "app_settings.vala"
	_tmp0_ = app_settings_instance;
#line 37 "app_settings.vala"
	if (_tmp0_ == NULL) {
#line 270 "app_settings.c"
		AppSettings* _tmp1_;
#line 38 "app_settings.vala"
		_tmp1_ = app_settings_new ();
#line 38 "app_settings.vala"
		_g_object_unref0 (app_settings_instance);
#line 38 "app_settings.vala"
		app_settings_instance = _tmp1_;
#line 278 "app_settings.c"
	}
#line 39 "app_settings.vala"
	_tmp2_ = app_settings_instance;
#line 39 "app_settings.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 39 "app_settings.vala"
	result = _tmp3_;
#line 39 "app_settings.vala"
	return result;
#line 288 "app_settings.c"
}


static void
__lambda4_ (AppSettings* self,
            GSettings* setting,
            const gchar* key)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
#line 50 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 50 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 52 "app_settings.vala"
	_tmp0_ = g_settings_get_string (setting, key);
#line 52 "app_settings.vala"
	_tmp1_ = _tmp0_;
#line 52 "app_settings.vala"
	app_settings_set_system_font (self, _tmp1_);
#line 52 "app_settings.vala"
	_g_free0 (_tmp1_);
#line 53 "app_settings.vala"
	_tmp2_ = self->priv->editor;
#line 53 "app_settings.vala"
	if (g_settings_get_boolean (_tmp2_, "use-default-font")) {
#line 316 "app_settings.c"
		const gchar* _tmp3_;
#line 54 "app_settings.vala"
		_tmp3_ = self->priv->_system_font;
#line 54 "app_settings.vala"
		app_settings_set_font (self, _tmp3_);
#line 322 "app_settings.c"
	}
}


static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
#line 50 "app_settings.vala"
	__lambda4_ ((AppSettings*) self, _sender, key);
#line 334 "app_settings.c"
}


static void
__lambda120_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* font = NULL;
	gchar* _tmp6_;
#line 57 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 57 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 59 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 60 "app_settings.vala"
	_tmp1_ = val;
#line 60 "app_settings.vala"
	if (_tmp1_) {
#line 358 "app_settings.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 60 "app_settings.vala"
		_tmp2_ = self->priv->_system_font;
#line 60 "app_settings.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 60 "app_settings.vala"
		_g_free0 (_tmp0_);
#line 60 "app_settings.vala"
		_tmp0_ = _tmp3_;
#line 369 "app_settings.c"
	} else {
		GSettings* _tmp4_;
		gchar* _tmp5_;
#line 60 "app_settings.vala"
		_tmp4_ = self->priv->editor;
#line 60 "app_settings.vala"
		_tmp5_ = g_settings_get_string (_tmp4_, "editor-font");
#line 60 "app_settings.vala"
		_g_free0 (_tmp0_);
#line 60 "app_settings.vala"
		_tmp0_ = _tmp5_;
#line 381 "app_settings.c"
	}
#line 60 "app_settings.vala"
	_tmp6_ = g_strdup (_tmp0_);
#line 60 "app_settings.vala"
	font = _tmp6_;
#line 61 "app_settings.vala"
	app_settings_set_font (self, font);
#line 57 "app_settings.vala"
	_g_free0 (font);
#line 57 "app_settings.vala"
	_g_free0 (_tmp0_);
#line 393 "app_settings.c"
}


static void
___lambda120__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 57 "app_settings.vala"
	__lambda120_ ((AppSettings*) self, _sender, key);
#line 404 "app_settings.c"
}


static void
__lambda121_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 64 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 64 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 66 "app_settings.vala"
	_tmp0_ = self->priv->editor;
#line 66 "app_settings.vala"
	if (g_settings_get_boolean (_tmp0_, "use-default-font")) {
#line 67 "app_settings.vala"
		return;
#line 426 "app_settings.c"
	}
#line 68 "app_settings.vala"
	_tmp1_ = g_settings_get_string (setting, key);
#line 68 "app_settings.vala"
	_tmp2_ = _tmp1_;
#line 68 "app_settings.vala"
	app_settings_set_font (self, _tmp2_);
#line 68 "app_settings.vala"
	_g_free0 (_tmp2_);
#line 436 "app_settings.c"
}


static void
___lambda121__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 64 "app_settings.vala"
	__lambda121_ ((AppSettings*) self, _sender, key);
#line 447 "app_settings.c"
}


static void
__lambda122_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	guint val = 0U;
#line 71 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 71 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 74 "app_settings.vala"
	g_settings_get (setting, key, "u", &val);
#line 463 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 76 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 76 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 76 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 76 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 76 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 76 "app_settings.vala"
		_view_list = _tmp3_;
#line 76 "app_settings.vala"
		_tmp4_ = _view_list;
#line 76 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 76 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 76 "app_settings.vala"
		_view_size = _tmp6_;
#line 76 "app_settings.vala"
		_view_index = -1;
#line 76 "app_settings.vala"
		while (TRUE) {
#line 499 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			DocumentView* view = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			DocumentView* _tmp13_;
			guint _tmp14_;
#line 76 "app_settings.vala"
			_tmp7_ = _view_index;
#line 76 "app_settings.vala"
			_view_index = _tmp7_ + 1;
#line 76 "app_settings.vala"
			_tmp8_ = _view_index;
#line 76 "app_settings.vala"
			_tmp9_ = _view_size;
#line 76 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 76 "app_settings.vala"
				break;
#line 521 "app_settings.c"
			}
#line 76 "app_settings.vala"
			_tmp10_ = _view_list;
#line 76 "app_settings.vala"
			_tmp11_ = _view_index;
#line 76 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 76 "app_settings.vala"
			view = (DocumentView*) _tmp12_;
#line 77 "app_settings.vala"
			_tmp13_ = view;
#line 77 "app_settings.vala"
			_tmp14_ = val;
#line 77 "app_settings.vala"
			gtk_source_view_set_tab_width ((GtkSourceView*) _tmp13_, _tmp14_);
#line 76 "app_settings.vala"
			_g_object_unref0 (view);
#line 539 "app_settings.c"
		}
#line 76 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 543 "app_settings.c"
	}
}


static void
___lambda122__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 71 "app_settings.vala"
	__lambda122_ ((AppSettings*) self, _sender, key);
#line 555 "app_settings.c"
}


static void
__lambda123_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 80 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 80 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 82 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 571 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 84 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 84 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 84 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 84 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 84 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 84 "app_settings.vala"
		_view_list = _tmp3_;
#line 84 "app_settings.vala"
		_tmp4_ = _view_list;
#line 84 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 84 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 84 "app_settings.vala"
		_view_size = _tmp6_;
#line 84 "app_settings.vala"
		_view_index = -1;
#line 84 "app_settings.vala"
		while (TRUE) {
#line 607 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			DocumentView* view = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			DocumentView* _tmp13_;
			gboolean _tmp14_;
#line 84 "app_settings.vala"
			_tmp7_ = _view_index;
#line 84 "app_settings.vala"
			_view_index = _tmp7_ + 1;
#line 84 "app_settings.vala"
			_tmp8_ = _view_index;
#line 84 "app_settings.vala"
			_tmp9_ = _view_size;
#line 84 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 84 "app_settings.vala"
				break;
#line 629 "app_settings.c"
			}
#line 84 "app_settings.vala"
			_tmp10_ = _view_list;
#line 84 "app_settings.vala"
			_tmp11_ = _view_index;
#line 84 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 84 "app_settings.vala"
			view = (DocumentView*) _tmp12_;
#line 85 "app_settings.vala"
			_tmp13_ = view;
#line 85 "app_settings.vala"
			_tmp14_ = val;
#line 85 "app_settings.vala"
			gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) _tmp13_, _tmp14_);
#line 84 "app_settings.vala"
			_g_object_unref0 (view);
#line 647 "app_settings.c"
		}
#line 84 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 651 "app_settings.c"
	}
}


static void
___lambda123__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 80 "app_settings.vala"
	__lambda123_ ((AppSettings*) self, _sender, key);
#line 663 "app_settings.c"
}


static void
__lambda124_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 88 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 88 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 90 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 679 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 92 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 92 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 92 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 92 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 92 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 92 "app_settings.vala"
		_view_list = _tmp3_;
#line 92 "app_settings.vala"
		_tmp4_ = _view_list;
#line 92 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 92 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 92 "app_settings.vala"
		_view_size = _tmp6_;
#line 92 "app_settings.vala"
		_view_index = -1;
#line 92 "app_settings.vala"
		while (TRUE) {
#line 715 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			DocumentView* view = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			DocumentView* _tmp13_;
			gboolean _tmp14_;
#line 92 "app_settings.vala"
			_tmp7_ = _view_index;
#line 92 "app_settings.vala"
			_view_index = _tmp7_ + 1;
#line 92 "app_settings.vala"
			_tmp8_ = _view_index;
#line 92 "app_settings.vala"
			_tmp9_ = _view_size;
#line 92 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 92 "app_settings.vala"
				break;
#line 737 "app_settings.c"
			}
#line 92 "app_settings.vala"
			_tmp10_ = _view_list;
#line 92 "app_settings.vala"
			_tmp11_ = _view_index;
#line 92 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 92 "app_settings.vala"
			view = (DocumentView*) _tmp12_;
#line 93 "app_settings.vala"
			_tmp13_ = view;
#line 93 "app_settings.vala"
			_tmp14_ = val;
#line 93 "app_settings.vala"
			gtk_source_view_set_show_line_numbers ((GtkSourceView*) _tmp13_, _tmp14_);
#line 92 "app_settings.vala"
			_g_object_unref0 (view);
#line 755 "app_settings.c"
		}
#line 92 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 759 "app_settings.c"
	}
}


static void
___lambda124__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 88 "app_settings.vala"
	__lambda124_ ((AppSettings*) self, _sender, key);
#line 771 "app_settings.c"
}


static void
__lambda125_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 96 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 96 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 98 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 787 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 100 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 100 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 100 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 100 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 100 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 100 "app_settings.vala"
		_view_list = _tmp3_;
#line 100 "app_settings.vala"
		_tmp4_ = _view_list;
#line 100 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 100 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 100 "app_settings.vala"
		_view_size = _tmp6_;
#line 100 "app_settings.vala"
		_view_index = -1;
#line 100 "app_settings.vala"
		while (TRUE) {
#line 823 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			DocumentView* view = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			DocumentView* _tmp13_;
			gboolean _tmp14_;
#line 100 "app_settings.vala"
			_tmp7_ = _view_index;
#line 100 "app_settings.vala"
			_view_index = _tmp7_ + 1;
#line 100 "app_settings.vala"
			_tmp8_ = _view_index;
#line 100 "app_settings.vala"
			_tmp9_ = _view_size;
#line 100 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 100 "app_settings.vala"
				break;
#line 845 "app_settings.c"
			}
#line 100 "app_settings.vala"
			_tmp10_ = _view_list;
#line 100 "app_settings.vala"
			_tmp11_ = _view_index;
#line 100 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 100 "app_settings.vala"
			view = (DocumentView*) _tmp12_;
#line 101 "app_settings.vala"
			_tmp13_ = view;
#line 101 "app_settings.vala"
			_tmp14_ = val;
#line 101 "app_settings.vala"
			gtk_source_view_set_highlight_current_line ((GtkSourceView*) _tmp13_, _tmp14_);
#line 100 "app_settings.vala"
			_g_object_unref0 (view);
#line 863 "app_settings.c"
		}
#line 100 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 867 "app_settings.c"
	}
}


static void
___lambda125__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 96 "app_settings.vala"
	__lambda125_ ((AppSettings*) self, _sender, key);
#line 879 "app_settings.c"
}


static void
__lambda126_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 104 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 104 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 106 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 895 "app_settings.c"
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _doc_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _doc_index = 0;
#line 108 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 108 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 108 "app_settings.vala"
		_tmp2_ = glatex_app_get_documents (_tmp1_);
#line 108 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 108 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 108 "app_settings.vala"
		_doc_list = _tmp3_;
#line 108 "app_settings.vala"
		_tmp4_ = _doc_list;
#line 108 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 108 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 108 "app_settings.vala"
		_doc_size = _tmp6_;
#line 108 "app_settings.vala"
		_doc_index = -1;
#line 108 "app_settings.vala"
		while (TRUE) {
#line 931 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			Document* doc = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			Document* _tmp13_;
			gboolean _tmp14_;
#line 108 "app_settings.vala"
			_tmp7_ = _doc_index;
#line 108 "app_settings.vala"
			_doc_index = _tmp7_ + 1;
#line 108 "app_settings.vala"
			_tmp8_ = _doc_index;
#line 108 "app_settings.vala"
			_tmp9_ = _doc_size;
#line 108 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 108 "app_settings.vala"
				break;
#line 953 "app_settings.c"
			}
#line 108 "app_settings.vala"
			_tmp10_ = _doc_list;
#line 108 "app_settings.vala"
			_tmp11_ = _doc_index;
#line 108 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 108 "app_settings.vala"
			doc = (Document*) _tmp12_;
#line 109 "app_settings.vala"
			_tmp13_ = doc;
#line 109 "app_settings.vala"
			_tmp14_ = val;
#line 109 "app_settings.vala"
			gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) _tmp13_, _tmp14_);
#line 108 "app_settings.vala"
			_g_object_unref0 (doc);
#line 971 "app_settings.c"
		}
#line 108 "app_settings.vala"
		_g_object_unref0 (_doc_list);
#line 975 "app_settings.c"
	}
}


static void
___lambda126__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 104 "app_settings.vala"
	__lambda126_ ((AppSettings*) self, _sender, key);
#line 987 "app_settings.c"
}


static void
__lambda127_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	gboolean val = FALSE;
#line 112 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 112 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 114 "app_settings.vala"
	val = g_settings_get_boolean (setting, key);
#line 1003 "app_settings.c"
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _doc_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _doc_index = 0;
#line 116 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 116 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 116 "app_settings.vala"
		_tmp2_ = glatex_app_get_documents (_tmp1_);
#line 116 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 116 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 116 "app_settings.vala"
		_doc_list = _tmp3_;
#line 116 "app_settings.vala"
		_tmp4_ = _doc_list;
#line 116 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 116 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 116 "app_settings.vala"
		_doc_size = _tmp6_;
#line 116 "app_settings.vala"
		_doc_index = -1;
#line 116 "app_settings.vala"
		while (TRUE) {
#line 1039 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			Document* doc = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			Document* _tmp13_;
			DocumentTab* _tmp14_;
			gboolean _tmp15_;
#line 116 "app_settings.vala"
			_tmp7_ = _doc_index;
#line 116 "app_settings.vala"
			_doc_index = _tmp7_ + 1;
#line 116 "app_settings.vala"
			_tmp8_ = _doc_index;
#line 116 "app_settings.vala"
			_tmp9_ = _doc_size;
#line 116 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 116 "app_settings.vala"
				break;
#line 1062 "app_settings.c"
			}
#line 116 "app_settings.vala"
			_tmp10_ = _doc_list;
#line 116 "app_settings.vala"
			_tmp11_ = _doc_index;
#line 116 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 116 "app_settings.vala"
			doc = (Document*) _tmp12_;
#line 117 "app_settings.vala"
			_tmp13_ = doc;
#line 117 "app_settings.vala"
			_tmp14_ = _tmp13_->tab;
#line 117 "app_settings.vala"
			_tmp15_ = val;
#line 117 "app_settings.vala"
			document_tab_set_auto_save (_tmp14_, _tmp15_);
#line 116 "app_settings.vala"
			_g_object_unref0 (doc);
#line 1082 "app_settings.c"
		}
#line 116 "app_settings.vala"
		_g_object_unref0 (_doc_list);
#line 1086 "app_settings.c"
	}
}


static void
___lambda127__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 112 "app_settings.vala"
	__lambda127_ ((AppSettings*) self, _sender, key);
#line 1098 "app_settings.c"
}


static void
__lambda128_ (AppSettings* self,
              GSettings* setting,
              const gchar* key)
{
	guint val = 0U;
#line 120 "app_settings.vala"
	g_return_if_fail (setting != NULL);
#line 120 "app_settings.vala"
	g_return_if_fail (key != NULL);
#line 123 "app_settings.vala"
	g_settings_get (setting, key, "u", &val);
#line 1114 "app_settings.c"
	{
		GeeList* _doc_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _doc_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _doc_index = 0;
#line 125 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 125 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 125 "app_settings.vala"
		_tmp2_ = glatex_app_get_documents (_tmp1_);
#line 125 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 125 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 125 "app_settings.vala"
		_doc_list = _tmp3_;
#line 125 "app_settings.vala"
		_tmp4_ = _doc_list;
#line 125 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 125 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 125 "app_settings.vala"
		_doc_size = _tmp6_;
#line 125 "app_settings.vala"
		_doc_index = -1;
#line 125 "app_settings.vala"
		while (TRUE) {
#line 1150 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			Document* doc = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			Document* _tmp13_;
			DocumentTab* _tmp14_;
			guint _tmp15_;
#line 125 "app_settings.vala"
			_tmp7_ = _doc_index;
#line 125 "app_settings.vala"
			_doc_index = _tmp7_ + 1;
#line 125 "app_settings.vala"
			_tmp8_ = _doc_index;
#line 125 "app_settings.vala"
			_tmp9_ = _doc_size;
#line 125 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 125 "app_settings.vala"
				break;
#line 1173 "app_settings.c"
			}
#line 125 "app_settings.vala"
			_tmp10_ = _doc_list;
#line 125 "app_settings.vala"
			_tmp11_ = _doc_index;
#line 125 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 125 "app_settings.vala"
			doc = (Document*) _tmp12_;
#line 126 "app_settings.vala"
			_tmp13_ = doc;
#line 126 "app_settings.vala"
			_tmp14_ = _tmp13_->tab;
#line 126 "app_settings.vala"
			_tmp15_ = val;
#line 126 "app_settings.vala"
			document_tab_set_auto_save_interval (_tmp14_, _tmp15_);
#line 125 "app_settings.vala"
			_g_object_unref0 (doc);
#line 1193 "app_settings.c"
		}
#line 125 "app_settings.vala"
		_g_object_unref0 (_doc_list);
#line 1197 "app_settings.c"
	}
}


static void
___lambda128__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
#line 120 "app_settings.vala"
	__lambda128_ ((AppSettings*) self, _sender, key);
#line 1209 "app_settings.c"
}


static void
app_settings_initialize (AppSettings* self)
{
	GSettings* prefs = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* desktop_interface = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
#line 42 "app_settings.vala"
	g_return_if_fail (self != NULL);
#line 44 "app_settings.vala"
	_tmp0_ = g_settings_get_child ((GSettings*) self, "preferences");
#line 44 "app_settings.vala"
	prefs = _tmp0_;
#line 45 "app_settings.vala"
	_tmp1_ = g_settings_get_child (prefs, "editor");
#line 45 "app_settings.vala"
	_g_object_unref0 (self->priv->editor);
#line 45 "app_settings.vala"
	self->priv->editor = _tmp1_;
#line 47 "app_settings.vala"
	_tmp2_ = g_settings_new ("org.gnome.desktop.interface");
#line 47 "app_settings.vala"
	desktop_interface = _tmp2_;
#line 48 "app_settings.vala"
	_tmp3_ = g_settings_get_string (desktop_interface, "monospace-font-name");
#line 48 "app_settings.vala"
	_tmp4_ = _tmp3_;
#line 48 "app_settings.vala"
	app_settings_set_system_font (self, _tmp4_);
#line 48 "app_settings.vala"
	_g_free0 (_tmp4_);
#line 50 "app_settings.vala"
	g_signal_connect_object (desktop_interface, "changed::monospace-font-name", (GCallback) ___lambda4__g_settings_changed, self, 0);
#line 57 "app_settings.vala"
	_tmp5_ = self->priv->editor;
#line 57 "app_settings.vala"
	g_signal_connect_object (_tmp5_, "changed::use-default-font", (GCallback) ___lambda120__g_settings_changed, self, 0);
#line 64 "app_settings.vala"
	_tmp6_ = self->priv->editor;
#line 64 "app_settings.vala"
	g_signal_connect_object (_tmp6_, "changed::editor-font", (GCallback) ___lambda121__g_settings_changed, self, 0);
#line 71 "app_settings.vala"
	_tmp7_ = self->priv->editor;
#line 71 "app_settings.vala"
	g_signal_connect_object (_tmp7_, "changed::tabs-size", (GCallback) ___lambda122__g_settings_changed, self, 0);
#line 80 "app_settings.vala"
	_tmp8_ = self->priv->editor;
#line 80 "app_settings.vala"
	g_signal_connect_object (_tmp8_, "changed::insert-spaces", (GCallback) ___lambda123__g_settings_changed, self, 0);
#line 88 "app_settings.vala"
	_tmp9_ = self->priv->editor;
#line 88 "app_settings.vala"
	g_signal_connect_object (_tmp9_, "changed::display-line-numbers", (GCallback) ___lambda124__g_settings_changed, self, 0);
#line 96 "app_settings.vala"
	_tmp10_ = self->priv->editor;
#line 96 "app_settings.vala"
	g_signal_connect_object (_tmp10_, "changed::highlight-current-line", (GCallback) ___lambda125__g_settings_changed, self, 0);
#line 104 "app_settings.vala"
	_tmp11_ = self->priv->editor;
#line 104 "app_settings.vala"
	g_signal_connect_object (_tmp11_, "changed::bracket-matching", (GCallback) ___lambda126__g_settings_changed, self, 0);
#line 112 "app_settings.vala"
	_tmp12_ = self->priv->editor;
#line 112 "app_settings.vala"
	g_signal_connect_object (_tmp12_, "changed::auto-save", (GCallback) ___lambda127__g_settings_changed, self, 0);
#line 120 "app_settings.vala"
	_tmp13_ = self->priv->editor;
#line 120 "app_settings.vala"
	g_signal_connect_object (_tmp13_, "changed::auto-save-interval", (GCallback) ___lambda128__g_settings_changed, self, 0);
#line 42 "app_settings.vala"
	_g_object_unref0 (desktop_interface);
#line 42 "app_settings.vala"
	_g_object_unref0 (prefs);
#line 1298 "app_settings.c"
}


static void
app_settings_set_font (AppSettings* self,
                       const gchar* font)
{
#line 130 "app_settings.vala"
	g_return_if_fail (self != NULL);
#line 130 "app_settings.vala"
	g_return_if_fail (font != NULL);
#line 1310 "app_settings.c"
	{
		GeeList* _view_list = NULL;
		GlatexApp* _tmp0_;
		GlatexApp* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _view_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _view_index = 0;
#line 132 "app_settings.vala"
		_tmp0_ = glatex_app_get_instance ();
#line 132 "app_settings.vala"
		_tmp1_ = _tmp0_;
#line 132 "app_settings.vala"
		_tmp2_ = glatex_app_get_views (_tmp1_);
#line 132 "app_settings.vala"
		_tmp3_ = _tmp2_;
#line 132 "app_settings.vala"
		_g_object_unref0 (_tmp1_);
#line 132 "app_settings.vala"
		_view_list = _tmp3_;
#line 132 "app_settings.vala"
		_tmp4_ = _view_list;
#line 132 "app_settings.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 132 "app_settings.vala"
		_tmp6_ = _tmp5_;
#line 132 "app_settings.vala"
		_view_size = _tmp6_;
#line 132 "app_settings.vala"
		_view_index = -1;
#line 132 "app_settings.vala"
		while (TRUE) {
#line 1346 "app_settings.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			DocumentView* view = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			DocumentView* _tmp13_;
#line 132 "app_settings.vala"
			_tmp7_ = _view_index;
#line 132 "app_settings.vala"
			_view_index = _tmp7_ + 1;
#line 132 "app_settings.vala"
			_tmp8_ = _view_index;
#line 132 "app_settings.vala"
			_tmp9_ = _view_size;
#line 132 "app_settings.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 132 "app_settings.vala"
				break;
#line 1367 "app_settings.c"
			}
#line 132 "app_settings.vala"
			_tmp10_ = _view_list;
#line 132 "app_settings.vala"
			_tmp11_ = _view_index;
#line 132 "app_settings.vala"
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 132 "app_settings.vala"
			view = (DocumentView*) _tmp12_;
#line 133 "app_settings.vala"
			_tmp13_ = view;
#line 133 "app_settings.vala"
			document_view_set_font_from_string (_tmp13_, font);
#line 132 "app_settings.vala"
			_g_object_unref0 (view);
#line 1383 "app_settings.c"
		}
#line 132 "app_settings.vala"
		_g_object_unref0 (_view_list);
#line 1387 "app_settings.c"
	}
}


const gchar*
app_settings_get_system_font (AppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 26 "app_settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "app_settings.vala"
	_tmp0_ = self->priv->_system_font;
#line 26 "app_settings.vala"
	result = _tmp0_;
#line 26 "app_settings.vala"
	return result;
#line 1405 "app_settings.c"
}


static void
app_settings_set_system_font (AppSettings* self,
                              const gchar* value)
{
#line 26 "app_settings.vala"
	g_return_if_fail (self != NULL);
#line 26 "app_settings.vala"
	if (g_strcmp0 (value, app_settings_get_system_font (self)) != 0) {
#line 1417 "app_settings.c"
		gchar* _tmp0_;
#line 26 "app_settings.vala"
		_tmp0_ = g_strdup (value);
#line 26 "app_settings.vala"
		_g_free0 (self->priv->_system_font);
#line 26 "app_settings.vala"
		self->priv->_system_font = _tmp0_;
#line 26 "app_settings.vala"
		g_object_notify_by_pspec ((GObject *) self, app_settings_properties[APP_SETTINGS_SYSTEM_FONT_PROPERTY]);
#line 1427 "app_settings.c"
	}
}


static void
app_settings_class_init (AppSettingsClass * klass)
{
#line 20 "app_settings.vala"
	app_settings_parent_class = g_type_class_peek_parent (klass);
#line 20 "app_settings.vala"
	g_type_class_adjust_private_offset (klass, &AppSettings_private_offset);
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_app_settings_get_property;
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_app_settings_set_property;
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (klass)->finalize = app_settings_finalize;
#line 20 "app_settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_SYSTEM_FONT_PROPERTY, app_settings_properties[APP_SETTINGS_SYSTEM_FONT_PROPERTY] = g_param_spec_string ("system-font", "system-font", "system-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 1447 "app_settings.c"
}


static void
app_settings_instance_init (AppSettings * self)
{
#line 20 "app_settings.vala"
	self->priv = app_settings_get_instance_private (self);
#line 1456 "app_settings.c"
}


static void
app_settings_finalize (GObject * obj)
{
	AppSettings * self;
#line 20 "app_settings.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_SETTINGS, AppSettings);
#line 24 "app_settings.vala"
	_g_object_unref0 (self->priv->editor);
#line 26 "app_settings.vala"
	_g_free0 (self->priv->_system_font);
#line 20 "app_settings.vala"
	G_OBJECT_CLASS (app_settings_parent_class)->finalize (obj);
#line 1472 "app_settings.c"
}


GType
app_settings_get_type (void)
{
	static volatile gsize app_settings_type_id__volatile = 0;
	if (g_once_init_enter (&app_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AppSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppSettings), 0, (GInstanceInitFunc) app_settings_instance_init, NULL };
		GType app_settings_type_id;
		app_settings_type_id = g_type_register_static (g_settings_get_type (), "AppSettings", &g_define_type_info, 0);
		AppSettings_private_offset = g_type_add_instance_private (app_settings_type_id, sizeof (AppSettingsPrivate));
		g_once_init_leave (&app_settings_type_id__volatile, app_settings_type_id);
	}
	return app_settings_type_id__volatile;
}


static void
_vala_app_settings_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	AppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_SETTINGS, AppSettings);
#line 20 "app_settings.vala"
	switch (property_id) {
#line 20 "app_settings.vala"
		case APP_SETTINGS_SYSTEM_FONT_PROPERTY:
#line 20 "app_settings.vala"
		g_value_set_string (value, app_settings_get_system_font (self));
#line 20 "app_settings.vala"
		break;
#line 1507 "app_settings.c"
		default:
#line 20 "app_settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "app_settings.vala"
		break;
#line 1513 "app_settings.c"
	}
}


static void
_vala_app_settings_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	AppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_SETTINGS, AppSettings);
#line 20 "app_settings.vala"
	switch (property_id) {
#line 20 "app_settings.vala"
		case APP_SETTINGS_SYSTEM_FONT_PROPERTY:
#line 20 "app_settings.vala"
		app_settings_set_system_font (self, g_value_get_string (value));
#line 20 "app_settings.vala"
		break;
#line 1534 "app_settings.c"
		default:
#line 20 "app_settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "app_settings.vala"
		break;
#line 1540 "app_settings.c"
	}
}



