/* puzzle-view.c generated by valac 0.42.3, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
enum  {
	PUZZLE_VIEW_0_PROPERTY,
	PUZZLE_VIEW_PUZZLE_PROPERTY,
	PUZZLE_VIEW_NUM_PROPERTIES
};
static GParamSpec* puzzle_view_properties[PUZZLE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	gint render_size;
	gint piece_x;
	gint piece_y;
	gboolean piece_unmoved;
	gchar _piece_id;
	gchar last_piece_id;
	gdouble kx;
	gdouble ky;
	RsvgHandle* tiles_handle;
	gchar* image_filepath;
	cairo_surface_t* surface;
	Puzzle* _puzzle;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gint PuzzleView_private_offset;
static gpointer puzzle_view_parent_class = NULL;

GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_SPACE_OFFSET 4
#define PUZZLE_VIEW_SPACE_PADDING 5
#define PUZZLE_VIEW_THEME_OVERLAY_SIZE 8
#define PUZZLE_VIEW_THEME_TILE_SEGMENTS 27
#define PUZZLE_VIEW_THEME_TILE_CENTER 14
#define PUZZLE_VIEW_THEME_TILE_SIZE 34
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void puzzle_view_load_image (PuzzleView* self);
static gboolean puzzle_view_real_draw (GtkWidget* base,
                                cairo_t* cr);
static gint puzzle_view_get_tile_size (PuzzleView* self);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
static void puzzle_view_draw_square (PuzzleView* self,
                              cairo_t* cr,
                              gint x,
                              gint y,
                              gdouble kx,
                              gdouble ky);
static gchar puzzle_view_get_piece_id (PuzzleView* self);
gchar puzzle_get_piece_id (Puzzle* self,
                           gchar* src,
                           int src_length1,
                           gint x,
                           gint y);
gint puzzle_get_piece_nr (Puzzle* self,
                          gint x,
                          gint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base,
                                              GdkEventButton* event);
gboolean puzzle_game_over (Puzzle* self);
static void puzzle_view_set_piece_id (PuzzleView* self,
                               gchar value);
static gchar* _vala_array_dup7 (gchar* self,
                         int length);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base,
                                                GdkEventButton* event);
gboolean puzzle_movable (Puzzle* self,
                         gint id);
gboolean puzzle_mapcmp (Puzzle* self,
                        gchar* m1,
                        int m1_length1,
                        gchar* m2,
                        int m2_length1);
static gchar* _vala_array_dup8 (gchar* self,
                         int length);
static gchar* _vala_array_dup9 (gchar* self,
                         int length);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base,
                                               GdkEventMotion* event);
gboolean puzzle_move_piece (Puzzle* self,
                            gchar id,
                            gint x1,
                            gint y1,
                            gint x2,
                            gint y2);
static void puzzle_view_puzzle_changed_cb (PuzzleView* self);
void puzzle_view_set_puzzle (PuzzleView* self,
                             Puzzle* value);
static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender,
                                                    gpointer self);
static void puzzle_view_finalize (GObject * obj);
static void _vala_puzzle_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);


static inline gpointer
puzzle_view_get_instance_private (PuzzleView* self)
{
	return G_STRUCT_MEMBER_P (self, PuzzleView_private_offset);
}


PuzzleView*
puzzle_view_construct (GType object_type)
{
	PuzzleView * self = NULL;
#line 71 "puzzle-view.vala"
	self = (PuzzleView*) g_object_new (object_type, NULL);
#line 73 "puzzle-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 250);
#line 74 "puzzle-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
#line 75 "puzzle-view.vala"
	puzzle_view_load_image (self);
#line 71 "puzzle-view.vala"
	return self;
#line 207 "puzzle-view.c"
}


PuzzleView*
puzzle_view_new (void)
{
#line 71 "puzzle-view.vala"
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
#line 216 "puzzle-view.c"
}


static void
puzzle_view_load_image (PuzzleView* self)
{
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
#line 78 "puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 80 "puzzle-view.vala"
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "gnome-klotski.svg", NULL, NULL);
#line 80 "puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 80 "puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 233 "puzzle-view.c"
	{
		RsvgHandle* _tmp1_ = NULL;
		const gchar* _tmp2_;
		RsvgHandle* _tmp3_;
		RsvgHandle* _tmp4_;
#line 84 "puzzle-view.vala"
		_tmp2_ = self->priv->image_filepath;
#line 84 "puzzle-view.vala"
		_tmp3_ = rsvg_handle_new_from_file (_tmp2_, &_inner_error_);
#line 84 "puzzle-view.vala"
		_tmp1_ = _tmp3_;
#line 84 "puzzle-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "puzzle-view.c"
			goto __catch7_g_error;
		}
#line 84 "puzzle-view.vala"
		_tmp4_ = _tmp1_;
#line 84 "puzzle-view.vala"
		_tmp1_ = NULL;
#line 84 "puzzle-view.vala"
		_g_object_unref0 (self->priv->tiles_handle);
#line 84 "puzzle-view.vala"
		self->priv->tiles_handle = _tmp4_;
#line 82 "puzzle-view.vala"
		_g_object_unref0 (_tmp1_);
#line 260 "puzzle-view.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
#line 82 "puzzle-view.vala"
		e = _inner_error_;
#line 82 "puzzle-view.vala"
		_inner_error_ = NULL;
#line 95 "puzzle-view.vala"
		_tmp5_ = stderr;
#line 95 "puzzle-view.vala"
		_tmp6_ = e;
#line 95 "puzzle-view.vala"
		_tmp7_ = _tmp6_->message;
#line 95 "puzzle-view.vala"
		fprintf (_tmp5_, "%s %s\n", "Error in puzzle-view.vala load image:", _tmp7_);
#line 96 "puzzle-view.vala"
		_tmp8_ = stderr;
#line 96 "puzzle-view.vala"
		_tmp9_ = self->priv->image_filepath;
#line 96 "puzzle-view.vala"
		fprintf (_tmp8_, "%s %s\n", "image path:", _tmp9_);
#line 97 "puzzle-view.vala"
		exit (EXIT_FAILURE);
#line 82 "puzzle-view.vala"
		_g_error_free0 (e);
#line 293 "puzzle-view.c"
	}
	__finally7:
#line 82 "puzzle-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "puzzle-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "puzzle-view.vala"
		g_clear_error (&_inner_error_);
#line 82 "puzzle-view.vala"
		return;
#line 304 "puzzle-view.c"
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 124 "puzzle-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 314 "puzzle-view.c"
}


static gboolean
puzzle_view_real_draw (GtkWidget* base,
                       cairo_t* cr)
{
	PuzzleView * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkStyleContext* _tmp26_;
	GdkRGBA fg = {0};
	GtkStyleContext* _tmp27_;
	GdkRGBA _tmp28_ = {0};
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp29_;
	GdkRGBA _tmp30_ = {0};
	GtkStyleContext* _tmp31_;
	GdkRGBA _tmp32_;
	gint width = 0;
	gint height = 0;
	GdkRGBA _tmp33_;
	gdouble kwidth = 0.0;
	Puzzle* _tmp34_;
	Puzzle* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gdouble kheight = 0.0;
	Puzzle* _tmp39_;
	Puzzle* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gdouble _tmp45_;
	gint _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	gdouble _tmp51_;
#line 101 "puzzle-view.vala"
	self = (PuzzleView*) base;
#line 101 "puzzle-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 103 "puzzle-view.vala"
	_tmp0_ = puzzle_view_get_tile_size (self);
#line 103 "puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 103 "puzzle-view.vala"
	_tmp2_ = self->priv->render_size;
#line 103 "puzzle-view.vala"
	if (_tmp1_ != _tmp2_) {
#line 375 "puzzle-view.c"
		RsvgHandle* _tmp3_;
		gint _tmp21_;
		gint _tmp22_;
#line 105 "puzzle-view.vala"
		_tmp3_ = self->priv->tiles_handle;
#line 105 "puzzle-view.vala"
		if (_tmp3_ != NULL) {
#line 383 "puzzle-view.c"
			gint height = 0;
			gint _tmp4_;
			gint _tmp5_;
			gint width = 0;
			gint _tmp6_;
			gint _tmp7_;
			cairo_surface_t* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			cairo_surface_t* _tmp11_;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp12_;
			cairo_t* _tmp13_;
			gdouble sfw = 0.0;
			gint _tmp14_;
			gdouble sfh = 0.0;
			gint _tmp15_;
			cairo_t* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			RsvgHandle* _tmp19_;
			cairo_t* _tmp20_;
#line 107 "puzzle-view.vala"
			_tmp4_ = puzzle_view_get_tile_size (self);
#line 107 "puzzle-view.vala"
			_tmp5_ = _tmp4_;
#line 107 "puzzle-view.vala"
			height = _tmp5_ * 2;
#line 108 "puzzle-view.vala"
			_tmp6_ = puzzle_view_get_tile_size (self);
#line 108 "puzzle-view.vala"
			_tmp7_ = _tmp6_;
#line 108 "puzzle-view.vala"
			width = _tmp7_ * PUZZLE_VIEW_THEME_TILE_SEGMENTS;
#line 110 "puzzle-view.vala"
			_tmp8_ = cairo_get_target (cr);
#line 110 "puzzle-view.vala"
			_tmp9_ = width;
#line 110 "puzzle-view.vala"
			_tmp10_ = height;
#line 110 "puzzle-view.vala"
			_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_, _tmp10_);
#line 110 "puzzle-view.vala"
			_cairo_surface_destroy0 (self->priv->surface);
#line 110 "puzzle-view.vala"
			self->priv->surface = _tmp11_;
#line 111 "puzzle-view.vala"
			_tmp12_ = self->priv->surface;
#line 111 "puzzle-view.vala"
			_tmp13_ = cairo_create (_tmp12_);
#line 111 "puzzle-view.vala"
			c = _tmp13_;
#line 114 "puzzle-view.vala"
			_tmp14_ = width;
#line 114 "puzzle-view.vala"
			sfw = ((gdouble) _tmp14_) / 918;
#line 115 "puzzle-view.vala"
			_tmp15_ = height;
#line 115 "puzzle-view.vala"
			sfh = ((gdouble) _tmp15_) / 68;
#line 117 "puzzle-view.vala"
			_tmp16_ = c;
#line 117 "puzzle-view.vala"
			_tmp17_ = sfw;
#line 117 "puzzle-view.vala"
			_tmp18_ = sfh;
#line 117 "puzzle-view.vala"
			cairo_scale (_tmp16_, _tmp17_, _tmp18_);
#line 119 "puzzle-view.vala"
			_tmp19_ = self->priv->tiles_handle;
#line 119 "puzzle-view.vala"
			_tmp20_ = c;
#line 119 "puzzle-view.vala"
			rsvg_handle_render_cairo (_tmp19_, _tmp20_);
#line 105 "puzzle-view.vala"
			_cairo_destroy0 (c);
#line 460 "puzzle-view.c"
		}
#line 121 "puzzle-view.vala"
		_tmp21_ = puzzle_view_get_tile_size (self);
#line 121 "puzzle-view.vala"
		_tmp22_ = _tmp21_;
#line 121 "puzzle-view.vala"
		self->priv->render_size = _tmp22_;
#line 468 "puzzle-view.c"
	}
#line 124 "puzzle-view.vala"
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 124 "puzzle-view.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 124 "puzzle-view.vala"
	style = _tmp24_;
#line 125 "puzzle-view.vala"
	_tmp25_ = style;
#line 125 "puzzle-view.vala"
	gtk_style_context_save (_tmp25_);
#line 126 "puzzle-view.vala"
	_tmp26_ = style;
#line 126 "puzzle-view.vala"
	gtk_style_context_set_state (_tmp26_, GTK_STATE_FLAG_NORMAL);
#line 127 "puzzle-view.vala"
	_tmp27_ = style;
#line 127 "puzzle-view.vala"
	gtk_style_context_get_color (_tmp27_, GTK_STATE_FLAG_NORMAL, &_tmp28_);
#line 127 "puzzle-view.vala"
	fg = _tmp28_;
#line 128 "puzzle-view.vala"
	_tmp29_ = style;
#line 128 "puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp29_, GTK_STATE_FLAG_NORMAL, &_tmp30_);
#line 128 "puzzle-view.vala"
	bg = _tmp30_;
#line 129 "puzzle-view.vala"
	_tmp31_ = style;
#line 129 "puzzle-view.vala"
	gtk_style_context_restore (_tmp31_);
#line 131 "puzzle-view.vala"
	_tmp32_ = bg;
#line 131 "puzzle-view.vala"
	gdk_cairo_set_source_rgba (cr, &_tmp32_);
#line 132 "puzzle-view.vala"
	cairo_paint (cr);
#line 134 "puzzle-view.vala"
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 135 "puzzle-view.vala"
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 137 "puzzle-view.vala"
	_tmp33_ = fg;
#line 137 "puzzle-view.vala"
	gdk_cairo_set_source_rgba (cr, &_tmp33_);
#line 138 "puzzle-view.vala"
	cairo_set_line_width (cr, 1.0);
#line 140 "puzzle-view.vala"
	_tmp34_ = puzzle_view_get_puzzle (self);
#line 140 "puzzle-view.vala"
	_tmp35_ = _tmp34_;
#line 140 "puzzle-view.vala"
	_tmp36_ = _tmp35_->width;
#line 140 "puzzle-view.vala"
	_tmp37_ = puzzle_view_get_tile_size (self);
#line 140 "puzzle-view.vala"
	_tmp38_ = _tmp37_;
#line 140 "puzzle-view.vala"
	kwidth = ((_tmp36_ * _tmp38_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 141 "puzzle-view.vala"
	_tmp39_ = puzzle_view_get_puzzle (self);
#line 141 "puzzle-view.vala"
	_tmp40_ = _tmp39_;
#line 141 "puzzle-view.vala"
	_tmp41_ = _tmp40_->height;
#line 141 "puzzle-view.vala"
	_tmp42_ = puzzle_view_get_tile_size (self);
#line 141 "puzzle-view.vala"
	_tmp43_ = _tmp42_;
#line 141 "puzzle-view.vala"
	kheight = ((_tmp41_ * _tmp43_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 142 "puzzle-view.vala"
	_tmp44_ = width;
#line 142 "puzzle-view.vala"
	_tmp45_ = kwidth;
#line 142 "puzzle-view.vala"
	self->priv->kx = (_tmp44_ - _tmp45_) / 2.0;
#line 143 "puzzle-view.vala"
	_tmp46_ = height;
#line 143 "puzzle-view.vala"
	_tmp47_ = kheight;
#line 143 "puzzle-view.vala"
	self->priv->ky = (_tmp46_ - _tmp47_) / 2.0;
#line 145 "puzzle-view.vala"
	_tmp48_ = self->priv->kx;
#line 145 "puzzle-view.vala"
	_tmp49_ = self->priv->ky;
#line 145 "puzzle-view.vala"
	_tmp50_ = kwidth;
#line 145 "puzzle-view.vala"
	_tmp51_ = kheight;
#line 145 "puzzle-view.vala"
	cairo_rectangle (cr, _tmp48_, _tmp49_, _tmp50_, _tmp51_);
#line 146 "puzzle-view.vala"
	cairo_stroke (cr);
#line 564 "puzzle-view.c"
	{
		gint y = 0;
#line 148 "puzzle-view.vala"
		y = 0;
#line 569 "puzzle-view.c"
		{
			gboolean _tmp52_ = FALSE;
#line 148 "puzzle-view.vala"
			_tmp52_ = TRUE;
#line 148 "puzzle-view.vala"
			while (TRUE) {
#line 576 "puzzle-view.c"
				gint _tmp54_;
				Puzzle* _tmp55_;
				Puzzle* _tmp56_;
				gint _tmp57_;
#line 148 "puzzle-view.vala"
				if (!_tmp52_) {
#line 583 "puzzle-view.c"
					gint _tmp53_;
#line 148 "puzzle-view.vala"
					_tmp53_ = y;
#line 148 "puzzle-view.vala"
					y = _tmp53_ + 1;
#line 589 "puzzle-view.c"
				}
#line 148 "puzzle-view.vala"
				_tmp52_ = FALSE;
#line 148 "puzzle-view.vala"
				_tmp54_ = y;
#line 148 "puzzle-view.vala"
				_tmp55_ = puzzle_view_get_puzzle (self);
#line 148 "puzzle-view.vala"
				_tmp56_ = _tmp55_;
#line 148 "puzzle-view.vala"
				_tmp57_ = _tmp56_->height;
#line 148 "puzzle-view.vala"
				if (!(_tmp54_ < _tmp57_)) {
#line 148 "puzzle-view.vala"
					break;
#line 605 "puzzle-view.c"
				}
				{
					gint x = 0;
#line 149 "puzzle-view.vala"
					x = 0;
#line 611 "puzzle-view.c"
					{
						gboolean _tmp58_ = FALSE;
#line 149 "puzzle-view.vala"
						_tmp58_ = TRUE;
#line 149 "puzzle-view.vala"
						while (TRUE) {
#line 618 "puzzle-view.c"
							gint _tmp60_;
							Puzzle* _tmp61_;
							Puzzle* _tmp62_;
							gint _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							gdouble _tmp66_;
							gdouble _tmp67_;
							gchar _tmp68_;
							gchar _tmp69_;
							Puzzle* _tmp70_;
							Puzzle* _tmp71_;
							Puzzle* _tmp72_;
							Puzzle* _tmp73_;
							gchar* _tmp74_;
							gint _tmp74__length1;
							gint _tmp75_;
							gint _tmp76_;
#line 149 "puzzle-view.vala"
							if (!_tmp58_) {
#line 639 "puzzle-view.c"
								gint _tmp59_;
#line 149 "puzzle-view.vala"
								_tmp59_ = x;
#line 149 "puzzle-view.vala"
								x = _tmp59_ + 1;
#line 645 "puzzle-view.c"
							}
#line 149 "puzzle-view.vala"
							_tmp58_ = FALSE;
#line 149 "puzzle-view.vala"
							_tmp60_ = x;
#line 149 "puzzle-view.vala"
							_tmp61_ = puzzle_view_get_puzzle (self);
#line 149 "puzzle-view.vala"
							_tmp62_ = _tmp61_;
#line 149 "puzzle-view.vala"
							_tmp63_ = _tmp62_->width;
#line 149 "puzzle-view.vala"
							if (!(_tmp60_ < _tmp63_)) {
#line 149 "puzzle-view.vala"
								break;
#line 661 "puzzle-view.c"
							}
#line 151 "puzzle-view.vala"
							_tmp64_ = x;
#line 151 "puzzle-view.vala"
							_tmp65_ = y;
#line 151 "puzzle-view.vala"
							_tmp66_ = self->priv->kx;
#line 151 "puzzle-view.vala"
							_tmp67_ = self->priv->ky;
#line 151 "puzzle-view.vala"
							puzzle_view_draw_square (self, cr, _tmp64_, _tmp65_, _tmp66_, _tmp67_);
#line 153 "puzzle-view.vala"
							_tmp68_ = puzzle_view_get_piece_id (self);
#line 153 "puzzle-view.vala"
							_tmp69_ = _tmp68_;
#line 153 "puzzle-view.vala"
							_tmp70_ = puzzle_view_get_puzzle (self);
#line 153 "puzzle-view.vala"
							_tmp71_ = _tmp70_;
#line 153 "puzzle-view.vala"
							_tmp72_ = puzzle_view_get_puzzle (self);
#line 153 "puzzle-view.vala"
							_tmp73_ = _tmp72_;
#line 153 "puzzle-view.vala"
							_tmp74_ = _tmp73_->map;
#line 153 "puzzle-view.vala"
							_tmp74__length1 = _tmp73_->map_length1;
#line 153 "puzzle-view.vala"
							_tmp75_ = x;
#line 153 "puzzle-view.vala"
							_tmp76_ = y;
#line 153 "puzzle-view.vala"
							if (_tmp69_ == puzzle_get_piece_id (_tmp71_, _tmp74_, _tmp74__length1, _tmp75_, _tmp76_)) {
#line 695 "puzzle-view.c"
								GdkRGBA _tmp77_ = {0};
								gint _tmp78_;
								gint _tmp79_;
								gint _tmp80_;
								gdouble _tmp81_;
								gint _tmp82_;
								gint _tmp83_;
								gint _tmp84_;
								gdouble _tmp85_;
								gint _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								gint _tmp89_;
#line 155 "puzzle-view.vala"
								_tmp77_.red = 1.0;
#line 155 "puzzle-view.vala"
								_tmp77_.green = 1.0;
#line 155 "puzzle-view.vala"
								_tmp77_.blue = 1.0;
#line 155 "puzzle-view.vala"
								_tmp77_.alpha = 0.2;
#line 155 "puzzle-view.vala"
								gdk_cairo_set_source_rgba (cr, &_tmp77_);
#line 156 "puzzle-view.vala"
								_tmp78_ = x;
#line 156 "puzzle-view.vala"
								_tmp79_ = puzzle_view_get_tile_size (self);
#line 156 "puzzle-view.vala"
								_tmp80_ = _tmp79_;
#line 156 "puzzle-view.vala"
								_tmp81_ = self->priv->kx;
#line 156 "puzzle-view.vala"
								_tmp82_ = y;
#line 156 "puzzle-view.vala"
								_tmp83_ = puzzle_view_get_tile_size (self);
#line 156 "puzzle-view.vala"
								_tmp84_ = _tmp83_;
#line 156 "puzzle-view.vala"
								_tmp85_ = self->priv->ky;
#line 156 "puzzle-view.vala"
								_tmp86_ = puzzle_view_get_tile_size (self);
#line 156 "puzzle-view.vala"
								_tmp87_ = _tmp86_;
#line 156 "puzzle-view.vala"
								_tmp88_ = puzzle_view_get_tile_size (self);
#line 156 "puzzle-view.vala"
								_tmp89_ = _tmp88_;
#line 156 "puzzle-view.vala"
								cairo_rectangle (cr, (_tmp78_ * _tmp80_) + _tmp81_, (_tmp82_ * _tmp84_) + _tmp85_, (gdouble) _tmp87_, (gdouble) _tmp89_);
#line 157 "puzzle-view.vala"
								cairo_fill (cr);
#line 747 "puzzle-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 161 "puzzle-view.vala"
	result = FALSE;
#line 161 "puzzle-view.vala"
	_g_object_unref0 (style);
#line 161 "puzzle-view.vala"
	return result;
#line 761 "puzzle-view.c"
}


static void
puzzle_view_draw_square (PuzzleView* self,
                         cairo_t* cr,
                         gint x,
                         gint y,
                         gdouble kx,
                         gdouble ky)
{
	GdkRectangle rect = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkStyleContext* _tmp11_;
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp12_;
	GdkRGBA _tmp13_ = {0};
	GtkStyleContext* _tmp14_;
	GdkRectangle _tmp15_;
	GdkRGBA _tmp16_;
	Puzzle* _tmp17_;
	Puzzle* _tmp18_;
	Puzzle* _tmp19_;
	Puzzle* _tmp20_;
	gchar* _tmp21_;
	gint _tmp21__length1;
	Puzzle* _tmp34_;
	Puzzle* _tmp35_;
	Puzzle* _tmp36_;
	Puzzle* _tmp37_;
	gchar* _tmp38_;
	gint _tmp38__length1;
#line 164 "puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 164 "puzzle-view.vala"
	g_return_if_fail (cr != NULL);
#line 166 "puzzle-view.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 167 "puzzle-view.vala"
	_tmp0_ = puzzle_view_get_tile_size (self);
#line 167 "puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 167 "puzzle-view.vala"
	rect.x = (((x * _tmp1_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) kx)) - 1;
#line 168 "puzzle-view.vala"
	_tmp2_ = puzzle_view_get_tile_size (self);
#line 168 "puzzle-view.vala"
	_tmp3_ = _tmp2_;
#line 168 "puzzle-view.vala"
	rect.y = (((y * _tmp3_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) ky)) - 1;
#line 169 "puzzle-view.vala"
	_tmp4_ = puzzle_view_get_tile_size (self);
#line 169 "puzzle-view.vala"
	_tmp5_ = _tmp4_;
#line 169 "puzzle-view.vala"
	rect.width = _tmp5_;
#line 170 "puzzle-view.vala"
	_tmp6_ = puzzle_view_get_tile_size (self);
#line 170 "puzzle-view.vala"
	_tmp7_ = _tmp6_;
#line 170 "puzzle-view.vala"
	rect.height = _tmp7_;
#line 172 "puzzle-view.vala"
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 172 "puzzle-view.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 172 "puzzle-view.vala"
	style = _tmp9_;
#line 173 "puzzle-view.vala"
	_tmp10_ = style;
#line 173 "puzzle-view.vala"
	gtk_style_context_save (_tmp10_);
#line 174 "puzzle-view.vala"
	_tmp11_ = style;
#line 174 "puzzle-view.vala"
	gtk_style_context_set_state (_tmp11_, GTK_STATE_FLAG_NORMAL);
#line 175 "puzzle-view.vala"
	_tmp12_ = style;
#line 175 "puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp12_, GTK_STATE_FLAG_NORMAL, &_tmp13_);
#line 175 "puzzle-view.vala"
	bg = _tmp13_;
#line 176 "puzzle-view.vala"
	_tmp14_ = style;
#line 176 "puzzle-view.vala"
	gtk_style_context_restore (_tmp14_);
#line 178 "puzzle-view.vala"
	_tmp15_ = rect;
#line 178 "puzzle-view.vala"
	gdk_cairo_rectangle (cr, &_tmp15_);
#line 179 "puzzle-view.vala"
	_tmp16_ = bg;
#line 179 "puzzle-view.vala"
	gdk_cairo_set_source_rgba (cr, &_tmp16_);
#line 181 "puzzle-view.vala"
	cairo_fill (cr);
#line 183 "puzzle-view.vala"
	_tmp17_ = puzzle_view_get_puzzle (self);
#line 183 "puzzle-view.vala"
	_tmp18_ = _tmp17_;
#line 183 "puzzle-view.vala"
	_tmp19_ = puzzle_view_get_puzzle (self);
#line 183 "puzzle-view.vala"
	_tmp20_ = _tmp19_;
#line 183 "puzzle-view.vala"
	_tmp21_ = _tmp20_->map;
#line 183 "puzzle-view.vala"
	_tmp21__length1 = _tmp20_->map_length1;
#line 183 "puzzle-view.vala"
	if (puzzle_get_piece_id (_tmp18_, _tmp21_, _tmp21__length1, x, y) != ' ') {
#line 883 "puzzle-view.c"
		GdkRectangle _tmp22_;
		cairo_surface_t* _tmp23_;
		GdkRectangle _tmp24_;
		gint _tmp25_;
		Puzzle* _tmp26_;
		Puzzle* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		GdkRectangle _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
#line 185 "puzzle-view.vala"
		_tmp22_ = rect;
#line 185 "puzzle-view.vala"
		gdk_cairo_rectangle (cr, &_tmp22_);
#line 186 "puzzle-view.vala"
		_tmp23_ = self->priv->surface;
#line 186 "puzzle-view.vala"
		_tmp24_ = rect;
#line 186 "puzzle-view.vala"
		_tmp25_ = _tmp24_.x;
#line 186 "puzzle-view.vala"
		_tmp26_ = puzzle_view_get_puzzle (self);
#line 186 "puzzle-view.vala"
		_tmp27_ = _tmp26_;
#line 186 "puzzle-view.vala"
		_tmp28_ = puzzle_view_get_tile_size (self);
#line 186 "puzzle-view.vala"
		_tmp29_ = _tmp28_;
#line 186 "puzzle-view.vala"
		_tmp30_ = rect;
#line 186 "puzzle-view.vala"
		_tmp31_ = _tmp30_.y;
#line 186 "puzzle-view.vala"
		_tmp32_ = puzzle_view_get_tile_size (self);
#line 186 "puzzle-view.vala"
		_tmp33_ = _tmp32_;
#line 186 "puzzle-view.vala"
		cairo_set_source_surface (cr, _tmp23_, (gdouble) (_tmp25_ - (puzzle_get_piece_nr (_tmp27_, x, y) * _tmp29_)), (gdouble) (_tmp31_ - (_tmp33_ / 2)));
#line 187 "puzzle-view.vala"
		cairo_fill (cr);
#line 926 "puzzle-view.c"
	}
#line 190 "puzzle-view.vala"
	_tmp34_ = puzzle_view_get_puzzle (self);
#line 190 "puzzle-view.vala"
	_tmp35_ = _tmp34_;
#line 190 "puzzle-view.vala"
	_tmp36_ = puzzle_view_get_puzzle (self);
#line 190 "puzzle-view.vala"
	_tmp37_ = _tmp36_;
#line 190 "puzzle-view.vala"
	_tmp38_ = _tmp37_->map;
#line 190 "puzzle-view.vala"
	_tmp38__length1 = _tmp37_->map_length1;
#line 190 "puzzle-view.vala"
	if (puzzle_get_piece_id (_tmp35_, _tmp38_, _tmp38__length1, x, y) == '*') {
#line 942 "puzzle-view.c"
		gint value = 0;
		Puzzle* _tmp39_;
		Puzzle* _tmp40_;
		Puzzle* _tmp41_;
		Puzzle* _tmp42_;
		gchar* _tmp43_;
		gint _tmp43__length1;
		gint overlay_size = 0;
		gint _tmp44_;
		gint _tmp45_;
		gint overlay_offset = 0;
		gint _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		GdkRectangle _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		GdkRectangle _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		cairo_surface_t* _tmp57_;
		GdkRectangle _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		GdkRectangle _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
#line 192 "puzzle-view.vala"
		value = 22;
#line 193 "puzzle-view.vala"
		_tmp39_ = puzzle_view_get_puzzle (self);
#line 193 "puzzle-view.vala"
		_tmp40_ = _tmp39_;
#line 193 "puzzle-view.vala"
		_tmp41_ = puzzle_view_get_puzzle (self);
#line 193 "puzzle-view.vala"
		_tmp42_ = _tmp41_;
#line 193 "puzzle-view.vala"
		_tmp43_ = _tmp42_->orig_map;
#line 193 "puzzle-view.vala"
		_tmp43__length1 = _tmp42_->orig_map_length1;
#line 193 "puzzle-view.vala"
		if (puzzle_get_piece_id (_tmp40_, _tmp43_, _tmp43__length1, x, y) == '.') {
#line 194 "puzzle-view.vala"
			value = 20;
#line 993 "puzzle-view.c"
		}
#line 196 "puzzle-view.vala"
		_tmp44_ = puzzle_view_get_tile_size (self);
#line 196 "puzzle-view.vala"
		_tmp45_ = _tmp44_;
#line 196 "puzzle-view.vala"
		overlay_size = (PUZZLE_VIEW_THEME_OVERLAY_SIZE * _tmp45_) / PUZZLE_VIEW_THEME_TILE_SIZE;
#line 197 "puzzle-view.vala"
		_tmp46_ = puzzle_view_get_tile_size (self);
#line 197 "puzzle-view.vala"
		_tmp47_ = _tmp46_;
#line 197 "puzzle-view.vala"
		_tmp48_ = overlay_size;
#line 197 "puzzle-view.vala"
		overlay_offset = ((PUZZLE_VIEW_THEME_TILE_CENTER * _tmp47_) / PUZZLE_VIEW_THEME_TILE_SIZE) - (_tmp48_ / 2);
#line 199 "puzzle-view.vala"
		_tmp49_ = rect;
#line 199 "puzzle-view.vala"
		_tmp50_ = _tmp49_.x;
#line 199 "puzzle-view.vala"
		_tmp51_ = overlay_offset;
#line 199 "puzzle-view.vala"
		_tmp52_ = rect;
#line 199 "puzzle-view.vala"
		_tmp53_ = _tmp52_.y;
#line 199 "puzzle-view.vala"
		_tmp54_ = overlay_offset;
#line 199 "puzzle-view.vala"
		_tmp55_ = overlay_size;
#line 199 "puzzle-view.vala"
		_tmp56_ = overlay_size;
#line 199 "puzzle-view.vala"
		cairo_rectangle (cr, (gdouble) (_tmp50_ + _tmp51_), (gdouble) (_tmp53_ + _tmp54_), (gdouble) _tmp55_, (gdouble) _tmp56_);
#line 202 "puzzle-view.vala"
		_tmp57_ = self->priv->surface;
#line 202 "puzzle-view.vala"
		_tmp58_ = rect;
#line 202 "puzzle-view.vala"
		_tmp59_ = _tmp58_.x;
#line 202 "puzzle-view.vala"
		_tmp60_ = value;
#line 202 "puzzle-view.vala"
		_tmp61_ = puzzle_view_get_tile_size (self);
#line 202 "puzzle-view.vala"
		_tmp62_ = _tmp61_;
#line 202 "puzzle-view.vala"
		_tmp63_ = rect;
#line 202 "puzzle-view.vala"
		_tmp64_ = _tmp63_.y;
#line 202 "puzzle-view.vala"
		_tmp65_ = puzzle_view_get_tile_size (self);
#line 202 "puzzle-view.vala"
		_tmp66_ = _tmp65_;
#line 202 "puzzle-view.vala"
		cairo_set_source_surface (cr, _tmp57_, (gdouble) (_tmp59_ - (_tmp60_ * _tmp62_)), (gdouble) (_tmp64_ - (_tmp66_ / 2)));
#line 203 "puzzle-view.vala"
		cairo_fill (cr);
#line 1051 "puzzle-view.c"
	}
#line 164 "puzzle-view.vala"
	_g_object_unref0 (style);
#line 1055 "puzzle-view.c"
}


static gchar*
_vala_array_dup7 (gchar* self,
                  int length)
{
#line 229 "puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1065 "puzzle-view.c"
}


static gboolean
puzzle_view_real_button_press_event (GtkWidget* base,
                                     GdkEventButton* event)
{
	PuzzleView * self;
	gboolean result = FALSE;
	guint _tmp0_;
#line 207 "puzzle-view.vala"
	self = (PuzzleView*) base;
#line 207 "puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 209 "puzzle-view.vala"
	_tmp0_ = event->button;
#line 209 "puzzle-view.vala"
	if (_tmp0_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1084 "puzzle-view.c"
		Puzzle* _tmp1_;
		Puzzle* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar new_piece_id = '\0';
		Puzzle* _tmp11_;
		Puzzle* _tmp12_;
		Puzzle* _tmp13_;
		Puzzle* _tmp14_;
		gchar* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		gint _tmp17_;
		gboolean _tmp18_ = FALSE;
		gchar _tmp19_;
		gchar _tmp20_;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gchar _tmp26_;
		gchar _tmp33_;
		Puzzle* _tmp34_;
		Puzzle* _tmp35_;
		Puzzle* _tmp36_;
		Puzzle* _tmp37_;
		gchar* _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		gint _tmp39__length1;
#line 211 "puzzle-view.vala"
		_tmp1_ = puzzle_view_get_puzzle (self);
#line 211 "puzzle-view.vala"
		_tmp2_ = _tmp1_;
#line 211 "puzzle-view.vala"
		if (puzzle_game_over (_tmp2_)) {
#line 212 "puzzle-view.vala"
			result = FALSE;
#line 212 "puzzle-view.vala"
			return result;
#line 1131 "puzzle-view.c"
		}
#line 214 "puzzle-view.vala"
		_tmp3_ = event->x;
#line 214 "puzzle-view.vala"
		_tmp4_ = self->priv->kx;
#line 214 "puzzle-view.vala"
		_tmp5_ = puzzle_view_get_tile_size (self);
#line 214 "puzzle-view.vala"
		_tmp6_ = _tmp5_;
#line 214 "puzzle-view.vala"
		self->priv->piece_x = ((gint) (_tmp3_ - _tmp4_)) / _tmp6_;
#line 215 "puzzle-view.vala"
		_tmp7_ = event->y;
#line 215 "puzzle-view.vala"
		_tmp8_ = self->priv->ky;
#line 215 "puzzle-view.vala"
		_tmp9_ = puzzle_view_get_tile_size (self);
#line 215 "puzzle-view.vala"
		_tmp10_ = _tmp9_;
#line 215 "puzzle-view.vala"
		self->priv->piece_y = ((gint) (_tmp7_ - _tmp8_)) / _tmp10_;
#line 216 "puzzle-view.vala"
		_tmp11_ = puzzle_view_get_puzzle (self);
#line 216 "puzzle-view.vala"
		_tmp12_ = _tmp11_;
#line 216 "puzzle-view.vala"
		_tmp13_ = puzzle_view_get_puzzle (self);
#line 216 "puzzle-view.vala"
		_tmp14_ = _tmp13_;
#line 216 "puzzle-view.vala"
		_tmp15_ = _tmp14_->map;
#line 216 "puzzle-view.vala"
		_tmp15__length1 = _tmp14_->map_length1;
#line 216 "puzzle-view.vala"
		_tmp16_ = self->priv->piece_x;
#line 216 "puzzle-view.vala"
		_tmp17_ = self->priv->piece_y;
#line 216 "puzzle-view.vala"
		new_piece_id = puzzle_get_piece_id (_tmp12_, _tmp15_, _tmp15__length1, _tmp16_, _tmp17_);
#line 218 "puzzle-view.vala"
		_tmp19_ = puzzle_view_get_piece_id (self);
#line 218 "puzzle-view.vala"
		_tmp20_ = _tmp19_;
#line 218 "puzzle-view.vala"
		if (_tmp20_ != '\0') {
#line 1177 "puzzle-view.c"
			gboolean _tmp21_;
#line 218 "puzzle-view.vala"
			_tmp21_ = self->priv->piece_unmoved;
#line 218 "puzzle-view.vala"
			_tmp18_ = _tmp21_;
#line 1183 "puzzle-view.c"
		} else {
#line 218 "puzzle-view.vala"
			_tmp18_ = FALSE;
#line 1187 "puzzle-view.c"
		}
#line 218 "puzzle-view.vala"
		if (_tmp18_) {
#line 220 "puzzle-view.vala"
			puzzle_view_set_piece_id (self, '\0');
#line 221 "puzzle-view.vala"
			result = FALSE;
#line 221 "puzzle-view.vala"
			return result;
#line 1197 "puzzle-view.c"
		}
#line 223 "puzzle-view.vala"
		_tmp26_ = new_piece_id;
#line 223 "puzzle-view.vala"
		if (_tmp26_ == ' ') {
#line 223 "puzzle-view.vala"
			_tmp25_ = TRUE;
#line 1205 "puzzle-view.c"
		} else {
			gchar _tmp27_;
#line 223 "puzzle-view.vala"
			_tmp27_ = new_piece_id;
#line 223 "puzzle-view.vala"
			_tmp25_ = _tmp27_ == '.';
#line 1212 "puzzle-view.c"
		}
#line 223 "puzzle-view.vala"
		if (_tmp25_) {
#line 223 "puzzle-view.vala"
			_tmp24_ = TRUE;
#line 1218 "puzzle-view.c"
		} else {
			gchar _tmp28_;
#line 223 "puzzle-view.vala"
			_tmp28_ = new_piece_id;
#line 223 "puzzle-view.vala"
			_tmp24_ = _tmp28_ == '-';
#line 1225 "puzzle-view.c"
		}
#line 223 "puzzle-view.vala"
		if (_tmp24_) {
#line 223 "puzzle-view.vala"
			_tmp23_ = TRUE;
#line 1231 "puzzle-view.c"
		} else {
			gchar _tmp29_;
#line 224 "puzzle-view.vala"
			_tmp29_ = new_piece_id;
#line 224 "puzzle-view.vala"
			_tmp23_ = _tmp29_ == '#';
#line 1238 "puzzle-view.c"
		}
#line 223 "puzzle-view.vala"
		if (_tmp23_) {
#line 223 "puzzle-view.vala"
			_tmp22_ = TRUE;
#line 1244 "puzzle-view.c"
		} else {
			gchar _tmp30_;
			gchar _tmp31_;
			gchar _tmp32_;
#line 224 "puzzle-view.vala"
			_tmp30_ = new_piece_id;
#line 224 "puzzle-view.vala"
			_tmp31_ = puzzle_view_get_piece_id (self);
#line 224 "puzzle-view.vala"
			_tmp32_ = _tmp31_;
#line 224 "puzzle-view.vala"
			_tmp22_ = _tmp30_ == _tmp32_;
#line 1257 "puzzle-view.c"
		}
#line 223 "puzzle-view.vala"
		if (_tmp22_) {
#line 225 "puzzle-view.vala"
			result = FALSE;
#line 225 "puzzle-view.vala"
			return result;
#line 1265 "puzzle-view.c"
		}
#line 227 "puzzle-view.vala"
		self->priv->piece_unmoved = TRUE;
#line 228 "puzzle-view.vala"
		_tmp33_ = new_piece_id;
#line 228 "puzzle-view.vala"
		puzzle_view_set_piece_id (self, _tmp33_);
#line 229 "puzzle-view.vala"
		_tmp34_ = puzzle_view_get_puzzle (self);
#line 229 "puzzle-view.vala"
		_tmp35_ = _tmp34_;
#line 229 "puzzle-view.vala"
		_tmp36_ = puzzle_view_get_puzzle (self);
#line 229 "puzzle-view.vala"
		_tmp37_ = _tmp36_;
#line 229 "puzzle-view.vala"
		_tmp38_ = _tmp37_->map;
#line 229 "puzzle-view.vala"
		_tmp38__length1 = _tmp37_->map_length1;
#line 229 "puzzle-view.vala"
		_tmp39_ = (_tmp38_ != NULL) ? _vala_array_dup7 (_tmp38_, _tmp38__length1) : ((gpointer) _tmp38_);
#line 229 "puzzle-view.vala"
		_tmp39__length1 = _tmp38__length1;
#line 229 "puzzle-view.vala"
		_tmp35_->move_map = (g_free (_tmp35_->move_map), NULL);
#line 229 "puzzle-view.vala"
		_tmp35_->move_map = _tmp39_;
#line 229 "puzzle-view.vala"
		_tmp35_->move_map_length1 = _tmp39__length1;
#line 1295 "puzzle-view.c"
	}
#line 232 "puzzle-view.vala"
	result = FALSE;
#line 232 "puzzle-view.vala"
	return result;
#line 1301 "puzzle-view.c"
}


static gchar*
_vala_array_dup8 (gchar* self,
                  int length)
{
#line 246 "puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1311 "puzzle-view.c"
}


static gchar*
_vala_array_dup9 (gchar* self,
                  int length)
{
#line 259 "puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1321 "puzzle-view.c"
}


static gboolean
puzzle_view_real_button_release_event (GtkWidget* base,
                                       GdkEventButton* event)
{
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
#line 235 "puzzle-view.vala"
	self = (PuzzleView*) base;
#line 235 "puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 237 "puzzle-view.vala"
	_tmp1_ = event->button;
#line 237 "puzzle-view.vala"
	if (_tmp1_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1341 "puzzle-view.c"
		gchar _tmp2_;
		gchar _tmp3_;
#line 237 "puzzle-view.vala"
		_tmp2_ = puzzle_view_get_piece_id (self);
#line 237 "puzzle-view.vala"
		_tmp3_ = _tmp2_;
#line 237 "puzzle-view.vala"
		_tmp0_ = _tmp3_ != '\0';
#line 1350 "puzzle-view.c"
	} else {
#line 237 "puzzle-view.vala"
		_tmp0_ = FALSE;
#line 1354 "puzzle-view.c"
	}
#line 237 "puzzle-view.vala"
	if (_tmp0_) {
#line 1358 "puzzle-view.c"
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
		Puzzle* _tmp6_;
		Puzzle* _tmp7_;
		gchar _tmp8_;
		gchar _tmp9_;
#line 239 "puzzle-view.vala"
		_tmp4_ = self->priv->piece_unmoved;
#line 239 "puzzle-view.vala"
		if (_tmp4_) {
#line 240 "puzzle-view.vala"
			result = FALSE;
#line 240 "puzzle-view.vala"
			return result;
#line 1373 "puzzle-view.c"
		}
#line 242 "puzzle-view.vala"
		_tmp6_ = puzzle_view_get_puzzle (self);
#line 242 "puzzle-view.vala"
		_tmp7_ = _tmp6_;
#line 242 "puzzle-view.vala"
		_tmp8_ = puzzle_view_get_piece_id (self);
#line 242 "puzzle-view.vala"
		_tmp9_ = _tmp8_;
#line 242 "puzzle-view.vala"
		if (puzzle_movable (_tmp7_, (gint) _tmp9_)) {
#line 1385 "puzzle-view.c"
			Puzzle* _tmp10_;
			Puzzle* _tmp11_;
			Puzzle* _tmp12_;
			Puzzle* _tmp13_;
			gchar* _tmp14_;
			gint _tmp14__length1;
			Puzzle* _tmp15_;
			Puzzle* _tmp16_;
			gchar* _tmp17_;
			gint _tmp17__length1;
#line 242 "puzzle-view.vala"
			_tmp10_ = puzzle_view_get_puzzle (self);
#line 242 "puzzle-view.vala"
			_tmp11_ = _tmp10_;
#line 242 "puzzle-view.vala"
			_tmp12_ = puzzle_view_get_puzzle (self);
#line 242 "puzzle-view.vala"
			_tmp13_ = _tmp12_;
#line 242 "puzzle-view.vala"
			_tmp14_ = _tmp13_->move_map;
#line 242 "puzzle-view.vala"
			_tmp14__length1 = _tmp13_->move_map_length1;
#line 242 "puzzle-view.vala"
			_tmp15_ = puzzle_view_get_puzzle (self);
#line 242 "puzzle-view.vala"
			_tmp16_ = _tmp15_;
#line 242 "puzzle-view.vala"
			_tmp17_ = _tmp16_->map;
#line 242 "puzzle-view.vala"
			_tmp17__length1 = _tmp16_->map_length1;
#line 242 "puzzle-view.vala"
			_tmp5_ = puzzle_mapcmp (_tmp11_, _tmp14_, _tmp14__length1, _tmp17_, _tmp17__length1);
#line 1418 "puzzle-view.c"
		} else {
#line 242 "puzzle-view.vala"
			_tmp5_ = FALSE;
#line 1422 "puzzle-view.c"
		}
#line 242 "puzzle-view.vala"
		if (_tmp5_) {
#line 1426 "puzzle-view.c"
			gboolean _tmp18_ = FALSE;
			gchar _tmp19_;
			gboolean _tmp35_ = FALSE;
			Puzzle* _tmp36_;
			Puzzle* _tmp37_;
			gint _tmp38_;
			Puzzle* _tmp52_;
			Puzzle* _tmp53_;
			Puzzle* _tmp54_;
			Puzzle* _tmp55_;
			gchar* _tmp56_;
			gint _tmp56__length1;
			gchar* _tmp57_;
			gint _tmp57__length1;
			Puzzle* _tmp58_;
			Puzzle* _tmp59_;
#line 244 "puzzle-view.vala"
			_tmp19_ = self->priv->last_piece_id;
#line 244 "puzzle-view.vala"
			if (_tmp19_ == '\0') {
#line 244 "puzzle-view.vala"
				_tmp18_ = TRUE;
#line 1449 "puzzle-view.c"
			} else {
				gchar _tmp20_;
				gchar _tmp21_;
				gchar _tmp22_;
#line 244 "puzzle-view.vala"
				_tmp20_ = self->priv->last_piece_id;
#line 244 "puzzle-view.vala"
				_tmp21_ = puzzle_view_get_piece_id (self);
#line 244 "puzzle-view.vala"
				_tmp22_ = _tmp21_;
#line 244 "puzzle-view.vala"
				_tmp18_ = _tmp20_ != _tmp22_;
#line 1462 "puzzle-view.c"
			}
#line 244 "puzzle-view.vala"
			if (_tmp18_) {
#line 1466 "puzzle-view.c"
				Puzzle* _tmp23_;
				Puzzle* _tmp24_;
				Puzzle* _tmp25_;
				Puzzle* _tmp26_;
				gchar* _tmp27_;
				gint _tmp27__length1;
				gchar* _tmp28_;
				gint _tmp28__length1;
				Puzzle* _tmp29_;
				Puzzle* _tmp30_;
				gint _tmp31_;
#line 246 "puzzle-view.vala"
				_tmp23_ = puzzle_view_get_puzzle (self);
#line 246 "puzzle-view.vala"
				_tmp24_ = _tmp23_;
#line 246 "puzzle-view.vala"
				_tmp25_ = puzzle_view_get_puzzle (self);
#line 246 "puzzle-view.vala"
				_tmp26_ = _tmp25_;
#line 246 "puzzle-view.vala"
				_tmp27_ = _tmp26_->lastmove_map;
#line 246 "puzzle-view.vala"
				_tmp27__length1 = _tmp26_->lastmove_map_length1;
#line 246 "puzzle-view.vala"
				_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup8 (_tmp27_, _tmp27__length1) : ((gpointer) _tmp27_);
#line 246 "puzzle-view.vala"
				_tmp28__length1 = _tmp27__length1;
#line 246 "puzzle-view.vala"
				_tmp24_->undomove_map = (g_free (_tmp24_->undomove_map), NULL);
#line 246 "puzzle-view.vala"
				_tmp24_->undomove_map = _tmp28_;
#line 246 "puzzle-view.vala"
				_tmp24_->undomove_map_length1 = _tmp28__length1;
#line 247 "puzzle-view.vala"
				_tmp29_ = puzzle_view_get_puzzle (self);
#line 247 "puzzle-view.vala"
				_tmp30_ = _tmp29_;
#line 247 "puzzle-view.vala"
				_tmp31_ = _tmp30_->moves;
#line 247 "puzzle-view.vala"
				if (_tmp31_ < 999) {
#line 1508 "puzzle-view.c"
					Puzzle* _tmp32_;
					Puzzle* _tmp33_;
					gint _tmp34_;
#line 248 "puzzle-view.vala"
					_tmp32_ = puzzle_view_get_puzzle (self);
#line 248 "puzzle-view.vala"
					_tmp33_ = _tmp32_;
#line 248 "puzzle-view.vala"
					_tmp34_ = _tmp33_->moves;
#line 248 "puzzle-view.vala"
					_tmp33_->moves = _tmp34_ + 1;
#line 1520 "puzzle-view.c"
				}
			}
#line 251 "puzzle-view.vala"
			_tmp36_ = puzzle_view_get_puzzle (self);
#line 251 "puzzle-view.vala"
			_tmp37_ = _tmp36_;
#line 251 "puzzle-view.vala"
			_tmp38_ = _tmp37_->moves;
#line 251 "puzzle-view.vala"
			if (_tmp38_ > 0) {
#line 1531 "puzzle-view.c"
				Puzzle* _tmp39_;
				Puzzle* _tmp40_;
				Puzzle* _tmp41_;
				Puzzle* _tmp42_;
				gchar* _tmp43_;
				gint _tmp43__length1;
				Puzzle* _tmp44_;
				Puzzle* _tmp45_;
				gchar* _tmp46_;
				gint _tmp46__length1;
#line 251 "puzzle-view.vala"
				_tmp39_ = puzzle_view_get_puzzle (self);
#line 251 "puzzle-view.vala"
				_tmp40_ = _tmp39_;
#line 251 "puzzle-view.vala"
				_tmp41_ = puzzle_view_get_puzzle (self);
#line 251 "puzzle-view.vala"
				_tmp42_ = _tmp41_;
#line 251 "puzzle-view.vala"
				_tmp43_ = _tmp42_->undomove_map;
#line 251 "puzzle-view.vala"
				_tmp43__length1 = _tmp42_->undomove_map_length1;
#line 251 "puzzle-view.vala"
				_tmp44_ = puzzle_view_get_puzzle (self);
#line 251 "puzzle-view.vala"
				_tmp45_ = _tmp44_;
#line 251 "puzzle-view.vala"
				_tmp46_ = _tmp45_->map;
#line 251 "puzzle-view.vala"
				_tmp46__length1 = _tmp45_->map_length1;
#line 251 "puzzle-view.vala"
				_tmp35_ = !puzzle_mapcmp (_tmp40_, _tmp43_, _tmp43__length1, _tmp46_, _tmp46__length1);
#line 1564 "puzzle-view.c"
			} else {
#line 251 "puzzle-view.vala"
				_tmp35_ = FALSE;
#line 1568 "puzzle-view.c"
			}
#line 251 "puzzle-view.vala"
			if (_tmp35_) {
#line 1572 "puzzle-view.c"
				Puzzle* _tmp47_;
				Puzzle* _tmp48_;
				gint _tmp49_;
#line 253 "puzzle-view.vala"
				_tmp47_ = puzzle_view_get_puzzle (self);
#line 253 "puzzle-view.vala"
				_tmp48_ = _tmp47_;
#line 253 "puzzle-view.vala"
				_tmp49_ = _tmp48_->moves;
#line 253 "puzzle-view.vala"
				_tmp48_->moves = _tmp49_ - 1;
#line 254 "puzzle-view.vala"
				self->priv->last_piece_id = '\0';
#line 1586 "puzzle-view.c"
			} else {
				gchar _tmp50_;
				gchar _tmp51_;
#line 257 "puzzle-view.vala"
				_tmp50_ = puzzle_view_get_piece_id (self);
#line 257 "puzzle-view.vala"
				_tmp51_ = _tmp50_;
#line 257 "puzzle-view.vala"
				self->priv->last_piece_id = _tmp51_;
#line 1596 "puzzle-view.c"
			}
#line 259 "puzzle-view.vala"
			_tmp52_ = puzzle_view_get_puzzle (self);
#line 259 "puzzle-view.vala"
			_tmp53_ = _tmp52_;
#line 259 "puzzle-view.vala"
			_tmp54_ = puzzle_view_get_puzzle (self);
#line 259 "puzzle-view.vala"
			_tmp55_ = _tmp54_;
#line 259 "puzzle-view.vala"
			_tmp56_ = _tmp55_->map;
#line 259 "puzzle-view.vala"
			_tmp56__length1 = _tmp55_->map_length1;
#line 259 "puzzle-view.vala"
			_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup9 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
#line 259 "puzzle-view.vala"
			_tmp57__length1 = _tmp56__length1;
#line 259 "puzzle-view.vala"
			_tmp53_->lastmove_map = (g_free (_tmp53_->lastmove_map), NULL);
#line 259 "puzzle-view.vala"
			_tmp53_->lastmove_map = _tmp57_;
#line 259 "puzzle-view.vala"
			_tmp53_->lastmove_map_length1 = _tmp57__length1;
#line 261 "puzzle-view.vala"
			_tmp58_ = puzzle_view_get_puzzle (self);
#line 261 "puzzle-view.vala"
			_tmp59_ = _tmp58_;
#line 261 "puzzle-view.vala"
			g_signal_emit_by_name (_tmp59_, "moved");
#line 1626 "puzzle-view.c"
		}
#line 263 "puzzle-view.vala"
		puzzle_view_set_piece_id (self, '\0');
#line 1630 "puzzle-view.c"
	}
#line 266 "puzzle-view.vala"
	result = FALSE;
#line 266 "puzzle-view.vala"
	return result;
#line 1636 "puzzle-view.c"
}


static gboolean
puzzle_view_real_motion_notify_event (GtkWidget* base,
                                      GdkEventMotion* event)
{
	PuzzleView * self;
	gboolean result = FALSE;
	gint new_piece_x = 0;
	gint new_piece_y = 0;
	gchar _tmp0_;
	gchar _tmp1_;
#line 269 "puzzle-view.vala"
	self = (PuzzleView*) base;
#line 269 "puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 273 "puzzle-view.vala"
	_tmp0_ = puzzle_view_get_piece_id (self);
#line 273 "puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 273 "puzzle-view.vala"
	if (_tmp1_ != '\0') {
#line 1660 "puzzle-view.c"
		gdouble _tmp2_;
		gdouble _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		Puzzle* _tmp14_;
		Puzzle* _tmp15_;
		gint _tmp16_;
		Puzzle* _tmp23_;
		Puzzle* _tmp24_;
		gchar _tmp25_;
		gchar _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
#line 275 "puzzle-view.vala"
		_tmp2_ = event->x;
#line 275 "puzzle-view.vala"
		_tmp3_ = self->priv->kx;
#line 275 "puzzle-view.vala"
		_tmp4_ = puzzle_view_get_tile_size (self);
#line 275 "puzzle-view.vala"
		_tmp5_ = _tmp4_;
#line 275 "puzzle-view.vala"
		new_piece_x = ((gint) (_tmp2_ - _tmp3_)) / _tmp5_;
#line 276 "puzzle-view.vala"
		_tmp6_ = event->y;
#line 276 "puzzle-view.vala"
		_tmp7_ = self->priv->ky;
#line 276 "puzzle-view.vala"
		_tmp8_ = puzzle_view_get_tile_size (self);
#line 276 "puzzle-view.vala"
		_tmp9_ = _tmp8_;
#line 276 "puzzle-view.vala"
		new_piece_y = ((gint) (_tmp6_ - _tmp7_)) / _tmp9_;
#line 277 "puzzle-view.vala"
		_tmp13_ = new_piece_x;
#line 277 "puzzle-view.vala"
		_tmp14_ = puzzle_view_get_puzzle (self);
#line 277 "puzzle-view.vala"
		_tmp15_ = _tmp14_;
#line 277 "puzzle-view.vala"
		_tmp16_ = _tmp15_->width;
#line 277 "puzzle-view.vala"
		if (_tmp13_ >= _tmp16_) {
#line 277 "puzzle-view.vala"
			_tmp12_ = TRUE;
#line 1716 "puzzle-view.c"
		} else {
			gdouble _tmp17_;
#line 277 "puzzle-view.vala"
			_tmp17_ = event->x;
#line 277 "puzzle-view.vala"
			_tmp12_ = _tmp17_ < ((gdouble) 0);
#line 1723 "puzzle-view.c"
		}
#line 277 "puzzle-view.vala"
		if (_tmp12_) {
#line 277 "puzzle-view.vala"
			_tmp11_ = TRUE;
#line 1729 "puzzle-view.c"
		} else {
			gint _tmp18_;
			Puzzle* _tmp19_;
			Puzzle* _tmp20_;
			gint _tmp21_;
#line 277 "puzzle-view.vala"
			_tmp18_ = new_piece_y;
#line 277 "puzzle-view.vala"
			_tmp19_ = puzzle_view_get_puzzle (self);
#line 277 "puzzle-view.vala"
			_tmp20_ = _tmp19_;
#line 277 "puzzle-view.vala"
			_tmp21_ = _tmp20_->height;
#line 277 "puzzle-view.vala"
			_tmp11_ = _tmp18_ >= _tmp21_;
#line 1745 "puzzle-view.c"
		}
#line 277 "puzzle-view.vala"
		if (_tmp11_) {
#line 277 "puzzle-view.vala"
			_tmp10_ = TRUE;
#line 1751 "puzzle-view.c"
		} else {
			gdouble _tmp22_;
#line 277 "puzzle-view.vala"
			_tmp22_ = event->y;
#line 277 "puzzle-view.vala"
			_tmp10_ = _tmp22_ < ((gdouble) 0);
#line 1758 "puzzle-view.c"
		}
#line 277 "puzzle-view.vala"
		if (_tmp10_) {
#line 278 "puzzle-view.vala"
			result = FALSE;
#line 278 "puzzle-view.vala"
			return result;
#line 1766 "puzzle-view.c"
		}
#line 279 "puzzle-view.vala"
		_tmp23_ = puzzle_view_get_puzzle (self);
#line 279 "puzzle-view.vala"
		_tmp24_ = _tmp23_;
#line 279 "puzzle-view.vala"
		_tmp25_ = puzzle_view_get_piece_id (self);
#line 279 "puzzle-view.vala"
		_tmp26_ = _tmp25_;
#line 279 "puzzle-view.vala"
		_tmp27_ = self->priv->piece_x;
#line 279 "puzzle-view.vala"
		_tmp28_ = self->priv->piece_y;
#line 279 "puzzle-view.vala"
		_tmp29_ = new_piece_x;
#line 279 "puzzle-view.vala"
		_tmp30_ = new_piece_y;
#line 279 "puzzle-view.vala"
		if (puzzle_move_piece (_tmp24_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_)) {
#line 1786 "puzzle-view.c"
			gint _tmp31_;
			gint _tmp32_;
#line 281 "puzzle-view.vala"
			self->priv->piece_unmoved = FALSE;
#line 282 "puzzle-view.vala"
			_tmp31_ = new_piece_x;
#line 282 "puzzle-view.vala"
			self->priv->piece_x = _tmp31_;
#line 283 "puzzle-view.vala"
			_tmp32_ = new_piece_y;
#line 283 "puzzle-view.vala"
			self->priv->piece_y = _tmp32_;
#line 1799 "puzzle-view.c"
		}
#line 285 "puzzle-view.vala"
		result = TRUE;
#line 285 "puzzle-view.vala"
		return result;
#line 1805 "puzzle-view.c"
	}
#line 288 "puzzle-view.vala"
	result = FALSE;
#line 288 "puzzle-view.vala"
	return result;
#line 1811 "puzzle-view.c"
}


static void
puzzle_view_puzzle_changed_cb (PuzzleView* self)
{
#line 291 "puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 293 "puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1822 "puzzle-view.c"
}


static gchar
puzzle_view_get_piece_id (PuzzleView* self)
{
	gchar result;
	gchar _tmp0_;
#line 29 "puzzle-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 29 "puzzle-view.vala"
	_tmp0_ = self->priv->_piece_id;
#line 29 "puzzle-view.vala"
	result = _tmp0_;
#line 29 "puzzle-view.vala"
	return result;
#line 1839 "puzzle-view.c"
}


static void
puzzle_view_set_piece_id (PuzzleView* self,
                          gchar value)
{
#line 30 "puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 30 "puzzle-view.vala"
	self->priv->_piece_id = value;
#line 30 "puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1853 "puzzle-view.c"
}


Puzzle*
puzzle_view_get_puzzle (PuzzleView* self)
{
	Puzzle* result;
	Puzzle* _tmp0_;
#line 45 "puzzle-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 45 "puzzle-view.vala"
	result = _tmp0_;
#line 45 "puzzle-view.vala"
	return result;
#line 1870 "puzzle-view.c"
}


static void
_puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender,
                                               gpointer self)
{
#line 51 "puzzle-view.vala"
	puzzle_view_puzzle_changed_cb ((PuzzleView*) self);
#line 1880 "puzzle-view.c"
}


void
puzzle_view_set_puzzle (PuzzleView* self,
                        Puzzle* value)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp2_;
	Puzzle* _tmp3_;
#line 46 "puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 48 "puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 48 "puzzle-view.vala"
	if (_tmp0_ != NULL) {
#line 1897 "puzzle-view.c"
		Puzzle* _tmp1_;
#line 49 "puzzle-view.vala"
		_tmp1_ = self->priv->_puzzle;
#line 49 "puzzle-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1903 "puzzle-view.c"
	}
#line 50 "puzzle-view.vala"
	_tmp2_ = _g_object_ref0 (value);
#line 50 "puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 50 "puzzle-view.vala"
	self->priv->_puzzle = _tmp2_;
#line 51 "puzzle-view.vala"
	_tmp3_ = self->priv->_puzzle;
#line 51 "puzzle-view.vala"
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _puzzle_view_puzzle_changed_cb_puzzle_changed, self, 0);
#line 52 "puzzle-view.vala"
	self->priv->piece_x = 0;
#line 53 "puzzle-view.vala"
	self->priv->piece_y = 0;
#line 54 "puzzle-view.vala"
	puzzle_view_set_piece_id (self, '\0');
#line 55 "puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 46 "puzzle-view.vala"
	g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_PUZZLE_PROPERTY]);
#line 1925 "puzzle-view.c"
}


static gint
puzzle_view_get_tile_size (PuzzleView* self)
{
	gint result;
	gint s = 0;
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gint _tmp2_;
	Puzzle* _tmp3_;
	Puzzle* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp8_;
#line 61 "puzzle-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "puzzle-view.vala"
	_tmp0_ = puzzle_view_get_puzzle (self);
#line 63 "puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 63 "puzzle-view.vala"
	_tmp2_ = _tmp1_->width;
#line 63 "puzzle-view.vala"
	_tmp3_ = puzzle_view_get_puzzle (self);
#line 63 "puzzle-view.vala"
	_tmp4_ = _tmp3_;
#line 63 "puzzle-view.vala"
	_tmp5_ = _tmp4_->height;
#line 63 "puzzle-view.vala"
	s = MIN ((gtk_widget_get_allocated_width ((GtkWidget*) self) - PUZZLE_VIEW_SPACE_PADDING) / _tmp2_, (gtk_widget_get_allocated_height ((GtkWidget*) self) - PUZZLE_VIEW_SPACE_PADDING) / _tmp5_);
#line 65 "puzzle-view.vala"
	_tmp6_ = s;
#line 65 "puzzle-view.vala"
	if ((_tmp6_ % 2) != 0) {
#line 1962 "puzzle-view.c"
		gint _tmp7_;
#line 66 "puzzle-view.vala"
		_tmp7_ = s;
#line 66 "puzzle-view.vala"
		s = _tmp7_ - 1;
#line 1968 "puzzle-view.c"
	}
#line 67 "puzzle-view.vala"
	_tmp8_ = s;
#line 67 "puzzle-view.vala"
	result = _tmp8_;
#line 67 "puzzle-view.vala"
	return result;
#line 1976 "puzzle-view.c"
}


static void
puzzle_view_class_init (PuzzleViewClass * klass)
{
#line 11 "puzzle-view.vala"
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
#line 11 "puzzle-view.vala"
	g_type_class_adjust_private_offset (klass, &PuzzleView_private_offset);
#line 11 "puzzle-view.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) puzzle_view_real_draw;
#line 11 "puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) puzzle_view_real_button_press_event;
#line 11 "puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) puzzle_view_real_button_release_event;
#line 11 "puzzle-view.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget *, GdkEventMotion*)) puzzle_view_real_motion_notify_event;
#line 11 "puzzle-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
#line 11 "puzzle-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
#line 11 "puzzle-view.vala"
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
#line 11 "puzzle-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_PUZZLE_PROPERTY] = g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2003 "puzzle-view.c"
}


static void
puzzle_view_instance_init (PuzzleView * self)
{
	gchar* _tmp0_;
#line 11 "puzzle-view.vala"
	self->priv = puzzle_view_get_instance_private (self);
#line 20 "puzzle-view.vala"
	self->priv->render_size = 0;
#line 22 "puzzle-view.vala"
	self->priv->piece_x = 0;
#line 23 "puzzle-view.vala"
	self->priv->piece_y = 0;
#line 24 "puzzle-view.vala"
	self->priv->piece_unmoved = FALSE;
#line 26 "puzzle-view.vala"
	self->priv->_piece_id = '\0';
#line 33 "puzzle-view.vala"
	self->priv->last_piece_id = '\0';
#line 35 "puzzle-view.vala"
	self->priv->kx = (gdouble) 0;
#line 36 "puzzle-view.vala"
	self->priv->ky = (gdouble) 0;
#line 38 "puzzle-view.vala"
	self->priv->tiles_handle = NULL;
#line 39 "puzzle-view.vala"
	_tmp0_ = g_strdup ("");
#line 39 "puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 40 "puzzle-view.vala"
	self->priv->surface = NULL;
#line 42 "puzzle-view.vala"
	self->priv->_puzzle = NULL;
#line 2039 "puzzle-view.c"
}


static void
puzzle_view_finalize (GObject * obj)
{
	PuzzleView * self;
#line 11 "puzzle-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
#line 38 "puzzle-view.vala"
	_g_object_unref0 (self->priv->tiles_handle);
#line 39 "puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 40 "puzzle-view.vala"
	_cairo_surface_destroy0 (self->priv->surface);
#line 42 "puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 11 "puzzle-view.vala"
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
#line 2059 "puzzle-view.c"
}


GType
puzzle_view_get_type (void)
{
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PuzzleView", &g_define_type_info, 0);
		PuzzleView_private_offset = g_type_add_instance_private (puzzle_view_type_id, sizeof (PuzzleViewPrivate));
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void
_vala_puzzle_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "puzzle-view.vala"
	switch (property_id) {
#line 11 "puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
#line 11 "puzzle-view.vala"
		g_value_set_object (value, puzzle_view_get_puzzle (self));
#line 11 "puzzle-view.vala"
		break;
#line 2094 "puzzle-view.c"
		default:
#line 11 "puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "puzzle-view.vala"
		break;
#line 2100 "puzzle-view.c"
	}
}


static void
_vala_puzzle_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "puzzle-view.vala"
	switch (property_id) {
#line 11 "puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
#line 11 "puzzle-view.vala"
		puzzle_view_set_puzzle (self, g_value_get_object (value));
#line 11 "puzzle-view.vala"
		break;
#line 2121 "puzzle-view.c"
		default:
#line 11 "puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "puzzle-view.vala"
		break;
#line 2127 "puzzle-view.c"
	}
}



