// This file is part of GNOME Games. License: GPL-3.0+.

public class Games.MediaSet : Object {
	public delegate void MediaCallback (Media media);

	public int selected_media_number { get; set; default = 0; }
	public string icon_name { get; set; }

	private Media[] medias;

	public void add_media (Media media) {
		medias += media;
	}

	public int get_size () {
		return medias.length;
	}

	public Media get_selected_media (uint index) throws Error {
		return get_media (selected_media_number);
	}

	public void foreach_media (MediaCallback media_callback) {
		foreach (var media in medias)
			media_callback (media);
	}

	private Media get_media (uint index) throws Error {
		if (index >= medias.length)
			throw new MediaSetError.NOT_A_MEDIA (_("Invalid media index %u."), index);

		return medias[index];
	}
}
