/* puzzle-generator.c generated by valac 0.15.0, the Vala compiler
 * generated from puzzle-generator.vala, do not modify */

/* Puzzle generation logic:*/
/* We want to measure a puzzle's difficulty by the number of button presses*/
/* needed to solve it, and have that increase in a controlled manner.*/
/**/
/* Lights Off can be seen as a linear algebra problem over the field GF(2).*/
/* (See e.g. the first page of "Turning Lights Out with Linear Algebra".)*/
/* The linear map from button-press strategies to light configurations*/
/* will in general have a nullspace (of dimension n).*/
/* Thus, any solvable puzzle has 2^n solutions, given by a fixed solution*/
/* plus an element of the nullspace.*/
/* A solution is thus optimal if it presses at most half the buttons*/
/* which make up any element of the nullspace.*/
/**/
/* A basis for the nullspace splits the board into (up to) 2^n regions,*/
/* defined by which basic nullspace elements include a given button.*/
/* (This determines which nullspace elements include the same button.)*/
/* Thus, a solution is optimal if it includes at most half the buttons in any*/
/* region (except the region lying outside all null-sets).*/
/* The converse is not true, but (at least if the regions are even-sized)*/
/* does hold for a large number of puzzles up to the highest difficulty level.*/
/* (Certainly, on average, at most half the lights which belong to at least*/
/* one null set may be used.)*/

#include <glib.h>
#include <glib-object.h>
#include <math.h>
#include <float.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
typedef struct _PuzzleGeneratorPrivate PuzzleGeneratorPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecPuzzleGenerator ParamSpecPuzzleGenerator;

struct _PuzzleGenerator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PuzzleGeneratorPrivate * priv;
};

struct _PuzzleGeneratorClass {
	GTypeClass parent_class;
	void (*finalize) (PuzzleGenerator *self);
};

struct _PuzzleGeneratorPrivate {
	gint size;
	gint max_solution_length;
	gint* region_of;
	gint region_of_length1;
	gint _region_of_size_;
	gint* region_size;
	gint region_size_length1;
	gint _region_size_size_;
};

struct _ParamSpecPuzzleGenerator {
	GParamSpec parent_instance;
};


static gpointer puzzle_generator_parent_class = NULL;

gpointer puzzle_generator_ref (gpointer instance);
void puzzle_generator_unref (gpointer instance);
GParamSpec* param_spec_puzzle_generator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle_generator (GValue* value, gpointer v_object);
void value_take_puzzle_generator (GValue* value, gpointer v_object);
gpointer value_get_puzzle_generator (const GValue* value);
GType puzzle_generator_get_type (void) G_GNUC_CONST;
#define PUZZLE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorPrivate))
enum  {
	PUZZLE_GENERATOR_DUMMY_PROPERTY
};
PuzzleGenerator* puzzle_generator_new (gint size);
PuzzleGenerator* puzzle_generator_construct (GType object_type, gint size);
gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self, gint solution_length, int* result_length1, int* result_length2);
static void puzzle_generator_finalize (PuzzleGenerator* obj);


PuzzleGenerator* puzzle_generator_construct (GType object_type, gint size) {
	PuzzleGenerator* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint* _tmp5_ = NULL;
	gint* adj_matrix;
	gint adj_matrix_length1;
	gint adj_matrix_length2;
	GList* non_pivot_cols;
	gint ipiv;
	GList* _tmp114_;
	guint _tmp115_ = 0U;
	gint _tmp116_;
	gint _tmp117_;
	gint* _tmp118_ = NULL;
	gint* basis_for_ns;
	gint basis_for_ns_length1;
	gint basis_for_ns_length2;
	gint n;
	GList* _tmp119_;
	GList* _tmp173_;
	guint _tmp174_ = 0U;
	gint* _tmp175_ = NULL;
	gint _tmp184_;
	gint _tmp185_;
	gint* _tmp186_ = NULL;
	gint* _tmp215_;
	gint _tmp215__length1;
	gint _tmp216_;
	self = (PuzzleGenerator*) g_type_create_instance (object_type);
	_tmp0_ = size;
	self->priv->size = _tmp0_;
	_tmp1_ = size;
	_tmp2_ = size;
	_tmp3_ = size;
	_tmp4_ = size;
	_tmp5_ = g_new0 (gint, (_tmp1_ * _tmp2_) * (_tmp3_ * _tmp4_));
	adj_matrix = _tmp5_;
	adj_matrix_length1 = _tmp1_ * _tmp2_;
	adj_matrix_length2 = _tmp3_ * _tmp4_;
	{
		gint x0;
		x0 = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gint _tmp9_;
				gint _tmp10_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = x0;
					x0 = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = x0;
				_tmp10_ = size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				{
					gint y0;
					y0 = 0;
					{
						gboolean _tmp11_;
						_tmp11_ = TRUE;
						while (TRUE) {
							gboolean _tmp12_;
							gint _tmp14_;
							gint _tmp15_;
							_tmp12_ = _tmp11_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = y0;
								y0 = _tmp13_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp14_ = y0;
							_tmp15_ = size;
							if (!(_tmp14_ < _tmp15_)) {
								break;
							}
							{
								gint x1;
								x1 = 0;
								{
									gboolean _tmp16_;
									_tmp16_ = TRUE;
									while (TRUE) {
										gboolean _tmp17_;
										gint _tmp19_;
										gint _tmp20_;
										_tmp17_ = _tmp16_;
										if (!_tmp17_) {
											gint _tmp18_;
											_tmp18_ = x1;
											x1 = _tmp18_ + 1;
										}
										_tmp16_ = FALSE;
										_tmp19_ = x1;
										_tmp20_ = size;
										if (!(_tmp19_ < _tmp20_)) {
											break;
										}
										{
											gint y1;
											y1 = 0;
											{
												gboolean _tmp21_;
												_tmp21_ = TRUE;
												while (TRUE) {
													gboolean _tmp22_;
													gint _tmp24_;
													gint _tmp25_;
													gint _tmp26_;
													gint _tmp27_;
													gint dx;
													gint _tmp28_;
													gint _tmp29_;
													gint dy;
													gint _tmp30_ = 0;
													gint _tmp31_;
													gint _tmp32_;
													gint _tmp33_;
													gint _tmp34_;
													gint* _tmp35_;
													gint _tmp35__length1;
													gint _tmp35__length2;
													gint _tmp36_;
													gint _tmp37_;
													gint _tmp38_;
													gint _tmp39_;
													gint _tmp40_;
													gint _tmp41_;
													gint _tmp42_;
													gint _tmp43_;
													_tmp22_ = _tmp21_;
													if (!_tmp22_) {
														gint _tmp23_;
														_tmp23_ = y1;
														y1 = _tmp23_ + 1;
													}
													_tmp21_ = FALSE;
													_tmp24_ = y1;
													_tmp25_ = size;
													if (!(_tmp24_ < _tmp25_)) {
														break;
													}
													_tmp26_ = x0;
													_tmp27_ = x1;
													dx = _tmp26_ - _tmp27_;
													_tmp28_ = y0;
													_tmp29_ = y1;
													dy = _tmp28_ - _tmp29_;
													_tmp31_ = dx;
													_tmp32_ = dx;
													_tmp33_ = dy;
													_tmp34_ = dy;
													if (((_tmp31_ * _tmp32_) + (_tmp33_ * _tmp34_)) <= 1) {
														_tmp30_ = 1;
													} else {
														_tmp30_ = 0;
													}
													_tmp35_ = adj_matrix;
													_tmp35__length1 = adj_matrix_length1;
													_tmp35__length2 = adj_matrix_length2;
													_tmp36_ = x0;
													_tmp37_ = size;
													_tmp38_ = y0;
													_tmp39_ = x1;
													_tmp40_ = size;
													_tmp41_ = y1;
													_tmp42_ = _tmp30_;
													_tmp35_[(((_tmp36_ * _tmp37_) + _tmp38_) * _tmp35__length2) + ((_tmp39_ * _tmp40_) + _tmp41_)] = _tmp42_;
													_tmp43_ = _tmp35_[(((_tmp36_ * _tmp37_) + _tmp38_) * _tmp35__length2) + ((_tmp39_ * _tmp40_) + _tmp41_)];
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	non_pivot_cols = NULL;
	ipiv = 0;
	{
		gint jpiv;
		jpiv = 0;
		{
			gboolean _tmp44_;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gboolean is_pivot_col;
				gboolean _tmp112_;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = jpiv;
					jpiv = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = jpiv;
				_tmp48_ = size;
				_tmp49_ = size;
				if (!(_tmp47_ < (_tmp48_ * _tmp49_))) {
					break;
				}
				is_pivot_col = FALSE;
				{
					gint _tmp50_;
					gint i;
					_tmp50_ = ipiv;
					i = _tmp50_;
					{
						gboolean _tmp51_;
						_tmp51_ = TRUE;
						while (TRUE) {
							gboolean _tmp52_;
							gint _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
							gint* _tmp57_;
							gint _tmp57__length1;
							gint _tmp57__length2;
							gint _tmp58_;
							gint _tmp59_;
							gint _tmp60_;
							_tmp52_ = _tmp51_;
							if (!_tmp52_) {
								gint _tmp53_;
								_tmp53_ = i;
								i = _tmp53_ + 1;
							}
							_tmp51_ = FALSE;
							_tmp54_ = i;
							_tmp55_ = size;
							_tmp56_ = size;
							if (!(_tmp54_ < (_tmp55_ * _tmp56_))) {
								break;
							}
							_tmp57_ = adj_matrix;
							_tmp57__length1 = adj_matrix_length1;
							_tmp57__length2 = adj_matrix_length2;
							_tmp58_ = i;
							_tmp59_ = jpiv;
							_tmp60_ = _tmp57_[(_tmp58_ * _tmp57__length2) + _tmp59_];
							if (_tmp60_ != 0) {
								gint _tmp61_;
								gint _tmp62_;
								gint _tmp111_;
								_tmp61_ = i;
								_tmp62_ = ipiv;
								if (_tmp61_ != _tmp62_) {
									{
										gint z;
										z = 0;
										{
											gboolean _tmp63_;
											_tmp63_ = TRUE;
											while (TRUE) {
												gboolean _tmp64_;
												gint _tmp66_;
												gint _tmp67_;
												gint _tmp68_;
												gint* _tmp69_;
												gint _tmp69__length1;
												gint _tmp69__length2;
												gint _tmp70_;
												gint _tmp71_;
												gint _tmp72_;
												gint t;
												gint* _tmp73_;
												gint _tmp73__length1;
												gint _tmp73__length2;
												gint _tmp74_;
												gint _tmp75_;
												gint* _tmp76_;
												gint _tmp76__length1;
												gint _tmp76__length2;
												gint _tmp77_;
												gint _tmp78_;
												gint _tmp79_;
												gint _tmp80_;
												gint* _tmp81_;
												gint _tmp81__length1;
												gint _tmp81__length2;
												gint _tmp82_;
												gint _tmp83_;
												gint _tmp84_;
												gint _tmp85_;
												_tmp64_ = _tmp63_;
												if (!_tmp64_) {
													gint _tmp65_;
													_tmp65_ = z;
													z = _tmp65_ + 1;
												}
												_tmp63_ = FALSE;
												_tmp66_ = z;
												_tmp67_ = size;
												_tmp68_ = size;
												if (!(_tmp66_ < (_tmp67_ * _tmp68_))) {
													break;
												}
												_tmp69_ = adj_matrix;
												_tmp69__length1 = adj_matrix_length1;
												_tmp69__length2 = adj_matrix_length2;
												_tmp70_ = i;
												_tmp71_ = z;
												_tmp72_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
												t = _tmp72_;
												_tmp73_ = adj_matrix;
												_tmp73__length1 = adj_matrix_length1;
												_tmp73__length2 = adj_matrix_length2;
												_tmp74_ = i;
												_tmp75_ = z;
												_tmp76_ = adj_matrix;
												_tmp76__length1 = adj_matrix_length1;
												_tmp76__length2 = adj_matrix_length2;
												_tmp77_ = ipiv;
												_tmp78_ = z;
												_tmp79_ = _tmp76_[(_tmp77_ * _tmp76__length2) + _tmp78_];
												_tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_] = _tmp79_;
												_tmp80_ = _tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_];
												_tmp81_ = adj_matrix;
												_tmp81__length1 = adj_matrix_length1;
												_tmp81__length2 = adj_matrix_length2;
												_tmp82_ = ipiv;
												_tmp83_ = z;
												_tmp84_ = t;
												_tmp81_[(_tmp82_ * _tmp81__length2) + _tmp83_] = _tmp84_;
												_tmp85_ = _tmp81_[(_tmp82_ * _tmp81__length2) + _tmp83_];
											}
										}
									}
								}
								{
									gint _tmp86_;
									gint j;
									_tmp86_ = ipiv;
									j = _tmp86_ + 1;
									{
										gboolean _tmp87_;
										_tmp87_ = TRUE;
										while (TRUE) {
											gboolean _tmp88_;
											gint _tmp90_;
											gint _tmp91_;
											gint _tmp92_;
											gint* _tmp93_;
											gint _tmp93__length1;
											gint _tmp93__length2;
											gint _tmp94_;
											gint _tmp95_;
											gint _tmp96_;
											_tmp88_ = _tmp87_;
											if (!_tmp88_) {
												gint _tmp89_;
												_tmp89_ = j;
												j = _tmp89_ + 1;
											}
											_tmp87_ = FALSE;
											_tmp90_ = j;
											_tmp91_ = size;
											_tmp92_ = size;
											if (!(_tmp90_ < (_tmp91_ * _tmp92_))) {
												break;
											}
											_tmp93_ = adj_matrix;
											_tmp93__length1 = adj_matrix_length1;
											_tmp93__length2 = adj_matrix_length2;
											_tmp94_ = j;
											_tmp95_ = jpiv;
											_tmp96_ = _tmp93_[(_tmp94_ * _tmp93__length2) + _tmp95_];
											if (_tmp96_ != 0) {
												{
													gint k;
													k = 0;
													{
														gboolean _tmp97_;
														_tmp97_ = TRUE;
														while (TRUE) {
															gboolean _tmp98_;
															gint _tmp100_;
															gint _tmp101_;
															gint _tmp102_;
															gint* _tmp103_;
															gint _tmp103__length1;
															gint _tmp103__length2;
															gint _tmp104_;
															gint _tmp105_;
															gint* _tmp106_;
															gint _tmp106__length1;
															gint _tmp106__length2;
															gint _tmp107_;
															gint _tmp108_;
															gint _tmp109_;
															gint _tmp110_;
															_tmp98_ = _tmp97_;
															if (!_tmp98_) {
																gint _tmp99_;
																_tmp99_ = k;
																k = _tmp99_ + 1;
															}
															_tmp97_ = FALSE;
															_tmp100_ = k;
															_tmp101_ = size;
															_tmp102_ = size;
															if (!(_tmp100_ < (_tmp101_ * _tmp102_))) {
																break;
															}
															_tmp103_ = adj_matrix;
															_tmp103__length1 = adj_matrix_length1;
															_tmp103__length2 = adj_matrix_length2;
															_tmp104_ = j;
															_tmp105_ = k;
															_tmp106_ = adj_matrix;
															_tmp106__length1 = adj_matrix_length1;
															_tmp106__length2 = adj_matrix_length2;
															_tmp107_ = ipiv;
															_tmp108_ = k;
															_tmp109_ = _tmp106_[(_tmp107_ * _tmp106__length2) + _tmp108_];
															_tmp103_[(_tmp104_ * _tmp103__length2) + _tmp105_] ^= _tmp109_;
															_tmp110_ = _tmp103_[(_tmp104_ * _tmp103__length2) + _tmp105_];
														}
													}
												}
											}
										}
									}
								}
								is_pivot_col = TRUE;
								_tmp111_ = ipiv;
								ipiv = _tmp111_ + 1;
								break;
							}
						}
					}
				}
				_tmp112_ = is_pivot_col;
				if (!_tmp112_) {
					gint _tmp113_;
					_tmp113_ = jpiv;
					non_pivot_cols = g_list_append (non_pivot_cols, GINT_TO_POINTER (_tmp113_));
				}
			}
		}
	}
	_tmp114_ = non_pivot_cols;
	_tmp115_ = g_list_length (_tmp114_);
	_tmp116_ = size;
	_tmp117_ = size;
	_tmp118_ = g_new0 (gint, _tmp115_ * (_tmp116_ * _tmp117_));
	basis_for_ns = _tmp118_;
	basis_for_ns_length1 = _tmp115_;
	basis_for_ns_length2 = _tmp116_ * _tmp117_;
	n = 0;
	_tmp119_ = non_pivot_cols;
	{
		GList* col_collection = NULL;
		GList* col_it = NULL;
		col_collection = _tmp119_;
		for (col_it = col_collection; col_it != NULL; col_it = col_it->next) {
			gint col = 0;
			col = GPOINTER_TO_INT (col_it->data);
			{
				gint* _tmp130_;
				gint _tmp130__length1;
				gint _tmp130__length2;
				gint _tmp131_;
				gint _tmp132_;
				gint _tmp133_;
				gint _tmp172_;
				{
					gint j;
					j = 0;
					{
						gboolean _tmp120_;
						_tmp120_ = TRUE;
						while (TRUE) {
							gboolean _tmp121_;
							gint _tmp123_;
							gint _tmp124_;
							gint _tmp125_;
							gint* _tmp126_;
							gint _tmp126__length1;
							gint _tmp126__length2;
							gint _tmp127_;
							gint _tmp128_;
							gint _tmp129_;
							_tmp121_ = _tmp120_;
							if (!_tmp121_) {
								gint _tmp122_;
								_tmp122_ = j;
								j = _tmp122_ + 1;
							}
							_tmp120_ = FALSE;
							_tmp123_ = j;
							_tmp124_ = size;
							_tmp125_ = size;
							if (!(_tmp123_ < (_tmp124_ * _tmp125_))) {
								break;
							}
							_tmp126_ = basis_for_ns;
							_tmp126__length1 = basis_for_ns_length1;
							_tmp126__length2 = basis_for_ns_length2;
							_tmp127_ = n;
							_tmp128_ = j;
							_tmp126_[(_tmp127_ * _tmp126__length2) + _tmp128_] = 0;
							_tmp129_ = _tmp126_[(_tmp127_ * _tmp126__length2) + _tmp128_];
						}
					}
				}
				_tmp130_ = basis_for_ns;
				_tmp130__length1 = basis_for_ns_length1;
				_tmp130__length2 = basis_for_ns_length2;
				_tmp131_ = n;
				_tmp132_ = col;
				_tmp130_[(_tmp131_ * _tmp130__length2) + _tmp132_] = 1;
				_tmp133_ = _tmp130_[(_tmp131_ * _tmp130__length2) + _tmp132_];
				{
					gint _tmp134_;
					gint _tmp135_;
					gint i;
					_tmp134_ = size;
					_tmp135_ = size;
					i = (_tmp134_ * _tmp135_) - 1;
					{
						gboolean _tmp136_;
						_tmp136_ = TRUE;
						while (TRUE) {
							gboolean _tmp137_;
							gint _tmp139_;
							gint jpiv;
							gint _tmp150_;
							gint _tmp151_;
							gint _tmp152_;
							_tmp137_ = _tmp136_;
							if (!_tmp137_) {
								gint _tmp138_;
								_tmp138_ = i;
								i = _tmp138_ - 1;
							}
							_tmp136_ = FALSE;
							_tmp139_ = i;
							if (!(_tmp139_ >= 0)) {
								break;
							}
							jpiv = 0;
							{
								gboolean _tmp140_;
								_tmp140_ = TRUE;
								while (TRUE) {
									gboolean _tmp141_;
									gint _tmp143_;
									gint _tmp144_;
									gint _tmp145_;
									gint* _tmp146_;
									gint _tmp146__length1;
									gint _tmp146__length2;
									gint _tmp147_;
									gint _tmp148_;
									gint _tmp149_;
									_tmp141_ = _tmp140_;
									if (!_tmp141_) {
										gint _tmp142_;
										_tmp142_ = jpiv;
										jpiv = _tmp142_ + 1;
									}
									_tmp140_ = FALSE;
									_tmp143_ = jpiv;
									_tmp144_ = size;
									_tmp145_ = size;
									if (!(_tmp143_ < (_tmp144_ * _tmp145_))) {
										break;
									}
									_tmp146_ = adj_matrix;
									_tmp146__length1 = adj_matrix_length1;
									_tmp146__length2 = adj_matrix_length2;
									_tmp147_ = i;
									_tmp148_ = jpiv;
									_tmp149_ = _tmp146_[(_tmp147_ * _tmp146__length2) + _tmp148_];
									if (_tmp149_ != 0) {
										break;
									}
								}
							}
							_tmp150_ = jpiv;
							_tmp151_ = size;
							_tmp152_ = size;
							if (_tmp150_ == (_tmp151_ * _tmp152_)) {
								continue;
							}
							{
								gint _tmp153_;
								gint j;
								_tmp153_ = jpiv;
								j = _tmp153_ + 1;
								{
									gboolean _tmp154_;
									_tmp154_ = TRUE;
									while (TRUE) {
										gboolean _tmp155_;
										gint _tmp157_;
										gint _tmp158_;
										gint _tmp159_;
										gint* _tmp160_;
										gint _tmp160__length1;
										gint _tmp160__length2;
										gint _tmp161_;
										gint _tmp162_;
										gint* _tmp163_;
										gint _tmp163__length1;
										gint _tmp163__length2;
										gint _tmp164_;
										gint _tmp165_;
										gint _tmp166_;
										gint* _tmp167_;
										gint _tmp167__length1;
										gint _tmp167__length2;
										gint _tmp168_;
										gint _tmp169_;
										gint _tmp170_;
										gint _tmp171_;
										_tmp155_ = _tmp154_;
										if (!_tmp155_) {
											gint _tmp156_;
											_tmp156_ = j;
											j = _tmp156_ + 1;
										}
										_tmp154_ = FALSE;
										_tmp157_ = j;
										_tmp158_ = size;
										_tmp159_ = size;
										if (!(_tmp157_ < (_tmp158_ * _tmp159_))) {
											break;
										}
										_tmp160_ = basis_for_ns;
										_tmp160__length1 = basis_for_ns_length1;
										_tmp160__length2 = basis_for_ns_length2;
										_tmp161_ = n;
										_tmp162_ = jpiv;
										_tmp163_ = adj_matrix;
										_tmp163__length1 = adj_matrix_length1;
										_tmp163__length2 = adj_matrix_length2;
										_tmp164_ = i;
										_tmp165_ = j;
										_tmp166_ = _tmp163_[(_tmp164_ * _tmp163__length2) + _tmp165_];
										_tmp167_ = basis_for_ns;
										_tmp167__length1 = basis_for_ns_length1;
										_tmp167__length2 = basis_for_ns_length2;
										_tmp168_ = n;
										_tmp169_ = j;
										_tmp170_ = _tmp167_[(_tmp168_ * _tmp167__length2) + _tmp169_];
										_tmp160_[(_tmp161_ * _tmp160__length2) + _tmp162_] ^= _tmp166_ * _tmp170_;
										_tmp171_ = _tmp160_[(_tmp161_ * _tmp160__length2) + _tmp162_];
									}
								}
							}
						}
					}
				}
				_tmp172_ = n;
				n = _tmp172_ + 1;
			}
		}
	}
	_tmp173_ = non_pivot_cols;
	_tmp174_ = g_list_length (_tmp173_);
	_tmp175_ = g_new0 (gint, 1 << _tmp174_);
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
	self->priv->region_size = _tmp175_;
	self->priv->region_size_length1 = 1 << _tmp174_;
	self->priv->_region_size_size_ = self->priv->region_size_length1;
	{
		gint j;
		j = 0;
		{
			gboolean _tmp176_;
			_tmp176_ = TRUE;
			while (TRUE) {
				gboolean _tmp177_;
				gint _tmp179_;
				gint* _tmp180_;
				gint _tmp180__length1;
				gint* _tmp181_;
				gint _tmp181__length1;
				gint _tmp182_;
				gint _tmp183_;
				_tmp177_ = _tmp176_;
				if (!_tmp177_) {
					gint _tmp178_;
					_tmp178_ = j;
					j = _tmp178_ + 1;
				}
				_tmp176_ = FALSE;
				_tmp179_ = j;
				_tmp180_ = self->priv->region_size;
				_tmp180__length1 = self->priv->region_size_length1;
				if (!(_tmp179_ < _tmp180__length1)) {
					break;
				}
				_tmp181_ = self->priv->region_size;
				_tmp181__length1 = self->priv->region_size_length1;
				_tmp182_ = j;
				_tmp181_[_tmp182_] = 0;
				_tmp183_ = _tmp181_[_tmp182_];
			}
		}
	}
	_tmp184_ = size;
	_tmp185_ = size;
	_tmp186_ = g_new0 (gint, _tmp184_ * _tmp185_);
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
	self->priv->region_of = _tmp186_;
	self->priv->region_of_length1 = _tmp184_ * _tmp185_;
	self->priv->_region_of_size_ = self->priv->region_of_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp187_;
			_tmp187_ = TRUE;
			while (TRUE) {
				gboolean _tmp188_;
				gint _tmp190_;
				gint _tmp191_;
				gint _tmp192_;
				gint* _tmp193_;
				gint _tmp193__length1;
				gint _tmp194_;
				gint _tmp195_;
				gint* _tmp210_;
				gint _tmp210__length1;
				gint* _tmp211_;
				gint _tmp211__length1;
				gint _tmp212_;
				gint _tmp213_;
				gint _tmp214_;
				_tmp188_ = _tmp187_;
				if (!_tmp188_) {
					gint _tmp189_;
					_tmp189_ = i;
					i = _tmp189_ + 1;
				}
				_tmp187_ = FALSE;
				_tmp190_ = i;
				_tmp191_ = size;
				_tmp192_ = size;
				if (!(_tmp190_ < (_tmp191_ * _tmp192_))) {
					break;
				}
				_tmp193_ = self->priv->region_of;
				_tmp193__length1 = self->priv->region_of_length1;
				_tmp194_ = i;
				_tmp193_[_tmp194_] = 0;
				_tmp195_ = _tmp193_[_tmp194_];
				{
					gint j;
					j = 0;
					{
						gboolean _tmp196_;
						_tmp196_ = TRUE;
						while (TRUE) {
							gboolean _tmp197_;
							gint _tmp199_;
							GList* _tmp200_;
							guint _tmp201_ = 0U;
							gint* _tmp202_;
							gint _tmp202__length1;
							gint _tmp202__length2;
							gint _tmp203_;
							gint _tmp204_;
							gint _tmp205_;
							_tmp197_ = _tmp196_;
							if (!_tmp197_) {
								gint _tmp198_;
								_tmp198_ = j;
								j = _tmp198_ + 1;
							}
							_tmp196_ = FALSE;
							_tmp199_ = j;
							_tmp200_ = non_pivot_cols;
							_tmp201_ = g_list_length (_tmp200_);
							if (!(((guint) _tmp199_) < _tmp201_)) {
								break;
							}
							_tmp202_ = basis_for_ns;
							_tmp202__length1 = basis_for_ns_length1;
							_tmp202__length2 = basis_for_ns_length2;
							_tmp203_ = j;
							_tmp204_ = i;
							_tmp205_ = _tmp202_[(_tmp203_ * _tmp202__length2) + _tmp204_];
							if (_tmp205_ != 0) {
								gint* _tmp206_;
								gint _tmp206__length1;
								gint _tmp207_;
								gint _tmp208_;
								gint _tmp209_;
								_tmp206_ = self->priv->region_of;
								_tmp206__length1 = self->priv->region_of_length1;
								_tmp207_ = i;
								_tmp208_ = j;
								_tmp206_[_tmp207_] += 1 << _tmp208_;
								_tmp209_ = _tmp206_[_tmp207_];
							}
						}
					}
				}
				_tmp210_ = self->priv->region_size;
				_tmp210__length1 = self->priv->region_size_length1;
				_tmp211_ = self->priv->region_of;
				_tmp211__length1 = self->priv->region_of_length1;
				_tmp212_ = i;
				_tmp213_ = _tmp211_[_tmp212_];
				_tmp214_ = _tmp210_[_tmp213_];
				_tmp210_[_tmp213_] = _tmp214_ + 1;
			}
		}
	}
	_tmp215_ = self->priv->region_size;
	_tmp215__length1 = self->priv->region_size_length1;
	_tmp216_ = _tmp215_[0];
	self->priv->max_solution_length = _tmp216_;
	{
		gint j;
		j = 1;
		{
			gboolean _tmp217_;
			_tmp217_ = TRUE;
			while (TRUE) {
				gboolean _tmp218_;
				gint _tmp220_;
				gint* _tmp221_;
				gint _tmp221__length1;
				gint _tmp222_;
				gint* _tmp223_;
				gint _tmp223__length1;
				gint _tmp224_;
				gint _tmp225_;
				gdouble _tmp226_ = 0.0;
				_tmp218_ = _tmp217_;
				if (!_tmp218_) {
					gint _tmp219_;
					_tmp219_ = j;
					j = _tmp219_ + 1;
				}
				_tmp217_ = FALSE;
				_tmp220_ = j;
				_tmp221_ = self->priv->region_size;
				_tmp221__length1 = self->priv->region_size_length1;
				if (!(_tmp220_ < _tmp221__length1)) {
					break;
				}
				_tmp222_ = self->priv->max_solution_length;
				_tmp223_ = self->priv->region_size;
				_tmp223__length1 = self->priv->region_size_length1;
				_tmp224_ = j;
				_tmp225_ = _tmp223_[_tmp224_];
				_tmp226_ = floor ((gdouble) (_tmp225_ / 2));
				self->priv->max_solution_length = _tmp222_ + ((gint) _tmp226_);
			}
		}
	}
	basis_for_ns = (g_free (basis_for_ns), NULL);
	_g_list_free0 (non_pivot_cols);
	adj_matrix = (g_free (adj_matrix), NULL);
	return self;
}


PuzzleGenerator* puzzle_generator_new (gint size) {
	return puzzle_generator_construct (TYPE_PUZZLE_GENERATOR, size);
}


gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self, gint solution_length, int* result_length1, int* result_length2) {
	gboolean* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_ = NULL;
	gboolean* sol;
	gint sol_length1;
	gint sol_length2;
	gint* _tmp17_;
	gint _tmp17__length1;
	gint* _tmp18_ = NULL;
	gint* presses_in_region;
	gint presses_in_region_length1;
	gint _presses_in_region_size_;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	gint sym;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_ = 0;
	gint presses_left;
	gboolean* _tmp96_;
	gint _tmp96__length1;
	gint _tmp96__length2;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->size;
	_tmp1_ = self->priv->size;
	_tmp2_ = g_new0 (gboolean, _tmp0_ * _tmp1_);
	sol = _tmp2_;
	sol_length1 = _tmp0_;
	sol_length2 = _tmp1_;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gint _tmp7_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = x;
				_tmp7_ = self->priv->size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_;
							gint _tmp11_;
							gint _tmp12_;
							gboolean* _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							gint _tmp14_;
							gint _tmp15_;
							gboolean _tmp16_;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = y;
								y = _tmp10_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp11_ = y;
							_tmp12_ = self->priv->size;
							if (!(_tmp11_ < _tmp12_)) {
								break;
							}
							_tmp13_ = sol;
							_tmp13__length1 = sol_length1;
							_tmp13__length2 = sol_length2;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = FALSE;
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
						}
					}
				}
			}
		}
	}
	_tmp17_ = self->priv->region_size;
	_tmp17__length1 = self->priv->region_size_length1;
	_tmp18_ = g_new0 (gint, _tmp17__length1);
	presses_in_region = _tmp18_;
	presses_in_region_length1 = _tmp17__length1;
	_presses_in_region_size_ = presses_in_region_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp19_;
			_tmp19_ = TRUE;
			while (TRUE) {
				gboolean _tmp20_;
				gint _tmp22_;
				gint* _tmp23_;
				gint _tmp23__length1;
				gint* _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				gint _tmp26_;
				_tmp20_ = _tmp19_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = self->priv->region_size;
				_tmp23__length1 = self->priv->region_size_length1;
				if (!(_tmp22_ < _tmp23__length1)) {
					break;
				}
				_tmp24_ = presses_in_region;
				_tmp24__length1 = presses_in_region_length1;
				_tmp25_ = i;
				_tmp24_[_tmp25_] = 0;
				_tmp26_ = _tmp24_[_tmp25_];
			}
		}
	}
	_tmp27_ = g_random_double ();
	_tmp28_ = floor (3 * _tmp27_);
	sym = (gint) _tmp28_;
	_tmp29_ = solution_length;
	_tmp30_ = self->priv->max_solution_length;
	_tmp31_ = MIN (_tmp29_, _tmp30_);
	presses_left = _tmp31_;
	while (TRUE) {
		gint _tmp32_;
		gint x[2] = {0};
		gint y[2] = {0};
		gint _tmp33_;
		gdouble _tmp34_ = 0.0;
		gdouble _tmp35_ = 0.0;
		gint _tmp36_;
		gint _tmp37_;
		gdouble _tmp38_ = 0.0;
		gdouble _tmp39_ = 0.0;
		gint _tmp40_;
		gint _tmp41_;
		_tmp32_ = presses_left;
		if (!(_tmp32_ > 0)) {
			break;
		}
		_tmp33_ = self->priv->size;
		_tmp34_ = g_random_double ();
		_tmp35_ = round ((_tmp33_ - 1) * _tmp34_);
		x[0] = (gint) _tmp35_;
		_tmp36_ = x[0];
		_tmp37_ = self->priv->size;
		_tmp38_ = g_random_double ();
		_tmp39_ = round ((_tmp37_ - 1) * _tmp38_);
		y[0] = (gint) _tmp39_;
		_tmp40_ = y[0];
		_tmp41_ = sym;
		if (_tmp41_ == 0) {
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			_tmp42_ = self->priv->size;
			_tmp43_ = x[0];
			x[1] = (_tmp42_ - 1) - _tmp43_;
			_tmp44_ = x[1];
			_tmp45_ = y[0];
			y[1] = _tmp45_;
			_tmp46_ = y[1];
		} else {
			gint _tmp47_;
			_tmp47_ = sym;
			if (_tmp47_ == 1) {
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				_tmp48_ = self->priv->size;
				_tmp49_ = x[0];
				x[1] = (_tmp48_ - 1) - _tmp49_;
				_tmp50_ = x[1];
				_tmp51_ = self->priv->size;
				_tmp52_ = y[0];
				y[1] = (_tmp51_ - 1) - _tmp52_;
				_tmp53_ = y[1];
			} else {
				gint _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				gint _tmp58_;
				_tmp54_ = x[0];
				x[1] = _tmp54_;
				_tmp55_ = x[1];
				_tmp56_ = self->priv->size;
				_tmp57_ = y[0];
				y[1] = (_tmp56_ - 1) - _tmp57_;
				_tmp58_ = y[1];
			}
		}
		{
			gint k;
			k = 0;
			{
				gboolean _tmp59_;
				_tmp59_ = TRUE;
				while (TRUE) {
					gboolean _tmp60_;
					gint _tmp62_;
					gint* _tmp63_;
					gint _tmp63__length1;
					gint _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					gint r;
					gboolean _tmp70_ = FALSE;
					gint _tmp71_;
					gboolean _tmp78_;
					gint _tmp95_;
					_tmp60_ = _tmp59_;
					if (!_tmp60_) {
						gint _tmp61_;
						_tmp61_ = k;
						k = _tmp61_ + 1;
					}
					_tmp59_ = FALSE;
					_tmp62_ = k;
					if (!(_tmp62_ < 2)) {
						break;
					}
					_tmp63_ = self->priv->region_of;
					_tmp63__length1 = self->priv->region_of_length1;
					_tmp64_ = k;
					_tmp65_ = x[_tmp64_];
					_tmp66_ = self->priv->size;
					_tmp67_ = k;
					_tmp68_ = y[_tmp67_];
					_tmp69_ = _tmp63_[(_tmp65_ * _tmp66_) + _tmp68_];
					r = _tmp69_;
					_tmp71_ = r;
					if (_tmp71_ == 0) {
						_tmp70_ = TRUE;
					} else {
						gint* _tmp72_;
						gint _tmp72__length1;
						gint _tmp73_;
						gint _tmp74_;
						gint* _tmp75_;
						gint _tmp75__length1;
						gint _tmp76_;
						gint _tmp77_;
						_tmp72_ = presses_in_region;
						_tmp72__length1 = presses_in_region_length1;
						_tmp73_ = r;
						_tmp74_ = _tmp72_[_tmp73_];
						_tmp75_ = self->priv->region_size;
						_tmp75__length1 = self->priv->region_size_length1;
						_tmp76_ = r;
						_tmp77_ = _tmp75_[_tmp76_];
						_tmp70_ = (2 * (_tmp74_ + 1)) <= _tmp77_;
					}
					_tmp78_ = _tmp70_;
					if (_tmp78_) {
						gboolean* _tmp79_;
						gint _tmp79__length1;
						gint _tmp79__length2;
						gint _tmp80_;
						gint _tmp81_;
						gint _tmp82_;
						gint _tmp83_;
						gboolean _tmp84_;
						gboolean* _tmp85_;
						gint _tmp85__length1;
						gint _tmp85__length2;
						gint _tmp86_;
						gint _tmp87_;
						gint _tmp88_;
						gint _tmp89_;
						gboolean _tmp90_;
						gint* _tmp91_;
						gint _tmp91__length1;
						gint _tmp92_;
						gint _tmp93_;
						gint _tmp94_;
						_tmp79_ = sol;
						_tmp79__length1 = sol_length1;
						_tmp79__length2 = sol_length2;
						_tmp80_ = k;
						_tmp81_ = x[_tmp80_];
						_tmp82_ = k;
						_tmp83_ = y[_tmp82_];
						_tmp84_ = _tmp79_[(_tmp81_ * _tmp79__length2) + _tmp83_];
						if (_tmp84_) {
							continue;
						}
						_tmp85_ = sol;
						_tmp85__length1 = sol_length1;
						_tmp85__length2 = sol_length2;
						_tmp86_ = k;
						_tmp87_ = x[_tmp86_];
						_tmp88_ = k;
						_tmp89_ = y[_tmp88_];
						_tmp85_[(_tmp87_ * _tmp85__length2) + _tmp89_] = TRUE;
						_tmp90_ = _tmp85_[(_tmp87_ * _tmp85__length2) + _tmp89_];
						_tmp91_ = presses_in_region;
						_tmp91__length1 = presses_in_region_length1;
						_tmp92_ = r;
						_tmp93_ = _tmp91_[_tmp92_];
						_tmp91_[_tmp92_] = _tmp93_ + 1;
						_tmp94_ = presses_left;
						presses_left = _tmp94_ - 1;
					}
					_tmp95_ = presses_left;
					if (_tmp95_ == 0) {
						break;
					}
				}
			}
		}
	}
	_tmp96_ = sol;
	_tmp96__length1 = sol_length1;
	_tmp96__length2 = sol_length2;
	if (result_length1) {
		*result_length1 = _tmp96__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp96__length2;
	}
	result = _tmp96_;
	presses_in_region = (g_free (presses_in_region), NULL);
	return result;
}


static void value_puzzle_generator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_puzzle_generator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		puzzle_generator_unref (value->data[0].v_pointer);
	}
}


static void value_puzzle_generator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = puzzle_generator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_puzzle_generator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_puzzle_generator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PuzzleGenerator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = puzzle_generator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_puzzle_generator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PuzzleGenerator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = puzzle_generator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_puzzle_generator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPuzzleGenerator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PUZZLE_GENERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_puzzle_generator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PUZZLE_GENERATOR), NULL);
	return value->data[0].v_pointer;
}


void value_set_puzzle_generator (GValue* value, gpointer v_object) {
	PuzzleGenerator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PUZZLE_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PUZZLE_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		puzzle_generator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		puzzle_generator_unref (old);
	}
}


void value_take_puzzle_generator (GValue* value, gpointer v_object) {
	PuzzleGenerator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PUZZLE_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PUZZLE_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		puzzle_generator_unref (old);
	}
}


static void puzzle_generator_class_init (PuzzleGeneratorClass * klass) {
	puzzle_generator_parent_class = g_type_class_peek_parent (klass);
	PUZZLE_GENERATOR_CLASS (klass)->finalize = puzzle_generator_finalize;
	g_type_class_add_private (klass, sizeof (PuzzleGeneratorPrivate));
}


static void puzzle_generator_instance_init (PuzzleGenerator * self) {
	self->priv = PUZZLE_GENERATOR_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void puzzle_generator_finalize (PuzzleGenerator* obj) {
	PuzzleGenerator * self;
	self = PUZZLE_GENERATOR (obj);
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
}


GType puzzle_generator_get_type (void) {
	static volatile gsize puzzle_generator_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_generator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_puzzle_generator_init, value_puzzle_generator_free_value, value_puzzle_generator_copy_value, value_puzzle_generator_peek_pointer, "p", value_puzzle_generator_collect_value, "p", value_puzzle_generator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleGenerator), 0, (GInstanceInitFunc) puzzle_generator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType puzzle_generator_type_id;
		puzzle_generator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PuzzleGenerator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&puzzle_generator_type_id__volatile, puzzle_generator_type_id);
	}
	return puzzle_generator_type_id__volatile;
}


gpointer puzzle_generator_ref (gpointer instance) {
	PuzzleGenerator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void puzzle_generator_unref (gpointer instance) {
	PuzzleGenerator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PUZZLE_GENERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



