/* glchess.c generated by valac 0.15.0, the Vala compiler
 * generated from glchess.vala, do not modify */

/* Workaround for https://bugzilla.gnome.org/show_bug.cgi?id=647122 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
#define _chess_game_unref0(var) ((var == NULL) ? NULL : (var = (chess_game_unref (var), NULL)))
#define __g_list_free__ai_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ai_profile_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_CHESS_VIEW3_D (chess_view3_d_get_type ())
#define CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW3_D, ChessView3D))
#define CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW3_D, ChessView3DClass))
#define IS_CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW3_D))
#define IS_CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW3_D))
#define CHESS_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW3_D, ChessView3DClass))

typedef struct _ChessView3D ChessView3D;
typedef struct _ChessView3DClass ChessView3DClass;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
typedef struct _PGNGamePrivate PGNGamePrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define _ai_profile_unref0(var) ((var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL)))
typedef struct _AIProfilePrivate AIProfilePrivate;

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))

#define TYPE_GL_CHESS (gl_chess_get_type ())
#define GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GL_CHESS, GlChess))
#define GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GL_CHESS, GlChessClass))
#define IS_GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GL_CHESS))
#define IS_GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GL_CHESS))
#define GL_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GL_CHESS, GlChessClass))

typedef struct _GlChess GlChess;
typedef struct _GlChessClass GlChessClass;
typedef struct _GlChessPrivate GlChessPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ParamSpecGlChess ParamSpecGlChess;

struct _Application {
	GtkApplication parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ApplicationPrivate {
	GSettings* settings;
	History* history;
	GtkBuilder* builder;
	GtkBuilder* preferences_builder;
	GtkWindow* window;
	GtkWidget* save_menu;
	GtkWidget* save_as_menu;
	GtkMenuItem* fullscreen_menu;
	GtkInfoBar* info_bar;
	GtkLabel* info_title_label;
	GtkLabel* info_label;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkWidget* undo_menu;
	GtkWidget* undo_button;
	GtkWidget* resign_menu;
	GtkWidget* resign_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkDialog* preferences_dialog;
	GtkComboBox* duration_combo;
	GtkAdjustment* duration_adjustment;
	GtkContainer* custom_duration_box;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gboolean in_history;
	GFile* game_file;
	gboolean game_needs_saving;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH
} ChessRule;

struct _ChessGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GTypeClass parent_class;
	void (*finalize) (ChessGame *self);
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _PGNGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GTypeClass parent_class;
	void (*finalize) (PGNGame *self);
};

struct _AIProfile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AIProfilePrivate * priv;
	gchar* name;
	gchar* protocol;
	gchar* binary;
	gchar* path;
	gchar* args;
	gchar** easy_options;
	gint easy_options_length1;
	gchar** normal_options;
	gint normal_options_length1;
	gchar** hard_options;
	gint hard_options_length1;
};

struct _AIProfileClass {
	GTypeClass parent_class;
	void (*finalize) (AIProfile *self);
};

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
	gchar* binary;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _GlChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GlChessPrivate * priv;
};

struct _GlChessClass {
	GTypeClass parent_class;
	void (*finalize) (GlChess *self);
};

struct _ParamSpecGlChess {
	GParamSpec parent_instance;
};


static gpointer application_parent_class = NULL;
extern gchar* pgn_game_RESULT_WHITE;
extern gchar* pgn_game_RESULT_BLACK;
extern gchar* pgn_game_RESULT_DRAW;
extern gchar* pgn_game_TERMINATE_ABANDONED;
extern gchar* pgn_game_TERMINATE_DEATH;
static gpointer gl_chess_parent_class = NULL;
static gboolean gl_chess_show_version;
static gboolean gl_chess_show_version = FALSE;

void gtk_file_filter_set_name (GtkFileFilter* filter, const gchar* name);
GType application_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
gpointer ai_profile_ref (gpointer instance);
void ai_profile_unref (gpointer instance);
GParamSpec* param_spec_ai_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ai_profile (GValue* value, gpointer v_object);
void value_take_ai_profile (GValue* value, gpointer v_object);
gpointer value_get_ai_profile (const GValue* value);
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
static void _ai_profile_unref0_ (gpointer var);
static void _g_list_free__ai_profile_unref0_ (GList* self);
Application* application_new (void);
Application* application_construct (GType object_type);
History* history_new (GFile* data_dir);
History* history_construct (GType object_type, GFile* data_dir);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static void application_scene_changed_cb (Application* self, ChessScene* scene);
static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key);
static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void application_quit_game (Application* self);
static gboolean application_save_duration_cb (Application* self);
static void application_autosave (Application* self);
void history_remove (History* self, GFile* file);
void history_update (History* self, GFile* file, const gchar* fen, const gchar* _result_);
const gchar* pgn_game_get_result (PGNGame* self);
GFile* history_add (History* self, const gchar* date, const gchar* _result_, GError** error);
const gchar* pgn_game_get_date (PGNGame* self);
void pgn_game_write (PGNGame* self, GFile* file, GError** error);
ChessView3D* chess_view3_d_new (void);
ChessView3D* chess_view3_d_construct (GType object_type);
GType chess_view3_d_get_type (void) G_GNUC_CONST;
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
GType chess_view2_d_get_type (void) G_GNUC_CONST;
void chess_view_set_scene (ChessView* self, ChessScene* value);
static void application_update_history_panel (Application* self);
gint chess_scene_get_move_number (ChessScene* self);
guint chess_game_get_n_moves (ChessGame* self);
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move);
static void application_start_game (Application* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
gboolean pgn_game_get_set_up (PGNGame* self);
const gchar* pgn_game_get_fen (PGNGame* self);
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
const gchar* pgn_game_get_time_control (PGNGame* self);
ChessClock* chess_clock_new (guint white_duration, guint black_duration, guint white_used, guint black_used);
ChessClock* chess_clock_construct (GType object_type, guint white_duration, guint black_duration, guint white_used, guint black_used);
GType chess_clock_get_type (void) G_GNUC_CONST;
void chess_game_set_clock (ChessGame* self, ChessClock* value);
static void application_game_start_cb (Application* self, ChessGame* game);
static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self);
static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player);
static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move);
static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void application_game_undo_cb (Application* self, ChessGame* game);
static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void application_game_end_cb (Application* self, ChessGame* game);
static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
ChessClock* chess_game_get_clock (ChessGame* self);
static void application_game_clock_tick_cb (Application* self, ChessClock* clock);
static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void application_update_control_buttons (Application* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
ChessPlayer* chess_game_get_black (ChessGame* self);
static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty);
static void application_engine_ready_cb (Application* self, ChessEngine* engine);
static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move);
static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
gboolean chess_engine_start (ChessEngine* self);
void chess_game_start (ChessGame* self);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
ChessEngineCECP* chess_engine_cecp_new (gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (gchar** options, int options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, gchar** options, int options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
void application_start (Application* self, GFile* game, GError** error);
GList* load_ai_profiles (const gchar* filename);
GList* history_get_unfinished (History* self);
static void application_load_game (Application* self, GFile* file, gboolean from_history, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void application_start_new_game (Application* self);
void application_show (Application* self);
static void application_real_activate (GApplication* base);
gboolean chess_engine_get_ready (ChessEngine* self);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
void chess_engine_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
GType piece_type_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_san (ChessMove* self);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_lan (ChessMove* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
void pgn_game_set_result (PGNGame* self, const gchar* value);
void pgn_game_set_termination (PGNGame* self, const gchar* value);
gboolean G_MODULE_EXPORT glchess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
gboolean G_MODULE_EXPORT glchess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self);
gboolean G_MODULE_EXPORT glchess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self);
void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
gboolean chess_player_resign (ChessPlayer* self);
void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self);
gboolean chess_player_claim_draw (ChessPlayer* self);
void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self);
void chess_player_undo (ChessPlayer* self);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
void G_MODULE_EXPORT quit_cb (GtkWidget* widget, Application* self);
gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color);
gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
guint chess_clock_get_white_duration (ChessClock* self);
guint chess_clock_get_white_used_in_seconds (ChessClock* self);
guint chess_clock_get_black_duration (ChessClock* self);
guint chess_clock_get_black_used_in_seconds (ChessClock* self);
void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT preferences_cb (GtkWidget* widget, Application* self);
static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void application_set_duration (Application* self, gint duration, gboolean simplify);
static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index);
void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self);
static gint application_get_duration (Application* self);
void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self);
static void application_save_duration (Application* self);
void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self);
static gboolean _application_save_duration_cb_gsource_func (gpointer self);
void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self);
gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self);
void G_MODULE_EXPORT promotion_type_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT help_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT about_cb (GtkWidget* widget, Application* self);
static void application_about_response_cb (Application* self, gint response_id);
static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void G_MODULE_EXPORT save_game_as_cb (GtkWidget* widget, Application* self);
static void application_save_game (Application* self);
void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self);
static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label);
static void application_save_file_cb (Application* self);
static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_save_cb (Application* self, gint response_id);
static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self);
static void application_open_file_cb (Application* self);
static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_open_cb (Application* self, gint response_id);
static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
PGNGame* pgn_game_new (void);
PGNGame* pgn_game_construct (GType object_type);
void pgn_game_set_date (PGNGame* self, const gchar* value);
void pgn_game_set_time (PGNGame* self, const gchar* value);
void pgn_game_set_time_control (PGNGame* self, const gchar* value);
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
static void application_finalize (GObject* obj);
gpointer gl_chess_ref (gpointer instance);
void gl_chess_unref (gpointer instance);
GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gl_chess (GValue* value, gpointer v_object);
void value_take_gl_chess (GValue* value, gpointer v_object);
gpointer value_get_gl_chess (const GValue* value);
GType gl_chess_get_type (void) G_GNUC_CONST;
enum  {
	GL_CHESS_DUMMY_PROPERTY
};
gint gl_chess_main (gchar** args, int args_length1);
GlChess* gl_chess_new (void);
GlChess* gl_chess_construct (GType object_type);
static void gl_chess_finalize (GlChess* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* APPLICATION_artists[4] = {"John-Paul Gignac (3D Models)", "Max Froumentin (2D Models)", "Hylke Bons <h.bons@student.rug.nl> (icon)", NULL};
const GOptionEntry GL_CHESS_options[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &gl_chess_show_version, "Show release version", NULL}, {NULL}};

static void _ai_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL));
}


static void _g_list_free__ai_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _ai_profile_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
	application_scene_changed_cb (self, _sender);
}


static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	application_settings_changed_cb (self, _sender, key);
}


Application* application_construct (GType object_type) {
	Application * self = NULL;
	GSettings* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFile* data_dir;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	History* _tmp8_;
	GtkBuilder* _tmp9_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkWindow* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkWidget* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkWidget* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkWidget* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkWidget* _tmp32_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkWidget* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_ = NULL;
	GtkWidget* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkWidget* _tmp41_;
	GtkBuilder* _tmp42_;
	GObject* _tmp43_ = NULL;
	GtkWidget* _tmp44_;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_ = NULL;
	GtkWidget* _tmp47_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_ = NULL;
	GtkWidget* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_ = NULL;
	GtkComboBox* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_ = NULL;
	GtkWidget* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_ = NULL;
	GtkWidget* _tmp59_;
	GSettings* _tmp60_;
	GtkBuilder* _tmp61_;
	GObject* _tmp62_ = NULL;
	GSettings* _tmp63_;
	GtkBuilder* _tmp64_;
	GObject* _tmp65_ = NULL;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_ = NULL;
	GtkVBox* _tmp68_;
	GtkVBox* view_box;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_ = NULL;
	GtkContainer* _tmp71_;
	GtkBuilder* _tmp72_;
	GtkWindow* _tmp73_;
	GtkInfoBar* _tmp74_;
	GtkInfoBar* _tmp75_;
	GtkInfoBar* _tmp76_;
	GtkWidget* _tmp77_ = NULL;
	GtkContainer* _tmp78_;
	GtkContainer* content_area;
	GtkInfoBar* _tmp79_;
	GtkBox* _tmp80_;
	GtkBox* _tmp81_;
	GtkBox* vbox;
	GtkLabel* _tmp82_;
	GtkLabel* _tmp83_;
	GtkLabel* _tmp84_;
	GtkLabel* _tmp85_;
	GtkLabel* _tmp86_;
	GtkLabel* _tmp87_;
	GtkLabel* _tmp88_;
	GtkLabel* _tmp89_;
	ChessScene* _tmp90_;
	ChessScene* _tmp91_;
	GSettings* _tmp92_;
	ChessScene* _tmp93_;
	GSettings* _tmp94_;
	ChessScene* _tmp95_;
	GSettings* _tmp96_;
	ChessScene* _tmp97_;
	GSettings* _tmp98_;
	ChessScene* _tmp99_;
	GSettings* _tmp100_;
	ChessScene* _tmp101_;
	GSettings* _tmp102_;
	ChessScene* _tmp103_;
	GSettings* _tmp104_;
	GSettings* _tmp105_;
	GError * _inner_error_ = NULL;
	self = (Application*) g_object_new (object_type, "application-id", "org.gnome.glchess", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	_tmp0_ = g_settings_new ("org.gnome.glchess.Settings");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "glchess", NULL, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	data_dir = _tmp5_;
	_tmp6_ = g_file_get_path (data_dir);
	_tmp7_ = _tmp6_;
	g_mkdir_with_parents (_tmp7_, 0755);
	_g_free0 (_tmp7_);
	_tmp8_ = history_new (data_dir);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp8_;
	_tmp9_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp9_;
	{
		GtkBuilder* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp10_ = self->priv->builder;
		_tmp11_ = g_build_filename (PKGDATADIR, "glchess.ui", NULL, NULL);
		_tmp12_ = _tmp11_;
		gtk_builder_add_from_file (_tmp10_, _tmp12_, &_inner_error_);
		_g_free0 (_tmp12_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("glchess.vala:74: Could not load UI: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp15_ = self->priv->builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "glchess_app");
	_tmp17_ = _g_object_ref0 (GTK_WINDOW (_tmp16_));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp17_;
	_tmp18_ = self->priv->builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "menu_save_item");
	_tmp20_ = _g_object_ref0 (GTK_WIDGET (_tmp19_));
	_g_object_unref0 (self->priv->save_menu);
	self->priv->save_menu = _tmp20_;
	_tmp21_ = self->priv->builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "menu_save_as_item");
	_tmp23_ = _g_object_ref0 (GTK_WIDGET (_tmp22_));
	_g_object_unref0 (self->priv->save_as_menu);
	self->priv->save_as_menu = _tmp23_;
	_tmp24_ = self->priv->builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "fullscreen_item");
	_tmp26_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp25_));
	_g_object_unref0 (self->priv->fullscreen_menu);
	self->priv->fullscreen_menu = _tmp26_;
	_tmp27_ = self->priv->builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "undo_move_item");
	_tmp29_ = _g_object_ref0 (GTK_WIDGET (_tmp28_));
	_g_object_unref0 (self->priv->undo_menu);
	self->priv->undo_menu = _tmp29_;
	_tmp30_ = self->priv->builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "undo_move_button");
	_tmp32_ = _g_object_ref0 (GTK_WIDGET (_tmp31_));
	_g_object_unref0 (self->priv->undo_button);
	self->priv->undo_button = _tmp32_;
	_tmp33_ = self->priv->builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "resign_item");
	_tmp35_ = _g_object_ref0 (GTK_WIDGET (_tmp34_));
	_g_object_unref0 (self->priv->resign_menu);
	self->priv->resign_menu = _tmp35_;
	_tmp36_ = self->priv->builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "resign_button");
	_tmp38_ = _g_object_ref0 (GTK_WIDGET (_tmp37_));
	_g_object_unref0 (self->priv->resign_button);
	self->priv->resign_button = _tmp38_;
	_tmp39_ = self->priv->builder;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "first_move_button");
	_tmp41_ = _g_object_ref0 (GTK_WIDGET (_tmp40_));
	_g_object_unref0 (self->priv->first_move_button);
	self->priv->first_move_button = _tmp41_;
	_tmp42_ = self->priv->builder;
	_tmp43_ = gtk_builder_get_object (_tmp42_, "prev_move_button");
	_tmp44_ = _g_object_ref0 (GTK_WIDGET (_tmp43_));
	_g_object_unref0 (self->priv->prev_move_button);
	self->priv->prev_move_button = _tmp44_;
	_tmp45_ = self->priv->builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "next_move_button");
	_tmp47_ = _g_object_ref0 (GTK_WIDGET (_tmp46_));
	_g_object_unref0 (self->priv->next_move_button);
	self->priv->next_move_button = _tmp47_;
	_tmp48_ = self->priv->builder;
	_tmp49_ = gtk_builder_get_object (_tmp48_, "last_move_button");
	_tmp50_ = _g_object_ref0 (GTK_WIDGET (_tmp49_));
	_g_object_unref0 (self->priv->last_move_button);
	self->priv->last_move_button = _tmp50_;
	_tmp51_ = self->priv->builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "history_combo");
	_tmp53_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp52_));
	_g_object_unref0 (self->priv->history_combo);
	self->priv->history_combo = _tmp53_;
	_tmp54_ = self->priv->builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "white_time_label");
	_tmp56_ = _g_object_ref0 (GTK_WIDGET (_tmp55_));
	_g_object_unref0 (self->priv->white_time_label);
	self->priv->white_time_label = _tmp56_;
	_tmp57_ = self->priv->builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "black_time_label");
	_tmp59_ = _g_object_ref0 (GTK_WIDGET (_tmp58_));
	_g_object_unref0 (self->priv->black_time_label);
	self->priv->black_time_label = _tmp59_;
	_tmp60_ = self->priv->settings;
	_tmp61_ = self->priv->builder;
	_tmp62_ = gtk_builder_get_object (_tmp61_, "toolbar");
	g_settings_bind (_tmp60_, "show-toolbar", _tmp62_, "visible", G_SETTINGS_BIND_DEFAULT);
	_tmp63_ = self->priv->settings;
	_tmp64_ = self->priv->builder;
	_tmp65_ = gtk_builder_get_object (_tmp64_, "navigation_box");
	g_settings_bind (_tmp63_, "show-history", _tmp65_, "visible", G_SETTINGS_BIND_DEFAULT);
	_tmp66_ = self->priv->builder;
	_tmp67_ = gtk_builder_get_object (_tmp66_, "view_box");
	_tmp68_ = _g_object_ref0 (GTK_VBOX (_tmp67_));
	view_box = _tmp68_;
	_tmp69_ = self->priv->builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "view_container");
	_tmp71_ = _g_object_ref0 (GTK_CONTAINER (_tmp70_));
	_g_object_unref0 (self->priv->view_container);
	self->priv->view_container = _tmp71_;
	_tmp72_ = self->priv->builder;
	gtk_builder_connect_signals (_tmp72_, self);
	_tmp73_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp73_);
	_tmp74_ = (GtkInfoBar*) gtk_info_bar_new ();
	_tmp75_ = g_object_ref_sink (_tmp74_);
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = _tmp75_;
	_tmp76_ = self->priv->info_bar;
	_tmp77_ = gtk_info_bar_get_content_area (_tmp76_);
	_tmp78_ = _g_object_ref0 (GTK_CONTAINER (_tmp77_));
	content_area = _tmp78_;
	_tmp79_ = self->priv->info_bar;
	gtk_box_pack_start ((GtkBox*) view_box, (GtkWidget*) _tmp79_, FALSE, TRUE, (guint) 0);
	_tmp80_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp81_ = g_object_ref_sink (_tmp80_);
	vbox = _tmp81_;
	gtk_widget_show ((GtkWidget*) vbox);
	gtk_container_add (content_area, (GtkWidget*) vbox);
	_tmp82_ = (GtkLabel*) gtk_label_new ("");
	_tmp83_ = g_object_ref_sink (_tmp82_);
	_g_object_unref0 (self->priv->info_title_label);
	self->priv->info_title_label = _tmp83_;
	_tmp84_ = self->priv->info_title_label;
	gtk_widget_show ((GtkWidget*) _tmp84_);
	_tmp85_ = self->priv->info_title_label;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp85_, FALSE, TRUE, (guint) 0);
	_tmp86_ = (GtkLabel*) gtk_label_new ("");
	_tmp87_ = g_object_ref_sink (_tmp86_);
	_g_object_unref0 (self->priv->info_label);
	self->priv->info_label = _tmp87_;
	_tmp88_ = self->priv->info_label;
	gtk_widget_show ((GtkWidget*) _tmp88_);
	_tmp89_ = self->priv->info_label;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp89_, TRUE, TRUE, (guint) 0);
	_tmp90_ = chess_scene_new ();
	_g_object_unref0 (self->priv->scene);
	self->priv->scene = _tmp90_;
	_tmp91_ = self->priv->scene;
	g_signal_connect_object (_tmp91_, "changed", (GCallback) _application_scene_changed_cb_chess_scene_changed, self, 0);
	_tmp92_ = self->priv->settings;
	_tmp93_ = self->priv->scene;
	g_settings_bind (_tmp92_, "show-move-hints", _tmp93_, "show-move-hints", G_SETTINGS_BIND_GET);
	_tmp94_ = self->priv->settings;
	_tmp95_ = self->priv->scene;
	g_settings_bind (_tmp94_, "show-numbering", _tmp95_, "show-numbering", G_SETTINGS_BIND_GET);
	_tmp96_ = self->priv->settings;
	_tmp97_ = self->priv->scene;
	g_settings_bind (_tmp96_, "piece-theme", _tmp97_, "theme-name", G_SETTINGS_BIND_GET);
	_tmp98_ = self->priv->settings;
	_tmp99_ = self->priv->scene;
	g_settings_bind (_tmp98_, "show-3d-smooth", _tmp99_, "show-3d-smooth", G_SETTINGS_BIND_GET);
	_tmp100_ = self->priv->settings;
	_tmp101_ = self->priv->scene;
	g_settings_bind (_tmp100_, "move-format", _tmp101_, "move-format", G_SETTINGS_BIND_GET);
	_tmp102_ = self->priv->settings;
	_tmp103_ = self->priv->scene;
	g_settings_bind (_tmp102_, "board-side", _tmp103_, "board-side", G_SETTINGS_BIND_GET);
	_tmp104_ = self->priv->settings;
	g_signal_connect_object (_tmp104_, "changed", (GCallback) _application_settings_changed_cb_g_settings_changed, self, 0);
	_tmp105_ = self->priv->settings;
	application_settings_changed_cb (self, _tmp105_, "show-3d");
	_g_object_unref0 (vbox);
	_g_object_unref0 (content_area);
	_g_object_unref0 (view_box);
	_g_object_unref0 (data_dir);
	return self;
}


Application* application_new (void) {
	return application_construct (TYPE_APPLICATION);
}


void application_quit_game (Application* self) {
	guint _tmp0_;
	GSettings* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		application_save_duration_cb (self);
	}
	application_autosave (self);
	_tmp1_ = self->priv->settings;
	g_settings_sync ();
	_tmp2_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
}


static void application_autosave (Application* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->in_history;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->game_needs_saving;
	if (!_tmp1_) {
		GFile* _tmp2_;
		_tmp2_ = self->priv->game_file;
		if (_tmp2_ != NULL) {
			History* _tmp3_;
			GFile* _tmp4_;
			_tmp3_ = self->priv->history;
			_tmp4_ = self->priv->game_file;
			history_remove (_tmp3_, _tmp4_);
		}
		return;
	}
	{
		GFile* _tmp5_;
		GFile* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		PGNGame* _tmp23_;
		GFile* _tmp24_;
		_tmp5_ = self->priv->game_file;
		if (_tmp5_ != NULL) {
			History* _tmp6_;
			GFile* _tmp7_;
			PGNGame* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp6_ = self->priv->history;
			_tmp7_ = self->priv->game_file;
			_tmp8_ = self->priv->pgn_game;
			_tmp9_ = pgn_game_get_result (_tmp8_);
			_tmp10_ = _tmp9_;
			history_update (_tmp6_, _tmp7_, "", _tmp10_);
		} else {
			History* _tmp11_;
			PGNGame* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			PGNGame* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GFile* _tmp18_ = NULL;
			GFile* _tmp19_;
			_tmp11_ = self->priv->history;
			_tmp12_ = self->priv->pgn_game;
			_tmp13_ = pgn_game_get_date (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->pgn_game;
			_tmp16_ = pgn_game_get_result (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = history_add (_tmp11_, _tmp14_, _tmp17_, &_inner_error_);
			_tmp19_ = _tmp18_;
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp19_;
		}
		_tmp20_ = self->priv->game_file;
		_tmp21_ = g_file_get_path (_tmp20_);
		_tmp22_ = _tmp21_;
		g_debug ("glchess.vala:155: Writing current game to %s", _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = self->priv->pgn_game;
		_tmp24_ = self->priv->game_file;
		pgn_game_write (_tmp23_, _tmp24_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("glchess.vala:160: Failed to autosave: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "show-3d") == 0) {
		ChessView* _tmp1_;
		GSettings* _tmp5_;
		gboolean _tmp6_ = FALSE;
		ChessView* _tmp11_;
		ChessView* _tmp12_;
		ChessScene* _tmp13_;
		GtkContainer* _tmp14_;
		ChessView* _tmp15_;
		ChessView* _tmp16_;
		_tmp1_ = self->priv->view;
		if (_tmp1_ != NULL) {
			GtkContainer* _tmp2_;
			ChessView* _tmp3_;
			ChessView* _tmp4_;
			_tmp2_ = self->priv->view_container;
			_tmp3_ = self->priv->view;
			gtk_container_remove (_tmp2_, (GtkWidget*) _tmp3_);
			_tmp4_ = self->priv->view;
			gtk_widget_destroy ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = settings;
		_tmp6_ = g_settings_get_boolean (_tmp5_, "show-3d");
		if (_tmp6_) {
			ChessView3D* _tmp7_;
			ChessView* _tmp8_;
			_tmp7_ = chess_view3_d_new ();
			_tmp8_ = (ChessView*) g_object_ref_sink (_tmp7_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp8_;
		} else {
			ChessView2D* _tmp9_;
			ChessView* _tmp10_;
			_tmp9_ = chess_view2_d_new ();
			_tmp10_ = (ChessView*) g_object_ref_sink (_tmp9_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp10_;
		}
		_tmp11_ = self->priv->view;
		gtk_widget_set_size_request ((GtkWidget*) _tmp11_, 300, 300);
		_tmp12_ = self->priv->view;
		_tmp13_ = self->priv->scene;
		chess_view_set_scene (_tmp12_, _tmp13_);
		_tmp14_ = self->priv->view_container;
		_tmp15_ = self->priv->view;
		gtk_container_add (_tmp14_, (GtkWidget*) _tmp15_);
		_tmp16_ = self->priv->view;
		gtk_widget_show ((GtkWidget*) _tmp16_);
	}
}


static gpointer _chess_state_ref0 (gpointer self) {
	return self ? chess_state_ref (self) : NULL;
}


static void application_update_history_panel (Application* self) {
	ChessGame* _tmp0_;
	ChessScene* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint move_number;
	ChessGame* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gint n_moves;
	gint _tmp7_;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	GtkWidget* _tmp13_;
	gboolean _tmp14_;
	GtkWidget* _tmp15_;
	gint _tmp16_;
	GtkWidget* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_;
	GtkWidget* _tmp24_;
	gboolean _tmp25_;
	gint _tmp26_;
	gint i;
	ChessGame* _tmp27_;
	GList* _tmp28_;
	GtkComboBox* _tmp42_;
	gint _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	move_number = _tmp3_;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
	_tmp6_ = _tmp5_;
	n_moves = (gint) _tmp6_;
	_tmp7_ = move_number;
	if (_tmp7_ < 0) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = move_number;
		_tmp9_ = n_moves;
		move_number = _tmp8_ + (1 + _tmp9_);
	}
	_tmp11_ = n_moves;
	if (_tmp11_ > 0) {
		gint _tmp12_;
		_tmp12_ = move_number;
		_tmp10_ = _tmp12_ != 0;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = self->priv->first_move_button;
	_tmp14_ = _tmp10_;
	gtk_widget_set_sensitive (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->prev_move_button;
	_tmp16_ = move_number;
	gtk_widget_set_sensitive (_tmp15_, _tmp16_ > 0);
	_tmp17_ = self->priv->next_move_button;
	_tmp18_ = move_number;
	_tmp19_ = n_moves;
	gtk_widget_set_sensitive (_tmp17_, _tmp18_ < _tmp19_);
	_tmp21_ = n_moves;
	if (_tmp21_ > 0) {
		gint _tmp22_;
		gint _tmp23_;
		_tmp22_ = move_number;
		_tmp23_ = n_moves;
		_tmp20_ = _tmp22_ != _tmp23_;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp24_ = self->priv->last_move_button;
	_tmp25_ = _tmp20_;
	gtk_widget_set_sensitive (_tmp24_, _tmp25_);
	_tmp26_ = n_moves;
	i = _tmp26_;
	_tmp27_ = self->priv->game;
	_tmp28_ = _tmp27_->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp28_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp29_;
			ChessState* state = NULL;
			_tmp29_ = _chess_state_ref0 ((ChessState*) state_it->data);
			state = _tmp29_;
			{
				ChessState* _tmp30_;
				ChessMove* _tmp31_;
				gint _tmp41_;
				_tmp30_ = state;
				_tmp31_ = _tmp30_->last_move;
				if (_tmp31_ != NULL) {
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp32_;
					GtkTreeModel* _tmp33_;
					GtkTreeModel* _tmp34_;
					gint _tmp35_;
					GtkTreeIter _tmp36_ = {0};
					gboolean _tmp37_ = FALSE;
					_tmp32_ = self->priv->history_combo;
					_tmp33_ = gtk_combo_box_get_model (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = i;
					_tmp37_ = gtk_tree_model_iter_nth_child (_tmp34_, &_tmp36_, NULL, _tmp35_);
					iter = _tmp36_;
					if (_tmp37_) {
						GtkTreeIter _tmp38_;
						ChessState* _tmp39_;
						ChessMove* _tmp40_;
						_tmp38_ = iter;
						_tmp39_ = state;
						_tmp40_ = _tmp39_->last_move;
						application_set_move_text (self, &_tmp38_, _tmp40_);
					}
				}
				_tmp41_ = i;
				i = _tmp41_ - 1;
				_chess_state_unref0 (state);
			}
		}
	}
	_tmp42_ = self->priv->history_combo;
	_tmp43_ = move_number;
	gtk_combo_box_set_active (_tmp42_, _tmp43_);
}


static void application_scene_changed_cb (Application* self, ChessScene* scene) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scene != NULL);
	application_update_history_panel (self);
}


static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self) {
	application_game_start_cb (self, _sender);
}


static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
	application_game_turn_cb (self, _sender, player);
}


static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	application_game_move_cb (self, _sender, move);
}


static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	application_game_undo_cb (self, _sender);
}


static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
	application_game_end_cb (self, _sender);
}


static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
	application_game_clock_tick_cb (self, _sender);
}


static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
	application_engine_ready_cb (self, _sender);
}


static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
	application_engine_move_cb (self, _sender, move);
}


static void application_start_game (Application* self) {
	gboolean _tmp0_;
	GtkComboBox* _tmp15_;
	GtkTreeModel* _tmp16_;
	GtkTreeModel* _tmp17_;
	GtkListStore* _tmp18_;
	GtkListStore* model;
	GtkListStore* _tmp19_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_;
	GtkTreeIter _tmp23_;
	const gchar* _tmp24_ = NULL;
	GtkComboBox* _tmp25_;
	GtkTreeIter _tmp26_;
	gchar* _tmp27_;
	gchar* fen;
	PGNGame* _tmp28_;
	GList* _tmp29_;
	guint _tmp30_ = 0U;
	gchar** _tmp31_ = NULL;
	gchar** moves;
	gint moves_length1;
	gint _moves_size_;
	gint i;
	PGNGame* _tmp32_;
	GList* _tmp33_;
	PGNGame* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	const gchar* _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	ChessGame* _tmp52_;
	PGNGame* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	ChessGame* _tmp71_;
	ChessGame* _tmp72_;
	ChessGame* _tmp73_;
	ChessGame* _tmp74_;
	ChessGame* _tmp75_;
	ChessGame* _tmp76_;
	ChessClock* _tmp77_;
	ChessClock* _tmp78_;
	ChessScene* _tmp82_;
	ChessGame* _tmp83_;
	GtkInfoBar* _tmp84_;
	GtkWidget* _tmp85_;
	GtkWidget* _tmp86_;
	PGNGame* _tmp87_;
	GHashTable* _tmp88_;
	gconstpointer _tmp89_ = NULL;
	gchar* _tmp90_;
	gchar* white_engine;
	PGNGame* _tmp91_;
	GHashTable* _tmp92_;
	gconstpointer _tmp93_ = NULL;
	gchar* _tmp94_;
	gchar* white_level;
	const gchar* _tmp95_;
	PGNGame* _tmp97_;
	GHashTable* _tmp98_;
	gconstpointer _tmp99_ = NULL;
	gchar* _tmp100_;
	gchar* black_engine;
	PGNGame* _tmp101_;
	GHashTable* _tmp102_;
	gconstpointer _tmp103_ = NULL;
	gchar* _tmp104_;
	gchar* black_level;
	const gchar* _tmp105_;
	const gchar* _tmp107_;
	ChessEngine* _tmp131_;
	ChessGame* _tmp150_;
	ChessGame* _tmp151_;
	ChessResult _tmp152_;
	GtkWidget* _tmp154_;
	GtkWidget* _tmp155_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->in_history;
	if (_tmp0_) {
		GtkWindow* _tmp1_;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->window;
		_tmp2_ = _ ("Chess");
		gtk_window_set_title (_tmp1_, _tmp2_);
	} else {
		GFile* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* path;
		GtkWindow* _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp3_ = self->priv->game_file;
		_tmp4_ = g_file_get_path (_tmp3_);
		path = _tmp4_;
		_tmp5_ = self->priv->window;
		_tmp6_ = _ ("%1$s (%2$s) - Chess");
		_tmp7_ = path;
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = path;
		_tmp11_ = g_path_get_dirname (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf (_tmp6_, _tmp9_, _tmp12_);
		_tmp14_ = _tmp13_;
		gtk_window_set_title (_tmp5_, _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
		_g_free0 (path);
	}
	_tmp15_ = self->priv->history_combo;
	_tmp16_ = gtk_combo_box_get_model (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 (GTK_LIST_STORE (_tmp17_));
	model = _tmp18_;
	_tmp19_ = model;
	gtk_list_store_clear (_tmp19_);
	_tmp20_ = model;
	gtk_list_store_append (_tmp20_, &_tmp21_);
	iter = _tmp21_;
	_tmp22_ = model;
	_tmp23_ = iter;
	_tmp24_ = _ ("Game Start");
	gtk_list_store_set (_tmp22_, &_tmp23_, 0, _tmp24_, 1, 0, -1, -1);
	_tmp25_ = self->priv->history_combo;
	_tmp26_ = iter;
	gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
	_tmp27_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
	fen = _tmp27_;
	_tmp28_ = self->priv->pgn_game;
	_tmp29_ = _tmp28_->moves;
	_tmp30_ = g_list_length (_tmp29_);
	_tmp31_ = g_new0 (gchar*, _tmp30_ + 1);
	moves = _tmp31_;
	moves_length1 = _tmp30_;
	_moves_size_ = moves_length1;
	i = 0;
	_tmp32_ = self->priv->pgn_game;
	_tmp33_ = _tmp32_->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp33_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp34_;
			gchar* move = NULL;
			_tmp34_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp34_;
			{
				gchar** _tmp35_;
				gint _tmp35__length1;
				gint _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp35_ = moves;
				_tmp35__length1 = moves_length1;
				_tmp36_ = i;
				i = _tmp36_ + 1;
				_tmp37_ = move;
				_tmp38_ = g_strdup (_tmp37_);
				_g_free0 (_tmp35_[_tmp36_]);
				_tmp35_[_tmp36_] = _tmp38_;
				_tmp39_ = _tmp35_[_tmp36_];
				_g_free0 (move);
			}
		}
	}
	_tmp40_ = self->priv->pgn_game;
	_tmp41_ = pgn_game_get_set_up (_tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_) {
		PGNGame* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		_tmp43_ = self->priv->pgn_game;
		_tmp44_ = pgn_game_get_fen (_tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_ != NULL) {
			PGNGame* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp46_ = self->priv->pgn_game;
			_tmp47_ = pgn_game_get_fen (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strdup (_tmp48_);
			_g_free0 (fen);
			fen = _tmp49_;
		} else {
			g_warning ("glchess.vala:256: Chess game has SetUp tag but no FEN tag");
		}
	}
	_tmp50_ = fen;
	_tmp51_ = moves;
	_tmp51__length1 = moves_length1;
	_tmp52_ = chess_game_new (_tmp50_, _tmp51_, _tmp51__length1);
	_chess_game_unref0 (self->priv->game);
	self->priv->game = _tmp52_;
	_tmp53_ = self->priv->pgn_game;
	_tmp54_ = pgn_game_get_time_control (_tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		PGNGame* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		gchar** _tmp59_;
		gchar** _tmp60_ = NULL;
		gchar** controls;
		gint controls_length1;
		gint _controls_size_;
		gchar** _tmp61_;
		gint _tmp61__length1;
		_tmp56_ = self->priv->pgn_game;
		_tmp57_ = pgn_game_get_time_control (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp60_ = _tmp59_ = g_strsplit (_tmp58_, ":", 0);
		controls = _tmp60_;
		controls_length1 = _vala_array_length (_tmp59_);
		_controls_size_ = controls_length1;
		_tmp61_ = controls;
		_tmp61__length1 = controls_length1;
		{
			gchar** control_collection = NULL;
			gint control_collection_length1 = 0;
			gint _control_collection_size_ = 0;
			gint control_it = 0;
			control_collection = _tmp61_;
			control_collection_length1 = _tmp61__length1;
			for (control_it = 0; control_it < _tmp61__length1; control_it = control_it + 1) {
				gchar* _tmp62_;
				gchar* control = NULL;
				_tmp62_ = g_strdup (control_collection[control_it]);
				control = _tmp62_;
				{
					const gchar* _tmp63_;
					gint _tmp64_ = 0;
					gint duration;
					gint _tmp65_;
					_tmp63_ = control;
					_tmp64_ = atoi (_tmp63_);
					duration = _tmp64_;
					_tmp65_ = duration;
					if (_tmp65_ > 0) {
						ChessGame* _tmp66_;
						gint _tmp67_;
						gint _tmp68_;
						ChessClock* _tmp69_;
						ChessClock* _tmp70_;
						_tmp66_ = self->priv->game;
						_tmp67_ = duration;
						_tmp68_ = duration;
						_tmp69_ = chess_clock_new ((guint) _tmp67_, (guint) _tmp68_, (guint) 0, (guint) 0);
						_tmp70_ = _tmp69_;
						chess_game_set_clock (_tmp66_, _tmp70_);
						_g_object_unref0 (_tmp70_);
					}
					_g_free0 (control);
				}
			}
		}
		controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp71_ = self->priv->game;
	g_signal_connect_object (_tmp71_, "started", (GCallback) _application_game_start_cb_chess_game_started, self, 0);
	_tmp72_ = self->priv->game;
	g_signal_connect_object (_tmp72_, "turn-started", (GCallback) _application_game_turn_cb_chess_game_turn_started, self, 0);
	_tmp73_ = self->priv->game;
	g_signal_connect_object (_tmp73_, "moved", (GCallback) _application_game_move_cb_chess_game_moved, self, 0);
	_tmp74_ = self->priv->game;
	g_signal_connect_object (_tmp74_, "undo", (GCallback) _application_game_undo_cb_chess_game_undo, self, 0);
	_tmp75_ = self->priv->game;
	g_signal_connect_object (_tmp75_, "ended", (GCallback) _application_game_end_cb_chess_game_ended, self, 0);
	_tmp76_ = self->priv->game;
	_tmp77_ = chess_game_get_clock (_tmp76_);
	_tmp78_ = _tmp77_;
	if (_tmp78_ != NULL) {
		ChessGame* _tmp79_;
		ChessClock* _tmp80_;
		ChessClock* _tmp81_;
		_tmp79_ = self->priv->game;
		_tmp80_ = chess_game_get_clock (_tmp79_);
		_tmp81_ = _tmp80_;
		g_signal_connect_object (_tmp81_, "tick", (GCallback) _application_game_clock_tick_cb_chess_clock_tick, self, 0);
	}
	_tmp82_ = self->priv->scene;
	_tmp83_ = self->priv->game;
	chess_scene_set_game (_tmp82_, _tmp83_);
	_tmp84_ = self->priv->info_bar;
	gtk_widget_hide ((GtkWidget*) _tmp84_);
	_tmp85_ = self->priv->save_menu;
	gtk_widget_set_sensitive (_tmp85_, FALSE);
	_tmp86_ = self->priv->save_as_menu;
	gtk_widget_set_sensitive (_tmp86_, FALSE);
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_tmp87_ = self->priv->pgn_game;
	_tmp88_ = _tmp87_->tags;
	_tmp89_ = g_hash_table_lookup (_tmp88_, "WhiteAI");
	_tmp90_ = g_strdup ((const gchar*) _tmp89_);
	white_engine = _tmp90_;
	_tmp91_ = self->priv->pgn_game;
	_tmp92_ = _tmp91_->tags;
	_tmp93_ = g_hash_table_lookup (_tmp92_, "WhiteLevel");
	_tmp94_ = g_strdup ((const gchar*) _tmp93_);
	white_level = _tmp94_;
	_tmp95_ = white_level;
	if (_tmp95_ == NULL) {
		gchar* _tmp96_;
		_tmp96_ = g_strdup ("normal");
		_g_free0 (white_level);
		white_level = _tmp96_;
	}
	_tmp97_ = self->priv->pgn_game;
	_tmp98_ = _tmp97_->tags;
	_tmp99_ = g_hash_table_lookup (_tmp98_, "BlackAI");
	_tmp100_ = g_strdup ((const gchar*) _tmp99_);
	black_engine = _tmp100_;
	_tmp101_ = self->priv->pgn_game;
	_tmp102_ = _tmp101_->tags;
	_tmp103_ = g_hash_table_lookup (_tmp102_, "BlackLevel");
	_tmp104_ = g_strdup ((const gchar*) _tmp103_);
	black_level = _tmp104_;
	_tmp105_ = black_level;
	if (_tmp105_ == NULL) {
		gchar* _tmp106_;
		_tmp106_ = g_strdup ("normal");
		_g_free0 (black_level);
		black_level = _tmp106_;
	}
	_g_object_unref0 (self->priv->opponent);
	self->priv->opponent = NULL;
	_g_object_unref0 (self->priv->opponent_engine);
	self->priv->opponent_engine = NULL;
	_tmp107_ = white_engine;
	if (_tmp107_ != NULL) {
		ChessGame* _tmp108_;
		ChessPlayer* _tmp109_;
		ChessPlayer* _tmp110_;
		ChessPlayer* _tmp111_;
		ChessGame* _tmp112_;
		ChessPlayer* _tmp113_;
		ChessPlayer* _tmp114_;
		ChessPlayer* _tmp115_;
		const gchar* _tmp116_;
		const gchar* _tmp117_;
		ChessEngine* _tmp118_ = NULL;
		_tmp108_ = self->priv->game;
		_tmp109_ = chess_game_get_white (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = _g_object_ref0 (_tmp110_);
		_g_object_unref0 (self->priv->opponent);
		self->priv->opponent = _tmp111_;
		_tmp112_ = self->priv->game;
		_tmp113_ = chess_game_get_black (_tmp112_);
		_tmp114_ = _tmp113_;
		_tmp115_ = _g_object_ref0 (_tmp114_);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = _tmp115_;
		_tmp116_ = white_engine;
		_tmp117_ = white_level;
		_tmp118_ = application_get_engine (self, _tmp116_, _tmp117_);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = _tmp118_;
	} else {
		const gchar* _tmp119_;
		_tmp119_ = black_engine;
		if (_tmp119_ != NULL) {
			ChessGame* _tmp120_;
			ChessPlayer* _tmp121_;
			ChessPlayer* _tmp122_;
			ChessPlayer* _tmp123_;
			ChessGame* _tmp124_;
			ChessPlayer* _tmp125_;
			ChessPlayer* _tmp126_;
			ChessPlayer* _tmp127_;
			const gchar* _tmp128_;
			const gchar* _tmp129_;
			ChessEngine* _tmp130_ = NULL;
			_tmp120_ = self->priv->game;
			_tmp121_ = chess_game_get_black (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = _g_object_ref0 (_tmp122_);
			_g_object_unref0 (self->priv->opponent);
			self->priv->opponent = _tmp123_;
			_tmp124_ = self->priv->game;
			_tmp125_ = chess_game_get_white (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = _g_object_ref0 (_tmp126_);
			_g_object_unref0 (self->priv->human_player);
			self->priv->human_player = _tmp127_;
			_tmp128_ = black_engine;
			_tmp129_ = black_level;
			_tmp130_ = application_get_engine (self, _tmp128_, _tmp129_);
			_g_object_unref0 (self->priv->opponent_engine);
			self->priv->opponent_engine = _tmp130_;
		}
	}
	_tmp131_ = self->priv->opponent_engine;
	if (_tmp131_ != NULL) {
		ChessEngine* _tmp132_;
		ChessEngine* _tmp133_;
		ChessEngine* _tmp134_;
		_tmp132_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp132_, "ready-changed", (GCallback) _application_engine_ready_cb_chess_engine_ready_changed, self, 0);
		_tmp133_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp133_, "moved", (GCallback) _application_engine_move_cb_chess_engine_moved, self, 0);
		_tmp134_ = self->priv->opponent_engine;
		chess_engine_start (_tmp134_);
	}
	{
		ChessGame* _tmp135_;
		GList* _tmp136_;
		guint _tmp137_ = 0U;
		gint j;
		_tmp135_ = self->priv->game;
		_tmp136_ = _tmp135_->move_stack;
		_tmp137_ = g_list_length (_tmp136_);
		j = ((gint) _tmp137_) - 2;
		{
			gboolean _tmp138_;
			_tmp138_ = TRUE;
			while (TRUE) {
				gboolean _tmp139_;
				gint _tmp141_;
				ChessGame* _tmp142_;
				GList* _tmp143_;
				gint _tmp144_;
				gconstpointer _tmp145_ = NULL;
				ChessState* _tmp146_;
				ChessState* state;
				ChessGame* _tmp147_;
				ChessState* _tmp148_;
				ChessMove* _tmp149_;
				_tmp139_ = _tmp138_;
				if (!_tmp139_) {
					gint _tmp140_;
					_tmp140_ = j;
					j = _tmp140_ - 1;
				}
				_tmp138_ = FALSE;
				_tmp141_ = j;
				if (!(_tmp141_ >= 0)) {
					break;
				}
				_tmp142_ = self->priv->game;
				_tmp143_ = _tmp142_->move_stack;
				_tmp144_ = j;
				_tmp145_ = g_list_nth_data (_tmp143_, (guint) _tmp144_);
				_tmp146_ = _chess_state_ref0 ((ChessState*) _tmp145_);
				state = _tmp146_;
				_tmp147_ = self->priv->game;
				_tmp148_ = state;
				_tmp149_ = _tmp148_->last_move;
				application_game_move_cb (self, _tmp147_, _tmp149_);
				_chess_state_unref0 (state);
			}
		}
	}
	self->priv->game_needs_saving = FALSE;
	_tmp150_ = self->priv->game;
	chess_game_start (_tmp150_);
	_tmp151_ = self->priv->game;
	_tmp152_ = _tmp151_->result;
	if (_tmp152_ != CHESS_RESULT_IN_PROGRESS) {
		ChessGame* _tmp153_;
		_tmp153_ = self->priv->game;
		application_game_end_cb (self, _tmp153_);
	}
	_tmp154_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp154_);
	_tmp155_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp155_);
	_g_free0 (black_level);
	_g_free0 (black_engine);
	_g_free0 (white_level);
	_g_free0 (white_engine);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fen);
	_g_object_unref0 (model);
}


static gpointer _ai_profile_ref0 (gpointer self) {
	return self ? ai_profile_ref (self) : NULL;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile;
	const gchar* _tmp0_;
	GList* _tmp1_;
	AIProfile* _tmp11_;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GQuark _tmp20_ = 0U;
	static GQuark _tmp19_label0 = 0;
	static GQuark _tmp19_label1 = 0;
	AIProfile* _tmp30_;
	const gchar* _tmp31_;
	ChessEngine* _tmp40_;
	AIProfile* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	profile = NULL;
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "human") == 0) {
		result = NULL;
		_ai_profile_unref0 (profile);
		_g_object_unref0 (engine);
		return result;
	}
	_tmp1_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp1_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp2_;
			AIProfile* p = NULL;
			_tmp2_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
			p = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
				gboolean _tmp8_;
				_tmp4_ = name;
				if (g_strcmp0 (_tmp4_, "") == 0) {
					_tmp3_ = TRUE;
				} else {
					AIProfile* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = p;
					_tmp6_ = _tmp5_->name;
					_tmp7_ = name;
					_tmp3_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
				}
				_tmp8_ = _tmp3_;
				if (_tmp8_) {
					AIProfile* _tmp9_;
					AIProfile* _tmp10_;
					_tmp9_ = p;
					_tmp10_ = _ai_profile_ref0 (_tmp9_);
					_ai_profile_unref0 (profile);
					profile = _tmp10_;
					_ai_profile_unref0 (p);
					break;
				}
				_ai_profile_unref0 (p);
			}
		}
	}
	_tmp11_ = profile;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_;
		GList* _tmp13_;
		GList* _tmp14_;
		gconstpointer _tmp15_;
		AIProfile* _tmp16_;
		_tmp12_ = name;
		g_warning ("glchess.vala:355: Unknown AI profile %s", _tmp12_);
		_tmp13_ = self->priv->ai_profiles;
		if (_tmp13_ == NULL) {
			result = NULL;
			_ai_profile_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
		_tmp14_ = self->priv->ai_profiles;
		_tmp15_ = _tmp14_->data;
		_tmp16_ = _ai_profile_ref0 ((AIProfile*) _tmp15_);
		_ai_profile_unref0 (profile);
		profile = _tmp16_;
	}
	_tmp17_ = difficulty;
	_tmp18_ = _tmp17_;
	_tmp20_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
	if (_tmp20_ == ((0 != _tmp19_label0) ? _tmp19_label0 : (_tmp19_label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gchar** _tmp23_;
				gint _tmp23__length1;
				_tmp21_ = profile;
				_tmp22_ = _tmp21_->easy_options;
				_tmp22__length1 = _tmp21_->easy_options_length1;
				_tmp23_ = (_tmp22_ != NULL) ? _vala_array_dup2 (_tmp22_, _tmp22__length1) : ((gpointer) _tmp22_);
				_tmp23__length1 = _tmp22__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp23_;
				options_length1 = _tmp23__length1;
				_options_size_ = options_length1;
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label1) ? _tmp19_label1 : (_tmp19_label1 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				gchar** _tmp26_;
				gint _tmp26__length1;
				_tmp24_ = profile;
				_tmp25_ = _tmp24_->hard_options;
				_tmp25__length1 = _tmp24_->hard_options_length1;
				_tmp26_ = (_tmp25_ != NULL) ? _vala_array_dup3 (_tmp25_, _tmp25__length1) : ((gpointer) _tmp25_);
				_tmp26__length1 = _tmp25__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp26_;
				options_length1 = _tmp26__length1;
				_options_size_ = options_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				AIProfile* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar** _tmp29_;
				gint _tmp29__length1;
				_tmp27_ = profile;
				_tmp28_ = _tmp27_->normal_options;
				_tmp28__length1 = _tmp27_->normal_options_length1;
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup4 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
				_tmp29__length1 = _tmp28__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp29_;
				options_length1 = _tmp29__length1;
				_options_size_ = options_length1;
				break;
			}
		}
	}
	_tmp30_ = profile;
	_tmp31_ = _tmp30_->protocol;
	if (g_strcmp0 (_tmp31_, "cecp") == 0) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		ChessEngineCECP* _tmp33_;
		_tmp32_ = options;
		_tmp32__length1 = options_length1;
		_tmp33_ = chess_engine_cecp_new (_tmp32_, _tmp32__length1);
		_g_object_unref0 (engine);
		engine = (ChessEngine*) _tmp33_;
	} else {
		AIProfile* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = profile;
		_tmp35_ = _tmp34_->protocol;
		if (g_strcmp0 (_tmp35_, "uci") == 0) {
			gchar** _tmp36_;
			gint _tmp36__length1;
			ChessEngineUCI* _tmp37_;
			_tmp36_ = options;
			_tmp36__length1 = options_length1;
			_tmp37_ = chess_engine_uci_new (_tmp36_, _tmp36__length1);
			_g_object_unref0 (engine);
			engine = (ChessEngine*) _tmp37_;
		} else {
			AIProfile* _tmp38_;
			const gchar* _tmp39_;
			_tmp38_ = profile;
			_tmp39_ = _tmp38_->protocol;
			g_warning ("glchess.vala:382: Unknown AI protocol %s", _tmp39_);
			result = NULL;
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
			_ai_profile_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
	}
	_tmp40_ = engine;
	_tmp41_ = profile;
	_tmp42_ = _tmp41_->binary;
	_tmp43_ = g_strdup (_tmp42_);
	_g_free0 (_tmp40_->binary);
	_tmp40_->binary = _tmp43_;
	result = engine;
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_ai_profile_unref0 (profile);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void application_start (Application* self, GFile* game, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	GFile* _tmp9_;
	GtkWindow* _tmp18_;
	GSettings* _tmp19_;
	gint _tmp20_ = 0;
	GSettings* _tmp21_;
	gint _tmp22_ = 0;
	GSettings* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_build_filename (PKGDATADIR, "engines.conf", NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = load_ai_profiles (_tmp1_);
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
	self->priv->ai_profiles = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = self->priv->ai_profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp3_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			AIProfile* _tmp4_;
			AIProfile* profile = NULL;
			_tmp4_ = _ai_profile_ref0 ((AIProfile*) profile_it->data);
			profile = _tmp4_;
			{
				AIProfile* _tmp5_;
				const gchar* _tmp6_;
				AIProfile* _tmp7_;
				const gchar* _tmp8_;
				_tmp5_ = profile;
				_tmp6_ = _tmp5_->name;
				_tmp7_ = profile;
				_tmp8_ = _tmp7_->path;
				g_message ("glchess.vala:394: Detected AI profile %s in %s", _tmp6_, _tmp8_);
				_ai_profile_unref0 (profile);
			}
		}
	}
	_tmp9_ = game;
	if (_tmp9_ == NULL) {
		History* _tmp10_;
		GList* _tmp11_ = NULL;
		GList* unfinished;
		GList* _tmp12_;
		_tmp10_ = self->priv->history;
		_tmp11_ = history_get_unfinished (_tmp10_);
		unfinished = _tmp11_;
		_tmp12_ = unfinished;
		if (_tmp12_ != NULL) {
			GList* _tmp13_;
			gconstpointer _tmp14_;
			GFile* _tmp15_;
			GFile* file;
			GFile* _tmp16_;
			_tmp13_ = unfinished;
			_tmp14_ = _tmp13_->data;
			_tmp15_ = _g_object_ref0 ((GFile*) _tmp14_);
			file = _tmp15_;
			_tmp16_ = file;
			application_load_game (self, _tmp16_, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				__g_list_free__g_object_unref0_0 (unfinished);
				return;
			}
			_g_object_unref0 (file);
		} else {
			application_start_new_game (self);
		}
		__g_list_free__g_object_unref0_0 (unfinished);
	} else {
		GFile* _tmp17_;
		_tmp17_ = game;
		application_load_game (self, _tmp17_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp18_ = self->priv->window;
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_int (_tmp19_, "width");
	_tmp21_ = self->priv->settings;
	_tmp22_ = g_settings_get_int (_tmp21_, "height");
	gtk_window_set_default_size (_tmp18_, _tmp20_, _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_boolean (_tmp23_, "fullscreen");
	if (_tmp24_) {
		GtkWindow* _tmp25_;
		_tmp25_ = self->priv->window;
		gtk_window_fullscreen (_tmp25_);
	} else {
		GSettings* _tmp26_;
		gboolean _tmp27_ = FALSE;
		_tmp26_ = self->priv->settings;
		_tmp27_ = g_settings_get_boolean (_tmp26_, "maximized");
		if (_tmp27_) {
			GtkWindow* _tmp28_;
			_tmp28_ = self->priv->window;
			gtk_window_maximize (_tmp28_);
		}
	}
	application_show (self);
}


static void application_real_activate (GApplication* base) {
	Application * self;
	GtkWindow* _tmp0_;
	self = (Application*) base;
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void application_engine_ready_cb (Application* self, ChessEngine* engine) {
	ChessEngine* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent_engine;
	_tmp1_ = chess_engine_get_ready (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessGame* _tmp3_;
		ChessView* _tmp4_;
		_tmp3_ = self->priv->game;
		chess_game_start (_tmp3_);
		_tmp4_ = self->priv->view;
		gtk_widget_queue_draw ((GtkWidget*) _tmp4_);
	}
}


static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move) {
	ChessPlayer* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->opponent;
	_tmp1_ = move;
	chess_player_move (_tmp0_, _tmp1_, TRUE);
}


static void application_game_start_cb (Application* self, ChessGame* game) {
	ChessEngine* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_start_game (_tmp1_);
	}
}


static void application_game_clock_tick_cb (Application* self, ChessClock* clock) {
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp1_);
}


static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player) {
	gboolean _tmp0_ = FALSE;
	ChessEngine* _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (player != NULL);
	_tmp1_ = self->priv->opponent_engine;
	if (_tmp1_ != NULL) {
		ChessPlayer* _tmp2_;
		ChessPlayer* _tmp3_;
		_tmp2_ = player;
		_tmp3_ = self->priv->opponent;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		ChessEngine* _tmp5_;
		_tmp5_ = self->priv->opponent_engine;
		chess_engine_request_move (_tmp5_);
	}
}


static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move) {
	static const gchar* human_descriptions[] = {"White pawn moves from %1$s to %2$s", "White pawn at %1$s takes the black pawn at %2$s", "White pawn at %1$s takes the black rook at %2$s", "White pawn at %1$s takes the black knight at %2$s", "White pawn at %1$s takes the black bishop at %2$s", "White pawn at %1$s takes the black queen at %2$s", "White rook moves from %1$s to %2$s", "White rook at %1$s takes the black pawn at %2$s", "White rook at %1$s takes the black rook at %2$s", "White rook at %1$s takes the black knight at %2$s", "White rook at %1$s takes the black bishop at %2$s", "White rook at %1$s takes the black queen at %2$s", "White knight moves from %1$s to %2$s", "White knight at %1$s takes the black pawn at %2$s", "White knight at %1$s takes the black rook at %2$s", "White knight at %1$s takes the black knight at %2$s", "White knight at %1$s takes the black bishop at %2$s", "White knight at %1$s takes the black queen at %2$s", "White bishop moves from %1$s to %2$s", "White bishop at %1$s takes the black pawn at %2$s", "White bishop at %1$s takes the black rook at %2$s", "White bishop at %1$s takes the black knight at %2$s", "White bishop at %1$s takes the black bishop at %2$s", "White bishop at %1$s takes the black queen at %2$s", "White queen moves from %1$s to %2$s", "White queen at %1$s takes the black pawn at %2$s", "White queen at %1$s takes the black rook at %2$s", "White queen at %1$s takes the black knight at %2$s", "White queen at %1$s takes the black bishop at %2$s", "White queen at %1$s takes the black queen at %2$s", "White king moves from %1$s to %2$s", "White king at %1$s takes the black pawn at %2$s", "White king at %1$s takes the black rook at %2$s", "White king at %1$s takes the black knight at %2$s", "White king at %1$s takes the black bishop at %2$s", "White king at %1$s takes the black queen at %2$s", "Black pawn moves from %1$s to %2$s", "Black pawn at %1$s takes the white pawn at %2$s", "Black pawn at %1$s takes the white rook at %2$s", "Black pawn at %1$s takes the white knight at %2$s", "Black pawn at %1$s takes the white bishop at %2$s", "Black pawn at %1$s takes the white queen at %2$s", "Black rook moves from %1$s to %2$s", "Black rook at %1$s takes the white pawn at %2$s", "Black rook at %1$s takes the white rook at %2$s", "Black rook at %1$s takes the white knight at %2$s", "Black rook at %1$s takes the white bishop at %2$s", "Black rook at %1$s takes the white queen at %2$s", "Black knight moves from %1$s to %2$s", "Black knight at %1$s takes the white pawn at %2$s", "Black knight at %1$s takes the white rook at %2$s", "Black knight at %1$s takes the white knight at %2$s", "Black knight at %1$s takes the white bishop at %2$s", "Black knight at %1$s takes the white queen at %2$s", "Black bishop moves from %1$s to %2$s", "Black bishop at %1$s takes the white pawn at %2$s", "Black bishop at %1$s takes the white rook at %2$s", "Black bishop at %1$s takes the white knight at %2$s", "Black bishop at %1$s takes the white bishop at %2$s", "Black bishop at %1$s takes the white queen at %2$s", "Black queen moves from %1$s to %2$s", "Black queen at %1$s takes the white pawn at %2$s", "Black queen at %1$s takes the white rook at %2$s", "Black queen at %1$s takes the white knight at %2$s", "Black queen at %1$s takes the white bishop at %2$s", "Black queen at %1$s takes the white queen at %2$s", "Black king moves from %1$s to %2$s", "Black king at %1$s takes the white pawn at %2$s", "Black king at %1$s takes the white rook at %2$s", "Black king at %1$s takes the white knight at %2$s", "Black king at %1$s takes the white bishop at %2$s", "Black king at %1$s takes the white queen at %2$s"};
	gchar* _tmp0_;
	gchar* move_text;
	ChessScene* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	GtkComboBox* _tmp43_;
	GtkTreeModel* _tmp44_;
	GtkTreeModel* _tmp45_;
	GtkListStore* _tmp46_;
	GtkListStore* model;
	gchar _tmp47_ = '\0';
	ChessMove* _tmp48_;
	gint _tmp49_;
	ChessMove* _tmp50_;
	gint _tmp51_;
	gchar _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_ = NULL;
	gchar* label;
	GtkListStore* _tmp55_;
	GtkTreeIter _tmp56_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = g_strdup ("");
	move_text = _tmp0_;
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				gint index = 0;
				ChessMove* _tmp7_;
				ChessPiece* _tmp8_;
				gint _tmp12_;
				ChessMove* _tmp13_;
				ChessPiece* _tmp14_;
				PieceType _tmp15_;
				ChessMove* _tmp16_;
				ChessPiece* _tmp17_;
				ChessPlayer* _tmp18_;
				Color _tmp19_;
				ChessMove* _tmp21_;
				gint _tmp22_;
				ChessMove* _tmp23_;
				gint _tmp24_;
				gchar* _tmp25_ = NULL;
				gchar* start;
				ChessMove* _tmp26_;
				gint _tmp27_;
				ChessMove* _tmp28_;
				gint _tmp29_;
				gchar* _tmp30_ = NULL;
				gchar* end;
				gint _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_ = NULL;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_ = NULL;
				_tmp7_ = move;
				_tmp8_ = _tmp7_->victim;
				if (_tmp8_ == NULL) {
					index = 0;
				} else {
					ChessMove* _tmp9_;
					ChessPiece* _tmp10_;
					PieceType _tmp11_;
					_tmp9_ = move;
					_tmp10_ = _tmp9_->victim;
					_tmp11_ = _tmp10_->type;
					index = (gint) (_tmp11_ + 1);
				}
				_tmp12_ = index;
				_tmp13_ = move;
				_tmp14_ = _tmp13_->piece;
				_tmp15_ = _tmp14_->type;
				index = _tmp12_ + (_tmp15_ * 6);
				_tmp16_ = move;
				_tmp17_ = _tmp16_->piece;
				_tmp18_ = _tmp17_->player;
				_tmp19_ = _tmp18_->color;
				if (_tmp19_ == COLOR_BLACK) {
					gint _tmp20_;
					_tmp20_ = index;
					index = _tmp20_ + 36;
				}
				_tmp21_ = move;
				_tmp22_ = _tmp21_->f0;
				_tmp23_ = move;
				_tmp24_ = _tmp23_->r0;
				_tmp25_ = g_strdup_printf ("%c%d", 'a' + _tmp22_, _tmp24_ + 1);
				start = _tmp25_;
				_tmp26_ = move;
				_tmp27_ = _tmp26_->f1;
				_tmp28_ = move;
				_tmp29_ = _tmp28_->r1;
				_tmp30_ = g_strdup_printf ("%c%d", 'a' + _tmp27_, _tmp29_ + 1);
				end = _tmp30_;
				_tmp31_ = index;
				_tmp32_ = human_descriptions[_tmp31_];
				_tmp33_ = _ (_tmp32_);
				_tmp34_ = start;
				_tmp35_ = end;
				_tmp36_ = g_strdup_printf (_tmp33_, _tmp34_, _tmp35_);
				_g_free0 (move_text);
				move_text = _tmp36_;
				_g_free0 (end);
				_g_free0 (start);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp37_;
				gchar* _tmp38_ = NULL;
				_tmp37_ = move;
				_tmp38_ = chess_move_get_san (_tmp37_);
				_g_free0 (move_text);
				move_text = _tmp38_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp39_;
				gchar* _tmp40_ = NULL;
				_tmp39_ = move;
				_tmp40_ = chess_move_get_fan (_tmp39_);
				_g_free0 (move_text);
				move_text = _tmp40_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				ChessMove* _tmp41_;
				gchar* _tmp42_ = NULL;
				_tmp41_ = move;
				_tmp42_ = chess_move_get_lan (_tmp41_);
				_g_free0 (move_text);
				move_text = _tmp42_;
				break;
			}
		}
	}
	_tmp43_ = self->priv->history_combo;
	_tmp44_ = gtk_combo_box_get_model (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _g_object_ref0 (GTK_LIST_STORE (_tmp45_));
	model = _tmp46_;
	_tmp48_ = move;
	_tmp49_ = _tmp48_->number;
	if ((_tmp49_ % 2) == 0) {
		_tmp47_ = 'b';
	} else {
		_tmp47_ = 'a';
	}
	_tmp50_ = move;
	_tmp51_ = _tmp50_->number;
	_tmp52_ = _tmp47_;
	_tmp53_ = move_text;
	_tmp54_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp51_ + 1) / 2), (gint) _tmp52_, _tmp53_);
	label = _tmp54_;
	_tmp55_ = model;
	_tmp56_ = *iter;
	gtk_list_store_set (_tmp55_, &_tmp56_, 0, label, -1, -1);
	_g_free0 (label);
	_g_object_unref0 (model);
	_g_free0 (move_text);
}


static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_;
	gint _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	ChessMove* _tmp9_;
	gint _tmp10_;
	PGNGame* _tmp11_;
	GList* _tmp12_;
	guint _tmp13_ = 0U;
	GtkComboBox* _tmp17_;
	GtkTreeModel* _tmp18_;
	GtkTreeModel* _tmp19_;
	GtkListStore* _tmp20_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp21_;
	GtkTreeIter _tmp22_ = {0};
	GtkListStore* _tmp23_;
	GtkTreeIter _tmp24_;
	ChessMove* _tmp25_;
	gint _tmp26_;
	GtkTreeIter _tmp27_;
	ChessMove* _tmp28_;
	gboolean _tmp29_ = FALSE;
	ChessMove* _tmp30_;
	gint _tmp31_;
	ChessGame* _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	gboolean _tmp38_;
	GtkWidget* _tmp41_;
	GtkWidget* _tmp42_;
	ChessEngine* _tmp43_;
	ChessView* _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	self->priv->game_needs_saving = TRUE;
	_tmp2_ = move;
	_tmp3_ = _tmp2_->number;
	if (_tmp3_ == 1) {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->priv->opponent;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		ChessPlayer* _tmp6_;
		Color _tmp7_;
		_tmp6_ = self->priv->opponent;
		_tmp7_ = _tmp6_->color;
		_tmp0_ = _tmp7_ == COLOR_WHITE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		self->priv->game_needs_saving = FALSE;
	}
	_tmp9_ = move;
	_tmp10_ = _tmp9_->number;
	_tmp11_ = self->priv->pgn_game;
	_tmp12_ = _tmp11_->moves;
	_tmp13_ = g_list_length (_tmp12_);
	if (((guint) _tmp10_) > _tmp13_) {
		PGNGame* _tmp14_;
		ChessMove* _tmp15_;
		gchar* _tmp16_ = NULL;
		_tmp14_ = self->priv->pgn_game;
		_tmp15_ = move;
		_tmp16_ = chess_move_get_san (_tmp15_);
		_tmp14_->moves = g_list_append (_tmp14_->moves, _tmp16_);
	}
	_tmp17_ = self->priv->history_combo;
	_tmp18_ = gtk_combo_box_get_model (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _g_object_ref0 (GTK_LIST_STORE (_tmp19_));
	model = _tmp20_;
	_tmp21_ = model;
	gtk_list_store_append (_tmp21_, &_tmp22_);
	iter = _tmp22_;
	_tmp23_ = model;
	_tmp24_ = iter;
	_tmp25_ = move;
	_tmp26_ = _tmp25_->number;
	gtk_list_store_set (_tmp23_, &_tmp24_, 1, _tmp26_, -1, -1);
	_tmp27_ = iter;
	_tmp28_ = move;
	application_set_move_text (self, &_tmp27_, _tmp28_);
	_tmp30_ = move;
	_tmp31_ = _tmp30_->number;
	_tmp32_ = game;
	_tmp33_ = chess_game_get_n_moves (_tmp32_);
	_tmp34_ = _tmp33_;
	if (((guint) _tmp31_) == _tmp34_) {
		ChessScene* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		_tmp35_ = self->priv->scene;
		_tmp36_ = chess_scene_get_move_number (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp29_ = _tmp37_ == (-1);
	} else {
		_tmp29_ = FALSE;
	}
	_tmp38_ = _tmp29_;
	if (_tmp38_) {
		GtkComboBox* _tmp39_;
		GtkTreeIter _tmp40_;
		_tmp39_ = self->priv->history_combo;
		_tmp40_ = iter;
		gtk_combo_box_set_active_iter (_tmp39_, &_tmp40_);
	}
	_tmp41_ = self->priv->save_menu;
	gtk_widget_set_sensitive (_tmp41_, TRUE);
	_tmp42_ = self->priv->save_as_menu;
	gtk_widget_set_sensitive (_tmp42_, TRUE);
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_tmp43_ = self->priv->opponent_engine;
	if (_tmp43_ != NULL) {
		ChessEngine* _tmp44_;
		ChessMove* _tmp45_;
		_tmp44_ = self->priv->opponent_engine;
		_tmp45_ = move;
		chess_engine_report_move (_tmp44_, _tmp45_);
	}
	_tmp46_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp46_);
	_g_object_unref0 (model);
}


static void application_game_undo_cb (Application* self, ChessGame* game) {
	ChessEngine* _tmp0_;
	PGNGame* _tmp2_;
	PGNGame* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_ = NULL;
	GtkComboBox* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkListStore* _tmp9_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_;
	GtkListStore* _tmp11_;
	gint _tmp12_ = 0;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_;
	GtkTreeIter _tmp15_;
	gboolean _tmp16_ = FALSE;
	ChessScene* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	ChessGame* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_undo (_tmp1_);
	}
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = _tmp3_->moves;
	_tmp5_ = g_list_last (_tmp4_);
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
	_tmp6_ = self->priv->history_combo;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (GTK_LIST_STORE (_tmp8_));
	model = _tmp9_;
	_tmp10_ = model;
	_tmp11_ = model;
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
	iter = _tmp13_;
	_tmp14_ = model;
	_tmp15_ = iter;
	gtk_list_store_remove (_tmp14_, &_tmp15_);
	_tmp17_ = self->priv->scene;
	_tmp18_ = chess_scene_get_move_number (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = game;
	_tmp21_ = chess_game_get_n_moves (_tmp20_);
	_tmp22_ = _tmp21_;
	if (((guint) _tmp19_) > _tmp22_) {
		_tmp16_ = TRUE;
	} else {
		ChessScene* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp23_ = self->priv->scene;
		_tmp24_ = chess_scene_get_move_number (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp16_ = _tmp25_ == (-1);
	}
	_tmp26_ = _tmp16_;
	if (_tmp26_) {
		GtkListStore* _tmp27_;
		GtkListStore* _tmp28_;
		gint _tmp29_ = 0;
		GtkTreeIter _tmp30_ = {0};
		GtkComboBox* _tmp31_;
		GtkTreeIter _tmp32_;
		ChessView* _tmp33_;
		_tmp27_ = model;
		_tmp28_ = model;
		_tmp29_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp28_, NULL);
		gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp27_, &_tmp30_, NULL, _tmp29_ - 1);
		iter = _tmp30_;
		_tmp31_ = self->priv->history_combo;
		_tmp32_ = iter;
		gtk_combo_box_set_active_iter (_tmp31_, &_tmp32_);
		_tmp33_ = self->priv->view;
		gtk_widget_queue_draw ((GtkWidget*) _tmp33_);
	}
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_g_object_unref0 (model);
}


static void application_update_control_buttons (Application* self) {
	ChessGame* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean can_resign;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	gboolean _tmp5_;
	ChessGame* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	gboolean can_undo;
	gboolean _tmp9_ = FALSE;
	ChessPlayer* _tmp10_;
	gboolean _tmp13_;
	GtkWidget* _tmp17_;
	GtkWidget* _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_n_moves (_tmp0_);
	_tmp2_ = _tmp1_;
	can_resign = _tmp2_ > ((guint) 0);
	_tmp3_ = self->priv->resign_menu;
	_tmp4_ = self->priv->resign_button;
	_tmp5_ = can_resign;
	gtk_widget_set_sensitive (_tmp4_, _tmp5_);
	gtk_widget_set_sensitive (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->game;
	_tmp7_ = chess_game_get_n_moves (_tmp6_);
	_tmp8_ = _tmp7_;
	can_undo = _tmp8_ > ((guint) 0);
	_tmp10_ = self->priv->opponent;
	if (_tmp10_ != NULL) {
		ChessPlayer* _tmp11_;
		Color _tmp12_;
		_tmp11_ = self->priv->opponent;
		_tmp12_ = _tmp11_->color;
		_tmp9_ = _tmp12_ == COLOR_WHITE;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp13_ = _tmp9_;
	if (_tmp13_) {
		ChessGame* _tmp14_;
		guint _tmp15_;
		guint _tmp16_;
		_tmp14_ = self->priv->game;
		_tmp15_ = chess_game_get_n_moves (_tmp14_);
		_tmp16_ = _tmp15_;
		can_undo = _tmp16_ > ((guint) 1);
	}
	_tmp17_ = self->priv->undo_menu;
	_tmp18_ = self->priv->undo_button;
	_tmp19_ = can_undo;
	gtk_widget_set_sensitive (_tmp18_, _tmp19_);
	gtk_widget_set_sensitive (_tmp17_, _tmp19_);
}


static void application_game_end_cb (Application* self, ChessGame* game) {
	gchar* _tmp0_;
	gchar* title;
	ChessGame* _tmp1_;
	ChessResult _tmp2_;
	gchar* _tmp15_;
	gchar* reason;
	ChessGame* _tmp16_;
	ChessRule _tmp17_;
	GtkLabel* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
	GtkLabel* _tmp48_;
	const gchar* _tmp49_;
	GtkInfoBar* _tmp50_;
	GtkWidget* _tmp51_;
	GtkWidget* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = g_strdup ("");
	title = _tmp0_;
	_tmp1_ = game;
	_tmp2_ = _tmp1_->result;
	switch (_tmp2_) {
		case CHESS_RESULT_WHITE_WON:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			PGNGame* _tmp5_;
			const gchar* _tmp6_;
			_tmp3_ = _ ("White wins");
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (title);
			title = _tmp4_;
			_tmp5_ = self->priv->pgn_game;
			_tmp6_ = pgn_game_RESULT_WHITE;
			pgn_game_set_result (_tmp5_, _tmp6_);
			break;
		}
		case CHESS_RESULT_BLACK_WON:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			PGNGame* _tmp9_;
			const gchar* _tmp10_;
			_tmp7_ = _ ("Black wins");
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (title);
			title = _tmp8_;
			_tmp9_ = self->priv->pgn_game;
			_tmp10_ = pgn_game_RESULT_BLACK;
			pgn_game_set_result (_tmp9_, _tmp10_);
			break;
		}
		case CHESS_RESULT_DRAW:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			PGNGame* _tmp13_;
			const gchar* _tmp14_;
			_tmp11_ = _ ("Game is drawn");
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (title);
			title = _tmp12_;
			_tmp13_ = self->priv->pgn_game;
			_tmp14_ = pgn_game_RESULT_DRAW;
			pgn_game_set_result (_tmp13_, _tmp14_);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp15_ = g_strdup ("");
	reason = _tmp15_;
	_tmp16_ = game;
	_tmp17_ = _tmp16_->rule;
	switch (_tmp17_) {
		case CHESS_RULE_CHECKMATE:
		{
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			_tmp18_ = _ ("Opponent is in check and cannot move (checkmate)");
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (reason);
			reason = _tmp19_;
			break;
		}
		case CHESS_RULE_STALEMATE:
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp20_ = _ ("Opponent cannot move (stalemate)");
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (reason);
			reason = _tmp21_;
			break;
		}
		case CHESS_RULE_FIFTY_MOVES:
		{
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			_tmp22_ = _ ("No piece has been taken or pawn moved in the last fifty moves");
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (reason);
			reason = _tmp23_;
			break;
		}
		case CHESS_RULE_TIMEOUT:
		{
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp24_ = _ ("Opponent has run out of time");
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (reason);
			reason = _tmp25_;
			break;
		}
		case CHESS_RULE_THREE_FOLD_REPETITION:
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp26_ = _ ("The same board state has occurred three times (three fold repetition)");
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (reason);
			reason = _tmp27_;
			break;
		}
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
		{
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			_tmp28_ = _ ("Neither player can cause checkmate (insufficient material)");
			_tmp29_ = g_strdup (_tmp28_);
			_g_free0 (reason);
			reason = _tmp29_;
			break;
		}
		case CHESS_RULE_RESIGN:
		{
			ChessGame* _tmp30_;
			ChessResult _tmp31_;
			_tmp30_ = game;
			_tmp31_ = _tmp30_->result;
			if (_tmp31_ == CHESS_RESULT_WHITE_WON) {
				const gchar* _tmp32_ = NULL;
				gchar* _tmp33_;
				_tmp32_ = _ ("The black player has resigned");
				_tmp33_ = g_strdup (_tmp32_);
				_g_free0 (reason);
				reason = _tmp33_;
			} else {
				const gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				_tmp34_ = _ ("The white player has resigned");
				_tmp35_ = g_strdup (_tmp34_);
				_g_free0 (reason);
				reason = _tmp35_;
			}
			break;
		}
		case CHESS_RULE_ABANDONMENT:
		{
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			PGNGame* _tmp38_;
			const gchar* _tmp39_;
			_tmp36_ = _ ("The game has been abandoned");
			_tmp37_ = g_strdup (_tmp36_);
			_g_free0 (reason);
			reason = _tmp37_;
			_tmp38_ = self->priv->pgn_game;
			_tmp39_ = pgn_game_TERMINATE_ABANDONED;
			pgn_game_set_termination (_tmp38_, _tmp39_);
			break;
		}
		case CHESS_RULE_DEATH:
		{
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			PGNGame* _tmp42_;
			const gchar* _tmp43_;
			_tmp40_ = _ ("One of the players has died");
			_tmp41_ = g_strdup (_tmp40_);
			_g_free0 (reason);
			reason = _tmp41_;
			_tmp42_ = self->priv->pgn_game;
			_tmp43_ = pgn_game_TERMINATE_DEATH;
			pgn_game_set_termination (_tmp42_, _tmp43_);
			break;
		}
		default:
		break;
	}
	_tmp44_ = self->priv->info_title_label;
	_tmp45_ = title;
	_tmp46_ = g_strdup_printf ("<big><b>%s</b></big>", _tmp45_);
	_tmp47_ = _tmp46_;
	gtk_label_set_markup (_tmp44_, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->info_label;
	_tmp49_ = reason;
	gtk_label_set_text (_tmp48_, _tmp49_);
	_tmp50_ = self->priv->info_bar;
	gtk_widget_show ((GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp51_);
	_tmp52_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp52_);
	_g_free0 (reason);
	_g_free0 (title);
}


void application_show (Application* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


gboolean G_MODULE_EXPORT glchess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	application_quit_game (self);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT glchess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "maximized");
	if (!_tmp2_) {
		GSettings* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_boolean (_tmp3_, "fullscreen");
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GSettings* _tmp6_;
		GdkEventConfigure _tmp7_;
		gint _tmp8_;
		GSettings* _tmp9_;
		GdkEventConfigure _tmp10_;
		gint _tmp11_;
		_tmp6_ = self->priv->settings;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.width;
		g_settings_set_int (_tmp6_, "width", _tmp8_);
		_tmp9_ = self->priv->settings;
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.height;
		g_settings_set_int (_tmp9_, "height", _tmp11_);
	}
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT glchess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_;
	GdkWindowState _tmp1_;
	GdkEventWindowState _tmp6_;
	GdkWindowState _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_;
		GdkWindowState _tmp3_;
		gboolean is_maximized;
		GSettings* _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = is_maximized;
		g_settings_set_boolean (_tmp4_, "maximized", _tmp5_);
	}
	_tmp6_ = *event;
	_tmp7_ = _tmp6_.changed_mask;
	if ((_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState _tmp8_;
		GdkWindowState _tmp9_;
		gboolean is_fullscreen;
		GSettings* _tmp10_;
		gboolean _tmp11_;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_;
		GtkMenuItem* _tmp14_;
		const gchar* _tmp15_;
		_tmp8_ = *event;
		_tmp9_ = _tmp8_.new_window_state;
		is_fullscreen = (_tmp9_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
		_tmp10_ = self->priv->settings;
		_tmp11_ = is_fullscreen;
		g_settings_set_boolean (_tmp10_, "fullscreen", _tmp11_);
		_tmp13_ = is_fullscreen;
		if (_tmp13_) {
			_tmp12_ = GTK_STOCK_LEAVE_FULLSCREEN;
		} else {
			_tmp12_ = GTK_STOCK_FULLSCREEN;
		}
		_tmp14_ = self->priv->fullscreen_menu;
		_tmp15_ = _tmp12_;
		gtk_menu_item_set_label (_tmp14_, _tmp15_);
	}
	result = FALSE;
	return result;
}


void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp1_ = self->priv->game_needs_saving;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->in_history;
		if (_tmp3_) {
			GFile* _tmp4_;
			_tmp4_ = self->priv->game_file;
			_tmp2_ = _tmp4_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp5_ = _tmp2_;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		GtkWindow* _tmp7_;
		const gchar* _tmp8_ = NULL;
		GtkMessageDialog* _tmp9_;
		GtkMessageDialog* _tmp10_;
		GtkMessageDialog* dialog;
		GtkMessageDialog* _tmp11_;
		GtkMessageDialog* _tmp12_;
		const gchar* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_;
		const gchar* _tmp15_ = NULL;
		GtkMessageDialog* _tmp16_;
		gint _tmp17_ = 0;
		gint _result_;
		GtkMessageDialog* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp7_ = self->priv->window;
		_tmp8_ = _ ("Save this game before starting a new one?");
		_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp7_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "<span weight=\"bold\" size=\"larger\">%s</span>", _tmp8_);
		_tmp10_ = g_object_ref_sink (_tmp9_);
		dialog = _tmp10_;
		_tmp11_ = dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp11_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
		_tmp12_ = dialog;
		_tmp13_ = _ ("_Abandon game");
		gtk_dialog_add_button ((GtkDialog*) _tmp12_, _tmp13_, (gint) GTK_RESPONSE_NO);
		_tmp14_ = dialog;
		_tmp15_ = _ ("_Save game for later");
		gtk_dialog_add_button ((GtkDialog*) _tmp14_, _tmp15_, (gint) GTK_RESPONSE_YES);
		_tmp16_ = dialog;
		_tmp17_ = gtk_dialog_run ((GtkDialog*) _tmp16_);
		_result_ = _tmp17_;
		_tmp18_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp18_);
		_tmp19_ = _result_;
		if (_tmp19_ == ((gint) GTK_RESPONSE_CANCEL)) {
			_g_object_unref0 (dialog);
			return;
		}
		_tmp20_ = _result_;
		if (_tmp20_ == ((gint) GTK_RESPONSE_NO)) {
			self->priv->in_history = FALSE;
			self->priv->game_needs_saving = FALSE;
		}
		_g_object_unref0 (dialog);
	}
	application_autosave (self);
	application_start_new_game (self);
}


void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self) {
	ChessGame* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_current_player (_tmp0_);
	_tmp2_ = _tmp1_;
	chess_player_resign (_tmp2_);
}


void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self) {
	ChessGame* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_current_player (_tmp0_);
	_tmp2_ = _tmp1_;
	chess_player_claim_draw (_tmp2_);
}


void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self) {
	ChessPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->opponent;
	if (_tmp0_ != NULL) {
		ChessPlayer* _tmp1_;
		_tmp1_ = self->priv->human_player;
		chess_player_undo (_tmp1_);
	} else {
		ChessGame* _tmp2_;
		ChessPlayer* _tmp3_;
		ChessPlayer* _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = chess_game_get_opponent (_tmp2_);
		_tmp4_ = _tmp3_;
		chess_player_undo (_tmp4_);
	}
}


void G_MODULE_EXPORT quit_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_quit_game (self);
}


gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	gdouble _tmp0_[3] = {0};
	gdouble fg[3];
	gdouble _tmp1_[3] = {0};
	gdouble bg[3];
	GtkWidget* _tmp2_;
	cairo_t* _tmp3_;
	ChessGame* _tmp4_;
	ChessClock* _tmp5_;
	ChessClock* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 0.0;
	_tmp0_[1] = 0.0;
	_tmp0_[2] = 0.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 1.0;
	_tmp1_[1] = 1.0;
	_tmp1_[2] = 1.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = application_make_clock_text (self, _tmp6_, COLOR_WHITE);
	_tmp8_ = _tmp7_;
	application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	gdouble _tmp0_[3] = {0};
	gdouble fg[3];
	gdouble _tmp1_[3] = {0};
	gdouble bg[3];
	GtkWidget* _tmp2_;
	cairo_t* _tmp3_;
	ChessGame* _tmp4_;
	ChessClock* _tmp5_;
	ChessClock* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 1.0;
	_tmp0_[1] = 1.0;
	_tmp0_[2] = 1.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 0.0;
	_tmp1_[1] = 0.0;
	_tmp1_[2] = 0.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = application_make_clock_text (self, _tmp6_, COLOR_BLACK);
	_tmp8_ = _tmp7_;
	application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_;
	gint used = 0;
	Color _tmp2_;
	gint _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clock;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("∞");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessGame* _tmp3_;
		ChessClock* _tmp4_;
		ChessClock* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		ChessGame* _tmp8_;
		ChessClock* _tmp9_;
		ChessClock* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		_tmp3_ = self->priv->game;
		_tmp4_ = chess_game_get_clock (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = chess_clock_get_white_duration (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->game;
		_tmp9_ = chess_game_get_clock (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = chess_clock_get_white_used_in_seconds (_tmp10_);
		_tmp12_ = _tmp11_;
		used = (gint) ((_tmp7_ / 1000) - _tmp12_);
	} else {
		ChessGame* _tmp13_;
		ChessClock* _tmp14_;
		ChessClock* _tmp15_;
		guint _tmp16_;
		guint _tmp17_;
		ChessGame* _tmp18_;
		ChessClock* _tmp19_;
		ChessClock* _tmp20_;
		guint _tmp21_;
		guint _tmp22_;
		_tmp13_ = self->priv->game;
		_tmp14_ = chess_game_get_clock (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = chess_clock_get_black_duration (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_clock (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = chess_clock_get_black_used_in_seconds (_tmp20_);
		_tmp22_ = _tmp21_;
		used = (gint) ((_tmp17_ / 1000) - _tmp22_);
	}
	_tmp23_ = used;
	if (_tmp23_ >= 60) {
		gint _tmp24_;
		gint _tmp25_;
		gchar* _tmp26_ = NULL;
		_tmp24_ = used;
		_tmp25_ = used;
		_tmp26_ = g_strdup_printf ("%d:%02d", _tmp24_ / 60, _tmp25_ % 60);
		result = _tmp26_;
		return result;
	} else {
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		_tmp27_ = used;
		_tmp28_ = g_strdup_printf (":%02d", _tmp27_);
		result = _tmp28_;
		return result;
	}
}


static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha;
	GtkWidget* _tmp0_;
	GtkStateType _tmp1_ = 0;
	cairo_t* _tmp2_;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	gdouble _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble _tmp6_;
	gdouble* _tmp7_;
	gint _tmp7__length1;
	gdouble _tmp8_;
	gdouble _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	gdouble* _tmp12_;
	gint _tmp12__length1;
	gdouble _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	gdouble _tmp15_;
	gdouble* _tmp16_;
	gint _tmp16__length1;
	gdouble _tmp17_;
	gdouble _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	GtkWidget* _tmp21_;
	gint _tmp22_ = 0;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_;
	const gchar* _tmp24_;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_;
	GtkWidget* _tmp27_;
	gint _tmp28_ = 0;
	cairo_text_extents_t _tmp29_;
	gdouble _tmp30_;
	cairo_text_extents_t _tmp31_;
	gdouble _tmp32_;
	GtkWidget* _tmp33_;
	gint _tmp34_ = 0;
	cairo_text_extents_t _tmp35_;
	gdouble _tmp36_;
	cairo_text_extents_t _tmp37_;
	gdouble _tmp38_;
	cairo_t* _tmp39_;
	const gchar* _tmp40_;
	GtkWidget* _tmp41_;
	cairo_text_extents_t _tmp42_;
	gdouble _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	alpha = 1.0;
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_state (_tmp0_);
	if (_tmp1_ == GTK_STATE_INSENSITIVE) {
		alpha = 0.5;
	}
	_tmp2_ = c;
	_tmp3_ = bg;
	_tmp3__length1 = bg_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = bg;
	_tmp5__length1 = bg_length1;
	_tmp6_ = _tmp5_[1];
	_tmp7_ = bg;
	_tmp7__length1 = bg_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = alpha;
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
	_tmp10_ = c;
	cairo_paint (_tmp10_);
	_tmp11_ = c;
	_tmp12_ = fg;
	_tmp12__length1 = fg_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = fg;
	_tmp14__length1 = fg_length1;
	_tmp15_ = _tmp14_[1];
	_tmp16_ = fg;
	_tmp16__length1 = fg_length1;
	_tmp17_ = _tmp16_[2];
	_tmp18_ = alpha;
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
	_tmp19_ = c;
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp20_ = c;
	_tmp21_ = widget;
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
	_tmp23_ = c;
	_tmp24_ = text;
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
	extents = _tmp25_;
	_tmp26_ = c;
	_tmp27_ = widget;
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
	_tmp29_ = extents;
	_tmp30_ = _tmp29_.width;
	_tmp31_ = extents;
	_tmp32_ = _tmp31_.x_bearing;
	_tmp33_ = widget;
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
	_tmp35_ = extents;
	_tmp36_ = _tmp35_.height;
	_tmp37_ = extents;
	_tmp38_ = _tmp37_.y_bearing;
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
	_tmp39_ = c;
	_tmp40_ = text;
	cairo_show_text (_tmp39_, _tmp40_);
	_tmp41_ = widget;
	_tmp42_ = extents;
	_tmp43_ = _tmp42_.width;
	gtk_widget_set_size_request (_tmp41_, ((gint) _tmp43_) + 6, -1);
}


void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint move_number = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_;
	gboolean _tmp13_;
	ChessScene* _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
	_tmp8_ = self->priv->game;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_;
		ChessGame* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		_tmp9_ = move_number;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
	}
	_tmp13_ = _tmp7_;
	if (_tmp13_) {
		move_number = -1;
	}
	_tmp14_ = self->priv->scene;
	_tmp15_ = move_number;
	chess_scene_set_move_number (_tmp14_, _tmp15_);
}


void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, -1);
}


void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint move_number;
	gint _tmp6_;
	ChessGame* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	move_number = _tmp5_ + 1;
	_tmp6_ = move_number;
	_tmp7_ = self->priv->game;
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
	_tmp9_ = _tmp8_;
	if (((guint) _tmp6_) >= _tmp9_) {
		ChessScene* _tmp10_;
		_tmp10_ = self->priv->scene;
		chess_scene_set_move_number (_tmp10_, -1);
	} else {
		ChessScene* _tmp11_;
		gint _tmp12_;
		_tmp11_ = self->priv->scene;
		_tmp12_ = move_number;
		chess_scene_set_move_number (_tmp11_, _tmp12_);
	}
}


void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == (-1)) {
		ChessScene* _tmp6_;
		ChessGame* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		_tmp6_ = self->priv->scene;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
		_tmp9_ = _tmp8_;
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
	} else {
		ChessScene* _tmp10_;
		ChessScene* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp10_ = self->priv->scene;
		_tmp11_ = self->priv->scene;
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
		_tmp13_ = _tmp12_;
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
	}
}


void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, 0);
}


void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self) {
	GtkMenuItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->fullscreen_menu;
	_tmp1_ = gtk_menu_item_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, GTK_STOCK_FULLSCREEN) == 0) {
		GtkWindow* _tmp3_;
		_tmp3_ = self->priv->window;
		gtk_window_fullscreen (_tmp3_);
	} else {
		GtkWindow* _tmp4_;
		_tmp4_ = self->priv->window;
		gtk_window_unfullscreen (_tmp4_);
	}
}


void G_MODULE_EXPORT preferences_cb (GtkWidget* widget, Application* self) {
	GtkDialog* _tmp0_;
	GtkBuilder* _tmp2_;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkDialog* _tmp10_;
	GSettings* _tmp11_;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_ = NULL;
	GSettings* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_ = NULL;
	GSettings* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_ = NULL;
	GSettings* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GSettings* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_ = NULL;
	GSettings* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkBuilder* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkComboBox* _tmp31_;
	GtkComboBox* side_combo;
	gint _tmp32_ = 0;
	GSettings* _tmp33_;
	gboolean _tmp34_ = FALSE;
	GtkComboBox* _tmp35_;
	gint _tmp36_;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkComboBox* _tmp39_;
	GtkComboBox* ai_combo;
	GtkComboBox* _tmp40_;
	GtkTreeModel* _tmp41_;
	GtkTreeModel* _tmp42_;
	GtkListStore* _tmp43_;
	GtkListStore* ai_model;
	GSettings* _tmp44_;
	gchar* _tmp45_ = NULL;
	gchar* opponent_name;
	const gchar* _tmp46_;
	GList* _tmp48_;
	GSettings* _tmp70_;
	GtkComboBox* _tmp71_;
	GtkBuilder* _tmp72_;
	GObject* _tmp73_ = NULL;
	GtkComboBox* _tmp74_;
	GtkComboBox* difficulty_combo;
	GtkComboBox* _tmp75_;
	GSettings* _tmp76_;
	gchar* _tmp77_ = NULL;
	gchar* _tmp78_;
	GtkBuilder* _tmp79_;
	GObject* _tmp80_ = NULL;
	GtkComboBox* _tmp81_;
	GtkBuilder* _tmp82_;
	GObject* _tmp83_ = NULL;
	GtkAdjustment* _tmp84_;
	GtkBuilder* _tmp85_;
	GObject* _tmp86_ = NULL;
	GtkContainer* _tmp87_;
	GtkBuilder* _tmp88_;
	GObject* _tmp89_ = NULL;
	GtkComboBox* _tmp90_;
	GSettings* _tmp91_;
	gint _tmp92_ = 0;
	GtkBuilder* _tmp93_;
	GObject* _tmp94_ = NULL;
	GtkComboBox* _tmp95_;
	GtkComboBox* orientation_combo;
	GtkComboBox* _tmp96_;
	GSettings* _tmp97_;
	gchar* _tmp98_ = NULL;
	gchar* _tmp99_;
	GtkBuilder* _tmp100_;
	GObject* _tmp101_ = NULL;
	GtkComboBox* _tmp102_;
	GtkComboBox* move_combo;
	GtkComboBox* _tmp103_;
	GSettings* _tmp104_;
	gchar* _tmp105_ = NULL;
	gchar* _tmp106_;
	GtkBuilder* _tmp107_;
	GObject* _tmp108_ = NULL;
	GtkComboBox* _tmp109_;
	GtkComboBox* promotion_combo;
	GtkComboBox* _tmp110_;
	GSettings* _tmp111_;
	gchar* _tmp112_ = NULL;
	gchar* _tmp113_;
	GtkBuilder* _tmp114_;
	GObject* _tmp115_ = NULL;
	GtkComboBox* _tmp116_;
	GtkComboBox* theme_combo;
	GtkComboBox* _tmp117_;
	GSettings* _tmp118_;
	gchar* _tmp119_ = NULL;
	gchar* _tmp120_;
	GtkBuilder* _tmp121_;
	GtkDialog* _tmp122_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		GtkDialog* _tmp1_;
		_tmp1_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->preferences_builder);
	self->priv->preferences_builder = _tmp2_;
	{
		GtkBuilder* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp3_ = self->priv->preferences_builder;
		_tmp4_ = g_build_filename (PKGDATADIR, "preferences.ui", NULL, NULL);
		_tmp5_ = _tmp4_;
		gtk_builder_add_from_file (_tmp3_, _tmp5_, &_inner_error_);
		_g_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("glchess.vala:1030: Could not load preferences UI: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->preferences_builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "preferences");
	_tmp10_ = _g_object_ref0 (GTK_DIALOG (_tmp9_));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp10_;
	_tmp11_ = self->priv->settings;
	_tmp12_ = self->priv->preferences_builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "show_numbering_check");
	g_settings_bind (_tmp11_, "show-numbering", _tmp13_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = self->priv->settings;
	_tmp15_ = self->priv->preferences_builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "show_move_hints_check");
	g_settings_bind (_tmp14_, "show-move-hints", _tmp16_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = self->priv->settings;
	_tmp18_ = self->priv->preferences_builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "show_toolbar_check");
	g_settings_bind (_tmp17_, "show-toolbar", _tmp19_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp20_ = self->priv->settings;
	_tmp21_ = self->priv->preferences_builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "show_history_check");
	g_settings_bind (_tmp20_, "show-history", _tmp22_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp23_ = self->priv->settings;
	_tmp24_ = self->priv->preferences_builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "show_3d_check");
	g_settings_bind (_tmp23_, "show-3d", _tmp25_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp26_ = self->priv->settings;
	_tmp27_ = self->priv->preferences_builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "show_3d_smooth_check");
	g_settings_bind (_tmp26_, "show-3d-smooth", _tmp28_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp29_ = self->priv->preferences_builder;
	_tmp30_ = gtk_builder_get_object (_tmp29_, "side_combo");
	_tmp31_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp30_));
	side_combo = _tmp31_;
	_tmp33_ = self->priv->settings;
	_tmp34_ = g_settings_get_boolean (_tmp33_, "play-as-white");
	if (_tmp34_) {
		_tmp32_ = 0;
	} else {
		_tmp32_ = 1;
	}
	_tmp35_ = side_combo;
	_tmp36_ = _tmp32_;
	gtk_combo_box_set_active (_tmp35_, _tmp36_);
	_tmp37_ = self->priv->preferences_builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "opponent_combo");
	_tmp39_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp38_));
	ai_combo = _tmp39_;
	_tmp40_ = ai_combo;
	_tmp41_ = gtk_combo_box_get_model (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = _g_object_ref0 (GTK_LIST_STORE (_tmp42_));
	ai_model = _tmp43_;
	_tmp44_ = self->priv->settings;
	_tmp45_ = g_settings_get_string (_tmp44_, "opponent");
	opponent_name = _tmp45_;
	_tmp46_ = opponent_name;
	if (g_strcmp0 (_tmp46_, "human") == 0) {
		GtkComboBox* _tmp47_;
		_tmp47_ = ai_combo;
		gtk_combo_box_set_active (_tmp47_, 0);
	}
	_tmp48_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp48_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp49_;
			AIProfile* p = NULL;
			_tmp49_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
			p = _tmp49_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp50_;
				GtkTreeIter _tmp51_ = {0};
				GtkListStore* _tmp52_;
				GtkTreeIter _tmp53_;
				AIProfile* _tmp54_;
				const gchar* _tmp55_;
				AIProfile* _tmp56_;
				const gchar* _tmp57_;
				gboolean _tmp58_ = FALSE;
				AIProfile* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				gboolean _tmp67_;
				_tmp50_ = ai_model;
				gtk_list_store_append (_tmp50_, &_tmp51_);
				iter = _tmp51_;
				_tmp52_ = ai_model;
				_tmp53_ = iter;
				_tmp54_ = p;
				_tmp55_ = _tmp54_->name;
				_tmp56_ = p;
				_tmp57_ = _tmp56_->name;
				gtk_list_store_set (_tmp52_, &_tmp53_, 0, _tmp55_, 1, _tmp57_, -1, -1);
				_tmp59_ = p;
				_tmp60_ = _tmp59_->name;
				_tmp61_ = opponent_name;
				if (g_strcmp0 (_tmp60_, _tmp61_) == 0) {
					_tmp58_ = TRUE;
				} else {
					gboolean _tmp62_ = FALSE;
					const gchar* _tmp63_;
					gboolean _tmp66_;
					_tmp63_ = opponent_name;
					if (g_strcmp0 (_tmp63_, "") == 0) {
						GtkComboBox* _tmp64_;
						gint _tmp65_ = 0;
						_tmp64_ = ai_combo;
						_tmp65_ = gtk_combo_box_get_active (_tmp64_);
						_tmp62_ = _tmp65_ == (-1);
					} else {
						_tmp62_ = FALSE;
					}
					_tmp66_ = _tmp62_;
					_tmp58_ = _tmp66_;
				}
				_tmp67_ = _tmp58_;
				if (_tmp67_) {
					GtkComboBox* _tmp68_;
					GtkTreeIter _tmp69_;
					_tmp68_ = ai_combo;
					_tmp69_ = iter;
					gtk_combo_box_set_active_iter (_tmp68_, &_tmp69_);
				}
				_ai_profile_unref0 (p);
			}
		}
	}
	_tmp70_ = self->priv->settings;
	_tmp71_ = ai_combo;
	g_settings_bind (_tmp70_, "show-history", _tmp71_, "visible", G_SETTINGS_BIND_SET);
	_tmp72_ = self->priv->preferences_builder;
	_tmp73_ = gtk_builder_get_object (_tmp72_, "difficulty_combo");
	_tmp74_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp73_));
	difficulty_combo = _tmp74_;
	_tmp75_ = difficulty_combo;
	_tmp76_ = self->priv->settings;
	_tmp77_ = g_settings_get_string (_tmp76_, "difficulty");
	_tmp78_ = _tmp77_;
	application_set_combo (self, _tmp75_, 1, _tmp78_);
	_g_free0 (_tmp78_);
	_tmp79_ = self->priv->preferences_builder;
	_tmp80_ = gtk_builder_get_object (_tmp79_, "duration_combo");
	_tmp81_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp80_));
	_g_object_unref0 (self->priv->duration_combo);
	self->priv->duration_combo = _tmp81_;
	_tmp82_ = self->priv->preferences_builder;
	_tmp83_ = gtk_builder_get_object (_tmp82_, "duration_adjustment");
	_tmp84_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp83_));
	_g_object_unref0 (self->priv->duration_adjustment);
	self->priv->duration_adjustment = _tmp84_;
	_tmp85_ = self->priv->preferences_builder;
	_tmp86_ = gtk_builder_get_object (_tmp85_, "custom_duration_box");
	_tmp87_ = _g_object_ref0 (GTK_CONTAINER (_tmp86_));
	_g_object_unref0 (self->priv->custom_duration_box);
	self->priv->custom_duration_box = _tmp87_;
	_tmp88_ = self->priv->preferences_builder;
	_tmp89_ = gtk_builder_get_object (_tmp88_, "custom_duration_units_combo");
	_tmp90_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp89_));
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	self->priv->custom_duration_units_combo = _tmp90_;
	_tmp91_ = self->priv->settings;
	_tmp92_ = g_settings_get_int (_tmp91_, "duration");
	application_set_duration (self, _tmp92_, TRUE);
	_tmp93_ = self->priv->preferences_builder;
	_tmp94_ = gtk_builder_get_object (_tmp93_, "orientation_combo");
	_tmp95_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp94_));
	orientation_combo = _tmp95_;
	_tmp96_ = orientation_combo;
	_tmp97_ = self->priv->settings;
	_tmp98_ = g_settings_get_string (_tmp97_, "board-side");
	_tmp99_ = _tmp98_;
	application_set_combo (self, _tmp96_, 1, _tmp99_);
	_g_free0 (_tmp99_);
	_tmp100_ = self->priv->preferences_builder;
	_tmp101_ = gtk_builder_get_object (_tmp100_, "move_format_combo");
	_tmp102_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp101_));
	move_combo = _tmp102_;
	_tmp103_ = move_combo;
	_tmp104_ = self->priv->settings;
	_tmp105_ = g_settings_get_string (_tmp104_, "move-format");
	_tmp106_ = _tmp105_;
	application_set_combo (self, _tmp103_, 1, _tmp106_);
	_g_free0 (_tmp106_);
	_tmp107_ = self->priv->preferences_builder;
	_tmp108_ = gtk_builder_get_object (_tmp107_, "promotion_type_combo");
	_tmp109_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp108_));
	promotion_combo = _tmp109_;
	_tmp110_ = promotion_combo;
	_tmp111_ = self->priv->settings;
	_tmp112_ = g_settings_get_string (_tmp111_, "promotion-type");
	_tmp113_ = _tmp112_;
	application_set_combo (self, _tmp110_, 1, _tmp113_);
	_g_free0 (_tmp113_);
	_tmp114_ = self->priv->preferences_builder;
	_tmp115_ = gtk_builder_get_object (_tmp114_, "piece_style_combo");
	_tmp116_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp115_));
	theme_combo = _tmp116_;
	_tmp117_ = theme_combo;
	_tmp118_ = self->priv->settings;
	_tmp119_ = g_settings_get_string (_tmp118_, "piece-theme");
	_tmp120_ = _tmp119_;
	application_set_combo (self, _tmp117_, 1, _tmp120_);
	_g_free0 (_tmp120_);
	_tmp121_ = self->priv->preferences_builder;
	gtk_builder_connect_signals (_tmp121_, self);
	_tmp122_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp122_);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (promotion_combo);
	_g_object_unref0 (move_combo);
	_g_object_unref0 (orientation_combo);
	_g_object_unref0 (difficulty_combo);
	_g_free0 (opponent_name);
	_g_object_unref0 (ai_model);
	_g_object_unref0 (ai_combo);
	_g_object_unref0 (side_combo);
}


static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp7_;
		_tmp7_ = TRUE;
		while (TRUE) {
			gboolean _tmp8_;
			gchar* v = NULL;
			GtkTreeModel* _tmp11_;
			GtkTreeIter _tmp12_;
			gint _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = _tmp7_;
			if (!_tmp8_) {
				GtkTreeModel* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp9_ = model;
				_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
				if (!_tmp10_) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp11_ = model;
			_tmp12_ = iter;
			_tmp13_ = value_index;
			gtk_tree_model_get (_tmp11_, &_tmp12_, _tmp13_, &v, -1, -1);
			_tmp14_ = v;
			_tmp15_ = value;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				GtkComboBox* _tmp16_;
				GtkTreeIter _tmp17_;
				_tmp16_ = combo;
				_tmp17_ = iter;
				gtk_combo_box_set_active_iter (_tmp16_, &_tmp17_);
				_g_free0 (v);
				_g_object_unref0 (model);
				return;
			}
			_g_free0 (v);
		}
	}
	_g_object_unref0 (model);
}


static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (combo != NULL, NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_g_free0 (value);
		return result;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	_tmp7_ = value_index;
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
	result = value;
	return result;
}


void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean play_as_white = FALSE;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &play_as_white, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = play_as_white;
	g_settings_set_boolean (_tmp7_, "play-as-white", _tmp8_);
}


void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = opponent;
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
	_g_free0 (opponent);
}


void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = difficulty;
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
	_g_free0 (difficulty);
}


static void application_set_duration (Application* self, gint duration, gboolean simplify) {
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp4_ = {0};
	GtkTreeIter max_iter;
	gint max_multiplier;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gint value;
	gint _tmp22_;
	gboolean _tmp29_;
	GtkComboBox* _tmp30_;
	GtkTreeModel* _tmp31_;
	GtkTreeModel* _tmp32_;
	GtkTreeModel* _tmp33_;
	GtkTreeModel* _tmp34_;
	GtkTreeIter _tmp35_ = {0};
	gboolean _tmp36_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	max_iter = _tmp4_;
	max_multiplier = 0;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint multiplier = 0;
				GtkTreeModel* _tmp12_;
				GtkTreeIter _tmp13_;
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp16_;
				gboolean _tmp19_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					GtkTreeModel* _tmp10_;
					gboolean _tmp11_ = FALSE;
					_tmp10_ = model;
					_tmp11_ = gtk_tree_model_iter_next (_tmp10_, &iter);
					if (!_tmp11_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp12_ = model;
				_tmp13_ = iter;
				gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &multiplier, -1, -1);
				_tmp15_ = multiplier;
				_tmp16_ = max_multiplier;
				if (_tmp15_ > _tmp16_) {
					gint _tmp17_;
					gint _tmp18_;
					_tmp17_ = duration;
					_tmp18_ = multiplier;
					_tmp14_ = (_tmp17_ % _tmp18_) == 0;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp19_ = _tmp14_;
				if (_tmp19_) {
					gint _tmp20_;
					GtkTreeIter _tmp21_;
					_tmp20_ = multiplier;
					max_multiplier = _tmp20_;
					_tmp21_ = iter;
					max_iter = _tmp21_;
				}
			}
		}
	}
	value = 0;
	_tmp22_ = max_multiplier;
	if (_tmp22_ > 0) {
		gint _tmp23_;
		gint _tmp24_;
		GtkAdjustment* _tmp25_;
		gint _tmp26_;
		GtkComboBox* _tmp27_;
		GtkTreeIter _tmp28_;
		_tmp23_ = duration;
		_tmp24_ = max_multiplier;
		value = _tmp23_ / _tmp24_;
		_tmp25_ = self->priv->duration_adjustment;
		_tmp26_ = value;
		gtk_adjustment_set_value (_tmp25_, (gdouble) _tmp26_);
		_tmp27_ = self->priv->custom_duration_units_combo;
		_tmp28_ = max_iter;
		gtk_combo_box_set_active_iter (_tmp27_, &_tmp28_);
	}
	_tmp29_ = simplify;
	if (!_tmp29_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp30_ = self->priv->duration_combo;
	_tmp31_ = gtk_combo_box_get_model (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	_g_object_unref0 (model);
	model = _tmp33_;
	_tmp34_ = model;
	_tmp36_ = gtk_tree_model_get_iter_first (_tmp34_, &_tmp35_);
	iter = _tmp35_;
	if (!_tmp36_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp37_;
		_tmp37_ = TRUE;
		while (TRUE) {
			gboolean _tmp38_;
			gint v = 0;
			GtkTreeModel* _tmp41_;
			GtkTreeIter _tmp42_;
			gboolean _tmp43_ = FALSE;
			gint _tmp44_;
			gint _tmp45_;
			gboolean _tmp47_;
			_tmp38_ = _tmp37_;
			if (!_tmp38_) {
				GtkTreeModel* _tmp39_;
				gboolean _tmp40_ = FALSE;
				_tmp39_ = model;
				_tmp40_ = gtk_tree_model_iter_next (_tmp39_, &iter);
				if (!_tmp40_) {
					break;
				}
			}
			_tmp37_ = FALSE;
			_tmp41_ = model;
			_tmp42_ = iter;
			gtk_tree_model_get (_tmp41_, &_tmp42_, 1, &v, -1, -1);
			_tmp44_ = v;
			_tmp45_ = duration;
			if (_tmp44_ == _tmp45_) {
				_tmp43_ = TRUE;
			} else {
				gint _tmp46_;
				_tmp46_ = v;
				_tmp43_ = _tmp46_ == (-1);
			}
			_tmp47_ = _tmp43_;
			if (_tmp47_) {
				GtkComboBox* _tmp48_;
				GtkTreeIter _tmp49_;
				GtkContainer* _tmp50_;
				gint _tmp51_;
				_tmp48_ = self->priv->duration_combo;
				_tmp49_ = iter;
				gtk_combo_box_set_active_iter (_tmp48_, &_tmp49_);
				_tmp50_ = self->priv->custom_duration_box;
				_tmp51_ = v;
				gtk_widget_set_visible ((GtkWidget*) _tmp50_, _tmp51_ == (-1));
				_g_object_unref0 (model);
				return;
			}
		}
	}
	_g_object_unref0 (model);
}


static gint application_get_duration (Application* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkAdjustment* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gint magnitude;
	gint multiplier;
	GtkComboBox* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	gint _tmp18_;
	gint _tmp19_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->duration_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gint duration = 0;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		gint _tmp7_;
		_tmp3_ = self->priv->duration_combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = iter;
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
		_tmp7_ = duration;
		if (_tmp7_ >= 0) {
			result = duration;
			return result;
		}
	}
	_tmp8_ = self->priv->duration_adjustment;
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
	_tmp10_ = _tmp9_;
	magnitude = (gint) _tmp10_;
	multiplier = 1;
	_tmp11_ = self->priv->custom_duration_units_combo;
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
	iter = _tmp12_;
	if (_tmp13_) {
		GtkComboBox* _tmp14_;
		GtkTreeModel* _tmp15_;
		GtkTreeModel* _tmp16_;
		GtkTreeIter _tmp17_;
		_tmp14_ = self->priv->custom_duration_units_combo;
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = iter;
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
	}
	_tmp18_ = magnitude;
	_tmp19_ = multiplier;
	result = _tmp18_ * _tmp19_;
	return result;
}


static gboolean application_save_duration_cb (Application* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_;
	gint _tmp1_ = 0;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = application_get_duration (self);
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
	_tmp2_ = self->priv->save_duration_timeout;
	g_source_remove (_tmp2_);
	self->priv->save_duration_timeout = (guint) 0;
	result = FALSE;
	return result;
}


void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self) {
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (GTK_LIST_STORE (_tmp2_));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint multiplier = 0;
				GtkListStore* _tmp11_;
				GtkTreeIter _tmp12_;
				gint _tmp13_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					GtkListStore* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
				_tmp13_ = multiplier;
				switch (_tmp13_) {
					case 1:
					{
						GtkListStore* _tmp14_;
						GtkTreeIter _tmp15_;
						GtkAdjustment* _tmp16_;
						gdouble _tmp17_;
						gdouble _tmp18_;
						const gchar* _tmp19_ = NULL;
						_tmp14_ = model;
						_tmp15_ = iter;
						_tmp16_ = adjustment;
						_tmp17_ = gtk_adjustment_get_value (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = ngettext ("second", "seconds", (gulong) _tmp18_);
						gtk_list_store_set (_tmp14_, &_tmp15_, 0, _tmp19_, -1, -1);
						break;
					}
					case 60:
					{
						GtkListStore* _tmp20_;
						GtkTreeIter _tmp21_;
						GtkAdjustment* _tmp22_;
						gdouble _tmp23_;
						gdouble _tmp24_;
						const gchar* _tmp25_ = NULL;
						_tmp20_ = model;
						_tmp21_ = iter;
						_tmp22_ = adjustment;
						_tmp23_ = gtk_adjustment_get_value (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = ngettext ("minute", "minutes", (gulong) _tmp24_);
						gtk_list_store_set (_tmp20_, &_tmp21_, 0, _tmp25_, -1, -1);
						break;
					}
					case 3600:
					{
						GtkListStore* _tmp26_;
						GtkTreeIter _tmp27_;
						GtkAdjustment* _tmp28_;
						gdouble _tmp29_;
						gdouble _tmp30_;
						const gchar* _tmp31_ = NULL;
						_tmp26_ = model;
						_tmp27_ = iter;
						_tmp28_ = adjustment;
						_tmp29_ = gtk_adjustment_get_value (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = ngettext ("hour", "hours", (gulong) _tmp30_);
						gtk_list_store_set (_tmp26_, &_tmp27_, 0, _tmp31_, -1, -1);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	application_save_duration (self);
	_g_object_unref0 (model);
}


void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_duration (self);
}


static gboolean _application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = application_save_duration_cb (self);
	return result;
}


static void application_save_duration (Application* self) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->save_duration_timeout;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->save_duration_timeout = _tmp2_;
}


void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint duration = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkContainer* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
	_tmp7_ = self->priv->custom_duration_box;
	_tmp8_ = duration;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
	_tmp9_ = duration;
	if (_tmp9_ >= 0) {
		gint _tmp10_;
		_tmp10_ = duration;
		application_set_duration (self, _tmp10_, FALSE);
	} else {
		gint _tmp11_ = 0;
		_tmp11_ = application_get_duration (self);
		if (_tmp11_ <= 0) {
			application_set_duration (self, 5 * 60, FALSE);
		}
	}
	application_save_duration (self);
}


void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	G_MODULE_EXPORT preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
	result = TRUE;
	return result;
}


void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* w;
	GtkWidget* _tmp3_;
	GtkToggleButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_ = NULL;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkToggleButton* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "show_3d_smooth_check");
	_tmp2_ = _g_object_ref0 (GTK_WIDGET (_tmp1_));
	w = _tmp2_;
	_tmp3_ = w;
	_tmp4_ = widget;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_widget_set_sensitive (_tmp3_, _tmp6_);
	_tmp7_ = self->priv->preferences_builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "piece_style_combo");
	_tmp9_ = _g_object_ref0 (GTK_WIDGET (_tmp8_));
	_g_object_unref0 (w);
	w = _tmp9_;
	_tmp10_ = w;
	_tmp11_ = widget;
	_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_widget_set_sensitive (_tmp10_, !_tmp13_);
	_g_object_unref0 (w);
}


void G_MODULE_EXPORT promotion_type_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "promotion-type", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT help_cb (GtkWidget* widget, Application* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "ghelp:glchess", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("glchess.vala:1349: Unable to open help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_about_response_cb (self, response_id);
}


void G_MODULE_EXPORT about_cb (GtkWidget* widget, Application* self) {
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp2_;
	GtkAboutDialog* _tmp3_;
	GtkAboutDialog* _tmp4_;
	GtkWindow* _tmp5_;
	GtkAboutDialog* _tmp6_;
	GtkAboutDialog* _tmp7_;
	GtkAboutDialog* _tmp8_;
	GtkAboutDialog* _tmp9_;
	GtkAboutDialog* _tmp10_;
	GtkAboutDialog* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkAboutDialog* _tmp13_;
	GtkAboutDialog* _tmp14_;
	GtkAboutDialog* _tmp15_;
	GtkAboutDialog* _tmp16_;
	GtkAboutDialog* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GtkAboutDialog* _tmp19_;
	GtkAboutDialog* _tmp20_;
	GtkAboutDialog* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->about_dialog;
	if (_tmp0_ != NULL) {
		GtkAboutDialog* _tmp1_;
		_tmp1_ = self->priv->about_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = _tmp3_;
	_tmp4_ = self->priv->about_dialog;
	_tmp5_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp5_);
	_tmp6_ = self->priv->about_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp6_, TRUE);
	_tmp7_ = self->priv->about_dialog;
	gtk_widget_set_name ((GtkWidget*) _tmp7_, "glchess");
	_tmp8_ = self->priv->about_dialog;
	gtk_about_dialog_set_version (_tmp8_, VERSION);
	_tmp9_ = self->priv->about_dialog;
	gtk_about_dialog_set_copyright (_tmp9_, "Copyright 2010 Robert Ancell <robert.ancell@gmail.com>");
	_tmp10_ = self->priv->about_dialog;
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_2_0);
	_tmp11_ = self->priv->about_dialog;
	_tmp12_ = _ ("The 2D/3D chess game for GNOME. \n" \
"\n" \
"glChess is a part of GNOME Games.");
	gtk_about_dialog_set_comments (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->about_dialog;
	gtk_about_dialog_set_authors (_tmp13_, APPLICATION_authors);
	_tmp14_ = self->priv->about_dialog;
	gtk_about_dialog_set_artists (_tmp14_, APPLICATION_artists);
	_tmp15_ = self->priv->about_dialog;
	gtk_about_dialog_set_translator_credits (_tmp15_, "translator-credits");
	_tmp16_ = self->priv->about_dialog;
	gtk_about_dialog_set_website (_tmp16_, "http://www.gnome.org/projects/gnome-games/");
	_tmp17_ = self->priv->about_dialog;
	_tmp18_ = _ ("GNOME Games web site");
	gtk_about_dialog_set_website_label (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->about_dialog;
	gtk_about_dialog_set_logo_icon_name (_tmp19_, "glchess");
	_tmp20_ = self->priv->about_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp20_, "response", (GCallback) _application_about_response_cb_gtk_dialog_response, self, 0);
	_tmp21_ = self->priv->about_dialog;
	gtk_widget_show ((GtkWidget*) _tmp21_);
}


static void application_about_response_cb (Application* self, gint response_id) {
	GtkAboutDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = NULL;
}


void G_MODULE_EXPORT save_game_as_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_game (self);
}


void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_game (self);
}


static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* vbox;
	GtkInfoBar* _tmp2_;
	GtkInfoBar* _tmp3_;
	GtkWidget* _tmp4_ = NULL;
	GtkContainer* _tmp5_;
	GtkContainer* content_area;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkDialog* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	GtkContainer* _tmp10_;
	GtkContainer* child;
	GtkDialog* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	GtkDialog* _tmp14_;
	GtkDialog* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	vbox = _tmp1_;
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp2_ = (GtkInfoBar*) gtk_info_bar_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (_vala_info_bar);
	_vala_info_bar = _tmp3_;
	_tmp4_ = gtk_info_bar_get_content_area (_vala_info_bar);
	_tmp5_ = _g_object_ref0 (GTK_CONTAINER (_tmp4_));
	content_area = _tmp5_;
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
	_tmp6_ = (GtkLabel*) gtk_label_new ("");
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (_vala_label);
	_vala_label = _tmp7_;
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
	gtk_widget_show ((GtkWidget*) _vala_label);
	_tmp8_ = dialog;
	_tmp9_ = gtk_bin_get_child ((GtkBin*) _tmp8_);
	_tmp10_ = _g_object_ref0 (GTK_CONTAINER (_tmp9_));
	child = _tmp10_;
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
	_tmp11_ = dialog;
	_tmp12_ = gtk_container_get_border_width ((GtkContainer*) _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_container_set_border_width (child, _tmp13_);
	_tmp14_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp14_, (guint) 0);
	_tmp15_ = dialog;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) vbox);
	_g_object_unref0 (child);
	_g_object_unref0 (content_area);
	_g_object_unref0 (vbox);
	if (info_bar) {
		*info_bar = _vala_info_bar;
	} else {
		_g_object_unref0 (_vala_info_bar);
	}
	if (label) {
		*label = _vala_label;
	} else {
		_g_object_unref0 (_vala_label);
	}
}


static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	application_save_file_cb (self);
}


static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_save_cb (self, response_id);
}


static void application_save_game (Application* self) {
	GtkFileChooserDialog* _tmp0_;
	const gchar* _tmp2_ = NULL;
	GtkWindow* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkFileChooserDialog* _tmp6_;
	GtkInfoBar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	GtkFileFilter* _tmp11_;
	GtkFileFilter* _tmp12_;
	GtkFileFilter* pgn_filter;
	GtkFileFilter* _tmp13_;
	const gchar* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_;
	GtkFileChooserDialog* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* _tmp18_;
	GtkFileFilter* _tmp19_;
	GtkFileFilter* all_filter;
	GtkFileFilter* _tmp20_;
	const gchar* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_;
	GtkFileChooserDialog* _tmp23_;
	GtkFileFilter* _tmp24_;
	GtkFileChooserDialog* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_dialog;
	if (_tmp0_ != NULL) {
		GtkFileChooserDialog* _tmp1_;
		_tmp1_ = self->priv->save_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = _ ("Save Chess Game");
	_tmp3_ = self->priv->window;
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, _tmp3_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_OK, NULL, NULL);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = _tmp5_;
	_tmp6_ = self->priv->save_dialog;
	application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp6_, &_tmp7_, &_tmp8_);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = _tmp7_;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = _tmp8_;
	_tmp9_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp9_, "file-activated", (GCallback) _application_save_file_cb_gtk_file_chooser_file_activated, self, 0);
	_tmp10_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp10_, "response", (GCallback) _application_save_cb_gtk_dialog_response, self, 0);
	_tmp11_ = gtk_file_filter_new ();
	_tmp12_ = g_object_ref_sink (_tmp11_);
	pgn_filter = _tmp12_;
	_tmp13_ = pgn_filter;
	_tmp14_ = _ ("PGN files");
	gtk_file_filter_set_name (_tmp13_, _tmp14_);
	_tmp15_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp15_, "*.pgn");
	_tmp16_ = self->priv->save_dialog;
	_tmp17_ = pgn_filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp16_, _tmp17_);
	_tmp18_ = gtk_file_filter_new ();
	_tmp19_ = g_object_ref_sink (_tmp18_);
	all_filter = _tmp19_;
	_tmp20_ = all_filter;
	_tmp21_ = _ ("All files");
	gtk_file_filter_set_name (_tmp20_, _tmp21_);
	_tmp22_ = all_filter;
	gtk_file_filter_add_pattern (_tmp22_, "*");
	_tmp23_ = self->priv->save_dialog;
	_tmp24_ = all_filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp23_, _tmp24_);
	_tmp25_ = self->priv->save_dialog;
	gtk_window_present ((GtkWindow*) _tmp25_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void application_save_file_cb (Application* self) {
	g_return_if_fail (self != NULL);
	application_save_cb (self, (gint) GTK_RESPONSE_OK);
}


static void application_save_cb (Application* self, gint response_id) {
	gint _tmp0_;
	GtkFileChooserDialog* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		GtkWidget* _tmp1_;
		_tmp1_ = self->priv->save_menu;
		gtk_widget_set_sensitive (_tmp1_, FALSE);
		{
			PGNGame* _tmp2_;
			GtkFileChooserDialog* _tmp3_;
			GFile* _tmp4_ = NULL;
			_tmp2_ = self->priv->pgn_game;
			_tmp3_ = self->priv->save_dialog;
			_tmp4_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp3_);
			pgn_game_write (_tmp2_, _tmp4_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp5_;
			const gchar* _tmp6_ = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			GtkInfoBar* _tmp11_;
			GtkInfoBar* _tmp12_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = self->priv->save_dialog_error_label;
			_tmp6_ = _ ("Failed to save game: %s");
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			_tmp9_ = g_strdup_printf (_tmp6_, _tmp8_);
			_tmp10_ = _tmp9_;
			gtk_label_set_text (_tmp5_, _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = self->priv->save_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp11_, GTK_MESSAGE_ERROR);
			_tmp12_ = self->priv->save_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp12_);
			_g_error_free0 (e);
			return;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = self->priv->save_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = NULL;
}


static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	application_open_file_cb (self);
}


static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_open_cb (self, response_id);
}


void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self) {
	GtkFileChooserDialog* _tmp0_;
	const gchar* _tmp2_ = NULL;
	GtkWindow* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkFileChooserDialog* _tmp6_;
	GtkInfoBar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	GtkFileFilter* _tmp11_;
	GtkFileFilter* _tmp12_;
	GtkFileFilter* pgn_filter;
	GtkFileFilter* _tmp13_;
	const gchar* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_;
	GtkFileChooserDialog* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* _tmp18_;
	GtkFileFilter* _tmp19_;
	GtkFileFilter* all_filter;
	GtkFileFilter* _tmp20_;
	const gchar* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_;
	GtkFileChooserDialog* _tmp23_;
	GtkFileFilter* _tmp24_;
	GtkFileChooserDialog* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->open_dialog;
	if (_tmp0_ != NULL) {
		GtkFileChooserDialog* _tmp1_;
		_tmp1_ = self->priv->open_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = _ ("Load Chess Game");
	_tmp3_ = self->priv->window;
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, _tmp3_, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL, NULL);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = _tmp5_;
	_tmp6_ = self->priv->open_dialog;
	application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp6_, &_tmp7_, &_tmp8_);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = _tmp7_;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = _tmp8_;
	_tmp9_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp9_, "file-activated", (GCallback) _application_open_file_cb_gtk_file_chooser_file_activated, self, 0);
	_tmp10_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp10_, "response", (GCallback) _application_open_cb_gtk_dialog_response, self, 0);
	_tmp11_ = gtk_file_filter_new ();
	_tmp12_ = g_object_ref_sink (_tmp11_);
	pgn_filter = _tmp12_;
	_tmp13_ = pgn_filter;
	_tmp14_ = _ ("PGN files");
	gtk_file_filter_set_name (_tmp13_, _tmp14_);
	_tmp15_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp15_, "*.pgn");
	_tmp16_ = self->priv->open_dialog;
	_tmp17_ = pgn_filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp16_, _tmp17_);
	_tmp18_ = gtk_file_filter_new ();
	_tmp19_ = g_object_ref_sink (_tmp18_);
	all_filter = _tmp19_;
	_tmp20_ = all_filter;
	_tmp21_ = _ ("All files");
	gtk_file_filter_set_name (_tmp20_, _tmp21_);
	_tmp22_ = all_filter;
	gtk_file_filter_add_pattern (_tmp22_, "*");
	_tmp23_ = self->priv->open_dialog;
	_tmp24_ = all_filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp23_, _tmp24_);
	_tmp25_ = self->priv->open_dialog;
	gtk_window_present ((GtkWindow*) _tmp25_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void application_open_file_cb (Application* self) {
	g_return_if_fail (self != NULL);
	application_open_cb (self, (gint) GTK_RESPONSE_OK);
}


static void application_open_cb (Application* self, gint response_id) {
	gint _tmp0_;
	GtkFileChooserDialog* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		{
			GtkFileChooserDialog* _tmp1_;
			GFile* _tmp2_ = NULL;
			_tmp1_ = self->priv->open_dialog;
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
			application_load_game (self, _tmp2_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp3_;
			const gchar* _tmp4_ = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			GtkInfoBar* _tmp9_;
			GtkInfoBar* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = self->priv->open_dialog_error_label;
			_tmp4_ = _ ("Failed to open game: %s");
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			_tmp7_ = g_strdup_printf (_tmp4_, _tmp6_);
			_tmp8_ = _tmp7_;
			gtk_label_set_text (_tmp3_, _tmp8_);
			_g_free0 (_tmp8_);
			_tmp9_ = self->priv->open_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp9_, GTK_MESSAGE_ERROR);
			_tmp10_ = self->priv->open_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp10_);
			_g_error_free0 (e);
			return;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = self->priv->open_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = NULL;
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = NULL;
}


static void application_start_new_game (Application* self) {
	PGNGame* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* now;
	PGNGame* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	PGNGame* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GSettings* _tmp10_;
	gint _tmp11_ = 0;
	gint duration;
	gint _tmp12_;
	GSettings* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* engine_name;
	GSettings* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* engine_level;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	self->priv->in_history = TRUE;
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = NULL;
	_tmp0_ = pgn_game_new ();
	_pgn_game_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = now;
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
	_tmp5_ = _tmp4_;
	pgn_game_set_date (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = now;
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
	_tmp9_ = _tmp8_;
	pgn_game_set_time (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
	duration = _tmp11_;
	_tmp12_ = duration;
	if (_tmp12_ > 0) {
		PGNGame* _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp13_ = self->priv->pgn_game;
		_tmp14_ = duration;
		_tmp15_ = g_strdup_printf ("%d", _tmp14_);
		_tmp16_ = _tmp15_;
		pgn_game_set_time_control (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_get_string (_tmp17_, "opponent");
	engine_name = _tmp18_;
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_string (_tmp19_, "difficulty");
	engine_level = _tmp20_;
	_tmp22_ = engine_name;
	if (_tmp22_ != NULL) {
		const gchar* _tmp23_;
		_tmp23_ = engine_name;
		_tmp21_ = g_strcmp0 (_tmp23_, "human") != 0;
	} else {
		_tmp21_ = FALSE;
	}
	_tmp24_ = _tmp21_;
	if (_tmp24_) {
		GSettings* _tmp25_;
		gboolean _tmp26_ = FALSE;
		_tmp25_ = self->priv->settings;
		_tmp26_ = g_settings_get_boolean (_tmp25_, "play-as-white");
		if (_tmp26_) {
			PGNGame* _tmp27_;
			GHashTable* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			PGNGame* _tmp32_;
			GHashTable* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp27_ = self->priv->pgn_game;
			_tmp28_ = _tmp27_->tags;
			_tmp29_ = g_strdup ("BlackAI");
			_tmp30_ = engine_name;
			_tmp31_ = g_strdup (_tmp30_);
			g_hash_table_insert (_tmp28_, _tmp29_, _tmp31_);
			_tmp32_ = self->priv->pgn_game;
			_tmp33_ = _tmp32_->tags;
			_tmp34_ = g_strdup ("BlackLevel");
			_tmp35_ = engine_level;
			_tmp36_ = g_strdup (_tmp35_);
			g_hash_table_insert (_tmp33_, _tmp34_, _tmp36_);
		} else {
			PGNGame* _tmp37_;
			GHashTable* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			PGNGame* _tmp42_;
			GHashTable* _tmp43_;
			gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp37_ = self->priv->pgn_game;
			_tmp38_ = _tmp37_->tags;
			_tmp39_ = g_strdup ("WhiteAI");
			_tmp40_ = engine_name;
			_tmp41_ = g_strdup (_tmp40_);
			g_hash_table_insert (_tmp38_, _tmp39_, _tmp41_);
			_tmp42_ = self->priv->pgn_game;
			_tmp43_ = _tmp42_->tags;
			_tmp44_ = g_strdup ("WhiteLevel");
			_tmp45_ = engine_level;
			_tmp46_ = g_strdup (_tmp45_);
			g_hash_table_insert (_tmp43_, _tmp44_, _tmp46_);
		}
	}
	application_start_game (self);
	_g_free0 (engine_level);
	_g_free0 (engine_name);
	_g_date_time_unref0 (now);
}


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static void application_load_game (Application* self, GFile* file, gboolean from_history, GError** error) {
	GFile* _tmp0_;
	PGN* _tmp1_;
	PGN* pgn;
	GList* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	PGNGame* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
	pgn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = pgn->games;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = _pgn_game_ref0 ((PGNGame*) _tmp3_);
	_pgn_game_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp6_;
	_tmp7_ = from_history;
	self->priv->in_history = _tmp7_;
	application_start_game (self);
	_pgn_unref0 (pgn);
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
	G_APPLICATION_CLASS (klass)->activate = application_real_activate;
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
	self->priv->preferences_dialog = NULL;
	self->priv->save_duration_timeout = (guint) 0;
	self->priv->open_dialog = NULL;
	self->priv->open_dialog_info_bar = NULL;
	self->priv->open_dialog_error_label = NULL;
	self->priv->save_dialog = NULL;
	self->priv->save_dialog_info_bar = NULL;
	self->priv->save_dialog_error_label = NULL;
	self->priv->about_dialog = NULL;
	self->priv->opponent = NULL;
	self->priv->human_player = NULL;
	self->priv->opponent_engine = NULL;
}


static void application_finalize (GObject* obj) {
	Application * self;
	self = APPLICATION (obj);
	_g_object_unref0 (self->priv->settings);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->preferences_builder);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->save_menu);
	_g_object_unref0 (self->priv->save_as_menu);
	_g_object_unref0 (self->priv->fullscreen_menu);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->info_title_label);
	_g_object_unref0 (self->priv->info_label);
	_g_object_unref0 (self->priv->view_container);
	_g_object_unref0 (self->priv->scene);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->undo_menu);
	_g_object_unref0 (self->priv->undo_button);
	_g_object_unref0 (self->priv->resign_menu);
	_g_object_unref0 (self->priv->resign_button);
	_g_object_unref0 (self->priv->first_move_button);
	_g_object_unref0 (self->priv->prev_move_button);
	_g_object_unref0 (self->priv->next_move_button);
	_g_object_unref0 (self->priv->last_move_button);
	_g_object_unref0 (self->priv->history_combo);
	_g_object_unref0 (self->priv->white_time_label);
	_g_object_unref0 (self->priv->black_time_label);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->duration_combo);
	_g_object_unref0 (self->priv->duration_adjustment);
	_g_object_unref0 (self->priv->custom_duration_box);
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	_g_object_unref0 (self->priv->open_dialog);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	_g_object_unref0 (self->priv->open_dialog_error_label);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	_g_object_unref0 (self->priv->save_dialog_error_label);
	_g_object_unref0 (self->priv->about_dialog);
	_pgn_game_unref0 (self->priv->pgn_game);
	_chess_game_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->game_file);
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
	_g_object_unref0 (self->priv->opponent);
	_g_object_unref0 (self->priv->human_player);
	_g_object_unref0 (self->priv->opponent_engine);
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


gint gl_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	GFile* game_file;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* c;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	Application* _tmp20_;
	Application* app;
	Application* _tmp29_;
	gint _tmp30_ = 0;
	gint _result_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	game_file = NULL;
	_tmp0_ = _ ("[FILE] - Play Chess");
	_tmp1_ = g_option_context_new (_tmp0_);
	c = _tmp1_;
	_tmp2_ = c;
	g_option_context_add_main_entries (_tmp2_, GL_CHESS_options, GETTEXT_PACKAGE);
	_tmp3_ = c;
	_tmp4_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_;
		_tmp5_ = c;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		FILE* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		FILE* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_tmp9_ = stderr;
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = _tmp11_[0];
		fprintf (_tmp9_, _tmp10_, _tmp12_);
		_tmp13_ = stderr;
		fprintf (_tmp13_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp14_ = gl_chess_show_version;
	if (_tmp14_) {
		FILE* _tmp15_;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "glchess %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		return result;
	}
	_tmp16_ = args;
	_tmp16__length1 = args_length1;
	if (_tmp16__length1 > 1) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		GFile* _tmp19_ = NULL;
		_tmp17_ = args;
		_tmp17__length1 = args_length1;
		_tmp18_ = _tmp17_[1];
		_tmp19_ = g_file_new_for_path (_tmp18_);
		_g_object_unref0 (game_file);
		game_file = _tmp19_;
	}
	_tmp20_ = application_new ();
	app = _tmp20_;
	{
		Application* _tmp21_;
		GFile* _tmp22_;
		_tmp21_ = app;
		_tmp22_ = game_file;
		application_start (_tmp21_, _tmp22_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp23_;
		GFile* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = game_file;
		_tmp25_ = g_file_get_path (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		fprintf (_tmp23_, "Failed to load %s: %s\n", _tmp26_, _tmp28_);
		_g_free0 (_tmp26_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_object_unref0 (app);
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp29_ = app;
	_tmp30_ = g_application_run ((GApplication*) _tmp29_, 0, NULL);
	_result_ = _tmp30_;
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (c);
	_g_object_unref0 (game_file);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gl_chess_main (argv, argc);
}


GlChess* gl_chess_construct (GType object_type) {
	GlChess* self = NULL;
	self = (GlChess*) g_type_create_instance (object_type);
	return self;
}


GlChess* gl_chess_new (void) {
	return gl_chess_construct (TYPE_GL_CHESS);
}


static void value_gl_chess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_gl_chess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gl_chess_unref (value->data[0].v_pointer);
	}
}


static void value_gl_chess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gl_chess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_gl_chess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_gl_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GlChess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gl_chess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_gl_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GlChess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gl_chess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGlChess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GL_CHESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_gl_chess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gl_chess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


void value_take_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


static void gl_chess_class_init (GlChessClass * klass) {
	gl_chess_parent_class = g_type_class_peek_parent (klass);
	GL_CHESS_CLASS (klass)->finalize = gl_chess_finalize;
}


static void gl_chess_instance_init (GlChess * self) {
	self->ref_count = 1;
}


static void gl_chess_finalize (GlChess* obj) {
	GlChess * self;
	self = GL_CHESS (obj);
}


GType gl_chess_get_type (void) {
	static volatile gsize gl_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gl_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gl_chess_init, value_gl_chess_free_value, value_gl_chess_copy_value, value_gl_chess_peek_pointer, "p", value_gl_chess_collect_value, "p", value_gl_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GlChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gl_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlChess), 0, (GInstanceInitFunc) gl_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gl_chess_type_id;
		gl_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GlChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gl_chess_type_id__volatile, gl_chess_type_id);
	}
	return gl_chess_type_id__volatile;
}


gpointer gl_chess_ref (gpointer instance) {
	GlChess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gl_chess_unref (gpointer instance) {
	GlChess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GL_CHESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



