/* gnotravex.c generated by valac 0.14.1, the Vala compiler
 * generated from gnotravex.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <games-clock.h>
#include <games-scores.h>
#include <games-pause-action.h>
#include <stdlib.h>
#include <string.h>
#include <games-stock.h>
#include <games-score.h>
#include <glib/gi18n-lib.h>
#include <games-settings.h>
#include <games-fullscreen-action.h>
#include <gdk/gdk.h>
#include <time.h>
#include <games-scores-dialog.h>
#include <games-help.h>
#include <games-runtime.h>
#include <games-setgid-io.h>
#include <stdio.h>


#define TYPE_GNOTRAVEX (gnotravex_get_type ())
#define GNOTRAVEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GNOTRAVEX, Gnotravex))
#define GNOTRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GNOTRAVEX, GnotravexClass))
#define IS_GNOTRAVEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GNOTRAVEX))
#define IS_GNOTRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GNOTRAVEX))
#define GNOTRAVEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GNOTRAVEX, GnotravexClass))

typedef struct _Gnotravex Gnotravex;
typedef struct _GnotravexClass GnotravexClass;
typedef struct _GnotravexPrivate GnotravexPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Gnotravex {
	GtkApplication parent_instance;
	GnotravexPrivate * priv;
};

struct _GnotravexClass {
	GtkApplicationClass parent_class;
};

struct _GnotravexPrivate {
	GSettings* settings;
	Puzzle* puzzle;
	GamesClock* clock;
	GamesScores* highscores;
	PuzzleView* view;
	GtkWindow* window;
	GtkAction* new_game_action;
	GamesPauseAction* pause_action;
	GtkAction* solve_action;
	GtkAction* scores_action;
	GtkAction* move_up_action;
	GtkAction* move_left_action;
	GtkAction* move_right_action;
	GtkAction* move_down_action;
};


static gpointer gnotravex_parent_class = NULL;

GType gnotravex_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
#define GNOTRAVEX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GNOTRAVEX, GnotravexPrivate))
enum  {
	GNOTRAVEX_DUMMY_PROPERTY
};
#define GNOTRAVEX_LONG_COUNT 15
#define GNOTRAVEX_SHORT_COUNT 5
#define GNOTRAVEX_DELAY 10
#define GNOTRAVEX_KEY_GRID_SIZE "grid-size"
#define GNOTRAVEX_ui_description "<ui>" "    <menubar name='MainMenu'>" "        <menu action='GameMenu'>" "            <menuitem action='NewGame'/>" "            <menuitem action='PauseGame'/>" "            <separator/>" "            <menu action='MoveMenu'>" "                <menuitem action='MoveUp'/>" "                <menuitem action='MoveLeft'/>" "                <menuitem action='MoveRight'/>" "                <menuitem action='MoveDown'/>" "            </menu>" "            <menuitem action='Solve'/>" "            <separator/>" "            <menuitem action='Scores'/>" "            <separator/>" "            <menuitem action='Quit'/>" "        </menu>" "        <menu action='SettingsMenu'>" "            <menuitem action='Fullscreen'/>" "            <separator/>" "            <menuitem action='Size2x2'/>" "            <menuitem action='Size3x3'/>" "            <menuitem action='Size4x4'/>" "            <menuitem action='Size5x5'/>" "            <menuitem action='Size6x6'/>" "        </menu>" "        <menu action='HelpMenu'>" "            <menuitem action='Contents'/>" "            <menuitem action='About'/>" "        </menu>" "    </menubar>" "  <toolbar name='Toolbar'>" "    <toolitem action='NewGame'/>" "    <toolitem action='PauseGame'/>" "    <toolitem action='LeaveFullscreen'/>" "  </toolbar>" "</ui>"
static void gnotravex_new_game_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_solve_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_solve_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_scores_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_scores_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_quit_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_quit_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_move_up_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_move_up_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_move_left_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_move_left_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_move_right_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_move_right_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_move_down_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_move_down_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_help_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_help_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gnotravex_about_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_about_cb_gtk_action_callback (GtkAction* action, gpointer self);
Gnotravex* gnotravex_new (void);
Gnotravex* gnotravex_construct (GType object_type);
static void gnotravex_size_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_size_cb_gtk_radio_action_callback (GtkAction* action, GtkAction* current, gpointer self);
static void gnotravex_pause_cb (Gnotravex* self, GtkAction* action);
static void _gnotravex_pause_cb_games_pause_action_state_changed (GamesPauseAction* _sender, gpointer self);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static gboolean gnotravex_view_button_press_event (Gnotravex* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _gnotravex_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void gnotravex_new_game (Gnotravex* self);
static void gnotravex_real_activate (GApplication* base);
Puzzle* puzzle_new (guint size);
Puzzle* puzzle_construct (GType object_type, guint size);
static void gnotravex_solved_cb (Gnotravex* self, Puzzle* puzzle);
static void _gnotravex_solved_cb_puzzle_solved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
void puzzle_view_set_is_paused (PuzzleView* self, gboolean value);
gboolean puzzle_view_get_is_paused (PuzzleView* self);
static void gnotravex_toggle_pause (Gnotravex* self);
void puzzle_solve (Puzzle* self);
void puzzle_move_up (Puzzle* self);
void puzzle_move_left (Puzzle* self);
void puzzle_move_right (Puzzle* self);
void puzzle_move_down (Puzzle* self);
gint gnotravex_main (gchar** args, int args_length1);
static void gnotravex_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GamesScoresCategory GNOTRAVEX_scorecats[5] = {{"2x2", "2×2"}, {"3x3", "3×3"}, {"4x4", "4×4"}, {"5x5", "5×5"}, {"6x6", "6×6"}};
static const GtkRadioActionEntry GNOTRAVEX_size_action_entry[5] = {{"Size2x2", NULL, "_2×2", NULL, "Play on a 2×2 board", 2}, {"Size3x3", NULL, "_3×3", NULL, "Play on a 3×3 board", 3}, {"Size4x4", NULL, "_4×4", NULL, "Play on a 4×4 board", 4}, {"Size5x5", NULL, "_5×5", NULL, "Play on a 5×5 board", 5}, {"Size6x6", NULL, "_6×6", NULL, "Play on a 6×6 board", 6}};
static const GtkActionEntry GNOTRAVEX_action_entry[15] = {{"GameMenu", NULL, "_Game"}, {"MoveMenu", NULL, "_Move"}, {"SettingsMenu", NULL, "_Settings"}, {"SizeMenu", NULL, "_Size"}, {"HelpMenu", NULL, "_Help"}, {"NewGame", GAMES_STOCK_NEW_GAME, NULL, NULL, NULL, (GCallback) _gnotravex_new_game_cb_gtk_action_callback}, {"Solve", GTK_STOCK_REFRESH, "Sol_ve", NULL, "Solve the game", (GCallback) _gnotravex_solve_cb_gtk_action_callback}, {"Scores", GAMES_STOCK_SCORES, NULL, NULL, NULL, (GCallback) _gnotravex_scores_cb_gtk_action_callback}, {"Quit", GTK_STOCK_QUIT, NULL, NULL, NULL, (GCallback) _gnotravex_quit_cb_gtk_action_callback}, {"MoveUp", GTK_STOCK_GO_UP, "_Up", "<control>Up", "Move the pieces up", (GCallback) _gnotravex_move_up_cb_gtk_action_callback}, {"MoveLeft", GTK_STOCK_GO_BACK, "_Left", "<control>Left", "Move the pieces left", (GCallback) _gnotravex_move_left_cb_gtk_action_callback}, {"MoveRight", GTK_STOCK_GO_FORWARD, "_Right", "<control>Right", "Move the pieces right", (GCallback) _gnotravex_move_right_cb_gtk_action_callback}, {"MoveDown", GTK_STOCK_GO_DOWN, "_Down", "<control>Down", "Move the pieces down", (GCallback) _gnotravex_move_down_cb_gtk_action_callback}, {"Contents", GAMES_STOCK_CONTENTS, NULL, NULL, NULL, (GCallback) _gnotravex_help_cb_gtk_action_callback}, {"About", GTK_STOCK_ABOUT, NULL, NULL, NULL, (GCallback) _gnotravex_about_cb_gtk_action_callback}};

static void _gnotravex_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_new_game_cb (self, action);
}


static void _gnotravex_solve_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_solve_cb (self, action);
}


static void _gnotravex_scores_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_scores_cb (self, action);
}


static void _gnotravex_quit_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_quit_cb (self, action);
}


static void _gnotravex_move_up_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_move_up_cb (self, action);
}


static void _gnotravex_move_left_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_move_left_cb (self, action);
}


static void _gnotravex_move_right_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_move_right_cb (self, action);
}


static void _gnotravex_move_down_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_move_down_cb (self, action);
}


static void _gnotravex_help_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_help_cb (self, action);
}


static void _gnotravex_about_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gnotravex_about_cb (self, action);
}


static void _gnotravex_size_cb_gtk_radio_action_callback (GtkAction* action, GtkAction* current, gpointer self) {
	gnotravex_size_cb (self, action);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gnotravex_pause_cb_games_pause_action_state_changed (GamesPauseAction* _sender, gpointer self) {
	gnotravex_pause_cb (self, _sender);
}


static gboolean _gnotravex_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gnotravex_view_button_press_event (self, _sender, event);
	return result;
}


Gnotravex* gnotravex_construct (GType object_type) {
	Gnotravex * self = NULL;
	GSettings* _tmp0_;
	GamesScores* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GtkWindow* _tmp6_;
	GtkWindow* _tmp7_;
	GtkUIManager* _tmp8_;
	GtkUIManager* ui_manager;
	GtkActionGroup* _tmp9_;
	GtkActionGroup* action_group;
	GtkWindow* _tmp10_;
	GtkAccelGroup* _tmp11_ = NULL;
	GtkAction* _tmp14_ = NULL;
	GtkAction* _tmp15_;
	GtkAction* _tmp16_ = NULL;
	GtkAction* _tmp17_;
	GtkAction* _tmp18_ = NULL;
	GtkAction* _tmp19_;
	GtkAction* _tmp20_ = NULL;
	GtkAction* _tmp21_;
	GtkAction* _tmp22_ = NULL;
	GtkAction* _tmp23_;
	GtkAction* _tmp24_ = NULL;
	GtkAction* _tmp25_;
	GtkAction* _tmp26_ = NULL;
	GtkAction* _tmp27_;
	GamesPauseAction* _tmp28_;
	GamesPauseAction* _tmp29_;
	GamesPauseAction* _tmp30_;
	GamesPauseAction* _tmp31_;
	GtkWindow* _tmp32_;
	GamesFullscreenAction* _tmp33_;
	GamesFullscreenAction* fullscreen_action;
	GamesFullscreenAction* _tmp34_;
	GtkWindow* _tmp35_;
	GamesFullscreenAction* _tmp36_;
	GamesFullscreenAction* leave_fullscreen_action;
	GamesFullscreenAction* _tmp37_;
	GSettings* _tmp38_;
	gint _tmp39_ = 0;
	gint size;
	gboolean _tmp40_ = FALSE;
	gint _tmp41_;
	gboolean _tmp43_;
	gint _tmp44_;
	GtkRadioActionEntry _tmp45_;
	const gchar* _tmp46_;
	GtkAction* _tmp47_ = NULL;
	GtkRadioAction* _tmp48_;
	GtkRadioAction* size_action;
	GtkGrid* _tmp49_;
	GtkGrid* _tmp50_;
	GtkGrid* grid;
	GtkWindow* _tmp51_;
	GtkWidget* _tmp52_ = NULL;
	GtkWidget* _tmp53_;
	GtkWidget* menubar;
	GtkWidget* _tmp54_ = NULL;
	GtkToolbar* _tmp55_;
	GtkToolbar* toolbar;
	GtkStyleContext* _tmp56_ = NULL;
	PuzzleView* _tmp57_;
	PuzzleView* _tmp58_;
	PuzzleView* _tmp59_;
	PuzzleView* _tmp60_;
	PuzzleView* _tmp61_;
	PuzzleView* _tmp62_;
	PuzzleView* _tmp63_;
	GtkToolItem* _tmp64_;
	GtkToolItem* _tmp65_;
	GtkToolItem* time_item;
	GtkAlignment* _tmp66_;
	GtkAlignment* _tmp67_;
	GtkAlignment* time_align;
	GtkBox* _tmp68_;
	GtkBox* _tmp69_;
	GtkBox* time_box;
	const gchar* _tmp70_ = NULL;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkLabel* time_label;
	GtkLabel* _tmp73_;
	GtkLabel* _tmp74_;
	GtkLabel* label;
	GamesClock* _tmp75_;
	GamesClock* _tmp76_;
	GamesClock* _tmp77_;
	GamesClock* _tmp78_;
	GError * _inner_error_ = NULL;
	self = (Gnotravex*) g_object_new (object_type, "application-id", "org.gnome.gnotravex", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnotravex");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = games_scores_new ("gnotravex", GNOTRAVEX_scorecats, G_N_ELEMENTS (GNOTRAVEX_scorecats), NULL, NULL, 0, GAMES_SCORES_STYLE_TIME_ASCENDING);
	_g_object_unref0 (self->priv->highscores);
	self->priv->highscores = _tmp1_;
	_tmp2_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp3_;
	_tmp4_ = self->priv->window;
	_tmp5_ = _ ("Tetravex");
	gtk_window_set_title (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->window;
	games_settings_bind_window_state ("/org/gnome/gnotravex/", _tmp6_);
	_tmp7_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp7_);
	_tmp8_ = gtk_ui_manager_new ();
	ui_manager = _tmp8_;
	_tmp9_ = gtk_action_group_new ("actions");
	action_group = _tmp9_;
	gtk_action_group_set_translation_domain (action_group, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (action_group, GNOTRAVEX_action_entry, G_N_ELEMENTS (GNOTRAVEX_action_entry), self);
	gtk_action_group_add_radio_actions (action_group, GNOTRAVEX_size_action_entry, G_N_ELEMENTS (GNOTRAVEX_size_action_entry), -1, (GCallback) _gnotravex_size_cb_gtk_radio_action_callback, self);
	gtk_ui_manager_insert_action_group (ui_manager, action_group, 0);
	_tmp10_ = self->priv->window;
	_tmp11_ = gtk_ui_manager_get_accel_group (ui_manager);
	gtk_window_add_accel_group (_tmp10_, _tmp11_);
	{
		gtk_ui_manager_add_ui_from_string (ui_manager, GNOTRAVEX_ui_description, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("gnotravex.vala:111: Failed to parse UI: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action_group);
		_g_object_unref0 (ui_manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = gtk_action_group_get_action (action_group, "NewGame");
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp15_;
	_tmp16_ = gtk_action_group_get_action (action_group, "Solve");
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->solve_action);
	self->priv->solve_action = _tmp17_;
	_tmp18_ = gtk_action_group_get_action (action_group, "Scores");
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_g_object_unref0 (self->priv->scores_action);
	self->priv->scores_action = _tmp19_;
	_tmp20_ = gtk_action_group_get_action (action_group, "MoveUp");
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (self->priv->move_up_action);
	self->priv->move_up_action = _tmp21_;
	_tmp22_ = gtk_action_group_get_action (action_group, "MoveLeft");
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->move_left_action);
	self->priv->move_left_action = _tmp23_;
	_tmp24_ = gtk_action_group_get_action (action_group, "MoveRight");
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->move_right_action);
	self->priv->move_right_action = _tmp25_;
	_tmp26_ = gtk_action_group_get_action (action_group, "MoveDown");
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->move_down_action);
	self->priv->move_down_action = _tmp27_;
	_tmp28_ = games_pause_action_new ("PauseGame");
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp28_;
	_tmp29_ = self->priv->pause_action;
	gtk_action_set_is_important ((GtkAction*) _tmp29_, TRUE);
	_tmp30_ = self->priv->pause_action;
	g_signal_connect_object (_tmp30_, "state-changed", (GCallback) _gnotravex_pause_cb_games_pause_action_state_changed, self, 0);
	_tmp31_ = self->priv->pause_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp31_, NULL);
	_tmp32_ = self->priv->window;
	_tmp33_ = games_fullscreen_action_new ("Fullscreen", _tmp32_);
	fullscreen_action = _tmp33_;
	_tmp34_ = fullscreen_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp34_, NULL);
	_tmp35_ = self->priv->window;
	_tmp36_ = games_fullscreen_action_new ("LeaveFullscreen", _tmp35_);
	leave_fullscreen_action = _tmp36_;
	_tmp37_ = leave_fullscreen_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp37_, NULL);
	_tmp38_ = self->priv->settings;
	_tmp39_ = g_settings_get_int (_tmp38_, GNOTRAVEX_KEY_GRID_SIZE);
	size = _tmp39_;
	_tmp41_ = size;
	if (_tmp41_ < 2) {
		_tmp40_ = TRUE;
	} else {
		gint _tmp42_;
		_tmp42_ = size;
		_tmp40_ = _tmp42_ > 6;
	}
	_tmp43_ = _tmp40_;
	if (_tmp43_) {
		size = 3;
	}
	_tmp44_ = size;
	_tmp45_ = GNOTRAVEX_size_action_entry[_tmp44_ - 2];
	_tmp46_ = _tmp45_.name;
	_tmp47_ = gtk_action_group_get_action (action_group, _tmp46_);
	_tmp48_ = _g_object_ref0 (GTK_RADIO_ACTION (_tmp47_));
	size_action = _tmp48_;
	gtk_toggle_action_set_active ((GtkToggleAction*) size_action, TRUE);
	_tmp49_ = (GtkGrid*) gtk_grid_new ();
	_tmp50_ = g_object_ref_sink (_tmp49_);
	grid = _tmp50_;
	gtk_widget_show ((GtkWidget*) grid);
	_tmp51_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) grid);
	_tmp52_ = gtk_ui_manager_get_widget (ui_manager, "/MainMenu");
	_tmp53_ = _g_object_ref0 (_tmp52_);
	menubar = _tmp53_;
	gtk_widget_show (menubar);
	gtk_grid_attach (grid, menubar, 0, 0, 1, 1);
	_tmp54_ = gtk_ui_manager_get_widget (ui_manager, "/Toolbar");
	_tmp55_ = _g_object_ref0 (GTK_TOOLBAR (_tmp54_));
	toolbar = _tmp55_;
	_tmp56_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	gtk_style_context_add_class (_tmp56_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	gtk_widget_show ((GtkWidget*) toolbar);
	gtk_grid_attach (grid, (GtkWidget*) toolbar, 0, 1, 1, 1);
	_tmp57_ = puzzle_view_new ();
	_tmp58_ = g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp58_;
	_tmp59_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp59_, TRUE);
	_tmp60_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp60_, TRUE);
	_tmp61_ = self->priv->view;
	g_signal_connect_object ((GtkWidget*) _tmp61_, "button-press-event", (GCallback) _gnotravex_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp62_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp62_);
	_tmp63_ = self->priv->view;
	gtk_grid_attach (grid, (GtkWidget*) _tmp63_, 0, 2, 1, 1);
	_tmp64_ = gtk_tool_item_new ();
	_tmp65_ = g_object_ref_sink (_tmp64_);
	time_item = _tmp65_;
	gtk_tool_item_set_expand (time_item, TRUE);
	gtk_widget_show ((GtkWidget*) time_item);
	gtk_toolbar_insert (toolbar, time_item, -1);
	_tmp66_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	_tmp67_ = g_object_ref_sink (_tmp66_);
	time_align = _tmp67_;
	gtk_widget_show ((GtkWidget*) time_align);
	gtk_container_add ((GtkContainer*) time_item, (GtkWidget*) time_align);
	_tmp68_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp69_ = g_object_ref_sink (_tmp68_);
	time_box = _tmp69_;
	gtk_widget_show ((GtkWidget*) time_box);
	gtk_container_add ((GtkContainer*) time_align, (GtkWidget*) time_box);
	_tmp70_ = _ ("Time:");
	_tmp71_ = (GtkLabel*) gtk_label_new (_tmp70_);
	_tmp72_ = g_object_ref_sink (_tmp71_);
	time_label = _tmp72_;
	gtk_widget_show ((GtkWidget*) time_label);
	gtk_box_pack_start (time_box, (GtkWidget*) time_label, FALSE, FALSE, (guint) 0);
	_tmp73_ = (GtkLabel*) gtk_label_new (" ");
	_tmp74_ = g_object_ref_sink (_tmp73_);
	label = _tmp74_;
	gtk_widget_show ((GtkWidget*) label);
	gtk_box_pack_start (time_box, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp75_ = games_clock_new ();
	_tmp76_ = g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->clock);
	self->priv->clock = _tmp76_;
	_tmp77_ = self->priv->clock;
	gtk_widget_show ((GtkWidget*) _tmp77_);
	_tmp78_ = self->priv->clock;
	gtk_box_pack_start (time_box, (GtkWidget*) _tmp78_, FALSE, FALSE, (guint) 0);
	gnotravex_new_game (self);
	_g_object_unref0 (label);
	_g_object_unref0 (time_label);
	_g_object_unref0 (time_box);
	_g_object_unref0 (time_align);
	_g_object_unref0 (time_item);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (menubar);
	_g_object_unref0 (grid);
	_g_object_unref0 (size_action);
	_g_object_unref0 (leave_fullscreen_action);
	_g_object_unref0 (fullscreen_action);
	_g_object_unref0 (action_group);
	_g_object_unref0 (ui_manager);
	return self;
}


Gnotravex* gnotravex_new (void) {
	return gnotravex_construct (TYPE_GNOTRAVEX);
}


static void gnotravex_real_activate (GApplication* base) {
	Gnotravex * self;
	GtkWindow* _tmp0_;
	self = (Gnotravex*) base;
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void _gnotravex_solved_cb_puzzle_solved (Puzzle* _sender, gpointer self) {
	gnotravex_solved_cb (self, _sender);
}


static void gnotravex_new_game (Gnotravex* self) {
	Puzzle* _tmp0_;
	GamesPauseAction* _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_ = 0;
	gint size;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean _tmp8_;
	GamesScores* _tmp9_;
	gint _tmp10_;
	GamesScoresCategory _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	Puzzle* _tmp14_;
	Puzzle* _tmp15_;
	PuzzleView* _tmp16_;
	Puzzle* _tmp17_;
	PuzzleView* _tmp18_;
	GamesClock* _tmp19_;
	GamesClock* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_;
		_tmp1_ = self->priv->puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = self->priv->pause_action;
	gtk_action_set_sensitive ((GtkAction*) _tmp2_, TRUE);
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, GNOTRAVEX_KEY_GRID_SIZE);
	size = _tmp4_;
	_tmp6_ = size;
	if (_tmp6_ < 2) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp7_;
		_tmp7_ = size;
		_tmp5_ = _tmp7_ > 6;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		size = 3;
	}
	_tmp9_ = self->priv->highscores;
	_tmp10_ = size;
	_tmp11_ = GNOTRAVEX_scorecats[_tmp10_ - 2];
	_tmp12_ = _tmp11_.key;
	games_scores_set_category (_tmp9_, _tmp12_);
	_tmp13_ = size;
	_tmp14_ = puzzle_new ((guint) _tmp13_);
	_puzzle_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp14_;
	_tmp15_ = self->priv->puzzle;
	g_signal_connect_object (_tmp15_, "solved", (GCallback) _gnotravex_solved_cb_puzzle_solved, self, 0);
	_tmp16_ = self->priv->view;
	_tmp17_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->view;
	puzzle_view_set_is_paused (_tmp18_, FALSE);
	_tmp19_ = self->priv->clock;
	games_clock_reset (_tmp19_);
	_tmp20_ = self->priv->clock;
	games_clock_start (_tmp20_);
}


static void gnotravex_solved_cb (Gnotravex* self, Puzzle* puzzle) {
	GamesClock* _tmp0_;
	GamesClock* _tmp1_;
	time_t _tmp2_ = 0;
	time_t seconds;
	GamesScores* _tmp3_;
	time_t _tmp4_;
	time_t _tmp5_;
	gint _tmp6_ = 0;
	gint pos;
	GtkWindow* _tmp7_;
	GamesScores* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GamesScoresDialog* _tmp10_;
	GamesScoresDialog* _tmp11_;
	GamesScoresDialog* scores_dialog;
	GamesScoresDialog* _tmp12_;
	const gchar* _tmp13_ = NULL;
	GamesScoresDialog* _tmp14_;
	gint _tmp15_;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_;
	GamesScoresDialog* _tmp20_;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	GamesScoresDialog* _tmp25_;
	GamesScoresDialog* _tmp26_;
	gint _tmp27_ = 0;
	GamesScoresDialog* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	_tmp0_ = self->priv->clock;
	games_clock_stop (_tmp0_);
	_tmp1_ = self->priv->clock;
	_tmp2_ = games_clock_get_seconds (_tmp1_);
	seconds = _tmp2_;
	_tmp3_ = self->priv->highscores;
	_tmp4_ = seconds;
	_tmp5_ = seconds;
	_tmp6_ = games_scores_add_time_score (_tmp3_, ((_tmp4_ / 60) * 1.0) + ((_tmp5_ % 60) / 100.0));
	pos = _tmp6_;
	_tmp7_ = self->priv->window;
	_tmp8_ = self->priv->highscores;
	_tmp9_ = _ ("Tetravex Scores");
	_tmp10_ = games_scores_dialog_new (_tmp7_, _tmp8_, _tmp9_);
	_tmp11_ = g_object_ref_sink (_tmp10_);
	scores_dialog = _tmp11_;
	_tmp12_ = scores_dialog;
	_tmp13_ = _ ("Size:");
	games_scores_dialog_set_category_description (_tmp12_, _tmp13_);
	_tmp14_ = scores_dialog;
	_tmp15_ = pos;
	games_scores_dialog_set_hilight (_tmp14_, (guint) _tmp15_);
	_tmp17_ = pos;
	if (_tmp17_ == 1) {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = _ ("Your score is the best!");
		_tmp16_ = _tmp18_;
	} else {
		const gchar* _tmp19_ = NULL;
		_tmp19_ = _ ("Your score has made the top ten.");
		_tmp16_ = _tmp19_;
	}
	_tmp20_ = scores_dialog;
	_tmp21_ = _ ("Congratulations!");
	_tmp22_ = _tmp16_;
	_tmp23_ = g_strdup_printf ("<b>%s</b>\n\n%s", _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	games_scores_dialog_set_message (_tmp20_, _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = scores_dialog;
	games_scores_dialog_set_buttons (_tmp25_, (guint) (GAMES_SCORES_QUIT_BUTTON | GAMES_SCORES_NEW_GAME_BUTTON));
	_tmp26_ = scores_dialog;
	_tmp27_ = gtk_dialog_run ((GtkDialog*) _tmp26_);
	if (_tmp27_ == ((gint) GTK_RESPONSE_REJECT)) {
		GtkWindow* _tmp28_;
		_tmp28_ = self->priv->window;
		gtk_widget_destroy ((GtkWidget*) _tmp28_);
	} else {
		gnotravex_new_game (self);
	}
	_tmp29_ = scores_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp29_);
	_g_object_unref0 (scores_dialog);
}


static void gnotravex_new_game_cb (Gnotravex* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	gnotravex_new_game (self);
}


static void gnotravex_quit_cb (Gnotravex* self, GtkAction* action) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void gnotravex_scores_cb (Gnotravex* self, GtkAction* action) {
	GtkWindow* _tmp0_;
	GamesScores* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GamesScoresDialog* _tmp3_;
	GamesScoresDialog* _tmp4_;
	GamesScoresDialog* scores_dialog;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->highscores;
	_tmp2_ = _ ("Tetravex Scores");
	_tmp3_ = games_scores_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	scores_dialog = _tmp4_;
	_tmp5_ = _ ("Size:");
	games_scores_dialog_set_category_description (scores_dialog, _tmp5_);
	gtk_dialog_run ((GtkDialog*) scores_dialog);
	gtk_widget_destroy ((GtkWidget*) scores_dialog);
	_g_object_unref0 (scores_dialog);
}


static gboolean gnotravex_view_button_press_event (Gnotravex* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	PuzzleView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->view;
	_tmp1_ = puzzle_view_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gnotravex_toggle_pause (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void gnotravex_pause_cb (Gnotravex* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	gnotravex_toggle_pause (self);
}


static void gnotravex_toggle_pause (Gnotravex* self) {
	PuzzleView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = puzzle_view_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GamesPauseAction* _tmp3_;
		GtkAction* _tmp4_;
		GamesClock* _tmp5_;
		PuzzleView* _tmp6_;
		_tmp3_ = self->priv->pause_action;
		games_pause_action_set_is_paused (_tmp3_, FALSE);
		_tmp4_ = self->priv->solve_action;
		gtk_action_set_sensitive (_tmp4_, TRUE);
		_tmp5_ = self->priv->clock;
		games_clock_start (_tmp5_);
		_tmp6_ = self->priv->view;
		puzzle_view_set_is_paused (_tmp6_, FALSE);
	} else {
		GamesPauseAction* _tmp7_;
		GtkAction* _tmp8_;
		GamesClock* _tmp9_;
		PuzzleView* _tmp10_;
		_tmp7_ = self->priv->pause_action;
		games_pause_action_set_is_paused (_tmp7_, TRUE);
		_tmp8_ = self->priv->solve_action;
		gtk_action_set_sensitive (_tmp8_, FALSE);
		_tmp9_ = self->priv->clock;
		games_clock_stop (_tmp9_);
		_tmp10_ = self->priv->view;
		puzzle_view_set_is_paused (_tmp10_, TRUE);
	}
}


static void gnotravex_solve_cb (Gnotravex* self, GtkAction* action) {
	Puzzle* _tmp0_;
	GamesClock* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_solve (_tmp0_);
	_tmp1_ = self->priv->clock;
	games_clock_stop (_tmp1_);
}


static void gnotravex_help_cb (Gnotravex* self, GtkAction* action) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->window;
	games_help_display ((GtkWidget*) _tmp0_, "gnotravex", NULL);
}


static void gnotravex_about_cb (Gnotravex* self, GtkAction* action) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** documenters;
	gint documenters_length1;
	gint _documenters_size_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* license;
	GtkWindow* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_strdup ("Lars Rydlinge");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Rob Bradford");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = _ ("Tetravex");
	_tmp6_ = games_get_license (_tmp5_);
	license = _tmp6_;
	_tmp7_ = self->priv->window;
	_tmp8_ = _ ("Tetravex");
	_tmp9_ = _ ("GNOME Tetravex is a simple puzzle where pieces must be positioned so t" \
"hat the same numbers are touching each other.\n" \
"\n" \
"Tetravex is a part of GNOME Games.");
	_tmp10_ = _ ("translator-credits");
	_tmp11_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp7_, "program-name", _tmp8_, "version", VERSION, "comments", _tmp9_, "copyright", "Copyright \xc2\xa9 1999-2008 Lars Rydlinge", "license", license, "wrap-license", TRUE, "authors", authors, "documenters", documenters, "translator-credits", _tmp10_, "logo-icon-name", "gnome-tetravex", "website", "http://www.gnome.org/projects/gnome-games", "website-label", _tmp11_, NULL, NULL);
	_g_free0 (license);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void gnotravex_size_cb (Gnotravex* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gint _tmp1_ = 0;
	gint size;
	gint _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_ = 0;
	GSettings* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_radio_action_get_current_value (GTK_RADIO_ACTION (_tmp0_));
	size = _tmp1_;
	_tmp2_ = size;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, GNOTRAVEX_KEY_GRID_SIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = size;
	g_settings_set_int (_tmp5_, GNOTRAVEX_KEY_GRID_SIZE, _tmp6_);
	gnotravex_new_game (self);
}


static void gnotravex_move_up_cb (Gnotravex* self, GtkAction* action) {
	Puzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_up (_tmp0_);
}


static void gnotravex_move_left_cb (Gnotravex* self, GtkAction* action) {
	Puzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_left (_tmp0_);
}


static void gnotravex_move_right_cb (Gnotravex* self, GtkAction* action) {
	Puzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_right (_tmp0_);
}


static void gnotravex_move_down_cb (Gnotravex* self, GtkAction* action) {
	Puzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->puzzle;
	puzzle_move_down (_tmp0_);
}


gint gnotravex_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GOptionContext* _tmp1_;
	GOptionContext* context;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_ = NULL;
	const gchar* _tmp9_ = NULL;
	Gnotravex* _tmp10_;
	Gnotravex* app;
	Gnotravex* _tmp11_;
	gint _tmp12_ = 0;
	gint _result_;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_runtime_init ("gnotravex");
	if (!_tmp0_) {
		result = EXIT_FAILURE;
		return result;
	}
	setgid_io_init ();
	_tmp1_ = g_option_context_new ("");
	context = _tmp1_;
	_tmp2_ = context;
	g_option_context_set_translation_domain (_tmp2_, GETTEXT_PACKAGE);
	_tmp3_ = context;
	_tmp4_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_;
		_tmp5_ = context;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = _ ("Tetravex");
	g_set_application_name (_tmp9_);
	games_stock_init ();
	gtk_window_set_default_icon_name ("gnome-tetravex");
	_tmp10_ = gnotravex_new ();
	app = _tmp10_;
	_tmp11_ = app;
	_tmp12_ = g_application_run ((GApplication*) _tmp11_, 0, NULL);
	_result_ = _tmp12_;
	games_runtime_shutdown ();
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gnotravex_main (argv, argc);
}


static void gnotravex_class_init (GnotravexClass * klass) {
	gnotravex_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnotravexPrivate));
	G_APPLICATION_CLASS (klass)->activate = gnotravex_real_activate;
	G_OBJECT_CLASS (klass)->finalize = gnotravex_finalize;
}


static void gnotravex_instance_init (Gnotravex * self) {
	self->priv = GNOTRAVEX_GET_PRIVATE (self);
}


static void gnotravex_finalize (GObject* obj) {
	Gnotravex * self;
	self = GNOTRAVEX (obj);
	_g_object_unref0 (self->priv->settings);
	_puzzle_unref0 (self->priv->puzzle);
	_g_object_unref0 (self->priv->clock);
	_g_object_unref0 (self->priv->highscores);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->solve_action);
	_g_object_unref0 (self->priv->scores_action);
	_g_object_unref0 (self->priv->move_up_action);
	_g_object_unref0 (self->priv->move_left_action);
	_g_object_unref0 (self->priv->move_right_action);
	_g_object_unref0 (self->priv->move_down_action);
	G_OBJECT_CLASS (gnotravex_parent_class)->finalize (obj);
}


GType gnotravex_get_type (void) {
	static volatile gsize gnotravex_type_id__volatile = 0;
	if (g_once_init_enter (&gnotravex_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GnotravexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnotravex_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Gnotravex), 0, (GInstanceInitFunc) gnotravex_instance_init, NULL };
		GType gnotravex_type_id;
		gnotravex_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Gnotravex", &g_define_type_info, 0);
		g_once_init_leave (&gnotravex_type_id__volatile, gnotravex_type_id);
	}
	return gnotravex_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



