/* sega-saturn-header.c generated by valac 0.36.12.13-3ae08, the Vala compiler
 * generated from sega-saturn-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/
/* Documentation: http://koti.kapsi.fi/~antime/sega/files/ST-040-R4-051795.pdf*/
/* Documentation: http://www.gamefaqs.com/saturn/916393-sega-saturn/faqs/26021*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgnome-games.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_SEGA_SATURN_HEADER (games_sega_saturn_header_get_type ())
#define GAMES_SEGA_SATURN_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeader))
#define GAMES_SEGA_SATURN_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeaderClass))
#define GAMES_IS_SEGA_SATURN_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEGA_SATURN_HEADER))
#define GAMES_IS_SEGA_SATURN_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEGA_SATURN_HEADER))
#define GAMES_SEGA_SATURN_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeaderClass))

typedef struct _GamesSegaSaturnHeader GamesSegaSaturnHeader;
typedef struct _GamesSegaSaturnHeaderClass GamesSegaSaturnHeaderClass;
typedef struct _GamesSegaSaturnHeaderPrivate GamesSegaSaturnHeaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _GamesSegaSaturnHeader {
	GObject parent_instance;
	GamesSegaSaturnHeaderPrivate * priv;
};

struct _GamesSegaSaturnHeaderClass {
	GObjectClass parent_class;
};

struct _GamesSegaSaturnHeaderPrivate {
	GFile* file;
	gsize* header_offset;
};

typedef enum  {
	GAMES_SEGA_SATURN_ERROR_INVALID_CUE_SHEET,
	GAMES_SEGA_SATURN_ERROR_INVALID_FILE_TYPE,
	GAMES_SEGA_SATURN_ERROR_CANT_READ_FILE,
	GAMES_SEGA_SATURN_ERROR_INVALID_HEADER
} GamesSegaSaturnError;
#define GAMES_SEGA_SATURN_ERROR games_sega_saturn_error_quark ()

static gpointer games_sega_saturn_header_parent_class = NULL;
static GType games_sega_saturn_header_type_id = 0;

GType games_sega_saturn_header_get_type (void) G_GNUC_CONST;
#define GAMES_SEGA_SATURN_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeaderPrivate))
enum  {
	GAMES_SEGA_SATURN_HEADER_0_PROPERTY
};
#define GAMES_SEGA_SATURN_HEADER_MAGIC_OFFSET ((gsize) 0x0)
#define GAMES_SEGA_SATURN_HEADER_MAGIC_VALUE "SEGA SEGASATURN"
#define GAMES_SEGA_SATURN_HEADER_PRODUCT_NUMBER_OFFSET ((gsize) 0x20)
#define GAMES_SEGA_SATURN_HEADER_PRODUCT_NUMBER_SIZE ((gsize) 0xa)
#define GAMES_SEGA_SATURN_HEADER_AREAS_OFFSET ((gsize) 0x40)
#define GAMES_SEGA_SATURN_HEADER_AREAS_SIZE ((gsize) 0xa)
GamesSegaSaturnHeader* games_sega_saturn_header_new (GFile* file);
GamesSegaSaturnHeader* games_sega_saturn_header_construct (GType object_type, GFile* file);
void games_sega_saturn_header_check_validity (GamesSegaSaturnHeader* self, GError** error);
static gsize games_sega_saturn_header_get_header_offset (GamesSegaSaturnHeader* self, GError** error);
gchar* games_sega_saturn_header_get_product_number (GamesSegaSaturnHeader* self, GError** error);
gchar* games_sega_saturn_header_get_areas (GamesSegaSaturnHeader* self, GError** error);
static gsize* _size_t_dup (gsize* self);
GQuark games_sega_saturn_error_quark (void);
static void games_sega_saturn_header_finalize (GObject * obj);

static const gsize GAMES_SEGA_SATURN_HEADER_HEADER_OFFSETS[2] = {(gsize) 0x00, (gsize) 0x10};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesSegaSaturnHeader* games_sega_saturn_header_construct (GType object_type, GFile* file) {
	GamesSegaSaturnHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesSegaSaturnHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesSegaSaturnHeader* games_sega_saturn_header_new (GFile* file) {
	return games_sega_saturn_header_construct (GAMES_TYPE_SEGA_SATURN_HEADER, file);
}


void games_sega_saturn_header_check_validity (GamesSegaSaturnHeader* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	games_sega_saturn_header_get_header_offset (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


gchar* games_sega_saturn_header_get_product_number (GamesSegaSaturnHeader* self, GError** error) {
	gchar* result = NULL;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gchar* product_number = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_string_input_stream_read_string_for_size (stream, GAMES_SEGA_SATURN_HEADER_PRODUCT_NUMBER_OFFSET, GAMES_SEGA_SATURN_HEADER_PRODUCT_NUMBER_SIZE, &_inner_error_);
	product_number = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp3_ = string_strip (product_number);
	result = _tmp3_;
	_g_free0 (product_number);
	_g_object_unref0 (stream);
	return result;
}


gchar* games_sega_saturn_header_get_areas (GamesSegaSaturnHeader* self, GError** error) {
	gchar* result = NULL;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gchar* areas = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_string_input_stream_read_string_for_size (stream, GAMES_SEGA_SATURN_HEADER_AREAS_OFFSET, GAMES_SEGA_SATURN_HEADER_AREAS_SIZE, &_inner_error_);
	areas = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp3_ = string_strip (areas);
	result = _tmp3_;
	_g_free0 (areas);
	_g_object_unref0 (stream);
	return result;
}


static gsize* _size_t_dup (gsize* self) {
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}


static gpointer __size_t_dup0 (gpointer self) {
	return self ? _size_t_dup (self) : NULL;
}


static gsize games_sega_saturn_header_get_header_offset (GamesSegaSaturnHeader* self, GError** error) {
	gsize result = 0UL;
	gsize* _tmp0_;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp2_;
	GamesStringInputStream* _tmp3_;
	gsize* _tmp11_;
	gsize* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->header_offset;
	if (_tmp0_ != NULL) {
		gsize* _tmp1_;
		_tmp1_ = self->priv->header_offset;
		result = *_tmp1_;
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = games_string_input_stream_new (_tmp2_);
	stream = _tmp3_;
	{
		gsize* offset_collection = NULL;
		gint offset_collection_length1 = 0;
		gint _offset_collection_size_ = 0;
		gint offset_it = 0;
		offset_collection = GAMES_SEGA_SATURN_HEADER_HEADER_OFFSETS;
		offset_collection_length1 = G_N_ELEMENTS (GAMES_SEGA_SATURN_HEADER_HEADER_OFFSETS);
		for (offset_it = 0; offset_it < G_N_ELEMENTS (GAMES_SEGA_SATURN_HEADER_HEADER_OFFSETS); offset_it = offset_it + 1) {
			gsize offset = 0UL;
			offset = offset_collection[offset_it];
			{
				gboolean _tmp4_ = FALSE;
				GamesStringInputStream* _tmp5_;
				gsize _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = stream;
				_tmp6_ = offset;
				_tmp7_ = games_string_input_stream_has_string (_tmp5_, _tmp6_, GAMES_SEGA_SATURN_HEADER_MAGIC_VALUE, &_inner_error_);
				_tmp4_ = _tmp7_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gsize _tmp8_ = 0UL;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (stream);
					return _tmp8_;
				}
				if (_tmp4_) {
					gsize _tmp9_;
					gsize* _tmp10_;
					_tmp9_ = offset;
					_tmp10_ = __size_t_dup0 (&_tmp9_);
					_g_free0 (self->priv->header_offset);
					self->priv->header_offset = _tmp10_;
				}
			}
		}
	}
	_tmp11_ = self->priv->header_offset;
	if (_tmp11_ == NULL) {
		GError* _tmp12_;
		gsize _tmp13_ = 0UL;
		_tmp12_ = g_error_new_literal (GAMES_SEGA_SATURN_ERROR, GAMES_SEGA_SATURN_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Sega Saturn header."));
		_inner_error_ = _tmp12_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return _tmp13_;
	}
	_tmp14_ = self->priv->header_offset;
	result = *_tmp14_;
	_g_object_unref0 (stream);
	return result;
}


static void games_sega_saturn_header_class_init (GamesSegaSaturnHeaderClass * klass) {
	games_sega_saturn_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesSegaSaturnHeaderPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_sega_saturn_header_finalize;
}


static void games_sega_saturn_header_instance_init (GamesSegaSaturnHeader * self) {
	self->priv = GAMES_SEGA_SATURN_HEADER_GET_PRIVATE (self);
}


static void games_sega_saturn_header_finalize (GObject * obj) {
	GamesSegaSaturnHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeader);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->header_offset);
	G_OBJECT_CLASS (games_sega_saturn_header_parent_class)->finalize (obj);
}


GType games_sega_saturn_header_get_type (void) {
	return games_sega_saturn_header_type_id;
}


GType games_sega_saturn_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesSegaSaturnHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_sega_saturn_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSegaSaturnHeader), 0, (GInstanceInitFunc) games_sega_saturn_header_instance_init, NULL };
	games_sega_saturn_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSegaSaturnHeader", &g_define_type_info, 0);
	return games_sega_saturn_header_type_id;
}



