/* dreamcast-header.c generated by valac 0.36.1.39-72bb2, the Vala compiler
 * generated from dreamcast-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgnome-games.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_DREAMCAST_HEADER (games_dreamcast_header_get_type ())
#define GAMES_DREAMCAST_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeader))
#define GAMES_DREAMCAST_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeaderClass))
#define GAMES_IS_DREAMCAST_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DREAMCAST_HEADER))
#define GAMES_IS_DREAMCAST_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DREAMCAST_HEADER))
#define GAMES_DREAMCAST_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeaderClass))

typedef struct _GamesDreamcastHeader GamesDreamcastHeader;
typedef struct _GamesDreamcastHeaderClass GamesDreamcastHeaderClass;
typedef struct _GamesDreamcastHeaderPrivate GamesDreamcastHeaderPrivate;
enum  {
	GAMES_DREAMCAST_HEADER_DUMMY_PROPERTY,
	GAMES_DREAMCAST_HEADER_LAST_PROPERTY
};
static GParamSpec* games_dreamcast_header_properties[GAMES_DREAMCAST_HEADER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _GamesDreamcastHeader {
	GObject parent_instance;
	GamesDreamcastHeaderPrivate * priv;
};

struct _GamesDreamcastHeaderClass {
	GObjectClass parent_class;
};

struct _GamesDreamcastHeaderPrivate {
	GFile* file;
	gsize* header_offset;
};

typedef enum  {
	GAMES_DREAMCAST_ERROR_INVALID_HEADER
} GamesDreamcastError;
#define GAMES_DREAMCAST_ERROR games_dreamcast_error_quark ()

static gpointer games_dreamcast_header_parent_class = NULL;
static GType games_dreamcast_header_type_id = 0;

GType games_dreamcast_header_get_type (void) G_GNUC_CONST;
#define GAMES_DREAMCAST_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeaderPrivate))
#define GAMES_DREAMCAST_HEADER_HEADER_SIZE ((gsize) 0x100)
#define GAMES_DREAMCAST_HEADER_MAGIC_OFFSET ((gsize) 0x0)
#define GAMES_DREAMCAST_HEADER_MAGIC_VALUE "SEGA SEGAKATANA"
#define GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_OFFSET ((gsize) 0x40)
#define GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_SIZE ((gsize) 0xa)
#define GAMES_DREAMCAST_HEADER_AREAS_OFFSET ((gsize) 0x30)
#define GAMES_DREAMCAST_HEADER_AREAS_SIZE ((gsize) 0x8)
GamesDreamcastHeader* games_dreamcast_header_new (GFile* file);
GamesDreamcastHeader* games_dreamcast_header_construct (GType object_type, GFile* file);
void games_dreamcast_header_check_validity (GamesDreamcastHeader* self, GError** error);
static gsize games_dreamcast_header_get_header_offset (GamesDreamcastHeader* self, GError** error);
gchar* games_dreamcast_header_get_product_number (GamesDreamcastHeader* self, GError** error);
gchar* games_dreamcast_header_get_areas (GamesDreamcastHeader* self, GError** error);
static gboolean games_dreamcast_header_lookup_header_offset (GamesDreamcastHeader* self, gsize offset, GError** error);
static gsize* _size_t_dup (gsize* self);
GQuark games_dreamcast_error_quark (void);
static void games_dreamcast_header_finalize (GObject * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesDreamcastHeader* games_dreamcast_header_construct (GType object_type, GFile* file) {
	GamesDreamcastHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesDreamcastHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesDreamcastHeader* games_dreamcast_header_new (GFile* file) {
	return games_dreamcast_header_construct (GAMES_TYPE_DREAMCAST_HEADER, file);
}


void games_dreamcast_header_check_validity (GamesDreamcastHeader* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	games_dreamcast_header_get_header_offset (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


gchar* games_dreamcast_header_get_product_number (GamesDreamcastHeader* self, GError** error) {
	gchar* result = NULL;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gchar* product_number = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_string_input_stream_read_string_for_size (stream, GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_OFFSET, GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_SIZE, &_inner_error_);
	product_number = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp3_ = string_strip (product_number);
	result = _tmp3_;
	_g_free0 (product_number);
	_g_object_unref0 (stream);
	return result;
}


gchar* games_dreamcast_header_get_areas (GamesDreamcastHeader* self, GError** error) {
	gchar* result = NULL;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gchar* areas = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_string_input_stream_read_string_for_size (stream, GAMES_DREAMCAST_HEADER_AREAS_OFFSET, GAMES_DREAMCAST_HEADER_AREAS_SIZE, &_inner_error_);
	areas = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp3_ = string_strip (areas);
	result = _tmp3_;
	_g_free0 (areas);
	_g_object_unref0 (stream);
	return result;
}


static gsize* _size_t_dup (gsize* self) {
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}


static gpointer __size_t_dup0 (gpointer self) {
	return self ? _size_t_dup (self) : NULL;
}


static gsize games_dreamcast_header_get_header_offset (GamesDreamcastHeader* self, GError** error) {
	gsize result = 0UL;
	gsize* _tmp0_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gsize* header_offsets = NULL;
	const gchar* _tmp4_;
	gint _tmp5_;
	gsize* _tmp6_;
	gint header_offsets_length1;
	gint _header_offsets_size_;
	gsize* _tmp7_;
	gint _tmp7__length1;
	gsize* _tmp14_;
	gsize* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->header_offset;
	if (_tmp0_ != NULL) {
		gsize* _tmp1_;
		_tmp1_ = self->priv->header_offset;
		result = *_tmp1_;
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = g_file_get_path (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp6_ = games_grep_get_offsets (_tmp4_, GAMES_DREAMCAST_HEADER_MAGIC_VALUE, &_tmp5_);
	header_offsets = _tmp6_;
	header_offsets_length1 = _tmp5_;
	_header_offsets_size_ = header_offsets_length1;
	_tmp7_ = header_offsets;
	_tmp7__length1 = header_offsets_length1;
	{
		gsize* offset_collection = NULL;
		gint offset_collection_length1 = 0;
		gint _offset_collection_size_ = 0;
		gint offset_it = 0;
		offset_collection = _tmp7_;
		offset_collection_length1 = _tmp7__length1;
		for (offset_it = 0; offset_it < _tmp7__length1; offset_it = offset_it + 1) {
			gsize offset = 0UL;
			offset = offset_collection[offset_it];
			{
				gboolean _tmp8_ = FALSE;
				gsize _tmp9_;
				gboolean _tmp10_;
				_tmp9_ = offset;
				_tmp10_ = games_dreamcast_header_lookup_header_offset (self, _tmp9_, &_inner_error_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gsize _tmp11_ = 0UL;
					g_propagate_error (error, _inner_error_);
					header_offsets = (g_free (header_offsets), NULL);
					_g_free0 (path);
					return _tmp11_;
				}
				if (_tmp8_) {
					gsize _tmp12_;
					gsize* _tmp13_;
					_tmp12_ = offset;
					_tmp13_ = __size_t_dup0 (&_tmp12_);
					_g_free0 (self->priv->header_offset);
					self->priv->header_offset = _tmp13_;
				}
			}
		}
	}
	_tmp14_ = self->priv->header_offset;
	if (_tmp14_ == NULL) {
		GError* _tmp15_;
		gsize _tmp16_ = 0UL;
		_tmp15_ = g_error_new_literal (GAMES_DREAMCAST_ERROR, GAMES_DREAMCAST_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Dreamcast header."));
		_inner_error_ = _tmp15_;
		g_propagate_error (error, _inner_error_);
		header_offsets = (g_free (header_offsets), NULL);
		_g_free0 (path);
		return _tmp16_;
	}
	_tmp17_ = self->priv->header_offset;
	result = *_tmp17_;
	header_offsets = (g_free (header_offsets), NULL);
	_g_free0 (path);
	return result;
}


static gboolean games_dreamcast_header_lookup_header_offset (GamesDreamcastHeader* self, gsize offset, GError** error) {
	gboolean result = FALSE;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GamesStringInputStream* _tmp3_;
	gsize _tmp4_;
	gboolean _tmp5_;
	gchar* header = NULL;
	GamesStringInputStream* _tmp7_;
	gsize _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp3_ = stream;
	_tmp4_ = offset;
	_tmp5_ = games_string_input_stream_has_string (_tmp3_, _tmp4_ + GAMES_DREAMCAST_HEADER_MAGIC_OFFSET, GAMES_DREAMCAST_HEADER_MAGIC_VALUE, &_inner_error_);
	_tmp2_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return _tmp6_;
	}
	if (!_tmp2_) {
		result = FALSE;
		_g_object_unref0 (stream);
		return result;
	}
	_tmp7_ = stream;
	_tmp8_ = offset;
	_tmp9_ = games_string_input_stream_read_string_for_size (_tmp7_, _tmp8_ + GAMES_DREAMCAST_HEADER_MAGIC_OFFSET, GAMES_DREAMCAST_HEADER_HEADER_SIZE, &_inner_error_);
	header = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return _tmp10_;
	}
	_tmp12_ = header;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	if (((gsize) _tmp14_) == GAMES_DREAMCAST_HEADER_HEADER_SIZE) {
		const gchar* _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = header;
		_tmp16_ = g_str_is_ascii (_tmp15_);
		_tmp11_ = _tmp16_;
	} else {
		_tmp11_ = FALSE;
	}
	result = _tmp11_;
	_g_free0 (header);
	_g_object_unref0 (stream);
	return result;
}


static void games_dreamcast_header_class_init (GamesDreamcastHeaderClass * klass) {
	games_dreamcast_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesDreamcastHeaderPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_dreamcast_header_finalize;
}


static void games_dreamcast_header_instance_init (GamesDreamcastHeader * self) {
	self->priv = GAMES_DREAMCAST_HEADER_GET_PRIVATE (self);
}


static void games_dreamcast_header_finalize (GObject * obj) {
	GamesDreamcastHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeader);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->header_offset);
	G_OBJECT_CLASS (games_dreamcast_header_parent_class)->finalize (obj);
}


GType games_dreamcast_header_get_type (void) {
	return games_dreamcast_header_type_id;
}


GType games_dreamcast_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesDreamcastHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_dreamcast_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDreamcastHeader), 0, (GInstanceInitFunc) games_dreamcast_header_instance_init, NULL };
	games_dreamcast_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesDreamcastHeader", &g_define_type_info, 0);
	return games_dreamcast_header_type_id;
}


GQuark games_dreamcast_error_quark (void) {
	return g_quark_from_static_string ("games_dreamcast_error-quark");
}



