/* steam-cover.c generated by valac 0.38.2, the Vala compiler
 * generated from steam-cover.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define GAMES_TYPE_STEAM_COVER (games_steam_cover_get_type ())
#define GAMES_STEAM_COVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_COVER, GamesSteamCover))
#define GAMES_STEAM_COVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_COVER, GamesSteamCoverClass))
#define GAMES_IS_STEAM_COVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_COVER))
#define GAMES_IS_STEAM_COVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_COVER))
#define GAMES_STEAM_COVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_COVER, GamesSteamCoverClass))

typedef struct _GamesSteamCover GamesSteamCover;
typedef struct _GamesSteamCoverClass GamesSteamCoverClass;
typedef struct _GamesSteamCoverPrivate GamesSteamCoverPrivate;
enum  {
	GAMES_STEAM_COVER_DUMMY_PROPERTY,
	GAMES_STEAM_COVER_LAST_PROPERTY
};
static GParamSpec* games_steam_cover_properties[GAMES_STEAM_COVER_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesSteamCoverFetchCoverData GamesSteamCoverFetchCoverData;

struct _GamesSteamCover {
	GObject parent_instance;
	GamesSteamCoverPrivate * priv;
};

struct _GamesSteamCoverClass {
	GObjectClass parent_class;
};

struct _GamesSteamCoverPrivate {
	gchar* game_id;
	GIcon* icon;
	gboolean resolving;
};

struct _GamesSteamCoverFetchCoverData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesSteamCover* self;
	gchar* uri;
	gchar* dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* cover_path;
	gchar* _tmp2_;
	GFile* src;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* dst;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_;
};


static gpointer games_steam_cover_parent_class = NULL;
static GamesCoverIface * games_steam_cover_games_cover_parent_iface = NULL;
static GType games_steam_cover_type_id = 0;

GType games_steam_cover_get_type (void) G_GNUC_CONST;
#define GAMES_STEAM_COVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_STEAM_COVER, GamesSteamCoverPrivate))
GamesSteamCover* games_steam_cover_new (const gchar* game_id);
GamesSteamCover* games_steam_cover_construct (GType object_type, const gchar* game_id);
static GIcon* games_steam_cover_real_get_cover (GamesCover* base);
static void games_steam_cover_load_cover (GamesSteamCover* self);
static void games_steam_cover_fetch_cover (GamesSteamCover* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void games_steam_cover_fetch_cover_finish (GamesSteamCover* self, GAsyncResult* _res_);
static gchar* games_steam_cover_get_cover_path (GamesSteamCover* self);
static void games_steam_cover_fetch_cover_data_free (gpointer _data);
static void games_steam_cover_fetch_cover_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean games_steam_cover_fetch_cover_co (GamesSteamCoverFetchCoverData* _data_);
static void games_steam_cover_fetch_cover_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void games_steam_cover_finalize (GObject * obj);


GamesSteamCover* games_steam_cover_construct (GType object_type, const gchar* game_id) {
	GamesSteamCover * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (game_id != NULL, NULL);
	self = (GamesSteamCover*) g_object_new (object_type, NULL);
	_tmp0_ = game_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->game_id);
	self->priv->game_id = _tmp1_;
	self->priv->resolving = FALSE;
	return self;
}


GamesSteamCover* games_steam_cover_new (const gchar* game_id) {
	return games_steam_cover_construct (GAMES_TYPE_STEAM_COVER, game_id);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static GIcon* games_steam_cover_real_get_cover (GamesCover* base) {
	GamesSteamCover * self;
	GIcon* result = NULL;
	gboolean _tmp0_;
	GIcon* _tmp3_;
	GIcon* _tmp6_;
	gchar* uri = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (GamesSteamCover*) base;
	_tmp0_ = self->priv->resolving;
	if (_tmp0_) {
		GIcon* _tmp1_;
		GIcon* _tmp2_;
		_tmp1_ = self->priv->icon;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->icon;
	if (_tmp3_ != NULL) {
		GIcon* _tmp4_;
		GIcon* _tmp5_;
		_tmp4_ = self->priv->icon;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		result = _tmp5_;
		return result;
	}
	games_steam_cover_load_cover (self);
	_tmp6_ = self->priv->icon;
	if (_tmp6_ != NULL) {
		GIcon* _tmp7_;
		GIcon* _tmp8_;
		_tmp7_ = self->priv->icon;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		result = _tmp8_;
		return result;
	}
	self->priv->resolving = TRUE;
	_tmp9_ = self->priv->game_id;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("http://cdn.akamai.steamstatic.com/steam/apps/", _tmp10_, "/header.jpg", NULL);
	uri = _tmp11_;
	_tmp12_ = uri;
	games_steam_cover_fetch_cover (self, _tmp12_, NULL, NULL);
	result = NULL;
	_g_free0 (uri);
	return result;
}


static gchar* games_steam_cover_get_cover_path (GamesSteamCover* self) {
	gchar* result = NULL;
	gchar* dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_application_get_covers_dir ();
	dir = _tmp0_;
	_tmp1_ = string_to_string (dir);
	_tmp2_ = self->priv->game_id;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat (_tmp1_, "/steam-", _tmp3_, ".jpg", NULL);
	result = _tmp4_;
	_g_free0 (dir);
	return result;
}


static void games_steam_cover_fetch_cover_data_free (gpointer _data) {
	GamesSteamCoverFetchCoverData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSteamCoverFetchCoverData, _data_);
}


static void games_steam_cover_fetch_cover_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	GamesSteamCoverFetchCoverData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void games_steam_cover_fetch_cover (GamesSteamCover* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesSteamCoverFetchCoverData* _data_;
	GamesSteamCover* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (GamesSteamCoverFetchCoverData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, games_steam_cover_fetch_cover_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_steam_cover_fetch_cover_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	games_steam_cover_fetch_cover_co (_data_);
}


static void games_steam_cover_fetch_cover_finish (GamesSteamCover* self, GAsyncResult* _res_) {
	GamesSteamCoverFetchCoverData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void games_steam_cover_fetch_cover_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GamesSteamCoverFetchCoverData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_steam_cover_fetch_cover_co (_data_);
}


static gboolean games_steam_cover_fetch_cover_co (GamesSteamCoverFetchCoverData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = games_application_get_covers_dir ();
	_data_->dir = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dir;
	games_application_try_make_dir (_data_->_tmp1_);
	_data_->_tmp2_ = games_steam_cover_get_cover_path (_data_->self);
	_data_->cover_path = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->uri;
	_data_->_tmp4_ = g_file_new_for_uri (_data_->_tmp3_);
	_data_->src = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->cover_path;
	_data_->_tmp6_ = g_file_new_for_path (_data_->_tmp5_);
	_data_->dst = _data_->_tmp6_;
	{
		_data_->_tmp7_ = _data_->src;
		_data_->_tmp8_ = _data_->dst;
		_data_->_state_ = 1;
		g_file_copy_async (_data_->_tmp7_, _data_->_tmp8_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, NULL, NULL, games_steam_cover_fetch_cover_ready, _data_);
		return FALSE;
		_state_1:
		g_file_copy_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("steam-cover.vala:51: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->dst);
		_g_object_unref0 (_data_->src);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->dst);
		_g_object_unref0 (_data_->src);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	games_steam_cover_load_cover (_data_->self);
	_g_object_unref0 (_data_->dst);
	_g_object_unref0 (_data_->src);
	_g_free0 (_data_->cover_path);
	_g_free0 (_data_->dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void games_steam_cover_load_cover (GamesSteamCover* self) {
	gchar* cover_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	GFile* file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFileIcon* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_steam_cover_get_cover_path (self);
	cover_path = _tmp0_;
	_tmp1_ = cover_path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	if (!_tmp2_) {
		_g_free0 (cover_path);
		return;
	}
	_tmp3_ = cover_path;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	file = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = (GFileIcon*) g_file_icon_new (_tmp5_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = (GIcon*) _tmp6_;
	g_signal_emit_by_name ((GamesCover*) self, "changed");
	_g_object_unref0 (file);
	_g_free0 (cover_path);
}


static void games_steam_cover_class_init (GamesSteamCoverClass * klass) {
	games_steam_cover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesSteamCoverPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_steam_cover_finalize;
}


static void games_steam_cover_games_cover_interface_init (GamesCoverIface * iface) {
	games_steam_cover_games_cover_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_cover = (GIcon* (*) (GamesCover *)) games_steam_cover_real_get_cover;
}


static void games_steam_cover_instance_init (GamesSteamCover * self) {
	self->priv = GAMES_STEAM_COVER_GET_PRIVATE (self);
}


static void games_steam_cover_finalize (GObject * obj) {
	GamesSteamCover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_STEAM_COVER, GamesSteamCover);
	_g_free0 (self->priv->game_id);
	_g_object_unref0 (self->priv->icon);
	G_OBJECT_CLASS (games_steam_cover_parent_class)->finalize (obj);
}


GType games_steam_cover_get_type (void) {
	return games_steam_cover_type_id;
}


GType games_steam_cover_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesSteamCoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_steam_cover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSteamCover), 0, (GInstanceInitFunc) games_steam_cover_instance_init, NULL };
	static const GInterfaceInfo games_cover_info = { (GInterfaceInitFunc) games_steam_cover_games_cover_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_steam_cover_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSteamCover", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_steam_cover_type_id, GAMES_TYPE_COVER, &games_cover_info);
	return games_steam_cover_type_id;
}



