/* sega-cd-header.c generated by valac 0.38.2, the Vala compiler
 * generated from sega-cd-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/
/* Documentation: https://en.wikibooks.org/wiki/Genesis_Programming*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>


#define GAMES_TYPE_SEGA_CD_HEADER (games_sega_cd_header_get_type ())
#define GAMES_SEGA_CD_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeader))
#define GAMES_SEGA_CD_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeaderClass))
#define GAMES_IS_SEGA_CD_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEGA_CD_HEADER))
#define GAMES_IS_SEGA_CD_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEGA_CD_HEADER))
#define GAMES_SEGA_CD_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeaderClass))

typedef struct _GamesSegaCDHeader GamesSegaCDHeader;
typedef struct _GamesSegaCDHeaderClass GamesSegaCDHeaderClass;
typedef struct _GamesSegaCDHeaderPrivate GamesSegaCDHeaderPrivate;

#define GAMES_TYPE_SEGA_CD_SYSTEM (games_sega_cd_system_get_type ())
enum  {
	GAMES_SEGA_CD_HEADER_DUMMY_PROPERTY,
	GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY,
	GAMES_SEGA_CD_HEADER_LAST_PROPERTY
};
static GParamSpec* games_sega_cd_header_properties[GAMES_SEGA_CD_HEADER_LAST_PROPERTY];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesSegaCDHeader {
	GObject parent_instance;
	GamesSegaCDHeaderPrivate * priv;
};

struct _GamesSegaCDHeaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_SEGA_CD_SYSTEM_INVALID,
	GAMES_SEGA_CD_SYSTEM_SEGA_CD,
	GAMES_SEGA_CD_SYSTEM_SEGA_CD_32X
} GamesSegaCDSystem;

struct _GamesSegaCDHeaderPrivate {
	GamesSegaCDSystem* _system;
	GFile* file;
	gsize* offset;
};

typedef enum  {
	GAMES_SEGA_CD_ERROR_INVALID_HEADER,
	GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET,
	GAMES_SEGA_CD_ERROR_INVALID_FILE_TYPE
} GamesSegaCDError;
#define GAMES_SEGA_CD_ERROR games_sega_cd_error_quark ()

static gpointer games_sega_cd_header_parent_class = NULL;
static GType games_sega_cd_header_type_id = 0;

GType games_sega_cd_header_get_type (void) G_GNUC_CONST;
GType games_sega_cd_system_get_type (void) G_GNUC_CONST;
#define GAMES_SEGA_CD_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeaderPrivate))
#define GAMES_SEGA_CD_HEADER_HEADER_LENGTH ((gsize) 0x200)
#define GAMES_SEGA_CD_HEADER_CD_OFFSET ((gsize) 0x0)
#define GAMES_SEGA_CD_HEADER_SYSTEM_OFFSET ((gsize) 0x100)
#define GAMES_SEGA_CD_HEADER_SYSTEM_SIZE ((gsize) 0xf)
GamesSegaCDHeader* games_sega_cd_header_new (GFile* file);
GamesSegaCDHeader* games_sega_cd_header_construct (GType object_type, GFile* file);
void games_sega_cd_header_check_validity (GamesSegaCDHeader* self, GError** error);
GamesSegaCDSystem games_sega_cd_header_get_system (GamesSegaCDHeader* self);
GQuark games_sega_cd_error_quark (void);
gsize games_sega_cd_header_get_offset (GamesSegaCDHeader* self, GError** error);
static gsize* _size_t_dup (gsize* self);
static GamesSegaCDSystem games_sega_cd_header_parse_system (GamesSegaCDHeader* self, GError** error);
gboolean games_sega_cd_header_is_sega_cd (GamesSegaCDHeader* self);
gboolean games_sega_cd_header_is_sega_cd_32x (GamesSegaCDHeader* self);
static GamesSegaCDSystem* _games_sega_cd_system_dup (GamesSegaCDSystem* self);
static void games_sega_cd_header_finalize (GObject * obj);
static void _vala_games_sega_cd_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);

static const gsize GAMES_SEGA_CD_HEADER_POSSIBLE_HEADER_OFFSETS[2] = {(gsize) 0x0, (gsize) 0x10};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesSegaCDHeader* games_sega_cd_header_construct (GType object_type, GFile* file) {
	GamesSegaCDHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesSegaCDHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesSegaCDHeader* games_sega_cd_header_new (GFile* file) {
	return games_sega_cd_header_construct (GAMES_TYPE_SEGA_CD_HEADER, file);
}


void games_sega_cd_header_check_validity (GamesSegaCDHeader* self, GError** error) {
	GamesSegaCDSystem _tmp0_;
	GamesSegaCDSystem _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_sega_cd_header_get_system (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GAMES_SEGA_CD_SYSTEM_INVALID) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Genesis/Sega 32X/Sega CD/Sega Pico header."));
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gsize* _size_t_dup (gsize* self) {
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}


static gpointer __size_t_dup0 (gpointer self) {
	return self ? _size_t_dup (self) : NULL;
}


gsize games_sega_cd_header_get_offset (GamesSegaCDHeader* self, GError** error) {
	gsize result = 0UL;
	gsize* _tmp0_;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp2_;
	GamesStringInputStream* _tmp3_;
	GError* _tmp15_;
	gsize _tmp16_ = 0UL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->offset;
	if (_tmp0_ != NULL) {
		gsize* _tmp1_;
		_tmp1_ = self->priv->offset;
		result = *_tmp1_;
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = games_string_input_stream_new (_tmp2_);
	stream = _tmp3_;
	{
		gsize* possible_offset_collection = NULL;
		gint possible_offset_collection_length1 = 0;
		gint _possible_offset_collection_size_ = 0;
		gint possible_offset_it = 0;
		possible_offset_collection = GAMES_SEGA_CD_HEADER_POSSIBLE_HEADER_OFFSETS;
		possible_offset_collection_length1 = G_N_ELEMENTS (GAMES_SEGA_CD_HEADER_POSSIBLE_HEADER_OFFSETS);
		for (possible_offset_it = 0; possible_offset_it < G_N_ELEMENTS (GAMES_SEGA_CD_HEADER_POSSIBLE_HEADER_OFFSETS); possible_offset_it = possible_offset_it + 1) {
			gsize possible_offset = 0UL;
			possible_offset = possible_offset_collection[possible_offset_it];
			{
				gchar* system_string = NULL;
				GamesStringInputStream* _tmp4_;
				gsize _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gboolean _tmp11_;
				_tmp4_ = stream;
				_tmp5_ = possible_offset;
				_tmp6_ = games_string_input_stream_read_string_for_size (_tmp4_, _tmp5_ + GAMES_SEGA_CD_HEADER_SYSTEM_OFFSET, GAMES_SEGA_CD_HEADER_SYSTEM_SIZE, &_inner_error_);
				system_string = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gsize _tmp7_ = 0UL;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (stream);
					return _tmp7_;
				}
				_tmp8_ = system_string;
				_tmp9_ = string_strip (_tmp8_);
				_g_free0 (system_string);
				system_string = _tmp9_;
				_tmp10_ = system_string;
				_tmp11_ = g_str_has_prefix (_tmp10_, "SEGA");
				if (_tmp11_) {
					gsize _tmp12_;
					gsize* _tmp13_;
					gsize* _tmp14_;
					_tmp12_ = possible_offset;
					_tmp13_ = __size_t_dup0 (&_tmp12_);
					_g_free0 (self->priv->offset);
					self->priv->offset = _tmp13_;
					_tmp14_ = self->priv->offset;
					result = *_tmp14_;
					_g_free0 (system_string);
					_g_object_unref0 (stream);
					return result;
				}
				_g_free0 (system_string);
			}
		}
	}
	_tmp15_ = g_error_new_literal (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Genesis/Sega 32X/Sega CD/Sega Pico header."));
	_inner_error_ = _tmp15_;
	g_propagate_error (error, _inner_error_);
	_g_object_unref0 (stream);
	return _tmp16_;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}


static GamesSegaCDSystem games_sega_cd_header_parse_system (GamesSegaCDHeader* self, GError** error) {
	GamesSegaCDSystem result = 0;
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gsize offset = 0UL;
	gsize _tmp2_;
	gboolean _tmp3_ = FALSE;
	GamesStringInputStream* _tmp4_;
	gsize _tmp5_;
	gboolean _tmp6_;
	gchar* system_string = NULL;
	GamesStringInputStream* _tmp7_;
	gsize _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GQuark _tmp15_ = 0U;
	static GQuark _tmp14_label0 = 0;
	static GQuark _tmp14_label1 = 0;
	static GQuark _tmp14_label2 = 0;
	static GQuark _tmp14_label3 = 0;
	static GQuark _tmp14_label4 = 0;
	static GQuark _tmp14_label5 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_sega_cd_header_get_offset (self, &_inner_error_);
	offset = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return 0;
	}
	_tmp4_ = stream;
	_tmp5_ = offset;
	_tmp6_ = games_string_input_stream_has_string (_tmp4_, _tmp5_ + GAMES_SEGA_CD_HEADER_CD_OFFSET, "SEGADISCSYSTEM", &_inner_error_);
	_tmp3_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return 0;
	}
	if (!_tmp3_) {
		result = GAMES_SEGA_CD_SYSTEM_INVALID;
		_g_object_unref0 (stream);
		return result;
	}
	_tmp7_ = stream;
	_tmp8_ = offset;
	_tmp9_ = games_string_input_stream_read_string_for_size (_tmp7_, _tmp8_ + GAMES_SEGA_CD_HEADER_SYSTEM_OFFSET, GAMES_SEGA_CD_HEADER_SYSTEM_SIZE, &_inner_error_);
	system_string = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return 0;
	}
	_tmp10_ = system_string;
	_tmp11_ = string_chomp (_tmp10_);
	_g_free0 (system_string);
	system_string = _tmp11_;
	_tmp12_ = system_string;
	_tmp13_ = _tmp12_;
	_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
	if (((((_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("SEGA MEGA DRIVE")))) || (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("SEGA GENESIS"))))) || (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string (" SEGA MEGA DRIV"))))) || (_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("SEGA_SEGA_CD"))))) || (_tmp15_ == ((0 != _tmp14_label4) ? _tmp14_label4 : (_tmp14_label4 = g_quark_from_static_string ("SEGA are Regist"))))) {
		switch (0) {
			default:
			{
				result = GAMES_SEGA_CD_SYSTEM_SEGA_CD;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label5) ? _tmp14_label5 : (_tmp14_label5 = g_quark_from_static_string ("SEGA 32X")))) {
		switch (0) {
			default:
			{
				result = GAMES_SEGA_CD_SYSTEM_SEGA_CD_32X;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GAMES_SEGA_CD_SYSTEM_INVALID;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	}
	_g_free0 (system_string);
	_g_object_unref0 (stream);
}


gboolean games_sega_cd_header_is_sega_cd (GamesSegaCDHeader* self) {
	gboolean result = FALSE;
	GamesSegaCDSystem _tmp0_;
	GamesSegaCDSystem _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_sega_cd_header_get_system (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_SEGA_CD_SYSTEM_SEGA_CD:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


gboolean games_sega_cd_header_is_sega_cd_32x (GamesSegaCDHeader* self) {
	gboolean result = FALSE;
	GamesSegaCDSystem _tmp0_;
	GamesSegaCDSystem _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_sega_cd_header_get_system (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_SEGA_CD_SYSTEM_SEGA_CD_32X:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static GamesSegaCDSystem* _games_sega_cd_system_dup (GamesSegaCDSystem* self) {
	GamesSegaCDSystem* dup;
	dup = g_new0 (GamesSegaCDSystem, 1);
	memcpy (dup, self, sizeof (GamesSegaCDSystem));
	return dup;
}


static gpointer __games_sega_cd_system_dup0 (gpointer self) {
	return self ? _games_sega_cd_system_dup (self) : NULL;
}


GamesSegaCDSystem games_sega_cd_header_get_system (GamesSegaCDHeader* self) {
	GamesSegaCDSystem result;
	GamesSegaCDSystem* _tmp0_;
	GamesSegaCDSystem* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_system;
	if (_tmp0_ != NULL) {
		GamesSegaCDSystem* _tmp1_;
		_tmp1_ = self->priv->_system;
		result = *_tmp1_;
		return result;
	}
	{
		GamesSegaCDSystem _tmp2_ = 0;
		GamesSegaCDSystem _tmp3_;
		GamesSegaCDSystem* _tmp4_;
		_tmp3_ = games_sega_cd_header_parse_system (self, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = __games_sega_cd_system_dup0 (&_tmp2_);
		_g_free0 (self->priv->_system);
		self->priv->_system = _tmp4_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GamesSegaCDSystem _tmp7_;
		GamesSegaCDSystem* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("sega-cd-header.vala:26: %s", _tmp6_);
		_tmp7_ = GAMES_SEGA_CD_SYSTEM_INVALID;
		_tmp8_ = __games_sega_cd_system_dup0 (&_tmp7_);
		_g_free0 (self->priv->_system);
		self->priv->_system = _tmp8_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = self->priv->_system;
	result = *_tmp9_;
	return result;
}


static void games_sega_cd_header_class_init (GamesSegaCDHeaderClass * klass) {
	games_sega_cd_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesSegaCDHeaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_sega_cd_header_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_sega_cd_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY, games_sega_cd_header_properties[GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY] = g_param_spec_enum ("system", "system", "system", GAMES_TYPE_SEGA_CD_SYSTEM, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_sega_cd_header_instance_init (GamesSegaCDHeader * self) {
	self->priv = GAMES_SEGA_CD_HEADER_GET_PRIVATE (self);
}


static void games_sega_cd_header_finalize (GObject * obj) {
	GamesSegaCDHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeader);
	_g_free0 (self->priv->_system);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->offset);
	G_OBJECT_CLASS (games_sega_cd_header_parent_class)->finalize (obj);
}


GType games_sega_cd_header_get_type (void) {
	return games_sega_cd_header_type_id;
}


GType games_sega_cd_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesSegaCDHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_sega_cd_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSegaCDHeader), 0, (GInstanceInitFunc) games_sega_cd_header_instance_init, NULL };
	games_sega_cd_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSegaCDHeader", &g_define_type_info, 0);
	return games_sega_cd_header_type_id;
}


static void _vala_games_sega_cd_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesSegaCDHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeader);
	switch (property_id) {
		case GAMES_SEGA_CD_HEADER_SYSTEM_PROPERTY:
		g_value_set_enum (value, games_sega_cd_header_get_system (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GQuark games_sega_cd_error_quark (void) {
	return g_quark_from_static_string ("games_sega_cd_error-quark");
}



