/* mega-drive-plugin.c generated by valac 0.35.5.22-e5360, the Vala compiler
 * generated from mega-drive-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_MEGA_DRIVE_PLUGIN (games_mega_drive_plugin_get_type ())
#define GAMES_MEGA_DRIVE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEGA_DRIVE_PLUGIN, GamesMegaDrivePlugin))
#define GAMES_MEGA_DRIVE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEGA_DRIVE_PLUGIN, GamesMegaDrivePluginClass))
#define GAMES_IS_MEGA_DRIVE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEGA_DRIVE_PLUGIN))
#define GAMES_IS_MEGA_DRIVE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEGA_DRIVE_PLUGIN))
#define GAMES_MEGA_DRIVE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEGA_DRIVE_PLUGIN, GamesMegaDrivePluginClass))

typedef struct _GamesMegaDrivePlugin GamesMegaDrivePlugin;
typedef struct _GamesMegaDrivePluginClass GamesMegaDrivePluginClass;
typedef struct _GamesMegaDrivePluginPrivate GamesMegaDrivePluginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_MEGA_DRIVE_HEADER (games_mega_drive_header_get_type ())
#define GAMES_MEGA_DRIVE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeader))
#define GAMES_MEGA_DRIVE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeaderClass))
#define GAMES_IS_MEGA_DRIVE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEGA_DRIVE_HEADER))
#define GAMES_IS_MEGA_DRIVE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEGA_DRIVE_HEADER))
#define GAMES_MEGA_DRIVE_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeaderClass))

typedef struct _GamesMegaDriveHeader GamesMegaDriveHeader;
typedef struct _GamesMegaDriveHeaderClass GamesMegaDriveHeaderClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesMegaDrivePlugin {
	GObject parent_instance;
	GamesMegaDrivePluginPrivate * priv;
};

struct _GamesMegaDrivePluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_MEGA_DRIVE_ERROR_INVALID_HEADER,
	GAMES_MEGA_DRIVE_ERROR_INVALID_CUE_SHEET,
	GAMES_MEGA_DRIVE_ERROR_INVALID_FILE_TYPE
} GamesMegaDriveError;
#define GAMES_MEGA_DRIVE_ERROR games_mega_drive_error_quark ()

static gpointer games_mega_drive_plugin_parent_class = NULL;
static GamesPluginIface * games_mega_drive_plugin_games_plugin_parent_iface = NULL;
static GType games_mega_drive_plugin_type_id = 0;

GType games_mega_drive_plugin_get_type (void) G_GNUC_CONST;
enum  {
	GAMES_MEGA_DRIVE_PLUGIN_DUMMY_PROPERTY
};
#define GAMES_MEGA_DRIVE_PLUGIN_MEGA_DRIVE_PREFIX "mega-drive"
#define GAMES_MEGA_DRIVE_PLUGIN_MEGA_DRIVE_MIME_TYPE "application/x-genesis-rom"
#define GAMES_MEGA_DRIVE_PLUGIN_MEGA_DRIVE_PLATFORM "SegaGenesis"
#define GAMES_MEGA_DRIVE_PLUGIN_32X_PREFIX "mega-drive-32x"
#define GAMES_MEGA_DRIVE_PLUGIN_32X_MIME_TYPE "application/x-genesis-32x-rom"
#define GAMES_MEGA_DRIVE_PLUGIN_32X_PLATFORM "Sega32X"
#define GAMES_MEGA_DRIVE_PLUGIN_PICO_PREFIX "sega-pico"
#define GAMES_MEGA_DRIVE_PLUGIN_PICO_MIME_TYPE "application/x-sega-pico-rom"
#define GAMES_MEGA_DRIVE_PLUGIN_PICO_PLATFORM "SegaPico"
#define GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_PREFIX "mega-cd"
#define GAMES_MEGA_DRIVE_PLUGIN_CUE_MIME_TYPE "application/x-cue"
#define GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_MIME_TYPE "application/x-sega-cd-rom"
#define GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_PLATFORM "SegaCD"
#define GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_32X_PLATFORM "SegaCD32X"
static GamesGameSource* games_mega_drive_plugin_real_get_game_source (GamesPlugin* base, GError** error);
static GamesGame* games_mega_drive_plugin_game_for_uri (const gchar* uri, GError** error);
static GamesGame* _games_mega_drive_plugin_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error);
static GamesGame* games_mega_drive_plugin_cd_game_for_uri (const gchar* uri, GError** error);
static GamesGame* _games_mega_drive_plugin_cd_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error);
GType games_mega_drive_header_get_type (void) G_GNUC_CONST;
GamesMegaDriveHeader* games_mega_drive_header_new (GFile* file);
GamesMegaDriveHeader* games_mega_drive_header_construct (GType object_type, GFile* file);
void games_mega_drive_header_check_validity (GamesMegaDriveHeader* self, GError** error);
gboolean games_mega_drive_header_is_mega_drive (GamesMegaDriveHeader* self);
gboolean games_mega_drive_header_is_32x (GamesMegaDriveHeader* self);
gboolean games_mega_drive_header_is_pico (GamesMegaDriveHeader* self);
static GFile* games_mega_drive_plugin_get_binary_file (GamesCueSheet* cue, GError** error);
gsize games_mega_drive_header_get_offset (GamesMegaDriveHeader* self, GError** error);
#define GAMES_MEGA_DRIVE_HEADER_HEADER_LENGTH ((gsize) 0x200)
GQuark games_mega_drive_error_quark (void);
GamesMegaDrivePlugin* games_mega_drive_plugin_new (void);
GamesMegaDrivePlugin* games_mega_drive_plugin_construct (GType object_type);
GType register_games_plugin (GTypeModule* module);
GType games_mega_drive_header_register_type (GTypeModule * module);
GType games_mega_drive_plugin_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GamesGame* _games_mega_drive_plugin_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error) {
	GamesGame* result;
	result = games_mega_drive_plugin_game_for_uri (uri, error);
	return result;
}


static GamesGame* _games_mega_drive_plugin_cd_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error) {
	GamesGame* result;
	result = games_mega_drive_plugin_cd_game_for_uri (uri, error);
	return result;
}


static GamesGameSource* games_mega_drive_plugin_real_get_game_source (GamesPlugin* base, GError** error) {
	GamesMegaDrivePlugin * self;
	GamesGameSource* result = NULL;
	GamesGenericSyncGameUriAdapter* game_uri_adapter;
	GamesGenericSyncGameUriAdapter* _tmp0_;
	GamesGenericSyncGameUriAdapter* cd_game_uri_adapter;
	GamesGenericSyncGameUriAdapter* _tmp1_;
	GamesGenericUriGameFactory* mega_drive_factory;
	GamesGenericUriGameFactory* _tmp2_;
	GamesGenericUriGameFactory* _32x_factory_;
	GamesGenericUriGameFactory* _tmp3_;
	GamesGenericUriGameFactory* mega_cd_factory;
	GamesGenericUriGameFactory* _tmp4_;
	GamesMimeTypeTrackerQuery* mega_drive_query;
	GamesMimeTypeTrackerQuery* _tmp5_;
	GamesMimeTypeTrackerQuery* _32x_query_;
	GamesMimeTypeTrackerQuery* _tmp6_;
	GamesMimeTypeTrackerQuery* mega_cd_query;
	GamesMimeTypeTrackerQuery* _tmp7_;
	TrackerSparqlConnection* connection;
	TrackerSparqlConnection* _tmp8_;
	GamesTrackerGameSource* source;
	GamesTrackerGameSource* _tmp9_;
	GamesTrackerGameSource* _tmp10_;
	GamesTrackerGameSource* _tmp11_;
	GamesTrackerGameSource* _tmp12_;
	GError * _inner_error_ = NULL;
	self = (GamesMegaDrivePlugin*) base;
	_tmp0_ = games_generic_sync_game_uri_adapter_new (_games_mega_drive_plugin_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_sync_game_uri_adapter_new (_games_mega_drive_plugin_cd_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri, NULL, NULL);
	cd_game_uri_adapter = _tmp1_;
	_tmp2_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter, NULL, NULL, NULL);
	mega_drive_factory = _tmp2_;
	_tmp3_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter, NULL, NULL, NULL);
	_32x_factory_ = _tmp3_;
	_tmp4_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) cd_game_uri_adapter, NULL, NULL, NULL);
	mega_cd_factory = _tmp4_;
	_tmp5_ = games_mime_type_tracker_query_new (GAMES_MEGA_DRIVE_PLUGIN_MEGA_DRIVE_MIME_TYPE, (GamesUriGameFactory*) mega_drive_factory);
	mega_drive_query = _tmp5_;
	_tmp6_ = games_mime_type_tracker_query_new (GAMES_MEGA_DRIVE_PLUGIN_32X_MIME_TYPE, (GamesUriGameFactory*) _32x_factory_);
	_32x_query_ = _tmp6_;
	_tmp7_ = games_mime_type_tracker_query_new (GAMES_MEGA_DRIVE_PLUGIN_CUE_MIME_TYPE, (GamesUriGameFactory*) mega_cd_factory);
	mega_cd_query = _tmp7_;
	_tmp8_ = tracker_sparql_connection_get (NULL, &_inner_error_);
	connection = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (mega_cd_query);
		_g_object_unref0 (_32x_query_);
		_g_object_unref0 (mega_drive_query);
		_g_object_unref0 (mega_cd_factory);
		_g_object_unref0 (_32x_factory_);
		_g_object_unref0 (mega_drive_factory);
		_g_object_unref0 (cd_game_uri_adapter);
		_g_object_unref0 (game_uri_adapter);
		return NULL;
	}
	_tmp9_ = games_tracker_game_source_new (connection);
	source = _tmp9_;
	_tmp10_ = source;
	games_tracker_game_source_add_query (_tmp10_, (GamesTrackerQuery*) mega_drive_query);
	_tmp11_ = source;
	games_tracker_game_source_add_query (_tmp11_, (GamesTrackerQuery*) _32x_query_);
	_tmp12_ = source;
	games_tracker_game_source_add_query (_tmp12_, (GamesTrackerQuery*) mega_cd_query);
	result = (GamesGameSource*) source;
	_g_object_unref0 (connection);
	_g_object_unref0 (mega_cd_query);
	_g_object_unref0 (_32x_query_);
	_g_object_unref0 (mega_drive_query);
	_g_object_unref0 (mega_cd_factory);
	_g_object_unref0 (_32x_factory_);
	_g_object_unref0 (mega_drive_factory);
	_g_object_unref0 (cd_game_uri_adapter);
	_g_object_unref0 (game_uri_adapter);
	return result;
}


static GamesGame* games_mega_drive_plugin_game_for_uri (const gchar* uri, GError** error) {
	GamesGame* result = NULL;
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GamesMegaDriveHeader* header;
	GamesMegaDriveHeader* _tmp2_;
	gchar* prefix = NULL;
	gchar* mime_type = NULL;
	gchar* platform = NULL;
	gboolean _tmp3_;
	GamesFingerprintUid* uid;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GamesFingerprintUid* _tmp17_;
	GamesFilenameTitle* title;
	const gchar* _tmp18_;
	GamesFilenameTitle* _tmp19_;
	GamesDummyIcon* icon;
	GamesDummyIcon* _tmp20_;
	GamesGriloMedia* media;
	GamesFilenameTitle* _tmp21_;
	const gchar* _tmp22_;
	GamesGriloMedia* _tmp23_;
	GamesCompositeCover* cover;
	const gchar* _tmp24_;
	GamesLocalCover* _tmp25_;
	GamesGriloMedia* _tmp26_;
	GamesFingerprintUid* _tmp27_;
	GamesGriloCover* _tmp28_;
	GamesCover** _tmp29_;
	GamesCover** _tmp30_;
	gint _tmp30__length1;
	GamesCompositeCover* _tmp31_;
	GamesCompositeCover* _tmp32_;
	GamesRetroCoreSource* core_source;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	GamesRetroCoreSource* _tmp38_;
	GamesRetroCoreSource* _tmp39_;
	GamesRetroRunner* runner;
	GamesRetroCoreSource* _tmp40_;
	const gchar* _tmp41_;
	GamesFingerprintUid* _tmp42_;
	GamesFilenameTitle* _tmp43_;
	GamesRetroRunner* _tmp44_;
	GamesFilenameTitle* _tmp45_;
	GamesDummyIcon* _tmp46_;
	GamesCompositeCover* _tmp47_;
	GamesRetroRunner* _tmp48_;
	GamesGenericGame* _tmp49_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = games_mega_drive_header_new (file);
	header = _tmp2_;
	games_mega_drive_header_check_validity (header, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (header);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp3_ = games_mega_drive_header_is_mega_drive (header);
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_MEGA_DRIVE_PREFIX);
		_g_free0 (prefix);
		prefix = _tmp4_;
		_tmp5_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_MEGA_DRIVE_MIME_TYPE);
		_g_free0 (mime_type);
		mime_type = _tmp5_;
		_tmp6_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_MEGA_DRIVE_PLATFORM);
		_g_free0 (platform);
		platform = _tmp6_;
	} else {
		gboolean _tmp7_;
		_tmp7_ = games_mega_drive_header_is_32x (header);
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_32X_PREFIX);
			_g_free0 (prefix);
			prefix = _tmp8_;
			_tmp9_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_32X_MIME_TYPE);
			_g_free0 (mime_type);
			mime_type = _tmp9_;
			_tmp10_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_32X_PLATFORM);
			_g_free0 (platform);
			platform = _tmp10_;
		} else {
			gboolean _tmp11_;
			_tmp11_ = games_mega_drive_header_is_pico (header);
			if (_tmp11_) {
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_PICO_PREFIX);
				_g_free0 (prefix);
				prefix = _tmp12_;
				_tmp13_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_PICO_MIME_TYPE);
				_g_free0 (mime_type);
				mime_type = _tmp13_;
				_tmp14_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_PICO_PLATFORM);
				_g_free0 (platform);
				platform = _tmp14_;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp15_ = uri;
	_tmp16_ = prefix;
	_tmp17_ = games_fingerprint_uid_new (_tmp15_, _tmp16_);
	uid = _tmp17_;
	_tmp18_ = uri;
	_tmp19_ = games_filename_title_new (_tmp18_);
	title = _tmp19_;
	_tmp20_ = games_dummy_icon_new ();
	icon = _tmp20_;
	_tmp21_ = title;
	_tmp22_ = mime_type;
	_tmp23_ = games_grilo_media_new ((GamesTitle*) _tmp21_, _tmp22_);
	media = _tmp23_;
	_tmp24_ = uri;
	_tmp25_ = games_local_cover_new (_tmp24_);
	_tmp26_ = media;
	_tmp27_ = uid;
	_tmp28_ = games_grilo_cover_new (_tmp26_, (GamesUid*) _tmp27_);
	_tmp29_ = g_new0 (GamesCover*, 2 + 1);
	_tmp29_[0] = (GamesCover*) _tmp25_;
	_tmp29_[1] = (GamesCover*) _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 2;
	_tmp31_ = games_composite_cover_new (_tmp30_, 2);
	_tmp32_ = _tmp31_;
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp32_;
	_tmp33_ = platform;
	_tmp34_ = mime_type;
	_tmp35_ = g_strdup (_tmp34_);
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	_tmp38_ = games_retro_core_source_new (_tmp33_, _tmp37_, 1);
	_tmp39_ = _tmp38_;
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	core_source = _tmp39_;
	_tmp40_ = core_source;
	_tmp41_ = uri;
	_tmp42_ = uid;
	_tmp43_ = title;
	_tmp44_ = games_retro_runner_new (_tmp40_, _tmp41_, (GamesUid*) _tmp42_, (GamesTitle*) _tmp43_);
	runner = _tmp44_;
	_tmp45_ = title;
	_tmp46_ = icon;
	_tmp47_ = cover;
	_tmp48_ = runner;
	_tmp49_ = games_generic_game_new ((GamesTitle*) _tmp45_, (GamesIcon*) _tmp46_, (GamesCover*) _tmp47_, (GamesRunner*) _tmp48_);
	result = (GamesGame*) _tmp49_;
	_g_object_unref0 (runner);
	_g_object_unref0 (core_source);
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (platform);
	_g_free0 (mime_type);
	_g_free0 (prefix);
	_g_object_unref0 (header);
	_g_object_unref0 (file);
	return result;
}


static GamesGame* games_mega_drive_plugin_cd_game_for_uri (const gchar* uri, GError** error) {
	GamesGame* result = NULL;
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GamesCueSheet* cue;
	GFile* _tmp2_;
	GamesCueSheet* _tmp3_;
	GFile* bin_file;
	GamesCueSheet* _tmp4_;
	GFile* _tmp5_;
	GamesMegaDriveHeader* header;
	GFile* _tmp6_;
	GamesMegaDriveHeader* _tmp7_;
	GamesMegaDriveHeader* _tmp8_;
	gchar** mime_types = NULL;
	gint mime_types_length1 = 0;
	gint _mime_types_size_ = 0;
	gchar* platform = NULL;
	GamesMegaDriveHeader* _tmp9_;
	gboolean _tmp10_;
	gchar* bin_uri;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gsize header_offset;
	GamesMegaDriveHeader* _tmp24_;
	gsize _tmp25_;
	GamesFingerprintUid* uid;
	const gchar* _tmp26_;
	gsize _tmp27_;
	GamesFingerprintUid* _tmp28_;
	GamesFilenameTitle* title;
	const gchar* _tmp29_;
	GamesFilenameTitle* _tmp30_;
	GamesDummyIcon* icon;
	GamesDummyIcon* _tmp31_;
	GamesGriloMedia* media;
	GamesFilenameTitle* _tmp32_;
	GamesGriloMedia* _tmp33_;
	GamesCompositeCover* cover;
	const gchar* _tmp34_;
	GamesLocalCover* _tmp35_;
	GamesGriloMedia* _tmp36_;
	GamesFingerprintUid* _tmp37_;
	GamesGriloCover* _tmp38_;
	GamesCover** _tmp39_;
	GamesCover** _tmp40_;
	gint _tmp40__length1;
	GamesCompositeCover* _tmp41_;
	GamesCompositeCover* _tmp42_;
	GamesRetroCoreSource* core_source;
	const gchar* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	GamesRetroCoreSource* _tmp45_;
	GamesRetroRunner* runner;
	GamesRetroCoreSource* _tmp46_;
	const gchar* _tmp47_;
	GamesFingerprintUid* _tmp48_;
	GamesFilenameTitle* _tmp49_;
	GamesRetroRunner* _tmp50_;
	GamesFilenameTitle* _tmp51_;
	GamesDummyIcon* _tmp52_;
	GamesCompositeCover* _tmp53_;
	GamesRetroRunner* _tmp54_;
	GamesGenericGame* _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = games_cue_sheet_new (_tmp2_, &_inner_error_);
	cue = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp4_ = cue;
	_tmp5_ = games_mega_drive_plugin_get_binary_file (_tmp4_, &_inner_error_);
	bin_file = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cue);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp6_ = bin_file;
	_tmp7_ = games_mega_drive_header_new (_tmp6_);
	header = _tmp7_;
	_tmp8_ = header;
	games_mega_drive_header_check_validity (_tmp8_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_object_unref0 (cue);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp9_ = header;
	_tmp10_ = games_mega_drive_header_is_mega_drive (_tmp9_);
	if (_tmp10_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_CUE_MIME_TYPE);
		_tmp12_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_MIME_TYPE);
		_tmp13_ = g_new0 (gchar*, 2 + 1);
		_tmp13_[0] = _tmp11_;
		_tmp13_[1] = _tmp12_;
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		mime_types = _tmp13_;
		mime_types_length1 = 2;
		_mime_types_size_ = mime_types_length1;
		_tmp14_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_PLATFORM);
		_g_free0 (platform);
		platform = _tmp14_;
	} else {
		GamesMegaDriveHeader* _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = header;
		_tmp16_ = games_mega_drive_header_is_32x (_tmp15_);
		if (_tmp16_) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_CUE_MIME_TYPE);
			_tmp18_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_MIME_TYPE);
			_tmp19_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_32X_MIME_TYPE);
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
			mime_types = _tmp20_;
			mime_types_length1 = 3;
			_mime_types_size_ = mime_types_length1;
			_tmp21_ = g_strdup (GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_32X_PLATFORM);
			_g_free0 (platform);
			platform = _tmp21_;
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp22_ = bin_file;
	_tmp23_ = g_file_get_uri (_tmp22_);
	bin_uri = _tmp23_;
	_tmp24_ = header;
	_tmp25_ = games_mega_drive_header_get_offset (_tmp24_, &_inner_error_);
	header_offset = _tmp25_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (bin_uri);
		_g_free0 (platform);
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_object_unref0 (cue);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp26_ = bin_uri;
	_tmp27_ = header_offset;
	_tmp28_ = games_fingerprint_uid_new_for_chunk (_tmp26_, GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_PREFIX, _tmp27_, GAMES_MEGA_DRIVE_HEADER_HEADER_LENGTH);
	uid = _tmp28_;
	_tmp29_ = uri;
	_tmp30_ = games_filename_title_new (_tmp29_);
	title = _tmp30_;
	_tmp31_ = games_dummy_icon_new ();
	icon = _tmp31_;
	_tmp32_ = title;
	_tmp33_ = games_grilo_media_new ((GamesTitle*) _tmp32_, GAMES_MEGA_DRIVE_PLUGIN_MEGA_CD_MIME_TYPE);
	media = _tmp33_;
	_tmp34_ = uri;
	_tmp35_ = games_local_cover_new (_tmp34_);
	_tmp36_ = media;
	_tmp37_ = uid;
	_tmp38_ = games_grilo_cover_new (_tmp36_, (GamesUid*) _tmp37_);
	_tmp39_ = g_new0 (GamesCover*, 2 + 1);
	_tmp39_[0] = (GamesCover*) _tmp35_;
	_tmp39_[1] = (GamesCover*) _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 2;
	_tmp41_ = games_composite_cover_new (_tmp40_, 2);
	_tmp42_ = _tmp41_;
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp42_;
	_tmp43_ = platform;
	_tmp44_ = mime_types;
	_tmp44__length1 = mime_types_length1;
	_tmp45_ = games_retro_core_source_new (_tmp43_, _tmp44_, _tmp44__length1);
	core_source = _tmp45_;
	_tmp46_ = core_source;
	_tmp47_ = uri;
	_tmp48_ = uid;
	_tmp49_ = title;
	_tmp50_ = games_retro_runner_new (_tmp46_, _tmp47_, (GamesUid*) _tmp48_, (GamesTitle*) _tmp49_);
	runner = _tmp50_;
	_tmp51_ = title;
	_tmp52_ = icon;
	_tmp53_ = cover;
	_tmp54_ = runner;
	_tmp55_ = games_generic_game_new ((GamesTitle*) _tmp51_, (GamesIcon*) _tmp52_, (GamesCover*) _tmp53_, (GamesRunner*) _tmp54_);
	result = (GamesGame*) _tmp55_;
	_g_object_unref0 (runner);
	_g_object_unref0 (core_source);
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (bin_uri);
	_g_free0 (platform);
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_object_unref0 (cue);
	_g_object_unref0 (file);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GFile* games_mega_drive_plugin_get_binary_file (GamesCueSheet* cue, GError** error) {
	GFile* result = NULL;
	GamesCueSheet* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GamesCueSheetTrackNode* track;
	GamesCueSheet* _tmp10_;
	GamesCueSheetTrackNode* _tmp11_;
	GamesCueSheetFileNode* file;
	GamesCueSheetTrackNode* _tmp12_;
	GamesCueSheetFileNode* _tmp13_;
	GamesCueSheetFileNode* _tmp14_;
	GamesCueSheetFileNode* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GamesCueSheetFileNode* _tmp17_;
	GamesCueSheetFileFormat _tmp18_;
	GamesCueSheetFileFormat _tmp19_;
	GamesCueSheetTrackNode* _tmp30_;
	GamesCueSheetTrackMode _tmp31_;
	GamesCueSheetTrackMode _tmp32_;
	gboolean _tmp33_;
	GamesMegaDriveHeader* header;
	GamesCueSheetFileNode* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	GamesMegaDriveHeader* _tmp47_;
	GamesMegaDriveHeader* _tmp48_;
	GamesCueSheetFileNode* _tmp49_;
	GFile* _tmp50_;
	GFile* _tmp51_;
	GFile* _tmp52_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (cue != NULL, NULL);
	_tmp0_ = cue;
	_tmp1_ = games_cue_sheet_get_tracks_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint) 0)) {
		GamesCueSheet* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp3_ = cue;
		_tmp4_ = games_cue_sheet_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new (GAMES_MEGA_DRIVE_ERROR, GAMES_MEGA_DRIVE_ERROR_INVALID_CUE_SHEET, _ ("The file “%s” doesn’t have a track."), _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp10_ = cue;
	_tmp11_ = games_cue_sheet_get_track (_tmp10_, (guint) 0, &_inner_error_);
	track = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp12_ = track;
	_tmp13_ = games_cue_sheet_track_node_get_file (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	file = _tmp15_;
	_tmp17_ = file;
	_tmp18_ = games_cue_sheet_file_node_get_file_format (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != GAMES_CUE_SHEET_FILE_FORMAT_BINARY) {
		GamesCueSheetFileNode* _tmp20_;
		GamesCueSheetFileFormat _tmp21_;
		GamesCueSheetFileFormat _tmp22_;
		_tmp20_ = file;
		_tmp21_ = games_cue_sheet_file_node_get_file_format (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ != GAMES_CUE_SHEET_FILE_FORMAT_UNKNOWN;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GamesCueSheet* _tmp23_;
		GFile* _tmp24_;
		GFile* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		_tmp23_ = cue;
		_tmp24_ = games_cue_sheet_get_file (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_file_get_uri (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new (GAMES_MEGA_DRIVE_ERROR, GAMES_MEGA_DRIVE_ERROR_INVALID_CUE_SHEET, _ ("The file “%s” doesn’t have a valid binary file format."), _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_inner_error_ = _tmp29_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp30_ = track;
	_tmp31_ = games_cue_sheet_track_node_get_track_mode (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = games_cue_sheet_track_mode_is_mode1 (_tmp32_);
	if (!_tmp33_) {
		GamesCueSheet* _tmp34_;
		GFile* _tmp35_;
		GFile* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GamesCueSheetTrackNode* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		_tmp34_ = cue;
		_tmp35_ = games_cue_sheet_get_file (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_file_get_uri (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = track;
		_tmp40_ = games_cue_sheet_track_node_get_track_number (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_error_new (GAMES_MEGA_DRIVE_ERROR, GAMES_MEGA_DRIVE_ERROR_INVALID_CUE_SHEET, _ ("The file “%s” doesn’t have a valid track mode for track %d."), _tmp38_, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp38_);
		_inner_error_ = _tmp43_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp44_ = file;
	_tmp45_ = games_cue_sheet_file_node_get_file (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = games_mega_drive_header_new (_tmp46_);
	header = _tmp47_;
	_tmp48_ = header;
	games_mega_drive_header_check_validity (_tmp48_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (header);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp49_ = file;
	_tmp50_ = games_cue_sheet_file_node_get_file (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = _g_object_ref0 (_tmp51_);
	result = _tmp52_;
	_g_object_unref0 (header);
	_g_object_unref0 (file);
	_g_object_unref0 (track);
	return result;
}


GamesMegaDrivePlugin* games_mega_drive_plugin_construct (GType object_type) {
	GamesMegaDrivePlugin * self = NULL;
	self = (GamesMegaDrivePlugin*) g_object_new (object_type, NULL);
	return self;
}


GamesMegaDrivePlugin* games_mega_drive_plugin_new (void) {
	return games_mega_drive_plugin_construct (GAMES_TYPE_MEGA_DRIVE_PLUGIN);
}


static void games_mega_drive_plugin_class_init (GamesMegaDrivePluginClass * klass) {
	games_mega_drive_plugin_parent_class = g_type_class_peek_parent (klass);
}


static void games_mega_drive_plugin_games_plugin_interface_init (GamesPluginIface * iface) {
	games_mega_drive_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_game_source = (GamesGameSource* (*) (GamesPlugin *, GError**)) games_mega_drive_plugin_real_get_game_source;
}


static void games_mega_drive_plugin_instance_init (GamesMegaDrivePlugin * self) {
}


GType games_mega_drive_plugin_get_type (void) {
	return games_mega_drive_plugin_type_id;
}


GType games_mega_drive_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesMegaDrivePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_mega_drive_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesMegaDrivePlugin), 0, (GInstanceInitFunc) games_mega_drive_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_mega_drive_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_mega_drive_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesMegaDrivePlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_mega_drive_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_mega_drive_plugin_type_id;
}


GType register_games_plugin (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	games_mega_drive_header_register_type (module);
	games_mega_drive_plugin_register_type (module);
	result = GAMES_TYPE_MEGA_DRIVE_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



