/* game-thumbnail.c generated by valac 0.35.5, the Vala compiler
 * generated from game-thumbnail.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/*[GtkTemplate (ui = "/org/gnome/Boxes/ui/game-list-thumbnail.ui")]*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>


#define GAMES_TYPE_GAME_THUMBNAIL (games_game_thumbnail_get_type ())
#define GAMES_GAME_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail))
#define GAMES_GAME_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnailClass))
#define GAMES_IS_GAME_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_THUMBNAIL))
#define GAMES_IS_GAME_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_THUMBNAIL))
#define GAMES_GAME_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnailClass))

typedef struct _GamesGameThumbnail GamesGameThumbnail;
typedef struct _GamesGameThumbnailClass GamesGameThumbnailClass;
typedef struct _GamesGameThumbnailPrivate GamesGameThumbnailPrivate;

#define GAMES_TYPE_ICON (games_icon_get_type ())
#define GAMES_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_ICON, GamesIcon))
#define GAMES_IS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_ICON))
#define GAMES_ICON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_ICON, GamesIconIface))

typedef struct _GamesIcon GamesIcon;
typedef struct _GamesIconIface GamesIconIface;

#define GAMES_TYPE_COVER (games_cover_get_type ())
#define GAMES_COVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COVER, GamesCover))
#define GAMES_IS_COVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COVER))
#define GAMES_COVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COVER, GamesCoverIface))

typedef struct _GamesCover GamesCover;
typedef struct _GamesCoverIface GamesCoverIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_GAME_THUMBNAIL_TYPE_DRAWING_CONTEXT (games_game_thumbnail_drawing_context_get_type ())
typedef struct _GamesGameThumbnailDrawingContext GamesGameThumbnailDrawingContext;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _GamesGameThumbnail {
	GtkDrawingArea parent_instance;
	GamesGameThumbnailPrivate * priv;
};

struct _GamesGameThumbnailClass {
	GtkDrawingAreaClass parent_class;
};

struct _GamesIconIface {
	GTypeInterface parent_iface;
	GIcon* (*get_icon) (GamesIcon* self);
};

struct _GamesCoverIface {
	GTypeInterface parent_iface;
	GIcon* (*get_cover) (GamesCover* self);
};

struct _GamesGameThumbnailPrivate {
	gint _center_emblem_size;
	gint _secondary_emblem_size;
	GamesIcon* _icon;
	gulong cover_changed_id;
	GamesCover* _cover;
	GdkPixbuf* cover_cache;
	gint previous_cover_width;
	gint previous_cover_height;
};

struct _GamesGameThumbnailDrawingContext {
	cairo_t* cr;
	GdkWindow* window;
	GtkStyleContext* style;
	GtkStateFlags state;
	gint width;
	gint height;
};


static gpointer games_game_thumbnail_parent_class = NULL;

GType games_game_thumbnail_get_type (void) G_GNUC_CONST;
GType games_icon_get_type (void) G_GNUC_CONST;
GType games_cover_get_type (void) G_GNUC_CONST;
#define GAMES_GAME_THUMBNAIL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnailPrivate))
enum  {
	GAMES_GAME_THUMBNAIL_DUMMY_PROPERTY,
	GAMES_GAME_THUMBNAIL_CENTER_EMBLEM_SIZE,
	GAMES_GAME_THUMBNAIL_SECONDARY_EMBLEM_SIZE,
	GAMES_GAME_THUMBNAIL_ICON,
	GAMES_GAME_THUMBNAIL_COVER
};
#define GAMES_GAME_THUMBNAIL_ICON_SCALE 0.75
#define GAMES_GAME_THUMBNAIL_COVER_MARGIN ((gdouble) 0)
#define GAMES_GAME_THUMBNAIL_FRAME_RADIUS ((gdouble) 2)
#define GAMES_GAME_THUMBNAIL_EMBLEM_PADDING 8
static gboolean games_game_thumbnail_real_draw (GtkWidget* base, cairo_t* cr);
GType games_game_thumbnail_drawing_context_get_type (void) G_GNUC_CONST;
GamesGameThumbnailDrawingContext* games_game_thumbnail_drawing_context_dup (const GamesGameThumbnailDrawingContext* self);
void games_game_thumbnail_drawing_context_free (GamesGameThumbnailDrawingContext* self);
void games_game_thumbnail_drawing_context_copy (const GamesGameThumbnailDrawingContext* self, GamesGameThumbnailDrawingContext* dest);
void games_game_thumbnail_drawing_context_destroy (GamesGameThumbnailDrawingContext* self);
GamesIcon* games_game_thumbnail_get_icon (GamesGameThumbnail* self);
GamesCover* games_game_thumbnail_get_cover (GamesGameThumbnail* self);
gboolean games_game_thumbnail_draw_cover (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context);
gboolean games_game_thumbnail_draw_icon (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context);
void games_game_thumbnail_draw_default (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context);
GIcon* games_icon_get_icon (GamesIcon* self);
static GdkPixbuf* games_game_thumbnail_get_scaled_icon (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context, GIcon* icon, gdouble scale);
static void games_game_thumbnail_draw_background (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context);
static void games_game_thumbnail_draw_pixbuf (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context, GdkPixbuf* pixbuf);
static void games_game_thumbnail_draw_border (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context);
static GdkPixbuf* games_game_thumbnail_get_scaled_cover (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context);
static void games_game_thumbnail_rounded_rectangle (GamesGameThumbnail* self, cairo_t* cr, gdouble x, gdouble y, gdouble width, gdouble height, gdouble radius);
static void games_game_thumbnail_draw_emblem_icon (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context, const gchar* icon_name, gint size);
gint games_game_thumbnail_get_center_emblem_size (GamesGameThumbnail* self);
GIcon* games_cover_get_cover (GamesCover* self);
static void games_game_thumbnail_invalidate_cover (GamesGameThumbnail* self);
static cairo_surface_t* games_game_thumbnail_get_mask (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context);
GamesGameThumbnail* games_game_thumbnail_new (void);
GamesGameThumbnail* games_game_thumbnail_construct (GType object_type);
void games_game_thumbnail_set_center_emblem_size (GamesGameThumbnail* self, gint value);
gint games_game_thumbnail_get_secondary_emblem_size (GamesGameThumbnail* self);
void games_game_thumbnail_set_secondary_emblem_size (GamesGameThumbnail* self, gint value);
void games_game_thumbnail_set_icon (GamesGameThumbnail* self, GamesIcon* value);
void games_game_thumbnail_set_cover (GamesGameThumbnail* self, GamesCover* value);
static void _games_game_thumbnail_invalidate_cover_games_cover_changed (GamesCover* _sender, gpointer self);
static void games_game_thumbnail_finalize (GObject * obj);
static void _vala_games_game_thumbnail_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_games_game_thumbnail_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GtkCornerType GAMES_GAME_THUMBNAIL_right_corners[2] = {GTK_CORNER_TOP_RIGHT, GTK_CORNER_BOTTOM_RIGHT};
static const GtkCornerType GAMES_GAME_THUMBNAIL_bottom_corners[2] = {GTK_CORNER_BOTTOM_LEFT, GTK_CORNER_BOTTOM_RIGHT};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static gboolean games_game_thumbnail_real_draw (GtkWidget* base, cairo_t* cr) {
	GamesGameThumbnail * self;
	gboolean result = FALSE;
	GdkWindow* window;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GtkStyleContext* style;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStateFlags state;
	GtkStateFlags _tmp4_;
	gint width;
	gint _tmp5_;
	gint height;
	gint _tmp6_;
	GamesGameThumbnailDrawingContext context;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	GdkWindow* _tmp9_;
	GdkWindow* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkStyleContext* _tmp12_;
	GtkStateFlags _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GamesGameThumbnailDrawingContext _tmp16_ = {0};
	GamesIcon* _tmp17_;
	GamesIcon* _tmp18_;
	GamesCover* _tmp19_;
	GamesCover* _tmp20_;
	gboolean drawn;
	GamesGameThumbnailDrawingContext _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp26_;
	self = (GamesGameThumbnail*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style = _tmp3_;
	_tmp4_ = gtk_widget_get_state_flags ((GtkWidget*) self);
	state = _tmp4_;
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	width = _tmp5_;
	_tmp6_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	height = _tmp6_;
	_tmp7_ = cr;
	_tmp8_ = _cairo_reference0 (_tmp7_);
	_tmp9_ = window;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_tmp11_ = style;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_tmp13_ = state;
	_tmp14_ = width;
	_tmp15_ = height;
	_cairo_destroy0 (_tmp16_.cr);
	_tmp16_.cr = _tmp8_;
	_g_object_unref0 (_tmp16_.window);
	_tmp16_.window = _tmp10_;
	_g_object_unref0 (_tmp16_.style);
	_tmp16_.style = _tmp12_;
	_tmp16_.state = _tmp13_;
	_tmp16_.width = _tmp14_;
	_tmp16_.height = _tmp15_;
	context = _tmp16_;
	_tmp17_ = games_game_thumbnail_get_icon (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == NULL) {
		result = FALSE;
		games_game_thumbnail_drawing_context_destroy (&context);
		_g_object_unref0 (style);
		_g_object_unref0 (window);
		return result;
	}
	_tmp19_ = games_game_thumbnail_get_cover (self);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		result = FALSE;
		games_game_thumbnail_drawing_context_destroy (&context);
		_g_object_unref0 (style);
		_g_object_unref0 (window);
		return result;
	}
	drawn = FALSE;
	_tmp21_ = context;
	_tmp22_ = games_game_thumbnail_draw_cover (self, &_tmp21_);
	drawn = _tmp22_;
	_tmp23_ = drawn;
	if (!_tmp23_) {
		GamesGameThumbnailDrawingContext _tmp24_;
		gboolean _tmp25_;
		_tmp24_ = context;
		_tmp25_ = games_game_thumbnail_draw_icon (self, &_tmp24_);
		drawn = _tmp25_;
	}
	_tmp26_ = drawn;
	if (!_tmp26_) {
		GamesGameThumbnailDrawingContext _tmp27_;
		_tmp27_ = context;
		games_game_thumbnail_draw_default (self, &_tmp27_);
	}
	result = TRUE;
	games_game_thumbnail_drawing_context_destroy (&context);
	_g_object_unref0 (style);
	_g_object_unref0 (window);
	return result;
}


gboolean games_game_thumbnail_draw_icon (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context) {
	gboolean result = FALSE;
	GIcon* g_icon;
	GamesIcon* _tmp0_;
	GamesIcon* _tmp1_;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	GdkPixbuf* pixbuf;
	GamesGameThumbnailDrawingContext _tmp4_;
	GIcon* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GamesGameThumbnailDrawingContext _tmp8_;
	GamesGameThumbnailDrawingContext _tmp9_;
	GdkPixbuf* _tmp10_;
	GamesGameThumbnailDrawingContext _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = games_game_thumbnail_get_icon (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_icon_get_icon (_tmp1_);
	g_icon = _tmp2_;
	_tmp3_ = g_icon;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (g_icon);
		return result;
	}
	_tmp4_ = *context;
	_tmp5_ = g_icon;
	_tmp6_ = games_game_thumbnail_get_scaled_icon (self, &_tmp4_, _tmp5_, GAMES_GAME_THUMBNAIL_ICON_SCALE);
	pixbuf = _tmp6_;
	_tmp7_ = pixbuf;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (g_icon);
		return result;
	}
	_tmp8_ = *context;
	games_game_thumbnail_draw_background (self, &_tmp8_);
	_tmp9_ = *context;
	_tmp10_ = pixbuf;
	games_game_thumbnail_draw_pixbuf (self, &_tmp9_, _tmp10_);
	_tmp11_ = *context;
	games_game_thumbnail_draw_border (self, &_tmp11_);
	result = TRUE;
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (g_icon);
	return result;
}


gboolean games_game_thumbnail_draw_cover (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context) {
	gboolean result = FALSE;
	GdkPixbuf* pixbuf;
	GamesGameThumbnailDrawingContext _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GamesGameThumbnailDrawingContext _tmp3_;
	cairo_t* _tmp4_;
	GamesGameThumbnailDrawingContext _tmp5_;
	cairo_t* _tmp6_;
	GamesGameThumbnailDrawingContext _tmp7_;
	gint _tmp8_;
	GamesGameThumbnailDrawingContext _tmp9_;
	gint _tmp10_;
	GamesGameThumbnailDrawingContext _tmp11_;
	cairo_t* _tmp12_;
	GamesGameThumbnailDrawingContext _tmp13_;
	GdkPixbuf* _tmp14_;
	GamesGameThumbnailDrawingContext _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = *context;
	_tmp1_ = games_game_thumbnail_get_scaled_cover (self, &_tmp0_);
	pixbuf = _tmp1_;
	_tmp2_ = pixbuf;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (pixbuf);
		return result;
	}
	_tmp3_ = *context;
	_tmp4_ = _tmp3_.cr;
	cairo_set_source_rgb (_tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp5_ = *context;
	_tmp6_ = _tmp5_.cr;
	_tmp7_ = *context;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = *context;
	_tmp10_ = _tmp9_.height;
	games_game_thumbnail_rounded_rectangle (self, _tmp6_, 0.5, 0.5, (gdouble) (_tmp8_ - 1), (gdouble) (_tmp10_ - 1), GAMES_GAME_THUMBNAIL_FRAME_RADIUS);
	_tmp11_ = *context;
	_tmp12_ = _tmp11_.cr;
	cairo_fill (_tmp12_);
	_tmp13_ = *context;
	_tmp14_ = pixbuf;
	games_game_thumbnail_draw_pixbuf (self, &_tmp13_, _tmp14_);
	_tmp15_ = *context;
	games_game_thumbnail_draw_border (self, &_tmp15_);
	result = TRUE;
	_g_object_unref0 (pixbuf);
	return result;
}


void games_game_thumbnail_draw_default (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context) {
	GamesGameThumbnailDrawingContext _tmp0_;
	GamesGameThumbnailDrawingContext _tmp1_;
	gint _tmp2_;
	GamesGameThumbnailDrawingContext _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = *context;
	games_game_thumbnail_draw_background (self, &_tmp0_);
	_tmp1_ = *context;
	_tmp2_ = self->priv->_center_emblem_size;
	games_game_thumbnail_draw_emblem_icon (self, &_tmp1_, "applications-games-symbolic", _tmp2_);
	_tmp3_ = *context;
	games_game_thumbnail_draw_border (self, &_tmp3_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void games_game_thumbnail_draw_emblem_icon (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context, const gchar* icon_name, gint size) {
	GdkPixbuf* emblem;
	GdkRGBA color;
	GamesGameThumbnailDrawingContext _tmp0_;
	GtkStyleContext* _tmp1_;
	GamesGameThumbnailDrawingContext _tmp2_;
	GtkStateFlags _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GtkIconTheme* theme;
	GtkIconTheme* _tmp5_;
	GtkIconTheme* _tmp6_;
	GdkPixbuf* _tmp23_;
	gdouble offset_x;
	GamesGameThumbnailDrawingContext _tmp24_;
	gint _tmp25_;
	GdkPixbuf* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gdouble offset_y;
	GamesGameThumbnailDrawingContext _tmp29_;
	gint _tmp30_;
	GdkPixbuf* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GamesGameThumbnailDrawingContext _tmp34_;
	cairo_t* _tmp35_;
	GdkPixbuf* _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	GamesGameThumbnailDrawingContext _tmp39_;
	cairo_t* _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (icon_name != NULL);
	emblem = NULL;
	_tmp0_ = *context;
	_tmp1_ = _tmp0_.style;
	_tmp2_ = *context;
	_tmp3_ = _tmp2_.state;
	gtk_style_context_get_color (_tmp1_, _tmp3_, &_tmp4_);
	color = _tmp4_;
	_tmp5_ = gtk_icon_theme_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	theme = _tmp6_;
	{
		GtkIconInfo* icon_info;
		GtkIconTheme* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		GtkIconInfo* _tmp10_;
		GdkPixbuf* _tmp11_;
		GtkIconInfo* _tmp12_;
		GdkRGBA _tmp13_;
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		_tmp7_ = theme;
		_tmp8_ = icon_name;
		_tmp9_ = size;
		_tmp10_ = gtk_icon_theme_lookup_icon (_tmp7_, _tmp8_, _tmp9_, GTK_ICON_LOOKUP_FORCE_SIZE);
		icon_info = _tmp10_;
		_tmp12_ = icon_info;
		_tmp13_ = color;
		_tmp14_ = gtk_icon_info_load_symbolic (_tmp12_, &_tmp13_, NULL, NULL, NULL, NULL, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_gtk_icon_info_free0 (icon_info);
			goto __catch34_g_error;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (emblem);
		emblem = _tmp15_;
		_g_object_unref0 (_tmp11_);
		_gtk_icon_info_free0 (icon_info);
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = icon_name;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat ("Unable to get icon “", _tmp17_, "”: ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		g_warning ("game-thumbnail.vala:145: %s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_error_free0 (_error_);
		_g_object_unref0 (theme);
		_g_object_unref0 (emblem);
		return;
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (theme);
		_g_object_unref0 (emblem);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp23_ = emblem;
	if (_tmp23_ == NULL) {
		_g_object_unref0 (theme);
		_g_object_unref0 (emblem);
		return;
	}
	_tmp24_ = *context;
	_tmp25_ = _tmp24_.width;
	_tmp26_ = emblem;
	_tmp27_ = gdk_pixbuf_get_width (_tmp26_);
	_tmp28_ = _tmp27_;
	offset_x = (_tmp25_ / 2.0) - (_tmp28_ / 2.0);
	_tmp29_ = *context;
	_tmp30_ = _tmp29_.height;
	_tmp31_ = emblem;
	_tmp32_ = gdk_pixbuf_get_height (_tmp31_);
	_tmp33_ = _tmp32_;
	offset_y = (_tmp30_ / 2.0) - (_tmp33_ / 2.0);
	_tmp34_ = *context;
	_tmp35_ = _tmp34_.cr;
	_tmp36_ = emblem;
	_tmp37_ = offset_x;
	_tmp38_ = offset_y;
	gdk_cairo_set_source_pixbuf (_tmp35_, _tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = *context;
	_tmp40_ = _tmp39_.cr;
	cairo_paint (_tmp40_);
	_g_object_unref0 (theme);
	_g_object_unref0 (emblem);
}


static GdkPixbuf* games_game_thumbnail_get_scaled_icon (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context, GIcon* icon, gdouble scale) {
	GdkPixbuf* result = NULL;
	GIcon* _tmp0_;
	GtkIconTheme* theme;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* _tmp2_;
	GtkIconLookupFlags lookup_flags;
	gdouble size;
	GamesGameThumbnailDrawingContext _tmp3_;
	gint _tmp4_;
	GamesGameThumbnailDrawingContext _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gdouble _tmp8_;
	GtkIconInfo* icon_info;
	GtkIconTheme* _tmp9_;
	GIcon* _tmp10_;
	gdouble _tmp11_;
	GtkIconLookupFlags _tmp12_;
	GtkIconInfo* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = icon;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = gtk_icon_theme_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	theme = _tmp2_;
	lookup_flags = GTK_ICON_LOOKUP_FORCE_SIZE | GTK_ICON_LOOKUP_FORCE_REGULAR;
	_tmp3_ = *context;
	_tmp4_ = _tmp3_.width;
	_tmp5_ = *context;
	_tmp6_ = _tmp5_.height;
	_tmp7_ = MIN (_tmp4_, _tmp6_);
	_tmp8_ = scale;
	size = _tmp7_ * _tmp8_;
	_tmp9_ = theme;
	_tmp10_ = icon;
	_tmp11_ = size;
	_tmp12_ = lookup_flags;
	_tmp13_ = gtk_icon_theme_lookup_by_gicon (_tmp9_, _tmp10_, (gint) _tmp11_, _tmp12_);
	icon_info = _tmp13_;
	{
		GdkPixbuf* _tmp14_;
		GtkIconInfo* _tmp15_;
		GdkPixbuf* _tmp16_;
		GdkPixbuf* _tmp17_;
		_tmp15_ = icon_info;
		_tmp16_ = gtk_icon_info_load_icon (_tmp15_, &_inner_error_);
		_tmp14_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch35_g_error;
		}
		_tmp17_ = _tmp14_;
		_tmp14_ = NULL;
		result = _tmp17_;
		_g_object_unref0 (_tmp14_);
		_gtk_icon_info_free0 (icon_info);
		_g_object_unref0 (theme);
		return result;
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat ("Couldn’t load the icon: ", _tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		g_warning ("game-thumbnail.vala:172: %s", _tmp22_);
		_g_free0 (_tmp22_);
		result = NULL;
		_g_error_free0 (e);
		_gtk_icon_info_free0 (icon_info);
		_g_object_unref0 (theme);
		return result;
	}
	__finally35:
	_gtk_icon_info_free0 (icon_info);
	_g_object_unref0 (theme);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static GdkPixbuf* games_game_thumbnail_get_scaled_cover (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context) {
	GdkPixbuf* result = NULL;
	gint _tmp0_;
	GamesGameThumbnailDrawingContext _tmp1_;
	gint _tmp2_;
	gint _tmp5_;
	GamesGameThumbnailDrawingContext _tmp6_;
	gint _tmp7_;
	GdkPixbuf* _tmp10_;
	GIcon* g_icon;
	GamesCover* _tmp13_;
	GamesCover* _tmp14_;
	GIcon* _tmp15_;
	GIcon* _tmp16_;
	GtkIconTheme* theme;
	GtkIconTheme* _tmp17_;
	GtkIconTheme* _tmp18_;
	GtkIconLookupFlags lookup_flags;
	gdouble size;
	GamesGameThumbnailDrawingContext _tmp19_;
	gint _tmp20_;
	GamesGameThumbnailDrawingContext _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GtkIconInfo* icon_info;
	GtkIconTheme* _tmp24_;
	GIcon* _tmp25_;
	gdouble _tmp26_;
	GtkIconLookupFlags _tmp27_;
	GtkIconInfo* _tmp28_;
	GdkPixbuf* _tmp38_;
	GdkPixbuf* _tmp39_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = self->priv->previous_cover_width;
	_tmp1_ = *context;
	_tmp2_ = _tmp1_.width;
	if (_tmp0_ != _tmp2_) {
		GamesGameThumbnailDrawingContext _tmp3_;
		gint _tmp4_;
		_tmp3_ = *context;
		_tmp4_ = _tmp3_.width;
		self->priv->previous_cover_width = _tmp4_;
		_g_object_unref0 (self->priv->cover_cache);
		self->priv->cover_cache = NULL;
	}
	_tmp5_ = self->priv->previous_cover_height;
	_tmp6_ = *context;
	_tmp7_ = _tmp6_.height;
	if (_tmp5_ != _tmp7_) {
		GamesGameThumbnailDrawingContext _tmp8_;
		gint _tmp9_;
		_tmp8_ = *context;
		_tmp9_ = _tmp8_.height;
		self->priv->previous_cover_height = _tmp9_;
		_g_object_unref0 (self->priv->cover_cache);
		self->priv->cover_cache = NULL;
	}
	_tmp10_ = self->priv->cover_cache;
	if (_tmp10_ != NULL) {
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		_tmp11_ = self->priv->cover_cache;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		result = _tmp12_;
		return result;
	}
	_tmp13_ = games_game_thumbnail_get_cover (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = games_cover_get_cover (_tmp14_);
	g_icon = _tmp15_;
	_tmp16_ = g_icon;
	if (_tmp16_ == NULL) {
		result = NULL;
		_g_object_unref0 (g_icon);
		return result;
	}
	_tmp17_ = gtk_icon_theme_get_default ();
	_tmp18_ = _g_object_ref0 (_tmp17_);
	theme = _tmp18_;
	lookup_flags = GTK_ICON_LOOKUP_FORCE_SIZE | GTK_ICON_LOOKUP_FORCE_REGULAR;
	_tmp19_ = *context;
	_tmp20_ = _tmp19_.width;
	_tmp21_ = *context;
	_tmp22_ = _tmp21_.height;
	_tmp23_ = MIN (_tmp20_, _tmp22_);
	size = _tmp23_ - (GAMES_GAME_THUMBNAIL_COVER_MARGIN * 2);
	_tmp24_ = theme;
	_tmp25_ = g_icon;
	_tmp26_ = size;
	_tmp27_ = lookup_flags;
	_tmp28_ = gtk_icon_theme_lookup_by_gicon (_tmp24_, _tmp25_, (gint) _tmp26_, _tmp27_);
	icon_info = _tmp28_;
	{
		GdkPixbuf* _tmp29_;
		GtkIconInfo* _tmp30_;
		GdkPixbuf* _tmp31_;
		GdkPixbuf* _tmp32_;
		_tmp30_ = icon_info;
		_tmp31_ = gtk_icon_info_load_icon (_tmp30_, &_inner_error_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
		_tmp32_ = _tmp29_;
		_tmp29_ = NULL;
		_g_object_unref0 (self->priv->cover_cache);
		self->priv->cover_cache = _tmp32_;
		_g_object_unref0 (_tmp29_);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		_tmp35_ = string_to_string (_tmp34_);
		_tmp36_ = g_strconcat ("Couldn’t load the icon: ", _tmp35_, "\n", NULL);
		_tmp37_ = _tmp36_;
		g_warning ("game-thumbnail.vala:204: %s", _tmp37_);
		_g_free0 (_tmp37_);
		_g_error_free0 (e);
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_gtk_icon_info_free0 (icon_info);
		_g_object_unref0 (theme);
		_g_object_unref0 (g_icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp38_ = self->priv->cover_cache;
	_tmp39_ = _g_object_ref0 (_tmp38_);
	result = _tmp39_;
	_gtk_icon_info_free0 (icon_info);
	_g_object_unref0 (theme);
	_g_object_unref0 (g_icon);
	return result;
}


static void games_game_thumbnail_invalidate_cover (GamesGameThumbnail* self) {
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->cover_cache);
	self->priv->cover_cache = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void games_game_thumbnail_draw_pixbuf (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context, GdkPixbuf* pixbuf) {
	cairo_surface_t* surface;
	GdkPixbuf* _tmp0_;
	GamesGameThumbnailDrawingContext _tmp1_;
	GdkWindow* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* mask;
	GamesGameThumbnailDrawingContext _tmp4_;
	cairo_surface_t* _tmp5_;
	gint x_offset;
	GamesGameThumbnailDrawingContext _tmp6_;
	gint _tmp7_;
	GdkPixbuf* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint y_offset;
	GamesGameThumbnailDrawingContext _tmp11_;
	gint _tmp12_;
	GdkPixbuf* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GamesGameThumbnailDrawingContext _tmp16_;
	cairo_t* _tmp17_;
	GamesGameThumbnailDrawingContext _tmp18_;
	cairo_t* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = *context;
	_tmp2_ = _tmp1_.window;
	_tmp3_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, _tmp2_);
	surface = _tmp3_;
	_tmp4_ = *context;
	_tmp5_ = games_game_thumbnail_get_mask (self, &_tmp4_);
	mask = _tmp5_;
	_tmp6_ = *context;
	_tmp7_ = _tmp6_.width;
	_tmp8_ = pixbuf;
	_tmp9_ = gdk_pixbuf_get_width (_tmp8_);
	_tmp10_ = _tmp9_;
	x_offset = (_tmp7_ - _tmp10_) / 2;
	_tmp11_ = *context;
	_tmp12_ = _tmp11_.height;
	_tmp13_ = pixbuf;
	_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
	_tmp15_ = _tmp14_;
	y_offset = (_tmp12_ - _tmp15_) / 2;
	_tmp16_ = *context;
	_tmp17_ = _tmp16_.cr;
	cairo_set_source_surface (_tmp17_, surface, (gdouble) x_offset, (gdouble) y_offset);
	_tmp18_ = *context;
	_tmp19_ = _tmp18_.cr;
	cairo_mask_surface (_tmp19_, mask, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (mask);
	_cairo_surface_destroy0 (surface);
}


static cairo_surface_t* games_game_thumbnail_get_mask (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context) {
	cairo_surface_t* result = NULL;
	cairo_surface_t* mask;
	GamesGameThumbnailDrawingContext _tmp0_;
	gint _tmp1_;
	GamesGameThumbnailDrawingContext _tmp2_;
	gint _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_t* cr;
	cairo_t* _tmp5_;
	GamesGameThumbnailDrawingContext _tmp6_;
	gint _tmp7_;
	GamesGameThumbnailDrawingContext _tmp8_;
	gint _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = *context;
	_tmp1_ = _tmp0_.width;
	_tmp2_ = *context;
	_tmp3_ = _tmp2_.height;
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_A8, _tmp1_, _tmp3_);
	mask = _tmp4_;
	_tmp5_ = cairo_create (mask);
	cr = _tmp5_;
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.9);
	_tmp6_ = *context;
	_tmp7_ = _tmp6_.width;
	_tmp8_ = *context;
	_tmp9_ = _tmp8_.height;
	games_game_thumbnail_rounded_rectangle (self, cr, 0.5, 0.5, (gdouble) (_tmp7_ - 1), (gdouble) (_tmp9_ - 1), GAMES_GAME_THUMBNAIL_FRAME_RADIUS);
	cairo_fill (cr);
	result = mask;
	_cairo_destroy0 (cr);
	return result;
}


static void games_game_thumbnail_draw_background (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context) {
	GamesGameThumbnailDrawingContext _tmp0_;
	GtkStyleContext* _tmp1_;
	GamesGameThumbnailDrawingContext _tmp2_;
	cairo_t* _tmp3_;
	GamesGameThumbnailDrawingContext _tmp4_;
	gint _tmp5_;
	GamesGameThumbnailDrawingContext _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = *context;
	_tmp1_ = _tmp0_.style;
	_tmp2_ = *context;
	_tmp3_ = _tmp2_.cr;
	_tmp4_ = *context;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = *context;
	_tmp7_ = _tmp6_.height;
	gtk_render_background (_tmp1_, _tmp3_, 0.0, 0.0, (gdouble) _tmp5_, (gdouble) _tmp7_);
}


static void games_game_thumbnail_draw_border (GamesGameThumbnail* self, GamesGameThumbnailDrawingContext* context) {
	GamesGameThumbnailDrawingContext _tmp0_;
	GtkStyleContext* _tmp1_;
	GamesGameThumbnailDrawingContext _tmp2_;
	cairo_t* _tmp3_;
	GamesGameThumbnailDrawingContext _tmp4_;
	gint _tmp5_;
	GamesGameThumbnailDrawingContext _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = *context;
	_tmp1_ = _tmp0_.style;
	_tmp2_ = *context;
	_tmp3_ = _tmp2_.cr;
	_tmp4_ = *context;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = *context;
	_tmp7_ = _tmp6_.height;
	gtk_render_frame (_tmp1_, _tmp3_, 0.0, 0.0, (gdouble) _tmp5_, (gdouble) _tmp7_);
}


static void games_game_thumbnail_rounded_rectangle (GamesGameThumbnail* self, cairo_t* cr, gdouble x, gdouble y, gdouble width, gdouble height, gdouble radius) {
	static const gdouble ARC_0 = (gdouble) 0;
	static const gdouble ARC_1 = G_PI * 0.5;
	static const gdouble ARC_2 = G_PI;
	static const gdouble ARC_3 = G_PI * 1.5;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	cairo_t* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	cairo_t* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	cairo_t* _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	cairo_t* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_new_sub_path (_tmp0_);
	_tmp1_ = cr;
	_tmp2_ = x;
	_tmp3_ = width;
	_tmp4_ = radius;
	_tmp5_ = y;
	_tmp6_ = radius;
	_tmp7_ = radius;
	cairo_arc (_tmp1_, (_tmp2_ + _tmp3_) - _tmp4_, _tmp5_ + _tmp6_, _tmp7_, ARC_3, ARC_0);
	_tmp8_ = cr;
	_tmp9_ = x;
	_tmp10_ = width;
	_tmp11_ = radius;
	_tmp12_ = y;
	_tmp13_ = height;
	_tmp14_ = radius;
	_tmp15_ = radius;
	cairo_arc (_tmp8_, (_tmp9_ + _tmp10_) - _tmp11_, (_tmp12_ + _tmp13_) - _tmp14_, _tmp15_, ARC_0, ARC_1);
	_tmp16_ = cr;
	_tmp17_ = x;
	_tmp18_ = radius;
	_tmp19_ = y;
	_tmp20_ = height;
	_tmp21_ = radius;
	_tmp22_ = radius;
	cairo_arc (_tmp16_, _tmp17_ + _tmp18_, (_tmp19_ + _tmp20_) - _tmp21_, _tmp22_, ARC_1, ARC_2);
	_tmp23_ = cr;
	_tmp24_ = x;
	_tmp25_ = radius;
	_tmp26_ = y;
	_tmp27_ = radius;
	_tmp28_ = radius;
	cairo_arc (_tmp23_, _tmp24_ + _tmp25_, _tmp26_ + _tmp27_, _tmp28_, ARC_2, ARC_3);
	_tmp29_ = cr;
	cairo_close_path (_tmp29_);
}


GamesGameThumbnail* games_game_thumbnail_construct (GType object_type) {
	GamesGameThumbnail * self = NULL;
	self = (GamesGameThumbnail*) g_object_new (object_type, NULL);
	return self;
}


GamesGameThumbnail* games_game_thumbnail_new (void) {
	return games_game_thumbnail_construct (GAMES_TYPE_GAME_THUMBNAIL);
}


gint games_game_thumbnail_get_center_emblem_size (GamesGameThumbnail* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_center_emblem_size;
	result = _tmp0_;
	return result;
}


void games_game_thumbnail_set_center_emblem_size (GamesGameThumbnail* self, gint value) {
	g_return_if_fail (self != NULL);
	if (games_game_thumbnail_get_center_emblem_size (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_center_emblem_size = _tmp0_;
		g_object_notify ((GObject *) self, "center-emblem-size");
	}
}


gint games_game_thumbnail_get_secondary_emblem_size (GamesGameThumbnail* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_secondary_emblem_size;
	result = _tmp0_;
	return result;
}


void games_game_thumbnail_set_secondary_emblem_size (GamesGameThumbnail* self, gint value) {
	g_return_if_fail (self != NULL);
	if (games_game_thumbnail_get_secondary_emblem_size (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_secondary_emblem_size = _tmp0_;
		g_object_notify ((GObject *) self, "secondary-emblem-size");
	}
}


GamesIcon* games_game_thumbnail_get_icon (GamesGameThumbnail* self) {
	GamesIcon* result;
	GamesIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


void games_game_thumbnail_set_icon (GamesGameThumbnail* self, GamesIcon* value) {
	g_return_if_fail (self != NULL);
	if (games_game_thumbnail_get_icon (self) != value) {
		GamesIcon* _tmp0_;
		GamesIcon* _tmp1_;
		GamesIcon* _tmp2_;
		GamesIcon* _tmp3_;
		_tmp0_ = self->priv->_icon;
		_tmp1_ = value;
		if (_tmp0_ == _tmp1_) {
			return;
		}
		_tmp2_ = value;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp3_;
		gtk_widget_queue_draw ((GtkWidget*) self);
		g_object_notify ((GObject *) self, "icon");
	}
}


GamesCover* games_game_thumbnail_get_cover (GamesGameThumbnail* self) {
	GamesCover* result;
	GamesCover* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cover;
	result = _tmp0_;
	return result;
}


static void _games_game_thumbnail_invalidate_cover_games_cover_changed (GamesCover* _sender, gpointer self) {
	games_game_thumbnail_invalidate_cover ((GamesGameThumbnail*) self);
}


void games_game_thumbnail_set_cover (GamesGameThumbnail* self, GamesCover* value) {
	g_return_if_fail (self != NULL);
	if (games_game_thumbnail_get_cover (self) != value) {
		GamesCover* _tmp0_;
		GamesCover* _tmp1_;
		GamesCover* _tmp2_;
		GamesCover* _tmp5_;
		GamesCover* _tmp6_;
		GamesCover* _tmp7_;
		_tmp0_ = self->priv->_cover;
		_tmp1_ = value;
		if (_tmp0_ == _tmp1_) {
			return;
		}
		_tmp2_ = self->priv->_cover;
		if (_tmp2_ != NULL) {
			GamesCover* _tmp3_;
			gulong _tmp4_;
			_tmp3_ = self->priv->_cover;
			_tmp4_ = self->priv->cover_changed_id;
			g_signal_handler_disconnect ((GObject*) _tmp3_, _tmp4_);
		}
		_tmp5_ = value;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (self->priv->_cover);
		self->priv->_cover = _tmp6_;
		_tmp7_ = self->priv->_cover;
		if (_tmp7_ != NULL) {
			GamesCover* _tmp8_;
			_tmp8_ = self->priv->_cover;
			g_signal_connect_object (_tmp8_, "changed", (GCallback) _games_game_thumbnail_invalidate_cover_games_cover_changed, self, 0);
		}
		games_game_thumbnail_invalidate_cover (self);
		g_object_notify ((GObject *) self, "cover");
	}
}


void games_game_thumbnail_drawing_context_copy (const GamesGameThumbnailDrawingContext* self, GamesGameThumbnailDrawingContext* dest) {
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStateFlags _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	_tmp0_ = (*self).cr;
	_tmp1_ = _cairo_reference0 (_tmp0_);
	_cairo_destroy0 ((*dest).cr);
	(*dest).cr = _tmp1_;
	_tmp2_ = (*self).window;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).window);
	(*dest).window = _tmp3_;
	_tmp4_ = (*self).style;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).style);
	(*dest).style = _tmp5_;
	_tmp6_ = (*self).state;
	(*dest).state = _tmp6_;
	_tmp7_ = (*self).width;
	(*dest).width = _tmp7_;
	_tmp8_ = (*self).height;
	(*dest).height = _tmp8_;
}


void games_game_thumbnail_drawing_context_destroy (GamesGameThumbnailDrawingContext* self) {
	_cairo_destroy0 ((*self).cr);
	_g_object_unref0 ((*self).window);
	_g_object_unref0 ((*self).style);
}


GamesGameThumbnailDrawingContext* games_game_thumbnail_drawing_context_dup (const GamesGameThumbnailDrawingContext* self) {
	GamesGameThumbnailDrawingContext* dup;
	dup = g_new0 (GamesGameThumbnailDrawingContext, 1);
	games_game_thumbnail_drawing_context_copy (self, dup);
	return dup;
}


void games_game_thumbnail_drawing_context_free (GamesGameThumbnailDrawingContext* self) {
	games_game_thumbnail_drawing_context_destroy (self);
	g_free (self);
}


GType games_game_thumbnail_drawing_context_get_type (void) {
	static volatile gsize games_game_thumbnail_drawing_context_type_id__volatile = 0;
	if (g_once_init_enter (&games_game_thumbnail_drawing_context_type_id__volatile)) {
		GType games_game_thumbnail_drawing_context_type_id;
		games_game_thumbnail_drawing_context_type_id = g_boxed_type_register_static ("GamesGameThumbnailDrawingContext", (GBoxedCopyFunc) games_game_thumbnail_drawing_context_dup, (GBoxedFreeFunc) games_game_thumbnail_drawing_context_free);
		g_once_init_leave (&games_game_thumbnail_drawing_context_type_id__volatile, games_game_thumbnail_drawing_context_type_id);
	}
	return games_game_thumbnail_drawing_context_type_id__volatile;
}


static void games_game_thumbnail_class_init (GamesGameThumbnailClass * klass) {
	games_game_thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesGameThumbnailPrivate));
	((GtkWidgetClass *) klass)->draw = games_game_thumbnail_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_game_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_game_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_game_thumbnail_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_THUMBNAIL_CENTER_EMBLEM_SIZE, g_param_spec_int ("center-emblem-size", "center-emblem-size", "center-emblem-size", G_MININT, G_MAXINT, 32, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_THUMBNAIL_SECONDARY_EMBLEM_SIZE, g_param_spec_int ("secondary-emblem-size", "secondary-emblem-size", "secondary-emblem-size", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_THUMBNAIL_ICON, g_param_spec_object ("icon", "icon", "icon", GAMES_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_THUMBNAIL_COVER, g_param_spec_object ("cover", "cover", "cover", GAMES_TYPE_COVER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "gamesgamethumbnail");
}


static void games_game_thumbnail_instance_init (GamesGameThumbnail * self) {
	self->priv = GAMES_GAME_THUMBNAIL_GET_PRIVATE (self);
	self->priv->_center_emblem_size = 32;
	self->priv->_secondary_emblem_size = 8;
	games_game_thumbnail_set_icon (self, NULL);
	games_game_thumbnail_set_cover (self, NULL);
}


static void games_game_thumbnail_finalize (GObject * obj) {
	GamesGameThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_cover);
	_g_object_unref0 (self->priv->cover_cache);
	G_OBJECT_CLASS (games_game_thumbnail_parent_class)->finalize (obj);
}


GType games_game_thumbnail_get_type (void) {
	static volatile gsize games_game_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&games_game_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesGameThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_game_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGameThumbnail), 0, (GInstanceInitFunc) games_game_thumbnail_instance_init, NULL };
		GType games_game_thumbnail_type_id;
		games_game_thumbnail_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GamesGameThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&games_game_thumbnail_type_id__volatile, games_game_thumbnail_type_id);
	}
	return games_game_thumbnail_type_id__volatile;
}


static void _vala_games_game_thumbnail_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesGameThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail);
	switch (property_id) {
		case GAMES_GAME_THUMBNAIL_CENTER_EMBLEM_SIZE:
		g_value_set_int (value, games_game_thumbnail_get_center_emblem_size (self));
		break;
		case GAMES_GAME_THUMBNAIL_SECONDARY_EMBLEM_SIZE:
		g_value_set_int (value, games_game_thumbnail_get_secondary_emblem_size (self));
		break;
		case GAMES_GAME_THUMBNAIL_ICON:
		g_value_set_object (value, games_game_thumbnail_get_icon (self));
		break;
		case GAMES_GAME_THUMBNAIL_COVER:
		g_value_set_object (value, games_game_thumbnail_get_cover (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_games_game_thumbnail_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GamesGameThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_THUMBNAIL, GamesGameThumbnail);
	switch (property_id) {
		case GAMES_GAME_THUMBNAIL_CENTER_EMBLEM_SIZE:
		games_game_thumbnail_set_center_emblem_size (self, g_value_get_int (value));
		break;
		case GAMES_GAME_THUMBNAIL_SECONDARY_EMBLEM_SIZE:
		games_game_thumbnail_set_secondary_emblem_size (self, g_value_get_int (value));
		break;
		case GAMES_GAME_THUMBNAIL_ICON:
		games_game_thumbnail_set_icon (self, g_value_get_object (value));
		break;
		case GAMES_GAME_THUMBNAIL_COVER:
		games_game_thumbnail_set_cover (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



