/* gamepad-mapping.c generated by valac 0.35.5, the Vala compiler
 * generated from gamepad-mapping.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_GAMEPAD_MAPPING (games_gamepad_mapping_get_type ())
#define GAMES_GAMEPAD_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_MAPPING, GamesGamepadMapping))
#define GAMES_GAMEPAD_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_MAPPING, GamesGamepadMappingClass))
#define GAMES_IS_GAMEPAD_MAPPING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_MAPPING))
#define GAMES_IS_GAMEPAD_MAPPING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_MAPPING))
#define GAMES_GAMEPAD_MAPPING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_MAPPING, GamesGamepadMappingClass))

typedef struct _GamesGamepadMapping GamesGamepadMapping;
typedef struct _GamesGamepadMappingClass GamesGamepadMappingClass;
typedef struct _GamesGamepadMappingPrivate GamesGamepadMappingPrivate;

#define GAMES_TYPE_GAMEPAD_INPUT_TYPE (games_gamepad_input_type_get_type ())

#define GAMES_TYPE_GAMEPAD_DPAD (games_gamepad_dpad_get_type ())
#define GAMES_GAMEPAD_DPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_DPAD, GamesGamepadDPad))
#define GAMES_GAMEPAD_DPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_DPAD, GamesGamepadDPadClass))
#define GAMES_IS_GAMEPAD_DPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_DPAD))
#define GAMES_IS_GAMEPAD_DPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_DPAD))
#define GAMES_GAMEPAD_DPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_DPAD, GamesGamepadDPadClass))

typedef struct _GamesGamepadDPad GamesGamepadDPad;
typedef struct _GamesGamepadDPadClass GamesGamepadDPadClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_STANDARD_GAMEPAD_BUTTON (games_standard_gamepad_button_get_type ())

#define GAMES_TYPE_STANDARD_GAMEPAD_AXIS (games_standard_gamepad_axis_get_type ())

#define GAMES_TYPE_GAMEPAD_MAPPED_EVENT (games_gamepad_mapped_event_get_type ())
typedef struct _GamesGamepadMappedEvent GamesGamepadMappedEvent;
typedef struct _GamesGamepadDPadPrivate GamesGamepadDPadPrivate;

struct _GamesGamepadMapping {
	GObject parent_instance;
	GamesGamepadMappingPrivate * priv;
};

struct _GamesGamepadMappingClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_GAMEPAD_INPUT_TYPE_AXIS,
	GAMES_GAMEPAD_INPUT_TYPE_BUTTON,
	GAMES_GAMEPAD_INPUT_TYPE_INVALID
} GamesGamepadInputType;

struct _GamesGamepadMappingPrivate {
	GamesGamepadInputType* buttons_type;
	gint buttons_type_length1;
	gint _buttons_type_size_;
	gint* buttons_value;
	gint buttons_value_length1;
	gint _buttons_value_size_;
	GamesGamepadInputType* axes_type;
	gint axes_type_length1;
	gint _axes_type_size_;
	gint* axes_value;
	gint axes_value_length1;
	gint _axes_value_size_;
	GamesGamepadDPad** dpads;
	gint dpads_length1;
	gint _dpads_size_;
};

typedef enum  {
	GAMES_GAMEPAD_MAPPING_ERROR_NOT_A_MAPPING
} GamesGamepadMappingError;
#define GAMES_GAMEPAD_MAPPING_ERROR games_gamepad_mapping_error_quark ()
typedef enum  {
	GAMES_STANDARD_GAMEPAD_BUTTON_UNKNOWN,
	GAMES_STANDARD_GAMEPAD_BUTTON_A,
	GAMES_STANDARD_GAMEPAD_BUTTON_B,
	GAMES_STANDARD_GAMEPAD_BUTTON_X,
	GAMES_STANDARD_GAMEPAD_BUTTON_Y,
	GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_L,
	GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_R,
	GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_L,
	GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_R,
	GAMES_STANDARD_GAMEPAD_BUTTON_SELECT,
	GAMES_STANDARD_GAMEPAD_BUTTON_START,
	GAMES_STANDARD_GAMEPAD_BUTTON_STICK_L,
	GAMES_STANDARD_GAMEPAD_BUTTON_STICK_R,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_UP,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_DOWN,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_LEFT,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_RIGHT,
	GAMES_STANDARD_GAMEPAD_BUTTON_HOME
} GamesStandardGamepadButton;

typedef enum  {
	GAMES_STANDARD_GAMEPAD_AXIS_UNKNOWN,
	GAMES_STANDARD_GAMEPAD_AXIS_LEFT_X,
	GAMES_STANDARD_GAMEPAD_AXIS_LEFT_Y,
	GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_X,
	GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_Y
} GamesStandardGamepadAxis;

struct _GamesGamepadMappedEvent {
	GamesGamepadInputType type;
	GamesStandardGamepadAxis axis;
	GamesStandardGamepadButton button;
};

struct _GamesGamepadDPad {
	GObject parent_instance;
	GamesGamepadDPadPrivate * priv;
	GamesGamepadInputType types[4];
	gint values[4];
	gint axis_values[2];
};

struct _GamesGamepadDPadClass {
	GObjectClass parent_class;
};


static gpointer games_gamepad_mapping_parent_class = NULL;

GType games_gamepad_mapping_get_type (void) G_GNUC_CONST;
GType games_gamepad_input_type_get_type (void) G_GNUC_CONST;
GType games_gamepad_dpad_get_type (void) G_GNUC_CONST;
#define GAMES_GAMEPAD_MAPPING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_GAMEPAD_MAPPING, GamesGamepadMappingPrivate))
enum  {
	GAMES_GAMEPAD_MAPPING_DUMMY_PROPERTY
};
GQuark games_gamepad_mapping_error_quark (void);
GamesGamepadMapping* games_gamepad_mapping_new_from_sdl_string (const gchar* mapping_string, GError** error);
GamesGamepadMapping* games_gamepad_mapping_construct_from_sdl_string (GType object_type, const gchar* mapping_string, GError** error);
GamesGamepadInputType games_gamepad_mapping_parse_input_type (const gchar* mapping_string);
GType games_standard_gamepad_button_get_type (void) G_GNUC_CONST;
GamesStandardGamepadButton games_gamepad_mapping_parse_button (const gchar* mapping_string);
GType games_standard_gamepad_axis_get_type (void) G_GNUC_CONST;
GamesStandardGamepadAxis games_gamepad_mapping_parse_axis (const gchar* mapping_string);
static void games_gamepad_mapping_parse_dpad_value (GamesGamepadMapping* self, const gchar* mapping_value, GamesGamepadInputType type, gint parsed_key);
static void games_gamepad_mapping_parse_button_value (GamesGamepadMapping* self, const gchar* mapping_value, GamesGamepadInputType type, gint parsed_key);
static void games_gamepad_mapping_parse_axis_value (GamesGamepadMapping* self, const gchar* mapping_value, GamesGamepadInputType type, gint parsed_key);
GType games_gamepad_mapped_event_get_type (void) G_GNUC_CONST;
GamesGamepadMappedEvent* games_gamepad_mapped_event_dup (const GamesGamepadMappedEvent* self);
void games_gamepad_mapped_event_free (GamesGamepadMappedEvent* self);
void games_gamepad_mapping_get_dpad_mapping (GamesGamepadMapping* self, gint dpad_index, gint dpad_axis, gint dpad_value, GamesGamepadMappedEvent* result);
void games_gamepad_mapping_get_axis_mapping (GamesGamepadMapping* self, gint axis_number, GamesGamepadMappedEvent* result);
void games_gamepad_mapping_get_button_mapping (GamesGamepadMapping* self, gint button_number, GamesGamepadMappedEvent* result);
GamesGamepadDPad* games_gamepad_dpad_new (void);
GamesGamepadDPad* games_gamepad_dpad_construct (GType object_type);
static void _vala_array_add1 (GamesGamepadDPad** * array, int* length, int* size, GamesGamepadDPad* value);
static void _vala_array_add2 (GamesGamepadInputType* * array, int* length, int* size, GamesGamepadInputType value);
static void _vala_array_add3 (GamesGamepadInputType* * array, int* length, int* size, GamesGamepadInputType value);
GamesGamepadMapping* games_gamepad_mapping_new (void);
GamesGamepadMapping* games_gamepad_mapping_construct (GType object_type);
static void games_gamepad_mapping_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


GamesGamepadMapping* games_gamepad_mapping_construct_from_sdl_string (GType object_type, const gchar* mapping_string, GError** error) {
	GamesGamepadMapping * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar** mappings;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint mappings_length1;
	gint _mappings_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	self = (GamesGamepadMapping*) g_object_new (object_type, NULL);
	_tmp0_ = mapping_string;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GAMES_GAMEPAD_MAPPING_ERROR, GAMES_GAMEPAD_MAPPING_ERROR_NOT_A_MAPPING, _ ("The mapping string can’t be null."));
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == GAMES_GAMEPAD_MAPPING_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = mapping_string;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (GAMES_GAMEPAD_MAPPING_ERROR, GAMES_GAMEPAD_MAPPING_ERROR_NOT_A_MAPPING, _ ("The mapping string can’t be empty."));
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == GAMES_GAMEPAD_MAPPING_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = mapping_string;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
	mappings = _tmp6_;
	mappings_length1 = _vala_array_length (_tmp5_);
	_mappings_size_ = mappings_length1;
	_tmp7_ = mappings;
	_tmp7__length1 = mappings_length1;
	{
		gchar** mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = _tmp7_;
		mapping_collection_length1 = _tmp7__length1;
		for (mapping_it = 0; mapping_it < _tmp7__length1; mapping_it = mapping_it + 1) {
			gchar* _tmp8_;
			gchar* mapping = NULL;
			_tmp8_ = g_strdup (mapping_collection[mapping_it]);
			mapping = _tmp8_;
			{
				gchar** splitted_mapping;
				const gchar* _tmp9_;
				gchar** _tmp10_;
				gchar** _tmp11_;
				gint splitted_mapping_length1;
				gint _splitted_mapping_size_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				gchar* mapping_key;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* mapping_value;
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gchar** _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				GamesGamepadInputType type;
				const gchar* _tmp27_;
				GamesGamepadInputType _tmp28_;
				GamesGamepadInputType _tmp29_;
				gint parsed_key = 0;
				GamesGamepadInputType _tmp32_;
				const gchar* _tmp37_;
				gchar _tmp38_;
				_tmp9_ = mapping;
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ":", 0);
				splitted_mapping = _tmp11_;
				splitted_mapping_length1 = _vala_array_length (_tmp10_);
				_splitted_mapping_size_ = splitted_mapping_length1;
				_tmp12_ = splitted_mapping;
				_tmp12__length1 = splitted_mapping_length1;
				if (_tmp12__length1 != 2) {
					splitted_mapping = (_vala_array_free (splitted_mapping, splitted_mapping_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (mapping);
					continue;
				}
				_tmp13_ = mapping;
				_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ":", 0);
				_tmp16_ = _tmp15_;
				_tmp16__length1 = _vala_array_length (_tmp14_);
				_tmp17_ = _tmp16_[0];
				_tmp18_ = g_strdup (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
				mapping_key = _tmp19_;
				_tmp20_ = mapping;
				_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, ":", 0);
				_tmp23_ = _tmp22_;
				_tmp23__length1 = _vala_array_length (_tmp21_);
				_tmp24_ = _tmp23_[1];
				_tmp25_ = g_strdup (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
				mapping_value = _tmp26_;
				_tmp27_ = mapping_key;
				_tmp28_ = games_gamepad_mapping_parse_input_type (_tmp27_);
				type = _tmp28_;
				_tmp29_ = type;
				if (_tmp29_ == GAMES_GAMEPAD_INPUT_TYPE_INVALID) {
					const gchar* _tmp30_;
					_tmp30_ = mapping_key;
					if (g_strcmp0 (_tmp30_, "platform") != 0) {
						const gchar* _tmp31_;
						_tmp31_ = mapping_key;
						g_debug ("gamepad-mapping.vala:28: Invalid token : %s", _tmp31_);
					}
					_g_free0 (mapping_value);
					_g_free0 (mapping_key);
					splitted_mapping = (_vala_array_free (splitted_mapping, splitted_mapping_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (mapping);
					continue;
				}
				_tmp32_ = type;
				switch (_tmp32_) {
					case GAMES_GAMEPAD_INPUT_TYPE_BUTTON:
					{
						const gchar* _tmp33_;
						GamesStandardGamepadButton _tmp34_;
						_tmp33_ = mapping_key;
						_tmp34_ = games_gamepad_mapping_parse_button (_tmp33_);
						parsed_key = (gint) _tmp34_;
						break;
					}
					case GAMES_GAMEPAD_INPUT_TYPE_AXIS:
					{
						const gchar* _tmp35_;
						GamesStandardGamepadAxis _tmp36_;
						_tmp35_ = mapping_key;
						_tmp36_ = games_gamepad_mapping_parse_axis (_tmp35_);
						parsed_key = (gint) _tmp36_;
						break;
					}
					default:
					{
						continue;
					}
				}
				_tmp37_ = mapping_value;
				_tmp38_ = string_get (_tmp37_, (glong) 0);
				switch (_tmp38_) {
					case 'h':
					{
						const gchar* _tmp39_;
						GamesGamepadInputType _tmp40_;
						gint _tmp41_;
						_tmp39_ = mapping_value;
						_tmp40_ = type;
						_tmp41_ = parsed_key;
						games_gamepad_mapping_parse_dpad_value (self, _tmp39_, _tmp40_, _tmp41_);
						break;
					}
					case 'b':
					{
						const gchar* _tmp42_;
						GamesGamepadInputType _tmp43_;
						gint _tmp44_;
						_tmp42_ = mapping_value;
						_tmp43_ = type;
						_tmp44_ = parsed_key;
						games_gamepad_mapping_parse_button_value (self, _tmp42_, _tmp43_, _tmp44_);
						break;
					}
					case 'a':
					{
						const gchar* _tmp45_;
						GamesGamepadInputType _tmp46_;
						gint _tmp47_;
						_tmp45_ = mapping_value;
						_tmp46_ = type;
						_tmp47_ = parsed_key;
						games_gamepad_mapping_parse_axis_value (self, _tmp45_, _tmp46_, _tmp47_);
						break;
					}
					default:
					break;
				}
				_g_free0 (mapping_value);
				_g_free0 (mapping_key);
				splitted_mapping = (_vala_array_free (splitted_mapping, splitted_mapping_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (mapping);
			}
		}
	}
	mappings = (_vala_array_free (mappings, mappings_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


GamesGamepadMapping* games_gamepad_mapping_new_from_sdl_string (const gchar* mapping_string, GError** error) {
	return games_gamepad_mapping_construct_from_sdl_string (GAMES_TYPE_GAMEPAD_MAPPING, mapping_string, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void games_gamepad_mapping_get_dpad_mapping (GamesGamepadMapping* self, gint dpad_index, gint dpad_axis, gint dpad_value, GamesGamepadMappedEvent* result) {
	GamesGamepadMappedEvent event;
	GamesGamepadDPad* dpad;
	GamesGamepadDPad** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	GamesGamepadDPad* _tmp2_;
	GamesGamepadDPad* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint dpad_changed_value;
	gint dpad_position;
	gint _tmp10_;
	gint _tmp11_;
	GamesGamepadDPad* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GamesGamepadDPad* _tmp16_;
	gint _tmp17_;
	GamesGamepadInputType _tmp18_;
	GamesGamepadMappedEvent _tmp19_;
	GamesGamepadInputType _tmp20_;
	g_return_if_fail (self != NULL);
	memset (&event, 0, sizeof (GamesGamepadMappedEvent));
	_tmp0_ = self->priv->dpads;
	_tmp0__length1 = self->priv->dpads_length1;
	_tmp1_ = dpad_index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	dpad = _tmp3_;
	_tmp5_ = dpad_value;
	if (_tmp5_ == 0) {
		GamesGamepadDPad* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = dpad;
		_tmp7_ = dpad_axis;
		_tmp8_ = _tmp6_->axis_values[_tmp7_];
		_tmp4_ = _tmp8_;
	} else {
		gint _tmp9_;
		_tmp9_ = dpad_value;
		_tmp4_ = _tmp9_;
	}
	dpad_changed_value = _tmp4_;
	_tmp10_ = dpad_changed_value;
	_tmp11_ = dpad_axis;
	dpad_position = ((_tmp10_ + _tmp11_) + 4) % 4;
	_tmp12_ = dpad;
	_tmp13_ = dpad_axis;
	_tmp14_ = dpad_value;
	_tmp12_->axis_values[_tmp13_] = _tmp14_;
	_tmp15_ = _tmp12_->axis_values[_tmp13_];
	_tmp16_ = dpad;
	_tmp17_ = dpad_position;
	_tmp18_ = _tmp16_->types[_tmp17_];
	event.type = _tmp18_;
	_tmp19_ = event;
	_tmp20_ = _tmp19_.type;
	switch (_tmp20_) {
		case GAMES_GAMEPAD_INPUT_TYPE_AXIS:
		{
			GamesGamepadDPad* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp21_ = dpad;
			_tmp22_ = dpad_position;
			_tmp23_ = _tmp21_->values[_tmp22_];
			event.axis = (GamesStandardGamepadAxis) _tmp23_;
			break;
		}
		case GAMES_GAMEPAD_INPUT_TYPE_BUTTON:
		{
			GamesGamepadDPad* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp24_ = dpad;
			_tmp25_ = dpad_position;
			_tmp26_ = _tmp24_->values[_tmp25_];
			event.button = (GamesStandardGamepadButton) _tmp26_;
			break;
		}
		default:
		break;
	}
	*result = event;
	_g_object_unref0 (dpad);
	return;
}


void games_gamepad_mapping_get_axis_mapping (GamesGamepadMapping* self, gint axis_number, GamesGamepadMappedEvent* result) {
	GamesGamepadMappedEvent event;
	GamesGamepadInputType _tmp0_ = 0;
	gint _tmp1_;
	GamesGamepadInputType* _tmp2_;
	gint _tmp2__length1;
	GamesGamepadMappedEvent _tmp6_;
	GamesGamepadInputType _tmp7_;
	g_return_if_fail (self != NULL);
	memset (&event, 0, sizeof (GamesGamepadMappedEvent));
	_tmp1_ = axis_number;
	_tmp2_ = self->priv->axes_type;
	_tmp2__length1 = self->priv->axes_type_length1;
	if (_tmp1_ < _tmp2__length1) {
		GamesGamepadInputType* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		GamesGamepadInputType _tmp5_;
		_tmp3_ = self->priv->axes_type;
		_tmp3__length1 = self->priv->axes_type_length1;
		_tmp4_ = axis_number;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = GAMES_GAMEPAD_INPUT_TYPE_INVALID;
	}
	event.type = _tmp0_;
	_tmp6_ = event;
	_tmp7_ = _tmp6_.type;
	switch (_tmp7_) {
		case GAMES_GAMEPAD_INPUT_TYPE_AXIS:
		{
			gint* _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			gint _tmp10_;
			_tmp8_ = self->priv->axes_value;
			_tmp8__length1 = self->priv->axes_value_length1;
			_tmp9_ = axis_number;
			_tmp10_ = _tmp8_[_tmp9_];
			event.axis = (GamesStandardGamepadAxis) _tmp10_;
			break;
		}
		case GAMES_GAMEPAD_INPUT_TYPE_BUTTON:
		{
			gint* _tmp11_;
			gint _tmp11__length1;
			gint _tmp12_;
			gint _tmp13_;
			_tmp11_ = self->priv->axes_value;
			_tmp11__length1 = self->priv->axes_value_length1;
			_tmp12_ = axis_number;
			_tmp13_ = _tmp11_[_tmp12_];
			event.button = (GamesStandardGamepadButton) _tmp13_;
			break;
		}
		default:
		break;
	}
	*result = event;
	return;
}


void games_gamepad_mapping_get_button_mapping (GamesGamepadMapping* self, gint button_number, GamesGamepadMappedEvent* result) {
	GamesGamepadMappedEvent event;
	GamesGamepadInputType _tmp0_ = 0;
	gint _tmp1_;
	GamesGamepadInputType* _tmp2_;
	gint _tmp2__length1;
	GamesGamepadMappedEvent _tmp6_;
	GamesGamepadInputType _tmp7_;
	g_return_if_fail (self != NULL);
	memset (&event, 0, sizeof (GamesGamepadMappedEvent));
	_tmp1_ = button_number;
	_tmp2_ = self->priv->buttons_type;
	_tmp2__length1 = self->priv->buttons_type_length1;
	if (_tmp1_ < _tmp2__length1) {
		GamesGamepadInputType* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		GamesGamepadInputType _tmp5_;
		_tmp3_ = self->priv->buttons_type;
		_tmp3__length1 = self->priv->buttons_type_length1;
		_tmp4_ = button_number;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = GAMES_GAMEPAD_INPUT_TYPE_INVALID;
	}
	event.type = _tmp0_;
	_tmp6_ = event;
	_tmp7_ = _tmp6_.type;
	switch (_tmp7_) {
		case GAMES_GAMEPAD_INPUT_TYPE_AXIS:
		{
			gint* _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			gint _tmp10_;
			_tmp8_ = self->priv->buttons_value;
			_tmp8__length1 = self->priv->buttons_value_length1;
			_tmp9_ = button_number;
			_tmp10_ = _tmp8_[_tmp9_];
			event.axis = (GamesStandardGamepadAxis) _tmp10_;
			break;
		}
		case GAMES_GAMEPAD_INPUT_TYPE_BUTTON:
		{
			gint* _tmp11_;
			gint _tmp11__length1;
			gint _tmp12_;
			gint _tmp13_;
			_tmp11_ = self->priv->buttons_value;
			_tmp11__length1 = self->priv->buttons_value_length1;
			_tmp12_ = button_number;
			_tmp13_ = _tmp11_[_tmp12_];
			event.button = (GamesStandardGamepadButton) _tmp13_;
			break;
		}
		default:
		break;
	}
	*result = event;
	return;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void _vala_array_add1 (GamesGamepadDPad** * array, int* length, int* size, GamesGamepadDPad* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGamepadDPad*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void games_gamepad_mapping_parse_dpad_value (GamesGamepadMapping* self, const gchar* mapping_value, GamesGamepadInputType type, gint parsed_key) {
	gchar** dpad_parse_array;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint dpad_parse_array_length1;
	gint _dpad_parse_array_size_;
	gint dpad_index;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint dpad_position_2pow;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint dpad_position;
	GamesGamepadDPad** _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_;
	GamesGamepadDPad* _tmp24_;
	gint _tmp25_;
	GamesGamepadInputType _tmp26_;
	GamesGamepadInputType _tmp27_;
	GamesGamepadDPad** _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	GamesGamepadDPad* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mapping_value != NULL);
	_tmp0_ = mapping_value;
	_tmp1_ = mapping_value;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (_tmp0_, (glong) 1, (glong) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ".", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_g_free0 (_tmp5_);
	dpad_parse_array = _tmp8_;
	dpad_parse_array_length1 = _tmp8__length1;
	_dpad_parse_array_size_ = dpad_parse_array_length1;
	_tmp9_ = dpad_parse_array;
	_tmp9__length1 = dpad_parse_array_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = atoi (_tmp10_);
	dpad_index = _tmp11_;
	_tmp12_ = dpad_parse_array;
	_tmp12__length1 = dpad_parse_array_length1;
	_tmp13_ = _tmp12_[1];
	_tmp14_ = atoi (_tmp13_);
	dpad_position_2pow = _tmp14_;
	dpad_position = 0;
	while (TRUE) {
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp15_ = dpad_position_2pow;
		if (!(_tmp15_ > 1)) {
			break;
		}
		_tmp16_ = dpad_position_2pow;
		dpad_position_2pow = _tmp16_ >> 1;
		_tmp17_ = dpad_position;
		dpad_position = _tmp17_ + 1;
	}
	while (TRUE) {
		GamesGamepadDPad** _tmp18_;
		gint _tmp18__length1;
		gint _tmp19_;
		GamesGamepadDPad** _tmp20_;
		gint _tmp20__length1;
		GamesGamepadDPad* _tmp21_;
		_tmp18_ = self->priv->dpads;
		_tmp18__length1 = self->priv->dpads_length1;
		_tmp19_ = dpad_index;
		if (!(_tmp18__length1 <= _tmp19_)) {
			break;
		}
		_tmp20_ = self->priv->dpads;
		_tmp20__length1 = self->priv->dpads_length1;
		_tmp21_ = games_gamepad_dpad_new ();
		_vala_array_add1 (&self->priv->dpads, &self->priv->dpads_length1, &self->priv->_dpads_size_, _tmp21_);
	}
	_tmp22_ = self->priv->dpads;
	_tmp22__length1 = self->priv->dpads_length1;
	_tmp23_ = dpad_index;
	_tmp24_ = _tmp22_[_tmp23_];
	_tmp25_ = dpad_position;
	_tmp26_ = type;
	_tmp24_->types[_tmp25_] = _tmp26_;
	_tmp27_ = _tmp24_->types[_tmp25_];
	_tmp28_ = self->priv->dpads;
	_tmp28__length1 = self->priv->dpads_length1;
	_tmp29_ = dpad_index;
	_tmp30_ = _tmp28_[_tmp29_];
	_tmp31_ = dpad_position;
	_tmp32_ = parsed_key;
	_tmp30_->values[_tmp31_] = _tmp32_;
	_tmp33_ = _tmp30_->values[_tmp31_];
	dpad_parse_array = (_vala_array_free (dpad_parse_array, dpad_parse_array_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_add2 (GamesGamepadInputType* * array, int* length, int* size, GamesGamepadInputType value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGamepadInputType, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void games_gamepad_mapping_parse_button_value (GamesGamepadMapping* self, const gchar* mapping_value, GamesGamepadInputType type, gint parsed_key) {
	gint button;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	GamesGamepadInputType* _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	GamesGamepadInputType _tmp17_;
	GamesGamepadInputType _tmp18_;
	gint* _tmp19_;
	gint _tmp19__length1;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mapping_value != NULL);
	_tmp0_ = mapping_value;
	_tmp1_ = mapping_value;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (_tmp0_, (glong) 1, (glong) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = atoi (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	button = _tmp7_;
	while (TRUE) {
		GamesGamepadInputType* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		GamesGamepadInputType* _tmp10_;
		gint _tmp10__length1;
		_tmp8_ = self->priv->buttons_type;
		_tmp8__length1 = self->priv->buttons_type_length1;
		_tmp9_ = button;
		if (!(_tmp8__length1 <= _tmp9_)) {
			break;
		}
		_tmp10_ = self->priv->buttons_type;
		_tmp10__length1 = self->priv->buttons_type_length1;
		_vala_array_add2 (&self->priv->buttons_type, &self->priv->buttons_type_length1, &self->priv->_buttons_type_size_, GAMES_GAMEPAD_INPUT_TYPE_INVALID);
	}
	_tmp11_ = self->priv->buttons_value;
	_tmp11__length1 = self->priv->buttons_value_length1;
	_tmp12_ = button;
	if (_tmp11__length1 <= _tmp12_) {
		gint _tmp13_;
		gint _tmp14_;
		_tmp13_ = button;
		_tmp14_ = _tmp13_ + 1;
		self->priv->buttons_value = g_renew (gint, self->priv->buttons_value, _tmp13_ + 1);
		(_tmp14_ > self->priv->buttons_value_length1) ? memset (self->priv->buttons_value + self->priv->buttons_value_length1, 0, sizeof (gint) * (_tmp14_ - self->priv->buttons_value_length1)) : NULL;
		self->priv->buttons_value_length1 = _tmp14_;
		self->priv->_buttons_value_size_ = _tmp14_;
	}
	_tmp15_ = self->priv->buttons_type;
	_tmp15__length1 = self->priv->buttons_type_length1;
	_tmp16_ = button;
	_tmp17_ = type;
	_tmp15_[_tmp16_] = _tmp17_;
	_tmp18_ = _tmp15_[_tmp16_];
	_tmp19_ = self->priv->buttons_value;
	_tmp19__length1 = self->priv->buttons_value_length1;
	_tmp20_ = button;
	_tmp21_ = parsed_key;
	_tmp19_[_tmp20_] = _tmp21_;
	_tmp22_ = _tmp19_[_tmp20_];
}


static void _vala_array_add3 (GamesGamepadInputType* * array, int* length, int* size, GamesGamepadInputType value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGamepadInputType, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void games_gamepad_mapping_parse_axis_value (GamesGamepadMapping* self, const gchar* mapping_value, GamesGamepadInputType type, gint parsed_key) {
	gint axis;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	GamesGamepadInputType* _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	GamesGamepadInputType _tmp17_;
	GamesGamepadInputType _tmp18_;
	gint* _tmp19_;
	gint _tmp19__length1;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mapping_value != NULL);
	_tmp0_ = mapping_value;
	_tmp1_ = mapping_value;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (_tmp0_, (glong) 1, (glong) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = atoi (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	axis = _tmp7_;
	while (TRUE) {
		GamesGamepadInputType* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		GamesGamepadInputType* _tmp10_;
		gint _tmp10__length1;
		_tmp8_ = self->priv->axes_type;
		_tmp8__length1 = self->priv->axes_type_length1;
		_tmp9_ = axis;
		if (!(_tmp8__length1 <= _tmp9_)) {
			break;
		}
		_tmp10_ = self->priv->axes_type;
		_tmp10__length1 = self->priv->axes_type_length1;
		_vala_array_add3 (&self->priv->axes_type, &self->priv->axes_type_length1, &self->priv->_axes_type_size_, GAMES_GAMEPAD_INPUT_TYPE_INVALID);
	}
	_tmp11_ = self->priv->axes_value;
	_tmp11__length1 = self->priv->axes_value_length1;
	_tmp12_ = axis;
	if (_tmp11__length1 <= _tmp12_) {
		gint _tmp13_;
		gint _tmp14_;
		_tmp13_ = axis;
		_tmp14_ = _tmp13_ + 1;
		self->priv->axes_value = g_renew (gint, self->priv->axes_value, _tmp13_ + 1);
		(_tmp14_ > self->priv->axes_value_length1) ? memset (self->priv->axes_value + self->priv->axes_value_length1, 0, sizeof (gint) * (_tmp14_ - self->priv->axes_value_length1)) : NULL;
		self->priv->axes_value_length1 = _tmp14_;
		self->priv->_axes_value_size_ = _tmp14_;
	}
	_tmp15_ = self->priv->axes_type;
	_tmp15__length1 = self->priv->axes_type_length1;
	_tmp16_ = axis;
	_tmp17_ = type;
	_tmp15_[_tmp16_] = _tmp17_;
	_tmp18_ = _tmp15_[_tmp16_];
	_tmp19_ = self->priv->axes_value;
	_tmp19__length1 = self->priv->axes_value_length1;
	_tmp20_ = axis;
	_tmp21_ = parsed_key;
	_tmp19_[_tmp20_] = _tmp21_;
	_tmp22_ = _tmp19_[_tmp20_];
}


GamesGamepadInputType games_gamepad_mapping_parse_input_type (const gchar* mapping_string) {
	GamesGamepadInputType result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	static GQuark _tmp2_label17 = 0;
	static GQuark _tmp2_label18 = 0;
	static GQuark _tmp2_label19 = 0;
	static GQuark _tmp2_label20 = 0;
	g_return_val_if_fail (mapping_string != NULL, 0);
	_tmp0_ = mapping_string;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("leftx")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("lefty"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("rightx"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("righty"))))) {
		switch (0) {
			default:
			{
				result = GAMES_GAMEPAD_INPUT_TYPE_AXIS;
				return result;
			}
		}
	} else if (((((((((((((((((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("a")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("b"))))) || (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("back"))))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("dpdown"))))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dpleft"))))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("dpright"))))) || (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("dpup"))))) || (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("guide"))))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("leftshoulder"))))) || (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("leftstick"))))) || (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("lefttrigger"))))) || (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("rightshoulder"))))) || (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("rightstick"))))) || (_tmp3_ == ((0 != _tmp2_label17) ? _tmp2_label17 : (_tmp2_label17 = g_quark_from_static_string ("righttrigger"))))) || (_tmp3_ == ((0 != _tmp2_label18) ? _tmp2_label18 : (_tmp2_label18 = g_quark_from_static_string ("start"))))) || (_tmp3_ == ((0 != _tmp2_label19) ? _tmp2_label19 : (_tmp2_label19 = g_quark_from_static_string ("x"))))) || (_tmp3_ == ((0 != _tmp2_label20) ? _tmp2_label20 : (_tmp2_label20 = g_quark_from_static_string ("y"))))) {
		switch (0) {
			default:
			{
				result = GAMES_GAMEPAD_INPUT_TYPE_BUTTON;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GAMES_GAMEPAD_INPUT_TYPE_INVALID;
				return result;
			}
		}
	}
}


GamesStandardGamepadAxis games_gamepad_mapping_parse_axis (const gchar* mapping_string) {
	GamesStandardGamepadAxis result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	g_return_val_if_fail (mapping_string != NULL, 0);
	_tmp0_ = mapping_string;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("leftx")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_AXIS_LEFT_X;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("lefty")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_AXIS_LEFT_Y;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("rightx")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_X;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("righty")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_Y;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_AXIS_UNKNOWN;
				return result;
			}
		}
	}
}


GamesStandardGamepadButton games_gamepad_mapping_parse_button (const gchar* mapping_string) {
	GamesStandardGamepadButton result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	g_return_val_if_fail (mapping_string != NULL, 0);
	_tmp0_ = mapping_string;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("a")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_A;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_B;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("back")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_SELECT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("dpdown")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_DOWN;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("dpleft")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_LEFT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("dpright")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_RIGHT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("dpup")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_UP;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("guide")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_HOME;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("leftshoulder")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_L;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("leftstick")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_STICK_L;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("lefttrigger")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_L;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("rightshoulder")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_R;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("rightstick")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_STICK_R;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("righttrigger")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_R;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("start")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_START;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("x")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_X;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("y")))) {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_Y;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GAMES_STANDARD_GAMEPAD_BUTTON_UNKNOWN;
				return result;
			}
		}
	}
}


GamesGamepadMapping* games_gamepad_mapping_construct (GType object_type) {
	GamesGamepadMapping * self = NULL;
	self = (GamesGamepadMapping*) g_object_new (object_type, NULL);
	return self;
}


GamesGamepadMapping* games_gamepad_mapping_new (void) {
	return games_gamepad_mapping_construct (GAMES_TYPE_GAMEPAD_MAPPING);
}


static void games_gamepad_mapping_class_init (GamesGamepadMappingClass * klass) {
	games_gamepad_mapping_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesGamepadMappingPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_mapping_finalize;
}


static void games_gamepad_mapping_instance_init (GamesGamepadMapping * self) {
	self->priv = GAMES_GAMEPAD_MAPPING_GET_PRIVATE (self);
}


static void games_gamepad_mapping_finalize (GObject * obj) {
	GamesGamepadMapping * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_MAPPING, GamesGamepadMapping);
	self->priv->buttons_type = (g_free (self->priv->buttons_type), NULL);
	self->priv->buttons_value = (g_free (self->priv->buttons_value), NULL);
	self->priv->axes_type = (g_free (self->priv->axes_type), NULL);
	self->priv->axes_value = (g_free (self->priv->axes_value), NULL);
	self->priv->dpads = (_vala_array_free (self->priv->dpads, self->priv->dpads_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (games_gamepad_mapping_parent_class)->finalize (obj);
}


GType games_gamepad_mapping_get_type (void) {
	static volatile gsize games_gamepad_mapping_type_id__volatile = 0;
	if (g_once_init_enter (&games_gamepad_mapping_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadMappingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_mapping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadMapping), 0, (GInstanceInitFunc) games_gamepad_mapping_instance_init, NULL };
		GType games_gamepad_mapping_type_id;
		games_gamepad_mapping_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGamepadMapping", &g_define_type_info, 0);
		g_once_init_leave (&games_gamepad_mapping_type_id__volatile, games_gamepad_mapping_type_id);
	}
	return games_gamepad_mapping_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



