/* application.c generated by valac 0.35.5, the Vala compiler
 * generated from application.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-unix.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_APPLICATION (games_application_get_type ())
#define GAMES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_APPLICATION, GamesApplication))
#define GAMES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_APPLICATION, GamesApplicationClass))
#define GAMES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_APPLICATION))
#define GAMES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_APPLICATION))
#define GAMES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_APPLICATION, GamesApplicationClass))

typedef struct _GamesApplication GamesApplication;
typedef struct _GamesApplicationClass GamesApplicationClass;
typedef struct _GamesApplicationPrivate GamesApplicationPrivate;

#define GAMES_TYPE_APPLICATION_WINDOW (games_application_window_get_type ())
#define GAMES_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindow))
#define GAMES_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindowClass))
#define GAMES_IS_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_APPLICATION_WINDOW))
#define GAMES_IS_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_APPLICATION_WINDOW))
#define GAMES_APPLICATION_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindowClass))

typedef struct _GamesApplicationWindow GamesApplicationWindow;
typedef struct _GamesApplicationWindowClass GamesApplicationWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GAMES_TYPE_GAME (games_game_get_type ())
#define GAMES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME, GamesGame))
#define GAMES_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME))
#define GAMES_GAME_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_GAME, GamesGameIface))

typedef struct _GamesGame GamesGame;
typedef struct _GamesGameIface GamesGameIface;

#define GAMES_TYPE_ICON (games_icon_get_type ())
#define GAMES_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_ICON, GamesIcon))
#define GAMES_IS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_ICON))
#define GAMES_ICON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_ICON, GamesIconIface))

typedef struct _GamesIcon GamesIcon;
typedef struct _GamesIconIface GamesIconIface;

#define GAMES_TYPE_COVER (games_cover_get_type ())
#define GAMES_COVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COVER, GamesCover))
#define GAMES_IS_COVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COVER))
#define GAMES_COVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COVER, GamesCoverIface))

typedef struct _GamesCover GamesCover;
typedef struct _GamesCoverIface GamesCoverIface;

#define GAMES_TYPE_RUNNER (games_runner_get_type ())
#define GAMES_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RUNNER, GamesRunner))
#define GAMES_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RUNNER))
#define GAMES_RUNNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_RUNNER, GamesRunnerIface))

typedef struct _GamesRunner GamesRunner;
typedef struct _GamesRunnerIface GamesRunnerIface;

#define GAMES_TYPE_MEDIA_SET (games_media_set_get_type ())
#define GAMES_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSet))
#define GAMES_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))
#define GAMES_IS_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEDIA_SET))
#define GAMES_IS_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEDIA_SET))
#define GAMES_MEDIA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))

typedef struct _GamesMediaSet GamesMediaSet;
typedef struct _GamesMediaSetClass GamesMediaSetClass;

#define GAMES_TYPE_GAME_SOURCE (games_game_source_get_type ())
#define GAMES_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_SOURCE, GamesGameSource))
#define GAMES_IS_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_SOURCE))
#define GAMES_GAME_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_GAME_SOURCE, GamesGameSourceIface))

typedef struct _GamesGameSource GamesGameSource;
typedef struct _GamesGameSourceIface GamesGameSourceIface;
typedef struct _Block5Data Block5Data;

#define GAMES_TYPE_PLUGIN_REGISTER (games_plugin_register_get_type ())
#define GAMES_PLUGIN_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLUGIN_REGISTER, GamesPluginRegister))
#define GAMES_PLUGIN_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLUGIN_REGISTER, GamesPluginRegisterClass))
#define GAMES_IS_PLUGIN_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLUGIN_REGISTER))
#define GAMES_IS_PLUGIN_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLUGIN_REGISTER))
#define GAMES_PLUGIN_REGISTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLUGIN_REGISTER, GamesPluginRegisterClass))

typedef struct _GamesPluginRegister GamesPluginRegister;
typedef struct _GamesPluginRegisterClass GamesPluginRegisterClass;

#define GAMES_TYPE_PLUGIN_REGISTRAR (games_plugin_registrar_get_type ())
#define GAMES_PLUGIN_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLUGIN_REGISTRAR, GamesPluginRegistrar))
#define GAMES_PLUGIN_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLUGIN_REGISTRAR, GamesPluginRegistrarClass))
#define GAMES_IS_PLUGIN_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLUGIN_REGISTRAR))
#define GAMES_IS_PLUGIN_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLUGIN_REGISTRAR))
#define GAMES_PLUGIN_REGISTRAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLUGIN_REGISTRAR, GamesPluginRegistrarClass))

typedef struct _GamesPluginRegistrar GamesPluginRegistrar;
typedef struct _GamesPluginRegistrarClass GamesPluginRegistrarClass;

#define GAMES_TYPE_PLUGIN (games_plugin_get_type ())
#define GAMES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLUGIN, GamesPlugin))
#define GAMES_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLUGIN))
#define GAMES_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_PLUGIN, GamesPluginIface))

typedef struct _GamesPlugin GamesPlugin;
typedef struct _GamesPluginIface GamesPluginIface;
typedef struct _GamesApplicationLoadGameListData GamesApplicationLoadGameListData;

#define GAMES_TYPE_PREFERENCES_WINDOW (games_preferences_window_get_type ())
#define GAMES_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PREFERENCES_WINDOW, GamesPreferencesWindow))
#define GAMES_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PREFERENCES_WINDOW, GamesPreferencesWindowClass))
#define GAMES_IS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PREFERENCES_WINDOW))
#define GAMES_IS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PREFERENCES_WINDOW))
#define GAMES_PREFERENCES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PREFERENCES_WINDOW, GamesPreferencesWindowClass))

typedef struct _GamesPreferencesWindow GamesPreferencesWindow;
typedef struct _GamesPreferencesWindowClass GamesPreferencesWindowClass;
typedef struct _Block6Data Block6Data;

struct _GamesApplication {
	GtkApplication parent_instance;
	GamesApplicationPrivate * priv;
};

struct _GamesApplicationClass {
	GtkApplicationClass parent_class;
};

struct _GamesApplicationPrivate {
	GListStore* collection;
	GamesApplicationWindow* window;
	gboolean game_list_loaded;
};

struct _GamesIconIface {
	GTypeInterface parent_iface;
	GIcon* (*get_icon) (GamesIcon* self);
};

struct _GamesCoverIface {
	GTypeInterface parent_iface;
	GIcon* (*get_cover) (GamesCover* self);
};

struct _GamesRunnerIface {
	GTypeInterface parent_iface;
	gboolean (*check_is_valid) (GamesRunner* self, gchar* * error_message, GError** error);
	GtkWidget* (*get_display) (GamesRunner* self);
	void (*start) (GamesRunner* self, GError** error);
	void (*resume) (GamesRunner* self, GError** error);
	void (*pause) (GamesRunner* self);
	void (*stop) (GamesRunner* self);
	gboolean (*get_can_fullscreen) (GamesRunner* self);
	gboolean (*get_can_quit_safely) (GamesRunner* self);
	gboolean (*get_can_resume) (GamesRunner* self);
	GamesMediaSet* (*get_media_set) (GamesRunner* self);
};

struct _GamesGameIface {
	GTypeInterface parent_iface;
	GamesIcon* (*get_icon) (GamesGame* self);
	GamesCover* (*get_cover) (GamesGame* self);
	GamesRunner* (*get_runner) (GamesGame* self, GError** error);
	const gchar* (*get_name) (GamesGame* self);
};

typedef void (*GamesGameCallback) (GamesGame* game, void* user_data);
struct _GamesGameSourceIface {
	GTypeInterface parent_iface;
	void (*each_game) (GamesGameSource* self, GamesGameCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*each_game_finish) (GamesGameSource* self, GAsyncResult* _res_);
};

struct _Block5Data {
	int _ref_count_;
	GamesApplication* self;
	GamesGameSource** sources;
	gint sources_length1;
	gint _sources_size_;
	gpointer _async_data_;
};

typedef void (*GamesPluginRegisterPluginRegistrarFunc) (GamesPluginRegistrar* plugin_registrar, void* user_data);
struct _GamesPluginIface {
	GTypeInterface parent_iface;
	GamesGameSource* (*get_game_source) (GamesPlugin* self, GError** error);
};

typedef enum  {
	GAMES_PLUGIN_ERROR_INVALID_PLUGIN_DESCRIPTOR,
	GAMES_PLUGIN_ERROR_NOT_A_PLUGIN
} GamesPluginError;
#define GAMES_PLUGIN_ERROR games_plugin_error_quark ()
struct _GamesApplicationLoadGameListData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _task_complete_;
	GamesApplication* self;
	Block5Data* _data5_;
	GamesGameSource** _tmp0_;
	GamesPluginRegister* _register_;
	GamesPluginRegister* _tmp1_;
	GamesPluginRegister* _tmp2_;
	GamesGameSource** _tmp3_;
	gint _tmp3__length1;
	GamesGameSource** source_collection;
	gint source_collection_length1;
	gint _source_collection_size_;
	gint source_it;
	GamesGameSource* _tmp4_;
	GamesGameSource* source;
	GamesGameSource* _tmp5_;
	GamesApplicationWindow* _tmp6_;
	GamesApplicationWindow* _tmp7_;
};

struct _Block6Data {
	int _ref_count_;
	GamesApplication* self;
	GtkAboutDialog* dialog;
};


static gpointer games_application_parent_class = NULL;

GType games_application_get_type (void) G_GNUC_CONST;
GType games_application_window_get_type (void) G_GNUC_CONST;
#define GAMES_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_APPLICATION, GamesApplicationPrivate))
enum  {
	GAMES_APPLICATION_DUMMY_PROPERTY
};
GamesApplication* games_application_new (void);
GamesApplication* games_application_construct (GType object_type);
static void games_application_add_actions (GamesApplication* self);
static void games_application_preferences (GamesApplication* self);
static void _games_application_preferences_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void games_application_about (GamesApplication* self);
static void _games_application_about_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void games_application_quit_application (GamesApplication* self);
static void _games_application_quit_application_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void games_application_add_signal_handlers (GamesApplication* self);
static gboolean __lambda14_ (GamesApplication* self);
static gboolean ___lambda14__gsource_func (gpointer self);
gchar* games_application_get_data_dir (void);
gchar* games_application_get_saves_dir (void);
gchar* games_application_get_snapshots_dir (void);
gchar* games_application_get_cache_dir (void);
gchar* games_application_get_config_dir (void);
gchar* games_application_get_platforms_dir (void);
gchar* games_application_get_covers_dir (void);
void games_application_try_make_dir (const gchar* path);
gchar* games_application_get_medias_dir (void);
static void games_application_real_activate (GApplication* base);
static GtkCssProvider* games_application_load_css (const gchar* css);
GType games_icon_get_type (void) G_GNUC_CONST;
GType games_cover_get_type (void) G_GNUC_CONST;
GType games_media_set_get_type (void) G_GNUC_CONST;
GType games_runner_get_type (void) G_GNUC_CONST;
GType games_game_get_type (void) G_GNUC_CONST;
void games_application_load_game_list (GamesApplication* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void games_application_load_game_list_finish (GamesApplication* self, GAsyncResult* _res_);
GamesApplicationWindow* games_application_window_new (GListModel* collection);
GamesApplicationWindow* games_application_window_construct (GType object_type, GListModel* collection);
static void __lambda16_ (GamesApplication* self);
static void ___lambda16__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static gboolean games_application_show_loading_notification (GamesApplication* self);
static gboolean _games_application_show_loading_notification_gsource_func (gpointer self);
void games_application_window_set_loading_notification (GamesApplicationWindow* self, gboolean value);
static void games_application_load_game_list_data_free (gpointer _data);
static gboolean games_application_load_game_list_co (GamesApplicationLoadGameListData* _data_);
GType games_game_source_get_type (void) G_GNUC_CONST;
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
GType games_plugin_register_get_type (void) G_GNUC_CONST;
GamesPluginRegister* games_plugin_register_get_register (void);
GType games_plugin_registrar_get_type (void) G_GNUC_CONST;
void games_plugin_register_foreach_plugin_registrar (GamesPluginRegister* self, GamesPluginRegisterPluginRegistrarFunc func, void* func_target);
static void __lambda15_ (Block5Data* _data5_, GamesPluginRegistrar* plugin_registrar);
GType games_plugin_get_type (void) G_GNUC_CONST;
GQuark games_plugin_error_quark (void);
GamesPlugin* games_plugin_registrar_get_plugin (GamesPluginRegistrar* self, GError** error);
GamesGameSource* games_plugin_get_game_source (GamesPlugin* self, GError** error);
static void _vala_array_add11 (GamesGameSource** * array, int* length, int* size, GamesGameSource* value);
static void ___lambda15__games_plugin_register_plugin_registrar_func (GamesPluginRegistrar* plugin_registrar, gpointer self);
void games_game_source_each_game (GamesGameSource* self, GamesGameCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
void games_game_source_each_game_finish (GamesGameSource* self, GAsyncResult* _res_);
static void games_application_add_game (GamesApplication* self, GamesGame* game);
static void _games_application_add_game_games_game_callback (GamesGame* game, gpointer self);
static void games_application_load_game_list_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GamesPreferencesWindow* games_preferences_window_new (void);
GamesPreferencesWindow* games_preferences_window_construct (GType object_type);
GType games_preferences_window_get_type (void) G_GNUC_CONST;
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
#define GAMES_CREDITS_DOCUMENTERS NULL
static void __lambda13_ (Block6Data* _data6_, gint response_id);
static void ___lambda13__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gboolean games_application_window_quit_game (GamesApplicationWindow* self);
static GObject * games_application_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void games_application_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gchar* GAMES_CREDITS_AUTHORS[2];
extern const gchar* GAMES_CREDITS_ARTISTS[1];

GamesApplication* games_application_construct (GType object_type) {
	GamesApplication * self = NULL;
	self = (GamesApplication*) g_object_new (object_type, "application-id", "org.gnome.Games", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


GamesApplication* games_application_new (void) {
	return games_application_construct (GAMES_TYPE_APPLICATION);
}


static void _games_application_preferences_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	games_application_preferences ((GamesApplication*) self);
}


static void _games_application_about_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	games_application_about ((GamesApplication*) self);
}


static void _games_application_quit_application_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	games_application_quit_application ((GamesApplication*) self);
}


static void games_application_add_actions (GamesApplication* self) {
	GSimpleAction* preferences_action;
	GSimpleAction* _tmp0_;
	GSimpleAction* about_action;
	GSimpleAction* _tmp1_;
	GSimpleAction* quit_action;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_new ("preferences", NULL);
	preferences_action = _tmp0_;
	g_signal_connect_object (preferences_action, "activate", (GCallback) _games_application_preferences_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) preferences_action);
	_tmp1_ = g_simple_action_new ("about", NULL);
	about_action = _tmp1_;
	g_signal_connect_object (about_action, "activate", (GCallback) _games_application_about_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) about_action);
	_tmp2_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp2_;
	g_signal_connect_object (quit_action, "activate", (GCallback) _games_application_quit_application_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	_g_object_unref0 (quit_action);
	_g_object_unref0 (about_action);
	_g_object_unref0 (preferences_action);
}


static gboolean __lambda14_ (GamesApplication* self) {
	gboolean result = FALSE;
	games_application_quit_application (self);
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean ___lambda14__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda14_ ((GamesApplication*) self);
	return result;
}


static void games_application_add_signal_handlers (GamesApplication* self) {
	GSource* interrupt_source;
	GSource* _tmp0_;
	GMainContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_unix_signal_source_new ((gint) SIGINT);
	interrupt_source = _tmp0_;
	g_source_set_callback (interrupt_source, ___lambda14__gsource_func, g_object_ref (self), g_object_unref);
	_tmp1_ = g_main_context_default ();
	g_source_attach (interrupt_source, _tmp1_);
	_g_source_unref0 (interrupt_source);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* games_application_get_data_dir (void) {
	gchar* result = NULL;
	gchar* data_dir;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	data_dir = _tmp1_;
	_tmp2_ = string_to_string (data_dir);
	_tmp3_ = g_strconcat (_tmp2_, "/gnome-games", NULL);
	result = _tmp3_;
	_g_free0 (data_dir);
	return result;
}


gchar* games_application_get_saves_dir (void) {
	gchar* result = NULL;
	gchar* data_dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/saves", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}


gchar* games_application_get_snapshots_dir (void) {
	gchar* result = NULL;
	gchar* data_dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/snapshots", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}


gchar* games_application_get_cache_dir (void) {
	gchar* result = NULL;
	gchar* cache_dir;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	cache_dir = _tmp1_;
	_tmp2_ = string_to_string (cache_dir);
	_tmp3_ = g_strconcat (_tmp2_, "/gnome-games", NULL);
	result = _tmp3_;
	_g_free0 (cache_dir);
	return result;
}


gchar* games_application_get_config_dir (void) {
	gchar* result = NULL;
	gchar* config_dir;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = string_to_string (config_dir);
	_tmp3_ = g_strconcat (_tmp2_, "/gnome-games", NULL);
	result = _tmp3_;
	_g_free0 (config_dir);
	return result;
}


gchar* games_application_get_platforms_dir (void) {
	gchar* result = NULL;
	gchar* config_dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = games_application_get_config_dir ();
	config_dir = _tmp0_;
	_tmp1_ = string_to_string (config_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/platforms", NULL);
	result = _tmp2_;
	_g_free0 (config_dir);
	return result;
}


gchar* games_application_get_covers_dir (void) {
	gchar* result = NULL;
	gchar* cache_dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = games_application_get_cache_dir ();
	cache_dir = _tmp0_;
	_tmp1_ = string_to_string (cache_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/covers", NULL);
	result = _tmp2_;
	_g_free0 (cache_dir);
	return result;
}


void games_application_try_make_dir (const gchar* path) {
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	{
		GFile* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = file;
		_tmp3_ = g_file_query_exists (_tmp2_, NULL);
		if (!_tmp3_) {
			GFile* _tmp4_;
			_tmp4_ = file;
			g_file_make_directory_with_parents (_tmp4_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch26_g_error;
			}
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		g_warning ("application.vala:99: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


gchar* games_application_get_medias_dir (void) {
	gchar* result = NULL;
	gchar* data_dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/medias", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda16_ (GamesApplication* self) {
	games_application_quit_application (self);
}


static void ___lambda16__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda16_ ((GamesApplication*) self);
}


static gboolean _games_application_show_loading_notification_gsource_func (gpointer self) {
	gboolean result;
	result = games_application_show_loading_notification ((GamesApplication*) self);
	return result;
}


static void games_application_real_activate (GApplication* base) {
	GamesApplication * self;
	GtkSettings* _tmp0_;
	GdkScreen* screen;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GtkCssProvider* provider;
	GtkCssProvider* _tmp3_;
	GListStore* _tmp4_;
	GListStore* _tmp5_;
	GamesApplicationWindow* _tmp6_;
	GamesApplicationWindow* _tmp7_;
	GamesApplicationWindow* _tmp8_;
	GamesApplicationWindow* _tmp9_;
	self = (GamesApplication*) base;
	_tmp0_ = gtk_settings_get_default ();
	g_object_set (_tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	_tmp1_ = gdk_screen_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	screen = _tmp2_;
	_tmp3_ = games_application_load_css ("gtk-style.css");
	provider = _tmp3_;
	gtk_style_context_add_provider_for_screen (screen, (GtkStyleProvider*) provider, (guint) 600);
	_tmp4_ = g_list_store_new (GAMES_TYPE_GAME);
	_g_object_unref0 (self->priv->collection);
	self->priv->collection = _tmp4_;
	games_application_load_game_list (self, NULL, NULL);
	_tmp5_ = self->priv->collection;
	_tmp6_ = games_application_window_new ((GListModel*) _tmp5_);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp6_;
	_tmp7_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp7_);
	_tmp8_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "destroy", (GCallback) ___lambda16__gtk_widget_destroy, self, 0);
	_tmp9_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _games_application_show_loading_notification_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (provider);
	_g_object_unref0 (screen);
}


static gboolean games_application_show_loading_notification (GamesApplication* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game_list_loaded;
	if (!_tmp0_) {
		GamesApplicationWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		games_application_window_set_loading_notification (_tmp1_, TRUE);
	}
	result = FALSE;
	return result;
}


static void games_application_load_game_list_data_free (gpointer _data) {
	GamesApplicationLoadGameListData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesApplicationLoadGameListData, _data_);
}


void games_application_load_game_list (GamesApplication* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesApplicationLoadGameListData* _data_;
	GamesApplication* _tmp0_;
	_data_ = g_slice_new0 (GamesApplicationLoadGameListData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_application_load_game_list_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	games_application_load_game_list_co (_data_);
}


void games_application_load_game_list_finish (GamesApplication* self, GAsyncResult* _res_) {
	GamesApplicationLoadGameListData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_data_->_task_complete_ = TRUE;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesApplication* self;
		self = _data5_->self;
		_data5_->sources = (_vala_array_free (_data5_->sources, _data5_->sources_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _vala_array_add11 (GamesGameSource** * array, int* length, int* size, GamesGameSource* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGameSource*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda15_ (Block5Data* _data5_, GamesPluginRegistrar* plugin_registrar) {
	GamesApplication* self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	g_return_if_fail (plugin_registrar != NULL);
	{
		GamesPlugin* plugin;
		GamesPluginRegistrar* _tmp0_;
		GamesPlugin* _tmp1_;
		GamesGameSource* source;
		GamesPlugin* _tmp2_;
		GamesGameSource* _tmp3_;
		GamesGameSource* _tmp4_;
		_tmp0_ = plugin_registrar;
		_tmp1_ = games_plugin_registrar_get_plugin (_tmp0_, &_inner_error_);
		plugin = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
		_tmp2_ = plugin;
		_tmp3_ = games_plugin_get_game_source (_tmp2_, &_inner_error_);
		source = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (plugin);
			goto __catch27_g_error;
		}
		_tmp4_ = source;
		if (_tmp4_ != NULL) {
			GamesGameSource** _tmp5_;
			gint _tmp5__length1;
			GamesGameSource* _tmp6_;
			GamesGameSource* _tmp7_;
			_tmp5_ = _data5_->sources;
			_tmp5__length1 = _data5_->sources_length1;
			_tmp6_ = source;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_vala_array_add11 (&_data5_->sources, &_data5_->sources_length1, &_data5_->_sources_size_, _tmp7_);
		}
		_g_object_unref0 (source);
		_g_object_unref0 (plugin);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_debug ("application.vala:148: Error: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda15__games_plugin_register_plugin_registrar_func (GamesPluginRegistrar* plugin_registrar, gpointer self) {
	__lambda15_ (self, plugin_registrar);
}


static void _games_application_add_game_games_game_callback (GamesGame* game, gpointer self) {
	games_application_add_game ((GamesApplication*) self, game);
}


static void games_application_load_game_list_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GamesApplicationLoadGameListData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_application_load_game_list_co (_data_);
}


static gboolean games_application_load_game_list_co (GamesApplicationLoadGameListData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = g_new0 (GamesGameSource*, 0 + 1);
	_data_->_data5_->sources = _data_->_tmp0_;
	_data_->_data5_->sources_length1 = 0;
	_data_->_data5_->_sources_size_ = _data_->_data5_->sources_length1;
	_data_->_tmp1_ = games_plugin_register_get_register ();
	_data_->_register_ = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->_register_;
	games_plugin_register_foreach_plugin_registrar (_data_->_tmp2_, ___lambda15__games_plugin_register_plugin_registrar_func, _data_->_data5_);
	_data_->_tmp3_ = _data_->_data5_->sources;
	_data_->_tmp3__length1 = _data_->_data5_->sources_length1;
	{
		_data_->source_collection_length1 = 0;
		_data_->_source_collection_size_ = 0;
		_data_->source_collection = _data_->_tmp3_;
		_data_->source_collection_length1 = _data_->_tmp3__length1;
		for (_data_->source_it = 0; _data_->source_it < _data_->_tmp3__length1; _data_->source_it = _data_->source_it + 1) {
			_data_->_tmp4_ = _g_object_ref0 (_data_->source_collection[_data_->source_it]);
			_data_->source = _data_->_tmp4_;
			{
				_data_->_tmp5_ = _data_->source;
				_data_->_state_ = 1;
				games_game_source_each_game (_data_->_tmp5_, _games_application_add_game_games_game_callback, _data_->self, games_application_load_game_list_ready, _data_);
				return FALSE;
				_state_1:
				games_game_source_each_game_finish (_data_->_tmp5_, _data_->_res_);
				_g_object_unref0 (_data_->source);
			}
		}
	}
	_data_->self->priv->game_list_loaded = TRUE;
	_data_->_tmp6_ = _data_->self->priv->window;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->self->priv->window;
		games_application_window_set_loading_notification (_data_->_tmp7_, FALSE);
	}
	_g_object_unref0 (_data_->_register_);
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void games_application_add_game (GamesApplication* self, GamesGame* game) {
	GListStore* _tmp0_;
	GamesGame* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->collection;
	_tmp1_ = game;
	g_list_store_append (_tmp0_, (GObject*) _tmp1_);
}


static void games_application_preferences (GamesApplication* self) {
	GamesPreferencesWindow* _tmp0_;
	GamesPreferencesWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_preferences_window_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GamesApplication* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda13_ (Block6Data* _data6_, gint response_id) {
	GamesApplication* self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	self = _data6_->self;
	_tmp1_ = response_id;
	if (_tmp1_ == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		_tmp2_ = response_id;
		_tmp0_ = _tmp2_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp0_) {
		gtk_widget_hide_on_delete ((GtkWidget*) _data6_->dialog);
	}
}


static void ___lambda13__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda13_ (self, response_id);
}


static void games_application_about (GamesApplication* self) {
	Block6Data* _data6_;
	GtkAboutDialog* _tmp0_;
	GamesApplicationWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_data6_->dialog = _tmp0_;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data6_->dialog, TRUE);
	_tmp1_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _data6_->dialog, (GtkWindow*) _tmp1_);
	gtk_window_set_modal ((GtkWindow*) _data6_->dialog, TRUE);
	gtk_about_dialog_set_program_name (_data6_->dialog, _ ("GNOME Games"));
	gtk_about_dialog_set_logo_icon_name (_data6_->dialog, "org.gnome.Games");
	gtk_about_dialog_set_comments (_data6_->dialog, _ ("A video game player for GNOME"));
	gtk_about_dialog_set_version (_data6_->dialog, VERSION);
	gtk_about_dialog_set_website (_data6_->dialog, "https://wiki.gnome.org/Apps/Games");
	gtk_about_dialog_set_website_label (_data6_->dialog, _ ("Learn more about GNOME Games"));
	gtk_about_dialog_set_license_type (_data6_->dialog, GTK_LICENSE_GPL_3_0);
	gtk_about_dialog_set_authors (_data6_->dialog, GAMES_CREDITS_AUTHORS);
	gtk_about_dialog_set_artists (_data6_->dialog, GAMES_CREDITS_ARTISTS);
	gtk_about_dialog_set_documenters (_data6_->dialog, GAMES_CREDITS_DOCUMENTERS);
	gtk_about_dialog_set_translator_credits (_data6_->dialog, _ ("translator-credits"));
	g_signal_connect_data ((GtkDialog*) _data6_->dialog, "response", (GCallback) ___lambda13__gtk_dialog_response, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data6_->dialog);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void games_application_quit_application (GamesApplication* self) {
	gboolean _tmp0_ = FALSE;
	GamesApplicationWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->window;
	if (_tmp1_ != NULL) {
		GamesApplicationWindow* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->window;
		_tmp3_ = games_application_window_quit_game (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_application_quit ((GApplication*) self);
}


static GtkCssProvider* games_application_load_css (const gchar* css) {
	GtkCssProvider* result = NULL;
	GtkCssProvider* provider;
	GtkCssProvider* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (css != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		GFile* file;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp1_ = css;
		_tmp2_ = g_strconcat ("resource:///org/gnome/Games/", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		file = _tmp5_;
		gtk_css_provider_load_from_file (provider, file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch28_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = css;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("application.vala:210: Loading CSS file “%s” failed: %s", _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = provider;
	return result;
}


static GObject * games_application_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesApplication * self;
	parent_class = G_OBJECT_CLASS (games_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_APPLICATION, GamesApplication);
	g_set_prgname ("gnome-games");
	g_set_application_name (_ ("Games"));
	gtk_window_set_default_icon_name ("org.gnome.Games");
	g_setenv ("PULSE_PROP_media.role", "game", TRUE);
	g_setenv ("PULSE_PROP_application.icon_name", "org.gnome.Games", TRUE);
	games_application_add_actions (self);
	games_application_add_signal_handlers (self);
	return obj;
}


static void games_application_class_init (GamesApplicationClass * klass) {
	games_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesApplicationPrivate));
	((GApplicationClass *) klass)->activate = games_application_real_activate;
	G_OBJECT_CLASS (klass)->constructor = games_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_application_finalize;
}


static void games_application_instance_init (GamesApplication * self) {
	self->priv = GAMES_APPLICATION_GET_PRIVATE (self);
}


static void games_application_finalize (GObject * obj) {
	GamesApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_APPLICATION, GamesApplication);
	_g_object_unref0 (self->priv->collection);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (games_application_parent_class)->finalize (obj);
}


GType games_application_get_type (void) {
	static volatile gsize games_application_type_id__volatile = 0;
	if (g_once_init_enter (&games_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesApplication), 0, (GInstanceInitFunc) games_application_instance_init, NULL };
		GType games_application_type_id;
		games_application_type_id = g_type_register_static (gtk_application_get_type (), "GamesApplication", &g_define_type_info, 0);
		g_once_init_leave (&games_application_type_id__volatile, games_application_type_id);
	}
	return games_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



