/* mega-drive-header.c generated by valac 0.35.5, the Vala compiler
 * generated from mega-drive-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/
/* Documentation: https://en.wikibooks.org/wiki/Genesis_Programming*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgnome-games.h>


#define GAMES_TYPE_MEGA_DRIVE_HEADER (games_mega_drive_header_get_type ())
#define GAMES_MEGA_DRIVE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeader))
#define GAMES_MEGA_DRIVE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeaderClass))
#define GAMES_IS_MEGA_DRIVE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEGA_DRIVE_HEADER))
#define GAMES_IS_MEGA_DRIVE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEGA_DRIVE_HEADER))
#define GAMES_MEGA_DRIVE_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeaderClass))

typedef struct _GamesMegaDriveHeader GamesMegaDriveHeader;
typedef struct _GamesMegaDriveHeaderClass GamesMegaDriveHeaderClass;
typedef struct _GamesMegaDriveHeaderPrivate GamesMegaDriveHeaderPrivate;

#define GAMES_TYPE_MEGA_DRIVE_SYSTEM (games_mega_drive_system_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesMegaDriveHeader {
	GObject parent_instance;
	GamesMegaDriveHeaderPrivate * priv;
};

struct _GamesMegaDriveHeaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_MEGA_DRIVE_SYSTEM_INVALID,
	GAMES_MEGA_DRIVE_SYSTEM_MEGA_DRIVE,
	GAMES_MEGA_DRIVE_SYSTEM_32X,
	GAMES_MEGA_DRIVE_SYSTEM_PICO,
	GAMES_MEGA_DRIVE_SYSTEM_MEGA_CD,
	GAMES_MEGA_DRIVE_SYSTEM_MEGA_CD_32X
} GamesMegaDriveSystem;

struct _GamesMegaDriveHeaderPrivate {
	gchar* _domestic_name;
	GamesMegaDriveSystem* _system;
	GFile* file;
	gsize* offset;
};

typedef enum  {
	GAMES_MEGA_DRIVE_ERROR_INVALID_HEADER,
	GAMES_MEGA_DRIVE_ERROR_INVALID_CUE_SHEET,
	GAMES_MEGA_DRIVE_ERROR_INVALID_FILE_TYPE
} GamesMegaDriveError;
#define GAMES_MEGA_DRIVE_ERROR games_mega_drive_error_quark ()

static gpointer games_mega_drive_header_parent_class = NULL;
static GType games_mega_drive_header_type_id = 0;

GType games_mega_drive_header_get_type (void) G_GNUC_CONST;
GType games_mega_drive_system_get_type (void) G_GNUC_CONST;
#define GAMES_MEGA_DRIVE_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeaderPrivate))
enum  {
	GAMES_MEGA_DRIVE_HEADER_DUMMY_PROPERTY,
	GAMES_MEGA_DRIVE_HEADER_DOMESTIC_NAME,
	GAMES_MEGA_DRIVE_HEADER_SYSTEM
};
#define GAMES_MEGA_DRIVE_HEADER_HEADER_LENGTH ((gsize) 0x200)
#define GAMES_MEGA_DRIVE_HEADER_CD_OFFSET ((gsize) 0x0)
#define GAMES_MEGA_DRIVE_HEADER_SYSTEM_OFFSET ((gsize) 0x100)
#define GAMES_MEGA_DRIVE_HEADER_SYSTEM_SIZE ((gsize) 0xf)
#define GAMES_MEGA_DRIVE_HEADER_DOMESTIC_NAME_OFFSET ((gsize) 0x120)
#define GAMES_MEGA_DRIVE_HEADER_NAME_SIZE ((gsize) 0x30)
GamesMegaDriveHeader* games_mega_drive_header_new (GFile* file);
GamesMegaDriveHeader* games_mega_drive_header_construct (GType object_type, GFile* file);
void games_mega_drive_header_check_validity (GamesMegaDriveHeader* self, GError** error);
GamesMegaDriveSystem games_mega_drive_header_get_system (GamesMegaDriveHeader* self);
GQuark games_mega_drive_error_quark (void);
gsize games_mega_drive_header_get_offset (GamesMegaDriveHeader* self, GError** error);
static gsize* _size_t_dup (gsize* self);
static GamesMegaDriveSystem games_mega_drive_header_parse_system (GamesMegaDriveHeader* self, GError** error);
gboolean games_mega_drive_header_is_mega_drive (GamesMegaDriveHeader* self);
gboolean games_mega_drive_header_is_32x (GamesMegaDriveHeader* self);
gboolean games_mega_drive_header_is_pico (GamesMegaDriveHeader* self);
const gchar* games_mega_drive_header_get_domestic_name (GamesMegaDriveHeader* self);
static GamesMegaDriveSystem* _games_mega_drive_system_dup (GamesMegaDriveSystem* self);
static void games_mega_drive_header_finalize (GObject * obj);
static void _vala_games_mega_drive_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);

static const gsize GAMES_MEGA_DRIVE_HEADER_POSSIBLE_HEADER_OFFSETS[2] = {(gsize) 0x0, (gsize) 0x10};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesMegaDriveHeader* games_mega_drive_header_construct (GType object_type, GFile* file) {
	GamesMegaDriveHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesMegaDriveHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesMegaDriveHeader* games_mega_drive_header_new (GFile* file) {
	return games_mega_drive_header_construct (GAMES_TYPE_MEGA_DRIVE_HEADER, file);
}


void games_mega_drive_header_check_validity (GamesMegaDriveHeader* self, GError** error) {
	GamesMegaDriveSystem _tmp0_;
	GamesMegaDriveSystem _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_mega_drive_header_get_system (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GAMES_MEGA_DRIVE_SYSTEM_INVALID) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (GAMES_MEGA_DRIVE_ERROR, GAMES_MEGA_DRIVE_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Genesis/Sega 32X/Sega CD/Sega Pico header."));
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gsize* _size_t_dup (gsize* self) {
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}


static gpointer __size_t_dup0 (gpointer self) {
	return self ? _size_t_dup (self) : NULL;
}


gsize games_mega_drive_header_get_offset (GamesMegaDriveHeader* self, GError** error) {
	gsize result = 0UL;
	gsize* _tmp0_;
	GamesStringInputStream* stream;
	GFile* _tmp2_;
	GamesStringInputStream* _tmp3_;
	GError* _tmp15_;
	gsize _tmp16_ = 0UL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->offset;
	if (_tmp0_ != NULL) {
		gsize* _tmp1_;
		_tmp1_ = self->priv->offset;
		result = *_tmp1_;
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = games_string_input_stream_new (_tmp2_);
	stream = _tmp3_;
	{
		gsize* possible_offset_collection = NULL;
		gint possible_offset_collection_length1 = 0;
		gint _possible_offset_collection_size_ = 0;
		gint possible_offset_it = 0;
		possible_offset_collection = GAMES_MEGA_DRIVE_HEADER_POSSIBLE_HEADER_OFFSETS;
		possible_offset_collection_length1 = G_N_ELEMENTS (GAMES_MEGA_DRIVE_HEADER_POSSIBLE_HEADER_OFFSETS);
		for (possible_offset_it = 0; possible_offset_it < G_N_ELEMENTS (GAMES_MEGA_DRIVE_HEADER_POSSIBLE_HEADER_OFFSETS); possible_offset_it = possible_offset_it + 1) {
			gsize possible_offset = 0UL;
			possible_offset = possible_offset_collection[possible_offset_it];
			{
				gchar* system_string;
				GamesStringInputStream* _tmp4_;
				gsize _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gboolean _tmp11_;
				_tmp4_ = stream;
				_tmp5_ = possible_offset;
				_tmp6_ = games_string_input_stream_read_string_for_size (_tmp4_, _tmp5_ + GAMES_MEGA_DRIVE_HEADER_SYSTEM_OFFSET, GAMES_MEGA_DRIVE_HEADER_SYSTEM_SIZE, &_inner_error_);
				system_string = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gsize _tmp7_ = 0UL;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (stream);
					return _tmp7_;
				}
				_tmp8_ = system_string;
				_tmp9_ = string_strip (_tmp8_);
				_g_free0 (system_string);
				system_string = _tmp9_;
				_tmp10_ = system_string;
				_tmp11_ = g_str_has_prefix (_tmp10_, "SEGA");
				if (_tmp11_) {
					gsize _tmp12_;
					gsize* _tmp13_;
					gsize* _tmp14_;
					_tmp12_ = possible_offset;
					_tmp13_ = __size_t_dup0 (&_tmp12_);
					_g_free0 (self->priv->offset);
					self->priv->offset = _tmp13_;
					_tmp14_ = self->priv->offset;
					result = *_tmp14_;
					_g_free0 (system_string);
					_g_object_unref0 (stream);
					return result;
				}
				_g_free0 (system_string);
			}
		}
	}
	_tmp15_ = g_error_new_literal (GAMES_MEGA_DRIVE_ERROR, GAMES_MEGA_DRIVE_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Genesis/Sega 32X/Sega CD/Sega Pico header."));
	_inner_error_ = _tmp15_;
	g_propagate_error (error, _inner_error_);
	_g_object_unref0 (stream);
	return _tmp16_;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}


static GamesMegaDriveSystem games_mega_drive_header_parse_system (GamesMegaDriveHeader* self, GError** error) {
	GamesMegaDriveSystem result = 0;
	GamesStringInputStream* stream;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gsize offset;
	gsize _tmp2_;
	gboolean is_cd;
	GamesStringInputStream* _tmp3_;
	gsize _tmp4_;
	gboolean _tmp5_;
	gchar* system_string;
	GamesStringInputStream* _tmp6_;
	gsize _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GQuark _tmp14_ = 0U;
	static GQuark _tmp13_label0 = 0;
	static GQuark _tmp13_label1 = 0;
	static GQuark _tmp13_label2 = 0;
	static GQuark _tmp13_label3 = 0;
	static GQuark _tmp13_label4 = 0;
	static GQuark _tmp13_label5 = 0;
	static GQuark _tmp13_label6 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_mega_drive_header_get_offset (self, &_inner_error_);
	offset = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return 0;
	}
	_tmp3_ = stream;
	_tmp4_ = offset;
	_tmp5_ = games_string_input_stream_has_string (_tmp3_, _tmp4_ + GAMES_MEGA_DRIVE_HEADER_CD_OFFSET, "SEGADISCSYSTEM", &_inner_error_);
	is_cd = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return 0;
	}
	_tmp6_ = stream;
	_tmp7_ = offset;
	_tmp8_ = games_string_input_stream_read_string_for_size (_tmp6_, _tmp7_ + GAMES_MEGA_DRIVE_HEADER_SYSTEM_OFFSET, GAMES_MEGA_DRIVE_HEADER_SYSTEM_SIZE, &_inner_error_);
	system_string = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return 0;
	}
	_tmp9_ = system_string;
	_tmp10_ = string_chomp (_tmp9_);
	_g_free0 (system_string);
	system_string = _tmp10_;
	_tmp11_ = system_string;
	_tmp12_ = _tmp11_;
	_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
	if (((((_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("SEGA MEGA DRIVE")))) || (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("SEGA GENESIS"))))) || (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string (" SEGA MEGA DRIV"))))) || (_tmp14_ == ((0 != _tmp13_label3) ? _tmp13_label3 : (_tmp13_label3 = g_quark_from_static_string ("SEGA_MEGA_DRIVE"))))) || (_tmp14_ == ((0 != _tmp13_label4) ? _tmp13_label4 : (_tmp13_label4 = g_quark_from_static_string ("SEGA are Regist"))))) {
		switch (0) {
			default:
			{
				GamesMegaDriveSystem _tmp15_ = 0;
				gboolean _tmp16_;
				_tmp16_ = is_cd;
				if (_tmp16_) {
					_tmp15_ = GAMES_MEGA_DRIVE_SYSTEM_MEGA_CD;
				} else {
					_tmp15_ = GAMES_MEGA_DRIVE_SYSTEM_MEGA_DRIVE;
				}
				result = _tmp15_;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label5) ? _tmp13_label5 : (_tmp13_label5 = g_quark_from_static_string ("SEGA 32X")))) {
		switch (0) {
			default:
			{
				GamesMegaDriveSystem _tmp17_ = 0;
				gboolean _tmp18_;
				_tmp18_ = is_cd;
				if (_tmp18_) {
					_tmp17_ = GAMES_MEGA_DRIVE_SYSTEM_MEGA_CD_32X;
				} else {
					_tmp17_ = GAMES_MEGA_DRIVE_SYSTEM_32X;
				}
				result = _tmp17_;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label6) ? _tmp13_label6 : (_tmp13_label6 = g_quark_from_static_string ("SEGA PICO")))) {
		switch (0) {
			default:
			{
				GamesMegaDriveSystem _tmp19_ = 0;
				gboolean _tmp20_;
				_tmp20_ = is_cd;
				if (_tmp20_) {
					_tmp19_ = GAMES_MEGA_DRIVE_SYSTEM_INVALID;
				} else {
					_tmp19_ = GAMES_MEGA_DRIVE_SYSTEM_PICO;
				}
				result = _tmp19_;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GAMES_MEGA_DRIVE_SYSTEM_INVALID;
				_g_free0 (system_string);
				_g_object_unref0 (stream);
				return result;
			}
		}
	}
	_g_free0 (system_string);
	_g_object_unref0 (stream);
}


gboolean games_mega_drive_header_is_mega_drive (GamesMegaDriveHeader* self) {
	gboolean result = FALSE;
	GamesMegaDriveSystem _tmp0_;
	GamesMegaDriveSystem _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_mega_drive_header_get_system (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_MEGA_DRIVE_SYSTEM_MEGA_DRIVE:
		case GAMES_MEGA_DRIVE_SYSTEM_MEGA_CD:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


gboolean games_mega_drive_header_is_32x (GamesMegaDriveHeader* self) {
	gboolean result = FALSE;
	GamesMegaDriveSystem _tmp0_;
	GamesMegaDriveSystem _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_mega_drive_header_get_system (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_MEGA_DRIVE_SYSTEM_32X:
		case GAMES_MEGA_DRIVE_SYSTEM_MEGA_CD_32X:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


gboolean games_mega_drive_header_is_pico (GamesMegaDriveHeader* self) {
	gboolean result = FALSE;
	GamesMegaDriveSystem _tmp0_;
	GamesMegaDriveSystem _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_mega_drive_header_get_system (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GAMES_MEGA_DRIVE_SYSTEM_PICO;
	return result;
}


const gchar* games_mega_drive_header_get_domestic_name (GamesMegaDriveHeader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	GamesStringInputStream* stream;
	GFile* _tmp2_;
	GamesStringInputStream* _tmp3_;
	const gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_domestic_name;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_domestic_name;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = games_string_input_stream_new (_tmp2_);
	stream = _tmp3_;
	{
		gchar* _tmp4_;
		GamesStringInputStream* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = stream;
		_tmp6_ = games_string_input_stream_read_string_for_size (_tmp5_, GAMES_MEGA_DRIVE_HEADER_DOMESTIC_NAME_OFFSET, GAMES_MEGA_DRIVE_HEADER_NAME_SIZE, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (self->priv->_domestic_name);
		self->priv->_domestic_name = _tmp7_;
		_g_free0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = g_strdup ("");
		_g_free0 (self->priv->_domestic_name);
		self->priv->_domestic_name = _tmp8_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = self->priv->_domestic_name;
	result = _tmp9_;
	_g_object_unref0 (stream);
	return result;
}


static GamesMegaDriveSystem* _games_mega_drive_system_dup (GamesMegaDriveSystem* self) {
	GamesMegaDriveSystem* dup;
	dup = g_new0 (GamesMegaDriveSystem, 1);
	memcpy (dup, self, sizeof (GamesMegaDriveSystem));
	return dup;
}


static gpointer __games_mega_drive_system_dup0 (gpointer self) {
	return self ? _games_mega_drive_system_dup (self) : NULL;
}


GamesMegaDriveSystem games_mega_drive_header_get_system (GamesMegaDriveHeader* self) {
	GamesMegaDriveSystem result;
	GamesMegaDriveSystem* _tmp0_;
	GamesMegaDriveSystem* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_system;
	if (_tmp0_ != NULL) {
		GamesMegaDriveSystem* _tmp1_;
		_tmp1_ = self->priv->_system;
		result = *_tmp1_;
		return result;
	}
	{
		GamesMegaDriveSystem _tmp2_;
		GamesMegaDriveSystem _tmp3_;
		GamesMegaDriveSystem* _tmp4_;
		_tmp3_ = games_mega_drive_header_parse_system (self, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp4_ = __games_mega_drive_system_dup0 (&_tmp2_);
		_g_free0 (self->priv->_system);
		self->priv->_system = _tmp4_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GamesMegaDriveSystem _tmp7_;
		GamesMegaDriveSystem* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("mega-drive-header.vala:47: %s", _tmp6_);
		_tmp7_ = GAMES_MEGA_DRIVE_SYSTEM_INVALID;
		_tmp8_ = __games_mega_drive_system_dup0 (&_tmp7_);
		_g_free0 (self->priv->_system);
		self->priv->_system = _tmp8_;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = self->priv->_system;
	result = *_tmp9_;
	return result;
}


static void games_mega_drive_header_class_init (GamesMegaDriveHeaderClass * klass) {
	games_mega_drive_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesMegaDriveHeaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_mega_drive_header_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_mega_drive_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_MEGA_DRIVE_HEADER_DOMESTIC_NAME, g_param_spec_string ("domestic-name", "domestic-name", "domestic-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_MEGA_DRIVE_HEADER_SYSTEM, g_param_spec_enum ("system", "system", "system", GAMES_TYPE_MEGA_DRIVE_SYSTEM, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_mega_drive_header_instance_init (GamesMegaDriveHeader * self) {
	self->priv = GAMES_MEGA_DRIVE_HEADER_GET_PRIVATE (self);
}


static void games_mega_drive_header_finalize (GObject * obj) {
	GamesMegaDriveHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeader);
	_g_free0 (self->priv->_domestic_name);
	_g_free0 (self->priv->_system);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->offset);
	G_OBJECT_CLASS (games_mega_drive_header_parent_class)->finalize (obj);
}


GType games_mega_drive_header_get_type (void) {
	return games_mega_drive_header_type_id;
}


GType games_mega_drive_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesMegaDriveHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_mega_drive_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesMegaDriveHeader), 0, (GInstanceInitFunc) games_mega_drive_header_instance_init, NULL };
	games_mega_drive_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesMegaDriveHeader", &g_define_type_info, 0);
	return games_mega_drive_header_type_id;
}


static void _vala_games_mega_drive_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesMegaDriveHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_MEGA_DRIVE_HEADER, GamesMegaDriveHeader);
	switch (property_id) {
		case GAMES_MEGA_DRIVE_HEADER_DOMESTIC_NAME:
		g_value_set_string (value, games_mega_drive_header_get_domestic_name (self));
		break;
		case GAMES_MEGA_DRIVE_HEADER_SYSTEM:
		g_value_set_enum (value, games_mega_drive_header_get_system (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GQuark games_mega_drive_error_quark (void) {
	return g_quark_from_static_string ("games_mega_drive_error-quark");
}



