/* master-system-header.c generated by valac 0.35.5, the Vala compiler
 * generated from master-system-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/
/* Documentation: http://www.smspower.org/Development/ROMHeader*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgnome-games.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_MASTER_SYSTEM_HEADER (games_master_system_header_get_type ())
#define GAMES_MASTER_SYSTEM_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MASTER_SYSTEM_HEADER, GamesMasterSystemHeader))
#define GAMES_MASTER_SYSTEM_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MASTER_SYSTEM_HEADER, GamesMasterSystemHeaderClass))
#define GAMES_IS_MASTER_SYSTEM_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MASTER_SYSTEM_HEADER))
#define GAMES_IS_MASTER_SYSTEM_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MASTER_SYSTEM_HEADER))
#define GAMES_MASTER_SYSTEM_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MASTER_SYSTEM_HEADER, GamesMasterSystemHeaderClass))

typedef struct _GamesMasterSystemHeader GamesMasterSystemHeader;
typedef struct _GamesMasterSystemHeaderClass GamesMasterSystemHeaderClass;
typedef struct _GamesMasterSystemHeaderPrivate GamesMasterSystemHeaderPrivate;

#define GAMES_TYPE_MASTER_SYSTEM_REGION (games_master_system_region_get_type ())
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesMasterSystemHeader {
	GObject parent_instance;
	GamesMasterSystemHeaderPrivate * priv;
};

struct _GamesMasterSystemHeaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_MASTER_SYSTEM_REGION_INVALID = 0,
	GAMES_MASTER_SYSTEM_REGION_SMS_JAPAN = 3,
	GAMES_MASTER_SYSTEM_REGION_SMS_EXPORT,
	GAMES_MASTER_SYSTEM_REGION_GG_JAPAN,
	GAMES_MASTER_SYSTEM_REGION_GG_EXPORT,
	GAMES_MASTER_SYSTEM_REGION_GG_INTERNATIONAL
} GamesMasterSystemRegion;

struct _GamesMasterSystemHeaderPrivate {
	GamesMasterSystemRegion* _region_code;
	GFile* file;
};

typedef enum  {
	GAMES_MASTER_SYSTEM_ERROR_INVALID_HEADER
} GamesMasterSystemError;
#define GAMES_MASTER_SYSTEM_ERROR games_master_system_error_quark ()

static gpointer games_master_system_header_parent_class = NULL;
static GType games_master_system_header_type_id = 0;

GType games_master_system_header_get_type (void) G_GNUC_CONST;
GType games_master_system_region_get_type (void) G_GNUC_CONST;
#define GAMES_MASTER_SYSTEM_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_MASTER_SYSTEM_HEADER, GamesMasterSystemHeaderPrivate))
enum  {
	GAMES_MASTER_SYSTEM_HEADER_DUMMY_PROPERTY,
	GAMES_MASTER_SYSTEM_HEADER_REGION_CODE
};
#define GAMES_MASTER_SYSTEM_HEADER_MAGIC_OFFSET ((gsize) 0x7ff0)
#define GAMES_MASTER_SYSTEM_HEADER_MAGIC_VALUE "TMR SEGA"
#define GAMES_MASTER_SYSTEM_HEADER_REGION_CODE_OFFSET ((gsize) 0x7fff)
#define GAMES_MASTER_SYSTEM_HEADER_REGION_CODE_MASK ((guint8) 0xf0)
GamesMasterSystemHeader* games_master_system_header_new (GFile* file);
GamesMasterSystemHeader* games_master_system_header_construct (GType object_type, GFile* file);
void games_master_system_header_check_validity (GamesMasterSystemHeader* self, GError** error);
GQuark games_master_system_error_quark (void);
gboolean games_master_system_header_is_master_system (GamesMasterSystemHeader* self);
GamesMasterSystemRegion games_master_system_header_get_region_code (GamesMasterSystemHeader* self);
gboolean games_master_system_header_is_game_gear (GamesMasterSystemHeader* self);
static GamesMasterSystemRegion* _games_master_system_region_dup (GamesMasterSystemRegion* self);
static void games_master_system_header_finalize (GObject * obj);
static void _vala_games_master_system_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesMasterSystemHeader* games_master_system_header_construct (GType object_type, GFile* file) {
	GamesMasterSystemHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesMasterSystemHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesMasterSystemHeader* games_master_system_header_new (GFile* file) {
	return games_master_system_header_construct (GAMES_TYPE_MASTER_SYSTEM_HEADER, file);
}


void games_master_system_header_check_validity (GamesMasterSystemHeader* self, GError** error) {
	GamesStringInputStream* stream;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gboolean _tmp2_;
	GamesStringInputStream* _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp3_ = stream;
	_tmp4_ = games_string_input_stream_has_string (_tmp3_, GAMES_MASTER_SYSTEM_HEADER_MAGIC_OFFSET, GAMES_MASTER_SYSTEM_HEADER_MAGIC_VALUE, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return;
	}
	if (!_tmp2_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (GAMES_MASTER_SYSTEM_ERROR, GAMES_MASTER_SYSTEM_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Master System header."));
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return;
	}
	_g_object_unref0 (stream);
}


gboolean games_master_system_header_is_master_system (GamesMasterSystemHeader* self) {
	gboolean result = FALSE;
	GamesMasterSystemRegion _tmp0_;
	GamesMasterSystemRegion _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_master_system_header_get_region_code (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_MASTER_SYSTEM_REGION_SMS_JAPAN:
		case GAMES_MASTER_SYSTEM_REGION_SMS_EXPORT:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


gboolean games_master_system_header_is_game_gear (GamesMasterSystemHeader* self) {
	gboolean result = FALSE;
	GamesMasterSystemRegion _tmp0_;
	GamesMasterSystemRegion _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_master_system_header_get_region_code (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GAMES_MASTER_SYSTEM_REGION_GG_JAPAN:
		case GAMES_MASTER_SYSTEM_REGION_GG_EXPORT:
		case GAMES_MASTER_SYSTEM_REGION_GG_INTERNATIONAL:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static GamesMasterSystemRegion* _games_master_system_region_dup (GamesMasterSystemRegion* self) {
	GamesMasterSystemRegion* dup;
	dup = g_new0 (GamesMasterSystemRegion, 1);
	memcpy (dup, self, sizeof (GamesMasterSystemRegion));
	return dup;
}


static gpointer __games_master_system_region_dup0 (gpointer self) {
	return self ? _games_master_system_region_dup (self) : NULL;
}


GamesMasterSystemRegion games_master_system_header_get_region_code (GamesMasterSystemHeader* self) {
	GamesMasterSystemRegion result;
	GamesMasterSystemRegion* _tmp0_;
	GFileInputStream* stream = NULL;
	guint8 buffer[1] = {0};
	gint region_value;
	guint8 _tmp18_;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_;
	GamesMasterSystemRegion* _tmp25_;
	GamesMasterSystemRegion* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_region_code;
	if (_tmp0_ != NULL) {
		GamesMasterSystemRegion* _tmp1_;
		_tmp1_ = self->priv->_region_code;
		result = *_tmp1_;
		return result;
	}
	{
		GFileInputStream* _tmp2_;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GFileInputStream* _tmp5_;
		_tmp3_ = self->priv->file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (stream);
		stream = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GamesMasterSystemRegion _tmp6_;
		GamesMasterSystemRegion* _tmp7_;
		GamesMasterSystemRegion* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = GAMES_MASTER_SYSTEM_REGION_INVALID;
		_tmp7_ = __games_master_system_region_dup0 (&_tmp6_);
		_g_free0 (self->priv->_region_code);
		self->priv->_region_code = _tmp7_;
		_tmp8_ = self->priv->_region_code;
		result = *_tmp8_;
		_g_error_free0 (e);
		_g_object_unref0 (stream);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		GFileInputStream* _tmp9_;
		_tmp9_ = stream;
		G_FILE_INPUT_STREAM_GET_CLASS (_tmp9_)->seek (_tmp9_, (gint64) GAMES_MASTER_SYSTEM_HEADER_REGION_CODE_OFFSET, G_SEEK_SET, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GamesMasterSystemRegion _tmp10_;
		GamesMasterSystemRegion* _tmp11_;
		GamesMasterSystemRegion* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = GAMES_MASTER_SYSTEM_REGION_INVALID;
		_tmp11_ = __games_master_system_region_dup0 (&_tmp10_);
		_g_free0 (self->priv->_region_code);
		self->priv->_region_code = _tmp11_;
		_tmp12_ = self->priv->_region_code;
		result = *_tmp12_;
		_g_error_free0 (e);
		_g_object_unref0 (stream);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		GFileInputStream* _tmp13_;
		GFileInputStream* _tmp14_;
		_tmp13_ = stream;
		G_FILE_INPUT_STREAM_GET_CLASS (_tmp13_)->seek (_tmp13_, (gint64) GAMES_MASTER_SYSTEM_HEADER_REGION_CODE_OFFSET, G_SEEK_SET, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp14_ = stream;
		g_input_stream_read ((GInputStream*) _tmp14_, buffer, (gsize) 1, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GamesMasterSystemRegion _tmp15_;
		GamesMasterSystemRegion* _tmp16_;
		GamesMasterSystemRegion* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = GAMES_MASTER_SYSTEM_REGION_INVALID;
		_tmp16_ = __games_master_system_region_dup0 (&_tmp15_);
		_g_free0 (self->priv->_region_code);
		self->priv->_region_code = _tmp16_;
		_tmp17_ = self->priv->_region_code;
		result = *_tmp17_;
		_g_error_free0 (e);
		_g_object_unref0 (stream);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp18_ = buffer[0];
	region_value = (_tmp18_ & GAMES_MASTER_SYSTEM_HEADER_REGION_CODE_MASK) >> 4;
	_tmp20_ = region_value;
	if (GAMES_MASTER_SYSTEM_REGION_SMS_JAPAN <= _tmp20_) {
		gint _tmp21_;
		_tmp21_ = region_value;
		_tmp19_ = _tmp21_ <= ((gint) GAMES_MASTER_SYSTEM_REGION_GG_INTERNATIONAL);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gint _tmp22_;
		GamesMasterSystemRegion _tmp23_;
		GamesMasterSystemRegion* _tmp24_;
		_tmp22_ = region_value;
		_tmp23_ = (GamesMasterSystemRegion) _tmp22_;
		_tmp24_ = __games_master_system_region_dup0 (&_tmp23_);
		_g_free0 (self->priv->_region_code);
		self->priv->_region_code = _tmp24_;
	}
	_tmp25_ = self->priv->_region_code;
	if (_tmp25_ == NULL) {
		GamesMasterSystemRegion _tmp26_;
		GamesMasterSystemRegion* _tmp27_;
		_tmp26_ = GAMES_MASTER_SYSTEM_REGION_INVALID;
		_tmp27_ = __games_master_system_region_dup0 (&_tmp26_);
		_g_free0 (self->priv->_region_code);
		self->priv->_region_code = _tmp27_;
	}
	_tmp28_ = self->priv->_region_code;
	result = *_tmp28_;
	_g_object_unref0 (stream);
	return result;
}


static void games_master_system_header_class_init (GamesMasterSystemHeaderClass * klass) {
	games_master_system_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesMasterSystemHeaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_master_system_header_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_master_system_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_MASTER_SYSTEM_HEADER_REGION_CODE, g_param_spec_enum ("region-code", "region-code", "region-code", GAMES_TYPE_MASTER_SYSTEM_REGION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_master_system_header_instance_init (GamesMasterSystemHeader * self) {
	self->priv = GAMES_MASTER_SYSTEM_HEADER_GET_PRIVATE (self);
}


static void games_master_system_header_finalize (GObject * obj) {
	GamesMasterSystemHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_MASTER_SYSTEM_HEADER, GamesMasterSystemHeader);
	_g_free0 (self->priv->_region_code);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_master_system_header_parent_class)->finalize (obj);
}


GType games_master_system_header_get_type (void) {
	return games_master_system_header_type_id;
}


GType games_master_system_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesMasterSystemHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_master_system_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesMasterSystemHeader), 0, (GInstanceInitFunc) games_master_system_header_instance_init, NULL };
	games_master_system_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesMasterSystemHeader", &g_define_type_info, 0);
	return games_master_system_header_type_id;
}


static void _vala_games_master_system_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesMasterSystemHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_MASTER_SYSTEM_HEADER, GamesMasterSystemHeader);
	switch (property_id) {
		case GAMES_MASTER_SYSTEM_HEADER_REGION_CODE:
		g_value_set_enum (value, games_master_system_header_get_region_code (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType games_master_system_region_get_type (void) {
	static volatile gsize games_master_system_region_type_id__volatile = 0;
	if (g_once_init_enter (&games_master_system_region_type_id__volatile)) {
		static const GEnumValue values[] = {{GAMES_MASTER_SYSTEM_REGION_INVALID, "GAMES_MASTER_SYSTEM_REGION_INVALID", "invalid"}, {GAMES_MASTER_SYSTEM_REGION_SMS_JAPAN, "GAMES_MASTER_SYSTEM_REGION_SMS_JAPAN", "sms-japan"}, {GAMES_MASTER_SYSTEM_REGION_SMS_EXPORT, "GAMES_MASTER_SYSTEM_REGION_SMS_EXPORT", "sms-export"}, {GAMES_MASTER_SYSTEM_REGION_GG_JAPAN, "GAMES_MASTER_SYSTEM_REGION_GG_JAPAN", "gg-japan"}, {GAMES_MASTER_SYSTEM_REGION_GG_EXPORT, "GAMES_MASTER_SYSTEM_REGION_GG_EXPORT", "gg-export"}, {GAMES_MASTER_SYSTEM_REGION_GG_INTERNATIONAL, "GAMES_MASTER_SYSTEM_REGION_GG_INTERNATIONAL", "gg-international"}, {0, NULL, NULL}};
		GType games_master_system_region_type_id;
		games_master_system_region_type_id = g_enum_register_static ("GamesMasterSystemRegion", values);
		g_once_init_leave (&games_master_system_region_type_id__volatile, games_master_system_region_type_id);
	}
	return games_master_system_region_type_id__volatile;
}


GQuark games_master_system_error_quark (void) {
	return g_quark_from_static_string ("games_master_system_error-quark");
}



