/* retro-gamepad.c generated by valac 0.35.5, the Vala compiler
 * generated from retro-gamepad.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <retro-gtk.h>
#include <float.h>
#include <math.h>


#define GAMES_TYPE_RETRO_GAMEPAD (games_retro_gamepad_get_type ())
#define GAMES_RETRO_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad))
#define GAMES_RETRO_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadClass))
#define GAMES_IS_RETRO_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_GAMEPAD))
#define GAMES_IS_RETRO_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_GAMEPAD))
#define GAMES_RETRO_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadClass))

typedef struct _GamesRetroGamepad GamesRetroGamepad;
typedef struct _GamesRetroGamepadClass GamesRetroGamepadClass;
typedef struct _GamesRetroGamepadPrivate GamesRetroGamepadPrivate;

#define GAMES_TYPE_GAMEPAD (games_gamepad_get_type ())
#define GAMES_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD, GamesGamepad))
#define GAMES_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD, GamesGamepadClass))
#define GAMES_IS_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD))
#define GAMES_IS_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD))
#define GAMES_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD, GamesGamepadClass))

typedef struct _GamesGamepad GamesGamepad;
typedef struct _GamesGamepadClass GamesGamepadClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_STANDARD_GAMEPAD_BUTTON (games_standard_gamepad_button_get_type ())

#define GAMES_TYPE_STANDARD_GAMEPAD_AXIS (games_standard_gamepad_axis_get_type ())

struct _GamesRetroGamepad {
	GObject parent_instance;
	GamesRetroGamepadPrivate * priv;
};

struct _GamesRetroGamepadClass {
	GObjectClass parent_class;
};

struct _GamesRetroGamepadPrivate {
	GamesGamepad* _gamepad;
	gboolean _present_analog_sticks;
	gboolean* buttons;
	gint buttons_length1;
	gint _buttons_size_;
	gint16* axes;
	gint axes_length1;
	gint _axes_size_;
};

typedef enum  {
	GAMES_STANDARD_GAMEPAD_BUTTON_UNKNOWN,
	GAMES_STANDARD_GAMEPAD_BUTTON_A,
	GAMES_STANDARD_GAMEPAD_BUTTON_B,
	GAMES_STANDARD_GAMEPAD_BUTTON_X,
	GAMES_STANDARD_GAMEPAD_BUTTON_Y,
	GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_L,
	GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_R,
	GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_L,
	GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_R,
	GAMES_STANDARD_GAMEPAD_BUTTON_SELECT,
	GAMES_STANDARD_GAMEPAD_BUTTON_START,
	GAMES_STANDARD_GAMEPAD_BUTTON_STICK_L,
	GAMES_STANDARD_GAMEPAD_BUTTON_STICK_R,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_UP,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_DOWN,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_LEFT,
	GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_RIGHT,
	GAMES_STANDARD_GAMEPAD_BUTTON_HOME
} GamesStandardGamepadButton;

typedef enum  {
	GAMES_STANDARD_GAMEPAD_AXIS_UNKNOWN,
	GAMES_STANDARD_GAMEPAD_AXIS_LEFT_X,
	GAMES_STANDARD_GAMEPAD_AXIS_LEFT_Y,
	GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_X,
	GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_Y
} GamesStandardGamepadAxis;


static gpointer games_retro_gamepad_parent_class = NULL;
static RetroInputDeviceIface * games_retro_gamepad_retro_input_device_parent_iface = NULL;

GType games_retro_gamepad_get_type (void) G_GNUC_CONST;
GType games_gamepad_get_type (void) G_GNUC_CONST;
#define GAMES_RETRO_GAMEPAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadPrivate))
enum  {
	GAMES_RETRO_GAMEPAD_DUMMY_PROPERTY,
	GAMES_RETRO_GAMEPAD_GAMEPAD,
	GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS
};
GamesRetroGamepad* games_retro_gamepad_new (GamesGamepad* gamepad, gboolean present_analog_sticks);
GamesRetroGamepad* games_retro_gamepad_construct (GType object_type, GamesGamepad* gamepad, gboolean present_analog_sticks);
static void games_retro_gamepad_real_poll (RetroInputDevice* base);
static gint16 games_retro_gamepad_real_get_input_state (RetroInputDevice* base, RetroDeviceType device, guint index, guint id);
gboolean games_retro_gamepad_get_button_pressed (GamesRetroGamepad* self, RetroJoypadId button);
gint16 games_retro_gamepad_get_analog_value (GamesRetroGamepad* self, RetroAnalogIndex index, RetroAnalogId id);
static RetroDeviceType games_retro_gamepad_real_get_device_type (RetroInputDevice* base);
gboolean games_retro_gamepad_get_present_analog_sticks (GamesRetroGamepad* self);
static guint64 games_retro_gamepad_real_get_device_capabilities (RetroInputDevice* base);
GType games_standard_gamepad_button_get_type (void) G_GNUC_CONST;
GType games_standard_gamepad_axis_get_type (void) G_GNUC_CONST;
GamesGamepad* games_retro_gamepad_get_gamepad (GamesRetroGamepad* self);
static void games_retro_gamepad_set_gamepad (GamesRetroGamepad* self, GamesGamepad* value);
static void games_retro_gamepad_set_present_analog_sticks (GamesRetroGamepad* self, gboolean value);
static GObject * games_retro_gamepad_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _games_retro_gamepad___lambda21_ (GamesRetroGamepad* self, GamesStandardGamepadButton button, gboolean value);
static void __games_retro_gamepad___lambda21__games_gamepad_button_event (GamesGamepad* _sender, GamesStandardGamepadButton button, gboolean value, gpointer self);
static void _games_retro_gamepad___lambda22_ (GamesRetroGamepad* self, GamesStandardGamepadAxis axis, gdouble value);
static void __games_retro_gamepad___lambda22__games_gamepad_axis_event (GamesGamepad* _sender, GamesStandardGamepadAxis axis, gdouble value, gpointer self);
static void games_retro_gamepad_finalize (GObject * obj);
static void _vala_games_retro_gamepad_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_games_retro_gamepad_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GamesRetroGamepad* games_retro_gamepad_construct (GType object_type, GamesGamepad* gamepad, gboolean present_analog_sticks) {
	GamesRetroGamepad * self = NULL;
	GamesGamepad* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (gamepad != NULL, NULL);
	_tmp0_ = gamepad;
	_tmp1_ = present_analog_sticks;
	self = (GamesRetroGamepad*) g_object_new (object_type, "gamepad", _tmp0_, "present-analog-sticks", _tmp1_, NULL);
	return self;
}


GamesRetroGamepad* games_retro_gamepad_new (GamesGamepad* gamepad, gboolean present_analog_sticks) {
	return games_retro_gamepad_construct (GAMES_TYPE_RETRO_GAMEPAD, gamepad, present_analog_sticks);
}


static void games_retro_gamepad_real_poll (RetroInputDevice* base) {
	GamesRetroGamepad * self;
	self = (GamesRetroGamepad*) base;
}


static gint16 games_retro_gamepad_real_get_input_state (RetroInputDevice* base, RetroDeviceType device, guint index, guint id) {
	GamesRetroGamepad * self;
	gint16 result = 0;
	RetroDeviceType _tmp0_;
	self = (GamesRetroGamepad*) base;
	_tmp0_ = device;
	switch (_tmp0_) {
		case RETRO_DEVICE_TYPE_JOYPAD:
		{
			gint16 _tmp1_ = 0;
			guint _tmp2_;
			gboolean _tmp3_;
			_tmp2_ = id;
			_tmp3_ = games_retro_gamepad_get_button_pressed (self, (RetroJoypadId) _tmp2_);
			if (_tmp3_) {
				_tmp1_ = G_MAXINT16;
			} else {
				_tmp1_ = (gint16) 0;
			}
			result = _tmp1_;
			return result;
		}
		case RETRO_DEVICE_TYPE_ANALOG:
		{
			guint _tmp4_;
			guint _tmp5_;
			gint16 _tmp6_;
			_tmp4_ = index;
			_tmp5_ = id;
			_tmp6_ = games_retro_gamepad_get_analog_value (self, (RetroAnalogIndex) _tmp4_, (RetroAnalogId) _tmp5_);
			result = _tmp6_;
			return result;
		}
		default:
		{
			result = (gint16) 0;
			return result;
		}
	}
}


static RetroDeviceType games_retro_gamepad_real_get_device_type (RetroInputDevice* base) {
	GamesRetroGamepad * self;
	RetroDeviceType result = 0;
	gboolean _tmp0_;
	self = (GamesRetroGamepad*) base;
	_tmp0_ = self->priv->_present_analog_sticks;
	if (_tmp0_) {
		result = RETRO_DEVICE_TYPE_ANALOG;
		return result;
	}
	result = RETRO_DEVICE_TYPE_JOYPAD;
	return result;
}


static guint64 games_retro_gamepad_real_get_device_capabilities (RetroInputDevice* base) {
	GamesRetroGamepad * self;
	guint64 result = 0ULL;
	self = (GamesRetroGamepad*) base;
	result = (guint64) ((1 << RETRO_DEVICE_TYPE_JOYPAD) | (1 << RETRO_DEVICE_TYPE_ANALOG));
	return result;
}


gboolean games_retro_gamepad_get_button_pressed (GamesRetroGamepad* self, RetroJoypadId button) {
	gboolean result = FALSE;
	RetroJoypadId _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = button;
	switch (_tmp0_) {
		case RETRO_JOYPAD_ID_B:
		{
			gboolean* _tmp1_;
			gint _tmp1__length1;
			gboolean _tmp2_;
			_tmp1_ = self->priv->buttons;
			_tmp1__length1 = self->priv->buttons_length1;
			_tmp2_ = _tmp1_[GAMES_STANDARD_GAMEPAD_BUTTON_A];
			result = _tmp2_;
			return result;
		}
		case RETRO_JOYPAD_ID_Y:
		{
			gboolean* _tmp3_;
			gint _tmp3__length1;
			gboolean _tmp4_;
			_tmp3_ = self->priv->buttons;
			_tmp3__length1 = self->priv->buttons_length1;
			_tmp4_ = _tmp3_[GAMES_STANDARD_GAMEPAD_BUTTON_X];
			result = _tmp4_;
			return result;
		}
		case RETRO_JOYPAD_ID_SELECT:
		{
			gboolean* _tmp5_;
			gint _tmp5__length1;
			gboolean _tmp6_;
			_tmp5_ = self->priv->buttons;
			_tmp5__length1 = self->priv->buttons_length1;
			_tmp6_ = _tmp5_[GAMES_STANDARD_GAMEPAD_BUTTON_SELECT];
			result = _tmp6_;
			return result;
		}
		case RETRO_JOYPAD_ID_START:
		{
			gboolean* _tmp7_;
			gint _tmp7__length1;
			gboolean _tmp8_;
			_tmp7_ = self->priv->buttons;
			_tmp7__length1 = self->priv->buttons_length1;
			_tmp8_ = _tmp7_[GAMES_STANDARD_GAMEPAD_BUTTON_START];
			result = _tmp8_;
			return result;
		}
		case RETRO_JOYPAD_ID_UP:
		{
			gboolean* _tmp9_;
			gint _tmp9__length1;
			gboolean _tmp10_;
			_tmp9_ = self->priv->buttons;
			_tmp9__length1 = self->priv->buttons_length1;
			_tmp10_ = _tmp9_[GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_UP];
			result = _tmp10_;
			return result;
		}
		case RETRO_JOYPAD_ID_DOWN:
		{
			gboolean* _tmp11_;
			gint _tmp11__length1;
			gboolean _tmp12_;
			_tmp11_ = self->priv->buttons;
			_tmp11__length1 = self->priv->buttons_length1;
			_tmp12_ = _tmp11_[GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_DOWN];
			result = _tmp12_;
			return result;
		}
		case RETRO_JOYPAD_ID_LEFT:
		{
			gboolean* _tmp13_;
			gint _tmp13__length1;
			gboolean _tmp14_;
			_tmp13_ = self->priv->buttons;
			_tmp13__length1 = self->priv->buttons_length1;
			_tmp14_ = _tmp13_[GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_LEFT];
			result = _tmp14_;
			return result;
		}
		case RETRO_JOYPAD_ID_RIGHT:
		{
			gboolean* _tmp15_;
			gint _tmp15__length1;
			gboolean _tmp16_;
			_tmp15_ = self->priv->buttons;
			_tmp15__length1 = self->priv->buttons_length1;
			_tmp16_ = _tmp15_[GAMES_STANDARD_GAMEPAD_BUTTON_DPAD_RIGHT];
			result = _tmp16_;
			return result;
		}
		case RETRO_JOYPAD_ID_A:
		{
			gboolean* _tmp17_;
			gint _tmp17__length1;
			gboolean _tmp18_;
			_tmp17_ = self->priv->buttons;
			_tmp17__length1 = self->priv->buttons_length1;
			_tmp18_ = _tmp17_[GAMES_STANDARD_GAMEPAD_BUTTON_B];
			result = _tmp18_;
			return result;
		}
		case RETRO_JOYPAD_ID_X:
		{
			gboolean* _tmp19_;
			gint _tmp19__length1;
			gboolean _tmp20_;
			_tmp19_ = self->priv->buttons;
			_tmp19__length1 = self->priv->buttons_length1;
			_tmp20_ = _tmp19_[GAMES_STANDARD_GAMEPAD_BUTTON_Y];
			result = _tmp20_;
			return result;
		}
		case RETRO_JOYPAD_ID_L:
		{
			gboolean* _tmp21_;
			gint _tmp21__length1;
			gboolean _tmp22_;
			_tmp21_ = self->priv->buttons;
			_tmp21__length1 = self->priv->buttons_length1;
			_tmp22_ = _tmp21_[GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_L];
			result = _tmp22_;
			return result;
		}
		case RETRO_JOYPAD_ID_R:
		{
			gboolean* _tmp23_;
			gint _tmp23__length1;
			gboolean _tmp24_;
			_tmp23_ = self->priv->buttons;
			_tmp23__length1 = self->priv->buttons_length1;
			_tmp24_ = _tmp23_[GAMES_STANDARD_GAMEPAD_BUTTON_SHOULDER_R];
			result = _tmp24_;
			return result;
		}
		case RETRO_JOYPAD_ID_L2:
		{
			gboolean* _tmp25_;
			gint _tmp25__length1;
			gboolean _tmp26_;
			_tmp25_ = self->priv->buttons;
			_tmp25__length1 = self->priv->buttons_length1;
			_tmp26_ = _tmp25_[GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_L];
			result = _tmp26_;
			return result;
		}
		case RETRO_JOYPAD_ID_R2:
		{
			gboolean* _tmp27_;
			gint _tmp27__length1;
			gboolean _tmp28_;
			_tmp27_ = self->priv->buttons;
			_tmp27__length1 = self->priv->buttons_length1;
			_tmp28_ = _tmp27_[GAMES_STANDARD_GAMEPAD_BUTTON_TRIGGER_R];
			result = _tmp28_;
			return result;
		}
		case RETRO_JOYPAD_ID_L3:
		{
			gboolean* _tmp29_;
			gint _tmp29__length1;
			gboolean _tmp30_;
			_tmp29_ = self->priv->buttons;
			_tmp29__length1 = self->priv->buttons_length1;
			_tmp30_ = _tmp29_[GAMES_STANDARD_GAMEPAD_BUTTON_STICK_L];
			result = _tmp30_;
			return result;
		}
		case RETRO_JOYPAD_ID_R3:
		{
			gboolean* _tmp31_;
			gint _tmp31__length1;
			gboolean _tmp32_;
			_tmp31_ = self->priv->buttons;
			_tmp31__length1 = self->priv->buttons_length1;
			_tmp32_ = _tmp31_[GAMES_STANDARD_GAMEPAD_BUTTON_STICK_R];
			result = _tmp32_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


gint16 games_retro_gamepad_get_analog_value (GamesRetroGamepad* self, RetroAnalogIndex index, RetroAnalogId id) {
	gint16 result = 0;
	RetroAnalogIndex _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	switch (_tmp0_) {
		case RETRO_ANALOG_INDEX_LEFT:
		{
			RetroAnalogId _tmp1_;
			_tmp1_ = id;
			switch (_tmp1_) {
				case RETRO_ANALOG_ID_X:
				{
					gint16* _tmp2_;
					gint _tmp2__length1;
					gint16 _tmp3_;
					_tmp2_ = self->priv->axes;
					_tmp2__length1 = self->priv->axes_length1;
					_tmp3_ = _tmp2_[GAMES_STANDARD_GAMEPAD_AXIS_LEFT_X];
					result = _tmp3_;
					return result;
				}
				case RETRO_ANALOG_ID_Y:
				{
					gint16* _tmp4_;
					gint _tmp4__length1;
					gint16 _tmp5_;
					_tmp4_ = self->priv->axes;
					_tmp4__length1 = self->priv->axes_length1;
					_tmp5_ = _tmp4_[GAMES_STANDARD_GAMEPAD_AXIS_LEFT_Y];
					result = _tmp5_;
					return result;
				}
				default:
				{
					result = (gint16) 0;
					return result;
				}
			}
		}
		case RETRO_ANALOG_INDEX_RIGHT:
		{
			RetroAnalogId _tmp6_;
			_tmp6_ = id;
			switch (_tmp6_) {
				case RETRO_ANALOG_ID_X:
				{
					gint16* _tmp7_;
					gint _tmp7__length1;
					gint16 _tmp8_;
					_tmp7_ = self->priv->axes;
					_tmp7__length1 = self->priv->axes_length1;
					_tmp8_ = _tmp7_[GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_X];
					result = _tmp8_;
					return result;
				}
				case RETRO_ANALOG_ID_Y:
				{
					gint16* _tmp9_;
					gint _tmp9__length1;
					gint16 _tmp10_;
					_tmp9_ = self->priv->axes;
					_tmp9__length1 = self->priv->axes_length1;
					_tmp10_ = _tmp9_[GAMES_STANDARD_GAMEPAD_AXIS_RIGHT_Y];
					result = _tmp10_;
					return result;
				}
				default:
				{
					result = (gint16) 0;
					return result;
				}
			}
		}
		default:
		{
			result = (gint16) 0;
			return result;
		}
	}
}


GamesGamepad* games_retro_gamepad_get_gamepad (GamesRetroGamepad* self) {
	GamesGamepad* result;
	GamesGamepad* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gamepad;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void games_retro_gamepad_set_gamepad (GamesRetroGamepad* self, GamesGamepad* value) {
	g_return_if_fail (self != NULL);
	if (games_retro_gamepad_get_gamepad (self) != value) {
		GamesGamepad* _tmp0_;
		GamesGamepad* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_gamepad);
		self->priv->_gamepad = _tmp1_;
		g_object_notify ((GObject *) self, "gamepad");
	}
}


gboolean games_retro_gamepad_get_present_analog_sticks (GamesRetroGamepad* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_present_analog_sticks;
	result = _tmp0_;
	return result;
}


static void games_retro_gamepad_set_present_analog_sticks (GamesRetroGamepad* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (games_retro_gamepad_get_present_analog_sticks (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_present_analog_sticks = _tmp0_;
		g_object_notify ((GObject *) self, "present-analog-sticks");
	}
}


static void _games_retro_gamepad___lambda21_ (GamesRetroGamepad* self, GamesStandardGamepadButton button, gboolean value) {
	gboolean* _tmp0_;
	gint _tmp0__length1;
	GamesStandardGamepadButton _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->buttons;
	_tmp0__length1 = self->priv->buttons_length1;
	_tmp1_ = button;
	_tmp2_ = value;
	_tmp0_[_tmp1_] = _tmp2_;
	_tmp3_ = _tmp0_[_tmp1_];
}


static void __games_retro_gamepad___lambda21__games_gamepad_button_event (GamesGamepad* _sender, GamesStandardGamepadButton button, gboolean value, gpointer self) {
	_games_retro_gamepad___lambda21_ ((GamesRetroGamepad*) self, button, value);
}


static void _games_retro_gamepad___lambda22_ (GamesRetroGamepad* self, GamesStandardGamepadAxis axis, gdouble value) {
	gint16* _tmp0_;
	gint _tmp0__length1;
	GamesStandardGamepadAxis _tmp1_;
	gdouble _tmp2_;
	gint16 _tmp3_;
	_tmp0_ = self->priv->axes;
	_tmp0__length1 = self->priv->axes_length1;
	_tmp1_ = axis;
	_tmp2_ = value;
	_tmp0_[_tmp1_] = (gint16) (_tmp2_ * G_MAXINT16);
	_tmp3_ = _tmp0_[_tmp1_];
}


static void __games_retro_gamepad___lambda22__games_gamepad_axis_event (GamesGamepad* _sender, GamesStandardGamepadAxis axis, gdouble value, gpointer self) {
	_games_retro_gamepad___lambda22_ ((GamesRetroGamepad*) self, axis, value);
}


static GObject * games_retro_gamepad_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesRetroGamepad * self;
	gboolean* _tmp0_;
	gint16* _tmp1_;
	GamesGamepad* _tmp2_;
	GamesGamepad* _tmp3_;
	parent_class = G_OBJECT_CLASS (games_retro_gamepad_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	_tmp0_ = g_new0 (gboolean, GAMES_STANDARD_GAMEPAD_BUTTON_HOME + 1);
	self->priv->buttons = (g_free (self->priv->buttons), NULL);
	self->priv->buttons = _tmp0_;
	self->priv->buttons_length1 = GAMES_STANDARD_GAMEPAD_BUTTON_HOME + 1;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp1_ = g_new0 (gint16, 4);
	self->priv->axes = (g_free (self->priv->axes), NULL);
	self->priv->axes = _tmp1_;
	self->priv->axes_length1 = 4;
	self->priv->_axes_size_ = self->priv->axes_length1;
	_tmp2_ = self->priv->_gamepad;
	g_signal_connect_object (_tmp2_, "button-event", (GCallback) __games_retro_gamepad___lambda21__games_gamepad_button_event, self, 0);
	_tmp3_ = self->priv->_gamepad;
	g_signal_connect_object (_tmp3_, "axis-event", (GCallback) __games_retro_gamepad___lambda22__games_gamepad_axis_event, self, 0);
	return obj;
}


static void games_retro_gamepad_class_init (GamesRetroGamepadClass * klass) {
	games_retro_gamepad_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesRetroGamepadPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_retro_gamepad_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_retro_gamepad_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_retro_gamepad_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_retro_gamepad_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_GAMEPAD_GAMEPAD, g_param_spec_object ("gamepad", "gamepad", "gamepad", GAMES_TYPE_GAMEPAD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS, g_param_spec_boolean ("present-analog-sticks", "present-analog-sticks", "present-analog-sticks", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void games_retro_gamepad_retro_input_device_interface_init (RetroInputDeviceIface * iface) {
	games_retro_gamepad_retro_input_device_parent_iface = g_type_interface_peek_parent (iface);
	iface->poll = (void (*) (RetroInputDevice *)) games_retro_gamepad_real_poll;
	iface->get_input_state = (gint16 (*) (RetroInputDevice *, RetroDeviceType, guint, guint)) games_retro_gamepad_real_get_input_state;
	iface->get_device_type = (RetroDeviceType (*) (RetroInputDevice *)) games_retro_gamepad_real_get_device_type;
	iface->get_device_capabilities = (guint64 (*) (RetroInputDevice *)) games_retro_gamepad_real_get_device_capabilities;
}


static void games_retro_gamepad_instance_init (GamesRetroGamepad * self) {
	self->priv = GAMES_RETRO_GAMEPAD_GET_PRIVATE (self);
}


static void games_retro_gamepad_finalize (GObject * obj) {
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	_g_object_unref0 (self->priv->_gamepad);
	self->priv->buttons = (g_free (self->priv->buttons), NULL);
	self->priv->axes = (g_free (self->priv->axes), NULL);
	G_OBJECT_CLASS (games_retro_gamepad_parent_class)->finalize (obj);
}


GType games_retro_gamepad_get_type (void) {
	static volatile gsize games_retro_gamepad_type_id__volatile = 0;
	if (g_once_init_enter (&games_retro_gamepad_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesRetroGamepadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_gamepad_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroGamepad), 0, (GInstanceInitFunc) games_retro_gamepad_instance_init, NULL };
		static const GInterfaceInfo retro_input_device_info = { (GInterfaceInitFunc) games_retro_gamepad_retro_input_device_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType games_retro_gamepad_type_id;
		games_retro_gamepad_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroGamepad", &g_define_type_info, 0);
		g_type_add_interface_static (games_retro_gamepad_type_id, RETRO_TYPE_INPUT_DEVICE, &retro_input_device_info);
		g_once_init_leave (&games_retro_gamepad_type_id__volatile, games_retro_gamepad_type_id);
	}
	return games_retro_gamepad_type_id__volatile;
}


static void _vala_games_retro_gamepad_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	switch (property_id) {
		case GAMES_RETRO_GAMEPAD_GAMEPAD:
		g_value_set_object (value, games_retro_gamepad_get_gamepad (self));
		break;
		case GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS:
		g_value_set_boolean (value, games_retro_gamepad_get_present_analog_sticks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_games_retro_gamepad_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	switch (property_id) {
		case GAMES_RETRO_GAMEPAD_GAMEPAD:
		games_retro_gamepad_set_gamepad (self, g_value_get_object (value));
		break;
		case GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS:
		games_retro_gamepad_set_present_analog_sticks (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



