// This file is part of GNOME Games. License: GPLv3

private enum Games.StandardGamepadButton {
	UNKNOWN,

	/**
	 * The button at the bottom of the action pad.
	 */
	A,

	/**
	 * The button at the right of the action pad.
	 */
	B,

	/**
	 * The button at the left of the action pad.
	 */
	X,

	/**
	 * The button at the top of the action pad.
	 */
	Y,

	/**
	 * The button at the left of the top of the gamepad.
	 */
	SHOULDER_L,

	/**
	 * The button at the right of the top of the gamepad.
	 */
	SHOULDER_R,

	/**
	 * The trigger at the left of the top of the gamepad.
	 */
	TRIGGER_L,

	/**
	 * The trigger at the right of the top of the gamepad.
	 */
	TRIGGER_R,

	/**
	 * The button at the left of the menu pad.
	 */
	SELECT,

	/**
	 * The button at the right of the menu pad.
	 */
	START,

	/**
	 * The button under the left stick.
	 */
	STICK_L,

	/**
	 * The button under the right stick.
	 */
	STICK_R,

	DPAD_UP,
	DPAD_DOWN,
	DPAD_LEFT,
	DPAD_RIGHT,

	/**
	 * The button at the center of the menu pad.
	 */
	HOME,
}
