/* pc-engine-plugin.c generated by valac 0.35.5, the Vala compiler
 * generated from pc-engine-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>


#define GAMES_TYPE_PC_ENGINE_PLUGIN (games_pc_engine_plugin_get_type ())
#define GAMES_PC_ENGINE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PC_ENGINE_PLUGIN, GamesPcEnginePlugin))
#define GAMES_PC_ENGINE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PC_ENGINE_PLUGIN, GamesPcEnginePluginClass))
#define GAMES_IS_PC_ENGINE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PC_ENGINE_PLUGIN))
#define GAMES_IS_PC_ENGINE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PC_ENGINE_PLUGIN))
#define GAMES_PC_ENGINE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PC_ENGINE_PLUGIN, GamesPcEnginePluginClass))

typedef struct _GamesPcEnginePlugin GamesPcEnginePlugin;
typedef struct _GamesPcEnginePluginClass GamesPcEnginePluginClass;
typedef struct _GamesPcEnginePluginPrivate GamesPcEnginePluginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesPcEnginePlugin {
	GObject parent_instance;
	GamesPcEnginePluginPrivate * priv;
};

struct _GamesPcEnginePluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_PC_ENGINE_ERROR_INVALID_DISC
} GamesPcEngineError;
#define GAMES_PC_ENGINE_ERROR games_pc_engine_error_quark ()

static gpointer games_pc_engine_plugin_parent_class = NULL;
static GamesPluginIface * games_pc_engine_plugin_games_plugin_parent_iface = NULL;
static GType games_pc_engine_plugin_type_id = 0;

GType games_pc_engine_plugin_get_type (void) G_GNUC_CONST;
enum  {
	GAMES_PC_ENGINE_PLUGIN_DUMMY_PROPERTY
};
#define GAMES_PC_ENGINE_PLUGIN_FINGERPRINT_PREFIX "pc-engine"
#define GAMES_PC_ENGINE_PLUGIN_MIME_TYPE "application/x-pc-engine-rom"
#define GAMES_PC_ENGINE_PLUGIN_PLATFORM "TurboGrafx16"
#define GAMES_PC_ENGINE_PLUGIN_CUE_MIME_TYPE "application/x-cue"
#define GAMES_PC_ENGINE_PLUGIN_CD_MAGIC_VALUE "PC Engine CD-ROM SYSTEM"
#define GAMES_PC_ENGINE_PLUGIN_CD_PLATFORM "TurboGrafxCD"
static GamesGameSource* games_pc_engine_plugin_real_get_game_source (GamesPlugin* base, GError** error);
static GamesGame* games_pc_engine_plugin_game_for_uri (const gchar* uri, GError** error);
static GamesGame* _games_pc_engine_plugin_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error);
static GamesGame* games_pc_engine_plugin_cd_game_for_uri (const gchar* uri, GError** error);
static GamesGame* _games_pc_engine_plugin_cd_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error);
static gboolean games_pc_engine_plugin_is_valid_disc (const gchar* uri, GError** error);
GQuark games_pc_engine_error_quark (void);
GamesPcEnginePlugin* games_pc_engine_plugin_new (void);
GamesPcEnginePlugin* games_pc_engine_plugin_construct (GType object_type);
GType register_games_plugin (GTypeModule* module);
GType games_pc_engine_plugin_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GamesGame* _games_pc_engine_plugin_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error) {
	GamesGame* result;
	result = games_pc_engine_plugin_game_for_uri (uri, error);
	return result;
}


static GamesGame* _games_pc_engine_plugin_cd_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri (const gchar* uri, gpointer self, GError** error) {
	GamesGame* result;
	result = games_pc_engine_plugin_cd_game_for_uri (uri, error);
	return result;
}


static GamesGameSource* games_pc_engine_plugin_real_get_game_source (GamesPlugin* base, GError** error) {
	GamesPcEnginePlugin * self;
	GamesGameSource* result = NULL;
	GamesGenericSyncGameUriAdapter* game_uri_adapter;
	GamesGenericSyncGameUriAdapter* _tmp0_;
	GamesGenericSyncGameUriAdapter* cd_game_uri_adapter;
	GamesGenericSyncGameUriAdapter* _tmp1_;
	GamesGenericUriGameFactory* factory;
	GamesGenericUriGameFactory* _tmp2_;
	GamesGenericUriGameFactory* cd_factory;
	GamesGenericUriGameFactory* _tmp3_;
	GamesMimeTypeTrackerQuery* query;
	GamesMimeTypeTrackerQuery* _tmp4_;
	GamesMimeTypeTrackerQuery* cd_query;
	GamesMimeTypeTrackerQuery* _tmp5_;
	TrackerSparqlConnection* connection;
	TrackerSparqlConnection* _tmp6_;
	GamesTrackerGameSource* source;
	GamesTrackerGameSource* _tmp7_;
	GamesTrackerGameSource* _tmp8_;
	GamesTrackerGameSource* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (GamesPcEnginePlugin*) base;
	_tmp0_ = games_generic_sync_game_uri_adapter_new (_games_pc_engine_plugin_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_sync_game_uri_adapter_new (_games_pc_engine_plugin_cd_game_for_uri_games_generic_sync_game_uri_adapter_game_for_uri, NULL, NULL);
	cd_game_uri_adapter = _tmp1_;
	_tmp2_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter, NULL, NULL, NULL);
	factory = _tmp2_;
	_tmp3_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) cd_game_uri_adapter, NULL, NULL, NULL);
	cd_factory = _tmp3_;
	_tmp4_ = games_mime_type_tracker_query_new (GAMES_PC_ENGINE_PLUGIN_MIME_TYPE, (GamesUriGameFactory*) factory);
	query = _tmp4_;
	_tmp5_ = games_mime_type_tracker_query_new (GAMES_PC_ENGINE_PLUGIN_CUE_MIME_TYPE, (GamesUriGameFactory*) cd_factory);
	cd_query = _tmp5_;
	_tmp6_ = tracker_sparql_connection_get (NULL, &_inner_error_);
	connection = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cd_query);
		_g_object_unref0 (query);
		_g_object_unref0 (cd_factory);
		_g_object_unref0 (factory);
		_g_object_unref0 (cd_game_uri_adapter);
		_g_object_unref0 (game_uri_adapter);
		return NULL;
	}
	_tmp7_ = games_tracker_game_source_new (connection);
	source = _tmp7_;
	_tmp8_ = source;
	games_tracker_game_source_add_query (_tmp8_, (GamesTrackerQuery*) query);
	_tmp9_ = source;
	games_tracker_game_source_add_query (_tmp9_, (GamesTrackerQuery*) cd_query);
	result = (GamesGameSource*) source;
	_g_object_unref0 (connection);
	_g_object_unref0 (cd_query);
	_g_object_unref0 (query);
	_g_object_unref0 (cd_factory);
	_g_object_unref0 (factory);
	_g_object_unref0 (cd_game_uri_adapter);
	_g_object_unref0 (game_uri_adapter);
	return result;
}


static GamesGame* games_pc_engine_plugin_game_for_uri (const gchar* uri, GError** error) {
	GamesGame* result = NULL;
	GamesFingerprintUid* uid;
	const gchar* _tmp0_;
	GamesFingerprintUid* _tmp1_;
	GamesFilenameTitle* title;
	const gchar* _tmp2_;
	GamesFilenameTitle* _tmp3_;
	GamesDummyIcon* icon;
	GamesDummyIcon* _tmp4_;
	GamesGriloMedia* media;
	GamesGriloMedia* _tmp5_;
	GamesCompositeCover* cover;
	const gchar* _tmp6_;
	GamesLocalCover* _tmp7_;
	GamesGriloCover* _tmp8_;
	GamesCover** _tmp9_;
	GamesCover** _tmp10_;
	gint _tmp10__length1;
	GamesCompositeCover* _tmp11_;
	GamesCompositeCover* _tmp12_;
	GamesRetroCoreSource* core_source;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GamesRetroCoreSource* _tmp16_;
	GamesRetroCoreSource* _tmp17_;
	GamesRetroRunner* runner;
	const gchar* _tmp18_;
	GamesRetroRunner* _tmp19_;
	GamesGenericGame* _tmp20_;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = games_fingerprint_uid_new (_tmp0_, GAMES_PC_ENGINE_PLUGIN_FINGERPRINT_PREFIX);
	uid = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = games_filename_title_new (_tmp2_);
	title = _tmp3_;
	_tmp4_ = games_dummy_icon_new ();
	icon = _tmp4_;
	_tmp5_ = games_grilo_media_new ((GamesTitle*) title, GAMES_PC_ENGINE_PLUGIN_MIME_TYPE);
	media = _tmp5_;
	_tmp6_ = uri;
	_tmp7_ = games_local_cover_new (_tmp6_);
	_tmp8_ = games_grilo_cover_new (media, (GamesUid*) uid);
	_tmp9_ = g_new0 (GamesCover*, 2 + 1);
	_tmp9_[0] = (GamesCover*) _tmp7_;
	_tmp9_[1] = (GamesCover*) _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = games_composite_cover_new (_tmp10_, 2);
	_tmp12_ = _tmp11_;
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp12_;
	_tmp13_ = g_strdup (GAMES_PC_ENGINE_PLUGIN_MIME_TYPE);
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	_tmp16_ = games_retro_core_source_new (GAMES_PC_ENGINE_PLUGIN_PLATFORM, _tmp15_, 1);
	_tmp17_ = _tmp16_;
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	core_source = _tmp17_;
	_tmp18_ = uri;
	_tmp19_ = games_retro_runner_new (core_source, _tmp18_, (GamesUid*) uid, (GamesTitle*) title);
	runner = _tmp19_;
	_tmp20_ = games_generic_game_new ((GamesTitle*) title, (GamesIcon*) icon, (GamesCover*) cover, (GamesRunner*) runner);
	result = (GamesGame*) _tmp20_;
	_g_object_unref0 (runner);
	_g_object_unref0 (core_source);
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	return result;
}


static GamesGame* games_pc_engine_plugin_cd_game_for_uri (const gchar* uri, GError** error) {
	GamesGame* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	GamesFingerprintUid* uid;
	const gchar* _tmp5_;
	GamesFingerprintUid* _tmp6_;
	GamesFilenameTitle* title;
	const gchar* _tmp7_;
	GamesFilenameTitle* _tmp8_;
	GamesDummyIcon* icon;
	GamesDummyIcon* _tmp9_;
	GamesGriloMedia* media;
	GamesFilenameTitle* _tmp10_;
	GamesGriloMedia* _tmp11_;
	GamesCompositeCover* cover;
	const gchar* _tmp12_;
	GamesLocalCover* _tmp13_;
	GamesGriloMedia* _tmp14_;
	GamesFingerprintUid* _tmp15_;
	GamesGriloCover* _tmp16_;
	GamesCover** _tmp17_;
	GamesCover** _tmp18_;
	gint _tmp18__length1;
	GamesCompositeCover* _tmp19_;
	GamesCompositeCover* _tmp20_;
	GamesRetroCoreSource* core_source;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	GamesRetroCoreSource* _tmp25_;
	GamesRetroCoreSource* _tmp26_;
	GamesRetroRunner* runner;
	GamesRetroCoreSource* _tmp27_;
	const gchar* _tmp28_;
	GamesFingerprintUid* _tmp29_;
	GamesFilenameTitle* _tmp30_;
	GamesRetroRunner* _tmp31_;
	GamesFilenameTitle* _tmp32_;
	GamesDummyIcon* _tmp33_;
	GamesCompositeCover* _tmp34_;
	GamesRetroRunner* _tmp35_;
	GamesGenericGame* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp1_ = uri;
	_tmp2_ = games_pc_engine_plugin_is_valid_disc (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (!_tmp0_) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = uri;
		_tmp4_ = g_error_new (GAMES_PC_ENGINE_ERROR, GAMES_PC_ENGINE_ERROR_INVALID_DISC, "“%s” isn’t a valid PC-Engine CD-ROM² disc.", _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp5_ = uri;
	_tmp6_ = games_fingerprint_uid_new (_tmp5_, GAMES_PC_ENGINE_PLUGIN_FINGERPRINT_PREFIX);
	uid = _tmp6_;
	_tmp7_ = uri;
	_tmp8_ = games_filename_title_new (_tmp7_);
	title = _tmp8_;
	_tmp9_ = games_dummy_icon_new ();
	icon = _tmp9_;
	_tmp10_ = title;
	_tmp11_ = games_grilo_media_new ((GamesTitle*) _tmp10_, GAMES_PC_ENGINE_PLUGIN_MIME_TYPE);
	media = _tmp11_;
	_tmp12_ = uri;
	_tmp13_ = games_local_cover_new (_tmp12_);
	_tmp14_ = media;
	_tmp15_ = uid;
	_tmp16_ = games_grilo_cover_new (_tmp14_, (GamesUid*) _tmp15_);
	_tmp17_ = g_new0 (GamesCover*, 2 + 1);
	_tmp17_[0] = (GamesCover*) _tmp13_;
	_tmp17_[1] = (GamesCover*) _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 2;
	_tmp19_ = games_composite_cover_new (_tmp18_, 2);
	_tmp20_ = _tmp19_;
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp20_;
	_tmp21_ = g_strdup (GAMES_PC_ENGINE_PLUGIN_CUE_MIME_TYPE);
	_tmp22_ = g_strdup (GAMES_PC_ENGINE_PLUGIN_MIME_TYPE);
	_tmp23_ = g_new0 (gchar*, 2 + 1);
	_tmp23_[0] = _tmp21_;
	_tmp23_[1] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 2;
	_tmp25_ = games_retro_core_source_new (GAMES_PC_ENGINE_PLUGIN_CD_PLATFORM, _tmp24_, 2);
	_tmp26_ = _tmp25_;
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	core_source = _tmp26_;
	_tmp27_ = core_source;
	_tmp28_ = uri;
	_tmp29_ = uid;
	_tmp30_ = title;
	_tmp31_ = games_retro_runner_new (_tmp27_, _tmp28_, (GamesUid*) _tmp29_, (GamesTitle*) _tmp30_);
	runner = _tmp31_;
	_tmp32_ = title;
	_tmp33_ = icon;
	_tmp34_ = cover;
	_tmp35_ = runner;
	_tmp36_ = games_generic_game_new ((GamesTitle*) _tmp32_, (GamesIcon*) _tmp33_, (GamesCover*) _tmp34_, (GamesRunner*) _tmp35_);
	result = (GamesGame*) _tmp36_;
	_g_object_unref0 (runner);
	_g_object_unref0 (core_source);
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean games_pc_engine_plugin_is_valid_disc (const gchar* uri, GError** error) {
	gboolean result = FALSE;
	GFile* cue_file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GamesCueSheet* cue_sheet;
	GFile* _tmp2_;
	GamesCueSheet* _tmp3_;
	GamesCueSheet* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GamesCueSheetTrackNode* track;
	GamesCueSheet* _tmp8_;
	GamesCueSheetTrackNode* _tmp9_;
	GamesCueSheetTrackNode* _tmp11_;
	GamesCueSheetTrackMode _tmp12_;
	GamesCueSheetTrackMode _tmp13_;
	gboolean _tmp14_;
	GFile* bin_file;
	GamesCueSheetTrackNode* _tmp15_;
	GamesCueSheetFileNode* _tmp16_;
	GamesCueSheetFileNode* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gchar* path;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gsize* offsets;
	const gchar* _tmp23_;
	gint _tmp24_;
	gsize* _tmp25_;
	gint offsets_length1;
	gint _offsets_size_;
	gsize* _tmp26_;
	gint _tmp26__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	cue_file = _tmp1_;
	_tmp2_ = cue_file;
	_tmp3_ = games_cue_sheet_new (_tmp2_, &_inner_error_);
	cue_sheet = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cue_file);
		return _tmp4_;
	}
	_tmp5_ = cue_sheet;
	_tmp6_ = games_cue_sheet_get_tracks_number (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ < ((guint) 2)) {
		result = FALSE;
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		return result;
	}
	_tmp8_ = cue_sheet;
	_tmp9_ = games_cue_sheet_get_track (_tmp8_, (guint) 1, &_inner_error_);
	track = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		return _tmp10_;
	}
	_tmp11_ = track;
	_tmp12_ = games_cue_sheet_track_node_get_track_mode (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = games_cue_sheet_track_mode_is_mode1 (_tmp13_);
	if (!_tmp14_) {
		result = FALSE;
		_g_object_unref0 (track);
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		return result;
	}
	_tmp15_ = track;
	_tmp16_ = games_cue_sheet_track_node_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = games_cue_sheet_file_node_get_file (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	bin_file = _tmp20_;
	_tmp21_ = bin_file;
	_tmp22_ = g_file_get_path (_tmp21_);
	path = _tmp22_;
	_tmp23_ = path;
	_tmp25_ = games_grep_get_offsets (_tmp23_, GAMES_PC_ENGINE_PLUGIN_CD_MAGIC_VALUE, &_tmp24_);
	offsets = _tmp25_;
	offsets_length1 = _tmp24_;
	_offsets_size_ = offsets_length1;
	_tmp26_ = offsets;
	_tmp26__length1 = offsets_length1;
	result = _tmp26__length1 > 0;
	offsets = (g_free (offsets), NULL);
	_g_free0 (path);
	_g_object_unref0 (bin_file);
	_g_object_unref0 (track);
	_g_object_unref0 (cue_sheet);
	_g_object_unref0 (cue_file);
	return result;
}


GamesPcEnginePlugin* games_pc_engine_plugin_construct (GType object_type) {
	GamesPcEnginePlugin * self = NULL;
	self = (GamesPcEnginePlugin*) g_object_new (object_type, NULL);
	return self;
}


GamesPcEnginePlugin* games_pc_engine_plugin_new (void) {
	return games_pc_engine_plugin_construct (GAMES_TYPE_PC_ENGINE_PLUGIN);
}


static void games_pc_engine_plugin_class_init (GamesPcEnginePluginClass * klass) {
	games_pc_engine_plugin_parent_class = g_type_class_peek_parent (klass);
}


static void games_pc_engine_plugin_games_plugin_interface_init (GamesPluginIface * iface) {
	games_pc_engine_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_game_source = (GamesGameSource* (*) (GamesPlugin *, GError**)) games_pc_engine_plugin_real_get_game_source;
}


static void games_pc_engine_plugin_instance_init (GamesPcEnginePlugin * self) {
}


GType games_pc_engine_plugin_get_type (void) {
	return games_pc_engine_plugin_type_id;
}


GType games_pc_engine_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesPcEnginePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_pc_engine_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesPcEnginePlugin), 0, (GInstanceInitFunc) games_pc_engine_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_pc_engine_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_pc_engine_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesPcEnginePlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_pc_engine_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_pc_engine_plugin_type_id;
}


GType register_games_plugin (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	games_pc_engine_plugin_register_type (module);
	result = GAMES_TYPE_PC_ENGINE_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



