/*
 * Copyright © 1998, 2003 Jonathan Blandford <jrb@mit.edu>
 * Copyright © 2007, 2008, 2009 Christian Persch
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include "ar-cursor.h"

#include <gtk/gtk.h>

#ifndef HAVE_HILDON

/* These cursors borrowed from EOG */
/* FIXMEchpe use themeable cursors here! */

#if GTK_CHECK_VERSION (2, 90, 6)

#define hand_closed_data_width 20
#define hand_closed_data_height 20
static const char hand_closed_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00,
  0x80, 0xff, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0xb0, 0xff, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00,
  0xe0, 0xff, 0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00,
  0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define hand_closed_mask_width 20
#define hand_closed_mask_height 20
static const char hand_closed_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x00,
  0xc0, 0xff, 0x01, 0x00, 0xf0, 0xff, 0x01, 0x00, 0xf8, 0xff, 0x01, 0x00, 0xf8, 0xff, 0x01, 0x00,
  0xf0, 0xff, 0x01, 0x00, 0xf0, 0xff, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00,
  0x80, 0x7f, 0x00, 0x00, 0x80, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define hand_open_data_width 20
#define hand_open_data_height 20
static const char hand_open_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
  0x60, 0x36, 0x00, 0x00, 0x60, 0x36, 0x00, 0x00, 0xc0, 0x36, 0x01, 0x00, 0xc0, 0xb6, 0x01, 0x00,
  0x80, 0xbf, 0x01, 0x00, 0x98, 0xff, 0x01, 0x00, 0xb8, 0xff, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00,
  0xe0, 0xff, 0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00,
  0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define hand_open_mask_width 20
#define hand_open_mask_height 20
static const char hand_open_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x60, 0x3f, 0x00, 0x00,
  0xf0, 0x7f, 0x00, 0x00, 0xf0, 0x7f, 0x01, 0x00, 0xe0, 0xff, 0x03, 0x00, 0xe0, 0xff, 0x03, 0x00,
  0xd8, 0xff, 0x03, 0x00, 0xfc, 0xff, 0x03, 0x00, 0xfc, 0xff, 0x01, 0x00, 0xf8, 0xff, 0x01, 0x00,
  0xf0, 0xff, 0x01, 0x00, 0xf0, 0xff, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00,
  0x80, 0x7f, 0x00, 0x00, 0x80, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#else

#define hand_closed_data_width 20
#define hand_closed_data_height 20
static const char hand_closed_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x80, 0x3f, 0x00,
  0x80, 0xff, 0x00, 0x80, 0xff, 0x00, 0xb0, 0xff, 0x00, 0xf0, 0xff, 0x00,
  0xe0, 0xff, 0x00, 0xe0, 0x7f, 0x00, 0xc0, 0x7f, 0x00, 0x80, 0x3f, 0x00,
  0x00, 0x3f, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define hand_closed_mask_width 20
#define hand_closed_mask_height 20
static const char hand_closed_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x80, 0x3f, 0x00, 0xc0, 0xff, 0x00,
  0xc0, 0xff, 0x01, 0xf0, 0xff, 0x01, 0xf8, 0xff, 0x01, 0xf8, 0xff, 0x01,
  0xf0, 0xff, 0x01, 0xf0, 0xff, 0x00, 0xe0, 0xff, 0x00, 0xc0, 0x7f, 0x00,
  0x80, 0x7f, 0x00, 0x80, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define hand_open_data_width 20
#define hand_open_data_height 20
static const char hand_open_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
  0x60, 0x36, 0x00, 0x60, 0x36, 0x00, 0xc0, 0x36, 0x01, 0xc0, 0xb6, 0x01,
  0x80, 0xbf, 0x01, 0x98, 0xff, 0x01, 0xb8, 0xff, 0x00, 0xf0, 0xff, 0x00,
  0xe0, 0xff, 0x00, 0xe0, 0x7f, 0x00, 0xc0, 0x7f, 0x00, 0x80, 0x3f, 0x00,
  0x00, 0x3f, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define hand_open_mask_width 20
#define hand_open_mask_height 20
static const char hand_open_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x60, 0x3f, 0x00,
  0xf0, 0x7f, 0x00, 0xf0, 0x7f, 0x01, 0xe0, 0xff, 0x03, 0xe0, 0xff, 0x03,
  0xd8, 0xff, 0x03, 0xfc, 0xff, 0x03, 0xfc, 0xff, 0x01, 0xf8, 0xff, 0x01,
  0xf0, 0xff, 0x01, 0xf0, 0xff, 0x00, 0xe0, 0xff, 0x00, 0xc0, 0x7f, 0x00,
  0x80, 0x7f, 0x00, 0x80, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#endif /* GTK 2.90.6 */

static GdkCursor *
ar_cursor_new_from_data (GdkWindow *window,
                         const char *data,
                         const char *mask_data)
{
  const GdkColor fg = { 0, 65535, 65535, 65535 };
  const GdkColor bg = { 0, 0, 0, 0 };
  GdkCursor *cursor;
  GdkPixmap *source;
  GdkPixmap *mask;
#if GTK_CHECK_VERSION (2, 90, 6)
  cairo_surface_t *image;
  cairo_t *cr;

  /* Yeah, hard-coded sizes are bad. */
  source = gdk_pixmap_new (window, 20, 20, 1);

  cr = gdk_cairo_create (source );
  cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
  image = cairo_image_surface_create_for_data ((guchar *) data,
                                                CAIRO_FORMAT_A1,
                                                20, 20, 4);
  cairo_set_source_surface (cr, image, 0, 0);
  cairo_surface_destroy (image);
  cairo_paint (cr);
  cairo_destroy (cr);

  /* Yeah, hard-coded sizes are bad. */
  mask = gdk_pixmap_new (window, 20, 20, 1);

  cr = gdk_cairo_create (mask);
  cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
  image = cairo_image_surface_create_for_data ((guchar *) mask_data,
                                                CAIRO_FORMAT_A1,
                                                20, 20, 4);
  cairo_set_source_surface (cr, image, 0, 0);
  cairo_surface_destroy (image);
  cairo_paint (cr);
  cairo_destroy (cr);

#else

  /* Yeah, hard-coded sizes are bad. */
  source = gdk_bitmap_create_from_data (window, data, 20, 20);
  mask = gdk_bitmap_create_from_data (window, mask_data, 20, 20);

#endif /* GTK 2.90.6 */

  cursor = gdk_cursor_new_from_pixmap (source, mask, &fg, &bg, 10, 10);

  g_object_unref (source);
  g_object_unref (mask);

  return cursor;
}

#endif /* !HAVE_HILDON */

GdkCursor *ar_cursor_new (GdkWindow *window,
                          ArCursorType cursor_type)
{
#ifndef HAVE_HILDON
  switch (cursor_type) {
    case AR_CURSOR_OPEN:
      return ar_cursor_new_from_data (window, hand_open_data_bits, hand_open_mask_bits);

    case AR_CURSOR_CLOSED:
      return ar_cursor_new_from_data (window, hand_closed_data_bits, hand_closed_mask_bits);

    default:
      g_assert_not_reached ();
  }
#else
  return NULL;
#endif /* !HAVE_HILDON */
}
