# Note that this is NOT a relocatable package
%define ver      	1.1.0
%define RELEASE 	1
%define rel     	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix   	/usr

Summary: GNOME games.
Name: 		gnome-games
Version: 	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		Amusements/Games
Source:		ftp://ftp.gnome.org/pub/GNOME/sources/gnome-games-%{PACKAGE_VERSION}.tar.gz
BuildRoot: 	/var/tmp/gnome-games-%{PACKAGE_VERSION}-root
URL: 		http://www.gnome.org
Docdir: 	%{prefix}/doc
Requires:	gnome-libs >= 1.0.0

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on free software.
The gnome-games package containes a collection of simple games for your
amusement.

You should install the gnome-games package if you would like to play the 
included games. You will also need to install the gnome-libs package.
If you would like to develop addtional games that utilize the GNOME
games libraries then you should install the gnome-games-devel package.

%package devel
Summary:	GNOME games development libraries.
Group: 		Development/Libraries
Requires:	gnome-games

%description devel
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on free software.
The gnome-games-devel package contains the libraries and include files
needed for development of GNOME games.

You should install the gnome-games package if you would like to play the
included games. You will also need to install the gnome-libs package.
If you would like to develop addtional games that utilize the GNOME
games libraries then you should install the gnome-games-devel package.

%changelog
* Tue Sep 28 1999 Ian Peters <itp@gnu.org>

- Merged some changes from Dax Kelson <dax@gurulabs.com> to get this thing to
  work right.

* Sun Aug 01 1999 Gregory McLean <gregm@comstar.net>

- Updated with better descriptions and more consistant layout.

* Sat Nov 21 1998 Michael Fulbright <drmike@redhat.com>

- updated for 0.30 tree

* Fri Nov 20 1998 Pablo Saratxaga <srtxg@chanae.alphanet.ch>

- use --localstatedir=/var/lib in config state (score files for games
  for exemple will go there).

* Mon Mar 16 1998 Marc Ewing <marc@redhat.com>

- Integrate into gnome-games CVS source tree

%prep
%setup -q

%build
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

CFLAGS="$RPM_OPT_FLAGS" ./configure --quiet $MYARCH_FLAGS --prefix=%prefix \
	 --localstatedir=/var/lib --sysconfdir=/etc

if [ "$SMP" != "" ]; then
  make -j$SMP MAKE="make -j$SMP"
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} scoredir=$RPM_BUILD_ROOT/var/lib/games sysconfdir=$RPM_BUILD_ROOT/etc install >install.log 2>&1

%clean
rm -rf $RPM_BUILD_ROOT

%post 
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
  echo "%{prefix}/lib" >> /etc/ld.so.conf
fi

/sbin/ldconfig

%postun -p /sbin/ldconfig



%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%attr(-, root, games) %{prefix}/bin/*
%config /etc/sound/events
%{prefix}/share/gnome/apps/Games/*
%{prefix}/share/gnibbles/*
%{prefix}/share/gnobots2/*
%{prefix}/share/gnome/help/*
%{prefix}/share/gnome-stones/*
%{prefix}/share/gturing/*
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*
%{prefix}/share/sol-games/*
%{prefix}/share/sounds/*
%{prefix}/share/xbill/*

%{prefix}/lib/lib*.so.*
%{prefix}/lib/gnome-stones/objects/lib*.so.*
%defattr(-, games, games)
/var/lib/games/*

%files devel
%defattr(-, root, root)

%{prefix}/lib/lib*.so
%{prefix}/lib/*a
%{prefix}/lib/gnome-stones/objects/lib*.so
%{prefix}/lib/gnome-stones/objects/lib*a
%{prefix}/include/*
