/* Aisleriot - menu.c
 * Copyright (C) 1998 Jonathan Blandford <jrb@mit.edu>
 *
 * This game is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <dirent.h>
#include "gnome.h"
#include "sol.h"
#include "menu.h"
#include "dialog.h"
#include "cscmi.h"
#include "draw.h"

void restart_game ()
{
  new_game (NULL, &seed);
};

void random_seed ()
{
  new_game (NULL, NULL);
};

void new_rules (GtkWidget* w, gchar* file) 
{
  new_game (file, NULL);
};

void undo_callback ()
{
  gh_eval_str ("(undo)");
  refresh_screen();
}

void redo_callback ()
{
  gh_eval_str ("(redo)");
  refresh_screen();
}

void help_about_callback ()
{
  GtkWidget *about;
  const gchar *authors[] = {
	  "Main program:  Jonathan Blandford (jrb@mit.edu)",
	  "                      Felix Bellaby (felix@pooh.u-net.com)",
	  "Card Games:    Jonathan Blandford (jrb@mit.edu)",
	  "                      Changwoo Ryu (cwryu@adam.kaist.ac.kr)",
	  "                      Rosanna Yuen (rwsy@mit.edu)",
          NULL
          };

  about = gnome_about_new ( _("GNOME Solitaire"), VERSION,
        		/* copyright notice */
                        "(C) 1998 Jonathan Blandford (jrb@MIT.EDU)",
                        (const char **)authors,
                        /* another comments */
                        _("The GNOME Generic Solitaire provides a rule-based "
			  "solitaire engine that allows many different games to be played"),
                        NULL);
  gtk_widget_show (about);

  return;
}

GnomeUIInfo rules_sub_menu[] = {
  GNOMEUIINFO_END
};

GnomeUIInfo file_menu[] = {
  GNOMEUIINFO_END
};

GnomeUIInfo settings_menu[] = {

  
  GNOMEUIINFO_ITEM_STOCK(N_("Game _options..."),
			 N_("Modify the options for this game"),
			 show_rules_options_dialog, GNOME_STOCK_MENU_PREF),

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_MENU_PREFERENCES_ITEM(show_preferences_dialog, NULL),

  GNOMEUIINFO_END
};

GnomeUIInfo rules_menu[] = {

  GNOMEUIINFO_END
};

GnomeUIInfo help_menu[] = {
  GNOMEUIINFO_HELP("aisleriot"),

  GNOMEUIINFO_MENU_ABOUT_ITEM(help_about_callback, NULL),

  GNOMEUIINFO_END
};

GnomeUIInfo game_menu[] = {

  GNOMEUIINFO_MENU_NEW_GAME_ITEM(random_seed, NULL),

  { GNOME_APP_UI_SUBTREE, N_("New _game of..."),
    N_("Start a new game of a different variation"),
    rules_sub_menu, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_NEW, 0, 0, NULL },
  
  GNOMEUIINFO_MENU_RESTART_GAME_ITEM(restart_game, NULL),

  GNOMEUIINFO_ITEM_STOCK(N_("_Select..."), N_("Select a new game variation"),
			 show_select_game_dialog, GNOME_STOCK_MENU_OPEN),

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_MENU_UNDO_MOVE_ITEM(undo_callback, NULL),

  GNOMEUIINFO_MENU_REDO_MOVE_ITEM(redo_callback, NULL),

  GNOMEUIINFO_MENU_HINT_ITEM(show_hint_dialog, NULL),
  /*  GNOMEUIINFO_ITEM_STOCK(N_("_Properties..."), NULL, 
      show_property_dialog, GNOME_STOCK_MENU_PREF), */

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_MENU_SCORES_ITEM(show_global_stats_dialog, NULL),
  /*  GNOMEUIINFO_ITEM_STOCK(N_("S_tatistics..."), NULL, 
      show_global_stats_dialog, GNOME_STOCK_MENU_BOOK_BLUE), */

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_MENU_EXIT_ITEM(quit_app, NULL),

  GNOMEUIINFO_END
};


GnomeUIInfo top_menu[] = {

  GNOMEUIINFO_MENU_GAME_TREE(game_menu),

  GNOMEUIINFO_MENU_SETTINGS_TREE(settings_menu),

  GNOMEUIINFO_MENU_HELP_TREE(help_menu),

  GNOMEUIINFO_END
};

GnomeUIInfo toolbar[] =
{
  GNOMEUIINFO_ITEM_STOCK(N_("New"), N_("Deal a new game."),
			 random_seed, GNOME_STOCK_PIXMAP_NEW),

  GNOMEUIINFO_ITEM_STOCK(N_("Restart"), N_("Start this game over."),
			 restart_game, GNOME_STOCK_PIXMAP_REFRESH),

  GNOMEUIINFO_ITEM_STOCK(N_("Select"), N_("Select a new game."),
			 show_select_game_dialog, GNOME_STOCK_PIXMAP_OPEN),

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_ITEM_STOCK(N_("Hint"), N_("Suggest a move."),
			 show_hint_dialog, GNOME_STOCK_PIXMAP_JUMP_TO),

  GNOMEUIINFO_ITEM_STOCK(N_("Undo"), N_("Undo the last move."),
			 undo_callback, GNOME_STOCK_PIXMAP_UNDO),

  GNOMEUIINFO_ITEM_STOCK(N_("Redo"), N_("Redo the last move."),
			 redo_callback, GNOME_STOCK_PIXMAP_REDO),

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_ITEM_STOCK(N_("Exit"), N_("Quit Aisleriot."),
			 quit_app, GNOME_STOCK_PIXMAP_EXIT),
  GNOMEUIINFO_END
};

void create_menus ()
{
  int i;
  GtkWidget *w;
  gnome_app_create_menus (GNOME_APP(app), top_menu);
  gnome_app_create_toolbar (GNOME_APP(app), toolbar);

  for(i = 0; i < n_games; i++) {
    w = gtk_menu_item_new_with_label 
      (game_file_to_name (game_dents[i]->d_name));
    gtk_widget_show(w);
    gtk_menu_shell_append (GTK_MENU_SHELL(rules_sub_menu[0].widget), w);
    gtk_signal_connect (GTK_OBJECT(w), "activate", 
			(GtkSignalFunc) new_rules,
			(gpointer) game_dents[i]->d_name);
  }
}

void install_menu_hints (GnomeApp *app)
{
  gnome_app_install_menu_hints(GNOME_APP (app), top_menu);
}

